/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.RayObject;

public class RayConstructor
extends LineConstructor {
    public ConstructionObject create(Construction construction, PointObject pointObject, PointObject pointObject2) {
        return new RayObject(construction, pointObject, pointObject2);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.ray.first", "Ray: Set the root point!"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.ray.second", "Ray: Set the second point!"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Ray")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("from") || !xmlTag.hasParam("to")) {
            throw new ConstructionException("Ray points missing!");
        }
        try {
            PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("from"));
            PointObject pointObject2 = (PointObject)construction.find(xmlTag.getValue("to"));
            RayObject rayObject = new RayObject(construction, pointObject, pointObject2);
            if (xmlTag.hasParam("partial")) {
                rayObject.setPartial(true);
            }
            this.setName(xmlTag, rayObject);
            this.set(xmlTree, rayObject);
            construction.add(rayObject);
            this.setConditionals(xmlTree, construction, rayObject);
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ConstructionException("Ray points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.ray");
    }

    public String getTag() {
        return "Ray";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject constructionObject = construction.find(stringArray[0]);
        if (constructionObject == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
        }
        ConstructionObject constructionObject2 = construction.find(stringArray[1]);
        if (constructionObject2 == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[1]);
        }
        if (!(constructionObject instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
        }
        if (!(constructionObject2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[1]);
        }
        RayObject rayObject = new RayObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2);
        construction.add(rayObject);
        rayObject.setDefaults();
        if (!string.equals("")) {
            rayObject.setNameCheck(string);
        }
    }
}

