package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// Access enumerates the values for access.
type Access string

const (
	// Allow specifies the allow state for access.
	Allow Access = "Allow"
	// Deny specifies the deny state for access.
	Deny Access = "Deny"
)

// ApplicationGatewayBackendHealthServerHealth enumerates the values for
// application gateway backend health server health.
type ApplicationGatewayBackendHealthServerHealth string

const (
	// Down specifies the down state for application gateway backend health
	// server health.
	Down ApplicationGatewayBackendHealthServerHealth = "Down"
	// Draining specifies the draining state for application gateway backend
	// health server health.
	Draining ApplicationGatewayBackendHealthServerHealth = "Draining"
	// Partial specifies the partial state for application gateway backend
	// health server health.
	Partial ApplicationGatewayBackendHealthServerHealth = "Partial"
	// Unknown specifies the unknown state for application gateway backend
	// health server health.
	Unknown ApplicationGatewayBackendHealthServerHealth = "Unknown"
	// Up specifies the up state for application gateway backend health server
	// health.
	Up ApplicationGatewayBackendHealthServerHealth = "Up"
)

// ApplicationGatewayCookieBasedAffinity enumerates the values for application
// gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// Disabled specifies the disabled state for application gateway cookie
	// based affinity.
	Disabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// Enabled specifies the enabled state for application gateway cookie based
	// affinity.
	Enabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// ApplicationGatewayFirewallMode enumerates the values for application gateway
// firewall mode.
type ApplicationGatewayFirewallMode string

const (
	// Detection specifies the detection state for application gateway firewall
	// mode.
	Detection ApplicationGatewayFirewallMode = "Detection"
	// Prevention specifies the prevention state for application gateway
	// firewall mode.
	Prevention ApplicationGatewayFirewallMode = "Prevention"
)

// ApplicationGatewayOperationalState enumerates the values for application
// gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// Running specifies the running state for application gateway operational
	// state.
	Running ApplicationGatewayOperationalState = "Running"
	// Starting specifies the starting state for application gateway
	// operational state.
	Starting ApplicationGatewayOperationalState = "Starting"
	// Stopped specifies the stopped state for application gateway operational
	// state.
	Stopped ApplicationGatewayOperationalState = "Stopped"
	// Stopping specifies the stopping state for application gateway
	// operational state.
	Stopping ApplicationGatewayOperationalState = "Stopping"
)

// ApplicationGatewayProtocol enumerates the values for application gateway
// protocol.
type ApplicationGatewayProtocol string

const (
	// HTTP specifies the http state for application gateway protocol.
	HTTP ApplicationGatewayProtocol = "Http"
	// HTTPS specifies the https state for application gateway protocol.
	HTTPS ApplicationGatewayProtocol = "Https"
)

// ApplicationGatewayRequestRoutingRuleType enumerates the values for
// application gateway request routing rule type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// Basic specifies the basic state for application gateway request routing
	// rule type.
	Basic ApplicationGatewayRequestRoutingRuleType = "Basic"
	// PathBasedRouting specifies the path based routing state for application
	// gateway request routing rule type.
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = "PathBasedRouting"
)

// ApplicationGatewaySkuName enumerates the values for application gateway sku
// name.
type ApplicationGatewaySkuName string

const (
	// StandardLarge specifies the standard large state for application gateway
	// sku name.
	StandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// StandardMedium specifies the standard medium state for application
	// gateway sku name.
	StandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// StandardSmall specifies the standard small state for application gateway
	// sku name.
	StandardSmall ApplicationGatewaySkuName = "Standard_Small"
	// WAFLarge specifies the waf large state for application gateway sku name.
	WAFLarge ApplicationGatewaySkuName = "WAF_Large"
	// WAFMedium specifies the waf medium state for application gateway sku
	// name.
	WAFMedium ApplicationGatewaySkuName = "WAF_Medium"
)

// ApplicationGatewaySslProtocol enumerates the values for application gateway
// ssl protocol.
type ApplicationGatewaySslProtocol string

const (
	// TLSv10 specifies the tl sv 10 state for application gateway ssl
	// protocol.
	TLSv10 ApplicationGatewaySslProtocol = "TLSv1_0"
	// TLSv11 specifies the tl sv 11 state for application gateway ssl
	// protocol.
	TLSv11 ApplicationGatewaySslProtocol = "TLSv1_1"
	// TLSv12 specifies the tl sv 12 state for application gateway ssl
	// protocol.
	TLSv12 ApplicationGatewaySslProtocol = "TLSv1_2"
)

// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// Standard specifies the standard state for application gateway tier.
	Standard ApplicationGatewayTier = "Standard"
	// WAF specifies the waf state for application gateway tier.
	WAF ApplicationGatewayTier = "WAF"
)

// AssociationType enumerates the values for association type.
type AssociationType string

const (
	// Associated specifies the associated state for association type.
	Associated AssociationType = "Associated"
	// Contains specifies the contains state for association type.
	Contains AssociationType = "Contains"
)

// AuthorizationUseStatus enumerates the values for authorization use status.
type AuthorizationUseStatus string

const (
	// Available specifies the available state for authorization use status.
	Available AuthorizationUseStatus = "Available"
	// InUse specifies the in use state for authorization use status.
	InUse AuthorizationUseStatus = "InUse"
)

// BgpPeerState enumerates the values for bgp peer state.
type BgpPeerState string

const (
	// BgpPeerStateConnected specifies the bgp peer state connected state for
	// bgp peer state.
	BgpPeerStateConnected BgpPeerState = "Connected"
	// BgpPeerStateConnecting specifies the bgp peer state connecting state for
	// bgp peer state.
	BgpPeerStateConnecting BgpPeerState = "Connecting"
	// BgpPeerStateIdle specifies the bgp peer state idle state for bgp peer
	// state.
	BgpPeerStateIdle BgpPeerState = "Idle"
	// BgpPeerStateStopped specifies the bgp peer state stopped state for bgp
	// peer state.
	BgpPeerStateStopped BgpPeerState = "Stopped"
	// BgpPeerStateUnknown specifies the bgp peer state unknown state for bgp
	// peer state.
	BgpPeerStateUnknown BgpPeerState = "Unknown"
)

// DhGroup enumerates the values for dh group.
type DhGroup string

const (
	// DHGroup1 specifies the dh group 1 state for dh group.
	DHGroup1 DhGroup = "DHGroup1"
	// DHGroup14 specifies the dh group 14 state for dh group.
	DHGroup14 DhGroup = "DHGroup14"
	// DHGroup2 specifies the dh group 2 state for dh group.
	DHGroup2 DhGroup = "DHGroup2"
	// DHGroup2048 specifies the dh group 2048 state for dh group.
	DHGroup2048 DhGroup = "DHGroup2048"
	// DHGroup24 specifies the dh group 24 state for dh group.
	DHGroup24 DhGroup = "DHGroup24"
	// ECP256 specifies the ecp256 state for dh group.
	ECP256 DhGroup = "ECP256"
	// ECP384 specifies the ecp384 state for dh group.
	ECP384 DhGroup = "ECP384"
	// None specifies the none state for dh group.
	None DhGroup = "None"
)

// Direction enumerates the values for direction.
type Direction string

const (
	// Inbound specifies the inbound state for direction.
	Inbound Direction = "Inbound"
	// Outbound specifies the outbound state for direction.
	Outbound Direction = "Outbound"
)

// EffectiveRouteSource enumerates the values for effective route source.
type EffectiveRouteSource string

const (
	// EffectiveRouteSourceDefault specifies the effective route source default
	// state for effective route source.
	EffectiveRouteSourceDefault EffectiveRouteSource = "Default"
	// EffectiveRouteSourceUnknown specifies the effective route source unknown
	// state for effective route source.
	EffectiveRouteSourceUnknown EffectiveRouteSource = "Unknown"
	// EffectiveRouteSourceUser specifies the effective route source user state
	// for effective route source.
	EffectiveRouteSourceUser EffectiveRouteSource = "User"
	// EffectiveRouteSourceVirtualNetworkGateway specifies the effective route
	// source virtual network gateway state for effective route source.
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = "VirtualNetworkGateway"
)

// EffectiveRouteState enumerates the values for effective route state.
type EffectiveRouteState string

const (
	// Active specifies the active state for effective route state.
	Active EffectiveRouteState = "Active"
	// Invalid specifies the invalid state for effective route state.
	Invalid EffectiveRouteState = "Invalid"
)

// ExpressRouteCircuitPeeringAdvertisedPublicPrefixState enumerates the values
// for express route circuit peering advertised public prefix state.
type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState string

const (
	// Configured specifies the configured state for express route circuit
	// peering advertised public prefix state.
	Configured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configured"
	// Configuring specifies the configuring state for express route circuit
	// peering advertised public prefix state.
	Configuring ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configuring"
	// NotConfigured specifies the not configured state for express route
	// circuit peering advertised public prefix state.
	NotConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "NotConfigured"
	// ValidationNeeded specifies the validation needed state for express route
	// circuit peering advertised public prefix state.
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "ValidationNeeded"
)

// ExpressRouteCircuitPeeringState enumerates the values for express route
// circuit peering state.
type ExpressRouteCircuitPeeringState string

const (
	// ExpressRouteCircuitPeeringStateDisabled specifies the express route
	// circuit peering state disabled state for express route circuit peering
	// state.
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = "Disabled"
	// ExpressRouteCircuitPeeringStateEnabled specifies the express route
	// circuit peering state enabled state for express route circuit peering
	// state.
	ExpressRouteCircuitPeeringStateEnabled ExpressRouteCircuitPeeringState = "Enabled"
)

// ExpressRouteCircuitPeeringType enumerates the values for express route
// circuit peering type.
type ExpressRouteCircuitPeeringType string

const (
	// AzurePrivatePeering specifies the azure private peering state for
	// express route circuit peering type.
	AzurePrivatePeering ExpressRouteCircuitPeeringType = "AzurePrivatePeering"
	// AzurePublicPeering specifies the azure public peering state for express
	// route circuit peering type.
	AzurePublicPeering ExpressRouteCircuitPeeringType = "AzurePublicPeering"
	// MicrosoftPeering specifies the microsoft peering state for express route
	// circuit peering type.
	MicrosoftPeering ExpressRouteCircuitPeeringType = "MicrosoftPeering"
)

// ExpressRouteCircuitSkuFamily enumerates the values for express route circuit
// sku family.
type ExpressRouteCircuitSkuFamily string

const (
	// MeteredData specifies the metered data state for express route circuit
	// sku family.
	MeteredData ExpressRouteCircuitSkuFamily = "MeteredData"
	// UnlimitedData specifies the unlimited data state for express route
	// circuit sku family.
	UnlimitedData ExpressRouteCircuitSkuFamily = "UnlimitedData"
)

// ExpressRouteCircuitSkuTier enumerates the values for express route circuit
// sku tier.
type ExpressRouteCircuitSkuTier string

const (
	// ExpressRouteCircuitSkuTierPremium specifies the express route circuit
	// sku tier premium state for express route circuit sku tier.
	ExpressRouteCircuitSkuTierPremium ExpressRouteCircuitSkuTier = "Premium"
	// ExpressRouteCircuitSkuTierStandard specifies the express route circuit
	// sku tier standard state for express route circuit sku tier.
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = "Standard"
)

// IkeEncryption enumerates the values for ike encryption.
type IkeEncryption string

const (
	// AES128 specifies the aes128 state for ike encryption.
	AES128 IkeEncryption = "AES128"
	// AES192 specifies the aes192 state for ike encryption.
	AES192 IkeEncryption = "AES192"
	// AES256 specifies the aes256 state for ike encryption.
	AES256 IkeEncryption = "AES256"
	// DES specifies the des state for ike encryption.
	DES IkeEncryption = "DES"
	// DES3 specifies the des3 state for ike encryption.
	DES3 IkeEncryption = "DES3"
)

// IkeIntegrity enumerates the values for ike integrity.
type IkeIntegrity string

const (
	// MD5 specifies the md5 state for ike integrity.
	MD5 IkeIntegrity = "MD5"
	// SHA1 specifies the sha1 state for ike integrity.
	SHA1 IkeIntegrity = "SHA1"
	// SHA256 specifies the sha256 state for ike integrity.
	SHA256 IkeIntegrity = "SHA256"
	// SHA384 specifies the sha384 state for ike integrity.
	SHA384 IkeIntegrity = "SHA384"
)

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic specifies the dynamic state for ip allocation method.
	Dynamic IPAllocationMethod = "Dynamic"
	// Static specifies the static state for ip allocation method.
	Static IPAllocationMethod = "Static"
)

// IpsecEncryption enumerates the values for ipsec encryption.
type IpsecEncryption string

const (
	// IpsecEncryptionAES128 specifies the ipsec encryption aes128 state for
	// ipsec encryption.
	IpsecEncryptionAES128 IpsecEncryption = "AES128"
	// IpsecEncryptionAES192 specifies the ipsec encryption aes192 state for
	// ipsec encryption.
	IpsecEncryptionAES192 IpsecEncryption = "AES192"
	// IpsecEncryptionAES256 specifies the ipsec encryption aes256 state for
	// ipsec encryption.
	IpsecEncryptionAES256 IpsecEncryption = "AES256"
	// IpsecEncryptionDES specifies the ipsec encryption des state for ipsec
	// encryption.
	IpsecEncryptionDES IpsecEncryption = "DES"
	// IpsecEncryptionDES3 specifies the ipsec encryption des3 state for ipsec
	// encryption.
	IpsecEncryptionDES3 IpsecEncryption = "DES3"
	// IpsecEncryptionGCMAES128 specifies the ipsec encryption gcmaes128 state
	// for ipsec encryption.
	IpsecEncryptionGCMAES128 IpsecEncryption = "GCMAES128"
	// IpsecEncryptionGCMAES192 specifies the ipsec encryption gcmaes192 state
	// for ipsec encryption.
	IpsecEncryptionGCMAES192 IpsecEncryption = "GCMAES192"
	// IpsecEncryptionGCMAES256 specifies the ipsec encryption gcmaes256 state
	// for ipsec encryption.
	IpsecEncryptionGCMAES256 IpsecEncryption = "GCMAES256"
	// IpsecEncryptionNone specifies the ipsec encryption none state for ipsec
	// encryption.
	IpsecEncryptionNone IpsecEncryption = "None"
)

// IpsecIntegrity enumerates the values for ipsec integrity.
type IpsecIntegrity string

const (
	// IpsecIntegrityGCMAES128 specifies the ipsec integrity gcmaes128 state
	// for ipsec integrity.
	IpsecIntegrityGCMAES128 IpsecIntegrity = "GCMAES128"
	// IpsecIntegrityGCMAES192 specifies the ipsec integrity gcmaes192 state
	// for ipsec integrity.
	IpsecIntegrityGCMAES192 IpsecIntegrity = "GCMAES192"
	// IpsecIntegrityGCMAES256 specifies the ipsec integrity gcmaes256 state
	// for ipsec integrity.
	IpsecIntegrityGCMAES256 IpsecIntegrity = "GCMAES256"
	// IpsecIntegrityMD5 specifies the ipsec integrity md5 state for ipsec
	// integrity.
	IpsecIntegrityMD5 IpsecIntegrity = "MD5"
	// IpsecIntegritySHA1 specifies the ipsec integrity sha1 state for ipsec
	// integrity.
	IpsecIntegritySHA1 IpsecIntegrity = "SHA1"
	// IpsecIntegritySHA256 specifies the ipsec integrity sha256 state for
	// ipsec integrity.
	IpsecIntegritySHA256 IpsecIntegrity = "SHA256"
)

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 specifies the i pv 4 state for ip version.
	IPv4 IPVersion = "IPv4"
	// IPv6 specifies the i pv 6 state for ip version.
	IPv6 IPVersion = "IPv6"
)

// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// Default specifies the default state for load distribution.
	Default LoadDistribution = "Default"
	// SourceIP specifies the source ip state for load distribution.
	SourceIP LoadDistribution = "SourceIP"
	// SourceIPProtocol specifies the source ip protocol state for load
	// distribution.
	SourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// NextHopType enumerates the values for next hop type.
type NextHopType string

const (
	// NextHopTypeHyperNetGateway specifies the next hop type hyper net gateway
	// state for next hop type.
	NextHopTypeHyperNetGateway NextHopType = "HyperNetGateway"
	// NextHopTypeInternet specifies the next hop type internet state for next
	// hop type.
	NextHopTypeInternet NextHopType = "Internet"
	// NextHopTypeNone specifies the next hop type none state for next hop
	// type.
	NextHopTypeNone NextHopType = "None"
	// NextHopTypeVirtualAppliance specifies the next hop type virtual
	// appliance state for next hop type.
	NextHopTypeVirtualAppliance NextHopType = "VirtualAppliance"
	// NextHopTypeVirtualNetworkGateway specifies the next hop type virtual
	// network gateway state for next hop type.
	NextHopTypeVirtualNetworkGateway NextHopType = "VirtualNetworkGateway"
	// NextHopTypeVnetLocal specifies the next hop type vnet local state for
	// next hop type.
	NextHopTypeVnetLocal NextHopType = "VnetLocal"
)

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed specifies the failed state for operation status.
	Failed OperationStatus = "Failed"
	// InProgress specifies the in progress state for operation status.
	InProgress OperationStatus = "InProgress"
	// Succeeded specifies the succeeded state for operation status.
	Succeeded OperationStatus = "Succeeded"
)

// PcError enumerates the values for pc error.
type PcError string

const (
	// AgentStopped specifies the agent stopped state for pc error.
	AgentStopped PcError = "AgentStopped"
	// CaptureFailed specifies the capture failed state for pc error.
	CaptureFailed PcError = "CaptureFailed"
	// InternalError specifies the internal error state for pc error.
	InternalError PcError = "InternalError"
	// LocalFileFailed specifies the local file failed state for pc error.
	LocalFileFailed PcError = "LocalFileFailed"
	// StorageFailed specifies the storage failed state for pc error.
	StorageFailed PcError = "StorageFailed"
)

// PcProtocol enumerates the values for pc protocol.
type PcProtocol string

const (
	// Any specifies the any state for pc protocol.
	Any PcProtocol = "Any"
	// TCP specifies the tcp state for pc protocol.
	TCP PcProtocol = "TCP"
	// UDP specifies the udp state for pc protocol.
	UDP PcProtocol = "UDP"
)

// PcStatus enumerates the values for pc status.
type PcStatus string

const (
	// PcStatusError specifies the pc status error state for pc status.
	PcStatusError PcStatus = "Error"
	// PcStatusNotStarted specifies the pc status not started state for pc
	// status.
	PcStatusNotStarted PcStatus = "NotStarted"
	// PcStatusRunning specifies the pc status running state for pc status.
	PcStatusRunning PcStatus = "Running"
	// PcStatusStopped specifies the pc status stopped state for pc status.
	PcStatusStopped PcStatus = "Stopped"
	// PcStatusUnknown specifies the pc status unknown state for pc status.
	PcStatusUnknown PcStatus = "Unknown"
)

// PfsGroup enumerates the values for pfs group.
type PfsGroup string

const (
	// PfsGroupECP256 specifies the pfs group ecp256 state for pfs group.
	PfsGroupECP256 PfsGroup = "ECP256"
	// PfsGroupECP384 specifies the pfs group ecp384 state for pfs group.
	PfsGroupECP384 PfsGroup = "ECP384"
	// PfsGroupNone specifies the pfs group none state for pfs group.
	PfsGroupNone PfsGroup = "None"
	// PfsGroupPFS1 specifies the pfs group pfs1 state for pfs group.
	PfsGroupPFS1 PfsGroup = "PFS1"
	// PfsGroupPFS2 specifies the pfs group pfs2 state for pfs group.
	PfsGroupPFS2 PfsGroup = "PFS2"
	// PfsGroupPFS2048 specifies the pfs group pfs2048 state for pfs group.
	PfsGroupPFS2048 PfsGroup = "PFS2048"
	// PfsGroupPFS24 specifies the pfs group pfs24 state for pfs group.
	PfsGroupPFS24 PfsGroup = "PFS24"
)

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP specifies the probe protocol http state for probe
	// protocol.
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolTCP specifies the probe protocol tcp state for probe
	// protocol.
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// ProcessorArchitecture enumerates the values for processor architecture.
type ProcessorArchitecture string

const (
	// Amd64 specifies the amd 64 state for processor architecture.
	Amd64 ProcessorArchitecture = "Amd64"
	// X86 specifies the x86 state for processor architecture.
	X86 ProcessorArchitecture = "X86"
)

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolTCP specifies the protocol tcp state for protocol.
	ProtocolTCP Protocol = "TCP"
	// ProtocolUDP specifies the protocol udp state for protocol.
	ProtocolUDP Protocol = "UDP"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleting specifies the provisioning state deleting
	// state for provisioning state.
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed specifies the provisioning state failed state
	// for provisioning state.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded specifies the provisioning state succeeded
	// state for provisioning state.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating specifies the provisioning state updating
	// state for provisioning state.
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// RouteNextHopType enumerates the values for route next hop type.
type RouteNextHopType string

const (
	// RouteNextHopTypeInternet specifies the route next hop type internet
	// state for route next hop type.
	RouteNextHopTypeInternet RouteNextHopType = "Internet"
	// RouteNextHopTypeNone specifies the route next hop type none state for
	// route next hop type.
	RouteNextHopTypeNone RouteNextHopType = "None"
	// RouteNextHopTypeVirtualAppliance specifies the route next hop type
	// virtual appliance state for route next hop type.
	RouteNextHopTypeVirtualAppliance RouteNextHopType = "VirtualAppliance"
	// RouteNextHopTypeVirtualNetworkGateway specifies the route next hop type
	// virtual network gateway state for route next hop type.
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	// RouteNextHopTypeVnetLocal specifies the route next hop type vnet local
	// state for route next hop type.
	RouteNextHopTypeVnetLocal RouteNextHopType = "VnetLocal"
)

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// SecurityRuleAccessAllow specifies the security rule access allow state
	// for security rule access.
	SecurityRuleAccessAllow SecurityRuleAccess = "Allow"
	// SecurityRuleAccessDeny specifies the security rule access deny state for
	// security rule access.
	SecurityRuleAccessDeny SecurityRuleAccess = "Deny"
)

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// SecurityRuleDirectionInbound specifies the security rule direction
	// inbound state for security rule direction.
	SecurityRuleDirectionInbound SecurityRuleDirection = "Inbound"
	// SecurityRuleDirectionOutbound specifies the security rule direction
	// outbound state for security rule direction.
	SecurityRuleDirectionOutbound SecurityRuleDirection = "Outbound"
)

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// SecurityRuleProtocolAsterisk specifies the security rule protocol
	// asterisk state for security rule protocol.
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = "*"
	// SecurityRuleProtocolTCP specifies the security rule protocol tcp state
	// for security rule protocol.
	SecurityRuleProtocolTCP SecurityRuleProtocol = "Tcp"
	// SecurityRuleProtocolUDP specifies the security rule protocol udp state
	// for security rule protocol.
	SecurityRuleProtocolUDP SecurityRuleProtocol = "Udp"
)

// ServiceProviderProvisioningState enumerates the values for service provider
// provisioning state.
type ServiceProviderProvisioningState string

const (
	// Deprovisioning specifies the deprovisioning state for service provider
	// provisioning state.
	Deprovisioning ServiceProviderProvisioningState = "Deprovisioning"
	// NotProvisioned specifies the not provisioned state for service provider
	// provisioning state.
	NotProvisioned ServiceProviderProvisioningState = "NotProvisioned"
	// Provisioned specifies the provisioned state for service provider
	// provisioning state.
	Provisioned ServiceProviderProvisioningState = "Provisioned"
	// Provisioning specifies the provisioning state for service provider
	// provisioning state.
	Provisioning ServiceProviderProvisioningState = "Provisioning"
)

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP specifies the transport protocol tcp state for
	// transport protocol.
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP specifies the transport protocol udp state for
	// transport protocol.
	TransportProtocolUDP TransportProtocol = "Udp"
)

// VirtualNetworkGatewayConnectionStatus enumerates the values for virtual
// network gateway connection status.
type VirtualNetworkGatewayConnectionStatus string

const (
	// VirtualNetworkGatewayConnectionStatusConnected specifies the virtual
	// network gateway connection status connected state for virtual network
	// gateway connection status.
	VirtualNetworkGatewayConnectionStatusConnected VirtualNetworkGatewayConnectionStatus = "Connected"
	// VirtualNetworkGatewayConnectionStatusConnecting specifies the virtual
	// network gateway connection status connecting state for virtual network
	// gateway connection status.
	VirtualNetworkGatewayConnectionStatusConnecting VirtualNetworkGatewayConnectionStatus = "Connecting"
	// VirtualNetworkGatewayConnectionStatusNotConnected specifies the virtual
	// network gateway connection status not connected state for virtual
	// network gateway connection status.
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	// VirtualNetworkGatewayConnectionStatusUnknown specifies the virtual
	// network gateway connection status unknown state for virtual network
	// gateway connection status.
	VirtualNetworkGatewayConnectionStatusUnknown VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// VirtualNetworkGatewayConnectionType enumerates the values for virtual
// network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// ExpressRoute specifies the express route state for virtual network
	// gateway connection type.
	ExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// IPsec specifies the i psec state for virtual network gateway connection
	// type.
	IPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// Vnet2Vnet specifies the vnet 2 vnet state for virtual network gateway
	// connection type.
	Vnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VPNClient specifies the vpn client state for virtual network gateway
	// connection type.
	VPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// VirtualNetworkGatewaySkuName enumerates the values for virtual network
// gateway sku name.
type VirtualNetworkGatewaySkuName string

const (
	// VirtualNetworkGatewaySkuNameBasic specifies the virtual network gateway
	// sku name basic state for virtual network gateway sku name.
	VirtualNetworkGatewaySkuNameBasic VirtualNetworkGatewaySkuName = "Basic"
	// VirtualNetworkGatewaySkuNameHighPerformance specifies the virtual
	// network gateway sku name high performance state for virtual network
	// gateway sku name.
	VirtualNetworkGatewaySkuNameHighPerformance VirtualNetworkGatewaySkuName = "HighPerformance"
	// VirtualNetworkGatewaySkuNameStandard specifies the virtual network
	// gateway sku name standard state for virtual network gateway sku name.
	VirtualNetworkGatewaySkuNameStandard VirtualNetworkGatewaySkuName = "Standard"
	// VirtualNetworkGatewaySkuNameUltraPerformance specifies the virtual
	// network gateway sku name ultra performance state for virtual network
	// gateway sku name.
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = "UltraPerformance"
	// VirtualNetworkGatewaySkuNameVpnGw1 specifies the virtual network gateway
	// sku name vpn gw 1 state for virtual network gateway sku name.
	VirtualNetworkGatewaySkuNameVpnGw1 VirtualNetworkGatewaySkuName = "VpnGw1"
	// VirtualNetworkGatewaySkuNameVpnGw2 specifies the virtual network gateway
	// sku name vpn gw 2 state for virtual network gateway sku name.
	VirtualNetworkGatewaySkuNameVpnGw2 VirtualNetworkGatewaySkuName = "VpnGw2"
	// VirtualNetworkGatewaySkuNameVpnGw3 specifies the virtual network gateway
	// sku name vpn gw 3 state for virtual network gateway sku name.
	VirtualNetworkGatewaySkuNameVpnGw3 VirtualNetworkGatewaySkuName = "VpnGw3"
)

// VirtualNetworkGatewaySkuTier enumerates the values for virtual network
// gateway sku tier.
type VirtualNetworkGatewaySkuTier string

const (
	// VirtualNetworkGatewaySkuTierBasic specifies the virtual network gateway
	// sku tier basic state for virtual network gateway sku tier.
	VirtualNetworkGatewaySkuTierBasic VirtualNetworkGatewaySkuTier = "Basic"
	// VirtualNetworkGatewaySkuTierHighPerformance specifies the virtual
	// network gateway sku tier high performance state for virtual network
	// gateway sku tier.
	VirtualNetworkGatewaySkuTierHighPerformance VirtualNetworkGatewaySkuTier = "HighPerformance"
	// VirtualNetworkGatewaySkuTierStandard specifies the virtual network
	// gateway sku tier standard state for virtual network gateway sku tier.
	VirtualNetworkGatewaySkuTierStandard VirtualNetworkGatewaySkuTier = "Standard"
	// VirtualNetworkGatewaySkuTierUltraPerformance specifies the virtual
	// network gateway sku tier ultra performance state for virtual network
	// gateway sku tier.
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = "UltraPerformance"
	// VirtualNetworkGatewaySkuTierVpnGw1 specifies the virtual network gateway
	// sku tier vpn gw 1 state for virtual network gateway sku tier.
	VirtualNetworkGatewaySkuTierVpnGw1 VirtualNetworkGatewaySkuTier = "VpnGw1"
	// VirtualNetworkGatewaySkuTierVpnGw2 specifies the virtual network gateway
	// sku tier vpn gw 2 state for virtual network gateway sku tier.
	VirtualNetworkGatewaySkuTierVpnGw2 VirtualNetworkGatewaySkuTier = "VpnGw2"
	// VirtualNetworkGatewaySkuTierVpnGw3 specifies the virtual network gateway
	// sku tier vpn gw 3 state for virtual network gateway sku tier.
	VirtualNetworkGatewaySkuTierVpnGw3 VirtualNetworkGatewaySkuTier = "VpnGw3"
)

// VirtualNetworkGatewayType enumerates the values for virtual network gateway
// type.
type VirtualNetworkGatewayType string

const (
	// VirtualNetworkGatewayTypeExpressRoute specifies the virtual network
	// gateway type express route state for virtual network gateway type.
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	// VirtualNetworkGatewayTypeVpn specifies the virtual network gateway type
	// vpn state for virtual network gateway type.
	VirtualNetworkGatewayTypeVpn VirtualNetworkGatewayType = "Vpn"
)

// VirtualNetworkPeeringState enumerates the values for virtual network peering
// state.
type VirtualNetworkPeeringState string

const (
	// Connected specifies the connected state for virtual network peering
	// state.
	Connected VirtualNetworkPeeringState = "Connected"
	// Disconnected specifies the disconnected state for virtual network
	// peering state.
	Disconnected VirtualNetworkPeeringState = "Disconnected"
	// Initiated specifies the initiated state for virtual network peering
	// state.
	Initiated VirtualNetworkPeeringState = "Initiated"
)

// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// PolicyBased specifies the policy based state for vpn type.
	PolicyBased VpnType = "PolicyBased"
	// RouteBased specifies the route based state for vpn type.
	RouteBased VpnType = "RouteBased"
)

// AddressSpace is addressSpace contains an array of IP address ranges that can
// be used by subnets of the virtual network.
type AddressSpace struct {
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// ApplicationGateway is application gateway resource
type ApplicationGateway struct {
	autorest.Response                   `json:"-"`
	ID                                  *string             `json:"id,omitempty"`
	Name                                *string             `json:"name,omitempty"`
	Type                                *string             `json:"type,omitempty"`
	Location                            *string             `json:"location,omitempty"`
	Tags                                *map[string]*string `json:"tags,omitempty"`
	*ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag                                *string `json:"etag,omitempty"`
}

// ApplicationGatewayAuthenticationCertificate is authentication certificates
// of an application gateway.
type ApplicationGatewayAuthenticationCertificate struct {
	ID                                                           *string `json:"id,omitempty"`
	*ApplicationGatewayAuthenticationCertificatePropertiesFormat `json:"properties,omitempty"`
	Name                                                         *string `json:"name,omitempty"`
	Etag                                                         *string `json:"etag,omitempty"`
}

// ApplicationGatewayAuthenticationCertificatePropertiesFormat is
// authentication certificates properties of an application gateway.
type ApplicationGatewayAuthenticationCertificatePropertiesFormat struct {
	Data              *string `json:"data,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayAvailableWafRuleSetsResult is response for
// ApplicationGatewayAvailableWafRuleSets API service call.
type ApplicationGatewayAvailableWafRuleSetsResult struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationGatewayFirewallRuleSet `json:"value,omitempty"`
}

// ApplicationGatewayBackendAddress is backend address of an application
// gateway.
type ApplicationGatewayBackendAddress struct {
	Fqdn      *string `json:"fqdn,omitempty"`
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool is backend Address Pool of an
// application gateway.
type ApplicationGatewayBackendAddressPool struct {
	ID                                                    *string `json:"id,omitempty"`
	*ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	Name                                                  *string `json:"name,omitempty"`
	Etag                                                  *string `json:"etag,omitempty"`
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat is properties of
// Backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	BackendIPConfigurations *[]InterfaceIPConfiguration         `json:"backendIPConfigurations,omitempty"`
	BackendAddresses        *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	ProvisioningState       *string                             `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendHealth is list of
// ApplicationGatewayBackendHealthPool resources.
type ApplicationGatewayBackendHealth struct {
	autorest.Response   `json:"-"`
	BackendAddressPools *[]ApplicationGatewayBackendHealthPool `json:"backendAddressPools,omitempty"`
}

// ApplicationGatewayBackendHealthHTTPSettings is application gateway
// BackendHealthHttp settings.
type ApplicationGatewayBackendHealthHTTPSettings struct {
	BackendHTTPSettings *ApplicationGatewayBackendHTTPSettings   `json:"backendHttpSettings,omitempty"`
	Servers             *[]ApplicationGatewayBackendHealthServer `json:"servers,omitempty"`
}

// ApplicationGatewayBackendHealthPool is application gateway BackendHealth
// pool.
type ApplicationGatewayBackendHealthPool struct {
	BackendAddressPool            *ApplicationGatewayBackendAddressPool          `json:"backendAddressPool,omitempty"`
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHealthHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
}

// ApplicationGatewayBackendHealthServer is application gateway backendhealth
// http settings.
type ApplicationGatewayBackendHealthServer struct {
	Address         *string                                     `json:"address,omitempty"`
	IPConfiguration *SubResource                                `json:"ipConfiguration,omitempty"`
	Health          ApplicationGatewayBackendHealthServerHealth `json:"health,omitempty"`
}

// ApplicationGatewayBackendHTTPSettings is backend address pool settings of an
// application gateway.
type ApplicationGatewayBackendHTTPSettings struct {
	ID                                                     *string `json:"id,omitempty"`
	*ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	Name                                                   *string `json:"name,omitempty"`
	Etag                                                   *string `json:"etag,omitempty"`
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat is properties of
// Backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	Port                       *int32                                `json:"port,omitempty"`
	Protocol                   ApplicationGatewayProtocol            `json:"protocol,omitempty"`
	CookieBasedAffinity        ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	RequestTimeout             *int32                                `json:"requestTimeout,omitempty"`
	Probe                      *SubResource                          `json:"probe,omitempty"`
	AuthenticationCertificates *[]SubResource                        `json:"authenticationCertificates,omitempty"`
	ProvisioningState          *string                               `json:"provisioningState,omitempty"`
	ConnectionDraining         *ApplicationGatewayConnectionDraining `json:"connectionDraining,omitempty"`
}

// ApplicationGatewayConnectionDraining is connection draining allows open
// connections to a backend server to be active for a specified time after the
// backend server got removed from the configuration.
type ApplicationGatewayConnectionDraining struct {
	Enabled           *bool  `json:"enabled,omitempty"`
	DrainTimeoutInSec *int32 `json:"drainTimeoutInSec,omitempty"`
}

// ApplicationGatewayFirewallDisabledRuleGroup is allows to disable rules
// within a rule group or an entire rule group.
type ApplicationGatewayFirewallDisabledRuleGroup struct {
	RuleGroupName *string  `json:"ruleGroupName,omitempty"`
	Rules         *[]int32 `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallRule is a web application firewall rule.
type ApplicationGatewayFirewallRule struct {
	RuleID      *int32  `json:"ruleId,omitempty"`
	Description *string `json:"description,omitempty"`
}

// ApplicationGatewayFirewallRuleGroup is a web application firewall rule
// group.
type ApplicationGatewayFirewallRuleGroup struct {
	RuleGroupName *string                           `json:"ruleGroupName,omitempty"`
	Description   *string                           `json:"description,omitempty"`
	Rules         *[]ApplicationGatewayFirewallRule `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallRuleSet is a web application firewall rule set.
type ApplicationGatewayFirewallRuleSet struct {
	ID                                                 *string             `json:"id,omitempty"`
	Name                                               *string             `json:"name,omitempty"`
	Type                                               *string             `json:"type,omitempty"`
	Location                                           *string             `json:"location,omitempty"`
	Tags                                               *map[string]*string `json:"tags,omitempty"`
	*ApplicationGatewayFirewallRuleSetPropertiesFormat `json:"properties,omitempty"`
}

// ApplicationGatewayFirewallRuleSetPropertiesFormat is properties of the web
// application firewall rule set.
type ApplicationGatewayFirewallRuleSetPropertiesFormat struct {
	ProvisioningState *string                                `json:"provisioningState,omitempty"`
	RuleSetType       *string                                `json:"ruleSetType,omitempty"`
	RuleSetVersion    *string                                `json:"ruleSetVersion,omitempty"`
	RuleGroups        *[]ApplicationGatewayFirewallRuleGroup `json:"ruleGroups,omitempty"`
}

// ApplicationGatewayFrontendIPConfiguration is frontend IP configuration of an
// application gateway.
type ApplicationGatewayFrontendIPConfiguration struct {
	ID                                                         *string `json:"id,omitempty"`
	*ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name                                                       *string `json:"name,omitempty"`
	Etag                                                       *string `json:"etag,omitempty"`
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat is properties of
// Frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *SubResource       `json:"subnet,omitempty"`
	PublicIPAddress           *SubResource       `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendPort is frontend port of an application gateway.
type ApplicationGatewayFrontendPort struct {
	ID                                              *string `json:"id,omitempty"`
	*ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	Name                                            *string `json:"name,omitempty"`
	Etag                                            *string `json:"etag,omitempty"`
}

// ApplicationGatewayFrontendPortPropertiesFormat is properties of Frontend
// port of an application gateway.
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	Port              *int32  `json:"port,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayHTTPListener is http listener of an application gateway.
type ApplicationGatewayHTTPListener struct {
	ID                                              *string `json:"id,omitempty"`
	*ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	Name                                            *string `json:"name,omitempty"`
	Etag                                            *string `json:"etag,omitempty"`
}

// ApplicationGatewayHTTPListenerPropertiesFormat is properties of HTTP
// listener of an application gateway.
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	FrontendIPConfiguration     *SubResource               `json:"frontendIPConfiguration,omitempty"`
	FrontendPort                *SubResource               `json:"frontendPort,omitempty"`
	Protocol                    ApplicationGatewayProtocol `json:"protocol,omitempty"`
	HostName                    *string                    `json:"hostName,omitempty"`
	SslCertificate              *SubResource               `json:"sslCertificate,omitempty"`
	RequireServerNameIndication *bool                      `json:"requireServerNameIndication,omitempty"`
	ProvisioningState           *string                    `json:"provisioningState,omitempty"`
}

// ApplicationGatewayIPConfiguration is iP configuration of an application
// gateway. Currently 1 public and 1 private IP configuration is allowed.
type ApplicationGatewayIPConfiguration struct {
	ID                                                 *string `json:"id,omitempty"`
	*ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name                                               *string `json:"name,omitempty"`
	Etag                                               *string `json:"etag,omitempty"`
}

// ApplicationGatewayIPConfigurationPropertiesFormat is properties of IP
// configuration of an application gateway.
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	Subnet            *SubResource `json:"subnet,omitempty"`
	ProvisioningState *string      `json:"provisioningState,omitempty"`
}

// ApplicationGatewayListResult is response for ListApplicationGateways API
// service call.
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationGateway `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// ApplicationGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ApplicationGatewayListResult) ApplicationGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ApplicationGatewayPathRule is path rule of URL path map of an application
// gateway.
type ApplicationGatewayPathRule struct {
	ID                                          *string `json:"id,omitempty"`
	*ApplicationGatewayPathRulePropertiesFormat `json:"properties,omitempty"`
	Name                                        *string `json:"name,omitempty"`
	Etag                                        *string `json:"etag,omitempty"`
}

// ApplicationGatewayPathRulePropertiesFormat is properties of probe of an
// application gateway.
type ApplicationGatewayPathRulePropertiesFormat struct {
	Paths               *[]string    `json:"paths,omitempty"`
	BackendAddressPool  *SubResource `json:"backendAddressPool,omitempty"`
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	ProvisioningState   *string      `json:"provisioningState,omitempty"`
}

// ApplicationGatewayProbe is probe of the application gateway.
type ApplicationGatewayProbe struct {
	ID                                       *string `json:"id,omitempty"`
	*ApplicationGatewayProbePropertiesFormat `json:"properties,omitempty"`
	Name                                     *string `json:"name,omitempty"`
	Etag                                     *string `json:"etag,omitempty"`
}

// ApplicationGatewayProbePropertiesFormat is properties of probe of an
// application gateway.
type ApplicationGatewayProbePropertiesFormat struct {
	Protocol           ApplicationGatewayProtocol `json:"protocol,omitempty"`
	Host               *string                    `json:"host,omitempty"`
	Path               *string                    `json:"path,omitempty"`
	Interval           *int32                     `json:"interval,omitempty"`
	Timeout            *int32                     `json:"timeout,omitempty"`
	UnhealthyThreshold *int32                     `json:"unhealthyThreshold,omitempty"`
	ProvisioningState  *string                    `json:"provisioningState,omitempty"`
}

// ApplicationGatewayPropertiesFormat is properties of the application gateway.
type ApplicationGatewayPropertiesFormat struct {
	Sku                                 *ApplicationGatewaySku                                 `json:"sku,omitempty"`
	SslPolicy                           *ApplicationGatewaySslPolicy                           `json:"sslPolicy,omitempty"`
	OperationalState                    ApplicationGatewayOperationalState                     `json:"operationalState,omitempty"`
	GatewayIPConfigurations             *[]ApplicationGatewayIPConfiguration                   `json:"gatewayIPConfigurations,omitempty"`
	AuthenticationCertificates          *[]ApplicationGatewayAuthenticationCertificate         `json:"authenticationCertificates,omitempty"`
	SslCertificates                     *[]ApplicationGatewaySslCertificate                    `json:"sslCertificates,omitempty"`
	FrontendIPConfigurations            *[]ApplicationGatewayFrontendIPConfiguration           `json:"frontendIPConfigurations,omitempty"`
	FrontendPorts                       *[]ApplicationGatewayFrontendPort                      `json:"frontendPorts,omitempty"`
	Probes                              *[]ApplicationGatewayProbe                             `json:"probes,omitempty"`
	BackendAddressPools                 *[]ApplicationGatewayBackendAddressPool                `json:"backendAddressPools,omitempty"`
	BackendHTTPSettingsCollection       *[]ApplicationGatewayBackendHTTPSettings               `json:"backendHttpSettingsCollection,omitempty"`
	HTTPListeners                       *[]ApplicationGatewayHTTPListener                      `json:"httpListeners,omitempty"`
	URLPathMaps                         *[]ApplicationGatewayURLPathMap                        `json:"urlPathMaps,omitempty"`
	RequestRoutingRules                 *[]ApplicationGatewayRequestRoutingRule                `json:"requestRoutingRules,omitempty"`
	WebApplicationFirewallConfiguration *ApplicationGatewayWebApplicationFirewallConfiguration `json:"webApplicationFirewallConfiguration,omitempty"`
	ResourceGUID                        *string                                                `json:"resourceGuid,omitempty"`
	ProvisioningState                   *string                                                `json:"provisioningState,omitempty"`
}

// ApplicationGatewayRequestRoutingRule is request routing rule of an
// application gateway.
type ApplicationGatewayRequestRoutingRule struct {
	ID                                                    *string `json:"id,omitempty"`
	*ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	Name                                                  *string `json:"name,omitempty"`
	Etag                                                  *string `json:"etag,omitempty"`
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat is properties of
// request routing rule of the application gateway.
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	RuleType            ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	BackendAddressPool  *SubResource                             `json:"backendAddressPool,omitempty"`
	BackendHTTPSettings *SubResource                             `json:"backendHttpSettings,omitempty"`
	HTTPListener        *SubResource                             `json:"httpListener,omitempty"`
	URLPathMap          *SubResource                             `json:"urlPathMap,omitempty"`
	ProvisioningState   *string                                  `json:"provisioningState,omitempty"`
}

// ApplicationGatewaySku is sKU of an application gateway
type ApplicationGatewaySku struct {
	Name     ApplicationGatewaySkuName `json:"name,omitempty"`
	Tier     ApplicationGatewayTier    `json:"tier,omitempty"`
	Capacity *int32                    `json:"capacity,omitempty"`
}

// ApplicationGatewaySslCertificate is sSL certificates of an application
// gateway.
type ApplicationGatewaySslCertificate struct {
	ID                                                *string `json:"id,omitempty"`
	*ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	Name                                              *string `json:"name,omitempty"`
	Etag                                              *string `json:"etag,omitempty"`
}

// ApplicationGatewaySslCertificatePropertiesFormat is properties of SSL
// certificates of an application gateway.
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	Data              *string `json:"data,omitempty"`
	Password          *string `json:"password,omitempty"`
	PublicCertData    *string `json:"publicCertData,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewaySslPolicy is application gateway SSL policy.
type ApplicationGatewaySslPolicy struct {
	DisabledSslProtocols *[]ApplicationGatewaySslProtocol `json:"disabledSslProtocols,omitempty"`
}

// ApplicationGatewayURLPathMap is urlPathMaps give a url path to the backend
// mapping information for PathBasedRouting.
type ApplicationGatewayURLPathMap struct {
	ID                                            *string `json:"id,omitempty"`
	*ApplicationGatewayURLPathMapPropertiesFormat `json:"properties,omitempty"`
	Name                                          *string `json:"name,omitempty"`
	Etag                                          *string `json:"etag,omitempty"`
}

// ApplicationGatewayURLPathMapPropertiesFormat is properties of UrlPathMap of
// the application gateway.
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	DefaultBackendAddressPool  *SubResource                  `json:"defaultBackendAddressPool,omitempty"`
	DefaultBackendHTTPSettings *SubResource                  `json:"defaultBackendHttpSettings,omitempty"`
	PathRules                  *[]ApplicationGatewayPathRule `json:"pathRules,omitempty"`
	ProvisioningState          *string                       `json:"provisioningState,omitempty"`
}

// ApplicationGatewayWebApplicationFirewallConfiguration is application gateway
// web application firewall configuration.
type ApplicationGatewayWebApplicationFirewallConfiguration struct {
	Enabled            *bool                                          `json:"enabled,omitempty"`
	FirewallMode       ApplicationGatewayFirewallMode                 `json:"firewallMode,omitempty"`
	RuleSetType        *string                                        `json:"ruleSetType,omitempty"`
	RuleSetVersion     *string                                        `json:"ruleSetVersion,omitempty"`
	DisabledRuleGroups *[]ApplicationGatewayFirewallDisabledRuleGroup `json:"disabledRuleGroups,omitempty"`
}

// AuthorizationListResult is response for ListAuthorizations API service call
// retrieves all authorizations that belongs to an ExpressRouteCircuit.
type AuthorizationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitAuthorization `json:"value,omitempty"`
	NextLink          *string                             `json:"nextLink,omitempty"`
}

// AuthorizationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AuthorizationListResult) AuthorizationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AuthorizationPropertiesFormat is
type AuthorizationPropertiesFormat struct {
	AuthorizationKey       *string                `json:"authorizationKey,omitempty"`
	AuthorizationUseStatus AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	ProvisioningState      *string                `json:"provisioningState,omitempty"`
}

// AzureAsyncOperationResult is the response body contains the status of the
// specified asynchronous operation, indicating whether it has succeeded, is in
// progress, or has failed. Note that this status is distinct from the HTTP
// status code returned for the Get Operation Status operation itself. If the
// asynchronous operation succeeded, the response body includes the HTTP status
// code for the successful request. If the asynchronous operation failed, the
// response body includes the HTTP status code for the failed request and error
// information regarding the failure.
type AzureAsyncOperationResult struct {
	Status OperationStatus `json:"status,omitempty"`
	Error  *Error          `json:"error,omitempty"`
}

// BackendAddressPool is pool of backend IP addresses.
type BackendAddressPool struct {
	ID                                  *string `json:"id,omitempty"`
	*BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	Name                                *string `json:"name,omitempty"`
	Etag                                *string `json:"etag,omitempty"`
}

// BackendAddressPoolPropertiesFormat is properties of the backend address
// pool.
type BackendAddressPoolPropertiesFormat struct {
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	LoadBalancingRules      *[]SubResource              `json:"loadBalancingRules,omitempty"`
	OutboundNatRule         *SubResource                `json:"outboundNatRule,omitempty"`
	ProvisioningState       *string                     `json:"provisioningState,omitempty"`
}

// BGPCommunity is contains bgp community information offered in Service
// Community resources.
type BGPCommunity struct {
	ServiceSupportedRegion *string   `json:"serviceSupportedRegion,omitempty"`
	CommunityName          *string   `json:"communityName,omitempty"`
	CommunityValue         *string   `json:"communityValue,omitempty"`
	CommunityPrefixes      *[]string `json:"communityPrefixes,omitempty"`
}

// BgpPeerStatus is bGP peer status details
type BgpPeerStatus struct {
	LocalAddress      *string      `json:"localAddress,omitempty"`
	Neighbor          *string      `json:"neighbor,omitempty"`
	Asn               *int32       `json:"asn,omitempty"`
	State             BgpPeerState `json:"state,omitempty"`
	ConnectedDuration *string      `json:"connectedDuration,omitempty"`
	RoutesReceived    *int64       `json:"routesReceived,omitempty"`
	MessagesSent      *int64       `json:"messagesSent,omitempty"`
	MessagesReceived  *int64       `json:"messagesReceived,omitempty"`
}

// BgpPeerStatusListResult is response for list BGP peer status API service
// call
type BgpPeerStatusListResult struct {
	autorest.Response `json:"-"`
	Value             *[]BgpPeerStatus `json:"value,omitempty"`
}

// BgpServiceCommunity is service Community Properties.
type BgpServiceCommunity struct {
	ID                                   *string             `json:"id,omitempty"`
	Name                                 *string             `json:"name,omitempty"`
	Type                                 *string             `json:"type,omitempty"`
	Location                             *string             `json:"location,omitempty"`
	Tags                                 *map[string]*string `json:"tags,omitempty"`
	*BgpServiceCommunityPropertiesFormat `json:"properties,omitempty"`
}

// BgpServiceCommunityListResult is response for the ListServiceCommunity API
// service call.
type BgpServiceCommunityListResult struct {
	autorest.Response `json:"-"`
	Value             *[]BgpServiceCommunity `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// BgpServiceCommunityListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client BgpServiceCommunityListResult) BgpServiceCommunityListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// BgpServiceCommunityPropertiesFormat is properties of Service Community.
type BgpServiceCommunityPropertiesFormat struct {
	ServiceName    *string         `json:"serviceName,omitempty"`
	BgpCommunities *[]BGPCommunity `json:"bgpCommunities,omitempty"`
}

// BgpSettings is bGP settings details
type BgpSettings struct {
	Asn               *int64  `json:"asn,omitempty"`
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`
	PeerWeight        *int32  `json:"peerWeight,omitempty"`
}

// ConnectionResetSharedKey is the virtual network connection reset shared key
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	KeyLength         *int32 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey is response for GetConnectionSharedKey API service call
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// DhcpOptions is dhcpOptions contains an array of DNS servers available to VMs
// deployed in the virtual network. Standard DHCP option for a subnet overrides
// VNET DHCP options.
type DhcpOptions struct {
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// DNSNameAvailabilityResult is response for the CheckDnsNameAvailability API
// service call.
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	Available         *bool `json:"available,omitempty"`
}

// EffectiveNetworkSecurityGroup is effective network security group.
type EffectiveNetworkSecurityGroup struct {
	NetworkSecurityGroup   *SubResource                              `json:"networkSecurityGroup,omitempty"`
	Association            *EffectiveNetworkSecurityGroupAssociation `json:"association,omitempty"`
	EffectiveSecurityRules *[]EffectiveNetworkSecurityRule           `json:"effectiveSecurityRules,omitempty"`
}

// EffectiveNetworkSecurityGroupAssociation is the effective network security
// group association.
type EffectiveNetworkSecurityGroupAssociation struct {
	Subnet           *SubResource `json:"subnet,omitempty"`
	NetworkInterface *SubResource `json:"networkInterface,omitempty"`
}

// EffectiveNetworkSecurityGroupListResult is response for list effective
// network security groups API service call.
type EffectiveNetworkSecurityGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]EffectiveNetworkSecurityGroup `json:"value,omitempty"`
	NextLink          *string                          `json:"nextLink,omitempty"`
}

// EffectiveNetworkSecurityRule is effective network security rules.
type EffectiveNetworkSecurityRule struct {
	Name                             *string               `json:"name,omitempty"`
	Protocol                         SecurityRuleProtocol  `json:"protocol,omitempty"`
	SourcePortRange                  *string               `json:"sourcePortRange,omitempty"`
	DestinationPortRange             *string               `json:"destinationPortRange,omitempty"`
	SourceAddressPrefix              *string               `json:"sourceAddressPrefix,omitempty"`
	DestinationAddressPrefix         *string               `json:"destinationAddressPrefix,omitempty"`
	ExpandedSourceAddressPrefix      *[]string             `json:"expandedSourceAddressPrefix,omitempty"`
	ExpandedDestinationAddressPrefix *[]string             `json:"expandedDestinationAddressPrefix,omitempty"`
	Access                           SecurityRuleAccess    `json:"access,omitempty"`
	Priority                         *int32                `json:"priority,omitempty"`
	Direction                        SecurityRuleDirection `json:"direction,omitempty"`
}

// EffectiveRoute is effective Route
type EffectiveRoute struct {
	Name             *string              `json:"name,omitempty"`
	Source           EffectiveRouteSource `json:"source,omitempty"`
	State            EffectiveRouteState  `json:"state,omitempty"`
	AddressPrefix    *[]string            `json:"addressPrefix,omitempty"`
	NextHopIPAddress *[]string            `json:"nextHopIpAddress,omitempty"`
	NextHopType      RouteNextHopType     `json:"nextHopType,omitempty"`
}

// EffectiveRouteListResult is response for list effective route API service
// call.
type EffectiveRouteListResult struct {
	autorest.Response `json:"-"`
	Value             *[]EffectiveRoute `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// Error is
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// ErrorDetails is
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExpressRouteCircuit is expressRouteCircuit resource
type ExpressRouteCircuit struct {
	autorest.Response                    `json:"-"`
	ID                                   *string                 `json:"id,omitempty"`
	Name                                 *string                 `json:"name,omitempty"`
	Type                                 *string                 `json:"type,omitempty"`
	Location                             *string                 `json:"location,omitempty"`
	Tags                                 *map[string]*string     `json:"tags,omitempty"`
	Sku                                  *ExpressRouteCircuitSku `json:"sku,omitempty"`
	*ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`
	Etag                                 *string `json:"etag,omitempty"`
}

// ExpressRouteCircuitArpTable is the ARP table associated with the
// ExpressRouteCircuit.
type ExpressRouteCircuitArpTable struct {
	Age        *int32  `json:"age,omitempty"`
	Interface  *string `json:"interface,omitempty"`
	IPAddress  *string `json:"ipAddress,omitempty"`
	MacAddress *string `json:"macAddress,omitempty"`
}

// ExpressRouteCircuitAuthorization is authorization in an ExpressRouteCircuit
// resource.
type ExpressRouteCircuitAuthorization struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	*AuthorizationPropertiesFormat `json:"properties,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Etag                           *string `json:"etag,omitempty"`
}

// ExpressRouteCircuitListResult is response for ListExpressRouteCircuit API
// service call.
type ExpressRouteCircuitListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuit `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ExpressRouteCircuitListResult) ExpressRouteCircuitListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ExpressRouteCircuitPeering is peering in an ExpressRouteCircuit resource.
type ExpressRouteCircuitPeering struct {
	autorest.Response                           `json:"-"`
	ID                                          *string `json:"id,omitempty"`
	*ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`
	Name                                        *string `json:"name,omitempty"`
	Etag                                        *string `json:"etag,omitempty"`
}

// ExpressRouteCircuitPeeringConfig is specifies the peering configuration.
type ExpressRouteCircuitPeeringConfig struct {
	AdvertisedPublicPrefixes      *[]string                                             `json:"advertisedPublicPrefixes,omitempty"`
	AdvertisedPublicPrefixesState ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty"`
	CustomerASN                   *int32                                                `json:"customerASN,omitempty"`
	RoutingRegistryName           *string                                               `json:"routingRegistryName,omitempty"`
}

// ExpressRouteCircuitPeeringListResult is response for ListPeering API service
// call retrieves all peerings that belong to an ExpressRouteCircuit.
type ExpressRouteCircuitPeeringListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitPeering `json:"value,omitempty"`
	NextLink          *string                       `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitPeeringListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ExpressRouteCircuitPeeringListResult) ExpressRouteCircuitPeeringListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ExpressRouteCircuitPeeringPropertiesFormat is
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	PeeringType                ExpressRouteCircuitPeeringType    `json:"peeringType,omitempty"`
	State                      ExpressRouteCircuitPeeringState   `json:"state,omitempty"`
	AzureASN                   *int32                            `json:"azureASN,omitempty"`
	PeerASN                    *int32                            `json:"peerASN,omitempty"`
	PrimaryPeerAddressPrefix   *string                           `json:"primaryPeerAddressPrefix,omitempty"`
	SecondaryPeerAddressPrefix *string                           `json:"secondaryPeerAddressPrefix,omitempty"`
	PrimaryAzurePort           *string                           `json:"primaryAzurePort,omitempty"`
	SecondaryAzurePort         *string                           `json:"secondaryAzurePort,omitempty"`
	SharedKey                  *string                           `json:"sharedKey,omitempty"`
	VlanID                     *int32                            `json:"vlanId,omitempty"`
	MicrosoftPeeringConfig     *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	Stats                      *ExpressRouteCircuitStats         `json:"stats,omitempty"`
	ProvisioningState          *string                           `json:"provisioningState,omitempty"`
	GatewayManagerEtag         *string                           `json:"gatewayManagerEtag,omitempty"`
	LastModifiedBy             *string                           `json:"lastModifiedBy,omitempty"`
	RouteFilter                *RouteFilter                      `json:"routeFilter,omitempty"`
}

// ExpressRouteCircuitPropertiesFormat is properties of ExpressRouteCircuit.
type ExpressRouteCircuitPropertiesFormat struct {
	AllowClassicOperations           *bool                                         `json:"allowClassicOperations,omitempty"`
	CircuitProvisioningState         *string                                       `json:"circuitProvisioningState,omitempty"`
	ServiceProviderProvisioningState ServiceProviderProvisioningState              `json:"serviceProviderProvisioningState,omitempty"`
	Authorizations                   *[]ExpressRouteCircuitAuthorization           `json:"authorizations,omitempty"`
	Peerings                         *[]ExpressRouteCircuitPeering                 `json:"peerings,omitempty"`
	ServiceKey                       *string                                       `json:"serviceKey,omitempty"`
	ServiceProviderNotes             *string                                       `json:"serviceProviderNotes,omitempty"`
	ServiceProviderProperties        *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`
	ProvisioningState                *string                                       `json:"provisioningState,omitempty"`
	GatewayManagerEtag               *string                                       `json:"gatewayManagerEtag,omitempty"`
}

// ExpressRouteCircuitRoutesTable is the routes table associated with the
// ExpressRouteCircuit
type ExpressRouteCircuitRoutesTable struct {
	NetworkProperty *string `json:"network,omitempty"`
	NextHop         *string `json:"nextHop,omitempty"`
	LocPrf          *string `json:"locPrf,omitempty"`
	Weight          *int32  `json:"weight,omitempty"`
	Path            *string `json:"path,omitempty"`
}

// ExpressRouteCircuitRoutesTableSummary is the routes table associated with
// the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTableSummary struct {
	Neighbor    *string `json:"neighbor,omitempty"`
	V           *int32  `json:"v,omitempty"`
	As          *int32  `json:"as,omitempty"`
	UpDown      *string `json:"upDown,omitempty"`
	StatePfxRcd *string `json:"statePfxRcd,omitempty"`
}

// ExpressRouteCircuitsArpTableListResult is response for ListArpTable
// associated with the Express Route Circuits API.
type ExpressRouteCircuitsArpTableListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitArpTable `json:"value,omitempty"`
	NextLink          *string                        `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitServiceProviderProperties is contains
// ServiceProviderProperties in an ExpressRouteCircuit.
type ExpressRouteCircuitServiceProviderProperties struct {
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	PeeringLocation     *string `json:"peeringLocation,omitempty"`
	BandwidthInMbps     *int32  `json:"bandwidthInMbps,omitempty"`
}

// ExpressRouteCircuitSku is contains SKU in an ExpressRouteCircuit.
type ExpressRouteCircuitSku struct {
	Name   *string                      `json:"name,omitempty"`
	Tier   ExpressRouteCircuitSkuTier   `json:"tier,omitempty"`
	Family ExpressRouteCircuitSkuFamily `json:"family,omitempty"`
}

// ExpressRouteCircuitsRoutesTableListResult is response for ListRoutesTable
// associated with the Express Route Circuits API.
type ExpressRouteCircuitsRoutesTableListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
	NextLink          *string                           `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsRoutesTableSummaryListResult is response for
// ListRoutesTable associated with the Express Route Circuits API.
type ExpressRouteCircuitsRoutesTableSummaryListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteCircuitRoutesTableSummary `json:"value,omitempty"`
	NextLink          *string                                  `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitStats is contains stats associated with the peering.
type ExpressRouteCircuitStats struct {
	autorest.Response `json:"-"`
	PrimarybytesIn    *int64 `json:"primarybytesIn,omitempty"`
	PrimarybytesOut   *int64 `json:"primarybytesOut,omitempty"`
	SecondarybytesIn  *int64 `json:"secondarybytesIn,omitempty"`
	SecondarybytesOut *int64 `json:"secondarybytesOut,omitempty"`
}

// ExpressRouteServiceProvider is a ExpressRouteResourceProvider object.
type ExpressRouteServiceProvider struct {
	ID                                           *string             `json:"id,omitempty"`
	Name                                         *string             `json:"name,omitempty"`
	Type                                         *string             `json:"type,omitempty"`
	Location                                     *string             `json:"location,omitempty"`
	Tags                                         *map[string]*string `json:"tags,omitempty"`
	*ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`
}

// ExpressRouteServiceProviderBandwidthsOffered is contains bandwidths offered
// in ExpressRouteServiceProvider resources.
type ExpressRouteServiceProviderBandwidthsOffered struct {
	OfferName   *string `json:"offerName,omitempty"`
	ValueInMbps *int32  `json:"valueInMbps,omitempty"`
}

// ExpressRouteServiceProviderListResult is response for the
// ListExpressRouteServiceProvider API service call.
type ExpressRouteServiceProviderListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExpressRouteServiceProvider `json:"value,omitempty"`
	NextLink          *string                        `json:"nextLink,omitempty"`
}

// ExpressRouteServiceProviderListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ExpressRouteServiceProviderListResult) ExpressRouteServiceProviderListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ExpressRouteServiceProviderPropertiesFormat is properties of
// ExpressRouteServiceProvider.
type ExpressRouteServiceProviderPropertiesFormat struct {
	PeeringLocations  *[]string                                       `json:"peeringLocations,omitempty"`
	BandwidthsOffered *[]ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`
	ProvisioningState *string                                         `json:"provisioningState,omitempty"`
}

// FlowLogInformation is information on the configuration of flow log.
type FlowLogInformation struct {
	autorest.Response  `json:"-"`
	TargetResourceID   *string `json:"targetResourceId,omitempty"`
	*FlowLogProperties `json:"properties,omitempty"`
}

// FlowLogProperties is parameters that define the configuration of flow log.
type FlowLogProperties struct {
	StorageID       *string                    `json:"storageId,omitempty"`
	Enabled         *bool                      `json:"enabled,omitempty"`
	RetentionPolicy *RetentionPolicyParameters `json:"retentionPolicy,omitempty"`
}

// FlowLogStatusParameters is parameters that define a resource to query flow
// log status.
type FlowLogStatusParameters struct {
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// FrontendIPConfiguration is frontend IP address of the load balancer.
type FrontendIPConfiguration struct {
	ID                                       *string `json:"id,omitempty"`
	*FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name                                     *string `json:"name,omitempty"`
	Etag                                     *string `json:"etag,omitempty"`
}

// FrontendIPConfigurationPropertiesFormat is properties of Frontend IP
// Configuration of the load balancer.
type FrontendIPConfigurationPropertiesFormat struct {
	InboundNatRules           *[]SubResource     `json:"inboundNatRules,omitempty"`
	InboundNatPools           *[]SubResource     `json:"inboundNatPools,omitempty"`
	OutboundNatRules          *[]SubResource     `json:"outboundNatRules,omitempty"`
	LoadBalancingRules        *[]SubResource     `json:"loadBalancingRules,omitempty"`
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *Subnet            `json:"subnet,omitempty"`
	PublicIPAddress           *PublicIPAddress   `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// GatewayRoute is gateway routing details
type GatewayRoute struct {
	LocalAddress    *string `json:"localAddress,omitempty"`
	NetworkProperty *string `json:"network,omitempty"`
	NextHop         *string `json:"nextHop,omitempty"`
	SourcePeer      *string `json:"sourcePeer,omitempty"`
	Origin          *string `json:"origin,omitempty"`
	AsPath          *string `json:"asPath,omitempty"`
	Weight          *int32  `json:"weight,omitempty"`
}

// GatewayRouteListResult is list of virtual network gateway routes
type GatewayRouteListResult struct {
	autorest.Response `json:"-"`
	Value             *[]GatewayRoute `json:"value,omitempty"`
}

// InboundNatPool is inbound NAT pool of the load balancer.
type InboundNatPool struct {
	ID                              *string `json:"id,omitempty"`
	*InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
	Name                            *string `json:"name,omitempty"`
	Etag                            *string `json:"etag,omitempty"`
}

// InboundNatPoolPropertiesFormat is properties of Inbound NAT pool.
type InboundNatPoolPropertiesFormat struct {
	FrontendIPConfiguration *SubResource      `json:"frontendIPConfiguration,omitempty"`
	Protocol                TransportProtocol `json:"protocol,omitempty"`
	FrontendPortRangeStart  *int32            `json:"frontendPortRangeStart,omitempty"`
	FrontendPortRangeEnd    *int32            `json:"frontendPortRangeEnd,omitempty"`
	BackendPort             *int32            `json:"backendPort,omitempty"`
	ProvisioningState       *string           `json:"provisioningState,omitempty"`
}

// InboundNatRule is inbound NAT rule of the load balancer.
type InboundNatRule struct {
	ID                              *string `json:"id,omitempty"`
	*InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	Name                            *string `json:"name,omitempty"`
	Etag                            *string `json:"etag,omitempty"`
}

// InboundNatRulePropertiesFormat is properties of the inbound NAT rule.
type InboundNatRulePropertiesFormat struct {
	FrontendIPConfiguration *SubResource              `json:"frontendIPConfiguration,omitempty"`
	BackendIPConfiguration  *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty"`
	Protocol                TransportProtocol         `json:"protocol,omitempty"`
	FrontendPort            *int32                    `json:"frontendPort,omitempty"`
	BackendPort             *int32                    `json:"backendPort,omitempty"`
	IdleTimeoutInMinutes    *int32                    `json:"idleTimeoutInMinutes,omitempty"`
	EnableFloatingIP        *bool                     `json:"enableFloatingIP,omitempty"`
	ProvisioningState       *string                   `json:"provisioningState,omitempty"`
}

// Interface is a network interface in a resource group.
type Interface struct {
	autorest.Response          `json:"-"`
	ID                         *string             `json:"id,omitempty"`
	Name                       *string             `json:"name,omitempty"`
	Type                       *string             `json:"type,omitempty"`
	Location                   *string             `json:"location,omitempty"`
	Tags                       *map[string]*string `json:"tags,omitempty"`
	*InterfacePropertiesFormat `json:"properties,omitempty"`
	Etag                       *string `json:"etag,omitempty"`
}

// InterfaceAssociation is network interface and its custom security rules.
type InterfaceAssociation struct {
	ID            *string         `json:"id,omitempty"`
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// InterfaceDNSSettings is dNS settings of a network interface.
type InterfaceDNSSettings struct {
	DNSServers               *[]string `json:"dnsServers,omitempty"`
	AppliedDNSServers        *[]string `json:"appliedDnsServers,omitempty"`
	InternalDNSNameLabel     *string   `json:"internalDnsNameLabel,omitempty"`
	InternalFqdn             *string   `json:"internalFqdn,omitempty"`
	InternalDomainNameSuffix *string   `json:"internalDomainNameSuffix,omitempty"`
}

// InterfaceIPConfiguration is iPConfiguration in a network interface.
type InterfaceIPConfiguration struct {
	ID                                        *string `json:"id,omitempty"`
	*InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name                                      *string `json:"name,omitempty"`
	Etag                                      *string `json:"etag,omitempty"`
}

// InterfaceIPConfigurationPropertiesFormat is properties of IP configuration.
type InterfaceIPConfigurationPropertiesFormat struct {
	ApplicationGatewayBackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"applicationGatewayBackendAddressPools,omitempty"`
	LoadBalancerBackendAddressPools       *[]BackendAddressPool                   `json:"loadBalancerBackendAddressPools,omitempty"`
	LoadBalancerInboundNatRules           *[]InboundNatRule                       `json:"loadBalancerInboundNatRules,omitempty"`
	PrivateIPAddress                      *string                                 `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod             IPAllocationMethod                      `json:"privateIPAllocationMethod,omitempty"`
	PrivateIPAddressVersion               IPVersion                               `json:"privateIPAddressVersion,omitempty"`
	Subnet                                *Subnet                                 `json:"subnet,omitempty"`
	Primary                               *bool                                   `json:"primary,omitempty"`
	PublicIPAddress                       *PublicIPAddress                        `json:"publicIPAddress,omitempty"`
	ProvisioningState                     *string                                 `json:"provisioningState,omitempty"`
}

// InterfaceListResult is response for the ListNetworkInterface API service
// call.
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Interface `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// InterfaceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client InterfaceListResult) InterfaceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// InterfacePropertiesFormat is networkInterface properties.
type InterfacePropertiesFormat struct {
	VirtualMachine              *SubResource                `json:"virtualMachine,omitempty"`
	NetworkSecurityGroup        *SecurityGroup              `json:"networkSecurityGroup,omitempty"`
	IPConfigurations            *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	DNSSettings                 *InterfaceDNSSettings       `json:"dnsSettings,omitempty"`
	MacAddress                  *string                     `json:"macAddress,omitempty"`
	Primary                     *bool                       `json:"primary,omitempty"`
	EnableAcceleratedNetworking *bool                       `json:"enableAcceleratedNetworking,omitempty"`
	EnableIPForwarding          *bool                       `json:"enableIPForwarding,omitempty"`
	ResourceGUID                *string                     `json:"resourceGuid,omitempty"`
	ProvisioningState           *string                     `json:"provisioningState,omitempty"`
}

// IPAddressAvailabilityResult is response for CheckIPAddressAvailability API
// service call
type IPAddressAvailabilityResult struct {
	autorest.Response    `json:"-"`
	Available            *bool     `json:"available,omitempty"`
	AvailableIPAddresses *[]string `json:"availableIPAddresses,omitempty"`
}

// IPConfiguration is iPConfiguration
type IPConfiguration struct {
	ID                               *string `json:"id,omitempty"`
	*IPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name                             *string `json:"name,omitempty"`
	Etag                             *string `json:"etag,omitempty"`
}

// IPConfigurationPropertiesFormat is properties of IP configuration.
type IPConfigurationPropertiesFormat struct {
	PrivateIPAddress          *string            `json:"privateIPAddress,omitempty"`
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *Subnet            `json:"subnet,omitempty"`
	PublicIPAddress           *PublicIPAddress   `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// IpsecPolicy is an IPSec Policy configuration for a virtual network gateway
// connection
type IpsecPolicy struct {
	SaLifeTimeSeconds   *int32          `json:"saLifeTimeSeconds,omitempty"`
	SaDataSizeKilobytes *int32          `json:"saDataSizeKilobytes,omitempty"`
	IpsecEncryption     IpsecEncryption `json:"ipsecEncryption,omitempty"`
	IpsecIntegrity      IpsecIntegrity  `json:"ipsecIntegrity,omitempty"`
	IkeEncryption       IkeEncryption   `json:"ikeEncryption,omitempty"`
	IkeIntegrity        IkeIntegrity    `json:"ikeIntegrity,omitempty"`
	DhGroup             DhGroup         `json:"dhGroup,omitempty"`
	PfsGroup            PfsGroup        `json:"pfsGroup,omitempty"`
}

// LoadBalancer is loadBalancer resource
type LoadBalancer struct {
	autorest.Response             `json:"-"`
	ID                            *string             `json:"id,omitempty"`
	Name                          *string             `json:"name,omitempty"`
	Type                          *string             `json:"type,omitempty"`
	Location                      *string             `json:"location,omitempty"`
	Tags                          *map[string]*string `json:"tags,omitempty"`
	*LoadBalancerPropertiesFormat `json:"properties,omitempty"`
	Etag                          *string `json:"etag,omitempty"`
}

// LoadBalancerListResult is response for ListLoadBalancers API service call.
type LoadBalancerListResult struct {
	autorest.Response `json:"-"`
	Value             *[]LoadBalancer `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// LoadBalancerListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LoadBalancerListResult) LoadBalancerListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LoadBalancerPropertiesFormat is properties of the load balancer.
type LoadBalancerPropertiesFormat struct {
	FrontendIPConfigurations *[]FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	BackendAddressPools      *[]BackendAddressPool      `json:"backendAddressPools,omitempty"`
	LoadBalancingRules       *[]LoadBalancingRule       `json:"loadBalancingRules,omitempty"`
	Probes                   *[]Probe                   `json:"probes,omitempty"`
	InboundNatRules          *[]InboundNatRule          `json:"inboundNatRules,omitempty"`
	InboundNatPools          *[]InboundNatPool          `json:"inboundNatPools,omitempty"`
	OutboundNatRules         *[]OutboundNatRule         `json:"outboundNatRules,omitempty"`
	ResourceGUID             *string                    `json:"resourceGuid,omitempty"`
	ProvisioningState        *string                    `json:"provisioningState,omitempty"`
}

// LoadBalancingRule is a loag balancing rule for a load balancer.
type LoadBalancingRule struct {
	ID                                 *string `json:"id,omitempty"`
	*LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
	Name                               *string `json:"name,omitempty"`
	Etag                               *string `json:"etag,omitempty"`
}

// LoadBalancingRulePropertiesFormat is properties of the load balancer.
type LoadBalancingRulePropertiesFormat struct {
	FrontendIPConfiguration *SubResource      `json:"frontendIPConfiguration,omitempty"`
	BackendAddressPool      *SubResource      `json:"backendAddressPool,omitempty"`
	Probe                   *SubResource      `json:"probe,omitempty"`
	Protocol                TransportProtocol `json:"protocol,omitempty"`
	LoadDistribution        LoadDistribution  `json:"loadDistribution,omitempty"`
	FrontendPort            *int32            `json:"frontendPort,omitempty"`
	BackendPort             *int32            `json:"backendPort,omitempty"`
	IdleTimeoutInMinutes    *int32            `json:"idleTimeoutInMinutes,omitempty"`
	EnableFloatingIP        *bool             `json:"enableFloatingIP,omitempty"`
	ProvisioningState       *string           `json:"provisioningState,omitempty"`
}

// LocalNetworkGateway is a common class for general resource information
type LocalNetworkGateway struct {
	autorest.Response                    `json:"-"`
	ID                                   *string             `json:"id,omitempty"`
	Name                                 *string             `json:"name,omitempty"`
	Type                                 *string             `json:"type,omitempty"`
	Location                             *string             `json:"location,omitempty"`
	Tags                                 *map[string]*string `json:"tags,omitempty"`
	*LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag                                 *string `json:"etag,omitempty"`
}

// LocalNetworkGatewayListResult is response for ListLocalNetworkGateways API
// service call.
type LocalNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]LocalNetworkGateway `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// LocalNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LocalNetworkGatewayListResult) LocalNetworkGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LocalNetworkGatewayPropertiesFormat is localNetworkGateway properties
type LocalNetworkGatewayPropertiesFormat struct {
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`
	GatewayIPAddress         *string       `json:"gatewayIpAddress,omitempty"`
	BgpSettings              *BgpSettings  `json:"bgpSettings,omitempty"`
	ResourceGUID             *string       `json:"resourceGuid,omitempty"`
	ProvisioningState        *string       `json:"provisioningState,omitempty"`
}

// NextHopParameters is parameters that define the source and destination
// endpoint.
type NextHopParameters struct {
	TargetResourceID     *string `json:"targetResourceId,omitempty"`
	SourceIPAddress      *string `json:"sourceIPAddress,omitempty"`
	DestinationIPAddress *string `json:"destinationIPAddress,omitempty"`
	TargetNicResourceID  *string `json:"targetNicResourceId,omitempty"`
}

// NextHopResult is the information about next hop from the specified VM.
type NextHopResult struct {
	autorest.Response `json:"-"`
	NextHopType       NextHopType `json:"nextHopType,omitempty"`
	NextHopIPAddress  *string     `json:"nextHopIpAddress,omitempty"`
	RouteTableID      *string     `json:"routeTableId,omitempty"`
}

// OutboundNatRule is outbound NAT pool of the load balancer.
type OutboundNatRule struct {
	ID                               *string `json:"id,omitempty"`
	*OutboundNatRulePropertiesFormat `json:"properties,omitempty"`
	Name                             *string `json:"name,omitempty"`
	Etag                             *string `json:"etag,omitempty"`
}

// OutboundNatRulePropertiesFormat is outbound NAT pool of the load balancer.
type OutboundNatRulePropertiesFormat struct {
	AllocatedOutboundPorts   *int32         `json:"allocatedOutboundPorts,omitempty"`
	FrontendIPConfigurations *[]SubResource `json:"frontendIPConfigurations,omitempty"`
	BackendAddressPool       *SubResource   `json:"backendAddressPool,omitempty"`
	ProvisioningState        *string        `json:"provisioningState,omitempty"`
}

// PacketCapture is parameters that define the create packet capture operation.
type PacketCapture struct {
	*PacketCaptureParameters `json:"properties,omitempty"`
}

// PacketCaptureFilter is filter that is applied to packet capture request.
// Multiple filters can be applied.
type PacketCaptureFilter struct {
	Protocol        PcProtocol `json:"protocol,omitempty"`
	LocalIPAddress  *string    `json:"localIPAddress,omitempty"`
	RemoteIPAddress *string    `json:"remoteIPAddress,omitempty"`
	LocalPort       *string    `json:"localPort,omitempty"`
	RemotePort      *string    `json:"remotePort,omitempty"`
}

// PacketCaptureListResult is list of packet capture sessions.
type PacketCaptureListResult struct {
	autorest.Response `json:"-"`
	Value             *[]PacketCaptureResult `json:"value,omitempty"`
}

// PacketCaptureParameters is parameters that define the create packet capture
// operation.
type PacketCaptureParameters struct {
	Target                  *string                       `json:"target,omitempty"`
	BytesToCapturePerPacket *int32                        `json:"bytesToCapturePerPacket,omitempty"`
	TotalBytesPerSession    *int32                        `json:"totalBytesPerSession,omitempty"`
	TimeLimitInSeconds      *int32                        `json:"timeLimitInSeconds,omitempty"`
	StorageLocation         *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`
	Filters                 *[]PacketCaptureFilter        `json:"filters,omitempty"`
}

// PacketCaptureQueryStatusResult is status of packet capture session.
type PacketCaptureQueryStatusResult struct {
	autorest.Response   `json:"-"`
	Name                *string    `json:"name,omitempty"`
	ID                  *string    `json:"id,omitempty"`
	CaptureStartTime    *date.Time `json:"captureStartTime,omitempty"`
	PacketCaptureStatus PcStatus   `json:"packetCaptureStatus,omitempty"`
	StopReason          *string    `json:"stopReason,omitempty"`
	PacketCaptureError  *[]PcError `json:"packetCaptureError,omitempty"`
}

// PacketCaptureResult is information about packet capture session.
type PacketCaptureResult struct {
	autorest.Response              `json:"-"`
	Name                           *string `json:"name,omitempty"`
	ID                             *string `json:"id,omitempty"`
	Etag                           *string `json:"etag,omitempty"`
	*PacketCaptureResultProperties `json:"properties,omitempty"`
}

// PacketCaptureResultProperties is describes the properties of a packet
// capture session.
type PacketCaptureResultProperties struct {
	Target                  *string                       `json:"target,omitempty"`
	BytesToCapturePerPacket *int32                        `json:"bytesToCapturePerPacket,omitempty"`
	TotalBytesPerSession    *int32                        `json:"totalBytesPerSession,omitempty"`
	TimeLimitInSeconds      *int32                        `json:"timeLimitInSeconds,omitempty"`
	StorageLocation         *PacketCaptureStorageLocation `json:"storageLocation,omitempty"`
	Filters                 *[]PacketCaptureFilter        `json:"filters,omitempty"`
	ProvisioningState       ProvisioningState             `json:"provisioningState,omitempty"`
}

// PacketCaptureStorageLocation is describes the storage location for a packet
// capture session.
type PacketCaptureStorageLocation struct {
	StorageID   *string `json:"storageId,omitempty"`
	StoragePath *string `json:"storagePath,omitempty"`
	FilePath    *string `json:"filePath,omitempty"`
}

// PatchRouteFilter is route Filter Resource.
type PatchRouteFilter struct {
	ID                           *string `json:"id,omitempty"`
	*RouteFilterPropertiesFormat `json:"properties,omitempty"`
	Name                         *string             `json:"name,omitempty"`
	Etag                         *string             `json:"etag,omitempty"`
	Type                         *string             `json:"type,omitempty"`
	Tags                         *map[string]*string `json:"tags,omitempty"`
}

// PatchRouteFilterRule is route Filter Rule Resource
type PatchRouteFilterRule struct {
	ID                               *string `json:"id,omitempty"`
	*RouteFilterRulePropertiesFormat `json:"properties,omitempty"`
	Name                             *string             `json:"name,omitempty"`
	Etag                             *string             `json:"etag,omitempty"`
	Tags                             *map[string]*string `json:"tags,omitempty"`
}

// Probe is a load balancer probe.
type Probe struct {
	ID                     *string `json:"id,omitempty"`
	*ProbePropertiesFormat `json:"properties,omitempty"`
	Name                   *string `json:"name,omitempty"`
	Etag                   *string `json:"etag,omitempty"`
}

// ProbePropertiesFormat is
type ProbePropertiesFormat struct {
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	Protocol           ProbeProtocol  `json:"protocol,omitempty"`
	Port               *int32         `json:"port,omitempty"`
	IntervalInSeconds  *int32         `json:"intervalInSeconds,omitempty"`
	NumberOfProbes     *int32         `json:"numberOfProbes,omitempty"`
	RequestPath        *string        `json:"requestPath,omitempty"`
	ProvisioningState  *string        `json:"provisioningState,omitempty"`
}

// PublicIPAddress is public IP address resource.
type PublicIPAddress struct {
	autorest.Response                `json:"-"`
	ID                               *string             `json:"id,omitempty"`
	Name                             *string             `json:"name,omitempty"`
	Type                             *string             `json:"type,omitempty"`
	Location                         *string             `json:"location,omitempty"`
	Tags                             *map[string]*string `json:"tags,omitempty"`
	*PublicIPAddressPropertiesFormat `json:"properties,omitempty"`
	Etag                             *string `json:"etag,omitempty"`
}

// PublicIPAddressDNSSettings is contains FQDN of the DNS record associated
// with the public IP address
type PublicIPAddressDNSSettings struct {
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	Fqdn            *string `json:"fqdn,omitempty"`
	ReverseFqdn     *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressListResult is response for ListPublicIpAddresses API service
// call.
type PublicIPAddressListResult struct {
	autorest.Response `json:"-"`
	Value             *[]PublicIPAddress `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// PublicIPAddressListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PublicIPAddressListResult) PublicIPAddressListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PublicIPAddressPropertiesFormat is public IP address properties.
type PublicIPAddressPropertiesFormat struct {
	PublicIPAllocationMethod IPAllocationMethod          `json:"publicIPAllocationMethod,omitempty"`
	PublicIPAddressVersion   IPVersion                   `json:"publicIPAddressVersion,omitempty"`
	IPConfiguration          *IPConfiguration            `json:"ipConfiguration,omitempty"`
	DNSSettings              *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`
	IPAddress                *string                     `json:"ipAddress,omitempty"`
	IdleTimeoutInMinutes     *int32                      `json:"idleTimeoutInMinutes,omitempty"`
	ResourceGUID             *string                     `json:"resourceGuid,omitempty"`
	ProvisioningState        *string                     `json:"provisioningState,omitempty"`
}

// QueryTroubleshootingParameters is parameters that define the resource to
// query the troubleshooting result.
type QueryTroubleshootingParameters struct {
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceNavigationLink is resourceNavigationLink resource.
type ResourceNavigationLink struct {
	ID                            *string `json:"id,omitempty"`
	*ResourceNavigationLinkFormat `json:"properties,omitempty"`
	Name                          *string `json:"name,omitempty"`
	Etag                          *string `json:"etag,omitempty"`
}

// ResourceNavigationLinkFormat is properties of ResourceNavigationLink.
type ResourceNavigationLinkFormat struct {
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`
	Link               *string `json:"link,omitempty"`
	ProvisioningState  *string `json:"provisioningState,omitempty"`
}

// RetentionPolicyParameters is parameters that define the retention policy for
// flow log.
type RetentionPolicyParameters struct {
	Days    *int32 `json:"days,omitempty"`
	Enabled *bool  `json:"enabled,omitempty"`
}

// Route is route resource
type Route struct {
	autorest.Response      `json:"-"`
	ID                     *string `json:"id,omitempty"`
	*RoutePropertiesFormat `json:"properties,omitempty"`
	Name                   *string `json:"name,omitempty"`
	Etag                   *string `json:"etag,omitempty"`
}

// RouteFilter is route Filter Resource.
type RouteFilter struct {
	autorest.Response            `json:"-"`
	ID                           *string             `json:"id,omitempty"`
	Name                         *string             `json:"name,omitempty"`
	Type                         *string             `json:"type,omitempty"`
	Location                     *string             `json:"location,omitempty"`
	Tags                         *map[string]*string `json:"tags,omitempty"`
	*RouteFilterPropertiesFormat `json:"properties,omitempty"`
	Etag                         *string `json:"etag,omitempty"`
}

// RouteFilterListResult is response for the ListRouteFilters API service call.
type RouteFilterListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RouteFilter `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// RouteFilterListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RouteFilterListResult) RouteFilterListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RouteFilterPropertiesFormat is route Filter Resource
type RouteFilterPropertiesFormat struct {
	Rules             *[]RouteFilterRule            `json:"rules,omitempty"`
	Peerings          *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	ProvisioningState *string                       `json:"provisioningState,omitempty"`
}

// RouteFilterRule is route Filter Rule Resource
type RouteFilterRule struct {
	autorest.Response                `json:"-"`
	ID                               *string `json:"id,omitempty"`
	*RouteFilterRulePropertiesFormat `json:"properties,omitempty"`
	Name                             *string             `json:"name,omitempty"`
	Location                         *string             `json:"location,omitempty"`
	Etag                             *string             `json:"etag,omitempty"`
	Tags                             *map[string]*string `json:"tags,omitempty"`
}

// RouteFilterRuleListResult is response for the ListRouteFilterRules API
// service call
type RouteFilterRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RouteFilterRule `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// RouteFilterRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RouteFilterRuleListResult) RouteFilterRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RouteFilterRulePropertiesFormat is route Filter Rule Resource
type RouteFilterRulePropertiesFormat struct {
	Access              Access    `json:"access,omitempty"`
	RouteFilterRuleType *string   `json:"routeFilterRuleType,omitempty"`
	Communities         *[]string `json:"communities,omitempty"`
	ProvisioningState   *string   `json:"provisioningState,omitempty"`
}

// RouteListResult is response for the ListRoute API service call
type RouteListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Route `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// RouteListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RouteListResult) RouteListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RoutePropertiesFormat is route resource
type RoutePropertiesFormat struct {
	AddressPrefix     *string          `json:"addressPrefix,omitempty"`
	NextHopType       RouteNextHopType `json:"nextHopType,omitempty"`
	NextHopIPAddress  *string          `json:"nextHopIpAddress,omitempty"`
	ProvisioningState *string          `json:"provisioningState,omitempty"`
}

// RouteTable is route table resource.
type RouteTable struct {
	autorest.Response           `json:"-"`
	ID                          *string             `json:"id,omitempty"`
	Name                        *string             `json:"name,omitempty"`
	Type                        *string             `json:"type,omitempty"`
	Location                    *string             `json:"location,omitempty"`
	Tags                        *map[string]*string `json:"tags,omitempty"`
	*RouteTablePropertiesFormat `json:"properties,omitempty"`
	Etag                        *string `json:"etag,omitempty"`
}

// RouteTableListResult is response for the ListRouteTable API service call.
type RouteTableListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RouteTable `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// RouteTableListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RouteTableListResult) RouteTableListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RouteTablePropertiesFormat is route Table resource
type RouteTablePropertiesFormat struct {
	Routes            *[]Route  `json:"routes,omitempty"`
	Subnets           *[]Subnet `json:"subnets,omitempty"`
	ProvisioningState *string   `json:"provisioningState,omitempty"`
}

// SecurityGroup is networkSecurityGroup resource.
type SecurityGroup struct {
	autorest.Response              `json:"-"`
	ID                             *string             `json:"id,omitempty"`
	Name                           *string             `json:"name,omitempty"`
	Type                           *string             `json:"type,omitempty"`
	Location                       *string             `json:"location,omitempty"`
	Tags                           *map[string]*string `json:"tags,omitempty"`
	*SecurityGroupPropertiesFormat `json:"properties,omitempty"`
	Etag                           *string `json:"etag,omitempty"`
}

// SecurityGroupListResult is response for ListNetworkSecurityGroups API
// service call.
type SecurityGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SecurityGroup `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// SecurityGroupListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SecurityGroupListResult) SecurityGroupListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SecurityGroupNetworkInterface is network interface and all its associated
// security rules.
type SecurityGroupNetworkInterface struct {
	ID                       *string                   `json:"id,omitempty"`
	SecurityRuleAssociations *SecurityRuleAssociations `json:"securityRuleAssociations,omitempty"`
}

// SecurityGroupPropertiesFormat is network Security Group resource.
type SecurityGroupPropertiesFormat struct {
	SecurityRules        *[]SecurityRule `json:"securityRules,omitempty"`
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	NetworkInterfaces    *[]Interface    `json:"networkInterfaces,omitempty"`
	Subnets              *[]Subnet       `json:"subnets,omitempty"`
	ResourceGUID         *string         `json:"resourceGuid,omitempty"`
	ProvisioningState    *string         `json:"provisioningState,omitempty"`
}

// SecurityGroupViewParameters is parameters that define the VM to check
// security groups for.
type SecurityGroupViewParameters struct {
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// SecurityGroupViewResult is the information about security rules applied to
// the specified VM.
type SecurityGroupViewResult struct {
	autorest.Response `json:"-"`
	NetworkInterfaces *[]SecurityGroupNetworkInterface `json:"networkInterfaces,omitempty"`
}

// SecurityRule is network security rule.
type SecurityRule struct {
	autorest.Response             `json:"-"`
	ID                            *string `json:"id,omitempty"`
	*SecurityRulePropertiesFormat `json:"properties,omitempty"`
	Name                          *string `json:"name,omitempty"`
	Etag                          *string `json:"etag,omitempty"`
}

// SecurityRuleAssociations is all security rules associated with the network
// interface.
type SecurityRuleAssociations struct {
	NetworkInterfaceAssociation *InterfaceAssociation           `json:"networkInterfaceAssociation,omitempty"`
	SubnetAssociation           *SubnetAssociation              `json:"subnetAssociation,omitempty"`
	DefaultSecurityRules        *[]SecurityRule                 `json:"defaultSecurityRules,omitempty"`
	EffectiveSecurityRules      *[]EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`
}

// SecurityRuleListResult is response for ListSecurityRule API service call.
// Retrieves all security rules that belongs to a network security group.
type SecurityRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SecurityRule `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// SecurityRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SecurityRuleListResult) SecurityRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SecurityRulePropertiesFormat is
type SecurityRulePropertiesFormat struct {
	Description              *string               `json:"description,omitempty"`
	Protocol                 SecurityRuleProtocol  `json:"protocol,omitempty"`
	SourcePortRange          *string               `json:"sourcePortRange,omitempty"`
	DestinationPortRange     *string               `json:"destinationPortRange,omitempty"`
	SourceAddressPrefix      *string               `json:"sourceAddressPrefix,omitempty"`
	DestinationAddressPrefix *string               `json:"destinationAddressPrefix,omitempty"`
	Access                   SecurityRuleAccess    `json:"access,omitempty"`
	Priority                 *int32                `json:"priority,omitempty"`
	Direction                SecurityRuleDirection `json:"direction,omitempty"`
	ProvisioningState        *string               `json:"provisioningState,omitempty"`
}

// String is
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// Subnet is subnet in a virtual network resource.
type Subnet struct {
	autorest.Response       `json:"-"`
	ID                      *string `json:"id,omitempty"`
	*SubnetPropertiesFormat `json:"properties,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Etag                    *string `json:"etag,omitempty"`
}

// SubnetAssociation is network interface and its custom security rules.
type SubnetAssociation struct {
	ID            *string         `json:"id,omitempty"`
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// SubnetListResult is response for ListSubnets API service callRetrieves all
// subnet that belongs to a virtual network
type SubnetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Subnet `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// SubnetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SubnetListResult) SubnetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SubnetPropertiesFormat is
type SubnetPropertiesFormat struct {
	AddressPrefix           *string                   `json:"addressPrefix,omitempty"`
	NetworkSecurityGroup    *SecurityGroup            `json:"networkSecurityGroup,omitempty"`
	RouteTable              *RouteTable               `json:"routeTable,omitempty"`
	IPConfigurations        *[]IPConfiguration        `json:"ipConfigurations,omitempty"`
	ResourceNavigationLinks *[]ResourceNavigationLink `json:"resourceNavigationLinks,omitempty"`
	ProvisioningState       *string                   `json:"provisioningState,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// Topology is topology of the specified resource group.
type Topology struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	CreatedDateTime   *date.Time          `json:"createdDateTime,omitempty"`
	LastModified      *date.Time          `json:"lastModified,omitempty"`
	Resources         *[]TopologyResource `json:"resources,omitempty"`
}

// TopologyAssociation is resources that have an association with the parent
// resource.
type TopologyAssociation struct {
	Name            *string         `json:"name,omitempty"`
	ResourceID      *string         `json:"resourceId,omitempty"`
	AssociationType AssociationType `json:"associationType,omitempty"`
}

// TopologyParameters is parameters that define the representation of topology.
type TopologyParameters struct {
	TargetResourceGroupName *string `json:"targetResourceGroupName,omitempty"`
}

// TopologyResource is the network resource topology information for the given
// resource group.
type TopologyResource struct {
	Name         *string                `json:"name,omitempty"`
	ID           *string                `json:"id,omitempty"`
	Location     *string                `json:"location,omitempty"`
	Associations *[]TopologyAssociation `json:"associations,omitempty"`
}

// TroubleshootingDetails is information gained from troubleshooting of
// specified resource.
type TroubleshootingDetails struct {
	ID                 *string                              `json:"id,omitempty"`
	ReasonType         *string                              `json:"reasonType,omitempty"`
	Summary            *string                              `json:"summary,omitempty"`
	Detail             *string                              `json:"detail,omitempty"`
	RecommendedActions *[]TroubleshootingRecommendedActions `json:"recommendedActions,omitempty"`
}

// TroubleshootingParameters is parameters that define the resource to
// troubleshoot.
type TroubleshootingParameters struct {
	TargetResourceID           *string `json:"targetResourceId,omitempty"`
	*TroubleshootingProperties `json:"properties,omitempty"`
}

// TroubleshootingProperties is storage location provided for troubleshoot.
type TroubleshootingProperties struct {
	StorageID   *string `json:"storageId,omitempty"`
	StoragePath *string `json:"storagePath,omitempty"`
}

// TroubleshootingRecommendedActions is recommended actions based on discovered
// issues.
type TroubleshootingRecommendedActions struct {
	ActionID      *string `json:"actionId,omitempty"`
	ActionText    *string `json:"actionText,omitempty"`
	ActionURI     *string `json:"actionUri,omitempty"`
	ActionURIText *string `json:"actionUriText,omitempty"`
}

// TroubleshootingResult is troubleshooting information gained from specified
// resource.
type TroubleshootingResult struct {
	autorest.Response `json:"-"`
	StartTime         *date.Time                `json:"startTime,omitempty"`
	EndTime           *date.Time                `json:"endTime,omitempty"`
	Code              *string                   `json:"code,omitempty"`
	Results           *[]TroubleshootingDetails `json:"results,omitempty"`
}

// TunnelConnectionHealth is virtualNetworkGatewayConnection properties
type TunnelConnectionHealth struct {
	Tunnel                           *string                               `json:"tunnel,omitempty"`
	ConnectionStatus                 VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	IngressBytesTransferred          *int64                                `json:"ingressBytesTransferred,omitempty"`
	EgressBytesTransferred           *int64                                `json:"egressBytesTransferred,omitempty"`
	LastConnectionEstablishedUtcTime *string                               `json:"lastConnectionEstablishedUtcTime,omitempty"`
}

// Usage is describes network resource usage.
type Usage struct {
	Unit         *string    `json:"unit,omitempty"`
	CurrentValue *int64     `json:"currentValue,omitempty"`
	Limit        *int64     `json:"limit,omitempty"`
	Name         *UsageName `json:"name,omitempty"`
}

// UsageName is the usage names.
type UsageName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsagesListResult is the list usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// UsagesListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client UsagesListResult) UsagesListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VerificationIPFlowParameters is parameters that define the IP flow to be
// verified.
type VerificationIPFlowParameters struct {
	TargetResourceID    *string   `json:"targetResourceId,omitempty"`
	Direction           Direction `json:"direction,omitempty"`
	Protocol            Protocol  `json:"protocol,omitempty"`
	LocalPort           *string   `json:"localPort,omitempty"`
	RemotePort          *string   `json:"remotePort,omitempty"`
	LocalIPAddress      *string   `json:"localIPAddress,omitempty"`
	RemoteIPAddress     *string   `json:"remoteIPAddress,omitempty"`
	TargetNicResourceID *string   `json:"targetNicResourceId,omitempty"`
}

// VerificationIPFlowResult is results of IP flow verification on the target
// resource.
type VerificationIPFlowResult struct {
	autorest.Response `json:"-"`
	Access            Access  `json:"access,omitempty"`
	RuleName          *string `json:"ruleName,omitempty"`
}

// VirtualNetwork is virtual Network resource.
type VirtualNetwork struct {
	autorest.Response               `json:"-"`
	ID                              *string             `json:"id,omitempty"`
	Name                            *string             `json:"name,omitempty"`
	Type                            *string             `json:"type,omitempty"`
	Location                        *string             `json:"location,omitempty"`
	Tags                            *map[string]*string `json:"tags,omitempty"`
	*VirtualNetworkPropertiesFormat `json:"properties,omitempty"`
	Etag                            *string `json:"etag,omitempty"`
}

// VirtualNetworkGateway is a common class for general resource information
type VirtualNetworkGateway struct {
	autorest.Response                      `json:"-"`
	ID                                     *string             `json:"id,omitempty"`
	Name                                   *string             `json:"name,omitempty"`
	Type                                   *string             `json:"type,omitempty"`
	Location                               *string             `json:"location,omitempty"`
	Tags                                   *map[string]*string `json:"tags,omitempty"`
	*VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	Etag                                   *string `json:"etag,omitempty"`
}

// VirtualNetworkGatewayConnection is a common class for general resource
// information
type VirtualNetworkGatewayConnection struct {
	autorest.Response                                `json:"-"`
	ID                                               *string             `json:"id,omitempty"`
	Name                                             *string             `json:"name,omitempty"`
	Type                                             *string             `json:"type,omitempty"`
	Location                                         *string             `json:"location,omitempty"`
	Tags                                             *map[string]*string `json:"tags,omitempty"`
	*VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`
	Etag                                             *string `json:"etag,omitempty"`
}

// VirtualNetworkGatewayConnectionListResult is response for the
// ListVirtualNetworkGatewayConnections API service call
type VirtualNetworkGatewayConnectionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkGatewayConnection `json:"value,omitempty"`
	NextLink          *string                            `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayConnectionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkGatewayConnectionListResult) VirtualNetworkGatewayConnectionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkGatewayConnectionPropertiesFormat is
// virtualNetworkGatewayConnection properties
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	AuthorizationKey               *string                               `json:"authorizationKey,omitempty"`
	VirtualNetworkGateway1         *VirtualNetworkGateway                `json:"virtualNetworkGateway1,omitempty"`
	VirtualNetworkGateway2         *VirtualNetworkGateway                `json:"virtualNetworkGateway2,omitempty"`
	LocalNetworkGateway2           *LocalNetworkGateway                  `json:"localNetworkGateway2,omitempty"`
	ConnectionType                 VirtualNetworkGatewayConnectionType   `json:"connectionType,omitempty"`
	RoutingWeight                  *int32                                `json:"routingWeight,omitempty"`
	SharedKey                      *string                               `json:"sharedKey,omitempty"`
	ConnectionStatus               VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	TunnelConnectionStatus         *[]TunnelConnectionHealth             `json:"tunnelConnectionStatus,omitempty"`
	EgressBytesTransferred         *int64                                `json:"egressBytesTransferred,omitempty"`
	IngressBytesTransferred        *int64                                `json:"ingressBytesTransferred,omitempty"`
	Peer                           *SubResource                          `json:"peer,omitempty"`
	EnableBgp                      *bool                                 `json:"enableBgp,omitempty"`
	UsePolicyBasedTrafficSelectors *bool                                 `json:"usePolicyBasedTrafficSelectors,omitempty"`
	IpsecPolicies                  *[]IpsecPolicy                        `json:"ipsecPolicies,omitempty"`
	ResourceGUID                   *string                               `json:"resourceGuid,omitempty"`
	ProvisioningState              *string                               `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayIPConfiguration is iP configuration for virtual network
// gateway
type VirtualNetworkGatewayIPConfiguration struct {
	ID                                                    *string `json:"id,omitempty"`
	*VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	Name                                                  *string `json:"name,omitempty"`
	Etag                                                  *string `json:"etag,omitempty"`
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat is properties of
// VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *SubResource       `json:"subnet,omitempty"`
	PublicIPAddress           *SubResource       `json:"publicIPAddress,omitempty"`
	ProvisioningState         *string            `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayListResult is response for the
// ListVirtualNetworkGateways API service call.
type VirtualNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkGateway `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkGatewayListResult) VirtualNetworkGatewayListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkGatewayPropertiesFormat is virtualNetworkGateway properties
type VirtualNetworkGatewayPropertiesFormat struct {
	IPConfigurations       *[]VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`
	GatewayType            VirtualNetworkGatewayType               `json:"gatewayType,omitempty"`
	VpnType                VpnType                                 `json:"vpnType,omitempty"`
	EnableBgp              *bool                                   `json:"enableBgp,omitempty"`
	ActiveActive           *bool                                   `json:"activeActive,omitempty"`
	GatewayDefaultSite     *SubResource                            `json:"gatewayDefaultSite,omitempty"`
	Sku                    *VirtualNetworkGatewaySku               `json:"sku,omitempty"`
	VpnClientConfiguration *VpnClientConfiguration                 `json:"vpnClientConfiguration,omitempty"`
	BgpSettings            *BgpSettings                            `json:"bgpSettings,omitempty"`
	ResourceGUID           *string                                 `json:"resourceGuid,omitempty"`
	ProvisioningState      *string                                 `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewaySku is virtualNetworkGatewaySku details
type VirtualNetworkGatewaySku struct {
	Name     VirtualNetworkGatewaySkuName `json:"name,omitempty"`
	Tier     VirtualNetworkGatewaySkuTier `json:"tier,omitempty"`
	Capacity *int32                       `json:"capacity,omitempty"`
}

// VirtualNetworkListResult is response for the ListVirtualNetworks API service
// call.
type VirtualNetworkListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetwork `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// VirtualNetworkListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkListResult) VirtualNetworkListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkPeering is peerings in a virtual network resource.
type VirtualNetworkPeering struct {
	autorest.Response                      `json:"-"`
	ID                                     *string `json:"id,omitempty"`
	*VirtualNetworkPeeringPropertiesFormat `json:"properties,omitempty"`
	Name                                   *string `json:"name,omitempty"`
	Etag                                   *string `json:"etag,omitempty"`
}

// VirtualNetworkPeeringListResult is response for ListSubnets API service
// call. Retrieves all subnets that belong to a virtual network.
type VirtualNetworkPeeringListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkPeering `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// VirtualNetworkPeeringListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkPeeringListResult) VirtualNetworkPeeringListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkPeeringPropertiesFormat is
type VirtualNetworkPeeringPropertiesFormat struct {
	AllowVirtualNetworkAccess *bool                      `json:"allowVirtualNetworkAccess,omitempty"`
	AllowForwardedTraffic     *bool                      `json:"allowForwardedTraffic,omitempty"`
	AllowGatewayTransit       *bool                      `json:"allowGatewayTransit,omitempty"`
	UseRemoteGateways         *bool                      `json:"useRemoteGateways,omitempty"`
	RemoteVirtualNetwork      *SubResource               `json:"remoteVirtualNetwork,omitempty"`
	PeeringState              VirtualNetworkPeeringState `json:"peeringState,omitempty"`
	ProvisioningState         *string                    `json:"provisioningState,omitempty"`
}

// VirtualNetworkPropertiesFormat is
type VirtualNetworkPropertiesFormat struct {
	AddressSpace           *AddressSpace            `json:"addressSpace,omitempty"`
	DhcpOptions            *DhcpOptions             `json:"dhcpOptions,omitempty"`
	Subnets                *[]Subnet                `json:"subnets,omitempty"`
	VirtualNetworkPeerings *[]VirtualNetworkPeering `json:"virtualNetworkPeerings,omitempty"`
	ResourceGUID           *string                  `json:"resourceGuid,omitempty"`
	ProvisioningState      *string                  `json:"provisioningState,omitempty"`
}

// VpnClientConfiguration is vpnClientConfiguration for P2S client.
type VpnClientConfiguration struct {
	VpnClientAddressPool         *AddressSpace                  `json:"vpnClientAddressPool,omitempty"`
	VpnClientRootCertificates    *[]VpnClientRootCertificate    `json:"vpnClientRootCertificates,omitempty"`
	VpnClientRevokedCertificates *[]VpnClientRevokedCertificate `json:"vpnClientRevokedCertificates,omitempty"`
}

// VpnClientParameters is vpn Client Parameters for package generation
type VpnClientParameters struct {
	ProcessorArchitecture ProcessorArchitecture `json:"processorArchitecture,omitempty"`
}

// VpnClientRevokedCertificate is vPN client revoked certificate of virtual
// network gateway.
type VpnClientRevokedCertificate struct {
	ID                                           *string `json:"id,omitempty"`
	*VpnClientRevokedCertificatePropertiesFormat `json:"properties,omitempty"`
	Name                                         *string `json:"name,omitempty"`
	Etag                                         *string `json:"etag,omitempty"`
}

// VpnClientRevokedCertificatePropertiesFormat is properties of the revoked VPN
// client certificate of virtual network gateway.
type VpnClientRevokedCertificatePropertiesFormat struct {
	Thumbprint        *string `json:"thumbprint,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VpnClientRootCertificate is vPN client root certificate of virtual network
// gateway
type VpnClientRootCertificate struct {
	ID                                        *string `json:"id,omitempty"`
	*VpnClientRootCertificatePropertiesFormat `json:"properties,omitempty"`
	Name                                      *string `json:"name,omitempty"`
	Etag                                      *string `json:"etag,omitempty"`
}

// VpnClientRootCertificatePropertiesFormat is properties of SSL certificates
// of application gateway
type VpnClientRootCertificatePropertiesFormat struct {
	PublicCertData    *string `json:"publicCertData,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Watcher is network watcher in a resource group.
type Watcher struct {
	autorest.Response        `json:"-"`
	ID                       *string             `json:"id,omitempty"`
	Name                     *string             `json:"name,omitempty"`
	Type                     *string             `json:"type,omitempty"`
	Location                 *string             `json:"location,omitempty"`
	Tags                     *map[string]*string `json:"tags,omitempty"`
	Etag                     *string             `json:"etag,omitempty"`
	*WatcherPropertiesFormat `json:"properties,omitempty"`
}

// WatcherListResult is list of network watcher resources.
type WatcherListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Watcher `json:"value,omitempty"`
}

// WatcherPropertiesFormat is the network watcher properties.
type WatcherPropertiesFormat struct {
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}
