package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// AppServiceEnvironmentsClient is the composite Swagger for WebSite Management
// Client
type AppServiceEnvironmentsClient struct {
	ManagementClient
}

// NewAppServiceEnvironmentsClient creates an instance of the
// AppServiceEnvironmentsClient client.
func NewAppServiceEnvironmentsClient(subscriptionID string) AppServiceEnvironmentsClient {
	return NewAppServiceEnvironmentsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAppServiceEnvironmentsClientWithBaseURI creates an instance of the
// AppServiceEnvironmentsClient client.
func NewAppServiceEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) AppServiceEnvironmentsClient {
	return AppServiceEnvironmentsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate create or update an App Service Environment. This method may
// poll for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
// hostingEnvironmentEnvelope is configuration details of the App Service
// Environment.
func (client AppServiceEnvironmentsClient) CreateOrUpdate(resourceGroupName string, name string, hostingEnvironmentEnvelope AppServiceEnvironmentResource, cancel <-chan struct{}) (<-chan AppServiceEnvironmentResource, <-chan error) {
	resultChan := make(chan AppServiceEnvironmentResource, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: hostingEnvironmentEnvelope,
			Constraints: []validation.Constraint{{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment.Name", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment.Location", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment.VirtualNetwork", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment.WorkerPools", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdate")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result AppServiceEnvironmentResource
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdatePreparer(resourceGroupName, name, hostingEnvironmentEnvelope, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdate", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdate", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client AppServiceEnvironmentsClient) CreateOrUpdatePreparer(resourceGroupName string, name string, hostingEnvironmentEnvelope AppServiceEnvironmentResource, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithJSON(hostingEnvironmentEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) CreateOrUpdateResponder(resp *http.Response) (result AppServiceEnvironmentResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateMultiRolePool create or update a multi-role pool. This method
// may poll for completion. Polling can be canceled by passing the cancel
// channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. multiRolePoolEnvelope
// is properties of the multi-role pool.
func (client AppServiceEnvironmentsClient) CreateOrUpdateMultiRolePool(resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, cancel <-chan struct{}) (<-chan WorkerPoolResource, <-chan error) {
	resultChan := make(chan WorkerPoolResource, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateMultiRolePool")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result WorkerPoolResource
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateMultiRolePoolPreparer(resourceGroupName, name, multiRolePoolEnvelope, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateMultiRolePool", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateMultiRolePoolSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateMultiRolePool", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateMultiRolePoolResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateMultiRolePool", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateMultiRolePoolPreparer prepares the CreateOrUpdateMultiRolePool request.
func (client AppServiceEnvironmentsClient) CreateOrUpdateMultiRolePoolPreparer(resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithJSON(multiRolePoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateMultiRolePoolSender sends the CreateOrUpdateMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) CreateOrUpdateMultiRolePoolSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateMultiRolePoolResponder handles the response to the CreateOrUpdateMultiRolePool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) CreateOrUpdateMultiRolePoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateWorkerPool create or update a worker pool. This method may
// poll for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. workerPoolName is name
// of the worker pool. workerPoolEnvelope is properties of the worker pool.
func (client AppServiceEnvironmentsClient) CreateOrUpdateWorkerPool(resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, cancel <-chan struct{}) (<-chan WorkerPoolResource, <-chan error) {
	resultChan := make(chan WorkerPoolResource, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateWorkerPool")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result WorkerPoolResource
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateWorkerPoolPreparer(resourceGroupName, name, workerPoolName, workerPoolEnvelope, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateWorkerPool", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateWorkerPoolSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateWorkerPool", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateWorkerPoolResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateWorkerPool", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateWorkerPoolPreparer prepares the CreateOrUpdateWorkerPool request.
func (client AppServiceEnvironmentsClient) CreateOrUpdateWorkerPoolPreparer(resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithJSON(workerPoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateWorkerPoolSender sends the CreateOrUpdateWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) CreateOrUpdateWorkerPoolSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateWorkerPoolResponder handles the response to the CreateOrUpdateWorkerPool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) CreateOrUpdateWorkerPoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an App Service Environment. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. forceDelete is specify
// <code>true</code> to force the deletion even if the App Service Environment
// contains resources. The default is <code>false</code>.
func (client AppServiceEnvironmentsClient) Delete(resourceGroupName string, name string, forceDelete *bool, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "Delete")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result autorest.Response
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.DeletePreparer(resourceGroupName, name, forceDelete, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Delete", nil, "Failure preparing request")
			return
		}

		resp, err := client.DeleteSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Delete", resp, "Failure sending request")
			return
		}

		result, err = client.DeleteResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Delete", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// DeletePreparer prepares the Delete request.
func (client AppServiceEnvironmentsClient) DeletePreparer(resourceGroupName string, name string, forceDelete *bool, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if forceDelete != nil {
		queryParameters["forceDelete"] = autorest.Encode("query", *forceDelete)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get the properties of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) Get(resourceGroupName string, name string) (result AppServiceEnvironmentResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "Get")
	}

	req, err := client.GetPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppServiceEnvironmentsClient) GetPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetResponder(resp *http.Response) (result AppServiceEnvironmentResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDiagnosticsItem get a diagnostics item for an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. diagnosticsName is
// name of the diagnostics item.
func (client AppServiceEnvironmentsClient) GetDiagnosticsItem(resourceGroupName string, name string, diagnosticsName string) (result HostingEnvironmentDiagnostics, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "GetDiagnosticsItem")
	}

	req, err := client.GetDiagnosticsItemPreparer(resourceGroupName, name, diagnosticsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetDiagnosticsItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDiagnosticsItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetDiagnosticsItem", resp, "Failure sending request")
		return
	}

	result, err = client.GetDiagnosticsItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetDiagnosticsItem", resp, "Failure responding to request")
	}

	return
}

// GetDiagnosticsItemPreparer prepares the GetDiagnosticsItem request.
func (client AppServiceEnvironmentsClient) GetDiagnosticsItemPreparer(resourceGroupName string, name string, diagnosticsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticsName":   autorest.Encode("path", diagnosticsName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDiagnosticsItemSender sends the GetDiagnosticsItem request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetDiagnosticsItemSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDiagnosticsItemResponder handles the response to the GetDiagnosticsItem request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetDiagnosticsItemResponder(resp *http.Response) (result HostingEnvironmentDiagnostics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePool get properties of a multi-role pool.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) GetMultiRolePool(resourceGroupName string, name string) (result WorkerPoolResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "GetMultiRolePool")
	}

	req, err := client.GetMultiRolePoolPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetMultiRolePool", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMultiRolePoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetMultiRolePool", resp, "Failure sending request")
		return
	}

	result, err = client.GetMultiRolePoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetMultiRolePool", resp, "Failure responding to request")
	}

	return
}

// GetMultiRolePoolPreparer prepares the GetMultiRolePool request.
func (client AppServiceEnvironmentsClient) GetMultiRolePoolPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMultiRolePoolSender sends the GetMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetMultiRolePoolSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetMultiRolePoolResponder handles the response to the GetMultiRolePool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetMultiRolePoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPool get properties of a worker pool.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. workerPoolName is name
// of the worker pool.
func (client AppServiceEnvironmentsClient) GetWorkerPool(resourceGroupName string, name string, workerPoolName string) (result WorkerPoolResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "GetWorkerPool")
	}

	req, err := client.GetWorkerPoolPreparer(resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetWorkerPool", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWorkerPoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetWorkerPool", resp, "Failure sending request")
		return
	}

	result, err = client.GetWorkerPoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetWorkerPool", resp, "Failure responding to request")
	}

	return
}

// GetWorkerPoolPreparer prepares the GetWorkerPool request.
func (client AppServiceEnvironmentsClient) GetWorkerPoolPreparer(resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetWorkerPoolSender sends the GetWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetWorkerPoolSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetWorkerPoolResponder handles the response to the GetWorkerPool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetWorkerPoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all App Service Environments for a subscription.
func (client AppServiceEnvironmentsClient) List() (result AppServiceEnvironmentCollection, err error) {
	req, err := client.ListPreparer()
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppServiceEnvironmentsClient) ListPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/hostingEnvironments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListResponder(resp *http.Response) (result AppServiceEnvironmentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListNextResults(lastResults AppServiceEnvironmentCollection) (result AppServiceEnvironmentCollection, err error) {
	req, err := lastResults.AppServiceEnvironmentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", resp, "Failure sending next results request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", resp, "Failure responding to next results request")
	}

	return
}

// ListAppServicePlans get all App Service plans in an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListAppServicePlans(resourceGroupName string, name string) (result AppServicePlanCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans")
	}

	req, err := client.ListAppServicePlansPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAppServicePlansSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", resp, "Failure sending request")
		return
	}

	result, err = client.ListAppServicePlansResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", resp, "Failure responding to request")
	}

	return
}

// ListAppServicePlansPreparer prepares the ListAppServicePlans request.
func (client AppServiceEnvironmentsClient) ListAppServicePlansPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListAppServicePlansSender sends the ListAppServicePlans request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListAppServicePlansSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListAppServicePlansResponder handles the response to the ListAppServicePlans request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListAppServicePlansResponder(resp *http.Response) (result AppServicePlanCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAppServicePlansNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListAppServicePlansNextResults(lastResults AppServicePlanCollection) (result AppServicePlanCollection, err error) {
	req, err := lastResults.AppServicePlanCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListAppServicePlansSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", resp, "Failure sending next results request")
	}

	result, err = client.ListAppServicePlansResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", resp, "Failure responding to next results request")
	}

	return
}

// ListByResourceGroup get all App Service Environments in a resource group.
//
// resourceGroupName is name of the resource group to which the resource
// belongs.
func (client AppServiceEnvironmentsClient) ListByResourceGroup(resourceGroupName string) (result AppServiceEnvironmentCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup")
	}

	req, err := client.ListByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AppServiceEnvironmentsClient) ListByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListByResourceGroupResponder(resp *http.Response) (result AppServiceEnvironmentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListByResourceGroupNextResults(lastResults AppServiceEnvironmentCollection) (result AppServiceEnvironmentCollection, err error) {
	req, err := lastResults.AppServiceEnvironmentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", resp, "Failure sending next results request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", resp, "Failure responding to next results request")
	}

	return
}

// ListCapacities get the used, available, and total worker capacity an App
// Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListCapacities(resourceGroupName string, name string) (result StampCapacityCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListCapacities")
	}

	req, err := client.ListCapacitiesPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCapacitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCapacitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", resp, "Failure responding to request")
	}

	return
}

// ListCapacitiesPreparer prepares the ListCapacities request.
func (client AppServiceEnvironmentsClient) ListCapacitiesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListCapacitiesSender sends the ListCapacities request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListCapacitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListCapacitiesResponder handles the response to the ListCapacities request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListCapacitiesResponder(resp *http.Response) (result StampCapacityCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCapacitiesNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListCapacitiesNextResults(lastResults StampCapacityCollection) (result StampCapacityCollection, err error) {
	req, err := lastResults.StampCapacityCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListCapacitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", resp, "Failure sending next results request")
	}

	result, err = client.ListCapacitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", resp, "Failure responding to next results request")
	}

	return
}

// ListDiagnostics get diagnostic information for an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListDiagnostics(resourceGroupName string, name string) (result ListHostingEnvironmentDiagnostics, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListDiagnostics")
	}

	req, err := client.ListDiagnosticsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListDiagnostics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDiagnosticsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListDiagnostics", resp, "Failure sending request")
		return
	}

	result, err = client.ListDiagnosticsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListDiagnostics", resp, "Failure responding to request")
	}

	return
}

// ListDiagnosticsPreparer prepares the ListDiagnostics request.
func (client AppServiceEnvironmentsClient) ListDiagnosticsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDiagnosticsSender sends the ListDiagnostics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListDiagnosticsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListDiagnosticsResponder handles the response to the ListDiagnostics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListDiagnosticsResponder(resp *http.Response) (result ListHostingEnvironmentDiagnostics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinitions get global metric definitions of an App Service
// Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMetricDefinitions(resourceGroupName string, name string) (result MetricDefinition, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMetricDefinitions")
	}

	req, err := client.ListMetricDefinitionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefinitionsPreparer prepares the ListMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListMetricDefinitionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricDefinitionsSender sends the ListMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetricDefinitionsResponder handles the response to the ListMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMetricDefinitionsResponder(resp *http.Response) (result MetricDefinition, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetrics get global metrics of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. details is specify
// <code>true</code> to include instance details. The default is
// <code>false</code>. filter is return only usages/metrics specified in the
// filter. Filter conforms to odata syntax. Example: $filter=(name.value eq
// 'Metric1' or name.value eq 'Metric2') and startTime eq
// '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain
// eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListMetrics(resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMetrics")
	}

	req, err := client.ListMetricsPreparer(resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMetricsPreparer prepares the ListMetrics request.
func (client AppServiceEnvironmentsClient) ListMetricsPreparer(resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricsSender sends the ListMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetricsResponder handles the response to the ListMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", resp, "Failure responding to next results request")
	}

	return
}

// ListMultiRoleMetricDefinitions get metric definitions for a multi-role pool
// of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitions(resourceGroupName string, name string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions")
	}

	req, err := client.ListMultiRoleMetricDefinitionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRoleMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListMultiRoleMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListMultiRoleMetricDefinitionsPreparer prepares the ListMultiRoleMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMultiRoleMetricDefinitionsSender sends the ListMultiRoleMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMultiRoleMetricDefinitionsResponder handles the response to the ListMultiRoleMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMultiRoleMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitionsNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMultiRoleMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", resp, "Failure sending next results request")
	}

	result, err = client.ListMultiRoleMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", resp, "Failure responding to next results request")
	}

	return
}

// ListMultiRoleMetrics get metrics for a multi-role pool of an App Service
// Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. startTime is beginning
// time of the metrics query. endTime is end time of the metrics query.
// timeGrain is time granularity of the metrics query. details is specify
// <code>true</code> to include instance details. The default is
// <code>false</code>. filter is return only usages/metrics specified in the
// filter. Filter conforms to odata syntax. Example: $filter=(name.value eq
// 'Metric1' or name.value eq 'Metric2') and startTime eq
// '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain
// eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetrics(resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics")
	}

	req, err := client.ListMultiRoleMetricsPreparer(resourceGroupName, name, startTime, endTime, timeGrain, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRoleMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListMultiRoleMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMultiRoleMetricsPreparer prepares the ListMultiRoleMetrics request.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricsPreparer(resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(startTime) > 0 {
		queryParameters["startTime"] = autorest.Encode("query", startTime)
	}
	if len(endTime) > 0 {
		queryParameters["endTime"] = autorest.Encode("query", endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMultiRoleMetricsSender sends the ListMultiRoleMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMultiRoleMetricsResponder handles the response to the ListMultiRoleMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMultiRoleMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMultiRoleMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", resp, "Failure sending next results request")
	}

	result, err = client.ListMultiRoleMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", resp, "Failure responding to next results request")
	}

	return
}

// ListMultiRolePoolInstanceMetricDefinitions get metric definitions for a
// specific instance of a multi-role pool of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. instance is name of
// the instance in the multi-role pool.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitions(resourceGroupName string, name string, instance string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions")
	}

	req, err := client.ListMultiRolePoolInstanceMetricDefinitionsPreparer(resourceGroupName, name, instance)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRolePoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListMultiRolePoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListMultiRolePoolInstanceMetricDefinitionsPreparer prepares the ListMultiRolePoolInstanceMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitionsPreparer(resourceGroupName string, name string, instance string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMultiRolePoolInstanceMetricDefinitionsSender sends the ListMultiRolePoolInstanceMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMultiRolePoolInstanceMetricDefinitionsResponder handles the response to the ListMultiRolePoolInstanceMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMultiRolePoolInstanceMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitionsNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMultiRolePoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", resp, "Failure sending next results request")
	}

	result, err = client.ListMultiRolePoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", resp, "Failure responding to next results request")
	}

	return
}

// ListMultiRolePoolInstanceMetrics get metrics for a specific instance of a
// multi-role pool of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. instance is name of
// the instance in the multi-role pool. details is specify <code>true</code> to
// include instance details. The default is <code>false</code>.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetrics(resourceGroupName string, name string, instance string, details *bool) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics")
	}

	req, err := client.ListMultiRolePoolInstanceMetricsPreparer(resourceGroupName, name, instance, details)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRolePoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListMultiRolePoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMultiRolePoolInstanceMetricsPreparer prepares the ListMultiRolePoolInstanceMetrics request.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricsPreparer(resourceGroupName string, name string, instance string, details *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMultiRolePoolInstanceMetricsSender sends the ListMultiRolePoolInstanceMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMultiRolePoolInstanceMetricsResponder handles the response to the ListMultiRolePoolInstanceMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMultiRolePoolInstanceMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMultiRolePoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", resp, "Failure sending next results request")
	}

	result, err = client.ListMultiRolePoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", resp, "Failure responding to next results request")
	}

	return
}

// ListMultiRolePools get all multi-role pools.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMultiRolePools(resourceGroupName string, name string) (result WorkerPoolCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools")
	}

	req, err := client.ListMultiRolePoolsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRolePoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", resp, "Failure sending request")
		return
	}

	result, err = client.ListMultiRolePoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", resp, "Failure responding to request")
	}

	return
}

// ListMultiRolePoolsPreparer prepares the ListMultiRolePools request.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMultiRolePoolsSender sends the ListMultiRolePools request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMultiRolePoolsResponder handles the response to the ListMultiRolePools request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolsResponder(resp *http.Response) (result WorkerPoolCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMultiRolePoolsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolsNextResults(lastResults WorkerPoolCollection) (result WorkerPoolCollection, err error) {
	req, err := lastResults.WorkerPoolCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMultiRolePoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", resp, "Failure sending next results request")
	}

	result, err = client.ListMultiRolePoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", resp, "Failure responding to next results request")
	}

	return
}

// ListMultiRolePoolSkus get available SKUs for scaling a multi-role pool.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkus(resourceGroupName string, name string) (result SkuInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus")
	}

	req, err := client.ListMultiRolePoolSkusPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRolePoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", resp, "Failure sending request")
		return
	}

	result, err = client.ListMultiRolePoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", resp, "Failure responding to request")
	}

	return
}

// ListMultiRolePoolSkusPreparer prepares the ListMultiRolePoolSkus request.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkusPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMultiRolePoolSkusSender sends the ListMultiRolePoolSkus request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMultiRolePoolSkusResponder handles the response to the ListMultiRolePoolSkus request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkusResponder(resp *http.Response) (result SkuInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMultiRolePoolSkusNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkusNextResults(lastResults SkuInfoCollection) (result SkuInfoCollection, err error) {
	req, err := lastResults.SkuInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMultiRolePoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", resp, "Failure sending next results request")
	}

	result, err = client.ListMultiRolePoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", resp, "Failure responding to next results request")
	}

	return
}

// ListMultiRoleUsages get usage metrics for a multi-role pool of an App
// Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsages(resourceGroupName string, name string) (result UsageCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages")
	}

	req, err := client.ListMultiRoleUsagesPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRoleUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", resp, "Failure sending request")
		return
	}

	result, err = client.ListMultiRoleUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", resp, "Failure responding to request")
	}

	return
}

// ListMultiRoleUsagesPreparer prepares the ListMultiRoleUsages request.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsagesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMultiRoleUsagesSender sends the ListMultiRoleUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMultiRoleUsagesResponder handles the response to the ListMultiRoleUsages request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsagesResponder(resp *http.Response) (result UsageCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMultiRoleUsagesNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsagesNextResults(lastResults UsageCollection) (result UsageCollection, err error) {
	req, err := lastResults.UsageCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMultiRoleUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", resp, "Failure sending next results request")
	}

	result, err = client.ListMultiRoleUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", resp, "Failure responding to next results request")
	}

	return
}

// ListOperations list all currently running operations on the App Service
// Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListOperations(resourceGroupName string, name string) (result ListOperation, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListOperations")
	}

	req, err := client.ListOperationsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListOperations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOperationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListOperations", resp, "Failure sending request")
		return
	}

	result, err = client.ListOperationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListOperations", resp, "Failure responding to request")
	}

	return
}

// ListOperationsPreparer prepares the ListOperations request.
func (client AppServiceEnvironmentsClient) ListOperationsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListOperationsSender sends the ListOperations request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListOperationsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListOperationsResponder handles the response to the ListOperations request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListOperationsResponder(resp *http.Response) (result ListOperation, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsages get global usage metrics of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. filter is return only
// usages/metrics specified in the filter. Filter conforms to odata syntax.
// Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and
// startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z'
// and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListUsages(resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListUsages")
	}

	req, err := client.ListUsagesPreparer(resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", resp, "Failure sending request")
		return
	}

	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", resp, "Failure responding to request")
	}

	return
}

// ListUsagesPreparer prepares the ListUsages request.
func (client AppServiceEnvironmentsClient) ListUsagesPreparer(resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListUsagesSender sends the ListUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListUsagesResponder handles the response to the ListUsages request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsagesNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListUsagesNextResults(lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.CsmUsageQuotaCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", resp, "Failure sending next results request")
	}

	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", resp, "Failure responding to next results request")
	}

	return
}

// ListVips get IP addresses assigned to an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListVips(resourceGroupName string, name string) (result AddressResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListVips")
	}

	req, err := client.ListVipsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListVips", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVipsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListVips", resp, "Failure sending request")
		return
	}

	result, err = client.ListVipsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListVips", resp, "Failure responding to request")
	}

	return
}

// ListVipsPreparer prepares the ListVips request.
func (client AppServiceEnvironmentsClient) ListVipsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListVipsSender sends the ListVips request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListVipsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListVipsResponder handles the response to the ListVips request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListVipsResponder(resp *http.Response) (result AddressResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebApps get all apps in an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. propertiesToInclude is
// comma separated list of app properties to include.
func (client AppServiceEnvironmentsClient) ListWebApps(resourceGroupName string, name string, propertiesToInclude string) (result AppCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListWebApps")
	}

	req, err := client.ListWebAppsPreparer(resourceGroupName, name, propertiesToInclude)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebAppsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", resp, "Failure sending request")
		return
	}

	result, err = client.ListWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", resp, "Failure responding to request")
	}

	return
}

// ListWebAppsPreparer prepares the ListWebApps request.
func (client AppServiceEnvironmentsClient) ListWebAppsPreparer(resourceGroupName string, name string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWebAppsSender sends the ListWebApps request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWebAppsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListWebAppsResponder handles the response to the ListWebApps request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWebAppsResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebAppsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListWebAppsNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWebAppsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", resp, "Failure sending next results request")
	}

	result, err = client.ListWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", resp, "Failure responding to next results request")
	}

	return
}

// ListWebWorkerMetricDefinitions get metric definitions for a worker pool of
// an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. workerPoolName is name
// of the worker pool.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitions(resourceGroupName string, name string, workerPoolName string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions")
	}

	req, err := client.ListWebWorkerMetricDefinitionsPreparer(resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebWorkerMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListWebWorkerMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListWebWorkerMetricDefinitionsPreparer prepares the ListWebWorkerMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitionsPreparer(resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWebWorkerMetricDefinitionsSender sends the ListWebWorkerMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListWebWorkerMetricDefinitionsResponder handles the response to the ListWebWorkerMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebWorkerMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitionsNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWebWorkerMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", resp, "Failure sending next results request")
	}

	result, err = client.ListWebWorkerMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", resp, "Failure responding to next results request")
	}

	return
}

// ListWebWorkerMetrics get metrics for a worker pool of a
// AppServiceEnvironment (App Service Environment).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. workerPoolName is name
// of worker pool details is specify <code>true</code> to include instance
// details. The default is <code>false</code>. filter is return only
// usages/metrics specified in the filter. Filter conforms to odata syntax.
// Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and
// startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z'
// and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetrics(resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics")
	}

	req, err := client.ListWebWorkerMetricsPreparer(resourceGroupName, name, workerPoolName, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebWorkerMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListWebWorkerMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", resp, "Failure responding to request")
	}

	return
}

// ListWebWorkerMetricsPreparer prepares the ListWebWorkerMetrics request.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricsPreparer(resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWebWorkerMetricsSender sends the ListWebWorkerMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListWebWorkerMetricsResponder handles the response to the ListWebWorkerMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebWorkerMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWebWorkerMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", resp, "Failure sending next results request")
	}

	result, err = client.ListWebWorkerMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", resp, "Failure responding to next results request")
	}

	return
}

// ListWebWorkerUsages get usage metrics for a worker pool of an App Service
// Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. workerPoolName is name
// of the worker pool.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsages(resourceGroupName string, name string, workerPoolName string) (result UsageCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages")
	}

	req, err := client.ListWebWorkerUsagesPreparer(resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebWorkerUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", resp, "Failure sending request")
		return
	}

	result, err = client.ListWebWorkerUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", resp, "Failure responding to request")
	}

	return
}

// ListWebWorkerUsagesPreparer prepares the ListWebWorkerUsages request.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsagesPreparer(resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWebWorkerUsagesSender sends the ListWebWorkerUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListWebWorkerUsagesResponder handles the response to the ListWebWorkerUsages request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsagesResponder(resp *http.Response) (result UsageCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebWorkerUsagesNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsagesNextResults(lastResults UsageCollection) (result UsageCollection, err error) {
	req, err := lastResults.UsageCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWebWorkerUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", resp, "Failure sending next results request")
	}

	result, err = client.ListWebWorkerUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", resp, "Failure responding to next results request")
	}

	return
}

// ListWorkerPoolInstanceMetricDefinitions get metric definitions for a
// specific instance of a worker pool of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. workerPoolName is name
// of the worker pool. instance is name of the instance in the worker pool.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitions(resourceGroupName string, name string, workerPoolName string, instance string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions")
	}

	req, err := client.ListWorkerPoolInstanceMetricDefinitionsPreparer(resourceGroupName, name, workerPoolName, instance)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWorkerPoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListWorkerPoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListWorkerPoolInstanceMetricDefinitionsPreparer prepares the ListWorkerPoolInstanceMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitionsPreparer(resourceGroupName string, name string, workerPoolName string, instance string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWorkerPoolInstanceMetricDefinitionsSender sends the ListWorkerPoolInstanceMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListWorkerPoolInstanceMetricDefinitionsResponder handles the response to the ListWorkerPoolInstanceMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWorkerPoolInstanceMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitionsNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWorkerPoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", resp, "Failure sending next results request")
	}

	result, err = client.ListWorkerPoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", resp, "Failure responding to next results request")
	}

	return
}

// ListWorkerPoolInstanceMetrics get metrics for a specific instance of a
// worker pool of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. workerPoolName is name
// of the worker pool. instance is name of the instance in the worker pool.
// details is specify <code>true</code> to include instance details. The
// default is <code>false</code>. filter is return only usages/metrics
// specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime
// eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and
// timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetrics(resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics")
	}

	req, err := client.ListWorkerPoolInstanceMetricsPreparer(resourceGroupName, name, workerPoolName, instance, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWorkerPoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListWorkerPoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", resp, "Failure responding to request")
	}

	return
}

// ListWorkerPoolInstanceMetricsPreparer prepares the ListWorkerPoolInstanceMetrics request.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricsPreparer(resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWorkerPoolInstanceMetricsSender sends the ListWorkerPoolInstanceMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListWorkerPoolInstanceMetricsResponder handles the response to the ListWorkerPoolInstanceMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWorkerPoolInstanceMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWorkerPoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", resp, "Failure sending next results request")
	}

	result, err = client.ListWorkerPoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", resp, "Failure responding to next results request")
	}

	return
}

// ListWorkerPools get all worker pools of an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListWorkerPools(resourceGroupName string, name string) (result WorkerPoolCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools")
	}

	req, err := client.ListWorkerPoolsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWorkerPoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", resp, "Failure sending request")
		return
	}

	result, err = client.ListWorkerPoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", resp, "Failure responding to request")
	}

	return
}

// ListWorkerPoolsPreparer prepares the ListWorkerPools request.
func (client AppServiceEnvironmentsClient) ListWorkerPoolsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWorkerPoolsSender sends the ListWorkerPools request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWorkerPoolsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListWorkerPoolsResponder handles the response to the ListWorkerPools request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWorkerPoolsResponder(resp *http.Response) (result WorkerPoolCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWorkerPoolsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListWorkerPoolsNextResults(lastResults WorkerPoolCollection) (result WorkerPoolCollection, err error) {
	req, err := lastResults.WorkerPoolCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWorkerPoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", resp, "Failure sending next results request")
	}

	result, err = client.ListWorkerPoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", resp, "Failure responding to next results request")
	}

	return
}

// ListWorkerPoolSkus get available SKUs for scaling a worker pool.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment. workerPoolName is name
// of the worker pool.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkus(resourceGroupName string, name string, workerPoolName string) (result SkuInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus")
	}

	req, err := client.ListWorkerPoolSkusPreparer(resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWorkerPoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", resp, "Failure sending request")
		return
	}

	result, err = client.ListWorkerPoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", resp, "Failure responding to request")
	}

	return
}

// ListWorkerPoolSkusPreparer prepares the ListWorkerPoolSkus request.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkusPreparer(resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWorkerPoolSkusSender sends the ListWorkerPoolSkus request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListWorkerPoolSkusResponder handles the response to the ListWorkerPoolSkus request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkusResponder(resp *http.Response) (result SkuInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWorkerPoolSkusNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkusNextResults(lastResults SkuInfoCollection) (result SkuInfoCollection, err error) {
	req, err := lastResults.SkuInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWorkerPoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", resp, "Failure sending next results request")
	}

	result, err = client.ListWorkerPoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", resp, "Failure responding to next results request")
	}

	return
}

// Reboot reboot all machines in an App Service Environment.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) Reboot(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "Reboot")
	}

	req, err := client.RebootPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Reboot", nil, "Failure preparing request")
		return
	}

	resp, err := client.RebootSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Reboot", resp, "Failure sending request")
		return
	}

	result, err = client.RebootResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Reboot", resp, "Failure responding to request")
	}

	return
}

// RebootPreparer prepares the Reboot request.
func (client AppServiceEnvironmentsClient) RebootPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RebootSender sends the Reboot request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) RebootSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RebootResponder handles the response to the Reboot request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) RebootResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Resume resume an App Service Environment. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) Resume(resourceGroupName string, name string, cancel <-chan struct{}) (result AppCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "Resume")
	}

	req, err := client.ResumePreparer(resourceGroupName, name, cancel)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Resume", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResumeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Resume", resp, "Failure sending request")
		return
	}

	result, err = client.ResumeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Resume", resp, "Failure responding to request")
	}

	return
}

// ResumePreparer prepares the Resume request.
func (client AppServiceEnvironmentsClient) ResumePreparer(resourceGroupName string, name string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ResumeSender sends the Resume request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ResumeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ResumeResponder handles the response to the Resume request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ResumeResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResumeNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) ResumeNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Resume", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ResumeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Resume", resp, "Failure sending next results request")
	}

	result, err = client.ResumeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Resume", resp, "Failure responding to next results request")
	}

	return
}

// Suspend suspend an App Service Environment. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the App Service Environment.
func (client AppServiceEnvironmentsClient) Suspend(resourceGroupName string, name string, cancel <-chan struct{}) (result AppCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServiceEnvironmentsClient", "Suspend")
	}

	req, err := client.SuspendPreparer(resourceGroupName, name, cancel)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Suspend", nil, "Failure preparing request")
		return
	}

	resp, err := client.SuspendSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Suspend", resp, "Failure sending request")
		return
	}

	result, err = client.SuspendResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Suspend", resp, "Failure responding to request")
	}

	return
}

// SuspendPreparer prepares the Suspend request.
func (client AppServiceEnvironmentsClient) SuspendPreparer(resourceGroupName string, name string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// SuspendSender sends the Suspend request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) SuspendSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// SuspendResponder handles the response to the Suspend request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) SuspendResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SuspendNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) SuspendNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Suspend", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.SuspendSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Suspend", resp, "Failure sending next results request")
	}

	result, err = client.SuspendResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Suspend", resp, "Failure responding to next results request")
	}

	return
}
