'''apport package hook for shim and shim-signed

(c) 2015 Canonical Ltd.
Author: Brian Murray <brian@ubuntu.com>
'''

import errno
import os

from apport.hookutils import (
    command_available,
    command_output,
    attach_root_command_outputs)

efiarch = {'amd64': 'x64',
           'i386': 'ia32',
           'arm64': 'aarch64'
          }
grubarch = {'amd64': 'x86_64',
            'i386': 'i386',
            'arm64': 'arm64'
           }

def add_info(report, ui):
    efiboot = '/boot/efi/EFI/ubuntu'
    if command_available('efibootmgr'):
        report['EFIBootMgr'] = command_output(['efibootmgr', '-v'])
    else:
        report['EFIBootMgr'] = 'efibootmgr not available'
    commands = {}
    try:
        directory = os.stat(efiboot)
    except OSError as e:
        if e.errno == errno.ENOENT:
            report['Missing'] = '/boot/efi/EFI/ubuntu directory is missing'
            return
        if e.errno == errno.EACCES:
            directory= True
    if directory:
        arch = report['Architecture']
        commands['BootEFIContents'] = 'ls %s' % efiboot
        commands['ShimDiff'] = 'diff %s/shim%s.efi /usr/lib/shim/shim.efi.signed' % (efiboot, efiarch[arch])
        commands['GrubDiff'] = 'diff %s/grub%s.efi /usr/lib/grub/%s-efi-signed/grub%s.efi.signed' %(efiboot, efiarch[arch], grubarch[arch], efiarch[arch])
        attach_root_command_outputs(report, commands)
