package org.basex.qt3ts.app;

import org.basex.tests.bxapi.*;
import org.basex.tests.qt3ts.*;

/**
 * Some XQuery demonstration programs from CBCL.
 *
 * @author BaseX Team 2005-15, BSD License
 * @author Leo Woerteler
 */
@SuppressWarnings("all")
public class AppDemos extends QT3TestSet {

  /**
   * Draw an SVG of currency exchange data..
   */
  @org.junit.Test
  public void currencysvg() {
    final XQuery query = new XQuery(
      queryFile(
        file(
            "app/Demos/currencysvg.xq"
        )
      ),
      ctx);
    try {
      query.context(node(file("app/Demos/GBPNoon.xml")));
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<?xml version=\"1.0\" encoding=\"UTF-8\"?><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"-50,-50,1100,1100\"><!-- Border --><path stroke=\"black\" d=\"M0,0L1000,0L1000,1000L0,1000L0,0\" fill=\"none\" stroke-width=\"1\"/><!-- Title --><text text-anchor=\"middle\" y=\"-20\" x=\"500\">Foreign Exchange UK Pound Noon Rates</text><!-- Generator --><text text-anchor=\"middle\" y=\"1040\" x=\"500\">Generated by XQSharp</text><!-- Ranges --><text text-anchor=\"middle\" y=\"1020\" x=\"0\">1994-01-06</text><text text-anchor=\"middle\" y=\"1020\" x=\"1000\">2008-10-29</text><text text-anchor=\"end\" y=\"0\" x=\"0\">2.1104</text><text text-anchor=\"end\" y=\"1000\" x=\"0\">1.373</text><!-- Graph --><path stroke=\"red\" fill=\"none\" stroke-width=\"1\" d=\"M0,847.4369 L0.1848,841.3344 L0.7394,838.2154 L0.9242,840.6564 L1.1091,825.3322 L1.2939,833.6046 L1.4787,839.5715 L2.2181,832.5197 L2.403,839.9783 L2.5878,827.7733 L2.7726,834.8251 L3.3272,840.6564 L3.512,837.2661 L3.6969,835.91 L3.8817,837.2661 L4.0665,828.4513 L4.6211,827.0952 L4.8059,823.7049 L4.9908,834.147 L5.1756,837.2661 L5.3604,856.2517 L5.915,851.5053 L6.0998,866.0157 L6.2847,879.9837 L6.4695,879.0344 L6.6543,875.5085 L7.2089,867.3718 L7.3937,860.9981 L7.5786,860.9981 L7.7634,858.9639 L7.9482,856.1161 L8.6876,857.0654 L8.8725,860.9981 L9.0573,848.5218 L9.2421,844.7247 L9.9815,847.5726 L10.1664,835.3675 L10.3512,832.6553 L10.536,842.0125 L11.0906,838.6222 L11.2754,844.4535 L11.4603,839.3002 L11.6451,826.6884 L11.8299,826.4171 L12.3845,835.5031 L12.5693,837.9441 L12.7542,837.6729 L12.939,834.9607 L13.1238,837.9441 L13.6784,849.7423 L13.8632,846.0808 L14.0481,836.3168 L14.2329,834.8251 L14.4177,831.1635 L14.9723,832.5197 L15.1571,848.115 L15.342,851.7765 L15.5268,844.0467 L21.4418,802.4139 L21.6266,810.1437 L21.8115,828.4513 L21.9963,830.4855 L22.1811,836.588 L22.7357,831.1635 L22.9205,840.6564 L23.1054,839.8427 L23.2902,828.4513 L23.475,829.8074 L24.0296,824.383 L24.2144,818.9585 L24.3993,816.2463 L24.5841,816.9243 L24.7689,814.4833 L25.3235,820.3146 L25.5083,819.9078 L25.6932,814.8902 L25.878,813.1272 L26.0628,814.8902 L26.8022,811.4999 L26.9871,804.4481 L27.1719,816.6531 L27.3567,820.3146 L27.9113,816.5175 L28.0961,816.9243 L28.281,819.2297 L28.4658,818.6873 L28.6506,816.3819 L29.2052,800.3797 L29.39,801.7358 L29.7597,800.6509 L29.9445,786.1405 L30.4991,775.5628 L30.8688,785.0556 L31.0536,771.4944 L31.2384,757.3908 L31.793,760.6455 L31.9778,758.3401 L32.1627,765.1207 L32.3475,762.2729 L32.5323,774.8847 L33.2717,771.4944 L33.4566,759.2894 L33.6414,770.6808 L33.8262,767.4261 L34.3808,740.3038 L34.5656,729.4548 L34.7505,736.2354 L34.9353,744.3721 L35.1201,749.9322 L35.6747,743.4228 L35.8595,758.2045 L36.0444,760.9167 L36.2292,774.2067 L36.414,785.7337 L36.9686,784.3775 L37.1534,794.684 L37.3383,786.2761 L37.5231,784.7844 L37.7079,771.4944 L43.9926,767.4261 L44.1774,763.3577 L44.9168,761.7304 L45.1017,765.1207 L45.2865,768.6466 L45.4713,759.5606 L46.0259,733.3876 L46.2107,743.2872 L46.3956,736.5066 L46.5804,742.3379 L46.7652,713.8595 L47.3198,738.2696 L47.5046,726.7426 L47.6895,721.9962 L47.8743,724.7084 L48.0591,717.521 L48.6137,726.7426 L48.7985,722.6743 L48.9834,724.7084 L49.1682,719.284 L49.353,723.3523 L49.9076,721.3181 L50.0924,721.5894 L50.2773,711.1473 L50.4621,709.1131 L50.647,710.4692 L51.3863,721.9962 L51.5712,717.9279 L51.756,717.2498 L51.9409,704.3667 L52.4954,678.6005 L52.6802,673.8541 L52.8651,667.7516 L53.0499,663.0052 L53.2348,657.5807 L53.7893,654.8685 L53.9741,642.6634 L54.159,648.7659 L54.3438,642.2566 L54.5287,660.971 L55.0832,644.6976 L55.268,648.7659 L55.4529,645.3756 L55.6377,675.2102 L55.8226,677.9224 L56.5619,663.6832 L56.7468,685.3811 L56.9316,693.2465 L57.671,708.435 L57.8558,713.8595 L58.0407,730.811 L58.2255,723.3523 L58.4104,735.5574 L58.9649,738.2696 L59.1497,733.5232 L59.3346,729.4548 L59.7043,742.3379 L60.2588,742.3379 L60.4436,740.575 L60.6285,736.9135 L62.1072,742.0667 L62.2921,746.1351 L62.8466,741.3887 L63.0314,745.7282 L63.2163,744.779 L63.4011,742.3379 L63.586,742.3379 L64.1405,743.4228 L64.3253,746.4063 L64.5102,747.0844 L64.695,765.1207 L64.8799,767.4261 L65.6192,766.748 L65.8041,768.7822 L65.9889,746.1351 L66.1738,737.5915 L66.9131,743.1516 L67.098,745.7282 L67.2828,741.6599 L67.4677,757.5264 L68.0222,750.0678 L68.207,748.4405 L68.3919,747.4912 L68.5767,730.811 L68.7616,736.9135 L69.5009,735.5574 L69.6858,731.8959 L69.8706,726.0646 L70.0555,708.8419 L70.61,698.2642 L70.7948,697.5861 L70.9797,701.3832 L71.1645,704.6379 L71.3494,707.757 L71.9039,700.9764 L72.0887,717.2498 L72.2736,718.6059 L72.4584,715.2156 L72.6433,740.575 L73.1978,746.4063 L73.3826,750.4746 L73.5675,756.8484 L73.7523,751.1527 L73.9372,742.7448 L74.4917,741.6599 L74.6765,749.7966 L74.8614,745.7282 L75.0462,722.6743 L75.2311,724.0304 L75.9704,717.2498 L76.1553,711.1473 L76.3401,701.6545 L76.525,707.757 L77.0795,714.5376 L77.2643,713.8595 L77.4492,713.4527 L77.634,704.3667 L77.8189,663.6832 L78.3734,647.4098 L78.5582,632.4925 L78.7431,666.3954 L78.9279,671.5487 L79.1128,719.0127 L79.6673,696.5012 L79.8521,711.8253 L80.037,688.0933 L80.2218,711.1473 L80.4067,716.5717 L80.9612,718.6059 L81.146,711.8253 L81.3309,711.1473 L81.5157,702.6037 L81.7006,708.435 L82.2551,698.2642 L82.4399,678.6005 L82.6248,681.3127 L82.8096,694.1958 L82.9945,666.3954 L83.549,670.4638 L83.7338,690.1275 L83.9187,683.3469 L84.1035,684.2962 L84.2884,690.1275 L84.8429,700.2983 L85.0277,699.6203 L85.2126,705.7228 L85.3974,682.9401 L85.5823,689.4494 L86.1368,665.7174 L86.3216,673.176 L86.5065,670.4638 L86.6913,674.939 L86.8762,678.6005 L87.4307,684.703 L87.6155,673.8541 L87.8004,677.9224 L87.9852,670.1926 L88.1701,679.821 L88.7246,667.7516 L88.9094,675.2102 L89.0943,668.8365 L89.2791,667.0735 L89.464,693.5178 L90.0185,681.3127 L90.2033,707.757 L90.3882,717.2498 L90.573,749.661 L90.7579,731.489 L91.3124,739.3545 L91.4972,734.2012 L91.6821,734.8793 L91.8669,743.016 L92.0518,728.0987 L92.6063,726.0646 L92.7911,738.2696 L92.976,725.3865 L93.1608,687.144 L93.3457,686.7372 L94.085,690.8055 L94.2699,710.4692 L94.4547,699.6203 L94.6396,711.1473 L95.1941,698.2642 L95.3789,705.7228 L95.5638,700.0271 L95.7486,703.0106 L95.9335,699.6203 L96.488,698.9422 L96.6728,698.2642 L96.8577,680.6347 L97.0425,698.2642 L97.2274,682.6688 L97.7819,692.8397 L97.9667,688.0933 L98.1516,685.5167 L98.3364,692.4329 L98.5213,686.0591 L99.0758,711.8253 L99.2606,713.1814 L99.4455,727.4207 L99.6303,703.6886 L99.8152,705.0448 L100.3697,695.9588 L100.7394,698.9422 L100.9242,694.1958 L101.1091,699.6203 L101.6636,705.0448 L101.8484,708.435 L102.0333,703.6886 L102.2181,691.4836 L102.403,699.6203 L102.9575,699.6203 L103.1423,697.3149 L103.3272,698.2642 L103.512,696.23 L103.6969,700.2983 L104.2514,695.4163 L104.4362,708.5707 L104.6211,698.1286 L104.8059,697.0437 L104.9908,691.7548 L105.5453,694.8739 L105.7301,693.2465 L105.915,692.8397 L106.0998,682.9401 L106.2847,682.262 L106.8392,689.7206 L107.024,690.8055 L107.2089,691.8904 L107.3937,707.3501 L107.5786,722.5386 L108.1331,727.4207 L108.3179,752.78 L108.5028,757.9333 L108.6876,780.9873 L108.8725,769.4603 L109.427,772.8506 L109.6118,779.6311 L109.7967,771.4944 L109.9815,769.189 L110.1664,771.0876 L110.7209,756.5772 L110.9057,766.3412 L111.0906,768.1041 L111.2754,757.9333 L111.4603,755.4923 L112.1996,751.1527 L112.3845,759.8318 L112.5693,759.9675 L112.7542,762.4085 L113.3087,762.2729 L113.4935,753.8649 L113.6784,762.6797 L113.8632,759.2894 L114.0481,757.2552 L114.6026,765.3919 L114.7874,765.3919 L114.9723,756.5772 L115.1571,733.5232 L115.342,719.962 L115.8965,730.811 L116.0813,731.7602 L116.2662,729.8617 L116.451,718.6059 L116.6359,719.962 L117.1904,704.5023 L117.3752,718.1991 L117.5601,714.2663 L117.7449,713.8595 L117.9298,717.6566 L118.6691,722.2674 L118.854,728.7768 L119.0388,728.0987 L119.2237,729.4548 L119.7782,726.0646 L119.963,727.4207 L120.1479,733.5232 L120.3327,729.4548 L120.5176,724.844 L121.0721,719.284 L121.2569,717.9279 L121.4418,719.962 L121.6266,727.4207 L121.8115,719.962 L122.366,722.6743 L122.5508,718.3347 L122.7357,722.2674 L122.9205,717.521 L123.1054,718.6059 L123.6599,720.2333 L123.8447,722.2674 L124.0296,718.6059 L124.2144,720.0976 L124.3993,725.6577 L124.9538,752.5088 L125.1386,745.7282 L125.5083,749.1185 L125.6932,759.2894 L126.2477,760.6455 L126.4325,748.7117 L126.6174,739.6257 L126.9871,746.4063 L127.5416,759.2894 L127.7264,762.6797 L127.9113,775.834 L128.0961,786.8186 L128.281,778.9531 L128.8355,778.9531 L129.0203,772.1725 L129.2052,770.5452 L129.39,779.9024 L129.5749,783.157 L130.1294,780.5804 L130.3142,785.3268 L130.4991,783.6995 L130.6839,772.1725 L130.8688,774.2067 L131.4233,774.8847 L131.6081,770.8164 L131.793,777.1901 L131.9778,775.156 L132.1627,770.1383 L132.902,752.5088 L133.0869,746.4063 L133.2717,774.8847 L133.4566,755.221 L134.1959,751.1527 L134.3808,757.6621 L134.5656,764.9851 L134.7505,757.2552 L135.305,760.6455 L135.4898,763.3577 L135.6747,765.9344 L135.8595,767.4261 L136.0444,761.7304 L136.7837,776.2408 L136.9686,793.1923 L137.1534,796.8538 L137.3383,815.1614 L137.8928,809.4657 L138.0776,809.4657 L138.2625,815.297 L138.4473,817.6024 L138.6322,823.7049 L139.1867,819.2297 L139.3715,822.7556 L139.5564,814.7545 L139.7412,809.8725 L139.9261,802.0071 L140.4806,780.038 L140.6654,773.2574 L140.8503,778.275 L141.0351,777.0545 L141.22,784.6488 L141.7745,786.0049 L141.9593,781.6653 L142.1442,777.4614 L142.329,775.5628 L142.5139,761.7304 L143.2532,767.4261 L143.4381,770.1383 L143.6229,768.7822 L143.8078,772.1725 L144.3623,773.5286 L144.5471,773.7998 L144.732,782.3434 L144.9168,784.3775 L145.1017,790.7513 L145.6562,789.2596 L145.841,788.4459 L146.0259,788.4459 L146.2107,787.0898 L146.3956,795.2265 L146.9501,795.4977 L147.1349,798.888 L147.3198,797.2606 L147.5046,796.447 L147.6895,793.8704 L148.244,787.0898 L148.4288,783.4283 L148.6137,776.7833 L148.7985,778.9531 L148.9834,782.479 L149.5379,796.5826 L149.7227,795.2265 L149.9076,803.2276 L150.0924,795.3621 L150.2773,792.243 L150.8318,794.684 L151.0166,794.1416 L151.2015,792.5142 L151.3863,787.7678 L151.5712,788.8527 L152.1257,785.7337 L152.3105,794.8196 L152.4954,812.1779 L152.6802,810.8218 L152.8651,811.093 L153.4196,816.2463 L153.6044,818.1448 L153.7893,818.2804 L153.9741,814.2121 L154.159,804.9905 L154.7135,812.5848 L154.8983,805.9398 L155.0832,809.0589 L155.268,810.5506 L155.4529,813.8053 L156.0074,815.0258 L156.1922,820.9927 L156.3771,834.8251 L156.5619,823.7049 L156.7468,822.0776 L157.3013,818.0092 L157.4861,810.8218 L157.671,798.6168 L157.8558,797.9387 L158.0407,797.5319 L158.5952,808.1096 L158.78,807.5671 L158.9649,810.1437 L159.1497,809.7369 L159.3346,807.4315 L159.8891,810.1437 L160.0739,812.1779 L160.2588,813.8053 L160.4436,809.6013 L160.6285,812.856 L161.3678,810.5506 L161.5527,799.1592 L161.7375,780.9873 L161.9224,760.6455 L162.4769,757.9333 L162.6617,762.0016 L162.8466,763.4934 L163.0314,772.8506 L163.2163,772.1725 L163.7708,784.1063 L163.9556,779.6311 L164.1405,780.9873 L164.3253,784.3775 L164.5102,779.2243 L165.0647,766.748 L165.2495,768.7822 L165.4344,769.0534 L165.6192,771.0876 L165.8041,775.834 L166.3586,773.5286 L166.5434,772.8506 L166.7283,771.6301 L166.9131,765.1207 L167.098,756.0347 L167.6525,753.8649 L167.8373,748.7117 L168.0222,748.1692 L168.3919,756.984 L168.9464,755.8991 L169.1312,760.6455 L169.3161,759.425 L169.5009,752.5088 L169.6858,756.5772 L170.2403,759.9675 L170.4251,748.4405 L170.61,769.189 L170.7948,762.8153 L170.9797,764.5782 L171.5342,758.3401 L171.719,757.9333 L171.9039,756.5772 L172.0887,750.2034 L172.2736,753.8649 L172.8281,750.4746 L173.0129,752.102 L173.1978,752.3732 L173.3826,750.2034 L173.5675,771.0876 L174.122,767.8329 L174.3068,776.9189 L174.4917,771.0876 L174.6765,760.3743 L174.8614,761.3236 L175.4159,759.2894 L175.6007,760.1031 L175.7856,762.2729 L175.9704,759.425 L176.1553,764.307 L176.7098,767.5617 L176.8946,763.629 L177.0795,760.3743 L177.2643,758.8826 L177.4492,755.8991 L178.0037,752.78 L178.1885,755.8991 L178.3734,747.3556 L178.5582,751.4239 L178.7431,744.779 L179.4824,736.7779 L179.6673,736.9135 L179.8521,737.3203 L180.037,745.457 L180.5915,748.8473 L180.7763,750.6103 L180.9612,753.1869 L181.146,754.8142 L181.3309,754.0005 L181.8854,751.0171 L182.0702,753.8649 L182.2551,746.1351 L182.4399,757.9333 L182.6248,752.5088 L183.1793,750.7459 L183.3641,749.1185 L183.549,741.9311 L183.7338,744.6433 L183.9187,742.3379 L184.4732,739.2189 L184.658,740.9818 L184.8429,734.8793 L185.0277,738.134 L185.2126,743.2872 L185.7671,741.6599 L185.9519,742.2023 L186.1368,740.7106 L186.3216,739.4901 L186.5065,725.3865 L187.2458,716.1649 L187.4307,714.5376 L187.6155,710.7404 L187.8004,705.316 L188.3549,703.553 L188.5397,698.5354 L188.7246,696.5012 L188.9094,703.2818 L189.0943,683.7537 L189.6488,675.617 L189.8336,678.7361 L190.0185,647.9523 L190.2033,654.4616 L190.3882,643.6127 L190.9427,633.1706 L191.1275,631.1364 L191.3124,637.917 L191.4972,627.7461 L191.6821,628.4242 L192.4214,628.4242 L192.6063,617.5753 L192.976,604.5566 L193.5305,597.2335 L193.7153,589.0968 L193.9002,586.3846 L194.085,571.8742 L194.2699,583.6724 L194.8244,597.9116 L195.0092,593.1652 L195.1941,589.0968 L195.5638,580.9601 L196.1183,578.2479 L196.3031,635.2048 L196.488,639.68 L196.6728,655.8177 L196.8577,635.8828 L197.4122,627.7461 L197.597,623.6778 L197.7819,613.5069 L197.9667,614.863 L198.1516,610.3878 L198.7061,607.8112 L198.8909,594.5213 L199.0758,594.2501 L199.2606,620.9656 L199.4455,601.3019 L200,595.1993 L200.1848,595.1993 L200.5545,593.7076 L200.7394,567.8058 L201.2939,569.0263 L201.4787,539.8698 L201.8484,574.1795 L202.0333,570.1112 L202.5878,576.8918 L202.7726,563.3306 L202.9575,574.0439 L203.1423,564.0087 L203.3272,581.7738 L203.8817,595.4706 L204.0665,597.9116 L204.2514,585.7065 L204.4362,588.8256 L204.6211,610.5235 L205.3604,606.4551 L205.5453,619.7451 L205.7301,653.5123 L205.915,653.7836 L206.4695,659.6149 L206.6543,671.1418 L206.8392,664.09 L207.024,667.3447 L207.2089,690.5343 L207.7634,673.8541 L207.9482,664.09 L208.1331,640.6292 L208.3179,644.0195 L208.5028,661.2422 L209.0573,639.2731 L209.2421,632.4925 L209.427,646.3249 L209.6118,660.971 L209.7967,664.09 L210.536,689.1782 L210.7209,673.4472 L210.9057,677.6512 L211.0906,671.1418 L211.6451,647.003 L211.8299,648.3591 L212.0148,647.4098 L212.1996,656.2246 L212.3845,653.2411 L212.939,668.4296 L213.1238,671.1418 L213.3087,676.2951 L213.4935,674.3965 L213.6784,687.8221 L214.2329,691.4836 L214.4177,684.2962 L214.6026,701.3832 L214.7874,696.9081 L214.9723,689.1782 L215.5268,705.7228 L215.7116,707.0789 L215.8965,696.5012 L216.0813,699.2135 L216.2662,690.1275 L216.8207,668.9721 L217.0055,668.8365 L217.1904,654.7328 L217.3752,649.8508 L217.5601,649.444 L218.1146,631.4076 L218.2994,626.39 L218.4843,634.5267 L218.6691,629.7803 L218.854,639.4087 L219.4085,654.5972 L219.5933,660.5641 L219.7782,662.3271 L219.963,660.971 L220.1479,658.9368 L220.7024,661.649 L220.8872,657.5807 L221.0721,661.649 L221.2569,650.1221 L221.4418,649.444 L221.9963,644.2908 L222.1811,643.0702 L222.366,663.2764 L222.5508,658.2587 L222.7357,660.2929 L223.2902,660.6998 L223.475,649.8508 L223.6599,665.0393 L223.8447,659.8861 L224.0296,663.0052 L224.5841,665.0393 L224.7689,641.3073 L224.9538,642.799 L225.1386,665.0393 L225.3235,663.6832 L225.878,660.2929 L226.0628,648.9015 L226.2477,637.917 L226.4325,639.9512 L226.6174,646.7318 L227.1719,640.6292 L227.3567,632.7638 L227.5416,629.1023 L227.7264,660.2929 L227.9113,648.2235 L228.6506,652.8343 L228.8355,640.358 L229.0203,637.2389 L229.2052,643.3415 L229.7597,645.6469 L229.9445,645.7825 L230.1294,655.2753 L230.3142,647.681 L230.4991,654.1904 L231.0536,644.0195 L231.2384,640.358 L231.4233,641.9854 L231.6081,644.4264 L231.793,645.6469 L232.3475,643.7483 L232.5323,639.9512 L232.7172,640.0868 L232.902,627.0681 L233.0869,619.3382 L233.6414,598.8609 L233.8262,604.9634 L234.0111,607.4044 L234.1959,602.658 L234.3808,608.0825 L234.9353,604.0141 L235.1201,614.3206 L235.305,601.3019 L235.4898,572.1454 L236.2292,574.1795 L236.414,572.1454 L236.5989,578.2479 L236.7837,572.6878 L236.9686,565.3648 L237.5231,572.5522 L237.7079,588.4188 L237.8928,591.131 L238.0776,590.4529 L238.2625,588.9612 L238.817,586.927 L239.0018,591.2666 L239.1867,586.5202 L239.3715,593.3008 L239.5564,606.9976 L240.1109,652.5631 L240.2957,654.8685 L240.4806,663.6832 L240.6654,639.5443 L240.8503,644.9688 L241.4048,653.7836 L241.5896,658.2587 L241.7745,691.0768 L241.9593,709.1131 L242.1442,712.5034 L242.6987,705.4516 L242.8835,722.6743 L243.0684,715.8937 L243.2532,710.4692 L243.4381,679.9566 L243.9926,680.2278 L244.1774,687.4152 L244.3623,702.6037 L244.5471,705.0448 L244.732,681.1771 L245.2865,685.1098 L245.4713,675.7526 L245.6562,678.1937 L245.841,670.735 L246.0259,664.6325 L246.7652,706.1296 L246.9501,713.0458 L247.1349,711.8253 L247.3198,703.0106 L247.8743,715.6225 L248.0591,708.1638 L248.244,707.0789 L248.4288,696.5012 L248.6137,680.6347 L249.1682,686.466 L249.353,700.1627 L249.5379,694.1958 L249.7227,673.5829 L249.9076,676.9731 L250.4621,688.7714 L250.647,676.5663 L250.8318,678.1937 L251.0166,654.326 L251.2015,678.6005 L251.756,672.9048 L251.9409,676.2951 L252.1257,672.498 L252.3105,673.8541 L252.4954,674.5321 L253.0499,674.5321 L253.2348,665.7174 L253.4196,663.9544 L253.6044,658.9368 L253.7893,664.09 L254.5287,665.4462 L254.7135,660.2929 L254.8983,666.8023 L255.0832,672.498 L255.6377,651.885 L255.8226,646.3249 L256.0074,646.3249 L256.1922,649.1728 L256.3771,645.1044 L256.9316,617.8465 L257.1165,589.6393 L257.3013,594.3857 L257.4861,603.336 L257.671,585.5709 L258.2255,588.69 L258.4104,579.3328 L258.5952,587.0627 L258.78,567.399 L258.9649,569.4331 L259.5194,571.0605 L259.8891,551.8036 L260.0739,555.1939 L260.2588,565.9072 L260.8133,565.9072 L260.9982,562.6526 L261.183,568.6195 L261.3678,566.7209 L261.5527,571.1961 L262.1072,570.1112 L262.2921,582.9943 L262.4769,592.4871 L262.8466,572.1454 L263.4011,580.2821 L263.586,581.367 L263.7708,578.2479 L263.9556,596.5555 L264.1405,612.8289 L264.695,628.153 L264.8799,620.5587 L265.0647,625.0339 L265.2495,617.304 L265.4344,624.2202 L265.9889,647.003 L266.1738,647.9523 L266.3586,623.4066 L266.5434,606.0483 L266.7283,599.4033 L267.2828,608.4893 L267.4677,599.9458 L267.6525,600.6238 L268.0222,597.9116 L268.5767,599.5389 L268.7616,617.304 L268.9464,634.2555 L269.3161,635.6116 L269.8706,647.4098 L270.0555,646.7318 L270.2403,657.8519 L270.4251,676.7019 L270.61,669.7857 L271.1645,662.1915 L271.3494,645.3756 L271.5342,651.3426 L271.719,651.4782 L271.9039,646.4605 L272.6433,655.4109 L272.8281,656.3602 L273.0129,624.6271 L273.1978,598.9965 L273.7523,620.9656 L273.9372,627.8817 L274.122,633.8487 L274.3068,637.917 L274.4917,648.0879 L275.0462,640.6292 L275.2311,634.7979 L275.4159,613.5069 L275.6007,618.2533 L275.7856,627.7461 L276.3401,646.3249 L276.525,660.971 L276.7098,648.2235 L276.8946,640.7648 L277.0795,645.3756 L277.8189,649.8508 L278.0037,638.5951 L278.1885,644.0195 L278.3734,642.9346 L278.9279,628.4242 L279.1128,630.4584 L279.2976,626.5256 L279.4824,631.4076 L279.6673,630.7296 L280.2218,628.153 L280.4067,620.9656 L280.5915,629.7803 L280.7763,631.1364 L280.9612,648.0879 L281.5157,642.799 L281.7006,640.4936 L281.8854,628.831 L282.0702,616.0835 L282.2551,602.9292 L282.8096,599.6745 L282.9945,591.4022 L283.1793,595.7418 L283.3641,600.217 L283.549,604.9634 L284.1035,585.0285 L284.2884,590.3173 L284.4732,591.9447 L284.658,575.5357 L284.8429,580.2821 L285.3974,587.0627 L285.5823,588.4188 L285.7671,591.8091 L285.9519,601.9799 L286.1368,614.185 L286.6913,606.0483 L286.8762,602.9292 L287.061,599.5389 L287.2458,593.8432 L287.4307,594.7925 L287.9852,601.5731 L288.1701,578.2479 L288.3549,579.604 L288.5397,568.7551 L288.7246,578.2479 L289.2791,589.5037 L289.464,588.8256 L289.6488,594.7925 L289.8336,601.9799 L290.0185,600.217 L290.573,592.7583 L290.7579,600.895 L290.9427,596.9623 L291.1275,593.572 L291.3124,600.6238 L291.8669,602.658 L292.0518,610.1166 L292.2366,609.4386 L292.4214,626.39 L292.6063,640.6292 L293.1608,651.4782 L293.3457,645.1044 L293.5305,650.3933 L293.7153,650.6645 L293.9002,654.4616 L294.4547,660.2929 L294.6396,660.6998 L294.8244,647.1386 L295.0092,650.8001 L295.1941,649.0372 L295.9335,642.6634 L296.1183,648.4947 L296.3031,654.5972 L296.488,650.3933 L297.0425,639.0019 L297.2274,639.5443 L297.4122,639.9512 L297.597,638.5951 L297.7819,644.562 L298.3364,648.2235 L298.5213,645.1044 L298.7061,654.5972 L298.8909,652.5631 L299.0758,649.444 L299.6303,649.444 L299.8152,620.9656 L300,608.0825 L300.1848,596.5555 L300.3697,592.4871 L300.9242,594.5213 L301.1091,605.2346 L301.2939,599.5389 L301.4787,594.2501 L301.6636,609.7098 L302.2181,604.6922 L302.403,597.9116 L302.5878,608.6249 L302.7726,615.5411 L302.9575,628.2886 L303.512,632.2213 L303.6969,641.3073 L303.8817,642.121 L304.0665,649.444 L304.2514,648.0879 L304.8059,636.2897 L304.9908,644.0195 L305.1756,646.4605 L305.3604,639.68 L305.5453,634.2555 L306.0998,627.0681 L306.2847,633.8487 L306.4695,635.2048 L306.6543,627.8817 L306.8392,611.6084 L307.3937,615.5411 L307.5786,626.39 L307.7634,632.4925 L307.9482,635.8828 L308.1331,644.8332 L308.6876,658.9368 L308.8725,647.4098 L309.0573,643.3415 L309.2421,647.1386 L309.427,652.8343 L309.9815,647.681 L310.1664,652.1562 L310.3512,652.8343 L310.536,656.2246 L310.7209,667.2091 L311.2754,670.1926 L311.4603,670.1926 L311.6451,661.3778 L311.8299,654.8685 L312.0148,642.9346 L312.5693,636.5609 L312.7542,638.5951 L312.939,639.9512 L313.1238,637.2389 L313.3087,594.5213 L313.8632,589.0968 L314.0481,591.8091 L314.2329,599.1321 L314.4177,588.8256 L314.6026,594.5213 L315.342,613.3713 L315.5268,608.0825 L315.7116,581.5026 L315.8965,577.2986 L316.451,587.0627 L316.6359,591.5378 L316.8207,589.368 L317.0055,578.2479 L317.1904,578.926 L317.7449,577.5698 L317.9298,578.6547 L318.1146,583.9436 L318.2994,564.0087 L318.4843,553.431 L319.0388,551.1256 L319.2237,547.3285 L319.4085,557.2281 L319.5933,550.4475 L319.7782,553.0241 L320.3327,569.9756 L320.5176,579.1972 L320.7024,560.8896 L320.8872,526.4443 L321.0721,552.4817 L321.8115,554.5159 L321.9963,549.0914 L322.1811,552.7529 L322.366,552.4817 L322.9205,557.2281 L323.1054,548.4133 L323.2902,555.872 L323.475,563.3306 L323.6599,570.1112 L324.2144,579.604 L324.3993,594.2501 L324.5841,594.5213 L324.7689,589.368 L324.9538,592.4871 L325.5083,603.7429 L325.6932,613.9138 L325.878,612.422 L326.0628,606.7263 L326.2477,613.5069 L326.8022,612.8289 L326.9871,613.5069 L327.3567,615.1343 L327.5416,606.0483 L328.0961,589.7749 L328.281,587.0627 L328.4658,594.5213 L328.6506,600.3526 L328.8355,618.6602 L329.39,618.9314 L329.5749,613.2357 L329.7597,609.0317 L330.1294,621.3724 L330.6839,626.39 L330.8688,618.9314 L331.0536,607.4044 L331.2384,604.6922 L331.4233,608.7605 L331.9778,620.2875 L332.1627,618.9314 L332.3475,613.5069 L332.5323,601.3019 L332.7172,578.926 L333.2717,572.1454 L333.4566,576.4849 L333.6414,588.4188 L333.8262,590.4529 L334.5656,583.6724 L334.7505,587.0627 L334.9353,588.1475 L335.1201,594.1145 L335.8595,591.131 L336.0444,578.7903 L336.2292,601.9799 L336.414,606.9976 L337.1534,613.3713 L337.3383,615.4055 L337.5231,617.9821 L337.7079,625.0339 L337.8928,637.2389 L338.4473,641.3073 L338.6322,650.3933 L338.817,625.3051 L339.0018,620.2875 L339.1867,624.3558 L339.9261,617.5753 L340.1109,628.831 L340.2957,622.1861 L340.4806,616.2191 L341.0351,615.8123 L341.22,612.8289 L341.4048,626.39 L341.5896,628.4242 L341.7745,630.1871 L342.329,636.5609 L342.5139,633.8487 L342.6987,641.3073 L342.8835,638.5951 L343.0684,641.9854 L343.6229,640.6292 L343.8078,644.0195 L343.9926,652.8343 L344.1774,659.0724 L344.3623,649.9864 L345.1017,649.1728 L345.2865,646.3249 L345.4713,646.3249 L345.6562,657.5807 L346.2107,659.8861 L346.3956,673.4472 L346.5804,694.8739 L346.7652,684.025 L346.9501,688.5001 L347.5046,684.2962 L347.6895,673.8541 L347.8743,673.9897 L348.0591,683.3469 L348.244,682.262 L348.7985,680.6347 L348.9834,672.0911 L349.1682,655.9533 L349.353,655.5465 L349.5379,646.7318 L350.0924,661.9203 L350.2773,659.6149 L350.4621,651.2069 L350.647,652.8343 L350.8318,651.0713 L351.3863,654.1904 L351.5712,641.7141 L351.756,636.5609 L351.9409,649.5796 L352.1257,664.3613 L352.6802,673.176 L352.8651,676.5663 L353.0499,673.176 L353.2348,683.6181 L353.4196,689.0426 L353.9741,690.1275 L354.159,703.0106 L354.3438,695.5519 L354.5287,680.9059 L354.7135,682.9401 L355.268,674.939 L355.4529,673.8541 L355.6377,675.3458 L355.8226,678.1937 L356.0074,676.9731 L356.5619,681.9908 L356.7468,673.8541 L356.9316,682.1264 L357.1165,676.2951 L357.3013,669.1077 L357.8558,676.8375 L358.0407,668.1584 L358.2255,672.0911 L358.4104,677.9224 L358.5952,680.6347 L359.1497,680.9059 L359.3346,663.6832 L359.5194,646.4605 L359.7043,641.0361 L359.8891,644.6976 L360.4436,651.4782 L360.6285,663.0052 L360.8133,665.9886 L360.9982,666.3954 L361.183,668.4296 L361.7375,665.9886 L361.9224,664.6325 L362.1072,668.4296 L362.2921,675.617 L362.4769,689.4494 L363.0314,695.1451 L363.2163,689.3138 L363.4011,697.1793 L363.586,697.9929 L363.7708,689.4494 L364.5102,671.8199 L364.695,681.9908 L364.8799,684.703 L365.0647,682.1264 L365.6192,690.8055 L365.8041,685.3811 L365.9889,692.026 L366.1738,691.8904 L366.3586,680.6347 L366.9131,681.9908 L367.098,698.9422 L367.2828,710.8761 L367.4677,702.3325 L367.6525,702.4681 L368.207,707.0789 L368.3919,706.4009 L368.5767,721.0469 L368.7616,714.8088 L368.9464,706.6721 L369.5009,716.3005 L369.6858,721.8606 L369.8706,724.0304 L370.0555,724.0304 L370.2403,720.3689 L370.9797,734.4725 L371.1645,746.1351 L371.3494,749.5254 L371.5342,757.9333 L372.0887,752.102 L372.2736,751.0171 L372.4584,741.6599 L372.6433,737.5915 L372.8281,743.4228 L373.3826,742.3379 L373.5675,732.8451 L373.7523,723.8948 L373.9372,714.5376 L374.122,721.9962 L374.6765,705.0448 L374.8614,706.4009 L375.0462,700.9764 L375.2311,674.5321 L375.4159,664.09 L375.9704,672.498 L376.1553,667.0735 L376.3401,665.0393 L376.525,665.3106 L376.7098,672.2267 L377.2643,684.025 L377.4492,667.7516 L377.634,677.6512 L377.8189,679.9566 L378.0037,684.4318 L378.5582,690.6699 L378.7431,687.2796 L378.9279,691.6192 L379.1128,667.7516 L379.2976,674.1253 L379.8521,681.8552 L380.037,699.4847 L380.2218,710.4692 L380.4067,708.9775 L380.5915,707.757 L381.146,709.1131 L381.3309,680.4991 L381.5157,689.0426 L381.7006,679.821 L381.8854,688.3645 L382.6248,684.4318 L382.8096,667.0735 L382.9945,647.1386 L383.1793,667.3447 L383.7338,679.9566 L383.9187,680.6347 L384.1035,677.2444 L384.2884,658.2587 L384.4732,662.0559 L385.0277,660.971 L385.2126,650.1221 L385.3974,642.9346 L385.5823,641.3073 L385.7671,634.1199 L386.3216,630.4584 L386.5065,626.39 L386.6913,634.5267 L386.8762,630.1871 L387.061,617.5753 L387.6155,616.8972 L387.8004,620.9656 L387.9852,616.2191 L388.1701,621.6436 L388.3549,621.6436 L389.0943,619.6094 L389.2791,620.0163 L389.464,614.185 L389.6488,599.4033 L390.2033,594.5213 L390.3882,596.1486 L390.573,604.9634 L390.7579,588.4188 L390.9427,612.9645 L391.4972,606.5907 L391.6821,620.9656 L391.8669,627.4749 L392.0518,637.917 L392.2366,634.5267 L392.7911,637.3746 L392.976,631.8145 L393.1608,632.4925 L393.3457,641.3073 L393.5305,664.3613 L394.085,671.8199 L394.2699,663.6832 L394.4547,658.2587 L394.8244,674.3965 L395.3789,660.971 L395.5638,669.9213 L395.7486,660.8354 L395.9335,671.8199 L396.1183,670.4638 L396.6728,664.3613 L396.8577,660.1573 L397.0425,679.9566 L397.4122,683.7537 L397.9667,688.907 L398.1516,700.9764 L398.3364,697.5861 L398.5213,695.9588 L398.7061,690.1275 L399.2606,660.971 L399.4455,660.5641 L399.6303,657.5807 L399.8152,660.971 L400,661.649 L400.5545,660.6998 L400.7394,677.2444 L400.9242,680.6347 L401.1091,675.4814 L401.2939,682.6688 L401.8484,687.4152 L402.0333,678.1937 L402.2181,684.025 L402.403,670.3282 L402.5878,671.2775 L403.1423,668.7008 L403.3272,669.7857 L403.512,669.3789 L403.6969,674.5321 L403.8817,671.8199 L404.4362,655.5465 L404.6211,641.9854 L404.8059,635.8828 L404.9908,627.7461 L405.1756,640.0868 L405.7301,641.4429 L405.915,627.0681 L406.0998,629.1023 L406.2847,626.7969 L406.4695,644.2908 L407.2089,640.6292 L407.3937,632.7638 L407.5786,619.2026 L407.7634,623.8134 L408.3179,621.6436 L408.5028,626.7969 L408.6876,638.5951 L408.8725,642.9346 L409.0573,663.6832 L409.6118,667.4803 L409.7967,671.8199 L409.9815,684.025 L410.1664,688.7714 L410.3512,703.6886 L410.9057,703.4174 L411.0906,677.9224 L411.2754,676.5663 L411.4603,684.4318 L411.6451,702.6037 L412.1996,707.0789 L412.3845,698.9422 L412.5693,686.7372 L412.7542,685.3811 L412.939,694.3314 L413.6784,669.7857 L413.8632,685.7879 L414.0481,694.7383 L414.2329,704.6379 L414.7874,700.9764 L414.9723,721.9962 L415.1571,712.639 L415.342,724.0304 L415.5268,717.9279 L416.0813,728.5056 L416.2662,723.0811 L416.451,711.8253 L416.6359,717.2498 L416.8207,720.2333 L417.3752,721.725 L417.5601,729.4548 L417.7449,728.7768 L417.9298,726.4714 L418.1146,732.1671 L418.854,729.4548 L419.0388,732.1671 L419.2237,715.2156 L419.4085,704.3667 L419.963,711.8253 L420.1479,709.5199 L420.3327,709.7912 L420.5176,702.7394 L420.7024,702.7394 L421.2569,694.8739 L421.4418,696.9081 L421.6266,705.7228 L421.8115,719.284 L421.9963,715.2156 L422.7357,709.3843 L422.9205,708.1638 L423.1054,708.2994 L423.2902,711.1473 L423.8447,712.0966 L424.0296,724.166 L424.2144,722.403 L424.3993,719.1484 L424.5841,721.3181 L425.1386,719.284 L425.3235,721.0469 L425.5083,719.962 L425.6932,726.3358 L425.878,751.8308 L426.4325,752.102 L426.6174,747.7624 L426.8022,745.7282 L426.9871,768.7822 L427.1719,788.7171 L427.7264,785.7337 L427.9113,785.0556 L428.281,828.1801 L428.4658,804.4481 L429.0203,817.6024 L429.2052,826.6884 L429.39,840.6564 L429.5749,852.4546 L429.7597,847.4369 L430.3142,840.3851 L430.4991,864.6596 L430.6839,860.9981 L430.8688,867.7787 L431.0536,844.7247 L431.793,834.5538 L431.9778,832.1128 L432.1627,839.3002 L432.3475,817.0599 L432.902,809.4657 L433.0869,795.9045 L433.2717,797.2606 L433.4566,819.6366 L433.6414,817.0599 L434.1959,811.4999 L434.3808,810.1437 L434.5656,824.6542 L434.7505,813.8053 L434.9353,805.3973 L435.4898,806.8891 L435.6747,814.2121 L435.8595,831.8416 L436.0444,812.856 L436.2292,826.4171 L436.7837,829.1294 L436.9686,827.7733 L437.1534,813.2628 L437.3383,801.4646 L437.5231,810.1437 L438.0776,809.4657 L438.4473,811.4999 L438.6322,811.4999 L438.817,808.3808 L439.3715,809.1945 L439.5564,808.7876 L439.7412,818.5517 L439.9261,829.1294 L440.1109,829.1294 L440.6654,838.6222 L440.8503,835.2319 L441.0351,835.6387 L441.22,815.0258 L441.4048,805.1261 L441.9593,808.7876 L442.1442,802.0071 L442.329,806.8891 L442.5139,812.0423 L442.6987,824.383 L443.2532,830.0787 L443.4381,828.8582 L443.6229,837.8085 L443.8078,834.9607 L443.9926,824.7898 L444.5471,818.2804 L444.732,824.7898 L444.9168,828.8582 L445.1017,830.4855 L445.2865,822.3488 L445.841,819.6366 L446.0259,820.179 L446.2107,829.4006 L446.3956,828.8582 L446.5804,842.0125 L447.1349,841.3344 L447.3198,855.3024 L447.5046,853.1326 L447.6895,854.0819 L447.8743,862.3542 L448.4288,866.287 L448.6137,879.8481 L448.7985,887.4424 L448.9834,893.5449 L449.1682,881.3398 L449.9076,892.5956 L450.0924,901.6816 L450.2773,911.8525 L450.4621,936.805 L451.0166,946.7046 L451.2015,960.6726 L451.3863,946.4334 L451.5712,955.2482 L451.756,962.7068 L452.3105,961.3507 L452.4954,952.5359 L452.6802,948.8744 L452.8651,925.4136 L453.0499,886.3575 L453.6044,890.1546 L453.7893,882.0179 L453.9741,881.0686 L454.159,877.2715 L454.3438,856.6585 L454.8983,871.847 L455.0832,886.7643 L455.268,887.7136 L455.4529,895.3078 L455.6377,903.0377 L456.3771,897.7488 L456.5619,879.3057 L456.7468,863.7103 L456.9316,882.4247 L457.4861,901.6816 L457.671,905.6143 L457.8558,900.4611 L458.0407,906.1568 L458.2255,902.6309 L458.78,888.7985 L458.9649,896.9352 L459.1497,917.955 L459.3346,920.9384 L459.5194,893.2737 L460.0739,891.5107 L460.2588,894.901 L460.4436,902.0884 L460.6285,903.7158 L460.8133,897.7488 L461.3678,919.9892 L461.5527,921.3453 L461.7375,931.3805 L461.9224,930.5669 L462.1072,922.0233 L462.6617,910.7676 L462.8466,921.8877 L463.0314,928.5327 L463.2163,932.4654 L463.4011,932.1942 L463.9556,933.2791 L464.1405,941.687 L464.3253,952.9428 L464.695,963.7917 L465.2495,942.3651 L465.4344,938.7036 L465.6192,935.042 L465.8041,934.9064 L465.9889,912.8017 L466.5434,892.46 L466.7283,907.7841 L466.9131,913.8866 L467.098,909.1402 L467.2828,903.4445 L467.8373,888.256 L468.0222,898.2913 L468.207,894.2229 L468.3919,873.2031 L468.5767,859.9132 L469.1312,871.5758 L469.3161,879.3057 L469.5009,863.4391 L469.6858,867.5075 L469.8706,857.201 L470.61,854.8956 L470.7948,839.7071 L470.9797,840.3851 L471.1645,833.8758 L471.9039,830.8923 L472.0887,821.6707 L472.2736,837.2661 L472.4584,829.1294 L473.0129,831.9772 L473.1978,841.3344 L473.3826,839.9783 L473.5675,832.5197 L473.7523,857.879 L474.4917,871.847 L474.6765,865.3377 L474.8614,860.9981 L475.0462,870.7621 L475.6007,875.2373 L475.7856,866.4226 L475.9704,879.8481 L476.1553,881.3398 L476.3401,883.374 L476.8946,886.0862 L477.0795,879.9837 L477.2643,880.2549 L477.4492,858.2859 L477.634,869.5416 L478.1885,861.6762 L478.3734,884.0521 L478.5582,877.5427 L478.7431,903.7158 L478.9279,896.9352 L479.4824,893.8161 L479.6673,894.2229 L479.8521,885.0014 L480.037,896.9352 L480.2218,894.901 L480.9612,904.2582 L481.146,911.1744 L481.3309,902.7665 L481.5157,899.6474 L482.0702,903.7158 L482.2551,908.4622 L482.4399,904.665 L482.6248,888.3916 L482.8096,865.0664 L483.3641,870.2197 L483.549,874.5593 L483.7338,880.3906 L483.9187,872.9319 L484.1035,871.847 L484.658,872.5251 L484.8429,893.8161 L485.0277,895.9859 L485.2126,904.2582 L485.3974,927.4478 L485.9519,931.2449 L486.1368,924.7356 L486.3216,921.3453 L486.5065,933.1435 L486.6913,923.7863 L487.2458,916.5989 L487.4307,924.0575 L487.6155,915.6496 L487.8004,922.4302 L487.9852,937.6187 L488.5397,936.2625 L488.7246,922.0233 L488.9094,915.9208 L489.0943,927.3122 L489.2791,911.4456 L489.8336,899.6474 L490.0185,914.5647 L490.2033,917.2769 L490.3882,910.3607 L490.573,915.3784 L491.1275,914.5647 L491.3124,924.4643 L491.4972,928.5327 L491.6821,913.751 L491.8669,905.3431 L492.4214,912.2593 L492.6063,913.8866 L492.7911,909.5471 L492.976,912.1237 L493.1608,914.2935 L493.7153,921.8877 L493.9002,917.2769 L494.085,916.5989 L494.2699,919.7179 L494.4547,914.2935 L495.0092,909.1402 L495.1941,920.6672 L495.3789,935.042 L495.5638,938.1611 L495.7486,939.3816 L496.3031,939.5172 L496.488,931.3805 L496.6728,923.6507 L496.8577,921.3453 L497.0425,918.2262 L497.597,911.8525 L497.7819,925.6848 L497.9667,930.16 L498.1516,949.4169 L498.3364,935.3133 L499.0758,938.0255 L499.2606,929.3464 L499.4455,939.6528 L499.6303,941.687 L500.1848,946.7046 L500.3697,948.0608 L500.5545,976.1324 L500.7394,976.946 L500.9242,988.2018 L501.4787,1000 L501.6636,993.0838 L501.8484,975.7255 L502.0333,962.7068 L502.2181,955.7906 L502.7726,958.7741 L502.9575,962.3 L503.1423,969.8942 L503.3272,940.7377 L503.512,944.3992 L504.0665,945.7554 L504.2514,942.5007 L504.4362,937.6187 L504.6211,953.8921 L504.8059,952.9428 L505.3604,940.6021 L505.5453,955.5194 L505.915,963.6561 L506.0998,949.01 L506.6543,952.4003 L506.8392,950.0949 L507.024,946.9759 L507.2089,954.5701 L507.3937,964.0629 L507.9482,961.8931 L508.1331,958.3672 L508.3179,941.687 L508.5028,937.6187 L508.6876,924.0575 L509.2421,938.2967 L509.427,933.1435 L509.6118,925.4136 L509.7967,927.4478 L509.9815,928.6683 L510.536,928.1258 L510.7209,929.2107 L510.9057,918.633 L511.0906,923.3794 L511.2754,927.041 L511.8299,939.6528 L512.0148,940.4665 L512.1996,945.0773 L512.3845,933.8215 L512.5693,926.3629 L513.1238,933.9571 L513.3087,924.7356 L513.4935,911.9881 L513.6784,903.987 L513.8632,900.3255 L514.4177,903.0377 L514.6026,899.9186 L514.7874,890.4258 L514.9723,898.5625 L515.1571,903.3089 L515.7116,905.0719 L515.8965,895.4434 L516.0813,893.5449 L516.2662,885.137 L516.451,894.2229 L517.1904,903.1733 L517.3752,888.3916 L517.5601,887.3068 L517.7449,878.492 L518.2994,884.0521 L519.5933,873.7456 L519.7782,877.2715 L519.963,866.5582 L520.1479,876.3222 L520.3327,889.2053 L520.8872,879.8481 L521.0721,869.5416 L521.2569,862.3542 L521.4418,863.9816 L521.6266,869.6772 L522.1811,856.9298 L522.366,879.5769 L522.5508,860.8625 L522.7357,858.4215 L522.9205,855.5736 L523.6599,881.3398 L523.8447,896.9352 L524.0296,907.106 L524.2144,893.1381 L524.7689,899.6474 L524.9538,898.5625 L525.1386,894.901 L525.3235,903.7158 L525.5083,912.9373 L526.0628,927.4478 L526.2477,934.364 L526.4325,927.719 L526.6174,921.8877 L526.8022,916.192 L527.3567,892.1888 L527.5416,889.3409 L527.7264,890.9683 L527.9113,879.3057 L528.0961,879.9837 L528.6506,886.0862 L528.8355,883.2384 L529.0203,875.2373 L529.2052,890.1546 L529.39,885.5438 L530.1294,905.7499 L530.3142,905.2075 L530.4991,921.3453 L530.6839,925.6848 L531.2384,948.8744 L531.4233,938.9748 L531.6081,942.5007 L531.9778,950.5018 L532.5323,946.4334 L532.7172,944.8061 L532.902,931.5161 L533.0869,931.923 L533.2717,928.8039 L533.8262,933.9571 L534.0111,934.0928 L534.1959,941.1446 L534.3808,929.482 L534.5656,920.6672 L535.1201,917.0057 L535.305,913.8866 L535.4898,903.7158 L535.6747,901.8172 L535.8595,889.2053 L536.414,883.6452 L536.5989,886.7643 L536.7837,894.4942 L536.9686,900.4611 L537.1534,911.1744 L537.7079,911.1744 L538.0776,896.9352 L538.2625,890.1546 L538.4473,898.9694 L539.0018,889.7478 L539.3715,902.224 L539.5564,909.1402 L539.7412,901.6816 L540.2957,911.1744 L540.4806,905.6143 L540.6654,912.8017 L540.8503,904.665 L541.0351,902.6309 L541.5896,898.0201 L541.7745,902.3596 L541.9593,912.5305 L542.1442,916.192 L542.329,913.8866 L543.0684,923.3794 L543.2532,926.3629 L543.4381,932.3298 L543.6229,950.3662 L544.1774,953.3496 L544.3623,945.4841 L544.5471,941.687 L544.732,947.1115 L544.9168,941.9582 L545.4713,936.6694 L545.6562,940.3309 L545.841,944.6705 L546.0259,951.8579 L546.2107,939.5172 L546.7652,931.2449 L546.9501,919.7179 L547.1349,922.9726 L547.3198,924.7356 L547.5046,920.6672 L548.244,922.4302 L548.4288,926.9053 L548.6137,929.0751 L548.7985,922.5658 L549.353,927.719 L549.5379,932.8723 L549.7227,941.009 L549.9076,945.891 L550.0924,937.6187 L550.647,932.4654 L550.8318,934.6352 L551.0166,931.1093 L551.2015,930.16 L551.3863,932.601 L551.9409,933.5503 L552.1257,943.5856 L552.3105,942.0938 L552.4954,936.2625 L552.6802,931.1093 L553.2348,928.6683 L553.4196,934.4996 L553.6044,928.1258 L553.7893,924.4643 L553.9741,927.719 L554.5287,928.8039 L554.7135,926.7697 L554.8983,931.1093 L555.0832,930.5669 L555.268,929.482 L555.8226,908.1909 L556.0074,914.8359 L556.1922,915.9208 L556.3771,916.0564 L556.5619,915.9208 L557.1165,921.3453 L557.3013,916.5989 L557.4861,913.8866 L557.671,911.5812 L557.8558,913.073 L558.4104,912.9373 L558.5952,909.6827 L558.78,903.987 L558.9649,898.4269 L559.1497,899.3762 L559.7043,897.2064 L559.8891,897.4776 L560.0739,898.2913 L560.2588,890.1546 L560.4436,889.4765 L560.9982,883.1028 L561.183,886.7643 L561.3678,879.1701 L561.5527,875.9154 L561.7375,873.3388 L562.2921,871.7114 L562.4769,871.847 L562.6617,891.1039 L562.8466,884.0521 L563.0314,881.2042 L563.586,883.6452 L563.7708,899.105 L563.9556,887.7136 L564.1405,886.4931 L564.3253,881.7467 L564.8799,883.6452 L565.0647,886.3575 L565.2495,883.5096 L565.4344,889.4765 L565.6192,885.137 L566.3586,879.5769 L566.5434,882.0179 L566.7283,874.5593 L566.9131,878.6276 L567.4677,879.0344 L567.6525,881.3398 L567.8373,885.5438 L568.0222,882.9672 L568.207,881.4755 L568.7616,880.6618 L568.9464,870.3553 L569.1312,867.7787 L569.3161,867.2362 L569.5009,863.7103 L570.0555,857.3366 L570.2403,845.674 L570.4251,844.9959 L570.61,830.2143 L570.7948,829.5362 L571.3494,820.179 L571.5342,827.9089 L571.719,798.3455 L571.9039,789.1239 L572.0887,794.5484 L572.6433,786.1405 L572.8281,787.0898 L573.0129,791.4293 L573.3826,799.8373 L573.9372,780.5804 L574.122,764.7139 L574.3068,762.2729 L574.4917,753.8649 L574.6765,759.9675 L575.2311,738.812 L575.4159,733.7944 L575.6007,735.2861 L575.7856,734.8793 L575.9704,721.3181 L576.525,719.284 L576.7098,738.6764 L576.8946,726.7426 L577.0795,725.5221 L577.2643,741.6599 L577.8189,750.4746 L578.0037,729.4548 L578.1885,743.016 L578.3734,749.3897 L578.5582,731.6246 L579.1128,737.5915 L579.2976,775.9696 L579.4824,779.7667 L579.6673,790.0732 L579.8521,795.9045 L580.4067,784.7844 L580.5915,785.7337 L580.7763,767.8329 L580.9612,778.9531 L581.146,777.3257 L581.7006,790.8869 L581.8854,791.7006 L582.0702,787.7678 L582.2551,801.7358 L582.4399,798.6168 L582.9945,795.7689 L583.1793,786.4117 L583.3641,778.5462 L583.549,762.1372 L583.7338,763.2221 L584.4732,743.016 L584.658,740.7106 L584.8429,738.2696 L585.0277,746.8131 L585.5823,748.4405 L585.7671,754.0005 L585.9519,761.0523 L586.1368,753.3225 L586.3216,748.4405 L586.8762,768.1041 L587.061,781.2585 L587.2458,756.5772 L587.4307,753.8649 L587.6155,752.102 L588.1701,749.7966 L588.3549,751.1527 L588.5397,743.016 L588.7246,751.4239 L588.9094,753.4581 L589.464,732.8451 L589.6488,731.7602 L589.8336,738.9477 L590.0185,732.3027 L590.2033,734.2012 L590.7579,740.575 L590.9427,750.6103 L591.1275,747.0844 L591.3124,743.016 L591.4972,745.7282 L592.2366,754.2718 L592.4214,754.1362 L592.6063,756.5772 L592.7911,765.2563 L593.3457,771.0876 L593.5305,764.9851 L593.7153,760.1031 L593.9002,762.9509 L594.085,755.4923 L594.6396,746.1351 L594.8244,748.4405 L595.0092,750.7459 L595.1941,742.3379 L595.3789,741.2531 L595.9335,753.8649 L596.1183,743.016 L596.3031,747.7624 L596.488,719.8264 L596.6728,703.6886 L597.4122,708.5707 L597.597,712.5034 L597.7819,720.9113 L597.9667,720.6401 L598.5213,720.6401 L598.7061,708.435 L598.8909,726.0646 L599.0758,725.6577 L599.2606,722.2674 L599.8152,737.3203 L600,762.0016 L600.1848,768.1041 L600.5545,752.78 L601.1091,752.5088 L601.2939,734.6081 L601.4787,735.2861 L601.6636,731.7602 L601.8484,728.7768 L602.403,721.3181 L602.5878,732.9807 L602.7726,726.8782 L602.9575,719.284 L603.1423,706.2653 L603.6969,705.0448 L603.8817,697.1793 L604.0665,692.1616 L604.2514,694.0602 L604.4362,690.1275 L604.9908,709.7912 L605.1756,697.8573 L605.5453,695.1451 L605.7301,689.1782 L606.2847,686.1947 L606.4695,679.2785 L606.8392,695.5519 L607.024,686.0591 L607.5786,681.3127 L607.7634,684.703 L607.9482,683.6181 L608.1331,687.4152 L608.3179,681.4483 L608.8725,688.0933 L609.0573,682.6688 L609.2421,688.2289 L609.427,682.262 L609.6118,668.7008 L610.3512,675.4814 L610.536,670.1926 L610.7209,660.5641 L610.9057,648.7659 L611.4603,644.562 L611.6451,637.917 L611.8299,630.1871 L612.0148,626.7969 L612.1996,631.4076 L612.7542,637.2389 L612.939,627.0681 L613.1238,630.4584 L613.3087,644.1551 L613.4935,653.648 L614.0481,654.8685 L614.2329,665.9886 L614.4177,671.1418 L614.6026,663.8188 L614.7874,677.9224 L615.5268,702.875 L615.7116,697.9929 L615.8965,702.3325 L616.0813,710.6048 L616.6359,711.1473 L616.8207,729.1836 L617.0055,718.4703 L617.1904,719.5552 L617.3752,727.8275 L617.9298,725.3865 L618.1146,716.5717 L618.2994,691.7548 L618.4843,685.5167 L618.6691,689.4494 L619.2237,691.2124 L619.4085,687.0084 L619.5933,674.6678 L619.7782,684.4318 L619.963,716.4361 L620.5176,735.2861 L620.7024,743.1516 L620.8872,739.8969 L621.0721,736.9135 L621.2569,738.2696 L621.8115,726.3358 L621.9963,731.8959 L622.1811,727.1494 L622.366,736.0998 L622.5508,736.5066 L623.1054,720.6401 L623.2902,723.7592 L623.475,738.4052 L623.6599,730.4041 L623.8447,746.8131 L624.3993,759.9675 L624.5841,759.0182 L624.7689,751.5595 L624.9538,730.2685 L625.1386,731.0822 L625.6932,731.0822 L625.878,732.1671 L626.0628,727.4207 L626.2477,726.3358 L626.4325,728.3699 L626.9871,747.4912 L627.1719,723.6235 L627.3567,717.2498 L627.5416,696.0944 L627.7264,703.6886 L628.281,704.9091 L628.4658,705.1804 L628.6506,692.1616 L628.8355,678.1937 L629.0203,689.4494 L629.5749,684.025 L629.7597,673.176 L629.9445,701.6545 L630.1294,687.5509 L630.3142,686.0591 L630.8688,679.2785 L631.0536,679.6854 L631.2384,670.057 L631.4233,656.6314 L631.6081,659.4793 L632.1627,644.4264 L632.3475,638.8663 L632.5323,635.8828 L632.7172,645.24 L632.902,641.1717 L633.6414,637.917 L634.0111,626.5256 L634.1959,638.8663 L634.7505,641.7141 L634.9353,654.4616 L635.1201,647.003 L635.305,611.2015 L635.4898,607.8112 L636.0444,630.8652 L636.2292,621.2368 L636.414,600.6238 L636.5989,599.6745 L636.7837,600.4882 L637.3383,581.6382 L637.5231,578.2479 L637.7079,583.9436 L637.8928,591.8091 L638.0776,604.8278 L638.6322,599.6745 L638.817,609.8454 L639.0018,585.4353 L639.1867,605.3702 L639.3715,625.4407 L639.9261,620.4231 L640.1109,607.2688 L640.2957,604.5566 L640.4806,594.7925 L641.22,622.3217 L641.4048,647.9523 L641.5896,650.6645 L641.7745,647.9523 L641.9593,648.3591 L642.5139,659.8861 L642.6987,694.0602 L642.8835,698.671 L643.0684,706.6721 L643.2532,710.198 L643.8078,690.8055 L643.9926,695.1451 L644.1774,679.9566 L644.3623,677.2444 L644.5471,665.3106 L645.1017,655.2753 L645.2865,661.649 L645.4713,669.5145 L645.6562,679.9566 L645.841,686.0591 L646.3956,681.3127 L646.5804,680.6347 L646.7652,681.1771 L646.9501,669.1077 L647.1349,681.3127 L647.6895,682.9401 L647.8743,688.3645 L648.0591,681.0415 L648.244,692.1616 L648.4288,697.8573 L648.9834,706.9433 L649.1682,709.5199 L649.353,702.7394 L649.5379,713.1814 L649.7227,725.3865 L650.2773,729.048 L650.4621,728.5056 L650.647,726.607 L650.8318,723.3523 L651.0166,722.9455 L651.756,727.4207 L651.9409,728.5056 L652.1257,721.3181 L652.3105,706.9433 L652.8651,711.4185 L653.0499,704.5023 L653.2348,706.1296 L653.4196,700.7052 L653.6044,683.7537 L654.159,689.7206 L654.3438,709.6555 L654.5287,686.1947 L654.7135,671.1418 L654.8983,649.444 L655.4529,628.153 L655.6377,616.2191 L655.8226,616.4904 L656.0074,612.5576 L656.1922,611.2015 L656.7468,605.099 L656.9316,608.0825 L657.1165,601.7087 L657.3013,590.4529 L657.4861,606.7263 L658.0407,591.5378 L658.2255,606.9976 L658.4104,611.0659 L658.5952,609.5742 L658.78,603.4717 L659.5194,592.2159 L659.7043,597.5047 L659.8891,589.0968 L660.0739,594.3857 L660.6285,590.5886 L660.8133,590.9954 L660.9982,565.3648 L661.183,564.2799 L661.3678,560.3472 L661.9224,563.0594 L662.1072,562.517 L662.2921,558.1774 L662.4769,553.1598 L662.6617,562.517 L663.2163,585.5709 L663.4011,583.4011 L663.586,586.3846 L663.7708,598.1828 L663.9556,596.1486 L664.5102,592.2159 L664.8799,587.7407 L665.0647,572.8234 L665.2495,578.1123 L665.8041,572.1454 L665.9889,556.8213 L666.1738,558.991 L666.3586,553.2954 L666.5434,553.1598 L667.098,563.3306 L667.2828,558.8554 L667.4677,544.345 L667.8373,526.8511 L668.3919,528.2072 L668.5767,517.0871 L668.7616,522.9184 L668.9464,529.4277 L669.1312,519.9349 L669.6858,511.2558 L669.8706,498.237 L670.0555,496.0673 L670.2403,496.2029 L670.4251,493.355 L670.9797,495.5248 L671.1645,487.3881 L671.3494,473.1489 L671.5342,465.2834 L671.719,465.0122 L672.2736,470.4367 L672.4584,468.4025 L672.6433,455.1126 L673.0129,458.2316 L673.5675,460.9439 L673.7523,449.9593 L673.9372,442.3651 L674.3068,434.2284 L674.8614,409.4114 L675.0462,387.7136 L675.2311,394.7654 L675.4159,375.1017 L675.6007,356.9298 L676.1553,351.6409 L676.3401,362.3542 L676.525,365.4733 L676.7098,393.1381 L676.8946,421.4809 L677.634,395.5791 L677.8189,380.933 L678.0037,360.4557 L678.1885,393.4093 L678.7431,393.8161 L678.9279,383.374 L679.1128,370.7621 L679.2976,405.7499 L679.4824,391.7819 L680.037,396.2571 L680.2218,369.406 L680.4067,375.5085 L680.5915,369.6772 L680.7763,358.6927 L681.3309,342.2837 L681.5157,326.4171 L681.7006,305.6686 L681.8854,297.5319 L682.0702,308.3808 L682.8096,279.2243 L682.9945,282.2078 L683.1793,296.0401 L683.3641,330.3499 L683.9187,327.9089 L684.1035,298.7524 L684.2884,318.2804 L684.4732,338.351 L684.658,342.9618 L685.2126,328.7225 L685.3974,368.5924 L685.5823,394.901 L685.7671,387.0355 L685.9519,362.8967 L686.5065,357.0654 L686.6913,367.3718 L686.8762,420.9384 L687.061,419.8535 L687.2458,428.6683 L687.8004,421.8877 L687.9852,406.6992 L688.1701,403.0377 L688.3549,371.7114 L688.5397,384.3233 L689.0943,355.1668 L689.2791,352.8614 L689.464,373.3388 L689.6488,407.5129 L689.8336,406.8348 L690.3882,398.8337 L690.573,382.5603 L690.7579,366.6938 L690.9427,344.4535 L691.1275,381.2042 L691.6821,401.9528 L691.8669,370.2197 L692.0518,365.3377 L692.2366,376.8647 L692.4214,377.2715 L692.976,372.3895 L693.1608,399.2406 L693.3457,434.2284 L693.5305,450.0949 L693.7153,420.396 L694.2699,413.4798 L694.4547,432.601 L694.6396,458.9097 L694.8244,463.7917 L695.0092,465.1478 L695.5638,440.3309 L695.7486,431.1093 L695.9335,458.9097 L696.1183,454.7057 L696.3031,455.655 L696.8577,458.9097 L697.0425,433.5503 L697.2274,430.16 L697.4122,428.9395 L697.597,442.3651 L698.1516,458.5028 L698.3364,482.7773 L698.5213,455.7906 L698.7061,477.3529 L698.8909,477.3529 L699.4455,462.3 L699.6303,462.3 L699.8152,444.3992 L700,460.2658 L700.1848,437.2118 L700.7394,433.4147 L700.9242,402.6309 L701.1091,401.6816 L701.2939,370.8977 L701.4787,376.1866 L702.2181,372.2539 L702.403,369.2704 L702.5878,368.4567 L702.7726,371.169 L703.3272,368.5924 L703.512,371.9826 L703.6969,381.3398 L703.8817,369.406 L704.0665,397.2064 L704.6211,400.8679 L704.8059,383.2384 L704.9908,385.4082 L705.1756,374.6949 L705.3604,371.0334 L705.915,378.8988 L706.0998,391.5107 L706.2847,395.9859 L706.4695,391.6463 L706.6543,391.3751 L707.2089,381.0686 L707.3937,408.7334 L707.5786,403.8514 L707.7634,399.2406 L707.9482,380.2549 L708.6876,363.5747 L708.8725,343.5042 L709.0573,344.1823 L709.2421,345.674 L709.7967,334.147 L709.9815,347.7082 L710.1664,344.4535 L710.3512,347.0301 L710.536,324.9254 L711.0906,321.3995 L711.2754,345.5384 L711.4603,372.9319 L711.6451,357.201 L711.8299,377.4071 L712.3845,367.6431 L712.5693,391.2395 L712.7542,390.8327 L712.939,397.342 L713.1238,396.1215 L713.6784,383.9165 L713.8632,387.9848 L714.0481,387.3068 L714.2329,389.6122 L714.4177,358.6927 L714.9723,366.287 L715.1571,368.4567 L715.342,382.9672 L715.5268,392.46 L715.7116,362.3542 L716.2662,367.7787 L716.451,381.8823 L716.6359,390.4258 L716.8207,378.492 L717.0055,392.0532 L717.5601,401.546 L717.7449,429.7532 L717.9298,425.6848 L718.1146,429.2107 L718.2994,431.6517 L718.854,431.1093 L719.0388,416.7345 L719.2237,429.0751 L719.4085,432.3298 L719.5933,453.6208 L720.3327,457.1467 L720.5176,436.9406 L720.7024,440.8733 L720.8872,423.7863 L721.4418,426.9053 L721.6266,420.8028 L721.8115,451.8579 L721.9963,433.2791 L722.1811,431.6517 L722.7357,437.2118 L722.9205,428.2615 L723.1054,427.8546 L723.2902,420.5316 L723.475,416.7345 L724.0296,410.632 L724.2144,406.6992 L724.3993,425.0068 L724.5841,408.7334 L724.7689,424.1931 L725.3235,444.3992 L725.5083,444.2636 L725.6932,449.4169 L725.878,445.0773 L726.0628,429.7532 L726.8022,437.3474 L726.9871,435.8557 L727.1719,424.7356 L727.3567,414.4291 L727.9113,419.5823 L728.0961,415.6496 L728.281,395.5791 L728.4658,380.6618 L728.6506,383.374 L729.2052,366.1513 L729.39,370.8977 L729.5749,377.1359 L729.7597,377.5427 L729.9445,374.1524 L730.4991,377.1359 L730.6839,368.728 L730.8688,360.5913 L731.0536,361.2693 L731.2384,347.4369 L731.793,344.4535 L731.9778,341.0632 L732.1627,356.3873 L732.5323,346.0808 L733.0869,355.8449 L733.2717,347.1657 L733.4566,342.2837 L733.6414,351.2341 L733.8262,339.5715 L734.3808,340.9276 L734.5656,324.2474 L734.7505,310.6862 L735.1201,290.0732 L735.6747,292.3786 L735.8595,275.4272 L736.0444,245.0502 L736.2292,254.8142 L736.414,234.4725 L736.9686,227.9631 L737.1534,223.0811 L737.3383,246.9487 L737.5231,260.2387 L737.7079,267.1549 L738.2625,253.4581 L738.4473,252.9156 L738.6322,224.844 L738.817,234.4725 L739.0018,232.4383 L739.5564,219.962 L739.7412,249.661 L739.9261,268.3754 L740.1109,259.1538 L740.2957,253.3225 L740.8503,235.2861 L741.0351,242.4736 L741.22,264.0358 L741.4048,255.4923 L741.5896,263.629 L742.1442,277.4614 L742.329,307.8384 L742.5139,302.2783 L742.6987,319.0941 L742.8835,325.7391 L743.4381,319.0941 L743.6229,312.9916 L743.8078,294.5484 L743.9926,308.1096 L744.1774,326.6884 L744.9168,326.9596 L745.1017,320.3146 L745.2865,323.2981 L745.4713,320.5858 L746.0259,315.4326 L746.2107,333.1977 L746.3956,307.974 L746.5804,303.4988 L746.7652,305.6686 L747.3198,305.6686 L747.5046,313.534 L747.6895,308.9232 L747.8743,311.7711 L748.0591,305.6686 L748.6137,338.6222 L748.7985,343.6398 L748.9834,342.0125 L749.1682,324.9254 L749.353,331.4348 L749.9076,296.5826 L750.0924,299.7017 L750.2773,315.1614 L750.4621,292.1074 L750.647,292.243 L751.3863,272.8506 L751.5712,276.3765 L751.756,271.2232 L751.9409,265.1207 L752.4954,251.5595 L752.6802,257.3908 L752.8651,268.511 L753.0499,272.0369 L753.2348,252.3732 L753.7893,263.7646 L753.9741,245.7282 L754.159,252.9156 L754.3438,253.7293 L754.5287,249.9322 L755.0832,269.5959 L755.268,267.1549 L755.4529,249.5254 L755.6377,252.78 L755.8226,259.2894 L756.3771,288.8527 L756.5619,285.7337 L756.7468,324.383 L756.9316,324.7898 L757.1165,328.1801 L757.671,331.8416 L757.8558,318.9585 L758.0407,310.2794 L758.2255,300.5153 L758.4104,313.9409 L758.9649,321.5351 L759.1497,316.1107 L759.3346,314.2121 L759.5194,316.7887 L759.7043,309.1945 L760.2588,297.8031 L760.4436,306.7535 L760.6285,294.8196 L760.8133,311.6355 L760.9982,294.8196 L761.5527,278.275 L761.7375,262.9509 L761.9224,258.6113 L762.1072,271.2232 L762.2921,264.8495 L762.8466,269.4603 L763.0314,279.9024 L763.2163,278.9531 L763.4011,272.1725 L763.586,268.7822 L764.1405,290.8869 L764.3253,297.5319 L764.5102,285.3268 L764.695,278.8175 L764.8799,296.1758 L765.4344,307.5671 L765.6192,308.652 L765.8041,321.2639 L765.9889,332.7909 L766.1738,349.0643 L766.7283,371.0334 L766.9131,366.5582 L767.098,369.1348 L767.2828,371.169 L767.4677,387.578 L768.0222,381.8823 L768.207,381.8823 L768.3919,378.6276 L768.5767,393.1381 L768.7616,390.1546 L769.5009,389.6122 L769.6858,404.665 L769.8706,399.783 L770.0555,404.8007 L770.61,392.5956 L770.7948,377.5427 L770.9797,371.0334 L771.1645,392.5956 L771.3494,403.5801 L771.9039,419.4467 L772.0887,412.5305 L772.2736,391.2395 L772.4584,393.0024 L772.6433,384.8657 L773.1978,389.6122 L773.3826,388.3916 L773.5675,391.3751 L773.7523,396.5283 L773.9372,390.9683 L774.4917,386.7643 L774.6765,399.6474 L774.8614,410.0895 L775.0462,430.4312 L775.2311,460.537 L775.9704,479.2514 L776.1553,477.4885 L776.3401,499.8644 L776.525,507.7299 L777.0795,480.2007 L777.2643,454.4345 L777.4492,481.4212 L777.634,477.2172 L777.8189,484.2691 L778.3734,485.6252 L778.5582,507.1874 L778.7431,515.4597 L778.9279,492.677 L779.1128,500.5424 L779.6673,494.8468 L779.8521,500.2712 L780.037,497.1522 L780.2218,482.3705 L780.4067,476.1324 L780.9612,462.3 L781.146,457.8248 L781.3309,446.9759 L781.5157,448.4676 L781.7006,455.1126 L782.2551,439.5172 L782.4399,442.0938 L782.6248,431.5161 L782.8096,411.31 L782.9945,400.8679 L783.549,409.0046 L783.7338,407.9197 L783.9187,410.632 L784.1035,427.8546 L784.2884,430.0244 L784.8429,417.955 L785.0277,421.4809 L785.2126,425.6848 L785.3974,414.8359 L785.5823,411.9881 L786.1368,420.1248 L786.3216,442.6363 L786.5065,419.3111 L786.6913,383.1028 L786.8762,366.287 L787.6155,363.9816 L787.8004,367.5075 L787.9852,368.3211 L788.1701,366.6938 L788.7246,388.9341 L788.9094,391.9175 L789.0943,387.8492 L789.2791,411.5812 L789.464,416.192 L790.0185,415.3784 L790.2033,414.7003 L790.3882,407.7841 L790.573,432.1942 L790.7579,449.6881 L791.3124,455.3838 L791.4972,464.741 L791.6821,469.8942 L791.8669,472.4708 L792.0518,462.1644 L792.6063,480.8788 L792.7911,476.946 L792.976,467.7244 L793.1608,457.8248 L793.3457,475.3187 L794.085,490.236 L794.2699,484.4047 L794.4547,490.914 L794.6396,464.741 L795.1941,481.5568 L795.3789,490.5072 L795.5638,471.5216 L795.7486,459.9946 L795.9335,462.7068 L796.488,460.1302 L796.6728,440.6021 L796.8577,452.6715 L797.0425,443.1787 L797.2274,450.6374 L797.7819,463.1136 L797.9667,471.1147 L798.1516,454.1633 L798.3364,458.9097 L798.5213,487.3881 L799.0758,496.8809 L799.2606,500.2712 L799.4455,500.2712 L799.6303,493.8975 L800.3697,509.2216 L800.5545,506.9162 L800.7394,534.0385 L800.9242,530.7838 L801.1091,536.6151 L801.6636,534.1741 L801.8484,537.8356 L802.0333,527.5292 L802.403,535.5302 L802.9575,526.5799 L803.1423,529.0209 L803.3272,513.0187 L803.512,517.2227 L803.6969,515.3241 L804.2514,502.7122 L804.4362,502.0342 L804.6211,509.086 L804.8059,486.8457 L804.9908,481.4212 L805.5453,456.1975 L805.7301,465.1478 L805.915,456.3331 L806.0998,468.6737 L806.2847,459.4521 L806.8392,469.623 L807.024,482.7773 L807.2089,502.0342 L807.3937,502.9835 L807.5786,512.3407 L808.3179,514.7817 L808.5028,525.9018 L808.6876,521.1554 L808.8725,531.0551 L809.6118,501.763 L809.7967,476.8104 L809.9815,479.7939 L810.1664,462.0287 L810.7209,469.0806 L810.9057,469.0806 L811.0906,469.3518 L811.2754,473.5557 L811.4603,459.5877 L812.1996,471.386 L812.3845,472.1996 L812.5693,472.7421 L812.7542,466.6395 L813.3087,442.3651 L813.4935,436.5338 L813.6784,438.0255 L813.8632,443.9924 L814.0481,457.1467 L814.6026,463.2493 L814.7874,445.3485 L814.9723,450.6374 L815.1571,447.1115 L815.342,471.6572 L815.8965,493.8975 L816.0813,496.3385 L816.2662,501.6273 L816.451,500.8137 L816.6359,494.9824 L817.1904,497.1522 L817.3752,510.0353 L817.5601,502.1698 L817.7449,508.5435 L817.9298,501.8986 L818.6691,495.9317 L818.854,498.9151 L819.0388,485.7608 L819.2237,495.796 L819.7782,501.0849 L819.963,483.4554 L820.1479,492.4057 L820.3327,489.6935 L820.5176,484.5403 L821.0721,489.8291 L821.2569,507.4586 L821.4418,507.8655 L821.6266,506.9162 L821.8115,521.8335 L822.366,514.5104 L822.5508,491.5921 L822.7357,494.1687 L822.9205,481.6924 L823.1054,479.6583 L823.6599,480.2007 L823.8447,494.3043 L824.0296,491.0496 L824.2144,506.7806 L824.3993,498.6439 L824.9538,492.8126 L825.1386,489.1511 L825.3235,508.2723 L825.5083,495.796 L825.6932,503.2547 L826.2477,503.7971 L826.4325,480.7432 L826.6174,489.1511 L826.8022,488.2018 L826.9871,501.3561 L827.5416,501.6273 L827.7264,493.2194 L827.9113,487.6593 L828.0961,484.8115 L828.281,487.3881 L828.8355,459.4521 L829.0203,453.214 L829.2052,435.1777 L829.39,447.9251 L829.5749,445.7554 L830.1294,442.7719 L830.3142,437.7543 L830.4991,434.9064 L830.6839,419.4467 L830.8688,391.1039 L831.4233,382.1535 L831.6081,367.1006 L831.793,360.4557 L831.9778,355.1668 L832.1627,341.1988 L832.7172,341.7413 L832.902,335.2319 L833.0869,333.0621 L833.2717,306.7535 L833.4566,297.3963 L834.0111,307.5671 L834.1959,309.8725 L834.3808,309.7369 L834.5656,301.8714 L834.7505,318.5517 L835.305,304.1768 L835.4898,311.2286 L835.6747,328.9938 L835.8595,323.4337 L836.0444,344.1823 L836.7837,309.0589 L836.9686,321.6707 L837.1534,327.9089 L837.3383,310.1437 L837.8928,314.3477 L838.0776,338.4866 L838.2625,341.6056 L838.4473,363.3035 L838.6322,363.1679 L839.1867,361.2693 L839.3715,366.965 L839.5564,354.3531 L839.7412,356.2517 L839.9261,355.3024 L840.4806,366.5582 L840.6654,366.8294 L840.8503,358.5571 L841.0351,379.4413 L841.22,393.2737 L841.7745,395.1722 L841.9593,388.7985 L842.1442,399.3762 L842.329,406.2924 L842.5139,354.3531 L843.0684,365.3377 L843.4381,374.5593 L843.6229,369.9485 L843.8078,351.3697 L844.3623,363.9816 L844.5471,362.4898 L844.732,373.8812 L844.9168,366.1513 L845.1017,371.5758 L845.6562,393.4093 L845.841,384.1877 L846.0259,369.8129 L846.2107,353.8107 L846.3956,341.47 L846.9501,354.2175 L847.1349,365.7445 L847.3198,356.6585 L847.5046,335.91 L847.6895,333.4689 L848.244,328.0445 L848.4288,324.5186 L848.6137,315.0258 L848.7985,306.0754 L848.9834,272.0369 L849.5379,271.4944 L849.7227,274.8847 L849.9076,273.2574 L850.0924,300.5153 L850.2773,291.8362 L850.8318,298.6168 L851.0166,292.3786 L851.2015,285.4624 L851.3863,293.4635 L851.5712,311.3643 L852.1257,289.6664 L852.3105,301.4646 L852.4954,294.9552 L852.6802,301.0578 L852.8651,301.0578 L853.4196,289.6664 L853.6044,296.9894 L853.7893,279.6311 L853.9741,282.0721 L854.159,278.5462 L854.8983,295.3621 L855.0832,311.093 L855.268,317.4668 L855.4529,332.1128 L856.0074,335.5031 L856.1922,319.6366 L856.3771,316.9243 L856.5619,300.7865 L856.7468,314.7545 L857.3013,316.1107 L857.4861,308.652 L857.671,299.7017 L857.8558,289.3952 L858.0407,283.6995 L858.5952,285.1912 L858.78,291.565 L858.9649,303.4988 L859.1497,319.7722 L859.3346,323.8405 L859.8891,304.1768 L860.0739,302.5495 L860.2588,307.1603 L860.4436,316.2463 L860.6285,324.383 L861.3678,346.6233 L861.5527,343.911 L861.7375,345.2672 L861.9224,346.2164 L862.4769,338.7578 L862.6617,321.3995 L862.8466,329.4006 L863.0314,317.8736 L863.2163,308.652 L863.7708,324.6542 L863.9556,319.9078 L864.1405,316.2463 L864.3253,302.1427 L864.5102,289.6664 L865.0647,281.9365 L865.2495,273.9354 L865.4344,272.9862 L865.6192,273.393 L865.8041,283.8351 L866.3586,289.802 L866.5434,272.0369 L866.7283,277.597 L866.9131,276.2408 L867.098,269.0534 L867.6525,282.0721 L867.8373,292.6499 L868.0222,301.1934 L868.207,298.6168 L868.3919,294.006 L868.9464,290.3445 L869.1312,287.4966 L869.3161,265.6631 L869.6858,242.6092 L870.2403,235.4218 L870.4251,220.2333 L870.61,218.6059 L870.7948,191.348 L870.9797,177.6512 L871.5342,178.4649 L871.719,184.1606 L871.9039,191.4836 L872.0887,200.1627 L872.2736,208.8419 L872.8281,210.4692 L873.0129,196.5012 L873.1978,195.4163 L873.3826,197.7217 L873.5675,212.3678 L874.122,223.2167 L874.3068,195.0095 L874.4917,197.4505 L874.6765,200.9764 L874.8614,208.0282 L875.6007,208.2994 L875.7856,208.5707 L875.9704,201.112 L876.1553,205.8584 L876.8946,185.5167 L877.0795,217.7922 L877.2643,225.2509 L877.4492,243.9653 L878.0037,233.1164 L878.1885,231.0822 L878.3734,240.0325 L878.5582,225.7933 L878.7431,207.0789 L879.4824,203.2818 L879.6673,187.6865 L879.8521,188.3645 L880.037,182.3976 L880.5915,180.6347 L880.7763,170.4638 L880.9612,193.789 L881.146,189.9919 L881.3309,204.2311 L881.8854,205.0448 L882.0702,201.6545 L882.2551,202.4681 L882.4399,192.2973 L882.6248,195.5519 L883.1793,203.9599 L883.3641,191.348 L883.549,190.5343 L883.7338,205.8584 L883.9187,215.8937 L884.4732,221.0469 L884.658,225.2509 L884.8429,200.1627 L885.0277,213.1814 L885.2126,217.6566 L885.9519,211.1473 L886.1368,214.2663 L886.3216,207.8926 L886.5065,198.671 L887.061,199.7559 L887.2458,195.6876 L887.4307,202.1969 L887.6155,206.8077 L887.8004,223.2167 L888.3549,253.4581 L888.5397,248.7117 L888.7246,242.6092 L888.9094,244.6433 L889.0943,242.2023 L889.6488,245.8638 L889.8336,241.6599 L890.0185,239.6257 L890.2033,235.8286 L890.3882,227.9631 L890.9427,222.9455 L891.1275,206.6721 L891.3124,204.5023 L891.4972,194.1958 L891.6821,199.6203 L892.2366,191.2124 L892.4214,195.2807 L892.6063,202.4681 L892.7911,200.2983 L892.976,192.4329 L893.5305,178.7361 L893.7153,179.4142 L893.9002,182.8044 L894.085,189.3138 L894.2699,196.5012 L894.8244,202.875 L895.0092,187.9577 L895.1941,178.7361 L895.3789,181.0415 L895.5638,172.9048 L896.1183,162.3271 L896.3031,141.4429 L896.488,144.1551 L896.6728,145.7825 L896.8577,143.3415 L897.4122,147.4098 L897.597,145.9181 L897.7819,144.0195 L897.9667,162.8695 L898.1516,151.7494 L898.7061,149.7152 L898.8909,150.6645 L899.0758,161.9203 L899.2606,166.2598 L899.4455,159.0724 L900,157.3095 L900.1848,163.0052 L900.3697,154.7328 L900.5545,172.3624 L900.7394,173.5829 L901.2939,176.4307 L901.4787,168.4296 L901.6636,180.3634 L901.8484,183.8893 L902.0333,182.9401 L902.5878,191.0768 L902.7726,181.1771 L902.9575,166.1242 L903.1423,169.7857 L903.3272,170.735 L904.0665,174.939 L904.2514,184.025 L904.4362,177.2444 L904.6211,176.2951 L905.1756,160.2929 L905.3604,157.7163 L905.5453,161.2422 L905.7301,177.1088 L905.915,196.23 L906.4695,192.2973 L906.6543,183.6181 L906.8392,186.6016 L907.024,190.9411 L907.2089,181.5839 L907.7634,173.8541 L907.9482,165.4462 L908.1331,158.2587 L908.3179,160.0217 L908.5028,153.1055 L909.0573,154.8685 L909.2421,150.1221 L909.427,154.4616 L909.6118,146.7318 L909.7967,141.1717 L910.3512,127.8817 L910.536,126.9325 L910.9057,134.2555 L911.0906,133.5774 L911.6451,127.2037 L911.8299,116.0835 L912.0148,106.3195 L912.1996,110.6591 L912.3845,103.0648 L912.939,98.9965 L913.1238,88.0119 L913.3087,77.2986 L913.4935,83.2655 L913.6784,72.959 L914.2329,70.3824 L914.4177,64.8223 L914.6026,80.4177 L914.7874,83.5368 L914.9723,110.3878 L915.5268,117.4397 L915.7116,100.3526 L915.8965,107.8112 L916.0813,102.7936 L916.2662,91.9447 L916.8207,109.981 L917.0055,122.3217 L917.1904,99.8101 L917.3752,112.9645 L917.5601,120.0163 L918.1146,133.035 L918.2994,149.7152 L918.4843,160.1573 L918.6691,172.9048 L918.854,173.0404 L919.4085,172.7692 L919.5933,175.0746 L919.7782,161.1066 L919.963,144.9688 L920.1479,136.2897 L920.7024,131.5433 L920.8872,140.9005 L921.0721,125.0339 L921.2569,128.0174 L921.4418,127.3393 L922.1811,134.9336 L922.366,119.7451 L922.5508,116.8972 L922.7357,111.3371 L923.2902,110.6591 L923.475,106.4551 L923.6599,107.1332 L923.8447,112.0152 L924.0296,140.6292 L924.5841,160.5641 L924.7689,153.3767 L924.9538,152.0206 L925.1386,131.8145 L925.3235,121.508 L925.878,119.6094 L926.0628,126.7969 L926.2477,128.153 L926.4325,117.8465 L926.6174,96.9623 L927.1719,90.5886 L927.3567,93.1652 L927.5416,99.6745 L927.7264,96.5555 L927.9113,90.5886 L928.6506,104.8278 L928.8355,91.131 L929.0203,103.336 L929.2052,103.6073 L929.7597,92.894 L929.9445,105.3702 L930.1294,97.2335 L930.3142,87.7407 L930.4991,84.0792 L931.0536,111.8796 L931.2384,82.5875 L931.4233,83.1299 L931.6081,83.9436 L931.793,80.0108 L932.3475,67.1277 L932.5323,58.7198 L932.7172,44.345 L932.902,38.7849 L933.0869,38.5137 L933.6414,41.3615 L933.8262,33.2248 L934.0111,8.0011 L934.1959,0 L934.3808,26.173 L935.1201,50.8544 L935.305,70.2468 L935.4898,84.2148 L935.6747,84.6216 L936.2292,84.8929 L936.414,61.2964 L936.5989,70.3824 L936.9686,73.2303 L937.5231,57.3637 L937.7079,61.1608 L937.8928,56.4144 L938.0776,62.6526 L938.2625,72.8234 L938.817,60.4828 L939.0018,71.4673 L939.1867,110.6591 L939.3715,110.5235 L939.5564,110.5235 L940.1109,87.7407 L940.2957,97.2335 L940.4806,82.7231 L940.6654,96.1486 L940.8503,122.9997 L941.4048,126.9325 L941.5896,130.7296 L941.7745,159.0724 L941.9593,173.9897 L942.1442,172.3624 L942.6987,180.3634 L943.0684,172.3624 L943.2532,162.3271 L943.4381,159.3436 L943.9926,171.0062 L944.3623,173.5829 L944.5471,185.9235 L944.732,182.6688 L945.2865,189.9919 L945.4713,186.1947 L945.6562,208.8419 L945.841,208.7063 L946.0259,205.0448 L946.5804,206.2653 L946.7652,194.3314 L946.9501,198.8066 L947.1349,184.4318 L947.3198,213.5883 L948.0591,207.0789 L948.244,215.4868 L948.4288,185.9235 L948.6137,176.5663 L949.1682,169.1077 L949.353,169.1077 L949.5379,165.9886 L949.7227,163.9544 L949.9076,192.1616 L950.4621,179.9566 L950.647,200.434 L950.8318,203.4174 L951.0166,228.3699 L951.2015,221.1825 L951.756,219.4196 L951.9409,200.9764 L952.1257,201.5189 L952.3105,189.3138 L952.4954,202.1969 L953.2348,216.0293 L953.4196,230.4041 L953.6044,202.0613 L953.7893,194.7383 L954.3438,193.789 L954.5287,184.025 L954.7135,160.1573 L954.8983,166.1242 L955.0832,168.1584 L955.6377,170.057 L955.8226,169.5145 L956.0074,157.9875 L956.1922,139.8156 L956.3771,132.3569 L956.9316,127.2037 L957.1165,144.1551 L957.3013,121.1012 L957.4861,107.54 L957.671,109.8454 L958.2255,148.6303 L958.4104,120.4231 L958.5952,168.9721 L958.78,173.7185 L958.9649,173.3116 L959.5194,169.7857 L959.7043,150.1221 L959.8891,147.1386 L960.0739,136.5609 L960.2588,164.6325 L960.8133,169.3789 L960.9982,180.3634 L961.183,173.176 L961.3678,155.0041 L961.5527,156.9026 L962.1072,169.3789 L962.2921,191.7548 L962.4769,186.8728 L962.6617,184.703 L962.8466,189.4494 L963.4011,174.6678 L963.586,200.2983 L963.7708,182.8044 L963.9556,162.1915 L964.1405,154.4616 L964.695,175.0746 L964.8799,150.5289 L965.0647,178.7361 L965.2495,188.2289 L965.4344,172.3624 L965.9889,162.1915 L966.1738,184.025 L966.3586,170.4638 L966.5434,183.7537 L966.7283,182.8044 L967.2828,193.2465 L967.4677,184.025 L967.6525,214.5376 L967.8373,211.6897 L968.0222,219.4196 L968.5767,201.7901 L968.7616,221.5894 L968.9464,224.166 L969.1312,219.1484 L969.3161,206.6721 L969.8706,221.3181 L970.0555,189.7206 L970.2403,194.6027 L970.4251,178.8717 L970.61,174.3965 L971.3494,183.4825 L971.5342,176.0239 L971.719,182.3976 L971.9039,177.7868 L972.4584,195.0095 L972.6433,197.1793 L972.8281,211.0117 L973.0129,208.9775 L973.1978,191.0768 L973.7523,182.5332 L973.9372,211.6897 L974.122,197.7217 L974.3068,221.9962 L974.4917,218.0635 L975.0462,198.9422 L975.2311,211.5541 L975.4159,208.0282 L975.6007,186.466 L975.7856,185.3811 L976.3401,202.7394 L976.525,189.4494 L976.7098,194.1958 L976.8946,166.9379 L977.0795,158.1231 L977.634,162.4627 L977.8189,159.208 L978.0037,159.8861 L978.1885,173.4472 L978.9279,190.8055 L979.1128,192.4329 L979.2976,175.2102 L979.4824,179.9566 L979.6673,163.9544 L980.2218,159.8861 L980.4067,144.8332 L980.5915,150.3933 L980.7763,144.562 L980.9612,151.7494 L981.5157,152.5631 L981.7006,157.7163 L981.8854,146.8674 L982.0702,172.498 L982.2551,165.9886 L982.8096,157.4451 L982.9945,176.1595 L983.1793,175.4814 L983.3641,176.0239 L983.549,184.5674 L984.1035,203.1462 L984.2884,213.1814 L984.4732,220.3689 L984.658,225.7933 L984.8429,259.1538 L985.3974,265.7988 L985.5823,284.6488 L985.7671,328.4513 L985.9519,323.9761 L986.1368,332.6553 L986.6913,329.6718 L986.8762,332.1128 L987.061,339.1646 L987.2458,318.1448 L987.4307,347.1657 L987.9852,341.3344 L988.1701,368.4567 L988.3549,377.8139 L988.5397,385.137 L988.7246,395.1722 L989.464,440.8733 L989.6488,448.7388 L989.8336,463.1136 L990.0185,463.3849 L990.573,482.9129 L990.7579,465.419 L990.9427,482.3705 L991.1275,489.1511 L991.3124,435.042 L991.8669,437.6187 L992.0518,447.7895 L992.2366,435.1777 L992.4214,395.7147 L992.6063,380.6618 L993.1608,355.3024 L993.3457,345.2672 L993.5305,352.8614 L993.7153,365.8801 L993.9002,366.6938 L994.4547,414.9715 L994.6396,447.5183 L994.8244,447.5183 L995.0092,467.7244 L995.1941,456.1975 L995.7486,505.0176 L995.9335,476.268 L996.1183,514.5104 L996.3031,526.0374 L996.488,551.5324 L997.2274,491.1852 L997.4122,497.9658 L997.597,523.5964 L997.7819,514.9173 L998.3364,538.3781 L998.5213,578.6547 L998.7061,668.5652 L998.8909,667.6159 L999.0758,713.1814 L999.6303,763.7646 L999.8152,747.6268 L1000,651.7494\"/><!-- Average --><path stroke-with=\"2\" stroke=\"blue\" d=\"M0,593.0792l1000,0\" fill=\"none\"/><text text-anchor=\"end\" y=\"593.0792\" x=\"0\">Average</text><text title=\"2008-10-29 - 1.6298\" text-anchor=\"end\" y=\"651.7494\" x=\"1000\">Largest 1-day rise</text><text title=\"2008-10-22 - 1.6174\" text-anchor=\"end\" y=\"668.5652\" x=\"998.7061\">Largest 1-day fall</text><text title=\"2008-09-23 - 1.8558\" text-anchor=\"end\" y=\"345.2672\" x=\"993.3457\">Largest 5-day rise</text><text title=\"2008-10-27 - 1.5472\" text-anchor=\"end\" y=\"763.7646\" x=\"999.6303\">Largest 5-day fall</text><text title=\"2004-01-12 - 1.8511\" text-anchor=\"end\" y=\"351.6409\" x=\"676.1553\">Largest 90-day rise</text><text title=\"2008-10-28 - 1.5591\" text-anchor=\"end\" y=\"747.6268\" x=\"999.8152\">Largest 90-day fall</text><text title=\"2004-02-17 - 1.9045\" text-anchor=\"end\" y=\"279.2243\" x=\"682.8096\">Largest 365-day rise</text><text title=\"2008-10-27 - 1.5472\" text-anchor=\"end\" y=\"763.7646\" x=\"999.6303\">Largest 365-day fall</text></svg>", false)
    );
  }

  /**
   * Magic number identifying the file as a "plain" ppm file width and height Maximum color value : Now the pixel data. We take each pixel in the image, and recenter it, so that the : y co-ordinate ($y-recentered) ranges from -0.5 at the bottom of the image, to 0.5 : at the top of the image. : : The aspect ratio is used to "stretch" the range of x-coordinate values to stop the : image from being skewed. plot-pixel returns us the rgb values of the color of this pixel. We convert these to an integer value in the range [0, 255], and output them. .
   */
  @org.junit.Test
  public void raytracer() {
    final XQuery query = new XQuery(
      "\n" +
      "        import module namespace raytracer=\"http://www.xqsharp.com/raytracer\";\n" +
      "        import module namespace scene=\"http://www.xqsharp.com/raytracer/scene\";\n" +
      "        declare variable $width := 64;\n" +
      "        declare variable $height := 64;\n" +
      "        declare variable $input-context := .;\n" +
      "        declare variable $scene := scene:prepare-scene($input-context/scene);\n" +
      "        string-join( ( \"P3\", string-join((string($width), string($height)), \" \"), \"255\", (: : Now the pixel data. We take each pixel in the image, and recenter it, so that the : y co-ordinate ($y-recentered) ranges from -0.5 at the bottom of the image, to 0.5 : at the top of the image. : : The aspect ratio is used to \"stretch\" the range of x-coordinate values to stop the : image from being skewed. :) \n" +
      "        let $aspect-ratio := $width div $height \n" +
      "        for $y in 1 to $height \n" +
      "        let $y-recentered := ((-$y div $height) + 0.5) \n" +
      "        for $x in 1 to $width \n" +
      "        let $x-recentered := (($x div $width) - 0.5) * $aspect-ratio \n" +
      "        return (: plot-pixel returns us the rgb values of the color of this pixel. \n" +
      "        \t\t  We convert these to an integer value in the range [0, 255], and output them. :) \n" +
      "        \tstring-join( for $channel in raytracer:plot-pixel($scene, $x-recentered, $y-recentered) \n" +
      "        \t\t\t     return string(floor($channel * 255)), \" \") ), \"&#xA;\" )\n" +
      "      ",
      ctx);
    try {
      query.context(node(file("app/Demos/scene.xml")));
      query.addModule("http://www.xqsharp.com/raytracer/materials", file("app/Demos/materials.xq"));
      query.addModule("http://www.xqsharp.com/raytracer/scene", file("app/Demos/scene.xq"));
      query.addModule("http://www.xqsharp.com/raytracer", file("app/Demos/raytracer.xq"));
      query.addModule("http://www.xqsharp.com/raytracer/vector", file("app/Demos/vector.xq"));
      query.addModule("http://www.xqsharp.com/raytracer/math", file("app/Demos/math.xq"));
      query.addModule("http://www.xqsharp.com/raytracer/shapes", file("app/Demos/shapes.xq"));
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      (
        assertQuery("starts-with(normalize-space(string-join($result, ' ')), 'P3 64 64 255 0 0 0')")
      &&
        assertQuery("ends-with(normalize-space(string-join($result, ' ')), '125 119 179 125 118 178 124 118 177 124 117 176')")
      )
    );
  }

  /**
   *  A sudoku solver .
   */
  @org.junit.Test
  public void sudoku() {
    final XQuery query = new XQuery(
      "\n" +
      "        declare namespace fn = \"sudoku\";\n" +
      "        declare variable $board as xs:integer+ := \n" +
      "        \t( 1,0,0, 3,0,0, 6,0,0, 0,2,0, 5,0,0, 0,0,4, 0,0,9, 0,0,0, \n" +
      "        \t5,2,0, 0,0,0, 9,6,3, 0,0,0, 7,1,6, 0,0,0, 0,0,0, 0,0,0, \n" +
      "        \t0,8,0, 0,4,0, 9,0,0, 0,0,5, 3,0,7, 8,0,0, 4,0,6, 0,0,0, \n" +
      "        \t3,5,0, 0,0,0, 0,0,1);\n" +
      "        declare variable $rowStarts as xs:integer+ := (1, 10, 19, 28, 37, 46, 55, 64,73);\n" +
      "        declare variable $groups as xs:integer+ := \n" +
      "        \t( 1,1,1, 2,2,2, 3,3,3, 1,1,1, 2,2,2, 3,3,3, 1,1,1, 2,2,2, 3,3,3, 4,4,4, \n" +
      "        \t5,5,5, 6,6,6, 4,4,4, 5,5,5, 6,6,6, 4,4,4, 5,5,5, 6,6,6, 7,7,7, 8,8,8, \n" +
      "        \t9,9,9, 7,7,7, 8,8,8, 9,9,9, 7,7,7, 8,8,8, 9,9,9 );\n" +
      "        declare function fn:getRow ($board as xs:integer+, $index as xs:integer) as xs:integer+ { \n" +
      "        \tlet $rowStart := floor(($index - 1) div 9) * 9 \n" +
      "        \treturn one-or-more($board[position() > $rowStart and position() <= $rowStart + 9]) \n" +
      "        };\n" +
      "        declare function fn:getCol ($board as xs:integer+, $index as xs:integer) as xs:integer+ { \n" +
      "        \tlet $gap := ($index - 1) mod 9, \n" +
      "        \t    $colIndexes := for $x in $rowStarts \n" +
      "        \t    \t\t       return $x + $gap \n" +
      "        \treturn one-or-more($board[position() = $colIndexes]) \n" +
      "        };\n" +
      "        declare function fn:getGroup ($board as xs:integer+, $index as xs:integer) as xs:integer+ { \n" +
      "        \tlet $group := $groups[$index] \n" +
      "        \treturn one-or-more($board[for $x in position() return $groups[$x]= $group]) \n" +
      "        };\n" +
      "        declare function fn:getAllowedValues ($board as xs:integer+, $index as xs:integer) as xs:integer* { \n" +
      "        \tlet $existingValues := (fn:getRow($board, $index), fn:getCol($board, $index), fn:getGroup($board, $index)) \n" +
      "        \treturn for $x in (1 to 9) return if (not($x = $existingValues)) then $x else () \n" +
      "        };\n" +
      "        declare function fn:tryValues($board as xs:integer+, $emptyCells as xs:integer+, $possibleValues as xs:integer+) as xs:integer* { \n" +
      "        \tlet $index as xs:integer := $emptyCells[1], \n" +
      "        \t    $newBoard as xs:integer+ := ($board[position() <$index], $possibleValues[1], $board[position() > $index]), \n" +
      "        \t    $result as xs:integer* := fn:populateValues($newBoard, $emptyCells[position() != 1]) \n" +
      "        \treturn if (empty($result)) then if (count($possibleValues) > 1) then fn:tryValues($board, $emptyCells, one-or-more($possibleValues[position() != 1])) else () else $result \n" +
      "        };\n" +
      "        declare function fn:populateValues($board as xs:integer+, $emptyCells as xs:integer*) as xs:integer*{ \n" +
      "        \tif (not(empty($emptyCells))) \n" +
      "        \tthen let $index as xs:integer := exactly-one($emptyCells[1]), \n" +
      "        \t\t\t $possibleValues as xs:integer* := distinct-values(fn:getAllowedValues($board, $index)) \n" +
      "        \t\t return if (count($possibleValues) > 1) \n" +
      "        \t\t        then fn:tryValues($board, one-or-more($emptyCells), one-or-more($possibleValues)) \n" +
      "        \t\t        else if (count($possibleValues) = 1) \n" +
      "        \t\t        then let $newBoard as xs:integer+ :=($board[position() < $index], \n" +
      "        \t\t                   exactly-one($possibleValues[1]), $board[position() > $index]) \n" +
      "        \t\t             return fn:populateValues($newBoard, $emptyCells[position() != 1]) \n" +
      "        \t\t        else () \n" +
      "        \telse $board \n" +
      "        };\n" +
      "        declare function fn:solveSudoku ($startBoard as xs:integer+) as xs:integer+{ \n" +
      "        \tlet $emptyCells as xs:integer* :=\n" +
      "        \t\t\tfor $x in (1 to 81) \n" +
      "        \t\t\treturn if ($startBoard[$x] = 0) then $x else (), \n" +
      "        \t\t$endBoard as xs:integer* :=fn:populateValues($startBoard,$emptyCells) \n" +
      "        \treturn if (empty($endBoard)) then $startBoard else one-or-more($endBoard)\n" +
      "        };\n" +
      "        declare function fn:drawResult ($board as xs:integer+) as element(){ \n" +
      "        \t<html><head><title>Sudoku - XSLT</title><style>table {{ border-collapse: collapse; border: 1px solid black; }} td {{ padding: 10px; }} .norm {{ border-left: 1px solid #CCC; border-top: 1px solid #CCC; }} .csep {{ border-left: 1px solid black; }} .rsep {{ border-top: 1px solid black; }}</style></head><body>{fn:drawBoard($board)}</body></html> };\n" +
      "        declare function fn:drawBoard ($board as xs:integer+) as element(){ \n" +
      "        \t<table>{for $i in 1 to 9 return \n" +
      "        \t\t<tr>{for $j at $p in 1 to 9 \n" +
      "        \t\t\t  let $pos := (($i - 1) * 9) + $j \n" +
      "        \t\t\t  return <td class=\"{if ($p mod 3 = 1) then 'csep' else ('norm')} {if ($i mod 3 = 1) then 'rsep' else ('norm')}\"> {$board[$pos]}</td> \n" +
      "        \t\t\t  }</tr> }</table> \n" +
      "        };\n" +
      "        fn:drawResult(fn:solveSudoku($board))\n" +
      "      ",
      ctx);
    try {
      result = new QT3Result(query.value());
    } catch(final Throwable trw) {
      result = new QT3Result(trw);
    } finally {
      query.close();
    }
    test(
      assertSerialization("<html><head><title>Sudoku - XSLT</title><style>table { border-collapse: collapse; border: 1px solid black; } td { padding: 10px; } .norm { border-left: 1px solid #CCC; border-top: 1px solid #CCC; } .csep { border-left: 1px solid black; } .rsep { border-top: 1px solid black; }</style></head><body><table><tr><td class=\"csep rsep\">1</td><td class=\"norm rsep\">8</td><td class=\"norm rsep\">5</td><td class=\"csep rsep\">3</td><td class=\"norm rsep\">4</td><td class=\"norm rsep\">2</td><td class=\"csep rsep\">6</td><td class=\"norm rsep\">7</td><td class=\"norm rsep\">9</td></tr><tr><td class=\"csep norm\">6</td><td class=\"norm norm\">2</td><td class=\"norm norm\">7</td><td class=\"csep norm\">5</td><td class=\"norm norm\">9</td><td class=\"norm norm\">8</td><td class=\"csep norm\">1</td><td class=\"norm norm\">3</td><td class=\"norm norm\">4</td></tr><tr><td class=\"csep norm\">4</td><td class=\"norm norm\">3</td><td class=\"norm norm\">9</td><td class=\"csep norm\">6</td><td class=\"norm norm\">1</td><td class=\"norm norm\">7</td><td class=\"csep norm\">5</td><td class=\"norm norm\">2</td><td class=\"norm norm\">8</td></tr><tr><td class=\"csep rsep\">2</td><td class=\"norm rsep\">4</td><td class=\"norm rsep\">8</td><td class=\"csep rsep\">9</td><td class=\"norm rsep\">6</td><td class=\"norm rsep\">3</td><td class=\"csep rsep\">7</td><td class=\"norm rsep\">1</td><td class=\"norm rsep\">5</td></tr><tr><td class=\"csep norm\">7</td><td class=\"norm norm\">1</td><td class=\"norm norm\">6</td><td class=\"csep norm\">2</td><td class=\"norm norm\">5</td><td class=\"norm norm\">4</td><td class=\"csep norm\">8</td><td class=\"norm norm\">9</td><td class=\"norm norm\">3</td></tr><tr><td class=\"csep norm\">5</td><td class=\"norm norm\">9</td><td class=\"norm norm\">3</td><td class=\"csep norm\">7</td><td class=\"norm norm\">8</td><td class=\"norm norm\">1</td><td class=\"csep norm\">2</td><td class=\"norm norm\">4</td><td class=\"norm norm\">6</td></tr><tr><td class=\"csep rsep\">9</td><td class=\"norm rsep\">6</td><td class=\"norm rsep\">4</td><td class=\"csep rsep\">1</td><td class=\"norm rsep\">2</td><td class=\"norm rsep\">5</td><td class=\"csep rsep\">3</td><td class=\"norm rsep\">8</td><td class=\"norm rsep\">7</td></tr><tr><td class=\"csep norm\">8</td><td class=\"norm norm\">7</td><td class=\"norm norm\">1</td><td class=\"csep norm\">4</td><td class=\"norm norm\">3</td><td class=\"norm norm\">6</td><td class=\"csep norm\">9</td><td class=\"norm norm\">5</td><td class=\"norm norm\">2</td></tr><tr><td class=\"csep norm\">3</td><td class=\"norm norm\">5</td><td class=\"norm norm\">2</td><td class=\"csep norm\">8</td><td class=\"norm norm\">7</td><td class=\"norm norm\">9</td><td class=\"csep norm\">4</td><td class=\"norm norm\">6</td><td class=\"norm norm\">1</td></tr></table></body></html>", false)
    );
  }
}
