/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceAlreadyExistsException;
import com.kreative.rsrc.MacResourceProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MacResourceCollection
extends MacResourceProvider
implements Map<Integer, Map<Short, MacResource>> {
    private Map<Integer, Map<Short, MacResource>> map = new HashMap<Integer, Map<Short, MacResource>>();
    private short attr = 0;

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public synchronized short getResourceMapAttributes() {
        return this.attr;
    }

    @Override
    public synchronized void setResourceMapAttributes(short attr) {
        this.attr = attr;
    }

    @Override
    public synchronized boolean add(MacResource r) throws MacResourceAlreadyExistsException {
        if (this.map.containsKey(r.type) && this.map.get(r.type).containsKey(r.id)) {
            throw new MacResourceAlreadyExistsException();
        }
        if (this.map.containsKey(r.type)) {
            this.map.get(r.type).put(r.id, r.deepCopy());
        } else {
            HashMap<Short, MacResource> nmap = new HashMap<Short, MacResource>();
            nmap.put(r.id, r.deepCopy());
            this.map.put(r.type, nmap);
        }
        return true;
    }

    @Override
    public synchronized boolean contains(int type, short id) {
        return this.map.containsKey(type) && this.map.get(type).containsKey(id);
    }

    @Override
    public synchronized boolean contains(int type, String name) {
        if (this.map.containsKey(type)) {
            for (MacResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private MacResource find(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get(type).get(id);
        }
        return null;
    }

    private MacResource find(int type, String name) {
        if (this.map.containsKey(type)) {
            for (MacResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return r;
            }
        }
        return null;
    }

    @Override
    public synchronized MacResource get(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get(type).get(id).deepCopy();
        }
        return null;
    }

    @Override
    public synchronized MacResource get(int type, String name) {
        if (this.map.containsKey(type)) {
            for (MacResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return r.deepCopy();
            }
        }
        return null;
    }

    @Override
    public synchronized MacResource getAttributes(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            MacResource r = this.map.get(type).get(id);
            return new MacResource(r.type, r.id, r.getAttributes(), r.name, new byte[0]);
        }
        return null;
    }

    @Override
    public synchronized MacResource getAttributes(int type, String name) {
        if (this.map.containsKey(type)) {
            for (MacResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return new MacResource(r.type, r.id, r.getAttributes(), r.name, new byte[0]);
            }
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return KSFLUtilities.copy(this.map.get((Object)Integer.valueOf((int)type)).get((Object)Short.valueOf((short)id)).data);
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(int type, String name) {
        if (this.map.containsKey(type)) {
            for (MacResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return KSFLUtilities.copy(r.data);
            }
        }
        return null;
    }

    @Override
    public synchronized boolean remove(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            this.map.get(type).remove(id);
            if (this.map.get(type).isEmpty()) {
                this.map.remove(type);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(int type, String name) {
        if (this.map.containsKey(type)) {
            for (MacResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                this.map.get(type).remove(r);
                if (this.map.get(type).isEmpty()) {
                    this.map.remove(type);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean set(int type, short id, MacResource r) throws MacResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        MacResource o = this.find(type, id);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new MacResourceAlreadyExistsException();
        }
        return this.remove(type, id) && this.add(r);
    }

    @Override
    public synchronized boolean set(int type, String name, MacResource r) throws MacResourceAlreadyExistsException {
        if (!this.contains(type, name)) {
            return false;
        }
        MacResource o = this.find(type, name);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new MacResourceAlreadyExistsException();
        }
        return this.remove(type, name) && this.add(r);
    }

    @Override
    public synchronized boolean setAttributes(int type, short id, MacResource r) throws MacResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        MacResource o = this.find(type, id);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new MacResourceAlreadyExistsException();
        }
        r = r.deepCopy();
        r.data = o.data;
        return this.remove(type, id) && this.add(r);
    }

    @Override
    public synchronized boolean setAttributes(int type, String name, MacResource r) throws MacResourceAlreadyExistsException {
        if (!this.contains(type, name)) {
            return false;
        }
        MacResource o = this.find(type, name);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new MacResourceAlreadyExistsException();
        }
        r = r.deepCopy();
        r.data = o.data;
        return this.remove(type, name) && this.add(r);
    }

    @Override
    public synchronized boolean setData(int type, short id, byte[] data) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            this.map.get((Object)Integer.valueOf((int)type)).get((Object)Short.valueOf((short)id)).data = KSFLUtilities.copy(data);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean setData(int type, String name, byte[] data) {
        if (this.map.containsKey(type)) {
            for (MacResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                r.data = KSFLUtilities.copy(data);
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int getTypeCount() {
        return this.map.size();
    }

    @Override
    public synchronized int getType(int index) {
        return this.map.keySet().toArray(new Integer[0])[index];
    }

    @Override
    public synchronized int[] getTypes() {
        Integer[] types = this.map.keySet().toArray(new Integer[0]);
        int[] types2 = new int[types.length];
        int i = 0;
        while (i < types.length) {
            types2[i] = types[i];
            ++i;
        }
        return types2;
    }

    @Override
    public synchronized int getResourceCount(int type) {
        if (this.map.containsKey(type)) {
            return this.map.get(type).size();
        }
        return 0;
    }

    @Override
    public synchronized short getID(int type, int index) {
        if (this.map.containsKey(type)) {
            return this.map.get(type).keySet().toArray(new Short[0])[index];
        }
        return 0;
    }

    @Override
    public synchronized short[] getIDs(int type) {
        if (this.map.containsKey(type)) {
            Short[] ids = this.map.get(type).keySet().toArray(new Short[0]);
            short[] ids2 = new short[ids.length];
            int i = 0;
            while (i < ids.length) {
                ids2[i] = ids[i];
                ++i;
            }
            return ids2;
        }
        return new short[0];
    }

    @Override
    public synchronized String getName(int type, int index) {
        if (this.map.containsKey(type)) {
            short id = this.map.get(type).keySet().toArray(new Short[0])[index];
            return this.getNameFromID(type, id);
        }
        return "";
    }

    @Override
    public synchronized String[] getNames(int type) {
        if (this.map.containsKey(type)) {
            Short[] ids = this.map.get(type).keySet().toArray(new Short[0]);
            String[] names = new String[ids.length];
            int i = 0;
            while (i < ids.length) {
                names[i] = this.getNameFromID(type, ids[i]);
                ++i;
            }
            return names;
        }
        return new String[0];
    }

    @Override
    public synchronized short getNextAvailableID(int type, short start) {
        if (this.map.containsKey(type)) {
            while (this.map.get(type).containsKey(start)) {
                start = (short)(start + 1);
            }
        }
        return start;
    }

    @Override
    public synchronized String getNameFromID(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get((Object)Integer.valueOf((int)type)).get((Object)Short.valueOf((short)id)).name;
        }
        return "";
    }

    @Override
    public synchronized short getIDFromName(int type, String name) {
        if (this.map.containsKey(type)) {
            for (MacResource r : this.map.get(type).values()) {
                if (!r.name.equals(name)) continue;
                return r.id;
            }
        }
        return 0;
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public synchronized Set<Map.Entry<Integer, Map<Short, MacResource>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public synchronized Map<Short, MacResource> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized Set<Integer> keySet() {
        return this.map.keySet();
    }

    @Override
    public synchronized Map<Short, MacResource> put(Integer key, Map<Short, MacResource> value) {
        return this.map.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Integer, ? extends Map<Short, MacResource>> t) {
        this.map.putAll(t);
    }

    @Override
    public synchronized Map<Short, MacResource> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized Collection<Map<Short, MacResource>> values() {
        return this.map.values();
    }
}

