/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PACKAGE_HPP_INCLUDED
#define __PACKAGE_HPP_INCLUDED

#include "frontend/ast/LibUnit.hpp"
#include "frontend/ast/PackageBody.hpp"

namespace ast {

//! VHDL package declaration.
/** This class represents a VHDL package declaration.
 */
class Package : public LibUnit {
public:
	//! c'tor
	/** 
	 * @param declName name of the declared symbol.
	 * @param libs library clauses
         * @param useCs use clauses
         * @param decls local declarations.
         * @param loc location of the declaration.
         */
	Package(
		std::string* declName,
		std::list<SimpleName*> *libs,
		std::list<Name*>* useCs,
		std::list<SymbolDeclaration*>* decls,
		Location loc
		) : 	LibUnit(declName, libs, useCs, decls, loc),
			body(NULL) {}

	//! Accept a Visitor.
	//
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << "PACKAGE " << *this->name << ';';
	}


	/** referring PackageBody, mainly usefule for SymbolTable */
	PackageBody* body;

protected: 
	/** Destructor */
	virtual ~Package() {
		util::MiscUtil::terminate(body);
	}
};

}; /* namespace ast */

#endif /* __PACKAGE_HPP_INCLUDED */
