#! /bin/sh
#
# ikeyd.rc	startfile for ikeyd.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian GNU/Linux
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#		Based on skeleton, modified for ikeyd by
#		Stefan Pfetzing <dreamind@dreamind.de>
#
# Version:	@(#)ikeyd.rc  0.5.0  09-Jan-2002  dreamind@dreamind.de
#
# This file was automatically customized by dh-make on Wed,  9 Jan 2002 22:57:13 +0100

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/ikeyd
NAME=ikeyd
DESC="Powerbook / iBook2 hotkey daemon"

test -f $DAEMON || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON -- -q
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --oknodo --stop --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON
	echo "$NAME."
	;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	echo -n "Restarting $DESC: "
	start-stop-daemon --stop --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON
	sleep 1
	start-stop-daemon --start --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON -- -q
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
