/***************************************************************************
 *   Copyright (C) 2010-2013 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QAbstractProxyModel>
#include <QKeyEvent>

#include <KLocale>
#include <KDebug>
#include <KDirModel>
#include <KIcon>

#include "klistviewitemsingle.h"
#include "kfileitemext.h"

#include "komparatortreewidget.h"

KomparatorTreeWidget::KomparatorTreeWidget( QWidget *parent ) :
	QTreeWidget( parent )
{
	ctrl_or_shift_down = false;
	setItemsExpandable( false );
	setIndentation( 0 );
	setRootIsDecorated( false );
}

KomparatorTreeWidget::~KomparatorTreeWidget()
{
}

void KomparatorTreeWidget::startDrag( Qt::DropActions supported_actions )
{
	QModelIndexList indexes = selectionModel()->selectedIndexes();

	QList<QTreeWidgetItem *> item_list = selectedItems();

	if ( item_list.count() > 0 )
	{
		QMimeData *data = new QMimeData;

		QList< QUrl > url_list;
		int i;
		for ( i=0; i<item_list.count(); i++ )
		{
			url_list.append( ((KListViewItemSingle *)item_list.at( 0 ))->item->url() );
		}
		data->setUrls( url_list );

		if ( data == 0 )
		{
			return;
		}

		QDrag* drag = new QDrag( this );
		QPixmap pixmap;

		if ( item_list.count() == 1 )
		{
			const KFileItemExt *item = ((KListViewItemSingle *)itemFromIndex( indexes.at( 0 ) ))->item;
			pixmap = item->pixmap( KIconLoader::SizeMedium, KIconLoader::SizeMedium );
		}
		else
		{
			pixmap = KIcon( "document-multiple" ).pixmap( KIconLoader::SizeMedium, KIconLoader::SizeMedium );
		}

		drag->setPixmap( pixmap );
		drag->setMimeData( data );

		drag->exec( supported_actions, Qt::IgnoreAction );
	}
}

void KomparatorTreeWidget::mousePressEvent( QMouseEvent *event )
{
	if( ( event->modifiers() & Qt::ShiftModifier || event->modifiers() & Qt::ControlModifier ) && event->button() == Qt::LeftButton )
	{
		ctrl_or_shift_down = true;
	}
	else
	{
		ctrl_or_shift_down = false;
	}
	QTreeWidget::mousePressEvent( event );
}

void KomparatorTreeWidget::keyPressEvent( QKeyEvent *event )
{
	switch( event->key() ) // ignoring events passes them to the parent (=KomparatorWidget).
	{
		case Qt::Key_Delete:
			event->ignore();
			return;
		case Qt::Key_C:
			if ( event->modifiers() & Qt::ControlModifier )
			{
				event->ignore();
				return;
			}
			break;
		case Qt::Key_Enter:  // Enter and return are equal events for us.
		case Qt::Key_Return:
			event->ignore();
			return;
		default:
			break;
	}
	QTreeWidget::keyPressEvent( event );
}

void KomparatorTreeWidget::dropEvent( QDropEvent * event )
{
	emit signalDropped( (QWidget *)event->source(), (QWidget *)this, event->pos() );
}

void KomparatorTreeWidget::slotExecute( QTreeWidgetItem *item, int )
{
	if ( !ctrl_or_shift_down ) ((KListViewItemSingle*) item)->item->run();
}

QStringList KomparatorTreeWidget::mimeTypes() const
{
	QStringList mime_types_list;

	mime_types_list.append( "text/uri-list" );
	return mime_types_list;
}

#include "komparatortreewidget.moc"
