/* build_tool_dialog.c generated by valac 0.28.0.1-2361a, the Vala compiler
 * generated from build_tool_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012, 2014 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* The configuration of a single build tool.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _BuildToolDialogPrivate BuildToolDialogPrivate;

#define BUILD_TOOL_DIALOG_TYPE_ICON_COLUMN (build_tool_dialog_icon_column_get_type ())

#define BUILD_TOOL_DIALOG_TYPE_JOB_COLUMN (build_tool_dialog_job_column_get_type ())

#define BUILD_TOOL_DIALOG_TYPE_POST_PROCESSOR_COLUMN (build_tool_dialog_post_processor_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BuildToolDialog {
	GObject parent_instance;
	BuildToolDialogPrivate * priv;
};

struct _BuildToolDialogClass {
	GObjectClass parent_class;
};

struct _BuildToolDialogPrivate {
	GtkDialog* _dialog;
	GtkEntry* _entry_label;
	GtkEntry* _entry_desc;
	GtkEntry* _entry_extensions;
	GtkEntry* _entry_files_to_open;
	GtkListStore* _icons_store;
	GtkComboBox* _icons_combobox;
	GtkListStore* _jobs_store;
	GtkTreeView* _jobs_view;
};

typedef enum  {
	BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME,
	BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL,
	BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS
} BuildToolDialogIconColumn;

typedef enum  {
	BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND,
	BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR,
	BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS
} BuildToolDialogJobColumn;

typedef enum  {
	BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME,
	BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS
} BuildToolDialogPostProcessorColumn;

struct _Block1Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* remove_button;
	GtkTreeSelection* select;
};

struct _Block2Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* up_button;
	GtkTreeSelection* select;
};

struct _Block3Data {
	int _ref_count_;
	BuildToolDialog* self;
	GtkToolButton* down_button;
	GtkTreeSelection* select;
};


static gpointer build_tool_dialog_parent_class = NULL;

GType build_tool_dialog_get_type (void) G_GNUC_CONST;
#define BUILD_TOOL_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogPrivate))
enum  {
	BUILD_TOOL_DIALOG_DUMMY_PROPERTY
};
static GType build_tool_dialog_icon_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType build_tool_dialog_job_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType build_tool_dialog_post_processor_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BuildToolDialog* build_tool_dialog_new (GtkWindow* parent);
BuildToolDialog* build_tool_dialog_construct (GType object_type, GtkWindow* parent);
static void build_tool_dialog_init_text_entries (BuildToolDialog* self);
static void build_tool_dialog_init_icons_store (BuildToolDialog* self);
static void build_tool_dialog_init_icons_combobox (BuildToolDialog* self);
static void build_tool_dialog_init_jobs (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_main_grid (BuildToolDialog* self);
static void build_tool_dialog_set_read_only (BuildToolDialog* self);
static void build_tool_dialog_set_editable (BuildToolDialog* self);
gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self, LatexilaBuildTools* build_tools, gint build_tool_num);
static void build_tool_dialog_set_build_tool (BuildToolDialog* self, LatexilaBuildTool* build_tool);
static LatexilaBuildTool* build_tool_dialog_retrieve_build_tool (BuildToolDialog* self);
gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self);
static void build_tool_dialog_set_new_build_tool (BuildToolDialog* self);
static void build_tool_dialog_add_icon (BuildToolDialog* self, const gchar* icon_name, const gchar* label);
static void __lambda46_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text);
static void ___lambda46__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self);
static void __lambda47_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text);
static void ___lambda47__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self);
static GtkToolButton* build_tool_dialog_get_add_button (BuildToolDialog* self);
static void __lambda48_ (BuildToolDialog* self);
static void build_tool_dialog_add_build_job (BuildToolDialog* self, LatexilaBuildJob* job);
static void ___lambda48__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static GtkToolButton* build_tool_dialog_get_remove_button (BuildToolDialog* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda49_ (Block1Data* _data1_);
static void ___lambda49__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda50_ (BuildToolDialog* self);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda50__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static GtkToolButton* build_tool_dialog_get_up_button (BuildToolDialog* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda51_ (Block2Data* _data2_);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void ___lambda51__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda52_ (Block2Data* _data2_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
static void ___lambda52__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static GtkToolButton* build_tool_dialog_get_down_button (BuildToolDialog* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda53_ (Block3Data* _data3_);
static void ___lambda53__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda54_ (Block3Data* _data3_);
static void ___lambda54__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static GtkGrid* build_tool_dialog_get_label_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_desc_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_extensions_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_icons_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_jobs_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_files_to_open_grid (BuildToolDialog* self);
GtkGrid* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void build_tool_dialog_finalize (GObject* obj);


static GType build_tool_dialog_icon_column_get_type (void) {
	static volatile gsize build_tool_dialog_icon_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_icon_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, "BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME", "icon-name"}, {BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, "BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL", "label"}, {BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_icon_column_type_id;
		build_tool_dialog_icon_column_type_id = g_enum_register_static ("BuildToolDialogIconColumn", values);
		g_once_init_leave (&build_tool_dialog_icon_column_type_id__volatile, build_tool_dialog_icon_column_type_id);
	}
	return build_tool_dialog_icon_column_type_id__volatile;
}


static GType build_tool_dialog_job_column_get_type (void) {
	static volatile gsize build_tool_dialog_job_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_job_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, "BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND", "command"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, "BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR", "post-processor"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_job_column_type_id;
		build_tool_dialog_job_column_type_id = g_enum_register_static ("BuildToolDialogJobColumn", values);
		g_once_init_leave (&build_tool_dialog_job_column_type_id__volatile, build_tool_dialog_job_column_type_id);
	}
	return build_tool_dialog_job_column_type_id__volatile;
}


static GType build_tool_dialog_post_processor_column_get_type (void) {
	static volatile gsize build_tool_dialog_post_processor_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_post_processor_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, "BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME", "name"}, {BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_post_processor_column_type_id;
		build_tool_dialog_post_processor_column_type_id = g_enum_register_static ("BuildToolDialogPostProcessorColumn", values);
		g_once_init_leave (&build_tool_dialog_post_processor_column_type_id__volatile, build_tool_dialog_post_processor_column_type_id);
	}
	return build_tool_dialog_post_processor_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BuildToolDialog* build_tool_dialog_construct (GType object_type, GtkWindow* parent) {
	BuildToolDialog * self = NULL;
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkGrid* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (BuildToolDialog*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkDialog*) gtk_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_dialog);
	self->priv->_dialog = _tmp0_;
	_tmp1_ = self->priv->_dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp1_, TRUE);
	_tmp2_ = self->priv->_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp2_, TRUE);
	_tmp3_ = self->priv->_dialog;
	_tmp4_ = parent;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp4_);
	build_tool_dialog_init_text_entries (self);
	build_tool_dialog_init_icons_store (self);
	build_tool_dialog_init_icons_combobox (self);
	build_tool_dialog_init_jobs (self);
	_tmp5_ = self->priv->_dialog;
	_tmp6_ = (GtkBox*) gtk_dialog_get_content_area (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	content_area = _tmp7_;
	_tmp8_ = build_tool_dialog_get_main_grid (self);
	_tmp9_ = _tmp8_;
	gtk_box_pack_start (content_area, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (_tmp9_);
	gtk_widget_show_all ((GtkWidget*) content_area);
	_g_object_unref0 (content_area);
	return self;
}


BuildToolDialog* build_tool_dialog_new (GtkWindow* parent) {
	return build_tool_dialog_construct (TYPE_BUILD_TOOL_DIALOG, parent);
}


static void build_tool_dialog_set_read_only (BuildToolDialog* self) {
	GtkDialog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = _ ("_Close");
	gtk_dialog_add_button (_tmp0_, _tmp1_, (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = self->priv->_dialog;
	_tmp3_ = _ ("Build Tool (read-only)");
	gtk_window_set_title ((GtkWindow*) _tmp2_, _tmp3_);
}


static void build_tool_dialog_set_editable (BuildToolDialog* self) {
	GtkDialog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = _ ("_Cancel");
	gtk_dialog_add_button (_tmp0_, _tmp1_, (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = self->priv->_dialog;
	_tmp3_ = _ ("_OK");
	gtk_dialog_add_button (_tmp2_, _tmp3_, (gint) GTK_RESPONSE_OK);
	_tmp4_ = self->priv->_dialog;
	_tmp5_ = _ ("Build Tool");
	gtk_window_set_title ((GtkWindow*) _tmp4_, _tmp5_);
}


gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self, LatexilaBuildTools* build_tools, gint build_tool_num) {
	gboolean result = FALSE;
	LatexilaBuildTool* build_tool = NULL;
	LatexilaBuildTools* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	LatexilaBuildTool* _tmp2_ = NULL;
	LatexilaBuildTool* _tmp3_ = NULL;
	LatexilaBuildTool* _tmp4_ = NULL;
	LatexilaBuildTools* _tmp5_ = NULL;
	LatexilaBuildTool* _tmp6_ = NULL;
	gboolean ok = FALSE;
	GtkDialog* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	GtkDialog* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (build_tools != NULL, FALSE);
	_tmp0_ = build_tools;
	_tmp1_ = build_tool_num;
	_tmp2_ = latexila_build_tools_nth (_tmp0_, (guint) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	build_tool = _tmp3_;
	_tmp4_ = build_tool;
	g_return_val_if_fail (_tmp4_ != NULL, FALSE);
	_tmp5_ = build_tools;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, latexila_build_tools_default_get_type ())) {
		build_tool_dialog_set_read_only (self);
	} else {
		build_tool_dialog_set_editable (self);
	}
	_tmp6_ = build_tool;
	build_tool_dialog_set_build_tool (self, _tmp6_);
	_tmp7_ = self->priv->_dialog;
	_tmp8_ = gtk_dialog_run (_tmp7_);
	ok = _tmp8_ == ((gint) GTK_RESPONSE_OK);
	_tmp9_ = ok;
	if (_tmp9_) {
		LatexilaBuildTool* new_build_tool = NULL;
		LatexilaBuildTool* _tmp10_ = NULL;
		LatexilaBuildTool* _tmp11_ = NULL;
		LatexilaBuildTool* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		LatexilaBuildToolsPersonal* personal_build_tools = NULL;
		LatexilaBuildTools* _tmp15_ = NULL;
		LatexilaBuildToolsPersonal* _tmp16_ = NULL;
		LatexilaBuildToolsPersonal* _tmp17_ = NULL;
		LatexilaBuildTool* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp10_ = build_tool_dialog_retrieve_build_tool (self);
		new_build_tool = _tmp10_;
		_tmp11_ = new_build_tool;
		_tmp12_ = build_tool;
		g_object_get (_tmp12_, "enabled", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		g_object_set (_tmp11_, "enabled", _tmp14_, NULL);
		_tmp15_ = build_tools;
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, latexila_build_tools_personal_get_type ()) ? ((LatexilaBuildToolsPersonal*) _tmp15_) : NULL);
		personal_build_tools = _tmp16_;
		_tmp17_ = personal_build_tools;
		_tmp18_ = new_build_tool;
		_tmp19_ = build_tool_num;
		latexila_build_tools_personal_replace (_tmp17_, _tmp18_, (guint) _tmp19_);
		_g_object_unref0 (personal_build_tools);
		_g_object_unref0 (new_build_tool);
	}
	_tmp20_ = self->priv->_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp20_);
	result = ok;
	_g_object_unref0 (build_tool);
	return result;
}


gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self) {
	gboolean result = FALSE;
	gboolean ok = FALSE;
	GtkDialog* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GtkDialog* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	build_tool_dialog_set_editable (self);
	build_tool_dialog_set_new_build_tool (self);
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = gtk_dialog_run (_tmp0_);
	ok = _tmp1_ == ((gint) GTK_RESPONSE_OK);
	_tmp2_ = ok;
	if (_tmp2_) {
		LatexilaBuildTool* new_build_tool = NULL;
		LatexilaBuildTool* _tmp3_ = NULL;
		LatexilaBuildTool* _tmp4_ = NULL;
		LatexilaBuildToolsPersonal* build_tools = NULL;
		LatexilaBuildToolsPersonal* _tmp5_ = NULL;
		LatexilaBuildToolsPersonal* _tmp6_ = NULL;
		LatexilaBuildToolsPersonal* _tmp7_ = NULL;
		LatexilaBuildTool* _tmp8_ = NULL;
		_tmp3_ = build_tool_dialog_retrieve_build_tool (self);
		new_build_tool = _tmp3_;
		_tmp4_ = new_build_tool;
		g_object_set (_tmp4_, "enabled", TRUE, NULL);
		_tmp5_ = latexila_build_tools_personal_get_instance ();
		_tmp6_ = _g_object_ref0 (_tmp5_);
		build_tools = _tmp6_;
		_tmp7_ = build_tools;
		_tmp8_ = new_build_tool;
		latexila_build_tools_personal_add (_tmp7_, _tmp8_);
		_g_object_unref0 (build_tools);
		_g_object_unref0 (new_build_tool);
	}
	_tmp9_ = self->priv->_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp9_);
	result = ok;
	return result;
}


/*************************************************************************/
static void build_tool_dialog_init_text_entries (BuildToolDialog* self) {
	GtkEntry* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_entry_label);
	self->priv->_entry_label = _tmp0_;
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_entry_desc);
	self->priv->_entry_desc = _tmp1_;
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_entry_extensions);
	self->priv->_entry_extensions = _tmp2_;
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->_entry_files_to_open);
	self->priv->_entry_files_to_open = _tmp3_;
}


static void build_tool_dialog_init_icons_store (BuildToolDialog* self) {
	GtkListStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_ICON_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->_icons_store);
	self->priv->_icons_store = _tmp0_;
	_tmp1_ = _ ("Execute");
	build_tool_dialog_add_icon (self, "system-run", _tmp1_);
	build_tool_dialog_add_icon (self, "compile_dvi", "LaTeX → DVI");
	build_tool_dialog_add_icon (self, "compile_pdf", "LaTeX → PDF");
	build_tool_dialog_add_icon (self, "compile_ps", "LaTeX → PS");
	_tmp2_ = _ ("Convert");
	build_tool_dialog_add_icon (self, GTK_STOCK_CONVERT, _tmp2_);
	_tmp3_ = _ ("View File");
	build_tool_dialog_add_icon (self, "text-x-generic", _tmp3_);
	_tmp4_ = _ ("View DVI");
	build_tool_dialog_add_icon (self, "latexila-dvi", _tmp4_);
	_tmp5_ = _ ("View PDF");
	build_tool_dialog_add_icon (self, "latexila-pdf", _tmp5_);
	_tmp6_ = _ ("View PS");
	build_tool_dialog_add_icon (self, "latexila-ps", _tmp6_);
}


static void build_tool_dialog_add_icon (BuildToolDialog* self, const gchar* icon_name, const gchar* label) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->_icons_store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->_icons_store;
	_tmp3_ = iter;
	_tmp4_ = icon_name;
	_tmp5_ = label;
	gtk_list_store_set (_tmp2_, &_tmp3_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, _tmp4_, BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, _tmp5_, -1);
}


static void build_tool_dialog_init_icons_combobox (BuildToolDialog* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkComboBox* _tmp4_ = NULL;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp5_ = NULL;
	GtkComboBox* _tmp6_ = NULL;
	GtkComboBox* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_icons_store;
	_tmp1_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_icons_combobox);
	self->priv->_icons_combobox = _tmp1_;
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp2_);
	pixbuf_renderer = _tmp2_;
	_tmp3_ = self->priv->_icons_combobox;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp4_ = self->priv->_icons_combobox;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) pixbuf_renderer, "icon-name", BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, NULL);
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp5_);
	text_renderer = _tmp5_;
	_tmp6_ = self->priv->_icons_combobox;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) text_renderer, TRUE);
	_tmp7_ = self->priv->_icons_combobox;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp7_, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOL_DIALOG_ICON_COLUMN_LABEL, NULL);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
}


static void __lambda46_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->_jobs_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->_jobs_store;
	_tmp4_ = iter;
	_tmp5_ = new_text;
	gtk_list_store_set (_tmp3_, &_tmp4_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp5_, -1);
}


static void ___lambda46__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self) {
	__lambda46_ ((BuildToolDialog*) self, path, new_text);
}


static void __lambda47_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->_jobs_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->_jobs_store;
	_tmp4_ = iter;
	_tmp5_ = new_text;
	gtk_list_store_set (_tmp3_, &_tmp4_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp5_, -1);
}


static void ___lambda47__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self) {
	__lambda47_ ((BuildToolDialog*) self, path, new_text);
}


static void build_tool_dialog_init_jobs (BuildToolDialog* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkListStore* post_processor_store = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkListStore* _tmp14_ = NULL;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp15_ = NULL;
	GtkTreeViewColumn* column = NULL;
	const gchar* _tmp16_ = NULL;
	GtkTreeViewColumn* _tmp17_ = NULL;
	GtkTreeView* _tmp18_ = NULL;
	GtkCellRendererCombo* combo_renderer = NULL;
	GtkCellRendererCombo* _tmp19_ = NULL;
	GtkListStore* _tmp20_ = NULL;
	GtkTreeView* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->_jobs_store);
	self->priv->_jobs_store = _tmp0_;
	_tmp1_ = self->priv->_jobs_store;
	_tmp2_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_jobs_view);
	self->priv->_jobs_view = _tmp2_;
	_tmp3_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_N_COLUMNS, G_TYPE_STRING, -1);
	post_processor_store = _tmp3_;
	{
		gint type = 0;
		type = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				const gchar* name = NULL;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp9_ = NULL;
				GtkTreeIter _tmp10_ = {0};
				GtkListStore* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				const gchar* _tmp13_ = NULL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = type;
					type = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = type;
				if (!(_tmp6_ < ((gint) LATEXILA_POST_PROCESSOR_TYPE_NB_TYPES))) {
					break;
				}
				_tmp7_ = type;
				_tmp8_ = latexila_post_processor_get_name_from_type ((LatexilaPostProcessorType) _tmp7_);
				name = _tmp8_;
				_tmp9_ = post_processor_store;
				gtk_list_store_append (_tmp9_, &_tmp10_);
				iter = _tmp10_;
				_tmp11_ = post_processor_store;
				_tmp12_ = iter;
				_tmp13_ = name;
				gtk_list_store_set (_tmp11_, &_tmp12_, BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, _tmp13_, -1);
			}
		}
	}
	_tmp14_ = post_processor_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp14_, (gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, GTK_SORT_ASCENDING);
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp15_);
	text_renderer = _tmp15_;
	g_object_set (text_renderer, "editable", TRUE, NULL);
	_tmp16_ = _ ("Commands");
	_tmp17_ = gtk_tree_view_column_new_with_attributes (_tmp16_, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, NULL);
	g_object_ref_sink (_tmp17_);
	column = _tmp17_;
	gtk_tree_view_column_set_resizable (column, TRUE);
	_tmp18_ = self->priv->_jobs_view;
	gtk_tree_view_append_column (_tmp18_, column);
	_tmp19_ = (GtkCellRendererCombo*) gtk_cell_renderer_combo_new ();
	g_object_ref_sink (_tmp19_);
	combo_renderer = _tmp19_;
	g_object_set ((GtkCellRendererText*) combo_renderer, "editable", TRUE, NULL);
	_tmp20_ = post_processor_store;
	g_object_set (combo_renderer, "model", (GtkTreeModel*) _tmp20_, NULL);
	g_object_set (combo_renderer, "text-column", (gint) BUILD_TOOL_DIALOG_POST_PROCESSOR_COLUMN_NAME, NULL);
	g_object_set (combo_renderer, "has-entry", FALSE, NULL);
	_tmp21_ = self->priv->_jobs_view;
	_tmp22_ = _ ("Post Processor");
	gtk_tree_view_insert_column_with_attributes (_tmp21_, -1, _tmp22_, (GtkCellRenderer*) combo_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, NULL);
	g_signal_connect_object (text_renderer, "edited", (GCallback) ___lambda46__gtk_cell_renderer_text_edited, self, 0);
	g_signal_connect_object ((GtkCellRendererText*) combo_renderer, "edited", (GCallback) ___lambda47__gtk_cell_renderer_text_edited, self, 0);
	_g_object_unref0 (combo_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (post_processor_store);
}


/*************************************************************************/
static void __lambda48_ (BuildToolDialog* self) {
	LatexilaBuildJob* new_job = NULL;
	LatexilaBuildJob* _tmp0_ = NULL;
	_tmp0_ = latexila_build_job_new ();
	new_job = _tmp0_;
	g_object_set (new_job, "command", "", NULL);
	g_object_set (new_job, "post-processor-type", LATEXILA_POST_PROCESSOR_TYPE_ALL_OUTPUT, NULL);
	build_tool_dialog_add_build_job (self, new_job);
	_g_object_unref0 (new_job);
}


static void ___lambda48__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda48_ ((BuildToolDialog*) self);
}


static GtkToolButton* build_tool_dialog_get_add_button (BuildToolDialog* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* add_button = NULL;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	add_button = _tmp0_;
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	_tmp1_ = _ ("Add...");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) add_button, _tmp1_);
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda48__gtk_tool_button_clicked, self, 0);
	result = add_button;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BuildToolDialog* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->remove_button);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda49_ (Block1Data* _data1_) {
	BuildToolDialog* self;
	gboolean row_selected = FALSE;
	gint _tmp0_ = 0;
	self = _data1_->self;
	_tmp0_ = gtk_tree_selection_count_selected_rows (_data1_->select);
	row_selected = _tmp0_ > 0;
	gtk_widget_set_sensitive ((GtkWidget*) _data1_->remove_button, row_selected);
}


static void ___lambda49__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda49_ (self);
}


static void __lambda50_ (BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	_tmp0_ = self->priv->_jobs_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ >= 0) {
		GtkListStore* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
		_tmp4_ = self->priv->_jobs_store;
		_tmp5_ = iter;
		gtk_list_store_remove (_tmp4_, &_tmp5_);
	}
}


static void ___lambda50__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda50_ ((BuildToolDialog*) self);
}


static GtkToolButton* build_tool_dialog_get_remove_button (BuildToolDialog* self) {
	GtkToolButton* result = NULL;
	Block1Data* _data1_;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data1_->remove_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data1_->remove_button, "list-remove-symbolic");
	_tmp1_ = _ ("Remove");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data1_->remove_button, _tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _data1_->remove_button, FALSE);
	_tmp2_ = self->priv->_jobs_view;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_data1_->select = _tmp3_;
	g_signal_connect_data (_data1_->select, "changed", (GCallback) ___lambda49__gtk_tree_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_object (_data1_->remove_button, "clicked", (GCallback) ___lambda50__gtk_tool_button_clicked, self, 0);
	_tmp4_ = _g_object_ref0 (_data1_->remove_button);
	result = _tmp4_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BuildToolDialog* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->up_button);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void __lambda51_ (Block2Data* _data2_) {
	BuildToolDialog* self;
	GList* selected_rows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkTreePath* path_selected = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GtkTreePath* _tmp5_ = NULL;
	gint row_num = 0;
	GtkTreePath* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	self = _data2_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data2_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, FALSE);
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		return;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path_selected = _tmp5_;
	_tmp6_ = path_selected;
	_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_[0];
	row_num = _tmp9_;
	_tmp10_ = row_num;
	gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, _tmp10_ > 0);
	_gtk_tree_path_free0 (path_selected);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
}


static void ___lambda51__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda51_ (self);
}


static void __lambda52_ (Block2Data* _data2_) {
	BuildToolDialog* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = _data2_->self;
	_tmp0_ = self->priv->_jobs_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ > 0) {
		GtkTreeIter iter_up = {0};
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = iter_selected;
		iter_up = _tmp4_;
		_tmp5_ = self->priv->_jobs_store;
		_tmp6_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp5_, &iter_up);
		if (_tmp6_) {
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			GtkTreeIter _tmp9_ = {0};
			_tmp7_ = self->priv->_jobs_store;
			_tmp8_ = iter_selected;
			_tmp9_ = iter_up;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
			g_signal_emit_by_name (_data2_->select, "changed");
		}
	}
}


static void ___lambda52__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda52_ (self);
}


static GtkToolButton* build_tool_dialog_get_up_button (BuildToolDialog* self) {
	GtkToolButton* result = NULL;
	Block2Data* _data2_;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data2_->up_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data2_->up_button, "go-up-symbolic");
	_tmp1_ = _ ("Move up");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data2_->up_button, _tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _data2_->up_button, FALSE);
	_tmp2_ = self->priv->_jobs_view;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_data2_->select = _tmp3_;
	g_signal_connect_data (_data2_->select, "changed", (GCallback) ___lambda51__gtk_tree_selection_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_signal_connect_data (_data2_->up_button, "clicked", (GCallback) ___lambda52__gtk_tool_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp4_ = _g_object_ref0 (_data2_->up_button);
	result = _tmp4_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BuildToolDialog* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->down_button);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda53_ (Block3Data* _data3_) {
	BuildToolDialog* self;
	GList* selected_rows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkTreePath* path_selected = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GtkTreePath* _tmp5_ = NULL;
	gint row_num = 0;
	GtkTreePath* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_ = NULL;
	gint nb_rows = 0;
	GtkTreeModel* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	self = _data3_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data3_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, FALSE);
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		return;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path_selected = _tmp5_;
	_tmp6_ = path_selected;
	_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_[0];
	row_num = _tmp9_;
	_tmp10_ = self->priv->_jobs_store;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp10_) : NULL);
	model = _tmp11_;
	_tmp12_ = model;
	_tmp13_ = gtk_tree_model_iter_n_children (_tmp12_, NULL);
	nb_rows = _tmp13_;
	_tmp14_ = row_num;
	_tmp15_ = nb_rows;
	gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, _tmp14_ < (_tmp15_ - 1));
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (path_selected);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
}


static void ___lambda53__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda53_ (self);
}


static void __lambda54_ (Block3Data* _data3_) {
	BuildToolDialog* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = _data3_->self;
	_tmp0_ = self->priv->_jobs_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ >= 0) {
		GtkTreeIter iter_down = {0};
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = iter_selected;
		iter_down = _tmp4_;
		_tmp5_ = self->priv->_jobs_store;
		_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter_down);
		if (_tmp6_) {
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			GtkTreeIter _tmp9_ = {0};
			_tmp7_ = self->priv->_jobs_store;
			_tmp8_ = iter_selected;
			_tmp9_ = iter_down;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
			g_signal_emit_by_name (_data3_->select, "changed");
		}
	}
}


static void ___lambda54__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda54_ (self);
}


static GtkToolButton* build_tool_dialog_get_down_button (BuildToolDialog* self) {
	GtkToolButton* result = NULL;
	Block3Data* _data3_;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data3_->down_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data3_->down_button, "go-down-symbolic");
	_tmp1_ = _ ("Move down");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data3_->down_button, _tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _data3_->down_button, FALSE);
	_tmp2_ = self->priv->_jobs_view;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_data3_->select = _tmp3_;
	g_signal_connect_data (_data3_->select, "changed", (GCallback) ___lambda53__gtk_tree_selection_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	g_signal_connect_data (_data3_->down_button, "clicked", (GCallback) ___lambda54__gtk_tool_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp4_ = _g_object_ref0 (_data3_->down_button);
	result = _tmp4_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


/*************************************************************************/
static void build_tool_dialog_set_new_build_tool (BuildToolDialog* self) {
	GtkEntry* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	GtkComboBox* _tmp4_ = NULL;
	GtkListStore* _tmp5_ = NULL;
	GtkTreeView* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry_label;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->_entry_desc;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->_entry_extensions;
	gtk_entry_set_text (_tmp2_, "");
	_tmp3_ = self->priv->_entry_files_to_open;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->_icons_combobox;
	gtk_combo_box_set_active (_tmp4_, 0);
	_tmp5_ = self->priv->_jobs_store;
	gtk_list_store_clear (_tmp5_);
	_tmp6_ = self->priv->_jobs_view;
	gtk_tree_view_columns_autosize (_tmp6_);
}


static void build_tool_dialog_set_build_tool (BuildToolDialog* self, LatexilaBuildTool* build_tool) {
	gchar* _tmp0_ = NULL;
	LatexilaBuildTool* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GtkEntry* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	LatexilaBuildTool* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	LatexilaBuildTool* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GtkEntry* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	LatexilaBuildTool* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GtkEntry* _tmp21_ = NULL;
	GtkComboBox* _tmp22_ = NULL;
	GtkTreeIter iter = {0};
	gboolean ok = FALSE;
	GtkListStore* _tmp23_ = NULL;
	GtkTreeIter _tmp24_ = {0};
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp27_ = NULL;
	GtkTreeModel* _tmp28_ = NULL;
	GtkListStore* _tmp42_ = NULL;
	LatexilaBuildTool* _tmp43_ = NULL;
	GList* _tmp44_ = NULL;
	GtkTreeView* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tool != NULL);
	_tmp1_ = build_tool;
	g_object_get (_tmp1_, "label", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = self->priv->_entry_label;
	gtk_entry_set_text (_tmp5_, _tmp0_);
	_tmp7_ = build_tool;
	_tmp8_ = latexila_build_tool_get_description (_tmp7_);
	_tmp6_ = _tmp8_;
	if (_tmp6_ == NULL) {
		_tmp6_ = "";
	}
	_tmp9_ = self->priv->_entry_desc;
	gtk_entry_set_text (_tmp9_, _tmp6_);
	_tmp11_ = build_tool;
	g_object_get (_tmp11_, "extensions", &_tmp12_, NULL);
	_tmp13_ = _tmp12_;
	_tmp10_ = _tmp13_;
	if (_tmp10_ == NULL) {
		gchar* _tmp14_ = NULL;
		_tmp14_ = g_strdup ("");
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp14_;
	}
	_tmp15_ = self->priv->_entry_extensions;
	gtk_entry_set_text (_tmp15_, _tmp10_);
	_tmp17_ = build_tool;
	g_object_get (_tmp17_, "files-to-open", &_tmp18_, NULL);
	_tmp19_ = _tmp18_;
	_tmp16_ = _tmp19_;
	if (_tmp16_ == NULL) {
		gchar* _tmp20_ = NULL;
		_tmp20_ = g_strdup ("");
		_g_free0 (_tmp16_);
		_tmp16_ = _tmp20_;
	}
	_tmp21_ = self->priv->_entry_files_to_open;
	gtk_entry_set_text (_tmp21_, _tmp16_);
	_tmp22_ = self->priv->_icons_combobox;
	gtk_combo_box_set_active (_tmp22_, 0);
	_tmp23_ = self->priv->_icons_store;
	_tmp25_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp23_, &_tmp24_);
	iter = _tmp24_;
	ok = _tmp25_;
	_tmp26_ = ok;
	g_return_if_fail (_tmp26_);
	_tmp27_ = self->priv->_icons_store;
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp27_) : NULL);
	model = _tmp28_;
	{
		gboolean _tmp29_ = FALSE;
		_tmp29_ = TRUE;
		while (TRUE) {
			gchar* icon_name = NULL;
			GtkTreeModel* _tmp32_ = NULL;
			GtkTreeIter _tmp33_ = {0};
			const gchar* _tmp34_ = NULL;
			LatexilaBuildTool* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			gboolean _tmp39_ = FALSE;
			if (!_tmp29_) {
				GtkListStore* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				_tmp30_ = self->priv->_icons_store;
				_tmp31_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp30_, &iter);
				if (!_tmp31_) {
					break;
				}
			}
			_tmp29_ = FALSE;
			_tmp32_ = model;
			_tmp33_ = iter;
			gtk_tree_model_get (_tmp32_, &_tmp33_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, &icon_name, -1);
			_tmp34_ = icon_name;
			_tmp35_ = build_tool;
			g_object_get (_tmp35_, "icon", &_tmp36_, NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strcmp0 (_tmp34_, _tmp38_) == 0;
			_g_free0 (_tmp38_);
			if (_tmp39_) {
				GtkComboBox* _tmp40_ = NULL;
				GtkTreeIter _tmp41_ = {0};
				_tmp40_ = self->priv->_icons_combobox;
				_tmp41_ = iter;
				gtk_combo_box_set_active_iter (_tmp40_, &_tmp41_);
				_g_free0 (icon_name);
				break;
			}
			_g_free0 (icon_name);
		}
	}
	_tmp42_ = self->priv->_jobs_store;
	gtk_list_store_clear (_tmp42_);
	_tmp43_ = build_tool;
	_tmp44_ = latexila_build_tool_get_jobs (_tmp43_);
	{
		GList* build_job_collection = NULL;
		GList* build_job_it = NULL;
		build_job_collection = _tmp44_;
		for (build_job_it = build_job_collection; build_job_it != NULL; build_job_it = build_job_it->next) {
			LatexilaBuildJob* _tmp45_ = NULL;
			LatexilaBuildJob* build_job = NULL;
			_tmp45_ = _g_object_ref0 ((LatexilaBuildJob*) build_job_it->data);
			build_job = _tmp45_;
			{
				LatexilaBuildJob* _tmp46_ = NULL;
				_tmp46_ = build_job;
				build_tool_dialog_add_build_job (self, _tmp46_);
				_g_object_unref0 (build_job);
			}
		}
	}
	_tmp47_ = self->priv->_jobs_view;
	gtk_tree_view_columns_autosize (_tmp47_);
	_g_object_unref0 (model);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp0_);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static LatexilaBuildTool* build_tool_dialog_retrieve_build_tool (BuildToolDialog* self) {
	LatexilaBuildTool* result = NULL;
	LatexilaBuildTool* tool = NULL;
	LatexilaBuildTool* _tmp0_ = NULL;
	LatexilaBuildTool* _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	LatexilaBuildTool* _tmp7_ = NULL;
	GtkEntry* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	LatexilaBuildTool* _tmp13_ = NULL;
	GtkEntry* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	LatexilaBuildTool* _tmp19_ = NULL;
	GtkEntry* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp25_ = NULL;
	GtkTreeIter _tmp26_ = {0};
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp27_ = NULL;
	GtkTreeModel* _tmp28_ = NULL;
	gchar* icon_name = NULL;
	GtkTreeModel* _tmp29_ = NULL;
	GtkTreeIter _tmp30_ = {0};
	LatexilaBuildTool* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	GtkListStore* _tmp33_ = NULL;
	GtkTreeModel* _tmp34_ = NULL;
	gboolean valid = FALSE;
	GtkListStore* _tmp35_ = NULL;
	GtkTreeIter _tmp36_ = {0};
	gboolean _tmp37_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_tool_new ();
	tool = _tmp0_;
	_tmp1_ = tool;
	_tmp2_ = self->priv->_entry_label;
	_tmp3_ = gtk_entry_get_text (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	g_object_set (_tmp1_, "label", _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_tmp7_ = tool;
	_tmp8_ = self->priv->_entry_desc;
	_tmp9_ = gtk_entry_get_text (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_strip (_tmp10_);
	_tmp12_ = _tmp11_;
	g_object_set (_tmp7_, "description", _tmp12_, NULL);
	_g_free0 (_tmp12_);
	_tmp13_ = tool;
	_tmp14_ = self->priv->_entry_extensions;
	_tmp15_ = gtk_entry_get_text (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = string_strip (_tmp16_);
	_tmp18_ = _tmp17_;
	g_object_set (_tmp13_, "extensions", _tmp18_, NULL);
	_g_free0 (_tmp18_);
	_tmp19_ = tool;
	_tmp20_ = self->priv->_entry_files_to_open;
	_tmp21_ = gtk_entry_get_text (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = string_strip (_tmp22_);
	_tmp24_ = _tmp23_;
	g_object_set (_tmp19_, "files-to-open", _tmp24_, NULL);
	_g_free0 (_tmp24_);
	_tmp25_ = self->priv->_icons_combobox;
	gtk_combo_box_get_active_iter (_tmp25_, &_tmp26_);
	iter = _tmp26_;
	_tmp27_ = self->priv->_icons_store;
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp27_) : NULL);
	model = _tmp28_;
	_tmp29_ = model;
	_tmp30_ = iter;
	gtk_tree_model_get (_tmp29_, &_tmp30_, BUILD_TOOL_DIALOG_ICON_COLUMN_ICON_NAME, &icon_name, -1);
	_tmp31_ = tool;
	_tmp32_ = icon_name;
	g_object_set (_tmp31_, "icon", _tmp32_, NULL);
	_tmp33_ = self->priv->_jobs_store;
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp33_) : NULL);
	_g_object_unref0 (model);
	model = _tmp34_;
	_tmp35_ = self->priv->_jobs_store;
	_tmp37_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp35_, &_tmp36_);
	iter = _tmp36_;
	valid = _tmp37_;
	while (TRUE) {
		gboolean _tmp38_ = FALSE;
		LatexilaBuildJob* job = NULL;
		LatexilaBuildJob* _tmp39_ = NULL;
		gchar* command = NULL;
		gchar* post_processor_name = NULL;
		GtkTreeModel* _tmp40_ = NULL;
		GtkTreeIter _tmp41_ = {0};
		LatexilaBuildJob* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		LatexilaPostProcessorType type = 0;
		const gchar* _tmp46_ = NULL;
		LatexilaPostProcessorType _tmp47_ = 0;
		gboolean _tmp48_ = FALSE;
		LatexilaBuildTool* _tmp51_ = NULL;
		LatexilaBuildJob* _tmp52_ = NULL;
		GtkListStore* _tmp53_ = NULL;
		gboolean _tmp54_ = FALSE;
		_tmp38_ = valid;
		if (!_tmp38_) {
			break;
		}
		_tmp39_ = latexila_build_job_new ();
		job = _tmp39_;
		_tmp40_ = model;
		_tmp41_ = iter;
		gtk_tree_model_get (_tmp40_, &_tmp41_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, &command, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, &post_processor_name, -1);
		_tmp42_ = job;
		_tmp43_ = command;
		_tmp44_ = string_strip (_tmp43_);
		_tmp45_ = _tmp44_;
		g_object_set (_tmp42_, "command", _tmp45_, NULL);
		_g_free0 (_tmp45_);
		_tmp46_ = post_processor_name;
		_tmp48_ = latexila_post_processor_get_type_from_name (_tmp46_, &_tmp47_);
		type = _tmp47_;
		if (_tmp48_) {
			LatexilaBuildJob* _tmp49_ = NULL;
			LatexilaPostProcessorType _tmp50_ = 0;
			_tmp49_ = job;
			_tmp50_ = type;
			g_object_set (_tmp49_, "post-processor-type", _tmp50_, NULL);
		}
		_tmp51_ = tool;
		_tmp52_ = job;
		latexila_build_tool_add_job (_tmp51_, _tmp52_);
		_tmp53_ = self->priv->_jobs_store;
		_tmp54_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp53_, &iter);
		valid = _tmp54_;
		_g_free0 (post_processor_name);
		_g_free0 (command);
		_g_object_unref0 (job);
	}
	result = tool;
	_g_free0 (icon_name);
	_g_object_unref0 (model);
	return result;
}


/*************************************************************************/
static void build_tool_dialog_add_build_job (BuildToolDialog* self, LatexilaBuildJob* job) {
	gchar* post_processor_name = NULL;
	LatexilaBuildJob* _tmp0_ = NULL;
	LatexilaPostProcessorType _tmp1_ = 0;
	LatexilaPostProcessorType _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkListStore* _tmp7_ = NULL;
	GtkTreeIter _tmp8_ = {0};
	LatexilaBuildJob* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GtkTreeSelection* select = NULL;
	GtkTreeView* _tmp13_ = NULL;
	GtkTreeSelection* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	_tmp0_ = job;
	g_object_get (_tmp0_, "post-processor-type", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = latexila_post_processor_get_name_from_type (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	post_processor_name = _tmp4_;
	_tmp5_ = self->priv->_jobs_store;
	gtk_list_store_append (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	_tmp7_ = self->priv->_jobs_store;
	_tmp8_ = iter;
	_tmp9_ = job;
	g_object_get (_tmp9_, "command", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	gtk_list_store_set (_tmp7_, &_tmp8_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp12_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, post_processor_name, -1);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->_jobs_view;
	_tmp14_ = gtk_tree_view_get_selection (_tmp13_);
	select = _tmp14_;
	g_signal_emit_by_name (select, "changed");
	_g_free0 (post_processor_name);
}


/*************************************************************************/
static GtkGrid* build_tool_dialog_get_main_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* _tmp3_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	GtkGrid* _tmp5_ = NULL;
	GtkGrid* _tmp6_ = NULL;
	GtkGrid* _tmp7_ = NULL;
	GtkGrid* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	GtkGrid* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	main_grid = _tmp0_;
	gtk_grid_set_row_spacing (main_grid, (guint) 5);
	gtk_grid_set_column_spacing (main_grid, (guint) 5);
	_tmp1_ = build_tool_dialog_get_label_grid (self);
	_tmp2_ = _tmp1_;
	gtk_grid_attach (main_grid, (GtkWidget*) _tmp2_, 0, 0, 1, 1);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = build_tool_dialog_get_desc_grid (self);
	_tmp4_ = _tmp3_;
	gtk_grid_attach (main_grid, (GtkWidget*) _tmp4_, 1, 0, 1, 1);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = build_tool_dialog_get_extensions_grid (self);
	_tmp6_ = _tmp5_;
	gtk_grid_attach (main_grid, (GtkWidget*) _tmp6_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = build_tool_dialog_get_icons_grid (self);
	_tmp8_ = _tmp7_;
	gtk_grid_attach (main_grid, (GtkWidget*) _tmp8_, 1, 1, 1, 1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = build_tool_dialog_get_jobs_grid (self);
	_tmp10_ = _tmp9_;
	gtk_grid_attach (main_grid, (GtkWidget*) _tmp10_, 0, 2, 2, 1);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = build_tool_dialog_get_files_to_open_grid (self);
	_tmp12_ = _tmp11_;
	gtk_grid_attach (main_grid, (GtkWidget*) _tmp12_, 0, 3, 2, 1);
	_g_object_unref0 (_tmp12_);
	result = main_grid;
	return result;
}


static GtkGrid* build_tool_dialog_get_label_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_ = NULL;
	GtkLabel* title = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkLabel* arrow = NULL;
	GtkLabel* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_grid_set_row_spacing (grid, (guint) 6);
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 6);
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	title = _tmp1_;
	_tmp2_ = _ ("Label");
	_tmp3_ = g_strconcat ("<b>", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "</b>", NULL);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (title, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	gtk_widget_set_halign ((GtkWidget*) title, GTK_ALIGN_START);
	gtk_grid_attach (grid, (GtkWidget*) title, 0, 0, 1, 1);
	_tmp7_ = (GtkLabel*) gtk_label_new ("→");
	g_object_ref_sink (_tmp7_);
	arrow = _tmp7_;
	_tmp8_ = _ ("You can select this arrow and copy/paste it!");
	gtk_widget_set_tooltip_text ((GtkWidget*) arrow, _tmp8_);
	gtk_widget_set_halign ((GtkWidget*) arrow, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) arrow, TRUE);
	gtk_label_set_selectable (arrow, TRUE);
	gtk_grid_attach (grid, (GtkWidget*) arrow, 1, 0, 1, 1);
	gtk_widget_set_hexpand ((GtkWidget*) grid, FALSE);
	_tmp9_ = self->priv->_entry_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp9_, 12);
	_tmp10_ = self->priv->_entry_label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp10_, 0, 1, 2, 1);
	result = grid;
	_g_object_unref0 (arrow);
	_g_object_unref0 (title);
	return result;
}


static GtkGrid* build_tool_dialog_get_desc_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkGrid* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_desc;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = _ ("Description");
	_tmp2_ = self->priv->_entry_desc;
	_tmp3_ = utils_get_dialog_component (_tmp1_, (GtkWidget*) _tmp2_);
	result = _tmp3_;
	return result;
}


static GtkGrid* build_tool_dialog_get_extensions_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkEntry* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_extensions;
	_tmp1_ = _ ("File extensions for which the build tool can be executed.");
	_tmp2_ = g_strconcat (_tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _ ("The extensions are separated by spaces.");
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, "\n", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _ ("If it is empty, all extensions are allowed.");
	_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp12_ = _ ("Extensions");
	_tmp13_ = self->priv->_entry_extensions;
	_tmp14_ = utils_get_dialog_component (_tmp12_, (GtkWidget*) _tmp13_);
	result = _tmp14_;
	return result;
}


static GtkGrid* build_tool_dialog_get_icons_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	const gchar* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Icon");
	_tmp1_ = self->priv->_icons_combobox;
	_tmp2_ = utils_get_dialog_component (_tmp0_, (GtkWidget*) _tmp1_);
	result = _tmp2_;
	return result;
}


static GtkGrid* build_tool_dialog_get_jobs_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkLabel* placeholders = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* placeholder_filename = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GtkLabel* placeholder_shortname = NULL;
	GtkLabel* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GtkGrid* placeholders_grid = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkTreeView* _tmp17_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkTreeView* _tmp18_ = NULL;
	GtkScrolledWindow* _tmp19_ = NULL;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp20_ = NULL;
	GtkStyleContext* _tmp21_ = NULL;
	GtkStyleContext* _tmp22_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp23_ = NULL;
	GtkToolButton* _tmp24_ = NULL;
	GtkToolButton* _tmp25_ = NULL;
	GtkToolButton* _tmp26_ = NULL;
	GtkToolButton* _tmp27_ = NULL;
	GtkToolButton* _tmp28_ = NULL;
	GtkToolButton* _tmp29_ = NULL;
	GtkToolButton* _tmp30_ = NULL;
	GtkToolButton* _tmp31_ = NULL;
	GtkStyleContext* _tmp32_ = NULL;
	GtkStyleContext* _tmp33_ = NULL;
	GtkStyleContext* _tmp34_ = NULL;
	GtkStyleContext* _tmp35_ = NULL;
	GtkBox* jobs_box = NULL;
	GtkBox* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GtkGrid* _tmp38_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Placeholders:");
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	placeholders = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new ("$filename");
	g_object_ref_sink (_tmp2_);
	placeholder_filename = _tmp2_;
	_tmp3_ = _ ("The active document's filename.");
	_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _ ("If the active document belongs to a project, the main file is chosen.");
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	gtk_widget_set_tooltip_text ((GtkWidget*) placeholder_filename, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_tmp9_ = (GtkLabel*) gtk_label_new ("$shortname");
	g_object_ref_sink (_tmp9_);
	placeholder_shortname = _tmp9_;
	_tmp10_ = _ ("The active document's filename without its extension.");
	_tmp11_ = g_strconcat (_tmp10_, "\n", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = _ ("If the active document belongs to a project, the main file is chosen.");
	_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	gtk_widget_set_tooltip_text ((GtkWidget*) placeholder_shortname, _tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp16_);
	placeholders_grid = _tmp16_;
	gtk_orientable_set_orientation ((GtkOrientable*) placeholders_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (placeholders_grid, (guint) 10);
	gtk_container_add ((GtkContainer*) placeholders_grid, (GtkWidget*) placeholders);
	gtk_container_add ((GtkContainer*) placeholders_grid, (GtkWidget*) placeholder_filename);
	gtk_container_add ((GtkContainer*) placeholders_grid, (GtkWidget*) placeholder_shortname);
	_tmp17_ = self->priv->_jobs_view;
	g_object_set ((GtkWidget*) _tmp17_, "expand", TRUE, NULL);
	_tmp18_ = self->priv->_jobs_view;
	_tmp19_ = utils_add_scrollbar ((GtkWidget*) _tmp18_);
	scrolled_window = _tmp19_;
	gtk_widget_set_size_request ((GtkWidget*) scrolled_window, 600, 80);
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) scrolled_window);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	context = _tmp21_;
	_tmp22_ = context;
	gtk_style_context_set_junction_sides (_tmp22_, GTK_JUNCTION_BOTTOM);
	_tmp23_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp23_);
	toolbar = _tmp23_;
	_tmp24_ = build_tool_dialog_get_add_button (self);
	_tmp25_ = _tmp24_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp25_, -1);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = build_tool_dialog_get_remove_button (self);
	_tmp27_ = _tmp26_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp27_, -1);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = build_tool_dialog_get_up_button (self);
	_tmp29_ = _tmp28_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp29_, -1);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = build_tool_dialog_get_down_button (self);
	_tmp31_ = _tmp30_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp31_, -1);
	_g_object_unref0 (_tmp31_);
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_ICONS);
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	_g_object_unref0 (context);
	context = _tmp33_;
	_tmp34_ = context;
	gtk_style_context_add_class (_tmp34_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp35_ = context;
	gtk_style_context_set_junction_sides (_tmp35_, GTK_JUNCTION_TOP);
	_tmp36_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp36_);
	jobs_box = _tmp36_;
	gtk_widget_set_margin_bottom ((GtkWidget*) placeholders_grid, 8);
	gtk_box_pack_start (jobs_box, (GtkWidget*) placeholders_grid, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start (jobs_box, (GtkWidget*) scrolled_window, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (jobs_box, (GtkWidget*) toolbar, FALSE, TRUE, (guint) 0);
	_tmp37_ = _ ("Jobs");
	_tmp38_ = utils_get_dialog_component (_tmp37_, (GtkWidget*) jobs_box);
	result = _tmp38_;
	_g_object_unref0 (jobs_box);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (context);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (placeholders_grid);
	_g_object_unref0 (placeholder_shortname);
	_g_object_unref0 (placeholder_filename);
	_g_object_unref0 (placeholders);
	return result;
}


static GtkGrid* build_tool_dialog_get_files_to_open_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkEntry* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkEntry* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_files_to_open;
	_tmp1_ = _ ("List of files to open after executing the build jobs.");
	_tmp2_ = g_strconcat (_tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _ ("The files are separated by spaces.");
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, "\n", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _ ("You should use the placeholders to specify the files.");
	_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp12_ = self->priv->_entry_files_to_open;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = _ ("Files to open");
	_tmp14_ = self->priv->_entry_files_to_open;
	_tmp15_ = utils_get_dialog_component (_tmp13_, (GtkWidget*) _tmp14_);
	result = _tmp15_;
	return result;
}


static void build_tool_dialog_class_init (BuildToolDialogClass * klass) {
	build_tool_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_dialog_finalize;
}


static void build_tool_dialog_instance_init (BuildToolDialog * self) {
	self->priv = BUILD_TOOL_DIALOG_GET_PRIVATE (self);
}


static void build_tool_dialog_finalize (GObject* obj) {
	BuildToolDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOL_DIALOG, BuildToolDialog);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_entry_label);
	_g_object_unref0 (self->priv->_entry_desc);
	_g_object_unref0 (self->priv->_entry_extensions);
	_g_object_unref0 (self->priv->_entry_files_to_open);
	_g_object_unref0 (self->priv->_icons_store);
	_g_object_unref0 (self->priv->_icons_combobox);
	_g_object_unref0 (self->priv->_jobs_store);
	_g_object_unref0 (self->priv->_jobs_view);
	G_OBJECT_CLASS (build_tool_dialog_parent_class)->finalize (obj);
}


GType build_tool_dialog_get_type (void) {
	static volatile gsize build_tool_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolDialog), 0, (GInstanceInitFunc) build_tool_dialog_instance_init, NULL };
		GType build_tool_dialog_type_id;
		build_tool_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolDialog", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_dialog_type_id__volatile, build_tool_dialog_type_id);
	}
	return build_tool_dialog_type_id__volatile;
}



