# status report function
# Automatically align right column and selects text based on condition.

function(liquid_status text)
  set(status_cond)
  set(status_then)
  set(status_else)

  set(status_current_name "cond")
  foreach(arg ${ARGN})
    if(arg STREQUAL "THEN")
      set(status_current_name "then")
    elseif(arg STREQUAL "ELSE")
      set(status_current_name "else")
    else()
      list(APPEND status_${status_current_name} ${arg})
    endif()
  endforeach()

  if(DEFINED status_cond)
    set(status_placeholder_length 23)
    string(RANDOM LENGTH ${status_placeholder_length} ALPHABET " " status_placeholder)
    string(LENGTH "${text}" status_text_length)
    if(status_text_length LESS status_placeholder_length)
      string(SUBSTRING "${text}${status_placeholder}" 0 ${status_placeholder_length} status_text)
    elseif(DEFINED status_then OR DEFINED status_else)
      message(STATUS "${text}")
      set(status_text "${status_placeholder}")
    else()
      set(status_text "${text}")
    endif()

    if(DEFINED status_then OR DEFINED status_else)
      if(${status_cond})
        string(REPLACE ";" " " status_then "${status_then}")
        string(REGEX REPLACE "^[ \t]+" "" status_then "${status_then}")
        message(STATUS "${status_text} ${status_then}")
      else()
        string(REPLACE ";" " " status_else "${status_else}")
        string(REGEX REPLACE "^[ \t]+" "" status_else "${status_else}")
        message(STATUS "${status_text} ${status_else}")
      endif()
    else()
      string(REPLACE ";" " " status_cond "${status_cond}")
      string(REGEX REPLACE "^[ \t]+" "" status_cond "${status_cond}")
      message(STATUS "${status_text} ${status_cond}")
    endif()
  else()
    message(STATUS "${text}")
  endif()
endfunction()

# Function merging lists of compiler flags to single string.
# Usage:
#   liquid_merge_flag_lists(out_variable <list1> [<list2>] [<list3>] ...)
function(liquid_merge_flag_lists out_var)
  set(__result "")
  foreach(__list ${ARGN})
    foreach(__flag ${${__list}})
      string(STRIP ${__flag} __flag)
      set(__result "${__result} ${__flag}")
    endforeach()
  endforeach()
  string(STRIP ${__result} __result)
  set(${out_var} ${__result} PARENT_SCOPE)
endfunction()

# Prints accumulated liquid-dsp configuration summary
# Usage:
#   liquid_print_config_summary()
function(liquid_print_config_summary)

    liquid_merge_flag_lists(__flags_rel CMAKE_CXX_FLAGS_RELEASE CMAKE_CXX_FLAGS)
    liquid_merge_flag_lists(__flags_deb CMAKE_CXX_FLAGS_DEBUG CMAKE_CXX_FLAGS)

    liquid_status("")
    liquid_status("******************* liquid-dsp Configuration Summary *******************")
    liquid_status("General:")
    liquid_status("  Version           :   ${PROJECT_VERSION}")
    liquid_status("  System            :   ${CMAKE_SYSTEM_NAME}")
    liquid_status("  C++ compiler      :   ${CMAKE_CXX_COMPILER}")
    liquid_status("  Release CXX flags :   ${__flags_rel}")
    liquid_status("  Debug CXX flags   :   ${__flags_deb}")
    liquid_status("  Build type        :   ${CMAKE_BUILD_TYPE}")
    liquid_status("")
    liquid_status("  BUILD_EXAMPLES    :   ${BUILD_EXAMPLES}")
    liquid_status("  BUILD_SANDBOX     :   ${BUILD_SANDBOX}")
    liquid_status("  BUILD_AUTOTESTS   :   ${BUILD_AUTOTESTS}")
    liquid_status("  BUILD_BENCHMARKS  :   ${BUILD_BENCHMARKS}")
    liquid_status("  BUILD_DOC         :   ${BUILD_DOC}")
    liquid_status("  COVERAGE          :   ${COVERAGE}")
    liquid_status("")
    liquid_status("Acceleration:")
    liquid_status("  NEON              : " C_NEON_FOUND THEN "Yes" ELSE "No")
    liquid_status("  SSE4              : " C_SSE4_FOUND THEN "Yes" ELSE "No")
    liquid_status("  AVX               : " C_AVX_FOUND THEN "Yes" ELSE "No")
    liquid_status("  AVX2              : " C_AVX2_FOUND THEN "Yes" ELSE "No")
    liquid_status("  AVX512            : " C_AVX512_FOUND THEN "Yes" ELSE "No")
    liquid_status("  AltiVec           : " C_ALTIVEC_FOUND THEN "Yes" ELSE "No")
    #liquid_status("  Pthread           : " USE_PTHREAD THEN "Yes" ELSE "No")
    #liquid_status("  TBB               : " USE_TBB AND TBB_FOUND THEN "Yes (ver. ${TBB_INTERFACE_VERSION})" ELSE "No")
    #liquid_status("  OMP               : " USE_OMP AND OMP_FOUND THEN "Yes" ELSE "No")
    liquid_status("")
    liquid_status("Install:")
    liquid_status("  Install path      :   ${CMAKE_INSTALL_PREFIX}")
    liquid_status("")
endfunction()
