//
//  Lynkeos
//  $Id: LynkeosCommon.h,v 1.2 2004/09/02 22:41:32 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Mon Aug 9 2004.
//  Copyright (c) 2003-2004. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  Common definitions for the Lynkeos project
//

#ifndef __LYNKEOSCOMMON_H
#define __LYNKEOSCOMMON_H

#include <sys/types.h>



#ifdef GNUSTEP
typedef BOOL bool;
typedef long TimeValue;

#define true 1
#define false 0
#define NSMovie LynkeosFfmpegMovie
#endif

// Integer cartesian types
typedef struct
{
   short x;
   short y;
} MyIntegerPoint;

typedef struct
{
   u_short width;
   u_short height;
} MyIntegerSize;

typedef struct
{
   MyIntegerPoint origin;
   MyIntegerSize  size;
} MyIntegerRect;

// Creators and conversion
static inline MyIntegerPoint MyMakeIntegerPoint(u_short x, u_short y) 
{
   MyIntegerPoint p = {x,y};
   return p; 
}

static inline MyIntegerSize MyMakeIntegerSize(u_short w, u_short h) 
{
   MyIntegerSize s = {w,h};
   return s;
}

static inline MyIntegerRect MyMakeIntegerRect(u_short x, u_short y, u_short w, u_short h) 
{
   MyIntegerRect r = {{x,y},{w,h}};
   return r;
}

#ifdef __OBJC__

static inline NSPoint NSPointFromIntegerPoint(MyIntegerPoint p)
{
   NSPoint rp = {p.x,p.y}; 
   return rp; 
}

static inline NSSize NSSizeFromIntegerSize(MyIntegerSize s)
{ 
   NSSize rs = {s.width,s.height}; 
   return rs; 
}

static inline NSRect NSRectFromIntegerRect(MyIntegerRect r) 
{
   NSRect rr = {{r.origin.x,r.origin.y},
                {r.size.width,r.size.height}};
   return rr;
}

static inline MyIntegerPoint  MyIntegerPointFromNSPoint(NSPoint p) 
{ 
   MyIntegerPoint rp = {(long)p.x,(long)p.y}; 
   return rp; 
}

static inline MyIntegerSize MyIntegerSizeFromNSSize(NSSize s) 
{ 
   MyIntegerSize rs = {(u_long)s.width,(u_long)s.height}; 
   return rs; 
}

static inline MyIntegerRect MyIntegerRectFromNSRect(NSRect r) 
{
   MyIntegerRect rr = {{(long)r.origin.x,(long)r.origin.y},
                       {(u_long)r.size.width,(u_long)r.size.height}};
   return rr; 
}

#endif

#endif
