# This file sets up five lists:
#	MAIN_SOURCE_FILES     List of compilation units  which will be included in
#	                      the library. If it isn't on this list, it won't be
#	                      part of the library. Please try to keep it sorted to
#	                      maintain sanity.
#
#	TEST_SOURCE_FILES     List of programs that will be run as unit tests.
#
#	TEST_DATA_FILES       Files from the source three that should be made
#	                      available in the corresponding location in the build
#	                      tree in order to run tests there.
#
#	EXAMPLE_SOURCE_FILES  Other programs that will be compiled as part of the
#	                      build, but which is not part of the library nor is
#	                      run as tests.
#
#	PUBLIC_HEADER_FILES   List of public header files that should be
#	                      distributed together with the library. The source
#	                      files can of course include other files than these;
#	                      you should only add to this list if the *user* of
#	                      the library needs it.

list (APPEND MAIN_SOURCE_FILES
      src/opm/common/OpmLog/CounterLog.cpp
      src/opm/common/OpmLog/EclipsePRTLog.cpp
      src/opm/common/OpmLog/LogBackend.cpp
      src/opm/common/OpmLog/Logger.cpp
      src/opm/common/OpmLog/LogUtil.cpp
      src/opm/common/OpmLog/KeywordLocation.cpp
      src/opm/common/OpmLog/InfoLogger.cpp
      src/opm/common/OpmLog/OpmLog.cpp
      src/opm/common/OpmLog/StreamLog.cpp
      src/opm/common/OpmLog/TimerLog.cpp
      src/opm/common/utility/ActiveGridCells.cpp
      src/opm/common/utility/Demangle.cpp
      src/opm/common/utility/FileSystem.cpp
      src/opm/common/utility/MemPacker.cpp
      src/opm/common/utility/numeric/MonotCubicInterpolator.cpp
      src/opm/common/utility/OpmInputError.cpp
      src/opm/common/utility/parameters/Parameter.cpp
      src/opm/common/utility/parameters/ParameterGroup.cpp
      src/opm/common/utility/parameters/ParameterRequirement.cpp
      src/opm/common/utility/parameters/ParameterTools.cpp
      src/opm/common/utility/numeric/calculateCellVol.cpp
      src/opm/common/utility/numeric/RootFinders.cpp
      src/opm/common/utility/shmatch.cpp
      src/opm/common/utility/String.cpp
      src/opm/common/utility/TimeService.cpp
      src/opm/material/common/Spline.cpp
      src/opm/material/common/Tabulated1DFunction.cpp
      src/opm/material/common/TridiagonalMatrix.cpp
      src/opm/material/common/UniformXTabulated2DFunction.cpp
      src/opm/material/components/CO2.cpp
      src/opm/material/components/H2.cpp
      src/opm/material/densead/Evaluation.cpp
      src/opm/material/fluidmatrixinteractions/EclEpsScalingPoints.cpp
      src/opm/material/fluidsystems/BlackOilFluidSystem.cpp
      src/opm/material/fluidsystems/blackoilpvt/DeadOilPvt.cpp
      src/opm/material/fluidsystems/blackoilpvt/DryGasPvt.cpp
      src/opm/material/fluidsystems/blackoilpvt/DryHumidGasPvt.cpp
      src/opm/material/fluidsystems/blackoilpvt/LiveOilPvt.cpp
      src/opm/material/fluidsystems/blackoilpvt/SolventPvt.cpp
      src/opm/material/fluidsystems/blackoilpvt/WetGasPvt.cpp
      src/opm/material/fluidsystems/blackoilpvt/WetHumidGasPvt.cpp
)
if(ENABLE_ECL_INPUT)
  list(APPEND MAIN_SOURCE_FILES
    external/resinsight/LibCore/cvfAssert.cpp
    external/resinsight/LibCore/cvfAtomicCounter.cpp
    external/resinsight/LibCore/cvfCharArray.cpp
    external/resinsight/LibCore/cvfMath.cpp
    external/resinsight/LibCore/cvfObject.cpp
    external/resinsight/LibCore/cvfPlane.cpp
    external/resinsight/LibCore/cvfString.cpp
    external/resinsight/LibCore/cvfSystem.cpp
    external/resinsight/LibCore/cvfTrace.cpp
    external/resinsight/LibCore/cvfVector3.cpp
    external/resinsight/LibGeometry/cvfBoundingBox.cpp
    external/resinsight/LibGeometry/cvfBoundingBoxTree.cpp
    external/resinsight/LibGeometry/cvfRay.cpp
    external/resinsight/ReservoirDataModel/cvfGeometryTools.cpp
    external/resinsight/ReservoirDataModel/RigHexIntersectionTools.cpp
    external/resinsight/ReservoirDataModel/RigWellLogExtractor.cpp
    external/resinsight/ReservoirDataModel/RigWellPath.cpp
    external/resinsight/CommonCode/cvfStructGrid.cpp
    external/resinsight/cafPdmCore/cafSignal.cpp
    external/resinsight/cafHexGridIntersectionTools/cafHexGridIntersectionTools.cpp
    src/opm/io/eclipse/SummaryNode.cpp
    src/opm/json/JsonObject.cpp
    src/opm/input/eclipse/Deck/Deck.cpp
    src/opm/input/eclipse/Deck/DeckView.cpp
    src/opm/input/eclipse/Deck/DeckTree.cpp
    src/opm/input/eclipse/Deck/FileDeck.cpp
    src/opm/input/eclipse/Deck/DeckItem.cpp
    src/opm/input/eclipse/Deck/DeckValue.cpp
    src/opm/input/eclipse/Deck/DeckKeyword.cpp
    src/opm/input/eclipse/Deck/DeckRecord.cpp
    src/opm/input/eclipse/Deck/DeckOutput.cpp
    src/opm/input/eclipse/Deck/DeckSection.cpp
    src/opm/input/eclipse/Deck/ImportContainer.cpp
    src/opm/input/eclipse/Deck/UDAValue.cpp
    src/opm/input/eclipse/Python/Python.cpp
    src/opm/input/eclipse/Schedule/Action/PyAction.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/AquiferConfig.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/AquiferFlux.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/AquiferCT.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/Aquifetp.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/Aquancon.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/AquiferHelpers.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/NumericalAquifer/NumericalAquiferCell.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/NumericalAquifer/NumericalAquiferConnection.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/NumericalAquifer/SingleNumericalAquifer.cpp
    src/opm/input/eclipse/EclipseState/Aquifer/NumericalAquifer/NumericalAquifers.cpp
    src/opm/input/eclipse/EclipseState/checkDeck.cpp
    src/opm/input/eclipse/EclipseState/EclipseConfig.cpp
    src/opm/input/eclipse/EclipseState/EclipseState.cpp
    src/opm/input/eclipse/EclipseState/EndpointScaling.cpp
    src/opm/input/eclipse/EclipseState/Grid/Box.cpp
    src/opm/input/eclipse/EclipseState/Grid/BoxManager.cpp
    src/opm/input/eclipse/EclipseState/Grid/Carfin.cpp
    src/opm/input/eclipse/EclipseState/Grid/CarfinManager.cpp
    src/opm/input/eclipse/EclipseState/Grid/LgrCollection.cpp
    src/opm/input/eclipse/EclipseState/Grid/EclipseGrid.cpp
    src/opm/input/eclipse/EclipseState/Grid/FieldProps.cpp
    src/opm/input/eclipse/EclipseState/Grid/FieldPropsManager.cpp
    src/opm/input/eclipse/EclipseState/Grid/FaceDir.cpp
    src/opm/input/eclipse/EclipseState/Grid/FaultCollection.cpp
    src/opm/input/eclipse/EclipseState/Grid/Fault.cpp
    src/opm/input/eclipse/EclipseState/Grid/FaultFace.cpp
    src/opm/input/eclipse/EclipseState/Grid/GridDims.cpp
    src/opm/input/eclipse/EclipseState/Grid/MapAxes.cpp
    src/opm/input/eclipse/EclipseState/Grid/MinpvMode.cpp
    src/opm/input/eclipse/EclipseState/Grid/MULTREGTScanner.cpp
    src/opm/input/eclipse/EclipseState/Grid/NNC.cpp
    src/opm/input/eclipse/EclipseState/Grid/Operate.cpp
    src/opm/input/eclipse/EclipseState/Grid/PinchMode.cpp
    src/opm/input/eclipse/EclipseState/Grid/readKeywordCarfin.cpp
    src/opm/input/eclipse/EclipseState/Grid/SatfuncPropertyInitializers.cpp
    src/opm/input/eclipse/EclipseState/Grid/setKeywordBox.cpp
    src/opm/input/eclipse/EclipseState/Grid/TranCalculator.cpp
    src/opm/input/eclipse/EclipseState/Grid/TransMult.cpp
    src/opm/input/eclipse/EclipseState/InitConfig/Equil.cpp
    src/opm/input/eclipse/EclipseState/InitConfig/FoamConfig.cpp
    src/opm/input/eclipse/EclipseState/InitConfig/InitConfig.cpp
    src/opm/input/eclipse/EclipseState/IOConfig/IOConfig.cpp
    src/opm/input/eclipse/EclipseState/Runspec.cpp
    src/opm/input/eclipse/EclipseState/Phase.cpp
    src/opm/input/eclipse/EclipseState/TracerConfig.cpp
    src/opm/input/eclipse/EclipseState/MICPpara.cpp
    src/opm/input/eclipse/EclipseState/WagHysteresisConfig.cpp
    src/opm/input/eclipse/Schedule/Action/ActionAST.cpp
    src/opm/input/eclipse/Schedule/Action/ActionContext.cpp
    src/opm/input/eclipse/Schedule/Action/ActionResult.cpp
    src/opm/input/eclipse/Schedule/Action/Actdims.cpp
    src/opm/input/eclipse/Schedule/Action/Actions.cpp
    src/opm/input/eclipse/Schedule/Action/ActionX.cpp
    src/opm/input/eclipse/Schedule/Action/ActionParser.cpp
    src/opm/input/eclipse/Schedule/Action/ActionValue.cpp
    src/opm/input/eclipse/Schedule/Action/ASTNode.cpp
    src/opm/input/eclipse/Schedule/Action/Condition.cpp
    src/opm/input/eclipse/Schedule/Action/Enums.cpp
    src/opm/input/eclipse/Schedule/Action/State.cpp
    src/opm/input/eclipse/Schedule/Action/WGNames.cpp
    src/opm/input/eclipse/Schedule/ArrayDimChecker.cpp
    src/opm/input/eclipse/Schedule/BCProp.cpp
    src/opm/input/eclipse/Schedule/CompletedCells.cpp
    src/opm/input/eclipse/Schedule/eval_uda.cpp
    src/opm/input/eclipse/Schedule/Events.cpp
    src/opm/input/eclipse/Schedule/GasLiftOpt.cpp
    src/opm/input/eclipse/Schedule/Group/GPMaint.cpp
    src/opm/input/eclipse/Schedule/Group/Group.cpp
    src/opm/input/eclipse/Schedule/Group/GuideRate.cpp
    src/opm/input/eclipse/Schedule/Group/GuideRateConfig.cpp
    src/opm/input/eclipse/Schedule/Group/GuideRateModel.cpp
    src/opm/input/eclipse/Schedule/Group/GConSale.cpp
    src/opm/input/eclipse/Schedule/Group/GConSump.cpp
    src/opm/input/eclipse/Schedule/Group/GroupEconProductionLimits.cpp
    src/opm/input/eclipse/Schedule/Group/GTNode.cpp
    src/opm/input/eclipse/Schedule/KeywordHandlers.cpp
    src/opm/input/eclipse/Schedule/MessageLimits.cpp
    src/opm/input/eclipse/Schedule/MSW/icd.cpp
    src/opm/input/eclipse/Schedule/MSW/Compsegs.cpp
    src/opm/input/eclipse/Schedule/MSW/Segment.cpp
    src/opm/input/eclipse/Schedule/MSW/SegmentMatcher.cpp
    src/opm/input/eclipse/Schedule/MSW/WellSegments.cpp
    src/opm/input/eclipse/Schedule/MSW/AICD.cpp
    src/opm/input/eclipse/Schedule/MSW/SICD.cpp
    src/opm/input/eclipse/Schedule/MSW/Valve.cpp
    src/opm/input/eclipse/Schedule/Network/Balance.cpp
    src/opm/input/eclipse/Schedule/Network/Branch.cpp
    src/opm/input/eclipse/Schedule/Network/ExtNetwork.cpp
    src/opm/input/eclipse/Schedule/Network/Node.cpp
    src/opm/input/eclipse/Schedule/OilVaporizationProperties.cpp
    src/opm/input/eclipse/Schedule/RFTConfig.cpp
    src/opm/input/eclipse/Schedule/RPTConfig.cpp
    src/opm/input/eclipse/Schedule/RSTConfig.cpp
    src/opm/input/eclipse/Schedule/Schedule.cpp
    src/opm/input/eclipse/Schedule/ScheduleDeck.cpp
    src/opm/input/eclipse/Schedule/ScheduleGrid.cpp
    src/opm/input/eclipse/Schedule/ScheduleState.cpp
    src/opm/input/eclipse/Schedule/ScheduleTypes.cpp
    src/opm/input/eclipse/Schedule/SummaryState.cpp
    src/opm/input/eclipse/Schedule/Tuning.cpp
    src/opm/input/eclipse/Schedule/WriteRestartFileEvents.cpp
    src/opm/input/eclipse/Schedule/Well/Connection.cpp
    src/opm/input/eclipse/Schedule/Well/FilterCake.cpp
    src/opm/input/eclipse/Schedule/Well/injection.cpp
    src/opm/input/eclipse/Schedule/Well/NameOrder.cpp
    src/opm/input/eclipse/Schedule/Well/PAvg.cpp
    src/opm/input/eclipse/Schedule/Well/PAvgCalculator.cpp
    src/opm/input/eclipse/Schedule/Well/PAvgCalculatorCollection.cpp
    src/opm/input/eclipse/Schedule/Well/PAvgDynamicSourceData.cpp
    src/opm/input/eclipse/Schedule/Well/Well.cpp
    src/opm/input/eclipse/Schedule/Well/WellConnections.cpp
    src/opm/input/eclipse/Schedule/Well/WellMatcher.cpp
    src/opm/input/eclipse/Schedule/Well/WellEnums.cpp
    src/opm/input/eclipse/Schedule/Well/WellBrineProperties.cpp
    src/opm/input/eclipse/Schedule/Well/WellEconProductionLimits.cpp
    src/opm/input/eclipse/Schedule/Well/WellFoamProperties.cpp
    src/opm/input/eclipse/Schedule/Well/WellInjectionProperties.cpp
    src/opm/input/eclipse/Schedule/Well/WellMICPProperties.cpp
    src/opm/input/eclipse/Schedule/Well/WellPolymerProperties.cpp
    src/opm/input/eclipse/Schedule/Well/WellProductionProperties.cpp
    src/opm/input/eclipse/Schedule/Well/WellTestConfig.cpp
    src/opm/input/eclipse/Schedule/Well/WellTestState.cpp
    src/opm/input/eclipse/Schedule/WellTraj/RigEclipseWellLogExtractor.cpp
    src/opm/input/eclipse/Schedule/Well/WellTracerProperties.cpp
    src/opm/input/eclipse/Schedule/Well/WINJMULT.cpp
    src/opm/input/eclipse/Schedule/Well/WList.cpp
    src/opm/input/eclipse/Schedule/Well/WListManager.cpp
    src/opm/input/eclipse/Schedule/Well/WVFPDP.cpp
    src/opm/input/eclipse/Schedule/Well/WVFPEXP.cpp
    src/opm/input/eclipse/Schedule/WellTraj/RigEclipseWellLogExtractor.cpp
    src/opm/input/eclipse/EclipseState/SimulationConfig/BCConfig.cpp
    src/opm/input/eclipse/EclipseState/SimulationConfig/RockConfig.cpp
    src/opm/input/eclipse/EclipseState/SimulationConfig/SimulationConfig.cpp
    src/opm/input/eclipse/EclipseState/SimulationConfig/ThresholdPressure.cpp
    src/opm/input/eclipse/EclipseState/SummaryConfig/SummaryConfig.cpp
    src/opm/input/eclipse/EclipseState/Tables/Aqudims.cpp
    src/opm/input/eclipse/EclipseState/Tables/ColumnSchema.cpp
    src/opm/input/eclipse/EclipseState/Tables/DenT.cpp
    src/opm/input/eclipse/EclipseState/Tables/JouleThomson.cpp
    src/opm/input/eclipse/EclipseState/Tables/Eqldims.cpp
    src/opm/input/eclipse/EclipseState/Tables/JFunc.cpp
    src/opm/input/eclipse/EclipseState/Tables/PvtxTable.cpp
    src/opm/input/eclipse/EclipseState/Tables/Regdims.cpp
    src/opm/input/eclipse/EclipseState/Tables/SimpleTable.cpp
    src/opm/input/eclipse/EclipseState/Tables/PolyInjTables.cpp
    src/opm/input/eclipse/EclipseState/Tables/StandardCond.cpp
    src/opm/input/eclipse/EclipseState/Tables/TableColumn.cpp
    src/opm/input/eclipse/EclipseState/Tables/TableContainer.cpp
    src/opm/input/eclipse/EclipseState/Tables/TableIndex.cpp
    src/opm/input/eclipse/EclipseState/Tables/TLMixpar.cpp
    src/opm/input/eclipse/EclipseState/Tables/Ppcwmax.cpp
    src/opm/input/eclipse/EclipseState/Tables/TableManager.cpp
    src/opm/input/eclipse/EclipseState/Tables/TableSchema.cpp
    src/opm/input/eclipse/EclipseState/Tables/Tables.cpp
    src/opm/input/eclipse/EclipseState/Tables/Rock2dTable.cpp
    src/opm/input/eclipse/EclipseState/Tables/Rock2dtrTable.cpp
    src/opm/input/eclipse/EclipseState/Tables/PvtwsaltTable.cpp
    src/opm/input/eclipse/EclipseState/Tables/BrineDensityTable.cpp
    src/opm/input/eclipse/EclipseState/Tables/SolventDensityTable.cpp
    src/opm/input/eclipse/EclipseState/Tables/Tabdims.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQASTNode.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQParams.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQParser.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQSet.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQActive.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQAssign.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQDefine.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQEnums.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQToken.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQConfig.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQContext.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQFunction.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQFunctionTable.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQInput.cpp
    src/opm/input/eclipse/Schedule/UDQ/UDQState.cpp
    src/opm/input/eclipse/Schedule/VFPInjTable.cpp
    src/opm/input/eclipse/Schedule/VFPProdTable.cpp
    src/opm/input/eclipse/Parser/ErrorGuard.cpp
    src/opm/input/eclipse/Parser/InputErrorAction.cpp
    src/opm/input/eclipse/Parser/ParseContext.cpp
    src/opm/input/eclipse/Parser/Parser.cpp
    src/opm/input/eclipse/Parser/ParserEnums.cpp
    src/opm/input/eclipse/Parser/ParserItem.cpp
    src/opm/input/eclipse/Parser/ParserKeyword.cpp
    src/opm/input/eclipse/Parser/ParserRecord.cpp
    src/opm/input/eclipse/Parser/raw/RawKeyword.cpp
    src/opm/input/eclipse/Parser/raw/RawRecord.cpp
    src/opm/input/eclipse/Parser/raw/StarToken.cpp
    src/opm/input/eclipse/Units/Dimension.cpp
    src/opm/input/eclipse/Units/UnitSystem.cpp
    src/opm/input/eclipse/Utility/Functional.cpp
    src/opm/material/fluidmatrixinteractions/EclEpsConfig.cpp
    src/opm/material/fluidmatrixinteractions/EclEpsGridProperties.cpp
    src/opm/material/fluidmatrixinteractions/EclHysteresisConfig.cpp
    src/opm/material/fluidmatrixinteractions/EclMaterialLawManager.cpp
    src/opm/material/fluidmatrixinteractions/EclMaterialLawManagerReadEffectiveParams.cpp
    src/opm/material/fluidmatrixinteractions/EclMaterialLawManagerInitParams.cpp
    src/opm/material/fluidmatrixinteractions/EclMaterialLawManagerHystParams.cpp
    src/opm/material/fluidsystems/blackoilpvt/BrineCo2Pvt.cpp
    src/opm/material/fluidsystems/blackoilpvt/Co2GasPvt.cpp
    src/opm/material/fluidsystems/blackoilpvt/BrineH2Pvt.cpp
    src/opm/material/fluidsystems/blackoilpvt/H2GasPvt.cpp
    src/opm/material/fluidsystems/blackoilpvt/ConstantCompressibilityBrinePvt.cpp
    src/opm/material/fluidsystems/blackoilpvt/ConstantCompressibilityOilPvt.cpp
    src/opm/material/fluidsystems/blackoilpvt/ConstantCompressibilityWaterPvt.cpp
    src/opm/material/fluidsystems/blackoilpvt/GasPvtMultiplexer.cpp
    src/opm/material/fluidsystems/blackoilpvt/GasPvtThermal.cpp
    src/opm/material/fluidsystems/blackoilpvt/OilPvtMultiplexer.cpp
    src/opm/material/fluidsystems/blackoilpvt/OilPvtThermal.cpp
    src/opm/material/fluidsystems/blackoilpvt/WaterPvtMultiplexer.cpp
    src/opm/material/fluidsystems/blackoilpvt/WaterPvtThermal.cpp
    src/opm/material/thermal/EclThermalLawManager.cpp
  )

  list( APPEND PYTHON_CXX_SOURCE_FILES
          python/cxx/connection.cpp
          python/cxx/converters.cpp
          python/cxx/deck.cpp
          python/cxx/deck_keyword.cpp
          python/cxx/eclipse_io.cpp
          python/cxx/field_props.cpp
          python/cxx/eclipse_config.cpp
          python/cxx/eclipse_grid.cpp
          python/cxx/eclipse_state.cpp
          python/cxx/emodel_util.cpp
          python/cxx/export.cpp
          python/cxx/group.cpp
          python/cxx/log.cpp
          python/cxx/parsecontext.cpp
          python/cxx/parser.cpp
          python/cxx/schedule.cpp
          python/cxx/summary_state.cpp
          python/cxx/table_manager.cpp
          python/cxx/unit_system.cpp
          python/cxx/well.cpp
          )

  if (OPM_ENABLE_EMBEDDED_PYTHON)
    set_source_files_properties(${PYTHON_CXX_SOURCE_FILES} PROPERTIES COMPILE_FLAGS -Wno-shadow)
    set_source_files_properties(src/opm/input/eclipse/Python/PythonInterp.cpp PROPERTIES COMPILE_FLAGS -Wno-shadow)
    set_source_files_properties(src/opm/input/eclipse/Schedule/Action/PyAction.cpp PROPERTIES COMPILE_FLAGS -Wno-shadow)
    list( APPEND MAIN_SOURCE_FILES
      src/opm/input/eclipse/Python/PythonInterp.cpp
      src/opm/input/eclipse/Python/PyRunModule.cpp
      ${PYTHON_CXX_SOURCE_FILES})
  endif()

  list( APPEND PYTHON_CXX_DEPENDS ${PYTHON_CXX_SOURCE_FILES}
    python/cxx/converters.hpp
    python/cxx/export.hpp)

  if(NOT cjson_FOUND)
    list(APPEND MAIN_SOURCE_FILES external/cjson/cJSON.c)
  endif()
endif()
if(ENABLE_ECL_OUTPUT)
  list( APPEND MAIN_SOURCE_FILES
          src/opm/io/eclipse/EclFile.cpp
          src/opm/io/eclipse/EclOutput.cpp
          src/opm/io/eclipse/EclUtil.cpp
          src/opm/io/eclipse/EGrid.cpp
          src/opm/io/eclipse/EInit.cpp
          src/opm/io/eclipse/ERft.cpp
          src/opm/io/eclipse/ERst.cpp
          src/opm/io/eclipse/ERsm.cpp
          src/opm/io/eclipse/ESmry.cpp
          src/opm/io/eclipse/ExtESmry.cpp
          src/opm/io/eclipse/ESmry_write_rsm.cpp
          src/opm/io/eclipse/OutputStream.cpp
          src/opm/io/eclipse/ExtSmryOutput.cpp
          src/opm/io/eclipse/RestartFileView.cpp
          src/opm/io/eclipse/SummaryNode.cpp
          src/opm/io/eclipse/rst/action.cpp
          src/opm/io/eclipse/rst/aquifer.cpp
          src/opm/io/eclipse/rst/connection.cpp
          src/opm/io/eclipse/rst/group.cpp
          src/opm/io/eclipse/rst/header.cpp
          src/opm/io/eclipse/rst/netbalan.cpp
          src/opm/io/eclipse/rst/network.cpp
          src/opm/io/eclipse/rst/udq.cpp
          src/opm/io/eclipse/rst/segment.cpp
          src/opm/io/eclipse/rst/state.cpp
          src/opm/io/eclipse/rst/well.cpp
          src/opm/output/data/Aquifer.cpp
          src/opm/output/data/InterRegFlowMap.cpp
          src/opm/output/data/Solution.cpp
          src/opm/output/eclipse/ActiveIndexByColumns.cpp
          src/opm/output/eclipse/AggregateActionxData.cpp
          src/opm/output/eclipse/AggregateAquiferData.cpp
          src/opm/output/eclipse/AggregateConnectionData.cpp
          src/opm/output/eclipse/AggregateGroupData.cpp
          src/opm/output/eclipse/AggregateNetworkData.cpp
          src/opm/output/eclipse/AggregateMSWData.cpp
          src/opm/output/eclipse/AggregateUDQData.cpp
          src/opm/output/eclipse/AggregateWellData.cpp
          src/opm/output/eclipse/AggregateWListData.cpp
          src/opm/output/eclipse/CreateActionRSTDims.cpp
          src/opm/output/eclipse/CreateDoubHead.cpp
          src/opm/output/eclipse/CreateInteHead.cpp
          src/opm/output/eclipse/CreateLogiHead.cpp
          src/opm/output/eclipse/CreateUdqDims.cpp
          src/opm/output/eclipse/DoubHEAD.cpp
          src/opm/output/eclipse/EclipseGridInspector.cpp
          src/opm/output/eclipse/EclipseIO.cpp
          src/opm/output/eclipse/InteHEAD.cpp
          src/opm/output/eclipse/LinearisedOutputTable.cpp
          src/opm/output/eclipse/LoadRestart.cpp
          src/opm/output/eclipse/LogiHEAD.cpp
          src/opm/output/eclipse/RestartIO.cpp
          src/opm/output/eclipse/Inplace.cpp
          src/opm/output/eclipse/Summary.cpp
          src/opm/output/eclipse/Tables.cpp
          src/opm/output/eclipse/UDQDims.cpp
          src/opm/output/eclipse/RegionCache.cpp
          src/opm/output/eclipse/RestartValue.cpp
          src/opm/output/eclipse/WriteInit.cpp
          src/opm/output/eclipse/WriteRFT.cpp
          src/opm/output/eclipse/WriteRPT.cpp
          src/opm/output/eclipse/report/WELSPECS.cpp
          src/opm/utility/EModel.cpp
      )
endif()

list (APPEND TEST_SOURCE_FILES
      tests/test_calculateCellVol.cpp
      tests/test_cmp.cpp
      tests/test_ConditionalStorage.cpp
      tests/test_cubic.cpp
      tests/test_EvaluationFormat.cpp
      tests/test_densead.cpp
      tests/test_messagelimiter.cpp
      tests/test_nonuniformtablelinear.cpp
      tests/test_OpmInputError_format.cpp
      tests/test_OpmLog.cpp
      tests/test_param.cpp
      tests/test_RootFinders.cpp
      tests/test_SegmentMatcher.cpp
      tests/test_sparsevector.cpp
      tests/test_uniformtablelinear.cpp
      tests/material/test_2dtables.cpp
      tests/material/test_blackoilfluidstate.cpp
      tests/material/test_components.cpp
      tests/material/test_fluidmatrixinteractions.cpp
      tests/material/test_fluidsystems.cpp
      tests/material/test_spline.cpp
      tests/material/test_tabulation.cpp
)

# tests that need to be linked to dune-common
list(APPEND DUNE_TEST_SOURCE_FILES
      tests/material/test_co2brine_ptflash.cpp
      tests/material/test_immiscibleflash.cpp
      tests/material/test_ncpflash.cpp
      tests/material/test_pengrobinson.cpp
      tests/material/test_threecomponents_ptflash.cpp
)

if(ENABLE_ECL_INPUT)
  list(APPEND TEST_SOURCE_FILES
    tests/rst_test.cpp
    tests/test_ActiveGridCells.cpp
    tests/test_CopyablePtr.cpp
    tests/test_ERsm.cpp
    tests/test_GuideRate.cpp
    tests/test_RestartFileView.cpp
    tests/test_EclIO.cpp
    tests/test_EGrid.cpp
    tests/test_EInit.cpp
    tests/test_ERft.cpp
    tests/test_ERst.cpp
    tests/test_ESmry.cpp
    tests/test_ExtESmry.cpp
    tests/test_PAvgCalculator.cpp
    tests/test_PAvgDynamicSourceData.cpp
    tests/test_Serialization.cpp
    tests/material/test_co2brinepvt.cpp
    tests/material/test_h2brinepvt.cpp
    tests/material/test_eclblackoilfluidsystem.cpp
    tests/material/test_eclblackoilpvt.cpp
    tests/material/test_eclmateriallawmanager.cpp
    tests/parser/ACTIONX.cpp
    tests/parser/ADDREGTests.cpp
    tests/parser/AquiferTests.cpp
    tests/parser/BCConfigTests.cpp
    tests/parser/BoxTests.cpp
    tests/parser/CarfinTests.cpp
    tests/parser/ColumnSchemaTests.cpp
    tests/parser/ConnectionTests.cpp
    tests/parser/COMPSEGUnits.cpp
    tests/parser/CopyRegTests.cpp
    tests/parser/DeckValueTests.cpp
    tests/parser/DeckTests.cpp
    tests/parser/EclipseGridTests.cpp
    tests/parser/EmbeddedPython.cpp
    tests/parser/EqualRegTests.cpp
    tests/parser/EventTests.cpp
    tests/parser/FaceDirTests.cpp
    tests/parser/FaultTests.cpp
    tests/parser/FieldPropsTests.cpp
    tests/parser/FoamTests.cpp
    tests/parser/FunctionalTests.cpp
    tests/parser/GeomodifierTests.cpp
    tests/parser/GroupTests.cpp
    tests/parser/ImportTests.cpp
    tests/parser/InitConfigTest.cpp
    tests/parser/IOConfigTests.cpp
    tests/parser/LgrTests.cpp
    tests/parser/MICPTests.cpp
    tests/parser/MessageLimitTests.cpp
    tests/parser/MultiRegTests.cpp
    tests/parser/MultisegmentWellTests.cpp
    tests/parser/MULTREGTScannerTests.cpp
    tests/parser/NetworkTests.cpp
    tests/parser/OrderedMapTests.cpp
    tests/parser/ParseContextTests.cpp
    tests/parser/ParseContext_EXIT1.cpp
    tests/parser/ParseDATAWithDefault.cpp
    tests/parser/PAvgTests.cpp
    tests/parser/PYACTION.cpp
    tests/parser/RawKeywordTests.cpp
    tests/parser/test_ReportConfig.cpp
    tests/parser/ResinsightTest.cpp
    tests/parser/RestartConfigTests.cpp
    tests/parser/RFTConfigTests.cpp
    tests/parser/RockTableTests.cpp
    tests/parser/RunspecTests.cpp
    tests/parser/SaltTableTests.cpp
    tests/parser/ScheduleSerializeTest.cpp
    tests/parser/ScheduleRestartTests.cpp
    tests/parser/ScheduleTests.cpp
    tests/parser/SectionTests.cpp
    tests/parser/SimpleTableTests.cpp
    tests/parser/SimulationConfigTest.cpp
    tests/parser/StarTokenTests.cpp
    tests/parser/StringTests.cpp
    tests/parser/SummaryConfigTests.cpp
    tests/parser/TabdimsTests.cpp
    tests/parser/TableColumnTests.cpp
    tests/parser/TableContainerTests.cpp
    tests/parser/TableManagerTests.cpp
    tests/parser/TableSchemaTests.cpp
    tests/parser/ThresholdPressureTest.cpp
    tests/parser/TracerTests.cpp
    tests/parser/TransMultTests.cpp
    tests/parser/TuningTests.cpp
    tests/parser/UDQTests.cpp
    tests/parser/UnitTests.cpp
    tests/parser/integration/NNCTests.cpp
    tests/parser/WellSolventTests.cpp
    tests/parser/WellTracerTests.cpp
    tests/parser/WellTests.cpp
    tests/parser/WLIST.cpp
    tests/parser/WriteRestartFileEventsTests.cpp
    tests/parser/WTEST.cpp)
endif()

if(ENABLE_ECL_OUTPUT)
  list (APPEND TEST_SOURCE_FILES
          tests/test_ActiveIndexByColumns.cpp
          tests/test_AggregateActionxData.cpp
          tests/test_AggregateAquiferData.cpp
          tests/test_AggregateWellData.cpp
          tests/test_AggregateGroupData.cpp
          tests/test_AggregateNetworkData.cpp
          tests/test_AggregateWListData.cpp
          tests/test_AggregateMSWData.cpp
          tests/test_AggregateConnectionData.cpp
          tests/test_AggregateUDQData.cpp
          tests/test_ArrayDimChecker.cpp
          tests/test_data_GuideRateValue.cpp
          tests/test_EclipseIO.cpp
          tests/test_DoubHEAD.cpp
          tests/test_InteHEAD.cpp
          tests/test_data_InterRegFlow.cpp
          tests/test_data_InterRegFlowMap.cpp
          tests/test_LinearisedOutputTable.cpp
          tests/test_LogiHEAD.cpp
          tests/test_LGOData.cpp
          tests/test_OutputStream.cpp
          tests/test_regionCache.cpp
          tests/test_PaddedOutputString.cpp
          tests/test_Restart.cpp
          tests/test_RFT.cpp
          tests/test_rst.cpp
          tests/test_rst_netbalan.cpp
          tests/test_Solution.cpp
          tests/test_Inplace.cpp
          tests/test_Summary.cpp
          tests/test_Summary_Group.cpp
          tests/test_Tables.cpp
          tests/test_Wells.cpp
          tests/test_WindowedArray.cpp
          tests/test_restartwellinfo.cpp
      )
endif()

list(APPEND TEST_SOURCE_FILES ${DUNE_TEST_SOURCE_FILES})

list (APPEND TEST_DATA_FILES
      tests/testdata.param
      tests/material/brine_unittest.json
      tests/material/co2_unittest_part1.json
      tests/material/co2_unittest_part2.json
      tests/material/co2_unittest_above_sat.json
      tests/material/co2_unittest_below_sat.json
      tests/material/h2o_unittest.json
      tests/material/h2_unittest.json
)
if(ENABLE_ECL_OUTPUT)
  list (APPEND TEST_DATA_FILES
          tests/GDFILE_NO_ACTNUM.DATA
          tests/EGRID_NO_ACTNUM.FEGRID
          tests/BASE_SIM.DATA
          tests/BASE_SIM_THPRES.DATA
          tests/RESTART_SIM.DATA
          tests/summary_deck.DATA
          tests/group_group.DATA
          tests/testblackoilstate3.DATA
          tests/testrft.DATA
          tests/table_deck.DATA
          tests/summary_deck_non_constant_porosity.DATA
          tests/SUMMARY_EFF_FAC.DATA
          tests/SPE1CASE1.DATA
          tests/SPE1CASE1_RPTONLY.DATA
          tests/SPE1CASE1_SUMTHIN.DATA
          tests/SPE1CASE1.SMSPEC
          tests/SPE1CASE1A.SMSPEC
          tests/SPE1CASE1B.DATA
          tests/SPE1CASE1_WELTRAJ.DATA
          tests/props_spe1case1b.inc
          tests/SPE9_CP_PACKED.DATA
          tests/SOFR_TEST.DATA
          tests/UDQ_BASE.DATA
          tests/UDQ_RESTART.DATA
          tests/UDQ_ACTIONX.X0007
          tests/UDQ_ACTIONX.DATA
          tests/UDQ_ACTIONX_RESTART.DATA
          tests/UDQ_TEST_WCONPROD_IUAD-2.DATA
          tests/5_NETWORK_MODEL5_STDW_NETBAL_PACK.DATA
          tests/9_4C_WINJ_GINJ_UDQ_MSW-UDARATE_TEST_PACK.DATA
          tests/UDQ_ACTIONX_TEST1.DATA
          tests/UDQ_ACTIONX_TEST1_U.DATA
          tests/TEST_AGGREGATE_MSW.DATA
          tests/include_example_pvt.txt
          tests/include_example_summary.txt
          tests/include_sgof.txt
          tests/include_swof.txt
          tests/include_grid_3x5x4.grdecl
          tests/SPE1CASE2.DATA
          tests/SPE1CASE2_RESTART.DATA
          tests/SPE1CASE2_RESTART_SKIPREST.DATA
          tests/SPE1CASE2.X0060
          tests/PYACTION.DATA
          tests/0A4_GRCTRL_LRAT_LRAT_GGR_BASE_MODEL2_MSW_ALL.DATA
          tests/MOD4_TEST_IGRP-DATA.DATA
          tests/2_WLIFT_MODEL5_NOINC.DATA
          tests/TEST_NETWORK_ALL.DATA
          tests/TEST_WLIST.DATA
          tests/act1.py
          tests/MSW.DATA
          tests/MSW_2WELSEGS.DATA
          tests/EXIT_TEST.DATA
          tests/action_syntax_error.py
          tests/action_missing_run.py
          tests/EMBEDDED_PYTHON.DATA
          tests/ACTIONX_M1.DATA
          tests/ACTIONX_M1_MULTIPLE.DATA
          tests/ACTIONX_M1_RESTART.DATA
          tests/ACTIONX_M1.UNRST
          tests/ACTIONX_M1.X0010
          tests/wclose.py
          tests/msim/MSIM_PYACTION.DATA
          tests/msim/MSIM_PYACTION_ACTIONX.DATA
          tests/msim/action1.py
          tests/msim/action2.py
          tests/msim/action3.py
          tests/msim/action_count.py
          tests/VFP_CASE.DATA)
endif()

list (APPEND EXAMPLE_SOURCE_FILES
)
if(ENABLE_ECL_INPUT)
  list (APPEND TEST_DATA_FILES
    tests/ECLFILE.INIT
    tests/ECLFILE.FINIT
    tests/LGR_TESTMOD.EGRID
    tests/LGR_TESTMOD.INIT
    tests/LGR_TESTMOD.UNRST
    tests/LGR_TESTMOD.X0002
    tests/MODEL1_IX.INIT
    tests/MODEL1_IX.SMSPEC
    tests/MODEL1_IX.UNSMRY
    tests/SPE1CASE1.EGRID
    tests/SPE1CASE1.RFT
    tests/SPE1_TESTCASE.UNRST
    tests/SPE1_TESTCASE.FUNRST
    tests/SPE1_TESTCASE.F0025
    tests/SPE1_TESTCASE.X0025
    tests/SPE1CASE1.UNSMRY
    tests/SPE1CASE1A.UNSMRY
    tests/SPE1CASE1_RST60.SMSPEC
    tests/SPE1CASE1_RST60.UNSMRY
    tests/SPE1CASE1_RST60.ESMRY
    tests/MODEL2_RESTART.DATA
    tests/restart/MODEL2.UNRST
    tests/UDQ_WCONPROD.DATA
    tests/UDQ_WCONPROD_GRID.grdecl
    tests/UDQ_WCONPROD_RESTART.DATA
    tests/UDQ_WCONPROD.X0006
    tests/BASE.UNRST
  )
  list (APPEND EXAMPLE_SOURCE_FILES
    examples/opmi.cpp
    examples/opmpack.cpp
    examples/opmhash.cpp
    examples/rst_deck.cpp
    examples/wellgraph.cpp
    examples/make_ext_smry.cpp
    examples/co2brinepvt.cpp
  )
endif()

# programs listed here will not only be compiled, but also marked for
# installation
list (APPEND PROGRAM_SOURCE_FILES
)
if(ENABLE_ECL_INPUT)
  list (APPEND PROGRAM_SOURCE_FILES
    examples/opmi.cpp
    examples/opmpack.cpp
    examples/opmhash.cpp
    examples/rst_deck.cpp
    examples/make_esmry.cpp
    examples/co2brinepvt.cpp
  )
endif()

list( APPEND PUBLIC_HEADER_FILES
      opm/common/ErrorMacros.hpp
      opm/common/Exceptions.hpp
      opm/common/TimingMacros.hpp
      opm/common/OpmLog/CounterLog.hpp
      opm/common/OpmLog/EclipsePRTLog.hpp
      opm/common/OpmLog/LogBackend.hpp
      opm/common/OpmLog/Logger.hpp
      opm/common/OpmLog/LogUtil.hpp
      opm/common/OpmLog/MessageFormatter.hpp
      opm/common/OpmLog/MessageLimiter.hpp
      opm/common/OpmLog/KeywordLocation.hpp
      opm/common/OpmLog/InfoLogger.hpp
      opm/common/OpmLog/OpmLog.hpp
      opm/common/OpmLog/StreamLog.hpp
      opm/common/OpmLog/TimerLog.hpp
      opm/common/utility/ActiveGridCells.hpp
      opm/common/utility/Demangle.hpp
      opm/common/utility/FileSystem.hpp
      opm/common/utility/OpmInputError.hpp
      opm/common/utility/Serializer.hpp
      opm/common/utility/MemPacker.hpp
      opm/common/utility/numeric/cmp.hpp
      opm/common/utility/platform_dependent/disable_warnings.h
      opm/common/utility/platform_dependent/reenable_warnings.h
      opm/common/utility/numeric/blas_lapack.h
      opm/common/utility/numeric/buildUniformMonotoneTable.hpp
      opm/common/utility/numeric/linearInterpolation.hpp
      opm/common/utility/numeric/MonotCubicInterpolator.hpp
      opm/common/utility/numeric/NonuniformTableLinear.hpp
      opm/common/utility/numeric/RootFinders.hpp
      opm/common/utility/numeric/SparseVector.hpp
      opm/common/utility/numeric/UniformTableLinear.hpp
      opm/common/utility/parameters/ParameterGroup.hpp
      opm/common/utility/parameters/ParameterGroup_impl.hpp
      opm/common/utility/parameters/Parameter.hpp
      opm/common/utility/parameters/ParameterMapItem.hpp
      opm/common/utility/parameters/ParameterRequirement.hpp
      opm/common/utility/parameters/ParameterStrings.hpp
      opm/common/utility/parameters/ParameterTools.hpp
      opm/common/utility/numeric/calculateCellVol.hpp
      opm/common/utility/shmatch.hpp
      opm/common/utility/String.hpp
      opm/common/utility/TimeService.hpp
      opm/material/components/Lnapl.hpp
      opm/material/components/N2.hpp
      opm/material/components/H2.hpp
      opm/material/components/Unit.hpp
      opm/material/components/iapws/Common.hpp
      opm/material/components/iapws/Region1.hpp
      opm/material/components/iapws/Region4.hpp
      opm/material/components/iapws/Region2.hpp
      opm/material/components/Dnapl.hpp
      opm/material/components/NullComponent.hpp
      opm/material/components/H2O.hpp
      opm/material/components/TabulatedComponent.hpp
      opm/material/components/Xylene.hpp
      opm/material/components/SimpleH2O.hpp
      opm/material/components/CO2.hpp
      opm/material/components/Mesitylene.hpp
      opm/material/components/SimpleCO2.hpp
      opm/material/components/C10.hpp
      opm/material/components/SimpleHuDuanH2O.hpp
      opm/material/components/Component.hpp
      opm/material/components/Air.hpp
      opm/material/components/C1.hpp
      opm/material/components/Brine.hpp
      opm/material/components/BrineDynamic.hpp
      opm/material/fluidstates/BlackOilFluidState.hpp
      opm/material/fluidstates/NonEquilibriumFluidState.hpp
      opm/material/fluidstates/FluidStateSaturationModules.hpp
      opm/material/fluidstates/FluidStateCompositionModules.hpp
      opm/material/fluidstates/PressureOverlayFluidState.hpp
      opm/material/fluidstates/CompositionalFluidState.hpp
      opm/material/fluidstates/FluidStateEnthalpyModules.hpp
      opm/material/fluidstates/FluidStatePressureModules.hpp
      opm/material/fluidstates/ModularFluidState.hpp
      opm/material/fluidstates/FluidStateTemperatureModules.hpp
      opm/material/fluidstates/SimpleModularFluidState.hpp
      opm/material/fluidstates/FluidStateViscosityModules.hpp
      opm/material/fluidstates/TemperatureOverlayFluidState.hpp
      opm/material/fluidstates/ImmiscibleFluidState.hpp
      opm/material/fluidstates/SaturationOverlayFluidState.hpp
      opm/material/fluidstates/FluidStateFugacityModules.hpp
      opm/material/fluidstates/FluidStateDensityModules.hpp
      opm/material/constraintsolvers/ComputeFromReferencePhase.hpp
      opm/material/constraintsolvers/PTFlash.hpp
      opm/material/constraintsolvers/CompositionFromFugacities.hpp
      opm/material/constraintsolvers/MiscibleMultiPhaseComposition.hpp
      opm/material/constraintsolvers/NcpFlash.hpp
      opm/material/constraintsolvers/ImmiscibleFlash.hpp
      opm/material/IdealGas.hpp
      opm/material/binarycoefficients/H2O_Mesitylene.hpp
      opm/material/binarycoefficients/H2O_Air.hpp
      opm/material/binarycoefficients/H2O_N2.hpp
      opm/material/binarycoefficients/Air_Mesitylene.hpp
      opm/material/binarycoefficients/FullerMethod.hpp
      opm/material/binarycoefficients/H2O_Xylene.hpp
      opm/material/binarycoefficients/H2O_CO2.hpp
      opm/material/binarycoefficients/Air_Xylene.hpp
      opm/material/binarycoefficients/Brine_CO2.hpp
      opm/material/binarycoefficients/Brine_H2.hpp
      opm/material/binarycoefficients/HenryIapws.hpp
      opm/material/Constants.hpp
      opm/material/fluidsystems/NullParameterCache.hpp
      opm/material/fluidsystems/BaseFluidSystem.hpp
      opm/material/fluidsystems/BlackOilDefaultIndexTraits.hpp
      opm/material/fluidsystems/ParameterCacheBase.hpp
      opm/material/fluidsystems/H2ON2LiquidPhaseFluidSystem.hpp
      opm/material/fluidsystems/BrineCO2FluidSystem.hpp
      opm/material/fluidsystems/GasPhase.hpp
      opm/material/fluidsystems/TwoPhaseImmiscibleFluidSystem.hpp
      opm/material/fluidsystems/BlackOilFluidSystem.hpp
      opm/material/fluidsystems/LiquidPhase.hpp
      opm/material/fluidsystems/PTFlashParameterCache.hpp
      opm/material/fluidsystems/Spe5ParameterCache.hpp
      opm/material/fluidsystems/H2OAirMesityleneFluidSystem.hpp
      opm/material/fluidsystems/H2OAirXyleneFluidSystem.hpp
      opm/material/fluidsystems/SinglePhaseFluidSystem.hpp
      opm/material/fluidsystems/Spe5FluidSystem.hpp
      opm/material/fluidsystems/blackoilpvt/SolventPvt.hpp
      opm/material/fluidsystems/blackoilpvt/WetHumidGasPvt.hpp
      opm/material/fluidsystems/blackoilpvt/WaterPvtThermal.hpp
      opm/material/fluidsystems/blackoilpvt/WaterPvtMultiplexer.hpp
      opm/material/fluidsystems/blackoilpvt/BrineCo2Pvt.hpp
      opm/material/fluidsystems/blackoilpvt/BrineH2Pvt.hpp
      opm/material/fluidsystems/blackoilpvt/OilPvtMultiplexer.hpp
      opm/material/fluidsystems/blackoilpvt/GasPvtMultiplexer.hpp
      opm/material/fluidsystems/blackoilpvt/DryHumidGasPvt.hpp
      opm/material/fluidsystems/blackoilpvt/WetGasPvt.hpp
      opm/material/fluidsystems/blackoilpvt/DeadOilPvt.hpp
      opm/material/fluidsystems/blackoilpvt/DryGasPvt.hpp
      opm/material/fluidsystems/blackoilpvt/ConstantCompressibilityWaterPvt.hpp
      opm/material/fluidsystems/blackoilpvt/LiveOilPvt.hpp
      opm/material/fluidsystems/blackoilpvt/OilPvtThermal.hpp
      opm/material/fluidsystems/blackoilpvt/ConstantCompressibilityBrinePvt.hpp
      opm/material/fluidsystems/blackoilpvt/GasPvtThermal.hpp
      opm/material/fluidsystems/blackoilpvt/Co2GasPvt.hpp
      opm/material/fluidsystems/blackoilpvt/H2GasPvt.hpp
      opm/material/fluidsystems/blackoilpvt/ConstantCompressibilityOilPvt.hpp
      opm/material/fluidsystems/H2OAirFluidSystem.hpp
      opm/material/fluidsystems/H2ON2FluidSystem.hpp
      opm/material/fluidsystems/ThreeComponentFluidSystem.hh
      opm/material/fluidmatrixinteractions/EclTwoPhaseMaterial.hpp
      opm/material/fluidmatrixinteractions/SatCurveMultiplexerParams.hpp
      opm/material/fluidmatrixinteractions/EclTwoPhaseMaterialParams.hpp
      opm/material/fluidmatrixinteractions/EclEpsTwoPhaseLawParams.hpp
      opm/material/fluidmatrixinteractions/ParkerLenhardParams.hpp
      opm/material/fluidmatrixinteractions/ThreePhaseParkerVanGenuchtenParams.hpp
      opm/material/fluidmatrixinteractions/RegularizedVanGenuchtenParams.hpp
      opm/material/fluidmatrixinteractions/MaterialTraits.hpp
      opm/material/fluidmatrixinteractions/VanGenuchtenParams.hpp
      opm/material/fluidmatrixinteractions/VanGenuchten.hpp
      opm/material/fluidmatrixinteractions/LinearMaterial.hpp
      opm/material/fluidmatrixinteractions/ParkerLenhard.hpp
      opm/material/fluidmatrixinteractions/SatCurveMultiplexer.hpp
      opm/material/fluidmatrixinteractions/EclEpsGridProperties.hpp
      opm/material/fluidmatrixinteractions/EclHysteresisTwoPhaseLaw.hpp
      opm/material/fluidmatrixinteractions/EclHysteresisConfig.hpp
      opm/material/fluidmatrixinteractions/RegularizedBrooksCoreyParams.hpp
      opm/material/fluidmatrixinteractions/EclMultiplexerMaterialParams.hpp
      opm/material/fluidmatrixinteractions/NullMaterial.hpp
      opm/material/fluidmatrixinteractions/EclEpsScalingPoints.hpp
      opm/material/fluidmatrixinteractions/EclHysteresisTwoPhaseLawParams.hpp
      opm/material/fluidmatrixinteractions/TwoPhaseLETCurvesParams.hpp
      opm/material/fluidmatrixinteractions/EclStone2Material.hpp
      opm/material/fluidmatrixinteractions/NullMaterialParams.hpp
      opm/material/fluidmatrixinteractions/LinearMaterialParams.hpp
      opm/material/fluidmatrixinteractions/EclStone1Material.hpp
      opm/material/fluidmatrixinteractions/EclMultiplexerMaterial.hpp
      opm/material/fluidmatrixinteractions/EclStone1MaterialParams.hpp
      opm/material/fluidmatrixinteractions/EclEpsConfig.hpp
      opm/material/fluidmatrixinteractions/EclStone2MaterialParams.hpp
      opm/material/fluidmatrixinteractions/EffToAbsLawParams.hpp
      opm/material/fluidmatrixinteractions/RegularizedBrooksCorey.hpp
      opm/material/fluidmatrixinteractions/SplineTwoPhaseMaterial.hpp
      opm/material/fluidmatrixinteractions/EffToAbsLaw.hpp
      opm/material/fluidmatrixinteractions/EclDefaultMaterial.hpp
      opm/material/fluidmatrixinteractions/PiecewiseLinearTwoPhaseMaterialParams.hpp
      opm/material/fluidmatrixinteractions/SplineTwoPhaseMaterialParams.hpp
      opm/material/fluidmatrixinteractions/EclEpsTwoPhaseLaw.hpp
      opm/material/fluidmatrixinteractions/TwoPhaseLETCurves.hpp
      opm/material/fluidmatrixinteractions/EclMaterialLawManager.hpp
      opm/material/fluidmatrixinteractions/DirectionalMaterialLawParams.hpp
      opm/material/fluidmatrixinteractions/DirectionalMaterialLawParams.hpp
      opm/material/fluidmatrixinteractions/RegularizedVanGenuchten.hpp
      opm/material/fluidmatrixinteractions/EclDefaultMaterialParams.hpp
      opm/material/fluidmatrixinteractions/ThreePhaseParkerVanGenuchten.hpp
      opm/material/fluidmatrixinteractions/BrooksCoreyParams.hpp
      opm/material/fluidmatrixinteractions/BrooksCorey.hpp
      opm/material/fluidmatrixinteractions/PiecewiseLinearTwoPhaseMaterial.hpp
      opm/material/checkFluidSystem.hpp
      opm/material/viscositymodels/LBC.hpp
      opm/material/viscositymodels/LBCco2rich.hpp
      opm/material/common/Valgrind.hpp
      opm/material/common/EnsureFinalized.hpp
      opm/material/common/quad.hpp
      opm/material/common/Spline.hpp
      opm/material/common/PolynomialUtils.hpp
      opm/material/common/UniformXTabulated2DFunction.hpp
      opm/material/common/MathToolbox.hpp
      opm/material/common/TridiagonalMatrix.hpp
      opm/material/common/ResetLocale.hpp
      opm/material/common/HasMemberGeneratorMacros.hpp
      opm/material/common/UniformTabulated2DFunction.hpp
      opm/material/common/FastSmallVector.hpp
      opm/material/common/ConditionalStorage.hpp
      opm/material/common/Means.hpp
      opm/material/common/IntervalTabulated2DFunction.hpp
      opm/material/common/Tabulated1DFunction.hpp
      opm/material/densead/Evaluation9.hpp
      opm/material/densead/Evaluation8.hpp
      opm/material/densead/Evaluation7.hpp
      opm/material/densead/Evaluation.hpp
      opm/material/densead/Evaluation5.hpp
      opm/material/densead/Evaluation3.hpp
      opm/material/densead/Evaluation4.hpp
      opm/material/densead/Evaluation11.hpp
      opm/material/densead/DynamicEvaluation.hpp
      opm/material/densead/Math.hpp
      opm/material/densead/Evaluation1.hpp
      opm/material/densead/Evaluation12.hpp
      opm/material/densead/Evaluation2.hpp
      opm/material/densead/EvaluationFormat.hpp
      opm/material/densead/EvaluationSpecializations.hpp
      opm/material/densead/Evaluation10.hpp
      opm/material/densead/Evaluation6.hpp
      opm/material/eos/PengRobinson.hpp
      opm/material/eos/PengRobinsonParams.hpp
      opm/material/eos/PengRobinsonParamsMixture.hpp
      opm/material/eos/PengRobinsonMixture.hpp
      opm/material/thermal/ConstantSolidHeatCapLawParams.hpp
      opm/material/thermal/ConstantSolidHeatCapLaw.hpp
      opm/material/thermal/EclHeatcrLaw.hpp
      opm/material/thermal/SomertonThermalConductionLawParams.hpp
      opm/material/thermal/EclThcLawParams.hpp
      opm/material/thermal/EclSpecrockLawParams.hpp
      opm/material/thermal/EclThconrLaw.hpp
      opm/material/thermal/EclThconrLawParams.hpp
      opm/material/thermal/FluidThermalConductionLaw.hpp
      opm/material/thermal/EclThcLaw.hpp
      opm/material/thermal/FluidThermalConductionLawParams.hpp
      opm/material/thermal/EclHeatcrLawParams.hpp
      opm/material/thermal/NullThermalConductionLaw.hpp
      opm/material/thermal/EclSolidEnergyLawMultiplexer.hpp
      opm/material/thermal/EclThermalConductionLawMultiplexerParams.hpp
      opm/material/thermal/EclThermalConductionLawMultiplexer.hpp
      opm/material/thermal/EclSolidEnergyLawMultiplexerParams.hpp
      opm/material/thermal/EclThermalLawManager.hpp
      opm/material/thermal/SomertonThermalConductionLaw.hpp
      opm/material/thermal/EclSpecrockLaw.hpp
      opm/material/thermal/NullSolidEnergyLaw.hpp
)

if(ENABLE_ECL_INPUT)
  list(APPEND PUBLIC_HEADER_FILES
       external/resinsight/CommonCode/cvfStructGrid.h
       external/resinsight/LibCore/cvfArray.h
       external/resinsight/LibCore/cvfArrayWrapperConst.h
       external/resinsight/LibCore/cvfAssert.h
       external/resinsight/LibCore/cvfAtomicCounter.h
       external/resinsight/LibCore/cvfBase.h
       external/resinsight/LibCore/cvfBase64.h
       external/resinsight/LibCore/cvfCharArray.h
       external/resinsight/LibCore/cvfCodeLocation.h
       external/resinsight/LibCore/cvfCollection.h
       external/resinsight/LibCore/cvfColor3.h
       external/resinsight/LibCore/cvfColor4.h
       external/resinsight/LibCore/cvfConfigCore.h
       external/resinsight/LibCore/cvfDebugTimer.h
       external/resinsight/LibCore/cvfFlags.h
       external/resinsight/LibCore/cvfFunctorRange.h
       external/resinsight/LibCore/cvfLibCore.h
       external/resinsight/LibCore/cvfLogDestination.h
       external/resinsight/LibCore/cvfLogger.h
       external/resinsight/LibCore/cvfMath.h
       external/resinsight/LibCore/cvfMatrix3.h
       external/resinsight/LibCore/cvfMatrix4.h
       external/resinsight/LibCore/cvfObject.h
       external/resinsight/LibCore/cvfPlane.h
       external/resinsight/LibCore/cvfPropertySet.h
       external/resinsight/LibCore/cvfQuat.h
       external/resinsight/LibCore/cvfRect.h
       external/resinsight/LibCore/cvfString.h
       external/resinsight/LibCore/cvfSystem.h
       external/resinsight/LibCore/cvfTBBControl.h
       external/resinsight/LibCore/cvfTimer.h
       external/resinsight/LibCore/cvfTrace.h
       external/resinsight/LibCore/cvfValueArray.h
       external/resinsight/LibCore/cvfVector2.h
       external/resinsight/LibCore/cvfVector3.h
       external/resinsight/LibCore/cvfVector4.h
       external/resinsight/LibCore/cvfVersion.h
       external/resinsight/LibGeometry/cvfBoundingBox.h
       external/resinsight/LibGeometry/cvfBoundingBoxTree.h
       external/resinsight/LibGeometry/cvfRay.h
       external/resinsight/ReservoirDataModel/RigCellGeometryTools.h
       #external/resinsight/ReservoirDataModel/RigEclipseCaseData.h
       external/resinsight/ReservoirDataModel/RigHexIntersectionTools.h
       #external/resinsight/ReservoirDataModel/RigMainGrid.h
       external/resinsight/ReservoirDataModel/RigWellLogExtractionTools.h
       external/resinsight/ReservoirDataModel/RigWellLogExtractor.h
       external/resinsight/ReservoirDataModel/RigWellPath.h
       #external/resinsight/ReservoirDataModel/RigWellPathIntersectionTools.h
       external/resinsight/ReservoirDataModel/cvfGeometryTools.h
       external/resinsight/cafHexGridIntersectionTools/cafHexGridIntersectionTools.h
       external/resinsight/cafPdmCore/cafAppEnum.h
       external/resinsight/cafPdmCore/cafAssert.h
       external/resinsight/cafPdmCore/cafSignal.h
       external/resinsight/LibCore/cvfArray.inl
       external/resinsight/LibCore/cvfCollection.inl
       external/resinsight/LibCore/cvfFlags.inl
       external/resinsight/LibCore/cvfMath.inl
       external/resinsight/LibCore/cvfMatrix3.inl
       external/resinsight/LibCore/cvfMatrix4.inl
       external/resinsight/LibCore/cvfObject.inl
       external/resinsight/LibCore/cvfQuat.inl
       external/resinsight/LibCore/cvfRect.inl
       external/resinsight/LibCore/cvfVector2.inl
       external/resinsight/LibCore/cvfVector3.inl
       external/resinsight/LibCore/cvfVector4.inl
       external/resinsight/ReservoirDataModel/cvfGeometryTools.inl
       opm/io/eclipse/SummaryNode.hpp
       opm/json/JsonObject.hpp
       opm/input/eclipse/Utility/Functional.hpp
       opm/input/eclipse/Utility/Typetools.hpp
       opm/input/eclipse/Generator/KeywordGenerator.hpp
       opm/input/eclipse/Generator/KeywordLoader.hpp
       opm/input/eclipse/Units/UnitSystem.hpp
       opm/input/eclipse/Units/Units.hpp
       opm/input/eclipse/Units/Dimension.hpp
       opm/input/eclipse/Parser/ErrorGuard.hpp
       opm/input/eclipse/Parser/ParserItem.hpp
       opm/input/eclipse/Parser/Parser.hpp
       opm/input/eclipse/Parser/ParserRecord.hpp
       opm/input/eclipse/Parser/ParserKeyword.hpp
       opm/input/eclipse/Parser/InputErrorAction.hpp
       opm/input/eclipse/Parser/ParserEnums.hpp
       opm/input/eclipse/Parser/ParseContext.hpp
       opm/input/eclipse/Parser/ParserConst.hpp
       opm/input/eclipse/EclipseState/InitConfig/InitConfig.hpp
       opm/input/eclipse/EclipseState/InitConfig/Equil.hpp
       opm/input/eclipse/EclipseState/InitConfig/FoamConfig.hpp
       opm/input/eclipse/EclipseState/Util/IOrderSet.hpp
       opm/input/eclipse/EclipseState/Util/OrderedMap.hpp
       opm/input/eclipse/EclipseState/SummaryConfig/SummaryConfig.hpp
       opm/input/eclipse/EclipseState/Grid/FieldData.hpp
       opm/input/eclipse/EclipseState/Grid/Keywords.hpp
       opm/input/eclipse/EclipseState/Grid/GridDims.hpp
       opm/input/eclipse/EclipseState/Grid/TranCalculator.hpp
       opm/input/eclipse/EclipseState/Grid/TransMult.hpp
       opm/input/eclipse/EclipseState/Grid/PinchMode.hpp
       opm/input/eclipse/EclipseState/Grid/MULTREGTScanner.hpp
       opm/input/eclipse/EclipseState/Grid/FaultCollection.hpp
       opm/input/eclipse/EclipseState/Grid/SatfuncPropertyInitializers.hpp
       opm/input/eclipse/EclipseState/Grid/Fault.hpp
       opm/input/eclipse/EclipseState/Grid/Box.hpp
       opm/input/eclipse/EclipseState/Grid/Carfin.hpp
       opm/input/eclipse/EclipseState/Grid/LgrCollection.hpp
       opm/input/eclipse/EclipseState/Grid/FieldProps.hpp
       opm/input/eclipse/EclipseState/Grid/FieldPropsManager.hpp
       opm/input/eclipse/EclipseState/Grid/FaultFace.hpp
       opm/input/eclipse/EclipseState/Grid/NNC.hpp
       opm/input/eclipse/EclipseState/Grid/EclipseGrid.hpp
       opm/input/eclipse/EclipseState/Grid/BoxManager.hpp
       opm/input/eclipse/EclipseState/Grid/CarfinManager.hpp
       opm/input/eclipse/EclipseState/Grid/FaceDir.hpp
       opm/input/eclipse/EclipseState/Grid/MapAxes.hpp
       opm/input/eclipse/EclipseState/Grid/MinpvMode.hpp
       opm/input/eclipse/EclipseState/EndpointScaling.hpp
       opm/input/eclipse/EclipseState/TracerConfig.hpp
       opm/input/eclipse/EclipseState/MICPpara.hpp
       opm/input/eclipse/EclipseState/WagHysteresisConfig.hpp
       opm/input/eclipse/EclipseState/Tables/DenT.hpp
       opm/input/eclipse/EclipseState/Tables/JouleThomson.hpp
       opm/input/eclipse/EclipseState/Tables/SimpleTable.hpp
       opm/input/eclipse/EclipseState/Tables/StandardCond.hpp
       opm/input/eclipse/EclipseState/Tables/PolyInjTable.hpp
       opm/input/eclipse/EclipseState/Tables/PdvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/TlpmixpaTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvdgTable.hpp
       opm/input/eclipse/EclipseState/Tables/MsfnTable.hpp
       opm/input/eclipse/EclipseState/Tables/GasvisctTable.hpp
       opm/input/eclipse/EclipseState/Tables/Regdims.hpp
       opm/input/eclipse/EclipseState/Tables/Eqldims.hpp
       opm/input/eclipse/EclipseState/Tables/SpecrockTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvtwsaltTable.hpp
       opm/input/eclipse/EclipseState/Tables/BrineDensityTable.hpp
       opm/input/eclipse/EclipseState/Tables/PermfactTable.hpp
       opm/input/eclipse/EclipseState/Tables/RwgsaltTable.hpp
       opm/input/eclipse/EclipseState/Tables/SaltSolubilityTable.hpp
       opm/input/eclipse/EclipseState/Tables/SaltvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/SaltpvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/SolventDensityTable.hpp
       opm/input/eclipse/EclipseState/Tables/PlydhflfTable.hpp
       opm/input/eclipse/EclipseState/Tables/PlymwinjTable.hpp
       opm/input/eclipse/EclipseState/Tables/PlyshlogTable.hpp
       opm/input/eclipse/EclipseState/Tables/RsvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/SkprwatTable.hpp
       opm/input/eclipse/EclipseState/Tables/SkprpolyTable.hpp
       opm/input/eclipse/EclipseState/Tables/SpecheatTable.hpp
       opm/input/eclipse/EclipseState/Tables/SgcwmisTable.hpp
       opm/input/eclipse/EclipseState/Tables/Sof2Table.hpp
       opm/input/eclipse/EclipseState/Tables/TLMixpar.hpp
       opm/input/eclipse/EclipseState/Tables/Ppcwmax.hpp
       opm/input/eclipse/EclipseState/Tables/TableManager.hpp
       opm/input/eclipse/EclipseState/Tables/SwfnTable.hpp
       opm/input/eclipse/EclipseState/Tables/EnptvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/SwofTable.hpp
       opm/input/eclipse/EclipseState/Tables/FlatTable.hpp
       opm/input/eclipse/EclipseState/Tables/Aqudims.hpp
       opm/input/eclipse/EclipseState/Tables/JFunc.hpp
       opm/input/eclipse/EclipseState/Tables/TableIndex.hpp
       opm/input/eclipse/EclipseState/Tables/PvtgTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvtgwTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvtgwoTable.hpp
       opm/input/eclipse/EclipseState/Tables/Tabdims.hpp
       opm/input/eclipse/EclipseState/Tables/TableSchema.hpp
       opm/input/eclipse/EclipseState/Tables/RocktabTable.hpp
       opm/input/eclipse/EclipseState/Tables/EnkrvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/PlyrockTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvtxTable.hpp
       opm/input/eclipse/EclipseState/Tables/WatvisctTable.hpp
       opm/input/eclipse/EclipseState/Tables/TableEnums.hpp
       opm/input/eclipse/EclipseState/Tables/RvvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/RvwvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/TableContainer.hpp
       opm/input/eclipse/EclipseState/Tables/AqutabTable.hpp
       opm/input/eclipse/EclipseState/Tables/PlyadsTable.hpp
       opm/input/eclipse/EclipseState/Tables/FoamadsTable.hpp
       opm/input/eclipse/EclipseState/Tables/FoammobTable.hpp
       opm/input/eclipse/EclipseState/Tables/PbvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/SorwmisTable.hpp
       opm/input/eclipse/EclipseState/Tables/PlymaxTable.hpp
       opm/input/eclipse/EclipseState/Tables/PlyviscTable.hpp
       opm/input/eclipse/EclipseState/Tables/TableColumn.hpp
       opm/input/eclipse/EclipseState/Tables/SsfnTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvdoTable.hpp
       opm/input/eclipse/EclipseState/Tables/OilvisctTable.hpp
       opm/input/eclipse/EclipseState/Tables/SgfnTable.hpp
       opm/input/eclipse/EclipseState/Tables/WsfTable.hpp
       opm/input/eclipse/EclipseState/Tables/GsfTable.hpp
       opm/input/eclipse/EclipseState/Tables/MiscTable.hpp
       opm/input/eclipse/EclipseState/Tables/SgwfnTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvdsTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvtoTable.hpp
       opm/input/eclipse/EclipseState/Tables/PvtsolTable.hpp
       opm/input/eclipse/EclipseState/Tables/Rock2dTable.hpp
       opm/input/eclipse/EclipseState/Tables/Rock2dtrTable.hpp
       opm/input/eclipse/EclipseState/Tables/RockwnodTable.hpp
       opm/input/eclipse/EclipseState/Tables/OverburdTable.hpp
       opm/input/eclipse/EclipseState/Tables/ColumnSchema.hpp
       opm/input/eclipse/EclipseState/Tables/PmiscTable.hpp
       opm/input/eclipse/EclipseState/Tables/RtempvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/SlgofTable.hpp
       opm/input/eclipse/EclipseState/Tables/ImptvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/ImkrvdTable.hpp
       opm/input/eclipse/EclipseState/Tables/Sof3Table.hpp
       opm/input/eclipse/EclipseState/Tables/SgofTable.hpp
       opm/input/eclipse/EclipseState/Tables/TracerVdTable.hpp
       opm/input/eclipse/EclipseState/EclipseState.hpp
       opm/input/eclipse/EclipseState/EclipseConfig.hpp
       opm/input/eclipse/EclipseState/Aquifer/Aquancon.hpp
       opm/input/eclipse/EclipseState/Aquifer/AquiferConfig.hpp
       opm/input/eclipse/EclipseState/Aquifer/AquiferFlux.hpp
       opm/input/eclipse/EclipseState/Aquifer/AquiferCT.hpp
       opm/input/eclipse/EclipseState/Aquifer/Aquifetp.hpp
       opm/input/eclipse/EclipseState/Aquifer/NumericalAquifer/NumericalAquiferCell.hpp
       opm/input/eclipse/EclipseState/Aquifer/NumericalAquifer/NumericalAquiferConnection.hpp
       opm/input/eclipse/EclipseState/Aquifer/NumericalAquifer/SingleNumericalAquifer.hpp
       opm/input/eclipse/EclipseState/Aquifer/NumericalAquifer/NumericalAquifers.hpp
       opm/input/eclipse/Schedule/Action/ActionAST.hpp
       opm/input/eclipse/Schedule/Action/ActionContext.hpp
       opm/input/eclipse/Schedule/Action/ActionResult.hpp
       opm/input/eclipse/Schedule/Action/ActionValue.hpp
       opm/input/eclipse/Schedule/Action/Actdims.hpp
       opm/input/eclipse/Schedule/Action/Actions.hpp
       opm/input/eclipse/Schedule/Action/ActionX.hpp
       opm/input/eclipse/Schedule/Action/Condition.hpp
       opm/input/eclipse/Schedule/Action/Enums.hpp
       opm/input/eclipse/Schedule/Action/ASTNode.hpp
       opm/input/eclipse/Schedule/Action/PyAction.hpp
       opm/input/eclipse/Schedule/Action/SimulatorUpdate.hpp
       opm/input/eclipse/Schedule/Action/State.hpp
       opm/input/eclipse/Schedule/Action/WGNames.hpp
       opm/input/eclipse/Schedule/ArrayDimChecker.hpp
       opm/input/eclipse/Schedule/BCProp.hpp
       opm/input/eclipse/Schedule/GasLiftOpt.hpp
       opm/input/eclipse/Schedule/Network/Balance.hpp
       opm/input/eclipse/Schedule/Network/Branch.hpp
       opm/input/eclipse/Schedule/Network/ExtNetwork.hpp
       opm/input/eclipse/Schedule/Network/Node.hpp
       opm/input/eclipse/Schedule/VFPInjTable.hpp
       opm/input/eclipse/Schedule/VFPProdTable.hpp
       opm/input/eclipse/Schedule/Well/Connection.hpp
       opm/input/eclipse/Schedule/Well/FilterCake.hpp
       opm/input/eclipse/Schedule/Well/PAvg.hpp
       opm/input/eclipse/Schedule/Well/PAvgCalculator.hpp
       opm/input/eclipse/Schedule/Well/PAvgCalculatorCollection.hpp
       opm/input/eclipse/Schedule/Well/PAvgDynamicSourceData.hpp
       opm/input/eclipse/Schedule/Well/Well.hpp
       opm/input/eclipse/Schedule/Well/WellEnums.hpp
       opm/input/eclipse/Schedule/Well/WellInjectionControls.hpp
       opm/input/eclipse/Schedule/Well/WellProductionControls.hpp
       opm/input/eclipse/Schedule/Well/WList.hpp
       opm/input/eclipse/Schedule/Well/NameOrder.hpp
       opm/input/eclipse/Schedule/Well/WellMatcher.hpp
       opm/input/eclipse/Schedule/Well/WListManager.hpp
       opm/input/eclipse/Schedule/Well/WellEconProductionLimits.hpp
       opm/input/eclipse/Schedule/Well/WellFoamProperties.hpp
       opm/input/eclipse/Schedule/Well/WellBrineProperties.hpp
       opm/input/eclipse/Schedule/Well/WellMICPProperties.hpp
       opm/input/eclipse/Schedule/Well/WellPolymerProperties.hpp
       opm/input/eclipse/Schedule/Well/WellTracerProperties.hpp
       opm/input/eclipse/Schedule/Well/WINJMULT.hpp
       opm/input/eclipse/Schedule/Well/WVFPDP.hpp
       opm/input/eclipse/Schedule/Well/WVFPEXP.hpp
       opm/input/eclipse/Schedule/Well/WellTestConfig.hpp
       opm/input/eclipse/Schedule/Well/WellTestState.hpp
       opm/input/eclipse/Schedule/Well/WellConnections.hpp
       opm/input/eclipse/Schedule/WellTraj/RigEclipseWellLogExtractor.hpp
       opm/input/eclipse/Schedule/SummaryState.hpp
       opm/input/eclipse/Schedule/RFTConfig.hpp
       opm/input/eclipse/Schedule/RPTConfig.hpp
       opm/input/eclipse/Schedule/RSTConfig.hpp
       opm/input/eclipse/Schedule/Schedule.hpp
       opm/input/eclipse/Schedule/ScheduleDeck.hpp
       opm/input/eclipse/Schedule/ScheduleGrid.hpp
       opm/input/eclipse/Schedule/ScheduleState.hpp
       opm/input/eclipse/Schedule/ScheduleTypes.hpp
       opm/input/eclipse/Schedule/Tuning.hpp
       opm/input/eclipse/Schedule/WriteRestartFileEvents.hpp
       opm/input/eclipse/Schedule/Group/GPMaint.hpp
       opm/input/eclipse/Schedule/Group/GTNode.hpp
       opm/input/eclipse/Schedule/Group/Group.hpp
       opm/input/eclipse/Schedule/Group/GuideRate.hpp
       opm/input/eclipse/Schedule/Group/GConSale.hpp
       opm/input/eclipse/Schedule/Group/GConSump.hpp
       opm/input/eclipse/Schedule/Group/GroupEconProductionLimits.hpp
       opm/input/eclipse/Schedule/Group/GuideRateConfig.hpp
       opm/input/eclipse/Schedule/Group/GuideRateModel.hpp
       opm/input/eclipse/Schedule/MessageLimits.hpp
       opm/input/eclipse/Schedule/CompletedCells.hpp
       opm/input/eclipse/Schedule/Events.hpp
       opm/input/eclipse/Schedule/OilVaporizationProperties.hpp
       opm/input/eclipse/Schedule/MSW/icd.hpp
       opm/input/eclipse/Schedule/MSW/Segment.hpp
       opm/input/eclipse/Schedule/MSW/SegmentMatcher.hpp
       opm/input/eclipse/Schedule/MSW/WellSegments.hpp
       opm/input/eclipse/Schedule/MSW/AICD.hpp
       opm/input/eclipse/Schedule/MSW/SICD.hpp
       opm/input/eclipse/EclipseState/SimulationConfig/ThresholdPressure.hpp
       opm/input/eclipse/EclipseState/SimulationConfig/BCConfig.hpp
       opm/input/eclipse/EclipseState/SimulationConfig/RockConfig.hpp
       opm/input/eclipse/EclipseState/SimulationConfig/SimulationConfig.hpp
       opm/input/eclipse/Schedule/MSW/Valve.hpp
       opm/input/eclipse/EclipseState/IOConfig/IOConfig.hpp
       opm/input/eclipse/EclipseState/checkDeck.hpp
       opm/input/eclipse/EclipseState/Phase.hpp
       opm/input/eclipse/EclipseState/Runspec.hpp
       opm/input/eclipse/Schedule/UDQ/UDQAssign.hpp
       opm/input/eclipse/Schedule/UDQ/UDQASTNode.hpp
       opm/input/eclipse/Schedule/UDQ/UDQDefine.hpp
       opm/input/eclipse/Schedule/UDQ/UDQContext.hpp
       opm/input/eclipse/Schedule/UDQ/UDQState.hpp
       opm/input/eclipse/Schedule/UDQ/UDQConfig.hpp
       opm/input/eclipse/Schedule/UDQ/UDQEnums.hpp
       opm/input/eclipse/Schedule/UDQ/UDQParams.hpp
       opm/input/eclipse/Schedule/UDQ/UDQInput.hpp
       opm/input/eclipse/Schedule/UDQ/UDQActive.hpp
       opm/input/eclipse/Schedule/UDQ/UDQSet.hpp
       opm/input/eclipse/Schedule/UDQ/UDQToken.hpp
       opm/input/eclipse/Schedule/UDQ/UDQFunction.hpp
       opm/input/eclipse/Schedule/UDQ/UDQFunctionTable.hpp
       opm/input/eclipse/Deck/DeckItem.hpp
       opm/input/eclipse/Deck/Deck.hpp
       opm/input/eclipse/Deck/DeckView.hpp
       opm/input/eclipse/Deck/FileDeck.hpp
       opm/input/eclipse/Deck/DeckSection.hpp
       opm/input/eclipse/Deck/DeckTree.hpp
       opm/input/eclipse/Deck/DeckOutput.hpp
       opm/input/eclipse/Deck/DeckValue.hpp
       opm/input/eclipse/Deck/DeckKeyword.hpp
       opm/input/eclipse/Deck/DeckRecord.hpp
       opm/input/eclipse/Deck/ImportContainer.hpp
       opm/input/eclipse/Deck/UDAValue.hpp
       opm/input/eclipse/Deck/value_status.hpp
       opm/input/eclipse/Python/Python.hpp)
endif()
if(ENABLE_ECL_OUTPUT)
  list(APPEND PUBLIC_HEADER_FILES
        opm/io/eclipse/EclFile.hpp
        opm/io/eclipse/EclIOdata.hpp
        opm/io/eclipse/EclOutput.hpp
        opm/io/eclipse/EclUtil.hpp
        opm/io/eclipse/EGrid.hpp
        opm/io/eclipse/EInit.hpp
        opm/io/eclipse/ERft.hpp
        opm/io/eclipse/ERst.hpp
        opm/io/eclipse/ERsm.hpp
        opm/io/eclipse/ESmry.hpp
        opm/io/eclipse/ExtESmry.hpp
        opm/io/eclipse/PaddedOutputString.hpp
        opm/io/eclipse/OutputStream.hpp
        opm/io/eclipse/ExtSmryOutput.hpp
        opm/io/eclipse/RestartFileView.hpp
        opm/io/eclipse/SummaryNode.hpp
        opm/io/eclipse/rst/action.hpp
        opm/io/eclipse/rst/aquifer.hpp
        opm/io/eclipse/rst/connection.hpp
        opm/io/eclipse/rst/group.hpp
        opm/io/eclipse/rst/header.hpp
        opm/io/eclipse/rst/netbalan.hpp
        opm/io/eclipse/rst/network.hpp
        opm/io/eclipse/rst/segment.hpp
        opm/io/eclipse/rst/state.hpp
        opm/io/eclipse/rst/udq.hpp
        opm/io/eclipse/rst/well.hpp
        opm/output/data/Aquifer.hpp
        opm/output/data/Cells.hpp
        opm/output/data/GuideRateValue.hpp
        opm/output/data/Groups.hpp
        opm/output/data/InterRegFlow.hpp
        opm/output/data/InterRegFlowMap.hpp
        opm/output/data/Solution.hpp
        opm/output/data/Wells.hpp
        opm/output/eclipse/VectorItems/action.hpp
        opm/output/eclipse/VectorItems/aquifer.hpp
        opm/output/eclipse/VectorItems/connection.hpp
        opm/output/eclipse/VectorItems/group.hpp
        opm/output/eclipse/VectorItems/network.hpp
        opm/output/eclipse/VectorItems/intehead.hpp
        opm/output/eclipse/VectorItems/logihead.hpp
        opm/output/eclipse/VectorItems/msw.hpp
        opm/output/eclipse/VectorItems/tabdims.hpp
        opm/output/eclipse/VectorItems/well.hpp
        opm/output/eclipse/ActiveIndexByColumns.hpp
        opm/output/eclipse/AggregateActionxData.hpp
        opm/output/eclipse/AggregateAquiferData.hpp
        opm/output/eclipse/AggregateGroupData.hpp
        opm/output/eclipse/AggregateNetworkData.hpp
        opm/output/eclipse/AggregateConnectionData.hpp
        opm/output/eclipse/AggregateMSWData.hpp
        opm/output/eclipse/AggregateUDQData.hpp
        opm/output/eclipse/AggregateWellData.hpp
        opm/output/eclipse/AggregateWListData.hpp
        opm/output/eclipse/DoubHEAD.hpp
        opm/output/eclipse/EclipseGridInspector.hpp
        opm/output/eclipse/EclipseIO.hpp
        opm/output/eclipse/EclipseIOUtil.hpp
        opm/output/eclipse/InteHEAD.hpp
        opm/output/eclipse/LinearisedOutputTable.hpp
        opm/output/eclipse/LogiHEAD.hpp
        opm/output/eclipse/RegionCache.hpp
        opm/output/eclipse/RestartIO.hpp
        opm/output/eclipse/RestartValue.hpp
        opm/output/eclipse/Inplace.hpp
        opm/output/eclipse/Summary.hpp
        opm/output/eclipse/Tables.hpp
        opm/output/eclipse/UDQDims.hpp
        opm/output/eclipse/WStat.hpp
        opm/output/eclipse/WindowedArray.hpp
        opm/output/eclipse/WriteInit.hpp
        opm/output/eclipse/WriteRFT.hpp
        opm/output/eclipse/WriteRPT.hpp
        opm/output/eclipse/WriteRestartHelpers.hpp
        opm/output/OutputWriter.hpp
        opm/utility/CopyablePtr.hpp
        opm/utility/EModel.hpp
        )
endif()

if(ENABLE_ECL_INPUT OR ENABLE_ECL_OUTPUT)
  list(APPEND TEST_SOURCE_FILES
      tests/test_SummaryNode.cpp
)
endif()
