//
// SQLiteException.cpp
//
// $Id: //poco/1.3/Data/SQLite/src/SQLiteException.cpp#7 $
//
// Library: Data/SQLite
// Package: SQLite
// Module:  SQLiteException
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/SQLite/SQLiteException.h"
#include <typeinfo>


namespace Poco {
namespace Data {
namespace SQLite {


POCO_IMPLEMENT_EXCEPTION(SQLiteException, Poco::Data::DataException, "Generic SQLite error")
POCO_IMPLEMENT_EXCEPTION(InvalidSQLStatementException, SQLiteException, "SQL Statement invalid or database missing")
POCO_IMPLEMENT_EXCEPTION(InternalDBErrorException, SQLiteException, "SQLite internal error")
POCO_IMPLEMENT_EXCEPTION(DBAccessDeniedException, SQLiteException, "Access permission denied")
POCO_IMPLEMENT_EXCEPTION(ExecutionAbortedException, SQLiteException, "Execution of SQL statement aborted by callback")
POCO_IMPLEMENT_EXCEPTION(LockedException, SQLiteException, "Database is locked")
POCO_IMPLEMENT_EXCEPTION(DBLockedException, LockedException, "Database is locked")
POCO_IMPLEMENT_EXCEPTION(TableLockedException, LockedException, "Table is locked")
POCO_IMPLEMENT_EXCEPTION(NoMemoryException, SQLiteException, "Out of Memory")
POCO_IMPLEMENT_EXCEPTION(ReadOnlyException, SQLiteException, "Attempt to write a readonly database")
POCO_IMPLEMENT_EXCEPTION(InterruptException, SQLiteException, "Database operation interrupted")
POCO_IMPLEMENT_EXCEPTION(IOErrorException, SQLiteException, "I/O Error")
POCO_IMPLEMENT_EXCEPTION(CorruptImageException, SQLiteException, "Corrupt database")
POCO_IMPLEMENT_EXCEPTION(TableNotFoundException, SQLiteException, "Table not found")
POCO_IMPLEMENT_EXCEPTION(DatabaseFullException, SQLiteException, "Database is full")
POCO_IMPLEMENT_EXCEPTION(CantOpenDBFileException, SQLiteException, "Cannot open database file")
POCO_IMPLEMENT_EXCEPTION(LockProtocolException, SQLiteException, "Database lock protocol error")
POCO_IMPLEMENT_EXCEPTION(SchemaDiffersException, SQLiteException, "Database schema changed")
POCO_IMPLEMENT_EXCEPTION(RowTooBigException, SQLiteException, "Row is too big")
POCO_IMPLEMENT_EXCEPTION(ConstraintViolationException, SQLiteException, "Constraint violation abort")
POCO_IMPLEMENT_EXCEPTION(DataTypeMismatchException, SQLiteException, "Data type mismatch")
POCO_IMPLEMENT_EXCEPTION(ParameterCountMismatchException, SQLiteException, "Parameter count mismatch")
POCO_IMPLEMENT_EXCEPTION(InvalidLibraryUseException, SQLiteException, "Library used incorrectly")
POCO_IMPLEMENT_EXCEPTION(OSFeaturesMissingException, SQLiteException, "Required OS feature not supported")
POCO_IMPLEMENT_EXCEPTION(AuthorizationDeniedException, SQLiteException, "Authorization denied")
POCO_IMPLEMENT_EXCEPTION(TransactionException, SQLiteException, "Transaction exception")


} } } // namespace Poco::Data::SQLite
