/*
 * FILE : libxine_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header:$
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initlibxine

#define SWIG_name    "libxine"

#include <xine.h>

#ifdef LIST_OUTPUT
# define output_helper l_output_helper
#else
# define output_helper t_output_helper
#endif

#define STRINGIFY(s) #s
  
void initlibxine (void);

PyObject * Pyxine_Error = 0;

static void
init_statics (void)
{  
  PyObject * pyxine = PyImport_ImportModule("pyxine");

  if (pyxine) {
    Pyxine_Error = PyObject_GetAttrString(pyxine, "Error");
    Py_DECREF(pyxine);
  }
    
  if (!Pyxine_Error) {
    if (PyErr_Occurred())
      PyErr_Print();
    Pyxine_Error = PyExc_Exception; /* punt */
    Py_INCREF(Pyxine_Error);
  }
}  


static PyObject* l_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;
    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyList_Check(target)) {
            o2 = target;
            target = PyList_New(0);
            PyList_Append(target, o2);
	    Py_XDECREF(o2);
        }
        PyList_Append(target,o);
	Py_XDECREF(o);
    }
    return target;
}

static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyTuple_Check(target)) {
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}

  typedef const char * STRING;

struct callback_s 
{
  PyThreadState * state;
  PyObject * callback;
};
typedef struct callback_s callback_t;

static callback_t *
callback_t_new(PyObject * callback)
{
  callback_t * cb;

  if (!PyCallable_Check(callback)) {
    PyErr_SetString(PyExc_TypeError, "Need a callable object for callback");
    return 0;
  }

  if (!(cb = malloc(sizeof(callback_t)))) {
    PyErr_NoMemory();
    return 0;
  }

  /* You must call this from a python thread. */
  PyEval_InitThreads();
  cb->state = PyThreadState_New(PyThreadState_Get()->interp);
  if (!cb->state) {
    free(cb);
    return 0;
  }
  PyThreadState_Clear(cb->state);

  cb->callback = callback;
  Py_INCREF(callback);

  return cb;
}

static void
callback_t_delete(callback_t * cb)
{
  PyThreadState_Delete(cb->state);
  Py_DECREF(cb->callback);
  free(cb);
}

#define BEGIN_CALLBACK_CONTEXT(cb)					\
    {									\
      PyThreadState * saved_state;					\
      PyEval_AcquireLock();						\
      saved_state = PyThreadState_Swap(cb->state);
#define END_CALLBACK_CONTEXT(cb)					\
      /* Report any pending exception */				\
      if (PyErr_Occurred())						\
        PyErr_Print();							\
      PyThreadState_Swap(saved_state);					\
      PyEval_ReleaseLock();						\
    }

void
event_listener_callback (void *user_data, const xine_event_t *event)
{
  callback_t * cb = (callback_t *)user_data;
  PyObject * buffer;
  
  if (!cb)
    return;

  BEGIN_CALLBACK_CONTEXT(cb);

  buffer = PyBuffer_New(sizeof(xine_event_t));
  if (buffer) {
    void * ptr;
    int length;
    PyObject_AsWriteBuffer(buffer, &ptr, &length);
    *(xine_event_t *)ptr = *event;
    PyObject_CallFunction(cb->callback, "O", buffer);
    Py_DECREF(buffer);
  }
  
  END_CALLBACK_CONTEXT(cb);
}

void
xine_cfg_entry_callback (void *user_data, xine_cfg_entry_t *entry)
{
  callback_t * cb = (callback_t *)user_data;
  PyObject * buffer;
  
  if (!cb)
    return;
  
  BEGIN_CALLBACK_CONTEXT(cb);

  buffer = PyBuffer_New(sizeof(xine_cfg_entry_t));
  if (buffer) {
    void * ptr;
    int length;
    PyObject_AsWriteBuffer(buffer, &ptr, &length);
    *(xine_cfg_entry_t *)ptr = *entry;
    PyObject_CallFunction(cb->callback, "O", buffer);
    Py_DECREF(buffer);
  }

  END_CALLBACK_CONTEXT(cb);
}

void
xine_log_callback (void *user_data, int section)
{
  callback_t * cb = (callback_t *)user_data;
  
  if (!cb)
    return;
  
  BEGIN_CALLBACK_CONTEXT(cb);

  PyObject_CallFunction(cb->callback, "i", section);

  END_CALLBACK_CONTEXT(cb);
}

  typedef uint32_t color_t;
  typedef uint8_t  trans_t;

  static const int _XINE_IMGFMT_YV12 = XINE_IMGFMT_YV12;
  static const int _XINE_IMGFMT_YUY2 = XINE_IMGFMT_YUY2;

void
px_make_input_event(int type, uint8_t button, uint16_t x, uint16_t y,
		    xine_input_data_t *OUTPUT)
{
  xine_input_data_t * buf = OUTPUT;
  
  memset(buf, 0, sizeof(*buf));
  buf->event.type = type;
  buf->event.data = buf;
  buf->event.data_length = sizeof(*buf);
  buf->button = button;
  buf->x = x;
  buf->y = y;
}
static PyObject *_wrap_px_make_input_event(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    uint8_t  _arg1;
    uint16_t  _arg2;
    uint16_t  _arg3;
    xine_input_data_t * _arg4;
    PyObject * buffer;

    self = self;
{
  void * ptr;
  int length;
  buffer = PyBuffer_New(sizeof(xine_input_data_t ));
  if (!buffer)
    return NULL;
  PyObject_AsWriteBuffer(buffer, &ptr, &length);
  _arg4 = ptr;
}
    if(!PyArg_ParseTuple(args,"ibhh:px_make_input_event",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    px_make_input_event(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
  _resultobj = output_helper(_resultobj, buffer);
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_version_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":xine_get_version_string")) 
        return NULL;
    _result = (char *)xine_get_version_string();
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_xine_get_version(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int * _arg0;
    int  temp;
    int * _arg1;
    int  temp0;
    int * _arg2;
    int  temp1;

    self = self;
{
  _arg0 = &temp;
}
{
  _arg1 = &temp0;
}
{
  _arg2 = &temp1;
}
    if(!PyArg_ParseTuple(args,":xine_get_version")) 
        return NULL;
    xine_get_version(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg0));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_xine_check_version(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"iii:xine_check_version",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (int )xine_check_version(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":xine_new")) 
        return NULL;
    _result = (xine_t *)xine_new();
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_new));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_init(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_init",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_init. Expected _xine_t_p.");
        return NULL;
        }
    }
    xine_init(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_open_audio_driver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_audio_port_t * _result;
    xine_t * _arg0;
    char * _arg1;
    void * _arg2;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOs:xine_open_audio_driver",&_argc0,&_obj1,&_argc2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_open_audio_driver. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  if (_obj1 == Py_None) {
    _arg1 = 0;
  }
  else {
    if (!(_arg1 = PyString_AsString(_obj1)))
      return NULL;
  }
}
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of xine_open_audio_driver. Expected _void_p.");
        return NULL;
        }
    }
    _result = (xine_audio_port_t *)xine_open_audio_driver(_arg0,_arg1,_arg2);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_open_audio_driver));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_audio_port_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_open_video_driver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_video_port_t * _result;
    xine_t * _arg0;
    char * _arg1;
    int  _arg2;
    void * _arg3;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOis:xine_open_video_driver",&_argc0,&_obj1,&_arg2,&_argc3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_open_video_driver. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  if (_obj1 == Py_None) {
    _arg1 = 0;
  }
  else {
    if (!(_arg1 = PyString_AsString(_obj1)))
      return NULL;
  }
}
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of xine_open_video_driver. Expected _void_p.");
        return NULL;
        }
    }
{
  Py_BEGIN_ALLOW_THREADS
      _result = (xine_video_port_t *)xine_open_video_driver(_arg0,_arg1,_arg2,_arg3);
  
  Py_END_ALLOW_THREADS
}{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_open_video_driver));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_video_port_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_close_audio_driver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    xine_audio_port_t * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_close_audio_driver",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_close_audio_driver. Expected _xine_t_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_audio_port_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_close_audio_driver. Expected _xine_audio_port_t_p.");
        return NULL;
        }
    }
    xine_close_audio_driver(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_close_video_driver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    xine_video_port_t * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_close_video_driver",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_close_video_driver. Expected _xine_t_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_video_port_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_close_video_driver. Expected _xine_video_port_t_p.");
        return NULL;
        }
    }
    xine_close_video_driver(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_exit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_exit",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_exit. Expected _xine_t_p.");
        return NULL;
        }
    }
    xine_exit(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_stream_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_stream_t * _result;
    xine_t * _arg0;
    xine_audio_port_t * _arg1;
    xine_video_port_t * _arg2;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sss:xine_stream_new",&_argc0,&_argc1,&_argc2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_stream_new. Expected _xine_t_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_audio_port_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_stream_new. Expected _xine_audio_port_t_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_xine_video_port_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of xine_stream_new. Expected _xine_video_port_t_p.");
        return NULL;
        }
    }
    _result = (xine_stream_t *)xine_stream_new(_arg0,_arg1,_arg2);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_stream_new));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_stream_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_stream_master_slave(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    xine_stream_t * _arg1;
    int  _arg2;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssi:xine_stream_master_slave",&_argc0,&_argc1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_stream_master_slave. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_stream_master_slave. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_stream_master_slave(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_open(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_open",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_open. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
{
  Py_BEGIN_ALLOW_THREADS
      _result = (int )xine_open(_arg0,_arg1);
  
  Py_END_ALLOW_THREADS
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_play(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    int  _arg1;
    int  _arg2;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sii:xine_play",&_argc0,&_arg1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_play. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
{
  Py_BEGIN_ALLOW_THREADS
      _result = (int )xine_play(_arg0,_arg1,_arg2);
  
  Py_END_ALLOW_THREADS
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_trick_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    int  _arg1;
    int  _arg2;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sii:xine_trick_mode",&_argc0,&_arg1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_trick_mode. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_trick_mode(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_stop(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_stop",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_stop. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
{
  Py_BEGIN_ALLOW_THREADS
      xine_stop(_arg0);
  
  Py_END_ALLOW_THREADS
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_close(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_close",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_close. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
{
  Py_BEGIN_ALLOW_THREADS
      xine_close(_arg0);
  
  Py_END_ALLOW_THREADS
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_eject(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_eject",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_eject. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_eject(_arg0);
{
  if (! _result)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_eject));
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
    return _resultobj;
}

static PyObject *_wrap_xine_dispose(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_dispose",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_dispose. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    xine_dispose(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_set_param(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_stream_t * _arg0;
    int  _arg1;
    int  _arg2;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sii:xine_set_param",&_argc0,&_arg1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_set_param. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    xine_set_param(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_get_param(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_get_param",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_param. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_get_param(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_post_init(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_post_t * _result;
    xine_t * _arg0;
    char * _arg1;
    int  _arg2;
    xine_audio_port_t ** _arg3;
    xine_video_port_t ** _arg4;
    char * _argc0 = 0;
    xine_audio_port_t ** tmp;
    PyObject * _obj3 = 0;
    xine_video_port_t ** tmp0;
    PyObject * _obj4 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssiOO:xine_post_init",&_argc0,&_arg1,&_arg2,&_obj3,&_obj4)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_init. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  static const char * ptrtype = "_" STRINGIFY(xine_audio_port_t ) "_p";
  PyObject * seq = PySequence_Fast(_obj3, "");
  int length, i;
  
  if (! seq) {
    if (!PyErr_ExceptionMatches(PyExc_TypeError))
      return NULL;
    return PyErr_Format(PyExc_TypeError,
			"expected a sequence of %s's for arg %d of %s",
			ptrtype, 4, STRINGIFY(xine_post_init));
  }

  length = PySequence_Fast_GET_SIZE(seq);

  if ( ! (tmp = alloca(sizeof(*tmp) * (length + 1))) ) {
    Py_DECREF(seq);
    return PyErr_NoMemory();
  }

  for (i = 0; i < length; i++) {
    char * str = PyString_AsString(PySequence_Fast_GET_ITEM(seq, i));
    if (!str || SWIG_GetPtr(str, (void **)&tmp[i], (char *)ptrtype)) {
      Py_DECREF(seq);
      return PyErr_Format(PyExc_TypeError,
			  "expected a sequence of %s's for arg %d of %s",
			  ptrtype, 4, STRINGIFY(xine_post_init));
    }
  }
  Py_DECREF(seq);
  tmp[length] = 0;
  _arg3 = tmp;
}
{
  static const char * ptrtype = "_" STRINGIFY(xine_video_port_t ) "_p";
  PyObject * seq = PySequence_Fast(_obj4, "");
  int length, i;
  
  if (! seq) {
    if (!PyErr_ExceptionMatches(PyExc_TypeError))
      return NULL;
    return PyErr_Format(PyExc_TypeError,
			"expected a sequence of %s's for arg %d of %s",
			ptrtype, 5, STRINGIFY(xine_post_init));
  }

  length = PySequence_Fast_GET_SIZE(seq);

  if ( ! (tmp0 = alloca(sizeof(*tmp0) * (length + 1))) ) {
    Py_DECREF(seq);
    return PyErr_NoMemory();
  }

  for (i = 0; i < length; i++) {
    char * str = PyString_AsString(PySequence_Fast_GET_ITEM(seq, i));
    if (!str || SWIG_GetPtr(str, (void **)&tmp0[i], (char *)ptrtype)) {
      Py_DECREF(seq);
      return PyErr_Format(PyExc_TypeError,
			  "expected a sequence of %s's for arg %d of %s",
			  ptrtype, 5, STRINGIFY(xine_post_init));
    }
  }
  Py_DECREF(seq);
  tmp0[length] = 0;
  _arg4 = tmp0;
}
    _result = (xine_post_t *)xine_post_init(_arg0,_arg1,_arg2,_arg3,_arg4);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_post_init));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_post_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_list_post_plugins(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_list_post_plugins",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_list_post_plugins. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_list_post_plugins(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_list_post_plugins_typed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_list_post_plugins_typed",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_list_post_plugins_typed. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_list_post_plugins_typed(_arg0,_arg1);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_post_list_inputs(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_post_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_list_inputs",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_post_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_list_inputs. Expected _xine_post_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_post_list_inputs(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_post_list_outputs(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_post_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_list_outputs",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_post_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_list_outputs. Expected _xine_post_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_post_list_outputs(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_post_input(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_post_in_t * _result;
    xine_post_t * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_input",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_post_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_input. Expected _xine_post_t_p.");
        return NULL;
        }
    }
    _result = (xine_post_in_t *)xine_post_input(_arg0,_arg1);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_post_input));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_post_in_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_post_output(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_post_out_t * _result;
    xine_post_t * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_output",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_post_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_output. Expected _xine_post_t_p.");
        return NULL;
        }
    }
    _result = (xine_post_out_t *)xine_post_output(_arg0,_arg1);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_post_output));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_post_out_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_post_wire(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_post_out_t * _arg0;
    xine_post_in_t * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_wire",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_post_out_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_wire. Expected _xine_post_out_t_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_post_in_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_post_wire. Expected _xine_post_in_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_wire(_arg0,_arg1);
{
  if (! _result)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_post_wire));
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
    return _resultobj;
}

static PyObject *_wrap_xine_post_wire_video_port(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_post_out_t * _arg0;
    xine_video_port_t * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_wire_video_port",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_post_out_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_wire_video_port. Expected _xine_post_out_t_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_video_port_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_post_wire_video_port. Expected _xine_video_port_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_wire_video_port(_arg0,_arg1);
{
  if (! _result)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_post_wire_video_port));
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
    return _resultobj;
}

static PyObject *_wrap_xine_post_wire_audio_port(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_post_out_t * _arg0;
    xine_audio_port_t * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_wire_audio_port",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_post_out_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_wire_audio_port. Expected _xine_post_out_t_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_audio_port_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_post_wire_audio_port. Expected _xine_audio_port_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_wire_audio_port(_arg0,_arg1);
{
  if (! _result)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_post_wire_audio_port));
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_video_source(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_post_out_t * _result;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_video_source",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_video_source. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (xine_post_out_t *)xine_get_video_source(_arg0);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_get_video_source));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_post_out_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_audio_source(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_post_out_t * _result;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_audio_source",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_audio_source. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (xine_post_out_t *)xine_get_audio_source(_arg0);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_get_audio_source));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_post_out_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_post_dispose(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    xine_post_t * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_dispose",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_dispose. Expected _xine_t_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_post_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_post_dispose. Expected _xine_post_t_p.");
        return NULL;
        }
    }
    xine_post_dispose(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_get_log_section_count(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_log_section_count",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_log_section_count. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_get_log_section_count(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_get_log_names(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_log_names",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_log_names. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_get_log_names(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_log(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    int  _arg1;
    char * _arg2;
    char * _arg3;
    char * _argc0 = 0;

    self = self;
{ _arg2 = "%s\n"; }
    if(!PyArg_ParseTuple(args,"sis:xine_log",&_argc0,&_arg1,&_arg3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_log. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  Py_BEGIN_ALLOW_THREADS
      xine_log(_arg0,_arg1,_arg2,_arg3);
  
  Py_END_ALLOW_THREADS
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_get_log(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_get_log",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_log. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_get_log(_arg0,_arg1);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_register_log_cb(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    xine_log_cb_t  _arg1;
    void * _arg2;
    char * _argc0 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
  _arg1 = xine_log_callback;
}
{
  _arg2 = 0;
}
    if(!PyArg_ParseTuple(args,"sO:xine_register_log_cb",&_argc0,&_obj2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_register_log_cb. Expected _xine_t_p.");
        return NULL;
        }
    }
    if (_obj2)
{
  /* FIXME: memory leak: callback_t is never freed */
  _arg2 = callback_t_new(_obj2);
  if (!_arg2)
    return NULL;
}
    xine_register_log_cb(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_get_error(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_error",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_error. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_get_error(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_get_status(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_status",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_status. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_get_status(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_get_audio_lang(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    int  _arg1;
    char * _arg2;
    char  temp[64];
    char * _argc0 = 0;

    self = self;
{
  _arg2 = temp;
}
    if(!PyArg_ParseTuple(args,"si:xine_get_audio_lang",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_audio_lang. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_get_audio_lang(_arg0,_arg1,_arg2);
{
  if (! _result)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_get_audio_lang));
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
{
  _resultobj = output_helper(_resultobj, PyString_FromString(_arg2));
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_spu_lang(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    int  _arg1;
    char * _arg2;
    char  temp[64];
    char * _argc0 = 0;

    self = self;
{
  _arg2 = temp;
}
    if(!PyArg_ParseTuple(args,"si:xine_get_spu_lang",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_spu_lang. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_get_spu_lang(_arg0,_arg1,_arg2);
{
  if (! _result)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_get_spu_lang));
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
{
  _resultobj = output_helper(_resultobj, PyString_FromString(_arg2));
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_pos_length(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    int * _arg1;
    int  temp;
    int * _arg2;
    int  temp0;
    int * _arg3;
    int  temp1;
    char * _argc0 = 0;

    self = self;
{
  _arg1 = &temp;
}
{
  _arg2 = &temp0;
}
{
  _arg3 = &temp1;
}
    if(!PyArg_ParseTuple(args,"s:xine_get_pos_length",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_pos_length. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_get_pos_length(_arg0,_arg1,_arg2,_arg3);
{
  if (! _result)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_get_pos_length));
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg3));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_stream_info(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    uint32_t  _result;
    xine_stream_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_get_stream_info",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_stream_info. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (uint32_t )xine_get_stream_info(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_get_meta_info(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    xine_stream_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_get_meta_info",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_meta_info. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (char *)xine_get_meta_info(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_xine_get_browsable_input_plugin_ids(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_browsable_input_plugin_ids",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_browsable_input_plugin_ids. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_get_browsable_input_plugin_ids(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_browse_mrls(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_mrl_t ** _result;
    xine_t * _arg0;
    char * _arg1;
    char * _arg2;
    int * _arg3;
    char * _argc0 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssss:xine_get_browse_mrls",&_argc0,&_arg1,&_arg2,&_argc3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_browse_mrls. Expected _xine_t_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of xine_get_browse_mrls. Expected _int_p.");
        return NULL;
        }
    }
    _result = (xine_mrl_t **)xine_get_browse_mrls(_arg0,_arg1,_arg2,_arg3);
{
  size_t i, len = 0;

  while (_result[len])
    len++;
  
  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    xine_mrl_t * item = _result[i];
    PyObject * val = Py_BuildValue("{s:s,s:s,s:s,s:l,s:l}",
				   "origin",	item->origin,
				   "mrl",	item->mrl,
				   "link",	item->link,
				   "type",	(long)item->type,
				   "off_t",	(long)item->size);
    if (!val)
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, val);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_autoplay_input_plugin_ids(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_autoplay_input_plugin_ids",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_autoplay_input_plugin_ids. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_get_autoplay_input_plugin_ids(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_autoplay_mrls(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    char * _arg1;
    int * _arg2;
    char * _argc0 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sss:xine_get_autoplay_mrls",&_argc0,&_arg1,&_argc2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_autoplay_mrls. Expected _xine_t_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of xine_get_autoplay_mrls. Expected _int_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_get_autoplay_mrls(_arg0,_arg1,_arg2);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_file_extensions(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_file_extensions",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_file_extensions. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (char *)xine_get_file_extensions(_arg0);
{
  if (_result) {
    _resultobj = PyString_FromString(_result);
    free(_result);
    if (!_resultobj)
      return NULL;
  }
  else {
    Py_INCREF(Py_None);
    _resultobj = Py_None;
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_mime_types(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_get_mime_types",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_mime_types. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (char *)xine_get_mime_types(_arg0);
{
  if (_result) {
    _resultobj = PyString_FromString(_result);
    free(_result);
    if (!_resultobj)
      return NULL;
  }
  else {
    Py_INCREF(Py_None);
    _resultobj = Py_None;
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_demux_for_mime_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    xine_t * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_get_demux_for_mime_type",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_demux_for_mime_type. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (char *)xine_get_demux_for_mime_type(_arg0,_arg1);
{
  if (_result) {
    _resultobj = PyString_FromString(_result);
    free(_result);
    if (!_resultobj)
      return NULL;
  }
  else {
    Py_INCREF(Py_None);
    _resultobj = Py_None;
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_get_input_plugin_description(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    xine_t * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_get_input_plugin_description",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_get_input_plugin_description. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (char *)xine_get_input_plugin_description(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_xine_list_audio_output_plugins(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_list_audio_output_plugins",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_list_audio_output_plugins. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_list_audio_output_plugins(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_list_video_output_plugins(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING * _result;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_list_video_output_plugins",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_list_video_output_plugins. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (STRING *)xine_list_video_output_plugins(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_gui_send_vo_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_stream_t * _arg0;
    int  _arg1;
    void * _arg2;
    char * _argc0 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sis:xine_gui_send_vo_data",&_argc0,&_arg1,&_argc2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_gui_send_vo_data. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of xine_gui_send_vo_data. Expected _void_p.");
        return NULL;
        }
    }
    _result = (int )xine_gui_send_vo_data(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_config_register_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    xine_t * _arg0;
    char * _arg1;
    char * _arg2;
    char * _arg3;
    char * _arg4;
    int  _arg5;
    xine_config_cb_t  _arg6;
    void * _arg7;
    char * _argc0 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;
    PyObject * _obj7 = 0;

    self = self;
{
  _arg6 = xine_cfg_entry_callback;
}
{
  _arg7 = 0;
}
    if(!PyArg_ParseTuple(args,"ssOOOiO:xine_config_register_string",&_argc0,&_arg1,&_obj2,&_obj3,&_obj4,&_arg5,&_obj7)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_register_string. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  char * str = PyString_AsString(_obj2);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			3, STRINGIFY(xine_config_register_string));
  }
  _arg2 = strdup(str);
  if (!_arg2) {
    return PyErr_NoMemory();
  }
}
{
  char * str = PyString_AsString(_obj3);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			4, STRINGIFY(xine_config_register_string));
  }
  _arg3 = strdup(str);
  if (!_arg3) {
    return PyErr_NoMemory();
  }
}
{
  char * str = PyString_AsString(_obj4);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			5, STRINGIFY(xine_config_register_string));
  }
  _arg4 = strdup(str);
  if (!_arg4) {
    return PyErr_NoMemory();
  }
}
    if (_obj7)
{
  if (_obj7 != Py_None) {
    /* FIXME: memory leak: callback_t is never freed */
    _arg7 = callback_t_new(_obj7);
    if (!_arg7)
      return NULL;
  }
}
    _result = (char *)xine_config_register_string(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_xine_config_register_range(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_t * _arg0;
    char * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    char * _arg5;
    char * _arg6;
    int  _arg7;
    xine_config_cb_t  _arg8;
    void * _arg9;
    char * _argc0 = 0;
    PyObject * _obj5 = 0;
    PyObject * _obj6 = 0;
    PyObject * _obj9 = 0;

    self = self;
{
  _arg8 = xine_cfg_entry_callback;
}
{
  _arg9 = 0;
}
    if(!PyArg_ParseTuple(args,"ssiiiOOiO:xine_config_register_range",&_argc0,&_arg1,&_arg2,&_arg3,&_arg4,&_obj5,&_obj6,&_arg7,&_obj9)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_register_range. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  char * str = PyString_AsString(_obj5);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			6, STRINGIFY(xine_config_register_range));
  }
  _arg5 = strdup(str);
  if (!_arg5) {
    return PyErr_NoMemory();
  }
}
{
  char * str = PyString_AsString(_obj6);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			7, STRINGIFY(xine_config_register_range));
  }
  _arg6 = strdup(str);
  if (!_arg6) {
    return PyErr_NoMemory();
  }
}
    if (_obj9)
{
  if (_obj9 != Py_None) {
    /* FIXME: memory leak: callback_t is never freed */
    _arg9 = callback_t_new(_obj9);
    if (!_arg9)
      return NULL;
  }
}
    _result = (int )xine_config_register_range(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_config_register_enum(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_t * _arg0;
    char * _arg1;
    int  _arg2;
    char ** _arg3;
    char * _arg4;
    char * _arg5;
    int  _arg6;
    xine_config_cb_t  _arg7;
    void * _arg8;
    char * _argc0 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;
    PyObject * _obj5 = 0;
    PyObject * _obj8 = 0;

    self = self;
{
  _arg7 = xine_cfg_entry_callback;
}
{
  _arg8 = 0;
}
    if(!PyArg_ParseTuple(args,"ssiOOOiO:xine_config_register_enum",&_argc0,&_arg1,&_arg2,&_obj3,&_obj4,&_obj5,&_arg6,&_obj8)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_register_enum. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  int i, length;
  PyObject * seq = PySequence_Fast(_obj3, "");

  
  if (!seq) {
    return PyErr_Format(PyExc_TypeError,
			"expected sequence of strings for arg %d of %s",
			4, STRINGIFY(xine_config_register_enum));
  }

  length = PySequence_Fast_GET_SIZE(seq);
  _arg3 = malloc((length + 1) * sizeof(*_arg3));
  if (!_arg3) {
    Py_DECREF(seq);
    return PyErr_NoMemory();
  }
  
  for (i = 0; i < length; i++) {
    char * str = PyString_AsString(PySequence_Fast_GET_ITEM(seq, i));
    if (!str) {
      Py_DECREF(seq);
      return PyErr_Format(PyExc_TypeError,
			  "expected sequence of strings for arg %d of %s",
			  4, STRINGIFY(xine_config_register_enum));
    }
    _arg3[i] = strdup(str);
    if (!_arg3[i]) {
      Py_DECREF(seq);
      return PyErr_NoMemory();
    }
  }
  _arg3[length] = 0;
  Py_DECREF(seq);
}
{
  char * str = PyString_AsString(_obj4);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			5, STRINGIFY(xine_config_register_enum));
  }
  _arg4 = strdup(str);
  if (!_arg4) {
    return PyErr_NoMemory();
  }
}
{
  char * str = PyString_AsString(_obj5);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			6, STRINGIFY(xine_config_register_enum));
  }
  _arg5 = strdup(str);
  if (!_arg5) {
    return PyErr_NoMemory();
  }
}
    if (_obj8)
{
  if (_obj8 != Py_None) {
    /* FIXME: memory leak: callback_t is never freed */
    _arg8 = callback_t_new(_obj8);
    if (!_arg8)
      return NULL;
  }
}
    _result = (int )xine_config_register_enum(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_config_register_num(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_t * _arg0;
    char * _arg1;
    int  _arg2;
    char * _arg3;
    char * _arg4;
    int  _arg5;
    xine_config_cb_t  _arg6;
    void * _arg7;
    char * _argc0 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;
    PyObject * _obj7 = 0;

    self = self;
{
  _arg6 = xine_cfg_entry_callback;
}
{
  _arg7 = 0;
}
    if(!PyArg_ParseTuple(args,"ssiOOiO:xine_config_register_num",&_argc0,&_arg1,&_arg2,&_obj3,&_obj4,&_arg5,&_obj7)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_register_num. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  char * str = PyString_AsString(_obj3);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			4, STRINGIFY(xine_config_register_num));
  }
  _arg3 = strdup(str);
  if (!_arg3) {
    return PyErr_NoMemory();
  }
}
{
  char * str = PyString_AsString(_obj4);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			5, STRINGIFY(xine_config_register_num));
  }
  _arg4 = strdup(str);
  if (!_arg4) {
    return PyErr_NoMemory();
  }
}
    if (_obj7)
{
  if (_obj7 != Py_None) {
    /* FIXME: memory leak: callback_t is never freed */
    _arg7 = callback_t_new(_obj7);
    if (!_arg7)
      return NULL;
  }
}
    _result = (int )xine_config_register_num(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_config_register_bool(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_t * _arg0;
    char * _arg1;
    int  _arg2;
    char * _arg3;
    char * _arg4;
    int  _arg5;
    xine_config_cb_t  _arg6;
    void * _arg7;
    char * _argc0 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;
    PyObject * _obj7 = 0;

    self = self;
{
  _arg6 = xine_cfg_entry_callback;
}
{
  _arg7 = 0;
}
    if(!PyArg_ParseTuple(args,"ssiOOiO:xine_config_register_bool",&_argc0,&_arg1,&_arg2,&_obj3,&_obj4,&_arg5,&_obj7)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_register_bool. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  char * str = PyString_AsString(_obj3);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			4, STRINGIFY(xine_config_register_bool));
  }
  _arg3 = strdup(str);
  if (!_arg3) {
    return PyErr_NoMemory();
  }
}
{
  char * str = PyString_AsString(_obj4);
  if (!str) {
    return PyErr_Format(PyExc_TypeError,
			"expected string for arg %d of %s",
			5, STRINGIFY(xine_config_register_bool));
  }
  _arg4 = strdup(str);
  if (!_arg4) {
    return PyErr_NoMemory();
  }
}
    if (_obj7)
{
  if (_obj7 != Py_None) {
    /* FIXME: memory leak: callback_t is never freed */
    _arg7 = callback_t_new(_obj7);
    if (!_arg7)
      return NULL;
  }
}
    _result = (int )xine_config_register_bool(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_xine_config_get_first_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_t * _arg0;
    xine_cfg_entry_t * _arg1;
    PyObject * buffer;
    char * _argc0 = 0;

    self = self;
{
  void * ptr;
  int length;
  buffer = PyBuffer_New(sizeof(xine_cfg_entry_t ));
  if (!buffer)
    return NULL;
  PyObject_AsWriteBuffer(buffer, &ptr, &length);
  _arg1 = ptr;
}
    if(!PyArg_ParseTuple(args,"s:xine_config_get_first_entry",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_get_first_entry. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_config_get_first_entry(_arg0,_arg1);
{
  if (! _result) {
    PyErr_SetNone(PyExc_StopIteration);
    return NULL;
  }
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
{
  _resultobj = output_helper(_resultobj, buffer);
}
    return _resultobj;
}

static PyObject *_wrap_xine_config_get_next_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_t * _arg0;
    xine_cfg_entry_t * _arg1;
    PyObject * buffer;
    char * _argc0 = 0;

    self = self;
{
  void * ptr;
  int length;
  buffer = PyBuffer_New(sizeof(xine_cfg_entry_t ));
  if (!buffer)
    return NULL;
  PyObject_AsWriteBuffer(buffer, &ptr, &length);
  _arg1 = ptr;
}
    if(!PyArg_ParseTuple(args,"s:xine_config_get_next_entry",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_get_next_entry. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_config_get_next_entry(_arg0,_arg1);
{
  if (! _result) {
    PyErr_SetNone(PyExc_StopIteration);
    return NULL;
  }
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
{
  _resultobj = output_helper(_resultobj, buffer);
}
    return _resultobj;
}

static PyObject *_wrap_xine_config_lookup_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_t * _arg0;
    char * _arg1;
    xine_cfg_entry_t * _arg2;
    PyObject * buffer;
    char * _argc0 = 0;

    self = self;
{
  void * ptr;
  int length;
  buffer = PyBuffer_New(sizeof(xine_cfg_entry_t ));
  if (!buffer)
    return NULL;
  PyObject_AsWriteBuffer(buffer, &ptr, &length);
  _arg2 = ptr;
}
    if(!PyArg_ParseTuple(args,"ss:xine_config_lookup_entry",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_lookup_entry. Expected _xine_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_config_lookup_entry(_arg0,_arg1,_arg2);
{
  if (! _result) {
    PyErr_SetNone(PyExc_KeyError);
    return NULL;
  }
  Py_INCREF(Py_None);
  _resultobj = Py_None;
}
{
  _resultobj = output_helper(_resultobj, buffer);
}
    return _resultobj;
}

static PyObject *_wrap_xine_config_update_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    xine_cfg_entry_t * _arg1;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sO:xine_config_update_entry",&_argc0,&_obj1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_update_entry. Expected _xine_t_p.");
        return NULL;
        }
    }
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj1, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_cfg_entry_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_cfg_entry_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_cfg_entry_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			2, STRINGIFY(xine_config_update_entry), STRINGIFY(xine_cfg_entry_t ));
  _arg1 = ptr;
}
{
  Py_BEGIN_ALLOW_THREADS
      xine_config_update_entry(_arg0,_arg1);
  
  Py_END_ALLOW_THREADS
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_config_load(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_config_load",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_load. Expected _xine_t_p.");
        return NULL;
        }
    }
    xine_config_load(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_config_save(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_config_save",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_save. Expected _xine_t_p.");
        return NULL;
        }
    }
    xine_config_save(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_config_reset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_config_reset",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_config_reset. Expected _xine_t_p.");
        return NULL;
        }
    }
    xine_config_reset(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_event_new_queue(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_event_queue_t * _result;
    xine_stream_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_event_new_queue",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_event_new_queue. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (xine_event_queue_t *)xine_event_new_queue(_arg0);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_event_new_queue));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_event_queue_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_event_dispose_queue(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_event_queue_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_event_dispose_queue",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_event_queue_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_event_dispose_queue. Expected _xine_event_queue_t_p.");
        return NULL;
        }
    }
    xine_event_dispose_queue(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_event_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_event_t * _result;
    xine_event_queue_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_event_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_event_queue_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_event_get. Expected _xine_event_queue_t_p.");
        return NULL;
        }
    }
    _result = (xine_event_t *)xine_event_get(_arg0);
{
  if (_result) {
    _resultobj = PyBuffer_FromReadWriteMemory(_result, sizeof(xine_event_t ));
    if (!_resultobj)
      return NULL;
  }
  else {
    Py_INCREF(Py_None);
    _resultobj = Py_None;
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_event_wait(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_event_t * _result;
    xine_event_queue_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_event_wait",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_event_queue_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_event_wait. Expected _xine_event_queue_t_p.");
        return NULL;
        }
    }
{
  Py_BEGIN_ALLOW_THREADS
      _result = (xine_event_t *)xine_event_wait(_arg0);
  
  Py_END_ALLOW_THREADS
}{
  if (_result) {
    _resultobj = PyBuffer_FromReadWriteMemory(_result, sizeof(xine_event_t ));
    if (!_resultobj)
      return NULL;
  }
  else {
    Py_INCREF(Py_None);
    _resultobj = Py_None;
  }
}
    return _resultobj;
}

static PyObject *_wrap_xine_event_free(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_event_t * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_event_free",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_free), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    xine_event_free(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_event_create_listener_thread(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_event_queue_t * _arg0;
    xine_event_listener_cb_t  _arg1;
    void * _arg2;
    char * _argc0 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
  _arg1 = event_listener_callback;
}
{
  _arg2 = 0;
}
    if(!PyArg_ParseTuple(args,"sO:xine_event_create_listener_thread",&_argc0,&_obj2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_event_queue_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_event_create_listener_thread. Expected _xine_event_queue_t_p.");
        return NULL;
        }
    }
    if (_obj2)
{
  /* FIXME: memory leak: callback_t is never freed */
  _arg2 = callback_t_new(_obj2);
  if (!_arg2)
    return NULL;
}
    xine_event_create_listener_thread(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_event_send(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_stream_t * _arg0;
    xine_event_t * _arg1;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sO:xine_event_send",&_argc0,&_obj1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_event_send. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj1, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			2, STRINGIFY(xine_event_send), STRINGIFY(xine_event_t ));
  _arg1 = ptr;
}
    xine_event_send(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _result;
    xine_stream_t * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"siiii:xine_osd_new",&_argc0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_new. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (xine_osd_t *)xine_osd_new(_arg0,_arg1,_arg2,_arg3,_arg4);
{
  char ptmp[128];
  if (_result == NULL)
    return PyErr_Format(Pyxine_Error, "%s failed", STRINGIFY(xine_osd_new));
  SWIG_MakePtr(ptmp, (char *)_result, STRINGIFY(_xine_osd_t_p));
  _resultobj = PyString_FromString(ptmp);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static PyObject *_wrap_xine_osd_draw_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"siii:xine_osd_draw_point",&_argc0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_draw_point. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_draw_point(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_draw_line(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"siiiii:xine_osd_draw_line",&_argc0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_draw_line. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_draw_line(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_draw_rect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"siiiiii:xine_osd_draw_rect",&_argc0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_draw_rect. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_draw_rect(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_draw_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    int  _arg1;
    int  _arg2;
    char * _arg3;
    int  _arg4;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"siisi:xine_osd_draw_text",&_argc0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_draw_text. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_draw_text(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_get_text_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    char * _arg1;
    int * _arg2;
    int  temp;
    int * _arg3;
    int  temp0;
    char * _argc0 = 0;

    self = self;
{
  _arg2 = &temp;
}
{
  _arg3 = &temp0;
}
    if(!PyArg_ParseTuple(args,"ss:xine_osd_get_text_size",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_get_text_size. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_get_text_size(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg3));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_xine_osd_set_font(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    char * _arg1;
    int  _arg2;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssi:xine_osd_set_font",&_argc0,&_arg1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_set_font. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_set_font(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_set_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    int  _arg1;
    int  _arg2;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sii:xine_osd_set_position",&_argc0,&_arg1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_set_position. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_set_position(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_show(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    int64_t  _arg1;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sO:xine_osd_show",&_argc0,&_obj1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_show. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
{
  PyObject * aslong = PyNumber_Long(_obj1);
  if (!aslong)
    return NULL;
  _arg1 = PyLong_AsLongLong(aslong);
  Py_DECREF(aslong);
  if (PyErr_Occurred())
    return NULL;
}
    xine_osd_show(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_hide(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    int64_t  _arg1;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sO:xine_osd_hide",&_argc0,&_obj1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_hide. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
{
  PyObject * aslong = PyNumber_Long(_obj1);
  if (!aslong)
    return NULL;
  _arg1 = PyLong_AsLongLong(aslong);
  Py_DECREF(aslong);
  if (PyErr_Occurred())
    return NULL;
}
    xine_osd_hide(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_osd_clear",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_clear. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_clear(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_free(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_osd_free",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_free. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_free(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_set_palette(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    color_t * _arg1;
    trans_t * _arg2;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
  if (!(_arg1 = alloca(256 * sizeof(*_arg1))))
    return PyErr_NoMemory();
}
{
  if (!(_arg2 = alloca(256 * sizeof(*_arg2))))
    return PyErr_NoMemory();
}
    if(!PyArg_ParseTuple(args,"sOO:xine_osd_set_palette",&_argc0,&_obj1,&_obj2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_set_palette. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
{
  int i;
  PyObject * seq = PySequence_Fast(_obj1, "");

  if (!seq || PySequence_Fast_GET_SIZE(seq) != 256) {
    if (seq) {
      Py_DECREF(seq);
    }
    return PyErr_Format(PyExc_ValueError,
			"expected sequence of length 256 for arg %d of %s",
			2, STRINGIFY(xine_osd_set_palette));
  }

  
  for (i = 0; i < 256; i++) {
    long val = PyInt_AsLong(PySequence_Fast_GET_ITEM(seq, i));
    if (val == -1) {
      Py_DECREF(seq);
      return PyErr_Format(PyExc_ValueError,
			  "expected sequence of length 256 for arg %d of %s",
			  2, STRINGIFY(xine_osd_set_palette));
    }
    _arg1[i] = val;
  }
  Py_DECREF(seq);
}
{
  int i;
  PyObject * seq = PySequence_Fast(_obj2, "");

  if (!seq || PySequence_Fast_GET_SIZE(seq) != 256) {
    if (seq) {
      Py_DECREF(seq);
    }
    return PyErr_Format(PyExc_ValueError,
			"expected sequence of length 256 for arg %d of %s",
			3, STRINGIFY(xine_osd_set_palette));
  }

  
  for (i = 0; i < 256; i++) {
    long val = PyInt_AsLong(PySequence_Fast_GET_ITEM(seq, i));
    if (val == -1) {
      Py_DECREF(seq);
      return PyErr_Format(PyExc_ValueError,
			  "expected sequence of length 256 for arg %d of %s",
			  3, STRINGIFY(xine_osd_set_palette));
    }
    _arg2[i] = val;
  }
  Py_DECREF(seq);
}
    xine_osd_set_palette(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_set_text_palette(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    int  _arg1;
    int  _arg2;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sii:xine_osd_set_text_palette",&_argc0,&_arg1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_set_text_palette. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_set_text_palette(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_xine_osd_get_palette(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_osd_t * _arg0;
    color_t * _arg1;
    trans_t * _arg2;
    char * _argc0 = 0;

    self = self;
{
  if (!(_arg1 = alloca(256 * sizeof(*_arg1))))
    return PyErr_NoMemory();
}
{
  if (!(_arg2 = alloca(256 * sizeof(*_arg2))))
    return PyErr_NoMemory();
}
    if(!PyArg_ParseTuple(args,"s:xine_osd_get_palette",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_osd_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_osd_get_palette. Expected _xine_osd_t_p.");
        return NULL;
        }
    }
    xine_osd_get_palette(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
  int i;
  PyObject * tuple = PyTuple_New(256);
  if (!tuple)
    return NULL;
  for (i = 0; i < 256; i++) {
    PyObject * c = PyInt_FromLong((long)_arg1[i]);
    if (!c)
      return NULL;
    PyTuple_SET_ITEM(tuple, i, c);
  }
  _resultobj = l_output_helper(_resultobj, tuple);
}
{
  int i;
  PyObject * tuple = PyTuple_New(256);
  if (!tuple)
    return NULL;
  for (i = 0; i < 256; i++) {
    PyObject * c = PyInt_FromLong((long)_arg2[i]);
    if (!c)
      return NULL;
    PyTuple_SET_ITEM(tuple, i, c);
  }
  _resultobj = l_output_helper(_resultobj, tuple);
}
    return _resultobj;
}

static xine_audio_port_t ** xine_post_s_audio_input_set(struct xine_post_s *obj, xine_audio_port_t **val) {
{
  PyErr_Format(PyExc_AttributeError,
	       "%s is read-only", STRINGIFY(obj->audio_input));
  return 0;
}
    return (xine_audio_port_t **) val;
}
static PyObject *_wrap_xine_post_s_audio_input_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_audio_port_t ** _result;
    struct xine_post_s * _arg0;
    xine_audio_port_t ** _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_s_audio_input_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_s_audio_input_set. Expected _struct_xine_post_s_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_audio_port_t_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_post_s_audio_input_set. Expected _xine_audio_port_t_pp.");
        return NULL;
        }
    }
    _result = (xine_audio_port_t **)xine_post_s_audio_input_set(_arg0,_arg1);
{
  static const char * ptrtype = "_" STRINGIFY(xine_audio_port_t ) "_p";
  PyObject * stmp;
  char	ptmp[128];
  size_t i, len = 0;

  while (_result[len])
    len++;
  
  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    SWIG_MakePtr(ptmp, (char *) _result[i], (char *) ptrtype);
    if (!(stmp = PyString_FromString(ptmp)))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

#define xine_post_s_audio_input_get(_swigobj) ((xine_audio_port_t **) _swigobj->audio_input)
static PyObject *_wrap_xine_post_s_audio_input_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_audio_port_t ** _result;
    struct xine_post_s * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_s_audio_input_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_s_audio_input_get. Expected _struct_xine_post_s_p.");
        return NULL;
        }
    }
    _result = (xine_audio_port_t **)xine_post_s_audio_input_get(_arg0);
{
  static const char * ptrtype = "_" STRINGIFY(xine_audio_port_t ) "_p";
  PyObject * stmp;
  char	ptmp[128];
  size_t i, len = 0;

  while (_result[len])
    len++;
  
  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    SWIG_MakePtr(ptmp, (char *) _result[i], (char *) ptrtype);
    if (!(stmp = PyString_FromString(ptmp)))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static xine_video_port_t ** xine_post_s_video_input_set(struct xine_post_s *obj, xine_video_port_t **val) {
{
  PyErr_Format(PyExc_AttributeError,
	       "%s is read-only", STRINGIFY(obj->video_input));
  return 0;
}
    return (xine_video_port_t **) val;
}
static PyObject *_wrap_xine_post_s_video_input_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_video_port_t ** _result;
    struct xine_post_s * _arg0;
    xine_video_port_t ** _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_s_video_input_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_s_video_input_set. Expected _struct_xine_post_s_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_video_port_t_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_post_s_video_input_set. Expected _xine_video_port_t_pp.");
        return NULL;
        }
    }
    _result = (xine_video_port_t **)xine_post_s_video_input_set(_arg0,_arg1);
{
  static const char * ptrtype = "_" STRINGIFY(xine_video_port_t ) "_p";
  PyObject * stmp;
  char	ptmp[128];
  size_t i, len = 0;

  while (_result[len])
    len++;
  
  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    SWIG_MakePtr(ptmp, (char *) _result[i], (char *) ptrtype);
    if (!(stmp = PyString_FromString(ptmp)))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

#define xine_post_s_video_input_get(_swigobj) ((xine_video_port_t **) _swigobj->video_input)
static PyObject *_wrap_xine_post_s_video_input_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_video_port_t ** _result;
    struct xine_post_s * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_s_video_input_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_s_video_input_get. Expected _struct_xine_post_s_p.");
        return NULL;
        }
    }
    _result = (xine_video_port_t **)xine_post_s_video_input_get(_arg0);
{
  static const char * ptrtype = "_" STRINGIFY(xine_video_port_t ) "_p";
  PyObject * stmp;
  char	ptmp[128];
  size_t i, len = 0;

  while (_result[len])
    len++;
  
  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    SWIG_MakePtr(ptmp, (char *) _result[i], (char *) ptrtype);
    if (!(stmp = PyString_FromString(ptmp)))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

#define xine_post_s_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static PyObject *_wrap_xine_post_s_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_post_s * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_post_s_type_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_s_type_set. Expected _struct_xine_post_s_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_s_type_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_post_s_type_get(_swigobj) ((int ) _swigobj->type)
static PyObject *_wrap_xine_post_s_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_post_s * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_s_type_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_s_type_get. Expected _struct_xine_post_s_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_s_type_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static STRING  xine_post_in_s_name_set(struct xine_post_in_s *obj, STRING val) {
{
  PyErr_Format(PyExc_AttributeError,
	       "%s is read-only", STRINGIFY(obj->name));
  return 0;
}
    return (STRING ) val;
}
static PyObject *_wrap_xine_post_in_s_name_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_post_in_s * _arg0;
    STRING  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_in_s_name_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_in_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_in_s_name_set. Expected _struct_xine_post_in_s_p.");
        return NULL;
        }
    }
    _result = (STRING )xine_post_in_s_name_set(_arg0,_arg1);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_post_in_s_name_get(_swigobj) ((STRING ) _swigobj->name)
static PyObject *_wrap_xine_post_in_s_name_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_post_in_s * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_in_s_name_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_in_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_in_s_name_get. Expected _struct_xine_post_in_s_p.");
        return NULL;
        }
    }
    _result = (STRING )xine_post_in_s_name_get(_arg0);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_post_in_s_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static PyObject *_wrap_xine_post_in_s_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_post_in_s * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_post_in_s_type_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_in_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_in_s_type_set. Expected _struct_xine_post_in_s_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_in_s_type_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_post_in_s_type_get(_swigobj) ((int ) _swigobj->type)
static PyObject *_wrap_xine_post_in_s_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_post_in_s * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_in_s_type_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_in_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_in_s_type_get. Expected _struct_xine_post_in_s_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_in_s_type_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static STRING  xine_post_out_s_name_set(struct xine_post_out_s *obj, STRING val) {
{
  PyErr_Format(PyExc_AttributeError,
	       "%s is read-only", STRINGIFY(obj->name));
  return 0;
}
    return (STRING ) val;
}
static PyObject *_wrap_xine_post_out_s_name_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_post_out_s * _arg0;
    STRING  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:xine_post_out_s_name_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_out_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_out_s_name_set. Expected _struct_xine_post_out_s_p.");
        return NULL;
        }
    }
    _result = (STRING )xine_post_out_s_name_set(_arg0,_arg1);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_post_out_s_name_get(_swigobj) ((STRING ) _swigobj->name)
static PyObject *_wrap_xine_post_out_s_name_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_post_out_s * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_out_s_name_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_out_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_out_s_name_get. Expected _struct_xine_post_out_s_p.");
        return NULL;
        }
    }
    _result = (STRING )xine_post_out_s_name_get(_arg0);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_post_out_s_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static PyObject *_wrap_xine_post_out_s_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_post_out_s * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_post_out_s_type_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_out_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_out_s_type_set. Expected _struct_xine_post_out_s_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_out_s_type_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_post_out_s_type_get(_swigobj) ((int ) _swigobj->type)
static PyObject *_wrap_xine_post_out_s_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_post_out_s * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_post_out_s_type_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_struct_xine_post_out_s_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_post_out_s_type_get. Expected _struct_xine_post_out_s_p.");
        return NULL;
        }
    }
    _result = (int )xine_post_out_s_type_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define x11_rectangle_t_x_set(_swigobj,_swigval) (_swigobj->x = _swigval,_swigval)
static PyObject *_wrap_x11_rectangle_t_x_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    x11_rectangle_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:x11_rectangle_t_x_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_x11_rectangle_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of x11_rectangle_t_x_set. Expected _x11_rectangle_t_p.");
        return NULL;
        }
    }
    _result = (int )x11_rectangle_t_x_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define x11_rectangle_t_x_get(_swigobj) ((int ) _swigobj->x)
static PyObject *_wrap_x11_rectangle_t_x_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    x11_rectangle_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:x11_rectangle_t_x_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_x11_rectangle_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of x11_rectangle_t_x_get. Expected _x11_rectangle_t_p.");
        return NULL;
        }
    }
    _result = (int )x11_rectangle_t_x_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define x11_rectangle_t_y_set(_swigobj,_swigval) (_swigobj->y = _swigval,_swigval)
static PyObject *_wrap_x11_rectangle_t_y_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    x11_rectangle_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:x11_rectangle_t_y_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_x11_rectangle_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of x11_rectangle_t_y_set. Expected _x11_rectangle_t_p.");
        return NULL;
        }
    }
    _result = (int )x11_rectangle_t_y_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define x11_rectangle_t_y_get(_swigobj) ((int ) _swigobj->y)
static PyObject *_wrap_x11_rectangle_t_y_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    x11_rectangle_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:x11_rectangle_t_y_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_x11_rectangle_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of x11_rectangle_t_y_get. Expected _x11_rectangle_t_p.");
        return NULL;
        }
    }
    _result = (int )x11_rectangle_t_y_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define x11_rectangle_t_w_set(_swigobj,_swigval) (_swigobj->w = _swigval,_swigval)
static PyObject *_wrap_x11_rectangle_t_w_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    x11_rectangle_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:x11_rectangle_t_w_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_x11_rectangle_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of x11_rectangle_t_w_set. Expected _x11_rectangle_t_p.");
        return NULL;
        }
    }
    _result = (int )x11_rectangle_t_w_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define x11_rectangle_t_w_get(_swigobj) ((int ) _swigobj->w)
static PyObject *_wrap_x11_rectangle_t_w_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    x11_rectangle_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:x11_rectangle_t_w_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_x11_rectangle_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of x11_rectangle_t_w_get. Expected _x11_rectangle_t_p.");
        return NULL;
        }
    }
    _result = (int )x11_rectangle_t_w_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define x11_rectangle_t_h_set(_swigobj,_swigval) (_swigobj->h = _swigval,_swigval)
static PyObject *_wrap_x11_rectangle_t_h_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    x11_rectangle_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:x11_rectangle_t_h_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_x11_rectangle_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of x11_rectangle_t_h_set. Expected _x11_rectangle_t_p.");
        return NULL;
        }
    }
    _result = (int )x11_rectangle_t_h_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define x11_rectangle_t_h_get(_swigobj) ((int ) _swigobj->h)
static PyObject *_wrap_x11_rectangle_t_h_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    x11_rectangle_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:x11_rectangle_t_h_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_x11_rectangle_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of x11_rectangle_t_h_get. Expected _x11_rectangle_t_p.");
        return NULL;
        }
    }
    _result = (int )x11_rectangle_t_h_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static STRING  xine_cfg_entry_s_key_set(struct xine_cfg_entry_s *obj, STRING val) {
{
  PyErr_Format(PyExc_AttributeError,
	       "%s is read-only", STRINGIFY(obj->key));
  return 0;
}
    return (STRING ) val;
}
static PyObject *_wrap_xine_cfg_entry_s_key_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_cfg_entry_s * _arg0;
    STRING  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_cfg_entry_s_key_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_key_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (STRING )xine_cfg_entry_s_key_set(_arg0,_arg1);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_cfg_entry_s_key_get(_swigobj) ((STRING ) _swigobj->key)
static PyObject *_wrap_xine_cfg_entry_s_key_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_key_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_key_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (STRING )xine_cfg_entry_s_key_get(_arg0);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_cfg_entry_s_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static PyObject *_wrap_xine_cfg_entry_s_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:xine_cfg_entry_s_type_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_type_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_type_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_type_get(_swigobj) ((int ) _swigobj->type)
static PyObject *_wrap_xine_cfg_entry_s_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_type_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_type_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_type_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static char * xine_cfg_entry_s_unknown_value_set(struct xine_cfg_entry_s *obj, char *val) {
    if (obj->unknown_value) free(obj->unknown_value);
    obj->unknown_value = (char *) malloc(strlen(val)+1);
    strcpy(obj->unknown_value,val);
    return val;
}
static PyObject *_wrap_xine_cfg_entry_s_unknown_value_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    struct xine_cfg_entry_s * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_cfg_entry_s_unknown_value_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_unknown_value_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char *)xine_cfg_entry_s_unknown_value_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

#define xine_cfg_entry_s_unknown_value_get(_swigobj) ((char *) _swigobj->unknown_value)
static PyObject *_wrap_xine_cfg_entry_s_unknown_value_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_unknown_value_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_unknown_value_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char *)xine_cfg_entry_s_unknown_value_get(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static char * xine_cfg_entry_s_str_value_set(struct xine_cfg_entry_s *obj, char *val) {
    if (obj->str_value) free(obj->str_value);
    obj->str_value = (char *) malloc(strlen(val)+1);
    strcpy(obj->str_value,val);
    return val;
}
static PyObject *_wrap_xine_cfg_entry_s_str_value_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    struct xine_cfg_entry_s * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_cfg_entry_s_str_value_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_str_value_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char *)xine_cfg_entry_s_str_value_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

#define xine_cfg_entry_s_str_value_get(_swigobj) ((char *) _swigobj->str_value)
static PyObject *_wrap_xine_cfg_entry_s_str_value_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_str_value_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_str_value_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char *)xine_cfg_entry_s_str_value_get(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static char * xine_cfg_entry_s_str_default_set(struct xine_cfg_entry_s *obj, char *val) {
    if (obj->str_default) free(obj->str_default);
    obj->str_default = (char *) malloc(strlen(val)+1);
    strcpy(obj->str_default,val);
    return val;
}
static PyObject *_wrap_xine_cfg_entry_s_str_default_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    struct xine_cfg_entry_s * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_cfg_entry_s_str_default_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_str_default_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char *)xine_cfg_entry_s_str_default_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

#define xine_cfg_entry_s_str_default_get(_swigobj) ((char *) _swigobj->str_default)
static PyObject *_wrap_xine_cfg_entry_s_str_default_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_str_default_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_str_default_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char *)xine_cfg_entry_s_str_default_get(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static char * xine_cfg_entry_s_str_sticky_set(struct xine_cfg_entry_s *obj, char *val) {
    if (obj->str_sticky) free(obj->str_sticky);
    obj->str_sticky = (char *) malloc(strlen(val)+1);
    strcpy(obj->str_sticky,val);
    return val;
}
static PyObject *_wrap_xine_cfg_entry_s_str_sticky_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    struct xine_cfg_entry_s * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_cfg_entry_s_str_sticky_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_str_sticky_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char *)xine_cfg_entry_s_str_sticky_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

#define xine_cfg_entry_s_str_sticky_get(_swigobj) ((char *) _swigobj->str_sticky)
static PyObject *_wrap_xine_cfg_entry_s_str_sticky_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_str_sticky_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_str_sticky_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char *)xine_cfg_entry_s_str_sticky_get(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

#define xine_cfg_entry_s_num_value_set(_swigobj,_swigval) (_swigobj->num_value = _swigval,_swigval)
static PyObject *_wrap_xine_cfg_entry_s_num_value_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:xine_cfg_entry_s_num_value_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_num_value_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_num_value_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_num_value_get(_swigobj) ((int ) _swigobj->num_value)
static PyObject *_wrap_xine_cfg_entry_s_num_value_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_num_value_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_num_value_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_num_value_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_num_default_set(_swigobj,_swigval) (_swigobj->num_default = _swigval,_swigval)
static PyObject *_wrap_xine_cfg_entry_s_num_default_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:xine_cfg_entry_s_num_default_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_num_default_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_num_default_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_num_default_get(_swigobj) ((int ) _swigobj->num_default)
static PyObject *_wrap_xine_cfg_entry_s_num_default_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_num_default_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_num_default_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_num_default_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_range_min_set(_swigobj,_swigval) (_swigobj->range_min = _swigval,_swigval)
static PyObject *_wrap_xine_cfg_entry_s_range_min_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:xine_cfg_entry_s_range_min_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_range_min_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_range_min_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_range_min_get(_swigobj) ((int ) _swigobj->range_min)
static PyObject *_wrap_xine_cfg_entry_s_range_min_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_range_min_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_range_min_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_range_min_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_range_max_set(_swigobj,_swigval) (_swigobj->range_max = _swigval,_swigval)
static PyObject *_wrap_xine_cfg_entry_s_range_max_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:xine_cfg_entry_s_range_max_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_range_max_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_range_max_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_range_max_get(_swigobj) ((int ) _swigobj->range_max)
static PyObject *_wrap_xine_cfg_entry_s_range_max_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_range_max_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_range_max_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_range_max_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_enum_values_set(_swigobj,_swigval) (_swigobj->enum_values = _swigval,_swigval)
static PyObject *_wrap_xine_cfg_entry_s_enum_values_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char ** _result;
    struct xine_cfg_entry_s * _arg0;
    char ** _arg1;
    PyObject * _obj0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_cfg_entry_s_enum_values_set",&_obj0,&_argc1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_enum_values_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_char_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_cfg_entry_s_enum_values_set. Expected _char_pp.");
        return NULL;
        }
    }
    _result = (char **)xine_cfg_entry_s_enum_values_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_char_pp");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define xine_cfg_entry_s_enum_values_get(_swigobj) ((char **) _swigobj->enum_values)
static PyObject *_wrap_xine_cfg_entry_s_enum_values_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char ** _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_enum_values_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_enum_values_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (char **)xine_cfg_entry_s_enum_values_get(_arg0);
{
  PyObject * stmp;
  size_t i, len = 0;

  while (_result[len])
    len++;

  if (!(_resultobj = PyTuple_New(len)))
    return NULL;

  for (i = 0; i < len; i++) {
    if (!(stmp = PyString_FromString(_result[i])))
      return NULL;
    PyTuple_SET_ITEM(_resultobj, i, stmp);
  }
}
    return _resultobj;
}

static STRING  xine_cfg_entry_s_description_set(struct xine_cfg_entry_s *obj, STRING val) {
{
  PyErr_Format(PyExc_AttributeError,
	       "%s is read-only", STRINGIFY(obj->description));
  return 0;
}
    return (STRING ) val;
}
static PyObject *_wrap_xine_cfg_entry_s_description_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_cfg_entry_s * _arg0;
    STRING  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_cfg_entry_s_description_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_description_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (STRING )xine_cfg_entry_s_description_set(_arg0,_arg1);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_cfg_entry_s_description_get(_swigobj) ((STRING ) _swigobj->description)
static PyObject *_wrap_xine_cfg_entry_s_description_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_description_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_description_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (STRING )xine_cfg_entry_s_description_get(_arg0);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

static STRING  xine_cfg_entry_s_help_set(struct xine_cfg_entry_s *obj, STRING val) {
{
  PyErr_Format(PyExc_AttributeError,
	       "%s is read-only", STRINGIFY(obj->help));
  return 0;
}
    return (STRING ) val;
}
static PyObject *_wrap_xine_cfg_entry_s_help_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_cfg_entry_s * _arg0;
    STRING  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_cfg_entry_s_help_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_help_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (STRING )xine_cfg_entry_s_help_set(_arg0,_arg1);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_cfg_entry_s_help_get(_swigobj) ((STRING ) _swigobj->help)
static PyObject *_wrap_xine_cfg_entry_s_help_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    STRING  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_help_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_help_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (STRING )xine_cfg_entry_s_help_get(_arg0);
{
  if (PyErr_Occurred())
    return NULL;
  _resultobj = Py_BuildValue("s", _result);
  if (!_resultobj)
    return NULL;
}
    return _resultobj;
}

#define xine_cfg_entry_s_exp_level_set(_swigobj,_swigval) (_swigobj->exp_level = _swigval,_swigval)
static PyObject *_wrap_xine_cfg_entry_s_exp_level_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:xine_cfg_entry_s_exp_level_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_exp_level_set), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_exp_level_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_cfg_entry_s_exp_level_get(_swigobj) ((int ) _swigobj->exp_level)
static PyObject *_wrap_xine_cfg_entry_s_exp_level_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    struct xine_cfg_entry_s * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_cfg_entry_s_exp_level_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(struct xine_cfg_entry_s )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(struct xine_cfg_entry_s ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(struct xine_cfg_entry_s )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_cfg_entry_s_exp_level_get), STRINGIFY(struct xine_cfg_entry_s ));
  _arg0 = ptr;
}
    _result = (int )xine_cfg_entry_s_exp_level_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_event_t_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static PyObject *_wrap_xine_event_t_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_event_t * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:xine_event_t_type_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_type_set), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    _result = (int )xine_event_t_type_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_event_t_type_get(_swigobj) ((int ) _swigobj->type)
static PyObject *_wrap_xine_event_t_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_event_t * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_event_t_type_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_type_get), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    _result = (int )xine_event_t_type_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_event_t_stream_set(_swigobj,_swigval) (_swigobj->stream = _swigval,_swigval)
static PyObject *_wrap_xine_event_t_stream_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_stream_t * _result;
    xine_event_t * _arg0;
    xine_stream_t * _arg1;
    PyObject * _obj0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_event_t_stream_set",&_obj0,&_argc1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_stream_set), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_xine_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_event_t_stream_set. Expected _xine_stream_t_p.");
        return NULL;
        }
    }
    _result = (xine_stream_t *)xine_event_t_stream_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_xine_stream_t_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define xine_event_t_stream_get(_swigobj) ((xine_stream_t *) _swigobj->stream)
static PyObject *_wrap_xine_event_t_stream_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_stream_t * _result;
    xine_event_t * _arg0;
    PyObject * _obj0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_event_t_stream_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_stream_get), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    _result = (xine_stream_t *)xine_event_t_stream_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_xine_stream_t_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define xine_event_t_data_set(_swigobj,_swigval) (_swigobj->data = _swigval,_swigval)
static PyObject *_wrap_xine_event_t_data_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    void * _result;
    xine_event_t * _arg0;
    void * _arg1;
    PyObject * _obj0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Os:xine_event_t_data_set",&_obj0,&_argc1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_data_set), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of xine_event_t_data_set. Expected _void_p.");
        return NULL;
        }
    }
    _result = (void *)xine_event_t_data_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_void_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define xine_event_t_data_get(_swigobj) ((void *) _swigobj->data)
static PyObject *_wrap_xine_event_t_data_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    void * _result;
    xine_event_t * _arg0;
    PyObject * _obj0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_event_t_data_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_data_get), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    _result = (void *)xine_event_t_data_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_void_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define xine_event_t_data_length_set(_swigobj,_swigval) (_swigobj->data_length = _swigval,_swigval)
static PyObject *_wrap_xine_event_t_data_length_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_event_t * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:xine_event_t_data_length_set",&_obj0,&_arg1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_data_length_set), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    _result = (int )xine_event_t_data_length_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_event_t_data_length_get(_swigobj) ((int ) _swigobj->data_length)
static PyObject *_wrap_xine_event_t_data_length_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_event_t * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_event_t_data_length_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_data_length_get), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    _result = (int )xine_event_t_data_length_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_event_t_tv_set(_swigobj,_swigval) (_swigobj->tv = *(_swigval),_swigval)
static PyObject *_wrap_xine_event_t_tv_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    struct timeval * _result;
    xine_event_t * _arg0;
    struct timeval * _arg1;
    PyObject * _obj0 = 0;
    struct timeval  tmp;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:xine_event_t_tv_set",&_obj0,&_obj1)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_tv_set), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
{
  double secs;
  secs = PyFloat_AsDouble(_obj1);
  tmp.tv_sec = floor(secs);
  tmp.tv_usec = floor((secs - tmp.tv_sec) * 1e6);
  _arg1 = &tmp;
}
    _result = (struct timeval *)xine_event_t_tv_set(_arg0,_arg1);
{
  _resultobj = PyFloat_FromDouble(_result->tv_sec + _result->tv_usec / 1e6);
}
    return _resultobj;
}

#define xine_event_t_tv_get(_swigobj) (&_swigobj->tv)
static PyObject *_wrap_xine_event_t_tv_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    struct timeval * _result;
    xine_event_t * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:xine_event_t_tv_get",&_obj0)) 
        return NULL;
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj0, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			1, STRINGIFY(xine_event_t_tv_get), STRINGIFY(xine_event_t ));
  _arg0 = ptr;
}
    _result = (struct timeval *)xine_event_t_tv_get(_arg0);
{
  _resultobj = PyFloat_FromDouble(_result->tv_sec + _result->tv_usec / 1e6);
}
    return _resultobj;
}

#define xine_input_data_t_event_set(_swigobj,_swigval) (_swigobj->event = *(_swigval),_swigval)
static PyObject *_wrap_xine_input_data_t_event_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_event_t * _result;
    xine_input_data_t * _arg0;
    xine_event_t * _arg1;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sO:xine_input_data_t_event_set",&_argc0,&_obj1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_input_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_input_data_t_event_set. Expected _xine_input_data_t_p.");
        return NULL;
        }
    }
{
  int length;
  void * ptr;
  
  if (PyObject_AsWriteBuffer(_obj1, (void **)&ptr, &length))
    return NULL;
#unassert BASETYPE
#assert BASETYPE(xine_event_t )
#if #BASETYPE(xine_event_t)
  if (length != sizeof(xine_event_t ) && length != sizeof(xine_input_data_t)) 
#else
  if (length != sizeof(xine_event_t )) 
#endif
#unassert BASETYPE    
    return PyErr_Format(PyExc_TypeError,
			"arg %d of %s has bad size for %s",
			2, STRINGIFY(xine_input_data_t_event_set), STRINGIFY(xine_event_t ));
  _arg1 = ptr;
}
    _result = (xine_event_t *)xine_input_data_t_event_set(_arg0,_arg1);
{
  if (_result) {
    _resultobj = PyBuffer_FromReadWriteMemory(_result, sizeof(xine_event_t ));
    if (!_resultobj)
      return NULL;
  }
  else {
    Py_INCREF(Py_None);
    _resultobj = Py_None;
  }
}
    return _resultobj;
}

#define xine_input_data_t_event_get(_swigobj) (&_swigobj->event)
static PyObject *_wrap_xine_input_data_t_event_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    xine_event_t * _result;
    xine_input_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_input_data_t_event_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_input_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_input_data_t_event_get. Expected _xine_input_data_t_p.");
        return NULL;
        }
    }
    _result = (xine_event_t *)xine_input_data_t_event_get(_arg0);
{
  if (_result) {
    _resultobj = PyBuffer_FromReadWriteMemory(_result, sizeof(xine_event_t ));
    if (!_resultobj)
      return NULL;
  }
  else {
    Py_INCREF(Py_None);
    _resultobj = Py_None;
  }
}
    return _resultobj;
}

#define xine_input_data_t_button_set(_swigobj,_swigval) (_swigobj->button = _swigval,_swigval)
static PyObject *_wrap_xine_input_data_t_button_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    uint8_t  _result;
    xine_input_data_t * _arg0;
    uint8_t  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sb:xine_input_data_t_button_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_input_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_input_data_t_button_set. Expected _xine_input_data_t_p.");
        return NULL;
        }
    }
    _result = (uint8_t )xine_input_data_t_button_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("b",_result);
    return _resultobj;
}

#define xine_input_data_t_button_get(_swigobj) ((uint8_t ) _swigobj->button)
static PyObject *_wrap_xine_input_data_t_button_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    uint8_t  _result;
    xine_input_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_input_data_t_button_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_input_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_input_data_t_button_get. Expected _xine_input_data_t_p.");
        return NULL;
        }
    }
    _result = (uint8_t )xine_input_data_t_button_get(_arg0);
    _resultobj = Py_BuildValue("b",_result);
    return _resultobj;
}

#define xine_input_data_t_x_set(_swigobj,_swigval) (_swigobj->x = _swigval,_swigval)
static PyObject *_wrap_xine_input_data_t_x_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    uint16_t  _result;
    xine_input_data_t * _arg0;
    uint16_t  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sh:xine_input_data_t_x_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_input_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_input_data_t_x_set. Expected _xine_input_data_t_p.");
        return NULL;
        }
    }
    _result = (uint16_t )xine_input_data_t_x_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("h",_result);
    return _resultobj;
}

#define xine_input_data_t_x_get(_swigobj) ((uint16_t ) _swigobj->x)
static PyObject *_wrap_xine_input_data_t_x_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    uint16_t  _result;
    xine_input_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_input_data_t_x_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_input_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_input_data_t_x_get. Expected _xine_input_data_t_p.");
        return NULL;
        }
    }
    _result = (uint16_t )xine_input_data_t_x_get(_arg0);
    _resultobj = Py_BuildValue("h",_result);
    return _resultobj;
}

#define xine_input_data_t_y_set(_swigobj,_swigval) (_swigobj->y = _swigval,_swigval)
static PyObject *_wrap_xine_input_data_t_y_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    uint16_t  _result;
    xine_input_data_t * _arg0;
    uint16_t  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sh:xine_input_data_t_y_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_input_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_input_data_t_y_set. Expected _xine_input_data_t_p.");
        return NULL;
        }
    }
    _result = (uint16_t )xine_input_data_t_y_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("h",_result);
    return _resultobj;
}

#define xine_input_data_t_y_get(_swigobj) ((uint16_t ) _swigobj->y)
static PyObject *_wrap_xine_input_data_t_y_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    uint16_t  _result;
    xine_input_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_input_data_t_y_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_input_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_input_data_t_y_get. Expected _xine_input_data_t_p.");
        return NULL;
        }
    }
    _result = (uint16_t )xine_input_data_t_y_get(_arg0);
    _resultobj = Py_BuildValue("h",_result);
    return _resultobj;
}

#define xine_ui_data_t_num_buttons_set(_swigobj,_swigval) (_swigobj->num_buttons = _swigval,_swigval)
static PyObject *_wrap_xine_ui_data_t_num_buttons_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_ui_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_ui_data_t_num_buttons_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_ui_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_ui_data_t_num_buttons_set. Expected _xine_ui_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_ui_data_t_num_buttons_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_ui_data_t_num_buttons_get(_swigobj) ((int ) _swigobj->num_buttons)
static PyObject *_wrap_xine_ui_data_t_num_buttons_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_ui_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_ui_data_t_num_buttons_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_ui_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_ui_data_t_num_buttons_get. Expected _xine_ui_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_ui_data_t_num_buttons_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_ui_data_t_str_len_set(_swigobj,_swigval) (_swigobj->str_len = _swigval,_swigval)
static PyObject *_wrap_xine_ui_data_t_str_len_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_ui_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_ui_data_t_str_len_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_ui_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_ui_data_t_str_len_set. Expected _xine_ui_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_ui_data_t_str_len_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_ui_data_t_str_len_get(_swigobj) ((int ) _swigobj->str_len)
static PyObject *_wrap_xine_ui_data_t_str_len_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_ui_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_ui_data_t_str_len_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_ui_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_ui_data_t_str_len_get. Expected _xine_ui_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_ui_data_t_str_len_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_ui_data_t_str_get(_swigobj) ((char *) _swigobj->str)
static PyObject *_wrap_xine_ui_data_t_str_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    xine_ui_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_ui_data_t_str_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_ui_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_ui_data_t_str_get. Expected _xine_ui_data_t_p.");
        return NULL;
        }
    }
    _result = (char *)xine_ui_data_t_str_get(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

#define xine_format_change_data_t_width_set(_swigobj,_swigval) (_swigobj->width = _swigval,_swigval)
static PyObject *_wrap_xine_format_change_data_t_width_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_format_change_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_format_change_data_t_width_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_format_change_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_format_change_data_t_width_set. Expected _xine_format_change_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_format_change_data_t_width_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_format_change_data_t_width_get(_swigobj) ((int ) _swigobj->width)
static PyObject *_wrap_xine_format_change_data_t_width_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_format_change_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_format_change_data_t_width_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_format_change_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_format_change_data_t_width_get. Expected _xine_format_change_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_format_change_data_t_width_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_format_change_data_t_height_set(_swigobj,_swigval) (_swigobj->height = _swigval,_swigval)
static PyObject *_wrap_xine_format_change_data_t_height_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_format_change_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_format_change_data_t_height_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_format_change_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_format_change_data_t_height_set. Expected _xine_format_change_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_format_change_data_t_height_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_format_change_data_t_height_get(_swigobj) ((int ) _swigobj->height)
static PyObject *_wrap_xine_format_change_data_t_height_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_format_change_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_format_change_data_t_height_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_format_change_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_format_change_data_t_height_get. Expected _xine_format_change_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_format_change_data_t_height_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_format_change_data_t_aspect_set(_swigobj,_swigval) (_swigobj->aspect = _swigval,_swigval)
static PyObject *_wrap_xine_format_change_data_t_aspect_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_format_change_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_format_change_data_t_aspect_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_format_change_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_format_change_data_t_aspect_set. Expected _xine_format_change_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_format_change_data_t_aspect_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_format_change_data_t_aspect_get(_swigobj) ((int ) _swigobj->aspect)
static PyObject *_wrap_xine_format_change_data_t_aspect_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_format_change_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_format_change_data_t_aspect_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_format_change_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_format_change_data_t_aspect_get. Expected _xine_format_change_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_format_change_data_t_aspect_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_audio_level_data_t_left_set(_swigobj,_swigval) (_swigobj->left = _swigval,_swigval)
static PyObject *_wrap_xine_audio_level_data_t_left_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_audio_level_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_audio_level_data_t_left_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_audio_level_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_audio_level_data_t_left_set. Expected _xine_audio_level_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_audio_level_data_t_left_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_audio_level_data_t_left_get(_swigobj) ((int ) _swigobj->left)
static PyObject *_wrap_xine_audio_level_data_t_left_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_audio_level_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_audio_level_data_t_left_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_audio_level_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_audio_level_data_t_left_get. Expected _xine_audio_level_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_audio_level_data_t_left_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_audio_level_data_t_right_set(_swigobj,_swigval) (_swigobj->right = _swigval,_swigval)
static PyObject *_wrap_xine_audio_level_data_t_right_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_audio_level_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_audio_level_data_t_right_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_audio_level_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_audio_level_data_t_right_set. Expected _xine_audio_level_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_audio_level_data_t_right_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_audio_level_data_t_right_get(_swigobj) ((int ) _swigobj->right)
static PyObject *_wrap_xine_audio_level_data_t_right_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_audio_level_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_audio_level_data_t_right_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_audio_level_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_audio_level_data_t_right_get. Expected _xine_audio_level_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_audio_level_data_t_right_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_progress_data_t_percent_set(_swigobj,_swigval) (_swigobj->percent = _swigval,_swigval)
static PyObject *_wrap_xine_progress_data_t_percent_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_progress_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_progress_data_t_percent_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_progress_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_progress_data_t_percent_set. Expected _xine_progress_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_progress_data_t_percent_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_progress_data_t_percent_get(_swigobj) ((int ) _swigobj->percent)
static PyObject *_wrap_xine_progress_data_t_percent_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_progress_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_progress_data_t_percent_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_progress_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_progress_data_t_percent_get. Expected _xine_progress_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_progress_data_t_percent_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_mrl_reference_data_t_alternative_set(_swigobj,_swigval) (_swigobj->alternative = _swigval,_swigval)
static PyObject *_wrap_xine_mrl_reference_data_t_alternative_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_mrl_reference_data_t * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:xine_mrl_reference_data_t_alternative_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_mrl_reference_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_mrl_reference_data_t_alternative_set. Expected _xine_mrl_reference_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_mrl_reference_data_t_alternative_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_mrl_reference_data_t_alternative_get(_swigobj) ((int ) _swigobj->alternative)
static PyObject *_wrap_xine_mrl_reference_data_t_alternative_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    xine_mrl_reference_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_mrl_reference_data_t_alternative_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_mrl_reference_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_mrl_reference_data_t_alternative_get. Expected _xine_mrl_reference_data_t_p.");
        return NULL;
        }
    }
    _result = (int )xine_mrl_reference_data_t_alternative_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define xine_mrl_reference_data_t_mrl_get(_swigobj) ((char *) _swigobj->mrl)
static PyObject *_wrap_xine_mrl_reference_data_t_mrl_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    xine_mrl_reference_data_t * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:xine_mrl_reference_data_t_mrl_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_xine_mrl_reference_data_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of xine_mrl_reference_data_t_mrl_get. Expected _xine_mrl_reference_data_t_p.");
        return NULL;
        }
    }
    _result = (char *)xine_mrl_reference_data_t_mrl_get(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyMethodDef libxineMethods[] = {
	 { "xine_mrl_reference_data_t_mrl_get", _wrap_xine_mrl_reference_data_t_mrl_get, 1 },
	 { "xine_mrl_reference_data_t_alternative_get", _wrap_xine_mrl_reference_data_t_alternative_get, 1 },
	 { "xine_mrl_reference_data_t_alternative_set", _wrap_xine_mrl_reference_data_t_alternative_set, 1 },
	 { "xine_progress_data_t_percent_get", _wrap_xine_progress_data_t_percent_get, 1 },
	 { "xine_progress_data_t_percent_set", _wrap_xine_progress_data_t_percent_set, 1 },
	 { "xine_audio_level_data_t_right_get", _wrap_xine_audio_level_data_t_right_get, 1 },
	 { "xine_audio_level_data_t_right_set", _wrap_xine_audio_level_data_t_right_set, 1 },
	 { "xine_audio_level_data_t_left_get", _wrap_xine_audio_level_data_t_left_get, 1 },
	 { "xine_audio_level_data_t_left_set", _wrap_xine_audio_level_data_t_left_set, 1 },
	 { "xine_format_change_data_t_aspect_get", _wrap_xine_format_change_data_t_aspect_get, 1 },
	 { "xine_format_change_data_t_aspect_set", _wrap_xine_format_change_data_t_aspect_set, 1 },
	 { "xine_format_change_data_t_height_get", _wrap_xine_format_change_data_t_height_get, 1 },
	 { "xine_format_change_data_t_height_set", _wrap_xine_format_change_data_t_height_set, 1 },
	 { "xine_format_change_data_t_width_get", _wrap_xine_format_change_data_t_width_get, 1 },
	 { "xine_format_change_data_t_width_set", _wrap_xine_format_change_data_t_width_set, 1 },
	 { "xine_ui_data_t_str_get", _wrap_xine_ui_data_t_str_get, 1 },
	 { "xine_ui_data_t_str_len_get", _wrap_xine_ui_data_t_str_len_get, 1 },
	 { "xine_ui_data_t_str_len_set", _wrap_xine_ui_data_t_str_len_set, 1 },
	 { "xine_ui_data_t_num_buttons_get", _wrap_xine_ui_data_t_num_buttons_get, 1 },
	 { "xine_ui_data_t_num_buttons_set", _wrap_xine_ui_data_t_num_buttons_set, 1 },
	 { "xine_input_data_t_y_get", _wrap_xine_input_data_t_y_get, 1 },
	 { "xine_input_data_t_y_set", _wrap_xine_input_data_t_y_set, 1 },
	 { "xine_input_data_t_x_get", _wrap_xine_input_data_t_x_get, 1 },
	 { "xine_input_data_t_x_set", _wrap_xine_input_data_t_x_set, 1 },
	 { "xine_input_data_t_button_get", _wrap_xine_input_data_t_button_get, 1 },
	 { "xine_input_data_t_button_set", _wrap_xine_input_data_t_button_set, 1 },
	 { "xine_input_data_t_event_get", _wrap_xine_input_data_t_event_get, 1 },
	 { "xine_input_data_t_event_set", _wrap_xine_input_data_t_event_set, 1 },
	 { "xine_event_t_tv_get", _wrap_xine_event_t_tv_get, 1 },
	 { "xine_event_t_tv_set", _wrap_xine_event_t_tv_set, 1 },
	 { "xine_event_t_data_length_get", _wrap_xine_event_t_data_length_get, 1 },
	 { "xine_event_t_data_length_set", _wrap_xine_event_t_data_length_set, 1 },
	 { "xine_event_t_data_get", _wrap_xine_event_t_data_get, 1 },
	 { "xine_event_t_data_set", _wrap_xine_event_t_data_set, 1 },
	 { "xine_event_t_stream_get", _wrap_xine_event_t_stream_get, 1 },
	 { "xine_event_t_stream_set", _wrap_xine_event_t_stream_set, 1 },
	 { "xine_event_t_type_get", _wrap_xine_event_t_type_get, 1 },
	 { "xine_event_t_type_set", _wrap_xine_event_t_type_set, 1 },
	 { "xine_cfg_entry_s_exp_level_get", _wrap_xine_cfg_entry_s_exp_level_get, 1 },
	 { "xine_cfg_entry_s_exp_level_set", _wrap_xine_cfg_entry_s_exp_level_set, 1 },
	 { "xine_cfg_entry_s_help_get", _wrap_xine_cfg_entry_s_help_get, 1 },
	 { "xine_cfg_entry_s_help_set", _wrap_xine_cfg_entry_s_help_set, 1 },
	 { "xine_cfg_entry_s_description_get", _wrap_xine_cfg_entry_s_description_get, 1 },
	 { "xine_cfg_entry_s_description_set", _wrap_xine_cfg_entry_s_description_set, 1 },
	 { "xine_cfg_entry_s_enum_values_get", _wrap_xine_cfg_entry_s_enum_values_get, 1 },
	 { "xine_cfg_entry_s_enum_values_set", _wrap_xine_cfg_entry_s_enum_values_set, 1 },
	 { "xine_cfg_entry_s_range_max_get", _wrap_xine_cfg_entry_s_range_max_get, 1 },
	 { "xine_cfg_entry_s_range_max_set", _wrap_xine_cfg_entry_s_range_max_set, 1 },
	 { "xine_cfg_entry_s_range_min_get", _wrap_xine_cfg_entry_s_range_min_get, 1 },
	 { "xine_cfg_entry_s_range_min_set", _wrap_xine_cfg_entry_s_range_min_set, 1 },
	 { "xine_cfg_entry_s_num_default_get", _wrap_xine_cfg_entry_s_num_default_get, 1 },
	 { "xine_cfg_entry_s_num_default_set", _wrap_xine_cfg_entry_s_num_default_set, 1 },
	 { "xine_cfg_entry_s_num_value_get", _wrap_xine_cfg_entry_s_num_value_get, 1 },
	 { "xine_cfg_entry_s_num_value_set", _wrap_xine_cfg_entry_s_num_value_set, 1 },
	 { "xine_cfg_entry_s_str_sticky_get", _wrap_xine_cfg_entry_s_str_sticky_get, 1 },
	 { "xine_cfg_entry_s_str_sticky_set", _wrap_xine_cfg_entry_s_str_sticky_set, 1 },
	 { "xine_cfg_entry_s_str_default_get", _wrap_xine_cfg_entry_s_str_default_get, 1 },
	 { "xine_cfg_entry_s_str_default_set", _wrap_xine_cfg_entry_s_str_default_set, 1 },
	 { "xine_cfg_entry_s_str_value_get", _wrap_xine_cfg_entry_s_str_value_get, 1 },
	 { "xine_cfg_entry_s_str_value_set", _wrap_xine_cfg_entry_s_str_value_set, 1 },
	 { "xine_cfg_entry_s_unknown_value_get", _wrap_xine_cfg_entry_s_unknown_value_get, 1 },
	 { "xine_cfg_entry_s_unknown_value_set", _wrap_xine_cfg_entry_s_unknown_value_set, 1 },
	 { "xine_cfg_entry_s_type_get", _wrap_xine_cfg_entry_s_type_get, 1 },
	 { "xine_cfg_entry_s_type_set", _wrap_xine_cfg_entry_s_type_set, 1 },
	 { "xine_cfg_entry_s_key_get", _wrap_xine_cfg_entry_s_key_get, 1 },
	 { "xine_cfg_entry_s_key_set", _wrap_xine_cfg_entry_s_key_set, 1 },
	 { "x11_rectangle_t_h_get", _wrap_x11_rectangle_t_h_get, 1 },
	 { "x11_rectangle_t_h_set", _wrap_x11_rectangle_t_h_set, 1 },
	 { "x11_rectangle_t_w_get", _wrap_x11_rectangle_t_w_get, 1 },
	 { "x11_rectangle_t_w_set", _wrap_x11_rectangle_t_w_set, 1 },
	 { "x11_rectangle_t_y_get", _wrap_x11_rectangle_t_y_get, 1 },
	 { "x11_rectangle_t_y_set", _wrap_x11_rectangle_t_y_set, 1 },
	 { "x11_rectangle_t_x_get", _wrap_x11_rectangle_t_x_get, 1 },
	 { "x11_rectangle_t_x_set", _wrap_x11_rectangle_t_x_set, 1 },
	 { "xine_post_out_s_type_get", _wrap_xine_post_out_s_type_get, 1 },
	 { "xine_post_out_s_type_set", _wrap_xine_post_out_s_type_set, 1 },
	 { "xine_post_out_s_name_get", _wrap_xine_post_out_s_name_get, 1 },
	 { "xine_post_out_s_name_set", _wrap_xine_post_out_s_name_set, 1 },
	 { "xine_post_in_s_type_get", _wrap_xine_post_in_s_type_get, 1 },
	 { "xine_post_in_s_type_set", _wrap_xine_post_in_s_type_set, 1 },
	 { "xine_post_in_s_name_get", _wrap_xine_post_in_s_name_get, 1 },
	 { "xine_post_in_s_name_set", _wrap_xine_post_in_s_name_set, 1 },
	 { "xine_post_s_type_get", _wrap_xine_post_s_type_get, 1 },
	 { "xine_post_s_type_set", _wrap_xine_post_s_type_set, 1 },
	 { "xine_post_s_video_input_get", _wrap_xine_post_s_video_input_get, 1 },
	 { "xine_post_s_video_input_set", _wrap_xine_post_s_video_input_set, 1 },
	 { "xine_post_s_audio_input_get", _wrap_xine_post_s_audio_input_get, 1 },
	 { "xine_post_s_audio_input_set", _wrap_xine_post_s_audio_input_set, 1 },
	 { "xine_osd_get_palette", _wrap_xine_osd_get_palette, 1 },
	 { "xine_osd_set_text_palette", _wrap_xine_osd_set_text_palette, 1 },
	 { "xine_osd_set_palette", _wrap_xine_osd_set_palette, 1 },
	 { "xine_osd_free", _wrap_xine_osd_free, 1 },
	 { "xine_osd_clear", _wrap_xine_osd_clear, 1 },
	 { "xine_osd_hide", _wrap_xine_osd_hide, 1 },
	 { "xine_osd_show", _wrap_xine_osd_show, 1 },
	 { "xine_osd_set_position", _wrap_xine_osd_set_position, 1 },
	 { "xine_osd_set_font", _wrap_xine_osd_set_font, 1 },
	 { "xine_osd_get_text_size", _wrap_xine_osd_get_text_size, 1 },
	 { "xine_osd_draw_text", _wrap_xine_osd_draw_text, 1 },
	 { "xine_osd_draw_rect", _wrap_xine_osd_draw_rect, 1 },
	 { "xine_osd_draw_line", _wrap_xine_osd_draw_line, 1 },
	 { "xine_osd_draw_point", _wrap_xine_osd_draw_point, 1 },
	 { "xine_osd_new", _wrap_xine_osd_new, 1 },
	 { "xine_event_send", _wrap_xine_event_send, 1 },
	 { "xine_event_create_listener_thread", _wrap_xine_event_create_listener_thread, 1 },
	 { "xine_event_free", _wrap_xine_event_free, 1 },
	 { "xine_event_wait", _wrap_xine_event_wait, 1 },
	 { "xine_event_get", _wrap_xine_event_get, 1 },
	 { "xine_event_dispose_queue", _wrap_xine_event_dispose_queue, 1 },
	 { "xine_event_new_queue", _wrap_xine_event_new_queue, 1 },
	 { "xine_config_reset", _wrap_xine_config_reset, 1 },
	 { "xine_config_save", _wrap_xine_config_save, 1 },
	 { "xine_config_load", _wrap_xine_config_load, 1 },
	 { "xine_config_update_entry", _wrap_xine_config_update_entry, 1 },
	 { "xine_config_lookup_entry", _wrap_xine_config_lookup_entry, 1 },
	 { "xine_config_get_next_entry", _wrap_xine_config_get_next_entry, 1 },
	 { "xine_config_get_first_entry", _wrap_xine_config_get_first_entry, 1 },
	 { "xine_config_register_bool", _wrap_xine_config_register_bool, 1 },
	 { "xine_config_register_num", _wrap_xine_config_register_num, 1 },
	 { "xine_config_register_enum", _wrap_xine_config_register_enum, 1 },
	 { "xine_config_register_range", _wrap_xine_config_register_range, 1 },
	 { "xine_config_register_string", _wrap_xine_config_register_string, 1 },
	 { "xine_gui_send_vo_data", _wrap_xine_gui_send_vo_data, 1 },
	 { "xine_list_video_output_plugins", _wrap_xine_list_video_output_plugins, 1 },
	 { "xine_list_audio_output_plugins", _wrap_xine_list_audio_output_plugins, 1 },
	 { "xine_get_input_plugin_description", _wrap_xine_get_input_plugin_description, 1 },
	 { "xine_get_demux_for_mime_type", _wrap_xine_get_demux_for_mime_type, 1 },
	 { "xine_get_mime_types", _wrap_xine_get_mime_types, 1 },
	 { "xine_get_file_extensions", _wrap_xine_get_file_extensions, 1 },
	 { "xine_get_autoplay_mrls", _wrap_xine_get_autoplay_mrls, 1 },
	 { "xine_get_autoplay_input_plugin_ids", _wrap_xine_get_autoplay_input_plugin_ids, 1 },
	 { "xine_get_browse_mrls", _wrap_xine_get_browse_mrls, 1 },
	 { "xine_get_browsable_input_plugin_ids", _wrap_xine_get_browsable_input_plugin_ids, 1 },
	 { "xine_get_meta_info", _wrap_xine_get_meta_info, 1 },
	 { "xine_get_stream_info", _wrap_xine_get_stream_info, 1 },
	 { "xine_get_pos_length", _wrap_xine_get_pos_length, 1 },
	 { "xine_get_spu_lang", _wrap_xine_get_spu_lang, 1 },
	 { "xine_get_audio_lang", _wrap_xine_get_audio_lang, 1 },
	 { "xine_get_status", _wrap_xine_get_status, 1 },
	 { "xine_get_error", _wrap_xine_get_error, 1 },
	 { "xine_register_log_cb", _wrap_xine_register_log_cb, 1 },
	 { "xine_get_log", _wrap_xine_get_log, 1 },
	 { "xine_log", _wrap_xine_log, 1 },
	 { "xine_get_log_names", _wrap_xine_get_log_names, 1 },
	 { "xine_get_log_section_count", _wrap_xine_get_log_section_count, 1 },
	 { "xine_post_dispose", _wrap_xine_post_dispose, 1 },
	 { "xine_get_audio_source", _wrap_xine_get_audio_source, 1 },
	 { "xine_get_video_source", _wrap_xine_get_video_source, 1 },
	 { "xine_post_wire_audio_port", _wrap_xine_post_wire_audio_port, 1 },
	 { "xine_post_wire_video_port", _wrap_xine_post_wire_video_port, 1 },
	 { "xine_post_wire", _wrap_xine_post_wire, 1 },
	 { "xine_post_output", _wrap_xine_post_output, 1 },
	 { "xine_post_input", _wrap_xine_post_input, 1 },
	 { "xine_post_list_outputs", _wrap_xine_post_list_outputs, 1 },
	 { "xine_post_list_inputs", _wrap_xine_post_list_inputs, 1 },
	 { "xine_list_post_plugins_typed", _wrap_xine_list_post_plugins_typed, 1 },
	 { "xine_list_post_plugins", _wrap_xine_list_post_plugins, 1 },
	 { "xine_post_init", _wrap_xine_post_init, 1 },
	 { "xine_get_param", _wrap_xine_get_param, 1 },
	 { "xine_set_param", _wrap_xine_set_param, 1 },
	 { "xine_dispose", _wrap_xine_dispose, 1 },
	 { "xine_eject", _wrap_xine_eject, 1 },
	 { "xine_close", _wrap_xine_close, 1 },
	 { "xine_stop", _wrap_xine_stop, 1 },
	 { "xine_trick_mode", _wrap_xine_trick_mode, 1 },
	 { "xine_play", _wrap_xine_play, 1 },
	 { "xine_open", _wrap_xine_open, 1 },
	 { "xine_stream_master_slave", _wrap_xine_stream_master_slave, 1 },
	 { "xine_stream_new", _wrap_xine_stream_new, 1 },
	 { "xine_exit", _wrap_xine_exit, 1 },
	 { "xine_close_video_driver", _wrap_xine_close_video_driver, 1 },
	 { "xine_close_audio_driver", _wrap_xine_close_audio_driver, 1 },
	 { "xine_open_video_driver", _wrap_xine_open_video_driver, 1 },
	 { "xine_open_audio_driver", _wrap_xine_open_audio_driver, 1 },
	 { "xine_init", _wrap_xine_init, 1 },
	 { "xine_new", _wrap_xine_new, 1 },
	 { "xine_check_version", _wrap_xine_check_version, 1 },
	 { "xine_get_version", _wrap_xine_get_version, 1 },
	 { "xine_get_version_string", _wrap_xine_get_version_string, 1 },
	 { "px_make_input_event", _wrap_px_make_input_event, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initlibxine)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("libxine", libxineMethods);
	 d = PyModule_GetDict(m);
 init_statics();
	 PyDict_SetItemString(d,"XINE_IMGFMT_YV12", PyInt_FromLong((long) (int)_XINE_IMGFMT_YV12));
	 PyDict_SetItemString(d,"XINE_IMGFMT_YUY2", PyInt_FromLong((long) (int)_XINE_IMGFMT_YUY2));
	 PyDict_SetItemString(d,"XINE_MAJOR_VERSION", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_MINOR_VERSION", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_SUB_VERSION", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_VERSION", PyString_FromString("1-beta4"));
	 PyDict_SetItemString(d,"XINE_VISUAL_TYPE_NONE", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_VISUAL_TYPE_X11", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_VISUAL_TYPE_AA", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_VISUAL_TYPE_FB", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_VISUAL_TYPE_GTK", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_VISUAL_TYPE_DFB", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"XINE_VISUAL_TYPE_PM", PyInt_FromLong((long) 6));
	 PyDict_SetItemString(d,"XINE_MASTER_SLAVE_PLAY", PyInt_FromLong((long) (1<<0)));
	 PyDict_SetItemString(d,"XINE_MASTER_SLAVE_STOP", PyInt_FromLong((long) (1<<1)));
	 PyDict_SetItemString(d,"XINE_TRICK_MODE_OFF", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_TRICK_MODE_SEEK_TO_POSITION", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_TRICK_MODE_SEEK_TO_TIME", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_TRICK_MODE_FAST_FORWARD", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_TRICK_MODE_FAST_REWIND", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_PARAM_SPEED", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_PARAM_AV_OFFSET", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_PARAM_AUDIO_CHANNEL_LOGICAL", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_PARAM_SPU_CHANNEL", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_PARAM_VIDEO_CHANNEL", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"XINE_PARAM_AUDIO_VOLUME", PyInt_FromLong((long) 6));
	 PyDict_SetItemString(d,"XINE_PARAM_AUDIO_MUTE", PyInt_FromLong((long) 7));
	 PyDict_SetItemString(d,"XINE_PARAM_AUDIO_COMPR_LEVEL", PyInt_FromLong((long) 8));
	 PyDict_SetItemString(d,"XINE_PARAM_AUDIO_AMP_LEVEL", PyInt_FromLong((long) 9));
	 PyDict_SetItemString(d,"XINE_PARAM_AUDIO_REPORT_LEVEL", PyInt_FromLong((long) 10));
	 PyDict_SetItemString(d,"XINE_PARAM_VERBOSITY", PyInt_FromLong((long) 11));
	 PyDict_SetItemString(d,"XINE_PARAM_SPU_OFFSET", PyInt_FromLong((long) 12));
	 PyDict_SetItemString(d,"XINE_SPEED_PAUSE", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_SPEED_SLOW_4", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_SPEED_SLOW_2", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_SPEED_NORMAL", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_SPEED_FAST_2", PyInt_FromLong((long) 8));
	 PyDict_SetItemString(d,"XINE_SPEED_FAST_4", PyInt_FromLong((long) 16));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_DEINTERLACE", PyInt_FromLong((long) 0x01000000));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_ASPECT_RATIO", PyInt_FromLong((long) 0x01000001));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_HUE", PyInt_FromLong((long) 0x01000002));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_SATURATION", PyInt_FromLong((long) 0x01000003));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_CONTRAST", PyInt_FromLong((long) 0x01000004));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_BRIGHTNESS", PyInt_FromLong((long) 0x01000005));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_ZOOM_X", PyInt_FromLong((long) 0x01000008));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_ZOOM_Y", PyInt_FromLong((long) 0x0100000d));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_PAN_SCAN", PyInt_FromLong((long) 0x01000009));
	 PyDict_SetItemString(d,"XINE_PARAM_VO_TVMODE", PyInt_FromLong((long) 0x0100000a));
	 PyDict_SetItemString(d,"XINE_VO_ZOOM_STEP", PyInt_FromLong((long) 100));
	 PyDict_SetItemString(d,"XINE_VO_ZOOM_MAX", PyInt_FromLong((long) 400));
	 PyDict_SetItemString(d,"XINE_VO_ZOOM_MIN", PyInt_FromLong((long) -85));
	 PyDict_SetItemString(d,"XINE_VO_ASPECT_AUTO", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_VO_ASPECT_SQUARE", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_VO_ASPECT_4_3", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_VO_ASPECT_ANAMORPHIC", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_VO_ASPECT_DVB", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_VO_ASPECT_NUM_RATIOS", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"XINE_VO_ASPECT_PAN_SCAN", PyInt_FromLong((long) 41));
	 PyDict_SetItemString(d,"XINE_VO_ASPECT_DONT_TOUCH", PyInt_FromLong((long) 42));
	 PyDict_SetItemString(d,"XINE_DEMUX_DEFAULT_STRATEGY", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_DEMUX_REVERT_STRATEGY", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_DEMUX_CONTENT_STRATEGY", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_DEMUX_EXTENSION_STRATEGY", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_POST_TYPE_VIDEO_FILTER", PyInt_FromLong((long) 0x010000));
	 PyDict_SetItemString(d,"XINE_POST_TYPE_VIDEO_VISUALIZATION", PyInt_FromLong((long) 0x010001));
	 PyDict_SetItemString(d,"XINE_POST_TYPE_AUDIO_FILTER", PyInt_FromLong((long) 0x020000));
	 PyDict_SetItemString(d,"XINE_POST_TYPE_AUDIO_VISUALIZATION", PyInt_FromLong((long) 0x020001));
	 PyDict_SetItemString(d,"XINE_POST_DATA_VIDEO", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_POST_DATA_AUDIO", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_POST_DATA_INT", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_POST_DATA_DOUBLE", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_STATUS_IDLE", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_STATUS_STOP", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_STATUS_PLAY", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_STATUS_QUIT", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_ERROR_NONE", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_ERROR_NO_INPUT_PLUGIN", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_ERROR_NO_DEMUX_PLUGIN", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_ERROR_DEMUX_FAILED", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_ERROR_MALFORMED_MRL", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_BITRATE", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_SEEKABLE", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_WIDTH", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_HEIGHT", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_RATIO", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_CHANNELS", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_STREAMS", PyInt_FromLong((long) 6));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_BITRATE", PyInt_FromLong((long) 7));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_FOURCC", PyInt_FromLong((long) 8));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_HANDLED", PyInt_FromLong((long) 9));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_FRAME_DURATION", PyInt_FromLong((long) 10));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_AUDIO_CHANNELS", PyInt_FromLong((long) 11));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_AUDIO_BITS", PyInt_FromLong((long) 12));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_AUDIO_SAMPLERATE", PyInt_FromLong((long) 13));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_AUDIO_BITRATE", PyInt_FromLong((long) 14));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_AUDIO_FOURCC", PyInt_FromLong((long) 15));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_AUDIO_HANDLED", PyInt_FromLong((long) 16));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_HAS_CHAPTERS", PyInt_FromLong((long) 17));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_HAS_VIDEO", PyInt_FromLong((long) 18));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_HAS_AUDIO", PyInt_FromLong((long) 19));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_IGNORE_VIDEO", PyInt_FromLong((long) 20));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_IGNORE_AUDIO", PyInt_FromLong((long) 21));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_IGNORE_SPU", PyInt_FromLong((long) 22));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_VIDEO_HAS_STILL", PyInt_FromLong((long) 23));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_MAX_AUDIO_CHANNEL", PyInt_FromLong((long) 24));
	 PyDict_SetItemString(d,"XINE_STREAM_INFO_MAX_SPU_CHANNEL", PyInt_FromLong((long) 25));
	 PyDict_SetItemString(d,"XINE_META_INFO_TITLE", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_META_INFO_COMMENT", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_META_INFO_ARTIST", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_META_INFO_GENRE", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_META_INFO_ALBUM", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_META_INFO_YEAR", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"XINE_META_INFO_VIDEOCODEC", PyInt_FromLong((long) 6));
	 PyDict_SetItemString(d,"XINE_META_INFO_AUDIOCODEC", PyInt_FromLong((long) 7));
	 PyDict_SetItemString(d,"XINE_META_INFO_SYSTEMLAYER", PyInt_FromLong((long) 8));
	 PyDict_SetItemString(d,"XINE_META_INFO_INPUT_PLUGIN", PyInt_FromLong((long) 9));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_unknown", PyInt_FromLong((long) (0<<0)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_dvd", PyInt_FromLong((long) (1<<0)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_vcd", PyInt_FromLong((long) (1<<1)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_net", PyInt_FromLong((long) (1<<2)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_rtp", PyInt_FromLong((long) (1<<3)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_stdin", PyInt_FromLong((long) (1<<4)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_cda", PyInt_FromLong((long) (1<<5)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file", PyInt_FromLong((long) (1<<6)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_fifo", PyInt_FromLong((long) (1<<7)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_chardev", PyInt_FromLong((long) (1<<8)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_directory", PyInt_FromLong((long) (1<<9)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_blockdev", PyInt_FromLong((long) (1<<10)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_normal", PyInt_FromLong((long) (1<<11)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_symlink", PyInt_FromLong((long) (1<<12)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_sock", PyInt_FromLong((long) (1<<13)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_exec", PyInt_FromLong((long) (1<<14)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_backup", PyInt_FromLong((long) (1<<15)));
	 PyDict_SetItemString(d,"XINE_MRL_TYPE_file_hidden", PyInt_FromLong((long) (1<<16)));
	 PyDict_SetItemString(d,"XINE_GUI_SEND_COMPLETION_EVENT", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_GUI_SEND_DRAWABLE_CHANGED", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_GUI_SEND_EXPOSE_EVENT", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_GUI_SEND_TRANSLATE_GUI_TO_VIDEO", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_GUI_SEND_VIDEOWIN_VISIBLE", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"XINE_GUI_SEND_SELECT_VISUAL", PyInt_FromLong((long) 8));
	 PyDict_SetItemString(d,"XINE_CONFIG_TYPE_UNKNOWN", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_CONFIG_TYPE_RANGE", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_CONFIG_TYPE_STRING", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_CONFIG_TYPE_ENUM", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_CONFIG_TYPE_NUM", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_CONFIG_TYPE_BOOL", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"XINE_EVENT_UI_PLAYBACK_FINISHED", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_EVENT_UI_CHANNELS_CHANGED", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_EVENT_UI_SET_TITLE", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"XINE_EVENT_UI_MESSAGE", PyInt_FromLong((long) 4));
	 PyDict_SetItemString(d,"XINE_EVENT_FRAME_FORMAT_CHANGE", PyInt_FromLong((long) 5));
	 PyDict_SetItemString(d,"XINE_EVENT_AUDIO_LEVEL", PyInt_FromLong((long) 6));
	 PyDict_SetItemString(d,"XINE_EVENT_QUIT", PyInt_FromLong((long) 7));
	 PyDict_SetItemString(d,"XINE_EVENT_PROGRESS", PyInt_FromLong((long) 8));
	 PyDict_SetItemString(d,"XINE_EVENT_MRL_REFERENCE", PyInt_FromLong((long) 9));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MOUSE_BUTTON", PyInt_FromLong((long) 101));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MOUSE_MOVE", PyInt_FromLong((long) 102));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MENU1", PyInt_FromLong((long) 103));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MENU2", PyInt_FromLong((long) 104));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MENU3", PyInt_FromLong((long) 105));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MENU4", PyInt_FromLong((long) 106));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MENU5", PyInt_FromLong((long) 107));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MENU6", PyInt_FromLong((long) 108));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_MENU7", PyInt_FromLong((long) 109));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_UP", PyInt_FromLong((long) 110));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_DOWN", PyInt_FromLong((long) 111));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_LEFT", PyInt_FromLong((long) 112));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_RIGHT", PyInt_FromLong((long) 113));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_SELECT", PyInt_FromLong((long) 114));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NEXT", PyInt_FromLong((long) 115));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_PREVIOUS", PyInt_FromLong((long) 116));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_ANGLE_NEXT", PyInt_FromLong((long) 117));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_ANGLE_PREVIOUS", PyInt_FromLong((long) 118));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_BUTTON_FORCE", PyInt_FromLong((long) 119));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_0", PyInt_FromLong((long) 120));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_1", PyInt_FromLong((long) 121));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_2", PyInt_FromLong((long) 122));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_3", PyInt_FromLong((long) 123));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_4", PyInt_FromLong((long) 124));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_5", PyInt_FromLong((long) 125));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_6", PyInt_FromLong((long) 126));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_7", PyInt_FromLong((long) 127));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_8", PyInt_FromLong((long) 128));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_9", PyInt_FromLong((long) 129));
	 PyDict_SetItemString(d,"XINE_EVENT_INPUT_NUMBER_10_ADD", PyInt_FromLong((long) 130));
	 PyDict_SetItemString(d,"XINE_TEXT_PALETTE_SIZE", PyInt_FromLong((long) 11));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT1", PyInt_FromLong((long) (0*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT2", PyInt_FromLong((long) (1*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT3", PyInt_FromLong((long) (2*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT4", PyInt_FromLong((long) (3*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT5", PyInt_FromLong((long) (4*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT6", PyInt_FromLong((long) (5*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT7", PyInt_FromLong((long) (6*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT8", PyInt_FromLong((long) (7*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT9", PyInt_FromLong((long) (8*(11))));
	 PyDict_SetItemString(d,"XINE_OSD_TEXT10", PyInt_FromLong((long) (9*(11))));
	 PyDict_SetItemString(d,"XINE_TEXTPALETTE_WHITE_BLACK_TRANSPARENT", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"XINE_TEXTPALETTE_WHITE_NONE_TRANSPARENT", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"XINE_TEXTPALETTE_WHITE_NONE_TRANSLUCID", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"XINE_TEXTPALETTE_YELLOW_BLACK_TRANSPARENT", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"xine_progress_data_t_description", PyString_FromString("xine_progress_data_t::description"));
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_int64_t",0);
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_xine_ao_driver_t","_xine_audio_port_t",0);
	 SWIG_RegisterMapping("_xine_ao_driver_t","_struct_xine_audio_port_s",0);
	 SWIG_RegisterMapping("_xine_post_in_s","_struct_xine_post_in_s",0);
	 SWIG_RegisterMapping("_xine_post_in_t","_struct_xine_post_in_s",0);
	 SWIG_RegisterMapping("_long","_int64_t",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_int64_t","_long",0);
	 SWIG_RegisterMapping("_int64_t","_signed_long",0);
	 SWIG_RegisterMapping("_int64_t","_unsigned_long",0);
	 SWIG_RegisterMapping("_uint32_t","_unsigned",0);
	 SWIG_RegisterMapping("_struct_xine_post_s","_xine_post_s",0);
	 SWIG_RegisterMapping("_struct_xine_post_s","_xine_post_t",0);
	 SWIG_RegisterMapping("_struct_xine_stream_s","_xine_stream_t",0);
	 SWIG_RegisterMapping("_struct_xine_event_queue_s","_xine_event_queue_t",0);
	 SWIG_RegisterMapping("_struct_xine_audio_port_s","_xine_ao_driver_t",0);
	 SWIG_RegisterMapping("_struct_xine_audio_port_s","_xine_audio_port_t",0);
	 SWIG_RegisterMapping("_struct_xine_video_port_s","_xine_vo_driver_t",0);
	 SWIG_RegisterMapping("_struct_xine_video_port_s","_xine_video_port_t",0);
	 SWIG_RegisterMapping("_xine_vo_driver_t","_xine_video_port_t",0);
	 SWIG_RegisterMapping("_xine_vo_driver_t","_struct_xine_video_port_s",0);
	 SWIG_RegisterMapping("_char_p","_STRING",0);
	 SWIG_RegisterMapping("_xine_event_queue_t","_struct_xine_event_queue_s",0);
	 SWIG_RegisterMapping("_struct_xine_s","_xine_t",0);
	 SWIG_RegisterMapping("_struct_xine_post_out_s","_xine_post_out_s",0);
	 SWIG_RegisterMapping("_struct_xine_post_out_s","_xine_post_out_t",0);
	 SWIG_RegisterMapping("_xine_post_out_s","_struct_xine_post_out_s",0);
	 SWIG_RegisterMapping("_xine_post_out_t","_struct_xine_post_out_s",0);
	 SWIG_RegisterMapping("_unsigned_long","_int64_t",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_uint16_t",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_uint8_t","_unsigned_char",0);
	 SWIG_RegisterMapping("_xine_osd_t","_struct_xine_osd_s",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_char","_uint8_t",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_uint16_t","_unsigned_short",0);
	 SWIG_RegisterMapping("_uint16_t","_short",0);
	 SWIG_RegisterMapping("_struct_xine_post_in_s","_xine_post_in_s",0);
	 SWIG_RegisterMapping("_struct_xine_post_in_s","_xine_post_in_t",0);
	 SWIG_RegisterMapping("_short","_uint16_t",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_xine_t","_struct_xine_s",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
	 SWIG_RegisterMapping("_xine_post_s","_struct_xine_post_s",0);
	 SWIG_RegisterMapping("_xine_post_t","_struct_xine_post_s",0);
	 SWIG_RegisterMapping("_struct_xine_osd_s","_xine_osd_t",0);
	 SWIG_RegisterMapping("_xine_stream_t","_struct_xine_stream_s",0);
	 SWIG_RegisterMapping("_STRING","_char_p",0);
	 SWIG_RegisterMapping("_struct_xine_cfg_entry_s","_xine_cfg_entry_s",0);
	 SWIG_RegisterMapping("_struct_xine_cfg_entry_s","_xine_cfg_entry_t",0);
	 SWIG_RegisterMapping("_unsigned","_uint32_t",0);
	 SWIG_RegisterMapping("_xine_audio_port_t","_xine_ao_driver_t",0);
	 SWIG_RegisterMapping("_xine_audio_port_t","_struct_xine_audio_port_s",0);
	 SWIG_RegisterMapping("_xine_video_port_t","_xine_vo_driver_t",0);
	 SWIG_RegisterMapping("_xine_video_port_t","_struct_xine_video_port_s",0);
	 SWIG_RegisterMapping("_xine_cfg_entry_s","_struct_xine_cfg_entry_s",0);
	 SWIG_RegisterMapping("_xine_cfg_entry_t","_struct_xine_cfg_entry_s",0);
}
