% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{BarcodeInflectionsPlot}
\alias{BarcodeInflectionsPlot}
\title{Plot the Barcode Distribution and Calculated Inflection Points}
\usage{
BarcodeInflectionsPlot(object)
}
\arguments{
\item{object}{Seurat object}
}
\value{
Returns a `ggplot2` object showing the by-group inflection points and provided
  (or default) rank threshold values in grey.
}
\description{
This function plots the calculated inflection points derived from the barcode-rank
distribution.
}
\details{
See [CalculateBarcodeInflections()] to calculate inflection points and
[SubsetByBarcodeInflections()] to subsequently subset the Seurat object.
}
\examples{
data("pbmc_small")
pbmc_small <- CalculateBarcodeInflections(pbmc_small, group.column = 'groups')
BarcodeInflectionsPlot(pbmc_small)

}
\seealso{
\code{\link{CalculateBarcodeInflections}} \code{\link{SubsetByBarcodeInflections}}
}
\author{
Robert A. Amezquita, \email{robert.amezquita@fredhutch.org}
}
\concept{visualization}
