# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.p6.

use Test;

plan 2000;

ok Uni.new(0x1E0A).NFD.list ~~ (0x0044, 0x0307,), '1E0A -> 0044 0307';
ok Uni.new(0x1E0C).NFD.list ~~ (0x0044, 0x0323,), '1E0C -> 0044 0323';
ok Uni.new(0x1E0A, 0x0323).NFD.list ~~ (0x0044, 0x0323, 0x0307,), '1E0A 0323 -> 0044 0323 0307';
ok Uni.new(0x1E0C, 0x0307).NFD.list ~~ (0x0044, 0x0323, 0x0307,), '1E0C 0307 -> 0044 0323 0307';
ok Uni.new(0x0044, 0x0307, 0x0323).NFD.list ~~ (0x0044, 0x0323, 0x0307,), '0044 0307 0323 -> 0044 0323 0307';
ok Uni.new(0x0044, 0x0323, 0x0307).NFD.list ~~ (0x0044, 0x0323, 0x0307,), '0044 0323 0307 -> 0044 0323 0307';
ok Uni.new(0x1E0A, 0x031B).NFD.list ~~ (0x0044, 0x031B, 0x0307,), '1E0A 031B -> 0044 031B 0307';
ok Uni.new(0x1E0C, 0x031B).NFD.list ~~ (0x0044, 0x031B, 0x0323,), '1E0C 031B -> 0044 031B 0323';
ok Uni.new(0x1E0A, 0x031B, 0x0323).NFD.list ~~ (0x0044, 0x031B, 0x0323, 0x0307,), '1E0A 031B 0323 -> 0044 031B 0323 0307';
ok Uni.new(0x1E0C, 0x031B, 0x0307).NFD.list ~~ (0x0044, 0x031B, 0x0323, 0x0307,), '1E0C 031B 0307 -> 0044 031B 0323 0307';
ok Uni.new(0x0044, 0x031B, 0x0307, 0x0323).NFD.list ~~ (0x0044, 0x031B, 0x0323, 0x0307,), '0044 031B 0307 0323 -> 0044 031B 0323 0307';
ok Uni.new(0x0044, 0x031B, 0x0323, 0x0307).NFD.list ~~ (0x0044, 0x031B, 0x0323, 0x0307,), '0044 031B 0323 0307 -> 0044 031B 0323 0307';
ok Uni.new(0x00C8).NFD.list ~~ (0x0045, 0x0300,), '00C8 -> 0045 0300';
ok Uni.new(0x0112).NFD.list ~~ (0x0045, 0x0304,), '0112 -> 0045 0304';
ok Uni.new(0x0045, 0x0300).NFD.list ~~ (0x0045, 0x0300,), '0045 0300 -> 0045 0300';
ok Uni.new(0x0045, 0x0304).NFD.list ~~ (0x0045, 0x0304,), '0045 0304 -> 0045 0304';
ok Uni.new(0x1E14).NFD.list ~~ (0x0045, 0x0304, 0x0300,), '1E14 -> 0045 0304 0300';
ok Uni.new(0x0112, 0x0300).NFD.list ~~ (0x0045, 0x0304, 0x0300,), '0112 0300 -> 0045 0304 0300';
ok Uni.new(0x1E14, 0x0304).NFD.list ~~ (0x0045, 0x0304, 0x0300, 0x0304,), '1E14 0304 -> 0045 0304 0300 0304';
ok Uni.new(0x0045, 0x0304, 0x0300).NFD.list ~~ (0x0045, 0x0304, 0x0300,), '0045 0304 0300 -> 0045 0304 0300';
ok Uni.new(0x0045, 0x0300, 0x0304).NFD.list ~~ (0x0045, 0x0300, 0x0304,), '0045 0300 0304 -> 0045 0300 0304';
ok Uni.new(0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F).NFD.list ~~ (0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F,), '05B8 05B9 05B1 0591 05C3 05B0 05AC 059F -> 05B1 05B8 05B9 0591 05C3 05B0 05AC 059F';
ok Uni.new(0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD).NFD.list ~~ (0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4,), '0592 05B7 05BC 05A5 05B0 05C0 05C4 05AD -> 05B0 05B7 05BC 05A5 0592 05C0 05AD 05C4';
ok Uni.new(0x00A0).NFD.list ~~ (0x00A0,), '00A0 -> 00A0';
ok Uni.new(0x00A8).NFD.list ~~ (0x00A8,), '00A8 -> 00A8';
ok Uni.new(0x00AA).NFD.list ~~ (0x00AA,), '00AA -> 00AA';
ok Uni.new(0x00AF).NFD.list ~~ (0x00AF,), '00AF -> 00AF';
ok Uni.new(0x00B2).NFD.list ~~ (0x00B2,), '00B2 -> 00B2';
ok Uni.new(0x00B3).NFD.list ~~ (0x00B3,), '00B3 -> 00B3';
ok Uni.new(0x00B4).NFD.list ~~ (0x00B4,), '00B4 -> 00B4';
ok Uni.new(0x00B5).NFD.list ~~ (0x00B5,), '00B5 -> 00B5';
ok Uni.new(0x00B8).NFD.list ~~ (0x00B8,), '00B8 -> 00B8';
ok Uni.new(0x00B9).NFD.list ~~ (0x00B9,), '00B9 -> 00B9';
ok Uni.new(0x00BA).NFD.list ~~ (0x00BA,), '00BA -> 00BA';
ok Uni.new(0x00BC).NFD.list ~~ (0x00BC,), '00BC -> 00BC';
ok Uni.new(0x00BD).NFD.list ~~ (0x00BD,), '00BD -> 00BD';
ok Uni.new(0x00BE).NFD.list ~~ (0x00BE,), '00BE -> 00BE';
ok Uni.new(0x00C0).NFD.list ~~ (0x0041, 0x0300,), '00C0 -> 0041 0300';
ok Uni.new(0x00C1).NFD.list ~~ (0x0041, 0x0301,), '00C1 -> 0041 0301';
ok Uni.new(0x00C2).NFD.list ~~ (0x0041, 0x0302,), '00C2 -> 0041 0302';
ok Uni.new(0x00C3).NFD.list ~~ (0x0041, 0x0303,), '00C3 -> 0041 0303';
ok Uni.new(0x00C4).NFD.list ~~ (0x0041, 0x0308,), '00C4 -> 0041 0308';
ok Uni.new(0x00C5).NFD.list ~~ (0x0041, 0x030A,), '00C5 -> 0041 030A';
ok Uni.new(0x00C7).NFD.list ~~ (0x0043, 0x0327,), '00C7 -> 0043 0327';
ok Uni.new(0x00C8).NFD.list ~~ (0x0045, 0x0300,), '00C8 -> 0045 0300';
ok Uni.new(0x00C9).NFD.list ~~ (0x0045, 0x0301,), '00C9 -> 0045 0301';
ok Uni.new(0x00CA).NFD.list ~~ (0x0045, 0x0302,), '00CA -> 0045 0302';
ok Uni.new(0x00CB).NFD.list ~~ (0x0045, 0x0308,), '00CB -> 0045 0308';
ok Uni.new(0x00CC).NFD.list ~~ (0x0049, 0x0300,), '00CC -> 0049 0300';
ok Uni.new(0x00CD).NFD.list ~~ (0x0049, 0x0301,), '00CD -> 0049 0301';
ok Uni.new(0x00CE).NFD.list ~~ (0x0049, 0x0302,), '00CE -> 0049 0302';
ok Uni.new(0x00CF).NFD.list ~~ (0x0049, 0x0308,), '00CF -> 0049 0308';
ok Uni.new(0x00D1).NFD.list ~~ (0x004E, 0x0303,), '00D1 -> 004E 0303';
ok Uni.new(0x00D2).NFD.list ~~ (0x004F, 0x0300,), '00D2 -> 004F 0300';
ok Uni.new(0x00D3).NFD.list ~~ (0x004F, 0x0301,), '00D3 -> 004F 0301';
ok Uni.new(0x00D4).NFD.list ~~ (0x004F, 0x0302,), '00D4 -> 004F 0302';
ok Uni.new(0x00D5).NFD.list ~~ (0x004F, 0x0303,), '00D5 -> 004F 0303';
ok Uni.new(0x00D6).NFD.list ~~ (0x004F, 0x0308,), '00D6 -> 004F 0308';
ok Uni.new(0x00D9).NFD.list ~~ (0x0055, 0x0300,), '00D9 -> 0055 0300';
ok Uni.new(0x00DA).NFD.list ~~ (0x0055, 0x0301,), '00DA -> 0055 0301';
ok Uni.new(0x00DB).NFD.list ~~ (0x0055, 0x0302,), '00DB -> 0055 0302';
ok Uni.new(0x00DC).NFD.list ~~ (0x0055, 0x0308,), '00DC -> 0055 0308';
ok Uni.new(0x00DD).NFD.list ~~ (0x0059, 0x0301,), '00DD -> 0059 0301';
ok Uni.new(0x00E0).NFD.list ~~ (0x0061, 0x0300,), '00E0 -> 0061 0300';
ok Uni.new(0x00E1).NFD.list ~~ (0x0061, 0x0301,), '00E1 -> 0061 0301';
ok Uni.new(0x00E2).NFD.list ~~ (0x0061, 0x0302,), '00E2 -> 0061 0302';
ok Uni.new(0x00E3).NFD.list ~~ (0x0061, 0x0303,), '00E3 -> 0061 0303';
ok Uni.new(0x00E4).NFD.list ~~ (0x0061, 0x0308,), '00E4 -> 0061 0308';
ok Uni.new(0x00E5).NFD.list ~~ (0x0061, 0x030A,), '00E5 -> 0061 030A';
ok Uni.new(0x00E7).NFD.list ~~ (0x0063, 0x0327,), '00E7 -> 0063 0327';
ok Uni.new(0x00E8).NFD.list ~~ (0x0065, 0x0300,), '00E8 -> 0065 0300';
ok Uni.new(0x00E9).NFD.list ~~ (0x0065, 0x0301,), '00E9 -> 0065 0301';
ok Uni.new(0x00EA).NFD.list ~~ (0x0065, 0x0302,), '00EA -> 0065 0302';
ok Uni.new(0x00EB).NFD.list ~~ (0x0065, 0x0308,), '00EB -> 0065 0308';
ok Uni.new(0x00EC).NFD.list ~~ (0x0069, 0x0300,), '00EC -> 0069 0300';
ok Uni.new(0x00ED).NFD.list ~~ (0x0069, 0x0301,), '00ED -> 0069 0301';
ok Uni.new(0x00EE).NFD.list ~~ (0x0069, 0x0302,), '00EE -> 0069 0302';
ok Uni.new(0x00EF).NFD.list ~~ (0x0069, 0x0308,), '00EF -> 0069 0308';
ok Uni.new(0x00F1).NFD.list ~~ (0x006E, 0x0303,), '00F1 -> 006E 0303';
ok Uni.new(0x00F2).NFD.list ~~ (0x006F, 0x0300,), '00F2 -> 006F 0300';
ok Uni.new(0x00F3).NFD.list ~~ (0x006F, 0x0301,), '00F3 -> 006F 0301';
ok Uni.new(0x00F4).NFD.list ~~ (0x006F, 0x0302,), '00F4 -> 006F 0302';
ok Uni.new(0x00F5).NFD.list ~~ (0x006F, 0x0303,), '00F5 -> 006F 0303';
ok Uni.new(0x00F6).NFD.list ~~ (0x006F, 0x0308,), '00F6 -> 006F 0308';
ok Uni.new(0x00F9).NFD.list ~~ (0x0075, 0x0300,), '00F9 -> 0075 0300';
ok Uni.new(0x00FA).NFD.list ~~ (0x0075, 0x0301,), '00FA -> 0075 0301';
ok Uni.new(0x00FB).NFD.list ~~ (0x0075, 0x0302,), '00FB -> 0075 0302';
ok Uni.new(0x00FC).NFD.list ~~ (0x0075, 0x0308,), '00FC -> 0075 0308';
ok Uni.new(0x00FD).NFD.list ~~ (0x0079, 0x0301,), '00FD -> 0079 0301';
ok Uni.new(0x00FF).NFD.list ~~ (0x0079, 0x0308,), '00FF -> 0079 0308';
ok Uni.new(0x0100).NFD.list ~~ (0x0041, 0x0304,), '0100 -> 0041 0304';
ok Uni.new(0x0101).NFD.list ~~ (0x0061, 0x0304,), '0101 -> 0061 0304';
ok Uni.new(0x0102).NFD.list ~~ (0x0041, 0x0306,), '0102 -> 0041 0306';
ok Uni.new(0x0103).NFD.list ~~ (0x0061, 0x0306,), '0103 -> 0061 0306';
ok Uni.new(0x0104).NFD.list ~~ (0x0041, 0x0328,), '0104 -> 0041 0328';
ok Uni.new(0x0105).NFD.list ~~ (0x0061, 0x0328,), '0105 -> 0061 0328';
ok Uni.new(0x0106).NFD.list ~~ (0x0043, 0x0301,), '0106 -> 0043 0301';
ok Uni.new(0x0107).NFD.list ~~ (0x0063, 0x0301,), '0107 -> 0063 0301';
ok Uni.new(0x0108).NFD.list ~~ (0x0043, 0x0302,), '0108 -> 0043 0302';
ok Uni.new(0x0109).NFD.list ~~ (0x0063, 0x0302,), '0109 -> 0063 0302';
ok Uni.new(0x010A).NFD.list ~~ (0x0043, 0x0307,), '010A -> 0043 0307';
ok Uni.new(0x010B).NFD.list ~~ (0x0063, 0x0307,), '010B -> 0063 0307';
ok Uni.new(0x010C).NFD.list ~~ (0x0043, 0x030C,), '010C -> 0043 030C';
ok Uni.new(0x010D).NFD.list ~~ (0x0063, 0x030C,), '010D -> 0063 030C';
ok Uni.new(0x010E).NFD.list ~~ (0x0044, 0x030C,), '010E -> 0044 030C';
ok Uni.new(0x010F).NFD.list ~~ (0x0064, 0x030C,), '010F -> 0064 030C';
ok Uni.new(0x0112).NFD.list ~~ (0x0045, 0x0304,), '0112 -> 0045 0304';
ok Uni.new(0x0113).NFD.list ~~ (0x0065, 0x0304,), '0113 -> 0065 0304';
ok Uni.new(0x0114).NFD.list ~~ (0x0045, 0x0306,), '0114 -> 0045 0306';
ok Uni.new(0x0115).NFD.list ~~ (0x0065, 0x0306,), '0115 -> 0065 0306';
ok Uni.new(0x0116).NFD.list ~~ (0x0045, 0x0307,), '0116 -> 0045 0307';
ok Uni.new(0x0117).NFD.list ~~ (0x0065, 0x0307,), '0117 -> 0065 0307';
ok Uni.new(0x0118).NFD.list ~~ (0x0045, 0x0328,), '0118 -> 0045 0328';
ok Uni.new(0x0119).NFD.list ~~ (0x0065, 0x0328,), '0119 -> 0065 0328';
ok Uni.new(0x011A).NFD.list ~~ (0x0045, 0x030C,), '011A -> 0045 030C';
ok Uni.new(0x011B).NFD.list ~~ (0x0065, 0x030C,), '011B -> 0065 030C';
ok Uni.new(0x011C).NFD.list ~~ (0x0047, 0x0302,), '011C -> 0047 0302';
ok Uni.new(0x011D).NFD.list ~~ (0x0067, 0x0302,), '011D -> 0067 0302';
ok Uni.new(0x011E).NFD.list ~~ (0x0047, 0x0306,), '011E -> 0047 0306';
ok Uni.new(0x011F).NFD.list ~~ (0x0067, 0x0306,), '011F -> 0067 0306';
ok Uni.new(0x0120).NFD.list ~~ (0x0047, 0x0307,), '0120 -> 0047 0307';
ok Uni.new(0x0121).NFD.list ~~ (0x0067, 0x0307,), '0121 -> 0067 0307';
ok Uni.new(0x0122).NFD.list ~~ (0x0047, 0x0327,), '0122 -> 0047 0327';
ok Uni.new(0x0123).NFD.list ~~ (0x0067, 0x0327,), '0123 -> 0067 0327';
ok Uni.new(0x0124).NFD.list ~~ (0x0048, 0x0302,), '0124 -> 0048 0302';
ok Uni.new(0x0125).NFD.list ~~ (0x0068, 0x0302,), '0125 -> 0068 0302';
ok Uni.new(0x0128).NFD.list ~~ (0x0049, 0x0303,), '0128 -> 0049 0303';
ok Uni.new(0x0129).NFD.list ~~ (0x0069, 0x0303,), '0129 -> 0069 0303';
ok Uni.new(0x012A).NFD.list ~~ (0x0049, 0x0304,), '012A -> 0049 0304';
ok Uni.new(0x012B).NFD.list ~~ (0x0069, 0x0304,), '012B -> 0069 0304';
ok Uni.new(0x012C).NFD.list ~~ (0x0049, 0x0306,), '012C -> 0049 0306';
ok Uni.new(0x012D).NFD.list ~~ (0x0069, 0x0306,), '012D -> 0069 0306';
ok Uni.new(0x012E).NFD.list ~~ (0x0049, 0x0328,), '012E -> 0049 0328';
ok Uni.new(0x012F).NFD.list ~~ (0x0069, 0x0328,), '012F -> 0069 0328';
ok Uni.new(0x0130).NFD.list ~~ (0x0049, 0x0307,), '0130 -> 0049 0307';
ok Uni.new(0x0132).NFD.list ~~ (0x0132,), '0132 -> 0132';
ok Uni.new(0x0133).NFD.list ~~ (0x0133,), '0133 -> 0133';
ok Uni.new(0x0134).NFD.list ~~ (0x004A, 0x0302,), '0134 -> 004A 0302';
ok Uni.new(0x0135).NFD.list ~~ (0x006A, 0x0302,), '0135 -> 006A 0302';
ok Uni.new(0x0136).NFD.list ~~ (0x004B, 0x0327,), '0136 -> 004B 0327';
ok Uni.new(0x0137).NFD.list ~~ (0x006B, 0x0327,), '0137 -> 006B 0327';
ok Uni.new(0x0139).NFD.list ~~ (0x004C, 0x0301,), '0139 -> 004C 0301';
ok Uni.new(0x013A).NFD.list ~~ (0x006C, 0x0301,), '013A -> 006C 0301';
ok Uni.new(0x013B).NFD.list ~~ (0x004C, 0x0327,), '013B -> 004C 0327';
ok Uni.new(0x013C).NFD.list ~~ (0x006C, 0x0327,), '013C -> 006C 0327';
ok Uni.new(0x013D).NFD.list ~~ (0x004C, 0x030C,), '013D -> 004C 030C';
ok Uni.new(0x013E).NFD.list ~~ (0x006C, 0x030C,), '013E -> 006C 030C';
ok Uni.new(0x013F).NFD.list ~~ (0x013F,), '013F -> 013F';
ok Uni.new(0x0140).NFD.list ~~ (0x0140,), '0140 -> 0140';
ok Uni.new(0x0143).NFD.list ~~ (0x004E, 0x0301,), '0143 -> 004E 0301';
ok Uni.new(0x0144).NFD.list ~~ (0x006E, 0x0301,), '0144 -> 006E 0301';
ok Uni.new(0x0145).NFD.list ~~ (0x004E, 0x0327,), '0145 -> 004E 0327';
ok Uni.new(0x0146).NFD.list ~~ (0x006E, 0x0327,), '0146 -> 006E 0327';
ok Uni.new(0x0147).NFD.list ~~ (0x004E, 0x030C,), '0147 -> 004E 030C';
ok Uni.new(0x0148).NFD.list ~~ (0x006E, 0x030C,), '0148 -> 006E 030C';
ok Uni.new(0x0149).NFD.list ~~ (0x0149,), '0149 -> 0149';
ok Uni.new(0x014C).NFD.list ~~ (0x004F, 0x0304,), '014C -> 004F 0304';
ok Uni.new(0x014D).NFD.list ~~ (0x006F, 0x0304,), '014D -> 006F 0304';
ok Uni.new(0x014E).NFD.list ~~ (0x004F, 0x0306,), '014E -> 004F 0306';
ok Uni.new(0x014F).NFD.list ~~ (0x006F, 0x0306,), '014F -> 006F 0306';
ok Uni.new(0x0150).NFD.list ~~ (0x004F, 0x030B,), '0150 -> 004F 030B';
ok Uni.new(0x0151).NFD.list ~~ (0x006F, 0x030B,), '0151 -> 006F 030B';
ok Uni.new(0x0154).NFD.list ~~ (0x0052, 0x0301,), '0154 -> 0052 0301';
ok Uni.new(0x0155).NFD.list ~~ (0x0072, 0x0301,), '0155 -> 0072 0301';
ok Uni.new(0x0156).NFD.list ~~ (0x0052, 0x0327,), '0156 -> 0052 0327';
ok Uni.new(0x0157).NFD.list ~~ (0x0072, 0x0327,), '0157 -> 0072 0327';
ok Uni.new(0x0158).NFD.list ~~ (0x0052, 0x030C,), '0158 -> 0052 030C';
ok Uni.new(0x0159).NFD.list ~~ (0x0072, 0x030C,), '0159 -> 0072 030C';
ok Uni.new(0x015A).NFD.list ~~ (0x0053, 0x0301,), '015A -> 0053 0301';
ok Uni.new(0x015B).NFD.list ~~ (0x0073, 0x0301,), '015B -> 0073 0301';
ok Uni.new(0x015C).NFD.list ~~ (0x0053, 0x0302,), '015C -> 0053 0302';
ok Uni.new(0x015D).NFD.list ~~ (0x0073, 0x0302,), '015D -> 0073 0302';
ok Uni.new(0x015E).NFD.list ~~ (0x0053, 0x0327,), '015E -> 0053 0327';
ok Uni.new(0x015F).NFD.list ~~ (0x0073, 0x0327,), '015F -> 0073 0327';
ok Uni.new(0x0160).NFD.list ~~ (0x0053, 0x030C,), '0160 -> 0053 030C';
ok Uni.new(0x0161).NFD.list ~~ (0x0073, 0x030C,), '0161 -> 0073 030C';
ok Uni.new(0x0162).NFD.list ~~ (0x0054, 0x0327,), '0162 -> 0054 0327';
ok Uni.new(0x0163).NFD.list ~~ (0x0074, 0x0327,), '0163 -> 0074 0327';
ok Uni.new(0x0164).NFD.list ~~ (0x0054, 0x030C,), '0164 -> 0054 030C';
ok Uni.new(0x0165).NFD.list ~~ (0x0074, 0x030C,), '0165 -> 0074 030C';
ok Uni.new(0x0168).NFD.list ~~ (0x0055, 0x0303,), '0168 -> 0055 0303';
ok Uni.new(0x0169).NFD.list ~~ (0x0075, 0x0303,), '0169 -> 0075 0303';
ok Uni.new(0x016A).NFD.list ~~ (0x0055, 0x0304,), '016A -> 0055 0304';
ok Uni.new(0x016B).NFD.list ~~ (0x0075, 0x0304,), '016B -> 0075 0304';
ok Uni.new(0x016C).NFD.list ~~ (0x0055, 0x0306,), '016C -> 0055 0306';
ok Uni.new(0x016D).NFD.list ~~ (0x0075, 0x0306,), '016D -> 0075 0306';
ok Uni.new(0x016E).NFD.list ~~ (0x0055, 0x030A,), '016E -> 0055 030A';
ok Uni.new(0x016F).NFD.list ~~ (0x0075, 0x030A,), '016F -> 0075 030A';
ok Uni.new(0x0170).NFD.list ~~ (0x0055, 0x030B,), '0170 -> 0055 030B';
ok Uni.new(0x0171).NFD.list ~~ (0x0075, 0x030B,), '0171 -> 0075 030B';
ok Uni.new(0x0172).NFD.list ~~ (0x0055, 0x0328,), '0172 -> 0055 0328';
ok Uni.new(0x0173).NFD.list ~~ (0x0075, 0x0328,), '0173 -> 0075 0328';
ok Uni.new(0x0174).NFD.list ~~ (0x0057, 0x0302,), '0174 -> 0057 0302';
ok Uni.new(0x0175).NFD.list ~~ (0x0077, 0x0302,), '0175 -> 0077 0302';
ok Uni.new(0x0176).NFD.list ~~ (0x0059, 0x0302,), '0176 -> 0059 0302';
ok Uni.new(0x0177).NFD.list ~~ (0x0079, 0x0302,), '0177 -> 0079 0302';
ok Uni.new(0x0178).NFD.list ~~ (0x0059, 0x0308,), '0178 -> 0059 0308';
ok Uni.new(0x0179).NFD.list ~~ (0x005A, 0x0301,), '0179 -> 005A 0301';
ok Uni.new(0x017A).NFD.list ~~ (0x007A, 0x0301,), '017A -> 007A 0301';
ok Uni.new(0x017B).NFD.list ~~ (0x005A, 0x0307,), '017B -> 005A 0307';
ok Uni.new(0x017C).NFD.list ~~ (0x007A, 0x0307,), '017C -> 007A 0307';
ok Uni.new(0x017D).NFD.list ~~ (0x005A, 0x030C,), '017D -> 005A 030C';
ok Uni.new(0x017E).NFD.list ~~ (0x007A, 0x030C,), '017E -> 007A 030C';
ok Uni.new(0x017F).NFD.list ~~ (0x017F,), '017F -> 017F';
ok Uni.new(0x01A0).NFD.list ~~ (0x004F, 0x031B,), '01A0 -> 004F 031B';
ok Uni.new(0x01A1).NFD.list ~~ (0x006F, 0x031B,), '01A1 -> 006F 031B';
ok Uni.new(0x01AF).NFD.list ~~ (0x0055, 0x031B,), '01AF -> 0055 031B';
ok Uni.new(0x01B0).NFD.list ~~ (0x0075, 0x031B,), '01B0 -> 0075 031B';
ok Uni.new(0x01C4).NFD.list ~~ (0x01C4,), '01C4 -> 01C4';
ok Uni.new(0x01C5).NFD.list ~~ (0x01C5,), '01C5 -> 01C5';
ok Uni.new(0x01C6).NFD.list ~~ (0x01C6,), '01C6 -> 01C6';
ok Uni.new(0x01C7).NFD.list ~~ (0x01C7,), '01C7 -> 01C7';
ok Uni.new(0x01C8).NFD.list ~~ (0x01C8,), '01C8 -> 01C8';
ok Uni.new(0x01C9).NFD.list ~~ (0x01C9,), '01C9 -> 01C9';
ok Uni.new(0x01CA).NFD.list ~~ (0x01CA,), '01CA -> 01CA';
ok Uni.new(0x01CB).NFD.list ~~ (0x01CB,), '01CB -> 01CB';
ok Uni.new(0x01CC).NFD.list ~~ (0x01CC,), '01CC -> 01CC';
ok Uni.new(0x01CD).NFD.list ~~ (0x0041, 0x030C,), '01CD -> 0041 030C';
ok Uni.new(0x01CE).NFD.list ~~ (0x0061, 0x030C,), '01CE -> 0061 030C';
ok Uni.new(0x01CF).NFD.list ~~ (0x0049, 0x030C,), '01CF -> 0049 030C';
ok Uni.new(0x01D0).NFD.list ~~ (0x0069, 0x030C,), '01D0 -> 0069 030C';
ok Uni.new(0x01D1).NFD.list ~~ (0x004F, 0x030C,), '01D1 -> 004F 030C';
ok Uni.new(0x01D2).NFD.list ~~ (0x006F, 0x030C,), '01D2 -> 006F 030C';
ok Uni.new(0x01D3).NFD.list ~~ (0x0055, 0x030C,), '01D3 -> 0055 030C';
ok Uni.new(0x01D4).NFD.list ~~ (0x0075, 0x030C,), '01D4 -> 0075 030C';
ok Uni.new(0x01D5).NFD.list ~~ (0x0055, 0x0308, 0x0304,), '01D5 -> 0055 0308 0304';
ok Uni.new(0x01D6).NFD.list ~~ (0x0075, 0x0308, 0x0304,), '01D6 -> 0075 0308 0304';
ok Uni.new(0x01D7).NFD.list ~~ (0x0055, 0x0308, 0x0301,), '01D7 -> 0055 0308 0301';
ok Uni.new(0x01D8).NFD.list ~~ (0x0075, 0x0308, 0x0301,), '01D8 -> 0075 0308 0301';
ok Uni.new(0x01D9).NFD.list ~~ (0x0055, 0x0308, 0x030C,), '01D9 -> 0055 0308 030C';
ok Uni.new(0x01DA).NFD.list ~~ (0x0075, 0x0308, 0x030C,), '01DA -> 0075 0308 030C';
ok Uni.new(0x01DB).NFD.list ~~ (0x0055, 0x0308, 0x0300,), '01DB -> 0055 0308 0300';
ok Uni.new(0x01DC).NFD.list ~~ (0x0075, 0x0308, 0x0300,), '01DC -> 0075 0308 0300';
ok Uni.new(0x01DE).NFD.list ~~ (0x0041, 0x0308, 0x0304,), '01DE -> 0041 0308 0304';
ok Uni.new(0x01DF).NFD.list ~~ (0x0061, 0x0308, 0x0304,), '01DF -> 0061 0308 0304';
ok Uni.new(0x01E0).NFD.list ~~ (0x0041, 0x0307, 0x0304,), '01E0 -> 0041 0307 0304';
ok Uni.new(0x01E1).NFD.list ~~ (0x0061, 0x0307, 0x0304,), '01E1 -> 0061 0307 0304';
ok Uni.new(0x01E2).NFD.list ~~ (0x00C6, 0x0304,), '01E2 -> 00C6 0304';
ok Uni.new(0x01E3).NFD.list ~~ (0x00E6, 0x0304,), '01E3 -> 00E6 0304';
ok Uni.new(0x01E6).NFD.list ~~ (0x0047, 0x030C,), '01E6 -> 0047 030C';
ok Uni.new(0x01E7).NFD.list ~~ (0x0067, 0x030C,), '01E7 -> 0067 030C';
ok Uni.new(0x01E8).NFD.list ~~ (0x004B, 0x030C,), '01E8 -> 004B 030C';
ok Uni.new(0x01E9).NFD.list ~~ (0x006B, 0x030C,), '01E9 -> 006B 030C';
ok Uni.new(0x01EA).NFD.list ~~ (0x004F, 0x0328,), '01EA -> 004F 0328';
ok Uni.new(0x01EB).NFD.list ~~ (0x006F, 0x0328,), '01EB -> 006F 0328';
ok Uni.new(0x01EC).NFD.list ~~ (0x004F, 0x0328, 0x0304,), '01EC -> 004F 0328 0304';
ok Uni.new(0x01ED).NFD.list ~~ (0x006F, 0x0328, 0x0304,), '01ED -> 006F 0328 0304';
ok Uni.new(0x01EE).NFD.list ~~ (0x01B7, 0x030C,), '01EE -> 01B7 030C';
ok Uni.new(0x01EF).NFD.list ~~ (0x0292, 0x030C,), '01EF -> 0292 030C';
ok Uni.new(0x01F0).NFD.list ~~ (0x006A, 0x030C,), '01F0 -> 006A 030C';
ok Uni.new(0x01F1).NFD.list ~~ (0x01F1,), '01F1 -> 01F1';
ok Uni.new(0x01F2).NFD.list ~~ (0x01F2,), '01F2 -> 01F2';
ok Uni.new(0x01F3).NFD.list ~~ (0x01F3,), '01F3 -> 01F3';
ok Uni.new(0x01F4).NFD.list ~~ (0x0047, 0x0301,), '01F4 -> 0047 0301';
ok Uni.new(0x01F5).NFD.list ~~ (0x0067, 0x0301,), '01F5 -> 0067 0301';
ok Uni.new(0x01F8).NFD.list ~~ (0x004E, 0x0300,), '01F8 -> 004E 0300';
ok Uni.new(0x01F9).NFD.list ~~ (0x006E, 0x0300,), '01F9 -> 006E 0300';
ok Uni.new(0x01FA).NFD.list ~~ (0x0041, 0x030A, 0x0301,), '01FA -> 0041 030A 0301';
ok Uni.new(0x01FB).NFD.list ~~ (0x0061, 0x030A, 0x0301,), '01FB -> 0061 030A 0301';
ok Uni.new(0x01FC).NFD.list ~~ (0x00C6, 0x0301,), '01FC -> 00C6 0301';
ok Uni.new(0x01FD).NFD.list ~~ (0x00E6, 0x0301,), '01FD -> 00E6 0301';
ok Uni.new(0x01FE).NFD.list ~~ (0x00D8, 0x0301,), '01FE -> 00D8 0301';
ok Uni.new(0x01FF).NFD.list ~~ (0x00F8, 0x0301,), '01FF -> 00F8 0301';
ok Uni.new(0x0200).NFD.list ~~ (0x0041, 0x030F,), '0200 -> 0041 030F';
ok Uni.new(0x0201).NFD.list ~~ (0x0061, 0x030F,), '0201 -> 0061 030F';
ok Uni.new(0x0202).NFD.list ~~ (0x0041, 0x0311,), '0202 -> 0041 0311';
ok Uni.new(0x0203).NFD.list ~~ (0x0061, 0x0311,), '0203 -> 0061 0311';
ok Uni.new(0x0204).NFD.list ~~ (0x0045, 0x030F,), '0204 -> 0045 030F';
ok Uni.new(0x0205).NFD.list ~~ (0x0065, 0x030F,), '0205 -> 0065 030F';
ok Uni.new(0x0206).NFD.list ~~ (0x0045, 0x0311,), '0206 -> 0045 0311';
ok Uni.new(0x0207).NFD.list ~~ (0x0065, 0x0311,), '0207 -> 0065 0311';
ok Uni.new(0x0208).NFD.list ~~ (0x0049, 0x030F,), '0208 -> 0049 030F';
ok Uni.new(0x0209).NFD.list ~~ (0x0069, 0x030F,), '0209 -> 0069 030F';
ok Uni.new(0x020A).NFD.list ~~ (0x0049, 0x0311,), '020A -> 0049 0311';
ok Uni.new(0x020B).NFD.list ~~ (0x0069, 0x0311,), '020B -> 0069 0311';
ok Uni.new(0x020C).NFD.list ~~ (0x004F, 0x030F,), '020C -> 004F 030F';
ok Uni.new(0x020D).NFD.list ~~ (0x006F, 0x030F,), '020D -> 006F 030F';
ok Uni.new(0x020E).NFD.list ~~ (0x004F, 0x0311,), '020E -> 004F 0311';
ok Uni.new(0x020F).NFD.list ~~ (0x006F, 0x0311,), '020F -> 006F 0311';
ok Uni.new(0x0210).NFD.list ~~ (0x0052, 0x030F,), '0210 -> 0052 030F';
ok Uni.new(0x0211).NFD.list ~~ (0x0072, 0x030F,), '0211 -> 0072 030F';
ok Uni.new(0x0212).NFD.list ~~ (0x0052, 0x0311,), '0212 -> 0052 0311';
ok Uni.new(0x0213).NFD.list ~~ (0x0072, 0x0311,), '0213 -> 0072 0311';
ok Uni.new(0x0214).NFD.list ~~ (0x0055, 0x030F,), '0214 -> 0055 030F';
ok Uni.new(0x0215).NFD.list ~~ (0x0075, 0x030F,), '0215 -> 0075 030F';
ok Uni.new(0x0216).NFD.list ~~ (0x0055, 0x0311,), '0216 -> 0055 0311';
ok Uni.new(0x0217).NFD.list ~~ (0x0075, 0x0311,), '0217 -> 0075 0311';
ok Uni.new(0x0218).NFD.list ~~ (0x0053, 0x0326,), '0218 -> 0053 0326';
ok Uni.new(0x0219).NFD.list ~~ (0x0073, 0x0326,), '0219 -> 0073 0326';
ok Uni.new(0x021A).NFD.list ~~ (0x0054, 0x0326,), '021A -> 0054 0326';
ok Uni.new(0x021B).NFD.list ~~ (0x0074, 0x0326,), '021B -> 0074 0326';
ok Uni.new(0x021E).NFD.list ~~ (0x0048, 0x030C,), '021E -> 0048 030C';
ok Uni.new(0x021F).NFD.list ~~ (0x0068, 0x030C,), '021F -> 0068 030C';
ok Uni.new(0x0226).NFD.list ~~ (0x0041, 0x0307,), '0226 -> 0041 0307';
ok Uni.new(0x0227).NFD.list ~~ (0x0061, 0x0307,), '0227 -> 0061 0307';
ok Uni.new(0x0228).NFD.list ~~ (0x0045, 0x0327,), '0228 -> 0045 0327';
ok Uni.new(0x0229).NFD.list ~~ (0x0065, 0x0327,), '0229 -> 0065 0327';
ok Uni.new(0x022A).NFD.list ~~ (0x004F, 0x0308, 0x0304,), '022A -> 004F 0308 0304';
ok Uni.new(0x022B).NFD.list ~~ (0x006F, 0x0308, 0x0304,), '022B -> 006F 0308 0304';
ok Uni.new(0x022C).NFD.list ~~ (0x004F, 0x0303, 0x0304,), '022C -> 004F 0303 0304';
ok Uni.new(0x022D).NFD.list ~~ (0x006F, 0x0303, 0x0304,), '022D -> 006F 0303 0304';
ok Uni.new(0x022E).NFD.list ~~ (0x004F, 0x0307,), '022E -> 004F 0307';
ok Uni.new(0x022F).NFD.list ~~ (0x006F, 0x0307,), '022F -> 006F 0307';
ok Uni.new(0x0230).NFD.list ~~ (0x004F, 0x0307, 0x0304,), '0230 -> 004F 0307 0304';
ok Uni.new(0x0231).NFD.list ~~ (0x006F, 0x0307, 0x0304,), '0231 -> 006F 0307 0304';
ok Uni.new(0x0232).NFD.list ~~ (0x0059, 0x0304,), '0232 -> 0059 0304';
ok Uni.new(0x0233).NFD.list ~~ (0x0079, 0x0304,), '0233 -> 0079 0304';
ok Uni.new(0x02B0).NFD.list ~~ (0x02B0,), '02B0 -> 02B0';
ok Uni.new(0x02B1).NFD.list ~~ (0x02B1,), '02B1 -> 02B1';
ok Uni.new(0x02B2).NFD.list ~~ (0x02B2,), '02B2 -> 02B2';
ok Uni.new(0x02B3).NFD.list ~~ (0x02B3,), '02B3 -> 02B3';
ok Uni.new(0x02B4).NFD.list ~~ (0x02B4,), '02B4 -> 02B4';
ok Uni.new(0x02B5).NFD.list ~~ (0x02B5,), '02B5 -> 02B5';
ok Uni.new(0x02B6).NFD.list ~~ (0x02B6,), '02B6 -> 02B6';
ok Uni.new(0x02B7).NFD.list ~~ (0x02B7,), '02B7 -> 02B7';
ok Uni.new(0x02B8).NFD.list ~~ (0x02B8,), '02B8 -> 02B8';
ok Uni.new(0x02D8).NFD.list ~~ (0x02D8,), '02D8 -> 02D8';
ok Uni.new(0x02D9).NFD.list ~~ (0x02D9,), '02D9 -> 02D9';
ok Uni.new(0x02DA).NFD.list ~~ (0x02DA,), '02DA -> 02DA';
ok Uni.new(0x02DB).NFD.list ~~ (0x02DB,), '02DB -> 02DB';
ok Uni.new(0x02DC).NFD.list ~~ (0x02DC,), '02DC -> 02DC';
ok Uni.new(0x02DD).NFD.list ~~ (0x02DD,), '02DD -> 02DD';
ok Uni.new(0x02E0).NFD.list ~~ (0x02E0,), '02E0 -> 02E0';
ok Uni.new(0x02E1).NFD.list ~~ (0x02E1,), '02E1 -> 02E1';
ok Uni.new(0x02E2).NFD.list ~~ (0x02E2,), '02E2 -> 02E2';
ok Uni.new(0x02E3).NFD.list ~~ (0x02E3,), '02E3 -> 02E3';
ok Uni.new(0x02E4).NFD.list ~~ (0x02E4,), '02E4 -> 02E4';
ok Uni.new(0x0340).NFD.list ~~ (0x0300,), '0340 -> 0300';
ok Uni.new(0x0341).NFD.list ~~ (0x0301,), '0341 -> 0301';
ok Uni.new(0x0343).NFD.list ~~ (0x0313,), '0343 -> 0313';
ok Uni.new(0x0344).NFD.list ~~ (0x0308, 0x0301,), '0344 -> 0308 0301';
ok Uni.new(0x0374).NFD.list ~~ (0x02B9,), '0374 -> 02B9';
ok Uni.new(0x037A).NFD.list ~~ (0x037A,), '037A -> 037A';
ok Uni.new(0x037E).NFD.list ~~ (0x003B,), '037E -> 003B';
ok Uni.new(0x0384).NFD.list ~~ (0x0384,), '0384 -> 0384';
ok Uni.new(0x0385).NFD.list ~~ (0x00A8, 0x0301,), '0385 -> 00A8 0301';
ok Uni.new(0x0386).NFD.list ~~ (0x0391, 0x0301,), '0386 -> 0391 0301';
ok Uni.new(0x0387).NFD.list ~~ (0x00B7,), '0387 -> 00B7';
ok Uni.new(0x0388).NFD.list ~~ (0x0395, 0x0301,), '0388 -> 0395 0301';
ok Uni.new(0x0389).NFD.list ~~ (0x0397, 0x0301,), '0389 -> 0397 0301';
ok Uni.new(0x038A).NFD.list ~~ (0x0399, 0x0301,), '038A -> 0399 0301';
ok Uni.new(0x038C).NFD.list ~~ (0x039F, 0x0301,), '038C -> 039F 0301';
ok Uni.new(0x038E).NFD.list ~~ (0x03A5, 0x0301,), '038E -> 03A5 0301';
ok Uni.new(0x038F).NFD.list ~~ (0x03A9, 0x0301,), '038F -> 03A9 0301';
ok Uni.new(0x0390).NFD.list ~~ (0x03B9, 0x0308, 0x0301,), '0390 -> 03B9 0308 0301';
ok Uni.new(0x03AA).NFD.list ~~ (0x0399, 0x0308,), '03AA -> 0399 0308';
ok Uni.new(0x03AB).NFD.list ~~ (0x03A5, 0x0308,), '03AB -> 03A5 0308';
ok Uni.new(0x03AC).NFD.list ~~ (0x03B1, 0x0301,), '03AC -> 03B1 0301';
ok Uni.new(0x03AD).NFD.list ~~ (0x03B5, 0x0301,), '03AD -> 03B5 0301';
ok Uni.new(0x03AE).NFD.list ~~ (0x03B7, 0x0301,), '03AE -> 03B7 0301';
ok Uni.new(0x03AF).NFD.list ~~ (0x03B9, 0x0301,), '03AF -> 03B9 0301';
ok Uni.new(0x03B0).NFD.list ~~ (0x03C5, 0x0308, 0x0301,), '03B0 -> 03C5 0308 0301';
ok Uni.new(0x03CA).NFD.list ~~ (0x03B9, 0x0308,), '03CA -> 03B9 0308';
ok Uni.new(0x03CB).NFD.list ~~ (0x03C5, 0x0308,), '03CB -> 03C5 0308';
ok Uni.new(0x03CC).NFD.list ~~ (0x03BF, 0x0301,), '03CC -> 03BF 0301';
ok Uni.new(0x03CD).NFD.list ~~ (0x03C5, 0x0301,), '03CD -> 03C5 0301';
ok Uni.new(0x03CE).NFD.list ~~ (0x03C9, 0x0301,), '03CE -> 03C9 0301';
ok Uni.new(0x03D0).NFD.list ~~ (0x03D0,), '03D0 -> 03D0';
ok Uni.new(0x03D1).NFD.list ~~ (0x03D1,), '03D1 -> 03D1';
ok Uni.new(0x03D2).NFD.list ~~ (0x03D2,), '03D2 -> 03D2';
ok Uni.new(0x03D3).NFD.list ~~ (0x03D2, 0x0301,), '03D3 -> 03D2 0301';
ok Uni.new(0x03D4).NFD.list ~~ (0x03D2, 0x0308,), '03D4 -> 03D2 0308';
ok Uni.new(0x03D5).NFD.list ~~ (0x03D5,), '03D5 -> 03D5';
ok Uni.new(0x03D6).NFD.list ~~ (0x03D6,), '03D6 -> 03D6';
ok Uni.new(0x03F0).NFD.list ~~ (0x03F0,), '03F0 -> 03F0';
ok Uni.new(0x03F1).NFD.list ~~ (0x03F1,), '03F1 -> 03F1';
ok Uni.new(0x03F2).NFD.list ~~ (0x03F2,), '03F2 -> 03F2';
ok Uni.new(0x03F4).NFD.list ~~ (0x03F4,), '03F4 -> 03F4';
ok Uni.new(0x03F5).NFD.list ~~ (0x03F5,), '03F5 -> 03F5';
ok Uni.new(0x03F9).NFD.list ~~ (0x03F9,), '03F9 -> 03F9';
ok Uni.new(0x0400).NFD.list ~~ (0x0415, 0x0300,), '0400 -> 0415 0300';
ok Uni.new(0x0401).NFD.list ~~ (0x0415, 0x0308,), '0401 -> 0415 0308';
ok Uni.new(0x0403).NFD.list ~~ (0x0413, 0x0301,), '0403 -> 0413 0301';
ok Uni.new(0x0407).NFD.list ~~ (0x0406, 0x0308,), '0407 -> 0406 0308';
ok Uni.new(0x040C).NFD.list ~~ (0x041A, 0x0301,), '040C -> 041A 0301';
ok Uni.new(0x040D).NFD.list ~~ (0x0418, 0x0300,), '040D -> 0418 0300';
ok Uni.new(0x040E).NFD.list ~~ (0x0423, 0x0306,), '040E -> 0423 0306';
ok Uni.new(0x0419).NFD.list ~~ (0x0418, 0x0306,), '0419 -> 0418 0306';
ok Uni.new(0x0439).NFD.list ~~ (0x0438, 0x0306,), '0439 -> 0438 0306';
ok Uni.new(0x0450).NFD.list ~~ (0x0435, 0x0300,), '0450 -> 0435 0300';
ok Uni.new(0x0451).NFD.list ~~ (0x0435, 0x0308,), '0451 -> 0435 0308';
ok Uni.new(0x0453).NFD.list ~~ (0x0433, 0x0301,), '0453 -> 0433 0301';
ok Uni.new(0x0457).NFD.list ~~ (0x0456, 0x0308,), '0457 -> 0456 0308';
ok Uni.new(0x045C).NFD.list ~~ (0x043A, 0x0301,), '045C -> 043A 0301';
ok Uni.new(0x045D).NFD.list ~~ (0x0438, 0x0300,), '045D -> 0438 0300';
ok Uni.new(0x045E).NFD.list ~~ (0x0443, 0x0306,), '045E -> 0443 0306';
ok Uni.new(0x0476).NFD.list ~~ (0x0474, 0x030F,), '0476 -> 0474 030F';
ok Uni.new(0x0477).NFD.list ~~ (0x0475, 0x030F,), '0477 -> 0475 030F';
ok Uni.new(0x04C1).NFD.list ~~ (0x0416, 0x0306,), '04C1 -> 0416 0306';
ok Uni.new(0x04C2).NFD.list ~~ (0x0436, 0x0306,), '04C2 -> 0436 0306';
ok Uni.new(0x04D0).NFD.list ~~ (0x0410, 0x0306,), '04D0 -> 0410 0306';
ok Uni.new(0x04D1).NFD.list ~~ (0x0430, 0x0306,), '04D1 -> 0430 0306';
ok Uni.new(0x04D2).NFD.list ~~ (0x0410, 0x0308,), '04D2 -> 0410 0308';
ok Uni.new(0x04D3).NFD.list ~~ (0x0430, 0x0308,), '04D3 -> 0430 0308';
ok Uni.new(0x04D6).NFD.list ~~ (0x0415, 0x0306,), '04D6 -> 0415 0306';
ok Uni.new(0x04D7).NFD.list ~~ (0x0435, 0x0306,), '04D7 -> 0435 0306';
ok Uni.new(0x04DA).NFD.list ~~ (0x04D8, 0x0308,), '04DA -> 04D8 0308';
ok Uni.new(0x04DB).NFD.list ~~ (0x04D9, 0x0308,), '04DB -> 04D9 0308';
ok Uni.new(0x04DC).NFD.list ~~ (0x0416, 0x0308,), '04DC -> 0416 0308';
ok Uni.new(0x04DD).NFD.list ~~ (0x0436, 0x0308,), '04DD -> 0436 0308';
ok Uni.new(0x04DE).NFD.list ~~ (0x0417, 0x0308,), '04DE -> 0417 0308';
ok Uni.new(0x04DF).NFD.list ~~ (0x0437, 0x0308,), '04DF -> 0437 0308';
ok Uni.new(0x04E2).NFD.list ~~ (0x0418, 0x0304,), '04E2 -> 0418 0304';
ok Uni.new(0x04E3).NFD.list ~~ (0x0438, 0x0304,), '04E3 -> 0438 0304';
ok Uni.new(0x04E4).NFD.list ~~ (0x0418, 0x0308,), '04E4 -> 0418 0308';
ok Uni.new(0x04E5).NFD.list ~~ (0x0438, 0x0308,), '04E5 -> 0438 0308';
ok Uni.new(0x04E6).NFD.list ~~ (0x041E, 0x0308,), '04E6 -> 041E 0308';
ok Uni.new(0x04E7).NFD.list ~~ (0x043E, 0x0308,), '04E7 -> 043E 0308';
ok Uni.new(0x04EA).NFD.list ~~ (0x04E8, 0x0308,), '04EA -> 04E8 0308';
ok Uni.new(0x04EB).NFD.list ~~ (0x04E9, 0x0308,), '04EB -> 04E9 0308';
ok Uni.new(0x04EC).NFD.list ~~ (0x042D, 0x0308,), '04EC -> 042D 0308';
ok Uni.new(0x04ED).NFD.list ~~ (0x044D, 0x0308,), '04ED -> 044D 0308';
ok Uni.new(0x04EE).NFD.list ~~ (0x0423, 0x0304,), '04EE -> 0423 0304';
ok Uni.new(0x04EF).NFD.list ~~ (0x0443, 0x0304,), '04EF -> 0443 0304';
ok Uni.new(0x04F0).NFD.list ~~ (0x0423, 0x0308,), '04F0 -> 0423 0308';
ok Uni.new(0x04F1).NFD.list ~~ (0x0443, 0x0308,), '04F1 -> 0443 0308';
ok Uni.new(0x04F2).NFD.list ~~ (0x0423, 0x030B,), '04F2 -> 0423 030B';
ok Uni.new(0x04F3).NFD.list ~~ (0x0443, 0x030B,), '04F3 -> 0443 030B';
ok Uni.new(0x04F4).NFD.list ~~ (0x0427, 0x0308,), '04F4 -> 0427 0308';
ok Uni.new(0x04F5).NFD.list ~~ (0x0447, 0x0308,), '04F5 -> 0447 0308';
ok Uni.new(0x04F8).NFD.list ~~ (0x042B, 0x0308,), '04F8 -> 042B 0308';
ok Uni.new(0x04F9).NFD.list ~~ (0x044B, 0x0308,), '04F9 -> 044B 0308';
ok Uni.new(0x0587).NFD.list ~~ (0x0587,), '0587 -> 0587';
ok Uni.new(0x0622).NFD.list ~~ (0x0627, 0x0653,), '0622 -> 0627 0653';
ok Uni.new(0x0623).NFD.list ~~ (0x0627, 0x0654,), '0623 -> 0627 0654';
ok Uni.new(0x0624).NFD.list ~~ (0x0648, 0x0654,), '0624 -> 0648 0654';
ok Uni.new(0x0625).NFD.list ~~ (0x0627, 0x0655,), '0625 -> 0627 0655';
ok Uni.new(0x0626).NFD.list ~~ (0x064A, 0x0654,), '0626 -> 064A 0654';
ok Uni.new(0x0675).NFD.list ~~ (0x0675,), '0675 -> 0675';
ok Uni.new(0x0676).NFD.list ~~ (0x0676,), '0676 -> 0676';
ok Uni.new(0x0677).NFD.list ~~ (0x0677,), '0677 -> 0677';
ok Uni.new(0x0678).NFD.list ~~ (0x0678,), '0678 -> 0678';
ok Uni.new(0x06C0).NFD.list ~~ (0x06D5, 0x0654,), '06C0 -> 06D5 0654';
ok Uni.new(0x06C2).NFD.list ~~ (0x06C1, 0x0654,), '06C2 -> 06C1 0654';
ok Uni.new(0x06D3).NFD.list ~~ (0x06D2, 0x0654,), '06D3 -> 06D2 0654';
ok Uni.new(0x0929).NFD.list ~~ (0x0928, 0x093C,), '0929 -> 0928 093C';
ok Uni.new(0x0931).NFD.list ~~ (0x0930, 0x093C,), '0931 -> 0930 093C';
ok Uni.new(0x0934).NFD.list ~~ (0x0933, 0x093C,), '0934 -> 0933 093C';
ok Uni.new(0x0958).NFD.list ~~ (0x0915, 0x093C,), '0958 -> 0915 093C';
ok Uni.new(0x0959).NFD.list ~~ (0x0916, 0x093C,), '0959 -> 0916 093C';
ok Uni.new(0x095A).NFD.list ~~ (0x0917, 0x093C,), '095A -> 0917 093C';
ok Uni.new(0x095B).NFD.list ~~ (0x091C, 0x093C,), '095B -> 091C 093C';
ok Uni.new(0x095C).NFD.list ~~ (0x0921, 0x093C,), '095C -> 0921 093C';
ok Uni.new(0x095D).NFD.list ~~ (0x0922, 0x093C,), '095D -> 0922 093C';
ok Uni.new(0x095E).NFD.list ~~ (0x092B, 0x093C,), '095E -> 092B 093C';
ok Uni.new(0x095F).NFD.list ~~ (0x092F, 0x093C,), '095F -> 092F 093C';
ok Uni.new(0x09CB).NFD.list ~~ (0x09C7, 0x09BE,), '09CB -> 09C7 09BE';
ok Uni.new(0x09CC).NFD.list ~~ (0x09C7, 0x09D7,), '09CC -> 09C7 09D7';
ok Uni.new(0x09DC).NFD.list ~~ (0x09A1, 0x09BC,), '09DC -> 09A1 09BC';
ok Uni.new(0x09DD).NFD.list ~~ (0x09A2, 0x09BC,), '09DD -> 09A2 09BC';
ok Uni.new(0x09DF).NFD.list ~~ (0x09AF, 0x09BC,), '09DF -> 09AF 09BC';
ok Uni.new(0x0A33).NFD.list ~~ (0x0A32, 0x0A3C,), '0A33 -> 0A32 0A3C';
ok Uni.new(0x0A36).NFD.list ~~ (0x0A38, 0x0A3C,), '0A36 -> 0A38 0A3C';
ok Uni.new(0x0A59).NFD.list ~~ (0x0A16, 0x0A3C,), '0A59 -> 0A16 0A3C';
ok Uni.new(0x0A5A).NFD.list ~~ (0x0A17, 0x0A3C,), '0A5A -> 0A17 0A3C';
ok Uni.new(0x0A5B).NFD.list ~~ (0x0A1C, 0x0A3C,), '0A5B -> 0A1C 0A3C';
ok Uni.new(0x0A5E).NFD.list ~~ (0x0A2B, 0x0A3C,), '0A5E -> 0A2B 0A3C';
ok Uni.new(0x0B48).NFD.list ~~ (0x0B47, 0x0B56,), '0B48 -> 0B47 0B56';
ok Uni.new(0x0B4B).NFD.list ~~ (0x0B47, 0x0B3E,), '0B4B -> 0B47 0B3E';
ok Uni.new(0x0B4C).NFD.list ~~ (0x0B47, 0x0B57,), '0B4C -> 0B47 0B57';
ok Uni.new(0x0B5C).NFD.list ~~ (0x0B21, 0x0B3C,), '0B5C -> 0B21 0B3C';
ok Uni.new(0x0B5D).NFD.list ~~ (0x0B22, 0x0B3C,), '0B5D -> 0B22 0B3C';
ok Uni.new(0x0B94).NFD.list ~~ (0x0B92, 0x0BD7,), '0B94 -> 0B92 0BD7';
ok Uni.new(0x0BCA).NFD.list ~~ (0x0BC6, 0x0BBE,), '0BCA -> 0BC6 0BBE';
ok Uni.new(0x0BCB).NFD.list ~~ (0x0BC7, 0x0BBE,), '0BCB -> 0BC7 0BBE';
ok Uni.new(0x0BCC).NFD.list ~~ (0x0BC6, 0x0BD7,), '0BCC -> 0BC6 0BD7';
ok Uni.new(0x0C48).NFD.list ~~ (0x0C46, 0x0C56,), '0C48 -> 0C46 0C56';
ok Uni.new(0x0CC0).NFD.list ~~ (0x0CBF, 0x0CD5,), '0CC0 -> 0CBF 0CD5';
ok Uni.new(0x0CC7).NFD.list ~~ (0x0CC6, 0x0CD5,), '0CC7 -> 0CC6 0CD5';
ok Uni.new(0x0CC8).NFD.list ~~ (0x0CC6, 0x0CD6,), '0CC8 -> 0CC6 0CD6';
ok Uni.new(0x0CCA).NFD.list ~~ (0x0CC6, 0x0CC2,), '0CCA -> 0CC6 0CC2';
ok Uni.new(0x0CCB).NFD.list ~~ (0x0CC6, 0x0CC2, 0x0CD5,), '0CCB -> 0CC6 0CC2 0CD5';
ok Uni.new(0x0D4A).NFD.list ~~ (0x0D46, 0x0D3E,), '0D4A -> 0D46 0D3E';
ok Uni.new(0x0D4B).NFD.list ~~ (0x0D47, 0x0D3E,), '0D4B -> 0D47 0D3E';
ok Uni.new(0x0D4C).NFD.list ~~ (0x0D46, 0x0D57,), '0D4C -> 0D46 0D57';
ok Uni.new(0x0DDA).NFD.list ~~ (0x0DD9, 0x0DCA,), '0DDA -> 0DD9 0DCA';
ok Uni.new(0x0DDC).NFD.list ~~ (0x0DD9, 0x0DCF,), '0DDC -> 0DD9 0DCF';
ok Uni.new(0x0DDD).NFD.list ~~ (0x0DD9, 0x0DCF, 0x0DCA,), '0DDD -> 0DD9 0DCF 0DCA';
ok Uni.new(0x0DDE).NFD.list ~~ (0x0DD9, 0x0DDF,), '0DDE -> 0DD9 0DDF';
ok Uni.new(0x0E33).NFD.list ~~ (0x0E33,), '0E33 -> 0E33';
ok Uni.new(0x0EB3).NFD.list ~~ (0x0EB3,), '0EB3 -> 0EB3';
ok Uni.new(0x0EDC).NFD.list ~~ (0x0EDC,), '0EDC -> 0EDC';
ok Uni.new(0x0EDD).NFD.list ~~ (0x0EDD,), '0EDD -> 0EDD';
ok Uni.new(0x0F0C).NFD.list ~~ (0x0F0C,), '0F0C -> 0F0C';
ok Uni.new(0x0F43).NFD.list ~~ (0x0F42, 0x0FB7,), '0F43 -> 0F42 0FB7';
ok Uni.new(0x0F4D).NFD.list ~~ (0x0F4C, 0x0FB7,), '0F4D -> 0F4C 0FB7';
ok Uni.new(0x0F52).NFD.list ~~ (0x0F51, 0x0FB7,), '0F52 -> 0F51 0FB7';
ok Uni.new(0x0F57).NFD.list ~~ (0x0F56, 0x0FB7,), '0F57 -> 0F56 0FB7';
ok Uni.new(0x0F5C).NFD.list ~~ (0x0F5B, 0x0FB7,), '0F5C -> 0F5B 0FB7';
ok Uni.new(0x0F69).NFD.list ~~ (0x0F40, 0x0FB5,), '0F69 -> 0F40 0FB5';
ok Uni.new(0x0F73).NFD.list ~~ (0x0F71, 0x0F72,), '0F73 -> 0F71 0F72';
ok Uni.new(0x0F75).NFD.list ~~ (0x0F71, 0x0F74,), '0F75 -> 0F71 0F74';
ok Uni.new(0x0F76).NFD.list ~~ (0x0FB2, 0x0F80,), '0F76 -> 0FB2 0F80';
ok Uni.new(0x0F77).NFD.list ~~ (0x0F77,), '0F77 -> 0F77';
ok Uni.new(0x0F78).NFD.list ~~ (0x0FB3, 0x0F80,), '0F78 -> 0FB3 0F80';
ok Uni.new(0x0F79).NFD.list ~~ (0x0F79,), '0F79 -> 0F79';
ok Uni.new(0x0F81).NFD.list ~~ (0x0F71, 0x0F80,), '0F81 -> 0F71 0F80';
ok Uni.new(0x0F93).NFD.list ~~ (0x0F92, 0x0FB7,), '0F93 -> 0F92 0FB7';
ok Uni.new(0x0F9D).NFD.list ~~ (0x0F9C, 0x0FB7,), '0F9D -> 0F9C 0FB7';
ok Uni.new(0x0FA2).NFD.list ~~ (0x0FA1, 0x0FB7,), '0FA2 -> 0FA1 0FB7';
ok Uni.new(0x0FA7).NFD.list ~~ (0x0FA6, 0x0FB7,), '0FA7 -> 0FA6 0FB7';
ok Uni.new(0x0FAC).NFD.list ~~ (0x0FAB, 0x0FB7,), '0FAC -> 0FAB 0FB7';
ok Uni.new(0x0FB9).NFD.list ~~ (0x0F90, 0x0FB5,), '0FB9 -> 0F90 0FB5';
ok Uni.new(0x1026).NFD.list ~~ (0x1025, 0x102E,), '1026 -> 1025 102E';
ok Uni.new(0x10FC).NFD.list ~~ (0x10FC,), '10FC -> 10FC';
ok Uni.new(0x1B06).NFD.list ~~ (0x1B05, 0x1B35,), '1B06 -> 1B05 1B35';
ok Uni.new(0x1B08).NFD.list ~~ (0x1B07, 0x1B35,), '1B08 -> 1B07 1B35';
ok Uni.new(0x1B0A).NFD.list ~~ (0x1B09, 0x1B35,), '1B0A -> 1B09 1B35';
ok Uni.new(0x1B0C).NFD.list ~~ (0x1B0B, 0x1B35,), '1B0C -> 1B0B 1B35';
ok Uni.new(0x1B0E).NFD.list ~~ (0x1B0D, 0x1B35,), '1B0E -> 1B0D 1B35';
ok Uni.new(0x1B12).NFD.list ~~ (0x1B11, 0x1B35,), '1B12 -> 1B11 1B35';
ok Uni.new(0x1B3B).NFD.list ~~ (0x1B3A, 0x1B35,), '1B3B -> 1B3A 1B35';
ok Uni.new(0x1B3D).NFD.list ~~ (0x1B3C, 0x1B35,), '1B3D -> 1B3C 1B35';
ok Uni.new(0x1B40).NFD.list ~~ (0x1B3E, 0x1B35,), '1B40 -> 1B3E 1B35';
ok Uni.new(0x1B41).NFD.list ~~ (0x1B3F, 0x1B35,), '1B41 -> 1B3F 1B35';
ok Uni.new(0x1B43).NFD.list ~~ (0x1B42, 0x1B35,), '1B43 -> 1B42 1B35';
ok Uni.new(0x1D2C).NFD.list ~~ (0x1D2C,), '1D2C -> 1D2C';
ok Uni.new(0x1D2D).NFD.list ~~ (0x1D2D,), '1D2D -> 1D2D';
ok Uni.new(0x1D2E).NFD.list ~~ (0x1D2E,), '1D2E -> 1D2E';
ok Uni.new(0x1D30).NFD.list ~~ (0x1D30,), '1D30 -> 1D30';
ok Uni.new(0x1D31).NFD.list ~~ (0x1D31,), '1D31 -> 1D31';
ok Uni.new(0x1D32).NFD.list ~~ (0x1D32,), '1D32 -> 1D32';
ok Uni.new(0x1D33).NFD.list ~~ (0x1D33,), '1D33 -> 1D33';
ok Uni.new(0x1D34).NFD.list ~~ (0x1D34,), '1D34 -> 1D34';
ok Uni.new(0x1D35).NFD.list ~~ (0x1D35,), '1D35 -> 1D35';
ok Uni.new(0x1D36).NFD.list ~~ (0x1D36,), '1D36 -> 1D36';
ok Uni.new(0x1D37).NFD.list ~~ (0x1D37,), '1D37 -> 1D37';
ok Uni.new(0x1D38).NFD.list ~~ (0x1D38,), '1D38 -> 1D38';
ok Uni.new(0x1D39).NFD.list ~~ (0x1D39,), '1D39 -> 1D39';
ok Uni.new(0x1D3A).NFD.list ~~ (0x1D3A,), '1D3A -> 1D3A';
ok Uni.new(0x1D3C).NFD.list ~~ (0x1D3C,), '1D3C -> 1D3C';
ok Uni.new(0x1D3D).NFD.list ~~ (0x1D3D,), '1D3D -> 1D3D';
ok Uni.new(0x1D3E).NFD.list ~~ (0x1D3E,), '1D3E -> 1D3E';
ok Uni.new(0x1D3F).NFD.list ~~ (0x1D3F,), '1D3F -> 1D3F';
ok Uni.new(0x1D40).NFD.list ~~ (0x1D40,), '1D40 -> 1D40';
ok Uni.new(0x1D41).NFD.list ~~ (0x1D41,), '1D41 -> 1D41';
ok Uni.new(0x1D42).NFD.list ~~ (0x1D42,), '1D42 -> 1D42';
ok Uni.new(0x1D43).NFD.list ~~ (0x1D43,), '1D43 -> 1D43';
ok Uni.new(0x1D44).NFD.list ~~ (0x1D44,), '1D44 -> 1D44';
ok Uni.new(0x1D45).NFD.list ~~ (0x1D45,), '1D45 -> 1D45';
ok Uni.new(0x1D46).NFD.list ~~ (0x1D46,), '1D46 -> 1D46';
ok Uni.new(0x1D47).NFD.list ~~ (0x1D47,), '1D47 -> 1D47';
ok Uni.new(0x1D48).NFD.list ~~ (0x1D48,), '1D48 -> 1D48';
ok Uni.new(0x1D49).NFD.list ~~ (0x1D49,), '1D49 -> 1D49';
ok Uni.new(0x1D4A).NFD.list ~~ (0x1D4A,), '1D4A -> 1D4A';
ok Uni.new(0x1D4B).NFD.list ~~ (0x1D4B,), '1D4B -> 1D4B';
ok Uni.new(0x1D4C).NFD.list ~~ (0x1D4C,), '1D4C -> 1D4C';
ok Uni.new(0x1D4D).NFD.list ~~ (0x1D4D,), '1D4D -> 1D4D';
ok Uni.new(0x1D4F).NFD.list ~~ (0x1D4F,), '1D4F -> 1D4F';
ok Uni.new(0x1D50).NFD.list ~~ (0x1D50,), '1D50 -> 1D50';
ok Uni.new(0x1D51).NFD.list ~~ (0x1D51,), '1D51 -> 1D51';
ok Uni.new(0x1D52).NFD.list ~~ (0x1D52,), '1D52 -> 1D52';
ok Uni.new(0x1D53).NFD.list ~~ (0x1D53,), '1D53 -> 1D53';
ok Uni.new(0x1D54).NFD.list ~~ (0x1D54,), '1D54 -> 1D54';
ok Uni.new(0x1D55).NFD.list ~~ (0x1D55,), '1D55 -> 1D55';
ok Uni.new(0x1D56).NFD.list ~~ (0x1D56,), '1D56 -> 1D56';
ok Uni.new(0x1D57).NFD.list ~~ (0x1D57,), '1D57 -> 1D57';
ok Uni.new(0x1D58).NFD.list ~~ (0x1D58,), '1D58 -> 1D58';
ok Uni.new(0x1D59).NFD.list ~~ (0x1D59,), '1D59 -> 1D59';
ok Uni.new(0x1D5A).NFD.list ~~ (0x1D5A,), '1D5A -> 1D5A';
ok Uni.new(0x1D5B).NFD.list ~~ (0x1D5B,), '1D5B -> 1D5B';
ok Uni.new(0x1D5C).NFD.list ~~ (0x1D5C,), '1D5C -> 1D5C';
ok Uni.new(0x1D5D).NFD.list ~~ (0x1D5D,), '1D5D -> 1D5D';
ok Uni.new(0x1D5E).NFD.list ~~ (0x1D5E,), '1D5E -> 1D5E';
ok Uni.new(0x1D5F).NFD.list ~~ (0x1D5F,), '1D5F -> 1D5F';
ok Uni.new(0x1D60).NFD.list ~~ (0x1D60,), '1D60 -> 1D60';
ok Uni.new(0x1D61).NFD.list ~~ (0x1D61,), '1D61 -> 1D61';
ok Uni.new(0x1D62).NFD.list ~~ (0x1D62,), '1D62 -> 1D62';
ok Uni.new(0x1D63).NFD.list ~~ (0x1D63,), '1D63 -> 1D63';
ok Uni.new(0x1D64).NFD.list ~~ (0x1D64,), '1D64 -> 1D64';
ok Uni.new(0x1D65).NFD.list ~~ (0x1D65,), '1D65 -> 1D65';
ok Uni.new(0x1D66).NFD.list ~~ (0x1D66,), '1D66 -> 1D66';
ok Uni.new(0x1D67).NFD.list ~~ (0x1D67,), '1D67 -> 1D67';
ok Uni.new(0x1D68).NFD.list ~~ (0x1D68,), '1D68 -> 1D68';
ok Uni.new(0x1D69).NFD.list ~~ (0x1D69,), '1D69 -> 1D69';
ok Uni.new(0x1D6A).NFD.list ~~ (0x1D6A,), '1D6A -> 1D6A';
ok Uni.new(0x1D78).NFD.list ~~ (0x1D78,), '1D78 -> 1D78';
ok Uni.new(0x1D9B).NFD.list ~~ (0x1D9B,), '1D9B -> 1D9B';
ok Uni.new(0x1D9C).NFD.list ~~ (0x1D9C,), '1D9C -> 1D9C';
ok Uni.new(0x1D9D).NFD.list ~~ (0x1D9D,), '1D9D -> 1D9D';
ok Uni.new(0x1D9E).NFD.list ~~ (0x1D9E,), '1D9E -> 1D9E';
ok Uni.new(0x1D9F).NFD.list ~~ (0x1D9F,), '1D9F -> 1D9F';
ok Uni.new(0x1DA0).NFD.list ~~ (0x1DA0,), '1DA0 -> 1DA0';
ok Uni.new(0x1DA1).NFD.list ~~ (0x1DA1,), '1DA1 -> 1DA1';
ok Uni.new(0x1DA2).NFD.list ~~ (0x1DA2,), '1DA2 -> 1DA2';
ok Uni.new(0x1DA3).NFD.list ~~ (0x1DA3,), '1DA3 -> 1DA3';
ok Uni.new(0x1DA4).NFD.list ~~ (0x1DA4,), '1DA4 -> 1DA4';
ok Uni.new(0x1DA5).NFD.list ~~ (0x1DA5,), '1DA5 -> 1DA5';
ok Uni.new(0x1DA6).NFD.list ~~ (0x1DA6,), '1DA6 -> 1DA6';
ok Uni.new(0x1DA7).NFD.list ~~ (0x1DA7,), '1DA7 -> 1DA7';
ok Uni.new(0x1DA8).NFD.list ~~ (0x1DA8,), '1DA8 -> 1DA8';
ok Uni.new(0x1DA9).NFD.list ~~ (0x1DA9,), '1DA9 -> 1DA9';
ok Uni.new(0x1DAA).NFD.list ~~ (0x1DAA,), '1DAA -> 1DAA';
ok Uni.new(0x1DAB).NFD.list ~~ (0x1DAB,), '1DAB -> 1DAB';
ok Uni.new(0x1DAC).NFD.list ~~ (0x1DAC,), '1DAC -> 1DAC';
ok Uni.new(0x1DAD).NFD.list ~~ (0x1DAD,), '1DAD -> 1DAD';
ok Uni.new(0x1DAE).NFD.list ~~ (0x1DAE,), '1DAE -> 1DAE';
ok Uni.new(0x1DAF).NFD.list ~~ (0x1DAF,), '1DAF -> 1DAF';
ok Uni.new(0x1DB0).NFD.list ~~ (0x1DB0,), '1DB0 -> 1DB0';
ok Uni.new(0x1DB1).NFD.list ~~ (0x1DB1,), '1DB1 -> 1DB1';
ok Uni.new(0x1DB2).NFD.list ~~ (0x1DB2,), '1DB2 -> 1DB2';
ok Uni.new(0x1DB3).NFD.list ~~ (0x1DB3,), '1DB3 -> 1DB3';
ok Uni.new(0x1DB4).NFD.list ~~ (0x1DB4,), '1DB4 -> 1DB4';
ok Uni.new(0x1DB5).NFD.list ~~ (0x1DB5,), '1DB5 -> 1DB5';
ok Uni.new(0x1DB6).NFD.list ~~ (0x1DB6,), '1DB6 -> 1DB6';
ok Uni.new(0x1DB7).NFD.list ~~ (0x1DB7,), '1DB7 -> 1DB7';
ok Uni.new(0x1DB8).NFD.list ~~ (0x1DB8,), '1DB8 -> 1DB8';
ok Uni.new(0x1DB9).NFD.list ~~ (0x1DB9,), '1DB9 -> 1DB9';
ok Uni.new(0x1DBA).NFD.list ~~ (0x1DBA,), '1DBA -> 1DBA';
ok Uni.new(0x1DBB).NFD.list ~~ (0x1DBB,), '1DBB -> 1DBB';
ok Uni.new(0x1DBC).NFD.list ~~ (0x1DBC,), '1DBC -> 1DBC';
ok Uni.new(0x1DBD).NFD.list ~~ (0x1DBD,), '1DBD -> 1DBD';
ok Uni.new(0x1DBE).NFD.list ~~ (0x1DBE,), '1DBE -> 1DBE';
ok Uni.new(0x1DBF).NFD.list ~~ (0x1DBF,), '1DBF -> 1DBF';
ok Uni.new(0x1E00).NFD.list ~~ (0x0041, 0x0325,), '1E00 -> 0041 0325';
ok Uni.new(0x1E01).NFD.list ~~ (0x0061, 0x0325,), '1E01 -> 0061 0325';
ok Uni.new(0x1E02).NFD.list ~~ (0x0042, 0x0307,), '1E02 -> 0042 0307';
ok Uni.new(0x1E03).NFD.list ~~ (0x0062, 0x0307,), '1E03 -> 0062 0307';
ok Uni.new(0x1E04).NFD.list ~~ (0x0042, 0x0323,), '1E04 -> 0042 0323';
ok Uni.new(0x1E05).NFD.list ~~ (0x0062, 0x0323,), '1E05 -> 0062 0323';
ok Uni.new(0x1E06).NFD.list ~~ (0x0042, 0x0331,), '1E06 -> 0042 0331';
ok Uni.new(0x1E07).NFD.list ~~ (0x0062, 0x0331,), '1E07 -> 0062 0331';
ok Uni.new(0x1E08).NFD.list ~~ (0x0043, 0x0327, 0x0301,), '1E08 -> 0043 0327 0301';
ok Uni.new(0x1E09).NFD.list ~~ (0x0063, 0x0327, 0x0301,), '1E09 -> 0063 0327 0301';
ok Uni.new(0x1E0A).NFD.list ~~ (0x0044, 0x0307,), '1E0A -> 0044 0307';
ok Uni.new(0x1E0B).NFD.list ~~ (0x0064, 0x0307,), '1E0B -> 0064 0307';
ok Uni.new(0x1E0C).NFD.list ~~ (0x0044, 0x0323,), '1E0C -> 0044 0323';
ok Uni.new(0x1E0D).NFD.list ~~ (0x0064, 0x0323,), '1E0D -> 0064 0323';
ok Uni.new(0x1E0E).NFD.list ~~ (0x0044, 0x0331,), '1E0E -> 0044 0331';
ok Uni.new(0x1E0F).NFD.list ~~ (0x0064, 0x0331,), '1E0F -> 0064 0331';
ok Uni.new(0x1E10).NFD.list ~~ (0x0044, 0x0327,), '1E10 -> 0044 0327';
ok Uni.new(0x1E11).NFD.list ~~ (0x0064, 0x0327,), '1E11 -> 0064 0327';
ok Uni.new(0x1E12).NFD.list ~~ (0x0044, 0x032D,), '1E12 -> 0044 032D';
ok Uni.new(0x1E13).NFD.list ~~ (0x0064, 0x032D,), '1E13 -> 0064 032D';
ok Uni.new(0x1E14).NFD.list ~~ (0x0045, 0x0304, 0x0300,), '1E14 -> 0045 0304 0300';
ok Uni.new(0x1E15).NFD.list ~~ (0x0065, 0x0304, 0x0300,), '1E15 -> 0065 0304 0300';
ok Uni.new(0x1E16).NFD.list ~~ (0x0045, 0x0304, 0x0301,), '1E16 -> 0045 0304 0301';
ok Uni.new(0x1E17).NFD.list ~~ (0x0065, 0x0304, 0x0301,), '1E17 -> 0065 0304 0301';
ok Uni.new(0x1E18).NFD.list ~~ (0x0045, 0x032D,), '1E18 -> 0045 032D';
ok Uni.new(0x1E19).NFD.list ~~ (0x0065, 0x032D,), '1E19 -> 0065 032D';
ok Uni.new(0x1E1A).NFD.list ~~ (0x0045, 0x0330,), '1E1A -> 0045 0330';
ok Uni.new(0x1E1B).NFD.list ~~ (0x0065, 0x0330,), '1E1B -> 0065 0330';
ok Uni.new(0x1E1C).NFD.list ~~ (0x0045, 0x0327, 0x0306,), '1E1C -> 0045 0327 0306';
ok Uni.new(0x1E1D).NFD.list ~~ (0x0065, 0x0327, 0x0306,), '1E1D -> 0065 0327 0306';
ok Uni.new(0x1E1E).NFD.list ~~ (0x0046, 0x0307,), '1E1E -> 0046 0307';
ok Uni.new(0x1E1F).NFD.list ~~ (0x0066, 0x0307,), '1E1F -> 0066 0307';
ok Uni.new(0x1E20).NFD.list ~~ (0x0047, 0x0304,), '1E20 -> 0047 0304';
ok Uni.new(0x1E21).NFD.list ~~ (0x0067, 0x0304,), '1E21 -> 0067 0304';
ok Uni.new(0x1E22).NFD.list ~~ (0x0048, 0x0307,), '1E22 -> 0048 0307';
ok Uni.new(0x1E23).NFD.list ~~ (0x0068, 0x0307,), '1E23 -> 0068 0307';
ok Uni.new(0x1E24).NFD.list ~~ (0x0048, 0x0323,), '1E24 -> 0048 0323';
ok Uni.new(0x1E25).NFD.list ~~ (0x0068, 0x0323,), '1E25 -> 0068 0323';
ok Uni.new(0x1E26).NFD.list ~~ (0x0048, 0x0308,), '1E26 -> 0048 0308';
ok Uni.new(0x1E27).NFD.list ~~ (0x0068, 0x0308,), '1E27 -> 0068 0308';
ok Uni.new(0x1E28).NFD.list ~~ (0x0048, 0x0327,), '1E28 -> 0048 0327';
ok Uni.new(0x1E29).NFD.list ~~ (0x0068, 0x0327,), '1E29 -> 0068 0327';
ok Uni.new(0x1E2A).NFD.list ~~ (0x0048, 0x032E,), '1E2A -> 0048 032E';
ok Uni.new(0x1E2B).NFD.list ~~ (0x0068, 0x032E,), '1E2B -> 0068 032E';
ok Uni.new(0x1E2C).NFD.list ~~ (0x0049, 0x0330,), '1E2C -> 0049 0330';
ok Uni.new(0x1E2D).NFD.list ~~ (0x0069, 0x0330,), '1E2D -> 0069 0330';
ok Uni.new(0x1E2E).NFD.list ~~ (0x0049, 0x0308, 0x0301,), '1E2E -> 0049 0308 0301';
ok Uni.new(0x1E2F).NFD.list ~~ (0x0069, 0x0308, 0x0301,), '1E2F -> 0069 0308 0301';
ok Uni.new(0x1E30).NFD.list ~~ (0x004B, 0x0301,), '1E30 -> 004B 0301';
ok Uni.new(0x1E31).NFD.list ~~ (0x006B, 0x0301,), '1E31 -> 006B 0301';
ok Uni.new(0x1E32).NFD.list ~~ (0x004B, 0x0323,), '1E32 -> 004B 0323';
ok Uni.new(0x1E33).NFD.list ~~ (0x006B, 0x0323,), '1E33 -> 006B 0323';
ok Uni.new(0x1E34).NFD.list ~~ (0x004B, 0x0331,), '1E34 -> 004B 0331';
ok Uni.new(0x1E35).NFD.list ~~ (0x006B, 0x0331,), '1E35 -> 006B 0331';
ok Uni.new(0x1E36).NFD.list ~~ (0x004C, 0x0323,), '1E36 -> 004C 0323';
ok Uni.new(0x1E37).NFD.list ~~ (0x006C, 0x0323,), '1E37 -> 006C 0323';
ok Uni.new(0x1E38).NFD.list ~~ (0x004C, 0x0323, 0x0304,), '1E38 -> 004C 0323 0304';
ok Uni.new(0x1E39).NFD.list ~~ (0x006C, 0x0323, 0x0304,), '1E39 -> 006C 0323 0304';
ok Uni.new(0x1E3A).NFD.list ~~ (0x004C, 0x0331,), '1E3A -> 004C 0331';
ok Uni.new(0x1E3B).NFD.list ~~ (0x006C, 0x0331,), '1E3B -> 006C 0331';
ok Uni.new(0x1E3C).NFD.list ~~ (0x004C, 0x032D,), '1E3C -> 004C 032D';
ok Uni.new(0x1E3D).NFD.list ~~ (0x006C, 0x032D,), '1E3D -> 006C 032D';
ok Uni.new(0x1E3E).NFD.list ~~ (0x004D, 0x0301,), '1E3E -> 004D 0301';
ok Uni.new(0x1E3F).NFD.list ~~ (0x006D, 0x0301,), '1E3F -> 006D 0301';
ok Uni.new(0x1E40).NFD.list ~~ (0x004D, 0x0307,), '1E40 -> 004D 0307';
ok Uni.new(0x1E41).NFD.list ~~ (0x006D, 0x0307,), '1E41 -> 006D 0307';
ok Uni.new(0x1E42).NFD.list ~~ (0x004D, 0x0323,), '1E42 -> 004D 0323';
ok Uni.new(0x1E43).NFD.list ~~ (0x006D, 0x0323,), '1E43 -> 006D 0323';
ok Uni.new(0x1E44).NFD.list ~~ (0x004E, 0x0307,), '1E44 -> 004E 0307';
ok Uni.new(0x1E45).NFD.list ~~ (0x006E, 0x0307,), '1E45 -> 006E 0307';
ok Uni.new(0x1E46).NFD.list ~~ (0x004E, 0x0323,), '1E46 -> 004E 0323';
ok Uni.new(0x1E47).NFD.list ~~ (0x006E, 0x0323,), '1E47 -> 006E 0323';
ok Uni.new(0x1E48).NFD.list ~~ (0x004E, 0x0331,), '1E48 -> 004E 0331';
ok Uni.new(0x1E49).NFD.list ~~ (0x006E, 0x0331,), '1E49 -> 006E 0331';
ok Uni.new(0x1E4A).NFD.list ~~ (0x004E, 0x032D,), '1E4A -> 004E 032D';
ok Uni.new(0x1E4B).NFD.list ~~ (0x006E, 0x032D,), '1E4B -> 006E 032D';
ok Uni.new(0x1E4C).NFD.list ~~ (0x004F, 0x0303, 0x0301,), '1E4C -> 004F 0303 0301';
ok Uni.new(0x1E4D).NFD.list ~~ (0x006F, 0x0303, 0x0301,), '1E4D -> 006F 0303 0301';
ok Uni.new(0x1E4E).NFD.list ~~ (0x004F, 0x0303, 0x0308,), '1E4E -> 004F 0303 0308';
ok Uni.new(0x1E4F).NFD.list ~~ (0x006F, 0x0303, 0x0308,), '1E4F -> 006F 0303 0308';
ok Uni.new(0x1E50).NFD.list ~~ (0x004F, 0x0304, 0x0300,), '1E50 -> 004F 0304 0300';
ok Uni.new(0x1E51).NFD.list ~~ (0x006F, 0x0304, 0x0300,), '1E51 -> 006F 0304 0300';
ok Uni.new(0x1E52).NFD.list ~~ (0x004F, 0x0304, 0x0301,), '1E52 -> 004F 0304 0301';
ok Uni.new(0x1E53).NFD.list ~~ (0x006F, 0x0304, 0x0301,), '1E53 -> 006F 0304 0301';
ok Uni.new(0x1E54).NFD.list ~~ (0x0050, 0x0301,), '1E54 -> 0050 0301';
ok Uni.new(0x1E55).NFD.list ~~ (0x0070, 0x0301,), '1E55 -> 0070 0301';
ok Uni.new(0x1E56).NFD.list ~~ (0x0050, 0x0307,), '1E56 -> 0050 0307';
ok Uni.new(0x1E57).NFD.list ~~ (0x0070, 0x0307,), '1E57 -> 0070 0307';
ok Uni.new(0x1E58).NFD.list ~~ (0x0052, 0x0307,), '1E58 -> 0052 0307';
ok Uni.new(0x1E59).NFD.list ~~ (0x0072, 0x0307,), '1E59 -> 0072 0307';
ok Uni.new(0x1E5A).NFD.list ~~ (0x0052, 0x0323,), '1E5A -> 0052 0323';
ok Uni.new(0x1E5B).NFD.list ~~ (0x0072, 0x0323,), '1E5B -> 0072 0323';
ok Uni.new(0x1E5C).NFD.list ~~ (0x0052, 0x0323, 0x0304,), '1E5C -> 0052 0323 0304';
ok Uni.new(0x1E5D).NFD.list ~~ (0x0072, 0x0323, 0x0304,), '1E5D -> 0072 0323 0304';
ok Uni.new(0x1E5E).NFD.list ~~ (0x0052, 0x0331,), '1E5E -> 0052 0331';
ok Uni.new(0x1E5F).NFD.list ~~ (0x0072, 0x0331,), '1E5F -> 0072 0331';
ok Uni.new(0x1E60).NFD.list ~~ (0x0053, 0x0307,), '1E60 -> 0053 0307';
ok Uni.new(0x1E61).NFD.list ~~ (0x0073, 0x0307,), '1E61 -> 0073 0307';
ok Uni.new(0x1E62).NFD.list ~~ (0x0053, 0x0323,), '1E62 -> 0053 0323';
ok Uni.new(0x1E63).NFD.list ~~ (0x0073, 0x0323,), '1E63 -> 0073 0323';
ok Uni.new(0x1E64).NFD.list ~~ (0x0053, 0x0301, 0x0307,), '1E64 -> 0053 0301 0307';
ok Uni.new(0x1E65).NFD.list ~~ (0x0073, 0x0301, 0x0307,), '1E65 -> 0073 0301 0307';
ok Uni.new(0x1E66).NFD.list ~~ (0x0053, 0x030C, 0x0307,), '1E66 -> 0053 030C 0307';
ok Uni.new(0x1E67).NFD.list ~~ (0x0073, 0x030C, 0x0307,), '1E67 -> 0073 030C 0307';
ok Uni.new(0x1E68).NFD.list ~~ (0x0053, 0x0323, 0x0307,), '1E68 -> 0053 0323 0307';
ok Uni.new(0x1E69).NFD.list ~~ (0x0073, 0x0323, 0x0307,), '1E69 -> 0073 0323 0307';
ok Uni.new(0x1E6A).NFD.list ~~ (0x0054, 0x0307,), '1E6A -> 0054 0307';
ok Uni.new(0x1E6B).NFD.list ~~ (0x0074, 0x0307,), '1E6B -> 0074 0307';
ok Uni.new(0x1E6C).NFD.list ~~ (0x0054, 0x0323,), '1E6C -> 0054 0323';
ok Uni.new(0x1E6D).NFD.list ~~ (0x0074, 0x0323,), '1E6D -> 0074 0323';
ok Uni.new(0x1E6E).NFD.list ~~ (0x0054, 0x0331,), '1E6E -> 0054 0331';
ok Uni.new(0x1E6F).NFD.list ~~ (0x0074, 0x0331,), '1E6F -> 0074 0331';
ok Uni.new(0x1E70).NFD.list ~~ (0x0054, 0x032D,), '1E70 -> 0054 032D';
ok Uni.new(0x1E71).NFD.list ~~ (0x0074, 0x032D,), '1E71 -> 0074 032D';
ok Uni.new(0x1E72).NFD.list ~~ (0x0055, 0x0324,), '1E72 -> 0055 0324';
ok Uni.new(0x1E73).NFD.list ~~ (0x0075, 0x0324,), '1E73 -> 0075 0324';
ok Uni.new(0x1E74).NFD.list ~~ (0x0055, 0x0330,), '1E74 -> 0055 0330';
ok Uni.new(0x1E75).NFD.list ~~ (0x0075, 0x0330,), '1E75 -> 0075 0330';
ok Uni.new(0x1E76).NFD.list ~~ (0x0055, 0x032D,), '1E76 -> 0055 032D';
ok Uni.new(0x1E77).NFD.list ~~ (0x0075, 0x032D,), '1E77 -> 0075 032D';
ok Uni.new(0x1E78).NFD.list ~~ (0x0055, 0x0303, 0x0301,), '1E78 -> 0055 0303 0301';
ok Uni.new(0x1E79).NFD.list ~~ (0x0075, 0x0303, 0x0301,), '1E79 -> 0075 0303 0301';
ok Uni.new(0x1E7A).NFD.list ~~ (0x0055, 0x0304, 0x0308,), '1E7A -> 0055 0304 0308';
ok Uni.new(0x1E7B).NFD.list ~~ (0x0075, 0x0304, 0x0308,), '1E7B -> 0075 0304 0308';
ok Uni.new(0x1E7C).NFD.list ~~ (0x0056, 0x0303,), '1E7C -> 0056 0303';
ok Uni.new(0x1E7D).NFD.list ~~ (0x0076, 0x0303,), '1E7D -> 0076 0303';
ok Uni.new(0x1E7E).NFD.list ~~ (0x0056, 0x0323,), '1E7E -> 0056 0323';
ok Uni.new(0x1E7F).NFD.list ~~ (0x0076, 0x0323,), '1E7F -> 0076 0323';
ok Uni.new(0x1E80).NFD.list ~~ (0x0057, 0x0300,), '1E80 -> 0057 0300';
ok Uni.new(0x1E81).NFD.list ~~ (0x0077, 0x0300,), '1E81 -> 0077 0300';
ok Uni.new(0x1E82).NFD.list ~~ (0x0057, 0x0301,), '1E82 -> 0057 0301';
ok Uni.new(0x1E83).NFD.list ~~ (0x0077, 0x0301,), '1E83 -> 0077 0301';
ok Uni.new(0x1E84).NFD.list ~~ (0x0057, 0x0308,), '1E84 -> 0057 0308';
ok Uni.new(0x1E85).NFD.list ~~ (0x0077, 0x0308,), '1E85 -> 0077 0308';
ok Uni.new(0x1E86).NFD.list ~~ (0x0057, 0x0307,), '1E86 -> 0057 0307';
ok Uni.new(0x1E87).NFD.list ~~ (0x0077, 0x0307,), '1E87 -> 0077 0307';
ok Uni.new(0x1E88).NFD.list ~~ (0x0057, 0x0323,), '1E88 -> 0057 0323';
ok Uni.new(0x1E89).NFD.list ~~ (0x0077, 0x0323,), '1E89 -> 0077 0323';
ok Uni.new(0x1E8A).NFD.list ~~ (0x0058, 0x0307,), '1E8A -> 0058 0307';
ok Uni.new(0x1E8B).NFD.list ~~ (0x0078, 0x0307,), '1E8B -> 0078 0307';
ok Uni.new(0x1E8C).NFD.list ~~ (0x0058, 0x0308,), '1E8C -> 0058 0308';
ok Uni.new(0x1E8D).NFD.list ~~ (0x0078, 0x0308,), '1E8D -> 0078 0308';
ok Uni.new(0x1E8E).NFD.list ~~ (0x0059, 0x0307,), '1E8E -> 0059 0307';
ok Uni.new(0x1E8F).NFD.list ~~ (0x0079, 0x0307,), '1E8F -> 0079 0307';
ok Uni.new(0x1E90).NFD.list ~~ (0x005A, 0x0302,), '1E90 -> 005A 0302';
ok Uni.new(0x1E91).NFD.list ~~ (0x007A, 0x0302,), '1E91 -> 007A 0302';
ok Uni.new(0x1E92).NFD.list ~~ (0x005A, 0x0323,), '1E92 -> 005A 0323';
ok Uni.new(0x1E93).NFD.list ~~ (0x007A, 0x0323,), '1E93 -> 007A 0323';
ok Uni.new(0x1E94).NFD.list ~~ (0x005A, 0x0331,), '1E94 -> 005A 0331';
ok Uni.new(0x1E95).NFD.list ~~ (0x007A, 0x0331,), '1E95 -> 007A 0331';
ok Uni.new(0x1E96).NFD.list ~~ (0x0068, 0x0331,), '1E96 -> 0068 0331';
ok Uni.new(0x1E97).NFD.list ~~ (0x0074, 0x0308,), '1E97 -> 0074 0308';
ok Uni.new(0x1E98).NFD.list ~~ (0x0077, 0x030A,), '1E98 -> 0077 030A';
ok Uni.new(0x1E99).NFD.list ~~ (0x0079, 0x030A,), '1E99 -> 0079 030A';
ok Uni.new(0x1E9A).NFD.list ~~ (0x1E9A,), '1E9A -> 1E9A';
ok Uni.new(0x1E9B).NFD.list ~~ (0x017F, 0x0307,), '1E9B -> 017F 0307';
ok Uni.new(0x1EA0).NFD.list ~~ (0x0041, 0x0323,), '1EA0 -> 0041 0323';
ok Uni.new(0x1EA1).NFD.list ~~ (0x0061, 0x0323,), '1EA1 -> 0061 0323';
ok Uni.new(0x1EA2).NFD.list ~~ (0x0041, 0x0309,), '1EA2 -> 0041 0309';
ok Uni.new(0x1EA3).NFD.list ~~ (0x0061, 0x0309,), '1EA3 -> 0061 0309';
ok Uni.new(0x1EA4).NFD.list ~~ (0x0041, 0x0302, 0x0301,), '1EA4 -> 0041 0302 0301';
ok Uni.new(0x1EA5).NFD.list ~~ (0x0061, 0x0302, 0x0301,), '1EA5 -> 0061 0302 0301';
ok Uni.new(0x1EA6).NFD.list ~~ (0x0041, 0x0302, 0x0300,), '1EA6 -> 0041 0302 0300';
ok Uni.new(0x1EA7).NFD.list ~~ (0x0061, 0x0302, 0x0300,), '1EA7 -> 0061 0302 0300';
ok Uni.new(0x1EA8).NFD.list ~~ (0x0041, 0x0302, 0x0309,), '1EA8 -> 0041 0302 0309';
ok Uni.new(0x1EA9).NFD.list ~~ (0x0061, 0x0302, 0x0309,), '1EA9 -> 0061 0302 0309';
ok Uni.new(0x1EAA).NFD.list ~~ (0x0041, 0x0302, 0x0303,), '1EAA -> 0041 0302 0303';
ok Uni.new(0x1EAB).NFD.list ~~ (0x0061, 0x0302, 0x0303,), '1EAB -> 0061 0302 0303';
ok Uni.new(0x1EAC).NFD.list ~~ (0x0041, 0x0323, 0x0302,), '1EAC -> 0041 0323 0302';
ok Uni.new(0x1EAD).NFD.list ~~ (0x0061, 0x0323, 0x0302,), '1EAD -> 0061 0323 0302';
ok Uni.new(0x1EAE).NFD.list ~~ (0x0041, 0x0306, 0x0301,), '1EAE -> 0041 0306 0301';
ok Uni.new(0x1EAF).NFD.list ~~ (0x0061, 0x0306, 0x0301,), '1EAF -> 0061 0306 0301';
ok Uni.new(0x1EB0).NFD.list ~~ (0x0041, 0x0306, 0x0300,), '1EB0 -> 0041 0306 0300';
ok Uni.new(0x1EB1).NFD.list ~~ (0x0061, 0x0306, 0x0300,), '1EB1 -> 0061 0306 0300';
ok Uni.new(0x1EB2).NFD.list ~~ (0x0041, 0x0306, 0x0309,), '1EB2 -> 0041 0306 0309';
ok Uni.new(0x1EB3).NFD.list ~~ (0x0061, 0x0306, 0x0309,), '1EB3 -> 0061 0306 0309';
ok Uni.new(0x1EB4).NFD.list ~~ (0x0041, 0x0306, 0x0303,), '1EB4 -> 0041 0306 0303';
ok Uni.new(0x1EB5).NFD.list ~~ (0x0061, 0x0306, 0x0303,), '1EB5 -> 0061 0306 0303';
ok Uni.new(0x1EB6).NFD.list ~~ (0x0041, 0x0323, 0x0306,), '1EB6 -> 0041 0323 0306';
ok Uni.new(0x1EB7).NFD.list ~~ (0x0061, 0x0323, 0x0306,), '1EB7 -> 0061 0323 0306';
ok Uni.new(0x1EB8).NFD.list ~~ (0x0045, 0x0323,), '1EB8 -> 0045 0323';
ok Uni.new(0x1EB9).NFD.list ~~ (0x0065, 0x0323,), '1EB9 -> 0065 0323';
ok Uni.new(0x1EBA).NFD.list ~~ (0x0045, 0x0309,), '1EBA -> 0045 0309';
ok Uni.new(0x1EBB).NFD.list ~~ (0x0065, 0x0309,), '1EBB -> 0065 0309';
ok Uni.new(0x1EBC).NFD.list ~~ (0x0045, 0x0303,), '1EBC -> 0045 0303';
ok Uni.new(0x1EBD).NFD.list ~~ (0x0065, 0x0303,), '1EBD -> 0065 0303';
ok Uni.new(0x1EBE).NFD.list ~~ (0x0045, 0x0302, 0x0301,), '1EBE -> 0045 0302 0301';
ok Uni.new(0x1EBF).NFD.list ~~ (0x0065, 0x0302, 0x0301,), '1EBF -> 0065 0302 0301';
ok Uni.new(0x1EC0).NFD.list ~~ (0x0045, 0x0302, 0x0300,), '1EC0 -> 0045 0302 0300';
ok Uni.new(0x1EC1).NFD.list ~~ (0x0065, 0x0302, 0x0300,), '1EC1 -> 0065 0302 0300';
ok Uni.new(0x1EC2).NFD.list ~~ (0x0045, 0x0302, 0x0309,), '1EC2 -> 0045 0302 0309';
ok Uni.new(0x1EC3).NFD.list ~~ (0x0065, 0x0302, 0x0309,), '1EC3 -> 0065 0302 0309';
ok Uni.new(0x1EC4).NFD.list ~~ (0x0045, 0x0302, 0x0303,), '1EC4 -> 0045 0302 0303';
ok Uni.new(0x1EC5).NFD.list ~~ (0x0065, 0x0302, 0x0303,), '1EC5 -> 0065 0302 0303';
ok Uni.new(0x1EC6).NFD.list ~~ (0x0045, 0x0323, 0x0302,), '1EC6 -> 0045 0323 0302';
ok Uni.new(0x1EC7).NFD.list ~~ (0x0065, 0x0323, 0x0302,), '1EC7 -> 0065 0323 0302';
ok Uni.new(0x1EC8).NFD.list ~~ (0x0049, 0x0309,), '1EC8 -> 0049 0309';
ok Uni.new(0x1EC9).NFD.list ~~ (0x0069, 0x0309,), '1EC9 -> 0069 0309';
ok Uni.new(0x1ECA).NFD.list ~~ (0x0049, 0x0323,), '1ECA -> 0049 0323';
ok Uni.new(0x1ECB).NFD.list ~~ (0x0069, 0x0323,), '1ECB -> 0069 0323';
ok Uni.new(0x1ECC).NFD.list ~~ (0x004F, 0x0323,), '1ECC -> 004F 0323';
ok Uni.new(0x1ECD).NFD.list ~~ (0x006F, 0x0323,), '1ECD -> 006F 0323';
ok Uni.new(0x1ECE).NFD.list ~~ (0x004F, 0x0309,), '1ECE -> 004F 0309';
ok Uni.new(0x1ECF).NFD.list ~~ (0x006F, 0x0309,), '1ECF -> 006F 0309';
ok Uni.new(0x1ED0).NFD.list ~~ (0x004F, 0x0302, 0x0301,), '1ED0 -> 004F 0302 0301';
ok Uni.new(0x1ED1).NFD.list ~~ (0x006F, 0x0302, 0x0301,), '1ED1 -> 006F 0302 0301';
ok Uni.new(0x1ED2).NFD.list ~~ (0x004F, 0x0302, 0x0300,), '1ED2 -> 004F 0302 0300';
ok Uni.new(0x1ED3).NFD.list ~~ (0x006F, 0x0302, 0x0300,), '1ED3 -> 006F 0302 0300';
ok Uni.new(0x1ED4).NFD.list ~~ (0x004F, 0x0302, 0x0309,), '1ED4 -> 004F 0302 0309';
ok Uni.new(0x1ED5).NFD.list ~~ (0x006F, 0x0302, 0x0309,), '1ED5 -> 006F 0302 0309';
ok Uni.new(0x1ED6).NFD.list ~~ (0x004F, 0x0302, 0x0303,), '1ED6 -> 004F 0302 0303';
ok Uni.new(0x1ED7).NFD.list ~~ (0x006F, 0x0302, 0x0303,), '1ED7 -> 006F 0302 0303';
ok Uni.new(0x1ED8).NFD.list ~~ (0x004F, 0x0323, 0x0302,), '1ED8 -> 004F 0323 0302';
ok Uni.new(0x1ED9).NFD.list ~~ (0x006F, 0x0323, 0x0302,), '1ED9 -> 006F 0323 0302';
ok Uni.new(0x1EDA).NFD.list ~~ (0x004F, 0x031B, 0x0301,), '1EDA -> 004F 031B 0301';
ok Uni.new(0x1EDB).NFD.list ~~ (0x006F, 0x031B, 0x0301,), '1EDB -> 006F 031B 0301';
ok Uni.new(0x1EDC).NFD.list ~~ (0x004F, 0x031B, 0x0300,), '1EDC -> 004F 031B 0300';
ok Uni.new(0x1EDD).NFD.list ~~ (0x006F, 0x031B, 0x0300,), '1EDD -> 006F 031B 0300';
ok Uni.new(0x1EDE).NFD.list ~~ (0x004F, 0x031B, 0x0309,), '1EDE -> 004F 031B 0309';
ok Uni.new(0x1EDF).NFD.list ~~ (0x006F, 0x031B, 0x0309,), '1EDF -> 006F 031B 0309';
ok Uni.new(0x1EE0).NFD.list ~~ (0x004F, 0x031B, 0x0303,), '1EE0 -> 004F 031B 0303';
ok Uni.new(0x1EE1).NFD.list ~~ (0x006F, 0x031B, 0x0303,), '1EE1 -> 006F 031B 0303';
ok Uni.new(0x1EE2).NFD.list ~~ (0x004F, 0x031B, 0x0323,), '1EE2 -> 004F 031B 0323';
ok Uni.new(0x1EE3).NFD.list ~~ (0x006F, 0x031B, 0x0323,), '1EE3 -> 006F 031B 0323';
ok Uni.new(0x1EE4).NFD.list ~~ (0x0055, 0x0323,), '1EE4 -> 0055 0323';
ok Uni.new(0x1EE5).NFD.list ~~ (0x0075, 0x0323,), '1EE5 -> 0075 0323';
ok Uni.new(0x1EE6).NFD.list ~~ (0x0055, 0x0309,), '1EE6 -> 0055 0309';
ok Uni.new(0x1EE7).NFD.list ~~ (0x0075, 0x0309,), '1EE7 -> 0075 0309';
ok Uni.new(0x1EE8).NFD.list ~~ (0x0055, 0x031B, 0x0301,), '1EE8 -> 0055 031B 0301';
ok Uni.new(0x1EE9).NFD.list ~~ (0x0075, 0x031B, 0x0301,), '1EE9 -> 0075 031B 0301';
ok Uni.new(0x1EEA).NFD.list ~~ (0x0055, 0x031B, 0x0300,), '1EEA -> 0055 031B 0300';
ok Uni.new(0x1EEB).NFD.list ~~ (0x0075, 0x031B, 0x0300,), '1EEB -> 0075 031B 0300';
ok Uni.new(0x1EEC).NFD.list ~~ (0x0055, 0x031B, 0x0309,), '1EEC -> 0055 031B 0309';
ok Uni.new(0x1EED).NFD.list ~~ (0x0075, 0x031B, 0x0309,), '1EED -> 0075 031B 0309';
ok Uni.new(0x1EEE).NFD.list ~~ (0x0055, 0x031B, 0x0303,), '1EEE -> 0055 031B 0303';
ok Uni.new(0x1EEF).NFD.list ~~ (0x0075, 0x031B, 0x0303,), '1EEF -> 0075 031B 0303';
ok Uni.new(0x1EF0).NFD.list ~~ (0x0055, 0x031B, 0x0323,), '1EF0 -> 0055 031B 0323';
ok Uni.new(0x1EF1).NFD.list ~~ (0x0075, 0x031B, 0x0323,), '1EF1 -> 0075 031B 0323';
ok Uni.new(0x1EF2).NFD.list ~~ (0x0059, 0x0300,), '1EF2 -> 0059 0300';
ok Uni.new(0x1EF3).NFD.list ~~ (0x0079, 0x0300,), '1EF3 -> 0079 0300';
ok Uni.new(0x1EF4).NFD.list ~~ (0x0059, 0x0323,), '1EF4 -> 0059 0323';
ok Uni.new(0x1EF5).NFD.list ~~ (0x0079, 0x0323,), '1EF5 -> 0079 0323';
ok Uni.new(0x1EF6).NFD.list ~~ (0x0059, 0x0309,), '1EF6 -> 0059 0309';
ok Uni.new(0x1EF7).NFD.list ~~ (0x0079, 0x0309,), '1EF7 -> 0079 0309';
ok Uni.new(0x1EF8).NFD.list ~~ (0x0059, 0x0303,), '1EF8 -> 0059 0303';
ok Uni.new(0x1EF9).NFD.list ~~ (0x0079, 0x0303,), '1EF9 -> 0079 0303';
ok Uni.new(0x1F00).NFD.list ~~ (0x03B1, 0x0313,), '1F00 -> 03B1 0313';
ok Uni.new(0x1F01).NFD.list ~~ (0x03B1, 0x0314,), '1F01 -> 03B1 0314';
ok Uni.new(0x1F02).NFD.list ~~ (0x03B1, 0x0313, 0x0300,), '1F02 -> 03B1 0313 0300';
ok Uni.new(0x1F03).NFD.list ~~ (0x03B1, 0x0314, 0x0300,), '1F03 -> 03B1 0314 0300';
ok Uni.new(0x1F04).NFD.list ~~ (0x03B1, 0x0313, 0x0301,), '1F04 -> 03B1 0313 0301';
ok Uni.new(0x1F05).NFD.list ~~ (0x03B1, 0x0314, 0x0301,), '1F05 -> 03B1 0314 0301';
ok Uni.new(0x1F06).NFD.list ~~ (0x03B1, 0x0313, 0x0342,), '1F06 -> 03B1 0313 0342';
ok Uni.new(0x1F07).NFD.list ~~ (0x03B1, 0x0314, 0x0342,), '1F07 -> 03B1 0314 0342';
ok Uni.new(0x1F08).NFD.list ~~ (0x0391, 0x0313,), '1F08 -> 0391 0313';
ok Uni.new(0x1F09).NFD.list ~~ (0x0391, 0x0314,), '1F09 -> 0391 0314';
ok Uni.new(0x1F0A).NFD.list ~~ (0x0391, 0x0313, 0x0300,), '1F0A -> 0391 0313 0300';
ok Uni.new(0x1F0B).NFD.list ~~ (0x0391, 0x0314, 0x0300,), '1F0B -> 0391 0314 0300';
ok Uni.new(0x1F0C).NFD.list ~~ (0x0391, 0x0313, 0x0301,), '1F0C -> 0391 0313 0301';
ok Uni.new(0x1F0D).NFD.list ~~ (0x0391, 0x0314, 0x0301,), '1F0D -> 0391 0314 0301';
ok Uni.new(0x1F0E).NFD.list ~~ (0x0391, 0x0313, 0x0342,), '1F0E -> 0391 0313 0342';
ok Uni.new(0x1F0F).NFD.list ~~ (0x0391, 0x0314, 0x0342,), '1F0F -> 0391 0314 0342';
ok Uni.new(0x1F10).NFD.list ~~ (0x03B5, 0x0313,), '1F10 -> 03B5 0313';
ok Uni.new(0x1F11).NFD.list ~~ (0x03B5, 0x0314,), '1F11 -> 03B5 0314';
ok Uni.new(0x1F12).NFD.list ~~ (0x03B5, 0x0313, 0x0300,), '1F12 -> 03B5 0313 0300';
ok Uni.new(0x1F13).NFD.list ~~ (0x03B5, 0x0314, 0x0300,), '1F13 -> 03B5 0314 0300';
ok Uni.new(0x1F14).NFD.list ~~ (0x03B5, 0x0313, 0x0301,), '1F14 -> 03B5 0313 0301';
ok Uni.new(0x1F15).NFD.list ~~ (0x03B5, 0x0314, 0x0301,), '1F15 -> 03B5 0314 0301';
ok Uni.new(0x1F18).NFD.list ~~ (0x0395, 0x0313,), '1F18 -> 0395 0313';
ok Uni.new(0x1F19).NFD.list ~~ (0x0395, 0x0314,), '1F19 -> 0395 0314';
ok Uni.new(0x1F1A).NFD.list ~~ (0x0395, 0x0313, 0x0300,), '1F1A -> 0395 0313 0300';
ok Uni.new(0x1F1B).NFD.list ~~ (0x0395, 0x0314, 0x0300,), '1F1B -> 0395 0314 0300';
ok Uni.new(0x1F1C).NFD.list ~~ (0x0395, 0x0313, 0x0301,), '1F1C -> 0395 0313 0301';
ok Uni.new(0x1F1D).NFD.list ~~ (0x0395, 0x0314, 0x0301,), '1F1D -> 0395 0314 0301';
ok Uni.new(0x1F20).NFD.list ~~ (0x03B7, 0x0313,), '1F20 -> 03B7 0313';
ok Uni.new(0x1F21).NFD.list ~~ (0x03B7, 0x0314,), '1F21 -> 03B7 0314';
ok Uni.new(0x1F22).NFD.list ~~ (0x03B7, 0x0313, 0x0300,), '1F22 -> 03B7 0313 0300';
ok Uni.new(0x1F23).NFD.list ~~ (0x03B7, 0x0314, 0x0300,), '1F23 -> 03B7 0314 0300';
ok Uni.new(0x1F24).NFD.list ~~ (0x03B7, 0x0313, 0x0301,), '1F24 -> 03B7 0313 0301';
ok Uni.new(0x1F25).NFD.list ~~ (0x03B7, 0x0314, 0x0301,), '1F25 -> 03B7 0314 0301';
ok Uni.new(0x1F26).NFD.list ~~ (0x03B7, 0x0313, 0x0342,), '1F26 -> 03B7 0313 0342';
ok Uni.new(0x1F27).NFD.list ~~ (0x03B7, 0x0314, 0x0342,), '1F27 -> 03B7 0314 0342';
ok Uni.new(0x1F28).NFD.list ~~ (0x0397, 0x0313,), '1F28 -> 0397 0313';
ok Uni.new(0x1F29).NFD.list ~~ (0x0397, 0x0314,), '1F29 -> 0397 0314';
ok Uni.new(0x1F2A).NFD.list ~~ (0x0397, 0x0313, 0x0300,), '1F2A -> 0397 0313 0300';
ok Uni.new(0x1F2B).NFD.list ~~ (0x0397, 0x0314, 0x0300,), '1F2B -> 0397 0314 0300';
ok Uni.new(0x1F2C).NFD.list ~~ (0x0397, 0x0313, 0x0301,), '1F2C -> 0397 0313 0301';
ok Uni.new(0x1F2D).NFD.list ~~ (0x0397, 0x0314, 0x0301,), '1F2D -> 0397 0314 0301';
ok Uni.new(0x1F2E).NFD.list ~~ (0x0397, 0x0313, 0x0342,), '1F2E -> 0397 0313 0342';
ok Uni.new(0x1F2F).NFD.list ~~ (0x0397, 0x0314, 0x0342,), '1F2F -> 0397 0314 0342';
ok Uni.new(0x1F30).NFD.list ~~ (0x03B9, 0x0313,), '1F30 -> 03B9 0313';
ok Uni.new(0x1F31).NFD.list ~~ (0x03B9, 0x0314,), '1F31 -> 03B9 0314';
ok Uni.new(0x1F32).NFD.list ~~ (0x03B9, 0x0313, 0x0300,), '1F32 -> 03B9 0313 0300';
ok Uni.new(0x1F33).NFD.list ~~ (0x03B9, 0x0314, 0x0300,), '1F33 -> 03B9 0314 0300';
ok Uni.new(0x1F34).NFD.list ~~ (0x03B9, 0x0313, 0x0301,), '1F34 -> 03B9 0313 0301';
ok Uni.new(0x1F35).NFD.list ~~ (0x03B9, 0x0314, 0x0301,), '1F35 -> 03B9 0314 0301';
ok Uni.new(0x1F36).NFD.list ~~ (0x03B9, 0x0313, 0x0342,), '1F36 -> 03B9 0313 0342';
ok Uni.new(0x1F37).NFD.list ~~ (0x03B9, 0x0314, 0x0342,), '1F37 -> 03B9 0314 0342';
ok Uni.new(0x1F38).NFD.list ~~ (0x0399, 0x0313,), '1F38 -> 0399 0313';
ok Uni.new(0x1F39).NFD.list ~~ (0x0399, 0x0314,), '1F39 -> 0399 0314';
ok Uni.new(0x1F3A).NFD.list ~~ (0x0399, 0x0313, 0x0300,), '1F3A -> 0399 0313 0300';
ok Uni.new(0x1F3B).NFD.list ~~ (0x0399, 0x0314, 0x0300,), '1F3B -> 0399 0314 0300';
ok Uni.new(0x1F3C).NFD.list ~~ (0x0399, 0x0313, 0x0301,), '1F3C -> 0399 0313 0301';
ok Uni.new(0x1F3D).NFD.list ~~ (0x0399, 0x0314, 0x0301,), '1F3D -> 0399 0314 0301';
ok Uni.new(0x1F3E).NFD.list ~~ (0x0399, 0x0313, 0x0342,), '1F3E -> 0399 0313 0342';
ok Uni.new(0x1F3F).NFD.list ~~ (0x0399, 0x0314, 0x0342,), '1F3F -> 0399 0314 0342';
ok Uni.new(0x1F40).NFD.list ~~ (0x03BF, 0x0313,), '1F40 -> 03BF 0313';
ok Uni.new(0x1F41).NFD.list ~~ (0x03BF, 0x0314,), '1F41 -> 03BF 0314';
ok Uni.new(0x1F42).NFD.list ~~ (0x03BF, 0x0313, 0x0300,), '1F42 -> 03BF 0313 0300';
ok Uni.new(0x1F43).NFD.list ~~ (0x03BF, 0x0314, 0x0300,), '1F43 -> 03BF 0314 0300';
ok Uni.new(0x1F44).NFD.list ~~ (0x03BF, 0x0313, 0x0301,), '1F44 -> 03BF 0313 0301';
ok Uni.new(0x1F45).NFD.list ~~ (0x03BF, 0x0314, 0x0301,), '1F45 -> 03BF 0314 0301';
ok Uni.new(0x1F48).NFD.list ~~ (0x039F, 0x0313,), '1F48 -> 039F 0313';
ok Uni.new(0x1F49).NFD.list ~~ (0x039F, 0x0314,), '1F49 -> 039F 0314';
ok Uni.new(0x1F4A).NFD.list ~~ (0x039F, 0x0313, 0x0300,), '1F4A -> 039F 0313 0300';
ok Uni.new(0x1F4B).NFD.list ~~ (0x039F, 0x0314, 0x0300,), '1F4B -> 039F 0314 0300';
ok Uni.new(0x1F4C).NFD.list ~~ (0x039F, 0x0313, 0x0301,), '1F4C -> 039F 0313 0301';
ok Uni.new(0x1F4D).NFD.list ~~ (0x039F, 0x0314, 0x0301,), '1F4D -> 039F 0314 0301';
ok Uni.new(0x1F50).NFD.list ~~ (0x03C5, 0x0313,), '1F50 -> 03C5 0313';
ok Uni.new(0x1F51).NFD.list ~~ (0x03C5, 0x0314,), '1F51 -> 03C5 0314';
ok Uni.new(0x1F52).NFD.list ~~ (0x03C5, 0x0313, 0x0300,), '1F52 -> 03C5 0313 0300';
ok Uni.new(0x1F53).NFD.list ~~ (0x03C5, 0x0314, 0x0300,), '1F53 -> 03C5 0314 0300';
ok Uni.new(0x1F54).NFD.list ~~ (0x03C5, 0x0313, 0x0301,), '1F54 -> 03C5 0313 0301';
ok Uni.new(0x1F55).NFD.list ~~ (0x03C5, 0x0314, 0x0301,), '1F55 -> 03C5 0314 0301';
ok Uni.new(0x1F56).NFD.list ~~ (0x03C5, 0x0313, 0x0342,), '1F56 -> 03C5 0313 0342';
ok Uni.new(0x1F57).NFD.list ~~ (0x03C5, 0x0314, 0x0342,), '1F57 -> 03C5 0314 0342';
ok Uni.new(0x1F59).NFD.list ~~ (0x03A5, 0x0314,), '1F59 -> 03A5 0314';
ok Uni.new(0x1F5B).NFD.list ~~ (0x03A5, 0x0314, 0x0300,), '1F5B -> 03A5 0314 0300';
ok Uni.new(0x1F5D).NFD.list ~~ (0x03A5, 0x0314, 0x0301,), '1F5D -> 03A5 0314 0301';
ok Uni.new(0x1F5F).NFD.list ~~ (0x03A5, 0x0314, 0x0342,), '1F5F -> 03A5 0314 0342';
ok Uni.new(0x1F60).NFD.list ~~ (0x03C9, 0x0313,), '1F60 -> 03C9 0313';
ok Uni.new(0x1F61).NFD.list ~~ (0x03C9, 0x0314,), '1F61 -> 03C9 0314';
ok Uni.new(0x1F62).NFD.list ~~ (0x03C9, 0x0313, 0x0300,), '1F62 -> 03C9 0313 0300';
ok Uni.new(0x1F63).NFD.list ~~ (0x03C9, 0x0314, 0x0300,), '1F63 -> 03C9 0314 0300';
ok Uni.new(0x1F64).NFD.list ~~ (0x03C9, 0x0313, 0x0301,), '1F64 -> 03C9 0313 0301';
ok Uni.new(0x1F65).NFD.list ~~ (0x03C9, 0x0314, 0x0301,), '1F65 -> 03C9 0314 0301';
ok Uni.new(0x1F66).NFD.list ~~ (0x03C9, 0x0313, 0x0342,), '1F66 -> 03C9 0313 0342';
ok Uni.new(0x1F67).NFD.list ~~ (0x03C9, 0x0314, 0x0342,), '1F67 -> 03C9 0314 0342';
ok Uni.new(0x1F68).NFD.list ~~ (0x03A9, 0x0313,), '1F68 -> 03A9 0313';
ok Uni.new(0x1F69).NFD.list ~~ (0x03A9, 0x0314,), '1F69 -> 03A9 0314';
ok Uni.new(0x1F6A).NFD.list ~~ (0x03A9, 0x0313, 0x0300,), '1F6A -> 03A9 0313 0300';
ok Uni.new(0x1F6B).NFD.list ~~ (0x03A9, 0x0314, 0x0300,), '1F6B -> 03A9 0314 0300';
ok Uni.new(0x1F6C).NFD.list ~~ (0x03A9, 0x0313, 0x0301,), '1F6C -> 03A9 0313 0301';
ok Uni.new(0x1F6D).NFD.list ~~ (0x03A9, 0x0314, 0x0301,), '1F6D -> 03A9 0314 0301';
ok Uni.new(0x1F6E).NFD.list ~~ (0x03A9, 0x0313, 0x0342,), '1F6E -> 03A9 0313 0342';
ok Uni.new(0x1F6F).NFD.list ~~ (0x03A9, 0x0314, 0x0342,), '1F6F -> 03A9 0314 0342';
ok Uni.new(0x1F70).NFD.list ~~ (0x03B1, 0x0300,), '1F70 -> 03B1 0300';
ok Uni.new(0x1F71).NFD.list ~~ (0x03B1, 0x0301,), '1F71 -> 03B1 0301';
ok Uni.new(0x1F72).NFD.list ~~ (0x03B5, 0x0300,), '1F72 -> 03B5 0300';
ok Uni.new(0x1F73).NFD.list ~~ (0x03B5, 0x0301,), '1F73 -> 03B5 0301';
ok Uni.new(0x1F74).NFD.list ~~ (0x03B7, 0x0300,), '1F74 -> 03B7 0300';
ok Uni.new(0x1F75).NFD.list ~~ (0x03B7, 0x0301,), '1F75 -> 03B7 0301';
ok Uni.new(0x1F76).NFD.list ~~ (0x03B9, 0x0300,), '1F76 -> 03B9 0300';
ok Uni.new(0x1F77).NFD.list ~~ (0x03B9, 0x0301,), '1F77 -> 03B9 0301';
ok Uni.new(0x1F78).NFD.list ~~ (0x03BF, 0x0300,), '1F78 -> 03BF 0300';
ok Uni.new(0x1F79).NFD.list ~~ (0x03BF, 0x0301,), '1F79 -> 03BF 0301';
ok Uni.new(0x1F7A).NFD.list ~~ (0x03C5, 0x0300,), '1F7A -> 03C5 0300';
ok Uni.new(0x1F7B).NFD.list ~~ (0x03C5, 0x0301,), '1F7B -> 03C5 0301';
ok Uni.new(0x1F7C).NFD.list ~~ (0x03C9, 0x0300,), '1F7C -> 03C9 0300';
ok Uni.new(0x1F7D).NFD.list ~~ (0x03C9, 0x0301,), '1F7D -> 03C9 0301';
ok Uni.new(0x1F80).NFD.list ~~ (0x03B1, 0x0313, 0x0345,), '1F80 -> 03B1 0313 0345';
ok Uni.new(0x1F81).NFD.list ~~ (0x03B1, 0x0314, 0x0345,), '1F81 -> 03B1 0314 0345';
ok Uni.new(0x1F82).NFD.list ~~ (0x03B1, 0x0313, 0x0300, 0x0345,), '1F82 -> 03B1 0313 0300 0345';
ok Uni.new(0x1F83).NFD.list ~~ (0x03B1, 0x0314, 0x0300, 0x0345,), '1F83 -> 03B1 0314 0300 0345';
ok Uni.new(0x1F84).NFD.list ~~ (0x03B1, 0x0313, 0x0301, 0x0345,), '1F84 -> 03B1 0313 0301 0345';
ok Uni.new(0x1F85).NFD.list ~~ (0x03B1, 0x0314, 0x0301, 0x0345,), '1F85 -> 03B1 0314 0301 0345';
ok Uni.new(0x1F86).NFD.list ~~ (0x03B1, 0x0313, 0x0342, 0x0345,), '1F86 -> 03B1 0313 0342 0345';
ok Uni.new(0x1F87).NFD.list ~~ (0x03B1, 0x0314, 0x0342, 0x0345,), '1F87 -> 03B1 0314 0342 0345';
ok Uni.new(0x1F88).NFD.list ~~ (0x0391, 0x0313, 0x0345,), '1F88 -> 0391 0313 0345';
ok Uni.new(0x1F89).NFD.list ~~ (0x0391, 0x0314, 0x0345,), '1F89 -> 0391 0314 0345';
ok Uni.new(0x1F8A).NFD.list ~~ (0x0391, 0x0313, 0x0300, 0x0345,), '1F8A -> 0391 0313 0300 0345';
ok Uni.new(0x1F8B).NFD.list ~~ (0x0391, 0x0314, 0x0300, 0x0345,), '1F8B -> 0391 0314 0300 0345';
ok Uni.new(0x1F8C).NFD.list ~~ (0x0391, 0x0313, 0x0301, 0x0345,), '1F8C -> 0391 0313 0301 0345';
ok Uni.new(0x1F8D).NFD.list ~~ (0x0391, 0x0314, 0x0301, 0x0345,), '1F8D -> 0391 0314 0301 0345';
ok Uni.new(0x1F8E).NFD.list ~~ (0x0391, 0x0313, 0x0342, 0x0345,), '1F8E -> 0391 0313 0342 0345';
ok Uni.new(0x1F8F).NFD.list ~~ (0x0391, 0x0314, 0x0342, 0x0345,), '1F8F -> 0391 0314 0342 0345';
ok Uni.new(0x1F90).NFD.list ~~ (0x03B7, 0x0313, 0x0345,), '1F90 -> 03B7 0313 0345';
ok Uni.new(0x1F91).NFD.list ~~ (0x03B7, 0x0314, 0x0345,), '1F91 -> 03B7 0314 0345';
ok Uni.new(0x1F92).NFD.list ~~ (0x03B7, 0x0313, 0x0300, 0x0345,), '1F92 -> 03B7 0313 0300 0345';
ok Uni.new(0x1F93).NFD.list ~~ (0x03B7, 0x0314, 0x0300, 0x0345,), '1F93 -> 03B7 0314 0300 0345';
ok Uni.new(0x1F94).NFD.list ~~ (0x03B7, 0x0313, 0x0301, 0x0345,), '1F94 -> 03B7 0313 0301 0345';
ok Uni.new(0x1F95).NFD.list ~~ (0x03B7, 0x0314, 0x0301, 0x0345,), '1F95 -> 03B7 0314 0301 0345';
ok Uni.new(0x1F96).NFD.list ~~ (0x03B7, 0x0313, 0x0342, 0x0345,), '1F96 -> 03B7 0313 0342 0345';
ok Uni.new(0x1F97).NFD.list ~~ (0x03B7, 0x0314, 0x0342, 0x0345,), '1F97 -> 03B7 0314 0342 0345';
ok Uni.new(0x1F98).NFD.list ~~ (0x0397, 0x0313, 0x0345,), '1F98 -> 0397 0313 0345';
ok Uni.new(0x1F99).NFD.list ~~ (0x0397, 0x0314, 0x0345,), '1F99 -> 0397 0314 0345';
ok Uni.new(0x1F9A).NFD.list ~~ (0x0397, 0x0313, 0x0300, 0x0345,), '1F9A -> 0397 0313 0300 0345';
ok Uni.new(0x1F9B).NFD.list ~~ (0x0397, 0x0314, 0x0300, 0x0345,), '1F9B -> 0397 0314 0300 0345';
ok Uni.new(0x1F9C).NFD.list ~~ (0x0397, 0x0313, 0x0301, 0x0345,), '1F9C -> 0397 0313 0301 0345';
ok Uni.new(0x1F9D).NFD.list ~~ (0x0397, 0x0314, 0x0301, 0x0345,), '1F9D -> 0397 0314 0301 0345';
ok Uni.new(0x1F9E).NFD.list ~~ (0x0397, 0x0313, 0x0342, 0x0345,), '1F9E -> 0397 0313 0342 0345';
ok Uni.new(0x1F9F).NFD.list ~~ (0x0397, 0x0314, 0x0342, 0x0345,), '1F9F -> 0397 0314 0342 0345';
ok Uni.new(0x1FA0).NFD.list ~~ (0x03C9, 0x0313, 0x0345,), '1FA0 -> 03C9 0313 0345';
ok Uni.new(0x1FA1).NFD.list ~~ (0x03C9, 0x0314, 0x0345,), '1FA1 -> 03C9 0314 0345';
ok Uni.new(0x1FA2).NFD.list ~~ (0x03C9, 0x0313, 0x0300, 0x0345,), '1FA2 -> 03C9 0313 0300 0345';
ok Uni.new(0x1FA3).NFD.list ~~ (0x03C9, 0x0314, 0x0300, 0x0345,), '1FA3 -> 03C9 0314 0300 0345';
ok Uni.new(0x1FA4).NFD.list ~~ (0x03C9, 0x0313, 0x0301, 0x0345,), '1FA4 -> 03C9 0313 0301 0345';
ok Uni.new(0x1FA5).NFD.list ~~ (0x03C9, 0x0314, 0x0301, 0x0345,), '1FA5 -> 03C9 0314 0301 0345';
ok Uni.new(0x1FA6).NFD.list ~~ (0x03C9, 0x0313, 0x0342, 0x0345,), '1FA6 -> 03C9 0313 0342 0345';
ok Uni.new(0x1FA7).NFD.list ~~ (0x03C9, 0x0314, 0x0342, 0x0345,), '1FA7 -> 03C9 0314 0342 0345';
ok Uni.new(0x1FA8).NFD.list ~~ (0x03A9, 0x0313, 0x0345,), '1FA8 -> 03A9 0313 0345';
ok Uni.new(0x1FA9).NFD.list ~~ (0x03A9, 0x0314, 0x0345,), '1FA9 -> 03A9 0314 0345';
ok Uni.new(0x1FAA).NFD.list ~~ (0x03A9, 0x0313, 0x0300, 0x0345,), '1FAA -> 03A9 0313 0300 0345';
ok Uni.new(0x1FAB).NFD.list ~~ (0x03A9, 0x0314, 0x0300, 0x0345,), '1FAB -> 03A9 0314 0300 0345';
ok Uni.new(0x1FAC).NFD.list ~~ (0x03A9, 0x0313, 0x0301, 0x0345,), '1FAC -> 03A9 0313 0301 0345';
ok Uni.new(0x1FAD).NFD.list ~~ (0x03A9, 0x0314, 0x0301, 0x0345,), '1FAD -> 03A9 0314 0301 0345';
ok Uni.new(0x1FAE).NFD.list ~~ (0x03A9, 0x0313, 0x0342, 0x0345,), '1FAE -> 03A9 0313 0342 0345';
ok Uni.new(0x1FAF).NFD.list ~~ (0x03A9, 0x0314, 0x0342, 0x0345,), '1FAF -> 03A9 0314 0342 0345';
ok Uni.new(0x1FB0).NFD.list ~~ (0x03B1, 0x0306,), '1FB0 -> 03B1 0306';
ok Uni.new(0x1FB1).NFD.list ~~ (0x03B1, 0x0304,), '1FB1 -> 03B1 0304';
ok Uni.new(0x1FB2).NFD.list ~~ (0x03B1, 0x0300, 0x0345,), '1FB2 -> 03B1 0300 0345';
ok Uni.new(0x1FB3).NFD.list ~~ (0x03B1, 0x0345,), '1FB3 -> 03B1 0345';
ok Uni.new(0x1FB4).NFD.list ~~ (0x03B1, 0x0301, 0x0345,), '1FB4 -> 03B1 0301 0345';
ok Uni.new(0x1FB6).NFD.list ~~ (0x03B1, 0x0342,), '1FB6 -> 03B1 0342';
ok Uni.new(0x1FB7).NFD.list ~~ (0x03B1, 0x0342, 0x0345,), '1FB7 -> 03B1 0342 0345';
ok Uni.new(0x1FB8).NFD.list ~~ (0x0391, 0x0306,), '1FB8 -> 0391 0306';
ok Uni.new(0x1FB9).NFD.list ~~ (0x0391, 0x0304,), '1FB9 -> 0391 0304';
ok Uni.new(0x1FBA).NFD.list ~~ (0x0391, 0x0300,), '1FBA -> 0391 0300';
ok Uni.new(0x1FBB).NFD.list ~~ (0x0391, 0x0301,), '1FBB -> 0391 0301';
ok Uni.new(0x1FBC).NFD.list ~~ (0x0391, 0x0345,), '1FBC -> 0391 0345';
ok Uni.new(0x1FBD).NFD.list ~~ (0x1FBD,), '1FBD -> 1FBD';
ok Uni.new(0x1FBE).NFD.list ~~ (0x03B9,), '1FBE -> 03B9';
ok Uni.new(0x1FBF).NFD.list ~~ (0x1FBF,), '1FBF -> 1FBF';
ok Uni.new(0x1FC0).NFD.list ~~ (0x1FC0,), '1FC0 -> 1FC0';
ok Uni.new(0x1FC1).NFD.list ~~ (0x00A8, 0x0342,), '1FC1 -> 00A8 0342';
ok Uni.new(0x1FC2).NFD.list ~~ (0x03B7, 0x0300, 0x0345,), '1FC2 -> 03B7 0300 0345';
ok Uni.new(0x1FC3).NFD.list ~~ (0x03B7, 0x0345,), '1FC3 -> 03B7 0345';
ok Uni.new(0x1FC4).NFD.list ~~ (0x03B7, 0x0301, 0x0345,), '1FC4 -> 03B7 0301 0345';
ok Uni.new(0x1FC6).NFD.list ~~ (0x03B7, 0x0342,), '1FC6 -> 03B7 0342';
ok Uni.new(0x1FC7).NFD.list ~~ (0x03B7, 0x0342, 0x0345,), '1FC7 -> 03B7 0342 0345';
ok Uni.new(0x1FC8).NFD.list ~~ (0x0395, 0x0300,), '1FC8 -> 0395 0300';
ok Uni.new(0x1FC9).NFD.list ~~ (0x0395, 0x0301,), '1FC9 -> 0395 0301';
ok Uni.new(0x1FCA).NFD.list ~~ (0x0397, 0x0300,), '1FCA -> 0397 0300';
ok Uni.new(0x1FCB).NFD.list ~~ (0x0397, 0x0301,), '1FCB -> 0397 0301';
ok Uni.new(0x1FCC).NFD.list ~~ (0x0397, 0x0345,), '1FCC -> 0397 0345';
ok Uni.new(0x1FCD).NFD.list ~~ (0x1FBF, 0x0300,), '1FCD -> 1FBF 0300';
ok Uni.new(0x1FCE).NFD.list ~~ (0x1FBF, 0x0301,), '1FCE -> 1FBF 0301';
ok Uni.new(0x1FCF).NFD.list ~~ (0x1FBF, 0x0342,), '1FCF -> 1FBF 0342';
ok Uni.new(0x1FD0).NFD.list ~~ (0x03B9, 0x0306,), '1FD0 -> 03B9 0306';
ok Uni.new(0x1FD1).NFD.list ~~ (0x03B9, 0x0304,), '1FD1 -> 03B9 0304';
ok Uni.new(0x1FD2).NFD.list ~~ (0x03B9, 0x0308, 0x0300,), '1FD2 -> 03B9 0308 0300';
ok Uni.new(0x1FD3).NFD.list ~~ (0x03B9, 0x0308, 0x0301,), '1FD3 -> 03B9 0308 0301';
ok Uni.new(0x1FD6).NFD.list ~~ (0x03B9, 0x0342,), '1FD6 -> 03B9 0342';
ok Uni.new(0x1FD7).NFD.list ~~ (0x03B9, 0x0308, 0x0342,), '1FD7 -> 03B9 0308 0342';
ok Uni.new(0x1FD8).NFD.list ~~ (0x0399, 0x0306,), '1FD8 -> 0399 0306';
ok Uni.new(0x1FD9).NFD.list ~~ (0x0399, 0x0304,), '1FD9 -> 0399 0304';
ok Uni.new(0x1FDA).NFD.list ~~ (0x0399, 0x0300,), '1FDA -> 0399 0300';
ok Uni.new(0x1FDB).NFD.list ~~ (0x0399, 0x0301,), '1FDB -> 0399 0301';
ok Uni.new(0x1FDD).NFD.list ~~ (0x1FFE, 0x0300,), '1FDD -> 1FFE 0300';
ok Uni.new(0x1FDE).NFD.list ~~ (0x1FFE, 0x0301,), '1FDE -> 1FFE 0301';
ok Uni.new(0x1FDF).NFD.list ~~ (0x1FFE, 0x0342,), '1FDF -> 1FFE 0342';
ok Uni.new(0x1FE0).NFD.list ~~ (0x03C5, 0x0306,), '1FE0 -> 03C5 0306';
ok Uni.new(0x1FE1).NFD.list ~~ (0x03C5, 0x0304,), '1FE1 -> 03C5 0304';
ok Uni.new(0x1FE2).NFD.list ~~ (0x03C5, 0x0308, 0x0300,), '1FE2 -> 03C5 0308 0300';
ok Uni.new(0x1FE3).NFD.list ~~ (0x03C5, 0x0308, 0x0301,), '1FE3 -> 03C5 0308 0301';
ok Uni.new(0x1FE4).NFD.list ~~ (0x03C1, 0x0313,), '1FE4 -> 03C1 0313';
ok Uni.new(0x1FE5).NFD.list ~~ (0x03C1, 0x0314,), '1FE5 -> 03C1 0314';
ok Uni.new(0x1FE6).NFD.list ~~ (0x03C5, 0x0342,), '1FE6 -> 03C5 0342';
ok Uni.new(0x1FE7).NFD.list ~~ (0x03C5, 0x0308, 0x0342,), '1FE7 -> 03C5 0308 0342';
ok Uni.new(0x1FE8).NFD.list ~~ (0x03A5, 0x0306,), '1FE8 -> 03A5 0306';
ok Uni.new(0x1FE9).NFD.list ~~ (0x03A5, 0x0304,), '1FE9 -> 03A5 0304';
ok Uni.new(0x1FEA).NFD.list ~~ (0x03A5, 0x0300,), '1FEA -> 03A5 0300';
ok Uni.new(0x1FEB).NFD.list ~~ (0x03A5, 0x0301,), '1FEB -> 03A5 0301';
ok Uni.new(0x1FEC).NFD.list ~~ (0x03A1, 0x0314,), '1FEC -> 03A1 0314';
ok Uni.new(0x1FED).NFD.list ~~ (0x00A8, 0x0300,), '1FED -> 00A8 0300';
ok Uni.new(0x1FEE).NFD.list ~~ (0x00A8, 0x0301,), '1FEE -> 00A8 0301';
ok Uni.new(0x1FEF).NFD.list ~~ (0x0060,), '1FEF -> 0060';
ok Uni.new(0x1FF2).NFD.list ~~ (0x03C9, 0x0300, 0x0345,), '1FF2 -> 03C9 0300 0345';
ok Uni.new(0x1FF3).NFD.list ~~ (0x03C9, 0x0345,), '1FF3 -> 03C9 0345';
ok Uni.new(0x1FF4).NFD.list ~~ (0x03C9, 0x0301, 0x0345,), '1FF4 -> 03C9 0301 0345';
ok Uni.new(0x1FF6).NFD.list ~~ (0x03C9, 0x0342,), '1FF6 -> 03C9 0342';
ok Uni.new(0x1FF7).NFD.list ~~ (0x03C9, 0x0342, 0x0345,), '1FF7 -> 03C9 0342 0345';
ok Uni.new(0x1FF8).NFD.list ~~ (0x039F, 0x0300,), '1FF8 -> 039F 0300';
ok Uni.new(0x1FF9).NFD.list ~~ (0x039F, 0x0301,), '1FF9 -> 039F 0301';
ok Uni.new(0x1FFA).NFD.list ~~ (0x03A9, 0x0300,), '1FFA -> 03A9 0300';
ok Uni.new(0x1FFB).NFD.list ~~ (0x03A9, 0x0301,), '1FFB -> 03A9 0301';
ok Uni.new(0x1FFC).NFD.list ~~ (0x03A9, 0x0345,), '1FFC -> 03A9 0345';
ok Uni.new(0x1FFD).NFD.list ~~ (0x00B4,), '1FFD -> 00B4';
ok Uni.new(0x1FFE).NFD.list ~~ (0x1FFE,), '1FFE -> 1FFE';
ok Uni.new(0x2000).NFD.list ~~ (0x2002,), '2000 -> 2002';
ok Uni.new(0x2001).NFD.list ~~ (0x2003,), '2001 -> 2003';
ok Uni.new(0x2002).NFD.list ~~ (0x2002,), '2002 -> 2002';
ok Uni.new(0x2003).NFD.list ~~ (0x2003,), '2003 -> 2003';
ok Uni.new(0x2004).NFD.list ~~ (0x2004,), '2004 -> 2004';
ok Uni.new(0x2005).NFD.list ~~ (0x2005,), '2005 -> 2005';
ok Uni.new(0x2006).NFD.list ~~ (0x2006,), '2006 -> 2006';
ok Uni.new(0x2007).NFD.list ~~ (0x2007,), '2007 -> 2007';
ok Uni.new(0x2008).NFD.list ~~ (0x2008,), '2008 -> 2008';
ok Uni.new(0x2009).NFD.list ~~ (0x2009,), '2009 -> 2009';
ok Uni.new(0x200A).NFD.list ~~ (0x200A,), '200A -> 200A';
ok Uni.new(0x2011).NFD.list ~~ (0x2011,), '2011 -> 2011';
ok Uni.new(0x2017).NFD.list ~~ (0x2017,), '2017 -> 2017';
ok Uni.new(0x2024).NFD.list ~~ (0x2024,), '2024 -> 2024';
ok Uni.new(0x2025).NFD.list ~~ (0x2025,), '2025 -> 2025';
ok Uni.new(0x2026).NFD.list ~~ (0x2026,), '2026 -> 2026';
ok Uni.new(0x202F).NFD.list ~~ (0x202F,), '202F -> 202F';
ok Uni.new(0x2033).NFD.list ~~ (0x2033,), '2033 -> 2033';
ok Uni.new(0x2034).NFD.list ~~ (0x2034,), '2034 -> 2034';
ok Uni.new(0x2036).NFD.list ~~ (0x2036,), '2036 -> 2036';
ok Uni.new(0x2037).NFD.list ~~ (0x2037,), '2037 -> 2037';
ok Uni.new(0x203C).NFD.list ~~ (0x203C,), '203C -> 203C';
ok Uni.new(0x203E).NFD.list ~~ (0x203E,), '203E -> 203E';
ok Uni.new(0x2047).NFD.list ~~ (0x2047,), '2047 -> 2047';
ok Uni.new(0x2048).NFD.list ~~ (0x2048,), '2048 -> 2048';
ok Uni.new(0x2049).NFD.list ~~ (0x2049,), '2049 -> 2049';
ok Uni.new(0x2057).NFD.list ~~ (0x2057,), '2057 -> 2057';
ok Uni.new(0x205F).NFD.list ~~ (0x205F,), '205F -> 205F';
ok Uni.new(0x2070).NFD.list ~~ (0x2070,), '2070 -> 2070';
ok Uni.new(0x2071).NFD.list ~~ (0x2071,), '2071 -> 2071';
ok Uni.new(0x2074).NFD.list ~~ (0x2074,), '2074 -> 2074';
ok Uni.new(0x2075).NFD.list ~~ (0x2075,), '2075 -> 2075';
ok Uni.new(0x2076).NFD.list ~~ (0x2076,), '2076 -> 2076';
ok Uni.new(0x2077).NFD.list ~~ (0x2077,), '2077 -> 2077';
ok Uni.new(0x2078).NFD.list ~~ (0x2078,), '2078 -> 2078';
ok Uni.new(0x2079).NFD.list ~~ (0x2079,), '2079 -> 2079';
ok Uni.new(0x207A).NFD.list ~~ (0x207A,), '207A -> 207A';
ok Uni.new(0x207B).NFD.list ~~ (0x207B,), '207B -> 207B';
ok Uni.new(0x207C).NFD.list ~~ (0x207C,), '207C -> 207C';
ok Uni.new(0x207D).NFD.list ~~ (0x207D,), '207D -> 207D';
ok Uni.new(0x207E).NFD.list ~~ (0x207E,), '207E -> 207E';
ok Uni.new(0x207F).NFD.list ~~ (0x207F,), '207F -> 207F';
ok Uni.new(0x2080).NFD.list ~~ (0x2080,), '2080 -> 2080';
ok Uni.new(0x2081).NFD.list ~~ (0x2081,), '2081 -> 2081';
ok Uni.new(0x2082).NFD.list ~~ (0x2082,), '2082 -> 2082';
ok Uni.new(0x2083).NFD.list ~~ (0x2083,), '2083 -> 2083';
ok Uni.new(0x2084).NFD.list ~~ (0x2084,), '2084 -> 2084';
ok Uni.new(0x2085).NFD.list ~~ (0x2085,), '2085 -> 2085';
ok Uni.new(0x2086).NFD.list ~~ (0x2086,), '2086 -> 2086';
ok Uni.new(0x2087).NFD.list ~~ (0x2087,), '2087 -> 2087';
ok Uni.new(0x2088).NFD.list ~~ (0x2088,), '2088 -> 2088';
ok Uni.new(0x2089).NFD.list ~~ (0x2089,), '2089 -> 2089';
ok Uni.new(0x208A).NFD.list ~~ (0x208A,), '208A -> 208A';
ok Uni.new(0x208B).NFD.list ~~ (0x208B,), '208B -> 208B';
ok Uni.new(0x208C).NFD.list ~~ (0x208C,), '208C -> 208C';
ok Uni.new(0x208D).NFD.list ~~ (0x208D,), '208D -> 208D';
ok Uni.new(0x208E).NFD.list ~~ (0x208E,), '208E -> 208E';
ok Uni.new(0x2090).NFD.list ~~ (0x2090,), '2090 -> 2090';
ok Uni.new(0x2091).NFD.list ~~ (0x2091,), '2091 -> 2091';
ok Uni.new(0x2092).NFD.list ~~ (0x2092,), '2092 -> 2092';
ok Uni.new(0x2093).NFD.list ~~ (0x2093,), '2093 -> 2093';
ok Uni.new(0x2094).NFD.list ~~ (0x2094,), '2094 -> 2094';
ok Uni.new(0x2095).NFD.list ~~ (0x2095,), '2095 -> 2095';
ok Uni.new(0x2096).NFD.list ~~ (0x2096,), '2096 -> 2096';
ok Uni.new(0x2097).NFD.list ~~ (0x2097,), '2097 -> 2097';
ok Uni.new(0x2098).NFD.list ~~ (0x2098,), '2098 -> 2098';
ok Uni.new(0x2099).NFD.list ~~ (0x2099,), '2099 -> 2099';
ok Uni.new(0x209A).NFD.list ~~ (0x209A,), '209A -> 209A';
ok Uni.new(0x209B).NFD.list ~~ (0x209B,), '209B -> 209B';
ok Uni.new(0x209C).NFD.list ~~ (0x209C,), '209C -> 209C';
ok Uni.new(0x20A8).NFD.list ~~ (0x20A8,), '20A8 -> 20A8';
ok Uni.new(0x2100).NFD.list ~~ (0x2100,), '2100 -> 2100';
ok Uni.new(0x2101).NFD.list ~~ (0x2101,), '2101 -> 2101';
ok Uni.new(0x2102).NFD.list ~~ (0x2102,), '2102 -> 2102';
ok Uni.new(0x2103).NFD.list ~~ (0x2103,), '2103 -> 2103';
ok Uni.new(0x2105).NFD.list ~~ (0x2105,), '2105 -> 2105';
ok Uni.new(0x2106).NFD.list ~~ (0x2106,), '2106 -> 2106';
ok Uni.new(0x2107).NFD.list ~~ (0x2107,), '2107 -> 2107';
ok Uni.new(0x2109).NFD.list ~~ (0x2109,), '2109 -> 2109';
ok Uni.new(0x210A).NFD.list ~~ (0x210A,), '210A -> 210A';
ok Uni.new(0x210B).NFD.list ~~ (0x210B,), '210B -> 210B';
ok Uni.new(0x210C).NFD.list ~~ (0x210C,), '210C -> 210C';
ok Uni.new(0x210D).NFD.list ~~ (0x210D,), '210D -> 210D';
ok Uni.new(0x210E).NFD.list ~~ (0x210E,), '210E -> 210E';
ok Uni.new(0x210F).NFD.list ~~ (0x210F,), '210F -> 210F';
ok Uni.new(0x2110).NFD.list ~~ (0x2110,), '2110 -> 2110';
ok Uni.new(0x2111).NFD.list ~~ (0x2111,), '2111 -> 2111';
ok Uni.new(0x2112).NFD.list ~~ (0x2112,), '2112 -> 2112';
ok Uni.new(0x2113).NFD.list ~~ (0x2113,), '2113 -> 2113';
ok Uni.new(0x2115).NFD.list ~~ (0x2115,), '2115 -> 2115';
ok Uni.new(0x2116).NFD.list ~~ (0x2116,), '2116 -> 2116';
ok Uni.new(0x2119).NFD.list ~~ (0x2119,), '2119 -> 2119';
ok Uni.new(0x211A).NFD.list ~~ (0x211A,), '211A -> 211A';
ok Uni.new(0x211B).NFD.list ~~ (0x211B,), '211B -> 211B';
ok Uni.new(0x211C).NFD.list ~~ (0x211C,), '211C -> 211C';
ok Uni.new(0x211D).NFD.list ~~ (0x211D,), '211D -> 211D';
ok Uni.new(0x2120).NFD.list ~~ (0x2120,), '2120 -> 2120';
ok Uni.new(0x2121).NFD.list ~~ (0x2121,), '2121 -> 2121';
ok Uni.new(0x2122).NFD.list ~~ (0x2122,), '2122 -> 2122';
ok Uni.new(0x2124).NFD.list ~~ (0x2124,), '2124 -> 2124';
ok Uni.new(0x2126).NFD.list ~~ (0x03A9,), '2126 -> 03A9';
ok Uni.new(0x2128).NFD.list ~~ (0x2128,), '2128 -> 2128';
ok Uni.new(0x212A).NFD.list ~~ (0x004B,), '212A -> 004B';
ok Uni.new(0x212B).NFD.list ~~ (0x0041, 0x030A,), '212B -> 0041 030A';
ok Uni.new(0x212C).NFD.list ~~ (0x212C,), '212C -> 212C';
ok Uni.new(0x212D).NFD.list ~~ (0x212D,), '212D -> 212D';
ok Uni.new(0x212F).NFD.list ~~ (0x212F,), '212F -> 212F';
ok Uni.new(0x2130).NFD.list ~~ (0x2130,), '2130 -> 2130';
ok Uni.new(0x2131).NFD.list ~~ (0x2131,), '2131 -> 2131';
ok Uni.new(0x2133).NFD.list ~~ (0x2133,), '2133 -> 2133';
ok Uni.new(0x2134).NFD.list ~~ (0x2134,), '2134 -> 2134';
ok Uni.new(0x2135).NFD.list ~~ (0x2135,), '2135 -> 2135';
ok Uni.new(0x2136).NFD.list ~~ (0x2136,), '2136 -> 2136';
ok Uni.new(0x2137).NFD.list ~~ (0x2137,), '2137 -> 2137';
ok Uni.new(0x2138).NFD.list ~~ (0x2138,), '2138 -> 2138';
ok Uni.new(0x2139).NFD.list ~~ (0x2139,), '2139 -> 2139';
ok Uni.new(0x213B).NFD.list ~~ (0x213B,), '213B -> 213B';
ok Uni.new(0x213C).NFD.list ~~ (0x213C,), '213C -> 213C';
ok Uni.new(0x213D).NFD.list ~~ (0x213D,), '213D -> 213D';
ok Uni.new(0x213E).NFD.list ~~ (0x213E,), '213E -> 213E';
ok Uni.new(0x213F).NFD.list ~~ (0x213F,), '213F -> 213F';
ok Uni.new(0x2140).NFD.list ~~ (0x2140,), '2140 -> 2140';
ok Uni.new(0x2145).NFD.list ~~ (0x2145,), '2145 -> 2145';
ok Uni.new(0x2146).NFD.list ~~ (0x2146,), '2146 -> 2146';
ok Uni.new(0x2147).NFD.list ~~ (0x2147,), '2147 -> 2147';
ok Uni.new(0x2148).NFD.list ~~ (0x2148,), '2148 -> 2148';
ok Uni.new(0x2149).NFD.list ~~ (0x2149,), '2149 -> 2149';
ok Uni.new(0x2150).NFD.list ~~ (0x2150,), '2150 -> 2150';
ok Uni.new(0x2151).NFD.list ~~ (0x2151,), '2151 -> 2151';
ok Uni.new(0x2152).NFD.list ~~ (0x2152,), '2152 -> 2152';
ok Uni.new(0x2153).NFD.list ~~ (0x2153,), '2153 -> 2153';
ok Uni.new(0x2154).NFD.list ~~ (0x2154,), '2154 -> 2154';
ok Uni.new(0x2155).NFD.list ~~ (0x2155,), '2155 -> 2155';
ok Uni.new(0x2156).NFD.list ~~ (0x2156,), '2156 -> 2156';
ok Uni.new(0x2157).NFD.list ~~ (0x2157,), '2157 -> 2157';
ok Uni.new(0x2158).NFD.list ~~ (0x2158,), '2158 -> 2158';
ok Uni.new(0x2159).NFD.list ~~ (0x2159,), '2159 -> 2159';
ok Uni.new(0x215A).NFD.list ~~ (0x215A,), '215A -> 215A';
ok Uni.new(0x215B).NFD.list ~~ (0x215B,), '215B -> 215B';
ok Uni.new(0x215C).NFD.list ~~ (0x215C,), '215C -> 215C';
ok Uni.new(0x215D).NFD.list ~~ (0x215D,), '215D -> 215D';
ok Uni.new(0x215E).NFD.list ~~ (0x215E,), '215E -> 215E';
ok Uni.new(0x215F).NFD.list ~~ (0x215F,), '215F -> 215F';
ok Uni.new(0x2160).NFD.list ~~ (0x2160,), '2160 -> 2160';
ok Uni.new(0x2161).NFD.list ~~ (0x2161,), '2161 -> 2161';
ok Uni.new(0x2162).NFD.list ~~ (0x2162,), '2162 -> 2162';
ok Uni.new(0x2163).NFD.list ~~ (0x2163,), '2163 -> 2163';
ok Uni.new(0x2164).NFD.list ~~ (0x2164,), '2164 -> 2164';
ok Uni.new(0x2165).NFD.list ~~ (0x2165,), '2165 -> 2165';
ok Uni.new(0x2166).NFD.list ~~ (0x2166,), '2166 -> 2166';
ok Uni.new(0x2167).NFD.list ~~ (0x2167,), '2167 -> 2167';
ok Uni.new(0x2168).NFD.list ~~ (0x2168,), '2168 -> 2168';
ok Uni.new(0x2169).NFD.list ~~ (0x2169,), '2169 -> 2169';
ok Uni.new(0x216A).NFD.list ~~ (0x216A,), '216A -> 216A';
ok Uni.new(0x216B).NFD.list ~~ (0x216B,), '216B -> 216B';
ok Uni.new(0x216C).NFD.list ~~ (0x216C,), '216C -> 216C';
ok Uni.new(0x216D).NFD.list ~~ (0x216D,), '216D -> 216D';
ok Uni.new(0x216E).NFD.list ~~ (0x216E,), '216E -> 216E';
ok Uni.new(0x216F).NFD.list ~~ (0x216F,), '216F -> 216F';
ok Uni.new(0x2170).NFD.list ~~ (0x2170,), '2170 -> 2170';
ok Uni.new(0x2171).NFD.list ~~ (0x2171,), '2171 -> 2171';
ok Uni.new(0x2172).NFD.list ~~ (0x2172,), '2172 -> 2172';
ok Uni.new(0x2173).NFD.list ~~ (0x2173,), '2173 -> 2173';
ok Uni.new(0x2174).NFD.list ~~ (0x2174,), '2174 -> 2174';
ok Uni.new(0x2175).NFD.list ~~ (0x2175,), '2175 -> 2175';
ok Uni.new(0x2176).NFD.list ~~ (0x2176,), '2176 -> 2176';
ok Uni.new(0x2177).NFD.list ~~ (0x2177,), '2177 -> 2177';
ok Uni.new(0x2178).NFD.list ~~ (0x2178,), '2178 -> 2178';
ok Uni.new(0x2179).NFD.list ~~ (0x2179,), '2179 -> 2179';
ok Uni.new(0x217A).NFD.list ~~ (0x217A,), '217A -> 217A';
ok Uni.new(0x217B).NFD.list ~~ (0x217B,), '217B -> 217B';
ok Uni.new(0x217C).NFD.list ~~ (0x217C,), '217C -> 217C';
ok Uni.new(0x217D).NFD.list ~~ (0x217D,), '217D -> 217D';
ok Uni.new(0x217E).NFD.list ~~ (0x217E,), '217E -> 217E';
ok Uni.new(0x217F).NFD.list ~~ (0x217F,), '217F -> 217F';
ok Uni.new(0x2189).NFD.list ~~ (0x2189,), '2189 -> 2189';
ok Uni.new(0x219A).NFD.list ~~ (0x2190, 0x0338,), '219A -> 2190 0338';
ok Uni.new(0x219B).NFD.list ~~ (0x2192, 0x0338,), '219B -> 2192 0338';
ok Uni.new(0x21AE).NFD.list ~~ (0x2194, 0x0338,), '21AE -> 2194 0338';
ok Uni.new(0x21CD).NFD.list ~~ (0x21D0, 0x0338,), '21CD -> 21D0 0338';
ok Uni.new(0x21CE).NFD.list ~~ (0x21D4, 0x0338,), '21CE -> 21D4 0338';
ok Uni.new(0x21CF).NFD.list ~~ (0x21D2, 0x0338,), '21CF -> 21D2 0338';
ok Uni.new(0x2204).NFD.list ~~ (0x2203, 0x0338,), '2204 -> 2203 0338';
ok Uni.new(0x2209).NFD.list ~~ (0x2208, 0x0338,), '2209 -> 2208 0338';
ok Uni.new(0x220C).NFD.list ~~ (0x220B, 0x0338,), '220C -> 220B 0338';
ok Uni.new(0x2224).NFD.list ~~ (0x2223, 0x0338,), '2224 -> 2223 0338';
ok Uni.new(0x2226).NFD.list ~~ (0x2225, 0x0338,), '2226 -> 2225 0338';
ok Uni.new(0x222C).NFD.list ~~ (0x222C,), '222C -> 222C';
ok Uni.new(0x222D).NFD.list ~~ (0x222D,), '222D -> 222D';
ok Uni.new(0x222F).NFD.list ~~ (0x222F,), '222F -> 222F';
ok Uni.new(0x2230).NFD.list ~~ (0x2230,), '2230 -> 2230';
ok Uni.new(0x2241).NFD.list ~~ (0x223C, 0x0338,), '2241 -> 223C 0338';
ok Uni.new(0x2244).NFD.list ~~ (0x2243, 0x0338,), '2244 -> 2243 0338';
ok Uni.new(0x2247).NFD.list ~~ (0x2245, 0x0338,), '2247 -> 2245 0338';
ok Uni.new(0x2249).NFD.list ~~ (0x2248, 0x0338,), '2249 -> 2248 0338';
ok Uni.new(0x2260).NFD.list ~~ (0x003D, 0x0338,), '2260 -> 003D 0338';
ok Uni.new(0x2262).NFD.list ~~ (0x2261, 0x0338,), '2262 -> 2261 0338';
ok Uni.new(0x226D).NFD.list ~~ (0x224D, 0x0338,), '226D -> 224D 0338';
ok Uni.new(0x226E).NFD.list ~~ (0x003C, 0x0338,), '226E -> 003C 0338';
ok Uni.new(0x226F).NFD.list ~~ (0x003E, 0x0338,), '226F -> 003E 0338';
ok Uni.new(0x2270).NFD.list ~~ (0x2264, 0x0338,), '2270 -> 2264 0338';
ok Uni.new(0x2271).NFD.list ~~ (0x2265, 0x0338,), '2271 -> 2265 0338';
ok Uni.new(0x2274).NFD.list ~~ (0x2272, 0x0338,), '2274 -> 2272 0338';
ok Uni.new(0x2275).NFD.list ~~ (0x2273, 0x0338,), '2275 -> 2273 0338';
ok Uni.new(0x2278).NFD.list ~~ (0x2276, 0x0338,), '2278 -> 2276 0338';
ok Uni.new(0x2279).NFD.list ~~ (0x2277, 0x0338,), '2279 -> 2277 0338';
ok Uni.new(0x2280).NFD.list ~~ (0x227A, 0x0338,), '2280 -> 227A 0338';
ok Uni.new(0x2281).NFD.list ~~ (0x227B, 0x0338,), '2281 -> 227B 0338';
ok Uni.new(0x2284).NFD.list ~~ (0x2282, 0x0338,), '2284 -> 2282 0338';
ok Uni.new(0x2285).NFD.list ~~ (0x2283, 0x0338,), '2285 -> 2283 0338';
ok Uni.new(0x2288).NFD.list ~~ (0x2286, 0x0338,), '2288 -> 2286 0338';
ok Uni.new(0x2289).NFD.list ~~ (0x2287, 0x0338,), '2289 -> 2287 0338';
ok Uni.new(0x22AC).NFD.list ~~ (0x22A2, 0x0338,), '22AC -> 22A2 0338';
ok Uni.new(0x22AD).NFD.list ~~ (0x22A8, 0x0338,), '22AD -> 22A8 0338';
ok Uni.new(0x22AE).NFD.list ~~ (0x22A9, 0x0338,), '22AE -> 22A9 0338';
ok Uni.new(0x22AF).NFD.list ~~ (0x22AB, 0x0338,), '22AF -> 22AB 0338';
ok Uni.new(0x22E0).NFD.list ~~ (0x227C, 0x0338,), '22E0 -> 227C 0338';
ok Uni.new(0x22E1).NFD.list ~~ (0x227D, 0x0338,), '22E1 -> 227D 0338';
ok Uni.new(0x22E2).NFD.list ~~ (0x2291, 0x0338,), '22E2 -> 2291 0338';
ok Uni.new(0x22E3).NFD.list ~~ (0x2292, 0x0338,), '22E3 -> 2292 0338';
ok Uni.new(0x22EA).NFD.list ~~ (0x22B2, 0x0338,), '22EA -> 22B2 0338';
ok Uni.new(0x22EB).NFD.list ~~ (0x22B3, 0x0338,), '22EB -> 22B3 0338';
ok Uni.new(0x22EC).NFD.list ~~ (0x22B4, 0x0338,), '22EC -> 22B4 0338';
ok Uni.new(0x22ED).NFD.list ~~ (0x22B5, 0x0338,), '22ED -> 22B5 0338';
ok Uni.new(0x2329).NFD.list ~~ (0x3008,), '2329 -> 3008';
ok Uni.new(0x232A).NFD.list ~~ (0x3009,), '232A -> 3009';
ok Uni.new(0x2460).NFD.list ~~ (0x2460,), '2460 -> 2460';
ok Uni.new(0x2461).NFD.list ~~ (0x2461,), '2461 -> 2461';
ok Uni.new(0x2462).NFD.list ~~ (0x2462,), '2462 -> 2462';
ok Uni.new(0x2463).NFD.list ~~ (0x2463,), '2463 -> 2463';
ok Uni.new(0x2464).NFD.list ~~ (0x2464,), '2464 -> 2464';
ok Uni.new(0x2465).NFD.list ~~ (0x2465,), '2465 -> 2465';
ok Uni.new(0x2466).NFD.list ~~ (0x2466,), '2466 -> 2466';
ok Uni.new(0x2467).NFD.list ~~ (0x2467,), '2467 -> 2467';
ok Uni.new(0x2468).NFD.list ~~ (0x2468,), '2468 -> 2468';
ok Uni.new(0x2469).NFD.list ~~ (0x2469,), '2469 -> 2469';
ok Uni.new(0x246A).NFD.list ~~ (0x246A,), '246A -> 246A';
ok Uni.new(0x246B).NFD.list ~~ (0x246B,), '246B -> 246B';
ok Uni.new(0x246C).NFD.list ~~ (0x246C,), '246C -> 246C';
ok Uni.new(0x246D).NFD.list ~~ (0x246D,), '246D -> 246D';
ok Uni.new(0x246E).NFD.list ~~ (0x246E,), '246E -> 246E';
ok Uni.new(0x246F).NFD.list ~~ (0x246F,), '246F -> 246F';
ok Uni.new(0x2470).NFD.list ~~ (0x2470,), '2470 -> 2470';
ok Uni.new(0x2471).NFD.list ~~ (0x2471,), '2471 -> 2471';
ok Uni.new(0x2472).NFD.list ~~ (0x2472,), '2472 -> 2472';
ok Uni.new(0x2473).NFD.list ~~ (0x2473,), '2473 -> 2473';
ok Uni.new(0x2474).NFD.list ~~ (0x2474,), '2474 -> 2474';
ok Uni.new(0x2475).NFD.list ~~ (0x2475,), '2475 -> 2475';
ok Uni.new(0x2476).NFD.list ~~ (0x2476,), '2476 -> 2476';
ok Uni.new(0x2477).NFD.list ~~ (0x2477,), '2477 -> 2477';
ok Uni.new(0x2478).NFD.list ~~ (0x2478,), '2478 -> 2478';
ok Uni.new(0x2479).NFD.list ~~ (0x2479,), '2479 -> 2479';
ok Uni.new(0x247A).NFD.list ~~ (0x247A,), '247A -> 247A';
ok Uni.new(0x247B).NFD.list ~~ (0x247B,), '247B -> 247B';
ok Uni.new(0x247C).NFD.list ~~ (0x247C,), '247C -> 247C';
ok Uni.new(0x247D).NFD.list ~~ (0x247D,), '247D -> 247D';
ok Uni.new(0x247E).NFD.list ~~ (0x247E,), '247E -> 247E';
ok Uni.new(0x247F).NFD.list ~~ (0x247F,), '247F -> 247F';
ok Uni.new(0x2480).NFD.list ~~ (0x2480,), '2480 -> 2480';
ok Uni.new(0x2481).NFD.list ~~ (0x2481,), '2481 -> 2481';
ok Uni.new(0x2482).NFD.list ~~ (0x2482,), '2482 -> 2482';
ok Uni.new(0x2483).NFD.list ~~ (0x2483,), '2483 -> 2483';
ok Uni.new(0x2484).NFD.list ~~ (0x2484,), '2484 -> 2484';
ok Uni.new(0x2485).NFD.list ~~ (0x2485,), '2485 -> 2485';
ok Uni.new(0x2486).NFD.list ~~ (0x2486,), '2486 -> 2486';
ok Uni.new(0x2487).NFD.list ~~ (0x2487,), '2487 -> 2487';
ok Uni.new(0x2488).NFD.list ~~ (0x2488,), '2488 -> 2488';
ok Uni.new(0x2489).NFD.list ~~ (0x2489,), '2489 -> 2489';
ok Uni.new(0x248A).NFD.list ~~ (0x248A,), '248A -> 248A';
ok Uni.new(0x248B).NFD.list ~~ (0x248B,), '248B -> 248B';
ok Uni.new(0x248C).NFD.list ~~ (0x248C,), '248C -> 248C';
ok Uni.new(0x248D).NFD.list ~~ (0x248D,), '248D -> 248D';
ok Uni.new(0x248E).NFD.list ~~ (0x248E,), '248E -> 248E';
ok Uni.new(0x248F).NFD.list ~~ (0x248F,), '248F -> 248F';
ok Uni.new(0x2490).NFD.list ~~ (0x2490,), '2490 -> 2490';
ok Uni.new(0x2491).NFD.list ~~ (0x2491,), '2491 -> 2491';
ok Uni.new(0x2492).NFD.list ~~ (0x2492,), '2492 -> 2492';
ok Uni.new(0x2493).NFD.list ~~ (0x2493,), '2493 -> 2493';
ok Uni.new(0x2494).NFD.list ~~ (0x2494,), '2494 -> 2494';
ok Uni.new(0x2495).NFD.list ~~ (0x2495,), '2495 -> 2495';
ok Uni.new(0x2496).NFD.list ~~ (0x2496,), '2496 -> 2496';
ok Uni.new(0x2497).NFD.list ~~ (0x2497,), '2497 -> 2497';
ok Uni.new(0x2498).NFD.list ~~ (0x2498,), '2498 -> 2498';
ok Uni.new(0x2499).NFD.list ~~ (0x2499,), '2499 -> 2499';
ok Uni.new(0x249A).NFD.list ~~ (0x249A,), '249A -> 249A';
ok Uni.new(0x249B).NFD.list ~~ (0x249B,), '249B -> 249B';
ok Uni.new(0x249C).NFD.list ~~ (0x249C,), '249C -> 249C';
ok Uni.new(0x249D).NFD.list ~~ (0x249D,), '249D -> 249D';
ok Uni.new(0x249E).NFD.list ~~ (0x249E,), '249E -> 249E';
ok Uni.new(0x249F).NFD.list ~~ (0x249F,), '249F -> 249F';
ok Uni.new(0x24A0).NFD.list ~~ (0x24A0,), '24A0 -> 24A0';
ok Uni.new(0x24A1).NFD.list ~~ (0x24A1,), '24A1 -> 24A1';
ok Uni.new(0x24A2).NFD.list ~~ (0x24A2,), '24A2 -> 24A2';
ok Uni.new(0x24A3).NFD.list ~~ (0x24A3,), '24A3 -> 24A3';
ok Uni.new(0x24A4).NFD.list ~~ (0x24A4,), '24A4 -> 24A4';
ok Uni.new(0x24A5).NFD.list ~~ (0x24A5,), '24A5 -> 24A5';
ok Uni.new(0x24A6).NFD.list ~~ (0x24A6,), '24A6 -> 24A6';
ok Uni.new(0x24A7).NFD.list ~~ (0x24A7,), '24A7 -> 24A7';
ok Uni.new(0x24A8).NFD.list ~~ (0x24A8,), '24A8 -> 24A8';
ok Uni.new(0x24A9).NFD.list ~~ (0x24A9,), '24A9 -> 24A9';
ok Uni.new(0x24AA).NFD.list ~~ (0x24AA,), '24AA -> 24AA';
ok Uni.new(0x24AB).NFD.list ~~ (0x24AB,), '24AB -> 24AB';
ok Uni.new(0x24AC).NFD.list ~~ (0x24AC,), '24AC -> 24AC';
ok Uni.new(0x24AD).NFD.list ~~ (0x24AD,), '24AD -> 24AD';
ok Uni.new(0x24AE).NFD.list ~~ (0x24AE,), '24AE -> 24AE';
ok Uni.new(0x24AF).NFD.list ~~ (0x24AF,), '24AF -> 24AF';
ok Uni.new(0x24B0).NFD.list ~~ (0x24B0,), '24B0 -> 24B0';
ok Uni.new(0x24B1).NFD.list ~~ (0x24B1,), '24B1 -> 24B1';
ok Uni.new(0x24B2).NFD.list ~~ (0x24B2,), '24B2 -> 24B2';
ok Uni.new(0x24B3).NFD.list ~~ (0x24B3,), '24B3 -> 24B3';
ok Uni.new(0x24B4).NFD.list ~~ (0x24B4,), '24B4 -> 24B4';
ok Uni.new(0x24B5).NFD.list ~~ (0x24B5,), '24B5 -> 24B5';
ok Uni.new(0x24B6).NFD.list ~~ (0x24B6,), '24B6 -> 24B6';
ok Uni.new(0x24B7).NFD.list ~~ (0x24B7,), '24B7 -> 24B7';
ok Uni.new(0x24B8).NFD.list ~~ (0x24B8,), '24B8 -> 24B8';
ok Uni.new(0x24B9).NFD.list ~~ (0x24B9,), '24B9 -> 24B9';
ok Uni.new(0x24BA).NFD.list ~~ (0x24BA,), '24BA -> 24BA';
ok Uni.new(0x24BB).NFD.list ~~ (0x24BB,), '24BB -> 24BB';
ok Uni.new(0x24BC).NFD.list ~~ (0x24BC,), '24BC -> 24BC';
ok Uni.new(0x24BD).NFD.list ~~ (0x24BD,), '24BD -> 24BD';
ok Uni.new(0x24BE).NFD.list ~~ (0x24BE,), '24BE -> 24BE';
ok Uni.new(0x24BF).NFD.list ~~ (0x24BF,), '24BF -> 24BF';
ok Uni.new(0x24C0).NFD.list ~~ (0x24C0,), '24C0 -> 24C0';
ok Uni.new(0x24C1).NFD.list ~~ (0x24C1,), '24C1 -> 24C1';
ok Uni.new(0x24C2).NFD.list ~~ (0x24C2,), '24C2 -> 24C2';
ok Uni.new(0x24C3).NFD.list ~~ (0x24C3,), '24C3 -> 24C3';
ok Uni.new(0x24C4).NFD.list ~~ (0x24C4,), '24C4 -> 24C4';
ok Uni.new(0x24C5).NFD.list ~~ (0x24C5,), '24C5 -> 24C5';
ok Uni.new(0x24C6).NFD.list ~~ (0x24C6,), '24C6 -> 24C6';
ok Uni.new(0x24C7).NFD.list ~~ (0x24C7,), '24C7 -> 24C7';
ok Uni.new(0x24C8).NFD.list ~~ (0x24C8,), '24C8 -> 24C8';
ok Uni.new(0x24C9).NFD.list ~~ (0x24C9,), '24C9 -> 24C9';
ok Uni.new(0x24CA).NFD.list ~~ (0x24CA,), '24CA -> 24CA';
ok Uni.new(0x24CB).NFD.list ~~ (0x24CB,), '24CB -> 24CB';
ok Uni.new(0x24CC).NFD.list ~~ (0x24CC,), '24CC -> 24CC';
ok Uni.new(0x24CD).NFD.list ~~ (0x24CD,), '24CD -> 24CD';
ok Uni.new(0x24CE).NFD.list ~~ (0x24CE,), '24CE -> 24CE';
ok Uni.new(0x24CF).NFD.list ~~ (0x24CF,), '24CF -> 24CF';
ok Uni.new(0x24D0).NFD.list ~~ (0x24D0,), '24D0 -> 24D0';
ok Uni.new(0x24D1).NFD.list ~~ (0x24D1,), '24D1 -> 24D1';
ok Uni.new(0x24D2).NFD.list ~~ (0x24D2,), '24D2 -> 24D2';
ok Uni.new(0x24D3).NFD.list ~~ (0x24D3,), '24D3 -> 24D3';
ok Uni.new(0x24D4).NFD.list ~~ (0x24D4,), '24D4 -> 24D4';
ok Uni.new(0x24D5).NFD.list ~~ (0x24D5,), '24D5 -> 24D5';
ok Uni.new(0x24D6).NFD.list ~~ (0x24D6,), '24D6 -> 24D6';
ok Uni.new(0x24D7).NFD.list ~~ (0x24D7,), '24D7 -> 24D7';
ok Uni.new(0x24D8).NFD.list ~~ (0x24D8,), '24D8 -> 24D8';
ok Uni.new(0x24D9).NFD.list ~~ (0x24D9,), '24D9 -> 24D9';
ok Uni.new(0x24DA).NFD.list ~~ (0x24DA,), '24DA -> 24DA';
ok Uni.new(0x24DB).NFD.list ~~ (0x24DB,), '24DB -> 24DB';
ok Uni.new(0x24DC).NFD.list ~~ (0x24DC,), '24DC -> 24DC';
ok Uni.new(0x24DD).NFD.list ~~ (0x24DD,), '24DD -> 24DD';
ok Uni.new(0x24DE).NFD.list ~~ (0x24DE,), '24DE -> 24DE';
ok Uni.new(0x24DF).NFD.list ~~ (0x24DF,), '24DF -> 24DF';
ok Uni.new(0x24E0).NFD.list ~~ (0x24E0,), '24E0 -> 24E0';
ok Uni.new(0x24E1).NFD.list ~~ (0x24E1,), '24E1 -> 24E1';
ok Uni.new(0x24E2).NFD.list ~~ (0x24E2,), '24E2 -> 24E2';
ok Uni.new(0x24E3).NFD.list ~~ (0x24E3,), '24E3 -> 24E3';
ok Uni.new(0x24E4).NFD.list ~~ (0x24E4,), '24E4 -> 24E4';
ok Uni.new(0x24E5).NFD.list ~~ (0x24E5,), '24E5 -> 24E5';
ok Uni.new(0x24E6).NFD.list ~~ (0x24E6,), '24E6 -> 24E6';
ok Uni.new(0x24E7).NFD.list ~~ (0x24E7,), '24E7 -> 24E7';
ok Uni.new(0x24E8).NFD.list ~~ (0x24E8,), '24E8 -> 24E8';
ok Uni.new(0x24E9).NFD.list ~~ (0x24E9,), '24E9 -> 24E9';
ok Uni.new(0x24EA).NFD.list ~~ (0x24EA,), '24EA -> 24EA';
ok Uni.new(0x2A0C).NFD.list ~~ (0x2A0C,), '2A0C -> 2A0C';
ok Uni.new(0x2A74).NFD.list ~~ (0x2A74,), '2A74 -> 2A74';
ok Uni.new(0x2A75).NFD.list ~~ (0x2A75,), '2A75 -> 2A75';
ok Uni.new(0x2A76).NFD.list ~~ (0x2A76,), '2A76 -> 2A76';
ok Uni.new(0x2ADC).NFD.list ~~ (0x2ADD, 0x0338,), '2ADC -> 2ADD 0338';
ok Uni.new(0x2C7C).NFD.list ~~ (0x2C7C,), '2C7C -> 2C7C';
ok Uni.new(0x2C7D).NFD.list ~~ (0x2C7D,), '2C7D -> 2C7D';
ok Uni.new(0x2D6F).NFD.list ~~ (0x2D6F,), '2D6F -> 2D6F';
ok Uni.new(0x2E9F).NFD.list ~~ (0x2E9F,), '2E9F -> 2E9F';
ok Uni.new(0x2EF3).NFD.list ~~ (0x2EF3,), '2EF3 -> 2EF3';
ok Uni.new(0x2F00).NFD.list ~~ (0x2F00,), '2F00 -> 2F00';
ok Uni.new(0x2F01).NFD.list ~~ (0x2F01,), '2F01 -> 2F01';
ok Uni.new(0x2F02).NFD.list ~~ (0x2F02,), '2F02 -> 2F02';
ok Uni.new(0x2F03).NFD.list ~~ (0x2F03,), '2F03 -> 2F03';
ok Uni.new(0x2F04).NFD.list ~~ (0x2F04,), '2F04 -> 2F04';
ok Uni.new(0x2F05).NFD.list ~~ (0x2F05,), '2F05 -> 2F05';
ok Uni.new(0x2F06).NFD.list ~~ (0x2F06,), '2F06 -> 2F06';
ok Uni.new(0x2F07).NFD.list ~~ (0x2F07,), '2F07 -> 2F07';
ok Uni.new(0x2F08).NFD.list ~~ (0x2F08,), '2F08 -> 2F08';
ok Uni.new(0x2F09).NFD.list ~~ (0x2F09,), '2F09 -> 2F09';
ok Uni.new(0x2F0A).NFD.list ~~ (0x2F0A,), '2F0A -> 2F0A';
ok Uni.new(0x2F0B).NFD.list ~~ (0x2F0B,), '2F0B -> 2F0B';
ok Uni.new(0x2F0C).NFD.list ~~ (0x2F0C,), '2F0C -> 2F0C';
ok Uni.new(0x2F0D).NFD.list ~~ (0x2F0D,), '2F0D -> 2F0D';
ok Uni.new(0x2F0E).NFD.list ~~ (0x2F0E,), '2F0E -> 2F0E';
ok Uni.new(0x2F0F).NFD.list ~~ (0x2F0F,), '2F0F -> 2F0F';
ok Uni.new(0x2F10).NFD.list ~~ (0x2F10,), '2F10 -> 2F10';
ok Uni.new(0x2F11).NFD.list ~~ (0x2F11,), '2F11 -> 2F11';
ok Uni.new(0x2F12).NFD.list ~~ (0x2F12,), '2F12 -> 2F12';
ok Uni.new(0x2F13).NFD.list ~~ (0x2F13,), '2F13 -> 2F13';
ok Uni.new(0x2F14).NFD.list ~~ (0x2F14,), '2F14 -> 2F14';
ok Uni.new(0x2F15).NFD.list ~~ (0x2F15,), '2F15 -> 2F15';
ok Uni.new(0x2F16).NFD.list ~~ (0x2F16,), '2F16 -> 2F16';
ok Uni.new(0x2F17).NFD.list ~~ (0x2F17,), '2F17 -> 2F17';
ok Uni.new(0x2F18).NFD.list ~~ (0x2F18,), '2F18 -> 2F18';
ok Uni.new(0x2F19).NFD.list ~~ (0x2F19,), '2F19 -> 2F19';
ok Uni.new(0x2F1A).NFD.list ~~ (0x2F1A,), '2F1A -> 2F1A';
ok Uni.new(0x2F1B).NFD.list ~~ (0x2F1B,), '2F1B -> 2F1B';
ok Uni.new(0x2F1C).NFD.list ~~ (0x2F1C,), '2F1C -> 2F1C';
ok Uni.new(0x2F1D).NFD.list ~~ (0x2F1D,), '2F1D -> 2F1D';
ok Uni.new(0x2F1E).NFD.list ~~ (0x2F1E,), '2F1E -> 2F1E';
ok Uni.new(0x2F1F).NFD.list ~~ (0x2F1F,), '2F1F -> 2F1F';
ok Uni.new(0x2F20).NFD.list ~~ (0x2F20,), '2F20 -> 2F20';
ok Uni.new(0x2F21).NFD.list ~~ (0x2F21,), '2F21 -> 2F21';
ok Uni.new(0x2F22).NFD.list ~~ (0x2F22,), '2F22 -> 2F22';
ok Uni.new(0x2F23).NFD.list ~~ (0x2F23,), '2F23 -> 2F23';
ok Uni.new(0x2F24).NFD.list ~~ (0x2F24,), '2F24 -> 2F24';
ok Uni.new(0x2F25).NFD.list ~~ (0x2F25,), '2F25 -> 2F25';
ok Uni.new(0x2F26).NFD.list ~~ (0x2F26,), '2F26 -> 2F26';
ok Uni.new(0x2F27).NFD.list ~~ (0x2F27,), '2F27 -> 2F27';
ok Uni.new(0x2F28).NFD.list ~~ (0x2F28,), '2F28 -> 2F28';
ok Uni.new(0x2F29).NFD.list ~~ (0x2F29,), '2F29 -> 2F29';
ok Uni.new(0x2F2A).NFD.list ~~ (0x2F2A,), '2F2A -> 2F2A';
ok Uni.new(0x2F2B).NFD.list ~~ (0x2F2B,), '2F2B -> 2F2B';
ok Uni.new(0x2F2C).NFD.list ~~ (0x2F2C,), '2F2C -> 2F2C';
ok Uni.new(0x2F2D).NFD.list ~~ (0x2F2D,), '2F2D -> 2F2D';
ok Uni.new(0x2F2E).NFD.list ~~ (0x2F2E,), '2F2E -> 2F2E';
ok Uni.new(0x2F2F).NFD.list ~~ (0x2F2F,), '2F2F -> 2F2F';
ok Uni.new(0x2F30).NFD.list ~~ (0x2F30,), '2F30 -> 2F30';
ok Uni.new(0x2F31).NFD.list ~~ (0x2F31,), '2F31 -> 2F31';
ok Uni.new(0x2F32).NFD.list ~~ (0x2F32,), '2F32 -> 2F32';
ok Uni.new(0x2F33).NFD.list ~~ (0x2F33,), '2F33 -> 2F33';
ok Uni.new(0x2F34).NFD.list ~~ (0x2F34,), '2F34 -> 2F34';
ok Uni.new(0x2F35).NFD.list ~~ (0x2F35,), '2F35 -> 2F35';
ok Uni.new(0x2F36).NFD.list ~~ (0x2F36,), '2F36 -> 2F36';
ok Uni.new(0x2F37).NFD.list ~~ (0x2F37,), '2F37 -> 2F37';
ok Uni.new(0x2F38).NFD.list ~~ (0x2F38,), '2F38 -> 2F38';
ok Uni.new(0x2F39).NFD.list ~~ (0x2F39,), '2F39 -> 2F39';
ok Uni.new(0x2F3A).NFD.list ~~ (0x2F3A,), '2F3A -> 2F3A';
ok Uni.new(0x2F3B).NFD.list ~~ (0x2F3B,), '2F3B -> 2F3B';
ok Uni.new(0x2F3C).NFD.list ~~ (0x2F3C,), '2F3C -> 2F3C';
ok Uni.new(0x2F3D).NFD.list ~~ (0x2F3D,), '2F3D -> 2F3D';
ok Uni.new(0x2F3E).NFD.list ~~ (0x2F3E,), '2F3E -> 2F3E';
ok Uni.new(0x2F3F).NFD.list ~~ (0x2F3F,), '2F3F -> 2F3F';
ok Uni.new(0x2F40).NFD.list ~~ (0x2F40,), '2F40 -> 2F40';
ok Uni.new(0x2F41).NFD.list ~~ (0x2F41,), '2F41 -> 2F41';
ok Uni.new(0x2F42).NFD.list ~~ (0x2F42,), '2F42 -> 2F42';
ok Uni.new(0x2F43).NFD.list ~~ (0x2F43,), '2F43 -> 2F43';
ok Uni.new(0x2F44).NFD.list ~~ (0x2F44,), '2F44 -> 2F44';
ok Uni.new(0x2F45).NFD.list ~~ (0x2F45,), '2F45 -> 2F45';
ok Uni.new(0x2F46).NFD.list ~~ (0x2F46,), '2F46 -> 2F46';
ok Uni.new(0x2F47).NFD.list ~~ (0x2F47,), '2F47 -> 2F47';
ok Uni.new(0x2F48).NFD.list ~~ (0x2F48,), '2F48 -> 2F48';
ok Uni.new(0x2F49).NFD.list ~~ (0x2F49,), '2F49 -> 2F49';
ok Uni.new(0x2F4A).NFD.list ~~ (0x2F4A,), '2F4A -> 2F4A';
ok Uni.new(0x2F4B).NFD.list ~~ (0x2F4B,), '2F4B -> 2F4B';
ok Uni.new(0x2F4C).NFD.list ~~ (0x2F4C,), '2F4C -> 2F4C';
ok Uni.new(0x2F4D).NFD.list ~~ (0x2F4D,), '2F4D -> 2F4D';
ok Uni.new(0x2F4E).NFD.list ~~ (0x2F4E,), '2F4E -> 2F4E';
ok Uni.new(0x2F4F).NFD.list ~~ (0x2F4F,), '2F4F -> 2F4F';
ok Uni.new(0x2F50).NFD.list ~~ (0x2F50,), '2F50 -> 2F50';
ok Uni.new(0x2F51).NFD.list ~~ (0x2F51,), '2F51 -> 2F51';
ok Uni.new(0x2F52).NFD.list ~~ (0x2F52,), '2F52 -> 2F52';
ok Uni.new(0x2F53).NFD.list ~~ (0x2F53,), '2F53 -> 2F53';
ok Uni.new(0x2F54).NFD.list ~~ (0x2F54,), '2F54 -> 2F54';
ok Uni.new(0x2F55).NFD.list ~~ (0x2F55,), '2F55 -> 2F55';
ok Uni.new(0x2F56).NFD.list ~~ (0x2F56,), '2F56 -> 2F56';
ok Uni.new(0x2F57).NFD.list ~~ (0x2F57,), '2F57 -> 2F57';
ok Uni.new(0x2F58).NFD.list ~~ (0x2F58,), '2F58 -> 2F58';
ok Uni.new(0x2F59).NFD.list ~~ (0x2F59,), '2F59 -> 2F59';
ok Uni.new(0x2F5A).NFD.list ~~ (0x2F5A,), '2F5A -> 2F5A';
ok Uni.new(0x2F5B).NFD.list ~~ (0x2F5B,), '2F5B -> 2F5B';
ok Uni.new(0x2F5C).NFD.list ~~ (0x2F5C,), '2F5C -> 2F5C';
ok Uni.new(0x2F5D).NFD.list ~~ (0x2F5D,), '2F5D -> 2F5D';
ok Uni.new(0x2F5E).NFD.list ~~ (0x2F5E,), '2F5E -> 2F5E';
ok Uni.new(0x2F5F).NFD.list ~~ (0x2F5F,), '2F5F -> 2F5F';
ok Uni.new(0x2F60).NFD.list ~~ (0x2F60,), '2F60 -> 2F60';
ok Uni.new(0x2F61).NFD.list ~~ (0x2F61,), '2F61 -> 2F61';
ok Uni.new(0x2F62).NFD.list ~~ (0x2F62,), '2F62 -> 2F62';
ok Uni.new(0x2F63).NFD.list ~~ (0x2F63,), '2F63 -> 2F63';
ok Uni.new(0x2F64).NFD.list ~~ (0x2F64,), '2F64 -> 2F64';
ok Uni.new(0x2F65).NFD.list ~~ (0x2F65,), '2F65 -> 2F65';
ok Uni.new(0x2F66).NFD.list ~~ (0x2F66,), '2F66 -> 2F66';
ok Uni.new(0x2F67).NFD.list ~~ (0x2F67,), '2F67 -> 2F67';
ok Uni.new(0x2F68).NFD.list ~~ (0x2F68,), '2F68 -> 2F68';
ok Uni.new(0x2F69).NFD.list ~~ (0x2F69,), '2F69 -> 2F69';
ok Uni.new(0x2F6A).NFD.list ~~ (0x2F6A,), '2F6A -> 2F6A';
ok Uni.new(0x2F6B).NFD.list ~~ (0x2F6B,), '2F6B -> 2F6B';
ok Uni.new(0x2F6C).NFD.list ~~ (0x2F6C,), '2F6C -> 2F6C';
ok Uni.new(0x2F6D).NFD.list ~~ (0x2F6D,), '2F6D -> 2F6D';
ok Uni.new(0x2F6E).NFD.list ~~ (0x2F6E,), '2F6E -> 2F6E';
ok Uni.new(0x2F6F).NFD.list ~~ (0x2F6F,), '2F6F -> 2F6F';
ok Uni.new(0x2F70).NFD.list ~~ (0x2F70,), '2F70 -> 2F70';
ok Uni.new(0x2F71).NFD.list ~~ (0x2F71,), '2F71 -> 2F71';
ok Uni.new(0x2F72).NFD.list ~~ (0x2F72,), '2F72 -> 2F72';
ok Uni.new(0x2F73).NFD.list ~~ (0x2F73,), '2F73 -> 2F73';
ok Uni.new(0x2F74).NFD.list ~~ (0x2F74,), '2F74 -> 2F74';
ok Uni.new(0x2F75).NFD.list ~~ (0x2F75,), '2F75 -> 2F75';
ok Uni.new(0x2F76).NFD.list ~~ (0x2F76,), '2F76 -> 2F76';
ok Uni.new(0x2F77).NFD.list ~~ (0x2F77,), '2F77 -> 2F77';
ok Uni.new(0x2F78).NFD.list ~~ (0x2F78,), '2F78 -> 2F78';
ok Uni.new(0x2F79).NFD.list ~~ (0x2F79,), '2F79 -> 2F79';
ok Uni.new(0x2F7A).NFD.list ~~ (0x2F7A,), '2F7A -> 2F7A';
ok Uni.new(0x2F7B).NFD.list ~~ (0x2F7B,), '2F7B -> 2F7B';
ok Uni.new(0x2F7C).NFD.list ~~ (0x2F7C,), '2F7C -> 2F7C';
ok Uni.new(0x2F7D).NFD.list ~~ (0x2F7D,), '2F7D -> 2F7D';
ok Uni.new(0x2F7E).NFD.list ~~ (0x2F7E,), '2F7E -> 2F7E';
ok Uni.new(0x2F7F).NFD.list ~~ (0x2F7F,), '2F7F -> 2F7F';
ok Uni.new(0x2F80).NFD.list ~~ (0x2F80,), '2F80 -> 2F80';
ok Uni.new(0x2F81).NFD.list ~~ (0x2F81,), '2F81 -> 2F81';
ok Uni.new(0x2F82).NFD.list ~~ (0x2F82,), '2F82 -> 2F82';
ok Uni.new(0x2F83).NFD.list ~~ (0x2F83,), '2F83 -> 2F83';
ok Uni.new(0x2F84).NFD.list ~~ (0x2F84,), '2F84 -> 2F84';
ok Uni.new(0x2F85).NFD.list ~~ (0x2F85,), '2F85 -> 2F85';
ok Uni.new(0x2F86).NFD.list ~~ (0x2F86,), '2F86 -> 2F86';
ok Uni.new(0x2F87).NFD.list ~~ (0x2F87,), '2F87 -> 2F87';
ok Uni.new(0x2F88).NFD.list ~~ (0x2F88,), '2F88 -> 2F88';
ok Uni.new(0x2F89).NFD.list ~~ (0x2F89,), '2F89 -> 2F89';
ok Uni.new(0x2F8A).NFD.list ~~ (0x2F8A,), '2F8A -> 2F8A';
ok Uni.new(0x2F8B).NFD.list ~~ (0x2F8B,), '2F8B -> 2F8B';
ok Uni.new(0x2F8C).NFD.list ~~ (0x2F8C,), '2F8C -> 2F8C';
ok Uni.new(0x2F8D).NFD.list ~~ (0x2F8D,), '2F8D -> 2F8D';
ok Uni.new(0x2F8E).NFD.list ~~ (0x2F8E,), '2F8E -> 2F8E';
ok Uni.new(0x2F8F).NFD.list ~~ (0x2F8F,), '2F8F -> 2F8F';
ok Uni.new(0x2F90).NFD.list ~~ (0x2F90,), '2F90 -> 2F90';
ok Uni.new(0x2F91).NFD.list ~~ (0x2F91,), '2F91 -> 2F91';
ok Uni.new(0x2F92).NFD.list ~~ (0x2F92,), '2F92 -> 2F92';
ok Uni.new(0x2F93).NFD.list ~~ (0x2F93,), '2F93 -> 2F93';
ok Uni.new(0x2F94).NFD.list ~~ (0x2F94,), '2F94 -> 2F94';
ok Uni.new(0x2F95).NFD.list ~~ (0x2F95,), '2F95 -> 2F95';
ok Uni.new(0x2F96).NFD.list ~~ (0x2F96,), '2F96 -> 2F96';
ok Uni.new(0x2F97).NFD.list ~~ (0x2F97,), '2F97 -> 2F97';
ok Uni.new(0x2F98).NFD.list ~~ (0x2F98,), '2F98 -> 2F98';
ok Uni.new(0x2F99).NFD.list ~~ (0x2F99,), '2F99 -> 2F99';
ok Uni.new(0x2F9A).NFD.list ~~ (0x2F9A,), '2F9A -> 2F9A';
ok Uni.new(0x2F9B).NFD.list ~~ (0x2F9B,), '2F9B -> 2F9B';
ok Uni.new(0x2F9C).NFD.list ~~ (0x2F9C,), '2F9C -> 2F9C';
ok Uni.new(0x2F9D).NFD.list ~~ (0x2F9D,), '2F9D -> 2F9D';
ok Uni.new(0x2F9E).NFD.list ~~ (0x2F9E,), '2F9E -> 2F9E';
ok Uni.new(0x2F9F).NFD.list ~~ (0x2F9F,), '2F9F -> 2F9F';
ok Uni.new(0x2FA0).NFD.list ~~ (0x2FA0,), '2FA0 -> 2FA0';
ok Uni.new(0x2FA1).NFD.list ~~ (0x2FA1,), '2FA1 -> 2FA1';
ok Uni.new(0x2FA2).NFD.list ~~ (0x2FA2,), '2FA2 -> 2FA2';
ok Uni.new(0x2FA3).NFD.list ~~ (0x2FA3,), '2FA3 -> 2FA3';
ok Uni.new(0x2FA4).NFD.list ~~ (0x2FA4,), '2FA4 -> 2FA4';
ok Uni.new(0x2FA5).NFD.list ~~ (0x2FA5,), '2FA5 -> 2FA5';
ok Uni.new(0x2FA6).NFD.list ~~ (0x2FA6,), '2FA6 -> 2FA6';
ok Uni.new(0x2FA7).NFD.list ~~ (0x2FA7,), '2FA7 -> 2FA7';
ok Uni.new(0x2FA8).NFD.list ~~ (0x2FA8,), '2FA8 -> 2FA8';
ok Uni.new(0x2FA9).NFD.list ~~ (0x2FA9,), '2FA9 -> 2FA9';
ok Uni.new(0x2FAA).NFD.list ~~ (0x2FAA,), '2FAA -> 2FAA';
ok Uni.new(0x2FAB).NFD.list ~~ (0x2FAB,), '2FAB -> 2FAB';
ok Uni.new(0x2FAC).NFD.list ~~ (0x2FAC,), '2FAC -> 2FAC';
ok Uni.new(0x2FAD).NFD.list ~~ (0x2FAD,), '2FAD -> 2FAD';
ok Uni.new(0x2FAE).NFD.list ~~ (0x2FAE,), '2FAE -> 2FAE';
ok Uni.new(0x2FAF).NFD.list ~~ (0x2FAF,), '2FAF -> 2FAF';
ok Uni.new(0x2FB0).NFD.list ~~ (0x2FB0,), '2FB0 -> 2FB0';
ok Uni.new(0x2FB1).NFD.list ~~ (0x2FB1,), '2FB1 -> 2FB1';
ok Uni.new(0x2FB2).NFD.list ~~ (0x2FB2,), '2FB2 -> 2FB2';
ok Uni.new(0x2FB3).NFD.list ~~ (0x2FB3,), '2FB3 -> 2FB3';
ok Uni.new(0x2FB4).NFD.list ~~ (0x2FB4,), '2FB4 -> 2FB4';
ok Uni.new(0x2FB5).NFD.list ~~ (0x2FB5,), '2FB5 -> 2FB5';
ok Uni.new(0x2FB6).NFD.list ~~ (0x2FB6,), '2FB6 -> 2FB6';
ok Uni.new(0x2FB7).NFD.list ~~ (0x2FB7,), '2FB7 -> 2FB7';
ok Uni.new(0x2FB8).NFD.list ~~ (0x2FB8,), '2FB8 -> 2FB8';
ok Uni.new(0x2FB9).NFD.list ~~ (0x2FB9,), '2FB9 -> 2FB9';
ok Uni.new(0x2FBA).NFD.list ~~ (0x2FBA,), '2FBA -> 2FBA';
ok Uni.new(0x2FBB).NFD.list ~~ (0x2FBB,), '2FBB -> 2FBB';
ok Uni.new(0x2FBC).NFD.list ~~ (0x2FBC,), '2FBC -> 2FBC';
ok Uni.new(0x2FBD).NFD.list ~~ (0x2FBD,), '2FBD -> 2FBD';
ok Uni.new(0x2FBE).NFD.list ~~ (0x2FBE,), '2FBE -> 2FBE';
ok Uni.new(0x2FBF).NFD.list ~~ (0x2FBF,), '2FBF -> 2FBF';
ok Uni.new(0x2FC0).NFD.list ~~ (0x2FC0,), '2FC0 -> 2FC0';
ok Uni.new(0x2FC1).NFD.list ~~ (0x2FC1,), '2FC1 -> 2FC1';
ok Uni.new(0x2FC2).NFD.list ~~ (0x2FC2,), '2FC2 -> 2FC2';
ok Uni.new(0x2FC3).NFD.list ~~ (0x2FC3,), '2FC3 -> 2FC3';
ok Uni.new(0x2FC4).NFD.list ~~ (0x2FC4,), '2FC4 -> 2FC4';
ok Uni.new(0x2FC5).NFD.list ~~ (0x2FC5,), '2FC5 -> 2FC5';
ok Uni.new(0x2FC6).NFD.list ~~ (0x2FC6,), '2FC6 -> 2FC6';
ok Uni.new(0x2FC7).NFD.list ~~ (0x2FC7,), '2FC7 -> 2FC7';
ok Uni.new(0x2FC8).NFD.list ~~ (0x2FC8,), '2FC8 -> 2FC8';
ok Uni.new(0x2FC9).NFD.list ~~ (0x2FC9,), '2FC9 -> 2FC9';
ok Uni.new(0x2FCA).NFD.list ~~ (0x2FCA,), '2FCA -> 2FCA';
ok Uni.new(0x2FCB).NFD.list ~~ (0x2FCB,), '2FCB -> 2FCB';
ok Uni.new(0x2FCC).NFD.list ~~ (0x2FCC,), '2FCC -> 2FCC';
ok Uni.new(0x2FCD).NFD.list ~~ (0x2FCD,), '2FCD -> 2FCD';
ok Uni.new(0x2FCE).NFD.list ~~ (0x2FCE,), '2FCE -> 2FCE';
ok Uni.new(0x2FCF).NFD.list ~~ (0x2FCF,), '2FCF -> 2FCF';
ok Uni.new(0x2FD0).NFD.list ~~ (0x2FD0,), '2FD0 -> 2FD0';
ok Uni.new(0x2FD1).NFD.list ~~ (0x2FD1,), '2FD1 -> 2FD1';
ok Uni.new(0x2FD2).NFD.list ~~ (0x2FD2,), '2FD2 -> 2FD2';
ok Uni.new(0x2FD3).NFD.list ~~ (0x2FD3,), '2FD3 -> 2FD3';
ok Uni.new(0x2FD4).NFD.list ~~ (0x2FD4,), '2FD4 -> 2FD4';
ok Uni.new(0x2FD5).NFD.list ~~ (0x2FD5,), '2FD5 -> 2FD5';
ok Uni.new(0x3000).NFD.list ~~ (0x3000,), '3000 -> 3000';
ok Uni.new(0x3036).NFD.list ~~ (0x3036,), '3036 -> 3036';
ok Uni.new(0x3038).NFD.list ~~ (0x3038,), '3038 -> 3038';
ok Uni.new(0x3039).NFD.list ~~ (0x3039,), '3039 -> 3039';
ok Uni.new(0x303A).NFD.list ~~ (0x303A,), '303A -> 303A';
ok Uni.new(0x304C).NFD.list ~~ (0x304B, 0x3099,), '304C -> 304B 3099';
ok Uni.new(0x304E).NFD.list ~~ (0x304D, 0x3099,), '304E -> 304D 3099';
ok Uni.new(0x3050).NFD.list ~~ (0x304F, 0x3099,), '3050 -> 304F 3099';
ok Uni.new(0x3052).NFD.list ~~ (0x3051, 0x3099,), '3052 -> 3051 3099';
ok Uni.new(0x3054).NFD.list ~~ (0x3053, 0x3099,), '3054 -> 3053 3099';
ok Uni.new(0x3056).NFD.list ~~ (0x3055, 0x3099,), '3056 -> 3055 3099';
ok Uni.new(0x3058).NFD.list ~~ (0x3057, 0x3099,), '3058 -> 3057 3099';
ok Uni.new(0x305A).NFD.list ~~ (0x3059, 0x3099,), '305A -> 3059 3099';
ok Uni.new(0x305C).NFD.list ~~ (0x305B, 0x3099,), '305C -> 305B 3099';
ok Uni.new(0x305E).NFD.list ~~ (0x305D, 0x3099,), '305E -> 305D 3099';
ok Uni.new(0x3060).NFD.list ~~ (0x305F, 0x3099,), '3060 -> 305F 3099';
ok Uni.new(0x3062).NFD.list ~~ (0x3061, 0x3099,), '3062 -> 3061 3099';
ok Uni.new(0x3065).NFD.list ~~ (0x3064, 0x3099,), '3065 -> 3064 3099';
ok Uni.new(0x3067).NFD.list ~~ (0x3066, 0x3099,), '3067 -> 3066 3099';
ok Uni.new(0x3069).NFD.list ~~ (0x3068, 0x3099,), '3069 -> 3068 3099';
ok Uni.new(0x3070).NFD.list ~~ (0x306F, 0x3099,), '3070 -> 306F 3099';
ok Uni.new(0x3071).NFD.list ~~ (0x306F, 0x309A,), '3071 -> 306F 309A';
ok Uni.new(0x3073).NFD.list ~~ (0x3072, 0x3099,), '3073 -> 3072 3099';
ok Uni.new(0x3074).NFD.list ~~ (0x3072, 0x309A,), '3074 -> 3072 309A';
ok Uni.new(0x3076).NFD.list ~~ (0x3075, 0x3099,), '3076 -> 3075 3099';
ok Uni.new(0x3077).NFD.list ~~ (0x3075, 0x309A,), '3077 -> 3075 309A';
ok Uni.new(0x3079).NFD.list ~~ (0x3078, 0x3099,), '3079 -> 3078 3099';
ok Uni.new(0x307A).NFD.list ~~ (0x3078, 0x309A,), '307A -> 3078 309A';
ok Uni.new(0x307C).NFD.list ~~ (0x307B, 0x3099,), '307C -> 307B 3099';
ok Uni.new(0x307D).NFD.list ~~ (0x307B, 0x309A,), '307D -> 307B 309A';
ok Uni.new(0x3094).NFD.list ~~ (0x3046, 0x3099,), '3094 -> 3046 3099';
ok Uni.new(0x309B).NFD.list ~~ (0x309B,), '309B -> 309B';
ok Uni.new(0x309C).NFD.list ~~ (0x309C,), '309C -> 309C';
ok Uni.new(0x309E).NFD.list ~~ (0x309D, 0x3099,), '309E -> 309D 3099';
ok Uni.new(0x309F).NFD.list ~~ (0x309F,), '309F -> 309F';
ok Uni.new(0x30AC).NFD.list ~~ (0x30AB, 0x3099,), '30AC -> 30AB 3099';
ok Uni.new(0x30AE).NFD.list ~~ (0x30AD, 0x3099,), '30AE -> 30AD 3099';
ok Uni.new(0x30B0).NFD.list ~~ (0x30AF, 0x3099,), '30B0 -> 30AF 3099';
ok Uni.new(0x30B2).NFD.list ~~ (0x30B1, 0x3099,), '30B2 -> 30B1 3099';
ok Uni.new(0x30B4).NFD.list ~~ (0x30B3, 0x3099,), '30B4 -> 30B3 3099';
ok Uni.new(0x30B6).NFD.list ~~ (0x30B5, 0x3099,), '30B6 -> 30B5 3099';
ok Uni.new(0x30B8).NFD.list ~~ (0x30B7, 0x3099,), '30B8 -> 30B7 3099';
ok Uni.new(0x30BA).NFD.list ~~ (0x30B9, 0x3099,), '30BA -> 30B9 3099';
ok Uni.new(0x30BC).NFD.list ~~ (0x30BB, 0x3099,), '30BC -> 30BB 3099';
ok Uni.new(0x30BE).NFD.list ~~ (0x30BD, 0x3099,), '30BE -> 30BD 3099';
ok Uni.new(0x30C0).NFD.list ~~ (0x30BF, 0x3099,), '30C0 -> 30BF 3099';
ok Uni.new(0x30C2).NFD.list ~~ (0x30C1, 0x3099,), '30C2 -> 30C1 3099';
ok Uni.new(0x30C5).NFD.list ~~ (0x30C4, 0x3099,), '30C5 -> 30C4 3099';
ok Uni.new(0x30C7).NFD.list ~~ (0x30C6, 0x3099,), '30C7 -> 30C6 3099';
ok Uni.new(0x30C9).NFD.list ~~ (0x30C8, 0x3099,), '30C9 -> 30C8 3099';
ok Uni.new(0x30D0).NFD.list ~~ (0x30CF, 0x3099,), '30D0 -> 30CF 3099';
ok Uni.new(0x30D1).NFD.list ~~ (0x30CF, 0x309A,), '30D1 -> 30CF 309A';
ok Uni.new(0x30D3).NFD.list ~~ (0x30D2, 0x3099,), '30D3 -> 30D2 3099';
ok Uni.new(0x30D4).NFD.list ~~ (0x30D2, 0x309A,), '30D4 -> 30D2 309A';
ok Uni.new(0x30D6).NFD.list ~~ (0x30D5, 0x3099,), '30D6 -> 30D5 3099';
ok Uni.new(0x30D7).NFD.list ~~ (0x30D5, 0x309A,), '30D7 -> 30D5 309A';
ok Uni.new(0x30D9).NFD.list ~~ (0x30D8, 0x3099,), '30D9 -> 30D8 3099';
ok Uni.new(0x30DA).NFD.list ~~ (0x30D8, 0x309A,), '30DA -> 30D8 309A';
ok Uni.new(0x30DC).NFD.list ~~ (0x30DB, 0x3099,), '30DC -> 30DB 3099';
ok Uni.new(0x30DD).NFD.list ~~ (0x30DB, 0x309A,), '30DD -> 30DB 309A';
ok Uni.new(0x30F4).NFD.list ~~ (0x30A6, 0x3099,), '30F4 -> 30A6 3099';
ok Uni.new(0x30F7).NFD.list ~~ (0x30EF, 0x3099,), '30F7 -> 30EF 3099';
ok Uni.new(0x30F8).NFD.list ~~ (0x30F0, 0x3099,), '30F8 -> 30F0 3099';
ok Uni.new(0x30F9).NFD.list ~~ (0x30F1, 0x3099,), '30F9 -> 30F1 3099';
ok Uni.new(0x30FA).NFD.list ~~ (0x30F2, 0x3099,), '30FA -> 30F2 3099';
ok Uni.new(0x30FE).NFD.list ~~ (0x30FD, 0x3099,), '30FE -> 30FD 3099';
ok Uni.new(0x30FF).NFD.list ~~ (0x30FF,), '30FF -> 30FF';
ok Uni.new(0x3131).NFD.list ~~ (0x3131,), '3131 -> 3131';
ok Uni.new(0x3132).NFD.list ~~ (0x3132,), '3132 -> 3132';
ok Uni.new(0x3133).NFD.list ~~ (0x3133,), '3133 -> 3133';
ok Uni.new(0x3134).NFD.list ~~ (0x3134,), '3134 -> 3134';
ok Uni.new(0x3135).NFD.list ~~ (0x3135,), '3135 -> 3135';
ok Uni.new(0x3136).NFD.list ~~ (0x3136,), '3136 -> 3136';
ok Uni.new(0x3137).NFD.list ~~ (0x3137,), '3137 -> 3137';
ok Uni.new(0x3138).NFD.list ~~ (0x3138,), '3138 -> 3138';
ok Uni.new(0x3139).NFD.list ~~ (0x3139,), '3139 -> 3139';
ok Uni.new(0x313A).NFD.list ~~ (0x313A,), '313A -> 313A';
ok Uni.new(0x313B).NFD.list ~~ (0x313B,), '313B -> 313B';
ok Uni.new(0x313C).NFD.list ~~ (0x313C,), '313C -> 313C';
ok Uni.new(0x313D).NFD.list ~~ (0x313D,), '313D -> 313D';
ok Uni.new(0x313E).NFD.list ~~ (0x313E,), '313E -> 313E';
ok Uni.new(0x313F).NFD.list ~~ (0x313F,), '313F -> 313F';
ok Uni.new(0x3140).NFD.list ~~ (0x3140,), '3140 -> 3140';
ok Uni.new(0x3141).NFD.list ~~ (0x3141,), '3141 -> 3141';
ok Uni.new(0x3142).NFD.list ~~ (0x3142,), '3142 -> 3142';
ok Uni.new(0x3143).NFD.list ~~ (0x3143,), '3143 -> 3143';
ok Uni.new(0x3144).NFD.list ~~ (0x3144,), '3144 -> 3144';
ok Uni.new(0x3145).NFD.list ~~ (0x3145,), '3145 -> 3145';
ok Uni.new(0x3146).NFD.list ~~ (0x3146,), '3146 -> 3146';
ok Uni.new(0x3147).NFD.list ~~ (0x3147,), '3147 -> 3147';
ok Uni.new(0x3148).NFD.list ~~ (0x3148,), '3148 -> 3148';
ok Uni.new(0x3149).NFD.list ~~ (0x3149,), '3149 -> 3149';
ok Uni.new(0x314A).NFD.list ~~ (0x314A,), '314A -> 314A';
ok Uni.new(0x314B).NFD.list ~~ (0x314B,), '314B -> 314B';
ok Uni.new(0x314C).NFD.list ~~ (0x314C,), '314C -> 314C';
ok Uni.new(0x314D).NFD.list ~~ (0x314D,), '314D -> 314D';
ok Uni.new(0x314E).NFD.list ~~ (0x314E,), '314E -> 314E';
ok Uni.new(0x314F).NFD.list ~~ (0x314F,), '314F -> 314F';
ok Uni.new(0x3150).NFD.list ~~ (0x3150,), '3150 -> 3150';
ok Uni.new(0x3151).NFD.list ~~ (0x3151,), '3151 -> 3151';
ok Uni.new(0x3152).NFD.list ~~ (0x3152,), '3152 -> 3152';
ok Uni.new(0x3153).NFD.list ~~ (0x3153,), '3153 -> 3153';
ok Uni.new(0x3154).NFD.list ~~ (0x3154,), '3154 -> 3154';
ok Uni.new(0x3155).NFD.list ~~ (0x3155,), '3155 -> 3155';
ok Uni.new(0x3156).NFD.list ~~ (0x3156,), '3156 -> 3156';
ok Uni.new(0x3157).NFD.list ~~ (0x3157,), '3157 -> 3157';
ok Uni.new(0x3158).NFD.list ~~ (0x3158,), '3158 -> 3158';
ok Uni.new(0x3159).NFD.list ~~ (0x3159,), '3159 -> 3159';
ok Uni.new(0x315A).NFD.list ~~ (0x315A,), '315A -> 315A';
ok Uni.new(0x315B).NFD.list ~~ (0x315B,), '315B -> 315B';
ok Uni.new(0x315C).NFD.list ~~ (0x315C,), '315C -> 315C';
ok Uni.new(0x315D).NFD.list ~~ (0x315D,), '315D -> 315D';
ok Uni.new(0x315E).NFD.list ~~ (0x315E,), '315E -> 315E';
ok Uni.new(0x315F).NFD.list ~~ (0x315F,), '315F -> 315F';
ok Uni.new(0x3160).NFD.list ~~ (0x3160,), '3160 -> 3160';
ok Uni.new(0x3161).NFD.list ~~ (0x3161,), '3161 -> 3161';
ok Uni.new(0x3162).NFD.list ~~ (0x3162,), '3162 -> 3162';
ok Uni.new(0x3163).NFD.list ~~ (0x3163,), '3163 -> 3163';
ok Uni.new(0x3164).NFD.list ~~ (0x3164,), '3164 -> 3164';
ok Uni.new(0x3165).NFD.list ~~ (0x3165,), '3165 -> 3165';
ok Uni.new(0x3166).NFD.list ~~ (0x3166,), '3166 -> 3166';
ok Uni.new(0x3167).NFD.list ~~ (0x3167,), '3167 -> 3167';
ok Uni.new(0x3168).NFD.list ~~ (0x3168,), '3168 -> 3168';
ok Uni.new(0x3169).NFD.list ~~ (0x3169,), '3169 -> 3169';
ok Uni.new(0x316A).NFD.list ~~ (0x316A,), '316A -> 316A';
ok Uni.new(0x316B).NFD.list ~~ (0x316B,), '316B -> 316B';
ok Uni.new(0x316C).NFD.list ~~ (0x316C,), '316C -> 316C';
ok Uni.new(0x316D).NFD.list ~~ (0x316D,), '316D -> 316D';
ok Uni.new(0x316E).NFD.list ~~ (0x316E,), '316E -> 316E';
ok Uni.new(0x316F).NFD.list ~~ (0x316F,), '316F -> 316F';
ok Uni.new(0x3170).NFD.list ~~ (0x3170,), '3170 -> 3170';
ok Uni.new(0x3171).NFD.list ~~ (0x3171,), '3171 -> 3171';
ok Uni.new(0x3172).NFD.list ~~ (0x3172,), '3172 -> 3172';
ok Uni.new(0x3173).NFD.list ~~ (0x3173,), '3173 -> 3173';
ok Uni.new(0x3174).NFD.list ~~ (0x3174,), '3174 -> 3174';
ok Uni.new(0x3175).NFD.list ~~ (0x3175,), '3175 -> 3175';
ok Uni.new(0x3176).NFD.list ~~ (0x3176,), '3176 -> 3176';
ok Uni.new(0x3177).NFD.list ~~ (0x3177,), '3177 -> 3177';
ok Uni.new(0x3178).NFD.list ~~ (0x3178,), '3178 -> 3178';
ok Uni.new(0x3179).NFD.list ~~ (0x3179,), '3179 -> 3179';
ok Uni.new(0x317A).NFD.list ~~ (0x317A,), '317A -> 317A';
ok Uni.new(0x317B).NFD.list ~~ (0x317B,), '317B -> 317B';
ok Uni.new(0x317C).NFD.list ~~ (0x317C,), '317C -> 317C';
ok Uni.new(0x317D).NFD.list ~~ (0x317D,), '317D -> 317D';
ok Uni.new(0x317E).NFD.list ~~ (0x317E,), '317E -> 317E';
ok Uni.new(0x317F).NFD.list ~~ (0x317F,), '317F -> 317F';
ok Uni.new(0x3180).NFD.list ~~ (0x3180,), '3180 -> 3180';
ok Uni.new(0x3181).NFD.list ~~ (0x3181,), '3181 -> 3181';
ok Uni.new(0x3182).NFD.list ~~ (0x3182,), '3182 -> 3182';
ok Uni.new(0x3183).NFD.list ~~ (0x3183,), '3183 -> 3183';
ok Uni.new(0x3184).NFD.list ~~ (0x3184,), '3184 -> 3184';
ok Uni.new(0x3185).NFD.list ~~ (0x3185,), '3185 -> 3185';
ok Uni.new(0x3186).NFD.list ~~ (0x3186,), '3186 -> 3186';
ok Uni.new(0x3187).NFD.list ~~ (0x3187,), '3187 -> 3187';
ok Uni.new(0x3188).NFD.list ~~ (0x3188,), '3188 -> 3188';
ok Uni.new(0x3189).NFD.list ~~ (0x3189,), '3189 -> 3189';
ok Uni.new(0x318A).NFD.list ~~ (0x318A,), '318A -> 318A';
ok Uni.new(0x318B).NFD.list ~~ (0x318B,), '318B -> 318B';
ok Uni.new(0x318C).NFD.list ~~ (0x318C,), '318C -> 318C';
ok Uni.new(0x318D).NFD.list ~~ (0x318D,), '318D -> 318D';
ok Uni.new(0x318E).NFD.list ~~ (0x318E,), '318E -> 318E';
ok Uni.new(0x3192).NFD.list ~~ (0x3192,), '3192 -> 3192';
ok Uni.new(0x3193).NFD.list ~~ (0x3193,), '3193 -> 3193';
ok Uni.new(0x3194).NFD.list ~~ (0x3194,), '3194 -> 3194';
ok Uni.new(0x3195).NFD.list ~~ (0x3195,), '3195 -> 3195';
ok Uni.new(0x3196).NFD.list ~~ (0x3196,), '3196 -> 3196';
ok Uni.new(0x3197).NFD.list ~~ (0x3197,), '3197 -> 3197';
ok Uni.new(0x3198).NFD.list ~~ (0x3198,), '3198 -> 3198';
ok Uni.new(0x3199).NFD.list ~~ (0x3199,), '3199 -> 3199';
ok Uni.new(0x319A).NFD.list ~~ (0x319A,), '319A -> 319A';
ok Uni.new(0x319B).NFD.list ~~ (0x319B,), '319B -> 319B';
ok Uni.new(0x319C).NFD.list ~~ (0x319C,), '319C -> 319C';
ok Uni.new(0x319D).NFD.list ~~ (0x319D,), '319D -> 319D';
ok Uni.new(0x319E).NFD.list ~~ (0x319E,), '319E -> 319E';
ok Uni.new(0x319F).NFD.list ~~ (0x319F,), '319F -> 319F';
ok Uni.new(0x3200).NFD.list ~~ (0x3200,), '3200 -> 3200';
ok Uni.new(0x3201).NFD.list ~~ (0x3201,), '3201 -> 3201';
ok Uni.new(0x3202).NFD.list ~~ (0x3202,), '3202 -> 3202';
ok Uni.new(0x3203).NFD.list ~~ (0x3203,), '3203 -> 3203';
ok Uni.new(0x3204).NFD.list ~~ (0x3204,), '3204 -> 3204';
ok Uni.new(0x3205).NFD.list ~~ (0x3205,), '3205 -> 3205';
ok Uni.new(0x3206).NFD.list ~~ (0x3206,), '3206 -> 3206';
ok Uni.new(0x3207).NFD.list ~~ (0x3207,), '3207 -> 3207';
ok Uni.new(0x3208).NFD.list ~~ (0x3208,), '3208 -> 3208';
ok Uni.new(0x3209).NFD.list ~~ (0x3209,), '3209 -> 3209';
ok Uni.new(0x320A).NFD.list ~~ (0x320A,), '320A -> 320A';
ok Uni.new(0x320B).NFD.list ~~ (0x320B,), '320B -> 320B';
ok Uni.new(0x320C).NFD.list ~~ (0x320C,), '320C -> 320C';
ok Uni.new(0x320D).NFD.list ~~ (0x320D,), '320D -> 320D';
ok Uni.new(0x320E).NFD.list ~~ (0x320E,), '320E -> 320E';
ok Uni.new(0x320F).NFD.list ~~ (0x320F,), '320F -> 320F';
ok Uni.new(0x3210).NFD.list ~~ (0x3210,), '3210 -> 3210';
ok Uni.new(0x3211).NFD.list ~~ (0x3211,), '3211 -> 3211';
ok Uni.new(0x3212).NFD.list ~~ (0x3212,), '3212 -> 3212';
ok Uni.new(0x3213).NFD.list ~~ (0x3213,), '3213 -> 3213';
ok Uni.new(0x3214).NFD.list ~~ (0x3214,), '3214 -> 3214';
ok Uni.new(0x3215).NFD.list ~~ (0x3215,), '3215 -> 3215';
ok Uni.new(0x3216).NFD.list ~~ (0x3216,), '3216 -> 3216';
ok Uni.new(0x3217).NFD.list ~~ (0x3217,), '3217 -> 3217';
ok Uni.new(0x3218).NFD.list ~~ (0x3218,), '3218 -> 3218';
ok Uni.new(0x3219).NFD.list ~~ (0x3219,), '3219 -> 3219';
ok Uni.new(0x321A).NFD.list ~~ (0x321A,), '321A -> 321A';
ok Uni.new(0x321B).NFD.list ~~ (0x321B,), '321B -> 321B';
ok Uni.new(0x321C).NFD.list ~~ (0x321C,), '321C -> 321C';
ok Uni.new(0x321D).NFD.list ~~ (0x321D,), '321D -> 321D';
ok Uni.new(0x321E).NFD.list ~~ (0x321E,), '321E -> 321E';
ok Uni.new(0x3220).NFD.list ~~ (0x3220,), '3220 -> 3220';
ok Uni.new(0x3221).NFD.list ~~ (0x3221,), '3221 -> 3221';
ok Uni.new(0x3222).NFD.list ~~ (0x3222,), '3222 -> 3222';
ok Uni.new(0x3223).NFD.list ~~ (0x3223,), '3223 -> 3223';
ok Uni.new(0x3224).NFD.list ~~ (0x3224,), '3224 -> 3224';
ok Uni.new(0x3225).NFD.list ~~ (0x3225,), '3225 -> 3225';
ok Uni.new(0x3226).NFD.list ~~ (0x3226,), '3226 -> 3226';
ok Uni.new(0x3227).NFD.list ~~ (0x3227,), '3227 -> 3227';
ok Uni.new(0x3228).NFD.list ~~ (0x3228,), '3228 -> 3228';
ok Uni.new(0x3229).NFD.list ~~ (0x3229,), '3229 -> 3229';
ok Uni.new(0x322A).NFD.list ~~ (0x322A,), '322A -> 322A';
ok Uni.new(0x322B).NFD.list ~~ (0x322B,), '322B -> 322B';
ok Uni.new(0x322C).NFD.list ~~ (0x322C,), '322C -> 322C';
ok Uni.new(0x322D).NFD.list ~~ (0x322D,), '322D -> 322D';
ok Uni.new(0x322E).NFD.list ~~ (0x322E,), '322E -> 322E';
ok Uni.new(0x322F).NFD.list ~~ (0x322F,), '322F -> 322F';
ok Uni.new(0x3230).NFD.list ~~ (0x3230,), '3230 -> 3230';
ok Uni.new(0x3231).NFD.list ~~ (0x3231,), '3231 -> 3231';
ok Uni.new(0x3232).NFD.list ~~ (0x3232,), '3232 -> 3232';
ok Uni.new(0x3233).NFD.list ~~ (0x3233,), '3233 -> 3233';
ok Uni.new(0x3234).NFD.list ~~ (0x3234,), '3234 -> 3234';
ok Uni.new(0x3235).NFD.list ~~ (0x3235,), '3235 -> 3235';
ok Uni.new(0x3236).NFD.list ~~ (0x3236,), '3236 -> 3236';
ok Uni.new(0x3237).NFD.list ~~ (0x3237,), '3237 -> 3237';
ok Uni.new(0x3238).NFD.list ~~ (0x3238,), '3238 -> 3238';
ok Uni.new(0x3239).NFD.list ~~ (0x3239,), '3239 -> 3239';
ok Uni.new(0x323A).NFD.list ~~ (0x323A,), '323A -> 323A';
ok Uni.new(0x323B).NFD.list ~~ (0x323B,), '323B -> 323B';
ok Uni.new(0x323C).NFD.list ~~ (0x323C,), '323C -> 323C';
ok Uni.new(0x323D).NFD.list ~~ (0x323D,), '323D -> 323D';
ok Uni.new(0x323E).NFD.list ~~ (0x323E,), '323E -> 323E';
ok Uni.new(0x323F).NFD.list ~~ (0x323F,), '323F -> 323F';
ok Uni.new(0x3240).NFD.list ~~ (0x3240,), '3240 -> 3240';
ok Uni.new(0x3241).NFD.list ~~ (0x3241,), '3241 -> 3241';
ok Uni.new(0x3242).NFD.list ~~ (0x3242,), '3242 -> 3242';
ok Uni.new(0x3243).NFD.list ~~ (0x3243,), '3243 -> 3243';
ok Uni.new(0x3244).NFD.list ~~ (0x3244,), '3244 -> 3244';
ok Uni.new(0x3245).NFD.list ~~ (0x3245,), '3245 -> 3245';
ok Uni.new(0x3246).NFD.list ~~ (0x3246,), '3246 -> 3246';
ok Uni.new(0x3247).NFD.list ~~ (0x3247,), '3247 -> 3247';
ok Uni.new(0x3250).NFD.list ~~ (0x3250,), '3250 -> 3250';
ok Uni.new(0x3251).NFD.list ~~ (0x3251,), '3251 -> 3251';
ok Uni.new(0x3252).NFD.list ~~ (0x3252,), '3252 -> 3252';
ok Uni.new(0x3253).NFD.list ~~ (0x3253,), '3253 -> 3253';
ok Uni.new(0x3254).NFD.list ~~ (0x3254,), '3254 -> 3254';
ok Uni.new(0x3255).NFD.list ~~ (0x3255,), '3255 -> 3255';
ok Uni.new(0x3256).NFD.list ~~ (0x3256,), '3256 -> 3256';
ok Uni.new(0x3257).NFD.list ~~ (0x3257,), '3257 -> 3257';
ok Uni.new(0x3258).NFD.list ~~ (0x3258,), '3258 -> 3258';
ok Uni.new(0x3259).NFD.list ~~ (0x3259,), '3259 -> 3259';
ok Uni.new(0x325A).NFD.list ~~ (0x325A,), '325A -> 325A';
ok Uni.new(0x325B).NFD.list ~~ (0x325B,), '325B -> 325B';
ok Uni.new(0x325C).NFD.list ~~ (0x325C,), '325C -> 325C';
ok Uni.new(0x325D).NFD.list ~~ (0x325D,), '325D -> 325D';
ok Uni.new(0x325E).NFD.list ~~ (0x325E,), '325E -> 325E';
ok Uni.new(0x325F).NFD.list ~~ (0x325F,), '325F -> 325F';
ok Uni.new(0x3260).NFD.list ~~ (0x3260,), '3260 -> 3260';
ok Uni.new(0x3261).NFD.list ~~ (0x3261,), '3261 -> 3261';
ok Uni.new(0x3262).NFD.list ~~ (0x3262,), '3262 -> 3262';
ok Uni.new(0x3263).NFD.list ~~ (0x3263,), '3263 -> 3263';
ok Uni.new(0x3264).NFD.list ~~ (0x3264,), '3264 -> 3264';
ok Uni.new(0x3265).NFD.list ~~ (0x3265,), '3265 -> 3265';
ok Uni.new(0x3266).NFD.list ~~ (0x3266,), '3266 -> 3266';
ok Uni.new(0x3267).NFD.list ~~ (0x3267,), '3267 -> 3267';
ok Uni.new(0x3268).NFD.list ~~ (0x3268,), '3268 -> 3268';
ok Uni.new(0x3269).NFD.list ~~ (0x3269,), '3269 -> 3269';
ok Uni.new(0x326A).NFD.list ~~ (0x326A,), '326A -> 326A';
ok Uni.new(0x326B).NFD.list ~~ (0x326B,), '326B -> 326B';
ok Uni.new(0x326C).NFD.list ~~ (0x326C,), '326C -> 326C';
ok Uni.new(0x326D).NFD.list ~~ (0x326D,), '326D -> 326D';
ok Uni.new(0x326E).NFD.list ~~ (0x326E,), '326E -> 326E';
ok Uni.new(0x326F).NFD.list ~~ (0x326F,), '326F -> 326F';
ok Uni.new(0x3270).NFD.list ~~ (0x3270,), '3270 -> 3270';
ok Uni.new(0x3271).NFD.list ~~ (0x3271,), '3271 -> 3271';
ok Uni.new(0x3272).NFD.list ~~ (0x3272,), '3272 -> 3272';
ok Uni.new(0x3273).NFD.list ~~ (0x3273,), '3273 -> 3273';
ok Uni.new(0x3274).NFD.list ~~ (0x3274,), '3274 -> 3274';
ok Uni.new(0x3275).NFD.list ~~ (0x3275,), '3275 -> 3275';
ok Uni.new(0x3276).NFD.list ~~ (0x3276,), '3276 -> 3276';
ok Uni.new(0x3277).NFD.list ~~ (0x3277,), '3277 -> 3277';
ok Uni.new(0x3278).NFD.list ~~ (0x3278,), '3278 -> 3278';
ok Uni.new(0x3279).NFD.list ~~ (0x3279,), '3279 -> 3279';
ok Uni.new(0x327A).NFD.list ~~ (0x327A,), '327A -> 327A';
ok Uni.new(0x327B).NFD.list ~~ (0x327B,), '327B -> 327B';
ok Uni.new(0x327C).NFD.list ~~ (0x327C,), '327C -> 327C';
ok Uni.new(0x327D).NFD.list ~~ (0x327D,), '327D -> 327D';
ok Uni.new(0x327E).NFD.list ~~ (0x327E,), '327E -> 327E';
ok Uni.new(0x3280).NFD.list ~~ (0x3280,), '3280 -> 3280';
ok Uni.new(0x3281).NFD.list ~~ (0x3281,), '3281 -> 3281';
ok Uni.new(0x3282).NFD.list ~~ (0x3282,), '3282 -> 3282';
ok Uni.new(0x3283).NFD.list ~~ (0x3283,), '3283 -> 3283';
ok Uni.new(0x3284).NFD.list ~~ (0x3284,), '3284 -> 3284';
ok Uni.new(0x3285).NFD.list ~~ (0x3285,), '3285 -> 3285';
ok Uni.new(0x3286).NFD.list ~~ (0x3286,), '3286 -> 3286';
ok Uni.new(0x3287).NFD.list ~~ (0x3287,), '3287 -> 3287';
ok Uni.new(0x3288).NFD.list ~~ (0x3288,), '3288 -> 3288';
ok Uni.new(0x3289).NFD.list ~~ (0x3289,), '3289 -> 3289';
ok Uni.new(0x328A).NFD.list ~~ (0x328A,), '328A -> 328A';
ok Uni.new(0x328B).NFD.list ~~ (0x328B,), '328B -> 328B';
ok Uni.new(0x328C).NFD.list ~~ (0x328C,), '328C -> 328C';
ok Uni.new(0x328D).NFD.list ~~ (0x328D,), '328D -> 328D';
ok Uni.new(0x328E).NFD.list ~~ (0x328E,), '328E -> 328E';
ok Uni.new(0x328F).NFD.list ~~ (0x328F,), '328F -> 328F';
ok Uni.new(0x3290).NFD.list ~~ (0x3290,), '3290 -> 3290';
ok Uni.new(0x3291).NFD.list ~~ (0x3291,), '3291 -> 3291';
ok Uni.new(0x3292).NFD.list ~~ (0x3292,), '3292 -> 3292';
ok Uni.new(0x3293).NFD.list ~~ (0x3293,), '3293 -> 3293';
ok Uni.new(0x3294).NFD.list ~~ (0x3294,), '3294 -> 3294';
ok Uni.new(0x3295).NFD.list ~~ (0x3295,), '3295 -> 3295';
ok Uni.new(0x3296).NFD.list ~~ (0x3296,), '3296 -> 3296';
ok Uni.new(0x3297).NFD.list ~~ (0x3297,), '3297 -> 3297';
ok Uni.new(0x3298).NFD.list ~~ (0x3298,), '3298 -> 3298';
