#pragma once

#include <unordered_map>

namespace jpss
{
    namespace viirs
    {
        // Channel settings
        struct Channel
        {
            int apid;
            int zoneWidth[6];
            int zoneHeight;
            int totalWidth;
            int oversampleZone[6];
            float scale; // Coef to get the data to 16-bits
        };

        // All channels
        static std::unordered_map<int, Channel> VIIRSChannels = {
            // M4
            {800, {800, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 2, 3, 3, 2, 1}, 8}},
            // M5
            {801, {801, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 2, 3, 3, 2, 1}, 8}},
            // M3
            {802, {802, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 2, 3, 3, 2, 1}, 8}},
            // M2
            {803, {803, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 2, 3, 3, 2, 1}, 8}},
            // M1
            {804, {804, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 2, 3, 3, 2, 1}, 8}},
            // M6
            {805, {805, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},
            // M7
            {806, {806, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 2, 3, 3, 2, 1}, 8}},
            // M9
            {807, {807, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},
            // M10
            {808, {808, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},
            // M8
            {809, {809, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},
            // M11
            {810, {810, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},
            // M13
            {811, {811, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 2, 3, 3, 2, 1}, 8}},
            // M12
            {812, {812, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},
            // M16
            {814, {814, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},
            // M15
            {815, {815, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},
            // M14
            {816, {816, {640, 368, 592, 592, 368, 640}, 16, 3200, {1, 1, 1, 1, 1, 1}, 16}},

            // I1
            {818, {818, {1280, 736, 1184, 1184, 736, 1280}, 32, 6400, {1, 1, 1, 1, 1, 1}, 16}},
            // I2
            {819, {819, {1280, 736, 1184, 1184, 736, 1280}, 32, 6400, {1, 1, 1, 1, 1, 1}, 16}},
            // I3
            {820, {820, {1280, 736, 1184, 1184, 736, 1280}, 32, 6400, {1, 1, 1, 1, 1, 1}, 16}},
            // I4
            {813, {813, {1280, 736, 1184, 1184, 736, 1280}, 32, 6400, {1, 1, 1, 1, 1, 1}, 16}},
            // I5
            {817, {817, {1280, 736, 1184, 1184, 736, 1280}, 32, 6400, {1, 1, 1, 1, 1, 1}, 16}},

            // DNB
            {821, {821, {784, 488, 760, 760, 488, 784}, 16, 4064, {1, 1, 1, 1, 1, 1}, 2}},
            // DNB MGS
            {822, {822, {784, 488, 760, 760, 488, 784}, 16, 4064, {1, 1, 1, 1, 1, 1}, 2}},
            // DNB LGS
            {823, {823, {784, 488, 760, 760, 488, 784}, 16, 4064, {1, 1, 1, 1, 1, 1}, 2}}

        };
    } // namespace viirs
} // namespace jpss