C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=PSFNC2,SSI=0
                        SUBROUTINE PSFNC2
C                       *****************
C
C      -------------------------------------------------------
     * (MODE,
     *  NDIM,NBCOUF,VCOUPF,NBCOUS,VCOUPS,
     *  NELESF,NDMASF,NODESF,NELESS,NDMASS,NODESS,
     *  NBICOR,BARYF,NCBORF,BARYS,NCBORS)
C      -------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            PASSAGE DES DONNES DU FLUIDE VERS LE SOLIDE ET INVERSE    *
C            en 2D  ==> maillage surfacique de dimension 1             *
C            Les maillages ne sont pas coincidents                     *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  MODE     !  E ! D  ! SENS DE L'INTERPOLATION                      !
C !           !    !    !   = 1 PASSAGE SOLIDE --> FLUIDE              !
C !           !    !    !   = 2 PASSAGE FLUIDE --> SOLIDE              !
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  VCOUPF   ! TR !D M ! VALEUR AUX NOEUDS FLUIDES COUPLES            !
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  VCOUPS   ! TR !D M ! VALEUR AUX NOEUDS SOLIDES COUPLES            !
C !  NELESF   !  E ! D  ! NOMBRE D'ELEMENTS FLUIDES COUPLES            !
C !  NDMASF   !  E ! D  ! NOMBRE DE NOEUDS DES ELEMENTS FLUIDES COUPLES!
C !  NODESF   ! TE ! D  ! TABLE DES ELEMENTS FLUIDES COUPLES (NUM LOC) !
C !  NELESS   !  E ! D  ! NOMBRE D'ELEMENTS SOLIDES COUPLES            !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELEMENTS SOLIDES COUPLES!
C !  NODESS   ! TE ! D  ! TABLE DES ELEMENTS SOLIDES COUPLES (NUM LOC) !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !  BARYF    ! TR ! D  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! FLUIDES DANS LES ELTS SOLIDES                !
C !  NCBORF   ! TE ! D  ! NUMERO DE L'ELEMENT SOLIDE CORRESPONDANT     !
C !  BARYS    ! TR ! D  ! CCORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! SOLIDES DANS LES ELTS FLUIDES                !
C !  NCBORS   ! TE ! D  ! NUMERO DE L'ELEMENT FLUIDE CORRESPONDANT     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER MODE,NDIM,NBCOUF,NBCOUS,NELESF,NDMASF,NELESS,NDMASS
      INTEGER NBICOR
      DOUBLE PRECISION VCOUPF(NBCOUF,2),VCOUPS(NBCOUS,2)
      INTEGER NODESF(NELESF,NDMASF),NODESS(NELESS,NDMASS)
      INTEGER NCBORF(NBCOUF,NBICOR),NCBORS(NBCOUS,NBICOR)
      DOUBLE PRECISION BARYF(NBCOUF,NDIM),BARYS(NBCOUS,NDIM)
C
C..Variables internes
      INTEGER NF,NUMELF,NUMSEG,NS,NUMELS,N1,N2,N
      DOUBLE PRECISION XL1,XL2
C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
C
      IF (MODE.EQ.1) THEN
C
C      1- PASSAGE DU SOLIDE VERS LE FLUIDE
C      ===================================
C
       DO 100 NF=1,NBCOUF
C
        NUMELS = NCBORF(NF,1)
C
        NUMSEG = NCBORF(NF,2)
C
        IF (NUMSEG.EQ.1) THEN
          N1 = NODESS(NUMELS,1)
          N2 = NODESS(NUMELS,3)
        ELSE
          N1 = NODESS(NUMELS,2)
          N2 = NODESS(NUMELS,3)
        ENDIF
C
        XL1 = BARYF(NF,1)
        XL2 = BARYF(NF,2)
C
        VCOUPF(NF,1) =  VCOUPS(N1,1)*XL1 + VCOUPS(N2,1)*XL2 
C
  100  CONTINUE
C
C
C       IMPRESSIONS POUR CONTROLE
C       -------------------------
        IF (NBLBLA.EQ.14) THEN
          WRITE(NFECRA,1010)
          DO 110 N=1,NBCOUF
             WRITE(NFECRA,1020) N,VCOUPF(N,1)
 110      CONTINUE
        ENDIF
C
C
      ELSEIF (MODE.EQ.2) THEN
C
C     2- PASSAGE DU FLUIDE VERS LE SOLIDE
C     ===================================
C
       DO 200 NS=1,NBCOUS
C
        NUMELF = NCBORS(NS,1)
C
        IF (NUMELF.NE.-1) THEN
C
         NUMSEG = NCBORS(NS,2)
C
          IF (NUMSEG.EQ.0) THEN
            N1 = NODESF(NUMELF,1)
            N2 = NODESF(NUMELF,2)
          ELSEIF (NUMSEG.EQ.1) THEN
            N1 = NODESF(NUMELF,1)
            N2 = NODESF(NUMELF,3)
          ELSE
            N1 = NODESF(NUMELF,2)
            N2 = NODESF(NUMELF,3)
          ENDIF
C
          XL1 = BARYS(NS,1)
          XL2 = BARYS(NS,2)
C
          VCOUPS(NS,1) =  VCOUPF(N1,1)*XL1 + VCOUPF(N2,1)*XL2 
          VCOUPS(NS,2) =  VCOUPF(N1,2)*XL1 + VCOUPF(N2,2)*XL2
C
         ENDIF 
C
  200 CONTINUE
C
C       IMPRESSIONS POUR CONTROLE
C       -------------------------
        IF (NBLBLA.EQ.14) THEN
          WRITE(NFECRA,2010)
          DO 210 N=1,NBCOUS
             IF  (NCBORS(N,1).NE.-1) 
     *            WRITE(NFECRA,2020) N,VCOUPS(N,1),VCOUPS(N,2)
 210      CONTINUE
        ENDIF
C
C
C     3- SORTIE EN ERREUR
C     ===================
      ELSE
C
        WRITE(NFECRA,3000)
        STOP
C
      ENDIF
C
C
C
C-------
C FORMAT
C-------
C
 1010 FORMAT(/,' *** PSFNC2 : PASSAGE DES DONNEES DU SOLIDE',
     &         ' VERS LE FLUIDE',/,
     &          5X,' N fluide      T ')
 1020 FORMAT(5X,3X,I10,6X,G13.7)
 2010 FORMAT(/,' *** PSFCN2 : PASSAGE DES DONNEES DU FLUIDE',
     &         ' VERS LE SOLIDE  (vcoups)',/,
     &          5X,' N solide      T        h')
 2020 FORMAT(5X,3X,I10,6X,G13.7,3X,G13.7)
 3000 FORMAT(/,'  %% ERREUR PASSF2 : OPTION DE PASSAGE INCORRECTE ')
C
C----
C FIN
C----
      END
          
