C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=SOUSEG,SSI=0
                        SUBROUTINE SOUSEG
C                       *****************
C
C      --------------------------
     * (XX,YY,XA,YA,XB,YB,NUMSEG)
C      --------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            RECHERCHE DU SOUS SEGMENT (iso P2) DANS LEQUEL SE TROUVE  *
C            LE POINT XX,YY                                            *
C            (DIMENSION 2)                                             *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  XX,YY    !  R ! D  ! POINT DONT CHERCHE LA POSITION               !
C !  XA,YA    !  R ! D  ! COORDONNEES DU 1ER SOMMET DU SEGMENT (solide)!
C !  XB,YB    !  R ! D  ! COORDONNEES DU 2EME SOMMET DU SEGMENT(solide)!
C ! NUMSEG    !  E ! R  ! NUMERO DU SOUS SEGMENT                       !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : CORFS2
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
C
C***********************************************************************
C
      INTEGER NUMSEG
C
      DOUBLE PRECISION XA,YA,XB,YB,XAB,YAB
      DOUBLE PRECISION ABN,XE1,YE1
      DOUBLE PRECISION XXNEW,XANEW,XBNEW
      DOUBLE PRECISION XX,YY
C
C***********************************************************************
C
C     1- DEFINITION DU REPERE LOCAL LIE AU SEGMENT
C     --------------------------------------------
C
      XAB = XB - XA
      YAB = YB - YA
C
      ABN = SQRT ( XAB*XAB + YAB*YAB )
C
      XE1 = XAB / ABN
      YE1 = YAB / ABN
C
C
C     2- COORD  DANS LE NOUVEAU REPERE
C     --------------------------------
C
      XANEW = 0.D0
      XBNEW = ABN
C
      XXNEW = (XX-XA)*XE1 + (YY-YA)*YE1
C
C
C     3- POSITION DU POINT
C     --------------------
C
      IF (XXNEW .GT. XBNEW*0.5D0) THEN
         NUMSEG = 2
      ELSE
         NUMSEG = 1
      ENDIF
C
C----
C FIN
C----
      END
