#
# This file is called by /etc/init.d/vdr
#

writewarning ()
{
echo -e \
"#\n"\
"# This file is automatically generated by the vdr init-script. You can\n"\
"# define custom commands in /etc/vdr/command-hooks/$1.custom.conf\n"\
"# (see /usr/share/doc/vdr/README.Debian.gz).\n"\
"#\n\n\n"
}

# merges single <cmdtype>.<name>.conf files into one <cmdtype>.conf
# in alphabetical order
mergecommands ()
{
    local cmdtype
    local cmdfile

    cmdtype=$1
    cmdfile="/var/cache/vdr/$cmdtype.conf"

    writewarning $cmdtype > "$cmdfile"

    find $CMDHOOKSDIR -maxdepth 1 -name "$cmdtype.*.conf" | sort | xargs cat >> "$cmdfile"
}
