// This is mul/vil3d/algo/vil3d_corners.h
#ifndef vil3d_corners_h_
#define vil3d_corners_h_
//:
// \file
// \brief  Class containing functions to estimate corner-ness in various ways.
// \author Tim Cootes

#include <vil3d/vil3d_image_view.h>

//: Class containing functions to estimate corner-ness in various ways.
//  Implements 3D corner operators suggested by Karl Rohr
template <class srcT, class destT>
class vil3d_corners
{
private:
  //: Compute gradients, products and smoothed versions
  void compute_smooth_gradient_products(const vil3d_image_view<srcT>& src_im);
public:
  //: Computes cornerness measure for every pixel
  //  At each pixel, computes det(N)/trace(N), where
  //  N is a matrix generated by smoothing over gradient
  //  product matrices M = (gi, gj, gk)' * (gi, gj, gk),
  //  where gi = i-gradient at a pixel etc.
  //
  //  This is the Op3 corner operator described by Rohr.
  void cornerness1(const vil3d_image_view<srcT>& src_im,
                   vil3d_image_view<destT>& cornerness);

  //: Workspace for gradient in i
  vil3d_image_view<destT> grad_i;
  //: Workspace for gradient in j
  vil3d_image_view<destT> grad_j;
  //: Workspace for gradient in k
  vil3d_image_view<destT> grad_k;

  //: Workspace for product images
  vil3d_image_view<destT> grad_product_;
  //: Workspace for smoothed product images
  vil3d_image_view<destT> smooth_grad_product_;

};

#endif // vil3d_corners_h_

