# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "account list-locations",
)
class ListLocations(AAZCommand):
    """List supported regions for the current subscription.
    """

    _aaz_info = {
        "version": "2022-12-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/locations", "2022-12-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.include_extended_locations = AAZBoolArg(
            options=["--include-extended-locations"],
            help="Whether to include extended locations.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SubscriptionsListLocations(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        return result

    class SubscriptionsListLocations(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/locations",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "includeExtendedLocations", self.ctx.args.include_extended_locations,
                ),
                **self.serialize_query_param(
                    "api-version", "2022-12-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.value = AAZListType()

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.availability_zone_mappings = AAZListType(
                serialized_name="availabilityZoneMappings",
            )
            _element.display_name = AAZStrType(
                serialized_name="displayName",
                flags={"read_only": True},
            )
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.metadata = AAZObjectType()
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.regional_display_name = AAZStrType(
                serialized_name="regionalDisplayName",
                flags={"read_only": True},
            )
            _element.subscription_id = AAZStrType(
                serialized_name="subscriptionId",
                flags={"read_only": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            availability_zone_mappings = cls._schema_on_200.value.Element.availability_zone_mappings
            availability_zone_mappings.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.availability_zone_mappings.Element
            _element.logical_zone = AAZStrType(
                serialized_name="logicalZone",
                flags={"read_only": True},
            )
            _element.physical_zone = AAZStrType(
                serialized_name="physicalZone",
                flags={"read_only": True},
            )

            metadata = cls._schema_on_200.value.Element.metadata
            metadata.geography = AAZStrType(
                flags={"read_only": True},
            )
            metadata.geography_group = AAZStrType(
                serialized_name="geographyGroup",
                flags={"read_only": True},
            )
            metadata.home_location = AAZStrType(
                serialized_name="homeLocation",
                flags={"read_only": True},
            )
            metadata.latitude = AAZStrType(
                flags={"read_only": True},
            )
            metadata.longitude = AAZStrType(
                flags={"read_only": True},
            )
            metadata.paired_region = AAZListType(
                serialized_name="pairedRegion",
            )
            metadata.physical_location = AAZStrType(
                serialized_name="physicalLocation",
                flags={"read_only": True},
            )
            metadata.region_category = AAZStrType(
                serialized_name="regionCategory",
                flags={"read_only": True},
            )
            metadata.region_type = AAZStrType(
                serialized_name="regionType",
                flags={"read_only": True},
            )

            paired_region = cls._schema_on_200.value.Element.metadata.paired_region
            paired_region.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.metadata.paired_region.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.subscription_id = AAZStrType(
                serialized_name="subscriptionId",
                flags={"read_only": True},
            )

            return cls._schema_on_200


class _ListLocationsHelper:
    """Helper class for ListLocations"""


__all__ = ["ListLocations"]
