#include <gtk/gtk.h>
#include "casilda-compositor.h"

/* Do not listen on any socket by default */
gchar *socket = NULL;


static void
activate (GtkApplication *app, G_GNUC_UNUSED gpointer  user_data)
{
  CasildaCompositor *compositor;
  GtkWidget *window, *sw;

  window = gtk_application_window_new (app);
  gtk_window_set_title (GTK_WINDOW (window), "Casilda Compositor");
  gtk_window_set_default_size (GTK_WINDOW (window), 800, 600);

  if (socket)
    g_message ("Listening on %s", socket);
  else
    g_message ("Not listening in any socket, you can pass a socket path as parameter");

  sw = gtk_scrolled_window_new ();
  compositor = casilda_compositor_new (socket);

  gtk_scrolled_window_set_child (GTK_SCROLLED_WINDOW (sw), GTK_WIDGET (compositor));
  gtk_window_set_child (GTK_WINDOW (window), GTK_WIDGET (sw));
  gtk_window_present (GTK_WINDOW (window));

  gchar *argv[2] = {
    "/usr/bin/gtk4-demo",
     NULL
  };

  casilda_compositor_spawn_async (compositor, NULL, argv, NULL, G_SPAWN_DEFAULT, NULL, NULL, NULL, NULL);
}

int
main (int argc, char **argv)
{
  g_autoptr(GtkApplication) app = NULL;

  app = gtk_application_new ("ar.xjuan.casilda.Example", G_APPLICATION_DEFAULT_FLAGS);
  g_signal_connect (app, "activate", G_CALLBACK (activate), NULL);

  if (argc >= 2)
    socket = argv[1];

  return g_application_run (G_APPLICATION (app), 0, NULL);
}
