/* SPDX-License-Identifier: GPL-2.0-only */

#include <mipi/panel.h>

struct panel_serializable_data BOE_TV101WUM_NL6 = {
	.edid = {
		.ascii_string = "TV101WUM-NL6",
		.manufacturer_name = "BOE",
		.panel_bits_per_color = 8,
		.panel_bits_per_pixel = 24,
		.mode = {
			.pixel_clock = 159425,
			.lvds_dual_channel = 0,
			.refresh = 60,
			.ha = 1200, .hbl = 164, .hso = 100, .hspw = 24,
			.va = 1920, .vbl = 28, .vso = 10, .vspw = 4,
			.phsync = '-', .pvsync = '-',
			.x_mm = 135, .y_mm = 216,
		},
	},
	.init = {
		PANEL_DELAY(24),
		PANEL_DCS(0xB0, 0x05),
		PANEL_DCS(0xB1, 0xE5),
		PANEL_DCS(0xB3, 0x52),
		PANEL_DCS(0xB0, 0x00),
		PANEL_DCS(0xB3, 0x88),
		PANEL_DCS(0xB0, 0x04),
		PANEL_DCS(0xB8, 0x00),
		PANEL_DCS(0xB0, 0x00),
		PANEL_DCS(0xB6, 0x03),
		PANEL_DCS(0xBA, 0x8B),
		PANEL_DCS(0xBF, 0x1A),
		PANEL_DCS(0xC0, 0x0F),
		PANEL_DCS(0xC2, 0x0C),
		PANEL_DCS(0xC3, 0x02),
		PANEL_DCS(0xC4, 0x0C),
		PANEL_DCS(0xC5, 0x02),
		PANEL_DCS(0xB0, 0x01),
		PANEL_DCS(0xE0, 0x26),
		PANEL_DCS(0xE1, 0x26),
		PANEL_DCS(0xDC, 0x00),
		PANEL_DCS(0xDD, 0x00),
		PANEL_DCS(0xCC, 0x26),
		PANEL_DCS(0xCD, 0x26),
		PANEL_DCS(0xC8, 0x00),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xD2, 0x03),
		PANEL_DCS(0xD3, 0x03),
		PANEL_DCS(0xE6, 0x04),
		PANEL_DCS(0xE7, 0x04),
		PANEL_DCS(0xC4, 0x09),
		PANEL_DCS(0xC5, 0x09),
		PANEL_DCS(0xD8, 0x0A),
		PANEL_DCS(0xD9, 0x0A),
		PANEL_DCS(0xC2, 0x0B),
		PANEL_DCS(0xC3, 0x0B),
		PANEL_DCS(0xD6, 0x0C),
		PANEL_DCS(0xD7, 0x0C),
		PANEL_DCS(0xC0, 0x05),
		PANEL_DCS(0xC1, 0x05),
		PANEL_DCS(0xD4, 0x06),
		PANEL_DCS(0xD5, 0x06),
		PANEL_DCS(0xCA, 0x07),
		PANEL_DCS(0xCB, 0x07),
		PANEL_DCS(0xDE, 0x08),
		PANEL_DCS(0xDF, 0x08),
		PANEL_DCS(0xB0, 0x02),
		PANEL_DCS(0xC0, 0x00),
		PANEL_DCS(0xC1, 0x0D),
		PANEL_DCS(0xC2, 0x17),
		PANEL_DCS(0xC3, 0x26),
		PANEL_DCS(0xC4, 0x31),
		PANEL_DCS(0xC5, 0x1C),
		PANEL_DCS(0xC6, 0x2C),
		PANEL_DCS(0xC7, 0x33),
		PANEL_DCS(0xC8, 0x31),
		PANEL_DCS(0xC9, 0x37),
		PANEL_DCS(0xCA, 0x37),
		PANEL_DCS(0xCB, 0x37),
		PANEL_DCS(0xCC, 0x39),
		PANEL_DCS(0xCD, 0x2E),
		PANEL_DCS(0xCE, 0x2F),
		PANEL_DCS(0xCF, 0x2F),
		PANEL_DCS(0xD0, 0x07),
		PANEL_DCS(0xD2, 0x00),
		PANEL_DCS(0xD3, 0x0D),
		PANEL_DCS(0xD4, 0x17),
		PANEL_DCS(0xD5, 0x26),
		PANEL_DCS(0xD6, 0x31),
		PANEL_DCS(0xD7, 0x3F),
		PANEL_DCS(0xD8, 0x3F),
		PANEL_DCS(0xD9, 0x3F),
		PANEL_DCS(0xDA, 0x3F),
		PANEL_DCS(0xDB, 0x37),
		PANEL_DCS(0xDC, 0x37),
		PANEL_DCS(0xDD, 0x37),
		PANEL_DCS(0xDE, 0x39),
		PANEL_DCS(0xDF, 0x2E),
		PANEL_DCS(0xE0, 0x2F),
		PANEL_DCS(0xE1, 0x2F),
		PANEL_DCS(0xE2, 0x07),
		PANEL_DCS(0xB0, 0x03),
		PANEL_DCS(0xC8, 0x0B),
		PANEL_DCS(0xC9, 0x07),
		PANEL_DCS(0xC3, 0x00),
		PANEL_DCS(0xE7, 0x00),
		PANEL_DCS(0xC5, 0x2A),
		PANEL_DCS(0xDE, 0x2A),
		PANEL_DCS(0xCA, 0x43),
		PANEL_DCS(0xC9, 0x07),
		PANEL_DCS(0xE4, 0xC0),
		PANEL_DCS(0xE5, 0x0D),
		PANEL_DCS(0xCB, 0x00),
		PANEL_DCS(0xB0, 0x06),
		PANEL_DCS(0xB8, 0xA5),
		PANEL_DCS(0xC0, 0xA5),
		PANEL_DCS(0xC7, 0x0F),
		PANEL_DCS(0xD5, 0x32),
		PANEL_DCS(0xB8, 0x00),
		PANEL_DCS(0xC0, 0x00),
		PANEL_DCS(0xBC, 0x00),
		PANEL_DCS(0xB0, 0x07),
		PANEL_DCS(0xB1, 0x00),
		PANEL_DCS(0xB2, 0x02),
		PANEL_DCS(0xB3, 0x0F),
		PANEL_DCS(0xB4, 0x25),
		PANEL_DCS(0xB5, 0x39),
		PANEL_DCS(0xB6, 0x4E),
		PANEL_DCS(0xB7, 0x72),
		PANEL_DCS(0xB8, 0x97),
		PANEL_DCS(0xB9, 0xDC),
		PANEL_DCS(0xBA, 0x22),
		PANEL_DCS(0xBB, 0xA4),
		PANEL_DCS(0xBC, 0x2B),
		PANEL_DCS(0xBD, 0x2F),
		PANEL_DCS(0xBE, 0xA9),
		PANEL_DCS(0xBF, 0x25),
		PANEL_DCS(0xC0, 0x61),
		PANEL_DCS(0xC1, 0x97),
		PANEL_DCS(0xC2, 0xB2),
		PANEL_DCS(0xC3, 0xCD),
		PANEL_DCS(0xC4, 0xD9),
		PANEL_DCS(0xC5, 0xE7),
		PANEL_DCS(0xC6, 0xF4),
		PANEL_DCS(0xC7, 0xFA),
		PANEL_DCS(0xC8, 0xFC),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x08),
		PANEL_DCS(0xB1, 0x04),
		PANEL_DCS(0xB2, 0x05),
		PANEL_DCS(0xB3, 0x11),
		PANEL_DCS(0xB4, 0x24),
		PANEL_DCS(0xB5, 0x39),
		PANEL_DCS(0xB6, 0x4F),
		PANEL_DCS(0xB7, 0x72),
		PANEL_DCS(0xB8, 0x98),
		PANEL_DCS(0xB9, 0xDC),
		PANEL_DCS(0xBA, 0x23),
		PANEL_DCS(0xBB, 0xA6),
		PANEL_DCS(0xBC, 0x2C),
		PANEL_DCS(0xBD, 0x30),
		PANEL_DCS(0xBE, 0xAA),
		PANEL_DCS(0xBF, 0x26),
		PANEL_DCS(0xC0, 0x62),
		PANEL_DCS(0xC1, 0x9B),
		PANEL_DCS(0xC2, 0xB5),
		PANEL_DCS(0xC3, 0xCF),
		PANEL_DCS(0xC4, 0xDB),
		PANEL_DCS(0xC5, 0xE8),
		PANEL_DCS(0xC6, 0xF5),
		PANEL_DCS(0xC7, 0xFA),
		PANEL_DCS(0xC8, 0xFC),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x09),
		PANEL_DCS(0xB1, 0x04),
		PANEL_DCS(0xB2, 0x02),
		PANEL_DCS(0xB3, 0x16),
		PANEL_DCS(0xB4, 0x24),
		PANEL_DCS(0xB5, 0x3B),
		PANEL_DCS(0xB6, 0x4F),
		PANEL_DCS(0xB7, 0x73),
		PANEL_DCS(0xB8, 0x99),
		PANEL_DCS(0xB9, 0xE0),
		PANEL_DCS(0xBA, 0x26),
		PANEL_DCS(0xBB, 0xAD),
		PANEL_DCS(0xBC, 0x36),
		PANEL_DCS(0xBD, 0x3A),
		PANEL_DCS(0xBE, 0xAE),
		PANEL_DCS(0xBF, 0x2A),
		PANEL_DCS(0xC0, 0x66),
		PANEL_DCS(0xC1, 0x9E),
		PANEL_DCS(0xC2, 0xB8),
		PANEL_DCS(0xC3, 0xD1),
		PANEL_DCS(0xC4, 0xDD),
		PANEL_DCS(0xC5, 0xE9),
		PANEL_DCS(0xC6, 0xF6),
		PANEL_DCS(0xC7, 0xFA),
		PANEL_DCS(0xC8, 0xFC),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x0A),
		PANEL_DCS(0xB1, 0x00),
		PANEL_DCS(0xB2, 0x02),
		PANEL_DCS(0xB3, 0x0F),
		PANEL_DCS(0xB4, 0x25),
		PANEL_DCS(0xB5, 0x39),
		PANEL_DCS(0xB6, 0x4E),
		PANEL_DCS(0xB7, 0x72),
		PANEL_DCS(0xB8, 0x97),
		PANEL_DCS(0xB9, 0xDC),
		PANEL_DCS(0xBA, 0x22),
		PANEL_DCS(0xBB, 0xA4),
		PANEL_DCS(0xBC, 0x2B),
		PANEL_DCS(0xBD, 0x2F),
		PANEL_DCS(0xBE, 0xA9),
		PANEL_DCS(0xBF, 0x25),
		PANEL_DCS(0xC0, 0x61),
		PANEL_DCS(0xC1, 0x97),
		PANEL_DCS(0xC2, 0xB2),
		PANEL_DCS(0xC3, 0xCD),
		PANEL_DCS(0xC4, 0xD9),
		PANEL_DCS(0xC5, 0xE7),
		PANEL_DCS(0xC6, 0xF4),
		PANEL_DCS(0xC7, 0xFA),
		PANEL_DCS(0xC8, 0xFC),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x0B),
		PANEL_DCS(0xB1, 0x04),
		PANEL_DCS(0xB2, 0x05),
		PANEL_DCS(0xB3, 0x11),
		PANEL_DCS(0xB4, 0x24),
		PANEL_DCS(0xB5, 0x39),
		PANEL_DCS(0xB6, 0x4F),
		PANEL_DCS(0xB7, 0x72),
		PANEL_DCS(0xB8, 0x98),
		PANEL_DCS(0xB9, 0xDC),
		PANEL_DCS(0xBA, 0x23),
		PANEL_DCS(0xBB, 0xA6),
		PANEL_DCS(0xBC, 0x2C),
		PANEL_DCS(0xBD, 0x30),
		PANEL_DCS(0xBE, 0xAA),
		PANEL_DCS(0xBF, 0x26),
		PANEL_DCS(0xC0, 0x62),
		PANEL_DCS(0xC1, 0x9B),
		PANEL_DCS(0xC2, 0xB5),
		PANEL_DCS(0xC3, 0xCF),
		PANEL_DCS(0xC4, 0xDB),
		PANEL_DCS(0xC5, 0xE8),
		PANEL_DCS(0xC6, 0xF5),
		PANEL_DCS(0xC7, 0xFA),
		PANEL_DCS(0xC8, 0xFC),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x0C),
		PANEL_DCS(0xB1, 0x04),
		PANEL_DCS(0xB2, 0x02),
		PANEL_DCS(0xB3, 0x16),
		PANEL_DCS(0xB4, 0x24),
		PANEL_DCS(0xB5, 0x3B),
		PANEL_DCS(0xB6, 0x4F),
		PANEL_DCS(0xB7, 0x73),
		PANEL_DCS(0xB8, 0x99),
		PANEL_DCS(0xB9, 0xE0),
		PANEL_DCS(0xBA, 0x26),
		PANEL_DCS(0xBB, 0xAD),
		PANEL_DCS(0xBC, 0x36),
		PANEL_DCS(0xBD, 0x3A),
		PANEL_DCS(0xBE, 0xAE),
		PANEL_DCS(0xBF, 0x2A),
		PANEL_DCS(0xC0, 0x66),
		PANEL_DCS(0xC1, 0x9E),
		PANEL_DCS(0xC2, 0xB8),
		PANEL_DCS(0xC3, 0xD1),
		PANEL_DCS(0xC4, 0xDD),
		PANEL_DCS(0xC5, 0xE9),
		PANEL_DCS(0xC6, 0xF6),
		PANEL_DCS(0xC7, 0xFA),
		PANEL_DCS(0xC8, 0xFC),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x00),
		PANEL_DCS(0xB3, 0x08),
		PANEL_DCS(0xB0, 0x04),
		PANEL_DCS(0xB8, 0x68),
		PANEL_DELAY(150),
		PANEL_END,
	},
};
