/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef MAINBOARD_EC_H
#define MAINBOARD_EC_H

#include <baseboard/ec.h>

#undef MAINBOARD_EC_SCI_EVENTS
#define MAINBOARD_EC_SCI_EVENTS \
	(EC_HOST_EVENT_MASK(EC_HOST_EVENT_AC_CONNECTED)      |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_AC_DISCONNECTED)   |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_THERMAL_THRESHOLD) |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_THROTTLE_START)    |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_THROTTLE_STOP)     |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_MKBP)              |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_PD_MCU)            |\
	 EC_HOST_EVENT_MASK(EC_HOST_EVENT_MODE_CHANGE))

#undef MAINBOARD_EC_SMI_EVENTS
#define MAINBOARD_EC_SMI_EVENTS 0

/* EC can wake from S5 with power button */
#undef MAINBOARD_EC_S5_WAKE_EVENTS
#define MAINBOARD_EC_S5_WAKE_EVENTS \
	(EC_HOST_EVENT_MASK(EC_HOST_EVENT_POWER_BUTTON))

/* EC can wake from S3 with power button */
#undef MAINBOARD_EC_S3_WAKE_EVENTS
#define MAINBOARD_EC_S3_WAKE_EVENTS (MAINBOARD_EC_S5_WAKE_EVENTS)

/* Disaable LID switch */
#undef EC_ENABLE_LID_SWITCH

#undef SIO_EC_ENABLE_PS2K       /* Disable PS/2 Keyboard */

#endif
