// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/merchant/conversions/v1beta/conversionsources.proto

package conversionspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents state of the conversion source.
type ConversionSource_State int32

const (
	// Conversion source has unspecified state.
	ConversionSource_STATE_UNSPECIFIED ConversionSource_State = 0
	// Conversion source is fully functional.
	ConversionSource_ACTIVE ConversionSource_State = 1
	// Conversion source has been archived in the last 30 days and not
	// currently functional. Can be restored using the undelete method.
	ConversionSource_ARCHIVED ConversionSource_State = 2
	// Conversion source creation has started but not fully finished yet.
	ConversionSource_PENDING ConversionSource_State = 3
)

// Enum value maps for ConversionSource_State.
var (
	ConversionSource_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "ARCHIVED",
		3: "PENDING",
	}
	ConversionSource_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"ARCHIVED":          2,
		"PENDING":           3,
	}
)

func (x ConversionSource_State) Enum() *ConversionSource_State {
	p := new(ConversionSource_State)
	*p = x
	return p
}

func (x ConversionSource_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversionSource_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_enumTypes[0].Descriptor()
}

func (ConversionSource_State) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_enumTypes[0]
}

func (x ConversionSource_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversionSource_State.Descriptor instead.
func (ConversionSource_State) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{0, 0}
}

// Entity controlling the conversion source.
type ConversionSource_Controller int32

const (
	// Default value. This value is unused.
	ConversionSource_CONTROLLER_UNSPECIFIED ConversionSource_Controller = 0
	// Controlled by the Merchant who owns the Conversion Source.
	ConversionSource_MERCHANT ConversionSource_Controller = 1
	// Controlled by the YT Affiliates program.
	ConversionSource_YOUTUBE_AFFILIATES ConversionSource_Controller = 2
)

// Enum value maps for ConversionSource_Controller.
var (
	ConversionSource_Controller_name = map[int32]string{
		0: "CONTROLLER_UNSPECIFIED",
		1: "MERCHANT",
		2: "YOUTUBE_AFFILIATES",
	}
	ConversionSource_Controller_value = map[string]int32{
		"CONTROLLER_UNSPECIFIED": 0,
		"MERCHANT":               1,
		"YOUTUBE_AFFILIATES":     2,
	}
)

func (x ConversionSource_Controller) Enum() *ConversionSource_Controller {
	p := new(ConversionSource_Controller)
	*p = x
	return p
}

func (x ConversionSource_Controller) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversionSource_Controller) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_enumTypes[1].Descriptor()
}

func (ConversionSource_Controller) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_enumTypes[1]
}

func (x ConversionSource_Controller) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversionSource_Controller.Descriptor instead.
func (ConversionSource_Controller) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{0, 1}
}

// The attribution model used for this source. We support the same set of
// models offered by Google Analytics 4, as described in:
// https://support.google.com/analytics/answer/10596866.
type AttributionSettings_AttributionModel int32

const (
	// Unspecified model.
	AttributionSettings_ATTRIBUTION_MODEL_UNSPECIFIED AttributionSettings_AttributionModel = 0
	// Cross-channel Last Click model.
	AttributionSettings_CROSS_CHANNEL_LAST_CLICK AttributionSettings_AttributionModel = 1
	// Ads-preferred Last Click model.
	AttributionSettings_ADS_PREFERRED_LAST_CLICK AttributionSettings_AttributionModel = 2
	// Cross-channel Data Driven model.
	AttributionSettings_CROSS_CHANNEL_DATA_DRIVEN AttributionSettings_AttributionModel = 5
	// Cross-channel First Click model.
	AttributionSettings_CROSS_CHANNEL_FIRST_CLICK AttributionSettings_AttributionModel = 6
	// Cross-channel Linear model.
	AttributionSettings_CROSS_CHANNEL_LINEAR AttributionSettings_AttributionModel = 7
	// Cross-channel Position Based model.
	AttributionSettings_CROSS_CHANNEL_POSITION_BASED AttributionSettings_AttributionModel = 8
	// Cross-channel Time Decay model.
	AttributionSettings_CROSS_CHANNEL_TIME_DECAY AttributionSettings_AttributionModel = 9
)

// Enum value maps for AttributionSettings_AttributionModel.
var (
	AttributionSettings_AttributionModel_name = map[int32]string{
		0: "ATTRIBUTION_MODEL_UNSPECIFIED",
		1: "CROSS_CHANNEL_LAST_CLICK",
		2: "ADS_PREFERRED_LAST_CLICK",
		5: "CROSS_CHANNEL_DATA_DRIVEN",
		6: "CROSS_CHANNEL_FIRST_CLICK",
		7: "CROSS_CHANNEL_LINEAR",
		8: "CROSS_CHANNEL_POSITION_BASED",
		9: "CROSS_CHANNEL_TIME_DECAY",
	}
	AttributionSettings_AttributionModel_value = map[string]int32{
		"ATTRIBUTION_MODEL_UNSPECIFIED": 0,
		"CROSS_CHANNEL_LAST_CLICK":      1,
		"ADS_PREFERRED_LAST_CLICK":      2,
		"CROSS_CHANNEL_DATA_DRIVEN":     5,
		"CROSS_CHANNEL_FIRST_CLICK":     6,
		"CROSS_CHANNEL_LINEAR":          7,
		"CROSS_CHANNEL_POSITION_BASED":  8,
		"CROSS_CHANNEL_TIME_DECAY":      9,
	}
)

func (x AttributionSettings_AttributionModel) Enum() *AttributionSettings_AttributionModel {
	p := new(AttributionSettings_AttributionModel)
	*p = x
	return p
}

func (x AttributionSettings_AttributionModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttributionSettings_AttributionModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_enumTypes[2].Descriptor()
}

func (AttributionSettings_AttributionModel) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_enumTypes[2]
}

func (x AttributionSettings_AttributionModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttributionSettings_AttributionModel.Descriptor instead.
func (AttributionSettings_AttributionModel) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{1, 0}
}

// Represents a conversion source owned by a Merchant account. A merchant
// account can have up to 200 conversion sources.
type ConversionSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	// Conversion source data specific to each different type of source.
	//
	// Types that are assignable to SourceData:
	//
	//	*ConversionSource_GoogleAnalyticsLink
	//	*ConversionSource_MerchantCenterDestination
	SourceData isConversionSource_SourceData `protobuf_oneof:"source_data"`
	// Output only. Identifier. Generated by the Content API upon creation of a
	// new `ConversionSource`. Format: [a-z]{4}:.+ The four characters before the
	// colon represent the type of conversio source. Content after the colon
	// represents the ID of the conversion source within that type. The ID of two
	// different conversion sources might be the same across different types. The
	// following type prefixes are supported:
	// - galk: For GoogleAnalyticsLink sources.
	// - mcdn: For MerchantCenterDestination sources.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Current state of this conversion source. Can't be edited
	// through the API.
	State ConversionSource_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.shopping.merchant.conversions.v1beta.ConversionSource_State" json:"state,omitempty"`
	// Output only. The time when an archived conversion source becomes
	// permanently deleted and is no longer available to undelete.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. Controller of the conversion source.
	Controller ConversionSource_Controller `protobuf:"varint,7,opt,name=controller,proto3,enum=google.shopping.merchant.conversions.v1beta.ConversionSource_Controller" json:"controller,omitempty"`
}

func (x *ConversionSource) Reset() {
	*x = ConversionSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversionSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversionSource) ProtoMessage() {}

func (x *ConversionSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversionSource.ProtoReflect.Descriptor instead.
func (*ConversionSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{0}
}

func (m *ConversionSource) GetSourceData() isConversionSource_SourceData {
	if m != nil {
		return m.SourceData
	}
	return nil
}

func (x *ConversionSource) GetGoogleAnalyticsLink() *GoogleAnalyticsLink {
	if x, ok := x.GetSourceData().(*ConversionSource_GoogleAnalyticsLink); ok {
		return x.GoogleAnalyticsLink
	}
	return nil
}

func (x *ConversionSource) GetMerchantCenterDestination() *MerchantCenterDestination {
	if x, ok := x.GetSourceData().(*ConversionSource_MerchantCenterDestination); ok {
		return x.MerchantCenterDestination
	}
	return nil
}

func (x *ConversionSource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConversionSource) GetState() ConversionSource_State {
	if x != nil {
		return x.State
	}
	return ConversionSource_STATE_UNSPECIFIED
}

func (x *ConversionSource) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *ConversionSource) GetController() ConversionSource_Controller {
	if x != nil {
		return x.Controller
	}
	return ConversionSource_CONTROLLER_UNSPECIFIED
}

type isConversionSource_SourceData interface {
	isConversionSource_SourceData()
}

type ConversionSource_GoogleAnalyticsLink struct {
	// Immutable. Conversion Source of type "Link to Google Analytics Property".
	GoogleAnalyticsLink *GoogleAnalyticsLink `protobuf:"bytes,3,opt,name=google_analytics_link,json=googleAnalyticsLink,proto3,oneof"`
}

type ConversionSource_MerchantCenterDestination struct {
	// Conversion Source of type "Merchant Center Tag Destination".
	MerchantCenterDestination *MerchantCenterDestination `protobuf:"bytes,4,opt,name=merchant_center_destination,json=merchantCenterDestination,proto3,oneof"`
}

func (*ConversionSource_GoogleAnalyticsLink) isConversionSource_SourceData() {}

func (*ConversionSource_MerchantCenterDestination) isConversionSource_SourceData() {}

// Represents attribution settings for conversion sources receiving
// pre-attribution data.
type AttributionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Lookback windows (in days) used for attribution in this source.
	// Supported values are 7, 30, 40.
	AttributionLookbackWindowDays int32 `protobuf:"varint,1,opt,name=attribution_lookback_window_days,json=attributionLookbackWindowDays,proto3" json:"attribution_lookback_window_days,omitempty"`
	// Required. Attribution model.
	AttributionModel AttributionSettings_AttributionModel `protobuf:"varint,2,opt,name=attribution_model,json=attributionModel,proto3,enum=google.shopping.merchant.conversions.v1beta.AttributionSettings_AttributionModel" json:"attribution_model,omitempty"`
	// Immutable. Unordered list. List of different conversion types a conversion
	// event can be classified as. A standard "purchase" type will be
	// automatically created if this list is empty at creation time.
	ConversionType []*AttributionSettings_ConversionType `protobuf:"bytes,3,rep,name=conversion_type,json=conversionType,proto3" json:"conversion_type,omitempty"`
}

func (x *AttributionSettings) Reset() {
	*x = AttributionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSettings) ProtoMessage() {}

func (x *AttributionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSettings.ProtoReflect.Descriptor instead.
func (*AttributionSettings) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{1}
}

func (x *AttributionSettings) GetAttributionLookbackWindowDays() int32 {
	if x != nil {
		return x.AttributionLookbackWindowDays
	}
	return 0
}

func (x *AttributionSettings) GetAttributionModel() AttributionSettings_AttributionModel {
	if x != nil {
		return x.AttributionModel
	}
	return AttributionSettings_ATTRIBUTION_MODEL_UNSPECIFIED
}

func (x *AttributionSettings) GetConversionType() []*AttributionSettings_ConversionType {
	if x != nil {
		return x.ConversionType
	}
	return nil
}

// "Google Analytics Link" sources can be used to get conversion data from an
// existing Google Analytics property into the linked Merchant Center account.
type GoogleAnalyticsLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. ID of the Google Analytics property the merchant is
	// linked to.
	PropertyId int64 `protobuf:"varint,1,opt,name=property_id,json=propertyId,proto3" json:"property_id,omitempty"`
	// Output only. Attribution settings for the linked Google Analytics property.
	AttributionSettings *AttributionSettings `protobuf:"bytes,2,opt,name=attribution_settings,json=attributionSettings,proto3" json:"attribution_settings,omitempty"`
	// Output only. Name of the Google Analytics property the merchant is linked
	// to.
	Property string `protobuf:"bytes,3,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *GoogleAnalyticsLink) Reset() {
	*x = GoogleAnalyticsLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleAnalyticsLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleAnalyticsLink) ProtoMessage() {}

func (x *GoogleAnalyticsLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleAnalyticsLink.ProtoReflect.Descriptor instead.
func (*GoogleAnalyticsLink) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{2}
}

func (x *GoogleAnalyticsLink) GetPropertyId() int64 {
	if x != nil {
		return x.PropertyId
	}
	return 0
}

func (x *GoogleAnalyticsLink) GetAttributionSettings() *AttributionSettings {
	if x != nil {
		return x.AttributionSettings
	}
	return nil
}

func (x *GoogleAnalyticsLink) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

// "Merchant Center Destination" sources can be used to send conversion events
// from an online store using a Google tag directly to a Merchant Center account
// where the source is created.
type MerchantCenterDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Merchant Center Destination ID.
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// Required. Attribution settings being used for the Merchant Center
	// Destination.
	AttributionSettings *AttributionSettings `protobuf:"bytes,2,opt,name=attribution_settings,json=attributionSettings,proto3" json:"attribution_settings,omitempty"`
	// Required. Merchant-specified display name for the destination. This is the
	// name that identifies the conversion source within the Merchant Center UI.
	// Limited to 64 characters.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Three-letter currency code (ISO 4217). The currency code defines
	// in which currency the conversions sent to this destination will be reported
	// in Merchant Center.
	CurrencyCode string `protobuf:"bytes,4,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
}

func (x *MerchantCenterDestination) Reset() {
	*x = MerchantCenterDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MerchantCenterDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantCenterDestination) ProtoMessage() {}

func (x *MerchantCenterDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantCenterDestination.ProtoReflect.Descriptor instead.
func (*MerchantCenterDestination) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{3}
}

func (x *MerchantCenterDestination) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *MerchantCenterDestination) GetAttributionSettings() *AttributionSettings {
	if x != nil {
		return x.AttributionSettings
	}
	return nil
}

func (x *MerchantCenterDestination) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MerchantCenterDestination) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

// Request message for the CreateConversionSource method.
type CreateConversionSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The merchant account that will own the new conversion source.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversion source description. A new ID will be automatically
	// assigned to it upon creation.
	ConversionSource *ConversionSource `protobuf:"bytes,2,opt,name=conversion_source,json=conversionSource,proto3" json:"conversion_source,omitempty"`
}

func (x *CreateConversionSourceRequest) Reset() {
	*x = CreateConversionSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversionSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversionSourceRequest) ProtoMessage() {}

func (x *CreateConversionSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversionSourceRequest.ProtoReflect.Descriptor instead.
func (*CreateConversionSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{4}
}

func (x *CreateConversionSourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversionSourceRequest) GetConversionSource() *ConversionSource {
	if x != nil {
		return x.ConversionSource
	}
	return nil
}

// Request message for the UpdateConversionSource method.
type UpdateConversionSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new version of the conversion source data.
	// Format: accounts/{account}/conversionSources/{conversion_source}
	ConversionSource *ConversionSource `protobuf:"bytes,1,opt,name=conversion_source,json=conversionSource,proto3" json:"conversion_source,omitempty"`
	// Required. List of fields being updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConversionSourceRequest) Reset() {
	*x = UpdateConversionSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConversionSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversionSourceRequest) ProtoMessage() {}

func (x *UpdateConversionSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversionSourceRequest.ProtoReflect.Descriptor instead.
func (*UpdateConversionSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateConversionSourceRequest) GetConversionSource() *ConversionSource {
	if x != nil {
		return x.ConversionSource
	}
	return nil
}

func (x *UpdateConversionSourceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for the DeleteConversionSource method.
type DeleteConversionSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversion source to be deleted.
	// Format: accounts/{account}/conversionSources/{conversion_source}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversionSourceRequest) Reset() {
	*x = DeleteConversionSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversionSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversionSourceRequest) ProtoMessage() {}

func (x *DeleteConversionSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversionSourceRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversionSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteConversionSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the UndeleteConversionSource method.
type UndeleteConversionSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversion source to be undeleted.
	// Format: accounts/{account}/conversionSources/{conversion_source}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeleteConversionSourceRequest) Reset() {
	*x = UndeleteConversionSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeleteConversionSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteConversionSourceRequest) ProtoMessage() {}

func (x *UndeleteConversionSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteConversionSourceRequest.ProtoReflect.Descriptor instead.
func (*UndeleteConversionSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{7}
}

func (x *UndeleteConversionSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the GetConversionSource method.
type GetConversionSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversion source to be fetched.
	// Format: accounts/{account}/conversionsources/{conversion_source}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversionSourceRequest) Reset() {
	*x = GetConversionSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversionSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversionSourceRequest) ProtoMessage() {}

func (x *GetConversionSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversionSourceRequest.ProtoReflect.Descriptor instead.
func (*GetConversionSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{8}
}

func (x *GetConversionSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the ListConversionSources method.
type ListConversionSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The merchant account who owns the collection of conversion
	// sources. Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of conversion sources to return in a page.
	// If no `page_size` is specified, `100` is used as the default value. The
	// maximum value is `200`. Values above `200` will be coerced to `200`.
	// Regardless of pagination, at most `200` conversion sources are returned
	// in total.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Show deleted (archived) option.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListConversionSourcesRequest) Reset() {
	*x = ListConversionSourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionSourcesRequest) ProtoMessage() {}

func (x *ListConversionSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListConversionSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{9}
}

func (x *ListConversionSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversionSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversionSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConversionSourcesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for the ListConversionSources method.
type ListConversionSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of conversion sources.
	ConversionSources []*ConversionSource `protobuf:"bytes,1,rep,name=conversion_sources,json=conversionSources,proto3" json:"conversion_sources,omitempty"`
	// Token to be used to fetch the next results page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversionSourcesResponse) Reset() {
	*x = ListConversionSourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionSourcesResponse) ProtoMessage() {}

func (x *ListConversionSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListConversionSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{10}
}

func (x *ListConversionSourcesResponse) GetConversionSources() []*ConversionSource {
	if x != nil {
		return x.ConversionSources
	}
	return nil
}

func (x *ListConversionSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message representing a types of conversion events
type AttributionSettings_ConversionType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Conversion event name, as it'll be reported by the client.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Option indicating if the type should be included in Merchant
	// Center reporting.
	Report bool `protobuf:"varint,2,opt,name=report,proto3" json:"report,omitempty"`
}

func (x *AttributionSettings_ConversionType) Reset() {
	*x = AttributionSettings_ConversionType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributionSettings_ConversionType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSettings_ConversionType) ProtoMessage() {}

func (x *AttributionSettings_ConversionType) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSettings_ConversionType.ProtoReflect.Descriptor instead.
func (*AttributionSettings_ConversionType) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP(), []int{1, 0}
}

func (x *AttributionSettings_ConversionType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AttributionSettings_ConversionType) GetReport() bool {
	if x != nil {
		return x.Report
	}
	return false
}

var File_google_shopping_merchant_conversions_v1beta_conversionsources_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x80, 0x07, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x7b, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x48, 0x00, 0x52, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x88, 0x01, 0x0a, 0x1b, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x19, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5e,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x6d, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x22,
	0x45, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x41,
	0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x22, 0x4e, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x4c,
	0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x45, 0x52, 0x43, 0x48, 0x41, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x59, 0x4f, 0x55, 0x54, 0x55, 0x42, 0x45, 0x5f, 0x41, 0x46, 0x46, 0x49, 0x4c, 0x49,
	0x41, 0x54, 0x45, 0x53, 0x10, 0x02, 0x3a, 0x90, 0x01, 0xea, 0x41, 0x8c, 0x01, 0x0a, 0x2b, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x7d, 0x2a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x32, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc0, 0x05, 0x0a, 0x13, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x4c, 0x0a, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6c, 0x6f, 0x6f, 0x6b, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f,
	0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x1d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x6f, 0x6b,
	0x62, 0x61, 0x63, 0x6b, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x44, 0x61, 0x79, 0x73, 0x12, 0x83,
	0x01, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x80, 0x01, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x06, 0xe0, 0x41, 0x06, 0xe0, 0x41, 0x05, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x46, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x22,
	0x89, 0x02, 0x0a, 0x10, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x52, 0x4f, 0x53, 0x53,
	0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x43, 0x4c,
	0x49, 0x43, 0x4b, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x44, 0x53, 0x5f, 0x50, 0x52, 0x45,
	0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x5f, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x43, 0x4c, 0x49, 0x43,
	0x4b, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x44, 0x52, 0x49, 0x56, 0x45, 0x4e,
	0x10, 0x05, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e,
	0x4e, 0x45, 0x4c, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x10,
	0x06, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e,
	0x45, 0x4c, 0x5f, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x10, 0x07, 0x12, 0x20, 0x0a, 0x1c, 0x43,
	0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x44, 0x10, 0x08, 0x12, 0x1c, 0x0a,
	0x18, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x5f, 0x44, 0x45, 0x43, 0x41, 0x59, 0x10, 0x09, 0x22, 0xd9, 0x01, 0x0a, 0x13,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x27, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05,
	0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x49, 0x64, 0x12, 0x78, 0x0a, 0x14,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x13, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x8e, 0x02, 0x0a, 0x19, 0x4d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x14,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x13, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28,
	0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xdd, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x12, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6f, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6f, 0x0a, 0x11, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x68, 0x0a,
	0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6a, 0x0a, 0x1f, 0x55, 0x6e, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x1c, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x26,
	0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0xb5, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6c, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xd2,
	0x0c, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x94, 0x02, 0x0a, 0x16,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x6f, 0xda, 0x41, 0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x39, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0xac, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x86, 0x01, 0xda, 0x41, 0x1d, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x60, 0x3a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x32, 0x4b, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc6, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a,
	0x39, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf6, 0x01, 0x0a, 0x18, 0x55,
	0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x01, 0x2a, 0x22,
	0x42, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x12, 0xe7, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3b, 0x12, 0x39, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfa, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12,
	0x39, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0xdf, 0x01, 0xea, 0x41, 0x38, 0x0a, 0x22, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x7d, 0x0a, 0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x42, 0x16, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x57, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0x3b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescData = file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDesc
)

func file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescData)
	})
	return file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDescData
}

var file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_goTypes = []interface{}{
	(ConversionSource_State)(0),                // 0: google.shopping.merchant.conversions.v1beta.ConversionSource.State
	(ConversionSource_Controller)(0),           // 1: google.shopping.merchant.conversions.v1beta.ConversionSource.Controller
	(AttributionSettings_AttributionModel)(0),  // 2: google.shopping.merchant.conversions.v1beta.AttributionSettings.AttributionModel
	(*ConversionSource)(nil),                   // 3: google.shopping.merchant.conversions.v1beta.ConversionSource
	(*AttributionSettings)(nil),                // 4: google.shopping.merchant.conversions.v1beta.AttributionSettings
	(*GoogleAnalyticsLink)(nil),                // 5: google.shopping.merchant.conversions.v1beta.GoogleAnalyticsLink
	(*MerchantCenterDestination)(nil),          // 6: google.shopping.merchant.conversions.v1beta.MerchantCenterDestination
	(*CreateConversionSourceRequest)(nil),      // 7: google.shopping.merchant.conversions.v1beta.CreateConversionSourceRequest
	(*UpdateConversionSourceRequest)(nil),      // 8: google.shopping.merchant.conversions.v1beta.UpdateConversionSourceRequest
	(*DeleteConversionSourceRequest)(nil),      // 9: google.shopping.merchant.conversions.v1beta.DeleteConversionSourceRequest
	(*UndeleteConversionSourceRequest)(nil),    // 10: google.shopping.merchant.conversions.v1beta.UndeleteConversionSourceRequest
	(*GetConversionSourceRequest)(nil),         // 11: google.shopping.merchant.conversions.v1beta.GetConversionSourceRequest
	(*ListConversionSourcesRequest)(nil),       // 12: google.shopping.merchant.conversions.v1beta.ListConversionSourcesRequest
	(*ListConversionSourcesResponse)(nil),      // 13: google.shopping.merchant.conversions.v1beta.ListConversionSourcesResponse
	(*AttributionSettings_ConversionType)(nil), // 14: google.shopping.merchant.conversions.v1beta.AttributionSettings.ConversionType
	(*timestamppb.Timestamp)(nil),              // 15: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),              // 16: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                      // 17: google.protobuf.Empty
}
var file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_depIdxs = []int32{
	5,  // 0: google.shopping.merchant.conversions.v1beta.ConversionSource.google_analytics_link:type_name -> google.shopping.merchant.conversions.v1beta.GoogleAnalyticsLink
	6,  // 1: google.shopping.merchant.conversions.v1beta.ConversionSource.merchant_center_destination:type_name -> google.shopping.merchant.conversions.v1beta.MerchantCenterDestination
	0,  // 2: google.shopping.merchant.conversions.v1beta.ConversionSource.state:type_name -> google.shopping.merchant.conversions.v1beta.ConversionSource.State
	15, // 3: google.shopping.merchant.conversions.v1beta.ConversionSource.expire_time:type_name -> google.protobuf.Timestamp
	1,  // 4: google.shopping.merchant.conversions.v1beta.ConversionSource.controller:type_name -> google.shopping.merchant.conversions.v1beta.ConversionSource.Controller
	2,  // 5: google.shopping.merchant.conversions.v1beta.AttributionSettings.attribution_model:type_name -> google.shopping.merchant.conversions.v1beta.AttributionSettings.AttributionModel
	14, // 6: google.shopping.merchant.conversions.v1beta.AttributionSettings.conversion_type:type_name -> google.shopping.merchant.conversions.v1beta.AttributionSettings.ConversionType
	4,  // 7: google.shopping.merchant.conversions.v1beta.GoogleAnalyticsLink.attribution_settings:type_name -> google.shopping.merchant.conversions.v1beta.AttributionSettings
	4,  // 8: google.shopping.merchant.conversions.v1beta.MerchantCenterDestination.attribution_settings:type_name -> google.shopping.merchant.conversions.v1beta.AttributionSettings
	3,  // 9: google.shopping.merchant.conversions.v1beta.CreateConversionSourceRequest.conversion_source:type_name -> google.shopping.merchant.conversions.v1beta.ConversionSource
	3,  // 10: google.shopping.merchant.conversions.v1beta.UpdateConversionSourceRequest.conversion_source:type_name -> google.shopping.merchant.conversions.v1beta.ConversionSource
	16, // 11: google.shopping.merchant.conversions.v1beta.UpdateConversionSourceRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 12: google.shopping.merchant.conversions.v1beta.ListConversionSourcesResponse.conversion_sources:type_name -> google.shopping.merchant.conversions.v1beta.ConversionSource
	7,  // 13: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.CreateConversionSource:input_type -> google.shopping.merchant.conversions.v1beta.CreateConversionSourceRequest
	8,  // 14: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.UpdateConversionSource:input_type -> google.shopping.merchant.conversions.v1beta.UpdateConversionSourceRequest
	9,  // 15: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.DeleteConversionSource:input_type -> google.shopping.merchant.conversions.v1beta.DeleteConversionSourceRequest
	10, // 16: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.UndeleteConversionSource:input_type -> google.shopping.merchant.conversions.v1beta.UndeleteConversionSourceRequest
	11, // 17: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.GetConversionSource:input_type -> google.shopping.merchant.conversions.v1beta.GetConversionSourceRequest
	12, // 18: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.ListConversionSources:input_type -> google.shopping.merchant.conversions.v1beta.ListConversionSourcesRequest
	3,  // 19: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.CreateConversionSource:output_type -> google.shopping.merchant.conversions.v1beta.ConversionSource
	3,  // 20: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.UpdateConversionSource:output_type -> google.shopping.merchant.conversions.v1beta.ConversionSource
	17, // 21: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.DeleteConversionSource:output_type -> google.protobuf.Empty
	3,  // 22: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.UndeleteConversionSource:output_type -> google.shopping.merchant.conversions.v1beta.ConversionSource
	3,  // 23: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.GetConversionSource:output_type -> google.shopping.merchant.conversions.v1beta.ConversionSource
	13, // 24: google.shopping.merchant.conversions.v1beta.ConversionSourcesService.ListConversionSources:output_type -> google.shopping.merchant.conversions.v1beta.ListConversionSourcesResponse
	19, // [19:25] is the sub-list for method output_type
	13, // [13:19] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_init() }
func file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_init() {
	if File_google_shopping_merchant_conversions_v1beta_conversionsources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversionSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleAnalyticsLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MerchantCenterDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversionSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConversionSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversionSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeleteConversionSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversionSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionSourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionSourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributionSettings_ConversionType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ConversionSource_GoogleAnalyticsLink)(nil),
		(*ConversionSource_MerchantCenterDestination)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_conversions_v1beta_conversionsources_proto = out.File
	file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_rawDesc = nil
	file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_goTypes = nil
	file_google_shopping_merchant_conversions_v1beta_conversionsources_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConversionSourcesServiceClient is the client API for ConversionSourcesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversionSourcesServiceClient interface {
	// Creates a new conversion source.
	CreateConversionSource(ctx context.Context, in *CreateConversionSourceRequest, opts ...grpc.CallOption) (*ConversionSource, error)
	// Updates information of an existing conversion source. Available only for
	// Merchant Center Destination conversion sources.
	UpdateConversionSource(ctx context.Context, in *UpdateConversionSourceRequest, opts ...grpc.CallOption) (*ConversionSource, error)
	// Archives an existing conversion source. If the conversion source is a
	// Merchant Center Destination, it will be recoverable for 30 days. If the
	// conversion source is a Google Analytics Link, it will be deleted
	// immediately and can be restored by creating a new one.
	DeleteConversionSource(ctx context.Context, in *DeleteConversionSourceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Re-enables an archived conversion source. Only Available for Merchant
	// Center Destination conversion sources.
	UndeleteConversionSource(ctx context.Context, in *UndeleteConversionSourceRequest, opts ...grpc.CallOption) (*ConversionSource, error)
	// Fetches a conversion source.
	GetConversionSource(ctx context.Context, in *GetConversionSourceRequest, opts ...grpc.CallOption) (*ConversionSource, error)
	// Retrieves the list of conversion sources the caller has access to.
	ListConversionSources(ctx context.Context, in *ListConversionSourcesRequest, opts ...grpc.CallOption) (*ListConversionSourcesResponse, error)
}

type conversionSourcesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConversionSourcesServiceClient(cc grpc.ClientConnInterface) ConversionSourcesServiceClient {
	return &conversionSourcesServiceClient{cc}
}

func (c *conversionSourcesServiceClient) CreateConversionSource(ctx context.Context, in *CreateConversionSourceRequest, opts ...grpc.CallOption) (*ConversionSource, error) {
	out := new(ConversionSource)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/CreateConversionSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversionSourcesServiceClient) UpdateConversionSource(ctx context.Context, in *UpdateConversionSourceRequest, opts ...grpc.CallOption) (*ConversionSource, error) {
	out := new(ConversionSource)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/UpdateConversionSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversionSourcesServiceClient) DeleteConversionSource(ctx context.Context, in *DeleteConversionSourceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/DeleteConversionSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversionSourcesServiceClient) UndeleteConversionSource(ctx context.Context, in *UndeleteConversionSourceRequest, opts ...grpc.CallOption) (*ConversionSource, error) {
	out := new(ConversionSource)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/UndeleteConversionSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversionSourcesServiceClient) GetConversionSource(ctx context.Context, in *GetConversionSourceRequest, opts ...grpc.CallOption) (*ConversionSource, error) {
	out := new(ConversionSource)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/GetConversionSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversionSourcesServiceClient) ListConversionSources(ctx context.Context, in *ListConversionSourcesRequest, opts ...grpc.CallOption) (*ListConversionSourcesResponse, error) {
	out := new(ListConversionSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/ListConversionSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversionSourcesServiceServer is the server API for ConversionSourcesService service.
type ConversionSourcesServiceServer interface {
	// Creates a new conversion source.
	CreateConversionSource(context.Context, *CreateConversionSourceRequest) (*ConversionSource, error)
	// Updates information of an existing conversion source. Available only for
	// Merchant Center Destination conversion sources.
	UpdateConversionSource(context.Context, *UpdateConversionSourceRequest) (*ConversionSource, error)
	// Archives an existing conversion source. If the conversion source is a
	// Merchant Center Destination, it will be recoverable for 30 days. If the
	// conversion source is a Google Analytics Link, it will be deleted
	// immediately and can be restored by creating a new one.
	DeleteConversionSource(context.Context, *DeleteConversionSourceRequest) (*emptypb.Empty, error)
	// Re-enables an archived conversion source. Only Available for Merchant
	// Center Destination conversion sources.
	UndeleteConversionSource(context.Context, *UndeleteConversionSourceRequest) (*ConversionSource, error)
	// Fetches a conversion source.
	GetConversionSource(context.Context, *GetConversionSourceRequest) (*ConversionSource, error)
	// Retrieves the list of conversion sources the caller has access to.
	ListConversionSources(context.Context, *ListConversionSourcesRequest) (*ListConversionSourcesResponse, error)
}

// UnimplementedConversionSourcesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConversionSourcesServiceServer struct {
}

func (*UnimplementedConversionSourcesServiceServer) CreateConversionSource(context.Context, *CreateConversionSourceRequest) (*ConversionSource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversionSource not implemented")
}
func (*UnimplementedConversionSourcesServiceServer) UpdateConversionSource(context.Context, *UpdateConversionSourceRequest) (*ConversionSource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversionSource not implemented")
}
func (*UnimplementedConversionSourcesServiceServer) DeleteConversionSource(context.Context, *DeleteConversionSourceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversionSource not implemented")
}
func (*UnimplementedConversionSourcesServiceServer) UndeleteConversionSource(context.Context, *UndeleteConversionSourceRequest) (*ConversionSource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteConversionSource not implemented")
}
func (*UnimplementedConversionSourcesServiceServer) GetConversionSource(context.Context, *GetConversionSourceRequest) (*ConversionSource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversionSource not implemented")
}
func (*UnimplementedConversionSourcesServiceServer) ListConversionSources(context.Context, *ListConversionSourcesRequest) (*ListConversionSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversionSources not implemented")
}

func RegisterConversionSourcesServiceServer(s *grpc.Server, srv ConversionSourcesServiceServer) {
	s.RegisterService(&_ConversionSourcesService_serviceDesc, srv)
}

func _ConversionSourcesService_CreateConversionSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversionSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionSourcesServiceServer).CreateConversionSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/CreateConversionSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionSourcesServiceServer).CreateConversionSource(ctx, req.(*CreateConversionSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversionSourcesService_UpdateConversionSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversionSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionSourcesServiceServer).UpdateConversionSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/UpdateConversionSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionSourcesServiceServer).UpdateConversionSource(ctx, req.(*UpdateConversionSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversionSourcesService_DeleteConversionSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversionSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionSourcesServiceServer).DeleteConversionSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/DeleteConversionSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionSourcesServiceServer).DeleteConversionSource(ctx, req.(*DeleteConversionSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversionSourcesService_UndeleteConversionSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteConversionSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionSourcesServiceServer).UndeleteConversionSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/UndeleteConversionSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionSourcesServiceServer).UndeleteConversionSource(ctx, req.(*UndeleteConversionSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversionSourcesService_GetConversionSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversionSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionSourcesServiceServer).GetConversionSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/GetConversionSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionSourcesServiceServer).GetConversionSource(ctx, req.(*GetConversionSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversionSourcesService_ListConversionSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversionSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionSourcesServiceServer).ListConversionSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.conversions.v1beta.ConversionSourcesService/ListConversionSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionSourcesServiceServer).ListConversionSources(ctx, req.(*ListConversionSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConversionSourcesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.conversions.v1beta.ConversionSourcesService",
	HandlerType: (*ConversionSourcesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversionSource",
			Handler:    _ConversionSourcesService_CreateConversionSource_Handler,
		},
		{
			MethodName: "UpdateConversionSource",
			Handler:    _ConversionSourcesService_UpdateConversionSource_Handler,
		},
		{
			MethodName: "DeleteConversionSource",
			Handler:    _ConversionSourcesService_DeleteConversionSource_Handler,
		},
		{
			MethodName: "UndeleteConversionSource",
			Handler:    _ConversionSourcesService_UndeleteConversionSource_Handler,
		},
		{
			MethodName: "GetConversionSource",
			Handler:    _ConversionSourcesService_GetConversionSource_Handler,
		},
		{
			MethodName: "ListConversionSources",
			Handler:    _ConversionSourcesService_ListConversionSources_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/conversions/v1beta/conversionsources.proto",
}
