# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))

SOURCE_DIR = os.path.dirname(__file__)
LATEX_DIR = os.path.join(SOURCE_DIR, '_latex')
PREAMBLE_FILE = os.path.join(LATEX_DIR, 'preamble.tex')
TITLE_PAGE_FILE = os.path.join(LATEX_DIR, 'title_page.tex')

BUILD_TYPE = os.getenv("BUILD_TYPE")

# -- Project information -----------------------------------------------------


project = u'Intel® Cryptography Primitives Library'
copyright = u'2022, Intel Corporation'
author = u'Intel'

# The short X.Y version
version = u''
# The full version, including alpha/beta/rc tags
release = u'v1.1.0'


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
nbsphinx_allow_errors = True

nbsphinx_execute_arguments = [
    "--InlineBackend.figure_formats={'svg', 'pdf'}",
    "--InlineBackend.rc={'figure.dpi': 150}",
]

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.imgmath',
    'sphinx.ext.ifconfig',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages'
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['main/_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
#master_doc = 'main/title_main'
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build','_themes', '**.ipynb_checkpoints']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# Syntax highlighting for the :: directive
highlight_language = 'cpp'


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#

html_theme = 'sphinx_rtd_theme'

#otc_tcs_sphinx_theme
version = current_version = "latest"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.

# Replace value of 'canonical_url' below with actual location of doc website.
# TODO: Write user-setup section to customize dictionary output below.

html_theme_options = {
  'canonical_url': '',
  'style_nav_header_background': '#007ab2',
  'navigation_depth': 4,
  'collapse_navigation': False,
  'prev_next_buttons_location': 'None',
  'sticky_navigation': True
}

html_copy_source = False


# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = ['_themes']

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = "Documentation for Intel® oneAPI Programming Guide"

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.

html_logo = '_images_pdfly/logo-classicblue-400px.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = '_images_pdfly/favicon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
#html_static_path = ['_static']

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
# html_extra_path = ['_html_extra']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants =

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
html_domain_indices = False

# If false, no index is generated.
html_use_index = True

# If true, the index is split into individual pages for each letter.
html_split_index = True

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink =

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Language to be used for generating the HTML full-text search index.
# Sphinx supports the following languages:
#   'da', 'de', 'en', 'es', 'fi', 'fr', 'hu', 'it', 'ja'
#   'nl', 'no', 'pt', 'ro', 'ru', 'sv', 'tr'
# html_search_language = 'en'

# A dictionary with options for the search language support, empty by default.
# Now only 'ja' uses this config value
#html_search_options = {'type': 'default'}

# The name of a javascript file (relative to the configuration directory) that
# implements a search results scorer. If empty, the default will be used.
# html_search_scorer = 'scorer.js'

# Output file base name for HTML help builder.

#TODO: Add option for html_context in user-setup
# htmlhelp_basename = ''





# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']

# -- sphinx2dita configuration -----------------------------------------------

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'sphinx-infodevdoc'


# -- Options for LaTeX output ------------------------------------------------

#latex_engine = 'xelatex'
#PDF_TITLE = 'Information Development Template'
#
#with open(PREAMBLE_FILE, 'r', encoding='utf-8') as f:
#    PREAMBLE = f.read()
#
#with open(TITLE_PAGE_FILE, 'r', encoding='utf-8') as f:
#    TITLE_PAGE = f.read().replace('<PDF_TITLE>', PDF_TITLE)
#
#
#latex_elements = {
#    # The paper size ('letterpaper' or 'a4paper').
#    #
#    'extraclassoptions': 'openany,oneside',
#    'babel' : '\\usepackage[english]{babel}',
#    'papersize': 'a4paper',
#    'releasename':" ",
#    # Sonny, Lenny, Glenn, Conny, Rejne, Bjarne and Bjornstrup
#    # 'fncychap': '\\usepackage[Lenny]{fncychap}',
#    'fncychap':  '',
#    #'fontpkg': '\\usepackage{amsmath,amsfonts,amssymb,amsthm}',
#
#    'figure_align':'htbp',
#    # The font size ('10pt', '11pt' or '12pt').
#    #
#    'pointsize': '12pt',
#
#    # Additional stuff for the LaTeX preamble.
#    #
#    'preamble': PREAMBLE,
#
#    'maketitle': TITLE_PAGE,
#    # Latex figure (float) alignment
#    #
#    # 'figure_align': 'htbp',
#    'sphinxsetup': \
#        'hmargin={0.7in,0.7in}, vmargin={1in,1in}, \
#        verbatimwithframe=true, \
#        TitleColor={rgb}{0,0.686,0.941}, \
#        HeaderFamily=\\rmfamily\\bfseries, \
#        InnerLinkColor={rgb}{0,0.686,0.941}, \
#        OuterLinkColor={rgb}{0,0.686,0.941}',
#
#    'tableofcontents':' '
#}
#
#latex_logo = '_latex/intel_logo.png'
## Grouping the document tree into LaTeX files. List of tuples
## (source start file, target name, title,
##  author, documentclass [howto, manual, or own class]).
#latex_documents = [
#    (master_doc, 'sphinx-infodev.tex', u'sphinx-infodev Documentation',
#     u'Intel', 'manual'),
#]

#breathe_projects = {                                       #todd-mod
#    project: "../doxygen/xml"
#}
#breathe_default_project = project

# Setup the exhale extension
#exhale_args = {                                            #todd-mod
#    # These arguments are required
#    "containmentFolder":     "./api",
#    "rootFileName":          "library_root.rst",
#    "rootFileTitle":         "Library API",
#    "doxygenStripFromPath":  "..",
#    "fullApiSubSectionTitle": 'Full API'
#}


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'sphinx-infodev', u'sphinx-infodev Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'sphinx-infodev', u'sphinx-infodev Documentation',
     author, 'sphinx-infodev', 'One line description of project.',
     'Miscellaneous'),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
# intersphinx_mapping = {'https://docs.python.org/': None}

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

