.\" $NCDId: @(#)AuSCBFD.man,v 1.1 1994/09/27 00:34:14 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuSCBFD.man 5 1999-05-08 18:47:16Z jon $
.TH AuSoundCreateBucketFromData 3 "1.2" "soundlib"
.SH \fBName\fP
\fBAuSoundCreateBucketFromData\fP \- create a bucket and initialize its contents.
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.br
#include <audio/soundlib.h>
.sp 1
\fBAuBucketID\fP \fBAuSoundCreateBucketFromData\fP(\fIserver\fP, \fIsound\fP, \fIdata\fP, \fIaccess\fP, \fIattributes\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBSound\fP \fIsound\fP;
.br
    \fBAuPointer\fP \fIdata\fP;
.br
    \fBAuUint32\fP \fIaccess\fP;
.br
    \fBAuBucketAttributes\fP **\fIattributes\fP; /* \fBRETURN\fP */
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIsound\fP 1i
Specifies the audio data description.
.IP \fIdata\fP 1i
Specifies the audio data for the bucket.
.IP \fIaccess\fP 1i
Specifies the access restrictions the bucket should have.
.IP \fIattributes\fP 1i
If non-NULL, returns the attributes of the created bucket.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuSoundCreateBucketFromData\fP creates a bucket, initializing the contents with the audio data from \fIdata\fP, and returns the bucket ID or \fBAuNone\fP if there was error.
.SH \fBErrors\fP
\fBAuBadValue\fP,
\fBAuBadLength\fP,
\fBAuBadAlloc\fP.
.SH \fBSee Also\fP
\fBAuSoundCreateBucketFromFile\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
