/* ========================================================================
 * Copyright (c) 2005-2022 The OPC Foundation, Inc. All rights reserved.
 *
 * OPC Foundation MIT License 1.00
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * The complete license agreement can be found here:
 * http://opcfoundation.org/License/MIT/1.00/
 * ======================================================================*/

#ifndef _OpcUa_BrowseNames_H_
#define _OpcUa_BrowseNames_H_ 1

#define OpcUa_BrowseName_A "A"
#define OpcUa_BrowseName_AccessHistoryDataCapability "AccessHistoryDataCapability"
#define OpcUa_BrowseName_AccessHistoryEventsCapability "AccessHistoryEventsCapability"
#define OpcUa_BrowseName_AccessLevelExType "AccessLevelExType"
#define OpcUa_BrowseName_AccessLevelType "AccessLevelType"
#define OpcUa_BrowseName_AccessRestrictionType "AccessRestrictionType"
#define OpcUa_BrowseName_AccumulatedLatency "AccumulatedLatency"
#define OpcUa_BrowseName_AckedState "AckedState"
#define OpcUa_BrowseName_Acknowledge "Acknowledge"
#define OpcUa_BrowseName_AcknowledgeableConditionType "AcknowledgeableConditionType"
#define OpcUa_BrowseName_ActionTimeStamp "ActionTimeStamp"
#define OpcUa_BrowseName_ActivateSessionRequest "ActivateSessionRequest"
#define OpcUa_BrowseName_ActivateSessionResponse "ActivateSessionResponse"
#define OpcUa_BrowseName_Active "Active"
#define OpcUa_BrowseName_ActiveCount "ActiveCount"
#define OpcUa_BrowseName_ActiveState "ActiveState"
#define OpcUa_BrowseName_ActivityTimeout "ActivityTimeout"
#define OpcUa_BrowseName_Actual "Actual"
#define OpcUa_BrowseName_ActualSessionTimeout "ActualSessionTimeout"
#define OpcUa_BrowseName_AddApplication "AddApplication"
#define OpcUa_BrowseName_AddCertificate "AddCertificate"
#define OpcUa_BrowseName_AddComment "AddComment"
#define OpcUa_BrowseName_AddConnection "AddConnection"
#define OpcUa_BrowseName_AddDataSetFolder "AddDataSetFolder"
#define OpcUa_BrowseName_AddDataSetReader "AddDataSetReader"
#define OpcUa_BrowseName_AddDataSetWriter "AddDataSetWriter"
#define OpcUa_BrowseName_AddEndpoint "AddEndpoint"
#define OpcUa_BrowseName_AddExtensionField "AddExtensionField"
#define OpcUa_BrowseName_AddIdentity "AddIdentity"
#define OpcUa_BrowseName_AdditionalGroup_Placeholder "<AdditionalGroup>"
#define OpcUa_BrowseName_AdditionalParametersType "AdditionalParametersType"
#define OpcUa_BrowseName_AddNodesCount "AddNodesCount"
#define OpcUa_BrowseName_AddNodesItem "AddNodesItem"
#define OpcUa_BrowseName_AddNodesRequest "AddNodesRequest"
#define OpcUa_BrowseName_AddNodesResponse "AddNodesResponse"
#define OpcUa_BrowseName_AddNodesResult "AddNodesResult"
#define OpcUa_BrowseName_AddPriorityMappingEntry "AddPriorityMappingEntry"
#define OpcUa_BrowseName_AddPublishedDataItems "AddPublishedDataItems"
#define OpcUa_BrowseName_AddPublishedDataItemsTemplate "AddPublishedDataItemsTemplate"
#define OpcUa_BrowseName_AddPublishedEvents "AddPublishedEvents"
#define OpcUa_BrowseName_AddPublishedEventsTemplate "AddPublishedEventsTemplate"
#define OpcUa_BrowseName_AddPushTarget "AddPushTarget"
#define OpcUa_BrowseName_AddPushTargetFolder "AddPushTargetFolder"
#define OpcUa_BrowseName_AddReaderGroup "AddReaderGroup"
#define OpcUa_BrowseName_AddReferencesCount "AddReferencesCount"
#define OpcUa_BrowseName_AddReferencesItem "AddReferencesItem"
#define OpcUa_BrowseName_AddReferencesRequest "AddReferencesRequest"
#define OpcUa_BrowseName_AddReferencesResponse "AddReferencesResponse"
#define OpcUa_BrowseName_Address "Address"
#define OpcUa_BrowseName_AddressSpaceFileType "AddressSpaceFileType"
#define OpcUa_BrowseName_AddRole "AddRole"
#define OpcUa_BrowseName_AddSecurityGroup "AddSecurityGroup"
#define OpcUa_BrowseName_AddSecurityGroupFolder "AddSecurityGroupFolder"
#define OpcUa_BrowseName_AddSubscribedDataSet "AddSubscribedDataSet"
#define OpcUa_BrowseName_AddTargetVariables "AddTargetVariables"
#define OpcUa_BrowseName_AddUser "AddUser"
#define OpcUa_BrowseName_AddVariables "AddVariables"
#define OpcUa_BrowseName_AddWriterGroup "AddWriterGroup"
#define OpcUa_BrowseName_AdminStatus "AdminStatus"
#define OpcUa_BrowseName_AffectedCertificateGroups "AffectedCertificateGroups"
#define OpcUa_BrowseName_AffectedTrustLists "AffectedTrustLists"
#define OpcUa_BrowseName_AgencyId "AgencyId"
#define OpcUa_BrowseName_AggregateConfiguration "AggregateConfiguration"
#define OpcUa_BrowseName_AggregateConfigurationType "AggregateConfigurationType"
#define OpcUa_BrowseName_AggregateFilter "AggregateFilter"
#define OpcUa_BrowseName_AggregateFilterResult "AggregateFilterResult"
#define OpcUa_BrowseName_AggregateFunction_AnnotationCount "AnnotationCount"
#define OpcUa_BrowseName_AggregateFunction_Average "Average"
#define OpcUa_BrowseName_AggregateFunction_Count "Count"
#define OpcUa_BrowseName_AggregateFunction_Delta "Delta"
#define OpcUa_BrowseName_AggregateFunction_DeltaBounds "DeltaBounds"
#define OpcUa_BrowseName_AggregateFunction_DurationBad "DurationBad"
#define OpcUa_BrowseName_AggregateFunction_DurationGood "DurationGood"
#define OpcUa_BrowseName_AggregateFunction_DurationInStateNonZero "DurationInStateNonZero"
#define OpcUa_BrowseName_AggregateFunction_DurationInStateZero "DurationInStateZero"
#define OpcUa_BrowseName_AggregateFunction_End "End"
#define OpcUa_BrowseName_AggregateFunction_EndBound "EndBound"
#define OpcUa_BrowseName_AggregateFunction_Interpolative "Interpolative"
#define OpcUa_BrowseName_AggregateFunction_Maximum "Maximum"
#define OpcUa_BrowseName_AggregateFunction_Maximum2 "Maximum2"
#define OpcUa_BrowseName_AggregateFunction_MaximumActualTime "MaximumActualTime"
#define OpcUa_BrowseName_AggregateFunction_MaximumActualTime2 "MaximumActualTime2"
#define OpcUa_BrowseName_AggregateFunction_Minimum "Minimum"
#define OpcUa_BrowseName_AggregateFunction_Minimum2 "Minimum2"
#define OpcUa_BrowseName_AggregateFunction_MinimumActualTime "MinimumActualTime"
#define OpcUa_BrowseName_AggregateFunction_MinimumActualTime2 "MinimumActualTime2"
#define OpcUa_BrowseName_AggregateFunction_NumberOfTransitions "NumberOfTransitions"
#define OpcUa_BrowseName_AggregateFunction_PercentBad "PercentBad"
#define OpcUa_BrowseName_AggregateFunction_PercentGood "PercentGood"
#define OpcUa_BrowseName_AggregateFunction_Range "Range"
#define OpcUa_BrowseName_AggregateFunction_Range2 "Range2"
#define OpcUa_BrowseName_AggregateFunction_StandardDeviationPopulation "StandardDeviationPopulation"
#define OpcUa_BrowseName_AggregateFunction_StandardDeviationSample "StandardDeviationSample"
#define OpcUa_BrowseName_AggregateFunction_Start "Start"
#define OpcUa_BrowseName_AggregateFunction_StartBound "StartBound"
#define OpcUa_BrowseName_AggregateFunction_TimeAverage "TimeAverage"
#define OpcUa_BrowseName_AggregateFunction_TimeAverage2 "TimeAverage2"
#define OpcUa_BrowseName_AggregateFunction_Total "Total"
#define OpcUa_BrowseName_AggregateFunction_Total2 "Total2"
#define OpcUa_BrowseName_AggregateFunction_VariancePopulation "VariancePopulation"
#define OpcUa_BrowseName_AggregateFunction_VarianceSample "VarianceSample"
#define OpcUa_BrowseName_AggregateFunction_WorstQuality "WorstQuality"
#define OpcUa_BrowseName_AggregateFunction_WorstQuality2 "WorstQuality2"
#define OpcUa_BrowseName_AggregateFunctions "AggregateFunctions"
#define OpcUa_BrowseName_AggregateFunctionType "AggregateFunctionType"
#define OpcUa_BrowseName_Aggregates "Aggregates"
#define OpcUa_BrowseName_AlarmConditionInstance_Placeholder "<AlarmConditionInstance>"
#define OpcUa_BrowseName_AlarmConditionType "AlarmConditionType"
#define OpcUa_BrowseName_AlarmCount "AlarmCount"
#define OpcUa_BrowseName_AlarmGroup_Placeholder "<AlarmGroup>"
#define OpcUa_BrowseName_AlarmGroupMember "AlarmGroupMember"
#define OpcUa_BrowseName_AlarmGroupType "AlarmGroupType"
#define OpcUa_BrowseName_AlarmMask "AlarmMask"
#define OpcUa_BrowseName_AlarmMetricsType "AlarmMetricsType"
#define OpcUa_BrowseName_AlarmRateVariableType "AlarmRateVariableType"
#define OpcUa_BrowseName_AlarmStateVariableType "AlarmStateVariableType"
#define OpcUa_BrowseName_AlarmSuppressionGroupMember "AlarmSuppressionGroupMember"
#define OpcUa_BrowseName_AlarmSuppressionGroupType "AlarmSuppressionGroupType"
#define OpcUa_BrowseName_Alias_Placeholder "<Alias>"
#define OpcUa_BrowseName_Aliases "Aliases"
#define OpcUa_BrowseName_AliasFor "AliasFor"
#define OpcUa_BrowseName_AliasNameCategoryType "AliasNameCategoryType"
#define OpcUa_BrowseName_AliasNameDataType "AliasNameDataType"
#define OpcUa_BrowseName_AliasNameType "AliasNameType"
#define OpcUa_BrowseName_AllowNulls "AllowNulls"
#define OpcUa_BrowseName_AlwaysGeneratesEvent "AlwaysGeneratesEvent"
#define OpcUa_BrowseName_AnalogItemType "AnalogItemType"
#define OpcUa_BrowseName_AnalogUnitRangeType "AnalogUnitRangeType"
#define OpcUa_BrowseName_AnalogUnitType "AnalogUnitType"
#define OpcUa_BrowseName_AngleUnit "AngleUnit"
#define OpcUa_BrowseName_Annotation "Annotation"
#define OpcUa_BrowseName_Annotations "Annotations"
#define OpcUa_BrowseName_AnonymousIdentityToken "AnonymousIdentityToken"
#define OpcUa_BrowseName_ApplicationCertificateType "ApplicationCertificateType"
#define OpcUa_BrowseName_ApplicationConfigurationType "ApplicationConfigurationType"
#define OpcUa_BrowseName_ApplicationDescription "ApplicationDescription"
#define OpcUa_BrowseName_ApplicationInstanceCertificate "ApplicationInstanceCertificate"
#define OpcUa_BrowseName_ApplicationName_Placeholder "<ApplicationName>"
#define OpcUa_BrowseName_Applications "Applications"
#define OpcUa_BrowseName_ApplicationsExclude "ApplicationsExclude"
#define OpcUa_BrowseName_ApplicationType "ApplicationType"
#define OpcUa_BrowseName_ApplicationUri "ApplicationUri"
#define OpcUa_BrowseName_ApplyChanges "ApplyChanges"
#define OpcUa_BrowseName_ApplyWrite "ApplyWrite"
#define OpcUa_BrowseName_ApplyWriteToError "ApplyWriteToError"
#define OpcUa_BrowseName_ApplyWriteToIdle "ApplyWriteToIdle"
#define OpcUa_BrowseName_Argument "Argument"
#define OpcUa_BrowseName_ArrayItemType "ArrayItemType"
#define OpcUa_BrowseName_AssociatedWith "AssociatedWith"
#define OpcUa_BrowseName_AttributeId "AttributeId"
#define OpcUa_BrowseName_AttributeOperand "AttributeOperand"
#define OpcUa_BrowseName_AttributeWriteMask "AttributeWriteMask"
#define OpcUa_BrowseName_AudibleEnabled "AudibleEnabled"
#define OpcUa_BrowseName_AudibleSound "AudibleSound"
#define OpcUa_BrowseName_AudioDataType "AudioDataType"
#define OpcUa_BrowseName_AudioVariableType "AudioVariableType"
#define OpcUa_BrowseName_AuditActivateSessionEventType "AuditActivateSessionEventType"
#define OpcUa_BrowseName_AuditAddNodesEventType "AuditAddNodesEventType"
#define OpcUa_BrowseName_AuditAddReferencesEventType "AuditAddReferencesEventType"
#define OpcUa_BrowseName_AuditCancelEventType "AuditCancelEventType"
#define OpcUa_BrowseName_AuditCertificateDataMismatchEventType "AuditCertificateDataMismatchEventType"
#define OpcUa_BrowseName_AuditCertificateEventType "AuditCertificateEventType"
#define OpcUa_BrowseName_AuditCertificateExpiredEventType "AuditCertificateExpiredEventType"
#define OpcUa_BrowseName_AuditCertificateInvalidEventType "AuditCertificateInvalidEventType"
#define OpcUa_BrowseName_AuditCertificateMismatchEventType "AuditCertificateMismatchEventType"
#define OpcUa_BrowseName_AuditCertificateRevokedEventType "AuditCertificateRevokedEventType"
#define OpcUa_BrowseName_AuditCertificateUntrustedEventType "AuditCertificateUntrustedEventType"
#define OpcUa_BrowseName_AuditChannelEventType "AuditChannelEventType"
#define OpcUa_BrowseName_AuditClientEventType "AuditClientEventType"
#define OpcUa_BrowseName_AuditClientUpdateMethodResultEventType "AuditClientUpdateMethodResultEventType"
#define OpcUa_BrowseName_AuditConditionAcknowledgeEventType "AuditConditionAcknowledgeEventType"
#define OpcUa_BrowseName_AuditConditionCommentEventType "AuditConditionCommentEventType"
#define OpcUa_BrowseName_AuditConditionConfirmEventType "AuditConditionConfirmEventType"
#define OpcUa_BrowseName_AuditConditionEnableEventType "AuditConditionEnableEventType"
#define OpcUa_BrowseName_AuditConditionEventType "AuditConditionEventType"
#define OpcUa_BrowseName_AuditConditionOutOfServiceEventType "AuditConditionOutOfServiceEventType"
#define OpcUa_BrowseName_AuditConditionResetEventType "AuditConditionResetEventType"
#define OpcUa_BrowseName_AuditConditionRespondEventType "AuditConditionRespondEventType"
#define OpcUa_BrowseName_AuditConditionShelvingEventType "AuditConditionShelvingEventType"
#define OpcUa_BrowseName_AuditConditionSilenceEventType "AuditConditionSilenceEventType"
#define OpcUa_BrowseName_AuditConditionSuppressionEventType "AuditConditionSuppressionEventType"
#define OpcUa_BrowseName_AuditCreateSessionEventType "AuditCreateSessionEventType"
#define OpcUa_BrowseName_AuditDeleteNodesEventType "AuditDeleteNodesEventType"
#define OpcUa_BrowseName_AuditDeleteReferencesEventType "AuditDeleteReferencesEventType"
#define OpcUa_BrowseName_AuditEventType "AuditEventType"
#define OpcUa_BrowseName_AuditHistoryAnnotationUpdateEventType "AuditHistoryAnnotationUpdateEventType"
#define OpcUa_BrowseName_AuditHistoryAtTimeDeleteEventType "AuditHistoryAtTimeDeleteEventType"
#define OpcUa_BrowseName_AuditHistoryDeleteEventType "AuditHistoryDeleteEventType"
#define OpcUa_BrowseName_AuditHistoryEventDeleteEventType "AuditHistoryEventDeleteEventType"
#define OpcUa_BrowseName_AuditHistoryEventUpdateEventType "AuditHistoryEventUpdateEventType"
#define OpcUa_BrowseName_AuditHistoryRawModifyDeleteEventType "AuditHistoryRawModifyDeleteEventType"
#define OpcUa_BrowseName_AuditHistoryUpdateEventType "AuditHistoryUpdateEventType"
#define OpcUa_BrowseName_AuditHistoryValueUpdateEventType "AuditHistoryValueUpdateEventType"
#define OpcUa_BrowseName_Auditing "Auditing"
#define OpcUa_BrowseName_AuditNodeManagementEventType "AuditNodeManagementEventType"
#define OpcUa_BrowseName_AuditOpenSecureChannelEventType "AuditOpenSecureChannelEventType"
#define OpcUa_BrowseName_AuditProgramTransitionEventType "AuditProgramTransitionEventType"
#define OpcUa_BrowseName_AuditSecurityEventType "AuditSecurityEventType"
#define OpcUa_BrowseName_AuditSessionEventType "AuditSessionEventType"
#define OpcUa_BrowseName_AuditUpdateEventType "AuditUpdateEventType"
#define OpcUa_BrowseName_AuditUpdateMethodEventType "AuditUpdateMethodEventType"
#define OpcUa_BrowseName_AuditUpdateStateEventType "AuditUpdateStateEventType"
#define OpcUa_BrowseName_AuditUrlMismatchEventType "AuditUrlMismatchEventType"
#define OpcUa_BrowseName_AuditWriteUpdateEventType "AuditWriteUpdateEventType"
#define OpcUa_BrowseName_AuthenticationMechanism "AuthenticationMechanism"
#define OpcUa_BrowseName_AuthenticationProfileUri "AuthenticationProfileUri"
#define OpcUa_BrowseName_AuthorizationServiceConfigurationType "AuthorizationServiceConfigurationType"
#define OpcUa_BrowseName_AuthorizationServices "AuthorizationServices"
#define OpcUa_BrowseName_AuthorizationServicesConfigurationFolderType "AuthorizationServicesConfigurationFolderType"
#define OpcUa_BrowseName_AutoDelete "AutoDelete"
#define OpcUa_BrowseName_AvailableStates "AvailableStates"
#define OpcUa_BrowseName_AvailableTransitions "AvailableTransitions"
#define OpcUa_BrowseName_AverageAlarmRate "AverageAlarmRate"
#define OpcUa_BrowseName_AxisDefinition "AxisDefinition"
#define OpcUa_BrowseName_AxisInformation "AxisInformation"
#define OpcUa_BrowseName_AxisScaleEnumeration "AxisScaleEnumeration"
#define OpcUa_BrowseName_AxisScaleType "AxisScaleType"
#define OpcUa_BrowseName_B "B"
#define OpcUa_BrowseName_BaseAnalogType "BaseAnalogType"
#define OpcUa_BrowseName_BaseConditionClassType "BaseConditionClassType"
#define OpcUa_BrowseName_BaseDataType "BaseDataType"
#define OpcUa_BrowseName_BaseDataVariableType "BaseDataVariableType"
#define OpcUa_BrowseName_BaseEventType "BaseEventType"
#define OpcUa_BrowseName_BaseFrame "BaseFrame"
#define OpcUa_BrowseName_BaseHighHighLimit "BaseHighHighLimit"
#define OpcUa_BrowseName_BaseHighLimit "BaseHighLimit"
#define OpcUa_BrowseName_BaseInterfaceType "BaseInterfaceType"
#define OpcUa_BrowseName_BaseLowLimit "BaseLowLimit"
#define OpcUa_BrowseName_BaseLowLowLimit "BaseLowLowLimit"
#define OpcUa_BrowseName_BaseModelChangeEventType "BaseModelChangeEventType"
#define OpcUa_BrowseName_BaseObjectType "BaseObjectType"
#define OpcUa_BrowseName_BaseSetpointNode "BaseSetpointNode"
#define OpcUa_BrowseName_BaseVariableType "BaseVariableType"
#define OpcUa_BrowseName_BitFieldMaskDataType "BitFieldMaskDataType"
#define OpcUa_BrowseName_BitMask "BitMask"
#define OpcUa_BrowseName_Boolean "Boolean"
#define OpcUa_BrowseName_BranchId "BranchId"
#define OpcUa_BrowseName_BrokerConnectionTransportDataType "BrokerConnectionTransportDataType"
#define OpcUa_BrowseName_BrokerConnectionTransportType "BrokerConnectionTransportType"
#define OpcUa_BrowseName_BrokerDataSetReaderTransportDataType "BrokerDataSetReaderTransportDataType"
#define OpcUa_BrowseName_BrokerDataSetReaderTransportType "BrokerDataSetReaderTransportType"
#define OpcUa_BrowseName_BrokerDataSetWriterTransportDataType "BrokerDataSetWriterTransportDataType"
#define OpcUa_BrowseName_BrokerDataSetWriterTransportType "BrokerDataSetWriterTransportType"
#define OpcUa_BrowseName_BrokerTransportQualityOfService "BrokerTransportQualityOfService"
#define OpcUa_BrowseName_BrokerWriterGroupTransportDataType "BrokerWriterGroupTransportDataType"
#define OpcUa_BrowseName_BrokerWriterGroupTransportType "BrokerWriterGroupTransportType"
#define OpcUa_BrowseName_BrowseCount "BrowseCount"
#define OpcUa_BrowseName_BrowseDescription "BrowseDescription"
#define OpcUa_BrowseName_BrowseDirection "BrowseDirection"
#define OpcUa_BrowseName_BrowseNextCount "BrowseNextCount"
#define OpcUa_BrowseName_BrowseNextRequest "BrowseNextRequest"
#define OpcUa_BrowseName_BrowseNextResponse "BrowseNextResponse"
#define OpcUa_BrowseName_BrowsePath "BrowsePath"
#define OpcUa_BrowseName_BrowsePathResult "BrowsePathResult"
#define OpcUa_BrowseName_BrowsePathTarget "BrowsePathTarget"
#define OpcUa_BrowseName_BrowseRequest "BrowseRequest"
#define OpcUa_BrowseName_BrowseResponse "BrowseResponse"
#define OpcUa_BrowseName_BrowseResult "BrowseResult"
#define OpcUa_BrowseName_BrowseResultMask "BrowseResultMask"
#define OpcUa_BrowseName_BuildDate "BuildDate"
#define OpcUa_BrowseName_BuildInfo "BuildInfo"
#define OpcUa_BrowseName_BuildInfoType "BuildInfoType"
#define OpcUa_BrowseName_BuildNumber "BuildNumber"
#define OpcUa_BrowseName_Byte "Byte"
#define OpcUa_BrowseName_ByteString "ByteString"
#define OpcUa_BrowseName_C "C"
#define OpcUa_BrowseName_CallCount "CallCount"
#define OpcUa_BrowseName_CallMethodRequest "CallMethodRequest"
#define OpcUa_BrowseName_CallMethodResult "CallMethodResult"
#define OpcUa_BrowseName_CallRequest "CallRequest"
#define OpcUa_BrowseName_CallResponse "CallResponse"
#define OpcUa_BrowseName_CancelChanges "CancelChanges"
#define OpcUa_BrowseName_CancelRequest "CancelRequest"
#define OpcUa_BrowseName_CancelResponse "CancelResponse"
#define OpcUa_BrowseName_CartesianCoordinates "CartesianCoordinates"
#define OpcUa_BrowseName_CartesianCoordinatesType "CartesianCoordinatesType"
#define OpcUa_BrowseName_Certificate "Certificate"
#define OpcUa_BrowseName_CertificateErrorEventId "CertificateErrorEventId"
#define OpcUa_BrowseName_CertificateExpirationAlarmType "CertificateExpirationAlarmType"
#define OpcUa_BrowseName_CertificateExpired "CertificateExpired"
#define OpcUa_BrowseName_CertificateGroup "CertificateGroup"
#define OpcUa_BrowseName_CertificateGroupFolderType "CertificateGroupFolderType"
#define OpcUa_BrowseName_CertificateGroups "CertificateGroups"
#define OpcUa_BrowseName_CertificateGroupType "CertificateGroupType"
#define OpcUa_BrowseName_CertificateType "CertificateType"
#define OpcUa_BrowseName_CertificateTypes "CertificateTypes"
#define OpcUa_BrowseName_CertificateUpdatedAuditEventType "CertificateUpdatedAuditEventType"
#define OpcUa_BrowseName_CertificateUpdateRequestedAuditEventType "CertificateUpdateRequestedAuditEventType"
#define OpcUa_BrowseName_ChangePassword "ChangePassword"
#define OpcUa_BrowseName_Changes "Changes"
#define OpcUa_BrowseName_ChannelSecurityToken "ChannelSecurityToken"
#define OpcUa_BrowseName_ChoiceStateType "ChoiceStateType"
#define OpcUa_BrowseName_Classification "Classification"
#define OpcUa_BrowseName_ClientAuditEntryId "ClientAuditEntryId"
#define OpcUa_BrowseName_ClientCertificate "ClientCertificate"
#define OpcUa_BrowseName_ClientCertificateThumbprint "ClientCertificateThumbprint"
#define OpcUa_BrowseName_ClientConnectionTime "ClientConnectionTime"
#define OpcUa_BrowseName_ClientDescription "ClientDescription"
#define OpcUa_BrowseName_ClientLastContactTime "ClientLastContactTime"
#define OpcUa_BrowseName_ClientName_Placeholder "<ClientName>"
#define OpcUa_BrowseName_ClientProcessingTimeout "ClientProcessingTimeout"
#define OpcUa_BrowseName_ClientSoftwareCertificates "ClientSoftwareCertificates"
#define OpcUa_BrowseName_ClientUserId "ClientUserId"
#define OpcUa_BrowseName_ClientUserIdHistory "ClientUserIdHistory"
#define OpcUa_BrowseName_ClientUserIdOfSession "ClientUserIdOfSession"
#define OpcUa_BrowseName_Close "Close"
#define OpcUa_BrowseName_CloseAndCommit "CloseAndCommit"
#define OpcUa_BrowseName_CloseAndUpdate "CloseAndUpdate"
#define OpcUa_BrowseName_CloseSecureChannelRequest "CloseSecureChannelRequest"
#define OpcUa_BrowseName_CloseSecureChannelResponse "CloseSecureChannelResponse"
#define OpcUa_BrowseName_CloseSessionRequest "CloseSessionRequest"
#define OpcUa_BrowseName_CloseSessionResponse "CloseSessionResponse"
#define OpcUa_BrowseName_Comment "Comment"
#define OpcUa_BrowseName_Communication "Communication"
#define OpcUa_BrowseName_ComplexNumberType "ComplexNumberType"
#define OpcUa_BrowseName_ConditionClassId "ConditionClassId"
#define OpcUa_BrowseName_ConditionClassName "ConditionClassName"
#define OpcUa_BrowseName_ConditionEventId "ConditionEventId"
#define OpcUa_BrowseName_ConditionName "ConditionName"
#define OpcUa_BrowseName_ConditionRefresh "ConditionRefresh"
#define OpcUa_BrowseName_ConditionRefresh2 "ConditionRefresh2"
#define OpcUa_BrowseName_ConditionSubClassId "ConditionSubClassId"
#define OpcUa_BrowseName_ConditionSubClassName "ConditionSubClassName"
#define OpcUa_BrowseName_ConditionType "ConditionType"
#define OpcUa_BrowseName_ConditionVariableType "ConditionVariableType"
#define OpcUa_BrowseName_ConfigurationProperties "ConfigurationProperties"
#define OpcUa_BrowseName_ConfigurationVersion "ConfigurationVersion"
#define OpcUa_BrowseName_ConfigurationVersionDataType "ConfigurationVersionDataType"
#define OpcUa_BrowseName_ConfiguredSize "ConfiguredSize"
#define OpcUa_BrowseName_Confirm "Confirm"
#define OpcUa_BrowseName_ConfirmedState "ConfirmedState"
#define OpcUa_BrowseName_ConformanceUnits "ConformanceUnits"
#define OpcUa_BrowseName_ConnectionId "ConnectionId"
#define OpcUa_BrowseName_ConnectionName_Placeholder "<ConnectionName>"
#define OpcUa_BrowseName_ConnectionProperties "ConnectionProperties"
#define OpcUa_BrowseName_ConnectionTransportDataType "ConnectionTransportDataType"
#define OpcUa_BrowseName_ConnectionTransportType "ConnectionTransportType"
#define OpcUa_BrowseName_ConnectSecurityGroups "ConnectSecurityGroups"
#define OpcUa_BrowseName_Constant "Constant"
#define OpcUa_BrowseName_ContentFilter "ContentFilter"
#define OpcUa_BrowseName_ContentFilterElement "ContentFilterElement"
#define OpcUa_BrowseName_ContentFilterElementResult "ContentFilterElementResult"
#define OpcUa_BrowseName_ContentFilterResult "ContentFilterResult"
#define OpcUa_BrowseName_Context "Context"
#define OpcUa_BrowseName_ContinuationPoint "ContinuationPoint"
#define OpcUa_BrowseName_Controls "Controls"
#define OpcUa_BrowseName_Counter "Counter"
#define OpcUa_BrowseName_Counters "Counters"
#define OpcUa_BrowseName_Creatable "Creatable"
#define OpcUa_BrowseName_CreateClientName "CreateClientName"
#define OpcUa_BrowseName_CreateCredential "CreateCredential"
#define OpcUa_BrowseName_CreateDataSetMirror "CreateDataSetMirror"
#define OpcUa_BrowseName_CreateDirectory "CreateDirectory"
#define OpcUa_BrowseName_CreateFile "CreateFile"
#define OpcUa_BrowseName_CreateMonitoredItemsCount "CreateMonitoredItemsCount"
#define OpcUa_BrowseName_CreateMonitoredItemsRequest "CreateMonitoredItemsRequest"
#define OpcUa_BrowseName_CreateMonitoredItemsResponse "CreateMonitoredItemsResponse"
#define OpcUa_BrowseName_CreateSessionId "CreateSessionId"
#define OpcUa_BrowseName_CreateSessionRequest "CreateSessionRequest"
#define OpcUa_BrowseName_CreateSessionResponse "CreateSessionResponse"
#define OpcUa_BrowseName_CreateSigningRequest "CreateSigningRequest"
#define OpcUa_BrowseName_CreateSubscriptionCount "CreateSubscriptionCount"
#define OpcUa_BrowseName_CreateSubscriptionRequest "CreateSubscriptionRequest"
#define OpcUa_BrowseName_CreateSubscriptionResponse "CreateSubscriptionResponse"
#define OpcUa_BrowseName_CreateTargetVariables "CreateTargetVariables"
#define OpcUa_BrowseName_CubeItemType "CubeItemType"
#define OpcUa_BrowseName_CumulatedSessionCount "CumulatedSessionCount"
#define OpcUa_BrowseName_CumulatedSubscriptionCount "CumulatedSubscriptionCount"
#define OpcUa_BrowseName_CurrencyUnit "CurrencyUnit"
#define OpcUa_BrowseName_CurrencyUnitType "CurrencyUnitType"
#define OpcUa_BrowseName_CurrentAlarmRate "CurrentAlarmRate"
#define OpcUa_BrowseName_CurrentKeepAliveCount "CurrentKeepAliveCount"
#define OpcUa_BrowseName_CurrentLifetimeCount "CurrentLifetimeCount"
#define OpcUa_BrowseName_CurrentMonitoredItemsCount "CurrentMonitoredItemsCount"
#define OpcUa_BrowseName_CurrentPublishRequestsInQueue "CurrentPublishRequestsInQueue"
#define OpcUa_BrowseName_CurrentServerId "CurrentServerId"
#define OpcUa_BrowseName_CurrentSessionCount "CurrentSessionCount"
#define OpcUa_BrowseName_CurrentState "CurrentState"
#define OpcUa_BrowseName_CurrentSubscriptionCount "CurrentSubscriptionCount"
#define OpcUa_BrowseName_CurrentSubscriptionsCount "CurrentSubscriptionsCount"
#define OpcUa_BrowseName_CurrentTime "CurrentTime"
#define OpcUa_BrowseName_CustomConfiguration "CustomConfiguration"
#define OpcUa_BrowseName_CyclicDataSet "CyclicDataSet"
#define OpcUa_BrowseName_DataChangeFilter "DataChangeFilter"
#define OpcUa_BrowseName_DataChangeNotification "DataChangeNotification"
#define OpcUa_BrowseName_DataChangeNotificationsCount "DataChangeNotificationsCount"
#define OpcUa_BrowseName_DataChangeTrigger "DataChangeTrigger"
#define OpcUa_BrowseName_DatagramConnectionTransport2DataType "DatagramConnectionTransport2DataType"
#define OpcUa_BrowseName_DatagramConnectionTransportDataType "DatagramConnectionTransportDataType"
#define OpcUa_BrowseName_DatagramConnectionTransportType "DatagramConnectionTransportType"
#define OpcUa_BrowseName_DatagramDataSetReaderTransportDataType "DatagramDataSetReaderTransportDataType"
#define OpcUa_BrowseName_DatagramDataSetReaderTransportType "DatagramDataSetReaderTransportType"
#define OpcUa_BrowseName_DatagramQos "DatagramQos"
#define OpcUa_BrowseName_DatagramWriterGroupTransport2DataType "DatagramWriterGroupTransport2DataType"
#define OpcUa_BrowseName_DatagramWriterGroupTransportDataType "DatagramWriterGroupTransportDataType"
#define OpcUa_BrowseName_DatagramWriterGroupTransportType "DatagramWriterGroupTransportType"
#define OpcUa_BrowseName_DataItemType "DataItemType"
#define OpcUa_BrowseName_DataSetClasses "DataSetClasses"
#define OpcUa_BrowseName_DataSetClassId "DataSetClassId"
#define OpcUa_BrowseName_DataSetFieldContentMask "DataSetFieldContentMask"
#define OpcUa_BrowseName_DataSetFieldFlags "DataSetFieldFlags"
#define OpcUa_BrowseName_DataSetFolderName_Placeholder "<DataSetFolderName>"
#define OpcUa_BrowseName_DataSetFolderType "DataSetFolderType"
#define OpcUa_BrowseName_DataSetMessageContentMask "DataSetMessageContentMask"
#define OpcUa_BrowseName_DataSetMetaData "DataSetMetaData"
#define OpcUa_BrowseName_DataSetMetaDataType "DataSetMetaDataType"
#define OpcUa_BrowseName_DataSetOffset "DataSetOffset"
#define OpcUa_BrowseName_DataSetOrdering "DataSetOrdering"
#define OpcUa_BrowseName_DataSetOrderingType "DataSetOrderingType"
#define OpcUa_BrowseName_DataSetReaderDataType "DataSetReaderDataType"
#define OpcUa_BrowseName_DataSetReaderMessageDataType "DataSetReaderMessageDataType"
#define OpcUa_BrowseName_DataSetReaderMessageType "DataSetReaderMessageType"
#define OpcUa_BrowseName_DataSetReaderName_Placeholder "<DataSetReaderName>"
#define OpcUa_BrowseName_DataSetReaderProperties "DataSetReaderProperties"
#define OpcUa_BrowseName_DataSetReaderTransportDataType "DataSetReaderTransportDataType"
#define OpcUa_BrowseName_DataSetReaderTransportType "DataSetReaderTransportType"
#define OpcUa_BrowseName_DataSetReaderType "DataSetReaderType"
#define OpcUa_BrowseName_DataSetToWriter "DataSetToWriter"
#define OpcUa_BrowseName_DataSetWriterDataType "DataSetWriterDataType"
#define OpcUa_BrowseName_DataSetWriterId "DataSetWriterId"
#define OpcUa_BrowseName_DataSetWriterMessageDataType "DataSetWriterMessageDataType"
#define OpcUa_BrowseName_DataSetWriterMessageType "DataSetWriterMessageType"
#define OpcUa_BrowseName_DataSetWriterName_Placeholder "<DataSetWriterName>"
#define OpcUa_BrowseName_DataSetWriterProperties "DataSetWriterProperties"
#define OpcUa_BrowseName_DataSetWriterTransportDataType "DataSetWriterTransportDataType"
#define OpcUa_BrowseName_DataSetWriterTransportType "DataSetWriterTransportType"
#define OpcUa_BrowseName_DataSetWriterType "DataSetWriterType"
#define OpcUa_BrowseName_DataTypeAttributes "DataTypeAttributes"
#define OpcUa_BrowseName_DataTypeDefinition "DataTypeDefinition"
#define OpcUa_BrowseName_DataTypeDescription "DataTypeDescription"
#define OpcUa_BrowseName_DataTypeDescriptionType "DataTypeDescriptionType"
#define OpcUa_BrowseName_DataTypeDictionaryType "DataTypeDictionaryType"
#define OpcUa_BrowseName_DataTypeEncodingType "DataTypeEncodingType"
#define OpcUa_BrowseName_DataTypeNode "DataTypeNode"
#define OpcUa_BrowseName_DataTypeSchemaHeader "DataTypeSchemaHeader"
#define OpcUa_BrowseName_DataTypesFolder "DataTypes"
#define OpcUa_BrowseName_DataTypeSystemType "DataTypeSystemType"
#define OpcUa_BrowseName_DataTypeVersion "DataTypeVersion"
#define OpcUa_BrowseName_DataValue "DataValue"
#define OpcUa_BrowseName_DateString "DateString"
#define OpcUa_BrowseName_DateTime "DateTime"
#define OpcUa_BrowseName_DeadbandType "DeadbandType"
#define OpcUa_BrowseName_Decimal "Decimal"
#define OpcUa_BrowseName_DecimalDataType "DecimalDataType"
#define OpcUa_BrowseName_DecimalString "DecimalString"
#define OpcUa_BrowseName_DefaultAccessRestrictions "DefaultAccessRestrictions"
#define OpcUa_BrowseName_DefaultApplicationGroup "DefaultApplicationGroup"
#define OpcUa_BrowseName_DefaultBinary "Default Binary"
#define OpcUa_BrowseName_DefaultDatagramPublisherId "DefaultDatagramPublisherId"
#define OpcUa_BrowseName_DefaultHttpsGroup "DefaultHttpsGroup"
#define OpcUa_BrowseName_DefaultInstanceBrowseName "DefaultInstanceBrowseName"
#define OpcUa_BrowseName_DefaultJson "Default JSON"
#define OpcUa_BrowseName_DefaultResponse "DefaultResponse"
#define OpcUa_BrowseName_DefaultRolePermissions "DefaultRolePermissions"
#define OpcUa_BrowseName_DefaultSecurityKeyServices "DefaultSecurityKeyServices"
#define OpcUa_BrowseName_DefaultUserRolePermissions "DefaultUserRolePermissions"
#define OpcUa_BrowseName_DefaultUserTokenGroup "DefaultUserTokenGroup"
#define OpcUa_BrowseName_DefaultValidationOptions "DefaultValidationOptions"
#define OpcUa_BrowseName_DefaultXml "Default XML"
#define OpcUa_BrowseName_Definition "Definition"
#define OpcUa_BrowseName_Deletable "Deletable"
#define OpcUa_BrowseName_DeleteAtTimeCapability "DeleteAtTimeCapability"
#define OpcUa_BrowseName_DeleteAtTimeDetails "DeleteAtTimeDetails"
#define OpcUa_BrowseName_DeleteCredential "DeleteCredential"
#define OpcUa_BrowseName_DeleteEventCapability "DeleteEventCapability"
#define OpcUa_BrowseName_DeleteEventDetails "DeleteEventDetails"
#define OpcUa_BrowseName_DeleteFileSystemObject "Delete"
#define OpcUa_BrowseName_DeleteMonitoredItemsCount "DeleteMonitoredItemsCount"
#define OpcUa_BrowseName_DeleteMonitoredItemsRequest "DeleteMonitoredItemsRequest"
#define OpcUa_BrowseName_DeleteMonitoredItemsResponse "DeleteMonitoredItemsResponse"
#define OpcUa_BrowseName_DeleteNodesCount "DeleteNodesCount"
#define OpcUa_BrowseName_DeleteNodesItem "DeleteNodesItem"
#define OpcUa_BrowseName_DeleteNodesRequest "DeleteNodesRequest"
#define OpcUa_BrowseName_DeleteNodesResponse "DeleteNodesResponse"
#define OpcUa_BrowseName_DeletePriorityMappingEntry "DeletePriorityMappingEntry"
#define OpcUa_BrowseName_DeleteRawCapability "DeleteRawCapability"
#define OpcUa_BrowseName_DeleteRawModifiedDetails "DeleteRawModifiedDetails"
#define OpcUa_BrowseName_DeleteReferencesCount "DeleteReferencesCount"
#define OpcUa_BrowseName_DeleteReferencesItem "DeleteReferencesItem"
#define OpcUa_BrowseName_DeleteReferencesRequest "DeleteReferencesRequest"
#define OpcUa_BrowseName_DeleteReferencesResponse "DeleteReferencesResponse"
#define OpcUa_BrowseName_DeleteSubscriptionsCount "DeleteSubscriptionsCount"
#define OpcUa_BrowseName_DeleteSubscriptionsRequest "DeleteSubscriptionsRequest"
#define OpcUa_BrowseName_DeleteSubscriptionsResponse "DeleteSubscriptionsResponse"
#define OpcUa_BrowseName_Denominator "Denominator"
#define OpcUa_BrowseName_Deprecated "Deprecated"
#define OpcUa_BrowseName_DestinationAddress "DestinationAddress"
#define OpcUa_BrowseName_DeviceFailureEventType "DeviceFailureEventType"
#define OpcUa_BrowseName_DiagnosticInfo "DiagnosticInfo"
#define OpcUa_BrowseName_Diagnostics "Diagnostics"
#define OpcUa_BrowseName_DiagnosticsLevel "DiagnosticsLevel"
#define OpcUa_BrowseName_DialogConditionType "DialogConditionType"
#define OpcUa_BrowseName_DialogState "DialogState"
#define OpcUa_BrowseName_Dictionaries "Dictionaries"
#define OpcUa_BrowseName_DictionaryEntryName_Placeholder "<DictionaryEntryName>"
#define OpcUa_BrowseName_DictionaryEntryType "DictionaryEntryType"
#define OpcUa_BrowseName_DictionaryFolderName_Placeholder "<DictionaryFolderName>"
#define OpcUa_BrowseName_DictionaryFolderType "DictionaryFolderType"
#define OpcUa_BrowseName_DictionaryFragment "DictionaryFragment"
#define OpcUa_BrowseName_DigitalVariable_Placeholder "<DigitalVariable>"
#define OpcUa_BrowseName_Disable "Disable"
#define OpcUa_BrowseName_DisableCount "DisableCount"
#define OpcUa_BrowseName_DisabledMonitoredItemCount "DisabledMonitoredItemCount"
#define OpcUa_BrowseName_DisabledMonitoredItemsSamplingCount "DisabledMonitoredItemsSamplingCount"
#define OpcUa_BrowseName_DiscardedMessageCount "DiscardedMessageCount"
#define OpcUa_BrowseName_DisconnectSecurityGroups "DisconnectSecurityGroups"
#define OpcUa_BrowseName_DiscoveryAddress "DiscoveryAddress"
#define OpcUa_BrowseName_DiscoveryAnnounceRate "DiscoveryAnnounceRate"
#define OpcUa_BrowseName_DiscoveryConfiguration "DiscoveryConfiguration"
#define OpcUa_BrowseName_DiscoveryMaxMessageSize "DiscoveryMaxMessageSize"
#define OpcUa_BrowseName_DiscrepancyAlarmType "DiscrepancyAlarmType"
#define OpcUa_BrowseName_DiscreteAlarmType "DiscreteAlarmType"
#define OpcUa_BrowseName_DiscreteItemType "DiscreteItemType"
#define OpcUa_BrowseName_Double "Double"
#define OpcUa_BrowseName_DoubleComplexNumberType "DoubleComplexNumberType"
#define OpcUa_BrowseName_Duplex "Duplex"
#define OpcUa_BrowseName_Duration "Duration"
#define OpcUa_BrowseName_DurationString "DurationString"
#define OpcUa_BrowseName_EccApplicationCertificateType "EccApplicationCertificateType"
#define OpcUa_BrowseName_EccBrainpoolP256r1ApplicationCertificateType "EccBrainpoolP256r1ApplicationCertificateType"
#define OpcUa_BrowseName_EccBrainpoolP384r1ApplicationCertificateType "EccBrainpoolP384r1ApplicationCertificateType"
#define OpcUa_BrowseName_EccCurve25519ApplicationCertificateType "EccCurve25519ApplicationCertificateType"
#define OpcUa_BrowseName_EccCurve448ApplicationCertificateType "EccCurve448ApplicationCertificateType"
#define OpcUa_BrowseName_EccEncryptedSecret "EccEncryptedSecret"
#define OpcUa_BrowseName_EccNistP256ApplicationCertificateType "EccNistP256ApplicationCertificateType"
#define OpcUa_BrowseName_EccNistP384ApplicationCertificateType "EccNistP384ApplicationCertificateType"
#define OpcUa_BrowseName_EffectiveDisplayName "EffectiveDisplayName"
#define OpcUa_BrowseName_EffectiveTransitionTime "EffectiveTransitionTime"
#define OpcUa_BrowseName_ElementOperand "ElementOperand"
#define OpcUa_BrowseName_ElseGuardVariableType "ElseGuardVariableType"
#define OpcUa_BrowseName_Enable "Enable"
#define OpcUa_BrowseName_EnableCount "EnableCount"
#define OpcUa_BrowseName_Enabled "Enabled"
#define OpcUa_BrowseName_EnabledFlag "EnabledFlag"
#define OpcUa_BrowseName_EnabledState "EnabledState"
#define OpcUa_BrowseName_EncodedTicket "EncodedTicket"
#define OpcUa_BrowseName_Encoding "Encoding"
#define OpcUa_BrowseName_EndpointConfiguration "EndpointConfiguration"
#define OpcUa_BrowseName_EndpointDescription "EndpointDescription"
#define OpcUa_BrowseName_Endpoints "Endpoints"
#define OpcUa_BrowseName_EndpointsExclude "EndpointsExclude"
#define OpcUa_BrowseName_EndpointType "EndpointType"
#define OpcUa_BrowseName_EndpointUrl "EndpointUrl"
#define OpcUa_BrowseName_EndpointUrlListDataType "EndpointUrlListDataType"
#define OpcUa_BrowseName_EndpointUrls "EndpointUrls"
#define OpcUa_BrowseName_EndTime "EndTime"
#define OpcUa_BrowseName_EngineeringUnits "EngineeringUnits"
#define OpcUa_BrowseName_EnumDefinition "EnumDefinition"
#define OpcUa_BrowseName_EnumDescription "EnumDescription"
#define OpcUa_BrowseName_EnumDictionaryEntries "EnumDictionaryEntries"
#define OpcUa_BrowseName_Enumeration "Enumeration"
#define OpcUa_BrowseName_EnumField "EnumField"
#define OpcUa_BrowseName_EnumStrings "EnumStrings"
#define OpcUa_BrowseName_EnumValues "EnumValues"
#define OpcUa_BrowseName_EnumValueType "EnumValueType"
#define OpcUa_BrowseName_EphemeralKeyType "EphemeralKeyType"
#define OpcUa_BrowseName_Error "Error"
#define OpcUa_BrowseName_Errors "Errors"
#define OpcUa_BrowseName_ErrorToIdle "ErrorToIdle"
#define OpcUa_BrowseName_EstimatedReturnTime "EstimatedReturnTime"
#define OpcUa_BrowseName_EUInformation "EUInformation"
#define OpcUa_BrowseName_EURange "EURange"
#define OpcUa_BrowseName_EventFieldList "EventFieldList"
#define OpcUa_BrowseName_EventFilter "EventFilter"
#define OpcUa_BrowseName_EventFilterResult "EventFilterResult"
#define OpcUa_BrowseName_EventId "EventId"
#define OpcUa_BrowseName_EventIds "EventIds"
#define OpcUa_BrowseName_EventNotificationList "EventNotificationList"
#define OpcUa_BrowseName_EventNotificationsCount "EventNotificationsCount"
#define OpcUa_BrowseName_EventNotifierType "EventNotifierType"
#define OpcUa_BrowseName_EventQueueOverflowCount "EventQueueOverflowCount"
#define OpcUa_BrowseName_EventQueueOverflowEventType "EventQueueOverflowEventType"
#define OpcUa_BrowseName_EventType "EventType"
#define OpcUa_BrowseName_EventTypesFolder "EventTypes"
#define OpcUa_BrowseName_ExceptionDeviation "ExceptionDeviation"
#define OpcUa_BrowseName_ExceptionDeviationFormat "ExceptionDeviationFormat"
#define OpcUa_BrowseName_ExclusiveDeviationAlarmType "ExclusiveDeviationAlarmType"
#define OpcUa_BrowseName_ExclusiveLevelAlarmType "ExclusiveLevelAlarmType"
#define OpcUa_BrowseName_ExclusiveLimitAlarmType "ExclusiveLimitAlarmType"
#define OpcUa_BrowseName_ExclusiveLimitStateMachineType "ExclusiveLimitStateMachineType"
#define OpcUa_BrowseName_ExclusiveRateOfChangeAlarmType "ExclusiveRateOfChangeAlarmType"
#define OpcUa_BrowseName_ExpandedNodeId "ExpandedNodeId"
#define OpcUa_BrowseName_ExpectedTime "ExpectedTime"
#define OpcUa_BrowseName_ExpirationDate "ExpirationDate"
#define OpcUa_BrowseName_ExpirationLimit "ExpirationLimit"
#define OpcUa_BrowseName_ExportNamespace "ExportNamespace"
#define OpcUa_BrowseName_Expression "Expression"
#define OpcUa_BrowseName_ExpressionGuardVariableType "ExpressionGuardVariableType"
#define OpcUa_BrowseName_ExtensionFieldName_Placeholder "<ExtensionFieldName>"
#define OpcUa_BrowseName_ExtensionFields "ExtensionFields"
#define OpcUa_BrowseName_ExtensionFieldsType "ExtensionFieldsType"
#define OpcUa_BrowseName_FailureCode "FailureCode"
#define OpcUa_BrowseName_FailureSystemIdentifier "FailureSystemIdentifier"
#define OpcUa_BrowseName_FalseState "FalseState"
#define OpcUa_BrowseName_FieldMetaData "FieldMetaData"
#define OpcUa_BrowseName_FieldTargetDataType "FieldTargetDataType"
#define OpcUa_BrowseName_FileDirectoryName_Placeholder "<FileDirectoryName>"
#define OpcUa_BrowseName_FileDirectoryType "FileDirectoryType"
#define OpcUa_BrowseName_FileName_Placeholder "<FileName>"
#define OpcUa_BrowseName_FileSystem "FileSystem"
#define OpcUa_BrowseName_FileTransferStateMachineType "FileTransferStateMachineType"
#define OpcUa_BrowseName_FileType "FileType"
#define OpcUa_BrowseName_Filter "Filter"
#define OpcUa_BrowseName_FilterOperand "FilterOperand"
#define OpcUa_BrowseName_FilterOperator "FilterOperator"
#define OpcUa_BrowseName_FinalResultData "FinalResultData"
#define OpcUa_BrowseName_FindAlias "FindAlias"
#define OpcUa_BrowseName_FindServersOnNetworkRequest "FindServersOnNetworkRequest"
#define OpcUa_BrowseName_FindServersOnNetworkResponse "FindServersOnNetworkResponse"
#define OpcUa_BrowseName_FindServersRequest "FindServersRequest"
#define OpcUa_BrowseName_FindServersResponse "FindServersResponse"
#define OpcUa_BrowseName_FiniteStateMachineType "FiniteStateMachineType"
#define OpcUa_BrowseName_FiniteStateVariableType "FiniteStateVariableType"
#define OpcUa_BrowseName_FiniteTransitionVariableType "FiniteTransitionVariableType"
#define OpcUa_BrowseName_FirstInGroup "FirstInGroup"
#define OpcUa_BrowseName_FirstInGroupFlag "FirstInGroupFlag"
#define OpcUa_BrowseName_FixedBase "FixedBase"
#define OpcUa_BrowseName_Float "Float"
#define OpcUa_BrowseName_FolderType "FolderType"
#define OpcUa_BrowseName_ForceKeyRotation "ForceKeyRotation"
#define OpcUa_BrowseName_Frame "Frame"
#define OpcUa_BrowseName_FrameType "FrameType"
#define OpcUa_BrowseName_FromState "FromState"
#define OpcUa_BrowseName_GeneralModelChangeEventType "GeneralModelChangeEventType"
#define OpcUa_BrowseName_GenerateFileForRead "GenerateFileForRead"
#define OpcUa_BrowseName_GenerateFileForWrite "GenerateFileForWrite"
#define OpcUa_BrowseName_GeneratesEvent "GeneratesEvent"
#define OpcUa_BrowseName_GenericAttributes "GenericAttributes"
#define OpcUa_BrowseName_GenericAttributeValue "GenericAttributeValue"
#define OpcUa_BrowseName_GetCertificates "GetCertificates"
#define OpcUa_BrowseName_GetEncryptingKey "GetEncryptingKey"
#define OpcUa_BrowseName_GetEndpointsRequest "GetEndpointsRequest"
#define OpcUa_BrowseName_GetEndpointsResponse "GetEndpointsResponse"
#define OpcUa_BrowseName_GetGroupMemberships "GetGroupMemberships"
#define OpcUa_BrowseName_GetMonitoredItems "GetMonitoredItems"
#define OpcUa_BrowseName_GetPosition "GetPosition"
#define OpcUa_BrowseName_GetRejectedList "GetRejectedList"
#define OpcUa_BrowseName_GetSecurityGroup "GetSecurityGroup"
#define OpcUa_BrowseName_GetSecurityKeys "GetSecurityKeys"
#define OpcUa_BrowseName_GroupId "GroupId"
#define OpcUa_BrowseName_GroupProperties "GroupProperties"
#define OpcUa_BrowseName_GroupVersion "GroupVersion"
#define OpcUa_BrowseName_GuardVariableType "GuardVariableType"
#define OpcUa_BrowseName_Guid "Guid"
#define OpcUa_BrowseName_HAConfiguration "HA Configuration"
#define OpcUa_BrowseName_Halt "Halt"
#define OpcUa_BrowseName_Halted "Halted"
#define OpcUa_BrowseName_HaltedToReady "HaltedToReady"
#define OpcUa_BrowseName_Handle "Handle"
#define OpcUa_BrowseName_HasAddIn "HasAddIn"
#define OpcUa_BrowseName_HasAlarmSuppressionGroup "HasAlarmSuppressionGroup"
#define OpcUa_BrowseName_HasArgumentDescription "HasArgumentDescription"
#define OpcUa_BrowseName_HasAttachedComponent "HasAttachedComponent"
#define OpcUa_BrowseName_HasCause "HasCause"
#define OpcUa_BrowseName_HasChild "HasChild"
#define OpcUa_BrowseName_HasComponent "HasComponent"
#define OpcUa_BrowseName_HasCondition "HasCondition"
#define OpcUa_BrowseName_HasContainedComponent "HasContainedComponent"
#define OpcUa_BrowseName_HasDataSetReader "HasDataSetReader"
#define OpcUa_BrowseName_HasDataSetWriter "HasDataSetWriter"
#define OpcUa_BrowseName_HasDescription "HasDescription"
#define OpcUa_BrowseName_HasDictionaryEntry "HasDictionaryEntry"
#define OpcUa_BrowseName_HasEffect "HasEffect"
#define OpcUa_BrowseName_HasEffectDisable "HasEffectDisable"
#define OpcUa_BrowseName_HasEffectEnable "HasEffectEnable"
#define OpcUa_BrowseName_HasEffectSuppressed "HasEffectSuppressed"
#define OpcUa_BrowseName_HasEffectUnsuppressed "HasEffectUnsuppressed"
#define OpcUa_BrowseName_HasEncoding "HasEncoding"
#define OpcUa_BrowseName_HasEventSource "HasEventSource"
#define OpcUa_BrowseName_HasFalseSubState "HasFalseSubState"
#define OpcUa_BrowseName_HasGuard "HasGuard"
#define OpcUa_BrowseName_HasHistoricalConfiguration "HasHistoricalConfiguration"
#define OpcUa_BrowseName_HasInterface "HasInterface"
#define OpcUa_BrowseName_HasLowerLayerInterface "HasLowerLayerInterface"
#define OpcUa_BrowseName_HasModellingRule "HasModellingRule"
#define OpcUa_BrowseName_HasNotifier "HasNotifier"
#define OpcUa_BrowseName_HasOptionalInputArgumentDescription "HasOptionalInputArgumentDescription"
#define OpcUa_BrowseName_HasOrderedComponent "HasOrderedComponent"
#define OpcUa_BrowseName_HasPhysicalComponent "HasPhysicalComponent"
#define OpcUa_BrowseName_HasProperty "HasProperty"
#define OpcUa_BrowseName_HasPubSubConnection "HasPubSubConnection"
#define OpcUa_BrowseName_HasPushedSecurityGroup "HasPushedSecurityGroup"
#define OpcUa_BrowseName_HasReaderGroup "HasReaderGroup"
#define OpcUa_BrowseName_HasReferenceDescription "HasReferenceDescription"
#define OpcUa_BrowseName_HasSecureElement "HasSecureElement"
#define OpcUa_BrowseName_HasStructuredComponent "HasStructuredComponent"
#define OpcUa_BrowseName_HasSubStateMachine "HasSubStateMachine"
#define OpcUa_BrowseName_HasSubtype "HasSubtype"
#define OpcUa_BrowseName_HasTrueSubState "HasTrueSubState"
#define OpcUa_BrowseName_HasTypeDefinition "HasTypeDefinition"
#define OpcUa_BrowseName_HasWriterGroup "HasWriterGroup"
#define OpcUa_BrowseName_HeaderLayoutUri "HeaderLayoutUri"
#define OpcUa_BrowseName_HierarchicalReferences "HierarchicalReferences"
#define OpcUa_BrowseName_High "High"
#define OpcUa_BrowseName_HighDeadband "HighDeadband"
#define OpcUa_BrowseName_HighestActiveSeverity "HighestActiveSeverity"
#define OpcUa_BrowseName_HighestUnackSeverity "HighestUnackSeverity"
#define OpcUa_BrowseName_HighHigh "HighHigh"
#define OpcUa_BrowseName_HighHighDeadband "HighHighDeadband"
#define OpcUa_BrowseName_HighHighLimit "HighHighLimit"
#define OpcUa_BrowseName_HighHighState "HighHighState"
#define OpcUa_BrowseName_HighHighToHigh "HighHighToHigh"
#define OpcUa_BrowseName_HighLimit "HighLimit"
#define OpcUa_BrowseName_HighlyManagedAlarmConditionClassType "HighlyManagedAlarmConditionClassType"
#define OpcUa_BrowseName_HighState "HighState"
#define OpcUa_BrowseName_HighToHighHigh "HighToHighHigh"
#define OpcUa_BrowseName_HistoricalDataConfigurationType "HistoricalDataConfigurationType"
#define OpcUa_BrowseName_HistoricalEventFilter "HistoricalEventFilter"
#define OpcUa_BrowseName_HistoryData "HistoryData"
#define OpcUa_BrowseName_HistoryEvent "HistoryEvent"
#define OpcUa_BrowseName_HistoryEventFieldList "HistoryEventFieldList"
#define OpcUa_BrowseName_HistoryModifiedData "HistoryModifiedData"
#define OpcUa_BrowseName_HistoryReadCount "HistoryReadCount"
#define OpcUa_BrowseName_HistoryReadDetails "HistoryReadDetails"
#define OpcUa_BrowseName_HistoryReadRequest "HistoryReadRequest"
#define OpcUa_BrowseName_HistoryReadResponse "HistoryReadResponse"
#define OpcUa_BrowseName_HistoryReadResult "HistoryReadResult"
#define OpcUa_BrowseName_HistoryReadValueId "HistoryReadValueId"
#define OpcUa_BrowseName_HistoryServerCapabilities "HistoryServerCapabilities"
#define OpcUa_BrowseName_HistoryServerCapabilitiesType "HistoryServerCapabilitiesType"
#define OpcUa_BrowseName_HistoryUpdateCount "HistoryUpdateCount"
#define OpcUa_BrowseName_HistoryUpdateDetails "HistoryUpdateDetails"
#define OpcUa_BrowseName_HistoryUpdateRequest "HistoryUpdateRequest"
#define OpcUa_BrowseName_HistoryUpdateResponse "HistoryUpdateResponse"
#define OpcUa_BrowseName_HistoryUpdateResult "HistoryUpdateResult"
#define OpcUa_BrowseName_HistoryUpdateType "HistoryUpdateType"
#define OpcUa_BrowseName_HttpsCertificateType "HttpsCertificateType"
#define OpcUa_BrowseName_IBaseEthernetCapabilitiesType "IBaseEthernetCapabilitiesType"
#define OpcUa_BrowseName_Icon "Icon"
#define OpcUa_BrowseName_Id "Id"
#define OpcUa_BrowseName_Identities "Identities"
#define OpcUa_BrowseName_IdentityCriteriaType "IdentityCriteriaType"
#define OpcUa_BrowseName_IdentityMappingRuleType "IdentityMappingRuleType"
#define OpcUa_BrowseName_Idle "Idle"
#define OpcUa_BrowseName_IdleToApplyWrite "IdleToApplyWrite"
#define OpcUa_BrowseName_IdleToReadPrepare "IdleToReadPrepare"
#define OpcUa_BrowseName_IdType "IdType"
#define OpcUa_BrowseName_IetfBaseNetworkInterfaceType "IetfBaseNetworkInterfaceType"
#define OpcUa_BrowseName_IIeeeAutoNegotiationStatusType "IIeeeAutoNegotiationStatusType"
#define OpcUa_BrowseName_IIeeeBaseEthernetPortType "IIeeeBaseEthernetPortType"
#define OpcUa_BrowseName_IIeeeBaseTsnStatusStreamType "IIeeeBaseTsnStatusStreamType"
#define OpcUa_BrowseName_IIeeeBaseTsnStreamType "IIeeeBaseTsnStreamType"
#define OpcUa_BrowseName_IIeeeBaseTsnTrafficSpecificationType "IIeeeBaseTsnTrafficSpecificationType"
#define OpcUa_BrowseName_IIeeeTsnInterfaceConfigurationListenerType "IIeeeTsnInterfaceConfigurationListenerType"
#define OpcUa_BrowseName_IIeeeTsnInterfaceConfigurationTalkerType "IIeeeTsnInterfaceConfigurationTalkerType"
#define OpcUa_BrowseName_IIeeeTsnInterfaceConfigurationType "IIeeeTsnInterfaceConfigurationType"
#define OpcUa_BrowseName_IIeeeTsnMacAddressType "IIeeeTsnMacAddressType"
#define OpcUa_BrowseName_IIeeeTsnVlanTagType "IIeeeTsnVlanTagType"
#define OpcUa_BrowseName_IIetfBaseNetworkInterfaceType "IIetfBaseNetworkInterfaceType"
#define OpcUa_BrowseName_Image "Image"
#define OpcUa_BrowseName_ImageBMP "ImageBMP"
#define OpcUa_BrowseName_ImageGIF "ImageGIF"
#define OpcUa_BrowseName_ImageItemType "ImageItemType"
#define OpcUa_BrowseName_ImageJPG "ImageJPG"
#define OpcUa_BrowseName_ImagePNG "ImagePNG"
#define OpcUa_BrowseName_Index "Index"
#define OpcUa_BrowseName_IndexRange "IndexRange"
#define OpcUa_BrowseName_InitialStateType "InitialStateType"
#define OpcUa_BrowseName_InputArguments "InputArguments"
#define OpcUa_BrowseName_InputNode "InputNode"
#define OpcUa_BrowseName_InsertAnnotationCapability "InsertAnnotationCapability"
#define OpcUa_BrowseName_InsertDataCapability "InsertDataCapability"
#define OpcUa_BrowseName_InsertEventCapability "InsertEventCapability"
#define OpcUa_BrowseName_InstanceCount "InstanceCount"
#define OpcUa_BrowseName_InstanceNode "InstanceNode"
#define OpcUa_BrowseName_InstrumentDiagnosticAlarmType "InstrumentDiagnosticAlarmType"
#define OpcUa_BrowseName_InstrumentRange "InstrumentRange"
#define OpcUa_BrowseName_Int16 "Int16"
#define OpcUa_BrowseName_Int32 "Int32"
#define OpcUa_BrowseName_Int64 "Int64"
#define OpcUa_BrowseName_Integer "Integer"
#define OpcUa_BrowseName_IntegerId "IntegerId"
#define OpcUa_BrowseName_InterfaceAdminStatus "InterfaceAdminStatus"
#define OpcUa_BrowseName_InterfaceName "InterfaceName"
#define OpcUa_BrowseName_InterfaceName_Placeholder "<InterfaceName>"
#define OpcUa_BrowseName_InterfaceOperStatus "InterfaceOperStatus"
#define OpcUa_BrowseName_InterfaceTypes "InterfaceTypes"
#define OpcUa_BrowseName_IntermediateResult "IntermediateResult"
#define OpcUa_BrowseName_Interval "Interval"
#define OpcUa_BrowseName_InvalidateKeys "InvalidateKeys"
#define OpcUa_BrowseName_InvalidHostname "InvalidHostname"
#define OpcUa_BrowseName_InvalidUri "InvalidUri"
#define OpcUa_BrowseName_InvocationCreationTime "InvocationCreationTime"
#define OpcUa_BrowseName_IOrderedObjectType "IOrderedObjectType"
#define OpcUa_BrowseName_IPriorityMappingEntryType "IPriorityMappingEntryType"
#define OpcUa_BrowseName_IrdiDictionaryEntryType "IrdiDictionaryEntryType"
#define OpcUa_BrowseName_IsConnected "IsConnected"
#define OpcUa_BrowseName_IsDeleteModified "IsDeleteModified"
#define OpcUa_BrowseName_IsDeprecated "IsDeprecated"
#define OpcUa_BrowseName_IsExecutableOn "IsExecutableOn"
#define OpcUa_BrowseName_IsExecutingOn "IsExecutingOn"
#define OpcUa_BrowseName_IsHostedBy "IsHostedBy"
#define OpcUa_BrowseName_IsNamespaceSubset "IsNamespaceSubset"
#define OpcUa_BrowseName_IsPhysicallyConnectedTo "IsPhysicallyConnectedTo"
#define OpcUa_BrowseName_ISrClassType "ISrClassType"
#define OpcUa_BrowseName_IsSingleton "IsSingleton"
#define OpcUa_BrowseName_IssuedIdentityToken "IssuedIdentityToken"
#define OpcUa_BrowseName_IssuerEndpointUrl "IssuerEndpointUrl"
#define OpcUa_BrowseName_IVlanIdType "IVlanIdType"
#define OpcUa_BrowseName_JsonDataSetMessageContentMask "JsonDataSetMessageContentMask"
#define OpcUa_BrowseName_JsonDataSetReaderMessageDataType "JsonDataSetReaderMessageDataType"
#define OpcUa_BrowseName_JsonDataSetReaderMessageType "JsonDataSetReaderMessageType"
#define OpcUa_BrowseName_JsonDataSetWriterMessageDataType "JsonDataSetWriterMessageDataType"
#define OpcUa_BrowseName_JsonDataSetWriterMessageType "JsonDataSetWriterMessageType"
#define OpcUa_BrowseName_JsonNetworkMessageContentMask "JsonNetworkMessageContentMask"
#define OpcUa_BrowseName_JsonWriterGroupMessageDataType "JsonWriterGroupMessageDataType"
#define OpcUa_BrowseName_JsonWriterGroupMessageType "JsonWriterGroupMessageType"
#define OpcUa_BrowseName_KeepAliveTime "KeepAliveTime"
#define OpcUa_BrowseName_KeyCredentialAuditEventType "KeyCredentialAuditEventType"
#define OpcUa_BrowseName_KeyCredentialConfiguration "KeyCredentialConfiguration"
#define OpcUa_BrowseName_KeyCredentialConfigurationFolderType "KeyCredentialConfigurationFolderType"
#define OpcUa_BrowseName_KeyCredentialConfigurationType "KeyCredentialConfigurationType"
#define OpcUa_BrowseName_KeyCredentialDeletedAuditEventType "KeyCredentialDeletedAuditEventType"
#define OpcUa_BrowseName_KeyCredentialUpdatedAuditEventType "KeyCredentialUpdatedAuditEventType"
#define OpcUa_BrowseName_KeyFrameCount "KeyFrameCount"
#define OpcUa_BrowseName_KeyLifetime "KeyLifetime"
#define OpcUa_BrowseName_KeyPushTargets "KeyPushTargets"
#define OpcUa_BrowseName_KeyValuePair "KeyValuePair"
#define OpcUa_BrowseName_LastMethodCall "LastMethodCall"
#define OpcUa_BrowseName_LastMethodCallTime "LastMethodCallTime"
#define OpcUa_BrowseName_LastMethodInputArguments "LastMethodInputArguments"
#define OpcUa_BrowseName_LastMethodInputValues "LastMethodInputValues"
#define OpcUa_BrowseName_LastMethodOutputArguments "LastMethodOutputArguments"
#define OpcUa_BrowseName_LastMethodOutputValues "LastMethodOutputValues"
#define OpcUa_BrowseName_LastMethodReturnStatus "LastMethodReturnStatus"
#define OpcUa_BrowseName_LastMethodSessionId "LastMethodSessionId"
#define OpcUa_BrowseName_LastModifiedTime "LastModifiedTime"
#define OpcUa_BrowseName_LastPushErrorTime "LastPushErrorTime"
#define OpcUa_BrowseName_LastPushExecutionTime "LastPushExecutionTime"
#define OpcUa_BrowseName_LastResponse "LastResponse"
#define OpcUa_BrowseName_LastSeverity "LastSeverity"
#define OpcUa_BrowseName_LastTransition "LastTransition"
#define OpcUa_BrowseName_LastTransitionTime "LastTransitionTime"
#define OpcUa_BrowseName_LastUpdateTime "LastUpdateTime"
#define OpcUa_BrowseName_LatchedState "LatchedState"
#define OpcUa_BrowseName_LatePublishRequestCount "LatePublishRequestCount"
#define OpcUa_BrowseName_LengthUnit "LengthUnit"
#define OpcUa_BrowseName_LimitAlarmType "LimitAlarmType"
#define OpcUa_BrowseName_LimitState "LimitState"
#define OpcUa_BrowseName_ListenerStatus "ListenerStatus"
#define OpcUa_BrowseName_ListenerStreams "ListenerStreams"
#define OpcUa_BrowseName_ListId "ListId"
#define OpcUa_BrowseName_LiteralOperand "LiteralOperand"
#define OpcUa_BrowseName_LiveValues "LiveValues"
#define OpcUa_BrowseName_LocaleId "LocaleId"
#define OpcUa_BrowseName_LocaleIdArray "LocaleIdArray"
#define OpcUa_BrowseName_LocaleIds "LocaleIds"
#define OpcUa_BrowseName_LocalizedText "LocalizedText"
#define OpcUa_BrowseName_LocalTime "LocalTime"
#define OpcUa_BrowseName_Locations "Locations"
#define OpcUa_BrowseName_Low "Low"
#define OpcUa_BrowseName_LowDeadband "LowDeadband"
#define OpcUa_BrowseName_LowLimit "LowLimit"
#define OpcUa_BrowseName_LowLow "LowLow"
#define OpcUa_BrowseName_LowLowDeadband "LowLowDeadband"
#define OpcUa_BrowseName_LowLowLimit "LowLowLimit"
#define OpcUa_BrowseName_LowLowState "LowLowState"
#define OpcUa_BrowseName_LowLowToLow "LowLowToLow"
#define OpcUa_BrowseName_LowState "LowState"
#define OpcUa_BrowseName_LowToLowLow "LowToLowLow"
#define OpcUa_BrowseName_MacAddress "MacAddress"
#define OpcUa_BrowseName_MaintenanceConditionClassType "MaintenanceConditionClassType"
#define OpcUa_BrowseName_ManufacturerName "ManufacturerName"
#define OpcUa_BrowseName_MappingTables "MappingTables"
#define OpcUa_BrowseName_MappingUri "MappingUri"
#define OpcUa_BrowseName_MaxArrayLength "MaxArrayLength"
#define OpcUa_BrowseName_MaxBrowseContinuationPoints "MaxBrowseContinuationPoints"
#define OpcUa_BrowseName_MaxByteStringLength "MaxByteStringLength"
#define OpcUa_BrowseName_MaxCharacters "MaxCharacters"
#define OpcUa_BrowseName_MaxDataSetReaders "MaxDataSetReaders"
#define OpcUa_BrowseName_MaxDataSetWriters "MaxDataSetWriters"
#define OpcUa_BrowseName_MaxDataSetWritersPerGroup "MaxDataSetWritersPerGroup"
#define OpcUa_BrowseName_MaxFieldsPerDataSet "MaxFieldsPerDataSet"
#define OpcUa_BrowseName_MaxFrameLength "MaxFrameLength"
#define OpcUa_BrowseName_MaxFrameSize "MaxFrameSize"
#define OpcUa_BrowseName_MaxFutureKeyCount "MaxFutureKeyCount"
#define OpcUa_BrowseName_MaxHistoryContinuationPoints "MaxHistoryContinuationPoints"
#define OpcUa_BrowseName_Maximum "Maximum"
#define OpcUa_BrowseName_MaximumActiveState "MaximumActiveState"
#define OpcUa_BrowseName_MaximumAlarmRate "MaximumAlarmRate"
#define OpcUa_BrowseName_MaximumReAlarmCount "MaximumReAlarmCount"
#define OpcUa_BrowseName_MaximumUnAck "MaximumUnAck"
#define OpcUa_BrowseName_MaxInstanceCount "MaxInstanceCount"
#define OpcUa_BrowseName_MaxIntervalFrames "MaxIntervalFrames"
#define OpcUa_BrowseName_MaxKeepAliveCount "MaxKeepAliveCount"
#define OpcUa_BrowseName_MaxLifetimeCount "MaxLifetimeCount"
#define OpcUa_BrowseName_MaxMonitoredItems "MaxMonitoredItems"
#define OpcUa_BrowseName_MaxMonitoredItemsPerCall "MaxMonitoredItemsPerCall"
#define OpcUa_BrowseName_MaxMonitoredItemsPerSubscription "MaxMonitoredItemsPerSubscription"
#define OpcUa_BrowseName_MaxMonitoredItemsQueueSize "MaxMonitoredItemsQueueSize"
#define OpcUa_BrowseName_MaxNetworkMessageSize "MaxNetworkMessageSize"
#define OpcUa_BrowseName_MaxNetworkMessageSizeBroker "MaxNetworkMessageSizeBroker"
#define OpcUa_BrowseName_MaxNetworkMessageSizeDatagram "MaxNetworkMessageSizeDatagram"
#define OpcUa_BrowseName_MaxNodesPerBrowse "MaxNodesPerBrowse"
#define OpcUa_BrowseName_MaxNodesPerHistoryReadData "MaxNodesPerHistoryReadData"
#define OpcUa_BrowseName_MaxNodesPerHistoryReadEvents "MaxNodesPerHistoryReadEvents"
#define OpcUa_BrowseName_MaxNodesPerHistoryUpdateData "MaxNodesPerHistoryUpdateData"
#define OpcUa_BrowseName_MaxNodesPerHistoryUpdateEvents "MaxNodesPerHistoryUpdateEvents"
#define OpcUa_BrowseName_MaxNodesPerMethodCall "MaxNodesPerMethodCall"
#define OpcUa_BrowseName_MaxNodesPerNodeManagement "MaxNodesPerNodeManagement"
#define OpcUa_BrowseName_MaxNodesPerRead "MaxNodesPerRead"
#define OpcUa_BrowseName_MaxNodesPerRegisterNodes "MaxNodesPerRegisterNodes"
#define OpcUa_BrowseName_MaxNodesPerTranslateBrowsePathsToNodeIds "MaxNodesPerTranslateBrowsePathsToNodeIds"
#define OpcUa_BrowseName_MaxNodesPerWrite "MaxNodesPerWrite"
#define OpcUa_BrowseName_MaxNotificationsPerPublish "MaxNotificationsPerPublish"
#define OpcUa_BrowseName_MaxPastKeyCount "MaxPastKeyCount"
#define OpcUa_BrowseName_MaxPubSubConnections "MaxPubSubConnections"
#define OpcUa_BrowseName_MaxQueryContinuationPoints "MaxQueryContinuationPoints"
#define OpcUa_BrowseName_MaxReaderGroups "MaxReaderGroups"
#define OpcUa_BrowseName_MaxRecycleCount "MaxRecycleCount"
#define OpcUa_BrowseName_MaxResponseMessageSize "MaxResponseMessageSize"
#define OpcUa_BrowseName_MaxReturnDataValues "MaxReturnDataValues"
#define OpcUa_BrowseName_MaxReturnEventValues "MaxReturnEventValues"
#define OpcUa_BrowseName_MaxSampledMonitoredItemsCount "MaxSampledMonitoredItemsCount"
#define OpcUa_BrowseName_MaxSelectClauseParameters "MaxSelectClauseParameters"
#define OpcUa_BrowseName_MaxSessions "MaxSessions"
#define OpcUa_BrowseName_MaxStringLength "MaxStringLength"
#define OpcUa_BrowseName_MaxSubscriptions "MaxSubscriptions"
#define OpcUa_BrowseName_MaxSubscriptionsPerSession "MaxSubscriptionsPerSession"
#define OpcUa_BrowseName_MaxTimeInterval "MaxTimeInterval"
#define OpcUa_BrowseName_MaxTimeShelved "MaxTimeShelved"
#define OpcUa_BrowseName_MaxTrustListSize "MaxTrustListSize"
#define OpcUa_BrowseName_MaxWhereClauseParameters "MaxWhereClauseParameters"
#define OpcUa_BrowseName_MaxWriterGroups "MaxWriterGroups"
#define OpcUa_BrowseName_MdnsDiscoveryConfiguration "MdnsDiscoveryConfiguration"
#define OpcUa_BrowseName_Message "Message"
#define OpcUa_BrowseName_MessageReceiveTimeout "MessageReceiveTimeout"
#define OpcUa_BrowseName_MessageRepeatCount "MessageRepeatCount"
#define OpcUa_BrowseName_MessageRepeatDelay "MessageRepeatDelay"
#define OpcUa_BrowseName_MessageSecurityMode "MessageSecurityMode"
#define OpcUa_BrowseName_MessageSettings "MessageSettings"
#define OpcUa_BrowseName_MetaDataQueueName "MetaDataQueueName"
#define OpcUa_BrowseName_MetaDataUpdateTime "MetaDataUpdateTime"
#define OpcUa_BrowseName_MethodAttributes "MethodAttributes"
#define OpcUa_BrowseName_MethodId "MethodId"
#define OpcUa_BrowseName_MethodNode "MethodNode"
#define OpcUa_BrowseName_MimeType "MimeType"
#define OpcUa_BrowseName_MinSupportedSampleRate "MinSupportedSampleRate"
#define OpcUa_BrowseName_MinTimeInterval "MinTimeInterval"
#define OpcUa_BrowseName_ModelChangeStructureDataType "ModelChangeStructureDataType"
#define OpcUa_BrowseName_ModelChangeStructureVerbMask "ModelChangeStructureVerbMask"
#define OpcUa_BrowseName_ModellingRule_ExposesItsArray "ExposesItsArray"
#define OpcUa_BrowseName_ModellingRule_Mandatory "Mandatory"
#define OpcUa_BrowseName_ModellingRule_MandatoryPlaceholder "MandatoryPlaceholder"
#define OpcUa_BrowseName_ModellingRule_Optional "Optional"
#define OpcUa_BrowseName_ModellingRule_OptionalPlaceholder "OptionalPlaceholder"
#define OpcUa_BrowseName_ModellingRules "ModellingRules"
#define OpcUa_BrowseName_ModellingRuleType "ModellingRuleType"
#define OpcUa_BrowseName_ModificationInfo "ModificationInfo"
#define OpcUa_BrowseName_ModifyCount "ModifyCount"
#define OpcUa_BrowseName_ModifyFieldSelection "ModifyFieldSelection"
#define OpcUa_BrowseName_ModifyMonitoredItemsCount "ModifyMonitoredItemsCount"
#define OpcUa_BrowseName_ModifyMonitoredItemsRequest "ModifyMonitoredItemsRequest"
#define OpcUa_BrowseName_ModifyMonitoredItemsResponse "ModifyMonitoredItemsResponse"
#define OpcUa_BrowseName_ModifySubscriptionCount "ModifySubscriptionCount"
#define OpcUa_BrowseName_ModifySubscriptionRequest "ModifySubscriptionRequest"
#define OpcUa_BrowseName_ModifySubscriptionResponse "ModifySubscriptionResponse"
#define OpcUa_BrowseName_ModifyUser "ModifyUser"
#define OpcUa_BrowseName_MonitoredItemCount "MonitoredItemCount"
#define OpcUa_BrowseName_MonitoredItemCreateRequest "MonitoredItemCreateRequest"
#define OpcUa_BrowseName_MonitoredItemCreateResult "MonitoredItemCreateResult"
#define OpcUa_BrowseName_MonitoredItemModifyRequest "MonitoredItemModifyRequest"
#define OpcUa_BrowseName_MonitoredItemModifyResult "MonitoredItemModifyResult"
#define OpcUa_BrowseName_MonitoredItemNotification "MonitoredItemNotification"
#define OpcUa_BrowseName_MonitoringFilter "MonitoringFilter"
#define OpcUa_BrowseName_MonitoringFilterResult "MonitoringFilterResult"
#define OpcUa_BrowseName_MonitoringMode "MonitoringMode"
#define OpcUa_BrowseName_MonitoringParameters "MonitoringParameters"
#define OpcUa_BrowseName_MonitoringQueueOverflowCount "MonitoringQueueOverflowCount"
#define OpcUa_BrowseName_MoveOrCopy "MoveOrCopy"
#define OpcUa_BrowseName_MulticastDnsEnabled "MulticastDnsEnabled"
#define OpcUa_BrowseName_MultiStateDictionaryEntryDiscreteBaseType "MultiStateDictionaryEntryDiscreteBaseType"
#define OpcUa_BrowseName_MultiStateDictionaryEntryDiscreteType "MultiStateDictionaryEntryDiscreteType"
#define OpcUa_BrowseName_MultiStateDiscreteType "MultiStateDiscreteType"
#define OpcUa_BrowseName_MultiStateValueDiscreteType "MultiStateValueDiscreteType"
#define OpcUa_BrowseName_Name "Name"
#define OpcUa_BrowseName_NamespaceArray "NamespaceArray"
#define OpcUa_BrowseName_NamespaceFile "NamespaceFile"
#define OpcUa_BrowseName_NamespaceIdentifier_Placeholder "<NamespaceIdentifier>"
#define OpcUa_BrowseName_NamespaceMetadataType "NamespaceMetadataType"
#define OpcUa_BrowseName_NamespacePublicationDate "NamespacePublicationDate"
#define OpcUa_BrowseName_Namespaces "Namespaces"
#define OpcUa_BrowseName_NamespacesType "NamespacesType"
#define OpcUa_BrowseName_NamespaceUri "NamespaceUri"
#define OpcUa_BrowseName_NamespaceVersion "NamespaceVersion"
#define OpcUa_BrowseName_NamingRuleType "NamingRuleType"
#define OpcUa_BrowseName_NDimensionArrayItemType "NDimensionArrayItemType"
#define OpcUa_BrowseName_NegotiationStatus "NegotiationStatus"
#define OpcUa_BrowseName_NetworkAddressDataType "NetworkAddressDataType"
#define OpcUa_BrowseName_NetworkAddressType "NetworkAddressType"
#define OpcUa_BrowseName_NetworkAddressUrlDataType "NetworkAddressUrlDataType"
#define OpcUa_BrowseName_NetworkAddressUrlType "NetworkAddressUrlType"
#define OpcUa_BrowseName_NetworkGroupDataType "NetworkGroupDataType"
#define OpcUa_BrowseName_NetworkInterface "NetworkInterface"
#define OpcUa_BrowseName_NetworkInterfaces "NetworkInterfaces"
#define OpcUa_BrowseName_NetworkMessageContentMask "NetworkMessageContentMask"
#define OpcUa_BrowseName_NetworkMessageNumber "NetworkMessageNumber"
#define OpcUa_BrowseName_NewStateId "NewStateId"
#define OpcUa_BrowseName_NewValue "NewValue"
#define OpcUa_BrowseName_NewValues "NewValues"
#define OpcUa_BrowseName_NextSequenceNumber "NextSequenceNumber"
#define OpcUa_BrowseName_Node "Node"
#define OpcUa_BrowseName_NodeAttributes "NodeAttributes"
#define OpcUa_BrowseName_NodeAttributesMask "NodeAttributesMask"
#define OpcUa_BrowseName_NodeClass "NodeClass"
#define OpcUa_BrowseName_NodeId "NodeId"
#define OpcUa_BrowseName_NodeReference "NodeReference"
#define OpcUa_BrowseName_NodesToAdd "NodesToAdd"
#define OpcUa_BrowseName_NodesToDelete "NodesToDelete"
#define OpcUa_BrowseName_NodeTypeDescription "NodeTypeDescription"
#define OpcUa_BrowseName_NodeVersion "NodeVersion"
#define OpcUa_BrowseName_NonExclusiveDeviationAlarmType "NonExclusiveDeviationAlarmType"
#define OpcUa_BrowseName_NonExclusiveLevelAlarmType "NonExclusiveLevelAlarmType"
#define OpcUa_BrowseName_NonExclusiveLimitAlarmType "NonExclusiveLimitAlarmType"
#define OpcUa_BrowseName_NonExclusiveRateOfChangeAlarmType "NonExclusiveRateOfChangeAlarmType"
#define OpcUa_BrowseName_NonHierarchicalReferences "NonHierarchicalReferences"
#define OpcUa_BrowseName_NonTransparentNetworkRedundancyType "NonTransparentNetworkRedundancyType"
#define OpcUa_BrowseName_NonTransparentRedundancyType "NonTransparentRedundancyType"
#define OpcUa_BrowseName_NormalizedString "NormalizedString"
#define OpcUa_BrowseName_NormalState "NormalState"
#define OpcUa_BrowseName_NotificationData "NotificationData"
#define OpcUa_BrowseName_NotificationMessage "NotificationMessage"
#define OpcUa_BrowseName_NotificationsCount "NotificationsCount"
#define OpcUa_BrowseName_Number "Number"
#define OpcUa_BrowseName_NumberInList "NumberInList"
#define OpcUa_BrowseName_Numerator "Numerator"
#define OpcUa_BrowseName_NumericRange "NumericRange"
#define OpcUa_BrowseName_ObjectAttributes "ObjectAttributes"
#define OpcUa_BrowseName_ObjectId "ObjectId"
#define OpcUa_BrowseName_ObjectNode "ObjectNode"
#define OpcUa_BrowseName_ObjectsFolder "Objects"
#define OpcUa_BrowseName_ObjectTypeAttributes "ObjectTypeAttributes"
#define OpcUa_BrowseName_ObjectTypeNode "ObjectTypeNode"
#define OpcUa_BrowseName_ObjectTypesFolder "ObjectTypes"
#define OpcUa_BrowseName_OffDelay "OffDelay"
#define OpcUa_BrowseName_OffNormalAlarmType "OffNormalAlarmType"
#define OpcUa_BrowseName_OkResponse "OkResponse"
#define OpcUa_BrowseName_OldStateId "OldStateId"
#define OpcUa_BrowseName_OldValue "OldValue"
#define OpcUa_BrowseName_OldValues "OldValues"
#define OpcUa_BrowseName_OnDelay "OnDelay"
#define OpcUa_BrowseName_OneShotShelve "OneShotShelve"
#define OpcUa_BrowseName_OneShotShelve2 "OneShotShelve2"
#define OpcUa_BrowseName_OneShotShelved "OneShotShelved"
#define OpcUa_BrowseName_OneShotShelvedToTimedShelved "OneShotShelvedToTimedShelved"
#define OpcUa_BrowseName_OneShotShelvedToUnshelved "OneShotShelvedToUnshelved"
#define OpcUa_BrowseName_OPCBinarySchema_TypeSystem "OPC Binary"
#define OpcUa_BrowseName_OpcUa_BinarySchema "Opc.Ua"
#define OpcUa_BrowseName_OpcUa_XmlSchema "Opc.Ua"
#define OpcUa_BrowseName_OPCUANamespaceMetadata "http://opcfoundation.org/UA/"
#define OpcUa_BrowseName_Open "Open"
#define OpcUa_BrowseName_OpenCount "OpenCount"
#define OpcUa_BrowseName_OpenFileMode "OpenFileMode"
#define OpcUa_BrowseName_OpenSecureChannelRequest "OpenSecureChannelRequest"
#define OpcUa_BrowseName_OpenSecureChannelResponse "OpenSecureChannelResponse"
#define OpcUa_BrowseName_OpenWithMasks "OpenWithMasks"
#define OpcUa_BrowseName_OperationLimits "OperationLimits"
#define OpcUa_BrowseName_OperationLimitsType "OperationLimitsType"
#define OpcUa_BrowseName_OperStatus "OperStatus"
#define OpcUa_BrowseName_OptionSet "OptionSet"
#define OpcUa_BrowseName_OptionSetLength "OptionSetLength"
#define OpcUa_BrowseName_OptionSetType "OptionSetType"
#define OpcUa_BrowseName_OptionSetValues "OptionSetValues"
#define OpcUa_BrowseName_OrderedListType "OrderedListType"
#define OpcUa_BrowseName_OrderedObject_Placeholder "<OrderedObject>"
#define OpcUa_BrowseName_Organizes "Organizes"
#define OpcUa_BrowseName_Orientation "Orientation"
#define OpcUa_BrowseName_OrientationType "OrientationType"
#define OpcUa_BrowseName_OutOfServiceState "OutOfServiceState"
#define OpcUa_BrowseName_OutputArguments "OutputArguments"
#define OpcUa_BrowseName_OverrideValueHandling "OverrideValueHandling"
#define OpcUa_BrowseName_ParameterDataTypeId "ParameterDataTypeId"
#define OpcUa_BrowseName_ParsingResult "ParsingResult"
#define OpcUa_BrowseName_PasswordLength "PasswordLength"
#define OpcUa_BrowseName_PasswordOptions "PasswordOptions"
#define OpcUa_BrowseName_PasswordOptionsMask "PasswordOptionsMask"
#define OpcUa_BrowseName_PasswordRestrictions "PasswordRestrictions"
#define OpcUa_BrowseName_PercentDataBad "PercentDataBad"
#define OpcUa_BrowseName_PercentDataGood "PercentDataGood"
#define OpcUa_BrowseName_PerformInsertReplace "PerformInsertReplace"
#define OpcUa_BrowseName_PerformUpdateType "PerformUpdateType"
#define OpcUa_BrowseName_PermissionType "PermissionType"
#define OpcUa_BrowseName_PhysAddress "PhysAddress"
#define OpcUa_BrowseName_PlaceInService "PlaceInService"
#define OpcUa_BrowseName_PlaceInService2 "PlaceInService2"
#define OpcUa_BrowseName_PortableNodeId "PortableNodeId"
#define OpcUa_BrowseName_PortableQualifiedName "PortableQualifiedName"
#define OpcUa_BrowseName_Priority "Priority"
#define OpcUa_BrowseName_PriorityCodePoint "PriorityCodePoint"
#define OpcUa_BrowseName_PriorityLabel "PriorityLabel"
#define OpcUa_BrowseName_PriorityMappingEntryType "PriorityMappingEntryType"
#define OpcUa_BrowseName_PriorityMappingTableType "PriorityMappingTableType"
#define OpcUa_BrowseName_PriorityMapppingEntries "PriorityMapppingEntries"
#define OpcUa_BrowseName_PriorityValue_DSCP "PriorityValue_DSCP"
#define OpcUa_BrowseName_PriorityValue_PCP "PriorityValue_PCP"
#define OpcUa_BrowseName_ProcessConditionClassType "ProcessConditionClassType"
#define OpcUa_BrowseName_ProcessingOffset "ProcessingOffset"
#define OpcUa_BrowseName_ProductName "ProductName"
#define OpcUa_BrowseName_ProductUri "ProductUri"
#define OpcUa_BrowseName_ProfileUri "ProfileUri"
#define OpcUa_BrowseName_ProgramDiagnostic "ProgramDiagnostic"
#define OpcUa_BrowseName_ProgramDiagnostic2DataType "ProgramDiagnostic2DataType"
#define OpcUa_BrowseName_ProgramDiagnostic2Type "ProgramDiagnostic2Type"
#define OpcUa_BrowseName_ProgramDiagnosticDataType "ProgramDiagnosticDataType"
#define OpcUa_BrowseName_ProgramDiagnosticType "ProgramDiagnosticType"
#define OpcUa_BrowseName_ProgramStateMachineType "ProgramStateMachineType"
#define OpcUa_BrowseName_ProgramTransitionAuditEventType "ProgramTransitionAuditEventType"
#define OpcUa_BrowseName_ProgramTransitionEventType "ProgramTransitionEventType"
#define OpcUa_BrowseName_Progress "Progress"
#define OpcUa_BrowseName_ProgressEventType "ProgressEventType"
#define OpcUa_BrowseName_Prompt "Prompt"
#define OpcUa_BrowseName_PropertyType "PropertyType"
#define OpcUa_BrowseName_ProvisionableDevice "ProvisionableDevice"
#define OpcUa_BrowseName_ProvisionableDeviceType "ProvisionableDeviceType"
#define OpcUa_BrowseName_PublishCount "PublishCount"
#define OpcUa_BrowseName_PublishedData "PublishedData"
#define OpcUa_BrowseName_PublishedDataItemsDataType "PublishedDataItemsDataType"
#define OpcUa_BrowseName_PublishedDataItemsType "PublishedDataItemsType"
#define OpcUa_BrowseName_PublishedDataSetCustomSourceDataType "PublishedDataSetCustomSourceDataType"
#define OpcUa_BrowseName_PublishedDataSetDataType "PublishedDataSetDataType"
#define OpcUa_BrowseName_PublishedDataSetName_Placeholder "<PublishedDataSetName>"
#define OpcUa_BrowseName_PublishedDataSets "PublishedDataSets"
#define OpcUa_BrowseName_PublishedDataSetSourceDataType "PublishedDataSetSourceDataType"
#define OpcUa_BrowseName_PublishedDataSetType "PublishedDataSetType"
#define OpcUa_BrowseName_PublishedEventsDataType "PublishedEventsDataType"
#define OpcUa_BrowseName_PublishedEventsType "PublishedEventsType"
#define OpcUa_BrowseName_PublishedVariableDataType "PublishedVariableDataType"
#define OpcUa_BrowseName_PublisherId "PublisherId"
#define OpcUa_BrowseName_PublishingEnabled "PublishingEnabled"
#define OpcUa_BrowseName_PublishingInterval "PublishingInterval"
#define OpcUa_BrowseName_PublishingIntervalCount "PublishingIntervalCount"
#define OpcUa_BrowseName_PublishingOffset "PublishingOffset"
#define OpcUa_BrowseName_PublishRequest "PublishRequest"
#define OpcUa_BrowseName_PublishRequestCount "PublishRequestCount"
#define OpcUa_BrowseName_PublishResponse "PublishResponse"
#define OpcUa_BrowseName_PublishSubscribe "PublishSubscribe"
#define OpcUa_BrowseName_PublishSubscribeType "PublishSubscribeType"
#define OpcUa_BrowseName_PubSubCapabilitiesType "PubSubCapabilitiesType"
#define OpcUa_BrowseName_PubSubCapablities "PubSubCapablities"
#define OpcUa_BrowseName_PubSubCommunicationFailureEventType "PubSubCommunicationFailureEventType"
#define OpcUa_BrowseName_PubSubConfiguration "PubSubConfiguration"
#define OpcUa_BrowseName_PubSubConfiguration2DataType "PubSubConfiguration2DataType"
#define OpcUa_BrowseName_PubSubConfigurationDataType "PubSubConfigurationDataType"
#define OpcUa_BrowseName_PubSubConfigurationRefDataType "PubSubConfigurationRefDataType"
#define OpcUa_BrowseName_PubSubConfigurationRefMask "PubSubConfigurationRefMask"
#define OpcUa_BrowseName_PubSubConfigurationType "PubSubConfigurationType"
#define OpcUa_BrowseName_PubSubConfigurationValueDataType "PubSubConfigurationValueDataType"
#define OpcUa_BrowseName_PubSubConnectionDataType "PubSubConnectionDataType"
#define OpcUa_BrowseName_PubSubConnectionType "PubSubConnectionType"
#define OpcUa_BrowseName_PubSubDiagnosticsConnectionType "PubSubDiagnosticsConnectionType"
#define OpcUa_BrowseName_PubSubDiagnosticsCounterClassification "PubSubDiagnosticsCounterClassification"
#define OpcUa_BrowseName_PubSubDiagnosticsCounterType "PubSubDiagnosticsCounterType"
#define OpcUa_BrowseName_PubSubDiagnosticsDataSetReaderType "PubSubDiagnosticsDataSetReaderType"
#define OpcUa_BrowseName_PubSubDiagnosticsDataSetWriterType "PubSubDiagnosticsDataSetWriterType"
#define OpcUa_BrowseName_PubSubDiagnosticsReaderGroupType "PubSubDiagnosticsReaderGroupType"
#define OpcUa_BrowseName_PubSubDiagnosticsRootType "PubSubDiagnosticsRootType"
#define OpcUa_BrowseName_PubSubDiagnosticsType "PubSubDiagnosticsType"
#define OpcUa_BrowseName_PubSubDiagnosticsWriterGroupType "PubSubDiagnosticsWriterGroupType"
#define OpcUa_BrowseName_PubSubEventNotifier "EventNotifier"
#define OpcUa_BrowseName_PubSubGroupDataType "PubSubGroupDataType"
#define OpcUa_BrowseName_PubSubGroupType "PubSubGroupType"
#define OpcUa_BrowseName_PubSubKeyPushTargetDataType "PubSubKeyPushTargetDataType"
#define OpcUa_BrowseName_PubSubKeyPushTargetFolderType "PubSubKeyPushTargetFolderType"
#define OpcUa_BrowseName_PubSubKeyPushTargetType "PubSubKeyPushTargetType"
#define OpcUa_BrowseName_PubSubKeyServiceType "PubSubKeyServiceType"
#define OpcUa_BrowseName_PubSubState "PubSubState"
#define OpcUa_BrowseName_PubSubStatusEventType "PubSubStatusEventType"
#define OpcUa_BrowseName_PubSubStatusType "PubSubStatusType"
#define OpcUa_BrowseName_PubSubTransportLimitsExceedEventType "PubSubTransportLimitsExceedEventType"
#define OpcUa_BrowseName_PushTargetFolderName_Placeholder "<PushTargetFolderName>"
#define OpcUa_BrowseName_PushTargetName_Placeholder "<PushTargetName>"
#define OpcUa_BrowseName_QosCategory "QosCategory"
#define OpcUa_BrowseName_QosDataType "QosDataType"
#define OpcUa_BrowseName_QualifiedName "QualifiedName"
#define OpcUa_BrowseName_Quality "Quality"
#define OpcUa_BrowseName_QueryDataDescription "QueryDataDescription"
#define OpcUa_BrowseName_QueryDataSet "QueryDataSet"
#define OpcUa_BrowseName_QueryFirstCount "QueryFirstCount"
#define OpcUa_BrowseName_QueryFirstRequest "QueryFirstRequest"
#define OpcUa_BrowseName_QueryFirstResponse "QueryFirstResponse"
#define OpcUa_BrowseName_QueryNextCount "QueryNextCount"
#define OpcUa_BrowseName_QueryNextRequest "QueryNextRequest"
#define OpcUa_BrowseName_QueryNextResponse "QueryNextResponse"
#define OpcUa_BrowseName_QueueName "QueueName"
#define OpcUa_BrowseName_Range "Range"
#define OpcUa_BrowseName_Rate "Rate"
#define OpcUa_BrowseName_RationalNumber "RationalNumber"
#define OpcUa_BrowseName_RationalNumberType "RationalNumberType"
#define OpcUa_BrowseName_Read "Read"
#define OpcUa_BrowseName_ReadAnnotationDataDetails "ReadAnnotationDataDetails"
#define OpcUa_BrowseName_ReadAtTimeDetails "ReadAtTimeDetails"
#define OpcUa_BrowseName_ReadCount "ReadCount"
#define OpcUa_BrowseName_ReaderGroupDataType "ReaderGroupDataType"
#define OpcUa_BrowseName_ReaderGroupMessageDataType "ReaderGroupMessageDataType"
#define OpcUa_BrowseName_ReaderGroupMessageType "ReaderGroupMessageType"
#define OpcUa_BrowseName_ReaderGroupName_Placeholder "<ReaderGroupName>"
#define OpcUa_BrowseName_ReaderGroupTransportDataType "ReaderGroupTransportDataType"
#define OpcUa_BrowseName_ReaderGroupTransportType "ReaderGroupTransportType"
#define OpcUa_BrowseName_ReaderGroupType "ReaderGroupType"
#define OpcUa_BrowseName_ReadEventDetails "ReadEventDetails"
#define OpcUa_BrowseName_ReadPrepare "ReadPrepare"
#define OpcUa_BrowseName_ReadPrepareToError "ReadPrepareToError"
#define OpcUa_BrowseName_ReadPrepareToReadTransfer "ReadPrepareToReadTransfer"
#define OpcUa_BrowseName_ReadProcessedDetails "ReadProcessedDetails"
#define OpcUa_BrowseName_ReadRawModifiedDetails "ReadRawModifiedDetails"
#define OpcUa_BrowseName_ReadRequest "ReadRequest"
#define OpcUa_BrowseName_ReadResponse "ReadResponse"
#define OpcUa_BrowseName_ReadTransfer "ReadTransfer"
#define OpcUa_BrowseName_ReadTransferToError "ReadTransferToError"
#define OpcUa_BrowseName_ReadTransferToIdle "ReadTransferToIdle"
#define OpcUa_BrowseName_ReadValueId "ReadValueId"
#define OpcUa_BrowseName_Ready "Ready"
#define OpcUa_BrowseName_ReadyToHalted "ReadyToHalted"
#define OpcUa_BrowseName_ReadyToRunning "ReadyToRunning"
#define OpcUa_BrowseName_ReAlarmRepeatCount "ReAlarmRepeatCount"
#define OpcUa_BrowseName_ReAlarmTime "ReAlarmTime"
#define OpcUa_BrowseName_ReceiveOffset "ReceiveOffset"
#define OpcUa_BrowseName_ReceiveQosDataType "ReceiveQosDataType"
#define OpcUa_BrowseName_ReceiveQosPriorityDataType "ReceiveQosPriorityDataType"
#define OpcUa_BrowseName_ReceiveTime "ReceiveTime"
#define OpcUa_BrowseName_RecycleCount "RecycleCount"
#define OpcUa_BrowseName_RedundancySupport "RedundancySupport"
#define OpcUa_BrowseName_RedundantServerArray "RedundantServerArray"
#define OpcUa_BrowseName_RedundantServerDataType "RedundantServerDataType"
#define OpcUa_BrowseName_ReferenceDescription "ReferenceDescription"
#define OpcUa_BrowseName_ReferenceDescriptionDataType "ReferenceDescriptionDataType"
#define OpcUa_BrowseName_ReferenceDescriptionVariableType "ReferenceDescriptionVariableType"
#define OpcUa_BrowseName_ReferenceListEntryDataType "ReferenceListEntryDataType"
#define OpcUa_BrowseName_ReferenceNode "ReferenceNode"
#define OpcUa_BrowseName_ReferenceRefinement "ReferenceRefinement"
#define OpcUa_BrowseName_References "References"
#define OpcUa_BrowseName_ReferencesToAdd "ReferencesToAdd"
#define OpcUa_BrowseName_ReferencesToDelete "ReferencesToDelete"
#define OpcUa_BrowseName_ReferenceTypeAttributes "ReferenceTypeAttributes"
#define OpcUa_BrowseName_ReferenceTypeNode "ReferenceTypeNode"
#define OpcUa_BrowseName_ReferenceTypesFolder "ReferenceTypes"
#define OpcUa_BrowseName_RefreshEndEventType "RefreshEndEventType"
#define OpcUa_BrowseName_RefreshRequiredEventType "RefreshRequiredEventType"
#define OpcUa_BrowseName_RefreshStartEventType "RefreshStartEventType"
#define OpcUa_BrowseName_RegisteredServer "RegisteredServer"
#define OpcUa_BrowseName_RegisterNodesCount "RegisterNodesCount"
#define OpcUa_BrowseName_RegisterNodesRequest "RegisterNodesRequest"
#define OpcUa_BrowseName_RegisterNodesResponse "RegisterNodesResponse"
#define OpcUa_BrowseName_RegisterServer2Request "RegisterServer2Request"
#define OpcUa_BrowseName_RegisterServer2Response "RegisterServer2Response"
#define OpcUa_BrowseName_RegisterServerRequest "RegisterServerRequest"
#define OpcUa_BrowseName_RegisterServerResponse "RegisterServerResponse"
#define OpcUa_BrowseName_RejectedRequestsCount "RejectedRequestsCount"
#define OpcUa_BrowseName_RejectedSessionCount "RejectedSessionCount"
#define OpcUa_BrowseName_RelativePath "RelativePath"
#define OpcUa_BrowseName_RelativePathElement "RelativePathElement"
#define OpcUa_BrowseName_RemoveApplication "RemoveApplication"
#define OpcUa_BrowseName_RemoveCertificate "RemoveCertificate"
#define OpcUa_BrowseName_RemoveConnection "RemoveConnection"
#define OpcUa_BrowseName_RemoveDataSetFolder "RemoveDataSetFolder"
#define OpcUa_BrowseName_RemoveDataSetReader "RemoveDataSetReader"
#define OpcUa_BrowseName_RemoveDataSetWriter "RemoveDataSetWriter"
#define OpcUa_BrowseName_RemoveEndpoint "RemoveEndpoint"
#define OpcUa_BrowseName_RemoveExtensionField "RemoveExtensionField"
#define OpcUa_BrowseName_RemoveFromService "RemoveFromService"
#define OpcUa_BrowseName_RemoveFromService2 "RemoveFromService2"
#define OpcUa_BrowseName_RemoveGroup "RemoveGroup"
#define OpcUa_BrowseName_RemoveIdentity "RemoveIdentity"
#define OpcUa_BrowseName_RemovePublishedDataSet "RemovePublishedDataSet"
#define OpcUa_BrowseName_RemovePushTarget "RemovePushTarget"
#define OpcUa_BrowseName_RemovePushTargetFolder "RemovePushTargetFolder"
#define OpcUa_BrowseName_RemoveRole "RemoveRole"
#define OpcUa_BrowseName_RemoveSecurityGroup "RemoveSecurityGroup"
#define OpcUa_BrowseName_RemoveSecurityGroupFolder "RemoveSecurityGroupFolder"
#define OpcUa_BrowseName_RemoveSubscribedDataSet "RemoveSubscribedDataSet"
#define OpcUa_BrowseName_RemoveTargetVariables "RemoveTargetVariables"
#define OpcUa_BrowseName_RemoveUser "RemoveUser"
#define OpcUa_BrowseName_RemoveVariables "RemoveVariables"
#define OpcUa_BrowseName_ReplaceDataCapability "ReplaceDataCapability"
#define OpcUa_BrowseName_ReplaceEventCapability "ReplaceEventCapability"
#define OpcUa_BrowseName_RepresentsSameEntityAs "RepresentsSameEntityAs"
#define OpcUa_BrowseName_RepresentsSameFunctionalityAs "RepresentsSameFunctionalityAs"
#define OpcUa_BrowseName_RepresentsSameHardwareAs "RepresentsSameHardwareAs"
#define OpcUa_BrowseName_RepublishCount "RepublishCount"
#define OpcUa_BrowseName_RepublishMessageCount "RepublishMessageCount"
#define OpcUa_BrowseName_RepublishMessageRequestCount "RepublishMessageRequestCount"
#define OpcUa_BrowseName_RepublishRequest "RepublishRequest"
#define OpcUa_BrowseName_RepublishRequestCount "RepublishRequestCount"
#define OpcUa_BrowseName_RepublishResponse "RepublishResponse"
#define OpcUa_BrowseName_ReqTimes "ReqTimes"
#define OpcUa_BrowseName_RequestedDeliveryGuarantee "RequestedDeliveryGuarantee"
#define OpcUa_BrowseName_RequestedKeyCount "RequestedKeyCount"
#define OpcUa_BrowseName_RequestedLifetime "RequestedLifetime"
#define OpcUa_BrowseName_RequestHandle "RequestHandle"
#define OpcUa_BrowseName_RequestHeader "RequestHeader"
#define OpcUa_BrowseName_RequestServerStateChange "RequestServerStateChange"
#define OpcUa_BrowseName_RequestTickets "RequestTickets"
#define OpcUa_BrowseName_RequestType "RequestType"
#define OpcUa_BrowseName_Requires "Requires"
#define OpcUa_BrowseName_ResendData "ResendData"
#define OpcUa_BrowseName_ReserveIds "ReserveIds"
#define OpcUa_BrowseName_Reset "Reset"
#define OpcUa_BrowseName_Reset2 "Reset2"
#define OpcUa_BrowseName_ResetToServerDefaults "ResetToServerDefaults"
#define OpcUa_BrowseName_Resources "Resources"
#define OpcUa_BrowseName_ResourceUri "ResourceUri"
#define OpcUa_BrowseName_Respond "Respond"
#define OpcUa_BrowseName_Respond2 "Respond2"
#define OpcUa_BrowseName_ResponseHeader "ResponseHeader"
#define OpcUa_BrowseName_ResponseOptionSet "ResponseOptionSet"
#define OpcUa_BrowseName_RestrictToList "RestrictToList"
#define OpcUa_BrowseName_Result "Result"
#define OpcUa_BrowseName_Resume "Resume"
#define OpcUa_BrowseName_Retain "Retain"
#define OpcUa_BrowseName_RetryInterval "RetryInterval"
#define OpcUa_BrowseName_RevisedSessionTimeout "RevisedSessionTimeout"
#define OpcUa_BrowseName_RoleMappingRuleChangedAuditEventType "RoleMappingRuleChangedAuditEventType"
#define OpcUa_BrowseName_RoleName_Placeholder "<RoleName>"
#define OpcUa_BrowseName_RolePermissionType "RolePermissionType"
#define OpcUa_BrowseName_RoleSet "RoleSet"
#define OpcUa_BrowseName_RoleSetType "RoleSetType"
#define OpcUa_BrowseName_RoleType "RoleType"
#define OpcUa_BrowseName_RootFolder "Root"
#define OpcUa_BrowseName_RsaEncryptedSecret "RsaEncryptedSecret"
#define OpcUa_BrowseName_RsaMinApplicationCertificateType "RsaMinApplicationCertificateType"
#define OpcUa_BrowseName_RsaSha256ApplicationCertificateType "RsaSha256ApplicationCertificateType"
#define OpcUa_BrowseName_Running "Running"
#define OpcUa_BrowseName_RunningToHalted "RunningToHalted"
#define OpcUa_BrowseName_RunningToReady "RunningToReady"
#define OpcUa_BrowseName_RunningToSuspended "RunningToSuspended"
#define OpcUa_BrowseName_SafetyConditionClassType "SafetyConditionClassType"
#define OpcUa_BrowseName_SampledMonitoredItemsCount "SampledMonitoredItemsCount"
#define OpcUa_BrowseName_SamplingInterval "SamplingInterval"
#define OpcUa_BrowseName_SamplingIntervalDiagnostics "SamplingIntervalDiagnostics"
#define OpcUa_BrowseName_SamplingIntervalDiagnosticsArray "SamplingIntervalDiagnosticsArray"
#define OpcUa_BrowseName_SamplingIntervalDiagnosticsArrayType "SamplingIntervalDiagnosticsArrayType"
#define OpcUa_BrowseName_SamplingIntervalDiagnosticsDataType "SamplingIntervalDiagnosticsDataType"
#define OpcUa_BrowseName_SamplingIntervalDiagnosticsType "SamplingIntervalDiagnosticsType"
#define OpcUa_BrowseName_SamplingOffset "SamplingOffset"
#define OpcUa_BrowseName_SByte "SByte"
#define OpcUa_BrowseName_SecondsTillShutdown "SecondsTillShutdown"
#define OpcUa_BrowseName_SecureChannelId "SecureChannelId"
#define OpcUa_BrowseName_SecurityGroupDataType "SecurityGroupDataType"
#define OpcUa_BrowseName_SecurityGroupFolderName_Placeholder "<SecurityGroupFolderName>"
#define OpcUa_BrowseName_SecurityGroupFolderType "SecurityGroupFolderType"
#define OpcUa_BrowseName_SecurityGroupId "SecurityGroupId"
#define OpcUa_BrowseName_SecurityGroupName_Placeholder "<SecurityGroupName>"
#define OpcUa_BrowseName_SecurityGroups "SecurityGroups"
#define OpcUa_BrowseName_SecurityGroupType "SecurityGroupType"
#define OpcUa_BrowseName_SecurityKeyServices "SecurityKeyServices"
#define OpcUa_BrowseName_SecurityMode "SecurityMode"
#define OpcUa_BrowseName_SecurityPolicyUri "SecurityPolicyUri"
#define OpcUa_BrowseName_SecurityRejectedRequestsCount "SecurityRejectedRequestsCount"
#define OpcUa_BrowseName_SecurityRejectedSessionCount "SecurityRejectedSessionCount"
#define OpcUa_BrowseName_SecurityTokenRequestType "SecurityTokenRequestType"
#define OpcUa_BrowseName_SelectedFields "SelectedFields"
#define OpcUa_BrowseName_SelectedResponse "SelectedResponse"
#define OpcUa_BrowseName_SelectionDescriptions "SelectionDescriptions"
#define OpcUa_BrowseName_SelectionListType "SelectionListType"
#define OpcUa_BrowseName_Selections "Selections"
#define OpcUa_BrowseName_SemanticChangeEventType "SemanticChangeEventType"
#define OpcUa_BrowseName_SemanticChangeStructureDataType "SemanticChangeStructureDataType"
#define OpcUa_BrowseName_SemanticVersionString "SemanticVersionString"
#define OpcUa_BrowseName_Server "Server"
#define OpcUa_BrowseName_Server_ServerRedundancy_CurrentServerId "CurrentServerId"
#define OpcUa_BrowseName_Server_ServerRedundancy_RedundantServerArray "RedundantServerArray"
#define OpcUa_BrowseName_Server_ServerRedundancy_ServerNetworkGroups "ServerNetworkGroups"
#define OpcUa_BrowseName_Server_ServerRedundancy_ServerUriArray "ServerUriArray"
#define OpcUa_BrowseName_ServerArray "ServerArray"
#define OpcUa_BrowseName_ServerCapabilities "ServerCapabilities"
#define OpcUa_BrowseName_ServerCapabilitiesType "ServerCapabilitiesType"
#define OpcUa_BrowseName_ServerConfiguration "ServerConfiguration"
#define OpcUa_BrowseName_ServerConfigurationType "ServerConfigurationType"
#define OpcUa_BrowseName_ServerDiagnostics "ServerDiagnostics"
#define OpcUa_BrowseName_ServerDiagnosticsSummary "ServerDiagnosticsSummary"
#define OpcUa_BrowseName_ServerDiagnosticsSummaryDataType "ServerDiagnosticsSummaryDataType"
#define OpcUa_BrowseName_ServerDiagnosticsSummaryType "ServerDiagnosticsSummaryType"
#define OpcUa_BrowseName_ServerDiagnosticsType "ServerDiagnosticsType"
#define OpcUa_BrowseName_ServerId "ServerId"
#define OpcUa_BrowseName_ServerNetworkGroups "ServerNetworkGroups"
#define OpcUa_BrowseName_ServerOnNetwork "ServerOnNetwork"
#define OpcUa_BrowseName_ServerProfileArray "ServerProfileArray"
#define OpcUa_BrowseName_ServerRedundancy "ServerRedundancy"
#define OpcUa_BrowseName_ServerRedundancyType "ServerRedundancyType"
#define OpcUa_BrowseName_ServerState "ServerState"
#define OpcUa_BrowseName_ServerStatus "ServerStatus"
#define OpcUa_BrowseName_ServerStatusDataType "ServerStatusDataType"
#define OpcUa_BrowseName_ServerStatusType "ServerStatusType"
#define OpcUa_BrowseName_ServerTimestampSupported "ServerTimestampSupported"
#define OpcUa_BrowseName_ServerType "ServerType"
#define OpcUa_BrowseName_ServerUri "ServerUri"
#define OpcUa_BrowseName_ServerUriArray "ServerUriArray"
#define OpcUa_BrowseName_ServerVendorCapabilityType "ServerVendorCapabilityType"
#define OpcUa_BrowseName_ServerViewCount "ServerViewCount"
#define OpcUa_BrowseName_ServiceCertificate "ServiceCertificate"
#define OpcUa_BrowseName_ServiceCounterDataType "ServiceCounterDataType"
#define OpcUa_BrowseName_ServiceFault "ServiceFault"
#define OpcUa_BrowseName_ServiceLevel "ServiceLevel"
#define OpcUa_BrowseName_ServiceName_Placeholder "<ServiceName>"
#define OpcUa_BrowseName_ServiceStatus "ServiceStatus"
#define OpcUa_BrowseName_ServiceUri "ServiceUri"
#define OpcUa_BrowseName_SessionAbortCount "SessionAbortCount"
#define OpcUa_BrowseName_SessionAuthenticationToken "SessionAuthenticationToken"
#define OpcUa_BrowseName_SessionDiagnostics "SessionDiagnostics"
#define OpcUa_BrowseName_SessionDiagnosticsArray "SessionDiagnosticsArray"
#define OpcUa_BrowseName_SessionDiagnosticsArrayType "SessionDiagnosticsArrayType"
#define OpcUa_BrowseName_SessionDiagnosticsDataType "SessionDiagnosticsDataType"
#define OpcUa_BrowseName_SessionDiagnosticsObjectType "SessionDiagnosticsObjectType"
#define OpcUa_BrowseName_SessionDiagnosticsVariableType "SessionDiagnosticsVariableType"
#define OpcUa_BrowseName_SessionId "SessionId"
#define OpcUa_BrowseName_SessionlessInvokeRequestType "SessionlessInvokeRequestType"
#define OpcUa_BrowseName_SessionlessInvokeResponseType "SessionlessInvokeResponseType"
#define OpcUa_BrowseName_SessionName "SessionName"
#define OpcUa_BrowseName_SessionsDiagnosticsSummary "SessionsDiagnosticsSummary"
#define OpcUa_BrowseName_SessionsDiagnosticsSummaryType "SessionsDiagnosticsSummaryType"
#define OpcUa_BrowseName_SessionSecurityDiagnostics "SessionSecurityDiagnostics"
#define OpcUa_BrowseName_SessionSecurityDiagnosticsArray "SessionSecurityDiagnosticsArray"
#define OpcUa_BrowseName_SessionSecurityDiagnosticsArrayType "SessionSecurityDiagnosticsArrayType"
#define OpcUa_BrowseName_SessionSecurityDiagnosticsDataType "SessionSecurityDiagnosticsDataType"
#define OpcUa_BrowseName_SessionSecurityDiagnosticsType "SessionSecurityDiagnosticsType"
#define OpcUa_BrowseName_SessionTimeoutCount "SessionTimeoutCount"
#define OpcUa_BrowseName_SetAdminPassword "SetAdminPassword"
#define OpcUa_BrowseName_SetMonitoringModeCount "SetMonitoringModeCount"
#define OpcUa_BrowseName_SetMonitoringModeRequest "SetMonitoringModeRequest"
#define OpcUa_BrowseName_SetMonitoringModeResponse "SetMonitoringModeResponse"
#define OpcUa_BrowseName_SetpointNode "SetpointNode"
#define OpcUa_BrowseName_SetPosition "SetPosition"
#define OpcUa_BrowseName_SetPublishingModeCount "SetPublishingModeCount"
#define OpcUa_BrowseName_SetPublishingModeRequest "SetPublishingModeRequest"
#define OpcUa_BrowseName_SetPublishingModeResponse "SetPublishingModeResponse"
#define OpcUa_BrowseName_SetRegistrarEndpoints "SetRegistrarEndpoints"
#define OpcUa_BrowseName_SetSecurityKeys "SetSecurityKeys"
#define OpcUa_BrowseName_SetSubscriptionDurable "SetSubscriptionDurable"
#define OpcUa_BrowseName_SetTriggeringCount "SetTriggeringCount"
#define OpcUa_BrowseName_SetTriggeringRequest "SetTriggeringRequest"
#define OpcUa_BrowseName_SetTriggeringResponse "SetTriggeringResponse"
#define OpcUa_BrowseName_Severity "Severity"
#define OpcUa_BrowseName_SeverityHigh "SeverityHigh"
#define OpcUa_BrowseName_SeverityHighHigh "SeverityHighHigh"
#define OpcUa_BrowseName_SeverityLow "SeverityLow"
#define OpcUa_BrowseName_SeverityLowLow "SeverityLowLow"
#define OpcUa_BrowseName_ShelvedStateMachineType "ShelvedStateMachineType"
#define OpcUa_BrowseName_ShelvingState "ShelvingState"
#define OpcUa_BrowseName_ShelvingTime "ShelvingTime"
#define OpcUa_BrowseName_ShutdownReason "ShutdownReason"
#define OpcUa_BrowseName_SignatureData "SignatureData"
#define OpcUa_BrowseName_SignedSoftwareCertificate "SignedSoftwareCertificate"
#define OpcUa_BrowseName_Silence "Silence"
#define OpcUa_BrowseName_SilenceState "SilenceState"
#define OpcUa_BrowseName_SimpleAttributeOperand "SimpleAttributeOperand"
#define OpcUa_BrowseName_SimpleTypeDescription "SimpleTypeDescription"
#define OpcUa_BrowseName_Size "Size"
#define OpcUa_BrowseName_SoftwareCertificates "SoftwareCertificates"
#define OpcUa_BrowseName_SoftwareVersion "SoftwareVersion"
#define OpcUa_BrowseName_SourceAddress "SourceAddress"
#define OpcUa_BrowseName_SourceName "SourceName"
#define OpcUa_BrowseName_SourceNode "SourceNode"
#define OpcUa_BrowseName_SourceTimestamp "SourceTimestamp"
#define OpcUa_BrowseName_Speed "Speed"
#define OpcUa_BrowseName_SrClassId "SrClassId"
#define OpcUa_BrowseName_StandaloneSubscribedDataSetDataType "StandaloneSubscribedDataSetDataType"
#define OpcUa_BrowseName_StandaloneSubscribedDataSetName_Placeholder "<StandaloneSubscribedDataSetName>"
#define OpcUa_BrowseName_StandaloneSubscribedDataSetRefDataType "StandaloneSubscribedDataSetRefDataType"
#define OpcUa_BrowseName_StandaloneSubscribedDataSetType "StandaloneSubscribedDataSetType"
#define OpcUa_BrowseName_Start "Start"
#define OpcUa_BrowseName_StartOfArchive "StartOfArchive"
#define OpcUa_BrowseName_StartOfOnlineArchive "StartOfOnlineArchive"
#define OpcUa_BrowseName_StartTime "StartTime"
#define OpcUa_BrowseName_State "State"
#define OpcUa_BrowseName_StateMachineType "StateMachineType"
#define OpcUa_BrowseName_StateNumber "StateNumber"
#define OpcUa_BrowseName_StateType "StateType"
#define OpcUa_BrowseName_StateVariableType "StateVariableType"
#define OpcUa_BrowseName_StaticNodeIdTypes "StaticNodeIdTypes"
#define OpcUa_BrowseName_StaticNumericNodeIdRange "StaticNumericNodeIdRange"
#define OpcUa_BrowseName_StaticStringNodeIdPattern "StaticStringNodeIdPattern"
#define OpcUa_BrowseName_StatisticalConditionClassType "StatisticalConditionClassType"
#define OpcUa_BrowseName_Status "Status"
#define OpcUa_BrowseName_StatusChangeNotification "StatusChangeNotification"
#define OpcUa_BrowseName_StatusCode "StatusCode"
#define OpcUa_BrowseName_StatusCodeId "StatusCodeId"
#define OpcUa_BrowseName_StatusResult "StatusResult"
#define OpcUa_BrowseName_Stepped "Stepped"
#define OpcUa_BrowseName_StreamId "StreamId"
#define OpcUa_BrowseName_StreamName "StreamName"
#define OpcUa_BrowseName_Streams "Streams"
#define OpcUa_BrowseName_String "String"
#define OpcUa_BrowseName_Structure "Structure"
#define OpcUa_BrowseName_StructureDefinition "StructureDefinition"
#define OpcUa_BrowseName_StructureDescription "StructureDescription"
#define OpcUa_BrowseName_StructureField "StructureField"
#define OpcUa_BrowseName_StructureType "StructureType"
#define OpcUa_BrowseName_SubAliasNameCategories_Placeholder "<SubAliasNameCategories>"
#define OpcUa_BrowseName_SubError "SubError"
#define OpcUa_BrowseName_SubscribedDataSet "SubscribedDataSet"
#define OpcUa_BrowseName_SubscribedDataSetDataType "SubscribedDataSetDataType"
#define OpcUa_BrowseName_SubscribedDataSetFolderName_Placeholder "<SubscribedDataSetFolderName>"
#define OpcUa_BrowseName_SubscribedDataSetFolderType "SubscribedDataSetFolderType"
#define OpcUa_BrowseName_SubscribedDataSetMirrorDataType "SubscribedDataSetMirrorDataType"
#define OpcUa_BrowseName_SubscribedDataSetMirrorType "SubscribedDataSetMirrorType"
#define OpcUa_BrowseName_SubscribedDataSets "SubscribedDataSets"
#define OpcUa_BrowseName_SubscribedDataSetType "SubscribedDataSetType"
#define OpcUa_BrowseName_SubscriptionAcknowledgement "SubscriptionAcknowledgement"
#define OpcUa_BrowseName_SubscriptionDiagnostics "SubscriptionDiagnostics"
#define OpcUa_BrowseName_SubscriptionDiagnosticsArray "SubscriptionDiagnosticsArray"
#define OpcUa_BrowseName_SubscriptionDiagnosticsArrayType "SubscriptionDiagnosticsArrayType"
#define OpcUa_BrowseName_SubscriptionDiagnosticsDataType "SubscriptionDiagnosticsDataType"
#define OpcUa_BrowseName_SubscriptionDiagnosticsType "SubscriptionDiagnosticsType"
#define OpcUa_BrowseName_SubscriptionId "SubscriptionId"
#define OpcUa_BrowseName_SupportedPrivateKeyFormats "SupportedPrivateKeyFormats"
#define OpcUa_BrowseName_SupportedSecurityPolicyUris "SupportedSecurityPolicyUris"
#define OpcUa_BrowseName_SupportedTransportProfiles "SupportedTransportProfiles"
#define OpcUa_BrowseName_SupportSecurityKeyPull "SupportSecurityKeyPull"
#define OpcUa_BrowseName_SupportSecurityKeyPush "SupportSecurityKeyPush"
#define OpcUa_BrowseName_SupportsFilteredRetain "SupportsFilteredRetain"
#define OpcUa_BrowseName_Suppress "Suppress"
#define OpcUa_BrowseName_Suppress2 "Suppress2"
#define OpcUa_BrowseName_SuppressedOrShelved "SuppressedOrShelved"
#define OpcUa_BrowseName_SuppressedState "SuppressedState"
#define OpcUa_BrowseName_Suspend "Suspend"
#define OpcUa_BrowseName_Suspended "Suspended"
#define OpcUa_BrowseName_SuspendedToHalted "SuspendedToHalted"
#define OpcUa_BrowseName_SuspendedToReady "SuspendedToReady"
#define OpcUa_BrowseName_SuspendedToRunning "SuspendedToRunning"
#define OpcUa_BrowseName_SystemConditionClassType "SystemConditionClassType"
#define OpcUa_BrowseName_SystemDiagnosticAlarmType "SystemDiagnosticAlarmType"
#define OpcUa_BrowseName_SystemEventType "SystemEventType"
#define OpcUa_BrowseName_SystemOffNormalAlarmType "SystemOffNormalAlarmType"
#define OpcUa_BrowseName_SystemState "SystemState"
#define OpcUa_BrowseName_SystemStatusChangeEventType "SystemStatusChangeEventType"
#define OpcUa_BrowseName_TagVariables "TagVariables"
#define OpcUa_BrowseName_TalkerStatus "TalkerStatus"
#define OpcUa_BrowseName_TalkerStreams "TalkerStreams"
#define OpcUa_BrowseName_TargetValueNode "TargetValueNode"
#define OpcUa_BrowseName_TargetVariables "TargetVariables"
#define OpcUa_BrowseName_TargetVariablesDataType "TargetVariablesDataType"
#define OpcUa_BrowseName_TargetVariablesType "TargetVariablesType"
#define OpcUa_BrowseName_TemporaryFileTransferType "TemporaryFileTransferType"
#define OpcUa_BrowseName_TestingConditionClassType "TestingConditionClassType"
#define OpcUa_BrowseName_ThreeDCartesianCoordinates "3DCartesianCoordinates"
#define OpcUa_BrowseName_ThreeDCartesianCoordinatesType "3DCartesianCoordinatesType"
#define OpcUa_BrowseName_ThreeDFrame "3DFrame"
#define OpcUa_BrowseName_ThreeDFrameType "3DFrameType"
#define OpcUa_BrowseName_ThreeDOrientation "3DOrientation"
#define OpcUa_BrowseName_ThreeDOrientationType "3DOrientationType"
#define OpcUa_BrowseName_ThreeDVector "3DVector"
#define OpcUa_BrowseName_ThreeDVectorType "3DVectorType"
#define OpcUa_BrowseName_Time "Time"
#define OpcUa_BrowseName_TimeAwareOffset "TimeAwareOffset"
#define OpcUa_BrowseName_TimedShelve "TimedShelve"
#define OpcUa_BrowseName_TimedShelve2 "TimedShelve2"
#define OpcUa_BrowseName_TimedShelved "TimedShelved"
#define OpcUa_BrowseName_TimedShelvedToOneShotShelved "TimedShelvedToOneShotShelved"
#define OpcUa_BrowseName_TimedShelvedToUnshelved "TimedShelvedToUnshelved"
#define OpcUa_BrowseName_TimeFirstChange "TimeFirstChange"
#define OpcUa_BrowseName_TimestampsToReturn "TimestampsToReturn"
#define OpcUa_BrowseName_TimeString "TimeString"
#define OpcUa_BrowseName_TimeZoneDataType "TimeZoneDataType"
#define OpcUa_BrowseName_Title "Title"
#define OpcUa_BrowseName_Tolerance "Tolerance"
#define OpcUa_BrowseName_Topic "Topic"
#define OpcUa_BrowseName_Topics "Topics"
#define OpcUa_BrowseName_ToState "ToState"
#define OpcUa_BrowseName_TotalError "TotalError"
#define OpcUa_BrowseName_TotalInformation "TotalInformation"
#define OpcUa_BrowseName_TotalRequestCount "TotalRequestCount"
#define OpcUa_BrowseName_TrainingConditionClassType "TrainingConditionClassType"
#define OpcUa_BrowseName_TransactionDiagnostics "TransactionDiagnostics"
#define OpcUa_BrowseName_TransactionDiagnosticsType "TransactionDiagnosticsType"
#define OpcUa_BrowseName_TransactionErrorType "TransactionErrorType"
#define OpcUa_BrowseName_TransferredToAltClientCount "TransferredToAltClientCount"
#define OpcUa_BrowseName_TransferredToSameClientCount "TransferredToSameClientCount"
#define OpcUa_BrowseName_TransferRequestCount "TransferRequestCount"
#define OpcUa_BrowseName_TransferResult "TransferResult"
#define OpcUa_BrowseName_TransferState_Placeholder "<TransferState>"
#define OpcUa_BrowseName_TransferSubscriptionsCount "TransferSubscriptionsCount"
#define OpcUa_BrowseName_TransferSubscriptionsRequest "TransferSubscriptionsRequest"
#define OpcUa_BrowseName_TransferSubscriptionsResponse "TransferSubscriptionsResponse"
#define OpcUa_BrowseName_Transition "Transition"
#define OpcUa_BrowseName_TransitionEventType "TransitionEventType"
#define OpcUa_BrowseName_TransitionNumber "TransitionNumber"
#define OpcUa_BrowseName_TransitionTime "TransitionTime"
#define OpcUa_BrowseName_TransitionType "TransitionType"
#define OpcUa_BrowseName_TransitionVariableType "TransitionVariableType"
#define OpcUa_BrowseName_TranslateBrowsePathsToNodeIdsCount "TranslateBrowsePathsToNodeIdsCount"
#define OpcUa_BrowseName_TranslateBrowsePathsToNodeIdsRequest "TranslateBrowsePathsToNodeIdsRequest"
#define OpcUa_BrowseName_TranslateBrowsePathsToNodeIdsResponse "TranslateBrowsePathsToNodeIdsResponse"
#define OpcUa_BrowseName_TransmitQosDataType "TransmitQosDataType"
#define OpcUa_BrowseName_TransmitQosPriorityDataType "TransmitQosPriorityDataType"
#define OpcUa_BrowseName_TransparentRedundancyType "TransparentRedundancyType"
#define OpcUa_BrowseName_TransportProfileUri "TransportProfileUri"
#define OpcUa_BrowseName_TransportProtocol "TransportProtocol"
#define OpcUa_BrowseName_TransportSettings "TransportSettings"
#define OpcUa_BrowseName_TreatUncertainAsBad "TreatUncertainAsBad"
#define OpcUa_BrowseName_TriggerKeyUpdate "TriggerKeyUpdate"
#define OpcUa_BrowseName_TrimmedString "TrimmedString"
#define OpcUa_BrowseName_TripAlarmType "TripAlarmType"
#define OpcUa_BrowseName_TrueState "TrueState"
#define OpcUa_BrowseName_TrustList "TrustList"
#define OpcUa_BrowseName_TrustListDataType "TrustListDataType"
#define OpcUa_BrowseName_TrustListId "TrustListId"
#define OpcUa_BrowseName_TrustListMasks "TrustListMasks"
#define OpcUa_BrowseName_TrustListOutOfDate "TrustListOutOfDate"
#define OpcUa_BrowseName_TrustListOutOfDateAlarmType "TrustListOutOfDateAlarmType"
#define OpcUa_BrowseName_TrustListType "TrustListType"
#define OpcUa_BrowseName_TrustListUpdatedAuditEventType "TrustListUpdatedAuditEventType"
#define OpcUa_BrowseName_TrustListUpdateRequestedAuditEventType "TrustListUpdateRequestedAuditEventType"
#define OpcUa_BrowseName_TrustListValidationOptions "TrustListValidationOptions"
#define OpcUa_BrowseName_TsnFailureCode "TsnFailureCode"
#define OpcUa_BrowseName_TsnListenerStatus "TsnListenerStatus"
#define OpcUa_BrowseName_TsnStreamState "TsnStreamState"
#define OpcUa_BrowseName_TsnTalkerStatus "TsnTalkerStatus"
#define OpcUa_BrowseName_TwoStateDiscreteType "TwoStateDiscreteType"
#define OpcUa_BrowseName_TwoStateVariableType "TwoStateVariableType"
#define OpcUa_BrowseName_TypeNode "TypeNode"
#define OpcUa_BrowseName_TypesFolder "Types"
#define OpcUa_BrowseName_UABinaryFileDataType "UABinaryFileDataType"
#define OpcUa_BrowseName_UadpDataSetMessageContentMask "UadpDataSetMessageContentMask"
#define OpcUa_BrowseName_UadpDataSetReaderMessageDataType "UadpDataSetReaderMessageDataType"
#define OpcUa_BrowseName_UadpDataSetReaderMessageType "UadpDataSetReaderMessageType"
#define OpcUa_BrowseName_UadpDataSetWriterMessageDataType "UadpDataSetWriterMessageDataType"
#define OpcUa_BrowseName_UadpDataSetWriterMessageType "UadpDataSetWriterMessageType"
#define OpcUa_BrowseName_UadpNetworkMessageContentMask "UadpNetworkMessageContentMask"
#define OpcUa_BrowseName_UadpWriterGroupMessageDataType "UadpWriterGroupMessageDataType"
#define OpcUa_BrowseName_UadpWriterGroupMessageType "UadpWriterGroupMessageType"
#define OpcUa_BrowseName_UInt16 "UInt16"
#define OpcUa_BrowseName_UInt32 "UInt32"
#define OpcUa_BrowseName_UInt64 "UInt64"
#define OpcUa_BrowseName_UInteger "UInteger"
#define OpcUa_BrowseName_UnacknowledgedCount "UnacknowledgedCount"
#define OpcUa_BrowseName_UnacknowledgedMessageCount "UnacknowledgedMessageCount"
#define OpcUa_BrowseName_UnauthorizedRequestCount "UnauthorizedRequestCount"
#define OpcUa_BrowseName_UnconfirmedCount "UnconfirmedCount"
#define OpcUa_BrowseName_Union "Union"
#define OpcUa_BrowseName_UnregisterNodesCount "UnregisterNodesCount"
#define OpcUa_BrowseName_UnregisterNodesRequest "UnregisterNodesRequest"
#define OpcUa_BrowseName_UnregisterNodesResponse "UnregisterNodesResponse"
#define OpcUa_BrowseName_Unshelve "Unshelve"
#define OpcUa_BrowseName_Unshelve2 "Unshelve2"
#define OpcUa_BrowseName_Unshelved "Unshelved"
#define OpcUa_BrowseName_UnshelvedToOneShotShelved "UnshelvedToOneShotShelved"
#define OpcUa_BrowseName_UnshelvedToTimedShelved "UnshelvedToTimedShelved"
#define OpcUa_BrowseName_UnshelveTime "UnshelveTime"
#define OpcUa_BrowseName_UnsignedRationalNumber "UnsignedRationalNumber"
#define OpcUa_BrowseName_Unsuppress "Unsuppress"
#define OpcUa_BrowseName_Unsuppress2 "Unsuppress2"
#define OpcUa_BrowseName_UpdateCertificate "UpdateCertificate"
#define OpcUa_BrowseName_UpdateCredential "UpdateCredential"
#define OpcUa_BrowseName_UpdateDataCapability "UpdateDataCapability"
#define OpcUa_BrowseName_UpdateDataDetails "UpdateDataDetails"
#define OpcUa_BrowseName_UpdatedNode "UpdatedNode"
#define OpcUa_BrowseName_UpdateEventCapability "UpdateEventCapability"
#define OpcUa_BrowseName_UpdateEventDetails "UpdateEventDetails"
#define OpcUa_BrowseName_UpdateFrequency "UpdateFrequency"
#define OpcUa_BrowseName_UpdateStructureDataDetails "UpdateStructureDataDetails"
#define OpcUa_BrowseName_UriDictionaryEntryType "UriDictionaryEntryType"
#define OpcUa_BrowseName_UriString "UriString"
#define OpcUa_BrowseName_UrisVersion "UrisVersion"
#define OpcUa_BrowseName_Url "Url"
#define OpcUa_BrowseName_UserConfigurationMask "UserConfigurationMask"
#define OpcUa_BrowseName_UserCredentialCertificateType "UserCredentialCertificateType"
#define OpcUa_BrowseName_UserIdentityToken "UserIdentityToken"
#define OpcUa_BrowseName_UserManagement "UserManagement"
#define OpcUa_BrowseName_UserManagementDataType "UserManagementDataType"
#define OpcUa_BrowseName_UserManagementType "UserManagementType"
#define OpcUa_BrowseName_UserNameIdentityToken "UserNameIdentityToken"
#define OpcUa_BrowseName_Users "Users"
#define OpcUa_BrowseName_UserTokenPolicy "UserTokenPolicy"
#define OpcUa_BrowseName_UserTokenType "UserTokenType"
#define OpcUa_BrowseName_UserWritable "UserWritable"
#define OpcUa_BrowseName_UseSlopedExtrapolation "UseSlopedExtrapolation"
#define OpcUa_BrowseName_UsesPriorityMappingTable "UsesPriorityMappingTable"
#define OpcUa_BrowseName_UtcTime "UtcTime"
#define OpcUa_BrowseName_Utilizes "Utilizes"
#define OpcUa_BrowseName_ValueAsDictionaryEntries "ValueAsDictionaryEntries"
#define OpcUa_BrowseName_ValueAsText "ValueAsText"
#define OpcUa_BrowseName_ValuePrecision "ValuePrecision"
#define OpcUa_BrowseName_VariableAttributes "VariableAttributes"
#define OpcUa_BrowseName_VariableNode "VariableNode"
#define OpcUa_BrowseName_VariableTypeAttributes "VariableTypeAttributes"
#define OpcUa_BrowseName_VariableTypeNode "VariableTypeNode"
#define OpcUa_BrowseName_VariableTypesFolder "VariableTypes"
#define OpcUa_BrowseName_Vector "Vector"
#define OpcUa_BrowseName_VectorType "VectorType"
#define OpcUa_BrowseName_VectorUnit "VectorUnit"
#define OpcUa_BrowseName_VendorCapability_Placeholder "<VendorCapability>"
#define OpcUa_BrowseName_VendorServerInfo "VendorServerInfo"
#define OpcUa_BrowseName_VendorServerInfoType "VendorServerInfoType"
#define OpcUa_BrowseName_VersionId "VersionId"
#define OpcUa_BrowseName_VersionTime "VersionTime"
#define OpcUa_BrowseName_Vid "Vid"
#define OpcUa_BrowseName_ViewAttributes "ViewAttributes"
#define OpcUa_BrowseName_ViewDescription "ViewDescription"
#define OpcUa_BrowseName_ViewNode "ViewNode"
#define OpcUa_BrowseName_ViewsFolder "Views"
#define OpcUa_BrowseName_ViewVersion "ViewVersion"
#define OpcUa_BrowseName_VlanId "VlanId"
#define OpcUa_BrowseName_VlanTagCapable "VlanTagCapable"
#define OpcUa_BrowseName_WellKnownRole_Anonymous "Anonymous"
#define OpcUa_BrowseName_WellKnownRole_AuthenticatedUser "AuthenticatedUser"
#define OpcUa_BrowseName_WellKnownRole_ConfigureAdmin "ConfigureAdmin"
#define OpcUa_BrowseName_WellKnownRole_Engineer "Engineer"
#define OpcUa_BrowseName_WellKnownRole_Observer "Observer"
#define OpcUa_BrowseName_WellKnownRole_Operator "Operator"
#define OpcUa_BrowseName_WellKnownRole_SecurityAdmin "SecurityAdmin"
#define OpcUa_BrowseName_WellKnownRole_SecurityKeyServerAccess "SecurityKeyServerAccess"
#define OpcUa_BrowseName_WellKnownRole_SecurityKeyServerAdmin "SecurityKeyServerAdmin"
#define OpcUa_BrowseName_WellKnownRole_SecurityKeyServerPush "SecurityKeyServerPush"
#define OpcUa_BrowseName_WellKnownRole_Supervisor "Supervisor"
#define OpcUa_BrowseName_Writable "Writable"
#define OpcUa_BrowseName_Write "Write"
#define OpcUa_BrowseName_WriteCount "WriteCount"
#define OpcUa_BrowseName_WriteRequest "WriteRequest"
#define OpcUa_BrowseName_WriteResponse "WriteResponse"
#define OpcUa_BrowseName_WriterGroupDataType "WriterGroupDataType"
#define OpcUa_BrowseName_WriterGroupId "WriterGroupId"
#define OpcUa_BrowseName_WriterGroupMessageDataType "WriterGroupMessageDataType"
#define OpcUa_BrowseName_WriterGroupMessageType "WriterGroupMessageType"
#define OpcUa_BrowseName_WriterGroupName_Placeholder "<WriterGroupName>"
#define OpcUa_BrowseName_WriterGroupTransportDataType "WriterGroupTransportDataType"
#define OpcUa_BrowseName_WriterGroupTransportType "WriterGroupTransportType"
#define OpcUa_BrowseName_WriterGroupType "WriterGroupType"
#define OpcUa_BrowseName_WriteValue "WriteValue"
#define OpcUa_BrowseName_X "X"
#define OpcUa_BrowseName_X509IdentityToken "X509IdentityToken"
#define OpcUa_BrowseName_XAxisDefinition "XAxisDefinition"
#define OpcUa_BrowseName_XmlElement "XmlElement"
#define OpcUa_BrowseName_XmlSchema_TypeSystem "XML Schema"
#define OpcUa_BrowseName_XVType "XVType"
#define OpcUa_BrowseName_XYArrayItemType "XYArrayItemType"
#define OpcUa_BrowseName_Y "Y"
#define OpcUa_BrowseName_YArrayItemType "YArrayItemType"
#define OpcUa_BrowseName_YAxisDefinition "YAxisDefinition"
#define OpcUa_BrowseName_Z "Z"
#define OpcUa_BrowseName_ZAxisDefinition "ZAxisDefinition"

#endif /* _OpcUa_BrowseNames_H_ */
/* This is the last line of an autogenerated file. */
