# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hybridconnectivity.aio import HybridConnectivityMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHybridConnectivityMgmtEndpointsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HybridConnectivityMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_endpoints_get(self, resource_group):
        response = await self.client.endpoints.get(
            resource_uri="str",
            endpoint_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_endpoints_create_or_update(self, resource_group):
        response = await self.client.endpoints.create_or_update(
            resource_uri="str",
            endpoint_name="str",
            endpoint_resource={
                "id": "str",
                "name": "str",
                "properties": {"type": "str", "provisioningState": "str", "resourceId": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_endpoints_update(self, resource_group):
        response = await self.client.endpoints.update(
            resource_uri="str",
            endpoint_name="str",
            endpoint_resource={
                "id": "str",
                "name": "str",
                "properties": {"type": "str", "provisioningState": "str", "resourceId": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_endpoints_delete(self, resource_group):
        response = await self.client.endpoints.delete(
            resource_uri="str",
            endpoint_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_endpoints_list(self, resource_group):
        response = self.client.endpoints.list(
            resource_uri="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_endpoints_list_credentials(self, resource_group):
        response = await self.client.endpoints.list_credentials(
            resource_uri="str",
            endpoint_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_endpoints_list_ingress_gateway_credentials(self, resource_group):
        response = await self.client.endpoints.list_ingress_gateway_credentials(
            resource_uri="str",
            endpoint_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_endpoints_list_managed_proxy_details(self, resource_group):
        response = await self.client.endpoints.list_managed_proxy_details(
            resource_uri="str",
            endpoint_name="str",
            managed_proxy_request={"service": "str", "hostname": "str", "serviceName": "str"},
        )

        # please add some check logic here by yourself
        # ...
