% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene.R
\name{glance.levene}
\alias{glance.levene}
\title{Glance at a \code{levene} object}
\usage{
\method{glance}{levene}(x, ...)
}
\arguments{
\item{x}{a \code{levene} object returned from \code{\link{levene_test}}}

\item{...}{Additional arguments. Not used. Included only to match generic
signature.}
}
\value{
A one-row \code{\link[tibble:tibble]{tibble::tibble}} with the following
columns:

\item{\code{alpha}}{the value of alpha specified}
\item{\code{modcv}}{a logical value indicating whether the modified
                    CV approach was used.}
\item{\code{n}}{the total number of observations}
\item{\code{k}}{the number of groups}
\item{\code{f}}{the value of the F test statistic}
\item{\code{p}}{the computed p-value}
\item{\code{reject_equal_variance}}{a boolean value indicating whether the
      null hypothesis that all samples have the same variance is rejected}
}
\description{
Glance accepts an object of type \code{levene} and returns a
\code{\link[tibble:tibble]{tibble::tibble}} with
one row of summaries.

Glance does not do any calculations: it just gathers the results in a
tibble.
}
\examples{
df <- data.frame(
  groups = c(rep("A", 5), rep("B", 6)),
  strength = c(rnorm(5, 100, 6), rnorm(6, 105, 7))
)
levene_result <- levene_test(df, strength, groups)
glance(levene_result)

## # A tibble: 1 x 7
##   alpha modcv     n     k      f     p reject_equal_variance
##   <dbl> <lgl> <int> <int>  <dbl> <dbl> <lgl>
## 1  0.05 FALSE    11     2 0.0191 0.893 FALSE

}
\seealso{
\code{\link{levene_test}}
}
