% This LilyPond file was generated by Rosegarden 23.06
\include "nederlands.ly"
\version "2.12.0"
\header {
    composer = "Steve Conrad"
    copyright = "2004"
    title = "Bogus Surf Jam"
    tagline = "Created using Rosegarden 23.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 4/4
    \skip 1*192 
}
globalTempo = {
    \override Score.MetronomeMark #'transparent = ##t
    \tempo 4 = 150  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn #'force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering #'staff-padding = #'()

        \context Staff = "track 1, od gtr" << 
            \set Staff.instrumentName = \markup { \center-column { "od gtr " } }
            \set Staff.midiInstrument = "Distortion Guitar"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 0.0" {
                % Segment: Overdrive Guitar
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'numbered 
                \time 4/4
                
                R1 \sustainOff  |
            } % Voice

            % End of segment Overdrive Guitar

            \context Voice = "voice 0.0" {
                % Segment: theme 2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*12 
                \clef "treble_8"
                \key g \minor
                g' 8 ^( [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
%% 15
                bes' 8 ^( [ d'' ] bes' 16 [ d'' bes' f' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
                g' 8 ^( [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' ^( c' ) ] d' ^( [ bes ) ] g 4 _~  |
                g 1  |
%% 20
                r8 r r4 r8 r r f _( _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _( _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d _( c a, ) ] fis, _( [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2

            \context Voice = "voice 0.0" {
                % Segment: theme 2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*36 
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
                bes' 8 [ d'' ] bes' 16 [ d'' bes' f' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
%% 40
                bes' 1 )  |
                g' 8 [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
                g 1  |
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
%% 45
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2

            \context Voice = "voice 0.0" {
                % Segment: theme 2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*60 
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
                bes' 8 [ d'' ] bes' 16 [ d'' bes' f' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
%% 65
                g' 8 [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
                g 1  |
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
%% 70
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2

            \context Voice = "voice 0.0" {
                % Segment: theme 2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*84 
%% 85
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
                bes' 8 [ d'' ] bes' 16 [ d'' bes' f' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
                g' 8 [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
%% 90
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
                g 1  |
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
%% 95
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2

            \context Voice = "voice 0.0" {
                % Segment: theme 2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*108 
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
%% 110
                g' 1 )  |
                bes' 8 [ d'' ] bes' 16 [ d'' bes' f' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
                g' 8 [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
%% 115
                g 1  |
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
%% 120
                d, 1 )  |
            } % Voice

            % End of segment theme 2

            \context Voice = "voice 0.0" {
                % Segment: plausible
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*120 
                \clef "treble_8"
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r2  |
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r8 r r b 16 [ c' ]  |
%% 125
                \times 2/3 { des' 32 [ d' ees' _~ ] } ees' 16 bes g ees c 8 _~ c 8. bes, 16 b, c 8 ees 16 b,  |
                c 8 d 4 bes, 16 [ g, ] g 4 r  |
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r8 r r e 16 [ f ]  |
                \times 2/3 { fis 32 [ g a _~ ] } a 16 ees c a, f, 8. r8 r r d 16 [ ees ]  |
%% 130
                \times 2/3 { e 32 [ f g _~ ] } g 16 des bes, g, ees, 8. r8 r r des 16 [ d ]  |
                \times 2/3 { ees 32 [ e fis _~ ] } fis 16 c a, fis, d, 8. r4 r8 c 16 [ des ]  |
                d 16 [ ees fis g ] a [ bes c' des' ] des' 8 r r4  |
            } % Voice

            % End of segment plausible

            \context Voice = "voice 0.0" {
                % Segment: theme 2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*132 
                \clef "treble_8"
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
%% 135
                bes' 8 [ d'' bes' d'' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
                g 1  |
%% 140
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2

            \context Voice = "voice 0.0" {
                % Segment: implausible
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*144 
%% 145
                \clef "treble_8"
                \times 2/3 { bes 16 [ c' d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { bes 32 [ c' des' 16 d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { bes [ c' d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { e' 8 [ f' g' ] }  |
                \times 2/3 { bes' 16 [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { bes' [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { bes' [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { a' 8 [ bes' c'' ] }  |
                \times 2/3 { d'' 16 [ g' bes' ] } \times 2/3 { g' [ d' f' ] } \times 2/3 { g' [ g bes ] } \times 2/3 { g [ d f ] } \times 2/3 { d' [ g bes ] } \times 2/3 { g' [ d' f' ] } \times 2/3 { g'' [ g' bes' ] } \times 2/3 { g' [ d' f' ] }  |
                \times 2/3 { d'' 16 [ g' bes' ] } \times 2/3 { g' [ d' f' ] } \times 2/3 { g' [ g bes ] } \times 2/3 { g [ d f ] } \times 2/3 { d [ g, bes, ] } \times 2/3 { g, [ d, f, ] } \times 2/3 { g, 8 [ bes, b, ] }  |
                \times 2/3 { c 8 [ d ees ] } f 16 fis fis bes \times 2/3 { g' [ ees' fis' ] } \times 2/3 { bes [ c' ees' ] } \times 2/3 { d' 8 [ c' bes ] }  |
%% 150
                \times 2/3 { bes' 16 [ g' a' ] } \times 2/3 { c' [ ees' f' ] } \times 2/3 { ees' 8 [ f' g' ] } \times 2/3 { des'' 16 [ bes' c'' ] } \times 2/3 { ees' [ fis' aes' ] } \times 2/3 { fis' 8 [ aes' bes' ] }  |
                \times 2/3 { ees'' 16 [ c'' d'' ] } \times 2/3 { f' [ aes' bes' ] } \times 2/3 { aes' 8 [ bes' c'' ] } \times 2/3 { f'' 16 [ d'' e'' ] } \times 2/3 { g' [ bes' c'' ] } \times 2/3 { bes' 8 [ c'' d'' ] }  |
                \times 2/3 { g'' 16 [ f'' d'' ] } \times 2/3 { c'' [ bes' g' ] } \times 2/3 { f' [ d' c' ] } \times 2/3 { bes [ g f ] } \times 2/3 { d [ c b, ] } \times 2/3 { g, [ f, d, ] } r8 r  |
                \times 2/3 { aes 16 [ bes c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { aes 32 [ bes b 16 c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { aes [ bes c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { d' 8 [ ees' f' ] }  |
                \times 2/3 { fis 16 [ aes bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { fis 32 [ aes a 16 bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { fis [ aes bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { c' 8 [ des' ees' ] }  |
%% 155
                \times 2/3 { f 16 [ g a ] } \times 2/3 { c' [ a a ] } \times 2/3 { f 32 [ g aes 16 a ] } \times 2/3 { c' [ a a ] } \times 2/3 { f [ g a ] } \times 2/3 { c' [ a a ] } \times 2/3 { b 8 [ c' d' ] }  |
                \times 2/3 { fis' 16 [ ees' d' ] } \times 2/3 { c' [ bes a ] } \times 2/3 { fis [ ees d ] } \times 2/3 { c [ bes, a, ] } \times 2/3 { fis, [ ees, d, ] } \times 2/3 { c, [ bes,, a,, ] } g,, 8 r  |
            } % Voice

            % End of segment implausible

            \context Voice = "voice 0.0" {
                % Segment: MIDI soundcard synth #6 (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*167 
                \clef "treble"
                \key g \minor
                r2 r4 r8 \times 2/3 { f' 16 [ ees' d' ] }  |
            } % Voice

            % End of segment MIDI soundcard synth #6 (split)

            \context Voice = "voice 0.0" {
                % Segment: theme 1 8va (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*168 
                \clef "treble"
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
%% 170
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                ees'' 8 [ ees'' g'' bes'' ] a'' [ a'' bes'' g'' ]  |
                ees'' 8 [ ees'' g'' bes'' ] a'' 4. \times 2/3 { bes'' 16 [ a'' g'' ] }  |
%% 175
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                a' 8 [ a' c'' ees'' ] d'' [ d'' ees'' c'' ]  |
                g' 8 [ g' bes' des'' ] c'' 4. \times 2/3 { des'' 16 [ c'' bes' ] }  |
                fis' 8 [ fis' a' c'' ] e'' [ e'' d'' c'' ]  |
%% 180
                bes' 8 c'' a' f' fis' 4. \times 2/3 { f' 16 [ ees' d' ] }  |
            } % Voice

            % End of segment theme 1 8va (copied)

            \context Voice = "voice 0.0" {
                % Segment: theme 1 8va
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "treble"
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
%% 185
                ees'' 8 [ ees'' g'' bes'' ] a'' [ a'' bes'' g'' ]  |
                ees'' 8 [ ees'' g'' bes'' ] a'' 4. \times 2/3 { bes'' 16 [ a'' g'' ] }  |
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                a' 8 [ a' c'' ees'' ] d'' [ d'' ees'' c'' ]  |
%% 190
                g' 8 [ g' bes' des'' ] c'' 4. \times 2/3 { des'' 16 [ c'' bes' ] }  |
                fis' 8 [ fis' a' c'' ] e'' [ e'' d'' c'' ]  |
                bes' 8 [ c'' a' f' ] fis' 2  |
            } % Voice

            % End of segment theme 1 8va

            % End voice 0
        >> % Staff ends

        \context Staff = "track 2, nylon gtr" << 
            \set Staff.instrumentName = \markup { \center-column { "nylon gtr " } }
            \set Staff.midiInstrument = "Acoustic Guitar (nylon)"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 1.0" {
                % Segment: plausible 
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*24 
%% 25
                \clef "treble_8"
                \key g \minor
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r2  |
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r8 r r b 16 [ c' ]  |
                \times 2/3 { des' 32 [ d' ees' _~ ] } ees' 16 bes g ees c 8 _~ c 8. bes, 16 b, c 8 ees 16 b,  |
%% 30
                c 8 d 4 bes, 16 [ g, ] g 4 r  |
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r8 r r e 16 [ f ]  |
                \times 2/3 { fis 32 [ g a _~ ] } a 16 ees c a, f, 8. r8 r r d 16 [ ees ]  |
                \times 2/3 { e 32 [ f g _~ ] } g 16 des bes, g, ees, 8. r8 r r des 16 [ d ]  |
%% 35
                \times 2/3 { ees 32 [ e fis _~ ] } fis 16 c a, fis, d, 8. r4 r8 c 16 [ des ]  |
                d 16 [ ees fis g ] a [ bes c' des' ] des' 8 r r4  |
            } % Voice

            % End of segment plausible 

            \context Voice = "voice 1.0" {
                % Segment: implausible
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*48 
                \clef "treble_8"
                \key g \minor
                \times 2/3 { bes 16 [ c' d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { bes 32 [ c' des' 16 d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { bes [ c' d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { e' 8 [ f' g' ] }  |
%% 50
                \times 2/3 { bes' 16 [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { bes' [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { bes' [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { a' 8 [ bes' c'' ] }  |
                \times 2/3 { d'' 16 [ g' bes' ] } \times 2/3 { g' [ f' ees' ] } \times 2/3 { d' [ g bes ] } \times 2/3 { g [ d' f' ] } \times 2/3 { g' [ bes d' ] } \times 2/3 { bes [ g f ] } \times 2/3 { f 8 [ a c' ] }  |
                \times 2/3 { d' 16 [ g bes ] } \times 2/3 { g [ f d ] } \times 2/3 { bes, [ c f, ] } \times 2/3 { g, [ bes, f, ] } d, r r8 \times 2/3 { g, [ bes, b, ] }  |
                \times 2/3 { c 8 [ d ees ] } f 16 fis fis bes \times 2/3 { g' [ ees' fis' ] } \times 2/3 { bes [ c' ees' ] } \times 2/3 { d' 8 [ c' bes ] }  |
                \times 2/3 { ees 8 [ f g 16 _~ g ] } bes a ees' g' \times 2/3 { des'' [ bes' c'' ] } \times 2/3 { ees' [ fis' aes' ] } \times 2/3 { fis' 8 [ aes' bes' ] }  |
%% 55
                \times 2/3 { ees'' 16 [ c'' d'' ] } \times 2/3 { f' [ aes' bes' ] } \times 2/3 { aes' 8 [ bes' c'' ] } \times 2/3 { f'' 16 [ d'' e'' ] } \times 2/3 { g' [ bes' c'' ] } \times 2/3 { bes' 8 [ c'' d'' ] }  |
                \times 2/3 { g'' 16 [ f'' d'' ] } \times 2/3 { c'' [ bes' g' ] } \times 2/3 { f' [ d' c' ] } \times 2/3 { bes [ g f ] } \times 2/3 { d [ c b, ] } \times 2/3 { g, [ f, d, ] } r8 r  |
                \times 2/3 { aes 16 [ bes c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { aes 32 [ bes b 16 c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { aes [ bes c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { d' 8 [ ees' f' ] }  |
                \times 2/3 { fis 16 [ aes bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { fis 32 [ aes a 16 bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { fis [ aes bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { c' 8 [ des' ees' ] }  |
                \times 2/3 { f 16 [ g a ] } \times 2/3 { c' [ a a ] } \times 2/3 { f 32 [ g aes 16 a ] } \times 2/3 { c' [ a a ] } \times 2/3 { f [ g a ] } \times 2/3 { c' [ a a ] } \times 2/3 { b 8 [ c' d' ] }  |
%% 60
                \times 2/3 { fis' 16 [ ees' d' ] } \times 2/3 { c' [ bes a ] } \times 2/3 { fis [ ees d ] } \times 2/3 { c [ bes, a, ] } \times 2/3 { fis, [ ees, d, ] } \times 2/3 { c, [ bes,, a,, ] } g,, 8 r  |
            } % Voice

            % End of segment implausible

            \context Voice = "voice 1.0" {
                % Segment: MIDI soundcard synth #6 (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*167 
                \clef "treble"
                \key g \minor
                r2 r4 r8 \times 2/3 { f'' 16 [ ees'' d'' ] }  |
            } % Voice

            % End of segment MIDI soundcard synth #6 (split)

            \context Voice = "voice 1.0" {
                % Segment: theme 1a 8va (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*168 
                \clef "treble"
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
%% 170
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                ees'' 8 [ ees'' g'' bes'' ] a'' [ a'' bes'' g'' ]  |
                ees'' 8 [ ees'' g'' bes'' ] a'' 4. \times 2/3 { bes'' 16 [ a'' g'' ] }  |
%% 175
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                a'' 8 [ a'' c''' ees''' ] d''' [ d''' ees''' c''' ]  |
                g'' 8 [ g'' bes'' des''' ] c''' 4. \times 2/3 { des''' 16 [ c''' bes'' ] }  |
                fis'' 8 [ fis'' a'' c''' ] e''' [ e''' d''' c''' ]  |
%% 180
                bes'' 8 c''' a'' f'' fis'' 4. \times 2/3 { f'' 16 [ ees'' d'' ] }  |
            } % Voice

            % End of segment theme 1a 8va (copied)

            \context Voice = "voice 1.0" {
                % Segment: theme 1a 8va
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "treble"
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
%% 185
                ees'' 8 [ ees'' g'' bes'' ] a'' [ a'' bes'' g'' ]  |
                ees'' 8 [ ees'' g'' bes'' ] a'' 4. \times 2/3 { bes'' 16 [ a'' g'' ] }  |
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                a'' 8 [ a'' c''' ees''' ] d''' [ d''' ees''' c''' ]  |
%% 190
                g'' 8 [ g'' bes'' des''' ] c''' 4. \times 2/3 { des''' 16 [ c''' bes'' ] }  |
                fis'' 8 [ fis'' a'' c''' ] e''' [ e''' d''' c''' ]  |
                bes'' 8 [ c''' a'' f'' ] fis'' 2  |
            } % Voice

            % End of segment theme 1a 8va

            % End voice 0
        >> % Staff ends

        \context Staff = "track 3, trumbone" << 
            \set Staff.instrumentName = \markup { \center-column { "trumbone " } }
            \set Staff.midiInstrument = "Trombone"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 2.0" {
                % Segment: theme 2a
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*36 
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
                bes' 8 [ d'' bes' d'' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
%% 40
                bes' 1 )  |
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
                g 1  |
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
%% 45
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2a

            \context Voice = "voice 2.0" {
                % Segment: theme 2a
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*60 
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
                bes' 8 [ d'' bes' d'' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
%% 65
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
                g 1  |
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
%% 70
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2a

            \context Voice = "voice 2.0" {
                % Segment: theme 2a
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*84 
%% 85
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
                bes' 8 [ d'' bes' d'' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
%% 90
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
                g 1  |
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
%% 95
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2a

            \context Voice = "voice 2.0" {
                % Segment: theme 2a
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*108 
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
%% 110
                g' 1 )  |
                bes' 8 [ d'' bes' d'' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
%% 115
                g 1  |
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
%% 120
                d, 1 )  |
            } % Voice

            % End of segment theme 2a

            \context Voice = "voice 2.0" {
                % Segment: theme 2a
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*132 
                \clef "treble_8"
                \key g \minor
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
%% 135
                bes' 8 [ d'' bes' d'' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
                g' 8 [ bes' g' bes' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' c' ) ] d' [ bes ) ] g 4 _~  |
                g 1  |
%% 140
                r8 r r4 r8 r r f _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d c a, ) ] fis, [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2a

            \context Voice = "voice 2.0" {
                % Segment: Creative SBLive! 8MB Soundfont #11 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*156 
                < g' d'' > 1 _~  |
                < g' d'' > 1 _~  |
                < g' d'' > 1 _~  |
%% 160
                < g' d'' > 1  |
                < c'' g' > 1 _~  |
                < c'' g' > 1  |
                < g' d' > 1 _~  |
                < g' d' > 1  |
%% 165
                < f' c' > 1  |
                < ees' bes > 1  |
                < d' a > 1 _~  |
                < d' a > 1  |
            } % Voice

            % End of segment Creative SBLive! 8MB Soundfont #11 (copied)

            \context Voice = "voice 2.0" {
                % Segment: Creative SBLive! 8MB Soundfont #11
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*168 
                \repeat unfold 1 {
                    \clef "treble"
                    \key g \minor
                    R1*3  |
                    r2 r4 r8 d'' 16 [ bes' ]  |
                    c'' 8 [ c'' ees'' g'' ] f'' [ f'' g'' ees'' ]  |
                    c'' 8 [ c'' ees'' g'' ] f'' 4. g'' 16 [ ees'' ]  |
%% 175
                    g' 8 [ g' bes' d'' ] c'' [ c'' d'' bes' ]  |
                    g' 8 [ g' bes' d'' ] c'' 4. d'' 16 [ bes' ]  |
                    f'' 8 [ f'' a'' c''' ] bes'' [ bes'' c''' a'' ]  |
                    ees'' 8 [ ees'' g'' bes'' ] a'' 4. bes'' 16 [ f'' ]  |
                    d'' 8 [ d'' fis'' a'' ] c''' [ c''' a'' fis'' ]  |
%% 180
                    d'' 8 d'' c'' des'' d'' 4. d'' 16 [ bes' ]  |
                } % close repeat
            } % Voice

            % End of segment Creative SBLive! 8MB Soundfont #11

            \context Voice = "voice 2.0" {
                % Segment: Creative SBLive! 8MB Soundfont #11 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "treble"
                g' 8 [ g' bes' d'' ] c'' [ c'' d'' bes' ]  |
                g' 8 [ g' bes' d'' ] c'' 4. d'' 16 [ bes' ]  |
                g' 8 [ g' bes' d'' ] c'' [ c'' d'' bes' ]  |
                g' 8 [ g' bes' d'' ] c'' 4. d'' 16 [ bes' ]  |
%% 185
                c'' 8 [ c'' ees'' g'' ] f'' [ f'' g'' ees'' ]  |
                c'' 8 [ c'' ees'' g'' ] f'' 4. g'' 16 [ ees'' ]  |
                g' 8 [ g' bes' d'' ] c'' [ c'' d'' bes' ]  |
                g' 8 [ g' bes' d'' ] c'' 4. d'' 16 [ bes' ]  |
                f'' 8 [ f'' a'' c''' ] bes'' [ bes'' c''' a'' ]  |
%% 190
                ees'' 8 [ ees'' g'' bes'' ] a'' 4. bes'' 16 [ f'' ]  |
                d'' 8 [ d'' fis'' a'' ] c''' [ c''' a'' fis'' ]  |
                d'' 8 [ d'' c'' des'' ] d'' 2  |
            } % Voice

            % End of segment Creative SBLive! 8MB Soundfont #11 (copied)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 4, mute trumpet" << 
            \set Staff.instrumentName = \markup { \center-column { "mute trumpet " } }
            \set Staff.midiInstrument = "Muted Trumpet"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 3.0" {
                % Segment: plausible
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*72 
                \clef "treble_8"
                \key g \minor
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r2  |
%% 75
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r8 r r b 16 [ c' ]  |
                \times 2/3 { des' 32 [ d' ees' _~ ] } ees' 16 bes g ees c 8 _~ c 8. bes, 16 b, c 8 ees 16 b,  |
                c 8 d 4 bes, 16 [ g, ] g 4 r  |
                f 32 [ fis ] fis 16 bes 8 [ a ] bes 16 [ a ] g 4. fis 16 [ g ]  |
%% 80
                \times 2/3 { aes 32 [ a bes _~ ] } bes 16 f d bes, g, 8. r8 r r e' 16 [ f' ]  |
                \times 2/3 { fis' 32 [ g' a' _~ ] } a' 16 ees' c' a f 8. r8 r r d' 16 [ ees' ]  |
                \times 2/3 { e' 32 [ f' g' _~ ] } g' 16 des' bes g ees 8. r8 r r des' 16 [ d' ]  |
                \times 2/3 { ees' 32 [ e' fis' _~ ] } fis' 16 c' a fis d 8. r4 r8 c' 16 [ des' ]  |
                d' 16 [ ees' fis' g' ] a' [ bes' c'' des'' ] des'' 8 r r4  |
            } % Voice

            % End of segment plausible

            \context Voice = "voice 3.0" {
                % Segment: implausible
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*96 
                \clef "treble_8"
                \key g \minor
                \times 2/3 { bes 16 [ c' d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { bes 32 [ c' des' 16 d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { bes [ c' d' ] } \times 2/3 { f' [ d' d' ] } \times 2/3 { e' 8 [ f' g' ] }  |
                \times 2/3 { bes' 16 [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { bes' [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { bes' [ g' a' ] } \times 2/3 { d' [ e' g' ] } \times 2/3 { a' 8 [ bes' c'' ] }  |
                \times 2/3 { d'' 16 [ g' bes' ] } \times 2/3 { g' [ d' f' ] } \times 2/3 { d' [ g bes ] } \times 2/3 { g [ d' f' ] } \times 2/3 { d'' [ g' bes' ] } \times 2/3 { g [ d f ] } \times 2/3 { d' [ g' bes' ] } \times 2/3 { g' [ d' f' ] }  |
%% 100
                \times 2/3 { d'' 16 [ g' bes' ] } \times 2/3 { g' [ d' f' ] } \times 2/3 { d' [ g bes ] } \times 2/3 { g [ d f ] } \times 2/3 { d' [ g bes ] } \times 2/3 { g [ d f ] } \times 2/3 { g, 8 [ bes, b, ] }  |
                \times 2/3 { c 8 [ d ees ] } f 16 fis fis bes \times 2/3 { g' [ ees' fis' ] } \times 2/3 { bes [ c' ees' ] } \times 2/3 { d' 8 [ c' bes ] }  |
                \times 2/3 { bes' 16 [ g' a' ] } \times 2/3 { c' [ ees' f' ] } \times 2/3 { ees' 8 [ f' g' ] } \times 2/3 { des'' 16 [ bes' c'' ] } \times 2/3 { ees' [ fis' aes' ] } \times 2/3 { fis' 8 [ aes' bes' ] }  |
                \times 2/3 { ees'' 16 [ c'' d'' ] } \times 2/3 { f' [ aes' bes' ] } \times 2/3 { aes' 8 [ bes' c'' ] } \times 2/3 { f'' 16 [ d'' e'' ] } \times 2/3 { g' [ bes' c'' ] } \times 2/3 { bes' 8 [ c'' d'' ] }  |
                \times 2/3 { g'' 16 [ f'' d'' ] } \times 2/3 { c'' [ bes' g' ] } \times 2/3 { f' [ d' c' ] } \times 2/3 { bes [ g f ] } \times 2/3 { d [ c b, ] } \times 2/3 { g, [ f, d, ] } r8 r  |
%% 105
                \times 2/3 { aes 16 [ bes c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { aes 32 [ bes b 16 c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { aes [ bes c' ] } \times 2/3 { ees' [ c' c' ] } \times 2/3 { d' 8 [ ees' f' ] }  |
                \times 2/3 { fis 16 [ aes bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { fis 32 [ aes a 16 bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { fis [ aes bes ] } \times 2/3 { des' [ bes bes ] } \times 2/3 { c' 8 [ des' ees' ] }  |
                \times 2/3 { f 16 [ g a ] } \times 2/3 { c' [ a a ] } \times 2/3 { f 32 [ g aes 16 a ] } \times 2/3 { c' [ a a ] } \times 2/3 { f [ g a ] } \times 2/3 { c' [ a a ] } \times 2/3 { b 8 [ c' d' ] }  |
                \times 2/3 { fis' 16 [ ees' d' ] } \times 2/3 { c' [ bes a ] } \times 2/3 { fis [ ees d ] } \times 2/3 { c [ bes, a, ] } \times 2/3 { fis, [ ees, d, ] } \times 2/3 { c, [ bes,, a,, ] } g,, 8 r  |
            } % Voice

            % End of segment implausible

            \context Voice = "voice 3.0" {
                % Segment: theme 2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*132 
                \clef "treble_8"
                \key g \minor
                g' 8 ^( [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 1 )  |
%% 135
                bes' 8 ^( [ d'' ] bes' 16 [ d'' bes' f' ] bes' 2 _~ 
                % warning: overlong bar truncated here |
                bes' 1 )  |
                g' 8 ^( [ bes' ] g' 16 [ bes' g' d' ] g' 2 _~ 
                % warning: overlong bar truncated here |
                g' 8 ) [ f' d' ^( c' ) ] d' ^( [ bes ) ] g 4 _~  |
                g 1  |
%% 140
                r8 r r4 r8 r r f _( _~ 
                % warning: overlong bar truncated here |
                f 8 [ a f a ] f 4. ) ees 8 _( _~ 
                % warning: overlong bar truncated here |
                ees 8 [ g ees g ] ees 2 ) _~  |
                ees 8 [ d _( c a, ) ] fis, _( [ d, ] d, 4 _~ 
                % warning: overlong bar truncated here |
                d, 1 )  |
            } % Voice

            % End of segment theme 2

            \context Voice = "voice 3.0" {
                % Segment: Creative SBLive! 8MB Soundfont #11
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*154 \skip 2 \skip 64 
%% 155
                
                % warning: bar too short, padding with rests
                % 593320 + 0 < 595200  &&  0/1 < 4/4
                r4 r8 r16 r32 r64 r64  |
                \skip 64 
                % warning: bar too short, padding with rests
                % 595200 + 60 < 599040  &&  1/64 < 4/4
                r64 r32 r16 r8 r4 r2  |
                < g' d'' > 1 _~  |
                < g' d'' > 1 _~  |
                < g' d'' > 1 _~  |
%% 160
                < g' d'' > 1  |
                < c'' g' > 1 _~  |
                < c'' g' > 1  |
                < g' d' > 1 _~  |
                < g' d' > 1  |
%% 165
                < f' c' > 1  |
                < ees' bes > 1  |
                < d' a > 1 _~  |
                < d' a > 1  |
            } % Voice

            % End of segment Creative SBLive! 8MB Soundfont #11

            \context Voice = "voice 3.0" {
                % Segment: MIDI soundcard synth #6
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*168 
                \repeat unfold 1 {
                    \clef "treble"
                    \key g \minor
                    R1*2  |
                    r2 r4 r  |
                    R1*4  |
                    r2 r4 r8 \times 2/3 { f'' 16 [ e'' d'' ] }  |
                    a'' 8 [ a'' c''' ees''' ] d''' [ d''' ees''' c''' ]  |
                    g'' 8 [ g'' bes'' des''' ] c''' 4. \times 2/3 { des''' 16 [ c''' bes'' ] }  |
                    fis'' 8 [ fis'' a'' c''' ] e''' [ e''' d''' c''' ]  |
%% 180
                    bes'' 8 c''' a'' f'' fis'' 4. \times 2/3 { f'' 16 [ ees'' d'' ] }  |
                } % close repeat
            } % Voice

            % End of segment MIDI soundcard synth #6

            \context Voice = "voice 3.0" {
                % Segment: MIDI soundcard synth #6 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "treble"
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
%% 185
                ees'' 8 [ ees'' g'' bes'' ] a'' [ a'' bes'' g'' ]  |
                ees'' 8 [ ees'' g'' bes'' ] a'' 4. \times 2/3 { bes'' 16 [ a'' g'' ] }  |
                bes' 8 [ bes' d'' f'' ] e'' [ e'' f'' d'' ]  |
                bes' 8 [ bes' d'' f'' ] e'' 4. \times 2/3 { f'' 16 [ e'' d'' ] }  |
                a'' 8 [ a'' c''' ees''' ] d''' [ d''' ees''' c''' ]  |
%% 190
                g'' 8 [ g'' bes'' des''' ] c''' 4. \times 2/3 { des''' 16 [ c''' bes'' ] }  |
                fis'' 8 [ fis'' a'' c''' ] e''' [ e''' d''' c''' ]  |
                bes'' 8 [ c''' a'' f'' ] fis'' 2  |
            } % Voice

            % End of segment MIDI soundcard synth #6 (copied)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 5, vibes" << 
            \set Staff.instrumentName = \markup { \center-column { "vibes " } }
            \set Staff.midiInstrument = "Vibraphone"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 4.0" {
                % Segment: Mute Trumpet (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "treble_8"
                \key bes \major
                \times 2/3 { g 8 [ bes d' ] } \times 2/3 { bes [ c' d' ] } \times 2/3 { c' [ d' bes ] } \times 2/3 { d' [ c' bes ] }  |
                \times 2/3 { g 8 [ bes d' ] } \times 2/3 { bes [ c' d' ] } c' 2  |
                \times 2/3 { g 8 [ bes d' ] } \times 2/3 { bes [ c' d' ] } \times 2/3 { c' [ d' bes ] } \times 2/3 { d' [ c' bes ] }  |
                \times 2/3 { g 8 [ bes d' ] } \times 2/3 { bes [ c' d' ] } c' 2  |
%% 185
                \times 2/3 { c' 8 [ ees' g' ] } \times 2/3 { ees' [ f' g' ] } \times 2/3 { f' [ g' ees' ] } \times 2/3 { g' [ f' ees' ] }  |
                \times 2/3 { c' 8 [ ees' g' ] } \times 2/3 { ees' [ f' g' ] } f' 2  |
                \times 2/3 { g 8 [ bes d' ] } \times 2/3 { bes [ c' d' ] } \times 2/3 { c' [ d' bes ] } \times 2/3 { d' [ c' bes ] }  |
                \times 2/3 { g 8 [ bes d' ] } \times 2/3 { bes [ c' d' ] } c' 2  |
                \times 2/3 { f 8 [ a c' ] } \times 2/3 { a [ bes c' ] } \times 2/3 { bes [ c' a ] } \times 2/3 { c' [ bes aes ] }  |
%% 190
                \times 2/3 { ees 8 [ g bes ] } \times 2/3 { g [ a bes ] } a 2  |
                \times 2/3 { d 8 [ ges a ] } \times 2/3 { ges [ g a ] } \times 2/3 { g [ a ges ] } \times 2/3 { a [ g f ] }  |
                d 1  |
            } % Voice

            % End of segment Mute Trumpet (split)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 6, dbls bass" << 
            \set Staff.instrumentName = \markup { \center-column { "dbls bass " } }
            \set Staff.midiInstrument = "Electric Guitar (muted)"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 5.0" {
                % Segment: theme 1a (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'numbered 
                \time 4/4
                
                \clef "treble"
                \key g \minor
                bes, 8 [ bes, d f ] e [ e f d ]  |
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
                bes, 8 [ bes, d f ] e [ e f d ]  |
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
%% 5
                ees 8 [ ees g bes ] a [ a bes g ]  |
                ees 8 [ ees g bes ] a 4. \times 2/3 { bes 16 [ a g ] }  |
                bes, 8 [ bes, d f ] e [ e f d ]  |
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
                a 8 [ a c' ees' ] d' [ d' ees' c' ]  |
%% 10
                g 8 [ g bes des' ] c' 4. \times 2/3 { des' 16 [ c' bes ] }  |
                fis 8 [ fis a c' ] e' [ e' d' c' ]  |
                bes 8 c' a f fis 4. \times 2/3 { f 16 [ ees d ] }  |
            } % Voice

            % End of segment theme 1a (copied)

            \context Voice = "voice 5.0" {
                % Segment: theme 1a (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*168 
                \clef "treble"
                \key g \minor
                bes, 8 [ bes, d f ] e [ e f d ]  |
%% 170
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
                bes, 8 [ bes, d f ] e [ e f d ]  |
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
                ees 8 [ ees g bes ] a [ a bes g ]  |
                ees 8 [ ees g bes ] a 4. \times 2/3 { bes 16 [ a g ] }  |
%% 175
                bes, 8 [ bes, d f ] e [ e f d ]  |
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
                a 8 [ a c' ees' ] d' [ d' ees' c' ]  |
                g 8 [ g bes des' ] c' 4. \times 2/3 { des' 16 [ c' bes ] }  |
                fis 8 [ fis a c' ] e' [ e' d' c' ]  |
%% 180
                bes 8 c' a f fis 4. \times 2/3 { f 16 [ ees d ] }  |
            } % Voice

            % End of segment theme 1a (copied)

            \context Voice = "voice 5.0" {
                % Segment: theme 1a
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "treble"
                bes, 8 [ bes, d f ] e [ e f d ]  |
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
                bes, 8 [ bes, d f ] e [ e f d ]  |
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
%% 185
                ees 8 [ ees g bes ] a [ a bes g ]  |
                ees 8 [ ees g bes ] a 4. \times 2/3 { bes 16 [ a g ] }  |
                bes, 8 [ bes, d f ] e [ e f d ]  |
                bes, 8 [ bes, d f ] e 4. \times 2/3 { f 16 [ e d ] }  |
                a 8 [ a c' ees' ] d' [ d' ees' c' ]  |
%% 190
                g 8 [ g bes des' ] c' 4. \times 2/3 { des' 16 [ c' bes ] }  |
                fis 8 [ fis a c' ] e' [ e' d' c' ]  |
                bes 8 [ c' a f ] fis 2  |
            } % Voice

            % End of segment theme 1a

            \context Voice = "voice 5.0" {
                % Segment: Jazz Guitar
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*192 
                \clef "treble_8"
                g, 8 [ g, bes, d ] c [ c d bes, ]  |
                g, 8 [ g, a, f, ] g, 4 _~ < bes g, > 32 _~ [ < bes e' g, > _~ < bes e' a' g, > _~ < bes e' a' d'' g, > _~ ] < d'' a' e' bes g, > 8 _~  |
%% 195
                < d'' a' e' bes g, > 1  |
                \bar "|."
            } % Voice

            % End of segment Jazz Guitar

            % End voice 0
        >> % Staff ends

        \context Staff = "track 7, jazz gtr" << 
            \set Staff.instrumentName = \markup { \center-column { "jazz gtr " } }
            \set Staff.midiInstrument = "Electric Guitar (jazz)"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 6.0" {
                % Segment: 1 finger rhythm (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'numbered 
                \time 4/4
                
                \repeat unfold 15 {
                    \clef "treble"
                    \key g \minor
                    r4 < g' d' bes > 16 r r8 r4 < a' e' c' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
%% 5
                    r4 < c'' g' ees' > 16 r r8 r4 < a' d'' f' > 16 r r8  |
                    r4 < c'' g' ees' > 16 r r8 r4 < a' d'' f' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
                    r4 < c'' g' ees' > 16 r r8 r4 < d'' a' f' > 16 r r8  |
%% 10
                    r4 < bes' des' f' > 16 r r8 r4 < c'' g' ees' > 16 r r8  |
                    r4 < a' e' c' > 16 r r8 r4 < fis' b' d' > 16 r r8  |
                    r4 < a' e' c' > 16 r r8 r4 < fis' b' d' > 16 r r8  |
                } % close repeat
            } % Voice

            % End of segment 1 finger rhythm (copied)

            \context Voice = "voice 6.0" {
                % Segment: 1 finger rhythm
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \repeat unfold 1 {
                    \clef "treble"
                    \key g \minor
                    r4 < g' d' bes > 16 r r8 r4 < a' e' c' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
%% 185
                    r4 < c'' g' ees' > 16 r r8 r4 < a' d'' f' > 16 r r8  |
                    r4 < c'' g' ees' > 16 r r8 r4 < a' d'' f' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
                    r4 < g' d' bes > 16 r r8 r4 < e' a' c' > 16 r r8  |
                    r4 < c'' g' ees' > 16 r r8 r4 < d'' a' f' > 16 r r8  |
%% 190
                    r4 < bes' des' f' > 16 r r8 r4 < c'' g' ees' > 16 r r8  |
                    r4 < a' e' c' > 16 r r8 r4 < fis' b' d' > 16 r r8  |
                    r4 < a' e' c' > 16 r r8 r4 < fis' b' d' > 16 r r8  |
                } % close repeat
            } % Voice

            % End of segment 1 finger rhythm

            \context Voice = "voice 6.0" {
                % Segment: Jazz Guitar (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*192 
                \clef "treble_8"
                g, 8 [ g, bes, d ] c [ c d bes, ]  |
                g, 8 [ g, a, f, ] g, 4 _~ < bes g, > 32 _~ [ < bes e' g, > _~ < bes e' a' g, > _~ < bes e' a' d'' g, > _~ ] < d'' a' e' bes g, > 8 _~  |
%% 195
                < d'' a' e' bes g, > 1  |
                \bar "|."
            } % Voice

            % End of segment Jazz Guitar (copied)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 8, bass" << 
            \set Staff.instrumentName = \markup { \center-column { "bass " } }
            \set Staff.midiInstrument = "Picked Bass"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 7.0" {
                % Segment: theme 1 8vb (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'numbered 
                \time 4/4
                
                \repeat unfold 15 {
                    \clef "bass"
                    \key g \minor
                    g,, 8 [ g,, bes,, d, ] c, [ c, d, bes,, ]  |
                    g,, 8 [ g,, bes,, d, ] c, 4. d, 16 [ bes,, ]  |
                    g,, 8 [ g,, bes,, d, ] c, [ c, d, bes,, ]  |
                    g,, 8 [ g,, bes,, d, ] c, 4. d, 16 [ bes,, ]  |
%% 5
                    c, 8 [ c, ees, g, ] f, [ f, g, ees, ]  |
                    c, 8 [ c, ees, g, ] f, 4. g, 16 [ ees, ]  |
                    g,, 8 [ g,, bes,, d, ] c, [ c, d, bes,, ]  |
                    g,, 8 [ g,, bes,, d, ] c, 4. d, 16 [ bes,, ]  |
                    f, 8 [ f, a, c ] bes, [ bes, c a, ]  |
%% 10
                    ees, 8 [ ees, g, bes, ] a, 4. bes, 16 [ f, ]  |
                    d, 8 [ d, fis, a, ] c [ c a, fis, ]  |
                    d, 8 d, c, des, d, 4. d, 16 [ bes,, ]  |
                } % close repeat
            } % Voice

            % End of segment theme 1 8vb (copied)

            \context Voice = "voice 7.0" {
                % Segment: theme 1 8vb
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "bass"
                \key g \minor
                g,, 8 [ g,, bes,, d, ] c, [ c, d, bes,, ]  |
                g,, 8 [ g,, bes,, d, ] c, 4. d, 16 [ bes,, ]  |
                g,, 8 [ g,, bes,, d, ] c, [ c, d, bes,, ]  |
                g,, 8 [ g,, bes,, d, ] c, 4. d, 16 [ bes,, ]  |
%% 185
                c, 8 [ c, ees, g, ] f, [ f, g, ees, ]  |
                c, 8 [ c, ees, g, ] f, 4. g, 16 [ ees, ]  |
                g,, 8 [ g,, bes,, d, ] c, [ c, d, bes,, ]  |
                g,, 8 [ g,, bes,, d, ] c, 4. d, 16 [ bes,, ]  |
                f, 8 [ f, a, c ] bes, [ bes, c a, ]  |
%% 190
                ees, 8 [ ees, g, bes, ] a, 4. bes, 16 [ f, ]  |
                d, 8 [ d, fis, a, ] c [ c a, fis, ]  |
                d, 8 [ d, c, des, ] d, 4. a, 16 [ ees, ]  |
            } % Voice

            % End of segment theme 1 8vb

            \context Voice = "voice 7.0" {
                % Segment: Picked Bass
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*192 
                \clef "bass_8"
                \key bes \major
                g,, 8 [ g,, bes,, d, ] c, [ c, d, bes,, ]  |
                g,, 8 [ g,, a,, f,, ] g,, 2  |
%% 195
                R1  |
                \bar "|."
            } % Voice

            % End of segment Picked Bass

            % End voice 0
        >> % Staff ends

        \context Staff = "track 9, percussion" << 
            \set Staff.instrumentName = \markup { \center-column { "percussion " } }
            \set Staff.midiInstrument = "Standard"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 8.0" {
                % Segment: MIDI soundcard synth #9 (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'numbered 
                \time 4/4
                
                \repeat unfold 15 {
                    \clef "bass"
                    a, 8 [ a, c b, ] c [ c b, c ]  |
                    b, 8 [ b, c b, ] d [ d c b, ]  |
                    a, 8 [ a, c b, ] c [ c b, c ]  |
                    b, 8 [ b, c b, ] d [ d c b, ]  |
%% 5
                    a, 8 [ a, c b, ] c [ c b, c ]  |
                    b, 8 [ b, c b, ] d [ d c b, ]  |
                    a, 8 [ a, c b, ] c [ c b, c ]  |
                    b, 8 [ b, c b, ] d [ d c b, ]  |
                    a, 8 [ a, c b, ] c [ c b, c ]  |
%% 10
                    b, 8 [ b, c b, ] d [ d c b, ]  |
                    a, 8 [ a, c b, ] c [ c b, c ]  |
                    b, 8 [ b, c b, ] d [ d c b, ]  |
                } % close repeat
            } % Voice

            % End of segment MIDI soundcard synth #9 (split)

            \context Voice = "voice 8.0" {
                % Segment: MIDI soundcard synth #9 (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "bass"
                a, 8 [ a, c b, ] c [ c b, c ]  |
                b, 8 [ b, c b, ] d [ d c b, ]  |
                a, 8 [ a, c b, ] c [ c b, c ]  |
                b, 8 [ b, c b, ] d [ d c b, ]  |
%% 185
                a, 8 [ a, c b, ] c [ c b, c ]  |
                b, 8 [ b, c b, ] d [ d c b, ]  |
                a, 8 [ a, c b, ] c [ c b, c ]  |
                b, 8 [ b, c b, ] d [ d c b, ]  |
                a, 8 [ a, c b, ] c [ c b, c ]  |
%% 190
                b, 8 [ b, c b, ] d [ d c b, ]  |
                a, 8 [ a, c b, ] c [ c b, c ]  |
                b, 8 [ b, c b, ] d [ d c b, ]  |
                R1*3  |
                \bar "|."
            } % Voice

            % End of segment MIDI soundcard synth #9 (split) (copied)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 10, drums" << 
            \set Staff.instrumentName = \markup { \center-column { "drums " } }
            \set Staff.midiInstrument = "Standard"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 9.0" {
                % Segment: MIDI soundcard synth #10[D] (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'numbered 
                \time 4/4
                
                \repeat unfold 15 {
                    \clef "bass"
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
%% 5
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
%% 10
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                    b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                } % close repeat
            } % Voice

            % End of segment MIDI soundcard synth #10[D] (split) (copied)

            \context Voice = "voice 9.0" {
                % Segment: MIDI soundcard synth #10[D] (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*180 
                \clef "bass"
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
%% 185
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
%% 190
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                b,, 8 [ b,, ] e, 4 b,, 8 [ b,, ] e, 4  |
                R1*2  |
                \bar "|."
            } % Voice

            % End of segment MIDI soundcard synth #10[D] (split)

            % End voice 0
        >> % Staff ends

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
