use core:lang;
use core:io;
use core:asm;
use lang:bs:macro;

lang:PkgReader reader(Url[] files, Package pkg) on Compiler {
	IconReader(files, pkg);
}


/**
 * Read files, and place them as functions in the name tree.
 */
class IconReader extends lang:PkgReader {
	// Create.
	init(Url[] files, Package pkg) {
		init(files, pkg) {}
	}

	void readFunctions() {
		for (file in files) {
			var image = graphics:loadImageSet(file);
			pkg.add(createAccessor(file.title, image));
		}
	}

	private Function createAccessor(Str name, graphics:ImageSet image) {
		Type imageSet = named{graphics:ImageSet};
		Function f(imageSet, name, []);

		Listing l(false, ptrDesc);

		l << prolog();
		l << fnParam(ptrDesc, objPtr(image));
		l << fnCall(named{core:clone<graphics:ImageSet>}.ref, false, ptrDesc, ptrA);
		l << fnRet(ptrA);

		f.setCode(DynamicCode(l));

		return f;
	}
}
