//===-- Ryu Constants for long double conversion ----------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIBC_SRC___SUPPORT_RYU_LONG_DOUBLE_CONSTANTS_H
#define LLVM_LIBC_SRC___SUPPORT_RYU_LONG_DOUBLE_CONSTANTS_H

#include <stddef.h>
#include <stdint.h>

constexpr size_t TABLE_SHIFT_CONST = 120;
constexpr size_t IDX_SIZE = 128;

constexpr size_t MID_INT_SIZE = (256 + 64);

constexpr uint32_t POW10_OFFSET[] = {
    0,     4,     13,    26,    43,    64,    90,    120,   154,   193,   236,
    283,   334,   390,   450,   514,   582,   655,   732,   813,   899,   989,
    1083,  1181,  1284,  1391,  1502,  1618,  1738,  1862,  1990,  2123,  2260,
    2401,  2547,  2697,  2851,  3009,  3172,  3339,  3510,  3686,  3866,  4050,
    4238,  4431,  4628,  4829,  5034,  5244,  5458,  5676,  5899,  6126,  6357,
    6592,  6832,  7076,  7324,  7577,  7834,  8095,  8360,  8630,  8904,  9182,
    9465,  9752,  10043, 10338, 10638, 10942, 11250, 11563, 11880, 12201, 12526,
    12856, 13190, 13528, 13871, 14218, 14569, 14924, 15284, 15648, 16016, 16388,
    16765, 17146, 17531, 17921, 18315, 18713, 19115, 19522, 19933, 20348, 20768,
    21192, 21620, 22052, 22489, 22930, 23375, 23825, 24279, 24737, 25199, 25666,
    26137, 26612, 27092, 27576, 28064, 28556, 29053, 29554, 30059, 30568, 31082,
    31600, 32122, 32649, 33180, 33715, 34254, 34798, 35346};

constexpr uint32_t POW10_OFFSET_2[130] = {
    0,     15,    44,    83,    131,   190,   259,   338,   426,   524,   633,
    751,   879,   1017,  1166,  1324,  1492,  1670,  1858,  2056,  2264,  2482,
    2709,  2947,  3195,  3453,  3720,  3997,  4285,  4582,  4889,  5206,  5534,
    5871,  6218,  6575,  6941,  7318,  7705,  8102,  8508,  8925,  9352,  9788,
    10234, 10690, 11157, 11633, 12119, 12615, 13122, 13638, 14164, 14700, 15245,
    15801, 16367, 16943, 17528, 18124, 18730, 19345, 19970, 20605, 21251, 21906,
    22571, 23246, 23931, 24626, 25331, 26046, 26770, 27505, 28250, 29004, 29768,
    30543, 31328, 32122, 32926, 33740, 34565, 35399, 36243, 37097, 37961, 38835,
    39719, 40613, 41516, 42430, 43354, 44287, 45230, 46184, 47148, 48121, 49104,
    50097, 51100, 52113, 53136, 54169, 55212, 56265, 57328, 58400, 59482, 60575,
    61678, 62790, 63912, 65045, 66188, 67340, 68502, 69674, 70856, 72048, 73250,
    74462, 75684, 76916, 78158, 79409, 80670, 81942, 83224, 84515};

constexpr uint16_t MIN_BLOCK_2[130] = {
    0,   0,   4,   9,   13,  17,  21,  26,  30,  34,  39,  43,  47,  51,  56,
    60,  64,  68,  73,  77,  81,  86,  90,  94,  98,  103, 107, 111, 116, 120,
    124, 128, 133, 137, 141, 146, 150, 154, 158, 163, 167, 171, 176, 180, 184,
    188, 193, 197, 201, 205, 210, 214, 218, 223, 227, 231, 235, 240, 244, 248,
    253, 257, 261, 265, 270, 274, 278, 283, 287, 291, 295, 300, 304, 308, 313,
    317, 321, 325, 330, 334, 338, 342, 347, 351, 355, 360, 364, 368, 372, 377,
    381, 385, 390, 394, 398, 402, 407, 411, 415, 420, 424, 428, 432, 437, 441,
    445, 450, 454, 458, 462, 467, 471, 475, 479, 484, 488, 492, 497, 501, 505,
    509, 514, 518, 522, 527, 531, 535, 539, 544, 0};

constexpr uint64_t POW10_SPLIT[][5] = {
    {1u, 72057594037927936u, 0u, 0u, 0u},
    {699646928636035157u, 72057594u, 0u, 0u, 0u},
    {1329227995784915873u, 0u, 0u, 0u, 0u},
    {1329227996u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 72057594037927936u, 0u},
    {17296309485351745867u, 5171444645924616994u, 699646928636035156u, 72057594u, 0u},
    {16598859101615853088u, 16672297533003297785u, 1329227995784915872u, 0u, 0u},
    {7469952526870444257u, 14479142226848862514u, 1329227995u, 0u, 0u},
    {13531654022114669524u, 6073184580144670117u, 1u, 0u, 0u},
    {15757609704383306943u, 24519928653u, 0u, 0u, 0u},
    {9590990814237149590u, 24u, 0u, 0u, 0u},
    {452312848584u, 0u, 0u, 0u, 0u},
    {453u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3000826u},
    {3609144142396852269u, 16798760952716600047u, 17296309485351745866u, 5171444645924616994u, 1463310u},
    {11568848377382068865u, 2419982808370854966u, 16598859101615853087u, 16672297533003297785u, 3665872u},
    {10068303578029323957u, 2922947087773078955u, 7469952526870444256u, 14479142226848862514u, 1102995u},
    {11645070846862630231u, 15419220167069510189u, 13531654022114669523u, 6073184580144670117u, 1u},
    {12449386705878485055u, 3452124642157173415u, 15757609704383306942u, 24519928653u, 0u},
    {15025619323517318418u, 5979700067267186898u, 9590990814237149589u, 24u, 0u},
    {14996237555047131272u, 4913998146922579596u, 452312848583u, 0u, 0u},
    {10211005638256058413u, 5771037749337678923u, 452u, 0u, 0u},
    {1014743503555840530u, 8343699359066u, 0u, 0u, 0u},
    {12900897707145290678u, 8343u, 0u, 0u, 0u},
    {153914086704666u, 0u, 0u, 0u, 0u},
    {153915u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 506406u},
    {9917186842884466953u, 16428432973129962469u, 3609144142396852268u, 16798760952716600047u, 2281280u},
    {4751011869809829335u, 3721112279790863773u, 11568848377382068864u, 2419982808370854966u, 2203279u},
    {11068497969931435029u, 18032764903259620752u, 10068303578029323956u, 2922947087773078955u, 3846350u},
    {17118056985122509954u, 18058455550468776078u, 11645070846862630230u, 15419220167069510189u, 3546301u},
    {14607066080907684459u, 15692090139033993189u, 12449386705878485054u, 3452124642157173415u, 3847690u},
    {11768892370493391107u, 389416944300619392u, 15025619323517318417u, 5979700067267186898u, 763373u},
    {4043396447647747170u, 12009691357260487292u, 14996237555047131271u, 4913998146922579596u, 348583u},
    {1670341095362518057u, 13494259174449809899u, 10211005638256058412u, 5771037749337678923u, 452u},
    {3190817644167043165u, 18288583400616279876u, 1014743503555840529u, 8343699359066u, 0u},
    {10425820027224322486u, 7216107869057471u, 12900897707145290677u, 8343u, 0u},
    {13139964660506311565u, 17237061291959073877u, 153914086704665u, 0u, 0u},
    {2297772885416059937u, 1599418782488783272u, 153914u, 0u, 0u},
    {7677687919964523763u, 2839213766779714u, 0u, 0u, 0u},
    {14144589152747892828u, 2839213u, 0u, 0u, 0u},
    {52374249726338270u, 0u, 0u, 0u, 0u},
    {52374250u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3868386u},
    {3757709791947931308u, 8142946531605512549u, 9917186842884466952u, 16428432973129962469u, 2503150u},
    {3452755398462519465u, 5328402096432654514u, 4751011869809829334u, 3721112279790863773u, 995644u},
    {3105818720159874523u, 1932004361303814511u, 11068497969931435028u, 18032764903259620752u, 2388336u},
    {16859138458894499364u, 2511477647985517770u, 17118056985122509953u, 18058455550468776078u, 3013660u},
    {12271894740606233755u, 17451375493324716693u, 14607066080907684458u, 15692090139033993189u, 1579084u},
    {5429638071845793701u, 9489266854478998488u, 11768892370493391106u, 389416944300619392u, 2609173u},
    {145278150038876889u, 8803053132063235168u, 4043396447647747169u, 12009691357260487292u, 1056505u},
    {9050266019724932450u, 16198682197142616772u, 1670341095362518056u, 13494259174449809899u, 3144842u},
    {11907016253451490866u, 13696242485403414201u, 3190817644167043164u, 18288583400616279876u, 391185u},
    {2472757296513770735u, 16409082426079859930u, 10425820027224322485u, 7216107869057471u, 829215u},
    {10558733798178239360u, 11653410736879597609u, 13139964660506311564u, 17237061291959073877u, 767165u},
    {15917322570831255850u, 13589514120653213260u, 2297772885416059936u, 1599418782488783272u, 153914u},
    {12254334656791355238u, 8032934885905905773u, 7677687919964523762u, 2839213766779714u, 0u},
    {7869542424662730262u, 2753021350129449272u, 14144589152747892827u, 2839213u, 0u},
    {1378558986933000253u, 16974897459201404132u, 52374249726338269u, 0u, 0u},
    {13521405041909411105u, 13398576176159101588u, 52374249u, 0u, 0u},
    {3206744593298092012u, 966134380754314586u, 0u, 0u, 0u},
    {13914648122214918505u, 966134380u, 0u, 0u, 0u},
    {17822033662586700073u, 0u, 0u, 0u, 0u},
    {17822033663u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 23766u},
    {4307062684900157136u, 5782377197813462996u, 3757709791947931307u, 8142946531605512549u, 3697006u},
    {15300759383869911853u, 17732139848231399225u, 3452755398462519464u, 5328402096432654514u, 3171666u},
    {16007534237643445447u, 3628839527415562920u, 3105818720159874522u, 1932004361303814511u, 3334976u},
    {7138502295759677634u, 3188692267613601003u, 16859138458894499363u, 2511477647985517770u, 728461u},
    {8218537071653683708u, 5168130193478377351u, 12271894740606233754u, 17451375493324716693u, 2695436u},
    {2254219416760329296u, 12556227529405091289u, 5429638071845793700u, 9489266854478998488u, 651966u},
    {3057410459568460683u, 15087090312791441191u, 145278150038876888u, 8803053132063235168u, 3132321u},
    {8217810929938874370u, 10281804758610642493u, 9050266019724932449u, 16198682197142616772u, 287292u},
    {11741126472498340929u, 14238177586158586579u, 11907016253451490865u, 13696242485403414201u, 2819390u},
    {1175325363726654805u, 7107927498217678127u, 2472757296513770734u, 16409082426079859930u, 2826411u},
    {9428843070696730900u, 3845814658485364449u, 10558733798178239359u, 11653410736879597609u, 2314036u},
    {12662500978715131896u, 714293333681725945u, 15917322570831255849u, 13589514120653213260u, 1872522u},
    {6443045597035184564u, 16766172658649116981u, 12254334656791355237u, 8032934885905905773u, 804086u},
    {1921385512639171183u, 812461421432632214u, 7869542424662730261u, 2753021350129449272u, 2242285u},
    {10469475094355551399u, 15218024718633799195u, 1378558986933000252u, 16974897459201404132u, 3682019u},
    {14679174489076953574u, 8110797782612805145u, 13521405041909411104u, 13398576176159101588u, 1592999u},
    {11853074234719825644u, 15941193964933529226u, 3206744593298092011u, 966134380754314586u, 0u},
    {8270896886596139124u, 14144280602323277932u, 13914648122214918504u, 966134380u, 0u},
    {16532667046659118126u, 15072402647813125244u, 17822033662586700072u, 0u, 0u},
    {148341279888833483u, 10822706091283369888u, 17822033662u, 0u, 0u},
    {10364629296397276041u, 15163844593710966730u, 17u, 0u, 0u},
    {14265682585545771671u, 328758493846u, 0u, 0u, 0u},
    {13991741872911347878u, 328u, 0u, 0u, 0u},
    {6064523798050u, 0u, 0u, 0u, 0u},
    {6065u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 963296u},
    {2484134775182816690u, 419091135888749534u, 4307062684900157135u, 5782377197813462996u, 323727u},
    {18400539815335991277u, 1073142712661309789u, 15300759383869911852u, 17732139848231399225u, 1407284u},
    {485494064952118286u, 11076438902195672285u, 16007534237643445446u, 3628839527415562920u, 984354u},
    {17577048805241314891u, 1820390940081322072u, 7138502295759677633u, 3188692267613601003u, 2821149u},
    {2863946907557583807u, 18417808973944523596u, 8218537071653683707u, 5168130193478377351u, 986958u},
    {13045307417786230800u, 10251294197731582956u, 2254219416760329295u, 12556227529405091289u, 1466554u},
    {12032088871615097766u, 1502394029870156427u, 3057410459568460682u, 15087090312791441191u, 2690252u},
    {8848763446997690580u, 321014853559106074u, 8217810929938874369u, 10281804758610642493u, 2321903u},
    {10031289150307672684u, 2390953058510591777u, 11741126472498340928u, 14238177586158586579u, 2509021u},
    {11592215575498656563u, 10685224265907994086u, 1175325363726654804u, 7107927498217678127u, 1450780u},
    {15894436747956898388u, 5967405799190505022u, 9428843070696730899u, 3845814658485364449u, 3565669u},
    {2091546719588500923u, 11210723659228214760u, 12662500978715131895u, 714293333681725945u, 2646041u},
    {5863809244813756109u, 12327123641078462772u, 6443045597035184563u, 16766172658649116981u, 1074871u},
    {11303008753675411245u, 1709976940107894236u, 1921385512639171182u, 812461421432632214u, 752023u},
    {13238426537506910532u, 16607686590938553510u, 10469475094355551398u, 15218024718633799195u, 2187228u},
    {17258458071023005565u, 18332088094272679456u, 14679174489076953573u, 8110797782612805145u, 892606u},
    {8385733444777075179u, 2946170632136780881u, 11853074234719825643u, 15941193964933529226u, 1137987u},
    {9530757096163247300u, 4824449494694383418u, 8270896886596139123u, 14144280602323277932u, 670334u},
    {14423000845391072217u, 17008332258693407133u, 16532667046659118125u, 15072402647813125244u, 762572u},
    {10953140011159884311u, 1773419466622750660u, 148341279888833482u, 10822706091283369888u, 1721162u},
    {12228340237948264127u, 3892343466023784378u, 10364629296397276040u, 15163844593710966730u, 17u},
    {11279134946966259189u, 12001571085575422795u, 14265682585545771670u, 328758493846u, 0u},
    {14640097792684582651u, 12933506765500977581u, 13991741872911347877u, 328u, 0u},
    {6232313315128656728u, 11884830007749143733u, 6064523798049u, 0u, 0u},
    {16136121832933322088u, 9662368568096205336u, 6064u, 0u, 0u},
    {15074767079673358271u, 111870718431542u, 0u, 0u, 0u},
    {13252722804829281908u, 111870u, 0u, 0u, 0u},
    {2063650512248693u, 0u, 0u, 0u, 0u},
    {2063651u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3187726u},
    {12099486841948187399u, 11654451024602552033u, 2484134775182816689u, 419091135888749534u, 3487683u},
    {5319910566029976328u, 5299013208454526792u, 18400539815335991276u, 1073142712661309789u, 2798706u},
    {11549214421017285864u, 14918550373926182539u, 485494064952118285u, 11076438902195672285u, 1027340u},
    {1998791413186046700u, 6225552657491071053u, 17577048805241314890u, 1820390940081322072u, 2337675u},
    {17075171930090011210u, 10344713496596235784u, 2863946907557583806u, 18417808973944523596u, 1036271u},
    {15158296003813501474u, 12972405634433280208u, 13045307417786230799u, 10251294197731582956u, 3319943u},
    {1360083178079384115u, 12911885282402784944u, 12032088871615097765u, 1502394029870156427u, 1777250u},
    {6167980558592741158u, 6934311832970995867u, 8848763446997690579u, 321014853559106074u, 707575u},
    {3630180428124865653u, 9975729197003430460u, 10031289150307672683u, 2390953058510591777u, 1122168u},
    {2276550099763657677u, 1982857556803548934u, 11592215575498656562u, 10685224265907994086u, 3181216u},
    {407006713016100655u, 2095735223386298222u, 15894436747956898387u, 5967405799190505022u, 2265797u},
    {14242579061653496002u, 7110931538347639364u, 2091546719588500922u, 11210723659228214760u, 285961u},
    {17944493332678643704u, 15822183724630969534u, 5863809244813756108u, 12327123641078462772u, 2854285u},
    {987185901870869452u, 16931982690156327500u, 11303008753675411244u, 1709976940107894236u, 1866994u},
    {5578665155415167745u, 6740069226761666109u, 13238426537506910531u, 16607686590938553510u, 1596986u},
    {4849210377429577536u, 3138792961008474901u, 17258458071023005564u, 18332088094272679456u, 3462229u},
    {10811995403388891862u, 12154594426971851389u, 8385733444777075178u, 2946170632136780881u, 3721431u},
    {7051931074990177294u, 15780127219221910901u, 9530757096163247299u, 4824449494694383418u, 148539u},
    {2030832259446664275u, 16421541930960194380u, 14423000845391072216u, 17008332258693407133u, 2387261u},
    {6069512651054767896u, 7485894627196740575u, 10953140011159884310u, 1773419466622750660u, 66862u},
    {10608701253763958799u, 8897269432694476706u, 12228340237948264126u, 3892343466023784378u, 2168972u},
    {15700053443426906717u, 17189823634941678804u, 11279134946966259188u, 12001571085575422795u, 1908056u},
    {17759719234725541222u, 9585582064286255215u, 14640097792684582650u, 12933506765500977581u, 3652925u},
    {15187321568916405210u, 12835472279575022096u, 6232313315128656727u, 11884830007749143733u, 360549u},
    {11040156458113129594u, 6776016669542754607u, 16136121832933322087u, 9662368568096205336u, 6064u},
    {2800727824598008497u, 18340015775620871026u, 15074767079673358270u, 111870718431542u, 0u},
    {2997236166375604479u, 5254188752292365829u, 13252722804829281907u, 111870u, 0u},
    {6260091886451512841u, 6798802596750151182u, 2063650512248692u, 0u, 0u},
    {17573059315228347474u, 9449320530215271999u, 2063650u, 0u, 0u},
    {7519453664590169251u, 38067632857031246u, 0u, 0u, 0u},
    {15809436065653866529u, 38067632u, 0u, 0u, 0u},
    {702223880805592152u, 0u, 0u, 0u, 0u},
    {702223881u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2882806u},
    {18145438202636536773u, 10968905082284365637u, 12099486841948187398u, 11654451024602552033u, 2103831u},
    {12789043364381109412u, 14076907092801977811u, 5319910566029976327u, 5299013208454526792u, 142486u},
    {6353074369953819668u, 3438322122816124201u, 11549214421017285863u, 14918550373926182539u, 1550385u},
    {17062510605820933995u, 14645413324829073675u, 1998791413186046699u, 6225552657491071053u, 2194292u},
    {13874941021389934718u, 12271281439492289998u, 17075171930090011209u, 10344713496596235784u, 110518u},
    {6244875417950487646u, 6233751789862708245u, 15158296003813501473u, 12972405634433280208u, 735953u},
    {17731957631755937344u, 1962644459455827990u, 1360083178079384114u, 12911885282402784944u, 909797u},
    {15561983039146332959u, 8726934184642952499u, 6167980558592741157u, 6934311832970995867u, 1722863u},
    {3903438255588736488u, 4531087719737475146u, 3630180428124865652u, 9975729197003430460u, 2022173u},
    {11340348909323460163u, 481513520412720774u, 2276550099763657676u, 1982857556803548934u, 328784u},
    {6137444972131520667u, 992149349835802668u, 407006713016100654u, 2095735223386298222u, 2671871u},
    {8834868486469757182u, 11165474436676191360u, 14242579061653496001u, 7110931538347639364u, 2253548u},
    {12624729701656990740u, 10240785855143707183u, 17944493332678643703u, 15822183724630969534u, 3822120u},
    {2424312716199525191u, 10059329918238932465u, 987185901870869451u, 16931982690156327500u, 2098634u},
    {15602981927113431576u, 14791716450947031885u, 5578665155415167744u, 6740069226761666109u, 2185557u},
    {1761552748541759270u, 15378882314737417402u, 4849210377429577535u, 3138792961008474901u, 2651884u},
    {2348747960974894420u, 14726970229242271127u, 10811995403388891861u, 12154594426971851389u, 3879910u},
    {2835269122823692251u, 5090110549507128155u, 7051931074990177293u, 15780127219221910901u, 3494821u},
    {11713260335902707556u, 17185220781106503840u, 2030832259446664274u, 16421541930960194380u, 3467410u},
    {10998082825607846436u, 9858517691519529305u, 6069512651054767895u, 7485894627196740575u, 1853192u},
    {9582878005220981545u, 5595905546638020702u, 10608701253763958798u, 8897269432694476706u, 2174706u},
    {3554517550499837147u, 15555173226968030255u, 15700053443426906716u, 17189823634941678804u, 104194u},
    {6068015127447805372u, 10745236628845355770u, 17759719234725541221u, 9585582064286255215u, 499846u},
    {5834261733748302474u, 9973314042399760759u, 15187321568916405209u, 12835472279575022096u, 141099u},
    {12764648529156632042u, 4374506813558796575u, 11040156458113129593u, 6776016669542754607u, 2026747u},
    {16454052395913245109u, 15960826480426749932u, 2800727824598008496u, 18340015775620871026u, 3580142u},
    {1576542808359270498u, 9636454862798615737u, 2997236166375604478u, 5254188752292365829u, 1376327u},
    {6487760493583898347u, 17973331528911319268u, 6260091886451512840u, 6798802596750151182u, 529942u},
    {13937284973699010787u, 7366495200039369601u, 17573059315228347473u, 9449320530215271999u, 2063650u},
    {15526383088238921932u, 10505831326526933398u, 7519453664590169250u, 38067632857031246u, 0u},
    {16696066431351628018u, 2803218632575724144u, 15809436065653866528u, 38067632u, 0u},
    {3165933241245007274u, 8425731874431741635u, 702223880805592151u, 0u, 0u},
    {197521300793533396u, 14860552245711912110u, 702223880u, 0u, 0u},
    {10324683056622278765u, 12953744211667879574u, 0u, 0u, 0u},
    {12320203583960842990u, 12953744211u, 0u, 0u, 0u},
    {17593475384419245734u, 12u, 0u, 0u, 0u},
    {238954404269u, 0u, 0u, 0u, 0u},
    {239u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 875536u},
    {5218809981747799537u, 14486973664692593929u, 18145438202636536772u, 10968905082284365637u, 1391912u},
    {15843024983320533546u, 11970092907999888361u, 12789043364381109411u, 14076907092801977811u, 2798065u},
    {11844573090770795238u, 14018319588989021521u, 6353074369953819667u, 3438322122816124201u, 960697u},
    {4503746032576038050u, 1313838277904518202u, 17062510605820933994u, 14645413324829073675u, 1164999u},
    {8649685863831225007u, 5133200156448565829u, 13874941021389934717u, 12271281439492289998u, 1994861u},
    {11039694637337608570u, 1564267318960847868u, 6244875417950487645u, 6233751789862708245u, 926419u},
    {15788316133629700404u, 288094406765411749u, 17731957631755937343u, 1962644459455827990u, 431800u},
    {11764489945520985933u, 7105132101564153149u, 15561983039146332958u, 8726934184642952499u, 3443257u},
    {10209979424204746268u, 5467126739023988403u, 3903438255588736487u, 4531087719737475146u, 2665400u},
    {2185429517852548770u, 141944436040620692u, 11340348909323460162u, 481513520412720774u, 3003274u},
    {1817943823014982527u, 17787049583145646959u, 6137444972131520666u, 992149349835802668u, 3719082u},
    {859420803257499868u, 4911178998173376303u, 8834868486469757181u, 11165474436676191360u, 466613u},
    {8221570079035201540u, 2492403588465268215u, 12624729701656990739u, 10240785855143707183u, 2348617u},
    {16308871940717542208u, 1302429028955989138u, 2424312716199525190u, 10059329918238932465u, 1079305u},
    {13239827720299124549u, 5915072266190131345u, 15602981927113431575u, 14791716450947031885u, 1659630u},
    {7907558139918110623u, 5486596925715591599u, 1761552748541759269u, 15378882314737417402u, 1475655u},
    {13193563222420714972u, 16112946523525017734u, 2348747960974894419u, 14726970229242271127u, 2497945u},
    {9062488218207158965u, 11314191899605050128u, 2835269122823692250u, 5090110549507128155u, 1925185u},
    {13282680790808053275u, 16509099747728258847u, 11713260335902707555u, 17185220781106503840u, 3181314u},
    {9391866658095311826u, 10050638040060643301u, 10998082825607846435u, 9858517691519529305u, 2573397u},
    {9342871032033568849u, 10813284872894559969u, 9582878005220981544u, 5595905546638020702u, 3403880u},
    {13723153935414647912u, 18029575689662377848u, 3554517550499837146u, 15555173226968030255u, 469194u},
    {4295008710601833712u, 8815066103066201432u, 6068015127447805371u, 10745236628845355770u, 1591937u},
    {18051091670283771329u, 7136306738640812513u, 5834261733748302473u, 9973314042399760759u, 2767489u},
    {7339076420894569709u, 1185996542314059014u, 12764648529156632041u, 4374506813558796575u, 1956887u},
    {8283791229976640581u, 17979021584691093322u, 16454052395913245108u, 15960826480426749932u, 2862014u},
    {16191470718728899227u, 13535623218546078665u, 1576542808359270497u, 9636454862798615737u, 1680004u},
    {3360378322432791764u, 7924302766318446344u, 6487760493583898346u, 17973331528911319268u, 901004u},
    {5736112324315119995u, 8853279777688214857u, 13937284973699010786u, 7366495200039369601u, 3116007u},
    {7891892714625143306u, 18155510465795455292u, 15526383088238921931u, 10505831326526933398u, 3525286u},
    {13946504657791183042u, 7472213693422162789u, 16696066431351628017u, 2803218632575724144u, 3634840u},
    {16360021926960286022u, 15232800345935663933u, 3165933241245007273u, 8425731874431741635u, 904651u},
    {10876513123658431453u, 5822185157630120038u, 197521300793533395u, 14860552245711912110u, 3005130u},
    {13071823993215455991u, 3445343314290737595u, 10324683056622278764u, 12953744211667879574u, 0u},
    {15949423191553045785u, 11941875133909633394u, 12320203583960842989u, 12953744211u, 0u},
    {8499057584590477220u, 2334213467904891796u, 17593475384419245733u, 12u, 0u},
    {8756370509248011348u, 17226770962571993101u, 238954404268u, 0u, 0u},
    {4587524278881828832u, 17605651291878873617u, 238u, 0u, 0u},
    {13874870284098169788u, 4407930740834u, 0u, 0u, 0u},
    {17169137977623855829u, 4407u, 0u, 0u, 0u},
    {81311970270816u, 0u, 0u, 0u, 0u},
    {81312u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 184166u},
    {1881655259298307354u, 7950651768423060596u, 5218809981747799536u, 14486973664692593929u, 462536u},
    {13034942560243803229u, 13937459924082697122u, 15843024983320533545u, 11970092907999888361u, 2122127u},
    {5706855392060411262u, 17711859616632310113u, 11844573090770795237u, 14018319588989021521u, 910815u},
    {3262821746683671640u, 14248630625585449692u, 4503746032576038049u, 1313838277904518202u, 927588u},
    {15052244994238608425u, 4327617408008032323u, 8649685863831225006u, 5133200156448565829u, 2767851u},
    {8053581719267785316u, 9726151443247544558u, 11039694637337608569u, 1564267318960847868u, 3898879u},
    {4301069677845583948u, 5912570361161880607u, 15788316133629700403u, 288094406765411749u, 2357483u},
    {7577538168761665891u, 8964417295096654063u, 11764489945520985932u, 7105132101564153149u, 3404784u},
    {311557822690213759u, 2572033593445436293u, 10209979424204746267u, 5467126739023988403u, 3788573u},
    {12671731498971402023u, 9207651779467426342u, 2185429517852548769u, 141944436040620692u, 3300390u},
    {3542956167420957622u, 16813374933748046376u, 1817943823014982526u, 17787049583145646959u, 610546u},
    {7914979753424182412u, 10524480791318148678u, 859420803257499867u, 4911178998173376303u, 2300969u},
    {6181635693661224934u, 17947877328820635229u, 8221570079035201539u, 2492403588465268215u, 292319u},
    {6542859373210659471u, 12294633987774402167u, 16308871940717542207u, 1302429028955989138u, 344210u},
    {11188979006824460989u, 9761260198426104768u, 13239827720299124548u, 5915072266190131345u, 554015u},
    {16243097808740618663u, 1216081468976033897u, 7907558139918110622u, 5486596925715591599u, 2390831u},
    {2835518573591406799u, 2732784453406997234u, 13193563222420714971u, 16112946523525017734u, 62321u},
    {12831420334808703861u, 13193526249970817570u, 9062488218207158964u, 11314191899605050128u, 428840u},
    {17341607064676150345u, 1685236481417286847u, 13282680790808053274u, 16509099747728258847u, 1877429u},
    {9382996287011977830u, 531757836737635927u, 9391866658095311825u, 10050638040060643301u, 251847u},
    {13234990921736890030u, 1291188577281004766u, 9342871032033568848u, 10813284872894559969u, 822756u},
    {10767906383719677345u, 4263438940362121826u, 13723153935414647911u, 18029575689662377848u, 1303190u},
    {10668876068710551207u, 6511606934376272142u, 4295008710601833711u, 8815066103066201432u, 141213u},
    {13192870789749738065u, 1905252617530164651u, 18051091670283771328u, 7136306738640812513u, 1793001u},
    {3298656436100763360u, 6359732545322737720u, 7339076420894569708u, 1185996542314059014u, 1988463u},
    {5356364108977151127u, 15754782309406975781u, 8283791229976640580u, 17979021584691093322u, 3298854u},
    {6044464503132140273u, 15550980771814298753u, 16191470718728899226u, 13535623218546078665u, 3796063u},
    {18104790457626444879u, 499345888248204407u, 3360378322432791763u, 7924302766318446344u, 3374758u},
    {6093687254364530978u, 3396254309378468364u, 5736112324315119994u, 8853279777688214857u, 3743444u},
    {14486860555351621197u, 15133217604672887569u, 7891892714625143305u, 18155510465795455292u, 2725765u},
    {1132796877625797433u, 7726585104697775938u, 13946504657791183041u, 7472213693422162789u, 1553011u},
    {13004232087919639859u, 14438157407940878867u, 16360021926960286021u, 15232800345935663933u, 3121289u},
    {18131271466680297326u, 11448760194971697390u, 10876513123658431452u, 5822185157630120038u, 3178685u},
    {4336846336397494128u, 2348791099149746199u, 13071823993215455990u, 3445343314290737595u, 2839098u},
    {12802449300467157078u, 3467364351363007272u, 15949423191553045784u, 11941875133909633394u, 1537965u},
    {14374671818035683146u, 10426792023339601096u, 8499057584590477219u, 2334213467904891796u, 271375u},
    {6585560992943418815u, 2421901724551153673u, 8756370509248011347u, 17226770962571993101u, 1279268u},
    {14498137511664355427u, 13582462566798367666u, 4587524278881828831u, 17605651291878873617u, 238u},
    {727431908673339912u, 16939099644694428298u, 13874870284098169787u, 4407930740834u, 0u},
    {17495784791966273762u, 17341000705859382747u, 17169137977623855828u, 4407u, 0u},
    {5085534689834506474u, 11396906529410551655u, 81311970270815u, 0u, 0u},
    {2793550854607092996u, 17898337417891493249u, 81311u, 0u, 0u},
    {4481485673368483845u, 1499941105714815u, 0u, 0u, 0u},
    {1950094141586037287u, 1499941u, 0u, 0u, 0u},
    {27669029702758121u, 0u, 0u, 0u, 0u},
    {27669030u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1318196u},
    {14046376871840856031u, 4952090722795321974u, 1881655259298307353u, 7950651768423060596u, 1644966u},
    {2785896184200364589u, 10735285356131013985u, 13034942560243803228u, 13937459924082697122u, 3130583u},
    {9750182144337853284u, 9629407537254130910u, 5706855392060411261u, 17711859616632310113u, 2888563u},
    {6399944057171624488u, 13663163869594883942u, 3262821746683671639u, 14248630625585449692u, 225609u},
    {10823217241889193790u, 2718139097671871631u, 15052244994238608424u, 4327617408008032323u, 3818226u},
    {1771248979636434831u, 17677320198510536628u, 8053581719267785315u, 9726151443247544558u, 208581u},
    {10519674403320641406u, 13694770196897297222u, 4301069677845583947u, 5912570361161880607u, 1587035u},
    {17161794177878963586u, 11244541566357076814u, 7577538168761665890u, 8964417295096654063u, 2711470u},
    {11184591182664302872u, 12412482389091765403u, 311557822690213758u, 2572033593445436293u, 3054053u},
    {16241222346713000863u, 13193930667620843440u, 12671731498971402022u, 9207651779467426342u, 1298631u},
    {7264887137748358647u, 9403918266398053552u, 3542956167420957621u, 16813374933748046376u, 220746u},
    {16460822216361326608u, 17723030591374925485u, 7914979753424182411u, 10524480791318148678u, 300129u},
    {932859482773616684u, 10393336192439704377u, 6181635693661224933u, 17947877328820635229u, 2430943u},
    {3454530193778488900u, 14871543813922812559u, 6542859373210659470u, 12294633987774402167u, 1815225u},
    {3676119385195842312u, 16226289987773446717u, 11188979006824460988u, 9761260198426104768u, 3423908u},
    {6499583013960315375u, 16492424523187022007u, 16243097808740618662u, 1216081468976033897u, 3613292u},
    {17332882873648836903u, 17266509709130296294u, 2835518573591406798u, 2732784453406997234u, 378741u},
    {9821756798716174120u, 15840105484523919483u, 12831420334808703860u, 13193526249970817570u, 1513102u},
    {13731803429722255350u, 13537945440125113713u, 17341607064676150344u, 1685236481417286847u, 1482900u},
    {15610875373997038901u, 1266322803550945589u, 9382996287011977829u, 531757836737635927u, 3589223u},
    {7983137920747032167u, 4818742402439523181u, 13234990921736890029u, 1291188577281004766u, 652738u},
    {11829317551774974082u, 6737828470199048248u, 10767906383719677344u, 4263438940362121826u, 1432419u},
    {14049966915214822641u, 4287765331301549158u, 10668876068710551206u, 6511606934376272142u, 1721451u},
    {1604662026496967878u, 9252431824271154302u, 13192870789749738064u, 1905252617530164651u, 1011792u},
    {9141786037024652262u, 15095952641849489618u, 3298656436100763359u, 6359732545322737720u, 2505960u},
    {14493758865920036256u, 944411312163049946u, 5356364108977151126u, 15754782309406975781u, 3176606u},
    {15565873159085374358u, 3301258060402739508u, 6044464503132140272u, 15550980771814298753u, 3632094u},
    {12592073142206402214u, 8303690872469265283u, 18104790457626444878u, 499345888248204407u, 517565u},
    {10020141583693054886u, 1362130280201614826u, 6093687254364530977u, 3396254309378468364u, 60870u},
    {14247917632788538712u, 12487226796861850070u, 14486860555351621196u, 15133217604672887569u, 890267u},
    {9254298054435755652u, 11624795977529907060u, 1132796877625797432u, 7726585104697775938u, 1444081u},
    {7457492463327111282u, 11200958493528561239u, 13004232087919639858u, 14438157407940878867u, 3451033u},
    {7216249834797331728u, 10060355761083788165u, 18131271466680297325u, 11448760194971697390u, 2328220u},
    {14315417273369634227u, 5420905676137665798u, 4336846336397494127u, 2348791099149746199u, 466198u},
    {13067123471116473767u, 9816729993703878847u, 12802449300467157077u, 3467364351363007272u, 2737528u},
    {10993049356140036814u, 5630488580048419986u, 14374671818035683145u, 10426792023339601096u, 2385305u},
    {8261952871191511727u, 2304152573664011862u, 6585560992943418814u, 2421901724551153673u, 1931771u},
    {6072889333788581041u, 16555453971605233895u, 14498137511664355426u, 13582462566798367666u, 301681u},
    {13430376765620178392u, 683658820061411732u, 727431908673339911u, 16939099644694428298u, 2557531u},
    {13362075655456164027u, 6062423104791466032u, 17495784791966273761u, 17341000705859382747u, 640040u},
    {6927108066265753408u, 17025259250547833660u, 5085534689834506473u, 11396906529410551655u, 1520815u},
    {7528742493475790373u, 11006943337054026185u, 2793550854607092995u, 17898337417891493249u, 81311u},
    {15220469509235657142u, 2394981284699896215u, 4481485673368483844u, 1499941105714815u, 0u},
    {11656659170428876798u, 3447233161347141192u, 1950094141586037286u, 1499941u, 0u},
    {9670142302521856811u, 2702299366381936521u, 27669029702758120u, 0u, 0u},
    {1569051302105865850u, 12963599188063565286u, 27669029u, 0u, 0u},
    {5601651754467747060u, 510403509694646909u, 0u, 0u, 0u},
    {12813973757518059949u, 510403509u, 0u, 0u, 0u},
    {9415282917660283550u, 0u, 0u, 0u, 0u},
    {9415282918u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2828376u},
    {8240841188795400295u, 15588890659805396943u, 14046376871840856030u, 4952090722795321974u, 3835985u},
    {5569775363105053146u, 6546937164522616449u, 2785896184200364588u, 10735285356131013985u, 2479978u},
    {2272622365614846153u, 8964053544384631388u, 9750182144337853283u, 9629407537254130910u, 2400347u},
    {11441899008581666450u, 4937807399376358139u, 6399944057171624487u, 13663163869594883942u, 2819365u},
    {2919192151358327135u, 771446513002411516u, 10823217241889193789u, 2718139097671871631u, 1258198u},
    {16175040161524358904u, 9727259111332767700u, 1771248979636434830u, 17677320198510536628u, 207479u},
    {8786415393079631325u, 14862635825203308914u, 10519674403320641405u, 13694770196897297222u, 192819u},
    {7324066683358741517u, 18221447011883968751u, 17161794177878963585u, 11244541566357076814u, 1007018u},
    {5905862052703438780u, 973862981048259365u, 11184591182664302871u, 12412482389091765403u, 400664u},
    {11137565089655447797u, 6099432586355824782u, 16241222346713000862u, 13193930667620843440u, 1974930u},
    {13677591014302857514u, 12890547539278126509u, 7264887137748358646u, 9403918266398053552u, 3736163u},
    {8263185909590172353u, 785499379717712108u, 16460822216361326607u, 17723030591374925485u, 923883u},
    {4051095893757478191u, 11570978752138008670u, 932859482773616683u, 10393336192439704377u, 1500505u},
    {3006335798903580880u, 3081071037597410984u, 3454530193778488899u, 14871543813922812559u, 722692u},
    {12529650306932123564u, 10248896548387120547u, 3676119385195842311u, 16226289987773446717u, 3431124u},
    {4964206612172816937u, 16543843026980918793u, 6499583013960315374u, 16492424523187022007u, 2425616u},
    {14877655214805302954u, 4681517697295272482u, 17332882873648836902u, 17266509709130296294u, 3225088u},
    {8885520413637786502u, 3017078150264862998u, 9821756798716174119u, 15840105484523919483u, 3424742u},
    {6739691023568204640u, 10532223853687023700u, 13731803429722255349u, 13537945440125113713u, 2241246u},
    {4685883035689187550u, 15090907477071866159u, 15610875373997038900u, 1266322803550945589u, 3412049u},
    {10634179895294936816u, 2403501341809416807u, 7983137920747032166u, 4818742402439523181u, 1977163u},
    {15522061639988645212u, 6678127000988539899u, 11829317551774974081u, 6737828470199048248u, 1971474u},
    {3830698611595505816u, 13232753292082391627u, 14049966915214822640u, 4287765331301549158u, 1575334u},
    {9390115462334924251u, 3744472716781295804u, 1604662026496967877u, 9252431824271154302u, 1946982u},
    {2473682933167744615u, 10024803768049155665u, 9141786037024652261u, 15095952641849489618u, 415389u},
    {4755197871318507891u, 15500270242350578959u, 14493758865920036255u, 944411312163049946u, 3180308u},
    {16990380698948360618u, 11663091181432298576u, 15565873159085374357u, 3301258060402739508u, 925234u},
    {13665916186511886791u, 3174684463834320203u, 12592073142206402213u, 8303690872469265283u, 3528730u},
    {11245698546116525868u, 16655204058524819458u, 10020141583693054885u, 1362130280201614826u, 1152671u},
    {3694061784631000923u, 6606012918825216908u, 14247917632788538711u, 12487226796861850070u, 1275202u},
    {9891712261947617321u, 9073325175700823032u, 9254298054435755651u, 11624795977529907060u, 1736426u},
    {4542217508598893661u, 9855373491220502128u, 7457492463327111281u, 11200958493528561239u, 2404228u},
    {2474824339056151514u, 1973054034545220287u, 7216249834797331727u, 10060355761083788165u, 899135u},
    {16770014711371832065u, 8895885644674946791u, 14315417273369634226u, 5420905676137665798u, 915999u},
    {17770873815916177993u, 13538957163306360547u, 13067123471116473766u, 9816729993703878847u, 541897u},
    {9768313722327297066u, 17651920924309752159u, 10993049356140036813u, 5630488580048419986u, 3814611u},
    {9051356877558766837u, 5966005495367822315u, 8261952871191511726u, 2304152573664011862u, 2941708u},
    {3774738267154890578u, 12960453025338523956u, 6072889333788581040u, 16555453971605233895u, 1904968u},
    {5136552042988123287u, 5252134259238337751u, 13430376765620178391u, 683658820061411732u, 519615u},
    {4691457843059308407u, 9183651461302986459u, 13362075655456164026u, 6062423104791466032u, 1066153u},
    {17657669013149341105u, 7735098068224041941u, 6927108066265753407u, 17025259250547833660u, 2937593u},
    {1005457161781381485u, 11319168896565264805u, 7528742493475790372u, 11006943337054026185u, 925945u},
    {3312445623362864654u, 16703180930505273978u, 15220469509235657141u, 2394981284699896215u, 3281134u},
    {9856223345405842449u, 6431672888206517397u, 11656659170428876797u, 3447233161347141192u, 1960692u},
    {5271174339730948491u, 4588270115313519435u, 9670142302521856810u, 2702299366381936521u, 3539370u},
    {17991561279569209252u, 14533220579010857575u, 1569051302105865849u, 12963599188063565286u, 325279u},
    {8807102071762500324u, 10383012764076947993u, 5601651754467747059u, 510403509694646909u, 0u},
    {708997684247820969u, 5499011367584209741u, 12813973757518059948u, 510403509u, 0u},
    {12338746960911069334u, 2602475735216039174u, 9415282917660283549u, 0u, 0u},
    {7880529471538140638u, 12180081647086136071u, 9415282917u, 0u, 0u},
    {17352482171673218285u, 7660617700262647252u, 9u, 0u, 0u},
    {11964775821353590828u, 173681314363u, 0u, 0u, 0u},
    {12568031699968224028u, 173u, 0u, 0u, 0u},
    {3203854756452u, 0u, 0u, 0u, 0u},
    {3204u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1325456u},
    {5996678188806087497u, 8921286975312087473u, 8240841188795400294u, 15588890659805396943u, 3347674u},
    {8324010055995596852u, 13655451820145123554u, 5569775363105053145u, 6546937164522616449u, 1567316u},
    {14309190188633688241u, 2721943000759599228u, 2272622365614846152u, 8964053544384631388u, 2054075u},
    {3287449394556261627u, 8873849773695936760u, 11441899008581666449u, 4937807399376358139u, 2757699u},
    {12438547888765241861u, 4941307521400188166u, 2919192151358327134u, 771446513002411516u, 3878273u},
    {678335011817856779u, 3343149144451504213u, 16175040161524358903u, 9727259111332767700u, 1017602u},
    {2912889441547098796u, 6013834383560805398u, 8786415393079631324u, 14862635825203308914u, 3411621u},
    {17555917269122280807u, 16440965475706546237u, 7324066683358741516u, 18221447011883968751u, 2011967u},
    {3369740193988598501u, 4109696337916997543u, 5905862052703438779u, 973862981048259365u, 2525903u},
    {10945282166746569307u, 13792028944357852191u, 11137565089655447796u, 6099432586355824782u, 3485482u},
    {2807022443876894264u, 17311850585877969929u, 13677591014302857513u, 12890547539278126509u, 3519506u},
    {7756808237861946507u, 828384134953902162u, 8263185909590172352u, 785499379717712108u, 2264015u},
    {4127822063066179164u, 16673914570245738654u, 4051095893757478190u, 11570978752138008670u, 2962695u},
    {10159211043844921979u, 15082479110506046760u, 3006335798903580879u, 3081071037597410984u, 906295u},
    {1868844227059255999u, 4029627487590067847u, 12529650306932123563u, 10248896548387120547u, 2312277u},
    {8529890288658179717u, 5969787470109008958u, 4964206612172816936u, 16543843026980918793u, 3785582u},
    {16715251776061556100u, 6839385231513726102u, 14877655214805302953u, 4681517697295272482u, 3399884u},
    {6295984560217228443u, 7500537809080991181u, 8885520413637786501u, 3017078150264862998u, 640499u},
    {6235128427504144163u, 10268339753101670513u, 6739691023568204639u, 10532223853687023700u, 1673483u},
    {10165283179145715391u, 17441859305429297957u, 4685883035689187549u, 15090907477071866159u, 1387818u},
    {14944548057745062109u, 11617639549674399874u, 10634179895294936815u, 2403501341809416807u, 2646990u},
    {8899944291830794317u, 14042848962101142702u, 15522061639988645211u, 6678127000988539899u, 2505243u},
    {9829354044936504669u, 3269423512682252531u, 3830698611595505815u, 13232753292082391627u, 3769522u},
    {16851731507576629945u, 12216708211513756374u, 9390115462334924250u, 3744472716781295804u, 476951u},
    {8423430730944035539u, 15851179650237376188u, 2473682933167744614u, 10024803768049155665u, 427583u},
    {5244059229376537249u, 15920279902793366595u, 4755197871318507890u, 15500270242350578959u, 3351189u},
    {11536676445695695250u, 18328257295136973653u, 16990380698948360617u, 11663091181432298576u, 224989u},
    {18404787427019177530u, 4997839422742885979u, 13665916186511886790u, 3174684463834320203u, 536671u},
    {14456591655800308767u, 11479184050044011168u, 11245698546116525867u, 16655204058524819458u, 2643927u},
    {15210367617940141112u, 12154517383262246593u, 3694061784631000922u, 6606012918825216908u, 3584693u},
    {13134737042487810606u, 8887037323573317953u, 9891712261947617320u, 9073325175700823032u, 3010867u},
    {16225802161889610697u, 6550980868589160983u, 4542217508598893660u, 9855373491220502128u, 1490723u},
    {15203026534991034091u, 6254464434024411338u, 2474824339056151513u, 1973054034545220287u, 1778177u},
    {6812102395581484299u, 13192761193228784521u, 16770014711371832064u, 8895885644674946791u, 3479588u},
    {15052625978393243397u, 67449573667588335u, 17770873815916177992u, 13538957163306360547u, 3787550u},
    {11545718237792455178u, 7726321799253843850u, 9768313722327297065u, 17651920924309752159u, 3105305u},
    {14198416017953244669u, 3331668096639226476u, 9051356877558766836u, 5966005495367822315u, 3368816u},
    {15530779224313979069u, 11293723398046327656u, 3774738267154890577u, 12960453025338523956u, 3468768u},
    {11413409206209599624u, 9319473700261166456u, 5136552042988123286u, 5252134259238337751u, 1752993u},
    {4247728375065598095u, 12338413028113578985u, 4691457843059308406u, 9183651461302986459u, 1351756u},
    {4873311785100705234u, 2099108257789219632u, 17657669013149341104u, 7735098068224041941u, 332125u},
    {14091537752833565772u, 12313049670129066594u, 1005457161781381484u, 11319168896565264805u, 3137502u},
    {17867084854542725382u, 11375724792245546594u, 3312445623362864653u, 16703180930505273978u, 1005435u},
    {17761587191090964610u, 12189174277374245450u, 9856223345405842448u, 6431672888206517397u, 2636871u},
    {8989649335338757104u, 12719033297638867089u, 5271174339730948490u, 4588270115313519435u, 2691216u},
    {4329373827932773363u, 8197289361093609026u, 17991561279569209251u, 14533220579010857575u, 364249u},
    {14204785154956718103u, 13114472807494416489u, 8807102071762500323u, 10383012764076947993u, 1227003u},
    {836134715836846537u, 5621707601125683727u, 708997684247820968u, 5499011367584209741u, 455492u},
    {9957289456594291802u, 4239592617267627628u, 12338746960911069333u, 2602475735216039174u, 127299u},
    {12074224183470484214u, 9079706234150892191u, 7880529471538140637u, 12180081647086136071u, 1220417u},
    {7591547076706253199u, 4290316536795565027u, 17352482171673218284u, 7660617700262647252u, 9u},
    {5763628875512439444u, 12574787941437969382u, 11964775821353590827u, 173681314363u, 0u},
    {17202296139559059930u, 11515406471665721310u, 12568031699968224027u, 173u, 0u},
    {10591766840242427666u, 13293712444279139829u, 3203854756451u, 0u, 0u},
    {6873527005022905249u, 15767473510242971188u, 3203u, 0u, 0u},
    {17280858868324015226u, 59100688741601u, 0u, 0u, 0u},
    {12705040063844837458u, 59100u, 0u, 0u, 0u},
    {1090215279796299u, 0u, 0u, 0u, 0u},
    {1090216u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3155186u},
    {11183867204584591889u, 572048586268897342u, 5996678188806087496u, 8921286975312087473u, 1982276u},
    {14964236065799331528u, 13627490126448491784u, 8324010055995596851u, 13655451820145123554u, 3025575u},
    {619862709446141156u, 11657370401500403360u, 14309190188633688240u, 2721943000759599228u, 583610u},
    {4098677048842999935u, 4819707159098881715u, 3287449394556261626u, 8873849773695936760u, 2243817u},
    {963951642015149703u, 3184523009495905097u, 12438547888765241860u, 4941307521400188166u, 1544978u},
    {4272576590052029139u, 8365341735721274925u, 678335011817856778u, 3343149144451504213u, 1791865u},
    {9536659386070890849u, 63095731410403802u, 2912889441547098795u, 6013834383560805398u, 641524u},
    {12832284091854352050u, 841557195902600330u, 17555917269122280806u, 16440965475706546237u, 130834u},
    {5958467357709672591u, 9997842022454850337u, 3369740193988598500u, 4109696337916997543u, 1573637u},
    {2427622830183337436u, 8545702495319023939u, 10945282166746569306u, 13792028944357852191u, 977300u},
    {18105171821996583077u, 3979124335616426621u, 2807022443876894263u, 17311850585877969929u, 1938043u},
    {17469339317232270704u, 11678082765032880127u, 7756808237861946506u, 828384134953902162u, 1550970u},
    {9013278673420983406u, 6213834046483130198u, 4127822063066179163u, 16673914570245738654u, 1216580u},
    {7731833068139598859u, 15102063583953909972u, 10159211043844921978u, 15082479110506046760u, 3602793u},
    {17737051867639546550u, 565996778042699033u, 1868844227059255998u, 4029627487590067847u, 3310327u},
    {653457940972740867u, 10556202091327826647u, 8529890288658179716u, 5969787470109008958u, 3576316u},
    {14728649458523364682u, 16362851192942288657u, 16715251776061556099u, 6839385231513726102u, 354969u},
    {5039639003344541039u, 3124173704591913163u, 6295984560217228442u, 7500537809080991181u, 1960313u},
    {14979520238584583892u, 8881603051312812030u, 6235128427504144162u, 10268339753101670513u, 212587u},
    {17965223231003297464u, 1321521839736591682u, 10165283179145715390u, 17441859305429297957u, 887251u},
    {7257801560606206956u, 12232245514717514709u, 14944548057745062108u, 11617639549674399874u, 3451867u},
    {9736461091632852022u, 17449639350833499238u, 8899944291830794316u, 14042848962101142702u, 1454553u},
    {9565070199760131337u, 14009562722142593229u, 9829354044936504668u, 3269423512682252531u, 2112829u},
    {14024591664036500799u, 4980875257618429965u, 16851731507576629944u, 12216708211513756374u, 3825420u},
    {11806955381632608979u, 8239087867645557606u, 8423430730944035538u, 15851179650237376188u, 3665102u},
    {8895981706705239945u, 1534102412947410551u, 5244059229376537248u, 15920279902793366595u, 1389318u},
    {4138721968577346501u, 17392176477967153871u, 11536676445695695249u, 18328257295136973653u, 1402167u},
    {7143329261859377017u, 5236913504646706052u, 18404787427019177529u, 4997839422742885979u, 1194064u},
    {9514234475381229988u, 10447622992407642687u, 14456591655800308766u, 11479184050044011168u, 2647707u},
    {1988164684612060451u, 484921488509897592u, 15210367617940141111u, 12154517383262246593u, 1298508u},
    {7362308511019233638u, 9501789612641167023u, 13134737042487810605u, 8887037323573317953u, 3566884u},
    {11851301384617011735u, 12392444408684761638u, 16225802161889610696u, 6550980868589160983u, 3117696u},
    {17138413152458092596u, 4518245893388863949u, 15203026534991034090u, 6254464434024411338u, 337267u},
    {520876099414987261u, 12742771925301049611u, 6812102395581484298u, 13192761193228784521u, 3656448u},
    {4109956033706721924u, 7649653048381644942u, 15052625978393243396u, 67449573667588335u, 875994u},
    {7813252416785099900u, 17366318649896917700u, 11545718237792455177u, 7726321799253843850u, 922589u},
    {3102503955290790377u, 3884817191587865991u, 14198416017953244668u, 3331668096639226476u, 2858972u},
    {8405470100167672903u, 586848412924051707u, 15530779224313979068u, 11293723398046327656u, 1303431u},
    {4814580049352390508u, 2224247526739302905u, 11413409206209599623u, 9319473700261166456u, 897960u},
    {10591304534001480341u, 4951517086619109355u, 4247728375065598094u, 12338413028113578985u, 511636u},
    {12935581450949937070u, 968267203303801868u, 4873311785100705233u, 2099108257789219632u, 3429260u},
    {7652623453985667623u, 3372675497104933393u, 14091537752833565771u, 12313049670129066594u, 3398026u},
    {14313077562574674821u, 12522895607680760813u, 17867084854542725381u, 11375724792245546594u, 620211u},
    {10770102561913459476u, 5793356804642750897u, 17761587191090964609u, 12189174277374245450u, 2000176u},
    {16042283619303032320u, 670134523541442186u, 8989649335338757103u, 12719033297638867089u, 2969696u},
    {15623319273158482449u, 4352699321666094656u, 4329373827932773362u, 8197289361093609026u, 3905745u},
    {14095840134597372686u, 12109809681178022732u, 14204785154956718102u, 13114472807494416489u, 65879u},
    {1268197657389515829u, 13027536165832875118u, 836134715836846536u, 5621707601125683727u, 3266276u},
    {6525519152166773351u, 1406697507927077954u, 9957289456594291801u, 4239592617267627628u, 24361u},
    {4474150679807678939u, 17104158036330700071u, 12074224183470484213u, 9079706234150892191u, 2109775u},
    {2944778737651505787u, 14036077204731690560u, 7591547076706253198u, 4290316536795565027u, 1993120u},
    {13934363522403587502u, 15944803887993569165u, 5763628875512439443u, 12574787941437969382u, 3157685u},
    {6640920206423891021u, 1116030153779800237u, 17202296139559059929u, 11515406471665721310u, 1903595u},
    {4873334292521666991u, 6673685374216256852u, 10591766840242427665u, 13293712444279139829u, 3193951u},
    {11851786107222062383u, 13787907907402286366u, 6873527005022905248u, 15767473510242971188u, 3203u},
    {14386666443484068114u, 12747412655764311031u, 17280858868324015225u, 59100688741601u, 0u},
    {7077013817458146012u, 5902818677396016002u, 12705040063844837457u, 59100u, 0u},
    {10417727038657012658u, 6370454996014308562u, 1090215279796298u, 0u, 0u},
    {7582093838134998784u, 5161330708347826665u, 1090215u, 0u, 0u},
    {3004312471310853993u, 20110922251649967u, 0u, 0u, 0u},
    {4642122540410766704u, 20110922u, 0u, 0u, 0u},
    {370981035862457584u, 0u, 0u, 0u, 0u},
    {370981036u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3667066u},
    {1244844139083335697u, 2049582611429151937u, 11183867204584591888u, 572048586268897342u, 466470u},
    {1899830486990840114u, 13589289872428425122u, 14964236065799331527u, 13627490126448491784u, 3041065u},
    {8887170867745724715u, 16061489892436420098u, 619862709446141155u, 11657370401500403360u, 3464348u},
    {7118608618853951082u, 131739338878526247u, 4098677048842999934u, 4819707159098881715u, 758338u},
    {527087661527122945u, 8360461056227981034u, 963951642015149702u, 3184523009495905097u, 361084u},
    {7797991421830051616u, 15486313895288669443u, 4272576590052029138u, 8365341735721274925u, 3420426u},
    {6511902602324838041u, 1912156191347248896u, 9536659386070890848u, 63095731410403802u, 2652157u},
    {116798296732717538u, 7065941792489434181u, 12832284091854352049u, 841557195902600330u, 2921602u},
    {2428610463019374784u, 13544666484107462023u, 5958467357709672590u, 9997842022454850337u, 2325960u},
    {8066914201603888806u, 8934956136895837177u, 2427622830183337435u, 8545702495319023939u, 865012u},
    {16982479777305866411u, 14230746830470478128u, 18105171821996583076u, 3979124335616426621u, 257635u},
    {5350664078742198216u, 4261551556235034413u, 17469339317232270703u, 11678082765032880127u, 915118u},
    {9345804945743801626u, 11263540301367229410u, 9013278673420983405u, 6213834046483130198u, 2278257u},
    {14466166373912553007u, 5117045006000603017u, 7731833068139598858u, 15102063583953909972u, 3338996u},
    {3523128778581486154u, 4970508141662999334u, 17737051867639546549u, 565996778042699033u, 1940362u},
    {15417842527928779104u, 15191280190511924038u, 653457940972740866u, 10556202091327826647u, 313190u},
    {15362997565787255153u, 4894973752269781953u, 14728649458523364681u, 16362851192942288657u, 1393045u},
    {11328502698440044304u, 17780962586629465818u, 5039639003344541038u, 3124173704591913163u, 1003916u},
    {13705548826024933025u, 8391869238206865112u, 14979520238584583891u, 8881603051312812030u, 1327342u},
    {3514124682230818016u, 5640171754203195291u, 17965223231003297463u, 1321521839736591682u, 2955108u},
    {4525489164591782943u, 2174369804766836685u, 7257801560606206955u, 12232245514717514709u, 634344u},
    {12328558459040769555u, 3851155594703700103u, 9736461091632852021u, 17449639350833499238u, 1647416u},
    {3487602376499761751u, 13549471562575971984u, 9565070199760131336u, 14009562722142593229u, 482538u},
    {4734401732486746061u, 872433757001176757u, 14024591664036500798u, 4980875257618429965u, 1329348u},
    {12973911897710307199u, 8258329256452032917u, 11806955381632608978u, 8239087867645557606u, 1132608u},
    {1979122942677032842u, 11653869333233260933u, 8895981706705239944u, 1534102412947410551u, 1425526u},
    {189374073725640389u, 10823926229304848018u, 4138721968577346500u, 17392176477967153871u, 2643649u},
    {14236010913740978340u, 2093612860534710315u, 7143329261859377016u, 5236913504646706052u, 3866777u},
    {8746635780755642598u, 9632047847985216610u, 9514234475381229987u, 10447622992407642687u, 2850146u},
    {4228559881016487158u, 9244304581558185938u, 1988164684612060450u, 484921488509897592u, 3374297u},
    {4944118523850570505u, 11464938371712113389u, 7362308511019233637u, 9501789612641167023u, 3827007u},
    {5526986550509370837u, 17236360917437805537u, 11851301384617011734u, 12392444408684761638u, 2747100u},
    {13023294496470999140u, 2314998920297088015u, 17138413152458092595u, 4518245893388863949u, 3287050u},
    {7728596941390019741u, 6301942346090693781u, 520876099414987260u, 12742771925301049611u, 626022u},
    {16045517920793458342u, 12328266541092256281u, 4109956033706721923u, 7649653048381644942u, 23770u},
    {10328836006410333690u, 7883351030160942609u, 7813252416785099899u, 17366318649896917700u, 3565111u},
    {13875125297629556477u, 6478767970409190193u, 3102503955290790376u, 3884817191587865991u, 563116u},
    {4799375030871385428u, 6613872162408128848u, 8405470100167672902u, 586848412924051707u, 3389200u},
    {6318324772859722829u, 7447994933139407142u, 4814580049352390507u, 2224247526739302905u, 2797279u},
    {2187896710640520550u, 1513799058631821420u, 10591304534001480340u, 4951517086619109355u, 1708620u},
    {13340413411286997961u, 14395815833739200265u, 12935581450949937069u, 968267203303801868u, 3145605u},
    {8051554752423646381u, 2401888523833216664u, 7652623453985667622u, 3372675497104933393u, 3086281u},
    {18021063326167370014u, 18111305641076518301u, 14313077562574674820u, 12522895607680760813u, 1558501u},
    {137060156592208612u, 16061323378199682491u, 10770102561913459475u, 5793356804642750897u, 1171815u},
    {18360899623095666276u, 5028059798954706735u, 16042283619303032319u, 670134523541442186u, 1585303u},
    {845498102817335237u, 5086432591081313367u, 15623319273158482448u, 4352699321666094656u, 224098u},
    {17670067508717179323u, 7067191747042145139u, 14095840134597372685u, 12109809681178022732u, 3099150u},
    {15322055480736483626u, 5655218282404096764u, 1268197657389515828u, 13027536165832875118u, 2038474u},
    {5998647357164523324u, 6865226241954348498u, 6525519152166773350u, 1406697507927077954u, 1437015u},
    {6819181361308879309u, 17909775114108531758u, 4474150679807678938u, 17104158036330700071u, 3084769u},
    {2388668269734532694u, 8890543686442106396u, 2944778737651505786u, 14036077204731690560u, 1088300u},
    {10247696347185050016u, 8098407430332406734u, 13934363522403587501u, 15944803887993569165u, 1906365u},
    {17020730154787897513u, 8659373562457820522u, 6640920206423891020u, 1116030153779800237u, 2406209u},
    {7426570230896272208u, 1176059559505779608u, 4873334292521666990u, 6673685374216256852u, 1350235u},
    {17324490657486698475u, 5988403091271145392u, 11851786107222062382u, 13787907907402286366u, 3538624u},
    {7156574941180528775u, 14894018898222173480u, 14386666443484068113u, 12747412655764311031u, 3586191u},
    {15749541590212477294u, 12291956661179173679u, 7077013817458146011u, 5902818677396016002u, 1593057u},
    {2849273756751293582u, 5101746568766369835u, 10417727038657012657u, 6370454996014308562u, 2452548u},
    {1005694851717120050u, 7687472832141700014u, 7582093838134998783u, 5161330708347826665u, 1090215u},
    {176539436968279625u, 482243332104894058u, 3004312471310853992u, 20110922251649967u, 0u},
    {368327651729312099u, 1144632718893985953u, 4642122540410766703u, 20110922u, 0u},
    {8812939969023249853u, 11346899511405925550u, 370981035862457583u, 0u, 0u},
    {2859792802708540022u, 15909534319378013242u, 370981035u, 0u, 0u},
    {4936640212434321574u, 6843392224754420067u, 0u, 0u, 0u},
    {13916593904956453082u, 6843392224u, 0u, 0u, 0u},
    {15557840523801312573u, 6u, 0u, 0u, 0u},
    {126238304967u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1733096u},
    {2988483515553294799u, 3717900242497340198u, 1244844139083335696u, 2049582611429151937u, 2301880u},
    {3277242762846083311u, 1430603445919301482u, 1899830486990840113u, 13589289872428425122u, 3507611u},
    {16017735441113386872u, 10963432764851782776u, 8887170867745724714u, 16061489892436420098u, 3235353u},
    {1392278650305550307u, 14301890740856167785u, 7118608618853951081u, 131739338878526247u, 96502u},
    {4985050056779675619u, 980318009388928130u, 527087661527122944u, 8360461056227981034u, 3577258u},
    {13607246415660587362u, 3612638694574493815u, 7797991421830051615u, 15486313895288669443u, 2095694u},
    {17339247450183787869u, 13643063737833078960u, 6511902602324838040u, 1912156191347248896u, 232972u},
    {10741743628958608648u, 7289806620358445386u, 116798296732717537u, 7065941792489434181u, 3789091u},
    {2105331523560233183u, 16619234903944567950u, 2428610463019374783u, 13544666484107462023u, 3896192u},
    {10232312979829348368u, 7873614621568878186u, 8066914201603888805u, 8934956136895837177u, 1919081u},
    {3062258290335869190u, 4174660025039844806u, 16982479777305866410u, 14230746830470478128u, 550422u},
    {16966205556617293943u, 14885705096428362108u, 5350664078742198215u, 4261551556235034413u, 1222743u},
    {5474193143137377777u, 8896927972414738738u, 9345804945743801625u, 11263540301367229410u, 51815u},
    {8204040714605793978u, 17130030709188952604u, 14466166373912553006u, 5117045006000603017u, 3826786u},
    {5842181771665398962u, 8194761202335816396u, 3523128778581486153u, 4970508141662999334u, 3208449u},
    {8198069762171539857u, 13021586920933358645u, 15417842527928779103u, 15191280190511924038u, 3638308u},
    {9463887870069315378u, 4555994554773938666u, 15362997565787255152u, 4894973752269781953u, 2970413u},
    {10172713696908061704u, 14788616894377223327u, 11328502698440044303u, 17780962586629465818u, 1799142u},
    {15333177457963027072u, 5793697001762679535u, 13705548826024933024u, 8391869238206865112u, 1066823u},
    {4980967695576598061u, 3480500391943266189u, 3514124682230818015u, 5640171754203195291u, 685323u},
    {5927077835186953884u, 5591550485345129462u, 4525489164591782942u, 2174369804766836685u, 1740313u},
    {12951524358446063105u, 465625894204819714u, 12328558459040769554u, 3851155594703700103u, 143325u},
    {7432527934867064239u, 3887046297687784371u, 3487602376499761750u, 13549471562575971984u, 419728u},
    {9000781879717949341u, 6930291632776452991u, 4734401732486746060u, 872433757001176757u, 2372426u},
    {13488625240652884346u, 2756822153069241282u, 12973911897710307198u, 8258329256452032917u, 2851272u},
    {4594606449832582503u, 4933085524748347093u, 1979122942677032841u, 11653869333233260933u, 828716u},
    {9628059166355384205u, 14053118220948934637u, 189374073725640388u, 10823926229304848018u, 213730u},
    {1788558185594936934u, 6759410118535252041u, 14236010913740978339u, 2093612860534710315u, 2623110u},
    {2595328964789340923u, 18325835615860851353u, 8746635780755642597u, 9632047847985216610u, 1134755u},
    {14857427250754958361u, 5200831452811260422u, 4228559881016487157u, 9244304581558185938u, 421804u},
    {9797918880531002886u, 329266805304732654u, 4944118523850570504u, 11464938371712113389u, 791247u},
    {10442200336740508183u, 14769989958280674031u, 5526986550509370836u, 17236360917437805537u, 496342u},
    {6109622724824431885u, 7230433414500895980u, 13023294496470999139u, 2314998920297088015u, 1785229u},
    {12895521630040816134u, 18038421766859841584u, 7728596941390019740u, 6301942346090693781u, 347918u},
    {15839243094867485483u, 15736335281864050271u, 16045517920793458341u, 12328266541092256281u, 1576065u},
    {8649100984252376960u, 4640445928573930052u, 10328836006410333689u, 7883351030160942609u, 3558465u},
    {11582983993278500820u, 5318470679515517941u, 13875125297629556476u, 6478767970409190193u, 3069978u},
    {3716473896488312748u, 10944939003915296573u, 4799375030871385427u, 6613872162408128848u, 1412864u},
    {7156846703452949977u, 15063127529459802115u, 6318324772859722828u, 7447994933139407142u, 31961u},
    {18051614287851961587u, 10221516445522195499u, 2187896710640520549u, 1513799058631821420u, 3054990u},
    {12704111123477529012u, 9977856958432561174u, 13340413411286997960u, 14395815833739200265u, 1300387u},
    {13130228747963659866u, 1033196095014272767u, 8051554752423646380u, 2401888523833216664u, 1347096u},
    {6546300251331321568u, 7793881819797930887u, 18021063326167370013u, 18111305641076518301u, 3498584u},
    {12536728529087355182u, 11143175115351164112u, 137060156592208611u, 16061323378199682491u, 3040417u},
    {735361313438991275u, 17313767550426511923u, 18360899623095666275u, 5028059798954706735u, 2298563u},
    {8533222728735100581u, 2765863558359284831u, 845498102817335236u, 5086432591081313367u, 300732u},
    {1187941383938666203u, 10001309975371525948u, 17670067508717179322u, 7067191747042145139u, 1882497u},
    {5093219753128467129u, 17754245526657805918u, 15322055480736483625u, 5655218282404096764u, 1070910u},
    {10641514597847141557u, 18140513548465656281u, 5998647357164523323u, 6865226241954348498u, 2140854u},
    {7774242337307477853u, 13208228763127150947u, 6819181361308879308u, 17909775114108531758u, 1488588u},
    {10805423311015807025u, 17339282074323396568u, 2388668269734532693u, 8890543686442106396u, 1515546u},
    {13022151523039884783u, 4788103409623719014u, 10247696347185050015u, 8098407430332406734u, 675581u},
    {3226898804397498749u, 9734127243996436285u, 17020730154787897512u, 8659373562457820522u, 1254316u},
    {13805079240143953071u, 17185081974001365870u, 7426570230896272207u, 1176059559505779608u, 413232u},
    {14092048921043615718u, 11970175755025631700u, 17324490657486698474u, 5988403091271145392u, 2718882u},
    {11525132943270959347u, 15701207030375774718u, 7156574941180528774u, 14894018898222173480u, 2285805u},
    {140225924973976041u, 9851567325803423270u, 15749541590212477293u, 12291956661179173679u, 3128735u},
    {17377053208592351787u, 14044995239008046584u, 2849273756751293581u, 5101746568766369835u, 2676237u},
    {17821502621180711209u, 10174633989100498162u, 1005694851717120049u, 7687472832141700014u, 2704963u},
    {16810713021851828709u, 3739132916269415723u, 176539436968279624u, 482243332104894058u, 3456914u},
    {6526079893388897265u, 4947124125160049331u, 368327651729312098u, 1144632718893985953u, 1835405u},
    {11139253594547708568u, 9392377901271758019u, 8812939969023249852u, 11346899511405925550u, 3082583u},
    {18256927438818471325u, 10627344514325150827u, 2859792802708540021u, 15909534319378013242u, 3793535u},
    {2387054357086525850u, 8942539793381402015u, 4936640212434321573u, 6843392224754420067u, 0u},
    {8723493590596454461u, 2158266206321225907u, 13916593904956453081u, 6843392224u, 0u},
    {17544199257461222069u, 7701277044297410572u, 15557840523801312572u, 6u, 0u},
    {5356854437680173148u, 1081389982517690133u, 126238304966u, 0u, 0u},
    {4497596398122978697u, 4395950720377446174u, 126u, 0u, 0u},
    {14405980915044815254u, 2328685704007u, 0u, 0u, 0u},
    {12649006341852123813u, 2328u, 0u, 0u, 0u},
    {42956669209938u, 0u, 0u, 0u, 0u},
    {42957u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2329026u},
    {7971194062623543553u, 8384448353539466205u, 2988483515553294798u, 3717900242497340198u, 3334418u},
    {11793420187795591436u, 15728567901682959977u, 3277242762846083310u, 1430603445919301482u, 578881u},
    {7637249143122481650u, 115088477241190698u, 16017735441113386871u, 10963432764851782776u, 1869550u},
    {17041524428901980138u, 603534798887822515u, 1392278650305550306u, 14301890740856167785u, 2361895u},
    {14961414254769289329u, 9524238175046096361u, 4985050056779675618u, 980318009388928130u, 529036u},
    {6362292837329121728u, 8206405148524230805u, 13607246415660587361u, 3612638694574493815u, 1310717u},
    {13920046878618287103u, 5364614844446980130u, 17339247450183787868u, 13643063737833078960u, 649958u},
    {17432153720707319466u, 12708074080160116811u, 10741743628958608647u, 7289806620358445386u, 2493029u},
    {5103925650890506057u, 5176020760881800277u, 2105331523560233182u, 16619234903944567950u, 1048253u},
    {16859001032649257158u, 16010422637152512338u, 10232312979829348367u, 7873614621568878186u, 3652523u},
    {16315385771388561110u, 455642545177744330u, 3062258290335869189u, 4174660025039844806u, 2268190u},
    {4319849873526973926u, 6728640363973762548u, 16966205556617293942u, 14885705096428362108u, 1834681u},
    {16663464935941305701u, 10038091053023336670u, 5474193143137377776u, 8896927972414738738u, 2839575u},
    {13316048117639783220u, 17492117404087638709u, 8204040714605793977u, 17130030709188952604u, 2832644u},
    {3922958192093231392u, 12783071709949271062u, 5842181771665398961u, 8194761202335816396u, 2776641u},
    {8364435374136392463u, 10180650946820537215u, 8198069762171539856u, 13021586920933358645u, 887209u},
    {12014897442241476180u, 2887403927499267603u, 9463887870069315377u, 4555994554773938666u, 911278u},
    {10490029149225521239u, 7631425423325418988u, 10172713696908061703u, 14788616894377223327u, 1576943u},
    {4766123572255063022u, 15714175179354562570u, 15333177457963027071u, 5793697001762679535u, 1178304u},
    {10358227727419158907u, 2653679535101475232u, 4980967695576598060u, 3480500391943266189u, 2337309u},
    {1967128332109044583u, 15674592981046934043u, 5927077835186953883u, 5591550485345129462u, 1804130u},
    {2022429504181869800u, 228329294366671752u, 12951524358446063104u, 465625894204819714u, 3685952u},
    {4341042622524027762u, 1034623272960239864u, 7432527934867064238u, 3887046297687784371u, 691862u},
    {7934959201367574798u, 1550058618005775834u, 9000781879717949340u, 6930291632776452991u, 1010128u},
    {10757861831123605594u, 2428682904816612562u, 13488625240652884345u, 2756822153069241282u, 1798102u},
    {11811709713056228530u, 13749328087453622561u, 4594606449832582502u, 4933085524748347093u, 102315u},
    {5439897633930571862u, 10233431454460022089u, 9628059166355384204u, 14053118220948934637u, 3147106u},
    {10879450646051580964u, 7370469137481780628u, 1788558185594936933u, 6759410118535252041u, 1258039u},
    {419976959418619713u, 4163060711863150756u, 2595328964789340922u, 18325835615860851353u, 687637u},
    {5075574187275402506u, 1240485288302243283u, 14857427250754958360u, 5200831452811260422u, 2224589u},
    {11834457365168668041u, 17277071008262877989u, 9797918880531002885u, 329266805304732654u, 3807760u},
    {1111367144809013267u, 8824374679861427991u, 10442200336740508182u, 14769989958280674031u, 1337580u},
    {15422970738816252799u, 5259328300823565393u, 6109622724824431884u, 7230433414500895980u, 1302303u},
    {13761940803453892270u, 17803298255206405292u, 12895521630040816133u, 18038421766859841584u, 1505944u},
    {18411074503899875798u, 16692649487883537742u, 15839243094867485482u, 15736335281864050271u, 1559077u},
    {9179804940940932715u, 14258586645937469861u, 8649100984252376959u, 4640445928573930052u, 3158623u},
    {2827213030689390648u, 9107638636087690550u, 11582983993278500819u, 5318470679515517941u, 3482582u},
    {5655285147611385246u, 14405115343082686818u, 3716473896488312747u, 10944939003915296573u, 167529u},
    {13964743135887692846u, 12483593133363707678u, 7156846703452949976u, 15063127529459802115u, 3328266u},
    {2509064715212950894u, 4818900373126296686u, 18051614287851961586u, 10221516445522195499u, 1838209u},
    {14056409209901383981u, 4568525696521684122u, 12704111123477529011u, 9977856958432561174u, 1322172u},
    {4352608042115948555u, 3417971886606555312u, 13130228747963659865u, 1033196095014272767u, 632180u},
    {10560008064245213814u, 14232685319501223720u, 6546300251331321567u, 7793881819797930887u, 2510233u},
    {12577584695470164163u, 7495174204273931332u, 12536728529087355181u, 11143175115351164112u, 1081219u},
    {16451196046533575868u, 1114276265797130396u, 735361313438991274u, 17313767550426511923u, 1500263u},
    {8555797593147179958u, 16058292302896925604u, 8533222728735100580u, 2765863558359284831u, 3109600u},
    {14777473072708145837u, 9574138293427204836u, 1187941383938666202u, 10001309975371525948u, 1522078u},
    {13198007953828446147u, 8937885402097237768u, 5093219753128467128u, 17754245526657805918u, 2930459u},
    {579458140052480360u, 8021915681788358507u, 10641514597847141556u, 18140513548465656281u, 1175765u},
    {9345739971539968082u, 12429517474405864373u, 7774242337307477852u, 13208228763127150947u, 2464364u},
    {11838385824950259159u, 16303457253690789564u, 10805423311015807024u, 17339282074323396568u, 1751105u},
    {3460119180756723688u, 6838573142386294897u, 13022151523039884782u, 4788103409623719014u, 344345u},
    {2420214910412892682u, 2348781981847986734u, 3226898804397498748u, 9734127243996436285u, 1917660u},
    {2962322456208639266u, 756284559610137933u, 13805079240143953070u, 17185081974001365870u, 467027u},
    {9084762559211202114u, 16627162809951836264u, 14092048921043615717u, 11970175755025631700u, 3507888u},
    {7058900898810034498u, 17476590066766850262u, 11525132943270959346u, 15701207030375774718u, 2804534u},
    {7830518719760989495u, 15261824038790501220u, 140225924973976040u, 9851567325803423270u, 3568217u},
    {8319286270947274062u, 13122539889337033607u, 17377053208592351786u, 14044995239008046584u, 786763u},
    {15013468080130984027u, 11484729961094007969u, 17821502621180711208u, 10174633989100498162u, 3480051u},
    {13895963039567756039u, 8826864006841601826u, 16810713021851828708u, 3739132916269415723u, 2559136u},
    {3466779601123042621u, 1382566727507775972u, 6526079893388897264u, 4947124125160049331u, 1349326u},
    {7087213767653120203u, 9790513790582633137u, 11139253594547708567u, 9392377901271758019u, 1890750u},
    {1997875970602644137u, 16612201937693220764u, 18256927438818471324u, 10627344514325150827u, 401053u},
    {310531532504010730u, 1275056011778530253u, 2387054357086525849u, 8942539793381402015u, 3718595u},
    {9393768246182744990u, 8386930419569872058u, 8723493590596454460u, 2158266206321225907u, 3424565u},
    {16793182556022014083u, 1368505142995335067u, 17544199257461222068u, 7701277044297410572u, 28518u},
    {8564415893873659496u, 5416123219917497463u, 5356854437680173147u, 1081389982517690133u, 23716u},
    {16007313423380539654u, 746513377681867442u, 4497596398122978696u, 4395950720377446174u, 126u},
    {7397779289602372557u, 11664601899677946303u, 14405980915044815253u, 2328685704007u, 0u},
    {8633986451586678497u, 5706326245836316242u, 12649006341852123812u, 2328u, 0u},
    {1277732220537040402u, 12696633114679408370u, 42956669209937u, 0u, 0u},
    {16989756808139578037u, 12344744452118925507u, 42956u, 0u, 0u},
    {11402714726238588169u, 792410683174719u, 0u, 0u, 0u},
    {12602349210424152940u, 792410u, 0u, 0u, 0u},
    {14617397073797397u, 0u, 0u, 0u, 0u},
    {14617398u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1396856u},
    {10069247043632869529u, 14417649324724067537u, 7971194062623543552u, 8384448353539466205u, 1084874u},
    {11832242543388386886u, 14642977055871841983u, 11793420187795591435u, 15728567901682959977u, 2332708u},
    {1500639377154813521u, 2736890214002610577u, 7637249143122481649u, 115088477241190698u, 1467687u},
    {7266784942484822990u, 11432773423199414256u, 17041524428901980137u, 603534798887822515u, 684986u},
    {14314248100334033550u, 4313106901155890008u, 14961414254769289328u, 9524238175046096361u, 3463864u},
    {10845686011274574573u, 3973146221244887678u, 6362292837329121727u, 8206405148524230805u, 1753853u},
    {622372458645795581u, 2593475253661961885u, 13920046878618287102u, 5364614844446980130u, 1406076u},
    {4854151738701797565u, 16064971280109404462u, 17432153720707319465u, 12708074080160116811u, 3248897u},
    {16252917631465525496u, 10992416156200810468u, 5103925650890506056u, 5176020760881800277u, 739250u},
    {11937594173926533789u, 13723486402732633502u, 16859001032649257157u, 16010422637152512338u, 1262931u},
    {5916821175737436746u, 11057585327831760759u, 16315385771388561109u, 455642545177744330u, 1479075u},
    {6348605307288348014u, 6164562257486176411u, 4319849873526973925u, 6728640363973762548u, 1197256u},
    {2378753310345034420u, 15414398726365835820u, 16663464935941305700u, 10038091053023336670u, 2937084u},
    {8566184719301714186u, 7893338266509277809u, 13316048117639783219u, 17492117404087638709u, 1565455u},
    {1270384790070959786u, 12907914431194410858u, 3922958192093231391u, 12783071709949271062u, 1112943u},
    {16677478370962315553u, 13278752062440893047u, 8364435374136392462u, 10180650946820537215u, 276480u},
    {480219659483037365u, 2419046669482593464u, 12014897442241476179u, 2887403927499267603u, 3544151u},
    {12298075191966950942u, 3072609285577939445u, 10490029149225521238u, 7631425423325418988u, 304643u},
    {2524671378455660106u, 5176083599303394611u, 4766123572255063021u, 15714175179354562570u, 3231255u},
    {2699735360266849480u, 16231906624266805513u, 10358227727419158906u, 2653679535101475232u, 2065138u},
    {18365118137773581823u, 17313279214859380118u, 1967128332109044582u, 15674592981046934043u, 659005u},
    {16852017864920650231u, 6560941491625907526u, 2022429504181869799u, 228329294366671752u, 1399540u},
    {1188181771779485848u, 297938369163068435u, 4341042622524027761u, 1034623272960239864u, 1997596u},
    {12270040181519826678u, 16685223180148983865u, 7934959201367574797u, 1550058618005775834u, 2752914u},
    {4474056072201845913u, 14539821924495284267u, 10757861831123605593u, 2428682904816612562u, 3165069u},
    {12805963110202503304u, 7405191761752763840u, 11811709713056228529u, 13749328087453622561u, 67930u},
    {16441597763098545434u, 16086357462322743917u, 5439897633930571861u, 10233431454460022089u, 1116432u},
    {3390141701523991400u, 7903741363841837268u, 10879450646051580963u, 7370469137481780628u, 3023723u},
    {11791705798160560731u, 15769134597263349505u, 419976959418619712u, 4163060711863150756u, 840592u},
    {12561112362986593700u, 10962224130071860404u, 5075574187275402505u, 1240485288302243283u, 2998146u},
    {13757569715456559900u, 4743735368187551151u, 11834457365168668040u, 17277071008262877989u, 1807809u},
    {17361164986198777320u, 12147331650287069166u, 1111367144809013266u, 8824374679861427991u, 3858758u},
    {12204644184108500318u, 18303382816211319903u, 15422970738816252798u, 5259328300823565393u, 274982u},
    {3498453636683718972u, 11504711848390374557u, 13761940803453892269u, 17803298255206405292u, 2566591u},
    {13482982560605849088u, 10192022330245951164u, 18411074503899875797u, 16692649487883537742u, 3428280u},
    {5358047716599596574u, 9285031193003631926u, 9179804940940932714u, 14258586645937469861u, 1538579u},
    {8513913032149565226u, 14361511796615616201u, 2827213030689390647u, 9107638636087690550u, 3559117u},
    {14343549666184348913u, 11113495528189304285u, 5655285147611385245u, 14405115343082686818u, 955689u},
    {4066816381158153891u, 3382327065110455440u, 13964743135887692845u, 12483593133363707678u, 3420612u},
    {16469520221928891379u, 16401582430794176048u, 2509064715212950893u, 4818900373126296686u, 1566524u},
    {6841850464891469400u, 10009100288837245322u, 14056409209901383980u, 4568525696521684122u, 1694877u},
    {9778479324675669501u, 11730949460924396948u, 4352608042115948554u, 3417971886606555312u, 2024167u},
    {538130567719046915u, 4006446475532031458u, 10560008064245213813u, 14232685319501223720u, 64207u},
    {9299982435442178419u, 5565396064934071637u, 12577584695470164162u, 7495174204273931332u, 1811287u},
    {480610981334321104u, 3455085242493459328u, 16451196046533575867u, 1114276265797130396u, 3334270u},
    {11596968019070432259u, 10874225087299056277u, 8555797593147179957u, 16058292302896925604u, 3390076u},
    {2659214550330560919u, 2159499041052845358u, 14777473072708145836u, 9574138293427204836u, 148738u},
    {14817214326415593030u, 12737538397181150621u, 13198007953828446146u, 8937885402097237768u, 1275170u},
    {18215884654417537170u, 8327353811800978021u, 579458140052480359u, 8021915681788358507u, 1930492u},
    {13277398039840364843u, 13868151946752866154u, 9345739971539968081u, 12429517474405864373u, 999688u},
    {4863826939496275290u, 977134691223877426u, 11838385824950259158u, 16303457253690789564u, 3532292u},
    {14352665766754328975u, 10749503161704125516u, 3460119180756723687u, 6838573142386294897u, 2327726u},
    {9510186381497079079u, 17621368409414496344u, 2420214910412892681u, 2348781981847986734u, 1935768u},
    {131113415854057698u, 422670873324829798u, 2962322456208639265u, 756284559610137933u, 2922802u},
    {3668081157802074376u, 9808294403321201109u, 9084762559211202113u, 16627162809951836264u, 2095345u},
    {10479138220071074982u, 9833536051853573251u, 7058900898810034497u, 17476590066766850262u, 3126388u},
    {4142613421503316487u, 9586013212679202446u, 7830518719760989494u, 15261824038790501220u, 436812u},
    {13632671857322849781u, 15577893273976986732u, 8319286270947274061u, 13122539889337033607u, 1494708u},
    {7573780594772197509u, 4600762259546455929u, 15013468080130984026u, 11484729961094007969u, 1942756u},
    {13684093322004358973u, 15997471472711007540u, 13895963039567756038u, 8826864006841601826u, 730342u},
    {5697720306789844022u, 6010037890264061637u, 3466779601123042620u, 1382566727507775972u, 3401066u},
    {9795551766725013459u, 8954519381066723479u, 7087213767653120202u, 9790513790582633137u, 2111771u},
    {12167217817299410748u, 4081677312602576978u, 1997875970602644136u, 16612201937693220764u, 2714674u},
    {16189029406714634798u, 11247055571260069436u, 310531532504010729u, 1275056011778530253u, 1531409u},
    {1108397204920973997u, 10379449440131552659u, 9393768246182744989u, 8386930419569872058u, 3874312u},
    {9766239111039314784u, 13141626306272612586u, 16793182556022014082u, 1368505142995335067u, 639878u},
    {14780699741498472482u, 16295387431059948973u, 8564415893873659495u, 5416123219917497463u, 1406071u},
    {1488110609782824224u, 5005691498685919471u, 16007313423380539653u, 746513377681867442u, 3433086u},
    {10736767400979403845u, 13725468554736861157u, 7397779289602372556u, 11664601899677946303u, 746815u},
    {10082714745516691168u, 5455824610017803751u, 8633986451586678496u, 5706326245836316242u, 785860u},
    {3223978036235151169u, 4420535844277046091u, 1277732220537040401u, 12696633114679408370u, 1241187u},
    {13982971043805148870u, 8612869538331056041u, 16989756808139578036u, 12344744452118925507u, 42956u},
    {13962912175738854553u, 1961834926471270995u, 11402714726238588168u, 792410683174719u, 0u},
    {4049638588228637329u, 2128460448328311137u, 12602349210424152939u, 792410u, 0u},
    {1231495802420076948u, 4061742444411638271u, 14617397073797396u, 0u, 0u},
    {557222029730347u, 1361321681379939414u, 14617397u, 0u, 0u},
    {793264708212990565u, 269643382844131460u, 0u, 0u, 0u},
    {15571477007980056130u, 269643382u, 0u, 0u, 0u},
    {4974042474494977792u, 0u, 0u, 0u, 0u},
    {4974042475u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 332336u},
    {16192645214640281085u, 5947990590367701453u, 10069247043632869528u, 14417649324724067537u, 828626u},
    {14781808969092774815u, 10889090453843992688u, 11832242543388386885u, 14642977055871841983u, 3835865u},
    {12933402175242317533u, 14007550858333133347u, 1500639377154813520u, 2736890214002610577u, 2584389u},
    {9864070323254593939u, 9599986975977189638u, 7266784942484822989u, 11432773423199414256u, 3345243u},
    {4957752960752817445u, 1452948454066474438u, 14314248100334033549u, 4313106901155890008u, 540938u},
    {16899204622853834087u, 3639029879944314230u, 10845686011274574572u, 3973146221244887678u, 3873825u},
    {14971542605481336415u, 12571482284248673973u, 622372458645795580u, 2593475253661961885u, 3696338u},
    {8571476309559255582u, 1379814034314739015u, 4854151738701797564u, 16064971280109404462u, 2150073u},
    {4566685545319187163u, 4083084311985349754u, 16252917631465525495u, 10992416156200810468u, 1764188u},
    {9059002881754994605u, 18018401659943248095u, 11937594173926533788u, 13723486402732633502u, 1776651u},
    {2845220483878926821u, 15825219663784602627u, 5916821175737436745u, 11057585327831760759u, 2150339u},
    {709450619639925245u, 8584319154997978114u, 6348605307288348013u, 6164562257486176411u, 3584979u},
    {3081910851653326627u, 5751650778388853404u, 2378753310345034419u, 15414398726365835820u, 2117474u},
    {1199465077956944757u, 7402709448401569895u, 8566184719301714185u, 7893338266509277809u, 520693u},
    {13321863862520133993u, 18414693545813721445u, 1270384790070959785u, 12907914431194410858u, 1092591u},
    {12865253500153895765u, 8406712725054155715u, 16677478370962315552u, 13278752062440893047u, 2230532u},
    {14255179915861285268u, 3314955476316045064u, 480219659483037364u, 2419046669482593464u, 2503983u},
    {16067365716045364772u, 2979231000975759037u, 12298075191966950941u, 3072609285577939445u, 3252304u},
    {13060737486771265069u, 5682310789976264352u, 2524671378455660105u, 5176083599303394611u, 1027171u},
    {6096738654384918820u, 9331699753899950770u, 2699735360266849479u, 16231906624266805513u, 1054746u},
    {16652248099836270210u, 2473314791437849884u, 18365118137773581822u, 17313279214859380118u, 200600u},
    {6259785370560251943u, 8795889221305793558u, 16852017864920650230u, 6560941491625907526u, 526271u},
    {14373221712941384908u, 16079525472238070086u, 1188181771779485847u, 297938369163068435u, 2164011u},
    {14602923234591799201u, 7257628399133889284u, 12270040181519826677u, 16685223180148983865u, 3049075u},
    {1838733758725404678u, 621760742577509686u, 4474056072201845912u, 14539821924495284267u, 2998749u},
    {340034996561942543u, 10450817059975596808u, 12805963110202503303u, 7405191761752763840u, 949435u},
    {3072291501438769979u, 3405197079495945042u, 16441597763098545433u, 16086357462322743917u, 2681427u},
    {17255278358687397066u, 16600096181722555864u, 3390141701523991399u, 7903741363841837268u, 3283999u},
    {6168590497633989471u, 1765520016999829942u, 11791705798160560730u, 15769134597263349505u, 513360u},
    {12003101983142346983u, 722429286521884975u, 12561112362986593699u, 10962224130071860404u, 3252159u},
    {18330220559744816568u, 10546742693356981265u, 13757569715456559899u, 4743735368187551151u, 2258168u},
    {3592474520637192235u, 4767423090091537182u, 17361164986198777319u, 12147331650287069166u, 40870u},
    {9956812777037022878u, 11806954671399165603u, 12204644184108500317u, 18303382816211319903u, 2577928u},
    {14561788411290311641u, 11021131460572574570u, 3498453636683718971u, 11504711848390374557u, 1729387u},
    {5672031630124908222u, 6522963420868526916u, 13482982560605849087u, 10192022330245951164u, 3342549u},
    {8279787805230254901u, 16845040132324941917u, 5358047716599596573u, 9285031193003631926u, 1195364u},
    {5148712897503069184u, 16251193666095517215u, 8513913032149565225u, 14361511796615616201u, 901299u},
    {13608557407478824667u, 11473457656981307829u, 14343549666184348912u, 11113495528189304285u, 3668817u},
    {5629994506246977164u, 14225963463143458246u, 4066816381158153890u, 3382327065110455440u, 2412815u},
    {18231421987275465504u, 4249273366481301820u, 16469520221928891378u, 16401582430794176048u, 3531913u},
    {9779072915396044849u, 3762771914812423901u, 6841850464891469399u, 10009100288837245322u, 3123544u},
    {16223080230765406283u, 7178178112517716098u, 9778479324675669500u, 11730949460924396948u, 2346148u},
    {15340109363054668108u, 13385122716101752907u, 538130567719046914u, 4006446475532031458u, 919475u},
    {11866760575785320435u, 13545234668590857274u, 9299982435442178418u, 5565396064934071637u, 3706796u},
    {3246543036154106282u, 1614990062851200429u, 480610981334321103u, 3455085242493459328u, 3555423u},
    {9807201399665217834u, 11557273264842590925u, 11596968019070432258u, 10874225087299056277u, 3785427u},
    {6520845770328423147u, 1438432879132855344u, 2659214550330560918u, 2159499041052845358u, 3003340u},
    {1093757637794965576u, 12761872345117942120u, 14817214326415593029u, 12737538397181150621u, 2208004u},
    {6813503116536708463u, 4671460657771523869u, 18215884654417537169u, 8327353811800978021u, 1794023u},
    {8138116092462618157u, 11427695110277468755u, 13277398039840364842u, 13868151946752866154u, 2189327u},
    {5546468197013101211u, 2307684337741338602u, 4863826939496275289u, 977134691223877426u, 700484u},
    {2888567285226837421u, 13540655566891769753u, 14352665766754328974u, 10749503161704125516u, 2131295u},
    {7468779595384969692u, 13541355466041641596u, 9510186381497079078u, 17621368409414496344u, 3381783u},
    {3176936567283735596u, 12002872660592787594u, 131113415854057697u, 422670873324829798u, 458705u},
    {17858320869305681083u, 7117413254506932421u, 3668081157802074375u, 9808294403321201109u, 1827057u},
    {1518244476109494327u, 16088909126355705358u, 10479138220071074981u, 9833536051853573251u, 127567u},
    {11831596695880619673u, 2274596989406606080u, 4142613421503316486u, 9586013212679202446u, 729286u},
    {2575923424341950680u, 9475532352895627685u, 13632671857322849780u, 15577893273976986732u, 3314071u},
    {1660826281748569721u, 2438771510862974346u, 7573780594772197508u, 4600762259546455929u, 37166u},
    {1821849035104271751u, 11324501715853439163u, 13684093322004358972u, 15997471472711007540u, 1586056u},
    {7310340103640790482u, 7168425935230230092u, 5697720306789844021u, 6010037890264061637u, 1050468u},
    {831336249640227789u, 11041498284704899666u, 9795551766725013458u, 8954519381066723479u, 2518170u},
    {13684597889052562805u, 2153861070595150336u, 12167217817299410747u, 4081677312602576978u, 329104u},
    {17161977062064633829u, 4920163893516401722u, 16189029406714634797u, 11247055571260069436u, 171081u},
    {3117556323336221279u, 12631358369204477010u, 1108397204920973996u, 10379449440131552659u, 1471489u},
    {7713288255278671117u, 7576057955007247906u, 9766239111039314783u, 13141626306272612586u, 562222u},
    {6308553350970351367u, 6618119766136063415u, 14780699741498472481u, 16295387431059948973u, 1827829u},
    {1242576062867794237u, 6374675906921579576u, 1488110609782824223u, 5005691498685919471u, 1871641u},
    {12212040758961146714u, 17237719662622524370u, 10736767400979403844u, 13725468554736861157u, 2792094u},
    {7157246139297944873u, 5412503837025497579u, 10082714745516691167u, 5455824610017803751u, 1356478u},
    {99339321109266449u, 13816883424542789287u, 3223978036235151168u, 4420535844277046091u, 2060843u},
    {7523072898303711071u, 226925071009839203u, 13982971043805148869u, 8612869538331056041u, 882534u},
    {3831862224212686673u, 7606895456904555234u, 13962912175738854552u, 1961834926471270995u, 2102822u},
    {18107739001433328408u, 14118424106415509998u, 4049638588228637328u, 2128460448328311137u, 1437499u},
    {14851558932702407694u, 4382453213882258871u, 1231495802420076947u, 4061742444411638271u, 3484896u},
    {15382861923130001614u, 15601176251081172939u, 557222029730346u, 1361321681379939414u, 2898647u},
    {4665007657274136520u, 882186073029305769u, 793264708212990564u, 269643382844131460u, 0u},
    {15684583094012540679u, 14248817123785105425u, 15571477007980056129u, 269643382u, 0u},
    {17980854615254796245u, 7781970050942138783u, 4974042474494977791u, 0u, 0u},
    {7937616265577019841u, 9130728640529065085u, 4974042474u, 0u, 0u},
    {155009271214338714u, 17967912243931618654u, 4u, 0u, 0u},
    {14200766933414265542u, 91754888538u, 0u, 0u, 0u},
    {13925235678863534590u, 91u, 0u, 0u, 0u},
    {1692578946387u, 0u, 0u, 0u, 0u},
    {1693u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2128716u},
    {2839351182024271403u, 327807791774879292u, 16192645214640281084u, 5947990590367701453u, 455026u},
    {8647315271085917742u, 146780521561385809u, 14781808969092774814u, 10889090453843992688u, 1538353u},
    {8819743431664526734u, 2828450152547669559u, 12933402175242317532u, 14007550858333133347u, 885086u},
    {7111101033756196817u, 2848204957925315486u, 9864070323254593938u, 9599986975977189638u, 639493u},
    {7535752293301281118u, 16317634784415231703u, 4957752960752817444u, 1452948454066474438u, 1959705u},
    {4723078811427803802u, 9035025852452424316u, 16899204622853834086u, 3639029879944314230u, 1813920u},
    {2799081132777703020u, 16351143891507756357u, 14971542605481336414u, 12571482284248673973u, 581118u},
    {15381518656067564432u, 7111488994762211461u, 8571476309559255581u, 1379814034314739015u, 2594444u},
    {14146550178473967405u, 16113309999795138176u, 4566685545319187162u, 4083084311985349754u, 217011u},
    {4913246911437027887u, 17180700546621649281u, 9059002881754994604u, 18018401659943248095u, 2418126u},
    {16997910254208928276u, 17458322902300236009u, 2845220483878926820u, 15825219663784602627u, 513123u},
    {11193599594628582786u, 13863819129295570124u, 709450619639925244u, 8584319154997978114u, 3203863u},
    {16556979563123064844u, 7771834579259561444u, 3081910851653326626u, 5751650778388853404u, 2864183u},
    {7767725680390767519u, 761996968270496167u, 1199465077956944756u, 7402709448401569895u, 2168787u},
    {2894591791148383633u, 16789653648355454020u, 13321863862520133992u, 18414693545813721445u, 2603809u},
    {17463161395197684975u, 12853230413896531654u, 12865253500153895764u, 8406712725054155715u, 16596u},
    {7105304614243053397u, 8948607427795220976u, 14255179915861285267u, 3314955476316045064u, 1348186u},
    {7606003729727667585u, 12568274160956160472u, 16067365716045364771u, 2979231000975759037u, 3351185u},
    {2711487656870333671u, 5229539856601196111u, 13060737486771265068u, 5682310789976264352u, 1966207u},
    {13899031052846626841u, 2182716384200492074u, 6096738654384918819u, 9331699753899950770u, 1266163u},
    {10195750585638263733u, 8865993433982925761u, 16652248099836270209u, 2473314791437849884u, 263610u},
    {610940844672685683u, 15048833772587437520u, 6259785370560251942u, 8795889221305793558u, 579072u},
    {5146434108198564661u, 10068057723304294951u, 14373221712941384907u, 16079525472238070086u, 2811823u},
    {16510376200910169537u, 15214656315528047985u, 14602923234591799200u, 7257628399133889284u, 2455717u},
    {17439904583988819700u, 6478055582931112889u, 1838733758725404677u, 621760742577509686u, 133678u},
    {1872256457718472110u, 12052593841485067773u, 340034996561942542u, 10450817059975596808u, 1002353u},
    {13056464911500779499u, 5540299517475610116u, 3072291501438769978u, 3405197079495945042u, 1455517u},
    {6187830226143126202u, 4996496210285201041u, 17255278358687397065u, 16600096181722555864u, 1959031u},
    {13789860605457097817u, 12833997992752821301u, 6168590497633989470u, 1765520016999829942u, 100470u},
    {13377237422151455295u, 16791334417066987016u, 12003101983142346982u, 722429286521884975u, 1427567u},
    {2923579471563924407u, 15556584487872074201u, 18330220559744816567u, 10546742693356981265u, 630023u},
    {16217361364312181404u, 1723558543129064477u, 3592474520637192234u, 4767423090091537182u, 3337545u},
    {12400859377324901919u, 6517121530636994994u, 9956812777037022877u, 11806954671399165603u, 3706733u},
    {18402305178660569883u, 8341997181514409197u, 14561788411290311640u, 11021131460572574570u, 2048055u},
    {4012363072450844704u, 513462178154650757u, 5672031630124908221u, 6522963420868526916u, 3015205u},
    {7176138898996934961u, 17254954486642865623u, 8279787805230254900u, 16845040132324941917u, 2072723u},
    {16180026302257685269u, 1797772839948740164u, 5148712897503069183u, 16251193666095517215u, 883635u},
    {5852448942244906107u, 5387577898463623683u, 13608557407478824666u, 11473457656981307829u, 1659774u},
    {13139956465578571753u, 13657919031737784982u, 5629994506246977163u, 14225963463143458246u, 3791070u},
    {12894925032474317961u, 17142570699890786974u, 18231421987275465503u, 4249273366481301820u, 855274u},
    {11011843765827105131u, 13374361098487728153u, 9779072915396044848u, 3762771914812423901u, 2411065u},
    {1966544991374817705u, 18110635260475864124u, 16223080230765406282u, 7178178112517716098u, 2952706u},
    {11802800554066608483u, 5643238774931888484u, 15340109363054668107u, 13385122716101752907u, 3819892u},
    {17919706218866092787u, 8195862037195111226u, 11866760575785320434u, 13545234668590857274u, 1611286u},
    {2056955313339773948u, 13677663691532804877u, 3246543036154106281u, 1614990062851200429u, 1521039u},
    {11489343167126608900u, 12465799218835315056u, 9807201399665217833u, 11557273264842590925u, 3758852u},
    {7512904640085172517u, 5418014335876996021u, 6520845770328423146u, 1438432879132855344u, 416236u},
    {11335529350555532526u, 11463888969508957954u, 1093757637794965575u, 12761872345117942120u, 3240389u},
    {15717740477519512712u, 10830597733916797671u, 6813503116536708462u, 4671460657771523869u, 2309093u},
    {12536017231807313168u, 4866254307208646275u, 8138116092462618156u, 11427695110277468755u, 99818u},
    {12372168156461537341u, 5413957870808898305u, 5546468197013101210u, 2307684337741338602u, 3571659u},
    {12230055583651962450u, 7860296854352378026u, 2888567285226837420u, 13540655566891769753u, 3609600u},
    {7396050752118431838u, 11796432153610305449u, 7468779595384969691u, 13541355466041641596u, 2239530u},
    {13460197367584529050u, 13311991544623733190u, 3176936567283735595u, 12002872660592787594u, 3023245u},
    {3660739662137727105u, 18344958993059765997u, 17858320869305681082u, 7117413254506932421u, 1087761u},
    {14494996618519591719u, 5360871659724840906u, 1518244476109494326u, 16088909126355705358u, 2212399u},
    {17593590918552172411u, 17622097105757008590u, 11831596695880619672u, 2274596989406606080u, 1950888u},
    {11730333826872171596u, 9795550948545906940u, 2575923424341950679u, 9475532352895627685u, 3299818u},
    {11545199013964720324u, 10299825285370989621u, 1660826281748569720u, 2438771510862974346u, 621218u},
    {13820157617068103468u, 5602022801008819636u, 1821849035104271750u, 11324501715853439163u, 1882398u},
    {13770929291495643380u, 1419673346111381509u, 7310340103640790481u, 7168425935230230092u, 904571u},
    {18032252628779766777u, 5094705325000687141u, 831336249640227788u, 11041498284704899666u, 3479792u},
    {652348406505396146u, 15629653173149541213u, 13684597889052562804u, 2153861070595150336u, 1097619u},
    {15441332590514716401u, 3955517712267857859u, 17161977062064633828u, 4920163893516401722u, 1153559u},
    {14274976078733553911u, 12062113521049440674u, 3117556323336221278u, 12631358369204477010u, 542674u},
    {182187179190144063u, 11072524993707547843u, 7713288255278671116u, 7576057955007247906u, 3300241u},
    {12792639391601075476u, 11756997445211520257u, 6308553350970351366u, 6618119766136063415u, 1821873u},
    {5598294661184104822u, 12397265227695960504u, 1242576062867794236u, 6374675906921579576u, 864905u},
    {8861509937804644859u, 4068258453429831696u, 12212040758961146713u, 17237719662622524370u, 443670u},
    {15897790400192281294u, 1304408993360251544u, 7157246139297944872u, 5412503837025497579u, 2921001u},
    {4769564633302334053u, 2078394508515311584u, 99339321109266448u, 13816883424542789287u, 582882u},
    {12573479625040533703u, 8808328266268145247u, 7523072898303711070u, 226925071009839203u, 2214379u},
    {16203168412178281282u, 151981663320464986u, 3831862224212686672u, 7606895456904555234u, 3642554u},
    {10526893255897901893u, 17903366450249663449u, 18107739001433328407u, 14118424106415509998u, 3198264u},
    {10960479671582800573u, 415006731059547436u, 14851558932702407693u, 4382453213882258871u, 1991459u},
    {10988924016422468979u, 17870237813703505017u, 15382861923130001613u, 15601176251081172939u, 948402u},
    {864100862080444617u, 8378775868479829816u, 4665007657274136519u, 882186073029305769u, 2898674u},
    {11951351961628818488u, 11072078302116465313u, 15684583094012540678u, 14248817123785105425u, 3892691u},
    {2757657223747774370u, 16095255972416603135u, 17980854615254796244u, 7781970050942138783u, 2790291u},
    {6698459611403292882u, 13659689819196074731u, 7937616265577019840u, 9130728640529065085u, 1386224u},
    {64464644174487591u, 14117834554527708604u, 155009271214338713u, 17967912243931618654u, 4u},
    {8713699935143971241u, 13440840098945124996u, 14200766933414265541u, 91754888538u, 0u},
    {16776955507982625691u, 8338720603968779180u, 13925235678863534589u, 91u, 0u},
    {17946237806906582715u, 7982489916249056126u, 1692578946386u, 0u, 0u},
    {234567007806609242u, 10679675822923552438u, 1692u, 0u, 0u},
    {8944581044347588987u, 31222570648539u, 0u, 0u, 0u},
    {10526607563913844985u, 31222u, 0u, 0u, 0u},
    {575954770076924u, 0u, 0u, 0u, 0u},
    {575955u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2145496u},
    {5170925185611501334u, 11178767048783092671u, 2839351182024271402u, 327807791774879292u, 144488u},
    {2318104620510646098u, 3775343894336984707u, 8647315271085917741u, 146780521561385809u, 986840u},
    {13328154572302789967u, 15764110179664619470u, 8819743431664526733u, 2828450152547669559u, 2057750u},
    {3283186609274208765u, 7573644257018187043u, 7111101033756196816u, 2848204957925315486u, 1768254u},
    {2782744823913342155u, 2531631459397448300u, 7535752293301281117u, 16317634784415231703u, 1508482u},
    {1041444364964279123u, 6141529054013978438u, 4723078811427803801u, 9035025852452424316u, 3584786u},
    {3966699412960856981u, 11728566672678080577u, 2799081132777703019u, 16351143891507756357u, 2702090u},
    {15365911162222322240u, 16868975083114088491u, 15381518656067564431u, 7111488994762211461u, 2410535u},
    {1710300277676805739u, 10254994539256958907u, 14146550178473967404u, 16113309999795138176u, 1680142u},
    {3112689927670691399u, 9779847080374902843u, 4913246911437027886u, 17180700546621649281u, 1105080u},
    {16837107660028091843u, 8699714398265918190u, 16997910254208928275u, 17458322902300236009u, 1559140u},
    {8752041767728236592u, 14495020936367255603u, 11193599594628582785u, 13863819129295570124u, 3343246u},
    {12238070358290469534u, 11649660216747445788u, 16556979563123064843u, 7771834579259561444u, 2245438u},
    {6562484335331535590u, 6638910800307238533u, 7767725680390767518u, 761996968270496167u, 12698u},
    {13331280820052317535u, 10265459569854094863u, 2894591791148383632u, 16789653648355454020u, 1462516u},
    {11722972852301432512u, 18425774710755733705u, 17463161395197684974u, 12853230413896531654u, 729980u},
    {9400497556046299259u, 1608347985486608020u, 7105304614243053396u, 8948607427795220976u, 1640007u},
    {11039034964073600335u, 115675918132742136u, 7606003729727667584u, 12568274160956160472u, 2243923u},
    {16909320860278626556u, 2685333560484395276u, 2711487656870333670u, 5229539856601196111u, 1137792u},
    {14054929315811582704u, 14983260848546801197u, 13899031052846626840u, 2182716384200492074u, 157717u},
    {6865745581539966677u, 17611556239987310520u, 10195750585638263732u, 8865993433982925761u, 3298913u},
    {9243691058530736166u, 9643788773384218350u, 610940844672685682u, 15048833772587437520u, 2821752u},
    {9019044361076269731u, 9225381155182608583u, 5146434108198564660u, 10068057723304294951u, 569421u},
    {5441992701649333999u, 2891387906755085011u, 16510376200910169536u, 15214656315528047985u, 3519846u},
    {6115194595765176367u, 240159492152585866u, 17439904583988819699u, 6478055582931112889u, 1028671u},
    {1567365432163277754u, 16673150487071236888u, 1872256457718472109u, 12052593841485067773u, 3465238u},
    {11378537762397150474u, 8291992348131236660u, 13056464911500779498u, 5540299517475610116u, 1329352u},
    {12632657155572848548u, 6087120554149629667u, 6187830226143126201u, 4996496210285201041u, 419925u},
    {2735633324638084403u, 15960478207611252037u, 13789860605457097816u, 12833997992752821301u, 103812u},
    {4167239411269844221u, 13070265359105657059u, 13377237422151455294u, 16791334417066987016u, 3480384u},
    {17350998680801520502u, 8584233946732147344u, 2923579471563924406u, 15556584487872074201u, 3590545u},
    {1986758921423199473u, 17665833306161468097u, 16217361364312181403u, 1723558543129064477u, 1731366u},
    {7268197815993036096u, 13492965620624527039u, 12400859377324901918u, 6517121530636994994u, 3001823u},
    {18324759433320378836u, 9573795808611405662u, 18402305178660569882u, 8341997181514409197u, 491090u},
    {197240833208718834u, 11826378710333528932u, 4012363072450844703u, 513462178154650757u, 1799207u},
    {17759872991281327055u, 7838637819124837606u, 7176138898996934960u, 17254954486642865623u, 3707460u},
    {8823339910235415237u, 16825155152271711851u, 16180026302257685268u, 1797772839948740164u, 2998683u},
    {10830815624217247270u, 7775353187972493122u, 5852448942244906106u, 5387577898463623683u, 2116024u},
    {17022994308738623900u, 11278316792520114972u, 13139956465578571752u, 13657919031737784982u, 3519369u},
    {18024361981914070312u, 7395187701798460470u, 12894925032474317960u, 17142570699890786974u, 2369317u},
    {1620915530461684725u, 15680903764510010837u, 11011843765827105130u, 13374361098487728153u, 1310754u},
    {10481537180197207135u, 3610917000863703963u, 1966544991374817704u, 18110635260475864124u, 1233086u},
    {6777245736852962629u, 6398719961989116125u, 11802800554066608482u, 5643238774931888484u, 2892321u},
    {9752191441480687576u, 17473272538743959267u, 17919706218866092786u, 8195862037195111226u, 3186384u},
    {59298230722007439u, 4909584461301867805u, 2056955313339773947u, 13677663691532804877u, 3897329u},
    {16693230763938788454u, 11315347244876512642u, 11489343167126608899u, 12465799218835315056u, 742395u},
    {6490503189056209512u, 5984428436805103102u, 7512904640085172516u, 5418014335876996021u, 364916u},
    {12511730516033790989u, 12229640654649772780u, 11335529350555532525u, 11463888969508957954u, 1190379u},
    {15049440212944597804u, 1421653924309961336u, 15717740477519512711u, 10830597733916797671u, 2081424u},
    {11048035283730058472u, 5242424305894251637u, 12536017231807313167u, 4866254307208646275u, 522494u},
    {11897938409776402849u, 5210003050200833059u, 12372168156461537340u, 5413957870808898305u, 326296u},
    {12950901842144668203u, 5150242332431179760u, 12230055583651962449u, 7860296854352378026u, 2767118u},
    {6678955971321124761u, 3520676828043284638u, 7396050752118431837u, 11796432153610305449u, 2894507u},
    {14251387166859712687u, 2709081699295705052u, 13460197367584529049u, 13311991544623733190u, 2294719u},
    {1037059364005671821u, 17081038511924575197u, 3660739662137727104u, 18344958993059765997u, 1550934u},
    {17216009721078047204u, 2900347645781295686u, 14494996618519591718u, 5360871659724840906u, 2170798u},
    {4439063581317424339u, 11198238069668586665u, 17593590918552172410u, 17622097105757008590u, 3674130u},
    {9033162959230081407u, 12348013084543183279u, 11730333826872171595u, 9795550948545906940u, 3667147u},
    {5269555046819609733u, 12378183418155040993u, 11545199013964720323u, 10299825285370989621u, 2905014u},
    {12600817423556600566u, 1828777808916410857u, 13820157617068103467u, 5602022801008819636u, 2741896u},
    {3060395300680137485u, 17760448070159361925u, 13770929291495643379u, 1419673346111381509u, 2747029u},
    {15035304260595394149u, 6398735526743901331u, 18032252628779766776u, 5094705325000687141u, 3535196u},
    {3648512516104736728u, 15737692286505402401u, 652348406505396145u, 15629653173149541213u, 3491544u},
    {3246816464023262819u, 17488886148968080462u, 15441332590514716400u, 3955517712267857859u, 1544734u},
    {8801038077285149041u, 10731195042977137276u, 14274976078733553910u, 12062113521049440674u, 2586532u},
    {2026076967274730061u, 7011490960406114210u, 182187179190144062u, 11072524993707547843u, 629358u},
    {9203238856570436550u, 11319541944347060325u, 12792639391601075475u, 11756997445211520257u, 182094u},
    {3062645431124670009u, 8652069946297851214u, 5598294661184104821u, 12397265227695960504u, 1790732u},
    {18361993204350173274u, 5654020721363709739u, 8861509937804644858u, 4068258453429831696u, 399653u},
    {15960763664803921269u, 5948897179705968704u, 15897790400192281293u, 1304408993360251544u, 3294992u},
    {13639395080166568650u, 107078725164018625u, 4769564633302334052u, 2078394508515311584u, 937932u},
    {5908935471048887925u, 10706541690010579985u, 12573479625040533702u, 8808328266268145247u, 426442u},
    {2451352426562320337u, 33617467786934419u, 16203168412178281281u, 151981663320464986u, 1793440u},
    {2274785538386970840u, 362428659532778920u, 10526893255897901892u, 17903366450249663449u, 2966309u},
    {10904405379822639076u, 2726823165844996298u, 10960479671582800572u, 415006731059547436u, 3903783u},
    {16244812211956767455u, 15635371661444509014u, 10988924016422468978u, 17870237813703505017u, 1089349u},
    {9147683549532143686u, 8860129725556638762u, 864100862080444616u, 8378775868479829816u, 2562317u},
    {7372247660779155357u, 12940959579006708207u, 11951351961628818487u, 11072078302116465313u, 1431824u},
    {12806859255927795703u, 5085583606044964738u, 2757657223747774369u, 16095255972416603135u, 2212018u},
    {590180162080222749u, 18191602310017967028u, 6698459611403292881u, 13659689819196074731u, 3610594u},
    {1740473989564067001u, 5808382421229256978u, 64464644174487590u, 14117834554527708604u, 2066901u},
    {8255381688978023249u, 17458174025703243048u, 8713699935143971240u, 13440840098945124996u, 2824199u},
    {4949102210936810127u, 7444894156985382872u, 16776955507982625690u, 8338720603968779180u, 3044145u},
    {16935548287338741454u, 14047300581548497119u, 17946237806906582714u, 7982489916249056126u, 821386u},
    {16503126051982505503u, 13273914497180669236u, 234567007806609241u, 10679675822923552438u, 1692u},
    {1787534748662050340u, 8559890645778693452u, 8944581044347588986u, 31222570648539u, 0u},
    {9375698093866303435u, 6697607137821647964u, 10526607563913844984u, 31222u, 0u},
    {1667979327157574522u, 9857935169747556062u, 575954770076923u, 0u, 0u},
    {16722224933607412529u, 14205411925508671873u, 575954u, 0u, 0u},
    {11070140848929852665u, 10624490241641236u, 0u, 0u, 0u},
    {4457494049216992007u, 10624490u, 0u, 0u, 0u},
    {195987252401180444u, 0u, 0u, 0u, 0u},
    {195987253u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 533426u},
    {1403090639924297508u, 17785027192663925450u, 5170925185611501333u, 11178767048783092671u, 1536802u},
    {2576404099170517348u, 12900018090924419526u, 2318104620510646097u, 3775343894336984707u, 3011625u},
    {10505082623735122649u, 13944975003440484200u, 13328154572302789966u, 15764110179664619470u, 411827u},
    {3715885720975621150u, 8958543177286458857u, 3283186609274208764u, 7573644257018187043u, 521266u},
    {1598086176175722924u, 9923306965017832895u, 2782744823913342154u, 2531631459397448300u, 901707u},
    {1791031849051760247u, 1884341299626187166u, 1041444364964279122u, 6141529054013978438u, 2994373u},
    {11231636857935413845u, 16204948493845511853u, 3966699412960856980u, 11728566672678080577u, 406471u},
    {10758725197383165079u, 15276693035579473231u, 15365911162222322239u, 16868975083114088491u, 1236867u},
    {3334270824579965851u, 14339060879137720581u, 1710300277676805738u, 10254994539256958907u, 2822822u},
    {1742189705527709315u, 10752575443398039883u, 3112689927670691398u, 9779847080374902843u, 2862462u},
    {7731370066039003855u, 15958284912853086934u, 16837107660028091842u, 8699714398265918190u, 620409u},
    {14179693232986867956u, 14159580313428359508u, 8752041767728236591u, 14495020936367255603u, 2623095u},
    {9453248956214099823u, 17545018519695110379u, 12238070358290469533u, 11649660216747445788u, 521075u},
    {2247850790284057400u, 15176102074488633608u, 6562484335331535589u, 6638910800307238533u, 1804178u},
    {11215785829464111201u, 2350448819533271987u, 13331280820052317534u, 10265459569854094863u, 2769498u},
    {18297393102138808371u, 7419930347590147266u, 11722972852301432511u, 18425774710755733705u, 1251218u},
    {16752721476474364409u, 17550291330281489551u, 9400497556046299258u, 1608347985486608020u, 2364554u},
    {14144151402139313183u, 8614448758774217728u, 11039034964073600334u, 115675918132742136u, 1040974u},
    {5507611040518326962u, 6196081561005744773u, 16909320860278626555u, 2685333560484395276u, 3650448u},
    {2843877668039433367u, 2219601885874268966u, 14054929315811582703u, 14983260848546801197u, 1599376u},
    {1716151184993327367u, 13638019363592621833u, 6865745581539966676u, 17611556239987310520u, 3259586u},
    {18087187979807187548u, 14882541895111449880u, 9243691058530736165u, 9643788773384218350u, 108914u},
    {12355907080410572013u, 12038502898600481422u, 9019044361076269730u, 9225381155182608583u, 492452u},
    {2638861022421123293u, 9358401662110510413u, 5441992701649333998u, 2891387906755085011u, 1300322u},
    {5482182505902077218u, 12518894053708297534u, 6115194595765176366u, 240159492152585866u, 1509549u},
    {16991845500282006307u, 7368167613296142781u, 1567365432163277753u, 16673150487071236888u, 291055u},
    {7313688313540629673u, 17484097808558878558u, 11378537762397150473u, 8291992348131236660u, 1858466u},
    {3212452932043984705u, 8308035924984946948u, 12632657155572848547u, 6087120554149629667u, 1938007u},
    {14996323468167860220u, 14267608589591170239u, 2735633324638084402u, 15960478207611252037u, 1509254u},
    {4201049095684175147u, 8993525952005356711u, 4167239411269844220u, 13070265359105657059u, 508504u},
    {8325969651822917925u, 15187635837328995716u, 17350998680801520501u, 8584233946732147344u, 635492u},
    {16247025707986712431u, 2239891431779008230u, 1986758921423199472u, 17665833306161468097u, 986381u},
    {14494410928534793413u, 14133433405044544192u, 7268197815993036095u, 13492965620624527039u, 3371510u},
    {9475639688272462467u, 6589171075857637581u, 18324759433320378835u, 9573795808611405662u, 484274u},
    {8742766423851858205u, 12150345905454381236u, 197240833208718833u, 11826378710333528932u, 3058407u},
    {12022241700178105434u, 3441858767556862756u, 17759872991281327054u, 7838637819124837606u, 1937238u},
    {2020243224576111186u, 14403160185459278548u, 8823339910235415236u, 16825155152271711851u, 3533990u},
    {9086866501664449825u, 14798086798549044788u, 10830815624217247269u, 7775353187972493122u, 2023778u},
    {18093087016125002221u, 17067539860783226299u, 17022994308738623899u, 11278316792520114972u, 2456428u},
    {5654144803605366581u, 13972630550790752067u, 18024361981914070311u, 7395187701798460470u, 2407246u},
    {6390198951776095644u, 12346405951633641963u, 1620915530461684724u, 15680903764510010837u, 435702u},
    {11726920079657243013u, 5540469043347459617u, 10481537180197207134u, 3610917000863703963u, 3125304u},
    {4150677416922920477u, 4164241172526659557u, 6777245736852962628u, 6398719961989116125u, 1915502u},
    {12401897252866781166u, 6249047434559962390u, 9752191441480687575u, 17473272538743959267u, 524106u},
    {5810121519130589037u, 15717942740981799020u, 59298230722007438u, 4909584461301867805u, 124953u},
    {15996772895722295420u, 16679396330284705232u, 16693230763938788453u, 11315347244876512642u, 197765u},
    {10129097446989816770u, 15733481956578447515u, 6490503189056209511u, 5984428436805103102u, 2813898u},
    {17148691178471669630u, 14877996969955287840u, 12511730516033790988u, 12229640654649772780u, 2849263u},
    {14895520363669597083u, 10945567383364949705u, 15049440212944597803u, 1421653924309961336u, 2942391u},
    {11446000046006799334u, 5075586132844408619u, 11048035283730058471u, 5242424305894251637u, 1184831u},
    {13949092204583253686u, 11467931259535633946u, 11897938409776402848u, 5210003050200833059u, 1851446u},
    {7961759267955208123u, 6704313602111638275u, 12950901842144668202u, 5150242332431179760u, 3356273u},
    {10198833565591286952u, 133256518881180346u, 6678955971321124760u, 3520676828043284638u, 2328363u},
    {11202240651496186084u, 5392468368460720722u, 14251387166859712686u, 2709081699295705052u, 183703u},
    {14272815868529710215u, 2117285672453508364u, 1037059364005671820u, 17081038511924575197u, 978160u},
    {16664376805347323307u, 16018066632796529161u, 17216009721078047203u, 2900347645781295686u, 1588952u},
    {12048731029675377921u, 14436604384848794788u, 4439063581317424338u, 11198238069668586665u, 1418380u},
    {11394327226574919615u, 12344307653405975409u, 9033162959230081406u, 12348013084543183279u, 3053917u},
    {1574643915203148u, 12060175477612358543u, 5269555046819609732u, 12378183418155040993u, 1481993u},
    {5253318951524105219u, 17511793514995480985u, 12600817423556600565u, 1828777808916410857u, 1858319u},
    {1444447230819949220u, 103263802478519236u, 3060395300680137484u, 17760448070159361925u, 3126147u},
    {3217073282162885653u, 577352025293352641u, 15035304260595394148u, 6398735526743901331u, 1579508u},
    {3078372602626915134u, 5376094965078015336u, 3648512516104736727u, 15737692286505402401u, 2761917u},
    {1248912018164842730u, 13733377670415843889u, 3246816464023262818u, 17488886148968080462u, 3614248u},
    {17044287136033330272u, 17926813345459900571u, 8801038077285149040u, 10731195042977137276u, 1187436u},
    {17630618129696672352u, 8545525635865816534u, 2026076967274730060u, 7011490960406114210u, 352348u},
    {347962094791133972u, 569858818718921065u, 9203238856570436549u, 11319541944347060325u, 279651u},
    {761790486440206652u, 2316055219536478747u, 3062645431124670008u, 8652069946297851214u, 1817577u},
    {14829194617797071856u, 15116995057238922383u, 18361993204350173273u, 5654020721363709739u, 2177862u},
    {8473694288046333919u, 17534526197090839867u, 15960763664803921268u, 5948897179705968704u, 1898499u},
    {11544435149482732547u, 4677199204817835804u, 13639395080166568649u, 107078725164018625u, 2277788u},
    {12422860859648921308u, 7846432852618885546u, 5908935471048887924u, 10706541690010579985u, 1822406u},
    {5276260718381262161u, 12351512244074720027u, 2451352426562320336u, 33617467786934419u, 116047u},
    {1987252599560106199u, 16318467074117656617u, 2274785538386970839u, 362428659532778920u, 3290130u},
    {900319928262857482u, 11094514568364175383u, 10904405379822639075u, 2726823165844996298u, 3845196u},
    {12285680732810205394u, 3695289027916296767u, 16244812211956767454u, 15635371661444509014u, 3746094u},
    {8133077960086872368u, 9095848628857354430u, 9147683549532143685u, 8860129725556638762u, 2312074u},
    {12633495556845538845u, 6851172796336608033u, 7372247660779155356u, 12940959579006708207u, 2252539u},
    {7606066029910595444u, 2976467977397639846u, 12806859255927795702u, 5085583606044964738u, 1793737u},
    {17999690153274830309u, 13856518668272592054u, 590180162080222748u, 18191602310017967028u, 2373041u},
    {240957402729052346u, 2104730937581456386u, 1740473989564067000u, 5808382421229256978u, 1097010u},
    {15187376209100333779u, 7979877168524698460u, 8255381688978023248u, 17458174025703243048u, 1244770u},
    {1331468219766444589u, 12936220830934848551u, 4949102210936810126u, 7444894156985382872u, 3693190u},
    {4100195419506056552u, 190295112167594521u, 16935548287338741453u, 14047300581548497119u, 830346u},
    {10954965121695731708u, 14871387522903979011u, 16503126051982505502u, 13273914497180669236u, 3095101u},
    {5863488630818429366u, 7258202294580628513u, 1787534748662050339u, 8559890645778693452u, 3703010u},
    {11603544528523260322u, 11085595410970319445u, 9375698093866303434u, 6697607137821647964u, 3149736u},
    {14134630036249514755u, 14465731475214061695u, 1667979327157574521u, 9857935169747556062u, 545673u},
    {15055917290686890443u, 4613541793793678633u, 16722224933607412528u, 14205411925508671873u, 575954u},
    {11783849359972087495u, 10500593610601923123u, 11070140848929852664u, 10624490241641236u, 0u},
    {13322750718772605936u, 7856284581922517496u, 4457494049216992006u, 10624490u, 0u},
    {6844786740679376688u, 4900706771631966389u, 195987252401180443u, 0u, 0u},
    {4984536726238100520u, 7400472964299129342u, 195987252u, 0u, 0u},
    {12380137050116178993u, 3615326686754093431u, 0u, 0u, 0u},
    {13910568541702689726u, 3615326686u, 0u, 0u, 0u},
    {11350773912276406665u, 3u, 0u, 0u, 0u},
    {66691006134u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3190756u},
    {4242555158744157782u, 5764621099837873130u, 1403090639924297507u, 17785027192663925450u, 92631u},
    {3293094641578503931u, 1304285217403879600u, 2576404099170517347u, 12900018090924419526u, 2052359u},
    {7374526307433015495u, 7404450521446857336u, 10505082623735122648u, 13944975003440484200u, 1268598u},
    {16810361305782343049u, 3398785596952111495u, 3715885720975621149u, 8958543177286458857u, 2787298u},
    {3226318565850869997u, 2441794575651771185u, 1598086176175722923u, 9923306965017832895u, 587846u},
    {2493481245569193896u, 12405343508779236890u, 1791031849051760246u, 1884341299626187166u, 3472018u},
    {16428896247154110857u, 11225926789602173154u, 11231636857935413844u, 16204948493845511853u, 26188u},
    {13341671751728241521u, 9229422949071760804u, 10758725197383165078u, 15276693035579473231u, 3884547u},
    {15266143561141370882u, 6912489497070031797u, 3334270824579965850u, 14339060879137720581u, 867032u},
    {18423980899022457959u, 5535745011223706883u, 1742189705527709314u, 10752575443398039883u, 1819108u},
    {9248731218631998923u, 6421523570683446851u, 7731370066039003854u, 15958284912853086934u, 1967386u},
    {3145182325368459524u, 2043220667861046410u, 14179693232986867955u, 14159580313428359508u, 1898609u},
    {17284543896872299209u, 5561648828273200618u, 9453248956214099822u, 17545018519695110379u, 2385641u},
    {12371145307697920885u, 12507364392143618461u, 2247850790284057399u, 15176102074488633608u, 2418085u},
    {3858369942040262676u, 1308790730706162008u, 11215785829464111200u, 2350448819533271987u, 3797730u},
    {16743562838070185193u, 5539318767136384163u, 18297393102138808370u, 7419930347590147266u, 2184449u},
    {9475053582122160403u, 2839654341355697512u, 16752721476474364408u, 17550291330281489551u, 2146452u},
    {13320801356783820901u, 5343706985752437664u, 14144151402139313182u, 8614448758774217728u, 3859004u},
    {12216306986434786963u, 4779762683848472078u, 5507611040518326961u, 6196081561005744773u, 3137359u},
    {7710595261103589070u, 11241719463853208772u, 2843877668039433366u, 2219601885874268966u, 1037261u},
    {11258427549888571555u, 8604381183633001842u, 1716151184993327366u, 13638019363592621833u, 2096712u},
    {3409734887111967714u, 8369143283053331311u, 18087187979807187547u, 14882541895111449880u, 264799u},
    {155514301645707356u, 16408950176044496304u, 12355907080410572012u, 12038502898600481422u, 3413720u},
    {9267113842001585737u, 10703285782196465405u, 2638861022421123292u, 9358401662110510413u, 2869356u},
    {11610594361003023260u, 12924582782822153808u, 5482182505902077217u, 12518894053708297534u, 991666u},
    {777728023413922129u, 17382696357090017502u, 16991845500282006306u, 7368167613296142781u, 2502341u},
    {4521235545586173672u, 2403774909315818800u, 7313688313540629672u, 17484097808558878558u, 1160779u},
    {6534485785672648125u, 4481887793552770693u, 3212452932043984704u, 8308035924984946948u, 11111u},
    {15382299030864263294u, 4964762017142369743u, 14996323468167860219u, 14267608589591170239u, 3165018u},
    {14371189794757435388u, 12312512706721478742u, 4201049095684175146u, 8993525952005356711u, 3010888u},
    {7635246511823377127u, 5257378335889159731u, 8325969651822917924u, 15187635837328995716u, 331007u},
    {13189674427136736486u, 2531099379195120300u, 16247025707986712430u, 2239891431779008230u, 549960u},
    {13751572163077924925u, 606046934252023405u, 14494410928534793412u, 14133433405044544192u, 1730929u},
    {17118599414315071576u, 8100524407291297037u, 9475639688272462466u, 6589171075857637581u, 2421571u},
    {10871582088365177493u, 7324477823704765369u, 8742766423851858204u, 12150345905454381236u, 2989787u},
    {927055910137858647u, 14022024151722009158u, 12022241700178105433u, 3441858767556862756u, 3453128u},
    {10182792915546128348u, 1415852129943258000u, 2020243224576111185u, 14403160185459278548u, 1424642u},
    {15596944961172629219u, 14918684459425693255u, 9086866501664449824u, 14798086798549044788u, 3358189u},
    {11477665838265618190u, 9360623501527393994u, 18093087016125002220u, 17067539860783226299u, 3551569u},
    {3611811294813159477u, 4920223834194659636u, 5654144803605366580u, 13972630550790752067u, 1331257u},
    {10432053256254798889u, 8832984408599823644u, 6390198951776095643u, 12346405951633641963u, 3474428u},
    {14982156818660709377u, 18092659180535818581u, 11726920079657243012u, 5540469043347459617u, 3087716u},
    {1901561616979005992u, 3659992315380786649u, 4150677416922920476u, 4164241172526659557u, 2824040u},
    {8562622523416680662u, 10225340665526469160u, 12401897252866781165u, 6249047434559962390u, 508883u},
    {15195999959595993673u, 6287887300075930302u, 5810121519130589036u, 15717942740981799020u, 1848136u},
    {14402248485334320720u, 11183363909907172096u, 15996772895722295419u, 16679396330284705232u, 1351265u},
    {10366524750498245050u, 7833265462524771931u, 10129097446989816769u, 15733481956578447515u, 1850331u},
    {9439587275293197973u, 9238921635371254368u, 17148691178471669629u, 14877996969955287840u, 3516646u},
    {17514937944369697314u, 15360892398727898451u, 14895520363669597082u, 10945567383364949705u, 1710575u},
    {8702779904377922182u, 17015600710670005296u, 11446000046006799333u, 5075586132844408619u, 584049u},
    {5002989282894186454u, 5815206608555883490u, 13949092204583253685u, 11467931259535633946u, 160318u},
    {15933093959609466716u, 12473936069783771256u, 7961759267955208122u, 6704313602111638275u, 3317600u},
    {2435789416673580067u, 13195622381687808877u, 10198833565591286951u, 133256518881180346u, 3263796u},
    {17353381297428118981u, 10335213817749970637u, 11202240651496186083u, 5392468368460720722u, 1497036u},
    {8930036596974278465u, 9614761246334647683u, 14272815868529710214u, 2117285672453508364u, 1153632u},
    {9000346538055318457u, 7264966636588855234u, 16664376805347323306u, 16018066632796529161u, 1359891u},
    {17165442130680676227u, 10535097473279970586u, 12048731029675377920u, 14436604384848794788u, 1217508u},
    {9008722087523207002u, 13770992080927410143u, 11394327226574919614u, 12344307653405975409u, 1439672u},
    {7550288938271539730u, 11260132219568819874u, 1574643915203147u, 12060175477612358543u, 97478u},
    {12010681013794169730u, 7167788692391834299u, 5253318951524105218u, 17511793514995480985u, 1691691u},
    {15504080419324880913u, 9856816153828738247u, 1444447230819949219u, 103263802478519236u, 48316u},
    {13738708937155083994u, 16888781719289161392u, 3217073282162885652u, 577352025293352641u, 2376192u},
    {11444403423810176125u, 10299906697945817672u, 3078372602626915133u, 5376094965078015336u, 2300395u},
    {14999153428301646641u, 2782197516033395280u, 1248912018164842729u, 13733377670415843889u, 3064498u},
    {16959086785548703828u, 1457411600083830856u, 17044287136033330271u, 17926813345459900571u, 2316372u},
    {12962037869901953929u, 16462993004949701135u, 17630618129696672351u, 8545525635865816534u, 3548358u},
    {13796478971963559121u, 15153641354715947490u, 347962094791133971u, 569858818718921065u, 553605u},
    {16897316201608246304u, 17366205597306478240u, 761790486440206651u, 2316055219536478747u, 3087694u},
    {9321208271656754244u, 4189887711084818574u, 14829194617797071855u, 15116995057238922383u, 1329819u},
    {9010343991204909982u, 17404489147336562157u, 8473694288046333918u, 17534526197090839867u, 3551476u},
    {17373595393732597072u, 411695300191766310u, 11544435149482732546u, 4677199204817835804u, 3480977u},
    {12152911692318761890u, 4483745341795425488u, 12422860859648921307u, 7846432852618885546u, 1608070u},
    {6950609512154400593u, 13435013906556283506u, 5276260718381262160u, 12351512244074720027u, 1813372u},
    {13968034921769482532u, 7951753568988109026u, 1987252599560106198u, 16318467074117656617u, 3778589u},
    {247427852435667772u, 11858763443672409707u, 900319928262857481u, 11094514568364175383u, 1103269u},
    {5823520428661267085u, 12226060608668002606u, 12285680732810205393u, 3695289027916296767u, 899442u},
    {7681860244958351080u, 4040545632935532112u, 8133077960086872367u, 9095848628857354430u, 309071u},
    {4422733812952952367u, 4815497143315834584u, 12633495556845538844u, 6851172796336608033u, 1198402u},
    {17019422237914620824u, 14103706922267224730u, 7606066029910595443u, 2976467977397639846u, 1163382u},
    {2054241722599270997u, 11178556677770638936u, 17999690153274830308u, 13856518668272592054u, 816442u},
    {7618935482568085447u, 14699271866966204313u, 240957402729052345u, 2104730937581456386u, 2902508u},
    {6564181966122760131u, 17443310736577437686u, 15187376209100333778u, 7979877168524698460u, 2055186u},
    {4334235003739330303u, 13566767778367215339u, 1331468219766444588u, 12936220830934848551u, 2503418u},
    {1205463941935295181u, 4252151832660855922u, 4100195419506056551u, 190295112167594521u, 1492033u},
    {10792866808670239349u, 10287427001774721431u, 10954965121695731707u, 14871387522903979011u, 2842934u},
    {16569544802255812277u, 4580610403840570836u, 5863488630818429365u, 7258202294580628513u, 3295081u},
    {9461043224483927741u, 8963352437016295148u, 11603544528523260321u, 11085595410970319445u, 2938874u},
    {955631889099111765u, 8001717696091478374u, 14134630036249514754u, 14465731475214061695u, 100601u},
    {7925629830953861754u, 12933914877267010942u, 15055917290686890442u, 4613541793793678633u, 2832070u},
    {10947397035170277523u, 17245958630721124606u, 11783849359972087494u, 10500593610601923123u, 108790u},
    {6642079267707307926u, 6065335622435331623u, 13322750718772605935u, 7856284581922517496u, 42846u},
    {12413713833783431734u, 11727024045181979110u, 6844786740679376687u, 4900706771631966389u, 2742943u},
    {1084679890248696727u, 8997700466095396712u, 4984536726238100519u, 7400472964299129342u, 674752u},
    {2177253708839596352u, 8551469739726319158u, 12380137050116178992u, 3615326686754093431u, 0u},
    {15379341367795972996u, 12861318786425835320u, 13910568541702689725u, 3615326686u, 0u},
    {13169051952683859969u, 2248921922333511248u, 11350773912276406664u, 3u, 0u},
    {13881444988968728652u, 7472066048222752348u, 66691006133u, 0u, 0u},
    {10308285501244665000u, 12746813296286770275u, 66u, 0u, 0u},
    {2161532867808008545u, 1230231922161u, 0u, 0u, 0u},
    {4278208751150195365u, 1230u, 0u, 0u, 0u},
    {22693773419414u, 0u, 0u, 0u, 0u},
    {22694u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 736u},
    {7406210136613019200u, 7445689120409809433u, 4242555158744157781u, 5764621099837873130u, 392943u},
    {4036216546216463483u, 8352517286801237050u, 3293094641578503930u, 1304285217403879600u, 2958567u},
    {8761568170075843155u, 9051468349817407827u, 7374526307433015494u, 7404450521446857336u, 654786u},
    {11291392306874377128u, 7742077947114469050u, 16810361305782343048u, 3398785596952111495u, 3463699u},
    {4074584025334274519u, 17039344429685666094u, 3226318565850869996u, 2441794575651771185u, 620019u},
    {227633084198576925u, 2372115167947128791u, 2493481245569193895u, 12405343508779236890u, 3089960u},
    {4900361164253093944u, 14500799114366328858u, 16428896247154110856u, 11225926789602173154u, 328020u},
    {11120994101747372513u, 7534108511326570939u, 13341671751728241520u, 9229422949071760804u, 3633056u},
    {12715858298320952247u, 7588811954975584537u, 15266143561141370881u, 6912489497070031797u, 3218338u},
    {17502852102097475681u, 18354232940345691294u, 18423980899022457958u, 5535745011223706883u, 455240u},
    {12803481279836878377u, 17499694264958104205u, 9248731218631998922u, 6421523570683446851u, 1388214u},
    {3028862362776225938u, 1980068398176825044u, 3145182325368459523u, 2043220667861046410u, 716337u},
    {6015836020999212767u, 5989929984422367392u, 17284543896872299208u, 5561648828273200618u, 2244332u},
    {462511530827140867u, 7745147519160284102u, 12371145307697920884u, 12507364392143618461u, 637187u},
    {8201153351424719052u, 2599480724094367843u, 3858369942040262675u, 1308790730706162008u, 3412072u},
    {530248032591351892u, 14269745159568208374u, 16743562838070185192u, 5539318767136384163u, 1594220u},
    {10214166842321980497u, 7213173533440644102u, 9475053582122160402u, 2839654341355697512u, 620436u},
    {13340572098205790142u, 11286725408202542490u, 13320801356783820900u, 5343706985752437664u, 1298954u},
    {9723397943666104772u, 10291492911010813550u, 12216306986434786962u, 4779762683848472078u, 39833u},
    {12572490552470622855u, 12497518926839465987u, 7710595261103589069u, 11241719463853208772u, 1600688u},
    {9904351518696750031u, 16982927594895604508u, 11258427549888571554u, 8604381183633001842u, 567166u},
    {3737503312180917679u, 4229873887726637450u, 3409734887111967713u, 8369143283053331311u, 2812221u},
    {7198149941132450986u, 7460233441557855543u, 155514301645707355u, 16408950176044496304u, 2101284u},
    {11802380176447517666u, 9150398993708935329u, 9267113842001585736u, 10703285782196465405u, 1424286u},
    {5784099120941403591u, 7918276561132478609u, 11610594361003023259u, 12924582782822153808u, 911607u},
    {9937694038715076761u, 198243089747992822u, 777728023413922128u, 17382696357090017502u, 1402648u},
    {5349614636427059141u, 12703181481956563220u, 4521235545586173671u, 2403774909315818800u, 776124u},
    {17309197197767993240u, 15447875625795006106u, 6534485785672648124u, 4481887793552770693u, 3515288u},
    {15705328185914815465u, 12561814726423370017u, 15382299030864263293u, 4964762017142369743u, 3400151u},
    {4412915154061562851u, 548750748447242453u, 14371189794757435387u, 12312512706721478742u, 3753050u},
    {14718269663859986267u, 1072184884051686107u, 7635246511823377126u, 5257378335889159731u, 492422u},
    {15860034108341062300u, 1072472561548949743u, 13189674427136736485u, 2531099379195120300u, 1603870u},
    {7443700706385906169u, 11512170347850555064u, 13751572163077924924u, 606046934252023405u, 1630308u},
    {2822571293188762953u, 11951753447214908188u, 17118599414315071575u, 8100524407291297037u, 2529488u},
    {5356132196034571307u, 5789471809089221063u, 10871582088365177492u, 7324477823704765369u, 2322952u},
    {13342610993523478539u, 3285400321704835589u, 927055910137858646u, 14022024151722009158u, 2534747u},
    {13388995228802835562u, 11935405085839789366u, 10182792915546128347u, 1415852129943258000u, 149755u},
    {727476843832761185u, 4752796741891131566u, 15596944961172629218u, 14918684459425693255u, 3534166u},
    {523553092950771756u, 18202970244847812191u, 11477665838265618189u, 9360623501527393994u, 1100868u},
    {4629110942530175556u, 7123326475200322045u, 3611811294813159476u, 4920223834194659636u, 2274544u},
    {17678339438371813147u, 15954723912854360926u, 10432053256254798888u, 8832984408599823644u, 336269u},
    {1978498580434797535u, 16013715502428837088u, 14982156818660709376u, 18092659180535818581u, 3096080u},
    {15216725091339611296u, 15066908619001599081u, 1901561616979005991u, 3659992315380786649u, 3535578u},
    {1453518021353232410u, 12015514455639726861u, 8562622523416680661u, 10225340665526469160u, 1023303u},
    {1861967954692414782u, 13953161298641011390u, 15195999959595993672u, 6287887300075930302u, 782622u},
    {2582882965082962931u, 4972861032705717280u, 14402248485334320719u, 11183363909907172096u, 2767171u},
    {17157651953560420668u, 9299719998048972217u, 10366524750498245049u, 7833265462524771931u, 842945u},
    {7110881488946140048u, 3256098723718408357u, 9439587275293197972u, 9238921635371254368u, 684395u},
    {11068578400095466021u, 2473446070839821445u, 17514937944369697313u, 15360892398727898451u, 542562u},
    {17682374854544845306u, 16687559277993986144u, 8702779904377922181u, 17015600710670005296u, 2742981u},
    {7943806125592705542u, 5738244430769084373u, 5002989282894186453u, 5815206608555883490u, 432179u},
    {8645698326838591675u, 7198821902679565121u, 15933093959609466715u, 12473936069783771256u, 492372u},
    {2441696075285330307u, 12721428915961135153u, 2435789416673580066u, 13195622381687808877u, 1679313u},
    {1874874847361062230u, 6140644893313578922u, 17353381297428118980u, 10335213817749970637u, 1686001u},
    {3634690560524061558u, 2712516762363358942u, 8930036596974278464u, 9614761246334647683u, 3209630u},
    {6629791072510364276u, 14261278786680942455u, 9000346538055318456u, 7264966636588855234u, 796278u},
    {1374820033583692786u, 14975756171231239167u, 17165442130680676226u, 10535097473279970586u, 433226u},
    {13916889565808646319u, 10803893843325937378u, 9008722087523207001u, 13770992080927410143u, 1037990u},
    {12767328092836662849u, 18315062536898847962u, 7550288938271539729u, 11260132219568819874u, 1847853u},
    {14474954553784743975u, 17058812562104977459u, 12010681013794169729u, 7167788692391834299u, 3089074u},
    {17163536384578285236u, 16400606464135209720u, 15504080419324880912u, 9856816153828738247u, 1480191u},
    {5555500414466540427u, 7526385230417597574u, 13738708937155083993u, 16888781719289161392u, 3671560u},
    {7419737471639164155u, 10826114175045202531u, 11444403423810176124u, 10299906697945817672u, 2385729u},
    {7536058159073403734u, 14164249437475661690u, 14999153428301646640u, 2782197516033395280u, 881441u},
    {1891210864731987798u, 4914345747105709876u, 16959086785548703827u, 1457411600083830856u, 1835639u},
    {7790635341272925366u, 14813611845573825414u, 12962037869901953928u, 16462993004949701135u, 1168043u},
    {17958978041714770050u, 17929104395260601325u, 13796478971963559120u, 15153641354715947490u, 17641u},
    {9639955263611962202u, 8900521862372298500u, 16897316201608246303u, 17366205597306478240u, 571767u},
    {16780981326335527392u, 528405055983804228u, 9321208271656754243u, 4189887711084818574u, 2092997u},
    {654563766983656993u, 3284322122699404587u, 9010343991204909981u, 17404489147336562157u, 2786796u},
    {16905992522307680018u, 3715924470364159511u, 17373595393732597071u, 411695300191766310u, 876822u},
    {15724375795380033283u, 10933880751089627772u, 12152911692318761889u, 4483745341795425488u, 1751063u},
    {1475543489625124540u, 7259314463290069764u, 6950609512154400592u, 13435013906556283506u, 1377924u},
    {1766812104063920236u, 14630917600455783945u, 13968034921769482531u, 7951753568988109026u, 2239854u},
    {3854688477827651109u, 8384708743962984216u, 247427852435667771u, 11858763443672409707u, 2619823u},
    {11748601291748070398u, 12781685723172628308u, 5823520428661267084u, 12226060608668002606u, 288417u},
    {16701977612925290152u, 8933454386697815721u, 7681860244958351079u, 4040545632935532112u, 3236123u},
    {6796272415887301894u, 11242721605825448820u, 4422733812952952366u, 4815497143315834584u, 2844734u},
    {13470850048092668726u, 12302370010578182092u, 17019422237914620823u, 14103706922267224730u, 522021u},
    {17230582642883324361u, 8001405838775185813u, 2054241722599270996u, 11178556677770638936u, 3880374u},
    {7896484268293512522u, 13852695290440348432u, 7618935482568085446u, 14699271866966204313u, 291269u},
    {5453667737084745050u, 7857997881970697172u, 6564181966122760130u, 17443310736577437686u, 1080954u},
    {17651336191330814288u, 11244576812248229358u, 4334235003739330302u, 13566767778367215339u, 40862u},
    {5437681909105784718u, 11128610768719622834u, 1205463941935295180u, 4252151832660855922u, 2995035u},
    {9277743931130181063u, 9807877277803402210u, 10792866808670239348u, 10287427001774721431u, 2221637u},
    {16846172968080033005u, 18088790843938222336u, 16569544802255812276u, 4580610403840570836u, 1529309u},
    {8187152621097828267u, 18366448292537560280u, 9461043224483927740u, 8963352437016295148u, 180235u},
    {5246515376220185418u, 12397301648178212854u, 955631889099111764u, 8001717696091478374u, 1930180u},
    {8737803968765744918u, 10846800414060609061u, 7925629830953861753u, 12933914877267010942u, 1311540u},
    {16744539432027625477u, 7243045172799740550u, 10947397035170277522u, 17245958630721124606u, 677502u},
    {14611079944470653515u, 9090624293122507145u, 6642079267707307925u, 6065335622435331623u, 2910747u},
    {10552097391221860186u, 9108602399510603226u, 12413713833783431733u, 11727024045181979110u, 3391319u},
    {18097505492411232465u, 8650120233918785011u, 1084679890248696726u, 8997700466095396712u, 2638603u},
    {11068990695812137433u, 8519062185795396732u, 2177253708839596351u, 8551469739726319158u, 1900988u},
    {17047839748954332451u, 16409747739621186112u, 15379341367795972995u, 12861318786425835320u, 820551u},
    {5544125561659184123u, 17160680830530468182u, 13169051952683859968u, 2248921922333511248u, 2717762u},
    {3657847499898802821u, 10321289204717269063u, 13881444988968728651u, 7472066048222752348u, 3506133u},
    {16379028888362856975u, 18387394765579940647u, 10308285501244664999u, 12746813296286770275u, 66u},
    {14243663912197748962u, 18329339697206101571u, 2161532867808008544u, 1230231922161u, 0u},
    {5969091373988679880u, 17188136025545421677u, 4278208751150195364u, 1230u, 0u},
    {12680675224025632914u, 16577776133238396243u, 22693773419413u, 0u, 0u},
    {10668077713986553971u, 14267069989827446276u, 22693u, 0u, 0u},
    {12585626221615774165u, 418626230334680u, 0u, 0u, 0u},
    {4248924905845412207u, 418626u, 0u, 0u, 0u},
    {7722290933525641u, 0u, 0u, 0u, 0u},
    {7722291u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1287866u},
    {18175944690115874681u, 7655267744919564287u, 7406210136613019199u, 7445689120409809433u, 3572119u},
    {10847625266000508027u, 14539874783833844083u, 4036216546216463482u, 8352517286801237050u, 2399832u},
    {4165445768668573088u, 5126565539914075663u, 8761568170075843154u, 9051468349817407827u, 1730136u},
    {6024937110706186328u, 17531409296094507868u, 11291392306874377127u, 7742077947114469050u, 1829712u},
    {14355216620579439851u, 63504760232817724u, 4074584025334274518u, 17039344429685666094u, 3592620u},
    {14560738150314878831u, 3863433358066670588u, 227633084198576924u, 2372115167947128791u, 933645u},
    {13606233366945235474u, 3644897699410925774u, 4900361164253093943u, 14500799114366328858u, 2174840u},
    {1330407788655480480u, 8068523054051308694u, 11120994101747372512u, 7534108511326570939u, 1234070u},
    {10347368863617013259u, 17800478193568587624u, 12715858298320952246u, 7588811954975584537u, 2797461u},
    {8801496633549885713u, 12577492874818635365u, 17502852102097475680u, 18354232940345691294u, 3347826u},
    {10038024628370783513u, 12510608406678776922u, 12803481279836878376u, 17499694264958104205u, 1870972u},
    {13832474229877783844u, 16883915415516076844u, 3028862362776225937u, 1980068398176825044u, 496005u},
    {10570456235781452797u, 4038551618345995211u, 6015836020999212766u, 5989929984422367392u, 1896538u},
    {7067351040161245267u, 13961557824291287445u, 462511530827140866u, 7745147519160284102u, 293132u},
    {11557432760844213196u, 14404507029657287286u, 8201153351424719051u, 2599480724094367843u, 126935u},
    {11167416668031507503u, 15586958248640974381u, 530248032591351891u, 14269745159568208374u, 401920u},
    {4607500481811223949u, 2512073841962189877u, 10214166842321980496u, 7213173533440644102u, 2479610u},
    {16911135367827902514u, 14487362376995788978u, 13340572098205790141u, 11286725408202542490u, 3215448u},
    {12292719934125828030u, 5233825885718834446u, 9723397943666104771u, 10291492911010813550u, 1710608u},
    {7991571344544263038u, 3793145310017822514u, 12572490552470622854u, 12497518926839465987u, 2677599u},
    {7961953321745342688u, 6454183529323349911u, 9904351518696750030u, 16982927594895604508u, 2739422u},
    {9875061404911095300u, 152248179524697205u, 3737503312180917678u, 4229873887726637450u, 2076315u},
    {7468169753012386974u, 807995392738230431u, 7198149941132450985u, 7460233441557855543u, 3856623u},
    {6271579527007372757u, 2448465137078963239u, 11802380176447517665u, 9150398993708935329u, 3469382u},
    {3492691310623885220u, 14325732614100891615u, 5784099120941403590u, 7918276561132478609u, 2934279u},
    {4949256697655737066u, 14493347803859044289u, 9937694038715076760u, 198243089747992822u, 1140848u},
    {5822402818926646164u, 15213616458543158985u, 5349614636427059140u, 12703181481956563220u, 1493515u},
    {18038093081365905633u, 5846335837866421506u, 17309197197767993239u, 15447875625795006106u, 1289840u},
    {163672554861360263u, 16132924237036119649u, 15705328185914815464u, 12561814726423370017u, 2404087u},
    {922893871245062469u, 15084522603380053824u, 4412915154061562850u, 548750748447242453u, 3435759u},
    {1481440603756102380u, 13934154016424142174u, 14718269663859986266u, 1072184884051686107u, 3451354u},
    {17291074116397626963u, 5314444299533513371u, 15860034108341062299u, 1072472561548949743u, 2982255u},
    {10019438398507966052u, 833982230167520808u, 7443700706385906168u, 11512170347850555064u, 3374602u},
    {13056031255141532602u, 8484212921116599970u, 2822571293188762952u, 11951753447214908188u, 1347895u},
    {9571758180824089341u, 12106226995569028610u, 5356132196034571306u, 5789471809089221063u, 2320658u},
    {17521868644504777930u, 9749420838083518027u, 13342610993523478538u, 3285400321704835589u, 2488356u},
    {1860944360932115263u, 5507214541806476084u, 13388995228802835561u, 11935405085839789366u, 3743377u},
    {15966751775023847800u, 11866383330036118252u, 727476843832761184u, 4752796741891131566u, 2409994u},
    {10368810008505575774u, 10263087803409034261u, 523553092950771755u, 18202970244847812191u, 3343801u},
    {9873769803191398991u, 6901049952680570484u, 4629110942530175555u, 7123326475200322045u, 1626066u},
    {11060889486333782941u, 14937479225258295234u, 17678339438371813146u, 15954723912854360926u, 917756u},
    {3357100865835890481u, 13565409062479890677u, 1978498580434797534u, 16013715502428837088u, 372502u},
    {4509703953489492536u, 9771510667997014693u, 15216725091339611295u, 15066908619001599081u, 2924843u},
    {5933665978681151066u, 13777459932911179602u, 1453518021353232409u, 12015514455639726861u, 2496139u},
    {15818649474863133815u, 17523635238050186623u, 1861967954692414781u, 13953161298641011390u, 48086u},
    {12223248258919899027u, 10282108855623242520u, 2582882965082962930u, 4972861032705717280u, 232581u},
    {16783985122936806956u, 17242823714594456088u, 17157651953560420667u, 9299719998048972217u, 732215u},
    {9027219559761662247u, 4115992120237492483u, 7110881488946140047u, 3256098723718408357u, 1273280u},
    {1151355514189417111u, 16345487247858751812u, 11068578400095466020u, 2473446070839821445u, 2290651u},
    {12286441864168466310u, 16354311389243114419u, 17682374854544845305u, 16687559277993986144u, 2477103u},
    {14760406720670860315u, 3762139258935965907u, 7943806125592705541u, 5738244430769084373u, 3530167u},
    {11444007391683355438u, 483220968721978943u, 8645698326838591674u, 7198821902679565121u, 2130043u},
    {3238968452126550556u, 1028402625285107056u, 2441696075285330306u, 12721428915961135153u, 853776u},
    {10743192200776949914u, 14664154531868512355u, 1874874847361062229u, 6140644893313578922u, 2514578u},
    {9989884789492617769u, 15427118133839132304u, 3634690560524061557u, 2712516762363358942u, 3574222u},
    {2371603448217064448u, 5439927521271379692u, 6629791072510364275u, 14261278786680942455u, 3243618u},
    {14845207297153324320u, 6735078983616046958u, 1374820033583692785u, 14975756171231239167u, 3649008u},
    {8471516668371189260u, 17702829411697014283u, 13916889565808646318u, 10803893843325937378u, 674029u},
    {15077345244300726975u, 16285254048805653063u, 12767328092836662848u, 18315062536898847962u, 2885081u},
    {14063293713378669578u, 1618837871937554884u, 14474954553784743974u, 17058812562104977459u, 2359907u},
    {12653504340244137727u, 1000962947037128411u, 17163536384578285235u, 16400606464135209720u, 1756160u},
    {1370774816205994139u, 2467468124466438983u, 5555500414466540426u, 7526385230417597574u, 947325u},
    {17300801766966558950u, 15743838774592983168u, 7419737471639164154u, 10826114175045202531u, 2220500u},
    {18316125795277420432u, 1762627917160952277u, 7536058159073403733u, 14164249437475661690u, 782216u},
    {9395166232241221257u, 3218242381780225829u, 1891210864731987797u, 4914345747105709876u, 2266257u},
    {16261644403246186430u, 12259477467212816755u, 7790635341272925365u, 14813611845573825414u, 3188696u},
    {16751912492477263177u, 16148201652423666791u, 17958978041714770049u, 17929104395260601325u, 2029506u},
    {3750307038069343789u, 14009969822036118227u, 9639955263611962201u, 8900521862372298500u, 1301145u},
    {13286580334959333925u, 7678555389816786890u, 16780981326335527391u, 528405055983804228u, 2262209u},
    {1990108145106291980u, 188639050460711805u, 654563766983656992u, 3284322122699404587u, 2221919u},
    {12833897418097743373u, 10282651375478198204u, 16905992522307680017u, 3715924470364159511u, 2883113u},
    {9078361087720598019u, 4704700433734530499u, 15724375795380033282u, 10933880751089627772u, 2903225u},
    {738973680532346154u, 10061932139549093029u, 1475543489625124539u, 7259314463290069764u, 174882u},
    {15238720784819392855u, 14386825175926968416u, 1766812104063920235u, 14630917600455783945u, 1410971u},
    {12388355785831475458u, 16082039935066949316u, 3854688477827651108u, 8384708743962984216u, 1490321u},
    {3774166144724443385u, 2550475259698996054u, 11748601291748070397u, 12781685723172628308u, 3814782u},
    {14425957557561591728u, 16442666132919574618u, 16701977612925290151u, 8933454386697815721u, 94159u},
    {10687727611794265415u, 8366166447566721381u, 6796272415887301893u, 11242721605825448820u, 2850314u},
    {1495325053510103605u, 16815907966015786545u, 13470850048092668725u, 12302370010578182092u, 163329u},
    {5117733354934242316u, 413694465492173402u, 17230582642883324360u, 8001405838775185813u, 956116u},
    {18256462703973502121u, 8526326099546828163u, 7896484268293512521u, 13852695290440348432u, 201668u},
    {6997949821849426122u, 9040513917043740886u, 5453667737084745049u, 7857997881970697172u, 194730u},
    {795618814902093683u, 17354731531912062725u, 17651336191330814287u, 11244576812248229358u, 1720698u},
    {12009700581038726018u, 6535185280594675103u, 5437681909105784717u, 11128610768719622834u, 436092u},
    {6750706112534374918u, 13858197897391083212u, 9277743931130181062u, 9807877277803402210u, 126566u},
    {17758538486581523890u, 18166215559108204833u, 16846172968080033004u, 18088790843938222336u, 3459656u},
    {17851731245735552108u, 2382343814875895571u, 8187152621097828266u, 18366448292537560280u, 184068u},
    {3928825109794581548u, 11354409163709299731u, 5246515376220185417u, 12397301648178212854u, 2068728u},
    {89564757131068202u, 5844029050214052759u, 8737803968765744917u, 10846800414060609061u, 2021265u},
    {4086412896535992850u, 16069868801677807776u, 16744539432027625476u, 7243045172799740550u, 616230u},
    {664449364438189511u, 11185831798898310757u, 14611079944470653514u, 9090624293122507145u, 1590825u},
    {9993001578186057046u, 3070295168747421785u, 10552097391221860185u, 9108602399510603226u, 173957u},
    {18148594395200317835u, 2309989711224550511u, 18097505492411232464u, 8650120233918785011u, 881786u},
    {11938928447267806039u, 15307120335738287995u, 11068990695812137432u, 8519062185795396732u, 2855457u},
    {13019958630578139549u, 2644741736702570710u, 17047839748954332450u, 16409747739621186112u, 594871u},
    {1268497711052737284u, 5123244081068006769u, 5544125561659184122u, 17160680830530468182u, 924458u},
    {4673506242621971035u, 12175904070816763636u, 3657847499898802820u, 10321289204717269063u, 688917u},
    {17798896566336690957u, 10863135964947173124u, 16379028888362856974u, 18387394765579940647u, 1447995u},
    {10183315897612458670u, 17949110807595267139u, 14243663912197748961u, 18329339697206101571u, 2083220u},
    {6126912857785835408u, 7937744986925422378u, 5969091373988679879u, 17188136025545421677u, 245544u},
    {15370269484371110672u, 354398393913251049u, 12680675224025632913u, 16577776133238396243u, 3888163u},
    {8492849867248894701u, 15753647256792042207u, 10668077713986553970u, 14267069989827446276u, 22693u},
    {2317732147176234437u, 5499103440654516118u, 12585626221615774164u, 418626230334680u, 0u},
    {12947017446324628699u, 564784780460608025u, 4248924905845412206u, 418626u, 0u},
    {12968289412116232536u, 11071953871013697054u, 7722290933525640u, 0u, 0u},
    {8358797025175129917u, 17220508578397870217u, 7722290u, 0u, 0u},
    {13772170475209282336u, 142451124513475111u, 0u, 0u, 0u},
    {9471943974608774673u, 142451124u, 0u, 0u, 0u},
    {2627759436912208452u, 0u, 0u, 0u, 0u},
    {2627759437u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 930396u},
    {12181986584403920101u, 15971496792247495598u, 18175944690115874680u, 7655267744919564287u, 3051941u},
    {15111231234345070610u, 218567517507441426u, 10847625266000508026u, 14539874783833844083u, 567924u},
    {17654902731381076938u, 5684059778361461492u, 4165445768668573087u, 5126565539914075663u, 1160852u},
    {18228386366202115938u, 5563814848603174704u, 6024937110706186327u, 17531409296094507868u, 3442599u},
    {1182835648468876290u, 2960982063587611246u, 14355216620579439850u, 63504760232817724u, 2405892u},
    {10458164288020765787u, 12421679337107547124u, 14560738150314878830u, 3863433358066670588u, 2277800u},
    {13514109289920887984u, 15207972453761210196u, 13606233366945235473u, 3644897699410925774u, 3801761u},
    {1168810879383263021u, 5463192776038925383u, 1330407788655480479u, 8068523054051308694u, 122106u},
    {17057831288854468897u, 11549069632666333526u, 10347368863617013258u, 17800478193568587624u, 2139754u},
    {10653854005857538886u, 11061321990370634964u, 8801496633549885712u, 12577492874818635365u, 2420190u},
    {7029265320580996012u, 7085065910154696146u, 10038024628370783512u, 12510608406678776922u, 1216388u},
    {16635451233485039907u, 8779366145209329704u, 13832474229877783843u, 16883915415516076844u, 180321u},
    {11911329626309943437u, 3248861290734687151u, 10570456235781452796u, 4038551618345995211u, 2951316u},
    {4385046362723326112u, 11736554017735608681u, 7067351040161245266u, 13961557824291287445u, 3526140u},
    {6259531770902268921u, 11528592037470678311u, 11557432760844213195u, 14404507029657287286u, 1220699u},
    {1428407972321512321u, 13980697232648261136u, 11167416668031507502u, 15586958248640974381u, 3367295u},
    {3640085384168927337u, 8843161006750416686u, 4607500481811223948u, 2512073841962189877u, 205238u},
    {13062080710907200045u, 2180805600275982094u, 16911135367827902513u, 14487362376995788978u, 2476269u},
    {2549157310601946578u, 10638765347538213953u, 12292719934125828029u, 5233825885718834446u, 2501819u},
    {4737677596594630706u, 17307311373963744549u, 7991571344544263037u, 3793145310017822514u, 2225740u},
    {10308515873487634167u, 2217724793202046242u, 7961953321745342687u, 6454183529323349911u, 440890u},
    {10222748203656361726u, 6967053059013726903u, 9875061404911095299u, 152248179524697205u, 832768u},
    {14697197917020932749u, 10096249597489203439u, 7468169753012386973u, 807995392738230431u, 3825311u},
    {395313721750049535u, 770636447841600833u, 6271579527007372756u, 2448465137078963239u, 3162021u},
    {1482441763369634669u, 11081504377815806663u, 3492691310623885219u, 14325732614100891615u, 529708u},
    {6829471190444661862u, 15530681066071851219u, 4949256697655737065u, 14493347803859044289u, 513050u},
    {1405011819808813327u, 346040440020806363u, 5822402818926646163u, 15213616458543158985u, 524250u},
    {9771534212328799578u, 6163498496830876988u, 18038093081365905632u, 5846335837866421506u, 3473825u},
    {13187544808009946639u, 4547095266725626469u, 163672554861360262u, 16132924237036119649u, 1327358u},
    {12968385261638966893u, 14766181337036579976u, 922893871245062468u, 15084522603380053824u, 1465752u},
    {1229914537990081165u, 13084219581933358516u, 1481440603756102379u, 13934154016424142174u, 2940352u},
    {16907874551947151006u, 15174809580457566136u, 17291074116397626962u, 5314444299533513371u, 2241517u},
    {12623441536697841520u, 18197772995807521805u, 10019438398507966051u, 833982230167520808u, 2898854u},
    {15464050431895369498u, 7195396096510188790u, 13056031255141532601u, 8484212921116599970u, 29880u},
    {4335184208302255568u, 8096080464106081053u, 9571758180824089340u, 12106226995569028610u, 1173412u},
    {16076924163268322774u, 2597872906231836263u, 17521868644504777929u, 9749420838083518027u, 1671698u},
    {13614697823000339778u, 1518754550216172579u, 1860944360932115262u, 5507214541806476084u, 2652929u},
    {11953981945128748294u, 911668161834320737u, 15966751775023847799u, 11866383330036118252u, 1675604u},
    {1042204472225073446u, 5276920897393723454u, 10368810008505575773u, 10263087803409034261u, 3012917u},
    {15201856092342703604u, 13887976253730079273u, 9873769803191398990u, 6901049952680570484u, 1168621u},
    {5619768001860692748u, 17624449295514440037u, 11060889486333782940u, 14937479225258295234u, 1007298u},
    {10049542477040773946u, 16358332338008287380u, 3357100865835890480u, 13565409062479890677u, 2370904u},
    {6520495263986619669u, 15097751280289553108u, 4509703953489492535u, 9771510667997014693u, 783849u},
    {7022295103518921674u, 15955706228397454839u, 5933665978681151065u, 13777459932911179602u, 739419u},
    {9763747552124664881u, 16474269919928624034u, 15818649474863133814u, 17523635238050186623u, 2706737u},
    {9881937375226132544u, 12657153293100334419u, 12223248258919899026u, 10282108855623242520u, 1141596u},
    {1287427258621066781u, 5001560217585169563u, 16783985122936806955u, 17242823714594456088u, 472129u},
    {15035545505341422080u, 13369369766335253340u, 9027219559761662246u, 4115992120237492483u, 3278139u},
    {1025798881911427490u, 14689606402451692103u, 1151355514189417110u, 16345487247858751812u, 3756496u},
    {6367309710592256847u, 7352198490483173656u, 12286441864168466309u, 16354311389243114419u, 820977u},
    {6716135893926928294u, 18065448497552368146u, 14760406720670860314u, 3762139258935965907u, 2757961u},
    {15962543524153503973u, 13632461947298126041u, 11444007391683355437u, 483220968721978943u, 1062318u},
    {11029053160716200959u, 4879022389941825218u, 3238968452126550555u, 1028402625285107056u, 1976660u},
    {11333919266908695456u, 5551916771657570950u, 10743192200776949913u, 14664154531868512355u, 368249u},
    {1950897079867767236u, 16300025211631531126u, 9989884789492617768u, 15427118133839132304u, 1930311u},
    {11833761458623810241u, 15817416172814212974u, 2371603448217064447u, 5439927521271379692u, 1828113u},
    {13894200652905991281u, 10601514412020745078u, 14845207297153324319u, 6735078983616046958u, 2641055u},
    {6740268928175226052u, 8135651057840059644u, 8471516668371189259u, 17702829411697014283u, 12890u},
    {8721762201997654727u, 9123546142823230246u, 15077345244300726974u, 16285254048805653063u, 1819876u},
    {17504684616106405965u, 12533201938472821501u, 14063293713378669577u, 1618837871937554884u, 3481060u},
    {13696869768241643114u, 10709911793451761417u, 12653504340244137726u, 1000962947037128411u, 949215u},
    {5413744727511742053u, 1953638265413113001u, 1370774816205994138u, 2467468124466438983u, 1912710u},
    {6353748886222320295u, 1716403609348992605u, 17300801766966558949u, 15743838774592983168u, 1802250u},
    {5733115192565114599u, 3289689720584482998u, 18316125795277420431u, 1762627917160952277u, 2586269u},
    {7483103070727639371u, 18368303485236696200u, 9395166232241221256u, 3218242381780225829u, 525105u},
    {4504639570050754447u, 13460843734022380491u, 16261644403246186429u, 12259477467212816755u, 395765u},
    {14252516640378285448u, 16144523077708830194u, 16751912492477263176u, 16148201652423666791u, 1669485u},
    {11659428154873596249u, 3310592755293446813u, 3750307038069343788u, 14009969822036118227u, 2192821u},
    {8915981943183589720u, 11389130401096335885u, 13286580334959333924u, 7678555389816786890u, 2413643u},
    {17941469998232085959u, 16412849839208409694u, 1990108145106291979u, 188639050460711805u, 2736148u},
    {10745236668125140690u, 1719796367424984913u, 12833897418097743372u, 10282651375478198204u, 1136071u},
    {11668869914406259700u, 5004055866653544802u, 9078361087720598018u, 4704700433734530499u, 2489684u},
    {2398137578613066719u, 1069068255755505776u, 738973680532346153u, 10061932139549093029u, 2567605u},
    {12173252274844085091u, 3119600778335745775u, 15238720784819392854u, 14386825175926968416u, 715381u},
    {7779451514898190370u, 4662559300903692274u, 12388355785831475457u, 16082039935066949316u, 1542790u},
    {13941398414451698301u, 2611548968366425961u, 3774166144724443384u, 2550475259698996054u, 733717u},
    {4874433356834056814u, 4106772810299803251u, 14425957557561591727u, 16442666132919574618u, 405791u},
    {17374778453081109726u, 1678950910308113541u, 10687727611794265414u, 8366166447566721381u, 1435947u},
    {5138078875148400339u, 8119812951156970227u, 1495325053510103604u, 16815907966015786545u, 2895171u},
    {2912354010813359165u, 10241434937681767316u, 5117733354934242315u, 413694465492173402u, 1275564u},
    {3471031822902840676u, 10205128629966580448u, 18256462703973502120u, 8526326099546828163u, 1805991u},
    {12019928546986503950u, 12545564689178187098u, 6997949821849426121u, 9040513917043740886u, 3301881u},
    {3739081728399905738u, 120764076041066072u, 795618814902093682u, 17354731531912062725u, 2710603u},
    {10746521026925628521u, 11003026283172687303u, 12009700581038726017u, 6535185280594675103u, 1254413u},
    {4874935658480306537u, 14840364906338189881u, 6750706112534374917u, 13858197897391083212u, 417518u},
    {13067573027275812528u, 13099618056963303354u, 17758538486581523889u, 18166215559108204833u, 240866u},
    {8010180642101603212u, 13212386617306981441u, 17851731245735552107u, 2382343814875895571u, 2242504u},
    {12732483497093545816u, 15657055284633139906u, 3928825109794581547u, 11354409163709299731u, 399199u},
    {17639855793648380614u, 7360630664187411837u, 89564757131068201u, 5844029050214052759u, 55583u},
    {18367056462793991361u, 12656967691294569571u, 4086412896535992849u, 16069868801677807776u, 916406u},
    {14407224184124611121u, 17002474724306247746u, 664449364438189510u, 11185831798898310757u, 2378534u},
    {16841924614262361654u, 14849782583929821480u, 9993001578186057045u, 3070295168747421785u, 224793u},
    {15424349999154457458u, 2291827427723944976u, 18148594395200317834u, 2309989711224550511u, 1675656u},
    {5430325087087786125u, 5340493746854411284u, 11938928447267806038u, 15307120335738287995u, 2746736u},
    {5387313836954760779u, 4708781826258913330u, 13019958630578139548u, 2644741736702570710u, 387868u},
    {6194829614151815332u, 15752093805487746337u, 1268497711052737283u, 5123244081068006769u, 3807082u},
    {5908875843727476230u, 16638176951558943788u, 4673506242621971034u, 12175904070816763636u, 2954280u},
    {11375067196308633171u, 3247336988790455116u, 17798896566336690956u, 10863135964947173124u, 366996u},
    {8849437582602842620u, 11698288977271296823u, 10183315897612458669u, 17949110807595267139u, 618517u},
    {17828695938951382696u, 16357392894746685255u, 6126912857785835407u, 7937744986925422378u, 3586975u},
    {129956130789614939u, 15969048538284681688u, 15370269484371110671u, 354398393913251049u, 2444429u},
    {18027076071370085168u, 6713406209680871802u, 8492849867248894700u, 15753647256792042207u, 1231994u},
    {247647889258020129u, 1300024629214192236u, 2317732147176234436u, 5499103440654516118u, 3273294u},
    {16832433418235468468u, 6471803819875948446u, 12947017446324628698u, 564784780460608025u, 2555572u},
    {15919822867243450136u, 9093874608657053415u, 12968289412116232535u, 11071953871013697054u, 3838140u},
    {15144482471953204266u, 629101109709054547u, 8358797025175129916u, 17220508578397870217u, 3816040u},
    {16769134371627316483u, 4617309103158989748u, 13772170475209282335u, 142451124513475111u, 0u},
    {14749365850763347666u, 18356571062185531128u, 9471943974608774672u, 142451124u, 0u},
    {15861942479386815961u, 15568887028888437367u, 2627759436912208451u, 0u, 0u},
    {7827768558830313940u, 16827275853040906932u, 2627759436u, 0u, 0u},
    {5791456914435240281u, 11580117672575526403u, 2u, 0u, 0u},
    {18347678330763601335u, 48473605819u, 0u, 0u, 0u},
    {8736485353260286892u, 48u, 0u, 0u, 0u},
    {894180200892u, 0u, 0u, 0u, 0u},
    {895u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2535326u},
    {8163866615124625078u, 8815600413425464813u, 12181986584403920100u, 15971496792247495598u, 129818u},
    {3756679973730394940u, 10929723099882762541u, 15111231234345070609u, 218567517507441426u, 3445998u},
    {3792339739226977707u, 6081303320703483891u, 17654902731381076937u, 5684059778361461492u, 833757u},
    {11032014551946102358u, 15317589696874915092u, 18228386366202115937u, 5563814848603174704u, 358909u},
    {3021922972585390783u, 2971753975756252492u, 1182835648468876289u, 2960982063587611246u, 1505586u},
    {5625459086928660130u, 1127890032187084112u, 10458164288020765786u, 12421679337107547124u, 207088u},
    {2290231166394691172u, 463350815901060515u, 13514109289920887983u, 15207972453761210196u, 3191523u},
    {1591530238799760142u, 2565060475876834645u, 1168810879383263020u, 5463192776038925383u, 1076319u},
    {1962225123427322875u, 7017923811513828080u, 17057831288854468896u, 11549069632666333526u, 1979216u},
    {2922100916717916140u, 7892354751505768996u, 10653854005857538885u, 11061321990370634964u, 1269692u},
    {4192073728047168845u, 8297940602657473012u, 7029265320580996011u, 7085065910154696146u, 3274142u},
    {15322983430719117805u, 6589890861975900925u, 16635451233485039906u, 8779366145209329704u, 339873u},
    {14721982192695353033u, 10463484998501465487u, 11911329626309943436u, 3248861290734687151u, 3427368u},
    {13897733594665952942u, 16933322656287143035u, 4385046362723326111u, 11736554017735608681u, 3872476u},
    {8870826049923397106u, 9164151788758737963u, 6259531770902268920u, 11528592037470678311u, 82615u},
    {16512539122270692071u, 16194524578090662401u, 1428407972321512320u, 13980697232648261136u, 2826218u},
    {7992104736368973538u, 93368285110581768u, 3640085384168927336u, 8843161006750416686u, 1034208u},
    {15271283335199573411u, 15256910214614412835u, 13062080710907200044u, 2180805600275982094u, 2509875u},
    {3438487923346234946u, 7749328667439011339u, 2549157310601946577u, 10638765347538213953u, 731229u},
    {3672830183137505039u, 3718938303875928723u, 4737677596594630705u, 17307311373963744549u, 3035601u},
    {2081933537181018026u, 3925779722682659896u, 10308515873487634166u, 2217724793202046242u, 2684703u},
    {14874539317041307377u, 11179073822062818183u, 10222748203656361725u, 6967053059013726903u, 443787u},
    {4273994457605610278u, 2215654029371070351u, 14697197917020932748u, 10096249597489203439u, 2713785u},
    {5085023259080016616u, 8158277917968731766u, 395313721750049534u, 770636447841600833u, 3073306u},
    {16206861719554542673u, 13081309306299922235u, 1482441763369634668u, 11081504377815806663u, 2076157u},
    {16552221470310186548u, 677118523475933345u, 6829471190444661861u, 15530681066071851219u, 3133889u},
    {12369429741319999396u, 7919448234502527948u, 1405011819808813326u, 346040440020806363u, 2092673u},
    {11585815203279262519u, 12374220222995960014u, 9771534212328799577u, 6163498496830876988u, 404778u},
    {17816198623065959496u, 17674728532857981929u, 13187544808009946638u, 4547095266725626469u, 3601294u},
    {5027940966784259144u, 156697840563726132u, 12968385261638966892u, 14766181337036579976u, 2265714u},
    {6048252117424139692u, 3206554947404307076u, 1229914537990081164u, 13084219581933358516u, 2315575u},
    {685897838456388597u, 10467977920998210419u, 16907874551947151005u, 15174809580457566136u, 2128250u},
    {15047940978887662530u, 3764220119568123171u, 12623441536697841519u, 18197772995807521805u, 3344453u},
    {7670743600567911675u, 9213816018446259947u, 15464050431895369497u, 7195396096510188790u, 1389401u},
    {7613167468013899454u, 1293706935464005776u, 4335184208302255567u, 8096080464106081053u, 205972u},
    {6331109402334264113u, 17255129547024369884u, 16076924163268322773u, 2597872906231836263u, 300599u},
    {16804516859707540894u, 17023318147755151793u, 13614697823000339777u, 1518754550216172579u, 2546630u},
    {5751453701595367597u, 1934523368135715970u, 11953981945128748293u, 911668161834320737u, 906205u},
    {7227253740206374409u, 7229163988971997067u, 1042204472225073445u, 5276920897393723454u, 2868701u},
    {11591773625600103219u, 4425627829944260033u, 15201856092342703603u, 13887976253730079273u, 2298310u},
    {16651686420421004799u, 6998660229026357949u, 5619768001860692747u, 17624449295514440037u, 68222u},
    {17099059740448597138u, 6845471827983439696u, 10049542477040773945u, 16358332338008287380u, 2044486u},
    {17299385238770679644u, 8836205156700109104u, 6520495263986619668u, 15097751280289553108u, 1679317u},
    {5273368384467493325u, 4491740648716826981u, 7022295103518921673u, 15955706228397454839u, 2446961u},
    {11886070801882379352u, 5367572960611975694u, 9763747552124664880u, 16474269919928624034u, 2551904u},
    {9361893483037278945u, 18321602252724794516u, 9881937375226132543u, 12657153293100334419u, 1603872u},
    {7656715528543338792u, 3917374183200232908u, 1287427258621066780u, 5001560217585169563u, 2098737u},
    {1550918648730072577u, 9006837886941962213u, 15035545505341422079u, 13369369766335253340u, 3356408u},
    {11898011301811865514u, 10780822660564727221u, 1025798881911427489u, 14689606402451692103u, 125978u},
    {4177149011348618969u, 5023415604492720754u, 6367309710592256846u, 7352198490483173656u, 2767425u},
    {5292367669190950545u, 11147473369970568886u, 6716135893926928293u, 18065448497552368146u, 735992u},
    {1602538428561603188u, 628601979761506876u, 15962543524153503972u, 13632461947298126041u, 2773583u},
    {10445979660577461197u, 10173436099464190426u, 11029053160716200958u, 4879022389941825218u, 188761u},
    {5532138307355905356u, 9228892456553198375u, 11333919266908695455u, 5551916771657570950u, 813637u},
    {18304143497981494122u, 7014856401339363267u, 1950897079867767235u, 16300025211631531126u, 1995098u},
    {12341393680452422847u, 273187782797476880u, 11833761458623810240u, 15817416172814212974u, 490497u},
    {7183239188247144891u, 9374817149641972395u, 13894200652905991280u, 10601514412020745078u, 3534527u},
    {14496459338166671970u, 12135718913014916721u, 6740268928175226051u, 8135651057840059644u, 2400927u},
    {15775681242647362558u, 13617948504299803624u, 8721762201997654726u, 9123546142823230246u, 3644988u},
    {6231388820791498077u, 17074579155588359644u, 17504684616106405964u, 12533201938472821501u, 2460481u},
    {6138631867429751199u, 16822912553937124170u, 13696869768241643113u, 10709911793451761417u, 438192u},
    {8387032859203289224u, 15398798473135002538u, 5413744727511742052u, 1953638265413113001u, 3202676u},
    {13303934280104098670u, 6547817996362043893u, 6353748886222320294u, 1716403609348992605u, 2553187u},
    {6216948061422808697u, 10603746440337321684u, 5733115192565114598u, 3289689720584482998u, 3560227u},
    {4029221447440730378u, 9000164193663859681u, 7483103070727639370u, 18368303485236696200u, 3151300u},
    {7995069779741087642u, 12912561665195494211u, 4504639570050754446u, 13460843734022380491u, 196349u},
    {9660569969765770281u, 2911856306985989197u, 14252516640378285447u, 16144523077708830194u, 3686342u},
    {17371122645233230432u, 2872396073527216567u, 11659428154873596248u, 3310592755293446813u, 218496u},
    {7935189411316950643u, 6974459962369570706u, 8915981943183589719u, 11389130401096335885u, 3023622u},
    {11059459160753215258u, 2271596838729496942u, 17941469998232085958u, 16412849839208409694u, 3386597u},
    {398716164716474284u, 223329088068311825u, 10745236668125140689u, 1719796367424984913u, 1739162u},
    {8976402028527024521u, 1699866894766597984u, 11668869914406259699u, 5004055866653544802u, 3266806u},
    {10129170931797835562u, 10837264156100085344u, 2398137578613066718u, 1069068255755505776u, 1145147u},
    {2019682367876223352u, 16886237453093243005u, 12173252274844085090u, 3119600778335745775u, 2757846u},
    {12083149761780150008u, 17553760563565506991u, 7779451514898190369u, 4662559300903692274u, 947353u},
    {15608685337998466288u, 13080237984139836051u, 13941398414451698300u, 2611548968366425961u, 3878600u},
    {10767801110524943101u, 3262175287910991080u, 4874433356834056813u, 4106772810299803251u, 1172361u},
    {17496032099057695114u, 3946275899566195562u, 17374778453081109725u, 1678950910308113541u, 2675942u},
    {8598671037152785834u, 5702507171798922006u, 5138078875148400338u, 8119812951156970227u, 501800u},
    {11903712109094901176u, 16394690821762138635u, 2912354010813359164u, 10241434937681767316u, 2439881u},
    {14822422460254653228u, 2815315459825800152u, 3471031822902840675u, 10205128629966580448u, 408924u},
    {3934268906962121115u, 16171854464059184793u, 12019928546986503949u, 12545564689178187098u, 2640383u},
    {9617952194617061199u, 14602109937890966171u, 3739081728399905737u, 120764076041066072u, 2725250u},
    {1109239532024534584u, 7761321651423036664u, 10746521026925628520u, 11003026283172687303u, 3716543u},
    {13597218282090962408u, 13674142982417844433u, 4874935658480306536u, 14840364906338189881u, 3100467u},
    {3589842977181610847u, 6033084844158056239u, 13067573027275812527u, 13099618056963303354u, 1401163u},
    {13703557547603748579u, 5036992661637650199u, 8010180642101603211u, 13212386617306981441u, 1114417u},
    {13043672512145332636u, 10170114638474901187u, 12732483497093545815u, 15657055284633139906u, 583087u},
    {13634750685153807422u, 12233485605936462632u, 17639855793648380613u, 7360630664187411837u, 2541843u},
    {3877417811426707578u, 6663196640440377348u, 18367056462793991360u, 12656967691294569571u, 3737251u},
    {7465570360967084747u, 17591102039116459392u, 14407224184124611120u, 17002474724306247746u, 320826u},
    {3131880542454443372u, 7449741813886929166u, 16841924614262361653u, 14849782583929821480u, 3146463u},
    {4993019734488650765u, 16793057319132471236u, 15424349999154457457u, 2291827427723944976u, 446246u},
    {12335434059086661664u, 1101876595089594835u, 5430325087087786124u, 5340493746854411284u, 1357324u},
    {17020645246512663940u, 4149130443893111634u, 5387313836954760778u, 4708781826258913330u, 2360216u},
    {17024184646430041853u, 11622123072869018340u, 6194829614151815331u, 15752093805487746337u, 3519879u},
    {4370762186902936362u, 2578481231218993549u, 5908875843727476229u, 16638176951558943788u, 257240u},
    {7499191415655916224u, 8688030500069425817u, 11375067196308633170u, 3247336988790455116u, 1353016u},
    {12168058433130489341u, 11681436148006713730u, 8849437582602842619u, 11698288977271296823u, 17295u},
    {15077937738970172217u, 18359861894605431662u, 17828695938951382695u, 16357392894746685255u, 2402605u},
    {938794333914822707u, 17805676477893153743u, 129956130789614938u, 15969048538284681688u, 653229u},
    {523010629759113669u, 10271408508410679282u, 18027076071370085167u, 6713406209680871802u, 161976u},
    {6230671190300872015u, 10824812391060944126u, 247647889258020128u, 1300024629214192236u, 3180938u},
    {13054816828403416799u, 8465196699150677018u, 16832433418235468467u, 6471803819875948446u, 792430u},
    {10410315733161809530u, 7960420932742020915u, 15919822867243450135u, 9093874608657053415u, 2853639u},
    {7372054211036686548u, 15238987347492705209u, 15144482471953204265u, 629101109709054547u, 304828u},
    {9830265663053993241u, 17910161231282499678u, 16769134371627316482u, 4617309103158989748u, 2924211u},
    {11424303515517625597u, 11771060474967701561u, 14749365850763347665u, 18356571062185531128u, 241056u},
    {13892957692434102715u, 8020423877981548614u, 15861942479386815960u, 15568887028888437367u, 2052201u},
    {2982846315137791295u, 3222013253014825423u, 7827768558830313939u, 16827275853040906932u, 2759436u},
    {2573329932403645252u, 16303506663310658811u, 5791456914435240280u, 11580117672575526403u, 2u},
    {7693211869949031452u, 4998706841964713392u, 18347678330763601334u, 48473605819u, 0u},
    {4947999685374842836u, 18115714267933000613u, 8736485353260286891u, 48u, 0u},
    {17336551818813049962u, 5880166413083195611u, 894180200891u, 0u, 0u},
    {9165919061031204796u, 3324119724011597289u, 894u, 0u, 0u},
    {6470047789939746098u, 16494713321620u, 0u, 0u, 0u},
    {13158461372853944559u, 16494u, 0u, 0u, 0u},
    {304273755213139u, 0u, 0u, 0u, 0u},
    {304274u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1332156u},
    {10357547517412061369u, 9230365861615905752u, 8163866615124625077u, 8815600413425464813u, 2657726u},
    {12689744145862814663u, 5534427971354952607u, 3756679973730394939u, 10929723099882762541u, 1543113u},
    {15919152305506937448u, 6008357695010552448u, 3792339739226977706u, 6081303320703483891u, 2243201u},
    {11793017079045306904u, 11479523544932461991u, 11032014551946102357u, 15317589696874915092u, 942855u},
    {11095217311000957428u, 6453370386084214955u, 3021922972585390782u, 2971753975756252492u, 2549291u},
    {15530752049156759787u, 17319565929248140390u, 5625459086928660129u, 1127890032187084112u, 1680798u},
    {14303917747449282570u, 3781711845659236640u, 2290231166394691171u, 463350815901060515u, 2333457u},
    {7272449710585464605u, 6017637881266438124u, 1591530238799760141u, 2565060475876834645u, 1536162u},
    {7958188303667288787u, 6843157904319299370u, 1962225123427322874u, 7017923811513828080u, 2064158u},
    {12186468892917602794u, 14021263223047648719u, 2922100916717916139u, 7892354751505768996u, 613511u},
    {8960236162358805589u, 6105792815398911193u, 4192073728047168844u, 8297940602657473012u, 1769949u},
    {14369107409183867743u, 5284844240336108202u, 15322983430719117804u, 6589890861975900925u, 820408u},
    {7759767420768103738u, 17210012596593748736u, 14721982192695353032u, 10463484998501465487u, 3894760u},
    {9014785117066191000u, 11341069046625183976u, 13897733594665952941u, 16933322656287143035u, 695913u},
    {1149041056538286552u, 9450761907999225893u, 8870826049923397105u, 9164151788758737963u, 2906936u},
    {2218190668012101534u, 4199477464437021680u, 16512539122270692070u, 16194524578090662401u, 1155254u},
    {7041643151205768078u, 14168425958174753559u, 7992104736368973537u, 93368285110581768u, 2860010u},
    {15575739300467361829u, 18442781450549783656u, 15271283335199573410u, 15256910214614412835u, 2123198u},
    {7343895722542194328u, 3540318657724348581u, 3438487923346234945u, 7749328667439011339u, 2385299u},
    {17981612915669490926u, 7264219223784778155u, 3672830183137505038u, 3718938303875928723u, 1879445u},
    {8184690701322446864u, 4111656147724130341u, 2081933537181018025u, 3925779722682659896u, 550056u},
    {10560751637884163631u, 16359522600656850341u, 14874539317041307376u, 11179073822062818183u, 2923345u},
    {18041497248255616812u, 7784183348747040153u, 4273994457605610277u, 2215654029371070351u, 854882u},
    {9819148632726950774u, 17584832600669346656u, 5085023259080016615u, 8158277917968731766u, 2107948u},
    {17927564160922959661u, 16936006646224471303u, 16206861719554542672u, 13081309306299922235u, 1550418u},
    {9856905981785408609u, 17382607503135238306u, 16552221470310186547u, 677118523475933345u, 3532899u},
    {5860790369124476509u, 15641234328068079353u, 12369429741319999395u, 7919448234502527948u, 2839072u},
    {2209854884224846680u, 10023447833576035182u, 11585815203279262518u, 12374220222995960014u, 1117703u},
    {2790670337304071223u, 17217281688408550168u, 17816198623065959495u, 17674728532857981929u, 682106u},
    {526870151639811554u, 17157558240288180873u, 5027940966784259143u, 156697840563726132u, 1952692u},
    {5008109961745929957u, 1673636342604286955u, 6048252117424139691u, 3206554947404307076u, 1063970u},
    {17968925205866319588u, 9278985780623921696u, 685897838456388596u, 10467977920998210419u, 933781u},
    {5544956108785444279u, 11574793934687563754u, 15047940978887662529u, 3764220119568123171u, 3388217u},
    {3031796660650761672u, 1338695299993804316u, 7670743600567911674u, 9213816018446259947u, 3725743u},
    {15602331034356274679u, 10561643365093435422u, 7613167468013899453u, 1293706935464005776u, 1808697u},
    {10623993448113185737u, 17780194986381740229u, 6331109402334264112u, 17255129547024369884u, 960925u},
    {11011325022666076761u, 9252028259896739339u, 16804516859707540893u, 17023318147755151793u, 3308221u},
    {11064929896272546838u, 501164048385388930u, 5751453701595367596u, 1934523368135715970u, 1268765u},
    {16821029319824989903u, 4313714950249182321u, 7227253740206374408u, 7229163988971997067u, 1632515u},
    {15400054770191515220u, 10488385555074115298u, 11591773625600103218u, 4425627829944260033u, 491881u},
    {3765921449259374180u, 10305371022968423899u, 16651686420421004798u, 6998660229026357949u, 21u},
    {15427233931600193971u, 15879712850698324049u, 17099059740448597137u, 6845471827983439696u, 2449141u},
    {16429171171914794037u, 2905457558709084234u, 17299385238770679643u, 8836205156700109104u, 1310248u},
    {7631251170475921899u, 7636819140630160850u, 5273368384467493324u, 4491740648716826981u, 1914213u},
    {17558673881488041396u, 10777856072259518578u, 11886070801882379351u, 5367572960611975694u, 1028548u},
    {14408848954087496804u, 16038461564619177652u, 9361893483037278944u, 18321602252724794516u, 1423779u},
    {13851299247256293209u, 8700019919499881452u, 7656715528543338791u, 3917374183200232908u, 3886660u},
    {6928211846133371484u, 13442051638784583457u, 1550918648730072576u, 9006837886941962213u, 2398317u},
    {16483538883289334639u, 14198059296712680673u, 11898011301811865513u, 10780822660564727221u, 2788655u},
    {12612746132506313127u, 14562529937749833136u, 4177149011348618968u, 5023415604492720754u, 2743242u},
    {16972703136619840795u, 9537663692448449164u, 5292367669190950544u, 11147473369970568886u, 2826581u},
    {1442071652390777015u, 11014223576922793060u, 1602538428561603187u, 628601979761506876u, 721826u},
    {1494791398405139302u, 460310082941027851u, 10445979660577461196u, 10173436099464190426u, 299262u},
    {2898418746400981135u, 17971465262637237293u, 5532138307355905355u, 9228892456553198375u, 1369877u},
    {17682288220464515513u, 9415960988236436469u, 18304143497981494121u, 7014856401339363267u, 3090789u},
    {7762163047393904987u, 189307451522884195u, 12341393680452422846u, 273187782797476880u, 397356u},
    {644595414168567178u, 14948711274992337816u, 7183239188247144890u, 9374817149641972395u, 1628640u},
    {8036851928384574849u, 8346875929478381423u, 14496459338166671969u, 12135718913014916721u, 3855467u},
    {13170819124976887831u, 10611914863326403017u, 15775681242647362557u, 13617948504299803624u, 3739790u},
    {5056132899745801070u, 1111475020145813818u, 6231388820791498076u, 17074579155588359644u, 1815666u},
    {12787560325301998230u, 7422093153306839617u, 6138631867429751198u, 16822912553937124170u, 2739287u},
    {2610440400959573337u, 5544755360769602118u, 8387032859203289223u, 15398798473135002538u, 3395424u},
    {12187758610128512368u, 15127584063414998092u, 13303934280104098669u, 6547817996362043893u, 611496u},
    {16651651206182553072u, 12500951409579072644u, 6216948061422808696u, 10603746440337321684u, 3524878u},
    {15468774997568993584u, 1428744760769485674u, 4029221447440730377u, 9000164193663859681u, 772620u},
    {8569212913005387886u, 7870480320092824053u, 7995069779741087641u, 12912561665195494211u, 1602046u},
    {1491757598661686069u, 3044111100577339947u, 9660569969765770280u, 2911856306985989197u, 3369153u},
    {1675893101608463941u, 14522741609347722671u, 17371122645233230431u, 2872396073527216567u, 3086232u},
    {17166329577766864884u, 1998271144189718983u, 7935189411316950642u, 6974459962369570706u, 2049761u},
    {13880847447585226604u, 16007596666569646713u, 11059459160753215257u, 2271596838729496942u, 387944u},
    {7418273306547148640u, 15522197155144027453u, 398716164716474283u, 223329088068311825u, 2306219u},
    {5734838267100076081u, 7249171009140622907u, 8976402028527024520u, 1699866894766597984u, 1551767u},
    {7501168575943300642u, 1531253459909261842u, 10129170931797835561u, 10837264156100085344u, 1342266u},
    {15577198419936373605u, 9023238903158520725u, 2019682367876223351u, 16886237453093243005u, 2372516u},
    {16018000699146378398u, 13381502931803973746u, 12083149761780150007u, 17553760563565506991u, 2049871u},
    {16826388915588212574u, 9020820141032337253u, 15608685337998466287u, 13080237984139836051u, 1061626u},
    {11481921245098449907u, 3980109336884848136u, 10767801110524943100u, 3262175287910991080u, 2990545u},
    {2513895287813735029u, 7917562076670726034u, 17496032099057695113u, 3946275899566195562u, 539783u},
    {16131280757933920094u, 9798492696459038594u, 8598671037152785833u, 5702507171798922006u, 2039220u},
    {250443675894036235u, 13527953884283184663u, 11903712109094901175u, 16394690821762138635u, 274806u},
    {3372695677125126505u, 5396832420334655925u, 14822422460254653227u, 2815315459825800152u, 1677987u},
    {7302741706840235422u, 8037577166880069745u, 3934268906962121114u, 16171854464059184793u, 2519465u},
    {2648938012486823605u, 6528074770860124581u, 9617952194617061198u, 14602109937890966171u, 2773339u},
    {9279731804823052329u, 15543505440912649303u, 1109239532024534583u, 7761321651423036664u, 2995526u},
    {14726248143793099331u, 18131848262013267428u, 13597218282090962407u, 13674142982417844433u, 2835434u},
    {3514998542411777102u, 11884278713554098346u, 3589842977181610846u, 6033084844158056239u, 3524669u},
    {15554864426391329354u, 1611344025330587633u, 13703557547603748578u, 5036992661637650199u, 541769u},
    {5862789393137470636u, 16587788678303420461u, 13043672512145332635u, 10170114638474901187u, 3022333u},
    {2049677894725082041u, 12100098903057597686u, 13634750685153807421u, 12233485605936462632u, 1837613u},
    {10064718111758034697u, 6849557602429764299u, 3877417811426707577u, 6663196640440377348u, 490552u},
    {5833155836991042497u, 296359069904557976u, 7465570360967084746u, 17591102039116459392u, 1507562u},
    {12202923644760736279u, 2916291703301845621u, 3131880542454443371u, 7449741813886929166u, 197211u},
    {16230218532849972251u, 3997867716152174704u, 4993019734488650764u, 16793057319132471236u, 1139099u},
    {1826405653714287293u, 17843282530955401994u, 12335434059086661663u, 1101876595089594835u, 2268562u},
    {5019446022234338116u, 6700065821388904227u, 17020645246512663939u, 4149130443893111634u, 1130304u},
    {10355248375590392454u, 3086640326123279851u, 17024184646430041852u, 11622123072869018340u, 3060997u},
    {5363077900773090026u, 16101442080056283657u, 4370762186902936361u, 2578481231218993549u, 2229077u},
    {3386220281590282362u, 18025561701886839931u, 7499191415655916223u, 8688030500069425817u, 439422u},
    {10412300906750193384u, 5807125939537379717u, 12168058433130489340u, 11681436148006713730u, 3102607u},
    {15797125873696796660u, 6313265569837818155u, 15077937738970172216u, 18359861894605431662u, 403905u},
    {68215392852173069u, 10477265269450223442u, 938794333914822706u, 17805676477893153743u, 2126670u},
    {13437207275351349845u, 15754495540441138616u, 523010629759113668u, 10271408508410679282u, 876755u},
    {15248321719065437839u, 3597828261253747716u, 6230671190300872014u, 10824812391060944126u, 1867982u},
    {4320700968337982685u, 10364882795003823938u, 13054816828403416798u, 8465196699150677018u, 1847783u},
    {12401695906825240178u, 1626632685299482191u, 10410315733161809529u, 7960420932742020915u, 1888409u},
    {805306626018238329u, 17215823704700381238u, 7372054211036686547u, 15238987347492705209u, 2161785u},
    {15776482942900397337u, 5472471084487482916u, 9830265663053993240u, 17910161231282499678u, 1391716u},
    {5313390217525982388u, 5037277939974136358u, 11424303515517625596u, 11771060474967701561u, 1194299u},
    {17807789705401022159u, 1929299145994280848u, 13892957692434102714u, 8020423877981548614u, 2790688u},
    {15558004334779882914u, 3174401794641086716u, 2982846315137791294u, 3222013253014825423u, 1002367u},
    {6386051414189166393u, 14717572689290135939u, 2573329932403645251u, 16303506663310658811u, 1449190u},
    {12713581079923598263u, 2458111064145147702u, 7693211869949031451u, 4998706841964713392u, 1586088u},
    {15093718486348895616u, 3528807744310474918u, 4947999685374842835u, 18115714267933000613u, 2358209u},
    {11332426486655939910u, 4195264554210025581u, 17336551818813049961u, 5880166413083195611u, 513391u},
    {18365993628880011204u, 16414182812188054173u, 9165919061031204795u, 3324119724011597289u, 894u},
    {555702668010015833u, 17771878867964458084u, 6470047789939746097u, 16494713321620u, 0u},
    {313217524572922128u, 2554579237670121667u, 13158461372853944558u, 16494u, 0u},
    {12049093344271314443u, 3657968359976427441u, 304273755213138u, 0u, 0u},
    {8647067153141124437u, 13931223481447062136u, 304273u, 0u, 0u},
    {15604420023057428336u, 5612860090763307u, 0u, 0u, 0u},
    {1674287511116950686u, 5612860u, 0u, 0u, 0u},
    {103538993615848906u, 0u, 0u, 0u, 0u},
    {103538994u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 379136u},
    {1500418613136240896u, 11410824137751307037u, 10357547517412061368u, 9230365861615905752u, 3146941u},
    {15809298207116368646u, 3226569749765384531u, 12689744145862814662u, 5534427971354952607u, 1494973u},
    {6975007677584765351u, 2731746272661017141u, 15919152305506937447u, 6008357695010552448u, 1212468u},
    {11348678779489186091u, 15600906262884203185u, 11793017079045306903u, 11479523544932461991u, 2181659u},
    {4883808579875406732u, 1011247998517725784u, 11095217311000957427u, 6453370386084214955u, 1395550u},
    {1149510632724450365u, 16786454226865816792u, 15530752049156759786u, 17319565929248140390u, 1882009u},
    {4079070816753441219u, 13839210987561932170u, 14303917747449282569u, 3781711845659236640u, 1998053u},
    {1749729056596131064u, 16454273942384132819u, 7272449710585464604u, 6017637881266438124u, 3780833u},
    {17177678088581823250u, 4749959803192160556u, 7958188303667288786u, 6843157904319299370u, 2281702u},
    {13070448720958949614u, 4688218207031747221u, 12186468892917602793u, 14021263223047648719u, 2870691u},
    {5727099937400306634u, 3638044605685119009u, 8960236162358805588u, 6105792815398911193u, 1335730u},
    {14391233021088549113u, 1486186953721418581u, 14369107409183867742u, 5284844240336108202u, 3269152u},
    {5953427616553963702u, 1505761345108496346u, 7759767420768103737u, 17210012596593748736u, 1519334u},
    {10137153978633687843u, 12528132378201955771u, 9014785117066190999u, 11341069046625183976u, 608079u},
    {10056722065032112122u, 14540631990657446346u, 1149041056538286551u, 9450761907999225893u, 1091629u},
    {3747281820686297216u, 10495855445186472506u, 2218190668012101533u, 4199477464437021680u, 2446910u},
    {9766024965426247705u, 10642616076785162519u, 7041643151205768077u, 14168425958174753559u, 3691435u},
    {8384831299265717308u, 960130553098172386u, 15575739300467361828u, 18442781450549783656u, 514808u},
    {14536284070489227853u, 8038913463030811471u, 7343895722542194327u, 3540318657724348581u, 3169113u},
    {4955147565738804529u, 11990563530151584755u, 17981612915669490925u, 7264219223784778155u, 237076u},
    {2795517941477749964u, 4618733811905496979u, 8184690701322446863u, 4111656147724130341u, 132747u},
    {12877107478049780044u, 13646487159391349391u, 10560751637884163630u, 16359522600656850341u, 106424u},
    {12920576797819208370u, 17466447767193287994u, 18041497248255616811u, 7784183348747040153u, 150685u},
    {13234267868247013347u, 18020650479003149334u, 9819148632726950773u, 17584832600669346656u, 134009u},
    {17541372390676420726u, 7470082319583538253u, 17927564160922959660u, 16936006646224471303u, 906790u},
    {5463184440444004004u, 3291296640661166621u, 9856905981785408608u, 17382607503135238306u, 256761u},
    {3925477124037120902u, 1742573895823558279u, 5860790369124476508u, 15641234328068079353u, 403445u},
    {3246440556549493374u, 2448378715017556413u, 2209854884224846679u, 10023447833576035182u, 3663210u},
    {5745069269913380418u, 6890496267433386982u, 2790670337304071222u, 17217281688408550168u, 425595u},
    {5660926902736744815u, 3323347525868257588u, 526870151639811553u, 17157558240288180873u, 884257u},
    {10024635812360818726u, 2484785893231733941u, 5008109961745929956u, 1673636342604286955u, 3014827u},
    {16369793975031000370u, 15369040374171352439u, 17968925205866319587u, 9278985780623921696u, 2470836u},
    {5897524871297612302u, 768814910924089086u, 5544956108785444278u, 11574793934687563754u, 2258317u},
    {4978115653486453314u, 9774012771566578505u, 3031796660650761671u, 1338695299993804316u, 2235334u},
    {5142955960523897460u, 4484820962357936890u, 15602331034356274678u, 10561643365093435422u, 2928801u},
    {15746669540827046178u, 9381292514425799838u, 10623993448113185736u, 17780194986381740229u, 1553456u},
    {13133735255693701584u, 3466839327165682766u, 11011325022666076760u, 9252028259896739339u, 3730657u},
    {11924845736658475185u, 4244691295174732674u, 11064929896272546837u, 501164048385388930u, 3378206u},
    {9549841086550095440u, 16463454434593240601u, 16821029319824989902u, 4313714950249182321u, 2170270u},
    {12335218402758517278u, 11912607727247837677u, 15400054770191515219u, 10488385555074115298u, 61532u},
    {255526912235157505u, 4520326298258916158u, 3765921449259374179u, 10305371022968423899u, 1465958u},
    {904272934658919236u, 9176513824993249914u, 15427233931600193970u, 15879712850698324049u, 1255169u},
    {5155315293426184215u, 4885126136398706481u, 16429171171914794036u, 2905457558709084234u, 3836545u},
    {1033712765046491634u, 15681128886064624823u, 7631251170475921898u, 7636819140630160850u, 2237498u},
    {9385404530036394459u, 9771841457127464276u, 17558673881488041395u, 10777856072259518578u, 2259243u},
    {5676725251404127146u, 4509329675466977560u, 14408848954087496803u, 16038461564619177652u, 2879024u},
    {8336748178094582940u, 16123955502517452197u, 13851299247256293208u, 8700019919499881452u, 2132579u},
    {17879123396884623472u, 17523386117117966745u, 6928211846133371483u, 13442051638784583457u, 147086u},
    {11588940474616668121u, 1564380040957324194u, 16483538883289334638u, 14198059296712680673u, 373829u},
    {5622343920036974006u, 4221301817910989657u, 12612746132506313126u, 14562529937749833136u, 1412784u},
    {1792465570918914845u, 13634254292895157277u, 16972703136619840794u, 9537663692448449164u, 3332256u},
    {17778539197864506267u, 15927187320788329926u, 1442071652390777014u, 11014223576922793060u, 1515959u},
    {16828728038284273739u, 7710522806003747872u, 1494791398405139301u, 460310082941027851u, 1578834u},
    {7753399127558133913u, 2750756735270828239u, 2898418746400981134u, 17971465262637237293u, 2627767u},
    {7530931661655028915u, 2540031327062477012u, 17682288220464515512u, 9415960988236436469u, 2449877u},
    {13120192496529273543u, 12949435925375455642u, 7762163047393904986u, 189307451522884195u, 1777512u},
    {10871509127493959054u, 342954094241844803u, 644595414168567177u, 14948711274992337816u, 3266300u},
    {593574379501179252u, 3837118911904276584u, 8036851928384574848u, 8346875929478381423u, 1054307u},
    {8294687530488038035u, 15756201746947345950u, 13170819124976887830u, 10611914863326403017u, 1659431u},
    {1410514761732378332u, 1128107661211369435u, 5056132899745801069u, 1111475020145813818u, 8726u},
    {9685950764565255940u, 6566967344200086156u, 12787560325301998229u, 7422093153306839617u, 3706790u},
    {11215443539119179420u, 17342808660873914720u, 2610440400959573336u, 5544755360769602118u, 3661725u},
    {8241914948089886320u, 10278850920631325878u, 12187758610128512367u, 15127584063414998092u, 1896683u},
    {15270710416471942352u, 10201593422182734437u, 16651651206182553071u, 12500951409579072644u, 3233658u},
    {10990762072758948218u, 11705046155706961581u, 15468774997568993583u, 1428744760769485674u, 878343u},
    {3201144325287367487u, 3679021877945892029u, 8569212913005387885u, 7870480320092824053u, 959093u},
    {8086659412765480635u, 833367472339097942u, 1491757598661686068u, 3044111100577339947u, 2123150u},
    {9595241102421478642u, 3499288690969915017u, 1675893101608463940u, 14522741609347722671u, 2857745u},
    {5603024255593253072u, 3388242540939061708u, 17166329577766864883u, 1998271144189718983u, 586054u},
    {9359587744425483147u, 2527684202468410140u, 13880847447585226603u, 16007596666569646713u, 1616243u},
    {6994349469677964901u, 13498305716534787966u, 7418273306547148639u, 15522197155144027453u, 2353347u},
    {13333363254975919667u, 12857489819152035479u, 5734838267100076080u, 7249171009140622907u, 978166u},
    {16857226648566244641u, 6190976133678481535u, 7501168575943300641u, 1531253459909261842u, 869511u},
    {13736242535038598961u, 11305185414463043639u, 15577198419936373604u, 9023238903158520725u, 2756477u},
    {5966427737423991138u, 13636123139621148388u, 16018000699146378397u, 13381502931803973746u, 738389u},
    {12971504359033041149u, 13485239861922330280u, 16826388915588212573u, 9020820141032337253u, 918409u},
    {14950552604874484264u, 488044137937567940u, 11481921245098449906u, 3980109336884848136u, 3430650u},
    {7323808471999334943u, 10023298159988174986u, 2513895287813735028u, 7917562076670726034u, 3833603u},
    {18433278437474898032u, 16123596921773371841u, 16131280757933920093u, 9798492696459038594u, 2883099u},
    {13452651479703988811u, 14638785311688200190u, 250443675894036234u, 13527953884283184663u, 3500371u},
    {9331065581055781400u, 4695652254782277679u, 3372695677125126504u, 5396832420334655925u, 2124181u},
    {17360657327375364698u, 12759038079935212317u, 7302741706840235421u, 8037577166880069745u, 2325142u},
    {5501420556231368920u, 5883037348293687136u, 2648938012486823604u, 6528074770860124581u, 2771368u},
    {15971059388553440355u, 10018211032982985018u, 9279731804823052328u, 15543505440912649303u, 2460713u},
    {10603503616821576764u, 9675392982116549359u, 14726248143793099330u, 18131848262013267428u, 3623039u},
    {2140426472468969666u, 15421436771483341171u, 3514998542411777101u, 11884278713554098346u, 1413634u},
    {12557846578657992982u, 1335458342977368895u, 15554864426391329353u, 1611344025330587633u, 788326u},
    {1522392959083756577u, 12550370296947391108u, 5862789393137470635u, 16587788678303420461u, 3603925u},
    {3281773244831007673u, 720352950240542582u, 2049677894725082040u, 12100098903057597686u, 221511u},
    {12276601376885787385u, 3543114686788148532u, 10064718111758034696u, 6849557602429764299u, 440657u},
    {9958277125159208946u, 6791325115095078581u, 5833155836991042496u, 296359069904557976u, 1842490u},
    {1875595089553257196u, 10202841617632956189u, 12202923644760736278u, 2916291703301845621u, 1881093u},
    {7211590450515176u, 2143718680929886684u, 16230218532849972250u, 3997867716152174704u, 2442534u},
    {5915320594963634186u, 10846010698693230588u, 1826405653714287292u, 17843282530955401994u, 3836295u},
    {10081109560366182378u, 4689256727925659817u, 5019446022234338115u, 6700065821388904227u, 3264607u},
    {11518147766021860612u, 8635967555404696045u, 10355248375590392453u, 3086640326123279851u, 1767174u},
    {11615897285666414616u, 7364438544758483676u, 5363077900773090025u, 16101442080056283657u, 605157u},
    {2292807444662463646u, 1695409430669736265u, 3386220281590282361u, 18025561701886839931u, 2304927u},
    {2801502763569196022u, 1684272018798764272u, 10412300906750193383u, 5807125939537379717u, 2399062u},
    {7704517012623009403u, 4892451496998831401u, 15797125873696796659u, 6313265569837818155u, 1567438u},
    {17637789292115556817u, 5891057505135003549u, 68215392852173068u, 10477265269450223442u, 2490414u},
    {17517248315029411083u, 4599476567137914825u, 13437207275351349844u, 15754495540441138616u, 3632410u},
    {3932974704539479581u, 3487214193935136788u, 15248321719065437838u, 3597828261253747716u, 3287672u},
    {1520668493482642113u, 5598906438145884201u, 4320700968337982684u, 10364882795003823938u, 2242434u},
    {11587583073042293374u, 3938202702805811801u, 12401695906825240177u, 1626632685299482191u, 3584173u},
    {3107592696332038624u, 3161711451298202156u, 805306626018238328u, 17215823704700381238u, 3694501u},
    {17184758559057731048u, 4604720383452914038u, 15776482942900397336u, 5472471084487482916u, 3540134u},
    {3797497923466667326u, 3969088085414237649u, 5313390217525982387u, 5037277939974136358u, 3025016u},
    {1511685316364894328u, 9131511147599789879u, 17807789705401022158u, 1929299145994280848u, 209666u},
    {17641444655834883258u, 12551279452525116687u, 15558004334779882913u, 3174401794641086716u, 966214u},
    {1825643564787596253u, 14343515875786572297u, 6386051414189166392u, 14717572689290135939u, 441967u},
    {11460692495656750719u, 12522899990529946661u, 12713581079923598262u, 2458111064145147702u, 3797051u},
    {10728291759239414698u, 9474265293186995724u, 15093718486348895615u, 3528807744310474918u, 863247u},
    {10842138108507433526u, 6973251762574844171u, 11332426486655939909u, 4195264554210025581u, 3095883u},
    {4979702613376983710u, 15548104860291444666u, 18365993628880011203u, 16414182812188054173u, 2477983u},
    {16509344714155068425u, 2879131287572681657u, 555702668010015832u, 17771878867964458084u, 1765267u},
    {14588786592853778961u, 7540629202374030554u, 313217524572922127u, 2554579237670121667u, 2986362u},
    {17217808900919515547u, 14933544535386952236u, 12049093344271314442u, 3657968359976427441u, 1306888u},
    {14218422956419311090u, 5034448993657553859u, 8647067153141124436u, 13931223481447062136u, 304273u},
    {735601916003639096u, 3628247669381011169u, 15604420023057428335u, 5612860090763307u, 0u},
    {9339503902288041755u, 3925143346814914429u, 1674287511116950685u, 5612860u, 0u},
    {12947687568218366101u, 6132531758727718u, 103538993615848905u, 0u, 0u},
    {9468864972390716684u, 11360407138615399182u, 103538993u, 0u, 0u},
    {7702656960298443183u, 1909957316881011887u, 0u, 0u, 0u},
    {16251800813087576120u, 1909957316u, 0u, 0u, 0u},
    {16785749742503450566u, 1u, 0u, 0u, 0u},
    {35232493817u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1394516u},
    {14493207188449981861u, 3076461203129156288u, 1500418613136240895u, 11410824137751307037u, 3037696u},
    {15211851031348188071u, 4036296342501577416u, 15809298207116368645u, 3226569749765384531u, 3557012u},
    {6597876925567922063u, 5835631420910800696u, 6975007677584765350u, 2731746272661017141u, 1976823u},
    {3676122505838937501u, 4797988805354984499u, 11348678779489186090u, 15600906262884203185u, 132363u},
    {7717131690305226906u, 945092706144424867u, 4883808579875406731u, 1011247998517725784u, 3745507u},
    {7594375843659375918u, 17402692800153869316u, 1149510632724450364u, 16786454226865816792u, 225130u},
    {17371357414878862408u, 1716940240583151350u, 4079070816753441218u, 13839210987561932170u, 1362977u},
    {2738429320822780893u, 11160140893393462461u, 1749729056596131063u, 16454273942384132819u, 3589586u},
    {12591485360772537768u, 3019986267499962431u, 17177678088581823249u, 4749959803192160556u, 242568u},
    {5330542347468857347u, 2574072561463704603u, 13070448720958949613u, 4688218207031747221u, 1906293u},
    {10899212901122807752u, 813526448456371811u, 5727099937400306633u, 3638044605685119009u, 2441356u},
    {9222169670528520247u, 663151466699020932u, 14391233021088549112u, 1486186953721418581u, 3502486u},
    {11889098414595766366u, 16956350897705641854u, 5953427616553963701u, 1505761345108496346u, 3370167u},
    {2029991849070577482u, 1593650928058081670u, 10137153978633687842u, 12528132378201955771u, 3092989u},
    {5237640530808698539u, 16423980410319565828u, 10056722065032112121u, 14540631990657446346u, 2575213u},
    {7919002547279485060u, 7340833582320943725u, 3747281820686297215u, 10495855445186472506u, 2718623u},
    {3165168153757486287u, 18286478750091252540u, 9766024965426247704u, 10642616076785162519u, 1267531u},
    {6713501474310132129u, 8123273613846214126u, 8384831299265717307u, 960130553098172386u, 2196622u},
    {14792878795392031955u, 10763577684090367426u, 14536284070489227852u, 8038913463030811471u, 1572251u},
    {52332136457907634u, 13992269409396262922u, 4955147565738804528u, 11990563530151584755u, 382061u},
    {9671482299300532186u, 4558364316722050252u, 2795517941477749963u, 4618733811905496979u, 1496301u},
    {6172826231424398599u, 14391085040138854193u, 12877107478049780043u, 13646487159391349391u, 1545530u},
    {5073442284368909092u, 13024094540625574412u, 12920576797819208369u, 17466447767193287994u, 338919u},
    {1189951577520830110u, 14273403196236126942u, 13234267868247013346u, 18020650479003149334u, 2610223u},
    {16168574686677747574u, 8990053536906716231u, 17541372390676420725u, 7470082319583538253u, 2640298u},
    {13382507917566445227u, 4819054381499028490u, 5463184440444004003u, 3291296640661166621u, 715120u},
    {14339484912549557825u, 3619772478621647366u, 3925477124037120901u, 1742573895823558279u, 3820626u},
    {7246074814198858886u, 8006647324847180261u, 3246440556549493373u, 2448378715017556413u, 2440801u},
    {6355974229472726407u, 1011306540889156800u, 5745069269913380417u, 6890496267433386982u, 471530u},
    {2098821552510387240u, 1709847321968215253u, 5660926902736744814u, 3323347525868257588u, 1888013u},
    {18047896931821690634u, 11475423419722176343u, 10024635812360818725u, 2484785893231733941u, 1126098u},
    {4655475784554428034u, 1173140420412397150u, 16369793975031000369u, 15369040374171352439u, 2615039u},
    {10243985786881430854u, 17463137431155681855u, 5897524871297612301u, 768814910924089086u, 2506544u},
    {10954984718281728355u, 7611926122610597073u, 4978115653486453313u, 9774012771566578505u, 935131u},
    {5563603269719574197u, 11937406986173426349u, 5142955960523897459u, 4484820962357936890u, 748386u},
    {3991281235040991982u, 17489758639268993476u, 15746669540827046177u, 9381292514425799838u, 437736u},
    {13236518251414245908u, 14432511238277971382u, 13133735255693701583u, 3466839327165682766u, 3542676u},
    {7908054670925033194u, 6280151514581838185u, 11924845736658475184u, 4244691295174732674u, 1860653u},
    {16836896006881954843u, 15004897739241947885u, 9549841086550095439u, 16463454434593240601u, 1252508u},
    {8660663957837753231u, 12189392727346739266u, 12335218402758517277u, 11912607727247837677u, 2859879u},
    {7606260251706115933u, 14575273020334261420u, 255526912235157504u, 4520326298258916158u, 1366061u},
    {13877791568848650627u, 4839755083476091874u, 904272934658919235u, 9176513824993249914u, 3104468u},
    {4996480428209765998u, 2063557334623571239u, 5155315293426184214u, 4885126136398706481u, 2419450u},
    {16469891352902574388u, 9899015584550311513u, 1033712765046491633u, 15681128886064624823u, 2388836u},
    {16508762085233689048u, 15155122142085743030u, 9385404530036394458u, 9771841457127464276u, 2263751u},
    {4240277629549115244u, 9337666787018517172u, 5676725251404127145u, 4509329675466977560u, 2987629u},
    {15469890349091292782u, 10365998957887330407u, 8336748178094582939u, 16123955502517452197u, 725914u},
    {3006184860615620170u, 2389850875597171736u, 17879123396884623471u, 17523386117117966745u, 2773961u},
    {6646041804860569300u, 965329316940724453u, 11588940474616668120u, 1564380040957324194u, 2274730u},
    {8837667540583866481u, 2777572446790937072u, 5622343920036974005u, 4221301817910989657u, 833156u},
    {4057721448294402229u, 5616016290626698053u, 1792465570918914844u, 13634254292895157277u, 133304u},
    {17958636828556724752u, 891994159974649029u, 17778539197864506266u, 15927187320788329926u, 19528u},
    {5270976893884796987u, 7974148383365918592u, 16828728038284273738u, 7710522806003747872u, 681321u},
    {2158572473941518808u, 9515720951742996772u, 7753399127558133912u, 2750756735270828239u, 976624u},
    {16189741625494675380u, 17414144787253129409u, 7530931661655028914u, 2540031327062477012u, 2771578u},
    {4554017694166690214u, 8361500953367309637u, 13120192496529273542u, 12949435925375455642u, 2966578u},
    {30956389674569305u, 4637669778449722805u, 10871509127493959053u, 342954094241844803u, 979383u},
    {6013431761612459859u, 9670195514359520070u, 593574379501179251u, 3837118911904276584u, 2582908u},
    {12336583993239140598u, 9310681279435833799u, 8294687530488038034u, 15756201746947345950u, 2561088u},
    {5146471732835374103u, 6696488380437856261u, 1410514761732378331u, 1128107661211369435u, 527263u},
    {9419279507776815142u, 7130777435666604795u, 9685950764565255939u, 6566967344200086156u, 2655541u},
    {5058320274013033784u, 16830103361534415539u, 11215443539119179419u, 17342808660873914720u, 2530124u},
    {4746680532548967616u, 3380688372764019359u, 8241914948089886319u, 10278850920631325878u, 2248237u},
    {14487769960040704283u, 8607402770897988449u, 15270710416471942351u, 10201593422182734437u, 1719323u},
    {8003624357083354517u, 3123159789995197369u, 10990762072758948217u, 11705046155706961581u, 221425u},
    {5938648447749380420u, 4225372702292187851u, 3201144325287367486u, 3679021877945892029u, 2208191u},
    {4658920517433504072u, 11973273300884035663u, 8086659412765480634u, 833367472339097942u, 2196820u},
    {2325294718116715644u, 14473773371074161412u, 9595241102421478641u, 3499288690969915017u, 83246u},
    {6854264740573968950u, 11941726482627573426u, 5603024255593253071u, 3388242540939061708u, 307285u},
    {2294043925156091853u, 16336992898973424400u, 9359587744425483146u, 2527684202468410140u, 1275869u},
    {7141819301778545478u, 7294297335323166548u, 6994349469677964900u, 13498305716534787966u, 1693419u},
    {9507726168922610119u, 852719567780476542u, 13333363254975919666u, 12857489819152035479u, 3582238u},
    {17907093255310619496u, 1096147186460659560u, 16857226648566244640u, 6190976133678481535u, 3480329u},
    {17123845875399340476u, 14021448090569744718u, 13736242535038598960u, 11305185414463043639u, 934466u},
    {4598146088507642822u, 15790635777785234685u, 5966427737423991137u, 13636123139621148388u, 567567u},
    {2428311630246728481u, 6947665433884704707u, 12971504359033041148u, 13485239861922330280u, 3019425u},
    {4709312739087916649u, 10483403239707709422u, 14950552604874484263u, 488044137937567940u, 395332u},
    {451032895446799227u, 7057700220083661497u, 7323808471999334942u, 10023298159988174986u, 2968190u},
    {13201331692295951031u, 14167043340671163636u, 18433278437474898031u, 16123596921773371841u, 601391u},
    {13862369653676243113u, 8874329824762067243u, 13452651479703988810u, 14638785311688200190u, 645568u},
    {17415677550011606713u, 7069213993595866856u, 9331065581055781399u, 4695652254782277679u, 262590u},
    {16995149582333519764u, 18394940144736799296u, 17360657327375364697u, 12759038079935212317u, 2513843u},
    {14687713216733187108u, 3634089342314532439u, 5501420556231368919u, 5883037348293687136u, 119558u},
    {6105974258240070195u, 70782798529315432u, 15971059388553440354u, 10018211032982985018u, 1066604u},
    {10450428945964499475u, 18279706334329188547u, 10603503616821576763u, 9675392982116549359u, 60262u},
    {14264553810914956960u, 14804478359439458338u, 2140426472468969665u, 15421436771483341171u, 2082841u},
    {12703525380225896035u, 13808835968045631722u, 12557846578657992981u, 1335458342977368895u, 669437u},
    {2166748853110786464u, 13020589547988856083u, 1522392959083756576u, 12550370296947391108u, 3894161u},
    {1697403038891068660u, 15511784463189501283u, 3281773244831007672u, 720352950240542582u, 666382u},
    {12661492782633087342u, 16461733788913370363u, 12276601376885787384u, 3543114686788148532u, 970972u},
    {564846897810293548u, 4210844336699469313u, 9958277125159208945u, 6791325115095078581u, 2315902u},
    {9872154375115412988u, 7417789106738698800u, 1875595089553257195u, 10202841617632956189u, 2929972u},
    {16037525815726848892u, 6854217060833032798u, 7211590450515175u, 2143718680929886684u, 2025918u},
    {271093920347083598u, 3617648670118115718u, 5915320594963634185u, 10846010698693230588u, 298866u},
    {7380555991646388215u, 4144490665999232062u, 10081109560366182377u, 4689256727925659817u, 3312989u},
    {17955562442172002640u, 9005675244230345003u, 11518147766021860611u, 8635967555404696045u, 789513u},
    {8099846303881918910u, 12390313846141621964u, 11615897285666414615u, 7364438544758483676u, 2064579u},
    {15373384514228795156u, 16997790247169051655u, 2292807444662463645u, 1695409430669736265u, 1460819u},
    {7119071509489206323u, 12506161067123599585u, 2801502763569196021u, 1684272018798764272u, 3501577u},
    {11098604313006385669u, 2496318290300596630u, 7704517012623009402u, 4892451496998831401u, 2948617u},
    {8217746872437900230u, 12412071977181390237u, 17637789292115556816u, 5891057505135003549u, 3244374u},
    {7358578530256879533u, 13809058193579081319u, 17517248315029411082u, 4599476567137914825u, 1542260u},
    {13220965786406254606u, 14363535925473363203u, 3932974704539479580u, 3487214193935136788u, 2736076u},
    {11740317882921768801u, 10581340995907623844u, 1520668493482642112u, 5598906438145884201u, 2552896u},
    {13256389387027387664u, 78168162380661515u, 11587583073042293373u, 3938202702805811801u, 3427971u},
    {12058794426135873864u, 4182791194458136927u, 3107592696332038623u, 3161711451298202156u, 3528642u},
    {1469616381067963628u, 4151356212667215955u, 17184758559057731047u, 4604720383452914038u, 320946u},
    {13100450618939577637u, 436705105852607680u, 3797497923466667325u, 3969088085414237649u, 2832711u},
    {17878637495962680329u, 14100604931851741768u, 1511685316364894327u, 9131511147599789879u, 718722u},
    {12213901683139363966u, 13721943058997895368u, 17641444655834883257u, 12551279452525116687u, 219803u},
    {16635909123751073888u, 15992637530994416825u, 1825643564787596252u, 14343515875786572297u, 3086518u},
    {10310450063395482288u, 13125382533329605741u, 11460692495656750718u, 12522899990529946661u, 1882200u},
    {15083268901490098129u, 17811956463764383987u, 10728291759239414697u, 9474265293186995724u, 3020735u},
    {11577122048721157537u, 11459944606851339137u, 10842138108507433525u, 6973251762574844171u, 3020703u},
    {5777048037261410725u, 11777091871300057233u, 4979702613376983709u, 15548104860291444666u, 3734269u},
    {16152111101306266775u, 6224846955708328717u, 16509344714155068424u, 2879131287572681657u, 2528328u},
    {329871721887677387u, 15995203225790300763u, 14588786592853778960u, 7540629202374030554u, 955321u},
    {17270697048532243341u, 7640855393556954535u, 17217808900919515546u, 14933544535386952236u, 3386776u},
    {4173682541468461364u, 7567495967541908937u, 14218422956419311089u, 5034448993657553859u, 1375200u},
    {16675241724593420095u, 1366690369940673143u, 735601916003639095u, 3628247669381011169u, 1844947u},
    {597476019250454009u, 1895421973533486793u, 9339503902288041754u, 3925143346814914429u, 332445u},
    {4000556474356054778u, 6349349721624043360u, 12947687568218366100u, 6132531758727718u, 2567655u},
    {16989031595565888473u, 11350541143698465776u, 9468864972390716683u, 11360407138615399182u, 1976493u},
    {11843883755537511398u, 538619168201389078u, 7702656960298443182u, 1909957316881011887u, 0u},
    {13636730886590099165u, 8015157782484665073u, 16251800813087576119u, 1909957316u, 0u},
    {15981068766043842151u, 2700580743144745844u, 16785749742503450565u, 1u, 0u},
    {16322054379173739289u, 3929196722749539997u, 35232493816u, 0u, 0u},
    {11111334567868588090u, 4288753926401315653u, 35u, 0u, 0u},
    {4346462672403414239u, 649924796506u, 0u, 0u, 0u},
    {17059484470789262466u, 649u, 0u, 0u, 0u},
    {11988996388309u, 0u, 0u, 0u, 0u},
    {11989u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2712796u},
    {8231254784835174915u, 17800941567711196154u, 14493207188449981860u, 3076461203129156288u, 58063u},
    {11495968302988237083u, 18054068176626461663u, 15211851031348188070u, 4036296342501577416u, 3850213u},
    {7559610892195970626u, 2854309996889103981u, 6597876925567922062u, 5835631420910800696u, 2286994u},
    {6074589809295185830u, 4782319547661643823u, 3676122505838937500u, 4797988805354984499u, 452328u},
    {9095835958323476574u, 5733385528028085473u, 7717131690305226905u, 945092706144424867u, 1995617u},
    {11071129586785814522u, 16912903378692788177u, 7594375843659375917u, 17402692800153869316u, 3231766u},
    {619044721580574175u, 2661899663713865440u, 17371357414878862407u, 1716940240583151350u, 3429950u},
    {34420739616871207u, 9729757429560099631u, 2738429320822780892u, 11160140893393462461u, 3557533u},
    {16698359585955700725u, 8602932706882883986u, 12591485360772537767u, 3019986267499962431u, 2822003u},
    {8091215716708669934u, 12199618267693665502u, 5330542347468857346u, 2574072561463704603u, 1132607u},
    {18328103441462334730u, 10084679786391993943u, 10899212901122807751u, 813526448456371811u, 793263u},
    {14396872535394278953u, 15475439486041204171u, 9222169670528520246u, 663151466699020932u, 1236874u},
    {13450366034757314738u, 4120539665159391354u, 11889098414595766365u, 16956350897705641854u, 454489u},
    {203961272348283005u, 1385874611395493301u, 2029991849070577481u, 1593650928058081670u, 3627012u},
    {1066422305325710505u, 894771737339918019u, 5237640530808698538u, 16423980410319565828u, 3416135u},
    {10373673274766095017u, 9716253285879627816u, 7919002547279485059u, 7340833582320943725u, 3030749u},
    {6314059743630226835u, 1851226755922422301u, 3165168153757486286u, 18286478750091252540u, 2863544u},
    {1197602126058345647u, 5241660592672428820u, 6713501474310132128u, 8123273613846214126u, 1463465u},
    {9332572409537137085u, 8742184738437002825u, 14792878795392031954u, 10763577684090367426u, 709944u},
    {870881293249778283u, 12138157461268364271u, 52332136457907633u, 13992269409396262922u, 1015674u},
    {6674318576908182146u, 9707616217953053475u, 9671482299300532185u, 4558364316722050252u, 2798533u},
    {6498472781219694284u, 10162928640204634893u, 6172826231424398598u, 14391085040138854193u, 2912579u},
    {10256814964272114707u, 188701163132381235u, 5073442284368909091u, 13024094540625574412u, 325237u},
    {10295912141118409483u, 2233420262065528098u, 1189951577520830109u, 14273403196236126942u, 2976778u},
    {13136127202653493955u, 14012832078718789905u, 16168574686677747573u, 8990053536906716231u, 3428961u},
    {13848731994164089226u, 14012222167352148589u, 13382507917566445226u, 4819054381499028490u, 915759u},
    {4048014573659695906u, 11634733572128803093u, 14339484912549557824u, 3619772478621647366u, 447471u},
    {16730414534039667794u, 469083299702761887u, 7246074814198858885u, 8006647324847180261u, 135537u},
    {8893640469317607955u, 9423012533804135162u, 6355974229472726406u, 1011306540889156800u, 2847259u},
    {3714438646078572776u, 14242995081641852120u, 2098821552510387239u, 1709847321968215253u, 990200u},
    {13987020713362343158u, 16530446267558926501u, 18047896931821690633u, 11475423419722176343u, 1096069u},
    {9524619574863306222u, 14696103846937619098u, 4655475784554428033u, 1173140420412397150u, 1366077u},
    {620729590297524572u, 14239051818668026911u, 10243985786881430853u, 17463137431155681855u, 2487091u},
    {401987296957591555u, 8796754735856724964u, 10954984718281728354u, 7611926122610597073u, 2596879u},
    {73139495979838299u, 6482077889058483678u, 5563603269719574196u, 11937406986173426349u, 2809215u},
    {16258502710494222147u, 1012195358834290911u, 3991281235040991981u, 17489758639268993476u, 1138001u},
    {13991932116175800170u, 652805426016509103u, 13236518251414245907u, 14432511238277971382u, 603945u},
    {13526475898447950327u, 3355336184549483143u, 7908054670925033193u, 6280151514581838185u, 917136u},
    {14220710256759397703u, 13359135179035541921u, 16836896006881954842u, 15004897739241947885u, 632053u},
    {7509533777038230292u, 495962310471382714u, 8660663957837753230u, 12189392727346739266u, 1064633u},
    {10723846034626259757u, 11542916070577274660u, 7606260251706115932u, 14575273020334261420u, 644898u},
    {12020874281914489103u, 8579989091139020456u, 13877791568848650626u, 4839755083476091874u, 2490667u},
    {1534441652352712485u, 6129856052646213034u, 4996480428209765997u, 2063557334623571239u, 1470460u},
    {1187607472425406910u, 13852176289424284828u, 16469891352902574387u, 9899015584550311513u, 1248317u},
    {17901332513283722044u, 12456144525203041401u, 16508762085233689047u, 15155122142085743030u, 2289680u},
    {10131990654681641067u, 2536420073020786904u, 4240277629549115243u, 9337666787018517172u, 3348179u},
    {1446379845734991252u, 6087495994976189603u, 15469890349091292781u, 10365998957887330407u, 647825u},
    {9136072655951628538u, 16428000532196138491u, 3006184860615620169u, 2389850875597171736u, 1549357u},
    {10033130301674234770u, 13296031979685050276u, 6646041804860569299u, 965329316940724453u, 2135004u},
    {6925509320521427795u, 4221374528261036085u, 8837667540583866480u, 2777572446790937072u, 3663603u},
    {16751283264700773862u, 17904609026999861389u, 4057721448294402228u, 5616016290626698053u, 1480100u},
    {17268487919776875576u, 5914606797652355356u, 17958636828556724751u, 891994159974649029u, 2591950u},
    {13825214816125943921u, 14755270476666117855u, 5270976893884796986u, 7974148383365918592u, 223266u},
    {14911896328270347859u, 12207630119072329025u, 2158572473941518807u, 9515720951742996772u, 2616430u},
    {12386480434161885467u, 12852297428339492117u, 16189741625494675379u, 17414144787253129409u, 152874u},
    {16106353811666910040u, 4904525640032862660u, 4554017694166690213u, 8361500953367309637u, 1408582u},
    {5996516537647379318u, 9251577058107771131u, 30956389674569304u, 4637669778449722805u, 784849u},
    {1887713969258625278u, 13049269711013917467u, 6013431761612459858u, 9670195514359520070u, 826793u},
    {8295361409789934308u, 2208694831018762648u, 12336583993239140597u, 9310681279435833799u, 3642362u},
    {15421830312941378119u, 15537855844519534707u, 5146471732835374102u, 6696488380437856261u, 3747719u},
    {18000218125352728233u, 1352344511065605765u, 9419279507776815141u, 7130777435666604795u, 2205481u},
    {6923766203407270434u, 1339311042088535317u, 5058320274013033783u, 16830103361534415539u, 3579983u},
    {14461402444493246552u, 5144429003186354850u, 4746680532548967615u, 3380688372764019359u, 1764489u},
    {6570684837632835258u, 857547502829811695u, 14487769960040704282u, 8607402770897988449u, 1338081u},
    {15290427346331105212u, 6110369642354067623u, 8003624357083354516u, 3123159789995197369u, 2495413u},
    {12155865548917372879u, 6461970972225243320u, 5938648447749380419u, 4225372702292187851u, 634946u},
    {14627070795130179936u, 7252134727770255195u, 4658920517433504071u, 11973273300884035663u, 3374826u},
    {13628368851157465149u, 13133936704091195752u, 2325294718116715643u, 14473773371074161412u, 2831039u},
    {15503375257256863056u, 8085949850240733701u, 6854264740573968949u, 11941726482627573426u, 2817659u},
    {8188583589033060427u, 1361865366292231261u, 2294043925156091852u, 16336992898973424400u, 893400u},
    {10597228229619409786u, 6358826071775568381u, 7141819301778545477u, 7294297335323166548u, 3257270u},
    {5547618870474043202u, 5135060091358273536u, 9507726168922610118u, 852719567780476542u, 828508u},
    {8065443058436274803u, 16339934760464889134u, 17907093255310619495u, 1096147186460659560u, 2291724u},
    {8176244794291896867u, 3048483098072727993u, 17123845875399340475u, 14021448090569744718u, 543330u},
    {12876909845014501173u, 1735713975734845849u, 4598146088507642821u, 15790635777785234685u, 1633697u},
    {118104498598840080u, 17333973993796927784u, 2428311630246728480u, 6947665433884704707u, 1900178u},
    {4323369754353373467u, 5338933425602339054u, 4709312739087916648u, 10483403239707709422u, 3692445u},
    {13537168488641481485u, 12471705691928289925u, 451032895446799226u, 7057700220083661497u, 2371958u},
    {6002923624250571460u, 2746336992385670685u, 13201331692295951030u, 14167043340671163636u, 609633u},
    {3784835605984036312u, 16136150182092987056u, 13862369653676243112u, 8874329824762067243u, 410358u},
    {18066162364533913748u, 3029306766620374576u, 17415677550011606712u, 7069213993595866856u, 1097953u},
    {8190822786518722915u, 12543704364756019774u, 16995149582333519763u, 18394940144736799296u, 1691877u},
    {1761434405266367282u, 14232124436926650986u, 14687713216733187107u, 3634089342314532439u, 3837143u},
    {6817606890571487100u, 5920828198226402271u, 6105974258240070194u, 70782798529315432u, 2663616u},
    {2481395200697804754u, 13189296617656944526u, 10450428945964499474u, 18279706334329188547u, 1771129u},
    {15590607500757732293u, 828171200064505364u, 14264553810914956959u, 14804478359439458338u, 2484747u},
    {7277582702878104779u, 16937667574304206711u, 12703525380225896034u, 13808835968045631722u, 2722573u},
    {13892359091442190027u, 1480444827632289093u, 2166748853110786463u, 13020589547988856083u, 1051770u},
    {7551655588636621580u, 10292244845833209592u, 1697403038891068659u, 15511784463189501283u, 1767376u},
    {10791188124412235279u, 17857397229498474650u, 12661492782633087341u, 16461733788913370363u, 1707828u},
    {16450734839251848410u, 13663900271846296119u, 564846897810293547u, 4210844336699469313u, 3681653u},
    {7907471480325359454u, 3753361299291103805u, 9872154375115412987u, 7417789106738698800u, 474101u},
    {300683651856136027u, 3913935031453865841u, 16037525815726848891u, 6854217060833032798u, 800627u},
    {4693651857070078883u, 10369530434042557756u, 271093920347083597u, 3617648670118115718u, 2017039u},
    {13641383111401768668u, 7304590963036971413u, 7380555991646388214u, 4144490665999232062u, 3823633u},
    {13336971573890979413u, 12389572193095054190u, 17955562442172002639u, 9005675244230345003u, 3711509u},
    {11341856017747815551u, 387835261820989368u, 8099846303881918909u, 12390313846141621964u, 3483305u},
    {18301331648145312212u, 1936074575102879467u, 15373384514228795155u, 16997790247169051655u, 2179099u},
    {2029516907163144915u, 683964301970637040u, 7119071509489206322u, 12506161067123599585u, 2513185u},
    {13826441804515779773u, 4997832487569565345u, 11098604313006385668u, 2496318290300596630u, 984770u},
    {12613736646218997956u, 3367727401844399048u, 8217746872437900229u, 12412071977181390237u, 2496794u},
    {11800928367764271208u, 18113693370148514070u, 7358578530256879532u, 13809058193579081319u, 1305092u},
    {16828866456674192025u, 10593503749682317239u, 13220965786406254605u, 14363535925473363203u, 3303144u},
    {11553334383687896267u, 2056043059178894319u, 11740317882921768800u, 10581340995907623844u, 331254u},
    {584458663344563901u, 4975945168843770688u, 13256389387027387663u, 78168162380661515u, 187065u},
    {4059947150394150852u, 11449203091834694918u, 12058794426135873863u, 4182791194458136927u, 2389221u},
    {10559603526855016472u, 18098352807603875865u, 1469616381067963627u, 4151356212667215955u, 236331u},
    {12823293869238789030u, 6286739736000116973u, 13100450618939577636u, 436705105852607680u, 2676575u},
    {10801860475020974147u, 12459516010605212669u, 17878637495962680328u, 14100604931851741768u, 1680523u},
    {8777726989694478513u, 16278309102673005048u, 12213901683139363965u, 13721943058997895368u, 3681367u},
    {8748684341566976341u, 7486039341760765998u, 16635909123751073887u, 15992637530994416825u, 590912u},
    {1947344234373935851u, 5078406341405845589u, 10310450063395482287u, 13125382533329605741u, 744344u},
    {16836352559840832923u, 2820776625539281458u, 15083268901490098128u, 17811956463764383987u, 151091u},
    {8201070357450228388u, 10100876571712191499u, 11577122048721157536u, 11459944606851339137u, 1718679u},
    {6377178356912081458u, 747822750707716772u, 5777048037261410724u, 11777091871300057233u, 1512129u},
    {2929778087081465815u, 11986677255052765283u, 16152111101306266774u, 6224846955708328717u, 3820454u},
    {7679910882384619482u, 11856542754868763942u, 329871721887677386u, 15995203225790300763u, 149100u},
    {5287837521284090824u, 13437530621669801187u, 17270697048532243340u, 7640855393556954535u, 78528u},
    {2930978729223650513u, 18248232549850861281u, 4173682541468461363u, 7567495967541908937u, 3775933u},
    {16531753060490579882u, 7919962067683071080u, 16675241724593420094u, 1366690369940673143u, 1188531u},
    {14730923607457810789u, 8612421747118092965u, 597476019250454008u, 1895421973533486793u, 448938u},
    {7119981117797020034u, 12043791112687691960u, 4000556474356054777u, 6349349721624043360u, 2032818u},
    {13309596654504424665u, 17961364962417343468u, 16989031595565888472u, 11350541143698465776u, 1854853u},
    {5469982854613385407u, 17915080445693757493u, 11843883755537511397u, 538619168201389078u, 908824u},
    {638200479108354094u, 5265608153446028176u, 13636730886590099164u, 8015157782484665073u, 1867525u},
    {17713594611846903421u, 8400159008010795014u, 15981068766043842150u, 2700580743144745844u, 2064681u},
    {1513084128437356338u, 2960916229994356336u, 16322054379173739288u, 3929196722749539997u, 2025066u},
    {16146481427452167817u, 3727727932830965928u, 11111334567868588089u, 4288753926401315653u, 35u},
    {6160103518511760249u, 16016095876503856662u, 4346462672403414238u, 649924796506u, 0u},
    {6864734562942693081u, 13039411888425910343u, 17059484470789262465u, 649u, 0u},
    {8928938525597900095u, 5317481499710275300u, 11988996388308u, 0u, 0u},
    {15037435806188398586u, 18380120121029968917u, 11988u, 0u, 0u},
    {2485542442813773198u, 221157948075751u, 0u, 0u, 0u},
    {17488910743672524948u, 221157u, 0u, 0u, 0u},
    {4079644068020127u, 0u, 0u, 0u, 0u},
    {4079645u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 147226u},
    {3608671905748565305u, 12909419917425160249u, 8231254784835174914u, 17800941567711196154u, 2150496u},
    {1978559274599876581u, 15903711993555292776u, 11495968302988237082u, 18054068176626461663u, 2388704u},
    {7999530181960704365u, 2024115384506093850u, 7559610892195970625u, 2854309996889103981u, 1437562u},
    {6835989593787868508u, 5601615654644658892u, 6074589809295185829u, 4782319547661643823u, 2213702u},
    {9574705706052609434u, 6600686078378951544u, 9095835958323476573u, 5733385528028085473u, 2787829u},
    {11941776191703784409u, 4647103128013553741u, 11071129586785814521u, 16912903378692788177u, 3676869u},
    {15043836552693652361u, 3871414807642361236u, 619044721580574174u, 2661899663713865440u, 107457u},
    {13183381309357836439u, 15450118575021905850u, 34420739616871206u, 9729757429560099631u, 1522166u},
    {9140365723096672204u, 5037042089882057398u, 16698359585955700724u, 8602932706882883986u, 1186381u},
    {15068045337391559433u, 8077881549880647782u, 8091215716708669933u, 12199618267693665502u, 3722836u},
    {3163496314044384706u, 16237384572288732252u, 18328103441462334729u, 10084679786391993943u, 2987755u},
    {2885140947706126578u, 14737433998102632538u, 14396872535394278952u, 15475439486041204171u, 718652u},
    {11214479247218660510u, 3920792748674548581u, 13450366034757314737u, 4120539665159391354u, 909663u},
    {6791704627632271569u, 1884189716727619278u, 203961272348283004u, 1385874611395493301u, 1630673u},
    {16385671029082078775u, 16041238989746969375u, 1066422305325710504u, 894771737339918019u, 3281646u},
    {11290815226556878058u, 1225154985944012648u, 10373673274766095016u, 9716253285879627816u, 2698953u},
    {9371250150651554771u, 12935802156876629456u, 6314059743630226834u, 1851226755922422301u, 2900990u},
    {15719217653927168025u, 12745901239383269962u, 1197602126058345646u, 5241660592672428820u, 1258534u},
    {5732330938606289605u, 3152258407658584159u, 9332572409537137084u, 8742184738437002825u, 1760834u},
    {10595632104185435343u, 1168907234812453196u, 870881293249778282u, 12138157461268364271u, 2813429u},
    {7250047611939184608u, 14811496645919174996u, 6674318576908182145u, 9707616217953053475u, 152215u},
    {10742379441244141431u, 9880496449754051963u, 6498472781219694283u, 10162928640204634893u, 2417010u},
    {7329969809438989285u, 167827214637764864u, 10256814964272114706u, 188701163132381235u, 3886455u},
    {2233561294565240255u, 13810504442963703533u, 10295912141118409482u, 2233420262065528098u, 1824649u},
    {14041488874276509843u, 3923526444538878339u, 13136127202653493954u, 14012832078718789905u, 1791585u},
    {16800184815592906341u, 7971358205675837864u, 13848731994164089225u, 14012222167352148589u, 1813920u},
    {6624656877184799246u, 12643888507635179272u, 4048014573659695905u, 11634733572128803093u, 1991556u},
    {1336491259614996368u, 10664242230028473417u, 16730414534039667793u, 469083299702761887u, 3010033u},
    {816082944586477770u, 8435054737620409524u, 8893640469317607954u, 9423012533804135162u, 2583060u},
    {2536811372162760925u, 5177357389237617855u, 3714438646078572775u, 14242995081641852120u, 1586037u},
    {1556759971141805214u, 15691511949853392750u, 13987020713362343157u, 16530446267558926501u, 3708635u},
    {5783734547692654664u, 4892839003312083675u, 9524619574863306221u, 14696103846937619098u, 2369295u},
    {3788994793151146528u, 11129144076185800042u, 620729590297524571u, 14239051818668026911u, 310529u},
    {9963661610586253738u, 8564509154947657691u, 401987296957591554u, 8796754735856724964u, 3737896u},
    {2918336811250879972u, 2949080135078227781u, 73139495979838298u, 6482077889058483678u, 183720u},
    {18090456965420163391u, 425349934634598582u, 16258502710494222146u, 1012195358834290911u, 232403u},
    {6628505865413027189u, 4711170969849220084u, 13991932116175800169u, 652805426016509103u, 2205639u},
    {16575279466548853939u, 659674037977842318u, 13526475898447950326u, 3355336184549483143u, 1543919u},
    {2328620438181891467u, 14596825170009340917u, 14220710256759397702u, 13359135179035541921u, 3448670u},
    {2206648320063831965u, 786856176344099224u, 7509533777038230291u, 495962310471382714u, 742734u},
    {1102538431233806462u, 5145845048495974225u, 10723846034626259756u, 11542916070577274660u, 278390u},
    {9539960981155165225u, 16460881170036344093u, 12020874281914489102u, 8579989091139020456u, 268912u},
    {447628941040269919u, 7478344559354151232u, 1534441652352712484u, 6129856052646213034u, 927981u},
    {7503874578884495991u, 10013367952602204229u, 1187607472425406909u, 13852176289424284828u, 3373947u},
    {9209154271704070972u, 9489480884612478199u, 17901332513283722043u, 12456144525203041401u, 780857u},
    {11895777962165097122u, 14223802000816132704u, 10131990654681641066u, 2536420073020786904u, 1878819u},
    {13233853668209785u, 5276292596155962672u, 1446379845734991251u, 6087495994976189603u, 3844943u},
    {7737508642675688552u, 6019296318840221658u, 9136072655951628537u, 16428000532196138491u, 2029337u},
    {2690832062899254903u, 2434318408047112605u, 10033130301674234769u, 13296031979685050276u, 2278671u},
    {8279865001873003809u, 4020205210110449632u, 6925509320521427794u, 4221374528261036085u, 1860800u},
    {9107734866772801449u, 6360731659990210569u, 16751283264700773861u, 17904609026999861389u, 318976u},
    {13663629243532702817u, 1090526155454763099u, 17268487919776875575u, 5914606797652355356u, 3009815u},
    {7769305143065240432u, 3622415007875166181u, 13825214816125943920u, 14755270476666117855u, 1620704u},
    {5207268027770881277u, 17842292678292954031u, 14911896328270347858u, 12207630119072329025u, 1411939u},
    {9761432262567458372u, 10289140847016518410u, 12386480434161885466u, 12852297428339492117u, 249867u},
    {2925813184188004737u, 1667085583320646047u, 16106353811666910039u, 4904525640032862660u, 1528997u},
    {4072992081401878335u, 3459838687841782692u, 5996516537647379317u, 9251577058107771131u, 371078u},
    {15141227513667823356u, 3269622321106868698u, 1887713969258625277u, 13049269711013917467u, 2546086u},
    {13464155622332810186u, 16459350254422700136u, 8295361409789934307u, 2208694831018762648u, 2465103u},
    {8676500318231595833u, 6707115206359251908u, 15421830312941378118u, 15537855844519534707u, 2998242u},
    {17976773063206220420u, 13163135077063015173u, 18000218125352728232u, 1352344511065605765u, 2291697u},
    {8122220175322691109u, 15061310988555339640u, 6923766203407270433u, 1339311042088535317u, 1536305u},
    {10223004795680131328u, 13993751443559622125u, 14461402444493246551u, 5144429003186354850u, 3518993u},
    {3665254960681176789u, 3622349497943441653u, 6570684837632835257u, 857547502829811695u, 3118802u},
    {9599971119881734425u, 4080052499605650684u, 15290427346331105211u, 6110369642354067623u, 2647898u},
    {17566896298266688494u, 18113844302120850259u, 12155865548917372878u, 6461970972225243320u, 2514011u},
    {14609468677538404073u, 12309291235825760612u, 14627070795130179935u, 7252134727770255195u, 1054635u},
    {7865183516733478936u, 3020167637036845486u, 13628368851157465148u, 13133936704091195752u, 840219u},
    {1472489032988719286u, 4108998299700450535u, 15503375257256863055u, 8085949850240733701u, 3514369u},
    {8700936173158794149u, 6520649823314669103u, 8188583589033060426u, 1361865366292231261u, 962652u},
    {7720031154563546240u, 15050136128820441877u, 10597228229619409785u, 6358826071775568381u, 1028415u},
    {9387861901287747993u, 15882383261455431571u, 5547618870474043201u, 5135060091358273536u, 2977138u},
    {3132154792120878752u, 7942620237956447382u, 8065443058436274802u, 16339934760464889134u, 1196099u},
    {1563162744371412851u, 12564547604052634700u, 8176244794291896866u, 3048483098072727993u, 343243u},
    {13516292637654450702u, 8453688330665147053u, 12876909845014501172u, 1735713975734845849u, 2176613u},
    {9326459779612354683u, 13377978809906349480u, 118104498598840079u, 17333973993796927784u, 361660u},
    {16488216518816073472u, 17091203231980408481u, 4323369754353373466u, 5338933425602339054u, 311270u},
    {6278719791043006573u, 12523381121256564510u, 13537168488641481484u, 12471705691928289925u, 441726u},
    {18091126825398094986u, 283403613620766023u, 6002923624250571459u, 2746336992385670685u, 3648704u},
    {1471089322721093588u, 4584042521251925553u, 3784835605984036311u, 16136150182092987056u, 156548u},
    {9747456452118715099u, 14811493937662931447u, 18066162364533913747u, 3029306766620374576u, 308076u},
    {9973921197536422659u, 17940329663302449375u, 8190822786518722914u, 12543704364756019774u, 1993761u},
    {50750673822766843u, 17138938448031363827u, 1761434405266367281u, 14232124436926650986u, 656239u},
    {10730354499645283226u, 3105226058405713357u, 6817606890571487099u, 5920828198226402271u, 149452u},
    {5391335988779365896u, 10406346002334300537u, 2481395200697804753u, 13189296617656944526u, 1926500u},
    {7411260583830575758u, 2092649737162297639u, 15590607500757732292u, 828171200064505364u, 224049u},
    {11517545624731957608u, 610695328852707833u, 7277582702878104778u, 16937667574304206711u, 2130074u},
    {9309049814343816890u, 9502425121547024231u, 13892359091442190026u, 1480444827632289093u, 3256211u},
    {1705451508046681688u, 13887954656818273184u, 7551655588636621579u, 10292244845833209592u, 3207693u},
    {10636203149651253826u, 11378934213694627790u, 10791188124412235278u, 17857397229498474650u, 2440267u},
    {13069715013618686951u, 16968577521073943734u, 16450734839251848409u, 13663900271846296119u, 345123u},
    {11903096435035741023u, 10056349558313711173u, 7907471480325359453u, 3753361299291103805u, 1237343u},
    {2715409236043312216u, 12072651358829587618u, 300683651856136026u, 3913935031453865841u, 3539621u},
    {13068273872263878552u, 3449232318467055465u, 4693651857070078882u, 10369530434042557756u, 1451419u},
    {14969181178601297884u, 5837816049777642020u, 13641383111401768667u, 7304590963036971413u, 3671304u},
    {920522132824782035u, 608386519662864585u, 13336971573890979412u, 12389572193095054190u, 1493341u},
    {9068798523487084660u, 12487799143236481296u, 11341856017747815550u, 387835261820989368u, 3392313u},
    {9342876547286978753u, 4426701454154729157u, 18301331648145312211u, 1936074575102879467u, 1921529u},
    {17735143756490349587u, 14742953436586244054u, 2029516907163144914u, 683964301970637040u, 1401792u},
    {11152254926320155144u, 2175437566756836897u, 13826441804515779772u, 4997832487569565345u, 2877368u},
    {13866020871021907900u, 9940122124688605373u, 12613736646218997955u, 3367727401844399048u, 1476535u},
    {3090565689747655852u, 6981068533948447278u, 11800928367764271207u, 18113693370148514070u, 56238u},
    {15218544642393620968u, 14893363541738132243u, 16828866456674192024u, 10593503749682317239u, 2083317u},
    {14585638433325871470u, 4006260203472789219u, 11553334383687896266u, 2056043059178894319u, 215278u},
    {14569213156621829097u, 15742276853417566112u, 584458663344563900u, 4975945168843770688u, 3475043u},
    {628753006676978123u, 7214306091212325268u, 4059947150394150851u, 11449203091834694918u, 644921u},
    {15700619859170485796u, 524871027067947181u, 10559603526855016471u, 18098352807603875865u, 961093u},
    {6830443532542965188u, 7047499603374225671u, 12823293869238789029u, 6286739736000116973u, 3556716u},
    {6498765051588923094u, 11010970251307557333u, 10801860475020974146u, 12459516010605212669u, 3542654u},
    {7144042452238797858u, 13300867548419269996u, 8777726989694478512u, 16278309102673005048u, 3475255u},
    {15125661563793667249u, 14435635356218659667u, 8748684341566976340u, 7486039341760765998u, 1863459u},
    {15955796469897373711u, 7329175736140104224u, 1947344234373935850u, 5078406341405845589u, 570857u},
    {10202475053099194788u, 14434493607469269676u, 16836352559840832922u, 2820776625539281458u, 694616u},
    {5794535752182825195u, 14984104761943845309u, 8201070357450228387u, 10100876571712191499u, 1477052u},
    {4582979883623947580u, 13551872565024067039u, 6377178356912081457u, 747822750707716772u, 1361576u},
    {10084386346417375063u, 8050152947659456197u, 2929778087081465814u, 11986677255052765283u, 2119470u},
    {10316872696621591112u, 691042010191148514u, 7679910882384619481u, 11856542754868763942u, 1887494u},
    {3099458584815281947u, 15996666286869213943u, 5287837521284090823u, 13437530621669801187u, 957418u},
    {14449237071206744516u, 7276126794008146037u, 2930978729223650512u, 18248232549850861281u, 3560753u},
    {11916213971466310164u, 7297845114763020706u, 16531753060490579881u, 7919962067683071080u, 2036568u},
    {16261391703820168422u, 294560734166587691u, 14730923607457810788u, 8612421747118092965u, 551474u},
    {3044392421815375402u, 4727501540205492623u, 7119981117797020033u, 12043791112687691960u, 1031295u},
    {8359880521657890404u, 17685685153321283772u, 13309596654504424664u, 17961364962417343468u, 2428456u},
    {1226317049352321588u, 6833797207940863099u, 5469982854613385406u, 17915080445693757493u, 292939u},
    {18089990445570519515u, 18065879283848320202u, 638200479108354093u, 5265608153446028176u, 2248532u},
    {9034060831255307936u, 3915673798969283540u, 17713594611846903420u, 8400159008010795014u, 355340u},
    {8506813511220906041u, 13542143759577905732u, 1513084128437356337u, 2960916229994356336u, 2861786u},
    {8265502649454356106u, 5825771940857155537u, 16146481427452167816u, 3727727932830965928u, 1046797u},
    {15392174902863510188u, 17580003444026622898u, 6160103518511760248u, 16016095876503856662u, 3742934u},
    {7780475146392507215u, 813094569843304932u, 6864734562942693080u, 13039411888425910343u, 3104999u},
    {6979855492345257234u, 16456818381001823528u, 8928938525597900094u, 5317481499710275300u, 294558u},
    {6078796164426326198u, 6416540230586495733u, 15037435806188398585u, 18380120121029968917u, 11988u},
    {2384601259987984532u, 18344419714048063858u, 2485542442813773197u, 221157948075751u, 0u},
    {2045811545922764754u, 483983793065195436u, 17488910743672524947u, 221157u, 0u},
    {6462528650127521612u, 18064244545485438721u, 4079644068020126u, 0u, 0u},
    {14928255225593620651u, 1254749874247721533u, 4079644u, 0u, 0u},
    {4438770626287035262u, 75256150034594604u, 0u, 0u, 0u},
    {638157810758099376u, 75256150u, 0u, 0u, 0u},
    {1388230939660854884u, 0u, 0u, 0u, 0u},
    {1388230940u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 602306u},
    {5982983326005765525u, 6810861394117643027u, 3608671905748565304u, 12909419917425160249u, 2766954u},
    {14123299855951440409u, 4547172448550193767u, 1978559274599876580u, 15903711993555292776u, 352514u},
    {9703161663285788341u, 8430217017529777191u, 7999530181960704364u, 2024115384506093850u, 2882943u},
    {11018386767418054319u, 16887274268383602785u, 6835989593787868507u, 5601615654644658892u, 2355159u},
    {2310589607289919146u, 9218566363316199485u, 9574705706052609433u, 6600686078378951544u, 1919965u},
    {8121177549681461589u, 10913528722110162949u, 11941776191703784408u, 4647103128013553741u, 2838567u},
    {7335960313168748276u, 4080482814095837331u, 15043836552693652360u, 3871414807642361236u, 1615106u},
    {8245282932296636910u, 12637201614357816389u, 13183381309357836438u, 15450118575021905850u, 3527348u},
    {2259681977322646471u, 14168736167060821209u, 9140365723096672203u, 5037042089882057398u, 402836u},
    {17559009293263964464u, 8899015331470174486u, 15068045337391559432u, 8077881549880647782u, 1324131u},
    {11708158921999607424u, 15493787077679853079u, 3163496314044384705u, 16237384572288732252u, 2042897u},
    {15367336549878357286u, 16991885705748947491u, 2885140947706126577u, 14737433998102632538u, 1609100u},
    {13111112850911901926u, 17562362630920863408u, 11214479247218660509u, 3920792748674548581u, 579629u},
    {12273273188255860167u, 10620661802072808724u, 6791704627632271568u, 1884189716727619278u, 2409808u},
    {5847532069385770154u, 5207244031408198039u, 16385671029082078774u, 16041238989746969375u, 9534u},
    {6296008179628667158u, 6343102550587862941u, 11290815226556878057u, 1225154985944012648u, 2032490u},
    {14123557409705222395u, 10550111037552025746u, 9371250150651554770u, 12935802156876629456u, 3456690u},
    {12299481769845909045u, 11942353981597066470u, 15719217653927168024u, 12745901239383269962u, 2915520u},
    {16923482906579806101u, 12778497483718293955u, 5732330938606289604u, 3152258407658584159u, 866588u},
    {2692087797294558797u, 13391832171456561917u, 10595632104185435342u, 1168907234812453196u, 2151592u},
    {6237183538764011234u, 17609963435832093318u, 7250047611939184607u, 14811496645919174996u, 466535u},
    {16992361567149213439u, 4969610111314177361u, 10742379441244141430u, 9880496449754051963u, 1285431u},
    {15597359374087813755u, 17687866683964293308u, 7329969809438989284u, 167827214637764864u, 2575196u},
    {1180330651779615835u, 7136213056500462724u, 2233561294565240254u, 13810504442963703533u, 1757294u},
    {12871227853462258941u, 2447138545807120080u, 14041488874276509842u, 3923526444538878339u, 2440694u},
    {15981634840513729043u, 11672105926187292074u, 16800184815592906340u, 7971358205675837864u, 1832819u},
    {5272841728606438519u, 12925062251562937811u, 6624656877184799245u, 12643888507635179272u, 3890979u},
    {14867576688915314267u, 13373118779843831661u, 1336491259614996367u, 10664242230028473417u, 233983u},
    {8201803410644197661u, 1503363298712590004u, 816082944586477769u, 8435054737620409524u, 3321356u},
    {15073362684219220194u, 12011097295420755493u, 2536811372162760924u, 5177357389237617855u, 2982317u},
    {15204094046918140185u, 4672341802644917703u, 1556759971141805213u, 15691511949853392750u, 3522583u},
    {4507762224161798903u, 11110475085518993237u, 5783734547692654663u, 4892839003312083675u, 1749609u},
    {7740569423180647179u, 5413089459682361059u, 3788994793151146527u, 11129144076185800042u, 3345471u},
    {15686628951686341277u, 6512257293934985365u, 9963661610586253737u, 8564509154947657691u, 3619954u},
    {1807951327485173866u, 14446114151528328640u, 2918336811250879971u, 2949080135078227781u, 3527016u},
    {8328137676814059166u, 14244932972470129147u, 18090456965420163390u, 425349934634598582u, 1486840u},
    {11745252603429586881u, 5733449916627516144u, 6628505865413027188u, 4711170969849220084u, 604751u},
    {4193003083836754019u, 20483048991968118u, 16575279466548853938u, 659674037977842318u, 2232978u},
    {636619684097977784u, 14010962406760261861u, 2328620438181891466u, 14596825170009340917u, 3593058u},
    {12602668660371926399u, 4645550306954449273u, 2206648320063831964u, 786856176344099224u, 1613069u},
    {13341627309695540368u, 11114097122137818685u, 1102538431233806461u, 5145845048495974225u, 1721156u},
    {17992198548860432592u, 15378445436819900409u, 9539960981155165224u, 16460881170036344093u, 3058120u},
    {8008604538765826916u, 16476488527707852364u, 447628941040269918u, 7478344559354151232u, 3763264u},
    {15106152878421684472u, 9795464874892450433u, 7503874578884495990u, 10013367952602204229u, 2707039u},
    {4932523630826448552u, 1939100311707199290u, 9209154271704070971u, 9489480884612478199u, 1542601u},
    {11231644461135463995u, 6078711507277016763u, 11895777962165097121u, 14223802000816132704u, 872144u},
    {5971955338674568279u, 3151228685290455886u, 13233853668209784u, 5276292596155962672u, 2087957u},
    {2513013491043557659u, 2001898371445651790u, 7737508642675688551u, 6019296318840221658u, 3058415u},
    {13542383750315644386u, 6419284667374630009u, 2690832062899254902u, 2434318408047112605u, 3092011u},
    {7779515452682281323u, 3380413782567663498u, 8279865001873003808u, 4020205210110449632u, 1065954u},
    {1496846335138906199u, 15118548274154287291u, 9107734866772801448u, 6360731659990210569u, 523791u},
    {17196321548481452118u, 8001840612902437337u, 13663629243532702816u, 1090526155454763099u, 1059011u},
    {14708621955705866271u, 13052008829898198005u, 7769305143065240431u, 3622415007875166181u, 2388874u},
    {4624103292888530781u, 8044246410387655106u, 5207268027770881276u, 17842292678292954031u, 3087942u},
    {632285954050353260u, 5543411220938080455u, 9761432262567458371u, 10289140847016518410u, 529140u},
    {821846555281126719u, 8975019302629442456u, 2925813184188004736u, 1667085583320646047u, 58231u},
    {4074096983927694687u, 13321519598711040576u, 4072992081401878334u, 3459838687841782692u, 1465331u},
    {5708463902289305011u, 16460777618190788838u, 15141227513667823355u, 3269622321106868698u, 1638165u},
    {15555413329901452015u, 2828947732889566823u, 13464155622332810185u, 16459350254422700136u, 312193u},
    {1661585452033669070u, 2842882500411481576u, 8676500318231595832u, 6707115206359251908u, 2637482u},
    {13343858303322963814u, 18289447804392197231u, 17976773063206220419u, 13163135077063015173u, 69054u},
    {18442807680995288817u, 2117181000077869498u, 8122220175322691108u, 15061310988555339640u, 790285u},
    {12378341309932362470u, 5608812006302039709u, 10223004795680131327u, 13993751443559622125u, 1055459u},
    {16046405877915934794u, 9562305711225363916u, 3665254960681176788u, 3622349497943441653u, 2430089u},
    {4492849083884928763u, 6971718561529198220u, 9599971119881734424u, 4080052499605650684u, 1484717u},
    {11578536848060959021u, 991654909797855998u, 17566896298266688493u, 18113844302120850259u, 3225514u},
    {4209663850876019404u, 11814132775357823726u, 14609468677538404072u, 12309291235825760612u, 3567365u},
    {15783295992973962153u, 16101913956497181596u, 7865183516733478935u, 3020167637036845486u, 92994u},
    {1249375782015779178u, 17030469026942109711u, 1472489032988719285u, 4108998299700450535u, 1922635u},
    {8012420599969532444u, 4772918049593428264u, 8700936173158794148u, 6520649823314669103u, 3369514u},
    {6977811962268717143u, 17592050716380403536u, 7720031154563546239u, 15050136128820441877u, 1610721u},
    {9103038176855629368u, 10101238714516376582u, 9387861901287747992u, 15882383261455431571u, 882805u},
    {12251632165076784248u, 7058292599993936006u, 3132154792120878751u, 7942620237956447382u, 1437990u},
    {4039373102567546469u, 545313487333489731u, 1563162744371412850u, 12564547604052634700u, 1244112u},
    {12642418556454936550u, 16694951273797814526u, 13516292637654450701u, 8453688330665147053u, 2565434u},
    {16247401029758085030u, 14326668468567725184u, 9326459779612354682u, 13377978809906349480u, 734733u},
    {3417276769628501049u, 2117974187663515600u, 16488216518816073471u, 17091203231980408481u, 3112600u},
    {5352187618663531028u, 15267897226536528663u, 6278719791043006572u, 12523381121256564510u, 3644590u},
    {6242529739898065410u, 9448012295594659148u, 18091126825398094985u, 283403613620766023u, 2407693u},
    {6367323975142156682u, 9606495443895457648u, 1471089322721093587u, 4584042521251925553u, 2151445u},
    {5715061936002816435u, 12172843262396096594u, 9747456452118715098u, 14811493937662931447u, 3797219u},
    {3285144096355241891u, 14232111579175170508u, 9973921197536422658u, 17940329663302449375u, 3322464u},
    {11208639783208178311u, 4294590966144498128u, 50750673822766842u, 17138938448031363827u, 365891u},
    {11810477138961489357u, 11296944163631032066u, 10730354499645283225u, 3105226058405713357u, 1629147u},
    {18226696011411240045u, 2330306520652125437u, 5391335988779365895u, 10406346002334300537u, 161519u},
    {12238725780582062679u, 14453860562372227013u, 7411260583830575757u, 2092649737162297639u, 1855860u},
    {11561003760520352926u, 14180796926854032567u, 11517545624731957607u, 610695328852707833u, 3408748u},
    {8137311413340135443u, 16181167055915861495u, 9309049814343816889u, 9502425121547024231u, 2867530u},
    {15538823972470627715u, 15448186456910633686u, 1705451508046681687u, 13887954656818273184u, 3572009u},
    {15137653616043326612u, 5867579754212318004u, 10636203149651253825u, 11378934213694627790u, 1899680u},
    {10320671531915677759u, 9278648541442709550u, 13069715013618686950u, 16968577521073943734u, 2187051u},
    {11718241609924054124u, 3772679223361930707u, 11903096435035741022u, 10056349558313711173u, 2115991u},
    {4254558595958370713u, 5942424658051020294u, 2715409236043312215u, 12072651358829587618u, 3389508u},
    {15444660257620615278u, 16318110658166320888u, 13068273872263878551u, 3449232318467055465u, 62392u},
    {10793624873410400685u, 8585534242523004356u, 14969181178601297883u, 5837816049777642020u, 1730699u},
    {17867676954836090432u, 6649865802039654597u, 920522132824782034u, 608386519662864585u, 1183698u},
    {17188246502634016382u, 12262393476607379960u, 9068798523487084659u, 12487799143236481296u, 1690716u},
    {13872678657482238654u, 11394581330688197410u, 9342876547286978752u, 4426701454154729157u, 2342107u},
    {14893810900620273898u, 1977938420320497162u, 17735143756490349586u, 14742953436586244054u, 743206u},
    {17668205489971947805u, 13647063340801696317u, 11152254926320155143u, 2175437566756836897u, 3698850u},
    {9450618177296539992u, 10679858617375152250u, 13866020871021907899u, 9940122124688605373u, 3444483u},
    {14740293107520082608u, 9609608406976718751u, 3090565689747655851u, 6981068533948447278u, 2683355u},
    {18249120706540540661u, 10973451162843731247u, 15218544642393620967u, 14893363541738132243u, 2336050u},
    {670364419321852658u, 11211275369456016629u, 14585638433325871469u, 4006260203472789219u, 1828038u},
    {1618359513802089893u, 7900790322636819416u, 14569213156621829096u, 15742276853417566112u, 463316u},
    {15350287634640521815u, 15443875795028368431u, 628753006676978122u, 7214306091212325268u, 1109565u},
    {1243938327065883824u, 4578257766598090935u, 15700619859170485795u, 524871027067947181u, 3139469u},
    {17701189675125161585u, 5593738196503052494u, 6830443532542965187u, 7047499603374225671u, 3155893u},
    {17875407660143553580u, 5648572546230184168u, 6498765051588923093u, 11010970251307557333u, 2291474u},
    {10317411699827702146u, 14935394631245024206u, 7144042452238797857u, 13300867548419269996u, 1307360u},
    {8129477430376576336u, 6825803585347391648u, 15125661563793667248u, 14435635356218659667u, 2784162u},
    {7012764410334781063u, 208429620540695219u, 15955796469897373710u, 7329175736140104224u, 1245466u},
    {3254563841644055693u, 12806803152215249511u, 10202475053099194787u, 14434493607469269676u, 3696196u},
    {2114498164371881514u, 2870545432269712576u, 5794535752182825194u, 14984104761943845309u, 273483u},
    {16121029348450440362u, 3899932900354692222u, 4582979883623947579u, 13551872565024067039u, 2805915u},
    {12134425249599239670u, 1591858887601879084u, 10084386346417375062u, 8050152947659456197u, 2305212u},
    {2392285570882166584u, 17466264320715590755u, 10316872696621591111u, 691042010191148514u, 3899767u},
    {9628236511150587970u, 5744694040465256781u, 3099458584815281946u, 15996666286869213943u, 3814623u},
    {2943929417814949883u, 14934205867812803636u, 14449237071206744515u, 7276126794008146037u, 1085726u},
    {426345652981058560u, 1390282471705572401u, 11916213971466310163u, 7297845114763020706u, 343169u},
    {12725692431359439098u, 14890490787799259245u, 16261391703820168421u, 294560734166587691u, 2372122u},
    {14142214600665009077u, 8676549849165768907u, 3044392421815375401u, 4727501540205492623u, 1711663u},
    {2788447830170198191u, 12295040802996876278u, 8359880521657890403u, 17685685153321283772u, 3273388u},
    {17954607191384781503u, 8053827869863500704u, 1226317049352321587u, 6833797207940863099u, 2790778u},
    {5190370137855134649u, 5779223605840681702u, 18089990445570519514u, 18065879283848320202u, 1331601u},
    {16572129388412227126u, 17120183409809588383u, 9034060831255307935u, 3915673798969283540u, 3652334u},
    {15314391890493587315u, 4509249033650229254u, 8506813511220906040u, 13542143759577905732u, 3315729u},
    {9905843844587470398u, 4795422529886555786u, 8265502649454356105u, 5825771940857155537u, 3795146u},
    {96036600352163122u, 9785010337028306211u, 15392174902863510187u, 17580003444026622898u, 1109194u},
    {6996918556908303360u, 12907921369061854643u, 7780475146392507214u, 813094569843304932u, 1500912u},
    {9789218742529290188u, 8609560293165338441u, 6979855492345257233u, 16456818381001823528u, 185092u},
    {17285709128999239637u, 6996710449255187460u, 6078796164426326197u, 6416540230586495733u, 2265485u},
    {13163294430616917800u, 1549100112699048988u, 2384601259987984531u, 18344419714048063858u, 2799313u},
    {18201379885664739085u, 7721969162344094104u, 2045811545922764753u, 483983793065195436u, 2702159u},
    {3131191530405611697u, 7233389553530919361u, 6462528650127521611u, 18064244545485438721u, 1613876u},
    {16300011779981120225u, 2099390801463173166u, 14928255225593620650u, 1254749874247721533u, 173394u},
    {15480777666396818457u, 16767530358844783545u, 4438770626287035261u, 75256150034594604u, 0u},
    {4517584488468434352u, 8487629661434224656u, 638157810758099375u, 75256150u, 0u},
    {11409662735262010773u, 11151753626802437991u, 1388230939660854883u, 0u, 0u},
    {18014701397982592973u, 12190620907714022735u, 1388230939u, 0u, 0u},
    {15913455661114028011u, 7161596785419565344u, 1u, 0u, 0u},
    {2381787532608848889u, 25608340859u, 0u, 0u, 0u},
    {11221908137935415480u, 25u, 0u, 0u, 0u},
    {472390509981u, 0u, 0u, 0u, 0u},
    {473u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2030036u},
    {7772429657359560186u, 16810377974264459374u, 5982983326005765524u, 6810861394117643027u, 408962u},
    {12149715968774266711u, 4025371548759000811u, 14123299855951440408u, 4547172448550193767u, 3877980u},
    {17205738843344879363u, 1873391564700514791u, 9703161663285788340u, 8430217017529777191u, 1398472u},
    {13906396040592771009u, 9058720606983884720u, 11018386767418054318u, 16887274268383602785u, 3645733u},
    {12745599562301282401u, 5036369293840803095u, 2310589607289919145u, 9218566363316199485u, 1779827u},
    {7883042084508529144u, 6292830358215926437u, 8121177549681461588u, 10913528722110162949u, 2453416u},
    {3007725488200319980u, 8213797751767338386u, 7335960313168748275u, 4080482814095837331u, 1470322u},
    {11948642985618242572u, 8436323317759914051u, 8245282932296636909u, 12637201614357816389u, 2463726u},
    {7372644803533277686u, 16242664178375022283u, 2259681977322646470u, 14168736167060821209u, 1947837u},
    {10654729792240739909u, 2831407107931592562u, 17559009293263964463u, 8899015331470174486u, 76130u},
    {2779903423954979635u, 10060469034169593430u, 11708158921999607423u, 15493787077679853079u, 3163219u},
    {1067775874641549243u, 16975984274882698488u, 15367336549878357285u, 16991885705748947491u, 2838835u},
    {15229523146319323098u, 18174590070440806094u, 13111112850911901925u, 17562362630920863408u, 1528479u},
    {11651593085772735360u, 4641656037423420187u, 12273273188255860166u, 10620661802072808724u, 1035264u},
    {9427303220764701643u, 12797290982386403155u, 5847532069385770153u, 5207244031408198039u, 110278u},
    {13683799836159668880u, 7917267767686211643u, 6296008179628667157u, 6343102550587862941u, 1610165u},
    {2821010612646505886u, 11082435890197928094u, 14123557409705222394u, 10550111037552025746u, 2865056u},
    {17781280551083101211u, 12809593712745750266u, 12299481769845909044u, 11942353981597066470u, 1317486u},
    {7558463861488035540u, 6126978696841712292u, 16923482906579806100u, 12778497483718293955u, 3316426u},
    {9879118157124063823u, 10316593169151234541u, 2692087797294558796u, 13391832171456561917u, 1513030u},
    {16967405763943821574u, 5261718815880295903u, 6237183538764011233u, 17609963435832093318u, 3778103u},
    {9632257546998895371u, 4063099943441280924u, 16992361567149213438u, 4969610111314177361u, 1829924u},
    {7670972500799438905u, 17299138150044596580u, 15597359374087813754u, 17687866683964293308u, 136134u},
    {11633320286937090244u, 14306383193456608099u, 1180330651779615834u, 7136213056500462724u, 3753396u},
    {14278827755088132162u, 2724259340617122236u, 12871227853462258940u, 2447138545807120080u, 3839880u},
    {13047349557557047590u, 6234510660920134483u, 15981634840513729042u, 11672105926187292074u, 1450278u},
    {294247477308232400u, 8456086991360502711u, 5272841728606438518u, 12925062251562937811u, 2301971u},
    {17036096301094592773u, 11115470633618595635u, 14867576688915314266u, 13373118779843831661u, 3372487u},
    {7665549294572815566u, 13990739621262123138u, 8201803410644197660u, 1503363298712590004u, 2685389u},
    {18330604598172134439u, 2240550920129491204u, 15073362684219220193u, 12011097295420755493u, 3288156u},
    {296267198153373825u, 6024005954033938768u, 15204094046918140184u, 4672341802644917703u, 737561u},
    {5415379962633041614u, 1448014961021700165u, 4507762224161798902u, 11110475085518993237u, 475417u},
    {12363496740780218833u, 17598139356084933464u, 7740569423180647178u, 5413089459682361059u, 1467675u},
    {9728846336125152120u, 705649258501342568u, 15686628951686341276u, 6512257293934985365u, 1875417u},
    {12393696924387679167u, 3368712453685751909u, 1807951327485173865u, 14446114151528328640u, 2688113u},
    {18128959019126170081u, 18038676881468660026u, 8328137676814059165u, 14244932972470129147u, 2217192u},
    {13942726737948465483u, 1681647063460342853u, 11745252603429586880u, 5733449916627516144u, 1110388u},
    {13430156556259263851u, 4668511436589026125u, 4193003083836754018u, 20483048991968118u, 1723294u},
    {6574021981731731943u, 3264866548779154314u, 636619684097977783u, 14010962406760261861u, 1835786u},
    {9412958713900764739u, 18255996903386030074u, 12602668660371926398u, 4645550306954449273u, 933912u},
    {15074492622291866502u, 5836502582619382190u, 13341627309695540367u, 11114097122137818685u, 1635947u},
    {17598067206048594775u, 10682401751489569385u, 17992198548860432591u, 15378445436819900409u, 2567232u},
    {8791641080397579180u, 1070894876478774454u, 8008604538765826915u, 16476488527707852364u, 3669464u},
    {11145685515303170433u, 15008763931782867811u, 15106152878421684471u, 9795464874892450433u, 3556338u},
    {12715677225105816128u, 17519653657147133005u, 4932523630826448551u, 1939100311707199290u, 1402611u},
    {8682497224854271895u, 13254221881931318491u, 11231644461135463994u, 6078711507277016763u, 2859699u},
    {2188669797602078096u, 9476364459606929468u, 5971955338674568278u, 3151228685290455886u, 3054378u},
    {16274739942571801217u, 2455896619511611009u, 2513013491043557658u, 2001898371445651790u, 333869u},
    {7114304170745640402u, 14793432119669662091u, 13542383750315644385u, 6419284667374630009u, 3565098u},
    {12164247224739509260u, 13448628610116547913u, 7779515452682281322u, 3380413782567663498u, 3171894u},
    {5029364164331082585u, 6279488519169202362u, 1496846335138906198u, 15118548274154287291u, 186898u},
    {5260285240324122636u, 18094816026639653034u, 17196321548481452117u, 8001840612902437337u, 519566u},
    {11372047205400759282u, 15530070448962834934u, 14708621955705866270u, 13052008829898198005u, 2485721u},
    {2747283751978851268u, 18266189682535906261u, 4624103292888530780u, 8044246410387655106u, 3633924u},
    {18406622057608379693u, 15652346813602360829u, 632285954050353259u, 5543411220938080455u, 2161771u},
    {1015837661929444958u, 1495424338851327511u, 821846555281126718u, 8975019302629442456u, 3411024u},
    {15081047793528546655u, 15281772700785526475u, 4074096983927694686u, 13321519598711040576u, 1715542u},
    {16198221366860162022u, 12686096233359487486u, 5708463902289305010u, 16460777618190788838u, 1013813u},
    {6881451307608311704u, 6784877507568952723u, 15555413329901452014u, 2828947732889566823u, 1769219u},
    {490311863369736797u, 93356137743334197u, 1661585452033669069u, 2842882500411481576u, 3191702u},
    {10271577813759167248u, 5150958079431336852u, 13343858303322963813u, 18289447804392197231u, 1491361u},
    {16745556789943808478u, 17985035448585013057u, 18442807680995288816u, 2117181000077869498u, 3273058u},
    {9434859713207531581u, 14573850763715077061u, 12378341309932362469u, 5608812006302039709u, 2748631u},
    {2367245681075786596u, 6862169422465782496u, 16046405877915934793u, 9562305711225363916u, 2937620u},
    {14818771268216933395u, 723071219865555399u, 4492849083884928762u, 6971718561529198220u, 2976470u},
    {12652626036174033749u, 7797302251667441384u, 11578536848060959020u, 991654909797855998u, 3726671u},
    {17132967121006535976u, 2436718312782364076u, 4209663850876019403u, 11814132775357823726u, 1792754u},
    {9270041652411441442u, 1163075388191730195u, 15783295992973962152u, 16101913956497181596u, 1348575u},
    {1004513823795312765u, 11538373634303213056u, 1249375782015779177u, 17030469026942109711u, 927905u},
    {6097113480168272935u, 2881415248733692706u, 8012420599969532443u, 4772918049593428264u, 541980u},
    {8248222880894537537u, 16892235975822027043u, 6977811962268717142u, 17592050716380403536u, 714247u},
    {3054158120114828416u, 12865588515043390517u, 9103038176855629367u, 10101238714516376582u, 3724558u},
    {5178387505386029401u, 3734032873839335475u, 12251632165076784247u, 7058292599993936006u, 2217753u},
    {14762118571412846203u, 10991461303503128708u, 4039373102567546468u, 545313487333489731u, 2691372u},
    {16272106202813382036u, 16985012942466847528u, 12642418556454936549u, 16694951273797814526u, 3212753u},
    {624113430884404333u, 5652247185934430005u, 16247401029758085029u, 14326668468567725184u, 1534360u},
    {13694887390455934806u, 8094625604751326817u, 3417276769628501048u, 2117974187663515600u, 3455617u},
    {9634196112061083134u, 7686001947102373671u, 5352187618663531027u, 15267897226536528663u, 459022u},
    {2654013193728301424u, 8936644469288518907u, 6242529739898065409u, 9448012295594659148u, 1237911u},
    {5913465279431734303u, 13694069470136237562u, 6367323975142156681u, 9606495443895457648u, 3641155u},
    {4154841818924337829u, 5980204393045362872u, 5715061936002816434u, 12172843262396096594u, 1993064u},
    {17438711122631948531u, 17800250669338863829u, 3285144096355241890u, 14232111579175170508u, 2341492u},
    {2362632232173779542u, 6654020442294884111u, 11208639783208178310u, 4294590966144498128u, 3033570u},
    {2907320481876007544u, 12287949522064275519u, 11810477138961489356u, 11296944163631032066u, 1326169u},
    {9559072068074727403u, 6603935792628518602u, 18226696011411240044u, 2330306520652125437u, 2295351u},
    {1390561215080136427u, 56028154805061224u, 12238725780582062678u, 14453860562372227013u, 3117541u},
    {10714210888249219074u, 16340409648365290776u, 11561003760520352925u, 14180796926854032567u, 2182823u},
    {9205673060713049036u, 3446801539927988826u, 8137311413340135442u, 16181167055915861495u, 1510365u},
    {1778577113122868433u, 15593084456730380055u, 15538823972470627714u, 15448186456910633686u, 1675885u},
    {3373644874316316741u, 219568843290838193u, 15137653616043326611u, 5867579754212318004u, 2996545u},
    {10615911456137205580u, 1565032743245811059u, 10320671531915677758u, 9278648541442709550u, 1392350u},
    {3529201332199831978u, 13974739717558888826u, 11718241609924054123u, 3772679223361930707u, 1826986u},
    {14358806170013007214u, 9796664593285023471u, 4254558595958370712u, 5942424658051020294u, 1794051u},
    {17461020606671913140u, 10066647833402572150u, 15444660257620615277u, 16318110658166320888u, 578993u},
    {6845521035912244658u, 9797325757578021485u, 10793624873410400684u, 8585534242523004356u, 1114947u},
    {18164244683511948771u, 8180629476409635883u, 17867676954836090431u, 6649865802039654597u, 683182u},
    {2501391113685462227u, 8452338264422706345u, 17188246502634016381u, 12262393476607379960u, 513991u},
    {15983693062507404594u, 10192059220681724999u, 13872678657482238653u, 11394581330688197410u, 1755506u},
    {3008158220023452037u, 12821039602958461121u, 14893810900620273897u, 1977938420320497162u, 1527536u},
    {1704862866142398022u, 9139256833607827595u, 17668205489971947804u, 13647063340801696317u, 831295u},
    {17597580143295186865u, 10751898700945147728u, 9450618177296539991u, 10679858617375152250u, 1406665u},
    {827355378769385012u, 12872695688906516132u, 14740293107520082607u, 9609608406976718751u, 1121979u},
    {13090025127289410428u, 14588158330007467535u, 18249120706540540660u, 10973451162843731247u, 2295705u},
    {18126719031689627733u, 3683488151163898538u, 670364419321852657u, 11211275369456016629u, 2521451u},
    {2814533577863520110u, 16521231923867160913u, 1618359513802089892u, 7900790322636819416u, 1276684u},
    {13827180283806299258u, 14749242773838985427u, 15350287634640521814u, 15443875795028368431u, 2094100u},
    {3401505594235253806u, 5717861828093731016u, 1243938327065883823u, 4578257766598090935u, 2455905u},
    {10371519970218710116u, 15973634535795827405u, 17701189675125161584u, 5593738196503052494u, 1522231u},
    {8199750947615523723u, 8643595018662391647u, 17875407660143553579u, 5648572546230184168u, 1055615u},
    {14804710409399950219u, 1138062790026277466u, 10317411699827702145u, 14935394631245024206u, 2840053u},
    {1439237307995858816u, 7459239970617210744u, 8129477430376576335u, 6825803585347391648u, 3486492u},
    {5754248275723534673u, 12830298131756701137u, 7012764410334781062u, 208429620540695219u, 2851940u},
    {8371952110583069936u, 13272978508169366764u, 3254563841644055692u, 12806803152215249511u, 3268829u},
    {4166784427963584961u, 16654098573697520163u, 2114498164371881513u, 2870545432269712576u, 478286u},
    {17573144703113357217u, 5767351400635577380u, 16121029348450440361u, 3899932900354692222u, 357343u},
    {17174680895874886642u, 13641229285076637546u, 12134425249599239669u, 1591858887601879084u, 1535586u},
    {10374375281720078624u, 828491786481695030u, 2392285570882166583u, 17466264320715590755u, 2826737u},
    {13084880450594737180u, 4308711806202094481u, 9628236511150587969u, 5744694040465256781u, 991172u},
    {5870485077147133106u, 11978623797532698296u, 2943929417814949882u, 14934205867812803636u, 1148613u},
    {16223447888912951550u, 16501280099792868971u, 426345652981058559u, 1390282471705572401u, 2527623u},
    {14707632950996224748u, 4808285216713511564u, 12725692431359439097u, 14890490787799259245u, 1606709u},
    {6400509233474005608u, 9451877781908948901u, 14142214600665009076u, 8676549849165768907u, 2452997u},
    {16154987392052677059u, 16719140461314746008u, 2788447830170198190u, 12295040802996876278u, 3005133u},
    {16352245132355430210u, 14288240820080117066u, 17954607191384781502u, 8053827869863500704u, 792339u},
    {11464523548439324360u, 4094342483482425921u, 5190370137855134648u, 5779223605840681702u, 2305752u},
    {6887516057370471448u, 2803167085961293357u, 16572129388412227125u, 17120183409809588383u, 2259379u},
    {15525602341192977333u, 12838009271951808466u, 15314391890493587314u, 4509249033650229254u, 2147876u},
    {11211019978836467299u, 7176322729627275675u, 9905843844587470397u, 4795422529886555786u, 3102723u},
    {5816026929460260623u, 10538906412247898449u, 96036600352163121u, 9785010337028306211u, 521069u},
    {284283239904566673u, 5261316916889475237u, 6996918556908303359u, 12907921369061854643u, 1881448u},
    {12261495390506568850u, 13162208182067745200u, 9789218742529290187u, 8609560293165338441u, 386183u},
    {6892320752469113902u, 13511747353066990032u, 17285709128999239636u, 6996710449255187460u, 1945635u},
    {4796015631985085415u, 13306919595609237875u, 13163294430616917799u, 1549100112699048988u, 640037u},
    {4539277738133890308u, 8691114843300476566u, 18201379885664739084u, 7721969162344094104u, 1497833u},
    {14027754629983306945u, 12613625278089698009u, 3131191530405611696u, 7233389553530919361u, 526953u},
    {8512881849378807702u, 5538130217827061457u, 16300011779981120224u, 2099390801463173166u, 2719642u},
    {3892933897700813984u, 10051173962345247255u, 15480777666396818456u, 16767530358844783545u, 3084075u},
    {9734252238239110230u, 12321325182620503583u, 4517584488468434351u, 8487629661434224656u, 2975275u},
    {17265605240063445957u, 3320946078815338772u, 11409662735262010772u, 11151753626802437991u, 698633u},
    {14042443526761112331u, 7194117224206963811u, 18014701397982592972u, 12190620907714022735u, 1512189u},
    {4666068269930980128u, 6936343164263880631u, 15913455661114028010u, 7161596785419565344u, 1u},
    {15947921396818761219u, 13559009362450750708u, 2381787532608848888u, 25608340859u, 0u},
    {16005030111229345462u, 3525671458430705192u, 11221908137935415479u, 25u, 0u},
    {7228461016072598814u, 12436903306429060496u, 472390509980u, 0u, 0u},
    {14797759988856335781u, 7203637671726338833u, 472u, 0u, 0u},
    {11708177716470569230u, 8714066840462u, 0u, 0u, 0u},
    {1232988907990686201u, 8714u, 0u, 0u, 0u},
    {160746160847214u, 0u, 0u, 0u, 0u},
    {160747u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1136166u},
    {6991255793763263475u, 13597421490314438860u, 7772429657359560185u, 16810377974264459374u, 3372078u},
    {10351468879509172097u, 9181574255585109552u, 12149715968774266710u, 4025371548759000811u, 3900510u},
    {16603558107575884811u, 4258796972680311085u, 17205738843344879362u, 1873391564700514791u, 2792978u},
    {11351205107612119191u, 494143747553281925u, 13906396040592771008u, 9058720606983884720u, 3490876u},
    {13379793695719558172u, 10351463929284648295u, 12745599562301282400u, 5036369293840803095u, 1291267u},
    {4795088117733788169u, 3661469744265942943u, 7883042084508529143u, 6292830358215926437u, 3864618u},
    {3328973799162074926u, 11799739189455292619u, 3007725488200319979u, 8213797751767338386u, 302753u},
    {16756678970639286532u, 6057728567114739910u, 11948642985618242571u, 8436323317759914051u, 1610339u},
    {8555316686834661274u, 7272491816255995703u, 7372644803533277685u, 16242664178375022283u, 1147136u},
    {8592946579250884653u, 9015422433139917986u, 10654729792240739908u, 2831407107931592562u, 2410369u},
    {3032980649520379116u, 2590058718787602277u, 2779903423954979634u, 10060469034169593430u, 2301201u},
    {4399788216945434713u, 4523532167035681206u, 1067775874641549242u, 16975984274882698488u, 871501u},
    {2568002643259308352u, 5438493183782342439u, 15229523146319323097u, 18174590070440806094u, 1624677u},
    {16206657197985976840u, 2644722855814756153u, 11651593085772735359u, 4641656037423420187u, 2336284u},
    {15040129130334599221u, 15474550345536894440u, 9427303220764701642u, 12797290982386403155u, 3414695u},
    {12816766659349529172u, 11809532559250361547u, 13683799836159668879u, 7917267767686211643u, 3123803u},
    {4629500181123344394u, 11422613814186484771u, 2821010612646505885u, 11082435890197928094u, 3003216u},
    {11036010560271486058u, 9814558559673694339u, 17781280551083101210u, 12809593712745750266u, 112930u},
    {13251076115287297558u, 10617155381871241720u, 7558463861488035539u, 6126978696841712292u, 669886u},
    {5725680331497253562u, 10756544164429872627u, 9879118157124063822u, 10316593169151234541u, 82098u},
    {3614574629770159735u, 13092516960301564047u, 16967405763943821573u, 5261718815880295903u, 1511089u},
    {947139352769244693u, 6576013491884290030u, 9632257546998895370u, 4063099943441280924u, 288158u},
    {3336257141723492977u, 180899883902741728u, 7670972500799438904u, 17299138150044596580u, 2113086u},
    {9241599784519099422u, 1461450678118168594u, 11633320286937090243u, 14306383193456608099u, 3151144u},
    {663832842512944879u, 7038058044185046710u, 14278827755088132161u, 2724259340617122236u, 2036000u},
    {2729389514075423102u, 8040595166532218694u, 13047349557557047589u, 6234510660920134483u, 1374144u},
    {1591415186896130763u, 1291563201268490990u, 294247477308232399u, 8456086991360502711u, 1008370u},
    {6653639316353485790u, 15800560390068166640u, 17036096301094592772u, 11115470633618595635u, 627014u},
    {14946535192845270460u, 16551549879292393674u, 7665549294572815565u, 13990739621262123138u, 366758u},
    {8911194296960550255u, 7911554372078984923u, 18330604598172134438u, 2240550920129491204u, 2343267u},
    {469303385082766042u, 14425111372654830750u, 296267198153373824u, 6024005954033938768u, 372048u},
    {2954938739113855871u, 6799558424366005904u, 5415379962633041613u, 1448014961021700165u, 872046u},
    {892784932338523260u, 9290098141273334560u, 12363496740780218832u, 17598139356084933464u, 3097072u},
    {5883979503880998705u, 11148354132479794759u, 9728846336125152119u, 705649258501342568u, 2930768u},
    {3160152297541380879u, 17923229454096004521u, 12393696924387679166u, 3368712453685751909u, 1316133u},
    {15677102863998819801u, 773541319798099953u, 18128959019126170080u, 18038676881468660026u, 1318519u},
    {14840924216292581336u, 6084211384410290200u, 13942726737948465482u, 1681647063460342853u, 3080512u},
    {11736110643387115925u, 15078578941710327311u, 13430156556259263850u, 4668511436589026125u, 1207520u},
    {10490199080353141452u, 15063260184130076098u, 6574021981731731942u, 3264866548779154314u, 1378325u},
    {903793698482556430u, 7358305986458703786u, 9412958713900764738u, 18255996903386030074u, 3897438u},
    {407831428677391660u, 4661751411538945299u, 15074492622291866501u, 5836502582619382190u, 969159u},
    {8557518713666124663u, 3218422720049413908u, 17598067206048594774u, 10682401751489569385u, 3365827u},
    {17918212472072698242u, 3316448735060521847u, 8791641080397579179u, 1070894876478774454u, 1126723u},
    {16317804306616532535u, 8285088198083091339u, 11145685515303170432u, 15008763931782867811u, 523577u},
    {2481110318682527800u, 10368935512470589716u, 12715677225105816127u, 17519653657147133005u, 3669057u},
    {2982198417180587094u, 3516303589857447200u, 8682497224854271894u, 13254221881931318491u, 1995996u},
    {5934782724593123833u, 2717823851115535729u, 2188669797602078095u, 9476364459606929468u, 321922u},
    {2639337440059190634u, 10843675286127371908u, 16274739942571801216u, 2455896619511611009u, 1172312u},
    {18125616145751005172u, 5156751013456843379u, 7114304170745640401u, 14793432119669662091u, 2489117u},
    {9823790018087455732u, 14450327238945305031u, 12164247224739509259u, 13448628610116547913u, 568004u},
    {2180192781971738402u, 17154374255707127860u, 5029364164331082584u, 6279488519169202362u, 453192u},
    {974111830031303551u, 99006053781214854u, 5260285240324122635u, 18094816026639653034u, 2043055u},
    {10262620979211233468u, 9857269659963007758u, 11372047205400759281u, 15530070448962834934u, 1930876u},
    {1511464496856711007u, 15219081873687983581u, 2747283751978851267u, 18266189682535906261u, 859170u},
    {9198715917323135308u, 13513541706813401599u, 18406622057608379692u, 15652346813602360829u, 2942115u},
    {14869107551238377464u, 12696871749567961337u, 1015837661929444957u, 1495424338851327511u, 301558u},
    {3475732452631200958u, 7655420588891086721u, 15081047793528546654u, 15281772700785526475u, 214654u},
    {14492779836205758685u, 17293019737562549241u, 16198221366860162021u, 12686096233359487486u, 621446u},
    {9591060098943060575u, 7742555486219856557u, 6881451307608311703u, 6784877507568952723u, 1154596u},
    {5494977174543801240u, 9496639288953421314u, 490311863369736796u, 93356137743334197u, 1890247u},
    {13281098536214363868u, 8840026199471960688u, 10271577813759167247u, 5150958079431336852u, 2314475u},
    {13492464252182612918u, 6377882063943961171u, 16745556789943808477u, 17985035448585013057u, 987532u},
    {16233202442567387968u, 5807499548244168992u, 9434859713207531580u, 14573850763715077061u, 905199u},
    {7861253255064868144u, 11923457021544882474u, 2367245681075786595u, 6862169422465782496u, 135269u},
    {8387240054755346517u, 231355294513387107u, 14818771268216933394u, 723071219865555399u, 817602u},
    {16928542863013726989u, 9919860034586519792u, 12652626036174033748u, 7797302251667441384u, 3188514u},
    {17853279277221478117u, 13999726172802949031u, 17132967121006535975u, 2436718312782364076u, 550443u},
    {13916264606597888283u, 943694839527000598u, 9270041652411441441u, 1163075388191730195u, 496488u},
    {6949671054259747607u, 16215667360930519876u, 1004513823795312764u, 11538373634303213056u, 3858083u},
    {12865762900619298446u, 4265073705746412750u, 6097113480168272934u, 2881415248733692706u, 1667447u},
    {6510050462053888712u, 4531602471668991532u, 8248222880894537536u, 16892235975822027043u, 2132450u},
    {9406539283792630443u, 3140304060734294211u, 3054158120114828415u, 12865588515043390517u, 3203577u},
    {2236752491132841113u, 2265850452755451631u, 5178387505386029400u, 3734032873839335475u, 2098311u},
    {8494398901002223394u, 10825615941673980932u, 14762118571412846202u, 10991461303503128708u, 2790646u},
    {1213667157844805495u, 8431617611298761156u, 16272106202813382035u, 16985012942466847528u, 1721433u},
    {9432935388674104789u, 5215332317752921054u, 624113430884404332u, 5652247185934430005u, 1310533u},
    {12565782135443338789u, 8026334411141221808u, 13694887390455934805u, 8094625604751326817u, 2596500u},
    {10579138379080492840u, 11952108082383889317u, 9634196112061083133u, 7686001947102373671u, 81467u},
    {11648300835367283428u, 11762961518257806602u, 2654013193728301423u, 8936644469288518907u, 169493u},
    {3815459807782685772u, 16620828965360108385u, 5913465279431734302u, 13694069470136237562u, 3875029u},
    {6744584773680202515u, 6988857401613116871u, 4154841818924337828u, 5980204393045362872u, 109772u},
    {12867125358484752279u, 3067453960134726495u, 17438711122631948530u, 17800250669338863829u, 1340170u},
    {8018953120172616636u, 919269771467890674u, 2362632232173779541u, 6654020442294884111u, 2068578u},
    {9078314855365005005u, 18147583725912275628u, 2907320481876007543u, 12287949522064275519u, 2531326u},
    {1904458026595897534u, 16302621898603477879u, 9559072068074727402u, 6603935792628518602u, 3037292u},
    {10339061649698629506u, 5893834102016404639u, 1390561215080136426u, 56028154805061224u, 3002882u},
    {14711600692188140844u, 16633255774656932071u, 10714210888249219073u, 16340409648365290776u, 3257735u},
    {7483557330778939968u, 323283799764290020u, 9205673060713049035u, 3446801539927988826u, 1552802u},
    {12966323924518462741u, 2150734724138067630u, 1778577113122868432u, 15593084456730380055u, 184100u},
    {17120744566951410948u, 3160608168194429682u, 3373644874316316740u, 219568843290838193u, 2809345u},
    {10441477895778431109u, 3077709165419839055u, 10615911456137205579u, 1565032743245811059u, 3665908u},
    {6647213973754538061u, 14823231156688841710u, 3529201332199831977u, 13974739717558888826u, 3734501u},
    {1953179896653671647u, 5591544778197197377u, 14358806170013007213u, 9796664593285023471u, 2745322u},
    {15952004064397754391u, 4976842661818690597u, 17461020606671913139u, 10066647833402572150u, 3770343u},
    {6643907547963804383u, 17462738431885069759u, 6845521035912244657u, 9797325757578021485u, 2066562u},
    {1425955146039895087u, 5158607813994133908u, 18164244683511948770u, 8180629476409635883u, 1170925u},
    {3299581583889376472u, 4893967287880447984u, 2501391113685462226u, 8452338264422706345u, 1731387u},
    {18042027529546333687u, 3723202616401342706u, 15983693062507404593u, 10192059220681724999u, 3623699u},
    {13842913471714027865u, 5540455992876196169u, 3008158220023452036u, 12821039602958461121u, 3252605u},
    {357545893972740301u, 13374192944813381584u, 1704862866142398021u, 9139256833607827595u, 830346u},
    {2328050233104839532u, 13534105286711656688u, 17597580143295186864u, 10751898700945147728u, 2517731u},
    {9868267555668565352u, 15746909024849760401u, 827355378769385011u, 12872695688906516132u, 1763147u},
    {12751128877565527986u, 16308145810609163650u, 13090025127289410427u, 14588158330007467535u, 463542u},
    {16347177623887082945u, 1677438806004276422u, 18126719031689627732u, 3683488151163898538u, 1086527u},
    {7192290603741528490u, 12474028723641485697u, 2814533577863520109u, 16521231923867160913u, 2683052u},
    {16373141170804317907u, 5499882535610850707u, 13827180283806299257u, 14749242773838985427u, 1372160u},
    {897011519099126245u, 6752693521337570192u, 3401505594235253805u, 5717861828093731016u, 2651213u},
    {2909627374884012727u, 5649717315432865761u, 10371519970218710115u, 15973634535795827405u, 3726474u},
    {16528688244621846128u, 9423200806454785457u, 8199750947615523722u, 8643595018662391647u, 3100757u},
    {14281294274133595824u, 4038867880312424352u, 14804710409399950218u, 1138062790026277466u, 2022459u},
    {2709059334155761090u, 695914086437635319u, 1439237307995858815u, 7459239970617210744u, 219355u},
    {14980890534190775663u, 15450107374672752387u, 5754248275723534672u, 12830298131756701137u, 779606u},
    {1748876551220584295u, 10538410922529119182u, 8371952110583069935u, 13272978508169366764u, 476742u},
    {4923387258724113137u, 6307253762228737122u, 4166784427963584960u, 16654098573697520163u, 148745u},
    {6979055011475834794u, 7855381572713281418u, 17573144703113357216u, 5767351400635577380u, 1211271u},
    {8704254286755618633u, 8188950062849579129u, 17174680895874886641u, 13641229285076637546u, 1943879u},
    {8829193624923450858u, 11111189715901017005u, 10374375281720078623u, 828491786481695030u, 3106985u},
    {16457521228413874992u, 2699999452441527042u, 13084880450594737179u, 4308711806202094481u, 924997u},
    {13283388894921099700u, 8580209834482433920u, 5870485077147133105u, 11978623797532698296u, 4936u},
    {15436516434969272432u, 14870404762556622783u, 16223447888912951549u, 16501280099792868971u, 2845163u},
    {17028739016830503413u, 6881484344399131112u, 14707632950996224747u, 4808285216713511564u, 668571u},
    {5660218595941472262u, 3107567050651677438u, 6400509233474005607u, 9451877781908948901u, 96420u},
    {9072671846420170139u, 18235845089706799903u, 16154987392052677058u, 16719140461314746008u, 1129586u},
    {12854324648591258230u, 10410663570149091657u, 16352245132355430209u, 14288240820080117066u, 3204750u},
    {8227681312874284623u, 12332107101976891613u, 11464523548439324359u, 4094342483482425921u, 3522492u},
    {8063322072929486195u, 18321878942403690227u, 6887516057370471447u, 2803167085961293357u, 637377u},
    {8386077338231705348u, 10940344652392962661u, 15525602341192977332u, 12838009271951808466u, 2310484u},
    {2913097528527992566u, 11869798989942168645u, 11211019978836467298u, 7176322729627275675u, 1002761u},
    {14028027031426863205u, 3653158417667915575u, 5816026929460260622u, 10538906412247898449u, 60311u},
    {13703774934474097226u, 2826539663663821504u, 284283239904566672u, 5261316916889475237u, 2587235u},
    {7846527142954422006u, 5096168060978878258u, 12261495390506568849u, 13162208182067745200u, 2004541u},
    {11919551442035136136u, 55962722696064044u, 6892320752469113901u, 13511747353066990032u, 2619556u},
    {13331071399523915817u, 15853854028585693036u, 4796015631985085414u, 13306919595609237875u, 2396279u},
    {9581829992682910458u, 12900059723294620724u, 4539277738133890307u, 8691114843300476566u, 192246u},
    {4061075583619999142u, 12707798548679332691u, 14027754629983306944u, 12613625278089698009u, 3347640u},
    {12246991494181454469u, 11433353380357255945u, 8512881849378807701u, 5538130217827061457u, 1906482u},
    {986790600894612092u, 692306408753393221u, 3892933897700813983u, 10051173962345247255u, 3877876u},
    {1495697520465502937u, 3205592525961357996u, 9734252238239110229u, 12321325182620503583u, 341347u},
    {3202277665301447576u, 17827331722796310523u, 17265605240063445956u, 3320946078815338772u, 3275126u},
    {12159583588777743801u, 11742182060143991602u, 14042443526761112330u, 7194117224206963811u, 1019916u},
    {12829202012477440861u, 8578448087231856897u, 4666068269930980127u, 6936343164263880631u, 660370u},
    {15503241130181536275u, 16368322550597029127u, 15947921396818761218u, 13559009362450750708u, 3627032u},
    {202414939185691249u, 11565812258980899491u, 16005030111229345461u, 3525671458430705192u, 2330879u},
    {9099955995846676585u, 3373643076322632662u, 7228461016072598813u, 12436903306429060496u, 3791230u},
    {1427938966693862481u, 12718868245804108409u, 14797759988856335780u, 7203637671726338833u, 472u},
    {1477337919251945955u, 3151573480024094330u, 11708177716470569229u, 8714066840462u, 0u},
    {9844124640641622714u, 5476023359929506940u, 1232988907990686200u, 8714u, 0u},
    {5221050680701069529u, 432908638119696886u, 160746160847213u, 0u, 0u},
    {607692829235207369u, 2967107373613356587u, 160746u, 0u, 0u},
    {3641795378077100995u, 2965243289979889u, 0u, 0u, 0u},
    {5349184802547498974u, 2965243u, 0u, 0u, 0u},
    {54699084086543535u, 0u, 0u, 0u, 0u},
    {54699085u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2742696u},
    {7043107377745172179u, 8993255840511020866u, 6991255793763263474u, 13597421490314438860u, 1640387u},
    {16436155266857670583u, 1754925583102856362u, 10351468879509172096u, 9181574255585109552u, 401096u},
    {8996942438750306988u, 3873150403559846802u, 16603558107575884810u, 4258796972680311085u, 3350086u},
    {8037220170642121263u, 14095773013592263660u, 11351205107612119190u, 494143747553281925u, 2560234u},
    {5790159296879570868u, 12696906762070444545u, 13379793695719558171u, 10351463929284648295u, 3176172u},
    {2827526400588069182u, 2676241154464950609u, 4795088117733788168u, 3661469744265942943u, 2946393u},
    {16254703329605467463u, 10324868891600797167u, 3328973799162074925u, 11799739189455292619u, 265123u},
    {8452214015228699691u, 4653123263559679814u, 16756678970639286531u, 6057728567114739910u, 3617571u},
    {16452069717101024219u, 12628169996798248273u, 8555316686834661273u, 7272491816255995703u, 445779u},
    {13349078469985146776u, 2250715757281066270u, 8592946579250884652u, 9015422433139917986u, 3688614u},
    {632311271708197567u, 15794323860450647250u, 3032980649520379115u, 2590058718787602277u, 3033670u},
    {2432032057859399776u, 18054423661824888413u, 4399788216945434712u, 4523532167035681206u, 1852556u},
    {15359517592978683449u, 1210939189104233791u, 2568002643259308351u, 5438493183782342439u, 2745713u},
    {4806761071789402880u, 5508712501120500019u, 16206657197985976839u, 2644722855814756153u, 2939555u},
    {13071582205671129828u, 15119175889856205829u, 15040129130334599220u, 15474550345536894440u, 3477292u},
    {136646501853618629u, 7531278264895206606u, 12816766659349529171u, 11809532559250361547u, 2033635u},
    {3651280896322940930u, 5754677334635986040u, 4629500181123344393u, 11422613814186484771u, 798285u},
    {10931449488602813354u, 7894049655534759026u, 11036010560271486057u, 9814558559673694339u, 1338396u},
    {18164131443036008721u, 6250724560920720324u, 13251076115287297557u, 10617155381871241720u, 1082177u},
    {1370986903933236680u, 7539862946443546007u, 5725680331497253561u, 10756544164429872627u, 2715516u},
    {3991134431659037035u, 2940781589530862225u, 3614574629770159734u, 13092516960301564047u, 1017655u},
    {3929039926715467156u, 16155019578161358038u, 947139352769244692u, 6576013491884290030u, 1994102u},
    {3263291417456716894u, 10501098398848233896u, 3336257141723492976u, 180899883902741728u, 1100400u},
    {7070221586039622613u, 10011192346628904764u, 9241599784519099421u, 1461450678118168594u, 2627641u},
    {15032072819318620216u, 4993581979680585161u, 663832842512944878u, 7038058044185046710u, 2287787u},
    {8417598366710359881u, 14964295974633797711u, 2729389514075423101u, 8040595166532218694u, 3609531u},
    {521105162362079800u, 9841702135463100862u, 1591415186896130762u, 1291563201268490990u, 1081345u},
    {8961775328572208109u, 6437155936213275808u, 6653639316353485789u, 15800560390068166640u, 2730066u},
    {5169143091521803731u, 16594914641918162298u, 14946535192845270459u, 16551549879292393674u, 3104971u},
    {11595796766190748255u, 606813392085357226u, 8911194296960550254u, 7911554372078984923u, 736854u},
    {13385229822315463520u, 7360901059958546453u, 469303385082766041u, 14425111372654830750u, 1417300u},
    {2187627229223252777u, 891841810060229032u, 2954938739113855870u, 6799558424366005904u, 3617229u},
    {1374953159293508904u, 9580725278528082698u, 892784932338523259u, 9290098141273334560u, 2790988u},
    {7312655520063282555u, 928438418528350072u, 5883979503880998704u, 11148354132479794759u, 2870215u},
    {8666418354787074217u, 9628504743792316627u, 3160152297541380878u, 17923229454096004521u, 2871258u},
    {17292922727146463370u, 15660703954793317413u, 15677102863998819800u, 773541319798099953u, 1700760u},
    {1047346027859214849u, 12827873370789908222u, 14840924216292581335u, 6084211384410290200u, 1005152u},
    {8883342724776087755u, 239177674135748139u, 11736110643387115924u, 15078578941710327311u, 174720u},
    {9266634438297682523u, 12943947869138720808u, 10490199080353141451u, 15063260184130076098u, 457066u},
    {12526398963868966452u, 4231017452693019200u, 903793698482556429u, 7358305986458703786u, 2714050u},
    {13693381170364369733u, 7495491441376843122u, 407831428677391659u, 4661751411538945299u, 2596045u},
    {10430817150015989488u, 511645597291998321u, 8557518713666124662u, 3218422720049413908u, 97546u},
    {8814506919314336535u, 16511440186026808518u, 17918212472072698241u, 3316448735060521847u, 3823031u},
    {8922745125458644838u, 11542056376085197302u, 16317804306616532534u, 8285088198083091339u, 3507370u},
    {16817810803563800585u, 5423657802707955362u, 2481110318682527799u, 10368935512470589716u, 3119199u},
    {17542952247209412442u, 10120854084552250867u, 2982198417180587093u, 3516303589857447200u, 2802276u},
    {15392288876125847163u, 1869322016139152189u, 5934782724593123832u, 2717823851115535729u, 1899315u},
    {1458074293528026159u, 6499978418112737970u, 2639337440059190633u, 10843675286127371908u, 2204282u},
    {8550981170169900789u, 16569761178270908499u, 18125616145751005171u, 5156751013456843379u, 2103809u},
    {15958011253203159180u, 13916067667874639260u, 9823790018087455731u, 14450327238945305031u, 252991u},
    {15031470136184033644u, 570017742789658104u, 2180192781971738401u, 17154374255707127860u, 1460878u},
    {10841353831039574068u, 17870809589137824730u, 974111830031303550u, 99006053781214854u, 3113659u},
    {8416795873812202306u, 11881273351301826839u, 10262620979211233467u, 9857269659963007758u, 809331u},
    {8007136426616573992u, 8606629713247932408u, 1511464496856711006u, 15219081873687983581u, 2101813u},
    {2173072355389376997u, 6672143621283919841u, 9198715917323135307u, 13513541706813401599u, 798796u},
    {18376965816882675809u, 10861005120695226263u, 14869107551238377463u, 12696871749567961337u, 938681u},
    {609910602197384236u, 4242337774726254235u, 3475732452631200957u, 7655420588891086721u, 3862728u},
    {1434544460555451372u, 7635182288578404523u, 14492779836205758684u, 17293019737562549241u, 1756023u},
    {4724494703614717619u, 4104061660453435331u, 9591060098943060574u, 7742555486219856557u, 3095097u},
    {4538098622181177865u, 4121702093812562410u, 5494977174543801239u, 9496639288953421314u, 2656280u},
    {8348529632780488685u, 6413717884854845958u, 13281098536214363867u, 8840026199471960688u, 1995679u},
    {1138591012247762754u, 10026438115349843352u, 13492464252182612917u, 6377882063943961171u, 2325181u},
    {388790515211865237u, 3475159787065507282u, 16233202442567387967u, 5807499548244168992u, 1840650u},
    {17814144456235862808u, 15395015069471220089u, 7861253255064868143u, 11923457021544882474u, 823045u},
    {9789680475350681038u, 11426829120153738798u, 8387240054755346516u, 231355294513387107u, 2600440u},
    {16544528489084737694u, 17697844423610517371u, 16928542863013726988u, 9919860034586519792u, 1114176u},
    {17603374206661428364u, 193895884478918070u, 17853279277221478116u, 13999726172802949031u, 376549u},
    {10885950645190590203u, 18238435249468750516u, 13916264606597888282u, 943694839527000598u, 146839u},
    {12744867666262968505u, 17408971480387348158u, 6949671054259747606u, 16215667360930519876u, 741358u},
    {3084879977827871668u, 12991386455705669783u, 12865762900619298445u, 4265073705746412750u, 3471162u},
    {8287680408115736544u, 18425241030728864100u, 6510050462053888711u, 4531602471668991532u, 2267474u},
    {11931471617816256071u, 3279583319617657167u, 9406539283792630442u, 3140304060734294211u, 1738249u},
    {11090030529427742609u, 11479518819837204746u, 2236752491132841112u, 2265850452755451631u, 920316u},
    {12664088451831070578u, 241041845403250454u, 8494398901002223393u, 10825615941673980932u, 47656u},
    {6159963873176729293u, 6293229245814448884u, 1213667157844805494u, 8431617611298761156u, 1473731u},
    {12166832295159426398u, 16969084727663289484u, 9432935388674104788u, 5215332317752921054u, 1514710u},
    {9539211224306583165u, 15398342377533952243u, 12565782135443338788u, 8026334411141221808u, 3393827u},
    {9883010846379477597u, 5631101589382345812u, 10579138379080492839u, 11952108082383889317u, 952671u},
    {17741790764556284017u, 1825823445425460001u, 11648300835367283427u, 11762961518257806602u, 2579443u},
    {13284560614942187193u, 1744163026019802940u, 3815459807782685771u, 16620828965360108385u, 3866718u},
    {883834508656604967u, 6628050528082761876u, 6744584773680202514u, 6988857401613116871u, 2224512u},
    {11420479385844250010u, 16556423610584622318u, 12867125358484752278u, 3067453960134726495u, 2958714u},
    {8734644564188716545u, 13278810929649741434u, 8018953120172616635u, 919269771467890674u, 3313735u},
    {8785473974502178034u, 3870015852097007053u, 9078314855365005004u, 18147583725912275628u, 954403u},
    {3762563452693847518u, 14168217694104699766u, 1904458026595897533u, 16302621898603477879u, 3099136u},
    {15939882729123047475u, 11796729982601296329u, 10339061649698629505u, 5893834102016404639u, 3253102u},
    {8147450670599128866u, 644024565261029096u, 14711600692188140843u, 16633255774656932071u, 1900249u},
    {5522915781570748981u, 15116555635676311894u, 7483557330778939967u, 323283799764290020u, 3310313u},
    {10826654828663789436u, 17195280354078664956u, 12966323924518462740u, 2150734724138067630u, 3368162u},
    {3228903852602349840u, 2514599147493970599u, 17120744566951410947u, 3160608168194429682u, 2780448u},
    {15299828246491144383u, 355825649972576265u, 10441477895778431108u, 3077709165419839055u, 2787721u},
    {12005341925066223062u, 17006528623822976337u, 6647213973754538060u, 14823231156688841710u, 2336999u},
    {4160666107756327160u, 12132459823690661487u, 1953179896653671646u, 5591544778197197377u, 263931u},
    {10533948846762432386u, 18313492443605580154u, 15952004064397754390u, 4976842661818690597u, 1344447u},
    {1762441378474989000u, 1669319196904418691u, 6643907547963804382u, 17462738431885069759u, 2304939u},
    {61841807379093039u, 5168152530966077543u, 1425955146039895086u, 5158607813994133908u, 3583748u},
    {2831589511602915106u, 4624737131921178090u, 3299581583889376471u, 4893967287880447984u, 2616468u},
    {14028403142010274052u, 7975929844514091916u, 18042027529546333686u, 3723202616401342706u, 3473721u},
    {18326368826267294952u, 7850830209216651142u, 13842913471714027864u, 5540455992876196169u, 2360202u},
    {2253388271920431919u, 10622761972620812209u, 357545893972740300u, 13374192944813381584u, 3216567u},
    {7465606607195160046u, 17394755710812199500u, 2328050233104839531u, 13534105286711656688u, 2079148u},
    {6147228641698127995u, 7835564966065416070u, 9868267555668565351u, 15746909024849760401u, 1253855u},
    {6265274705263198826u, 3432685381881666794u, 12751128877565527985u, 16308145810609163650u, 1090389u},
    {9639742690086297511u, 2818344642048370779u, 16347177623887082944u, 1677438806004276422u, 437202u},
    {17853786536947960883u, 11305400850614449001u, 7192290603741528489u, 12474028723641485697u, 1274229u},
    {17025223992164528160u, 76226846205148250u, 16373141170804317906u, 5499882535610850707u, 2782999u},
    {10391767462179125444u, 14844961252185492579u, 897011519099126244u, 6752693521337570192u, 1584289u},
    {16670569428792051418u, 5636795582215684761u, 2909627374884012726u, 5649717315432865761u, 3020239u},
    {4028955917013410696u, 5760742677533171279u, 16528688244621846127u, 9423200806454785457u, 197466u},
    {1152542225130903351u, 3926668673321376333u, 14281294274133595823u, 4038867880312424352u, 2569328u},
    {13128671370043668038u, 3260835067460234549u, 2709059334155761089u, 695914086437635319u, 1614499u},
    {9448384345836655940u, 11038294376499610628u, 14980890534190775662u, 15450107374672752387u, 975900u},
    {11900590293658044323u, 2110186780683960578u, 1748876551220584294u, 10538410922529119182u, 2073161u},
    {17480373212548634470u, 16521177412165121730u, 4923387258724113136u, 6307253762228737122u, 59838u},
    {12844283190309179876u, 9509414940828428190u, 6979055011475834793u, 7855381572713281418u, 2517622u},
    {4360470854884776790u, 6323247125205135469u, 8704254286755618632u, 8188950062849579129u, 776301u},
    {12772973875324699610u, 18058354376814758077u, 8829193624923450857u, 11111189715901017005u, 1836013u},
    {2088649526183053449u, 1561440626611123132u, 16457521228413874991u, 2699999452441527042u, 290357u},
    {2883145156496457007u, 2700689203546182101u, 13283388894921099699u, 8580209834482433920u, 1438757u},
    {4546079751737271345u, 1477853728382485258u, 15436516434969272431u, 14870404762556622783u, 1952263u},
    {17780253069163264728u, 17544046880109533364u, 17028739016830503412u, 6881484344399131112u, 492797u},
    {13349472253959071606u, 11932513204030000478u, 5660218595941472261u, 3107567050651677438u, 285893u},
    {13381823595882440391u, 8539039846888920483u, 9072671846420170138u, 18235845089706799903u, 1863202u},
    {7063355183058341959u, 16670424048149278897u, 12854324648591258229u, 10410663570149091657u, 556115u},
    {924340398028029106u, 12203985542420607580u, 8227681312874284622u, 12332107101976891613u, 1043547u},
    {196593814706658510u, 5452039668653788866u, 8063322072929486194u, 18321878942403690227u, 3233521u},
    {16358677754309956185u, 13579747780949921849u, 8386077338231705347u, 10940344652392962661u, 2838092u},
    {1551213454849076755u, 2942209115307635147u, 2913097528527992565u, 11869798989942168645u, 2725614u},
    {8206688058265064569u, 584888500763844212u, 14028027031426863204u, 3653158417667915575u, 883272u},
    {11132329444819553189u, 12706973911563834430u, 13703774934474097225u, 2826539663663821504u, 2826324u},
    {8152061853747912980u, 15643123675813963241u, 7846527142954422005u, 5096168060978878258u, 3033745u},
    {17677007365611713344u, 8285717650211049397u, 11919551442035136135u, 55962722696064044u, 64149u},
    {4769352663545400021u, 5377635109895839045u, 13331071399523915816u, 15853854028585693036u, 94888u},
    {11084533503212122651u, 13766785185103473874u, 9581829992682910457u, 12900059723294620724u, 1391139u},
    {711400061346203816u, 7764028452026111756u, 4061075583619999141u, 12707798548679332691u, 2615828u},
    {16648179074749664617u, 6589239064186888321u, 12246991494181454468u, 11433353380357255945u, 2373755u},
    {355266026784447993u, 1227609942980318285u, 986790600894612091u, 692306408753393221u, 1900519u},
    {9261005996111323714u, 14881964112229907803u, 1495697520465502936u, 3205592525961357996u, 1577839u},
    {6625448806815448851u, 1426819808512918638u, 3202277665301447575u, 17827331722796310523u, 3732464u},
    {17289341308190327186u, 6231500649051955542u, 12159583588777743800u, 11742182060143991602u, 194852u},
    {5662048181172793214u, 3798131927107222812u, 12829202012477440860u, 8578448087231856897u, 609793u},
    {277718172661963211u, 7248187287895338970u, 15503241130181536274u, 16368322550597029127u, 1983938u},
    {15635480826826832235u, 17396187875754019477u, 202414939185691248u, 11565812258980899491u, 3198057u},
    {4222242302335200378u, 3369476682089776166u, 9099955995846676584u, 3373643076322632662u, 1991229u},
    {11140006569890215727u, 8715677060478803468u, 1427938966693862480u, 12718868245804108409u, 2878390u},
    {12525746762658868509u, 16820428654595208936u, 1477337919251945954u, 3151573480024094330u, 3887071u},
    {14912028719253096819u, 9451532636892729159u, 9844124640641622713u, 5476023359929506940u, 30524u},
    {17991580104889018815u, 16386624562389820903u, 5221050680701069528u, 432908638119696886u, 690963u},
    {2166810193822886273u, 5253806718269208091u, 607692829235207368u, 2967107373613356587u, 160746u},
    {16328243746058300261u, 11879853271432541659u, 3641795378077100994u, 2965243289979889u, 0u},
    {1104154730624396245u, 17054967092059930480u, 5349184802547498973u, 2965243u, 0u},
    {13887532697596060761u, 9407501199807270656u, 54699084086543534u, 0u, 0u},
    {3898195486334353081u, 1596446432339882286u, 54699084u, 0u, 0u},
    {14495488943909630777u, 1009020005210787387u, 0u, 0u, 0u},
    {3888340996450460726u, 1009020005u, 0u, 0u, 0u},
    {166389727666921521u, 1u, 0u, 0u, 0u},
    {18613133802u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3150376u},
    {11054191020964991431u, 17227551829361163832u, 7043107377745172178u, 8993255840511020866u, 1384706u},
    {3499586284066135649u, 693294514393899922u, 16436155266857670582u, 1754925583102856362u, 2932654u},
    {15514624698853527079u, 2396892412412515923u, 8996942438750306987u, 3873150403559846802u, 2414636u},
    {9536348422101344362u, 15847764502453474171u, 8037220170642121262u, 14095773013592263660u, 800694u},
    {7872560272381714762u, 18386723660110270318u, 5790159296879570867u, 12696906762070444545u, 548073u},
    {4515731929693126529u, 10699662677617465670u, 2827526400588069181u, 2676241154464950609u, 1118514u},
    {14409589540925626143u, 15360598432875080858u, 16254703329605467462u, 10324868891600797167u, 2246317u},
    {5522007654622139130u, 14605152192559090393u, 8452214015228699690u, 4653123263559679814u, 980717u},
    {6785912418087631472u, 13456402971771388803u, 16452069717101024218u, 12628169996798248273u, 917795u},
    {13330076579929125710u, 14953722235606592093u, 13349078469985146775u, 2250715757281066270u, 743262u},
    {8085694289244476406u, 8300086076735077359u, 632311271708197566u, 15794323860450647250u, 2169767u},
    {2681331049265532371u, 1068146143208779393u, 2432032057859399775u, 18054423661824888413u, 3145144u},
    {3064043761590525680u, 17981791068048005233u, 15359517592978683448u, 1210939189104233791u, 1752903u},
    {4359039137956744542u, 18269590268470638941u, 4806761071789402879u, 5508712501120500019u, 3205917u},
    {8562327451755955125u, 3048670076200314621u, 13071582205671129827u, 15119175889856205829u, 2021412u},
    {14902593814438529505u, 2257795940118449402u, 136646501853618628u, 7531278264895206606u, 3367933u},
    {7397043927491898591u, 9378958740819033526u, 3651280896322940929u, 5754677334635986040u, 2156039u},
    {14709027423788072860u, 11395740927030724204u, 10931449488602813353u, 7894049655534759026u, 2914957u},
    {6984674821843530574u, 605915805213044952u, 18164131443036008720u, 6250724560920720324u, 2486789u},
    {11770851905153717792u, 11302450845089752533u, 1370986903933236679u, 7539862946443546007u, 3170089u},
    {10645611091427966463u, 12115334063702736571u, 3991134431659037034u, 2940781589530862225u, 765366u},
    {18097972434937483975u, 3880743573396340050u, 3929039926715467155u, 16155019578161358038u, 2859434u},
    {1458339136138375966u, 5339086649252128939u, 3263291417456716893u, 10501098398848233896u, 3645324u},
    {12868244037546112684u, 14150950676123806958u, 7070221586039622612u, 10011192346628904764u, 1171371u},
    {6305553694177993092u, 4931689302083536540u, 15032072819318620215u, 4993581979680585161u, 2622360u},
    {4220854046386518085u, 2315925100565613283u, 8417598366710359880u, 14964295974633797711u, 2269741u},
    {1347285904461502819u, 14865562393739268924u, 521105162362079799u, 9841702135463100862u, 1302672u},
    {12835379041492177409u, 16952248337579315703u, 8961775328572208108u, 6437155936213275808u, 1174625u},
    {50519723448421843u, 3206373153090267092u, 5169143091521803730u, 16594914641918162298u, 1645419u},
    {16829039954998540693u, 10029446093571389920u, 11595796766190748254u, 606813392085357226u, 597746u},
    {4747857243677405155u, 2975527085947689514u, 13385229822315463519u, 7360901059958546453u, 1471841u},
    {8140793912000432331u, 3141334106920550693u, 2187627229223252776u, 891841810060229032u, 3747158u},
    {10115767766525943043u, 16823624953260005784u, 1374953159293508903u, 9580725278528082698u, 3455747u},
    {15676866439035642535u, 8771177848167753888u, 7312655520063282554u, 928438418528350072u, 2431038u},
    {16114190785049803032u, 13026541587840765160u, 8666418354787074216u, 9628504743792316627u, 1312212u},
    {10929014825995898761u, 2761369134005708052u, 17292922727146463369u, 15660703954793317413u, 87908u},
    {645769829296871675u, 8747940876424215769u, 1047346027859214848u, 12827873370789908222u, 1247097u},
    {10549034037148693568u, 8727981634450242292u, 8883342724776087754u, 239177674135748139u, 2474070u},
    {5346601730328840159u, 1650546378596951440u, 9266634438297682522u, 12943947869138720808u, 2801415u},
    {17943724979998508222u, 16286971424626632389u, 12526398963868966451u, 4231017452693019200u, 81405u},
    {6893940917236593327u, 7407646693094730755u, 13693381170364369732u, 7495491441376843122u, 392613u},
    {16669594846911322650u, 6683797940949313188u, 10430817150015989487u, 511645597291998321u, 555716u},
    {18126750118032961653u, 17493208248944144411u, 8814506919314336534u, 16511440186026808518u, 696129u},
    {12644231221401972561u, 15798814440389979152u, 8922745125458644837u, 11542056376085197302u, 1048328u},
    {16700120469414555299u, 6471679300405496644u, 16817810803563800584u, 5423657802707955362u, 1777599u},
    {7358114105063709345u, 11856455127319415867u, 17542952247209412441u, 10120854084552250867u, 3679899u},
    {15279076180046265454u, 16516964831200997395u, 15392288876125847162u, 1869322016139152189u, 802036u},
    {12349073721068027468u, 17414814816892618567u, 1458074293528026158u, 6499978418112737970u, 3717303u},
    {10400527096840560965u, 1403960421322187729u, 8550981170169900788u, 16569761178270908499u, 485289u},
    {3608416041362045977u, 18313115049386820802u, 15958011253203159179u, 13916067667874639260u, 3556973u},
    {18263944849434433991u, 17717839944756197432u, 15031470136184033643u, 570017742789658104u, 28529u},
    {18071609776324965717u, 4968776835098756262u, 10841353831039574067u, 17870809589137824730u, 3460118u},
    {9022065356287651715u, 4105314689771724746u, 8416795873812202305u, 11881273351301826839u, 1722581u},
    {9414697727806124860u, 11712060376470758316u, 8007136426616573991u, 8606629713247932408u, 2322630u},
    {18359680985119562374u, 6378784481536081219u, 2173072355389376996u, 6672143621283919841u, 2838767u},
    {14632777984142728149u, 13202423358091240673u, 18376965816882675808u, 10861005120695226263u, 3415091u},
    {9056039145684484499u, 5708332275451921393u, 609910602197384235u, 4242337774726254235u, 3747811u},
    {8778472900492021703u, 11318937129645956925u, 1434544460555451371u, 7635182288578404523u, 3731628u},
    {11221387540320852617u, 17172828670494981965u, 4724494703614717618u, 4104061660453435331u, 781668u},
    {3436538356702165083u, 14566492172224426806u, 4538098622181177864u, 4121702093812562410u, 32093u},
    {1999540693370900644u, 9367069088702461004u, 8348529632780488684u, 6413717884854845958u, 565549u},
    {9022101458940478955u, 17177352714080447118u, 1138591012247762753u, 10026438115349843352u, 888789u},
    {6463175067909642455u, 16564924747800061330u, 388790515211865236u, 3475159787065507282u, 2534189u},
    {1167801429603127265u, 667811480491575665u, 17814144456235862807u, 15395015069471220089u, 2262147u},
    {4870107803936103823u, 2177318327367218146u, 9789680475350681037u, 11426829120153738798u, 2370818u},
    {9619289971879869586u, 8507077827759995720u, 16544528489084737693u, 17697844423610517371u, 2698616u},
    {5659677287273924284u, 7454798955865700u, 17603374206661428363u, 193895884478918070u, 426306u},
    {13001309574782922464u, 5801335340980582796u, 10885950645190590202u, 18238435249468750516u, 2335984u},
    {14266899815036899748u, 18244876968787193790u, 12744867666262968504u, 17408971480387348158u, 1139470u},
    {11127065377310426746u, 11700034718340996380u, 3084879977827871667u, 12991386455705669783u, 2740567u},
    {15844763170582622372u, 12603305268573325149u, 8287680408115736543u, 18425241030728864100u, 2005317u},
    {8733173237858937182u, 11205173926016050563u, 11931471617816256070u, 3279583319617657167u, 1212212u},
    {1308811018350451935u, 17350797452308354919u, 11090030529427742608u, 11479518819837204746u, 1348154u},
    {11812808041196070458u, 4098209256144225402u, 12664088451831070577u, 241041845403250454u, 1312891u},
    {2493468433668552143u, 483001010081714028u, 6159963873176729292u, 6293229245814448884u, 1927176u},
    {4702567594948801186u, 11976624074415677016u, 12166832295159426397u, 16969084727663289484u, 2714562u},
    {12713585007396602144u, 624511083050919160u, 9539211224306583164u, 15398342377533952243u, 575128u},
    {16009166974820979177u, 2072016140243558974u, 9883010846379477596u, 5631101589382345812u, 1321837u},
    {1403545146813952539u, 8877946794904780791u, 17741790764556284016u, 1825823445425460001u, 801267u},
    {5444765608602994805u, 5495476619426483621u, 13284560614942187192u, 1744163026019802940u, 3838589u},
    {5128384435124866471u, 1206671928132203666u, 883834508656604966u, 6628050528082761876u, 2994272u},
    {1706543163733554367u, 10484697937146273295u, 11420479385844250009u, 16556423610584622318u, 1095782u},
    {1315576022671461512u, 11372316071920046295u, 8734644564188716544u, 13278810929649741434u, 2762729u},
    {9158854310964879716u, 13525103181368089185u, 8785473974502178033u, 3870015852097007053u, 2435620u},
    {17157228146191298537u, 16753119017483607001u, 3762563452693847517u, 14168217694104699766u, 2783263u},
    {10638669291871500620u, 6929156045630604077u, 15939882729123047474u, 11796729982601296329u, 3662641u},
    {7166291148192979484u, 15408204402704198309u, 8147450670599128865u, 644024565261029096u, 3063873u},
    {1548127010225253362u, 15260568754234643695u, 5522915781570748980u, 15116555635676311894u, 2470515u},
    {13855616565718814470u, 14825454979210019206u, 10826654828663789435u, 17195280354078664956u, 3504192u},
    {12857235531142290243u, 13919578893184299232u, 3228903852602349839u, 2514599147493970599u, 3664347u},
    {2766829222508267434u, 13345242688383456935u, 15299828246491144382u, 355825649972576265u, 50764u},
    {17344046249133681773u, 9066408815557288363u, 12005341925066223061u, 17006528623822976337u, 1451964u},
    {1644515353365325234u, 5401819788281343413u, 4160666107756327159u, 12132459823690661487u, 588914u},
    {15375589428645850634u, 8255636202367354017u, 10533948846762432385u, 18313492443605580154u, 650224u},
    {3268230046566912138u, 3254510974518412233u, 1762441378474988999u, 1669319196904418691u, 2822360u},
    {11159602674292913644u, 9215989929832149325u, 61841807379093038u, 5168152530966077543u, 707502u},
    {7734297979569284151u, 6227536654453870292u, 2831589511602915105u, 4624737131921178090u, 2688523u},
    {18194422506240902339u, 2850539083192280678u, 14028403142010274051u, 7975929844514091916u, 3719358u},
    {14872273445792246307u, 3784820956116857244u, 18326368826267294951u, 7850830209216651142u, 1642330u},
    {6491750371602075697u, 16642152655661413116u, 2253388271920431918u, 10622761972620812209u, 1565346u},
    {1816283472780716932u, 14364764407674790427u, 7465606607195160045u, 17394755710812199500u, 2891827u},
    {14114455006936278300u, 10417285117296989387u, 6147228641698127994u, 7835564966065416070u, 2492497u},
    {5253022563353209217u, 11592722510858542141u, 6265274705263198825u, 3432685381881666794u, 439019u},
    {14928478282413453860u, 2668129566589234056u, 9639742690086297510u, 2818344642048370779u, 3492008u},
    {2562061068202321013u, 792657001343798621u, 17853786536947960882u, 11305400850614449001u, 226015u},
    {3686191269674130454u, 16036203580925636164u, 17025223992164528159u, 76226846205148250u, 59462u},
    {1028683793761248839u, 15886277554582899847u, 10391767462179125443u, 14844961252185492579u, 883800u},
    {15099315973132468830u, 11979240114829766680u, 16670569428792051417u, 5636795582215684761u, 3696736u},
    {1238441067953738200u, 8322853820059618663u, 4028955917013410695u, 5760742677533171279u, 1927635u},
    {3187689002153265703u, 17019595475188337037u, 1152542225130903350u, 3926668673321376333u, 988973u},
    {13665667012536991499u, 17404174071330746888u, 13128671370043668037u, 3260835067460234549u, 730887u},
    {10467729933429995533u, 14611494314342415891u, 9448384345836655939u, 11038294376499610628u, 1112204u},
    {4534218318415020144u, 2933766705659631472u, 11900590293658044322u, 2110186780683960578u, 1083572u},
    {7638462913176585795u, 8892053795722948146u, 17480373212548634469u, 16521177412165121730u, 3787666u},
    {13622545409978971972u, 5894691111888757008u, 12844283190309179875u, 9509414940828428190u, 2940163u},
    {7394777596128442378u, 3002064512497140872u, 4360470854884776789u, 6323247125205135469u, 2382852u},
    {6869090689003397374u, 11381589537831171841u, 12772973875324699609u, 18058354376814758077u, 2614615u},
    {12307577946331673078u, 13007379979704378832u, 2088649526183053448u, 1561440626611123132u, 1873405u},
    {3838433051469967431u, 4636818613430552725u, 2883145156496457006u, 2700689203546182101u, 1989611u},
    {11072601557918517342u, 15762112637950584403u, 4546079751737271344u, 1477853728382485258u, 1845937u},
    {1746823793631772919u, 11027510551542606111u, 17780253069163264727u, 17544046880109533364u, 2331586u},
    {4526941364304940765u, 12382011116229833192u, 13349472253959071605u, 11932513204030000478u, 1964777u},
    {8238999027672164729u, 14842791982728440827u, 13381823595882440390u, 8539039846888920483u, 1361748u},
    {15815620835386213009u, 9304095114444585230u, 7063355183058341958u, 16670424048149278897u, 1423131u},
    {3887296524674395109u, 3633607301354297305u, 924340398028029105u, 12203985542420607580u, 2586912u},
    {6702340696805576231u, 10199984306051941134u, 196593814706658509u, 5452039668653788866u, 1784602u},
    {9642444548234351593u, 14767844925410268364u, 16358677754309956184u, 13579747780949921849u, 3247475u},
    {2399948198304452240u, 15489505372888245802u, 1551213454849076754u, 2942209115307635147u, 456869u},
    {15917823151966398506u, 9979975775171600454u, 8206688058265064568u, 584888500763844212u, 1346436u},
    {7446464895702908367u, 15161046480046671707u, 11132329444819553188u, 12706973911563834430u, 359183u},
    {15657182487614350487u, 5126212137812283231u, 8152061853747912979u, 15643123675813963241u, 3857153u},
    {13070279655029018465u, 16347600581657032290u, 17677007365611713343u, 8285717650211049397u, 2459683u},
    {964922964295953486u, 17849389503951433070u, 4769352663545400020u, 5377635109895839045u, 205170u},
    {11452425494205676815u, 10062224090865492626u, 11084533503212122650u, 13766785185103473874u, 2920075u},
    {11279866175125426292u, 14572600103437556343u, 711400061346203815u, 7764028452026111756u, 1734615u},
    {9569122305340487829u, 2349210415213125599u, 16648179074749664616u, 6589239064186888321u, 142618u},
    {5514693976925047900u, 13063489044739376505u, 355266026784447992u, 1227609942980318285u, 2065391u},
    {15107641251473361166u, 2358708586887335367u, 9261005996111323713u, 14881964112229907803u, 3129306u},
    {15615665441406496882u, 18068823730215533026u, 6625448806815448850u, 1426819808512918638u, 1872827u},
    {16405953970884846189u, 8141912683455981153u, 17289341308190327185u, 6231500649051955542u, 2772144u},
    {7860531932204105408u, 13928485675515818709u, 5662048181172793213u, 3798131927107222812u, 2300020u},
    {16745827161460650957u, 7609033374457282480u, 277718172661963210u, 7248187287895338970u, 1642984u},
    {13622769694600784381u, 15201287275109275597u, 15635480826826832234u, 17396187875754019477u, 2972196u},
    {5069790057853186948u, 4507174935167917439u, 4222242302335200377u, 3369476682089776166u, 3727800u},
    {13332258237741112831u, 12257150005908481227u, 11140006569890215726u, 8715677060478803468u, 1681014u},
    {15345484759833669152u, 10487276507870350788u, 12525746762658868508u, 16820428654595208936u, 649860u},
    {6504784841437770180u, 17563241777792063134u, 14912028719253096818u, 9451532636892729159u, 1601947u},
    {16374714253111185874u, 13081925363169971699u, 17991580104889018814u, 16386624562389820903u, 3559432u},
    {1427316156548460083u, 46136316134452932u, 2166810193822886272u, 5253806718269208091u, 3383136u},
    {10907206258808345458u, 12260026051762718738u, 16328243746058300260u, 11879853271432541659u, 2676618u},
    {17315038733771406466u, 14757524619797112195u, 1104154730624396244u, 17054967092059930480u, 2169161u},
    {1461381243260869928u, 16346773015008965941u, 13887532697596060760u, 9407501199807270656u, 606034u},
    {9618200632893358255u, 6857878914481344716u, 3898195486334353080u, 1596446432339882286u, 11584u},
    {5607398402911202833u, 10642545735712032934u, 14495488943909630776u, 1009020005210787387u, 0u},
    {4793800066056446106u, 18223504686625068741u, 3888340996450460725u, 1009020005u, 0u},
    {3090339154658209894u, 10598370314473422389u, 166389727666921520u, 1u, 0u},
    {9275210434505010965u, 6944703601017220364u, 18613133801u, 0u, 0u},
    {6290206552917955353u, 11310322316932465153u, 18u, 0u, 0u},
    {12993780297012094218u, 343351715643u, 0u, 0u, 0u},
    {6488008466134974639u, 343u, 0u, 0u, 0u},
    {6333721225749u, 0u, 0u, 0u, 0u},
    {6334u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 313706u},
    {16649156382539289687u, 10016875999337845162u, 11054191020964991430u, 17227551829361163832u, 2427320u},
    {18418597199700814575u, 11671658268171848744u, 3499586284066135648u, 693294514393899922u, 1029548u},
    {6759133347952649082u, 15340524299564440167u, 15514624698853527078u, 2396892412412515923u, 3640285u},
    {12317397627707497248u, 5239126318673903850u, 9536348422101344361u, 15847764502453474171u, 652536u},
    {15925968063475177356u, 10686330058829665865u, 7872560272381714761u, 18386723660110270318u, 1904875u},
    {11905540613035016514u, 9457583882237826171u, 4515731929693126528u, 10699662677617465670u, 668459u},
    {2017302795007316722u, 9736478415325319556u, 14409589540925626142u, 15360598432875080858u, 2684386u},
    {3136244077423323653u, 17113389182776590786u, 5522007654622139129u, 14605152192559090393u, 2910566u},
    {722643712845721836u, 11252667249859700416u, 6785912418087631471u, 13456402971771388803u, 2049156u},
    {9644889289246743336u, 17246197791076792623u, 13330076579929125709u, 14953722235606592093u, 729817u},
    {7834808272873646083u, 10150902920133660030u, 8085694289244476405u, 8300086076735077359u, 3216818u},
    {5725687520311174466u, 11942524632027284240u, 2681331049265532370u, 1068146143208779393u, 2138597u},
    {16902148022999657890u, 12384197480592695549u, 3064043761590525679u, 17981791068048005233u, 2115222u},
    {14611573265905025321u, 267762600734739980u, 4359039137956744541u, 18269590268470638941u, 1206235u},
    {12534247025799600566u, 11832689018580462508u, 8562327451755955124u, 3048670076200314621u, 1301613u},
    {9753574196726710059u, 14993719977116509234u, 14902593814438529504u, 2257795940118449402u, 621872u},
    {9588586625631243443u, 4361340989952170455u, 7397043927491898590u, 9378958740819033526u, 576853u},
    {14456013083302980139u, 9341515578695251075u, 14709027423788072859u, 11395740927030724204u, 1596761u},
    {12175812160023813344u, 8841165451784085206u, 6984674821843530573u, 605915805213044952u, 3332088u},
    {14344522717149392146u, 18258091684325851286u, 11770851905153717791u, 11302450845089752533u, 523575u},
    {8909644400921464702u, 5479352975447841571u, 10645611091427966462u, 12115334063702736571u, 3344280u},
    {6160039667093684114u, 3899399644485816970u, 18097972434937483974u, 3880743573396340050u, 369967u},
    {13389129901298746389u, 14540585625360856380u, 1458339136138375965u, 5339086649252128939u, 1499573u},
    {16197798436666866191u, 7450633987613537714u, 12868244037546112683u, 14150950676123806958u, 1722412u},
    {4586219234520274030u, 5486221868050646658u, 6305553694177993091u, 4931689302083536540u, 546551u},
    {8982746255383101853u, 16039997140091215326u, 4220854046386518084u, 2315925100565613283u, 1176252u},
    {13575971883542692682u, 11654216176697002703u, 1347285904461502818u, 14865562393739268924u, 1014473u},
    {16236708725977450016u, 17057458730449817481u, 12835379041492177408u, 16952248337579315703u, 1942836u},
    {4372163050307162019u, 11111076664675097907u, 50519723448421842u, 3206373153090267092u, 728612u},
    {5181381187818811u, 9850959537889552322u, 16829039954998540692u, 10029446093571389920u, 1147396u},
    {16337412937846181739u, 15724373371801526641u, 4747857243677405154u, 2975527085947689514u, 2323313u},
    {2855045706666340501u, 8574664737791506675u, 8140793912000432330u, 3141334106920550693u, 1854286u},
    {3926633326454034135u, 10632751881384740440u, 10115767766525943042u, 16823624953260005784u, 2830253u},
    {16275571597319583867u, 9416479094598521368u, 15676866439035642534u, 8771177848167753888u, 3045234u},
    {10902669628993065361u, 24464929957260092u, 16114190785049803031u, 13026541587840765160u, 1256620u},
    {7342775705355945307u, 16309510042291434819u, 10929014825995898760u, 2761369134005708052u, 1570575u},
    {15703895694037350058u, 4136091931454565696u, 645769829296871674u, 8747940876424215769u, 488582u},
    {7882183373083450022u, 241648108750550104u, 10549034037148693567u, 8727981634450242292u, 3538798u},
    {6671090422153329128u, 3558512091354048685u, 5346601730328840158u, 1650546378596951440u, 105990u},
    {14281242244457710140u, 18199348114774190227u, 17943724979998508221u, 16286971424626632389u, 3131831u},
    {1144921590258435084u, 12983829028363232425u, 6893940917236593326u, 7407646693094730755u, 2954412u},
    {12949128693457798274u, 12467919652926009232u, 16669594846911322649u, 6683797940949313188u, 2996219u},
    {14196281620386862487u, 5669040875861113006u, 18126750118032961652u, 17493208248944144411u, 986696u},
    {12705133567305969844u, 14133327229014805364u, 12644231221401972560u, 15798814440389979152u, 3174187u},
    {1915568725539240394u, 13406511870384320839u, 16700120469414555298u, 6471679300405496644u, 2114720u},
    {7440774448535540092u, 10654181247446087074u, 7358114105063709344u, 11856455127319415867u, 855207u},
    {6703709172068162298u, 8932869180061316884u, 15279076180046265453u, 16516964831200997395u, 2652752u},
    {11464390316405088069u, 17646758321673475452u, 12349073721068027467u, 17414814816892618567u, 1890096u},
    {9409567801402015636u, 2852263533141000862u, 10400527096840560964u, 1403960421322187729u, 568456u},
    {17652624405212357786u, 356261307065029449u, 3608416041362045976u, 18313115049386820802u, 3454777u},
    {5108614924134978152u, 14626189471685710146u, 18263944849434433990u, 17717839944756197432u, 3732931u},
    {15773758363104018734u, 12612807023351151029u, 18071609776324965716u, 4968776835098756262u, 3799555u},
    {13839611410022844320u, 5458155244338390979u, 9022065356287651714u, 4105314689771724746u, 2099565u},
    {12481827410455468268u, 14845162843586658475u, 9414697727806124859u, 11712060376470758316u, 2044599u},
    {6991268405371293229u, 813310670715287839u, 18359680985119562373u, 6378784481536081219u, 861054u},
    {17333111466193083703u, 16884247685019778838u, 14632777984142728148u, 13202423358091240673u, 855562u},
    {4721323263038412110u, 11889369072886893846u, 9056039145684484498u, 5708332275451921393u, 319561u},
    {15852753297585431255u, 15010049293281654015u, 8778472900492021702u, 11318937129645956925u, 1253407u},
    {11359392841792382955u, 2003189028200333560u, 11221387540320852616u, 17172828670494981965u, 588622u},
    {8434245571886766867u, 11826423233203116086u, 3436538356702165082u, 14566492172224426806u, 3883582u},
    {16590108916595913196u, 13943874856997077378u, 1999540693370900643u, 9367069088702461004u, 1498656u},
    {4388407862234425273u, 11877604751147233120u, 9022101458940478954u, 17177352714080447118u, 3455119u},
    {10780668607186537649u, 9547387374393145904u, 6463175067909642454u, 16564924747800061330u, 1045882u},
    {4359746301607435043u, 816746685095890027u, 1167801429603127264u, 667811480491575665u, 845163u},
    {5299545537300301180u, 18242708917971622051u, 4870107803936103822u, 2177318327367218146u, 232113u},
    {2132595381583864113u, 13292987327943648827u, 9619289971879869585u, 8507077827759995720u, 404125u},
    {18238526581237358950u, 11319090134525959324u, 5659677287273924283u, 7454798955865700u, 1991019u},
    {2940242715494900583u, 18314096260065975200u, 13001309574782922463u, 5801335340980582796u, 775512u},
    {9205647227497377669u, 9392828845297611984u, 14266899815036899747u, 18244876968787193790u, 1447652u},
    {11887664217121001152u, 12677814469484931359u, 11127065377310426745u, 11700034718340996380u, 3539047u},
    {7026008272447431696u, 4395845419511953853u, 15844763170582622371u, 12603305268573325149u, 1964945u},
    {14570955001318103034u, 14912773572202147793u, 8733173237858937181u, 11205173926016050563u, 3088614u},
    {7540995068341068151u, 7955323919334591102u, 1308811018350451934u, 17350797452308354919u, 3414368u},
    {8339002630339077096u, 757254458126587371u, 11812808041196070457u, 4098209256144225402u, 2746037u},
    {9090451208418820987u, 6187406178537893386u, 2493468433668552142u, 483001010081714028u, 816592u},
    {12073948477566720303u, 11346580147968550876u, 4702567594948801185u, 11976624074415677016u, 2604813u},
    {6922686380423158051u, 10569924764152051068u, 12713585007396602143u, 624511083050919160u, 2949220u},
    {14606173211405658165u, 4615910757665305850u, 16009166974820979176u, 2072016140243558974u, 805710u},
    {2255973542488678551u, 1221080752835588630u, 1403545146813952538u, 8877946794904780791u, 1035384u},
    {8043588348890278379u, 810179119370508741u, 5444765608602994804u, 5495476619426483621u, 2913816u},
    {12275299465791112290u, 16840999939171877823u, 5128384435124866470u, 1206671928132203666u, 1970364u},
    {8463461802767775784u, 3201998950343796242u, 1706543163733554366u, 10484697937146273295u, 3213239u},
    {5022114313508168204u, 10867254929457486610u, 1315576022671461511u, 11372316071920046295u, 2728562u},
    {2125608326500377996u, 12365415244509247740u, 9158854310964879715u, 13525103181368089185u, 1938401u},
    {2064925508470627447u, 16016838071442605604u, 17157228146191298536u, 16753119017483607001u, 630301u},
    {12593683160528207933u, 13073030599885642279u, 10638669291871500619u, 6929156045630604077u, 3249184u},
    {6332316396226266696u, 2480920240186818589u, 7166291148192979483u, 15408204402704198309u, 3058339u},
    {11248469719358143169u, 7093297189268120998u, 1548127010225253361u, 15260568754234643695u, 2908274u},
    {2036037215397784881u, 11080985458780929881u, 13855616565718814469u, 14825454979210019206u, 675633u},
    {17427540971340470214u, 13610063368703786727u, 12857235531142290242u, 13919578893184299232u, 790805u},
    {3339614631646006397u, 9147947630485554068u, 2766829222508267433u, 13345242688383456935u, 3209756u},
    {4713817010626905827u, 13541554299103304175u, 17344046249133681772u, 9066408815557288363u, 3770737u},
    {4826749362726163610u, 724762479381850189u, 1644515353365325233u, 5401819788281343413u, 2226435u},
    {8834547972980780869u, 10763121783858818634u, 15375589428645850633u, 8255636202367354017u, 646143u},
    {13498782073113867139u, 9354460384836572736u, 3268230046566912137u, 3254510974518412233u, 3506065u},
    {10197205479943108226u, 10048150046745806436u, 11159602674292913643u, 9215989929832149325u, 1657938u},
    {5429599386948781872u, 10420760737818278938u, 7734297979569284150u, 6227536654453870292u, 2184283u},
    {3660646756303973923u, 17266559583054607820u, 18194422506240902338u, 2850539083192280678u, 2050555u},
    {8839504076991705881u, 16298363706660710844u, 14872273445792246306u, 3784820956116857244u, 3735403u},
    {8959319669426026661u, 9059737959344521944u, 6491750371602075696u, 16642152655661413116u, 1371688u},
    {3335024206255274695u, 6255823666423495644u, 1816283472780716931u, 14364764407674790427u, 2222157u},
    {17470441366293318718u, 3400243239073445095u, 14114455006936278299u, 10417285117296989387u, 3442746u},
    {12785367628588497063u, 6166301371966615511u, 5253022563353209216u, 11592722510858542141u, 108343u},
    {6846826193720038852u, 4383619335303499760u, 14928478282413453859u, 2668129566589234056u, 1272u},
    {1537262228134510882u, 3974542621395035852u, 2562061068202321012u, 792657001343798621u, 2136838u},
    {1609594046160274619u, 13699634534266524633u, 3686191269674130453u, 16036203580925636164u, 1821831u},
    {9666352906966938049u, 2093104342016538669u, 1028683793761248838u, 15886277554582899847u, 958407u},
    {14106682331596937625u, 7437029593645416005u, 15099315973132468829u, 11979240114829766680u, 1964059u},
    {1458853630286045696u, 8365296158069175373u, 1238441067953738199u, 8322853820059618663u, 759119u},
    {13164646358216480401u, 9987341571402767537u, 3187689002153265702u, 17019595475188337037u, 2075916u},
    {4053682667133650857u, 10370043610089350822u, 13665667012536991498u, 17404174071330746888u, 3028193u},
    {7038123624952460737u, 17670901956709899081u, 10467729933429995532u, 14611494314342415891u, 2789811u},
    {17576588012126983186u, 62722710657305468u, 4534218318415020143u, 2933766705659631472u, 1570452u},
    {3146992051523667593u, 10230140117355553233u, 7638462913176585794u, 8892053795722948146u, 3145595u},
    {5444557125244920644u, 10515124669927704672u, 13622545409978971971u, 5894691111888757008u, 2585993u},
    {4110103999964618174u, 12625554992220360614u, 7394777596128442377u, 3002064512497140872u, 3715955u},
    {16016886522783975995u, 8055176806801148978u, 6869090689003397373u, 11381589537831171841u, 2006481u},
    {17235590235469098178u, 11973574337130378633u, 12307577946331673077u, 13007379979704378832u, 1362440u},
    {13941065921345908407u, 16040887054406171691u, 3838433051469967430u, 4636818613430552725u, 2903338u},
    {3495713706629384482u, 14372986489842058647u, 11072601557918517341u, 15762112637950584403u, 146294u},
    {14420924713650765039u, 17308702704922981160u, 1746823793631772918u, 11027510551542606111u, 3261417u},
    {6391020154248804882u, 8217866708697501438u, 4526941364304940764u, 12382011116229833192u, 3848115u},
    {4320497787041453283u, 2324003394250269945u, 8238999027672164728u, 14842791982728440827u, 469756u},
    {3327015676804060326u, 10535228772263324009u, 15815620835386213008u, 9304095114444585230u, 1665746u},
    {14440115562318221857u, 17384780965908201186u, 3887296524674395108u, 3633607301354297305u, 2161007u},
    {13887964549210787134u, 5819692838637045834u, 6702340696805576230u, 10199984306051941134u, 3691477u},
    {3374868920128715174u, 5406911990289430884u, 9642444548234351592u, 14767844925410268364u, 3750268u},
    {17964134234308998776u, 13740943215146867338u, 2399948198304452239u, 15489505372888245802u, 1953070u},
    {4911150369003658557u, 4927829855431683493u, 15917823151966398505u, 9979975775171600454u, 1569476u},
    {2471514938198028660u, 15708310624668541409u, 7446464895702908366u, 15161046480046671707u, 548766u},
    {2879953519666433266u, 2842646487200421354u, 15657182487614350486u, 5126212137812283231u, 3392703u},
    {16764381721772892929u, 2425882432104394289u, 13070279655029018464u, 16347600581657032290u, 2773593u},
    {18374832797563253993u, 1468001340544654288u, 964922964295953485u, 17849389503951433070u, 2505510u},
    {8938239403916706760u, 2129070905936108821u, 11452425494205676814u, 10062224090865492626u, 919734u},
    {13727206684683010272u, 15040241659842606630u, 11279866175125426291u, 14572600103437556343u, 2350951u},
    {14314164100321943618u, 16285177399921439048u, 9569122305340487828u, 2349210415213125599u, 1141910u},
    {15622595531873375009u, 15967995542720506630u, 5514693976925047899u, 13063489044739376505u, 2865848u},
    {8957342369711857189u, 2674495062728998338u, 15107641251473361165u, 2358708586887335367u, 2950397u},
    {5433950419233584633u, 15445685138694542973u, 15615665441406496881u, 18068823730215533026u, 3873970u},
    {2772834239023529214u, 8123341365896403250u, 16405953970884846188u, 8141912683455981153u, 1158471u},
    {2713033526084029188u, 10241322633907374987u, 7860531932204105407u, 13928485675515818709u, 2330275u},
    {5353603055078807592u, 12704633306098475927u, 16745827161460650956u, 7609033374457282480u, 3750934u},
    {12900851613070710029u, 10747784047564418843u, 13622769694600784380u, 15201287275109275597u, 2146942u},
    {17037047354038661079u, 8877803361698631532u, 5069790057853186947u, 4507174935167917439u, 398933u},
    {6045164734771117459u, 17542758050394541059u, 13332258237741112830u, 12257150005908481227u, 2110148u},
    {372245321764079610u, 6125816003295910717u, 15345484759833669151u, 10487276507870350788u, 2886494u},
    {17427795460957919217u, 12994215307966449886u, 6504784841437770179u, 17563241777792063134u, 2141344u},
    {5706398433709070230u, 2463223024139496712u, 16374714253111185873u, 13081925363169971699u, 2501054u},
    {18210507843684348638u, 2689094060738576590u, 1427316156548460082u, 46136316134452932u, 554844u},
    {2981479341932503273u, 4465791792148669396u, 10907206258808345457u, 12260026051762718738u, 3132012u},
    {9060435417421064538u, 7534674760994394279u, 17315038733771406465u, 14757524619797112195u, 3347840u},
    {7342584060289529327u, 16746297848256578558u, 1461381243260869927u, 16346773015008965941u, 672610u},
    {15388813407108271728u, 16487713575758741848u, 9618200632893358254u, 6857878914481344716u, 2714810u},
    {11489306785032409565u, 2344261506181400199u, 5607398402911202832u, 10642545735712032934u, 3523168u},
    {14935279861444131825u, 16512359167755688489u, 4793800066056446105u, 18223504686625068741u, 320055u},
    {7820872463992623890u, 4826251939624014114u, 3090339154658209893u, 10598370314473422389u, 1473136u},
    {15045191074543337052u, 14299667588463455705u, 9275210434505010964u, 6944703601017220364u, 3758801u},
    {1414149717849350417u, 11037488393949630558u, 6290206552917955352u, 11310322316932465153u, 18u},
    {15748064479885093852u, 16982050616775565749u, 12993780297012094217u, 343351715643u, 0u},
    {3674160316375260496u, 16145020331663287992u, 6488008466134974638u, 343u, 0u},
    {12391275820066806916u, 9429586839940733762u, 6333721225748u, 0u, 0u},
    {17246645586927790494u, 13304266802155325338u, 6333u, 0u, 0u},
    {13755911689891259962u, 116836534485604u, 0u, 0u, 0u},
    {9859519161825981906u, 116836u, 0u, 0u, 0u},
    {2155253650115091u, 0u, 0u, 0u, 0u},
    {2155254u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 47186u},
    {9693960579239218824u, 15232635332337710908u, 16649156382539289686u, 10016875999337845162u, 3815612u},
    {2838063092473052992u, 815762077369459664u, 18418597199700814574u, 11671658268171848744u, 3486488u},
    {9320618847230857967u, 13584023805376906427u, 6759133347952649081u, 15340524299564440167u, 2763606u},
    {15565131170525357520u, 6859962084080095452u, 12317397627707497247u, 5239126318673903850u, 1182113u},
    {17709454513320907035u, 4657902036721020055u, 15925968063475177355u, 10686330058829665865u, 977899u},
    {2204582927297709076u, 17350567322628763503u, 11905540613035016513u, 9457583882237826171u, 471802u},
    {6765750676899964416u, 12848573441682316984u, 2017302795007316721u, 9736478415325319556u, 1937436u},
    {3668989371434436653u, 3947345598947939986u, 3136244077423323652u, 17113389182776590786u, 633313u},
    {3883232989956230611u, 16642054021083375634u, 722643712845721835u, 11252667249859700416u, 1324505u},
    {11005201526996328048u, 3853955972495726019u, 9644889289246743335u, 17246197791076792623u, 3406549u},
    {3291828334700722360u, 17718050592114360119u, 7834808272873646082u, 10150902920133660030u, 2874307u},
    {5965591868112109011u, 13285632020260992144u, 5725687520311174465u, 11942524632027284240u, 3379940u},
    {251563124839204483u, 9649472376928100707u, 16902148022999657889u, 12384197480592695549u, 2796689u},
    {254749886397629434u, 2163512682403650372u, 14611573265905025320u, 267762600734739980u, 826357u},
    {9610352335293358654u, 17856057046966043414u, 12534247025799600565u, 11832689018580462508u, 311188u},
    {8106948347345319201u, 10422100901583140937u, 9753574196726710058u, 14993719977116509234u, 2053768u},
    {6833992899870004278u, 1769013436767769703u, 9588586625631243442u, 4361340989952170455u, 2498324u},
    {2220817526946637765u, 14785959416745495464u, 14456013083302980138u, 9341515578695251075u, 2718039u},
    {5311640640975390063u, 14621297446480548630u, 12175812160023813343u, 8841165451784085206u, 1491883u},
    {7760619429925913466u, 11702944411893883434u, 14344522717149392145u, 18258091684325851286u, 161319u},
    {4422459214799430312u, 14946304410679469375u, 8909644400921464701u, 5479352975447841571u, 449378u},
    {228596760903606775u, 12251733535778735515u, 6160039667093684113u, 3899399644485816970u, 3090476u},
    {12938526721533014059u, 5628114338947184519u, 13389129901298746388u, 14540585625360856380u, 1555927u},
    {17712036077187186017u, 15084938972782475697u, 16197798436666866190u, 7450633987613537714u, 533683u},
    {1502787801529895712u, 9352212634946264343u, 4586219234520274029u, 5486221868050646658u, 2342487u},
    {16232611027962708389u, 16567102562580263400u, 8982746255383101852u, 16039997140091215326u, 2870074u},
    {13298353594465057488u, 1415536969865837083u, 13575971883542692681u, 11654216176697002703u, 2811690u},
    {9829889687442582276u, 5191492439672252989u, 16236708725977450015u, 17057458730449817481u, 770172u},
    {4687828229495214813u, 8845946917484943878u, 4372163050307162018u, 11111076664675097907u, 2771586u},
    {4963292291460981445u, 5418158235307662728u, 5181381187818810u, 9850959537889552322u, 857488u},
    {5982754443768591229u, 16315290869896203150u, 16337412937846181738u, 15724373371801526641u, 3896006u},
    {16216245505375593612u, 12481589652846781684u, 2855045706666340500u, 8574664737791506675u, 2183884u},
    {15216102122136500902u, 12815919803664053835u, 3926633326454034134u, 10632751881384740440u, 2655854u},
    {17898658173696642504u, 15953640762628434177u, 16275571597319583866u, 9416479094598521368u, 1326246u},
    {6362685239406301596u, 10425891871608568629u, 10902669628993065360u, 24464929957260092u, 1327811u},
    {4411631029970460836u, 15229204838661703162u, 7342775705355945306u, 16309510042291434819u, 1561742u},
    {11324990298289834954u, 4275570898262070943u, 15703895694037350057u, 4136091931454565696u, 1381020u},
    {13568693556989957958u, 11017869699754077474u, 7882183373083450021u, 241648108750550104u, 1501077u},
    {13263980556083488145u, 15003773617842558284u, 6671090422153329127u, 3558512091354048685u, 2213638u},
    {9999768280786938597u, 14919560877824556684u, 14281242244457710139u, 18199348114774190227u, 729781u},
    {17930006436231962159u, 4455591658796834442u, 1144921590258435083u, 12983829028363232425u, 106028u},
    {18069996239286899930u, 5995941707004536300u, 12949128693457798273u, 12467919652926009232u, 2631821u},
    {10372989304946159874u, 9161733372779805544u, 14196281620386862486u, 5669040875861113006u, 544204u},
    {1231033145955314955u, 1844327728424567237u, 12705133567305969843u, 14133327229014805364u, 205964u},
    {11467330887958458009u, 2987665127596792402u, 1915568725539240393u, 13406511870384320839u, 3345572u},
    {9965772073360574795u, 12016929419511401334u, 7440774448535540091u, 10654181247446087074u, 3783058u},
    {7763756856812101419u, 4856365912787521882u, 6703709172068162297u, 8932869180061316884u, 3507685u},
    {16173601578585591296u, 18437266159907589634u, 11464390316405088068u, 17646758321673475452u, 2277765u},
    {129921799743799406u, 16142641348769037583u, 9409567801402015635u, 2852263533141000862u, 3687964u},
    {974219759880607844u, 1579487922972947549u, 17652624405212357785u, 356261307065029449u, 3824820u},
    {14829790853671451569u, 6991966972667025121u, 5108614924134978151u, 14626189471685710146u, 147888u},
    {9768719806010252746u, 10932998114555231420u, 15773758363104018733u, 12612807023351151029u, 2918438u},
    {12189951972050643986u, 12843680694653613349u, 13839611410022844319u, 5458155244338390979u, 70390u},
    {2842416692591136502u, 7683146820143932218u, 12481827410455468267u, 14845162843586658475u, 1120909u},
    {1858209782464432533u, 10454643714967865416u, 6991268405371293228u, 813310670715287839u, 1234401u},
    {16892435144294585420u, 7902380560346550040u, 17333111466193083702u, 16884247685019778838u, 3898988u},
    {7917893171745686781u, 16731057388478258484u, 4721323263038412109u, 11889369072886893846u, 1196402u},
    {10036441730824959108u, 7573284177540815441u, 15852753297585431254u, 15010049293281654015u, 3124344u},
    {18158199541095962256u, 17245019095791331731u, 11359392841792382954u, 2003189028200333560u, 486688u},
    {2185518660468133051u, 6023113607793841244u, 8434245571886766866u, 11826423233203116086u, 1992720u},
    {5176064819630836950u, 5096137405686801697u, 16590108916595913195u, 13943874856997077378u, 3261243u},
    {7993101734656195089u, 12290251176104701444u, 4388407862234425272u, 11877604751147233120u, 1939906u},
    {17417258817491081250u, 8705209058646581855u, 10780668607186537648u, 9547387374393145904u, 1307176u},
    {18288820463647370761u, 5012474155977459289u, 4359746301607435042u, 816746685095890027u, 657982u},
    {14120472462006123789u, 9847065055182108252u, 5299545537300301179u, 18242708917971622051u, 1864286u},
    {7701737542331928841u, 10902874510550985510u, 2132595381583864112u, 13292987327943648827u, 327855u},
    {5771445628083632111u, 12638333365822618314u, 18238526581237358949u, 11319090134525959324u, 621647u},
    {10749016541389771996u, 16211267381441720905u, 2940242715494900582u, 18314096260065975200u, 1373771u},
    {7871289034673287261u, 16435022572152728524u, 9205647227497377668u, 9392828845297611984u, 3671949u},
    {7195761645311013532u, 17952215584662199801u, 11887664217121001151u, 12677814469484931359u, 18007u},
    {13342101902120161752u, 13506991713447818817u, 7026008272447431695u, 4395845419511953853u, 3735575u},
    {260156381921755449u, 12373252161901259290u, 14570955001318103033u, 14912773572202147793u, 1571473u},
    {9091349316968691436u, 1355489069023015129u, 7540995068341068150u, 7955323919334591102u, 1988346u},
    {4287393318167335506u, 11807405930687506739u, 8339002630339077095u, 757254458126587371u, 3388711u},
    {3888232224239306509u, 11226538058762606090u, 9090451208418820986u, 6187406178537893386u, 1818092u},
    {840505864442743896u, 14633704575411151727u, 12073948477566720302u, 11346580147968550876u, 2684269u},
    {1367424654308281124u, 138748712817125012u, 6922686380423158050u, 10569924764152051068u, 229023u},
    {11061579533629747119u, 9765179215495423161u, 14606173211405658164u, 4615910757665305850u, 3694920u},
    {7539592079264422629u, 5172748988069760065u, 2255973542488678550u, 1221080752835588630u, 951148u},
    {16014480978552531980u, 117249687221047595u, 8043588348890278378u, 810179119370508741u, 2796186u},
    {16265564084726747424u, 17104939900288816429u, 12275299465791112289u, 16840999939171877823u, 1705710u},
    {719458102400720720u, 15088293284861432383u, 8463461802767775783u, 3201998950343796242u, 3177570u},
    {3538800934132360780u, 9773910978305514076u, 5022114313508168203u, 10867254929457486610u, 2361753u},
    {11958119779556257415u, 11858901371800006242u, 2125608326500377995u, 12365415244509247740u, 1087031u},
    {2970984245106818897u, 534088058069435882u, 2064925508470627446u, 16016838071442605604u, 1659158u},
    {13702049839251513344u, 4102510835578064338u, 12593683160528207932u, 13073030599885642279u, 1678455u},
    {5557752278841107901u, 2766297283441433249u, 6332316396226266695u, 2480920240186818589u, 1715911u},
    {15626351446231067116u, 8074747427345035649u, 11248469719358143168u, 7093297189268120998u, 3045175u},
    {454251549610050998u, 1717405458140744933u, 2036037215397784880u, 11080985458780929881u, 3428013u},
    {2549033760149055784u, 5569800757748206913u, 17427540971340470213u, 13610063368703786727u, 3723734u},
    {12703152873407295568u, 16981477673883692768u, 3339614631646006396u, 9147947630485554068u, 3620379u},
    {7761270127767881729u, 16115852395273597727u, 4713817010626905826u, 13541554299103304175u, 226952u},
    {11992492764156146260u, 1181785842151107507u, 4826749362726163609u, 724762479381850189u, 1438751u},
    {9714935922749324876u, 7407299104437708337u, 8834547972980780868u, 10763121783858818634u, 3200063u},
    {17996174556451388562u, 11859691056100445800u, 13498782073113867138u, 9354460384836572736u, 1742555u},
    {1283777264825671274u, 10291781529341556458u, 10197205479943108225u, 10048150046745806436u, 2410571u},
    {6145578721832857923u, 1619811872477918303u, 5429599386948781871u, 10420760737818278938u, 2428320u},
    {151268601765546200u, 18230540837641113986u, 3660646756303973922u, 17266559583054607820u, 723566u},
    {8990297314954259783u, 17000208307562692716u, 8839504076991705880u, 16298363706660710844u, 2848128u},
    {17027863841505195291u, 11407174208182114877u, 8959319669426026660u, 9059737959344521944u, 3191380u},
    {4324366577972643853u, 3968585381547194741u, 3335024206255274694u, 6255823666423495644u, 733805u},
    {4083134951242384631u, 4277901005925866182u, 17470441366293318717u, 3400243239073445095u, 2244617u},
    {3234673581576716689u, 11650494811019196773u, 12785367628588497062u, 6166301371966615511u, 3261480u},
    {10885221892197257682u, 14180523487963262219u, 6846826193720038851u, 4383619335303499760u, 616637u},
    {13410722945213594140u, 9061861269703286063u, 1537262228134510881u, 3974542621395035852u, 471176u},
    {6858978466619296252u, 1845411714346698528u, 1609594046160274618u, 13699634534266524633u, 186163u},
    {17587769819462766326u, 13992129758625458970u, 9666352906966938048u, 2093104342016538669u, 818432u},
    {11197831739477553165u, 2227151869318525377u, 14106682331596937624u, 7437029593645416005u, 358613u},
    {14367288857603700737u, 10179323490114329161u, 1458853630286045695u, 8365296158069175373u, 2352371u},
    {7356041076078618328u, 6208447983096473282u, 13164646358216480400u, 9987341571402767537u, 3567440u},
    {8537333832080279476u, 4496630582795105030u, 4053682667133650856u, 10370043610089350822u, 910264u},
    {10327773115955366530u, 9361051012845992410u, 7038123624952460736u, 17670901956709899081u, 3400204u},
    {14138405659210517992u, 13622231632584866271u, 17576588012126983185u, 62722710657305468u, 3795757u},
    {16271262577242946165u, 3018102525350734098u, 3146992051523667592u, 10230140117355553233u, 3619800u},
    {1670183314141577675u, 7402141968480082115u, 5444557125244920643u, 10515124669927704672u, 838957u},
    {3012410622940790109u, 14974365630357082049u, 4110103999964618173u, 12625554992220360614u, 3078259u},
    {10900580724877741591u, 10319210125346638280u, 16016886522783975994u, 8055176806801148978u, 651265u},
    {12876749563979580641u, 267778149275006762u, 17235590235469098177u, 11973574337130378633u, 2390729u},
    {5489227641296364691u, 11291446273553746781u, 13941065921345908406u, 16040887054406171691u, 1817408u},
    {2977609626579672502u, 13175349187407383399u, 3495713706629384481u, 14372986489842058647u, 806653u},
    {3073445513938851805u, 8312560390488645216u, 14420924713650765038u, 17308702704922981160u, 178946u},
    {10453828899225684286u, 11686473067994058161u, 6391020154248804881u, 8217866708697501438u, 984476u},
    {13690658447313264212u, 8953786626728318692u, 4320497787041453282u, 2324003394250269945u, 803396u},
    {5976876803325239458u, 17770467592348702749u, 3327015676804060325u, 10535228772263324009u, 1024614u},
    {1180724387911386595u, 2478999901932694270u, 14440115562318221856u, 17384780965908201186u, 2986180u},
    {4828945536308766478u, 3381592783828105805u, 13887964549210787133u, 5819692838637045834u, 140536u},
    {12183876956225307171u, 10269953470154293599u, 3374868920128715173u, 5406911990289430884u, 2710524u},
    {38512663292365916u, 3316478533603731639u, 17964134234308998775u, 13740943215146867338u, 1513191u},
    {16868390899932708249u, 18185410511026568754u, 4911150369003658556u, 4927829855431683493u, 3892975u},
    {16207247711010908613u, 1019271984286156286u, 2471514938198028659u, 15708310624668541409u, 1756424u},
    {14332098912834160609u, 6553924278546028961u, 2879953519666433265u, 2842646487200421354u, 2601100u},
    {6392760217081708030u, 1775368686721123421u, 16764381721772892928u, 2425882432104394289u, 1455512u},
    {8551036275529134883u, 4182973062605160154u, 18374832797563253992u, 1468001340544654288u, 2135915u},
    {1117769286970557888u, 2712144357536327063u, 8938239403916706759u, 2129070905936108821u, 2833134u},
    {14699270436506123247u, 11147267815590084293u, 13727206684683010271u, 15040241659842606630u, 8735u},
    {12182821369612758116u, 18057379637235179881u, 14314164100321943617u, 16285177399921439048u, 2345522u},
    {6910160543243892167u, 13771328575508340843u, 15622595531873375008u, 15967995542720506630u, 453417u},
    {15356410538565500740u, 12217910230306248425u, 8957342369711857188u, 2674495062728998338u, 1374769u},
    {6067971346679267374u, 14687759919111942388u, 5433950419233584632u, 15445685138694542973u, 2867217u},
    {13380102691846303120u, 985368857429387499u, 2772834239023529213u, 8123341365896403250u, 495712u},
    {15478287740408584127u, 5274991921439636341u, 2713033526084029187u, 10241322633907374987u, 1219551u},
    {87314007649121235u, 8803421490881368141u, 5353603055078807591u, 12704633306098475927u, 607290u},
    {492837031371849598u, 6527746806963082423u, 12900851613070710028u, 10747784047564418843u, 797934u},
    {14497479583997498541u, 4835670449781812302u, 17037047354038661078u, 8877803361698631532u, 1776069u},
    {15549328126755432390u, 2033998032108101461u, 6045164734771117458u, 17542758050394541059u, 49900u},
    {2536351564906480749u, 9492200166517246025u, 372245321764079609u, 6125816003295910717u, 1292823u},
    {12067187204354027972u, 11848870733067286977u, 17427795460957919216u, 12994215307966449886u, 719087u},
    {11574963001885200727u, 4122767327240651914u, 5706398433709070229u, 2463223024139496712u, 1244831u},
    {750141028296522577u, 10520929983307536794u, 18210507843684348637u, 2689094060738576590u, 3809808u},
    {12488135722670604710u, 14930398519952458148u, 2981479341932503272u, 4465791792148669396u, 2205537u},
    {2919223604103209524u, 16677315426085182132u, 9060435417421064537u, 7534674760994394279u, 1568625u},
    {8374308033667419080u, 13315549815755970593u, 7342584060289529326u, 16746297848256578558u, 3175743u},
    {11180637723027171517u, 16662775368750042232u, 15388813407108271727u, 16487713575758741848u, 2082670u},
    {6702183076670807581u, 8053214187949391101u, 11489306785032409564u, 2344261506181400199u, 605534u},
    {3392222189368185972u, 9802206007729984365u, 14935279861444131824u, 16512359167755688489u, 3819141u},
    {3679835260366254212u, 16140151103471002936u, 7820872463992623889u, 4826251939624014114u, 1749033u},
    {4900877694986104061u, 3240247369589324550u, 15045191074543337051u, 14299667588463455705u, 687194u},
    {2650045792406818073u, 5050733195783461201u, 1414149717849350416u, 11037488393949630558u, 2630058u},
    {10109440601604888842u, 10455182744644029658u, 15748064479885093851u, 16982050616775565749u, 223305u},
    {1807867592136634948u, 15891433118822575651u, 3674160316375260495u, 16145020331663287992u, 3366426u},
    {12227454176344899217u, 18284999772488998339u, 12391275820066806915u, 9429586839940733762u, 2475748u},
    {4332156227366192110u, 1760472325423379946u, 17246645586927790493u, 13304266802155325338u, 6333u},
    {12355797603676206868u, 10968204347577709958u, 13755911689891259961u, 116836534485604u, 0u},
    {4450025369655573386u, 17306661975114812678u, 9859519161825981905u, 116836u, 0u},
    {6419363160718790643u, 18420713539965664642u, 2155253650115090u, 0u, 0u},
    {12196066363385447256u, 11992506702107365322u, 2155253u, 0u, 0u},
    {6574496522988937929u, 39757412497601434u, 0u, 0u, 0u},
    {9179126310283371107u, 39757412u, 0u, 0u, 0u},
    {733394813376155323u, 0u, 0u, 0u, 0u},
    {733394814u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1544066u},
    {3491509993308569407u, 3505252079773720074u, 9693960579239218823u, 15232635332337710908u, 1253800u},
    {15158702150640854474u, 5072466338259371261u, 2838063092473052991u, 815762077369459664u, 2016406u},
    {16645184832145666245u, 5538028956107681925u, 9320618847230857966u, 13584023805376906427u, 785539u},
    {4366226962259694686u, 11961399797119231732u, 15565131170525357519u, 6859962084080095452u, 2505375u},
    {4614389356244128854u, 12964075695168833708u, 17709454513320907034u, 4657902036721020055u, 3076139u},
    {8327584793807119973u, 13551241961057878211u, 2204582927297709075u, 17350567322628763503u, 1210061u},
    {2780485766891497573u, 12098089385508637345u, 6765750676899964415u, 12848573441682316984u, 3048533u},
    {17504710490947064945u, 9149670056807974566u, 3668989371434436652u, 3947345598947939986u, 3730056u},
    {3037920327560200972u, 2259275393540904963u, 3883232989956230610u, 16642054021083375634u, 1892121u},
    {16609932464910726963u, 15205528102435087147u, 11005201526996328047u, 3853955972495726019u, 3466197u},
    {10693785543178790612u, 2124651411834968101u, 3291828334700722359u, 17718050592114360119u, 1465554u},
    {1270203940319661962u, 5816466616965632996u, 5965591868112109010u, 13285632020260992144u, 3567695u},
    {11300282467881664259u, 15147131322065112338u, 251563124839204482u, 9649472376928100707u, 96757u},
    {4169571328093083210u, 2539105534267280264u, 254749886397629433u, 2163512682403650372u, 3135042u},
    {7178684310028642176u, 6062923419239679897u, 9610352335293358653u, 17856057046966043414u, 2483221u},
    {5897091031579377136u, 11864861916927603861u, 8106948347345319200u, 10422100901583140937u, 2148410u},
    {8122114205145049689u, 13348218090807597088u, 6833992899870004277u, 1769013436767769703u, 767216u},
    {13654166044390525082u, 8668509133242695101u, 2220817526946637764u, 14785959416745495464u, 3559622u},
    {2955954632941601789u, 10107657674468395933u, 5311640640975390062u, 14621297446480548630u, 1605387u},
    {8790097811146260065u, 11864754210433691726u, 7760619429925913465u, 11702944411893883434u, 1647035u},
    {1396131319364683211u, 3535793867739225199u, 4422459214799430311u, 14946304410679469375u, 105305u},
    {836210371572383058u, 6651239046405737457u, 228596760903606774u, 12251733535778735515u, 413189u},
    {5386992065803768348u, 9808912246349030036u, 12938526721533014058u, 5628114338947184519u, 1349930u},
    {18243732274116100544u, 6095631440660301383u, 17712036077187186016u, 15084938972782475697u, 3078212u},
    {5410614946778594554u, 3627718986757041100u, 1502787801529895711u, 9352212634946264343u, 3573179u},
    {4808879283015740228u, 5734403252190775542u, 16232611027962708388u, 16567102562580263400u, 2517662u},
    {15074865610852957478u, 17138845205980888887u, 13298353594465057487u, 1415536969865837083u, 181369u},
    {3215181748209241782u, 11879645628319542399u, 9829889687442582275u, 5191492439672252989u, 2977243u},
    {9533581914699679042u, 6055296991177826251u, 4687828229495214812u, 8845946917484943878u, 750196u},
    {6138272657284596947u, 17724868308011159377u, 4963292291460981444u, 5418158235307662728u, 1641190u},
    {17913436394067193u, 4719092793817240435u, 5982754443768591228u, 16315290869896203150u, 847080u},
    {11165721271584405755u, 12461331021080466157u, 16216245505375593611u, 12481589652846781684u, 3346154u},
    {10506627565587357070u, 9100427802032021861u, 15216102122136500901u, 12815919803664053835u, 1567348u},
    {1628505232878893293u, 10346538011587209320u, 17898658173696642503u, 15953640762628434177u, 2688730u},
    {6222787016095775008u, 13368602903635598881u, 6362685239406301595u, 10425891871608568629u, 1358098u},
    {7494396223279468403u, 39231570987132471u, 4411631029970460835u, 15229204838661703162u, 1310412u},
    {6622175540993423761u, 7200695754137047825u, 11324990298289834953u, 4275570898262070943u, 3529913u},
    {11604162864143297976u, 136730391774779407u, 13568693556989957957u, 11017869699754077474u, 856197u},
    {231443469630765282u, 11065256798596426487u, 13263980556083488144u, 15003773617842558284u, 197265u},
    {7220021227503664504u, 5584621324006734276u, 9999768280786938596u, 14919560877824556684u, 3256857u},
    {15281378499589268192u, 4808950561408847418u, 17930006436231962158u, 4455591658796834442u, 821901u},
    {9815468154035989570u, 26162763674275786u, 18069996239286899929u, 5995941707004536300u, 564811u},
    {15083284783641763683u, 10389861951857482239u, 10372989304946159873u, 9161733372779805544u, 2324956u},
    {1046514188172317047u, 12746975261617533349u, 1231033145955314954u, 1844327728424567237u, 1805401u},
    {17336570704377495943u, 14760970287609589612u, 11467330887958458008u, 2987665127596792402u, 3001549u},
    {5031603216852328857u, 9991217478536001002u, 9965772073360574794u, 12016929419511401334u, 1545373u},
    {18403959032577986226u, 10463429071374760616u, 7763756856812101418u, 4856365912787521882u, 3392451u},
    {14465575017249192113u, 10010704651571414703u, 16173601578585591295u, 18437266159907589634u, 94340u},
    {7128802682589112678u, 2285530921943211468u, 129921799743799405u, 16142641348769037583u, 3592961u},
    {10796433861495111306u, 6038444810961221594u, 974219759880607843u, 1579487922972947549u, 129039u},
    {14068486301533810771u, 14662723087985178753u, 14829790853671451568u, 6991966972667025121u, 2835265u},
    {13343936695945433855u, 4489807361977443856u, 9768719806010252745u, 10932998114555231420u, 944825u},
    {18128362433926322011u, 13173606977861702988u, 12189951972050643985u, 12843680694653613349u, 2441723u},
    {12680636848510486584u, 12059460390407640516u, 2842416692591136501u, 7683146820143932218u, 341121u},
    {14710576623532464057u, 9732187945063324180u, 1858209782464432532u, 10454643714967865416u, 2607658u},
    {17222971517518238375u, 3812477815900081436u, 16892435144294585419u, 7902380560346550040u, 742438u},
    {9081465457776348551u, 10669961781771068961u, 7917893171745686780u, 16731057388478258484u, 392307u},
    {9935217455940083149u, 12271990104083918155u, 10036441730824959107u, 7573284177540815441u, 1260608u},
    {3327385539637457872u, 8326620682385708290u, 18158199541095962255u, 17245019095791331731u, 2294892u},
    {2128753125735335227u, 17409526145623085964u, 2185518660468133050u, 6023113607793841244u, 2824662u},
    {16704028143376675540u, 12977491556413167170u, 5176064819630836949u, 5096137405686801697u, 2193351u},
    {9946891762250854030u, 17966360563007133343u, 7993101734656195088u, 12290251176104701444u, 3160328u},
    {16988121346925906564u, 11404628706040047804u, 17417258817491081249u, 8705209058646581855u, 2195518u},
    {14617701698647398653u, 12212909260280933675u, 18288820463647370760u, 5012474155977459289u, 2560466u},
    {16053577051913949771u, 838040760569874828u, 14120472462006123788u, 9847065055182108252u, 1202261u},
    {3112131835772018091u, 3190567966653705171u, 7701737542331928840u, 10902874510550985510u, 1531674u},
    {15683072709948397667u, 15839672082642710008u, 5771445628083632110u, 12638333365822618314u, 3814565u},
    {15827955608743309984u, 12288928979573264841u, 10749016541389771995u, 16211267381441720905u, 319358u},
    {778216663435051869u, 15267811570028005148u, 7871289034673287260u, 16435022572152728524u, 535306u},
    {2735549361651364459u, 16388965146434404326u, 7195761645311013531u, 17952215584662199801u, 1746737u},
    {3594551553084988511u, 11058104016047104068u, 13342101902120161751u, 13506991713447818817u, 2786593u},
    {8793831561912584315u, 1171911165863493889u, 260156381921755448u, 12373252161901259290u, 3168709u},
    {5115196565987732287u, 2412804463648649992u, 9091349316968691435u, 1355489069023015129u, 3362008u},
    {2763911530149577976u, 71085397697815685u, 4287393318167335505u, 11807405930687506739u, 3123097u},
    {14456762420116067273u, 13452748565002599777u, 3888232224239306508u, 11226538058762606090u, 325964u},
    {3473807645155228677u, 909268289257813287u, 840505864442743895u, 14633704575411151727u, 3615332u},
    {15534069430202589752u, 3992394122456623897u, 1367424654308281123u, 138748712817125012u, 2027676u},
    {11750868057785972853u, 18062254366669224674u, 11061579533629747118u, 9765179215495423161u, 3071534u},
    {5513773172982866293u, 13418508419173679804u, 7539592079264422628u, 5172748988069760065u, 2449868u},
    {5937066507828000126u, 14401843061015577190u, 16014480978552531979u, 117249687221047595u, 1479400u},
    {14486153860429536638u, 15231511626430815804u, 16265564084726747423u, 17104939900288816429u, 1531767u},
    {18415001447502500144u, 11222435358730766191u, 719458102400720719u, 15088293284861432383u, 2501025u},
    {4936277583447785163u, 16414725411745409071u, 3538800934132360779u, 9773910978305514076u, 2247331u},
    {7995061774761215788u, 16390513770193050158u, 11958119779556257414u, 11858901371800006242u, 1609221u},
    {1137307266080717301u, 7099787708526793308u, 2970984245106818896u, 534088058069435882u, 3647558u},
    {11117878553590733514u, 4248813777173273666u, 13702049839251513343u, 4102510835578064338u, 1523776u},
    {15195641541913897527u, 11270248718091313141u, 5557752278841107900u, 2766297283441433249u, 232935u},
    {17878765979630344639u, 6653586457663804068u, 15626351446231067115u, 8074747427345035649u, 3256986u},
    {15233290062057140988u, 9478998076210953482u, 454251549610050997u, 1717405458140744933u, 1158254u},
    {10682706261290781589u, 4718133868474186559u, 2549033760149055783u, 5569800757748206913u, 2598999u},
    {3378859113687296926u, 3256029912781427291u, 12703152873407295567u, 16981477673883692768u, 2548358u},
    {13143093737763085855u, 14735220486512897174u, 7761270127767881728u, 16115852395273597727u, 1564738u},
    {6806689602301491056u, 13870053166838689704u, 11992492764156146259u, 1181785842151107507u, 3112989u},
    {8764058889124636622u, 13833758588265944409u, 9714935922749324875u, 7407299104437708337u, 2290140u},
    {8576749489612682478u, 7160865705701573768u, 17996174556451388561u, 11859691056100445800u, 3231094u},
    {5189278819097876290u, 10846947927436530574u, 1283777264825671273u, 10291781529341556458u, 1872677u},
    {16443117435152141483u, 8846968319359760663u, 6145578721832857922u, 1619811872477918303u, 3904599u},
    {4227080404498025085u, 13380746375313008113u, 151268601765546199u, 18230540837641113986u, 3614388u},
    {10704405063104756109u, 15496676266558640734u, 8990297314954259782u, 17000208307562692716u, 1196652u},
    {9694264555392470473u, 12520435174633466129u, 17027863841505195290u, 11407174208182114877u, 293694u},
    {1816331087029685360u, 16114060806134628409u, 4324366577972643852u, 3968585381547194741u, 1436728u},
    {8428140741519719452u, 11522782239802170276u, 4083134951242384630u, 4277901005925866182u, 2668339u},
    {10219737730036645343u, 8642785239040191649u, 3234673581576716688u, 11650494811019196773u, 3102718u},
    {13009423730211941454u, 7253061734181005588u, 10885221892197257681u, 14180523487963262219u, 2963233u},
    {426151455724944859u, 15824554777022613988u, 13410722945213594139u, 9061861269703286063u, 2383719u},
    {108292792102484096u, 17878710012837738239u, 6858978466619296251u, 1845411714346698528u, 702374u},
    {8601379684324597817u, 3315138975551343541u, 17587769819462766325u, 13992129758625458970u, 3546644u},
    {4666216170483899289u, 16954688572015427027u, 11197831739477553164u, 2227151869318525377u, 1040982u},
    {3673905850905659437u, 14071216757856367821u, 14367288857603700736u, 10179323490114329161u, 623139u},
    {4281971814666628802u, 1211126456466863187u, 7356041076078618327u, 6208447983096473282u, 1575332u},
    {2522217473862407442u, 5754377531831148304u, 8537333832080279475u, 4496630582795105030u, 3557342u},
    {18312747222428248087u, 16303562743945007166u, 10327773115955366529u, 9361051012845992410u, 181406u},
    {6764951709182064129u, 14056201790058773145u, 14138405659210517991u, 13622231632584866271u, 3455415u},
    {13994235330253804396u, 6100267572861915980u, 16271262577242946164u, 3018102525350734098u, 2833420u},
    {13878002310840923763u, 17871354197893362687u, 1670183314141577674u, 7402141968480082115u, 3168237u},
    {16000293778491292933u, 11275546249230197397u, 3012410622940790108u, 14974365630357082049u, 811751u},
    {6087539284501660232u, 4998159116211716394u, 10900580724877741590u, 10319210125346638280u, 2797532u},
    {9993231891208907230u, 13837431455266334446u, 12876749563979580640u, 267778149275006762u, 2735529u},
    {8382129349548215775u, 1542669049600096707u, 5489227641296364690u, 11291446273553746781u, 3299610u},
    {5516119613907047514u, 14979585296753961911u, 2977609626579672501u, 13175349187407383399u, 1406051u},
    {10647943380813449565u, 2907493561845860151u, 3073445513938851804u, 8312560390488645216u, 712474u},
    {17532424112347612693u, 5372116226072386606u, 10453828899225684285u, 11686473067994058161u, 1010745u},
    {2720915096716552204u, 11977787865941658494u, 13690658447313264211u, 8953786626728318692u, 2401478u},
    {15965090867940909875u, 1767243307208887572u, 5976876803325239457u, 17770467592348702749u, 1574353u},
    {9445635322637490872u, 7235178439029485563u, 1180724387911386594u, 2478999901932694270u, 3629012u},
    {8784659385441617853u, 298623020743601112u, 4828945536308766477u, 3381592783828105805u, 2047793u},
    {16851442944114390247u, 9363824900894580774u, 12183876956225307170u, 10269953470154293599u, 99161u},
    {2527534040988106475u, 6463768094179847511u, 38512663292365915u, 3316478533603731639u, 1458079u},
    {10879139225205765006u, 6764376103577753041u, 16868390899932708248u, 18185410511026568754u, 567344u},
    {1505177902433141259u, 7910103618104134260u, 16207247711010908612u, 1019271984286156286u, 3726447u},
    {17827379516609790882u, 8233586534983171714u, 14332098912834160608u, 6553924278546028961u, 2492929u},
    {13658040202392662726u, 2053237141024669218u, 6392760217081708029u, 1775368686721123421u, 196924u},
    {12201358372563990094u, 1115432354699780858u, 8551036275529134882u, 4182973062605160154u, 2494390u},
    {17432686608531432282u, 13141010120416301380u, 1117769286970557887u, 2712144357536327063u, 2732099u},
    {3076533310437682955u, 18031099079455942252u, 14699270436506123246u, 11147267815590084293u, 2330011u},
    {15974700552047774490u, 5963772425143157560u, 12182821369612758115u, 18057379637235179881u, 451467u},
    {1790377686543288661u, 6426878162853982158u, 6910160543243892166u, 13771328575508340843u, 2177990u},
    {4734889278235389514u, 13694823957905830050u, 15356410538565500739u, 12217910230306248425u, 3256310u},
    {4940127239235159513u, 1254247620377406056u, 6067971346679267373u, 14687759919111942388u, 2635702u},
    {3103493952278613044u, 8385308655597079418u, 13380102691846303119u, 985368857429387499u, 801635u},
    {15674995821493830130u, 15541051011237155763u, 15478287740408584126u, 5274991921439636341u, 671935u},
    {3049240077997597800u, 14428093997440117339u, 87314007649121234u, 8803421490881368141u, 2307363u},
    {12056940001640482681u, 1408180516870697591u, 492837031371849597u, 6527746806963082423u, 423470u},
    {17116795653091423947u, 8448008991283598490u, 14497479583997498540u, 4835670449781812302u, 888254u},
    {6535578620280622934u, 3484892416787575833u, 15549328126755432389u, 2033998032108101461u, 2854452u},
    {6213170825550943975u, 15254451580615560737u, 2536351564906480748u, 9492200166517246025u, 1703569u},
    {5663846414049160160u, 676877684958449268u, 12067187204354027971u, 11848870733067286977u, 839414u},
    {1287432585512013122u, 1314507364864117891u, 11574963001885200726u, 4122767327240651914u, 28257u},
    {17631769928639780226u, 13069627788091010666u, 750141028296522576u, 10520929983307536794u, 784775u},
    {4105580169528682595u, 11143015500950440272u, 12488135722670604709u, 14930398519952458148u, 1735330u},
    {15431793173864878523u, 2625199639248403524u, 2919223604103209523u, 16677315426085182132u, 3087401u},
    {16199380579055243385u, 6190740060462280094u, 8374308033667419079u, 13315549815755970593u, 947112u},
    {657285509703155795u, 16003702286386994438u, 11180637723027171516u, 16662775368750042232u, 2971865u},
    {4571935609895582618u, 10140246585327919918u, 6702183076670807580u, 8053214187949391101u, 128652u},
    {16744449868919279259u, 9991016847126731634u, 3392222189368185971u, 9802206007729984365u, 3865594u},
    {10623414147704413797u, 14825918928000665168u, 3679835260366254211u, 16140151103471002936u, 3779161u},
    {5864500637313506171u, 9593546609696871271u, 4900877694986104060u, 3240247369589324550u, 363295u},
    {18236992627519070814u, 3098764875834319937u, 2650045792406818072u, 5050733195783461201u, 370342u},
    {13919421988590745908u, 11376233249084909530u, 10109440601604888841u, 10455182744644029658u, 2101315u},
    {8526949797469687808u, 8234272554414658530u, 1807867592136634947u, 15891433118822575651u, 2950573u},
    {3772915267147399152u, 10446414254052827845u, 12227454176344899216u, 18284999772488998339u, 1685395u},
    {17891246297378127299u, 13845206726448170012u, 4332156227366192109u, 1760472325423379946u, 837549u},
    {2858533969077768263u, 17879436406746524723u, 12355797603676206867u, 10968204347577709958u, 696025u},
    {14683406164556521420u, 6143898332277122492u, 4450025369655573385u, 17306661975114812678u, 2495131u},
    {13665554554234091254u, 1589773042706453882u, 6419363160718790642u, 18420713539965664642u, 1677590u},
    {7950007068383239002u, 15134135955573371859u, 12196066363385447255u, 11992506702107365322u, 2155253u},
    {11096776499754033643u, 2916171537601982289u, 6574496522988937928u, 39757412497601434u, 0u},
    {12154593641719839759u, 11207416616133166218u, 9179126310283371106u, 39757412u, 0u},
    {12589633261743469429u, 3983554065613025059u, 733394813376155322u, 0u, 0u},
    {3783895972321119332u, 6938840960881362188u, 733394813u, 0u, 0u},
    {11280737333392521778u, 13528746427335915784u, 0u, 0u, 0u},
    {6196552509048235153u, 13528746427u, 0u, 0u, 0u},
    {9753650024953902562u, 13u, 0u, 0u, 0u},
    {249561322984u, 0u, 0u, 0u, 0u},
    {250u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2520096u},
    {14963224324489997650u, 11389384593919078847u, 3491509993308569406u, 3505252079773720074u, 1541451u},
    {2150130054507271957u, 8558766222609150583u, 15158702150640854473u, 5072466338259371261u, 3342151u},
    {16867228019297918990u, 13157031475575789394u, 16645184832145666244u, 5538028956107681925u, 3897532u},
    {16756010898447423213u, 14313449214631935868u, 4366226962259694685u, 11961399797119231732u, 3565201u},
    {16468343996428969880u, 11619903921274525778u, 4614389356244128853u, 12964075695168833708u, 239298u},
    {17421992076028196646u, 1029307467665349535u, 8327584793807119972u, 13551241961057878211u, 3494989u},
    {713661140445009190u, 9993577688815081172u, 2780485766891497572u, 12098089385508637345u, 3817107u},
    {8911506143382986336u, 5909873502785962737u, 17504710490947064944u, 9149670056807974566u, 1381814u},
    {7725748796886738781u, 5241177181355879934u, 3037920327560200971u, 2259275393540904963u, 74580u},
    {14191797396146604536u, 6819017129188920896u, 16609932464910726962u, 15205528102435087147u, 1896333u},
    {8082586438004890858u, 16609399708276230958u, 10693785543178790611u, 2124651411834968101u, 2811287u},
    {8771990215588977469u, 7956001396154068295u, 1270203940319661961u, 5816466616965632996u, 815134u},
    {11236234845003952833u, 6850357080173821364u, 11300282467881664258u, 15147131322065112338u, 926436u},
    {3228642794689798719u, 5156847854869912149u, 4169571328093083209u, 2539105534267280264u, 546737u},
    {8910748224524211486u, 17819719048616251099u, 7178684310028642175u, 6062923419239679897u, 2570453u},
    {11042549713965935253u, 13086402406659882352u, 5897091031579377135u, 11864861916927603861u, 952102u},
    {9590859228896611829u, 15189916504625425251u, 8122114205145049688u, 13348218090807597088u, 1170821u},
    {7440841085850424834u, 2166925612298891872u, 13654166044390525081u, 8668509133242695101u, 1062220u},
    {14806075191001333758u, 1349390712799872791u, 2955954632941601788u, 10107657674468395933u, 2564614u},
    {635172898126604777u, 18162618099463630960u, 8790097811146260064u, 11864754210433691726u, 269519u},
    {7340410748711222717u, 13997369941531684028u, 1396131319364683210u, 3535793867739225199u, 1189391u},
    {5143274482816113298u, 12818976172418430765u, 836210371572383057u, 6651239046405737457u, 492198u},
    {4757298662990189780u, 12614947880990965u, 5386992065803768347u, 9808912246349030036u, 2319842u},
    {18326186581611486296u, 1487111482462219172u, 18243732274116100543u, 6095631440660301383u, 1346540u},
    {3589185742865976949u, 17058584359052834618u, 5410614946778594553u, 3627718986757041100u, 2268873u},
    {7443447069830788370u, 16469644953357341706u, 4808879283015740227u, 5734403252190775542u, 3317410u},
    {3260038669695118684u, 9248552947342934648u, 15074865610852957477u, 17138845205980888887u, 3371879u},
    {16478633945712194314u, 15057979299746860754u, 3215181748209241781u, 11879645628319542399u, 133307u},
    {18267420819183949134u, 14107582095377503273u, 9533581914699679041u, 6055296991177826251u, 3835786u},
    {16222274116537733080u, 3909143131100059106u, 6138272657284596946u, 17724868308011159377u, 1916282u},
    {13606676791440815271u, 992928654413570212u, 17913436394067192u, 4719092793817240435u, 3655108u},
    {2683053335046956766u, 10097330810525471373u, 11165721271584405754u, 12461331021080466157u, 1147679u},
    {544784245870775740u, 8719334872089033464u, 10506627565587357069u, 9100427802032021861u, 2293199u},
    {17860891863182057957u, 10144273889656468846u, 1628505232878893292u, 10346538011587209320u, 2057165u},
    {12955120304882629778u, 9869684199642673606u, 6222787016095775007u, 13368602903635598881u, 2126747u},
    {11712667301647333050u, 11926379635504385298u, 7494396223279468402u, 39231570987132471u, 3631749u},
    {13867262577266153886u, 8683031534007069301u, 6622175540993423760u, 7200695754137047825u, 3505919u},
    {16428302919004761321u, 15330480708510465235u, 11604162864143297975u, 136730391774779407u, 2192523u},
    {16414024219315546785u, 13093741994702691568u, 231443469630765281u, 11065256798596426487u, 1961678u},
    {5847068617528413306u, 15115288688849558804u, 7220021227503664503u, 5584621324006734276u, 2881232u},
    {9342895507318156621u, 6490455760899253929u, 15281378499589268191u, 4808950561408847418u, 1418286u},
    {9251732974427051992u, 5196080629613649262u, 9815468154035989569u, 26162763674275786u, 735545u},
    {10209083075950703676u, 13233016562531765238u, 15083284783641763682u, 10389861951857482239u, 3514913u},
    {6052808062563118438u, 8281762315383401556u, 1046514188172317046u, 12746975261617533349u, 3318802u},
    {8654559827205954427u, 11174202705391720737u, 17336570704377495942u, 14760970287609589612u, 2562484u},
    {3911664279053078871u, 4307787690009944773u, 5031603216852328856u, 9991217478536001002u, 817376u},
    {5994008967297030077u, 11180710749620438989u, 18403959032577986225u, 10463429071374760616u, 3618886u},
    {5532166397295158923u, 17655373174764668267u, 14465575017249192112u, 10010704651571414703u, 2805129u},
    {11540327573144823602u, 7422231668005243183u, 7128802682589112677u, 2285530921943211468u, 3125999u},
    {7438460055861835045u, 3347890532008437999u, 10796433861495111305u, 6038444810961221594u, 1899061u},
    {17178131957961743799u, 4939116190252224819u, 14068486301533810770u, 14662723087985178753u, 1205444u},
    {6820302362678979166u, 12252181357377424741u, 13343936695945433854u, 4489807361977443856u, 3205165u},
    {11188964507961062043u, 18278424740519322061u, 18128362433926322010u, 13173606977861702988u, 1400907u},
    {1103436667525303789u, 7008678282203960970u, 12680636848510486583u, 12059460390407640516u, 239215u},
    {8140493447788539174u, 1638208843953013739u, 14710576623532464056u, 9732187945063324180u, 3549836u},
    {18229429833659724183u, 8586224302092155942u, 17222971517518238374u, 3812477815900081436u, 294787u},
    {4764282926977300820u, 13173167156239170472u, 9081465457776348550u, 10669961781771068961u, 1203416u},
    {892771209770276608u, 1086019272201853952u, 9935217455940083148u, 12271990104083918155u, 2168261u},
    {800563901267730685u, 6859784152735499991u, 3327385539637457871u, 8326620682385708290u, 2366053u},
    {11598561061761846662u, 2428655516711388638u, 2128753125735335226u, 17409526145623085964u, 386226u},
    {309682733622888150u, 11736890448633819222u, 16704028143376675539u, 12977491556413167170u, 1302107u},
    {14010516807499617018u, 786939054705287679u, 9946891762250854029u, 17966360563007133343u, 1058660u},
    {11012804196672894594u, 811569616057899195u, 16988121346925906563u, 11404628706040047804u, 1906887u},
    {2079176420364759115u, 7564185157533017843u, 14617701698647398652u, 12212909260280933675u, 2461530u},
    {5458597346919974974u, 5123677842727599396u, 16053577051913949770u, 838040760569874828u, 1086036u},
    {10645201696524484068u, 6196265656020829478u, 3112131835772018090u, 3190567966653705171u, 3201594u},
    {15697406630836735019u, 7948430675952387179u, 15683072709948397666u, 15839672082642710008u, 2121674u},
    {11416228514506732429u, 311158543285630822u, 15827955608743309983u, 12288928979573264841u, 3450973u},
    {3000909954753848868u, 1176712768811958718u, 778216663435051868u, 15267811570028005148u, 1728830u},
    {4533187267081688317u, 8600748603831512115u, 2735549361651364458u, 16388965146434404326u, 1804769u},
    {3400397599705217499u, 7070432954170676363u, 3594551553084988510u, 11058104016047104068u, 1029431u},
    {1650129642873998234u, 6307383310244388816u, 8793831561912584314u, 1171911165863493889u, 1892142u},
    {18358123260498433959u, 7737259728605307370u, 5115196565987732286u, 2412804463648649992u, 3853547u},
    {3090420130982272599u, 18102782217632167566u, 2763911530149577975u, 71085397697815685u, 2712461u},
    {14560191857171083507u, 13385476812278851867u, 14456762420116067272u, 13452748565002599777u, 2416532u},
    {12602915233476787774u, 12061357435333306567u, 3473807645155228676u, 909268289257813287u, 1584369u},
    {18143949618332935867u, 18237958892617252591u, 15534069430202589751u, 3992394122456623897u, 2594271u},
    {7163296031649987885u, 17069249692931290532u, 11750868057785972852u, 18062254366669224674u, 856298u},
    {13438521612961682289u, 11494091060468826864u, 5513773172982866292u, 13418508419173679804u, 3381726u},
    {9882434666227645667u, 4277479210201382418u, 5937066507828000125u, 14401843061015577190u, 1483149u},
    {9607296051469423088u, 4021281542576823239u, 14486153860429536637u, 15231511626430815804u, 2900689u},
    {13425809650469839804u, 16162466880312551937u, 18415001447502500143u, 11222435358730766191u, 3125297u},
    {8346178327434844325u, 3754230291009494723u, 4936277583447785162u, 16414725411745409071u, 1812781u},
    {7342867918073078480u, 9007785569808861075u, 7995061774761215787u, 16390513770193050158u, 2067762u},
    {230430591545871092u, 14680889001796450910u, 1137307266080717300u, 7099787708526793308u, 3766156u},
    {10158473170184582126u, 4692596477881595087u, 11117878553590733513u, 4248813777173273666u, 1586407u},
    {7382838251157310884u, 6319049526880856250u, 15195641541913897526u, 11270248718091313141u, 1316644u},
    {9399401685980977795u, 12483964033960731940u, 17878765979630344638u, 6653586457663804068u, 2138765u},
    {767078273127119160u, 10363572052043058205u, 15233290062057140987u, 9478998076210953482u, 1864299u},
    {11468947560145123042u, 17713988551791969060u, 10682706261290781588u, 4718133868474186559u, 728485u},
    {9084610695673868367u, 686866230399018487u, 3378859113687296925u, 3256029912781427291u, 1922903u},
    {2455299848502328669u, 16901385595581526110u, 13143093737763085854u, 14735220486512897174u, 1897088u},
    {4641908539183754976u, 2790239140906134899u, 6806689602301491055u, 13870053166838689704u, 3835805u},
    {10551908080765004373u, 8139345416357914332u, 8764058889124636621u, 13833758588265944409u, 1472557u},
    {1121348879658933032u, 8370478660838535452u, 8576749489612682477u, 7160865705701573768u, 2076725u},
    {1649140618411437576u, 6940645850048690747u, 5189278819097876289u, 10846947927436530574u, 3032613u},
    {3225537958267426217u, 6662934470020762032u, 16443117435152141482u, 8846968319359760663u, 2715464u},
    {12836646777410151078u, 9411131748456617032u, 4227080404498025084u, 13380746375313008113u, 232753u},
    {15218157897703452661u, 7734794693298486001u, 10704405063104756108u, 15496676266558640734u, 2952900u},
    {14635713780320535937u, 5281388650291270217u, 9694264555392470472u, 12520435174633466129u, 2451236u},
    {8671191807627342224u, 8895841836966106347u, 1816331087029685359u, 16114060806134628409u, 3557526u},
    {697384536380306856u, 7809653406461972748u, 8428140741519719451u, 11522782239802170276u, 3682576u},
    {15385276606221819872u, 4306874296112585745u, 10219737730036645342u, 8642785239040191649u, 2564264u},
    {2243823318582472044u, 9505764207281473512u, 13009423730211941453u, 7253061734181005588u, 2382083u},
    {11796140468076538419u, 2437082545452561427u, 426151455724944858u, 15824554777022613988u, 456811u},
    {8768348776682149012u, 16564738660752319653u, 108292792102484095u, 17878710012837738239u, 26543u},
    {6986366474568131461u, 121839414559272868u, 8601379684324597816u, 3315138975551343541u, 1146759u},
    {15016632599297165030u, 3936187943941014220u, 4666216170483899288u, 16954688572015427027u, 1083438u},
    {3303837482698787603u, 16699664899914867690u, 3673905850905659436u, 14071216757856367821u, 3155296u},
    {5883973787801388405u, 13297873167929455668u, 4281971814666628801u, 1211126456466863187u, 3351681u},
    {14886458500059134318u, 3586905369782015633u, 2522217473862407441u, 5754377531831148304u, 1005407u},
    {8651330862616710523u, 5102540913754620624u, 18312747222428248086u, 16303562743945007166u, 269475u},
    {9422060007462648586u, 18026784433318864602u, 6764951709182064128u, 14056201790058773145u, 2571167u},
    {4986416913205086633u, 2562356071631853926u, 13994235330253804395u, 6100267572861915980u, 58052u},
    {13652651452885911793u, 17164174925158542282u, 13878002310840923762u, 17871354197893362687u, 1873586u},
    {15007330244968471608u, 5623991146071014423u, 16000293778491292932u, 11275546249230197397u, 1419498u},
    {7463899004850198726u, 2896241610454369459u, 6087539284501660231u, 4998159116211716394u, 128662u},
    {15410180732058766289u, 11444448699724409754u, 9993231891208907229u, 13837431455266334446u, 1597006u},
    {9261087711795740879u, 1276011123678681474u, 8382129349548215774u, 1542669049600096707u, 3451196u},
    {15328714285769511135u, 1115025658555961766u, 5516119613907047513u, 14979585296753961911u, 1365541u},
    {7125274909668851658u, 9211997498872791051u, 10647943380813449564u, 2907493561845860151u, 2160504u},
    {17809149250697883319u, 14555171065384166755u, 17532424112347612692u, 5372116226072386606u, 879681u},
    {1178775353658319038u, 11685892924135550671u, 2720915096716552203u, 11977787865941658494u, 2052451u},
    {8872442636068082475u, 4158950597131511317u, 15965090867940909874u, 1767243307208887572u, 1594809u},
    {777519148192623790u, 14015063786189101696u, 9445635322637490871u, 7235178439029485563u, 563386u},
    {4759902213636253737u, 1700064768335267291u, 8784659385441617852u, 298623020743601112u, 3707715u},
    {14595946315881665349u, 4781357032295120577u, 16851442944114390246u, 9363824900894580774u, 2745320u},
    {864262754313457791u, 4113752138089899324u, 2527534040988106474u, 6463768094179847511u, 3416313u},
    {11717736565508395327u, 15414394094182263199u, 10879139225205765005u, 6764376103577753041u, 3026326u},
    {1951648397690962651u, 7360618304626221262u, 1505177902433141258u, 7910103618104134260u, 1031120u},
    {11580870912047404804u, 1726912946215693860u, 17827379516609790881u, 8233586534983171714u, 1931208u},
    {13689725541252266512u, 3569436734295110235u, 13658040202392662725u, 2053237141024669218u, 1873959u},
    {18300286291953268689u, 12209776626367144347u, 12201358372563990093u, 1115432354699780858u, 1438086u},
    {10716653309414535517u, 6339589541202254215u, 17432686608531432281u, 13141010120416301380u, 905339u},
    {2134866328770398121u, 4516241556358680171u, 3076533310437682954u, 18031099079455942252u, 2984250u},
    {659669349928542956u, 3403981119532262826u, 15974700552047774489u, 5963772425143157560u, 745513u},
    {15189603543185481713u, 13200275656044167529u, 1790377686543288660u, 6426878162853982158u, 210394u},
    {56911190582793378u, 16019699549664923915u, 4734889278235389513u, 13694823957905830050u, 1586649u},
    {8384141602689175680u, 17943171164074281059u, 4940127239235159512u, 1254247620377406056u, 1443493u},
    {13621365722994392862u, 321006864112955218u, 3103493952278613043u, 8385308655597079418u, 2638313u},
    {16304703775166674663u, 8706240791520124192u, 15674995821493830129u, 15541051011237155763u, 898542u},
    {15885989508942689067u, 11663697150181090484u, 3049240077997597799u, 14428093997440117339u, 2118868u},
    {12074149959701031660u, 14499499292283500970u, 12056940001640482680u, 1408180516870697591u, 936235u},
    {3624801935308207634u, 15391002120449532598u, 17116795653091423946u, 8448008991283598490u, 1416396u},
    {17064595767702521467u, 11059124913206412349u, 6535578620280622933u, 3484892416787575833u, 2726727u},
    {7894031736609437814u, 4189321500415139449u, 6213170825550943974u, 15254451580615560737u, 1537362u},
    {6167205082452575041u, 6195597956737981145u, 5663846414049160159u, 676877684958449268u, 947087u},
    {7135131420141039163u, 1767307274735145288u, 1287432585512013121u, 1314507364864117891u, 1474692u},
    {4543177621977861254u, 14278638223373505857u, 17631769928639780225u, 13069627788091010666u, 2501580u},
    {16913170929078625355u, 3457232728918042383u, 4105580169528682594u, 11143015500950440272u, 1687357u},
    {11300958575141676776u, 7665063744243187884u, 15431793173864878522u, 2625199639248403524u, 3569441u},
    {14122117369634058654u, 3816435857921876799u, 16199380579055243384u, 6190740060462280094u, 374939u},
    {11707328538378237465u, 4292123334774082280u, 657285509703155794u, 16003702286386994438u, 2828868u},
    {15006589384887660371u, 6902391818213759869u, 4571935609895582617u, 10140246585327919918u, 2551608u},
    {7514028806633014668u, 2359179064933838103u, 16744449868919279258u, 9991016847126731634u, 2933425u},
    {1316487592784093586u, 5766758452645896626u, 10623414147704413796u, 14825918928000665168u, 535953u},
    {16570810885058932117u, 17860190228046444546u, 5864500637313506170u, 9593546609696871271u, 15630u},
    {14240154511563228086u, 17350774806361648705u, 18236992627519070813u, 3098764875834319937u, 3425590u},
    {2734534748849016061u, 10330140635243459609u, 13919421988590745907u, 11376233249084909530u, 1068309u},
    {5675765515999334478u, 523782229561575093u, 8526949797469687807u, 8234272554414658530u, 3801251u},
    {5321402015758102567u, 1562508269730049146u, 3772915267147399151u, 10446414254052827845u, 550160u},
    {15841747306588348236u, 2796150661406838904u, 17891246297378127298u, 13845206726448170012u, 496189u},
    {2395554854148184037u, 13089954847163284877u, 2858533969077768262u, 17879436406746524723u, 1030145u},
    {15162723299945295059u, 15803542410279793803u, 14683406164556521419u, 6143898332277122492u, 244269u},
    {17895523702890258955u, 15296301315385865968u, 13665554554234091253u, 1589773042706453882u, 110654u},
    {9620843901732566630u, 9354653637460668449u, 7950007068383239001u, 15134135955573371859u, 1835975u},
    {7018882256051449234u, 9842126478754130139u, 11096776499754033642u, 2916171537601982289u, 2086522u},
    {10870410009040504977u, 15144015006933936003u, 12154593641719839758u, 11207416616133166218u, 1105148u},
    {10360926436841196830u, 4658237019430707470u, 12589633261743469428u, 3983554065613025059u, 1155322u},
    {2981206617418536144u, 11089880088956586909u, 3783895972321119331u, 6938840960881362188u, 2926063u},
    {14966027586934365539u, 3973297103941439736u, 11280737333392521777u, 13528746427335915784u, 0u},
    {11935096409705087177u, 14197144052036709039u, 6196552509048235152u, 13528746427u, 0u},
    {11562094221045896822u, 14394200723298427545u, 9753650024953902561u, 13u, 0u},
    {17510849428582451348u, 3284877568029259648u, 249561322983u, 0u, 0u},
    {13186658265229079375u, 10354581413377094956u, 249u, 0u, 0u},
    {1022822903734616835u, 4603593855767u, 0u, 0u, 0u},
    {10954705351568313214u, 4603u, 0u, 0u, 0u},
    {84921317676637u, 0u, 0u, 0u, 0u},
    {84922u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 232276u},
    {9544922693039852821u, 1552364644447806992u, 14963224324489997649u, 11389384593919078847u, 3034146u},
    {9776328400126259048u, 6025462508257812598u, 2150130054507271956u, 8558766222609150583u, 2306605u},
    {5483302470212491724u, 8259178512808727109u, 16867228019297918989u, 13157031475575789394u, 2496136u},
    {8984133506774760269u, 10278778692544647157u, 16756010898447423212u, 14313449214631935868u, 1010003u},
    {711310979918671876u, 12366333246139599659u, 16468343996428969879u, 11619903921274525778u, 1111369u},
    {3486462577459687906u, 4430361749226089078u, 17421992076028196645u, 1029307467665349535u, 2690432u},
    {16282967376193909194u, 8785892692841624351u, 713661140445009189u, 9993577688815081172u, 62384u},
    {18155917721994058177u, 5760074152230293081u, 8911506143382986335u, 5909873502785962737u, 2874784u},
    {14926920430885836099u, 9951000745102574766u, 7725748796886738780u, 5241177181355879934u, 2472159u},
    {871232617085010102u, 429175095381131753u, 14191797396146604535u, 6819017129188920896u, 1959862u},
    {3720251557601928204u, 11808711682540450296u, 8082586438004890857u, 16609399708276230958u, 1608199u},
    {1304449704976415327u, 9930744344590383691u, 8771990215588977468u, 7956001396154068295u, 264851u},
    {14716406502706588006u, 15733693700005017641u, 11236234845003952832u, 6850357080173821364u, 2209532u},
    {14920922136569364893u, 9597391742173090430u, 3228642794689798718u, 5156847854869912149u, 1165155u},
    {12791646436553066722u, 3870074933336855957u, 8910748224524211485u, 17819719048616251099u, 2384045u},
    {17817713452448379684u, 6678772620050949251u, 11042549713965935252u, 13086402406659882352u, 3134523u},
    {17410952088431076483u, 12453610396562511882u, 9590859228896611828u, 15189916504625425251u, 281772u},
    {9264565441563240549u, 16772655501891978160u, 7440841085850424833u, 2166925612298891872u, 2838117u},
    {4541602272163400480u, 11624369585326071969u, 14806075191001333757u, 1349390712799872791u, 222500u},
    {4962671798184348120u, 9200756580052450441u, 635172898126604776u, 18162618099463630960u, 986444u},
    {5977262349995137412u, 11137011450820458079u, 7340410748711222716u, 13997369941531684028u, 3511840u},
    {6358233769885502626u, 12906283022838949243u, 5143274482816113297u, 12818976172418430765u, 683857u},
    {12280936604627242613u, 1616770966225356924u, 4757298662990189779u, 12614947880990965u, 2491475u},
    {452801687520674807u, 9678579003117800038u, 18326186581611486295u, 1487111482462219172u, 2872711u},
    {10811973281346338795u, 10150237243359397359u, 3589185742865976948u, 17058584359052834618u, 2196241u},
    {12723698385604186871u, 17431371316734367513u, 7443447069830788369u, 16469644953357341706u, 1365059u},
    {16738697647313281259u, 13820322241698389553u, 3260038669695118683u, 9248552947342934648u, 3794693u},
    {11632880175137960754u, 9460592539220848u, 16478633945712194313u, 15057979299746860754u, 3054807u},
    {13471095542199409412u, 6883250715963709074u, 18267420819183949133u, 14107582095377503273u, 977573u},
    {7692936046682662883u, 6715806306466504330u, 16222274116537733079u, 3909143131100059106u, 3045520u},
    {16029376669205164190u, 4593709580809643883u, 13606676791440815270u, 992928654413570212u, 502400u},
    {18323506465437095041u, 2404943756018318555u, 2683053335046956765u, 10097330810525471373u, 19840u},
    {14401493444780146220u, 4355877144002481833u, 544784245870775739u, 8719334872089033464u, 3047189u},
    {2079667217826273479u, 11592870097196467918u, 17860891863182057956u, 10144273889656468846u, 3786652u},
    {7616453694539322207u, 2975430389678679132u, 12955120304882629777u, 9869684199642673606u, 1999085u},
    {1650601016741369829u, 10680569507326631918u, 11712667301647333049u, 11926379635504385298u, 1958082u},
    {10639869144833147929u, 17599337721152748404u, 13867262577266153885u, 8683031534007069301u, 2942024u},
    {2612618350544432823u, 13933217717550008016u, 16428302919004761320u, 15330480708510465235u, 2781925u},
    {10242335059498393447u, 1209440128772621914u, 16414024219315546784u, 13093741994702691568u, 2995191u},
    {10535138501816158940u, 18052514427675119816u, 5847068617528413305u, 15115288688849558804u, 285811u},
    {1799442558715500074u, 1440531811509035401u, 9342895507318156620u, 6490455760899253929u, 430095u},
    {5643764103445170958u, 13662105147423385804u, 9251732974427051991u, 5196080629613649262u, 2519515u},
    {10089708104016215972u, 4112207656429587959u, 10209083075950703675u, 13233016562531765238u, 3642734u},
    {7320423471154220666u, 16531768888978224051u, 6052808062563118437u, 8281762315383401556u, 285992u},
    {17165555189095180926u, 9787054469368948472u, 8654559827205954426u, 11174202705391720737u, 3056888u},
    {17218036130489784097u, 10077905401685801049u, 3911664279053078870u, 4307787690009944773u, 638794u},
    {15616310378583196795u, 12447975473049448607u, 5994008967297030076u, 11180710749620438989u, 68447u},
    {16212878781301512743u, 6288774203306884991u, 5532166397295158922u, 17655373174764668267u, 16234u},
    {7751752773480450152u, 18330623633835243415u, 11540327573144823601u, 7422231668005243183u, 1802009u},
    {13935503222399667535u, 1347948488724911905u, 7438460055861835044u, 3347890532008437999u, 2125025u},
    {3410470084774101080u, 4378848043236993754u, 17178131957961743798u, 4939116190252224819u, 129582u},
    {18064661426381246776u, 4711163668892065003u, 6820302362678979165u, 12252181357377424741u, 2594140u},
    {13765107632437692971u, 11812897585094156893u, 11188964507961062042u, 18278424740519322061u, 1034960u},
    {2805597435717025667u, 12849344823641577559u, 1103436667525303788u, 7008678282203960970u, 2869979u},
    {6004792822095989395u, 2508955177331242894u, 8140493447788539173u, 1638208843953013739u, 616402u},
    {12101260354821714805u, 8192064550432325633u, 18229429833659724182u, 8586224302092155942u, 3181322u},
    {16655635499901791269u, 4343309622859857268u, 4764282926977300819u, 13173167156239170472u, 279472u},
    {3962894049740082573u, 8788301948211063135u, 892771209770276607u, 1086019272201853952u, 775894u},
    {3488522491728493974u, 4930901454728243751u, 800563901267730684u, 6859784152735499991u, 2751429u},
    {17898034145510537427u, 13428063192283209933u, 11598561061761846661u, 2428655516711388638u, 3445606u},
    {17733519418549352617u, 8501145218542683003u, 309682733622888149u, 11736890448633819222u, 3597551u},
    {9773208897871294825u, 13587782355614051963u, 14010516807499617017u, 786939054705287679u, 1026527u},
    {11262553553644895881u, 12548390161903866842u, 11012804196672894593u, 811569616057899195u, 3805299u},
    {10062568927712370603u, 6189787591201968698u, 2079176420364759114u, 7564185157533017843u, 411382u},
    {4069141496733943873u, 10836274068495337828u, 5458597346919974973u, 5123677842727599396u, 3868984u},
    {9137455149808994351u, 18156754128817155007u, 10645201696524484067u, 6196265656020829478u, 1197790u},
    {17470119716219336388u, 5528540037827429817u, 15697406630836735018u, 7948430675952387179u, 1242938u},
    {15834131303745073842u, 17793065440709560719u, 11416228514506732428u, 311158543285630822u, 1289727u},
    {13604115737339198992u, 16468391516278758297u, 3000909954753848867u, 1176712768811958718u, 1403766u},
    {1383821498263665501u, 6618331174715481688u, 4533187267081688316u, 8600748603831512115u, 476438u},
    {2629292500830563829u, 2456919709973393804u, 3400397599705217498u, 7070432954170676363u, 2080184u},
    {14938873665711301709u, 1185351067612788814u, 1650129642873998233u, 6307383310244388816u, 1468940u},
    {14056597526694697359u, 13563919123655673072u, 18358123260498433958u, 7737259728605307370u, 885040u},
    {6503505890488764516u, 17075452203037850789u, 3090420130982272598u, 18102782217632167566u, 2971901u},
    {9670531246967497697u, 7649073603589481855u, 14560191857171083506u, 13385476812278851867u, 1503746u},
    {2369010555103966218u, 17149287799035221774u, 12602915233476787773u, 12061357435333306567u, 400482u},
    {14378505889570988636u, 10613737041508415916u, 18143949618332935866u, 18237958892617252591u, 3450879u},
    {13521342631127412574u, 9928826195606392509u, 7163296031649987884u, 17069249692931290532u, 2002174u},
    {8278595286415432801u, 11064226871326654865u, 13438521612961682288u, 11494091060468826864u, 1413862u},
    {2456195215760162974u, 17020766200542348065u, 9882434666227645666u, 4277479210201382418u, 3150359u},
    {5260173800970004408u, 4203014247801534231u, 9607296051469423087u, 4021281542576823239u, 1169085u},
    {10439731290848729301u, 6239889198015204958u, 13425809650469839803u, 16162466880312551937u, 392231u},
    {2233492196171701620u, 14752199389251032795u, 8346178327434844324u, 3754230291009494723u, 31784u},
    {18293516768143841707u, 5827034935293705838u, 7342867918073078479u, 9007785569808861075u, 2883837u},
    {15807292712340517172u, 10689193695074089005u, 230430591545871091u, 14680889001796450910u, 479914u},
    {4545609151326610423u, 4311676207835441515u, 10158473170184582125u, 4692596477881595087u, 2712611u},
    {6676866223513441883u, 12340213849602489240u, 7382838251157310883u, 6319049526880856250u, 975796u},
    {13550819266076963760u, 8751686202239322029u, 9399401685980977794u, 12483964033960731940u, 3216616u},
    {7724052217580104689u, 14970376394173478076u, 767078273127119159u, 10363572052043058205u, 3245993u},
    {15515763568163615693u, 1395021145146373731u, 11468947560145123041u, 17713988551791969060u, 2078842u},
    {17599222802772363255u, 13461289261258710457u, 9084610695673868366u, 686866230399018487u, 2163449u},
    {1564565947319935726u, 4516963882638074136u, 2455299848502328668u, 16901385595581526110u, 2821666u},
    {5735508154757405484u, 13747032484475650754u, 4641908539183754975u, 2790239140906134899u, 3734799u},
    {13975459956404978154u, 8501349940827382324u, 10551908080765004372u, 8139345416357914332u, 639557u},
    {5538855176230992922u, 8104205795007902112u, 1121348879658933031u, 8370478660838535452u, 1253165u},
    {15340020180809590741u, 7527778744508757145u, 1649140618411437575u, 6940645850048690747u, 1823401u},
    {4220712329086266262u, 3073533472564764369u, 3225537958267426216u, 6662934470020762032u, 2365974u},
    {13561469251504093117u, 17632653695487708463u, 12836646777410151077u, 9411131748456617032u, 1335310u},
    {7000082777278187558u, 14723935631415452844u, 15218157897703452660u, 7734794693298486001u, 1148402u},
    {3699882871838773088u, 11785137588012493342u, 14635713780320535936u, 5281388650291270217u, 1775802u},
    {17489624836796702747u, 17073279211700674415u, 8671191807627342223u, 8895841836966106347u, 1487159u},
    {8466510980990509049u, 17519656463116747489u, 697384536380306855u, 7809653406461972748u, 3007373u},
    {3373143314032886446u, 12225260726612371432u, 15385276606221819871u, 4306874296112585745u, 3589760u},
    {11919781468460351465u, 5191362991232067452u, 2243823318582472043u, 9505764207281473512u, 3208259u},
    {7483852863273925645u, 3705628791001340868u, 11796140468076538418u, 2437082545452561427u, 3445032u},
    {17995993093598852422u, 18305461239317890046u, 8768348776682149011u, 16564738660752319653u, 2698677u},
    {10937539105207650401u, 14836752635322622885u, 6986366474568131460u, 121839414559272868u, 2443676u},
    {7918887463743107761u, 13658677755770711393u, 15016632599297165029u, 3936187943941014220u, 2946898u},
    {6704454107412203926u, 10706638530521821917u, 3303837482698787602u, 16699664899914867690u, 2129148u},
    {137169940296326113u, 8293547863858740262u, 5883973787801388404u, 13297873167929455668u, 3040279u},
    {14670173851142483687u, 3475073583697560585u, 14886458500059134317u, 3586905369782015633u, 3171797u},
    {15267496022405125145u, 18134139593813207329u, 8651330862616710522u, 5102540913754620624u, 671442u},
    {20207630190249667u, 5151778258160381509u, 9422060007462648585u, 18026784433318864602u, 2186850u},
    {18135786958391099935u, 5893716603552555542u, 4986416913205086632u, 2562356071631853926u, 784287u},
    {3608077311535880310u, 13512662839260132585u, 13652651452885911792u, 17164174925158542282u, 189670u},
    {4813776910211516553u, 17528078228329262844u, 15007330244968471607u, 5623991146071014423u, 755572u},
    {7266470521045224144u, 11689000889890228640u, 7463899004850198725u, 2896241610454369459u, 3217307u},
    {6960539758537718747u, 15487212310393831153u, 15410180732058766288u, 11444448699724409754u, 2766451u},
    {1976503720366122831u, 116056008726501173u, 9261087711795740878u, 1276011123678681474u, 1851912u},
    {14327278376995330765u, 8035525938998529052u, 15328714285769511134u, 1115025658555961766u, 3289635u},
    {4206703483242323876u, 10368611402927652380u, 7125274909668851657u, 9211997498872791051u, 3881154u},
    {17582003733547931211u, 5562436697037979488u, 17809149250697883318u, 14555171065384166755u, 681024u},
    {7750439385118271058u, 17712938908806295558u, 1178775353658319037u, 11685892924135550671u, 2800913u},
    {5588816958844505806u, 14206071920973144793u, 8872442636068082474u, 4158950597131511317u, 1945630u},
    {1107077827844377621u, 15179051428825912061u, 777519148192623789u, 14015063786189101696u, 2316945u},
    {5330319167274646076u, 16042883290468329336u, 4759902213636253736u, 1700064768335267291u, 1385384u},
    {7662122117625816156u, 11381735114129476261u, 14595946315881665348u, 4781357032295120577u, 350700u},
    {7368292585130470229u, 17791644493866757949u, 864262754313457790u, 4113752138089899324u, 3584728u},
    {4374730606852877363u, 944645643848710131u, 11717736565508395326u, 15414394094182263199u, 582417u},
    {6552547712071731083u, 5676875952862450466u, 1951648397690962650u, 7360618304626221262u, 3772388u},
    {4786671581008727391u, 14659608520907460701u, 11580870912047404803u, 1726912946215693860u, 2093303u},
    {12393776996761528386u, 5850601296391321502u, 13689725541252266511u, 3569436734295110235u, 1737067u},
    {8423179408044820809u, 3023344307481600921u, 18300286291953268688u, 12209776626367144347u, 3826087u},
    {4574016170585317995u, 9913946417056847145u, 10716653309414535516u, 6339589541202254215u, 2638445u},
    {12713768312563911172u, 3424137697711869376u, 2134866328770398120u, 4516241556358680171u, 936436u},
    {4459480617623405400u, 10950269004253621229u, 659669349928542955u, 3403981119532262826u, 744627u},
    {4973813262587865560u, 4527138753669974667u, 15189603543185481712u, 13200275656044167529u, 1242152u},
    {3354091697728302240u, 2926610779273970281u, 56911190582793377u, 16019699549664923915u, 45007u},
    {16817860143035544330u, 16253245594200871017u, 8384141602689175679u, 17943171164074281059u, 1776816u},
    {9161562935686482905u, 10094447950175204910u, 13621365722994392861u, 321006864112955218u, 3216259u},
    {9805768185799430870u, 8691889123723754805u, 16304703775166674662u, 8706240791520124192u, 3384039u},
    {5816610619930989147u, 11959387924577436841u, 15885989508942689066u, 11663697150181090484u, 863181u},
    {13546870389229220u, 736260222700362536u, 12074149959701031659u, 14499499292283500970u, 2316646u},
    {5802471605081383156u, 1822460008790171025u, 3624801935308207633u, 15391002120449532598u, 1860112u},
    {6085636086824265296u, 214518535267945765u, 17064595767702521466u, 11059124913206412349u, 541073u},
    {16616501906925412905u, 17984832769271435666u, 7894031736609437813u, 4189321500415139449u, 3832788u},
    {9408822078478203445u, 3002331670334957991u, 6167205082452575040u, 6195597956737981145u, 2055919u},
    {17484768054598707187u, 18322476183306789289u, 7135131420141039162u, 1767307274735145288u, 609029u},
    {806720278886655134u, 5369123995131172802u, 4543177621977861253u, 14278638223373505857u, 3823211u},
    {13562682619575037460u, 16354539841192104059u, 16913170929078625354u, 3457232728918042383u, 1461438u},
    {6515762995115322584u, 16723818378047060073u, 11300958575141676775u, 7665063744243187884u, 3764402u},
    {10365331920799721279u, 17835910247072062412u, 14122117369634058653u, 3816435857921876799u, 2207722u},
    {15480284726567000931u, 8291425370168146883u, 11707328538378237464u, 4292123334774082280u, 3085660u},
    {7864949151720838506u, 7941745836249651584u, 15006589384887660370u, 6902391818213759869u, 2891353u},
    {7499653971257751456u, 16057865673427458420u, 7514028806633014667u, 2359179064933838103u, 116602u},
    {7297857584985541712u, 12750972934980726962u, 1316487592784093585u, 5766758452645896626u, 3359102u},
    {2502064169170092569u, 3128820767853595668u, 16570810885058932116u, 17860190228046444546u, 3087386u},
    {17220846440392434580u, 404213692348170958u, 14240154511563228085u, 17350774806361648705u, 1404295u},
    {13878576118488691683u, 2340686787797576510u, 2734534748849016060u, 10330140635243459609u, 1050541u},
    {1842588278962235467u, 8797102832465774906u, 5675765515999334477u, 523782229561575093u, 2672493u},
    {15965193504746609177u, 8882376104689638104u, 5321402015758102566u, 1562508269730049146u, 3142131u},
    {17142978246114881913u, 1702177708609014522u, 15841747306588348235u, 2796150661406838904u, 2576624u},
    {1465402172128276280u, 8260851240791302218u, 2395554854148184036u, 13089954847163284877u, 1243000u},
    {11680170398992723749u, 6118845301469942394u, 15162723299945295058u, 15803542410279793803u, 1089155u},
    {2698872486074812589u, 6624048455990420643u, 17895523702890258954u, 15296301315385865968u, 3210539u},
    {10262489289630051912u, 16303196005095748671u, 9620843901732566629u, 9354653637460668449u, 2292745u},
    {13644362985561529068u, 2498001522600869417u, 7018882256051449233u, 9842126478754130139u, 646198u},
    {5110149098937839008u, 10323686104639295353u, 10870410009040504976u, 15144015006933936003u, 2523534u},
    {17673482411138243579u, 17305652992909694743u, 10360926436841196829u, 4658237019430707470u, 3527354u},
    {2605674763301028855u, 17619145177481394553u, 2981206617418536143u, 11089880088956586909u, 549117u},
    {16100207125399815462u, 9481911270787608709u, 14966027586934365538u, 3973297103941439736u, 97471u},
    {10063063213057479222u, 5877256080083627532u, 11935096409705087176u, 14197144052036709039u, 2967434u},
    {5070707355536033821u, 8173163927588983361u, 11562094221045896821u, 14394200723298427545u, 2292319u},
    {9610706462255299125u, 10628386846379821812u, 17510849428582451347u, 3284877568029259648u, 2729233u},
    {7597564937115157671u, 2972430191811303686u, 13186658265229079374u, 10354581413377094956u, 249u},
    {11400071427547842235u, 17136671328216805451u, 1022822903734616834u, 4603593855767u, 0u},
    {6334168226776726517u, 16240260889917215192u, 10954705351568313213u, 4603u, 0u},
    {12411880097987385448u, 11702645096643506866u, 84921317676636u, 0u, 0u},
    {1526479927321040816u, 5860099614191631495u, 84921u, 0u, 0u},
    {450355693842276464u, 1566521813583103u, 0u, 0u, 0u},
    {15007959284185833419u, 1566521u, 0u, 0u, 0u},
    {28897226981050845u, 0u, 0u, 0u, 0u},
    {28897227u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2122606u},
    {5167430634414177797u, 4533736276077900105u, 9544922693039852820u, 1552364644447806992u, 2422227u},
    {5735036825602442819u, 7378409938596983348u, 9776328400126259047u, 6025462508257812598u, 2418464u},
    {16817670273079738766u, 7619261607880732773u, 5483302470212491723u, 8259178512808727109u, 2526209u},
    {406918755034733307u, 9226534049352988u, 8984133506774760268u, 10278778692544647157u, 2411518u},
    {3256086373953821803u, 17116110104693699211u, 711310979918671875u, 12366333246139599659u, 1889141u},
    {3653470841558579379u, 5780658328870040771u, 3486462577459687905u, 4430361749226089078u, 3627947u},
    {8707367374406657761u, 10361513739189263914u, 16282967376193909193u, 8785892692841624351u, 3660495u},
    {14935929829689629570u, 12996489906426900452u, 18155917721994058176u, 5760074152230293081u, 382331u},
    {322622131803784188u, 15226145633195117205u, 14926920430885836098u, 9951000745102574766u, 3734378u},
    {10688219812163048781u, 15174150056158624850u, 871232617085010101u, 429175095381131753u, 3432793u},
    {4192187921159104002u, 4496385711233228609u, 3720251557601928203u, 11808711682540450296u, 3190479u},
    {15560987399488672923u, 264414951519407696u, 1304449704976415326u, 9930744344590383691u, 1362744u},
    {1357407957869529856u, 9922600409132193446u, 14716406502706588005u, 15733693700005017641u, 744398u},
    {10241843157365713516u, 1071190429452522086u, 14920922136569364892u, 9597391742173090430u, 2765932u},
    {4394248906716635201u, 9941259623610919462u, 12791646436553066721u, 3870074933336855957u, 2681989u},
    {11971275297308800239u, 16165051865373067085u, 17817713452448379683u, 6678772620050949251u, 3236572u},
    {14627101877709353885u, 9555194501941188743u, 17410952088431076482u, 12453610396562511882u, 2997476u},
    {15308110698404485407u, 13386116887303877799u, 9264565441563240548u, 16772655501891978160u, 1252087u},
    {9153611612717713548u, 96952041953838074u, 4541602272163400479u, 11624369585326071969u, 2680263u},
    {10845037307911842015u, 8141384000245701023u, 4962671798184348119u, 9200756580052450441u, 2176100u},
    {2769760611043566469u, 5630174577895451309u, 5977262349995137411u, 11137011450820458079u, 432254u},
    {14858079306438907492u, 5248926934962707497u, 6358233769885502625u, 12906283022838949243u, 1707829u},
    {1909055200806503364u, 14772490917421615481u, 12280936604627242612u, 1616770966225356924u, 1239319u},
    {10768390913020325753u, 5195899214167719485u, 452801687520674806u, 9678579003117800038u, 3370463u},
    {5964425561747867229u, 2528317056725003567u, 10811973281346338794u, 10150237243359397359u, 3550282u},
    {11890329381016804969u, 9506557784432967257u, 12723698385604186870u, 17431371316734367513u, 3107419u},
    {15440912237348745683u, 1210658753152959381u, 16738697647313281258u, 13820322241698389553u, 512859u},
    {11880093181526325772u, 7398280878670570196u, 11632880175137960753u, 9460592539220848u, 2048019u},
    {13294287263635907403u, 16143793244663735094u, 13471095542199409411u, 6883250715963709074u, 783339u},
    {12539815469328868972u, 68337436857632101u, 7692936046682662882u, 6715806306466504330u, 2931745u},
    {10216497028596194850u, 4259021233563645u, 16029376669205164189u, 4593709580809643883u, 1466012u},
    {11150272244301722040u, 18176731499095109635u, 18323506465437095040u, 2404943756018318555u, 1757573u},
    {15038187236529574863u, 8365344038109748554u, 14401493444780146219u, 4355877144002481833u, 3450747u},
    {6129864470819708792u, 14261103677392278006u, 2079667217826273478u, 11592870097196467918u, 1142154u},
    {6482278955901996848u, 5951753260804495963u, 7616453694539322206u, 2975430389678679132u, 869833u},
    {4111473395048651834u, 1306146918343162750u, 1650601016741369828u, 10680569507326631918u, 937009u},
    {944943139256959821u, 804728512410163356u, 10639869144833147928u, 17599337721152748404u, 1414995u},
    {9286215446279340815u, 1880673450596456748u, 2612618350544432822u, 13933217717550008016u, 3063880u},
    {7467700891529419540u, 15236936045025217151u, 10242335059498393446u, 1209440128772621914u, 2066268u},
    {7791255360364476845u, 16286126355973517274u, 10535138501816158939u, 18052514427675119816u, 3872635u},
    {13403879329195489881u, 15209122003376098573u, 1799442558715500073u, 1440531811509035401u, 2342954u},
    {1971130190260790809u, 3688225663044616373u, 5643764103445170957u, 13662105147423385804u, 266973u},
    {17195820867428087349u, 10733660639436112882u, 10089708104016215971u, 4112207656429587959u, 1657737u},
    {11663999408572318292u, 1720025839242072660u, 7320423471154220665u, 16531768888978224051u, 3213535u},
    {4161454797957856095u, 13882909667445899150u, 17165555189095180925u, 9787054469368948472u, 3355596u},
    {14607703587426269674u, 16831168151247970433u, 17218036130489784096u, 10077905401685801049u, 2931102u},
    {4666626063143541018u, 3640165974949801478u, 15616310378583196794u, 12447975473049448607u, 1071382u},
    {8387820238555325638u, 9502801438155598552u, 16212878781301512742u, 6288774203306884991u, 1517598u},
    {17503937043022132849u, 14036328386444385664u, 7751752773480450151u, 18330623633835243415u, 2759933u},
    {13393035125256536224u, 9139462220871633060u, 13935503222399667534u, 1347948488724911905u, 3002828u},
    {14505072811714013624u, 16971992970393207212u, 3410470084774101079u, 4378848043236993754u, 1486444u},
    {4711824625858450786u, 3988370682275943641u, 18064661426381246775u, 4711163668892065003u, 3659711u},
    {11038337321970803783u, 13886539952054461885u, 13765107632437692970u, 11812897585094156893u, 1251878u},
    {534702887228848572u, 820814196503295561u, 2805597435717025666u, 12849344823641577559u, 3198232u},
    {9440814748705528890u, 17637979821651391346u, 6004792822095989394u, 2508955177331242894u, 2686459u},
    {12035042818926104502u, 7417074290386233966u, 12101260354821714804u, 8192064550432325633u, 1076286u},
    {3604367148693079115u, 10887640024720048754u, 16655635499901791268u, 4343309622859857268u, 3758553u},
    {10614248021221081095u, 7620710141968350902u, 3962894049740082572u, 8788301948211063135u, 1679703u},
    {10433694322503520965u, 6357417632230897285u, 3488522491728493973u, 4930901454728243751u, 1374264u},
    {2369072057311871041u, 8131582550403529928u, 17898034145510537426u, 13428063192283209933u, 3816755u},
    {5575994584764014822u, 990303022871534109u, 17733519418549352616u, 8501145218542683003u, 2220157u},
    {4369823475989067443u, 6368813212432488684u, 9773208897871294824u, 13587782355614051963u, 562093u},
    {15260322202461717641u, 14902284109858761755u, 11262553553644895880u, 12548390161903866842u, 3517807u},
    {1744782702481225750u, 12400077436975284190u, 10062568927712370602u, 6189787591201968698u, 1498094u},
    {17242199984746509669u, 13515033510634382127u, 4069141496733943872u, 10836274068495337828u, 3810863u},
    {801070077827797976u, 12379987160404332813u, 9137455149808994350u, 18156754128817155007u, 2827755u},
    {9243499003413509272u, 6163000797262970951u, 17470119716219336387u, 5528540037827429817u, 3626510u},
    {17049935500169798974u, 9695040882075408272u, 15834131303745073841u, 17793065440709560719u, 2128292u},
    {10701617090368542964u, 15822858859601432574u, 13604115737339198991u, 16468391516278758297u, 3311701u},
    {7631391433790304305u, 1770953836730897095u, 1383821498263665500u, 6618331174715481688u, 377384u},
    {4314820489198491195u, 16871104583739088760u, 2629292500830563828u, 2456919709973393804u, 1758010u},
    {9890229070557873483u, 16323775682646781091u, 14938873665711301708u, 1185351067612788814u, 926529u},
    {4504923412508942616u, 2653404697671121537u, 14056597526694697358u, 13563919123655673072u, 3787118u},
    {7041834722929706296u, 17207224663743473174u, 6503505890488764515u, 17075452203037850789u, 594610u},
    {11929670956094399302u, 3771283716654586628u, 9670531246967497696u, 7649073603589481855u, 3883504u},
    {7608577793220079357u, 878935708000137464u, 2369010555103966217u, 17149287799035221774u, 1153087u},
    {17359253768236540572u, 7511840197001479794u, 14378505889570988635u, 10613737041508415916u, 3086496u},
    {12594515751169558999u, 17616770961044830895u, 13521342631127412573u, 9928826195606392509u, 2136690u},
    {13315527786260746910u, 10230153969967656765u, 8278595286415432800u, 11064226871326654865u, 822584u},
    {13913240332156228406u, 3740389932806350494u, 2456195215760162973u, 17020766200542348065u, 1283358u},
    {14674057863776761773u, 611237683222959163u, 5260173800970004407u, 4203014247801534231u, 2327571u},
    {10756975822298099913u, 10371222144745372163u, 10439731290848729300u, 6239889198015204958u, 2843331u},
    {11393011437475130779u, 15056995554454823095u, 2233492196171701619u, 14752199389251032795u, 3384196u},
    {763336150171192118u, 12350053021595331935u, 18293516768143841706u, 5827034935293705838u, 1337351u},
    {15448916748090680943u, 8933185764778981661u, 15807292712340517171u, 10689193695074089005u, 3267685u},
    {7655159680894953172u, 11394528200736057415u, 4545609151326610422u, 4311676207835441515u, 995583u},
    {10369534200919573443u, 11701646182159438731u, 6676866223513441882u, 12340213849602489240u, 1773609u},
    {17013711482384338135u, 2403950664212302929u, 13550819266076963759u, 8751686202239322029u, 2951980u},
    {9479519428452089687u, 6496860310156355271u, 7724052217580104688u, 14970376394173478076u, 1405497u},
    {1766442642230843846u, 11865852193923649702u, 15515763568163615692u, 1395021145146373731u, 3175453u},
    {12470224008978310644u, 16734970278901157240u, 17599222802772363254u, 13461289261258710457u, 2677602u},
    {10507754054212209029u, 2653015877610730483u, 1564565947319935725u, 4516963882638074136u, 3040624u},
    {1715569400795863028u, 15434908108063344899u, 5735508154757405483u, 13747032484475650754u, 3827853u},
    {1172946166437446970u, 8046615786366357934u, 13975459956404978153u, 8501349940827382324u, 1829876u},
    {7027984848806955698u, 2864284860825325220u, 5538855176230992921u, 8104205795007902112u, 1831703u},
    {10064036583329794378u, 14738865156921747508u, 15340020180809590740u, 7527778744508757145u, 2554083u},
    {12897794420439063599u, 296289920950333193u, 4220712329086266261u, 3073533472564764369u, 2743072u},
    {7641171659886689481u, 1927120230290050331u, 13561469251504093116u, 17632653695487708463u, 1311149u},
    {6938842753873154933u, 4518387332557096976u, 7000082777278187557u, 14723935631415452844u, 2154838u},
    {1215839666232298269u, 6412228236880602856u, 3699882871838773087u, 11785137588012493342u, 3669320u},
    {9711069271500637446u, 9294275406081495900u, 17489624836796702746u, 17073279211700674415u, 523729u},
    {16805737594823322566u, 16001569310920030821u, 8466510980990509048u, 17519656463116747489u, 2576461u},
    {4254325175946357977u, 6097358910648485053u, 3373143314032886445u, 12225260726612371432u, 174351u},
    {10887003848694429619u, 11737397866891758144u, 11919781468460351464u, 5191362991232067452u, 1663789u},
    {8647409800250204096u, 15091662817106626357u, 7483852863273925644u, 3705628791001340868u, 153542u},
    {14911028994079685168u, 987739854742572433u, 17995993093598852421u, 18305461239317890046u, 3520721u},
    {3171359847291341492u, 12065029007535768538u, 10937539105207650400u, 14836752635322622885u, 2157154u},
    {5077346073582041491u, 611302679426969917u, 7918887463743107760u, 13658677755770711393u, 2283037u},
    {18224893149039553124u, 5418559886478479441u, 6704454107412203925u, 10706638530521821917u, 375380u},
    {12284680678351566525u, 1846981676198022417u, 137169940296326112u, 8293547863858740262u, 884116u},
    {4261581899182969514u, 17751715031044934290u, 14670173851142483686u, 3475073583697560585u, 2584927u},
    {12315991153208045814u, 395918021693677299u, 15267496022405125144u, 18134139593813207329u, 1934708u},
    {16935317396810059773u, 12723340231651940539u, 20207630190249666u, 5151778258160381509u, 3092767u},
    {9147576798914694314u, 2174077228042252055u, 18135786958391099934u, 5893716603552555542u, 2054170u},
    {474281866396737572u, 1356339767320287459u, 3608077311535880309u, 13512662839260132585u, 980274u},
    {9672071876109821747u, 5786865605597585550u, 4813776910211516552u, 17528078228329262844u, 849507u},
    {11485251262631062989u, 4977386232221631424u, 7266470521045224143u, 11689000889890228640u, 3625961u},
    {1691371055131188415u, 17449062975060056901u, 6960539758537718746u, 15487212310393831153u, 2385158u},
    {7602581576586899798u, 5164757091457661751u, 1976503720366122830u, 116056008726501173u, 2012984u},
    {17379315543194651252u, 1175299291900909271u, 14327278376995330764u, 8035525938998529052u, 3489800u},
    {17548468949500344834u, 14831691292787236879u, 4206703483242323875u, 10368611402927652380u, 759047u},
    {5547014746556869934u, 2925882124740867219u, 17582003733547931210u, 5562436697037979488u, 3189092u},
    {15280315061567156429u, 11839521935051157008u, 7750439385118271057u, 17712938908806295558u, 581451u},
    {14885409480013491877u, 10885339591029296301u, 5588816958844505805u, 14206071920973144793u, 2545526u},
    {9073567611090836285u, 10226637866241823765u, 1107077827844377620u, 15179051428825912061u, 2498945u},
    {14106653554083397342u, 10657276497241317090u, 5330319167274646075u, 16042883290468329336u, 3723846u},
    {7220341974918084177u, 11275255539776262108u, 7662122117625816155u, 11381735114129476261u, 3549480u},
    {12723801923587041296u, 937958120756535179u, 7368292585130470228u, 17791644493866757949u, 428092u},
    {10502871478010637130u, 12965990695987916041u, 4374730606852877362u, 944645643848710131u, 3056562u},
    {13073527051594931432u, 14090975836208271341u, 6552547712071731082u, 5676875952862450466u, 1730220u},
    {8770605368162072485u, 14155744716959292152u, 4786671581008727390u, 14659608520907460701u, 755481u},
    {15724521608756548803u, 346070931113823855u, 12393776996761528385u, 5850601296391321502u, 3739573u},
    {11621528748797098658u, 12918695844581951954u, 8423179408044820808u, 3023344307481600921u, 2279862u},
    {12935392096152244657u, 16859553317534850141u, 4574016170585317994u, 9913946417056847145u, 2029126u},
    {1769604675875367363u, 441278785839696258u, 12713768312563911171u, 3424137697711869376u, 3771522u},
    {8642627251370766838u, 1707777781180558023u, 4459480617623405399u, 10950269004253621229u, 3229183u},
    {9661965503495992027u, 16350860265490375001u, 4973813262587865559u, 4527138753669974667u, 2401888u},
    {7369495388630895772u, 2110424841228797689u, 3354091697728302239u, 2926610779273970281u, 2183959u},
    {1203471364569201608u, 12378883867683419649u, 16817860143035544329u, 16253245594200871017u, 346119u},
    {14237689402445086537u, 6205430577580920693u, 9161562935686482904u, 10094447950175204910u, 2438253u},
    {12030103283722129728u, 10982155310970965491u, 9805768185799430869u, 8691889123723754805u, 3788468u},
    {9008083843489661878u, 14632605942429971059u, 5816610619930989146u, 11959387924577436841u, 850246u},
    {5112587200465782058u, 5867768703396284497u, 13546870389229219u, 736260222700362536u, 1139505u},
    {15829543955071291235u, 7176828919761161770u, 5802471605081383155u, 1822460008790171025u, 3816573u},
    {9184229131671064370u, 16376463097355137985u, 6085636086824265295u, 214518535267945765u, 2303488u},
    {13587314473080450308u, 4625153320122535617u, 16616501906925412904u, 17984832769271435666u, 2600475u},
    {13547358534671975581u, 1139838340465162533u, 9408822078478203444u, 3002331670334957991u, 1075924u},
    {2770495052414438368u, 7875878777903832807u, 17484768054598707186u, 18322476183306789289u, 1998294u},
    {9995176266950952353u, 13344453512181539451u, 806720278886655133u, 5369123995131172802u, 3768881u},
    {15613203681403907211u, 1503481616100413509u, 13562682619575037459u, 16354539841192104059u, 350010u},
    {2232537822147032500u, 14210658909038544265u, 6515762995115322583u, 16723818378047060073u, 2042881u},
    {1951260748325798975u, 10127175571172383353u, 10365331920799721278u, 17835910247072062412u, 260319u},
    {2487253771068804323u, 13377459535734161797u, 15480284726567000930u, 8291425370168146883u, 835404u},
    {16820226564285458160u, 889171483851421386u, 7864949151720838505u, 7941745836249651584u, 3311142u},
    {16344350258598515021u, 14791355734143256134u, 7499653971257751455u, 16057865673427458420u, 3731627u},
    {499514344708455011u, 10191403445268922095u, 7297857584985541711u, 12750972934980726962u, 1644963u},
    {14716749537554447349u, 2743186378451299215u, 2502064169170092568u, 3128820767853595668u, 2381218u},
    {11511672926594140389u, 13962810320025038936u, 17220846440392434579u, 404213692348170958u, 1888885u},
    {3734071260159837277u, 7040555303112128856u, 13878576118488691682u, 2340686787797576510u, 329400u},
    {6777848957083451085u, 16536366835100664172u, 1842588278962235466u, 8797102832465774906u, 1045823u},
    {1114806332270763194u, 7679967103220400822u, 15965193504746609176u, 8882376104689638104u, 2431488u},
    {4630463144802263926u, 15342374135068460596u, 17142978246114881912u, 1702177708609014522u, 2509143u},
    {15484243982406160584u, 14107916258430793357u, 1465402172128276279u, 8260851240791302218u, 3578268u},
    {16728683650585972888u, 2302131077245378005u, 11680170398992723748u, 6118845301469942394u, 3621636u},
    {13979649056956596426u, 6400918148491129726u, 2698872486074812588u, 6624048455990420643u, 985526u},
    {14231689593264546124u, 3663662320315998279u, 10262489289630051911u, 16303196005095748671u, 2604433u},
    {7640261388187523383u, 2489179575969013024u, 13644362985561529067u, 2498001522600869417u, 1054395u},
    {15020341945036377755u, 13226427272161270690u, 5110149098937839007u, 10323686104639295353u, 641328u},
    {2853450449368519180u, 5108512614066148225u, 17673482411138243578u, 17305652992909694743u, 2010773u},
    {16098006650440526483u, 17609515614389640387u, 2605674763301028854u, 17619145177481394553u, 2296689u},
    {1239048686255472796u, 2148043785739058917u, 16100207125399815461u, 9481911270787608709u, 2200440u},
    {15669373454949903003u, 15913634320410468348u, 10063063213057479221u, 5877256080083627532u, 1661854u},
    {1311845016624687383u, 14963451991672245619u, 5070707355536033820u, 8173163927588983361u, 1947255u},
    {11193167666876775713u, 13455949366692916084u, 9610706462255299124u, 10628386846379821812u, 979513u},
    {13611453792150524794u, 15861400512752513889u, 7597564937115157670u, 2972430191811303686u, 3199564u},
    {12831790737758895094u, 5574964495173779187u, 11400071427547842234u, 17136671328216805451u, 1480056u},
    {15159131471055962661u, 11754681967504339588u, 6334168226776726516u, 16240260889917215192u, 1589161u},
    {14428107094246490133u, 3056721501624514254u, 12411880097987385447u, 11702645096643506866u, 1270386u},
    {6161237585725549432u, 13715577002787198477u, 1526479927321040815u, 5860099614191631495u, 84921u},
    {9803585840741465312u, 10327256778320242496u, 450355693842276463u, 1566521813583103u, 0u},
    {16478193739155166480u, 6017713667036637855u, 15007959284185833418u, 1566521u, 0u},
    {8552019755328114156u, 12781405016701063593u, 28897226981050844u, 0u, 0u},
    {8106006584661791527u, 18097193855346158840u, 28897226u, 0u, 0u},
    {13878888560324972320u, 533059750559339426u, 0u, 0u, 0u},
    {10317991255636490852u, 533059750u, 0u, 0u, 0u},
    {9833216794563586413u, 0u, 0u, 0u, 0u},
    {9833216795u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3586836u},
    {1804775132957189530u, 9333927358585237072u, 5167430634414177796u, 4533736276077900105u, 1546904u},
    {4977526866216358914u, 3276689625123732899u, 5735036825602442818u, 7378409938596983348u, 2884749u},
    {3694598375701189380u, 2405782491260842026u, 16817670273079738765u, 7619261607880732773u, 500171u},
    {1243107086675489139u, 9559267123445024817u, 406918755034733306u, 9226534049352988u, 2084938u},
    {15940537862719368904u, 12566136829564719810u, 3256086373953821802u, 17116110104693699211u, 870115u},
    {11929806364094603470u, 8261083219461988236u, 3653470841558579378u, 5780658328870040771u, 3105035u},
    {100848730715657957u, 1213727035742753074u, 8707367374406657760u, 10361513739189263914u, 1416129u},
    {3039868507691451825u, 17650151094464602190u, 14935929829689629569u, 12996489906426900452u, 1192258u},
    {12253673549499787572u, 9803847722209249200u, 322622131803784187u, 15226145633195117205u, 2279822u},
    {7630133847011879689u, 5515176175049860084u, 10688219812163048780u, 15174150056158624850u, 1562057u},
    {8720831749116441736u, 16613716429553078776u, 4192187921159104001u, 4496385711233228609u, 2615213u},
    {8295979400996265432u, 2932410170996161134u, 15560987399488672922u, 264414951519407696u, 2748996u},
    {13125243547863096284u, 14167243963334419252u, 1357407957869529855u, 9922600409132193446u, 3381849u},
    {2546702381070292000u, 4569272079581994075u, 10241843157365713515u, 1071190429452522086u, 3760514u},
    {17157133581569024772u, 12874958065204065544u, 4394248906716635200u, 9941259623610919462u, 1309217u},
    {13253392534401988509u, 13325480487498486253u, 11971275297308800238u, 16165051865373067085u, 2363131u},
    {8126417911680723925u, 12049198042556195707u, 14627101877709353884u, 9555194501941188743u, 3006600u},
    {6792564501072462131u, 15303827896808244351u, 15308110698404485406u, 13386116887303877799u, 1349530u},
    {16387435736854750072u, 2908576921002807639u, 9153611612717713547u, 96952041953838074u, 3845311u},
    {9890332365950557430u, 9017210250318138873u, 10845037307911842014u, 8141384000245701023u, 524875u},
    {8565579323119538168u, 15169000825808954183u, 2769760611043566468u, 5630174577895451309u, 3294899u},
    {17566463223021678218u, 10182506009130750784u, 14858079306438907491u, 5248926934962707497u, 37087u},
    {11004697096016118620u, 6066051588849611890u, 1909055200806503363u, 14772490917421615481u, 420260u},
    {5469824763711774158u, 4190532450383528862u, 10768390913020325752u, 5195899214167719485u, 341592u},
    {12214229100437859579u, 9674237472240093610u, 5964425561747867228u, 2528317056725003567u, 3632780u},
    {18253578820888490410u, 9806458500368831764u, 11890329381016804968u, 9506557784432967257u, 3129942u},
    {15367766236433486102u, 3638764753245252849u, 15440912237348745682u, 1210658753152959381u, 2624110u},
    {16671544860701179806u, 12607603185860532846u, 11880093181526325771u, 7398280878670570196u, 156785u},
    {17336130525348695685u, 14253641752295792755u, 13294287263635907402u, 16143793244663735094u, 3704579u},
    {13300877903367855622u, 3818039403079294231u, 12539815469328868971u, 68337436857632101u, 230882u},
    {6135473699680100838u, 13360577899352249964u, 10216497028596194849u, 4259021233563645u, 987589u},
    {4826421104337028637u, 9747531726724024410u, 11150272244301722039u, 18176731499095109635u, 361208u},
    {11001755528572594629u, 11745799144982396796u, 15038187236529574862u, 8365344038109748554u, 3564729u},
    {12745844163223059278u, 540001696724739389u, 6129864470819708791u, 14261103677392278006u, 2332690u},
    {1136367796602569736u, 1467680642013052113u, 6482278955901996847u, 5951753260804495963u, 493866u},
    {4741826489284947354u, 609700882701469130u, 4111473395048651833u, 1306146918343162750u, 655670u},
    {5920769878578087328u, 1245364651470564441u, 944943139256959820u, 804728512410163356u, 389012u},
    {15494133301641127082u, 14861888465332012185u, 9286215446279340814u, 1880673450596456748u, 1777208u},
    {13603497291457385804u, 4466702556969870988u, 7467700891529419539u, 15236936045025217151u, 60178u},
    {11293712045123807447u, 3714892450002592191u, 7791255360364476844u, 16286126355973517274u, 269405u},
    {1933401763472940180u, 6316078622429849078u, 13403879329195489880u, 15209122003376098573u, 720363u},
    {16097527126408281717u, 10182831031908407343u, 1971130190260790808u, 3688225663044616373u, 3747909u},
    {4059328222303314138u, 8353517305981358830u, 17195820867428087348u, 10733660639436112882u, 3399037u},
    {3983953319793668036u, 14247758435720558320u, 11663999408572318291u, 1720025839242072660u, 2594041u},
    {7924947636492849258u, 12511883207491744329u, 4161454797957856094u, 13882909667445899150u, 2263203u},
    {15224476437592577179u, 16329723093044364411u, 14607703587426269673u, 16831168151247970433u, 2021292u},
    {7263738623998839508u, 10181875076303919964u, 4666626063143541017u, 3640165974949801478u, 3429148u},
    {593579559428493461u, 9510199603641789238u, 8387820238555325637u, 9502801438155598552u, 3098386u},
    {4400769599737499045u, 3587812134146029336u, 17503937043022132848u, 14036328386444385664u, 3263739u},
    {4847004348574651129u, 13461693302486947907u, 13393035125256536223u, 9139462220871633060u, 2084832u},
    {14563023895311583983u, 6729309071452485276u, 14505072811714013623u, 16971992970393207212u, 1366257u},
    {15202348965971684399u, 12741321220217924048u, 4711824625858450785u, 3988370682275943641u, 2790839u},
    {2469164003190753343u, 13771900566832520012u, 11038337321970803782u, 13886539952054461885u, 1527676u},
    {12263321306760097606u, 12676901341585610384u, 534702887228848571u, 820814196503295561u, 3031802u},
    {17325486934077382456u, 16431416248598696340u, 9440814748705528889u, 17637979821651391346u, 3642902u},
    {6597569014629479606u, 17666987987953944248u, 12035042818926104501u, 7417074290386233966u, 376398u},
    {3429452053789175107u, 16806995394023907168u, 3604367148693079114u, 10887640024720048754u, 2963274u},
    {4559347443831385322u, 13404004185775120780u, 10614248021221081094u, 7620710141968350902u, 886300u},
    {7635601675621929979u, 7446794278251269558u, 10433694322503520964u, 6357417632230897285u, 3313973u},
    {4595824593171210422u, 4219844198970187513u, 2369072057311871040u, 8131582550403529928u, 2903184u},
    {3720785483886989629u, 669812202008729654u, 5575994584764014821u, 990303022871534109u, 1504056u},
    {997770924544561323u, 4680870551192391853u, 4369823475989067442u, 6368813212432488684u, 3166940u},
    {16721978465989635293u, 3900479663659362092u, 15260322202461717640u, 14902284109858761755u, 334544u},
    {9315846245701046910u, 263784459657806330u, 1744782702481225749u, 12400077436975284190u, 2182684u},
    {16254168103814488626u, 7537426199351445168u, 17242199984746509668u, 13515033510634382127u, 3151698u},
    {5696593951166778098u, 11627521220762580017u, 801070077827797975u, 12379987160404332813u, 2065692u},
    {11839625368715890125u, 17574975586816897829u, 9243499003413509271u, 6163000797262970951u, 2131719u},
    {4344072565395562641u, 11315029014313144131u, 17049935500169798973u, 9695040882075408272u, 2290147u},
    {613063579448545716u, 10855734706088812101u, 10701617090368542963u, 15822858859601432574u, 2253599u},
    {11753725886243842381u, 13545678291809697905u, 7631391433790304304u, 1770953836730897095u, 521912u},
    {1389974002070691849u, 8387433788146033651u, 4314820489198491194u, 16871104583739088760u, 2101152u},
    {16303120017722834608u, 4816899893422319834u, 9890229070557873482u, 16323775682646781091u, 3216356u},
    {9029168752940089735u, 7396053696184327940u, 4504923412508942615u, 2653404697671121537u, 3118018u},
    {581658684877682119u, 14154382547341735078u, 7041834722929706295u, 17207224663743473174u, 1316699u},
    {17625669276074181324u, 4610933829698676796u, 11929670956094399301u, 3771283716654586628u, 772200u},
    {13001242735748391330u, 12730344335464535348u, 7608577793220079356u, 878935708000137464u, 967673u},
    {14384277333021562324u, 9365099638682027640u, 17359253768236540571u, 7511840197001479794u, 1882067u},
    {6836298287987945115u, 16435075489015308254u, 12594515751169558998u, 17616770961044830895u, 3796507u},
    {11557556888754032436u, 6156038409808830936u, 13315527786260746909u, 10230153969967656765u, 3548194u},
    {4725973644550351564u, 16209884754597613271u, 13913240332156228405u, 3740389932806350494u, 1885261u},
    {12716279099051741253u, 6162627863267930359u, 14674057863776761772u, 611237683222959163u, 3631329u},
    {13917035822937121754u, 13350355177299790433u, 10756975822298099912u, 10371222144745372163u, 3741364u},
    {9141794959114413660u, 14056996454393516912u, 11393011437475130778u, 15056995554454823095u, 1528965u},
    {14336129187307420067u, 17622642031273070765u, 763336150171192117u, 12350053021595331935u, 3800220u},
    {13358510730835951709u, 4541023882861045905u, 15448916748090680942u, 8933185764778981661u, 511111u},
    {13142273052098898135u, 14998729109391083632u, 7655159680894953171u, 11394528200736057415u, 1535010u},
    {4347771563160102785u, 8191468032112243946u, 10369534200919573442u, 11701646182159438731u, 1412176u},
    {16265421203027187128u, 17242190029951395194u, 17013711482384338134u, 2403950664212302929u, 633003u},
    {18232412292919745225u, 16493303363984081719u, 9479519428452089686u, 6496860310156355271u, 2624136u},
    {3382334635394442426u, 18401727356941648991u, 1766442642230843845u, 11865852193923649702u, 954556u},
    {1925707249673537042u, 13972593547956327702u, 12470224008978310643u, 16734970278901157240u, 3195278u},
    {6818346752747068287u, 1016696943727857986u, 10507754054212209028u, 2653015877610730483u, 790545u},
    {764226514592733173u, 1675021105094294961u, 1715569400795863027u, 15434908108063344899u, 2614165u},
    {9454535142029172503u, 13789753794296101917u, 1172946166437446969u, 8046615786366357934u, 2929443u},
    {9615229829646929378u, 3945155750006642130u, 7027984848806955697u, 2864284860825325220u, 2120481u},
    {13343300666203259952u, 3319335780361998938u, 10064036583329794377u, 14738865156921747508u, 436908u},
    {12091460492477576302u, 16712479944639741920u, 12897794420439063598u, 296289920950333193u, 2906897u},
    {8133520109901354872u, 15632979538552175286u, 7641171659886689480u, 1927120230290050331u, 2754768u},
    {1635396657390562620u, 5631727967258749855u, 6938842753873154932u, 4518387332557096976u, 3857589u},
    {16820567053435713577u, 9684683274554420487u, 1215839666232298268u, 6412228236880602856u, 3843679u},
    {12302581803224737800u, 42430989042101100u, 9711069271500637445u, 9294275406081495900u, 259310u},
    {13061297950431672673u, 17628948350314752163u, 16805737594823322565u, 16001569310920030821u, 2413488u},
    {15225828699749994846u, 14096961790876403671u, 4254325175946357976u, 6097358910648485053u, 3473113u},
    {162798121039769827u, 8281410315476932259u, 10887003848694429618u, 11737397866891758144u, 1714430u},
    {5044850452233929682u, 11387182540573434159u, 8647409800250204095u, 15091662817106626357u, 2764234u},
    {3505049890056778597u, 7260854508619109269u, 14911028994079685167u, 987739854742572433u, 1702783u},
    {10111973045273308082u, 5895006512687730007u, 3171359847291341491u, 12065029007535768538u, 1888784u},
    {9156212155714111172u, 13612007465875736031u, 5077346073582041490u, 611302679426969917u, 771970u},
    {3899238515853192298u, 6833885637558274775u, 18224893149039553123u, 5418559886478479441u, 2468827u},
    {5662055269779158800u, 14907955580236040256u, 12284680678351566524u, 1846981676198022417u, 1384900u},
    {12278569609965246072u, 7075374068451979032u, 4261581899182969513u, 17751715031044934290u, 1931508u},
    {6637423495301716947u, 15481204939105160079u, 12315991153208045813u, 395918021693677299u, 2233656u},
    {13235705029347898682u, 15199639970288920825u, 16935317396810059772u, 12723340231651940539u, 669462u},
    {6107885081219681285u, 3157666958581246383u, 9147576798914694313u, 2174077228042252055u, 3214826u},
    {2994724995965263581u, 18105697886974121254u, 474281866396737571u, 1356339767320287459u, 1206613u},
    {9795175764037563726u, 8195516579034557906u, 9672071876109821746u, 5786865605597585550u, 293398u},
    {15597106738730538500u, 9506308832842147995u, 11485251262631062988u, 4977386232221631424u, 603099u},
    {7282675904263587445u, 4566423547147940789u, 1691371055131188414u, 17449062975060056901u, 2638292u},
    {14011949443957606694u, 7865019884070500001u, 7602581576586899797u, 5164757091457661751u, 1213102u},
    {3990119319973623339u, 8191017075872908817u, 17379315543194651251u, 1175299291900909271u, 3246346u},
    {3266310098058250339u, 9028260150448636229u, 17548468949500344833u, 14831691292787236879u, 2362387u},
    {2054320421103121376u, 17090848791890057567u, 5547014746556869933u, 2925882124740867219u, 1196770u},
    {14042142663600729383u, 8558237009669884127u, 15280315061567156428u, 11839521935051157008u, 251691u},
    {16005549182255056842u, 3188583399859475451u, 14885409480013491876u, 10885339591029296301u, 3605899u},
    {6307768727003437058u, 12024385353859240049u, 9073567611090836284u, 10226637866241823765u, 3513366u},
    {79224510906470225u, 6347735309605163828u, 14106653554083397341u, 10657276497241317090u, 1857827u},
    {13621756804110582486u, 4537546586541268638u, 7220341974918084176u, 11275255539776262108u, 65561u},
    {3142973940881212823u, 14763252473683472136u, 12723801923587041295u, 937958120756535179u, 3669014u},
    {16286077386220783546u, 18342795634153038564u, 10502871478010637129u, 12965990695987916041u, 2154580u},
    {5209700036579587314u, 7625475699734252711u, 13073527051594931431u, 14090975836208271341u, 1759458u},
    {2087213513380617617u, 17707386311775939470u, 8770605368162072484u, 14155744716959292152u, 3135542u},
    {2942561123032259479u, 2120624213404374410u, 15724521608756548802u, 346070931113823855u, 1105155u},
    {17026348509218780154u, 13702318275420913932u, 11621528748797098657u, 12918695844581951954u, 3801966u},
    {6792685243912355157u, 529030811238069017u, 12935392096152244656u, 16859553317534850141u, 484270u},
    {918543250177778908u, 14359307733984200855u, 1769604675875367362u, 441278785839696258u, 2735069u},
    {7246606380601889311u, 501211959687027828u, 8642627251370766837u, 1707777781180558023u, 3569411u},
    {9066983573110500699u, 14638495313248976514u, 9661965503495992026u, 16350860265490375001u, 1125109u},
    {1743358441624700079u, 9677020764327385918u, 7369495388630895771u, 2110424841228797689u, 3091889u},
    {140704054798592091u, 2737341490183673516u, 1203471364569201607u, 12378883867683419649u, 459565u},
    {14695960444006191942u, 388876386404278832u, 14237689402445086536u, 6205430577580920693u, 1593832u},
    {7951238242006612415u, 17200035928419932103u, 12030103283722129727u, 10982155310970965491u, 266407u},
    {4028224790039462105u, 15693969215760641991u, 9008083843489661877u, 14632605942429971059u, 1686128u},
    {5758037073524565434u, 1516794412286996512u, 5112587200465782057u, 5867768703396284497u, 2337925u},
    {9742261539679856987u, 8783380464746146658u, 15829543955071291234u, 7176828919761161770u, 1051093u},
    {16309010864667852775u, 12841386600070756958u, 9184229131671064369u, 16376463097355137985u, 730063u},
    {12191008054689154917u, 10902023122519329064u, 13587314473080450307u, 4625153320122535617u, 3197010u},
    {12542761966656483389u, 15629998926281032548u, 13547358534671975580u, 1139838340465162533u, 1170994u},
    {2384914990228411912u, 12368286835475202029u, 2770495052414438367u, 7875878777903832807u, 748024u},
    {11676929140957789135u, 15149709980524252341u, 9995176266950952352u, 13344453512181539451u, 3378901u},
    {4755775853907071567u, 4291543232899726385u, 15613203681403907210u, 1503481616100413509u, 830113u},
    {440399362105692840u, 5524104080074581765u, 2232537822147032499u, 14210658909038544265u, 2120287u},
    {9691386982180174598u, 7908536289253639504u, 1951260748325798974u, 10127175571172383353u, 2537284u},
    {6707013318223769539u, 12071049902595015254u, 2487253771068804322u, 13377459535734161797u, 1327082u},
    {16858396589789281585u, 2417808596599640213u, 16820226564285458159u, 889171483851421386u, 1059751u},
    {5591615246794724381u, 8806944004485524097u, 16344350258598515020u, 14791355734143256134u, 1695837u},
    {12061984192562837432u, 7213345377845633625u, 499514344708455010u, 10191403445268922095u, 270931u},
    {15096377823663196919u, 1693338543688696242u, 14716749537554447348u, 2743186378451299215u, 3019214u},
    {5803371415446641514u, 11808579402202861173u, 11511672926594140388u, 13962810320025038936u, 2763017u},
    {15472137034955355875u, 7533349904731063995u, 3734071260159837276u, 7040555303112128856u, 1906992u},
    {13979776079979741374u, 4349169009095227577u, 6777848957083451084u, 16536366835100664172u, 2269350u},
    {10774214783556045622u, 12304469648988587264u, 1114806332270763193u, 7679967103220400822u, 3586768u},
    {4763578585939863392u, 17638882819704198955u, 4630463144802263925u, 15342374135068460596u, 3072922u},
    {13201258241673595210u, 3877164228040058426u, 15484243982406160583u, 14107916258430793357u, 3705025u},
    {4091686077461852873u, 12494752591343611599u, 16728683650585972887u, 2302131077245378005u, 3244468u},
    {13368938332974983282u, 937175315944520292u, 13979649056956596425u, 6400918148491129726u, 3295032u},
    {2862322630640295061u, 660766671748820629u, 14231689593264546123u, 3663662320315998279u, 2126195u},
    {18096262229511121901u, 2562343270672193083u, 7640261388187523382u, 2489179575969013024u, 2162309u},
    {68588757251361306u, 15439594042135996361u, 15020341945036377754u, 13226427272161270690u, 3495523u},
    {8668790469703677987u, 10194118714411090080u, 2853450449368519179u, 5108512614066148225u, 1488754u},
    {15653363367177375604u, 3519022713546071484u, 16098006650440526482u, 17609515614389640387u, 3164436u},
    {11145643131547011335u, 12584750473738563876u, 1239048686255472795u, 2148043785739058917u, 3304845u},
    {13742545209927935713u, 16995667617416414672u, 15669373454949903002u, 15913634320410468348u, 2576607u},
    {17656936852481398866u, 11163289989246500942u, 1311845016624687382u, 14963451991672245619u, 2885976u},
    {14583405844775766687u, 14019502301178504490u, 11193167666876775712u, 13455949366692916084u, 473244u},
    {5424597335318467007u, 9106248507661955527u, 13611453792150524793u, 15861400512752513889u, 1438180u},
    {16027503012694514725u, 9310246931835927227u, 12831790737758895093u, 5574964495173779187u, 503836u},
    {10252383881407199167u, 5701086187573407044u, 15159131471055962660u, 11754681967504339588u, 1642704u},
    {1850144172389099105u, 14125666074872110215u, 14428107094246490132u, 3056721501624514254u, 1335419u},
    {16526821248594662782u, 10359408512866859557u, 6161237585725549431u, 13715577002787198477u, 1247961u},
    {851273370724365701u, 2406921566343368405u, 9803585840741465311u, 10327256778320242496u, 2002161u},
    {8687741548543047371u, 5664907725216447705u, 16478193739155166479u, 6017713667036637855u, 1475104u},
    {3415153338911772788u, 3113470671621474529u, 8552019755328114155u, 12781405016701063593u, 582094u},
    {14960395058532845786u, 17327013927955209423u, 8106006584661791526u, 18097193855346158840u, 1553476u},
    {2267344208123655334u, 669580339542892854u, 13878888560324972319u, 533059750559339426u, 0u},
    {9043970332562082175u, 17262181515298693565u, 10317991255636490851u, 533059750u, 0u},
    {16186183790403832804u, 12424746399312161894u, 9833216794563586412u, 0u, 0u},
    {12957061048258428539u, 10396334318008976124u, 9833216794u, 0u, 0u},
    {12359599449361215081u, 15370136967231106602u, 9u, 0u, 0u},
    {11382953517892260937u, 181390833630u, 0u, 0u, 0u},
    {7209607959391845142u, 181u, 0u, 0u, 0u},
    {3346070285301u, 0u, 0u, 0u, 0u},
    {3347u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2086966u},
    {4436691644854928897u, 3495335110159693819u, 1804775132957189529u, 9333927358585237072u, 1848450u},
    {15289228084471392014u, 11137057211487083482u, 4977526866216358913u, 3276689625123732899u, 1511480u},
    {16420810387939564146u, 16707005401538244125u, 3694598375701189379u, 2405782491260842026u, 2583909u},
    {5382223302897409265u, 4893273720298418166u, 1243107086675489138u, 9559267123445024817u, 1524142u},
    {17244089377698955896u, 1529496331393367423u, 15940537862719368903u, 12566136829564719810u, 2521718u},
    {5172160083244117051u, 2739032900893755659u, 11929806364094603469u, 8261083219461988236u, 3296274u},
    {10995969172684036469u, 17899019459149000957u, 100848730715657956u, 1213727035742753074u, 3691608u},
    {15514640847250974464u, 4021146507584999860u, 3039868507691451824u, 17650151094464602190u, 217649u},
    {4212085063758774076u, 15832431072341570897u, 12253673549499787571u, 9803847722209249200u, 2103299u},
    {9957824304867915284u, 16485635954953341313u, 7630133847011879688u, 5515176175049860084u, 2193872u},
    {6888249203260237717u, 14598256394921005663u, 8720831749116441735u, 16613716429553078776u, 2716273u},
    {7402934573602843872u, 8093826980359408845u, 8295979400996265431u, 2932410170996161134u, 2382834u},
    {10204253845630616630u, 14737182782198279169u, 13125243547863096283u, 14167243963334419252u, 1606985u},
    {14094271141361117892u, 15270725272596189521u, 2546702381070291999u, 4569272079581994075u, 2640375u},
    {14857175648664735139u, 14980659888664543936u, 17157133581569024771u, 12874958065204065544u, 3625744u},
    {1344593520566546144u, 2978543004427746305u, 13253392534401988508u, 13325480487498486253u, 844584u},
    {2682984202834829305u, 16164469734507616414u, 8126417911680723924u, 12049198042556195707u, 1497172u},
    {8644644219281165767u, 1417426949074020241u, 6792564501072462130u, 15303827896808244351u, 1424270u},
    {16273593981945684580u, 18037603887754839058u, 16387435736854750071u, 2908576921002807639u, 542697u},
    {7346170317464801839u, 12855195196302516772u, 9890332365950557429u, 9017210250318138873u, 2000682u},
    {5858615753741867520u, 4285901570631428640u, 8565579323119538167u, 15169000825808954183u, 1213506u},
    {10441785686887916213u, 2735147281478474718u, 17566463223021678217u, 10182506009130750784u, 716315u},
    {11763546518342293759u, 9061959358042893844u, 11004697096016118619u, 6066051588849611890u, 606719u},
    {16299399412050460277u, 457584832806290077u, 5469824763711774157u, 4190532450383528862u, 1003964u},
    {6139825474073051167u, 3186245838796546874u, 12214229100437859578u, 9674237472240093610u, 359180u},
    {72059666213089666u, 10983180688667861972u, 18253578820888490409u, 9806458500368831764u, 1945332u},
    {12115872642059065491u, 7285438742296557168u, 15367766236433486101u, 3638764753245252849u, 3772038u},
    {17492799788122194963u, 10590412525715910733u, 16671544860701179805u, 12607603185860532846u, 3160217u},
    {4839832064656638233u, 1925930351804442375u, 17336130525348695684u, 14253641752295792755u, 3851330u},
    {7810732905869156459u, 8981244577074748570u, 13300877903367855621u, 3818039403079294231u, 1622129u},
    {7901995352792892029u, 3584068477587779398u, 6135473699680100837u, 13360577899352249964u, 1071003u},
    {12167919953825531940u, 11921264236406665475u, 4826421104337028636u, 9747531726724024410u, 22297u},
    {8087501294238292220u, 5290703817513105315u, 11001755528572594628u, 11745799144982396796u, 1929800u},
    {2490678267668376458u, 3604600124326391065u, 12745844163223059277u, 540001696724739389u, 1438127u},
    {17660154119416683533u, 9286917624252163553u, 1136367796602569735u, 1467680642013052113u, 1801951u},
    {13893569982999247886u, 16146158377397038436u, 4741826489284947353u, 609700882701469130u, 1105103u},
    {3585538890916964267u, 15407115445278297345u, 5920769878578087327u, 1245364651470564441u, 977088u},
    {15481074332667283039u, 5845664579489822276u, 15494133301641127081u, 14861888465332012185u, 3859180u},
    {7402896305201716054u, 6019802018451630315u, 13603497291457385803u, 4466702556969870988u, 2165973u},
    {17160347451964716669u, 10630657527741469106u, 11293712045123807446u, 3714892450002592191u, 2551558u},
    {11101876056023318811u, 9649243726880332584u, 1933401763472940179u, 6316078622429849078u, 1231126u},
    {17623102717304447190u, 9240521670874698051u, 16097527126408281716u, 10182831031908407343u, 3626330u},
    {55786568817094775u, 16038235424446243646u, 4059328222303314137u, 8353517305981358830u, 2841282u},
    {611845112373958982u, 7153832001284233300u, 3983953319793668035u, 14247758435720558320u, 2489297u},
    {1376420264167397056u, 11892608292969077486u, 7924947636492849257u, 12511883207491744329u, 2423562u},
    {15161662555801689949u, 16350478096031486398u, 15224476437592577178u, 16329723093044364411u, 1179303u},
    {3999068740563952566u, 3416531115442630627u, 7263738623998839507u, 10181875076303919964u, 3830203u},
    {3852222703779574990u, 7620477244353311410u, 593579559428493460u, 9510199603641789238u, 3089435u},
    {12169447266398086147u, 13694298854082626915u, 4400769599737499044u, 3587812134146029336u, 3197356u},
    {7261712283000801490u, 10843297895166842887u, 4847004348574651128u, 13461693302486947907u, 1515325u},
    {10371119735072749528u, 16950381836651441051u, 14563023895311583982u, 6729309071452485276u, 3208407u},
    {13113688749258137913u, 2333524025853643604u, 15202348965971684398u, 12741321220217924048u, 482475u},
    {9546600695781462486u, 4013634572004320276u, 2469164003190753342u, 13771900566832520012u, 3622448u},
    {15063017751487481162u, 2030193722362256315u, 12263321306760097605u, 12676901341585610384u, 123859u},
    {14423154346280770210u, 18011527331137337051u, 17325486934077382455u, 16431416248598696340u, 698087u},
    {3503688308361513841u, 891947446767421364u, 6597569014629479605u, 17666987987953944248u, 952795u},
    {2727580813658851347u, 7489449907992704354u, 3429452053789175106u, 16806995394023907168u, 70022u},
    {14058189320923013051u, 3322823565148541582u, 4559347443831385321u, 13404004185775120780u, 1347776u},
    {15040465984179661354u, 15474745918595664618u, 7635601675621929978u, 7446794278251269558u, 2195712u},
    {16675256511302206579u, 12265468483882371164u, 4595824593171210421u, 4219844198970187513u, 1154342u},
    {7731120109143127822u, 10919059132817339488u, 3720785483886989628u, 669812202008729654u, 3750501u},
    {11080137481040428447u, 15195504482406610443u, 997770924544561322u, 4680870551192391853u, 507926u},
    {17629340428451001279u, 5865068986070507496u, 16721978465989635292u, 3900479663659362092u, 2581034u},
    {8195515490200300100u, 14471497811510512434u, 9315846245701046909u, 263784459657806330u, 2354693u},
    {9098022471466203122u, 5636203386017223023u, 16254168103814488625u, 7537426199351445168u, 1422938u},
    {447224329713818664u, 18023535943774402749u, 5696593951166778097u, 11627521220762580017u, 3522585u},
    {14757181516991283550u, 13100311879084574755u, 11839625368715890124u, 17574975586816897829u, 107701u},
    {2581737306043990614u, 9809138151626029516u, 4344072565395562640u, 11315029014313144131u, 2553057u},
    {5005405283737965743u, 4108999856015923241u, 613063579448545715u, 10855734706088812101u, 3843941u},
    {16595444947485042648u, 13758301655362548113u, 11753725886243842380u, 13545678291809697905u, 1558696u},
    {14277364674990794623u, 6124839908495538054u, 1389974002070691848u, 8387433788146033651u, 3312166u},
    {10742701491529497315u, 18326758339811592168u, 16303120017722834607u, 4816899893422319834u, 2503374u},
    {10523802719828813821u, 18296198276742638565u, 9029168752940089734u, 7396053696184327940u, 1685615u},
    {5744692225741875958u, 7276248378797867847u, 581658684877682118u, 14154382547341735078u, 3865473u},
    {8547555484954822341u, 6602585080122252298u, 17625669276074181323u, 4610933829698676796u, 2613349u},
    {13000231217905739749u, 6973050099896950165u, 13001242735748391329u, 12730344335464535348u, 3776818u},
    {14142739521488909343u, 8591399596817108634u, 14384277333021562323u, 9365099638682027640u, 322227u},
    {5350585751027120990u, 11308980760669656548u, 6836298287987945114u, 16435075489015308254u, 1688260u},
    {12241620117191349668u, 451763319324809851u, 11557556888754032435u, 6156038409808830936u, 3739613u},
    {17938109705763769053u, 207185325938651022u, 4725973644550351563u, 16209884754597613271u, 2045475u},
    {2567879137399312281u, 1095904445109859375u, 12716279099051741252u, 6162627863267930359u, 1067954u},
    {8479047668489161541u, 13889151657634695520u, 13917035822937121753u, 13350355177299790433u, 312554u},
    {702732413315827780u, 12857935972495048160u, 9141794959114413659u, 14056996454393516912u, 2200338u},
    {1764870546583863082u, 14868363118093758896u, 14336129187307420066u, 17622642031273070765u, 75647u},
    {8921087161945151599u, 14527518184188932892u, 13358510730835951708u, 4541023882861045905u, 582734u},
    {12896457546859604299u, 2093426773484086688u, 13142273052098898134u, 14998729109391083632u, 2654121u},
    {769300076267388894u, 6151207414555206574u, 4347771563160102784u, 8191468032112243946u, 1107244u},
    {910706864357697112u, 17635212483329334805u, 16265421203027187127u, 17242190029951395194u, 3478766u},
    {13464109472795361189u, 5136752812764351683u, 18232412292919745224u, 16493303363984081719u, 1465888u},
    {18039037451623721773u, 15994545635169467021u, 3382334635394442425u, 18401727356941648991u, 3549563u},
    {6693975997963605414u, 11504415425351016937u, 1925707249673537041u, 13972593547956327702u, 427751u},
    {9606256371338226075u, 5012329554749871847u, 6818346752747068286u, 1016696943727857986u, 959326u},
    {11958613475835357541u, 2861317237838180964u, 764226514592733172u, 1675021105094294961u, 1450301u},
    {4767410271016276737u, 7264113910643859928u, 9454535142029172502u, 13789753794296101917u, 2929821u},
    {17914664864249310274u, 14636564480862939212u, 9615229829646929377u, 3945155750006642130u, 254053u},
    {3950761553634856870u, 2714302360345381393u, 13343300666203259951u, 3319335780361998938u, 3641603u},
    {10008432725611885044u, 14651284553808834189u, 12091460492477576301u, 16712479944639741920u, 3715518u},
    {1114962782337836093u, 2381349771663064580u, 8133520109901354871u, 15632979538552175286u, 609084u},
    {11964738911627924020u, 12993579408060274739u, 1635396657390562619u, 5631727967258749855u, 1570232u},
    {11510174236566605304u, 6577298971592873001u, 16820567053435713576u, 9684683274554420487u, 2300188u},
    {4806028695306845107u, 12961130574859644784u, 12302581803224737799u, 42430989042101100u, 2542205u},
    {9285265442820630329u, 14196907167937147932u, 13061297950431672672u, 17628948350314752163u, 2479079u},
    {10161720949894522428u, 3983520975143647376u, 15225828699749994845u, 14096961790876403671u, 3623652u},
    {5023750578299253536u, 13933462086399679774u, 162798121039769826u, 8281410315476932259u, 112902u},
    {7023817069088722468u, 13753074872487445111u, 5044850452233929681u, 11387182540573434159u, 2986711u},
    {17026532335104730616u, 515436003628359443u, 3505049890056778596u, 7260854508619109269u, 3162693u},
    {15320854228118868487u, 6469610870155877229u, 10111973045273308081u, 5895006512687730007u, 3533403u},
    {12505258208004719927u, 14298332562344712128u, 9156212155714111171u, 13612007465875736031u, 3278182u},
    {13503398005554141715u, 12301031610117525052u, 3899238515853192297u, 6833885637558274775u, 3474391u},
    {4772094122242305006u, 10981383523741266590u, 5662055269779158799u, 14907955580236040256u, 744296u},
    {4411533795591857195u, 10678220101113869256u, 12278569609965246071u, 7075374068451979032u, 3300301u},
    {15291286095448817570u, 10245506856080261038u, 6637423495301716946u, 15481204939105160079u, 3661633u},
    {11985402415113294561u, 13154783796837380740u, 13235705029347898681u, 15199639970288920825u, 3208718u},
    {17299315357390471107u, 10134185369758006017u, 6107885081219681284u, 3157666958581246383u, 1043099u},
    {6855350844498817386u, 3191809810760891907u, 2994724995965263580u, 18105697886974121254u, 2873593u},
    {12692805029051512689u, 18140370442509440800u, 9795175764037563725u, 8195516579034557906u, 3619284u},
    {10017098553551155424u, 9532490140630121162u, 15597106738730538499u, 9506308832842147995u, 1452566u},
    {14969669368632033289u, 6193393151889227798u, 7282675904263587444u, 4566423547147940789u, 582332u},
    {11436419784886499505u, 5247136881927757370u, 14011949443957606693u, 7865019884070500001u, 2629675u},
    {10225464008233773453u, 1027762362008968584u, 3990119319973623338u, 8191017075872908817u, 1141713u},
    {17469457571428819442u, 12962263974159485036u, 3266310098058250338u, 9028260150448636229u, 715519u},
    {17472824109466264998u, 4318974313913137577u, 2054320421103121375u, 17090848791890057567u, 3005457u},
    {12586040118017302381u, 11048032450647749294u, 14042142663600729382u, 8558237009669884127u, 978452u},
    {3516069521339000506u, 8889019757158946439u, 16005549182255056841u, 3188583399859475451u, 3405736u},
    {5233149580216311252u, 15416816064220688514u, 6307768727003437057u, 12024385353859240049u, 361420u},
    {5829102695104854429u, 5307751065949726572u, 79224510906470224u, 6347735309605163828u, 3793393u},
    {11977807622861547907u, 17862470761663781724u, 13621756804110582485u, 4537546586541268638u, 3442520u},
    {7686432350418283481u, 3599155561938058561u, 3142973940881212822u, 14763252473683472136u, 2177443u},
    {7819092567301592292u, 2368038165812233080u, 16286077386220783545u, 18342795634153038564u, 3221615u},
    {5372208833639235635u, 3082901203660999417u, 5209700036579587313u, 7625475699734252711u, 2888085u},
    {10694474075110362264u, 3780107702557922132u, 2087213513380617616u, 17707386311775939470u, 1678018u},
    {6384012970318514933u, 16385787941534421020u, 2942561123032259478u, 2120624213404374410u, 616662u},
    {6407505706242662186u, 17149678067089559511u, 17026348509218780153u, 13702318275420913932u, 1335067u},
    {14395207889288469668u, 11625540585016893616u, 6792685243912355156u, 529030811238069017u, 1075882u},
    {5612583049577566896u, 9628108739787644397u, 918543250177778907u, 14359307733984200855u, 3733254u},
    {14079414202879457718u, 14804774088988850455u, 7246606380601889310u, 501211959687027828u, 585671u},
    {15037531199452479415u, 6786674001199481004u, 9066983573110500698u, 14638495313248976514u, 1154846u},
    {8193072917332202841u, 16461193696415269833u, 1743358441624700078u, 9677020764327385918u, 3860329u},
    {2757332114571940268u, 14000573143151682994u, 140704054798592090u, 2737341490183673516u, 1549781u},
    {13308874017389432164u, 7586870662989220123u, 14695960444006191941u, 388876386404278832u, 2728316u},
    {18059534145317619065u, 3194469699581797601u, 7951238242006612414u, 17200035928419932103u, 3115525u},
    {12511338036229165627u, 5478595592412785293u, 4028224790039462104u, 15693969215760641991u, 194339u},
    {12530688739001267133u, 7325518328129058215u, 5758037073524565433u, 1516794412286996512u, 3491759u},
    {16189111255281560769u, 12284054511171353706u, 9742261539679856986u, 8783380464746146658u, 820462u},
    {5311464783685685045u, 17420533008174653029u, 16309010864667852774u, 12841386600070756958u, 1156107u},
    {10042454204641683390u, 3721791010284411877u, 12191008054689154916u, 10902023122519329064u, 3553939u},
    {13506902681551157716u, 17337126747259386591u, 12542761966656483388u, 15629998926281032548u, 2517422u},
    {9188057585060224851u, 12146579404657134670u, 2384914990228411911u, 12368286835475202029u, 954923u},
    {17916659884041529276u, 11437694544312623238u, 11676929140957789134u, 15149709980524252341u, 2176274u},
    {15473346286482908226u, 5982595181054661072u, 4755775853907071566u, 4291543232899726385u, 2587282u},
    {6542450657993928882u, 257559312804343380u, 440399362105692839u, 5524104080074581765u, 2941361u},
    {12625182234890189154u, 3726365804098462224u, 9691386982180174597u, 7908536289253639504u, 2029176u},
    {17878077009615476354u, 6903755161162257990u, 6707013318223769538u, 12071049902595015254u, 2163416u},
    {15323598864680908184u, 3678533458701761426u, 16858396589789281584u, 2417808596599640213u, 862891u},
    {1479864860384542956u, 12792726408389217443u, 5591615246794724380u, 8806944004485524097u, 411236u},
    {16926182853456537690u, 11701410766209768257u, 12061984192562837431u, 7213345377845633625u, 1952316u},
    {5607476126351967592u, 4472551961014934367u, 15096377823663196918u, 1693338543688696242u, 3425622u},
    {15724438503011367499u, 3168221326262907588u, 5803371415446641513u, 11808579402202861173u, 2133716u},
    {6997625175068448707u, 11944222094434265399u, 15472137034955355874u, 7533349904731063995u, 1393924u},
    {1258591969483518463u, 7242470982094379874u, 13979776079979741373u, 4349169009095227577u, 2964136u},
    {1191818494886703644u, 6644477027137314861u, 10774214783556045621u, 12304469648988587264u, 3080753u},
    {4721913966982591540u, 589753722535088576u, 4763578585939863391u, 17638882819704198955u, 3150243u},
    {18108073663154365390u, 3826011131420115710u, 13201258241673595209u, 3877164228040058426u, 1560645u},
    {11751122570087962057u, 17414846956876585343u, 4091686077461852872u, 12494752591343611599u, 23125u},
    {8032166890771493474u, 12886284028422760686u, 13368938332974983281u, 937175315944520292u, 663983u},
    {13731437204722570086u, 15782377556709896404u, 2862322630640295060u, 660766671748820629u, 2186157u},
    {10068599281499414349u, 16480249524080508682u, 18096262229511121900u, 2562343270672193083u, 1044570u},
    {6250359188435401986u, 8455765179709131637u, 68588757251361305u, 15439594042135996361u, 1843032u},
    {13613748875765135037u, 4892173806485038938u, 8668790469703677986u, 10194118714411090080u, 3266603u},
    {7905040104385738203u, 2509702299402545261u, 15653363367177375603u, 3519022713546071484u, 2533190u},
    {12486760691075505403u, 12531212432063884009u, 11145643131547011334u, 12584750473738563876u, 3368237u},
    {4024112240557703599u, 9812893502321967712u, 13742545209927935712u, 16995667617416414672u, 3600662u},
    {1211912130143346108u, 3121733950117510721u, 17656936852481398865u, 11163289989246500942u, 2186242u},
    {15140994288621419495u, 6880810583769912132u, 14583405844775766686u, 14019502301178504490u, 1463220u},
    {10796865818466532895u, 8949822435067960099u, 5424597335318467006u, 9106248507661955527u, 803247u},
    {7416189153424231159u, 14182710383666016258u, 16027503012694514724u, 9310246931835927227u, 462751u},
    {8427573048570709107u, 1664615974011115496u, 10252383881407199166u, 5701086187573407044u, 128892u},
    {16018323343997346281u, 7640069953757196878u, 1850144172389099104u, 14125666074872110215u, 2990910u},
    {14903997858926207653u, 1813711628870279927u, 16526821248594662781u, 10359408512866859557u, 1573229u},
    {4117870365380251735u, 11986109852717690929u, 851273370724365700u, 2406921566343368405u, 2407763u},
    {17545094104410614494u, 9138352997653518297u, 8687741548543047370u, 5664907725216447705u, 812833u},
    {7900206747775122276u, 511039346690877413u, 3415153338911772787u, 3113470671621474529u, 1799307u},
    {4001440080699916194u, 9533695027430196627u, 14960395058532845785u, 17327013927955209423u, 1141772u},
    {13683366553609002450u, 10541638820124444900u, 2267344208123655333u, 669580339542892854u, 2190985u},
    {10005348199927692849u, 14224866489681808123u, 9043970332562082174u, 17262181515298693565u, 1671851u},
    {8383536854579900196u, 7149188234564492796u, 16186183790403832803u, 12424746399312161894u, 1086412u},
    {15657213792676115531u, 16408182937845027527u, 12957061048258428538u, 10396334318008976124u, 1185544u},
    {8254860859075841863u, 561463307525263528u, 12359599449361215080u, 15370136967231106602u, 9u},
    {14519088864083972760u, 3550758722225498948u, 11382953517892260936u, 181390833630u, 0u},
    {3948282160261821717u, 11914881423116179257u, 7209607959391845141u, 181u, 0u},
    {3334260967208187453u, 15139014816111327163u, 3346070285300u, 0u, 0u},
    {5670011940228982540u, 1296534956382912764u, 3346u, 0u, 0u},
    {10009570430271881468u, 61724102205588u, 0u, 0u, 0u},
    {1885360334748570495u, 61724u, 0u, 0u, 0u},
    {1138608716565984u, 0u, 0u, 0u, 0u},
    {1138609u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1982496u},
    {12511843883232364819u, 2558087034304555333u, 4436691644854928896u, 3495335110159693819u, 2178581u},
    {6901338498900127530u, 1357944818906150733u, 15289228084471392013u, 11137057211487083482u, 3344827u},
    {1235056100664979097u, 12380293161284682889u, 16420810387939564145u, 16707005401538244125u, 3546149u},
    {9710821956022057656u, 17013489053555056305u, 5382223302897409264u, 4893273720298418166u, 882912u},
    {12716627858180047117u, 17330815539107658238u, 17244089377698955895u, 1529496331393367423u, 45771u},
    {6884237500351611286u, 3263488017810086028u, 5172160083244117050u, 2739032900893755659u, 1557789u},
    {906016933365846472u, 13881964033547910756u, 10995969172684036468u, 17899019459149000957u, 3143038u},
    {5279909804883591311u, 5666402753064943963u, 15514640847250974463u, 4021146507584999860u, 2809058u},
    {14726668504197229024u, 14940325556634221418u, 4212085063758774075u, 15832431072341570897u, 3063115u},
    {14949309480546521123u, 13608883777066589394u, 9957824304867915283u, 16485635954953341313u, 2310564u},
    {923292649297340774u, 15518291644983516925u, 6888249203260237716u, 14598256394921005663u, 1267239u},
    {6654763515609447333u, 5613881184974605739u, 7402934573602843871u, 8093826980359408845u, 2029279u},
    {4614666631542837336u, 13881315393036440074u, 10204253845630616629u, 14737182782198279169u, 3608925u},
    {14481052006205182763u, 17386951579182697136u, 14094271141361117891u, 15270725272596189521u, 3509449u},
    {9886825287507624113u, 6548254208507308009u, 14857175648664735138u, 14980659888664543936u, 1310889u},
    {2092716292495394869u, 5605598403448031977u, 1344593520566546143u, 2978543004427746305u, 1277660u},
    {4826083395750513829u, 10444509293057149856u, 2682984202834829304u, 16164469734507616414u, 2620118u},
    {2637619364547698219u, 6646844024305171213u, 8644644219281165766u, 1417426949074020241u, 1257966u},
    {1773829707840237067u, 14607676288730429810u, 16273593981945684579u, 18037603887754839058u, 1569027u},
    {8184453515326107972u, 16337831490624965042u, 7346170317464801838u, 12855195196302516772u, 1870439u},
    {864352196163978409u, 10552544339110773640u, 5858615753741867519u, 4285901570631428640u, 3741381u},
    {15919236872003123456u, 7157530309730903947u, 10441785686887916212u, 2735147281478474718u, 2968551u},
    {16491493312792383960u, 2691024978368799423u, 11763546518342293758u, 9061959358042893844u, 1368223u},
    {3600675756746195517u, 4646888865171476505u, 16299399412050460276u, 457584832806290077u, 851733u},
    {6162197598799946161u, 3664039074862930440u, 6139825474073051166u, 3186245838796546874u, 1649418u},
    {14547061209556777484u, 10013485897269506043u, 72059666213089665u, 10983180688667861972u, 413175u},
    {3802071625001349596u, 8835422575197540120u, 12115872642059065490u, 7285438742296557168u, 3794913u},
    {6107470075384621637u, 9056840484896435106u, 17492799788122194962u, 10590412525715910733u, 2842393u},
    {7905371990698833585u, 9207576062067810656u, 4839832064656638232u, 1925930351804442375u, 2499244u},
    {477626647236721854u, 12708063384891515278u, 7810732905869156458u, 8981244577074748570u, 2886491u},
    {3312246859167639919u, 17712314161623633851u, 7901995352792892028u, 3584068477587779398u, 1721779u},
    {2370343362898495492u, 15639138944291709270u, 12167919953825531939u, 11921264236406665475u, 1653378u},
    {3438786360317663520u, 12984440092647208957u, 8087501294238292219u, 5290703817513105315u, 93264u},
    {11936999604104162786u, 2729447467619165873u, 2490678267668376457u, 3604600124326391065u, 3444813u},
    {9624025608638620029u, 1797916064390965500u, 17660154119416683532u, 9286917624252163553u, 284999u},
    {4118484359976772907u, 8132869224689913675u, 13893569982999247885u, 16146158377397038436u, 3190151u},
    {11685199740396806182u, 7779551233956269793u, 3585538890916964266u, 15407115445278297345u, 487861u},
    {14944877370540182533u, 3677531875161331365u, 15481074332667283038u, 5845664579489822276u, 2115371u},
    {9410404420066477640u, 7226903618929933574u, 7402896305201716053u, 6019802018451630315u, 2070349u},
    {16765038653753296774u, 15943027219922424391u, 17160347451964716668u, 10630657527741469106u, 3555300u},
    {16277167456434549882u, 9788004088718377297u, 11101876056023318810u, 9649243726880332584u, 929683u},
    {3848886032096132975u, 13817035633003641716u, 17623102717304447189u, 9240521670874698051u, 2246984u},
    {3494312500304109689u, 13905087609646919579u, 55786568817094774u, 16038235424446243646u, 1091259u},
    {9159896849331685963u, 11647086323510163694u, 611845112373958981u, 7153832001284233300u, 168337u},
    {15319757948698676516u, 2247559665962923482u, 1376420264167397055u, 11892608292969077486u, 3548693u},
    {389944004299961232u, 80085416392181188u, 15161662555801689948u, 16350478096031486398u, 1616772u},
    {12215514280017594164u, 2891511417008106831u, 3999068740563952565u, 3416531115442630627u, 2950649u},
    {13487047088018622746u, 11203274750214892018u, 3852222703779574989u, 7620477244353311410u, 181928u},
    {233917456595095063u, 16050156321171982270u, 12169447266398086146u, 13694298854082626915u, 1878856u},
    {14981697004919792293u, 3040117923620635967u, 7261712283000801489u, 10843297895166842887u, 913290u},
    {15939711720577873666u, 17162982048484033632u, 10371119735072749527u, 16950381836651441051u, 1500590u},
    {17037563367849495064u, 17843479905835360944u, 13113688749258137912u, 2333524025853643604u, 2735816u},
    {5770829553060884185u, 2898169307429560867u, 9546600695781462485u, 4013634572004320276u, 682022u},
    {10612858190348798001u, 13142798478696752253u, 15063017751487481161u, 2030193722362256315u, 3750603u},
    {11372036935916883176u, 7257763905979127761u, 14423154346280770209u, 18011527331137337051u, 1477567u},
    {9728735230394136363u, 12007025883397159518u, 3503688308361513840u, 891947446767421364u, 3660143u},
    {5795507120358518770u, 2284376028633309966u, 2727580813658851346u, 7489449907992704354u, 443126u},
    {11378273129634810725u, 13271304640066196256u, 14058189320923013050u, 3322823565148541582u, 2950157u},
    {13452714615853947811u, 16209304445591064672u, 15040465984179661353u, 15474745918595664618u, 849878u},
    {3273404559270897665u, 9064479344331472323u, 16675256511302206578u, 12265468483882371164u, 2079631u},
    {15393411899635506913u, 18237564239977661558u, 7731120109143127821u, 10919059132817339488u, 3437448u},
    {1307398797624639615u, 11199843228441377096u, 11080137481040428446u, 15195504482406610443u, 1539776u},
    {3760039248096958148u, 9526418664578893555u, 17629340428451001278u, 5865068986070507496u, 3251468u},
    {17337436339003423897u, 2662459570350250031u, 8195515490200300099u, 14471497811510512434u, 851697u},
    {735811695496258703u, 2315698646066134693u, 9098022471466203121u, 5636203386017223023u, 495341u},
    {3392305562685027758u, 16585186931776875013u, 447224329713818663u, 18023535943774402749u, 3138079u},
    {3197627777972651577u, 17325995017071270263u, 14757181516991283549u, 13100311879084574755u, 504444u},
    {12564788532231988961u, 13540797326691542816u, 2581737306043990613u, 9809138151626029516u, 93078u},
    {11274513632083873619u, 6850936977605318428u, 5005405283737965742u, 4108999856015923241u, 3651527u},
    {5875261951948373744u, 18350203229918170392u, 16595444947485042647u, 13758301655362548113u, 3903236u},
    {12209013136382502802u, 10193945115013221587u, 14277364674990794622u, 6124839908495538054u, 1308060u},
    {1529587853006456514u, 12416969152708729179u, 10742701491529497314u, 18326758339811592168u, 3557645u},
    {3955998918380443401u, 9448826716494585351u, 10523802719828813820u, 18296198276742638565u, 3821214u},
    {5543151689607459944u, 1828301898436696523u, 5744692225741875957u, 7276248378797867847u, 2458104u},
    {5990717590170421787u, 10846798651050922309u, 8547555484954822340u, 6602585080122252298u, 3009803u},
    {4697816178341264605u, 13011209431005569680u, 13000231217905739748u, 6973050099896950165u, 896955u},
    {11125680865811634913u, 1097080788336719864u, 14142739521488909342u, 8591399596817108634u, 3686075u},
    {10860536079787201296u, 4313532881481091548u, 5350585751027120989u, 11308980760669656548u, 1052638u},
    {7349059404215080180u, 7307188553694457345u, 12241620117191349667u, 451763319324809851u, 3419039u},
    {11670318201780797520u, 14562407038649943340u, 17938109705763769052u, 207185325938651022u, 815349u},
    {1643237966004725021u, 13398953944618496666u, 2567879137399312280u, 1095904445109859375u, 2932420u},
    {16816595450997741145u, 1865257297807354223u, 8479047668489161540u, 13889151657634695520u, 1717605u},
    {1070170589653658023u, 3892350438984882072u, 702732413315827779u, 12857935972495048160u, 1328079u},
    {10849465071808413496u, 13723037678582974800u, 1764870546583863081u, 14868363118093758896u, 2382088u},
    {18332062890262053251u, 845582990095700502u, 8921087161945151598u, 14527518184188932892u, 203642u},
    {2699881234479631813u, 16539863962647185716u, 12896457546859604298u, 2093426773484086688u, 1426372u},
    {1121973847496123465u, 17063417919114988991u, 769300076267388893u, 6151207414555206574u, 2881784u},
    {10115978384430956594u, 10061407286698681256u, 910706864357697111u, 17635212483329334805u, 1120177u},
    {8487186545543278105u, 4697273442307817618u, 13464109472795361188u, 5136752812764351683u, 3784806u},
    {8600537100774436739u, 18230335214862385915u, 18039037451623721772u, 15994545635169467021u, 2561859u},
    {4408692650344811502u, 12275098314233735353u, 6693975997963605413u, 11504415425351016937u, 2187679u},
    {11168976277753967314u, 17066489131717799319u, 9606256371338226074u, 5012329554749871847u, 2768568u},
    {14657175271729030221u, 15205574307889461454u, 11958613475835357540u, 2861317237838180964u, 3163404u},
    {5781719881192315702u, 9864425702051346085u, 4767410271016276736u, 7264113910643859928u, 481000u},
    {15407875957278529747u, 2151930470076811459u, 17914664864249310273u, 14636564480862939212u, 2611375u},
    {14262419306222146891u, 15210979760837565976u, 3950761553634856869u, 2714302360345381393u, 1278977u},
    {2900600732291367777u, 17666418572637440494u, 10008432725611885043u, 14651284553808834189u, 186979u},
    {16332200259801252245u, 16652169030214106134u, 1114962782337836092u, 2381349771663064580u, 1258351u},
    {18388706611795653558u, 4483784206878918450u, 11964738911627924019u, 12993579408060274739u, 1087341u},
    {10692520079867364210u, 16641374867843252477u, 11510174236566605303u, 6577298971592873001u, 3405546u},
    {14707456188763582654u, 17709979195138839252u, 4806028695306845106u, 12961130574859644784u, 84629u},
    {16863121288562347388u, 17475077969791200601u, 9285265442820630328u, 14196907167937147932u, 1103354u},
    {7990628259323895992u, 10793408827174227110u, 10161720949894522427u, 3983520975143647376u, 1428243u},
    {8669606801391211358u, 5608434649934751660u, 5023750578299253535u, 13933462086399679774u, 3368182u},
    {2233536134545960707u, 15158820599301476419u, 7023817069088722467u, 13753074872487445111u, 598091u},
    {7945127837803492185u, 12322468203331189485u, 17026532335104730615u, 515436003628359443u, 3062058u},
    {9902070205229791656u, 6433799166228204875u, 15320854228118868486u, 6469610870155877229u, 1676661u},
    {646261968955069551u, 764598474355687865u, 12505258208004719926u, 14298332562344712128u, 2777759u},
    {13569548774259974950u, 14162042790994560705u, 13503398005554141714u, 12301031610117525052u, 1551993u},
    {13699805969454207769u, 17034785175733861032u, 4772094122242305005u, 10981383523741266590u, 742471u},
    {14922681198620889228u, 14601745726238905561u, 4411533795591857194u, 10678220101113869256u, 722539u},
    {9990585880627372172u, 17276882459006216968u, 15291286095448817569u, 10245506856080261038u, 2184758u},
    {10460207199947703057u, 14531286616604038136u, 11985402415113294560u, 13154783796837380740u, 2500289u},
    {8338509035280364908u, 750435404394774448u, 17299315357390471106u, 10134185369758006017u, 1153356u},
    {5356777173510302230u, 18125603120460787097u, 6855350844498817385u, 3191809810760891907u, 2922702u},
    {13312698675671399793u, 16064590757758035774u, 12692805029051512688u, 18140370442509440800u, 1132325u},
    {5565522563564437265u, 18165628401450731519u, 10017098553551155423u, 9532490140630121162u, 3713265u},
    {6506948763864862630u, 668086762854091286u, 14969669368632033288u, 6193393151889227798u, 3197860u},
    {10092972625178125012u, 7041841931769802466u, 11436419784886499504u, 5247136881927757370u, 1027609u},
    {3711066434887278236u, 590261285095641599u, 10225464008233773452u, 1027762362008968584u, 3466988u},
    {9395214216064241689u, 7445469752319546164u, 17469457571428819441u, 12962263974159485036u, 3663316u},
    {243651467309565394u, 14177903953866050036u, 17472824109466264997u, 4318974313913137577u, 1258789u},
    {18095522567795327206u, 18214798657061119367u, 12586040118017302380u, 11048032450647749294u, 1405976u},
    {5920371977215369418u, 3835493900750435851u, 3516069521339000505u, 8889019757158946439u, 3716023u},
    {17405235799480173892u, 7899918079414256664u, 5233149580216311251u, 15416816064220688514u, 2577511u},
    {2799967105684232131u, 8039384212432615992u, 5829102695104854428u, 5307751065949726572u, 3482730u},
    {757544177533652241u, 2024523898236022441u, 11977807622861547906u, 17862470761663781724u, 3704363u},
    {2858026537354830615u, 16432293546647720450u, 7686432350418283480u, 3599155561938058561u, 3371606u},
    {12435502146421808819u, 11672848642982342769u, 7819092567301592291u, 2368038165812233080u, 3061909u},
    {14380675292080780692u, 6553742182942109959u, 5372208833639235634u, 3082901203660999417u, 1795049u},
    {17335651664028416690u, 6502935694126590809u, 10694474075110362263u, 3780107702557922132u, 1556594u},
    {2007711046921421018u, 15057494996182332331u, 6384012970318514932u, 16385787941534421020u, 3904660u},
    {16948184507002026143u, 4199737255540544819u, 6407505706242662185u, 17149678067089559511u, 1315567u},
    {7754934247272660417u, 11832064710906006537u, 14395207889288469667u, 11625540585016893616u, 2409570u},
    {16161524993293801033u, 1833367358295831086u, 5612583049577566895u, 9628108739787644397u, 1787161u},
    {2260163242345027541u, 15793712368913999453u, 14079414202879457717u, 14804774088988850455u, 718834u},
    {1105252703657071082u, 13296510930313891908u, 15037531199452479414u, 6786674001199481004u, 1738098u},
    {867339417926585974u, 18395693940267180227u, 8193072917332202840u, 16461193696415269833u, 1160090u},
    {6203587551868971923u, 15520979949124421002u, 2757332114571940267u, 14000573143151682994u, 1128832u},
    {14062676310427508901u, 13994769298463790231u, 13308874017389432163u, 7586870662989220123u, 1297549u},
    {3889249387482813846u, 4617630956868511948u, 18059534145317619064u, 3194469699581797601u, 120262u},
    {13900270619885909633u, 17306988974196433936u, 12511338036229165626u, 5478595592412785293u, 2585894u},
    {1807618306628052855u, 6145547157030215441u, 12530688739001267132u, 7325518328129058215u, 1857429u},
    {1776719869084728527u, 4595069123724361202u, 16189111255281560768u, 12284054511171353706u, 2962736u},
    {4384084225758063886u, 327490217223975432u, 5311464783685685044u, 17420533008174653029u, 2539944u},
    {14521730433964551334u, 13472180568380435049u, 10042454204641683389u, 3721791010284411877u, 2347524u},
    {18285779441204315063u, 7501581827641382183u, 13506902681551157715u, 17337126747259386591u, 2217388u},
    {3890819873709376313u, 4204671512216675998u, 9188057585060224850u, 12146579404657134670u, 2851163u},
    {6980453937726841247u, 3096745284010766971u, 17916659884041529275u, 11437694544312623238u, 98384u},
    {10302505889617707789u, 8844641697566517329u, 15473346286482908225u, 5982595181054661072u, 2243568u},
    {13496609915126913535u, 1710300676983905895u, 6542450657993928881u, 257559312804343380u, 2787945u},
    {15054896816166712710u, 7001072138098668320u, 12625182234890189153u, 3726365804098462224u, 3159567u},
    {7799352474029107208u, 11247767341799548345u, 17878077009615476353u, 6903755161162257990u, 194948u},
    {11917844435631612606u, 16893758467763758680u, 15323598864680908183u, 3678533458701761426u, 2088838u},
    {733876276135197267u, 15255470776634499241u, 1479864860384542955u, 12792726408389217443u, 1522248u},
    {10158654004120182385u, 7250565287577963791u, 16926182853456537689u, 11701410766209768257u, 270027u},
    {2197737701956036427u, 575913131062672560u, 5607476126351967591u, 4472551961014934367u, 3780872u},
    {12838625447938673203u, 14292985472533344496u, 15724438503011367498u, 3168221326262907588u, 2966327u},
    {11350325618429984281u, 5885836182072218110u, 6997625175068448706u, 11944222094434265399u, 1990138u},
    {16780220916361691292u, 9452193166969928078u, 1258591969483518462u, 7242470982094379874u, 822821u},
    {7491201202423103588u, 2149640085026898999u, 1191818494886703643u, 6644477027137314861u, 720613u},
    {10540634688015042771u, 10551750616865322733u, 4721913966982591539u, 589753722535088576u, 377229u},
    {10217127610096429756u, 7855837045515702235u, 18108073663154365389u, 3826011131420115710u, 2654495u},
    {5765753795481358728u, 10343965058479217555u, 11751122570087962056u, 17414846956876585343u, 3254356u},
    {6736094883031500566u, 6209703118174634122u, 8032166890771493473u, 12886284028422760686u, 95651u},
    {18444357108655996631u, 16565912301723141848u, 13731437204722570085u, 15782377556709896404u, 2771116u},
    {10560122153002314700u, 7940656398265889303u, 10068599281499414348u, 16480249524080508682u, 1356698u},
    {6266618536535118005u, 15872994359674523669u, 6250359188435401985u, 8455765179709131637u, 3486523u},
    {1881853992338831963u, 6192292809945735243u, 13613748875765135036u, 4892173806485038938u, 3238734u},
    {1201635871152737964u, 11210004254880971172u, 7905040104385738202u, 2509702299402545261u, 3537137u},
    {6698646825852875608u, 115687844331070022u, 12486760691075505402u, 12531212432063884009u, 708022u},
    {14675463498460584934u, 9398873954259366704u, 4024112240557703598u, 9812893502321967712u, 1260786u},
    {12283428638941621986u, 2875674121776364623u, 1211912130143346107u, 3121733950117510721u, 1915739u},
    {7773706165886145452u, 14254301398131939545u, 15140994288621419494u, 6880810583769912132u, 795846u},
    {3312224638137110618u, 1373112592129996481u, 10796865818466532894u, 8949822435067960099u, 3221270u},
    {17414561105616632648u, 966092845107941081u, 7416189153424231158u, 14182710383666016258u, 395262u},
    {13623710202516116407u, 6768581863495163201u, 8427573048570709106u, 1664615974011115496u, 106522u},
    {12403745404735070764u, 2598531490561257241u, 16018323343997346280u, 7640069953757196878u, 665254u},
    {3984416913263401613u, 2884165999823378057u, 14903997858926207652u, 1813711628870279927u, 1330817u},
    {4584079233973645535u, 6763669091638037881u, 4117870365380251734u, 11986109852717690929u, 3203608u},
    {5522058982085385957u, 3816193171655448424u, 17545094104410614493u, 9138352997653518297u, 359748u},
    {2267838147151380978u, 12311459064444907755u, 7900206747775122275u, 511039346690877413u, 1197643u},
    {13932855518845365229u, 12912165450890829874u, 4001440080699916193u, 9533695027430196627u, 1150885u},
    {4921953516171707104u, 11567104394606873524u, 13683366553609002449u, 10541638820124444900u, 1600307u},
    {9087135089159873328u, 12497260360103396284u, 10005348199927692848u, 14224866489681808123u, 839520u},
    {12955990650387758768u, 5272277513007825557u, 8383536854579900195u, 7149188234564492796u, 2770629u},
    {11732004488505094981u, 2585944925095323463u, 15657213792676115530u, 16408182937845027527u, 3093236u},
    {7722558066384807585u, 6544181281742034802u, 8254860859075841862u, 561463307525263528u, 1080766u},
    {8812358258303115837u, 305448684294757963u, 14519088864083972759u, 3550758722225498948u, 1375766u},
    {18107566215762086005u, 4531406212799166314u, 3948282160261821716u, 11914881423116179257u, 375137u},
    {13504756466283525842u, 6508389471989647068u, 3334260967208187452u, 15139014816111327163u, 3879050u},
    {4002530786941312137u, 4942429874284404575u, 5670011940228982539u, 1296534956382912764u, 3346u},
    {5556380661485988175u, 2725339295884964243u, 10009570430271881467u, 61724102205588u, 0u},
    {13356937694402061675u, 7406583114056784828u, 1885360334748570494u, 61724u, 0u},
    {15648617910059072899u, 2075562681147754256u, 1138608716565983u, 0u, 0u},
    {6567645663946930780u, 13218309302402671991u, 1138608u, 0u, 0u},
    {10128415775026933749u, 21003623594587587u, 0u, 0u, 0u},
    {10968205056921928210u, 21003623u, 0u, 0u, 0u},
    {387448469069884691u, 0u, 0u, 0u, 0u},
    {387448470u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1955426u},
    {7640156172174381424u, 12074505523253806975u, 12511843883232364818u, 2558087034304555333u, 3301836u},
    {1590566217304393086u, 3043088583310615356u, 6901338498900127529u, 1357944818906150733u, 3168287u},
    {15343607330713875342u, 3858282790293201746u, 1235056100664979096u, 12380293161284682889u, 428089u},
    {13177118234216213203u, 8789233526748502708u, 9710821956022057655u, 17013489053555056305u, 2005392u},
    {11261525132619951836u, 5791674199595149473u, 12716627858180047116u, 17330815539107658238u, 1132789u},
    {5578487283736404195u, 7668136420737987155u, 6884237500351611285u, 3263488017810086028u, 2542778u},
    {16627444478109300460u, 14899385408241086318u, 906016933365846471u, 13881964033547910756u, 2488808u},
    {10026214163643771038u, 9717977498606067045u, 5279909804883591310u, 5666402753064943963u, 1322921u},
    {13090793720080100322u, 15629345080253294289u, 14726668504197229023u, 14940325556634221418u, 3364067u},
    {16375508558050264612u, 905588737840771031u, 14949309480546521122u, 13608883777066589394u, 1404525u},
    {12509774746771869451u, 15918068565955195676u, 923292649297340773u, 15518291644983516925u, 3547858u},
    {13818537385160453069u, 17603779923724125607u, 6654763515609447332u, 5613881184974605739u, 2507615u},
    {15688275956862186322u, 4611851982940854918u, 4614666631542837335u, 13881315393036440074u, 1142283u},
    {256549769100358180u, 15187037771057708010u, 14481052006205182762u, 17386951579182697136u, 3419071u},
    {5636975128234086768u, 14824392262210401816u, 9886825287507624112u, 6548254208507308009u, 3098848u},
    {12057930465257767418u, 11756466846816851344u, 2092716292495394868u, 5605598403448031977u, 3697983u},
    {8352230315415923696u, 12914804386202790324u, 4826083395750513828u, 10444509293057149856u, 951136u},
    {4359640119720108479u, 16512431404944754u, 2637619364547698218u, 6646844024305171213u, 2821218u},
    {6246224308148832681u, 16159381639914710830u, 1773829707840237066u, 14607676288730429810u, 2863119u},
    {5391899735240872342u, 13207892569235275682u, 8184453515326107971u, 16337831490624965042u, 1742074u},
    {17183405418877255196u, 455922121228395404u, 864352196163978408u, 10552544339110773640u, 1291745u},
    {13753266906343195761u, 13713519247438232722u, 15919236872003123455u, 7157530309730903947u, 1349506u},
    {12216028108990346172u, 13039865842048243632u, 16491493312792383959u, 2691024978368799423u, 1908350u},
    {904681173065771625u, 12801286426423769933u, 3600675756746195516u, 4646888865171476505u, 3315456u},
    {4011902033925330549u, 4723132625845800945u, 6162197598799946160u, 3664039074862930440u, 3769658u},
    {17347792452058731668u, 8454866811515625083u, 14547061209556777483u, 10013485897269506043u, 2406717u},
    {14721214773273207590u, 8484449397549765434u, 3802071625001349595u, 8835422575197540120u, 2691056u},
    {3734245437526923089u, 7749865516259327691u, 6107470075384621636u, 9056840484896435106u, 3049948u},
    {2944012016440920881u, 8851803337011606042u, 7905371990698833584u, 9207576062067810656u, 1405496u},
    {6811079105535212964u, 6903064132807950290u, 477626647236721853u, 12708063384891515278u, 3155224u},
    {15181821827242885241u, 12052313894122013706u, 3312246859167639918u, 17712314161623633851u, 143170u},
    {13723244422533280252u, 14225181875175911409u, 2370343362898495491u, 15639138944291709270u, 762907u},
    {17506341194065939525u, 13400423319680462836u, 3438786360317663519u, 12984440092647208957u, 3432393u},
    {17469270676298741803u, 4995050675939476741u, 11936999604104162785u, 2729447467619165873u, 3715225u},
    {6275028746108864039u, 4980273239111072408u, 9624025608638620028u, 1797916064390965500u, 3383724u},
    {1913118474987312880u, 9308414704854830758u, 4118484359976772906u, 8132869224689913675u, 3761567u},
    {2377336798878871505u, 15411023510299777557u, 11685199740396806181u, 7779551233956269793u, 140652u},
    {10778669660647407197u, 15304359332420089317u, 14944877370540182532u, 3677531875161331365u, 1146230u},
    {8440502356407708565u, 5619417864313932906u, 9410404420066477639u, 7226903618929933574u, 991987u},
    {12990854368851138581u, 893491943363115450u, 16765038653753296773u, 15943027219922424391u, 3265014u},
    {9619874815574729039u, 3393518620732995145u, 16277167456434549881u, 9788004088718377297u, 2929252u},
    {5248118344372680751u, 6687364301307187605u, 3848886032096132974u, 13817035633003641716u, 3796309u},
    {17121768851591386238u, 11681620834807713511u, 3494312500304109688u, 13905087609646919579u, 2483564u},
    {994421322816408290u, 5941853739230880595u, 9159896849331685962u, 11647086323510163694u, 746703u},
    {11465675956524017407u, 11672085712050502482u, 15319757948698676515u, 2247559665962923482u, 435189u},
    {1595788328356483381u, 11279236053014272665u, 389944004299961231u, 80085416392181188u, 499148u},
    {12912246716529547903u, 4095186917076883356u, 12215514280017594163u, 2891511417008106831u, 1861991u},
    {248895216083966867u, 16075451190514039775u, 13487047088018622745u, 11203274750214892018u, 2893217u},
    {12011234648622660253u, 1846847173197128231u, 233917456595095062u, 16050156321171982270u, 742622u},
    {3534153694083135827u, 17059936561093405440u, 14981697004919792292u, 3040117923620635967u, 719621u},
    {6015846277894209081u, 6429486119287055129u, 15939711720577873665u, 17162982048484033632u, 2453233u},
    {9199921232085293271u, 1045196676163285898u, 17037563367849495063u, 17843479905835360944u, 860072u},
    {10149780114115848993u, 14229180103713050368u, 5770829553060884184u, 2898169307429560867u, 1535033u},
    {6863473289253073859u, 6401634558171025337u, 10612858190348798000u, 13142798478696752253u, 2819169u},
    {3016174169753486454u, 6249552361076141354u, 11372036935916883175u, 7257763905979127761u, 2464677u},
    {11241570578418201349u, 2059296064365365315u, 9728735230394136362u, 12007025883397159518u, 2742522u},
    {16794436512191714970u, 360624293286887616u, 5795507120358518769u, 2284376028633309966u, 688866u},
    {700141613319552264u, 16889335665517503030u, 11378273129634810724u, 13271304640066196256u, 3708154u},
    {17020732063701726445u, 8045965152710561681u, 13452714615853947810u, 16209304445591064672u, 3105159u},
    {10563261215570968736u, 13808481211951837007u, 3273404559270897664u, 9064479344331472323u, 379088u},
    {9480024678321818325u, 8471736589417309939u, 15393411899635506912u, 18237564239977661558u, 1675967u},
    {4192181445143738997u, 1194658968645806207u, 1307398797624639614u, 11199843228441377096u, 803190u},
    {2827377607552392789u, 2142983901211760036u, 3760039248096958147u, 9526418664578893555u, 3707222u},
    {15179393678336761355u, 17515704786670982118u, 17337436339003423896u, 2662459570350250031u, 534275u},
    {4922764362500749240u, 12528629995133287528u, 735811695496258702u, 2315698646066134693u, 647285u},
    {10569621474808919425u, 9968058806604227232u, 3392305562685027757u, 16585186931776875013u, 1744071u},
    {7308989017512372213u, 16813767112287460468u, 3197627777972651576u, 17325995017071270263u, 3579343u},
    {15580997010177340465u, 10230564132519131848u, 12564788532231988960u, 13540797326691542816u, 296287u},
    {4969708854706237504u, 17075108536862402589u, 11274513632083873618u, 6850936977605318428u, 2579010u},
    {1392607526257613888u, 16472791691211679628u, 5875261951948373743u, 18350203229918170392u, 1833621u},
    {7278817439941422627u, 248835359959992653u, 12209013136382502801u, 10193945115013221587u, 1250246u},
    {13726999931916010171u, 1926865148665544514u, 1529587853006456513u, 12416969152708729179u, 503172u},
    {6098498363755348714u, 14148619668343455224u, 3955998918380443400u, 9448826716494585351u, 1456194u},
    {12729148157832640187u, 6371119511321876792u, 5543151689607459943u, 1828301898436696523u, 2068633u},
    {14985274099345332309u, 14251046141594185557u, 5990717590170421786u, 10846798651050922309u, 2214076u},
    {10451698920939553850u, 6631194732776776563u, 4697816178341264604u, 13011209431005569680u, 879118u},
    {16951385246903731509u, 5619676847927563188u, 11125680865811634912u, 1097080788336719864u, 3368336u},
    {6581872458362129576u, 13927150700571712587u, 10860536079787201295u, 4313532881481091548u, 1592235u},
    {13938207735271921925u, 5205431808130141637u, 7349059404215080179u, 7307188553694457345u, 367167u},
    {15458202815338769769u, 9196898215749567426u, 11670318201780797519u, 14562407038649943340u, 3702498u},
    {10922785322972730929u, 6745089740233914647u, 1643237966004725020u, 13398953944618496666u, 3459550u},
    {4038166850196975686u, 14724967291583699243u, 16816595450997741144u, 1865257297807354223u, 67240u},
    {8564706601805245453u, 2769169009394308513u, 1070170589653658022u, 3892350438984882072u, 1739863u},
    {8226549563942256348u, 1829121997105067795u, 10849465071808413495u, 13723037678582974800u, 2870395u},
    {8152509682448010546u, 10292091811993051267u, 18332062890262053250u, 845582990095700502u, 2096572u},
    {14044367568395136901u, 13593282383277783575u, 2699881234479631812u, 16539863962647185716u, 3134738u},
    {11893270980693716996u, 14069468150730726556u, 1121973847496123464u, 17063417919114988991u, 2461231u},
    {13965296728915330702u, 13511230199504143553u, 10115978384430956593u, 10061407286698681256u, 733453u},
    {588939342998542149u, 12759684038388019350u, 8487186545543278104u, 4697273442307817618u, 3893452u},
    {15289108158340416526u, 4763593197746639023u, 8600537100774436738u, 18230335214862385915u, 1371912u},
    {13586525511941296777u, 16479384987953965851u, 4408692650344811501u, 12275098314233735353u, 3301229u},
    {9663412102110150591u, 13262680930533954516u, 11168976277753967313u, 17066489131717799319u, 77084u},
    {4448543982733604565u, 6013474792651364290u, 14657175271729030220u, 15205574307889461454u, 3501588u},
    {17356461850360950821u, 14761675130967145585u, 5781719881192315701u, 9864425702051346085u, 3375134u},
    {14025912237342641169u, 7077539144210885799u, 15407875957278529746u, 2151930470076811459u, 370115u},
    {1579644127885034611u, 13324727596288442951u, 14262419306222146890u, 15210979760837565976u, 667219u},
    {12106496145107239314u, 5147102225089213024u, 2900600732291367776u, 17666418572637440494u, 372141u},
    {1347878514000512837u, 16461014355529813453u, 16332200259801252244u, 16652169030214106134u, 878928u},
    {6880014789456716867u, 13559536690601512961u, 18388706611795653557u, 4483784206878918450u, 3693239u},
    {5539269796602092524u, 15401458564154031887u, 10692520079867364209u, 16641374867843252477u, 3028645u},
    {13876121675274387615u, 7450163301352625880u, 14707456188763582653u, 17709979195138839252u, 2013374u},
    {639827988403884088u, 6574907124319371567u, 16863121288562347387u, 17475077969791200601u, 3080614u},
    {2056482856497423942u, 10115873243442669726u, 7990628259323895991u, 10793408827174227110u, 3252601u},
    {14765803987949195764u, 2313273496969665918u, 8669606801391211357u, 5608434649934751660u, 1448811u},
    {16914787113889781636u, 9420249213386083668u, 2233536134545960706u, 15158820599301476419u, 33589u},
    {11883473198363570524u, 5310806449514320455u, 7945127837803492184u, 12322468203331189485u, 1120701u},
    {4347714137187001473u, 8013276698976679897u, 9902070205229791655u, 6433799166228204875u, 2386466u},
    {4946640396798785667u, 10803781182097399762u, 646261968955069550u, 764598474355687865u, 2100878u},
    {13454994073587503367u, 16688174614366387985u, 13569548774259974949u, 14162042790994560705u, 1582554u},
    {6251757141427934709u, 15040789893188836913u, 13699805969454207768u, 17034785175733861032u, 2499721u},
    {8822609315428260121u, 17307459450380448761u, 14922681198620889227u, 14601745726238905561u, 2987924u},
    {9737377896378123141u, 17455843051280933917u, 9990585880627372171u, 17276882459006216968u, 2586375u},
    {6972678548712610325u, 4111861525517526777u, 10460207199947703056u, 14531286616604038136u, 1618684u},
    {14740796018625824523u, 1191193632731220361u, 8338509035280364907u, 750435404394774448u, 2122164u},
    {1436324474808985318u, 9418606086982382200u, 5356777173510302229u, 18125603120460787097u, 3675709u},
    {5027858585692095883u, 10723521871901724768u, 13312698675671399792u, 16064590757758035774u, 385688u},
    {2801101789428316939u, 718543193692854734u, 5565522563564437264u, 18165628401450731519u, 1060805u},
    {7810283227550141366u, 14879218442992677903u, 6506948763864862629u, 668086762854091286u, 2832766u},
    {6474053056337858525u, 6475694491587960563u, 10092972625178125011u, 7041841931769802466u, 748128u},
    {5444326359803619542u, 7920375853273594475u, 3711066434887278235u, 590261285095641599u, 1275974u},
    {6260660454444442911u, 15844099656438345588u, 9395214216064241688u, 7445469752319546164u, 2960713u},
    {12153139793643042443u, 14048502395324104796u, 243651467309565393u, 14177903953866050036u, 3051213u},
    {9339312565629303043u, 12387352005062486162u, 18095522567795327205u, 18214798657061119367u, 891290u},
    {9794181343302625762u, 11209948348994742953u, 5920371977215369417u, 3835493900750435851u, 2474167u},
    {4865098414741827171u, 7936006706598706121u, 17405235799480173891u, 7899918079414256664u, 2222141u},
    {8285117087232960449u, 612251336005426277u, 2799967105684232130u, 8039384212432615992u, 374660u},
    {4996633954868017001u, 357500889133282387u, 757544177533652240u, 2024523898236022441u, 171418u},
    {10850242993379209266u, 4221196190647544444u, 2858026537354830614u, 16432293546647720450u, 3880142u},
    {2403667948561226069u, 16673727265399226263u, 12435502146421808818u, 11672848642982342769u, 3716575u},
    {8950157589483892694u, 2282908594808947753u, 14380675292080780691u, 6553742182942109959u, 962350u},
    {8311186325190891142u, 4309270744001944689u, 17335651664028416689u, 6502935694126590809u, 3768439u},
    {823856704661739220u, 2511546659632363901u, 2007711046921421017u, 15057494996182332331u, 1105712u},
    {1064806223590796391u, 12118673100056614552u, 16948184507002026142u, 4199737255540544819u, 792513u},
    {13705084806360806460u, 7554542594544191501u, 7754934247272660416u, 11832064710906006537u, 1730793u},
    {17511829100409708500u, 13247322955703336719u, 16161524993293801032u, 1833367358295831086u, 710113u},
    {1911873976635180420u, 6821431391719201556u, 2260163242345027540u, 15793712368913999453u, 2055301u},
    {4661519161584625286u, 332444350825749432u, 1105252703657071081u, 13296510930313891908u, 1138816u},
    {12647742822372333324u, 13378879390277528074u, 867339417926585973u, 18395693940267180227u, 1550258u},
    {16119099276151252789u, 13153237870583656045u, 6203587551868971922u, 15520979949124421002u, 845463u},
    {10650629052886120601u, 4881659333081193848u, 14062676310427508900u, 13994769298463790231u, 322275u},
    {3859445957348309973u, 12277315304374814180u, 3889249387482813845u, 4617630956868511948u, 713752u},
    {1784902902147885956u, 3037528052320078351u, 13900270619885909632u, 17306988974196433936u, 1119528u},
    {8696672614406939677u, 15621864586809562293u, 1807618306628052854u, 6145547157030215441u, 3005446u},
    {16015427592828498995u, 12273446848415321803u, 1776719869084728526u, 4595069123724361202u, 2128280u},
    {13365566501442979576u, 11236034277057096021u, 4384084225758063885u, 327490217223975432u, 3765872u},
    {10398770635779843269u, 9042439538473815456u, 14521730433964551333u, 13472180568380435049u, 411565u},
    {13368044945019834013u, 13160445082943790810u, 18285779441204315062u, 7501581827641382183u, 1373199u},
    {1626887622305743008u, 15287564547367834250u, 3890819873709376312u, 4204671512216675998u, 3812398u},
    {12895604820373853462u, 1053688514528488002u, 6980453937726841246u, 3096745284010766971u, 2906487u},
    {17624345181098516588u, 173979619234652759u, 10302505889617707788u, 8844641697566517329u, 2871835u},
    {17134135598088116105u, 8271579293767307318u, 13496609915126913534u, 1710300676983905895u, 622631u},
    {16106973055166375559u, 3378532068950487160u, 15054896816166712709u, 7001072138098668320u, 367689u},
    {14935704602344095258u, 17944310348560129585u, 7799352474029107207u, 11247767341799548345u, 1749981u},
    {9063280009545176180u, 13760626623033932663u, 11917844435631612605u, 16893758467763758680u, 2781977u},
    {5090670771460956495u, 15889435007703443458u, 733876276135197266u, 15255470776634499241u, 2428931u},
    {8762653282403689271u, 10285060720422461366u, 10158654004120182384u, 7250565287577963791u, 3876563u},
    {358605709679746947u, 2217748158204536979u, 2197737701956036426u, 575913131062672560u, 1386795u},
    {1995145882644615213u, 18244141751771804840u, 12838625447938673202u, 14292985472533344496u, 2665568u},
    {8111224774621744539u, 15394282877627684301u, 11350325618429984280u, 5885836182072218110u, 685668u},
    {3271040659016594166u, 1799713214203693916u, 16780220916361691291u, 9452193166969928078u, 3250972u},
    {12913950367253727680u, 8188520229210249264u, 7491201202423103587u, 2149640085026898999u, 1699047u},
    {5914736583952999318u, 37232971767127809u, 10540634688015042770u, 10551750616865322733u, 84529u},
    {9189418246204423717u, 13335031792913758344u, 10217127610096429755u, 7855837045515702235u, 2153719u},
    {5463128852052155772u, 17050258765004479449u, 5765753795481358727u, 10343965058479217555u, 691180u},
    {16856628117637794658u, 8141206485734042365u, 6736094883031500565u, 6209703118174634122u, 3508655u},
    {9384263024442540517u, 8697518035044141368u, 18444357108655996630u, 16565912301723141848u, 776345u},
    {14979701703550660994u, 11518724723452662499u, 10560122153002314699u, 7940656398265889303u, 1101748u},
    {17990435447593429974u, 1075508555581884774u, 6266618536535118004u, 15872994359674523669u, 3653615u},
    {14282397925846528995u, 14815143677809613137u, 1881853992338831962u, 6192292809945735243u, 2226798u},
    {4842169706642233140u, 948762880362484992u, 1201635871152737963u, 11210004254880971172u, 2365200u},
    {8696695952595459724u, 11630360666148950588u, 6698646825852875607u, 115687844331070022u, 1701478u},
    {16871647072514550527u, 15935462030113812414u, 14675463498460584933u, 9398873954259366704u, 3546856u},
    {4044082339588650541u, 15354349123940565184u, 12283428638941621985u, 2875674121776364623u, 3195977u},
    {16638657385300332088u, 17358667778263322370u, 7773706165886145451u, 14254301398131939545u, 217832u},
    {239995440558063773u, 5406437496230597793u, 3312224638137110617u, 1373112592129996481u, 1590748u},
    {6601672973825274792u, 2622813436485426747u, 17414561105616632647u, 966092845107941081u, 3644308u},
    {4848804218041570418u, 4201467160318351668u, 13623710202516116406u, 6768581863495163201u, 241674u},
    {13045949218890900613u, 13001570816114284211u, 12403745404735070763u, 2598531490561257241u, 100952u},
    {5908807708305987551u, 10352835401873723448u, 3984416913263401612u, 2884165999823378057u, 3377986u},
    {7586350567395040522u, 13467955683717090388u, 4584079233973645534u, 6763669091638037881u, 3751246u},
    {12676722143728128371u, 12135843727778457974u, 5522058982085385956u, 3816193171655448424u, 3343033u},
    {13395320561339589496u, 14529120281179215176u, 2267838147151380977u, 12311459064444907755u, 751141u},
    {6395110312893176201u, 14828126601976022014u, 13932855518845365228u, 12912165450890829874u, 2053985u},
    {2548557268243746556u, 6098378719274413303u, 4921953516171707103u, 11567104394606873524u, 1696591u},
    {8031163231117365783u, 8778222280069375858u, 9087135089159873327u, 12497260360103396284u, 654486u},
    {12569671371775091259u, 3753172473533087322u, 12955990650387758767u, 5272277513007825557u, 3465605u},
    {16196755346257015681u, 8599498710369769481u, 11732004488505094980u, 2585944925095323463u, 3198278u},
    {14765555690467492050u, 9565263188459668104u, 7722558066384807584u, 6544181281742034802u, 933406u},
    {13414828991410550874u, 8383062938837817511u, 8812358258303115836u, 305448684294757963u, 3460523u},
    {12931854252239880365u, 12746433275823104675u, 18107566215762086004u, 4531406212799166314u, 1258000u},
    {7001430790918502958u, 5998833740491021880u, 13504756466283525841u, 6508389471989647068u, 2304660u},
    {12463308440540529524u, 15989133970062875999u, 4002530786941312136u, 4942429874284404575u, 3209689u},
    {11779137431753754720u, 10890081865698633514u, 5556380661485988174u, 2725339295884964243u, 3074175u},
    {4099812973608845544u, 12204433442033119139u, 13356937694402061674u, 7406583114056784828u, 3141478u},
    {8330073314408319230u, 4835181063338223423u, 15648617910059072898u, 2075562681147754256u, 1722233u},
    {17640623118459204528u, 5446435171500509950u, 6567645663946930779u, 13218309302402671991u, 1138608u},
    {2510905851521339680u, 10854276042379333749u, 10128415775026933748u, 21003623594587587u, 0u},
    {13400954315941092617u, 4359414629222597179u, 10968205056921928209u, 21003623u, 0u},
    {10341945920311514726u, 10393503933766694729u, 387448469069884690u, 0u, 0u},
    {9036207120626983591u, 1289145001494033098u, 387448469u, 0u, 0u},
    {14567559861634791566u, 7147162750682733925u, 0u, 0u, 0u},
    {12594217999481771347u, 7147162750u, 0u, 0u, 0u},
    {2714673599027518317u, 7u, 0u, 0u, 0u},
    {131841882115u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2216506u},
    {757448694386359614u, 5561559341074478386u, 7640156172174381423u, 12074505523253806975u, 903662u},
    {6730086238522810126u, 17311437278346528863u, 1590566217304393085u, 3043088583310615356u, 2126679u},
    {8252611085241484692u, 5158502962549517789u, 15343607330713875341u, 3858282790293201746u, 3809054u},
    {1099082937839649733u, 5930987954812305217u, 13177118234216213202u, 8789233526748502708u, 1467287u},
    {2733727211039373778u, 17351546163482632671u, 11261525132619951835u, 5791674199595149473u, 1628008u},
    {5733282869848722944u, 6358774418435098718u, 5578487283736404194u, 7668136420737987155u, 3009801u},
    {2171506409011106236u, 14063372121769156091u, 16627444478109300459u, 14899385408241086318u, 3375115u},
    {8256576023854107993u, 11990527306770682648u, 10026214163643771037u, 9717977498606067045u, 3518494u},
    {16576144325326075896u, 4178796674621798710u, 13090793720080100321u, 15629345080253294289u, 2217063u},
    {11868389406076319877u, 6620445565125103582u, 16375508558050264611u, 905588737840771031u, 3545226u},
    {18283132349223140788u, 177268845290448886u, 12509774746771869450u, 15918068565955195676u, 1177821u},
    {16925329653006163891u, 15849428525676507721u, 13818537385160453068u, 17603779923724125607u, 8996u},
    {13400301832124141164u, 11520769330824214809u, 15688275956862186321u, 4611851982940854918u, 2978467u},
    {2697109255762658494u, 15151265741178423353u, 256549769100358179u, 15187037771057708010u, 2850664u},
    {5936459625578055238u, 10957534284580923853u, 5636975128234086767u, 14824392262210401816u, 600594u},
    {786820879062320674u, 18030332578162715637u, 12057930465257767417u, 11756466846816851344u, 894198u},
    {2205968297748499177u, 10556547929903312280u, 8352230315415923695u, 12914804386202790324u, 895140u},
    {14014555650223864994u, 5940056711638379126u, 4359640119720108478u, 16512431404944754u, 1001834u},
    {2972372991844099917u, 12310273180732504729u, 6246224308148832680u, 16159381639914710830u, 1157540u},
    {17174286360758610504u, 4368414059242394259u, 5391899735240872341u, 13207892569235275682u, 1278087u},
    {14074317120799178048u, 12629362726091856981u, 17183405418877255195u, 455922121228395404u, 1223868u},
    {7896166685991274016u, 5361728191676819195u, 13753266906343195760u, 13713519247438232722u, 3767543u},
    {799945186028149869u, 2138846854085418418u, 12216028108990346171u, 13039865842048243632u, 2552877u},
    {1433879031346515031u, 7283040103320318881u, 904681173065771624u, 12801286426423769933u, 2135282u},
    {7766307719390953155u, 17198341196042555976u, 4011902033925330548u, 4723132625845800945u, 1307998u},
    {17592469312890313824u, 5763367107374083550u, 17347792452058731667u, 8454866811515625083u, 2911673u},
    {11682199040459064876u, 9338510771508366570u, 14721214773273207589u, 8484449397549765434u, 2152301u},
    {8097493360061721633u, 12429585673335299967u, 3734245437526923088u, 7749865516259327691u, 3294720u},
    {6388981690471508255u, 7338743174841372148u, 2944012016440920880u, 8851803337011606042u, 3122106u},
    {2147392051050400835u, 16480894635170620071u, 6811079105535212963u, 6903064132807950290u, 1013495u},
    {5081562205043328529u, 17007535075857962842u, 15181821827242885240u, 12052313894122013706u, 1617404u},
    {8056958625607468019u, 14593484148964059828u, 13723244422533280251u, 14225181875175911409u, 3782153u},
    {9777549794456903437u, 5995412516948442211u, 17506341194065939524u, 13400423319680462836u, 1250989u},
    {214283937531906113u, 1084898846682550342u, 17469270676298741802u, 4995050675939476741u, 449903u},
    {10986813587473776430u, 13067563302051648870u, 6275028746108864038u, 4980273239111072408u, 703922u},
    {14696861135578444417u, 11857674057870202448u, 1913118474987312879u, 9308414704854830758u, 3402008u},
    {872968713726703908u, 4643441270104469638u, 2377336798878871504u, 15411023510299777557u, 1525981u},
    {10822041957403794263u, 17978048319484465060u, 10778669660647407196u, 15304359332420089317u, 3848002u},
    {3168101760817311800u, 11219390560347240460u, 8440502356407708564u, 5619417864313932906u, 1561295u},
    {7508034027245685135u, 16247526576875222700u, 12990854368851138580u, 893491943363115450u, 369263u},
    {11626592242701635833u, 4797679168720858366u, 9619874815574729038u, 3393518620732995145u, 3147745u},
    {14260890344058313760u, 18431988122094300892u, 5248118344372680750u, 6687364301307187605u, 449434u},
    {1475677485310590515u, 4853639693342671124u, 17121768851591386237u, 11681620834807713511u, 1796036u},
    {3800811201247641519u, 314672478916184846u, 994421322816408289u, 5941853739230880595u, 3838784u},
    {5386166189589445127u, 17480306479089402047u, 11465675956524017406u, 11672085712050502482u, 2073611u},
    {16204567996357328337u, 17794023281400610455u, 1595788328356483380u, 11279236053014272665u, 3250527u},
    {11394534775048329888u, 17548338439200731076u, 12912246716529547902u, 4095186917076883356u, 358205u},
    {6660726823484141620u, 3826734242299645768u, 248895216083966866u, 16075451190514039775u, 2461535u},
    {8421288869298632439u, 9404855277842825277u, 12011234648622660252u, 1846847173197128231u, 2946014u},
    {12883268585515705520u, 3546717344590246335u, 3534153694083135826u, 17059936561093405440u, 886890u},
    {8837747126075027244u, 674020161913232980u, 6015846277894209080u, 6429486119287055129u, 1972725u},
    {13341159109119284011u, 9256302132031514133u, 9199921232085293270u, 1045196676163285898u, 1834149u},
    {15393281196074755157u, 2859529088498624432u, 10149780114115848992u, 14229180103713050368u, 3283304u},
    {13213397187581234611u, 14129731955785327585u, 6863473289253073858u, 6401634558171025337u, 2851412u},
    {6125277114231924578u, 15911134374295055179u, 3016174169753486453u, 6249552361076141354u, 2259663u},
    {10838913889741495557u, 9812078583888945387u, 11241570578418201348u, 2059296064365365315u, 18232u},
    {422287801454940626u, 2546871497506794805u, 16794436512191714969u, 360624293286887616u, 1510221u},
    {16014976598555000131u, 14908551590250047671u, 700141613319552263u, 16889335665517503030u, 2578894u},
    {2200390054462253275u, 8403569359464365505u, 17020732063701726444u, 8045965152710561681u, 2465516u},
    {7943368719361989014u, 6624303945680565578u, 10563261215570968735u, 13808481211951837007u, 2222510u},
    {10402718325823139699u, 12903434896381493204u, 9480024678321818324u, 8471736589417309939u, 2262592u},
    {12524461245220571594u, 125137190676258381u, 4192181445143738996u, 1194658968645806207u, 2890140u},
    {4516293287213934557u, 11083972403953417154u, 2827377607552392788u, 2142983901211760036u, 309509u},
    {17997806442467226642u, 12173856229930893166u, 15179393678336761354u, 17515704786670982118u, 3397142u},
    {16514046802237560819u, 16100738714791969015u, 4922764362500749239u, 12528629995133287528u, 1307050u},
    {10467177105805230322u, 3124127439895663821u, 10569621474808919424u, 9968058806604227232u, 1319891u},
    {5885196352928213129u, 1708124822459665375u, 7308989017512372212u, 16813767112287460468u, 3818742u},
    {18224981140816634998u, 8666222297186528133u, 15580997010177340464u, 10230564132519131848u, 3768488u},
    {4471304340449823471u, 9153373292589136892u, 4969708854706237503u, 17075108536862402589u, 2366826u},
    {12839661050424537896u, 4082817561392859098u, 1392607526257613887u, 16472791691211679628u, 1770641u},
    {7339132954953725009u, 1474928445089404755u, 7278817439941422626u, 248835359959992653u, 2893069u},
    {11190144768059216720u, 17976321442816235989u, 13726999931916010170u, 1926865148665544514u, 1373209u},
    {14099332707559905831u, 4241406350393056740u, 6098498363755348713u, 14148619668343455224u, 1629080u},
    {5795759882016414215u, 16360992437354393721u, 12729148157832640186u, 6371119511321876792u, 3019509u},
    {16828070196961081867u, 2848752138780572143u, 14985274099345332308u, 14251046141594185557u, 102786u},
    {5509140776348046269u, 16625291094710120830u, 10451698920939553849u, 6631194732776776563u, 3862042u},
    {5347529854770271520u, 7287991482170563797u, 16951385246903731508u, 5619676847927563188u, 1086102u},
    {14995982592919199064u, 16418115568883575609u, 6581872458362129575u, 13927150700571712587u, 937023u},
    {5098017635942871676u, 2926680280049872760u, 13938207735271921924u, 5205431808130141637u, 2471101u},
    {17482235994856113150u, 3897619420449566860u, 15458202815338769768u, 9196898215749567426u, 2370797u},
    {10216587477924808774u, 3196463180184359929u, 10922785322972730928u, 6745089740233914647u, 1367076u},
    {7071517015595494927u, 3727591427160367428u, 4038166850196975685u, 14724967291583699243u, 1679452u},
    {15645886162337264720u, 10916865880196074660u, 8564706601805245452u, 2769169009394308513u, 1500652u},
    {12371460413341530257u, 8574448278889038275u, 8226549563942256347u, 1829121997105067795u, 3247915u},
    {5855298868162007975u, 3415918399062192547u, 8152509682448010545u, 10292091811993051267u, 2518314u},
    {4904534782620924661u, 7070880522337306573u, 14044367568395136900u, 13593282383277783575u, 988646u},
    {16855730646086526471u, 2172522420118795662u, 11893270980693716995u, 14069468150730726556u, 1976506u},
    {8049356586574908164u, 16780712125531826904u, 13965296728915330701u, 13511230199504143553u, 297607u},
    {14081741944610660443u, 13821188721510360647u, 588939342998542148u, 12759684038388019350u, 422404u},
    {8722863904235441899u, 7787698336398463482u, 15289108158340416525u, 4763593197746639023u, 2724250u},
    {10099470087165634720u, 13608821530599457478u, 13586525511941296776u, 16479384987953965851u, 221373u},
    {13653592979816487103u, 7412106172349656071u, 9663412102110150590u, 13262680930533954516u, 1772371u},
    {5859446361594697102u, 9498793407162179433u, 4448543982733604564u, 6013474792651364290u, 3357012u},
    {15987568948156275103u, 7085886493555542458u, 17356461850360950820u, 14761675130967145585u, 861665u},
    {13916614410340047709u, 538652681670716358u, 14025912237342641168u, 7077539144210885799u, 3584930u},
    {2748831805286084179u, 2019926445603288426u, 1579644127885034610u, 13324727596288442951u, 1681220u},
    {8787622350118165785u, 6547667125510137069u, 12106496145107239313u, 5147102225089213024u, 1728376u},
    {12365898805378763383u, 12878807496842274152u, 1347878514000512836u, 16461014355529813453u, 688956u},
    {8469108148305152807u, 11936571187913072017u, 6880014789456716866u, 13559536690601512961u, 2883491u},
    {8033716155737253622u, 14733132969400337108u, 5539269796602092523u, 15401458564154031887u, 1530411u},
    {3226003578919166257u, 3708908484065463815u, 13876121675274387614u, 7450163301352625880u, 957679u},
    {17770813001903699913u, 4626080348578405277u, 639827988403884087u, 6574907124319371567u, 1507587u},
    {16036739199117972322u, 8808376211903678658u, 2056482856497423941u, 10115873243442669726u, 402807u},
    {15698132035992227076u, 16361489987502519676u, 14765803987949195763u, 2313273496969665918u, 2860233u},
    {12247606169777790997u, 14824698202635316505u, 16914787113889781635u, 9420249213386083668u, 2743144u},
    {3917614316840588377u, 1413883678685826505u, 11883473198363570523u, 5310806449514320455u, 806850u},
    {2337419282639712815u, 14092379123818083631u, 4347714137187001472u, 8013276698976679897u, 3642901u},
    {4680191897145527160u, 12900525354247054396u, 4946640396798785666u, 10803781182097399762u, 2324008u},
    {11464121877361810173u, 16479153600133237395u, 13454994073587503366u, 16688174614366387985u, 2862853u},
    {11982733776161219003u, 16577740161378470084u, 6251757141427934708u, 15040789893188836913u, 739256u},
    {13467578929046027319u, 2502353460290539057u, 8822609315428260120u, 17307459450380448761u, 970647u},
    {17802264747684438196u, 13763852297494424995u, 9737377896378123140u, 17455843051280933917u, 248209u},
    {6607174585233575383u, 3172200187570442633u, 6972678548712610324u, 4111861525517526777u, 2074736u},
    {10493965051813829494u, 11429742309988764497u, 14740796018625824522u, 1191193632731220361u, 2771159u},
    {14929210623394122617u, 9512532177231032970u, 1436324474808985317u, 9418606086982382200u, 3198285u},
    {9531834853729230960u, 9687740734031721687u, 5027858585692095882u, 10723521871901724768u, 3796054u},
    {5261409703005094438u, 3396333252184754613u, 2801101789428316938u, 718543193692854734u, 1916548u},
    {6036920817728706788u, 13297168894830877937u, 7810283227550141365u, 14879218442992677903u, 3391851u},
    {3662435777491795928u, 10819525815489596387u, 6474053056337858524u, 6475694491587960563u, 3583185u},
    {8065555858391102444u, 13369198309667053808u, 5444326359803619541u, 7920375853273594475u, 3441613u},
    {12131112243201616092u, 3731032363845403821u, 6260660454444442910u, 15844099656438345588u, 3758340u},
    {8150788863384913156u, 11434327912869903836u, 12153139793643042442u, 14048502395324104796u, 3550947u},
    {8187506125805872732u, 10389973842768454437u, 9339312565629303042u, 12387352005062486162u, 2223767u},
    {5577214676682228113u, 2562540273181363399u, 9794181343302625761u, 11209948348994742953u, 524285u},
    {14862396031827050330u, 15709187654303492273u, 4865098414741827170u, 7936006706598706121u, 1940211u},
    {14751533359732014272u, 13350386878352668857u, 8285117087232960448u, 612251336005426277u, 3755162u},
    {6743231088749170965u, 5805373955343804329u, 4996633954868017000u, 357500889133282387u, 2269004u},
    {16321261990044215418u, 15028824641570297511u, 10850242993379209265u, 4221196190647544444u, 1540816u},
    {9694379244417233652u, 10219844229690866767u, 2403667948561226068u, 16673727265399226263u, 2662972u},
    {15309847491319790676u, 4056887435483518361u, 8950157589483892693u, 2282908594808947753u, 3137285u},
    {13341533455368872165u, 2994801252754266649u, 8311186325190891141u, 4309270744001944689u, 3338717u},
    {9069380862725014846u, 1128950277272511919u, 823856704661739219u, 2511546659632363901u, 704585u},
    {15908801169704029082u, 14482151299539050981u, 1064806223590796390u, 12118673100056614552u, 3282574u},
    {6424986901916109758u, 7442895375501997421u, 13705084806360806459u, 7554542594544191501u, 3295066u},
    {2672781166194101344u, 13988132299441937551u, 17511829100409708499u, 13247322955703336719u, 2603036u},
    {4949760514309968077u, 809384464849608954u, 1911873976635180419u, 6821431391719201556u, 2396844u},
    {2260497559922854974u, 17408926176201596417u, 4661519161584625285u, 332444350825749432u, 2614255u},
    {16355481876409833824u, 2051511807780050731u, 12647742822372333323u, 13378879390277528074u, 2100953u},
    {10812675841497066212u, 17109695934013882715u, 16119099276151252788u, 13153237870583656045u, 2916532u},
    {4833716851635615128u, 6702847681895353399u, 10650629052886120600u, 4881659333081193848u, 1492096u},
    {6283619640442853785u, 3402146740594691126u, 3859445957348309972u, 12277315304374814180u, 602225u},
    {10556067362026735135u, 11273071899191406983u, 1784902902147885955u, 3037528052320078351u, 3112976u},
    {7712358934197492742u, 3172917966338314347u, 8696672614406939676u, 15621864586809562293u, 1282386u},
    {13678430946475559576u, 5053839350716983380u, 16015427592828498994u, 12273446848415321803u, 3637888u},
    {14857680996802794217u, 10042916055515431422u, 13365566501442979575u, 11236034277057096021u, 1910379u},
    {17480850100733518712u, 8186689656358553464u, 10398770635779843268u, 9042439538473815456u, 2491657u},
    {417766381997202110u, 13323027287209343359u, 13368044945019834012u, 13160445082943790810u, 615534u},
    {11919411184011182961u, 12758514865113680652u, 1626887622305743007u, 15287564547367834250u, 2433068u},
    {14632748628932637076u, 9670115574291549699u, 12895604820373853461u, 1053688514528488002u, 1618954u},
    {18027530226265228322u, 4410648190753643924u, 17624345181098516587u, 173979619234652759u, 3090712u},
    {6086089501571911625u, 14968090340179617461u, 17134135598088116104u, 8271579293767307318u, 3463090u},
    {7262209638031159082u, 17612970293585854291u, 16106973055166375558u, 3378532068950487160u, 106763u},
    {7763803432137325100u, 1684243940325100875u, 14935704602344095257u, 17944310348560129585u, 3777563u},
    {12319923578271668528u, 13329918781378650720u, 9063280009545176179u, 13760626623033932663u, 1992997u},
    {13653959445054708908u, 9946174863061808092u, 5090670771460956494u, 15889435007703443458u, 2866758u},
    {9034632565205097490u, 3443348026341994507u, 8762653282403689270u, 10285060720422461366u, 3036868u},
    {7755259344776663532u, 2481392079823797432u, 358605709679746946u, 2217748158204536979u, 735656u},
    {16447363619949472915u, 513375583277363662u, 1995145882644615212u, 18244141751771804840u, 2494496u},
    {15041728039011382566u, 9359561176024368332u, 8111224774621744538u, 15394282877627684301u, 3812648u},
    {90437096324472782u, 11168035959925678495u, 3271040659016594165u, 1799713214203693916u, 2494321u},
    {10100781217761734966u, 4628358141549010335u, 12913950367253727679u, 8188520229210249264u, 2018403u},
    {6651583638150021702u, 10978820857488385243u, 5914736583952999317u, 37232971767127809u, 237272u},
    {17459310733363010322u, 10626739333578767594u, 9189418246204423716u, 13335031792913758344u, 2421379u},
    {5410155160898135803u, 16790695825473384680u, 5463128852052155771u, 17050258765004479449u, 3835687u},
    {14297110482937117236u, 441349934862731063u, 16856628117637794657u, 8141206485734042365u, 2743397u},
    {17910458997683460634u, 17335558862966400572u, 9384263024442540516u, 8697518035044141368u, 3337568u},
    {17673146010666881236u, 7603198432906168378u, 14979701703550660993u, 11518724723452662499u, 3615935u},
    {3310625555133032803u, 16783968165758953390u, 17990435447593429973u, 1075508555581884774u, 2349298u},
    {11441735239425783246u, 17489037929824594823u, 14282397925846528994u, 14815143677809613137u, 651288u},
    {2115041835000393280u, 8162014911550055895u, 4842169706642233139u, 948762880362484992u, 1576865u},
    {15430293949643237592u, 4595926069236773133u, 8696695952595459723u, 11630360666148950588u, 581877u},
    {5428091352407100512u, 10927719170514128907u, 16871647072514550526u, 15935462030113812414u, 329683u},
    {6197841764585644807u, 858880378106147746u, 4044082339588650540u, 15354349123940565184u, 3515265u},
    {8509957682125074472u, 12784769144258952715u, 16638657385300332087u, 17358667778263322370u, 114813u},
    {13109261233671380389u, 2299935175507696506u, 239995440558063772u, 5406437496230597793u, 1558001u},
    {3666282318085130333u, 8188633584952804171u, 6601672973825274791u, 2622813436485426747u, 1199491u},
    {10205956218117550734u, 6203950664900612988u, 4848804218041570417u, 4201467160318351668u, 1691566u},
    {12848168399378079440u, 16732045449732648693u, 13045949218890900612u, 13001570816114284211u, 2634581u},
    {15178266536954416272u, 14668768336519406970u, 5908807708305987550u, 10352835401873723448u, 3536840u},
    {15094909779545861236u, 14342685866654464619u, 7586350567395040521u, 13467955683717090388u, 1635406u},
    {6673612523556045326u, 11859756087808692389u, 12676722143728128370u, 12135843727778457974u, 2468938u},
    {4416388519364974108u, 11504645507455058769u, 13395320561339589495u, 14529120281179215176u, 3053103u},
    {2352056405626094073u, 14444942087295761496u, 6395110312893176200u, 14828126601976022014u, 2468772u},
    {5769713436571941500u, 2049485964935147786u, 2548557268243746555u, 6098378719274413303u, 3212133u},
    {18177366312664372618u, 3838580227782839577u, 8031163231117365782u, 8778222280069375858u, 334887u},
    {16042677501589757917u, 5580468106138838294u, 12569671371775091258u, 3753172473533087322u, 1336009u},
    {2742000018850960790u, 18233180847379879162u, 16196755346257015680u, 8599498710369769481u, 2908956u},
    {6280912597105064149u, 6866743536125861821u, 14765555690467492049u, 9565263188459668104u, 1321752u},
    {16618233097158518909u, 9458365577645107164u, 13414828991410550873u, 8383062938837817511u, 3485532u},
    {15190794517834932296u, 15981396523614178512u, 12931854252239880364u, 12746433275823104675u, 978678u},
    {6848077494116217682u, 3221176590451590898u, 7001430790918502957u, 5998833740491021880u, 3491439u},
    {17071982658909649573u, 14786655875020161521u, 12463308440540529523u, 15989133970062875999u, 508770u},
    {7855788610885996717u, 3340023335066818409u, 11779137431753754719u, 10890081865698633514u, 1447412u},
    {7029239732148900382u, 1552574184353763594u, 4099812973608845543u, 12204433442033119139u, 396940u},
    {15226047822590788223u, 1146812073649417072u, 8330073314408319229u, 4835181063338223423u, 2283092u},
    {14446188666641432882u, 3625204856611671784u, 17640623118459204527u, 5446435171500509950u, 2473983u},
    {10496370496633311227u, 7163479008832454321u, 2510905851521339679u, 10854276042379333749u, 1949340u},
    {10140964176611799504u, 8250621788793968623u, 13400954315941092616u, 4359414629222597179u, 932977u},
    {31176760066220322u, 11753682267331666267u, 10341945920311514725u, 10393503933766694729u, 3478440u},
    {17963246260045830459u, 13081608718998386964u, 9036207120626983590u, 1289145001494033098u, 729719u},
    {13486328205703058191u, 3059038746048492252u, 14567559861634791565u, 7147162750682733925u, 0u},
    {7420315194700892382u, 7684256234441371309u, 12594217999481771346u, 7147162750u, 0u},
    {18163225833518063804u, 10316809182081615217u, 2714673599027518316u, 7u, 0u},
    {857664136164642518u, 18343066520143317698u, 131841882114u, 0u, 0u},
    {11317334305649468237u, 15529983915534635656u, 131u, 0u, 0u},
    {8963224109754498253u, 2432053457571u, 0u, 0u, 0u},
    {986118140002381699u, 2432u, 0u, 0u, 0u},
    {44863467705402u, 0u, 0u, 0u, 0u},
    {44864u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 711486u},
    {8159427590630727611u, 12838631643846944267u, 757448694386359613u, 5561559341074478386u, 954895u},
    {2760459538635063512u, 14905126187741272544u, 6730086238522810125u, 17311437278346528863u, 2299255u},
    {2511183902861343198u, 5282557461612856023u, 8252611085241484691u, 5158502962549517789u, 1207001u},
    {4367125710390453034u, 8167944734353277878u, 1099082937839649732u, 5930987954812305217u, 3129202u},
    {15845748256849706942u, 1323895455369873868u, 2733727211039373777u, 17351546163482632671u, 959851u},
    {11216818934517112697u, 3985846451062287858u, 5733282869848722943u, 6358774418435098718u, 658180u},
    {2962850263246680267u, 13673857699745269315u, 2171506409011106235u, 14063372121769156091u, 1570287u},
    {8254820632479397647u, 14739080662595589422u, 8256576023854107992u, 11990527306770682648u, 3876771u},
    {5276853444993798369u, 1109677481296716990u, 16576144325326075895u, 4178796674621798710u, 3426323u},
    {3873751291323231680u, 7634139712364186313u, 11868389406076319876u, 6620445565125103582u, 1797263u},
    {6326218078383007186u, 16193535462143418019u, 18283132349223140787u, 177268845290448886u, 3730492u},
    {15584596319451487660u, 6285855618545334876u, 16925329653006163890u, 15849428525676507721u, 3448406u},
    {8817113283385034201u, 12402302437735538397u, 13400301832124141163u, 11520769330824214809u, 1039261u},
    {17335688662633466542u, 18210561622639227504u, 2697109255762658493u, 15151265741178423353u, 259123u},
    {12565633720843274996u, 8726417304675180247u, 5936459625578055237u, 10957534284580923853u, 863787u},
    {17615724888135692499u, 5830933851542087078u, 786820879062320673u, 18030332578162715637u, 1959109u},
    {13251251495062920642u, 4085820429751202540u, 2205968297748499176u, 10556547929903312280u, 1698619u},
    {14001839877857282428u, 6462317252480445783u, 14014555650223864993u, 5940056711638379126u, 3278746u},
    {16852951726976103517u, 17272549513598058931u, 2972372991844099916u, 12310273180732504729u, 2437200u},
    {5228357203229820011u, 18340770866692573023u, 17174286360758610503u, 4368414059242394259u, 1045375u},
    {10364911444427899352u, 18299152559713543824u, 14074317120799178047u, 12629362726091856981u, 1597367u},
    {5774512401949060226u, 13603472022223024079u, 7896166685991274015u, 5361728191676819195u, 2665870u},
    {11046643781209418528u, 7702435326803004611u, 799945186028149868u, 2138846854085418418u, 283145u},
    {10100068815461814988u, 14553051016471701292u, 1433879031346515030u, 7283040103320318881u, 2636444u},
    {4637001085715618696u, 8841140572337865210u, 7766307719390953154u, 17198341196042555976u, 3839006u},
    {703641944637079520u, 5922568956733422156u, 17592469312890313823u, 5763367107374083550u, 2335433u},
    {13975306658929859417u, 12860167393372085808u, 11682199040459064875u, 9338510771508366570u, 1934189u},
    {12219143063310160667u, 16063630968398444939u, 8097493360061721632u, 12429585673335299967u, 3302814u},
    {11955584744432270009u, 796078258575674638u, 6388981690471508254u, 7338743174841372148u, 2806088u},
    {4334089058491621891u, 12736435464989562745u, 2147392051050400834u, 16480894635170620071u, 105323u},
    {6815874061346089699u, 8958953800601000093u, 5081562205043328528u, 17007535075857962842u, 2051860u},
    {6268311611855443123u, 7572192177859780469u, 8056958625607468018u, 14593484148964059828u, 793213u},
    {16911273498708337581u, 14742604556461068709u, 9777549794456903436u, 5995412516948442211u, 218734u},
    {15103901960272247172u, 16955935712469483889u, 214283937531906112u, 1084898846682550342u, 1362776u},
    {3077620282503441642u, 15394188687264237901u, 10986813587473776429u, 13067563302051648870u, 2180798u},
    {6676298984665186446u, 12058124479422404180u, 14696861135578444416u, 11857674057870202448u, 1721455u},
    {10175379064171683112u, 4722161071985764863u, 872968713726703907u, 4643441270104469638u, 1935702u},
    {17500693498458979103u, 11885994025982337259u, 10822041957403794262u, 17978048319484465060u, 2735630u},
    {13897343338127040849u, 17113201323284459738u, 3168101760817311799u, 11219390560347240460u, 1873930u},
    {2779702283900213452u, 15580807000070849488u, 7508034027245685134u, 16247526576875222700u, 2270208u},
    {1320410564878202505u, 3388135303650535470u, 11626592242701635832u, 4797679168720858366u, 3106328u},
    {7000295253082113931u, 17704241525055657143u, 14260890344058313759u, 18431988122094300892u, 1397584u},
    {3796408245663025923u, 7501876426376300282u, 1475677485310590514u, 4853639693342671124u, 1433429u},
    {7055286254020436798u, 12552816064676821972u, 3800811201247641518u, 314672478916184846u, 2296813u},
    {2608577772137944592u, 6281898179558250348u, 5386166189589445126u, 17480306479089402047u, 3678434u},
    {6644688034808880815u, 12007778601813221510u, 16204567996357328336u, 17794023281400610455u, 2078582u},
    {16110988531926893091u, 10951998136839755371u, 11394534775048329887u, 17548338439200731076u, 416428u},
    {10263121067133204362u, 3057508568051223389u, 6660726823484141619u, 3826734242299645768u, 2025726u},
    {10621827038703215246u, 5829535693352855600u, 8421288869298632438u, 9404855277842825277u, 861682u},
    {12263391633901169622u, 10762920000030169539u, 12883268585515705519u, 3546717344590246335u, 1382456u},
    {7118683017949021119u, 16411124016546895249u, 8837747126075027243u, 674020161913232980u, 1785144u},
    {14458665759524364113u, 16416358691654383972u, 13341159109119284010u, 9256302132031514133u, 2671632u},
    {8609428474282932104u, 7837821057227465950u, 15393281196074755156u, 2859529088498624432u, 349304u},
    {6790530987829019173u, 16820919853618547671u, 13213397187581234610u, 14129731955785327585u, 3169322u},
    {7555190604888614733u, 1393002243091770049u, 6125277114231924577u, 15911134374295055179u, 663845u},
    {6744355152349703775u, 11705421316779341507u, 10838913889741495556u, 9812078583888945387u, 1347430u},
    {10314879817732300781u, 14485287865350607077u, 422287801454940625u, 2546871497506794805u, 3506701u},
    {8349167065798736914u, 3764282473580402254u, 16014976598555000130u, 14908551590250047671u, 2433407u},
    {611472348863097956u, 13366456489253158721u, 2200390054462253274u, 8403569359464365505u, 3635486u},
    {12610235588552791017u, 17395039313799283227u, 7943368719361989013u, 6624303945680565578u, 277857u},
    {3251859849708226231u, 17642334210610959677u, 10402718325823139698u, 12903434896381493204u, 2877450u},
    {6496055405773352215u, 4951559215953916318u, 12524461245220571593u, 125137190676258381u, 3207098u},
    {17537488385080000570u, 13222256797829977927u, 4516293287213934556u, 11083972403953417154u, 3696068u},
    {15093671581102623478u, 6207521756672721559u, 17997806442467226641u, 12173856229930893166u, 1729044u},
    {10728341089466046883u, 2483133953290619334u, 16514046802237560818u, 16100738714791969015u, 1390537u},
    {3314920761865326708u, 1957770106497917216u, 10467177105805230321u, 3124127439895663821u, 2753882u},
    {8774407804206124019u, 1648903707713720150u, 5885196352928213128u, 1708124822459665375u, 1046852u},
    {10593492709190075596u, 5125347414724941250u, 18224981140816634997u, 8666222297186528133u, 111610u},
    {2760750981178749167u, 1786605630125511173u, 4471304340449823470u, 9153373292589136892u, 2579983u},
    {8307199977607155899u, 13106894786384532506u, 12839661050424537895u, 4082817561392859098u, 1831031u},
    {12819072089797444092u, 4818868774477000074u, 7339132954953725008u, 1474928445089404755u, 1842088u},
    {17090043798216236896u, 8238670380771674928u, 11190144768059216719u, 17976321442816235989u, 3364598u},
    {45907027113735158u, 15125585472068991125u, 14099332707559905830u, 4241406350393056740u, 212427u},
    {10150956177130254140u, 8514304703187275982u, 5795759882016414214u, 16360992437354393721u, 2087412u},
    {5465377990731624814u, 4870110559847474079u, 16828070196961081866u, 2848752138780572143u, 2821336u},
    {17323130743105648293u, 1249585584369688116u, 5509140776348046268u, 16625291094710120830u, 551559u},
    {16980053578547788303u, 14245820044749361198u, 5347529854770271519u, 7287991482170563797u, 3309078u},
    {9476354797238866541u, 3525450227315839876u, 14995982592919199063u, 16418115568883575609u, 2405655u},
    {1659824538212078297u, 16113542462077916297u, 5098017635942871675u, 2926680280049872760u, 352872u},
    {17778399518985739105u, 13063125786772664989u, 17482235994856113149u, 3897619420449566860u, 1405616u},
    {1719898231711309618u, 3377521468867955476u, 10216587477924808773u, 3196463180184359929u, 2854386u},
    {15742287660923231335u, 9176333820521773826u, 7071517015595494926u, 3727591427160367428u, 1960735u},
    {10825803263389742588u, 6933000948261334383u, 15645886162337264719u, 10916865880196074660u, 3884272u},
    {3070404465346029980u, 8218675864750592951u, 12371460413341530256u, 8574448278889038275u, 1583557u},
    {11507376299318146888u, 12585506020181988023u, 5855298868162007974u, 3415918399062192547u, 500701u},
    {12236325520417360027u, 11681300752802688222u, 4904534782620924660u, 7070880522337306573u, 585176u},
    {7398412894596828430u, 8992287545702404457u, 16855730646086526470u, 2172522420118795662u, 3434227u},
    {16758410275427019563u, 10262306949858298351u, 8049356586574908163u, 16780712125531826904u, 3154391u},
    {7321112795755469216u, 798528626023381828u, 14081741944610660442u, 13821188721510360647u, 296972u},
    {10191439538076831407u, 13370702336477362453u, 8722863904235441898u, 7787698336398463482u, 3360693u},
    {10983492869923015059u, 12326627554950067178u, 10099470087165634719u, 13608821530599457478u, 3373580u},
    {8898316989894532768u, 3828652126612534392u, 13653592979816487102u, 7412106172349656071u, 3211872u},
    {12658928932215428624u, 16682377017089820902u, 5859446361594697101u, 9498793407162179433u, 1314176u},
    {9457355384391584005u, 7751526358613187676u, 15987568948156275102u, 7085886493555542458u, 1856670u},
    {6760135439916467465u, 2781745955636834605u, 13916614410340047708u, 538652681670716358u, 125432u},
    {6070806012351311074u, 6196837392064718145u, 2748831805286084178u, 2019926445603288426u, 3387246u},
    {12377441815872582650u, 921798011553040442u, 8787622350118165784u, 6547667125510137069u, 2849053u},
    {2805700680755940402u, 17745222809223472991u, 12365898805378763382u, 12878807496842274152u, 2551570u},
    {13509110269964681309u, 6459661193247651019u, 8469108148305152806u, 11936571187913072017u, 1809738u},
    {14456593716939967865u, 17632150729949922419u, 8033716155737253621u, 14733132969400337108u, 1841581u},
    {984351094987442521u, 5253117788963813428u, 3226003578919166256u, 3708908484065463815u, 780318u},
    {17556295609914694243u, 16027717455922892051u, 17770813001903699912u, 4626080348578405277u, 940531u},
    {5762595572661155063u, 10900193632968661628u, 16036739199117972321u, 8808376211903678658u, 239399u},
    {17498174056187352434u, 5551337217873434386u, 15698132035992227075u, 16361489987502519676u, 2867249u},
    {7633058804890195730u, 12891101918729678334u, 12247606169777790996u, 14824698202635316505u, 2428037u},
    {14150023342146449662u, 7581703101675404347u, 3917614316840588376u, 1413883678685826505u, 2230653u},
    {9619282178187041945u, 17486244696187944585u, 2337419282639712814u, 14092379123818083631u, 120130u},
    {8707328531529449865u, 5185744837671218367u, 4680191897145527159u, 12900525354247054396u, 2711706u},
    {11087940583887024526u, 12575791648125192293u, 11464121877361810172u, 16479153600133237395u, 243594u},
    {12802327964535734464u, 18393310435744696933u, 11982733776161219002u, 16577740161378470084u, 2840352u},
    {3670272330074596366u, 15062638310808594696u, 13467578929046027318u, 2502353460290539057u, 46178u},
    {7655197060666546164u, 16973007842388342507u, 17802264747684438195u, 13763852297494424995u, 90316u},
    {1128451592653619064u, 12236467123090501364u, 6607174585233575382u, 3172200187570442633u, 2420072u},
    {3709102253507276758u, 6433581328541437359u, 10493965051813829493u, 11429742309988764497u, 50402u},
    {15652244438062408387u, 16554328705899422293u, 14929210623394122616u, 9512532177231032970u, 1735977u},
    {15601028725291862636u, 473244742511433306u, 9531834853729230959u, 9687740734031721687u, 521844u},
    {11286816469719145513u, 9986551009846693225u, 5261409703005094437u, 3396333252184754613u, 2090970u},
    {9928942761255273709u, 6103130466579016775u, 6036920817728706787u, 13297168894830877937u, 590169u},
    {1243315411990657926u, 3921391207758228409u, 3662435777491795927u, 10819525815489596387u, 2089442u},
    {9358954592468932371u, 6575431783085543920u, 8065555858391102443u, 13369198309667053808u, 3040919u},
    {9831333934436946216u, 11603449085781366100u, 12131112243201616091u, 3731032363845403821u, 2668658u},
    {5836662359891885695u, 3919691013750761366u, 8150788863384913155u, 11434327912869903836u, 741610u},
    {8172232699014060636u, 5187156018473047539u, 8187506125805872731u, 10389973842768454437u, 2196836u},
    {2476625980839613695u, 18146913264820058828u, 5577214676682228112u, 2562540273181363399u, 34269u},
    {12979494156910397063u, 6720454362281163548u, 14862396031827050329u, 15709187654303492273u, 1069672u},
    {2601264160545760721u, 15906183389903602458u, 14751533359732014271u, 13350386878352668857u, 2209952u},
    {14611318778769644635u, 10567167460087980648u, 6743231088749170964u, 5805373955343804329u, 2214216u},
    {7769418720616191797u, 1405183027778257694u, 16321261990044215417u, 15028824641570297511u, 3237615u},
    {2047415606385255702u, 9373909146690427435u, 9694379244417233651u, 10219844229690866767u, 1174308u},
    {13946036824070252586u, 4450305996991278271u, 15309847491319790675u, 4056887435483518361u, 2192251u},
    {4732910342133565165u, 1210835191203772626u, 13341533455368872164u, 2994801252754266649u, 2606767u},
    {18193799113970287761u, 6165818673825030705u, 9069380862725014845u, 1128950277272511919u, 3828995u},
    {9174189512019947179u, 1008901673916926782u, 15908801169704029081u, 14482151299539050981u, 1136416u},
    {570571638432081226u, 3116504971898152962u, 6424986901916109757u, 7442895375501997421u, 485671u},
    {336440315169624790u, 4437162648687867894u, 2672781166194101343u, 13988132299441937551u, 908069u},
    {16362820229085971198u, 12652109369384408671u, 4949760514309968076u, 809384464849608954u, 2333529u},
    {835388399623147470u, 5523803074465353109u, 2260497559922854973u, 17408926176201596417u, 1837677u},
    {8748833623124426283u, 16765186057798588440u, 16355481876409833823u, 2051511807780050731u, 1737225u},
    {12558992441668026749u, 5525071384467217697u, 10812675841497066211u, 17109695934013882715u, 80850u},
    {14984093083279345486u, 4722389565271552808u, 4833716851635615127u, 6702847681895353399u, 836994u},
    {2871449859862192413u, 3072511372563739091u, 6283619640442853784u, 3402146740594691126u, 1739452u},
    {17586507523225017848u, 16059283669775170009u, 10556067362026735134u, 11273071899191406983u, 129227u},
    {7486706893843503821u, 14570975689151485059u, 7712358934197492741u, 3172917966338314347u, 531680u},
    {10835783995142450890u, 9117369183218496939u, 13678430946475559575u, 5053839350716983380u, 1458820u},
    {10045435314688778507u, 11731088382462284949u, 14857680996802794216u, 10042916055515431422u, 2395085u},
    {4110388324231904449u, 17619701433474372654u, 17480850100733518711u, 8186689656358553464u, 3492756u},
    {18235060126409052615u, 13084815543747667946u, 417766381997202109u, 13323027287209343359u, 234226u},
    {1957666082613267668u, 14222685201631756840u, 11919411184011182960u, 12758514865113680652u, 780515u},
    {18380168890861484389u, 16792005326537635041u, 14632748628932637075u, 9670115574291549699u, 820467u},
    {12964231871722930828u, 2786760914967936325u, 18027530226265228321u, 4410648190753643924u, 2828053u},
    {3746863801926352690u, 2597018835118648036u, 6086089501571911624u, 14968090340179617461u, 1676032u},
    {1715073268853110357u, 4967730170165936947u, 7262209638031159081u, 17612970293585854291u, 1459296u},
    {15985962343283546350u, 15783740984539318566u, 7763803432137325099u, 1684243940325100875u, 3866345u},
    {13754587286193060667u, 16204310268846705261u, 12319923578271668527u, 13329918781378650720u, 120719u},
    {8943635237958717956u, 4906629383866017633u, 13653959445054708907u, 9946174863061808092u, 3070520u},
    {2265061269953821367u, 4705076336109242561u, 9034632565205097489u, 3443348026341994507u, 1704034u},
    {3346782467828248017u, 13840302561561116042u, 7755259344776663531u, 2481392079823797432u, 486396u},
    {12742567091483391715u, 16385619625054943279u, 16447363619949472914u, 513375583277363662u, 3476578u},
    {17216974608179074384u, 10856430467005630814u, 15041728039011382565u, 9359561176024368332u, 3857942u},
    {17573056079558273223u, 11108456427605607717u, 90437096324472781u, 11168035959925678495u, 903797u},
    {14681332802130646725u, 10283490436552208260u, 10100781217761734965u, 4628358141549010335u, 1413071u},
    {16851526403081253125u, 9076309087806175659u, 6651583638150021701u, 10978820857488385243u, 1857943u},
    {14633271027210175676u, 11961226677964380099u, 17459310733363010321u, 10626739333578767594u, 69194u},
    {226738593690385677u, 11024303489050785377u, 5410155160898135802u, 16790695825473384680u, 488127u},
    {12813500998986025760u, 6182640158878850301u, 14297110482937117235u, 441349934862731063u, 2262529u},
    {15242245305603619415u, 10320902900471580839u, 17910458997683460633u, 17335558862966400572u, 2013962u},
    {4529054784375399033u, 17150558837713961880u, 17673146010666881235u, 7603198432906168378u, 3610737u},
    {13344196840837673864u, 3189131332091018674u, 3310625555133032802u, 16783968165758953390u, 2770145u},
    {4158863954432901021u, 11067901861834812566u, 11441735239425783245u, 17489037929824594823u, 1057464u},
    {2254828874678107469u, 10879424752450905703u, 2115041835000393279u, 8162014911550055895u, 3051901u},
    {2251295675647914430u, 9200266670678396030u, 15430293949643237591u, 4595926069236773133u, 2549093u},
    {12352088551657933685u, 4312478492139768266u, 5428091352407100511u, 10927719170514128907u, 3591248u},
    {3341384979046051957u, 1036731204936435926u, 6197841764585644806u, 858880378106147746u, 1657474u},
    {3123131579657490876u, 14933091015680002090u, 8509957682125074471u, 12784769144258952715u, 3585985u},
    {12009989330251224558u, 5145831264477641929u, 13109261233671380388u, 2299935175507696506u, 2500466u},
    {2529624328951365259u, 10473555480475613556u, 3666282318085130332u, 8188633584952804171u, 379339u},
    {12747969072094266829u, 16882981344146107561u, 10205956218117550733u, 6203950664900612988u, 796001u},
    {14978046240760960125u, 4256158192088718096u, 12848168399378079439u, 16732045449732648693u, 2226774u},
    {11308703272685202380u, 13894830509404784826u, 15178266536954416271u, 14668768336519406970u, 174808u},
    {11807780261971464658u, 7153282839569754051u, 15094909779545861235u, 14342685866654464619u, 2293665u},
    {15861228421428881149u, 5559143617964100443u, 6673612523556045325u, 11859756087808692389u, 2574332u},
    {2757594545621288365u, 6490364071025062522u, 4416388519364974107u, 11504645507455058769u, 1811879u},
    {2501723121225394787u, 9012721939705863605u, 2352056405626094072u, 14444942087295761496u, 1727856u},
    {863549443519392396u, 15439739298249211419u, 5769713436571941499u, 2049485964935147786u, 1058601u},
    {14140881368821682805u, 13698491862170075371u, 18177366312664372617u, 3838580227782839577u, 1736532u},
    {3661406199022026454u, 6817725533519682582u, 16042677501589757916u, 5580468106138838294u, 141464u},
    {3336843455751398608u, 13384083204819258648u, 2742000018850960789u, 18233180847379879162u, 1153162u},
    {16806841367827491235u, 7227627165279288013u, 6280912597105064148u, 6866743536125861821u, 1020275u},
    {12664408453217328056u, 9806054588013983513u, 16618233097158518908u, 9458365577645107164u, 3071991u},
    {7199866806977040348u, 10087137665072299472u, 15190794517834932295u, 15981396523614178512u, 2745332u},
    {10060358671668260125u, 552130964250120077u, 6848077494116217681u, 3221176590451590898u, 804971u},
    {14033841599880110188u, 9351699118398676481u, 17071982658909649572u, 14786655875020161521u, 1375527u},
    {514029624140946556u, 5822803689524554366u, 7855788610885996716u, 3340023335066818409u, 2133965u},
    {13109244457585089329u, 6091090918194401810u, 7029239732148900381u, 1552574184353763594u, 3575057u},
    {6510509786224805637u, 12854083768025562802u, 15226047822590788222u, 1146812073649417072u, 1210249u},
    {5343606528455067688u, 11672898925228477923u, 14446188666641432881u, 3625204856611671784u, 1614225u},
    {15824847893876490028u, 10658481237096288046u, 10496370496633311226u, 7163479008832454321u, 1954603u},
    {17238314966950699039u, 14048596284065821558u, 10140964176611799503u, 8250621788793968623u, 449642u},
    {7898835434960647644u, 4616169015561009304u, 31176760066220321u, 11753682267331666267u, 2124179u},
    {14492964437196807279u, 7953358297776468350u, 17963246260045830458u, 13081608718998386964u, 1768322u},
    {9067101823986371234u, 17776409951697202920u, 13486328205703058190u, 3059038746048492252u, 2501865u},
    {12431775725860554040u, 15264733533352602870u, 7420315194700892381u, 7684256234441371309u, 681596u},
    {13071703869573310596u, 2092626351549199706u, 18163225833518063803u, 10316809182081615217u, 2192128u},
    {9739216690523229137u, 8729420676746861923u, 857664136164642517u, 18343066520143317698u, 2038364u},
    {782323234618514023u, 17676416701443831987u, 11317334305649468236u, 15529983915534635656u, 131u},
    {1563654403091377874u, 17915276202256919438u, 8963224109754498252u, 2432053457571u, 0u},
    {12632847700624246608u, 11897836129447755047u, 986118140002381698u, 2432u, 0u},
    {7429241850005841035u, 11656715448122412305u, 44863467705401u, 0u, 0u},
    {3945580018759825506u, 8627641845795414844u, 44863u, 0u, 0u},
    {7555112184934606424u, 827584907020677u, 0u, 0u, 0u},
    {16731578305736887594u, 827584u, 0u, 0u, 0u},
    {15266246979075152u, 0u, 0u, 0u, 0u},
    {15266247u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 671116u},
    {2890824976687550536u, 18437611016931681722u, 8159427590630727610u, 12838631643846944267u, 3321009u},
    {76633274902748420u, 1877734422283051405u, 2760459538635063511u, 14905126187741272544u, 1211763u},
    {10057070661541096382u, 6368766856652062851u, 2511183902861343197u, 5282557461612856023u, 1378921u},
    {5871301785266442734u, 4896602277354327920u, 4367125710390453033u, 8167944734353277878u, 1456016u},
    {4636256201961155274u, 14641608316387269761u, 15845748256849706941u, 1323895455369873868u, 1229419u},
    {18132331297546332349u, 6738626855105424311u, 11216818934517112696u, 3985846451062287858u, 2980061u},
    {15255622483896334259u, 15088883994580591738u, 2962850263246680266u, 13673857699745269315u, 2132163u},
    {12255062749118244467u, 1896373894590116051u, 8254820632479397646u, 14739080662595589422u, 1561986u},
    {13451400378449205993u, 16072928762083843634u, 5276853444993798368u, 1109677481296716990u, 3691293u},
    {3609258414981045205u, 5773956644151624822u, 3873751291323231679u, 7634139712364186313u, 2853316u},
    {5383367744534934307u, 5095942257332088960u, 6326218078383007185u, 16193535462143418019u, 913165u},
    {10141123828068754708u, 6312367526284894071u, 15584596319451487659u, 6285855618545334876u, 455162u},
    {7207320432757666952u, 11827741423397057795u, 8817113283385034200u, 12402302437735538397u, 2821523u},
    {1023086593961812681u, 16572577761611053995u, 17335688662633466541u, 18210561622639227504u, 403779u},
    {11164966726969987897u, 13683891228475084577u, 12565633720843274995u, 8726417304675180247u, 3595557u},
    {11157313957758937033u, 5008385827513829285u, 17615724888135692498u, 5830933851542087078u, 2742769u},
    {2199232737774894245u, 16791558500288382275u, 13251251495062920641u, 4085820429751202540u, 2666670u},
    {5503820204219516911u, 13034410368140435875u, 14001839877857282427u, 6462317252480445783u, 2753035u},
    {5253952123069936786u, 11272560251483298129u, 16852951726976103516u, 17272549513598058931u, 2067680u},
    {7867440448068636672u, 7263001359026529371u, 5228357203229820010u, 18340770866692573023u, 3717797u},
    {15449648648212653741u, 2655549196395892243u, 10364911444427899351u, 18299152559713543824u, 3070695u},
    {16884746167574476596u, 16801310276956391829u, 5774512401949060225u, 13603472022223024079u, 3487355u},
    {8458653663534410091u, 12406556396561598994u, 11046643781209418527u, 7702435326803004611u, 3766226u},
    {10552694930450213578u, 10311821427014057275u, 10100068815461814987u, 14553051016471701292u, 2716690u},
    {9163635199757070076u, 15681641692529825165u, 4637001085715618695u, 8841140572337865210u, 750606u},
    {9215016058334646129u, 10873256055165932617u, 703641944637079519u, 5922568956733422156u, 1838571u},
    {2324586257019916296u, 17375965765315492665u, 13975306658929859416u, 12860167393372085808u, 3623679u},
    {10481250961219830184u, 140043418738943580u, 12219143063310160666u, 16063630968398444939u, 186738u},
    {2085852093599296555u, 17256977374671313927u, 11955584744432270008u, 796078258575674638u, 2943550u},
    {12383678988100343258u, 17463418557172458069u, 4334089058491621890u, 12736435464989562745u, 1290858u},
    {1303148056037769590u, 4490621124446206949u, 6815874061346089698u, 8958953800601000093u, 333110u},
    {618166720581660364u, 8642265402760033399u, 6268311611855443122u, 7572192177859780469u, 2323194u},
    {8392922474790445841u, 5256242750653734867u, 16911273498708337580u, 14742604556461068709u, 1214366u},
    {14031670600902639114u, 2569598619519532087u, 15103901960272247171u, 16955935712469483889u, 2489390u},
    {11979615319749618980u, 5803597209514068587u, 3077620282503441641u, 15394188687264237901u, 1328487u},
    {711539833221132130u, 1825982862360240620u, 6676298984665186445u, 12058124479422404180u, 2082614u},
    {9776072719420014574u, 2260967782752260251u, 10175379064171683111u, 4722161071985764863u, 3716027u},
    {2480576979876137122u, 4087005850848901195u, 17500693498458979102u, 11885994025982337259u, 1927252u},
    {8310459701472247113u, 1926551354940277132u, 13897343338127040848u, 17113201323284459738u, 887239u},
    {11554674734040629321u, 1399876186015540530u, 2779702283900213451u, 15580807000070849488u, 77432u},
    {12053562761794158519u, 13887576877843838750u, 1320410564878202504u, 3388135303650535470u, 2717606u},
    {14275501936679093321u, 17415872882609810446u, 7000295253082113930u, 17704241525055657143u, 427535u},
    {12345352403042231576u, 2297504692479880495u, 3796408245663025922u, 7501876426376300282u, 802022u},
    {9503333690767543723u, 6377881817593766706u, 7055286254020436797u, 12552816064676821972u, 698632u},
    {5671454463337875277u, 1905027382651299541u, 2608577772137944591u, 6281898179558250348u, 2505482u},
    {3746370602484020583u, 12342877889081477401u, 6644688034808880814u, 12007778601813221510u, 3865258u},
    {5562773454175548331u, 16073323680427477603u, 16110988531926893090u, 10951998136839755371u, 1685371u},
    {10514379140098599038u, 14285763716853106272u, 10263121067133204361u, 3057508568051223389u, 3519763u},
    {16938015876965270362u, 15387460658968294041u, 10621827038703215245u, 5829535693352855600u, 1427812u},
    {11339160343297136456u, 7992588999169318097u, 12263391633901169621u, 10762920000030169539u, 2930065u},
    {10157379713644854596u, 10190337179769206800u, 7118683017949021118u, 16411124016546895249u, 3213837u},
    {2729833132383548u, 1121749727046083839u, 14458665759524364112u, 16416358691654383972u, 3014130u},
    {6576126704909627333u, 9912102331043691968u, 8609428474282932103u, 7837821057227465950u, 1707642u},
    {4727805475042417033u, 15450145310394756179u, 6790530987829019172u, 16820919853618547671u, 1296052u},
    {637218779540062040u, 6531571875120698434u, 7555190604888614732u, 1393002243091770049u, 1739661u},
    {16811531449808607213u, 17832842561787102084u, 6744355152349703774u, 11705421316779341507u, 92778u},
    {11091476556128996459u, 3318455903004113878u, 10314879817732300780u, 14485287865350607077u, 937161u},
    {1796283554349215368u, 11344814533437329565u, 8349167065798736913u, 3764282473580402254u, 1940808u},
    {6106107762882246042u, 18335617670574126911u, 611472348863097955u, 13366456489253158721u, 1580720u},
    {3581344739163183075u, 12283122629564337390u, 12610235588552791016u, 17395039313799283227u, 3267853u},
    {16937801260611682424u, 432757234051439147u, 3251859849708226230u, 17642334210610959677u, 2799562u},
    {1090905246622547432u, 8016891038451968889u, 6496055405773352214u, 4951559215953916318u, 1936227u},
    {18204521962850657070u, 9257288486780006259u, 17537488385080000569u, 13222256797829977927u, 572928u},
    {17485428235471316989u, 5169585094252067042u, 15093671581102623477u, 6207521756672721559u, 1798461u},
    {11370367088175668811u, 13880843561772226640u, 10728341089466046882u, 2483133953290619334u, 662180u},
    {9047233976520113897u, 14914648342734101111u, 3314920761865326707u, 1957770106497917216u, 3449749u},
    {6515375682761302335u, 15024362217267444895u, 8774407804206124018u, 1648903707713720150u, 501890u},
    {11458560757707836814u, 12138663351060019160u, 10593492709190075595u, 5125347414724941250u, 3102085u},
    {14174087824592380526u, 15995565728671909624u, 2760750981178749166u, 1786605630125511173u, 3494940u},
    {13303902668171811298u, 13890165394908183438u, 8307199977607155898u, 13106894786384532506u, 3418899u},
    {16919812005513558798u, 418603454759094195u, 12819072089797444091u, 4818868774477000074u, 1306716u},
    {2044868286199766362u, 6220282149954848283u, 17090043798216236895u, 8238670380771674928u, 3553381u},
    {13049174131226162807u, 7324340227560477312u, 45907027113735157u, 15125585472068991125u, 623882u},
    {10473162867878091589u, 11930161473748568816u, 10150956177130254139u, 8514304703187275982u, 2290472u},
    {3591288590050379829u, 11554824359201512951u, 5465377990731624813u, 4870110559847474079u, 1333920u},
    {3033421392574874269u, 11613590409676209387u, 17323130743105648292u, 1249585584369688116u, 2736202u},
    {1951059495148838374u, 17557128823080254870u, 16980053578547788302u, 14245820044749361198u, 3615039u},
    {8130921433136314115u, 17156782721060425184u, 9476354797238866540u, 3525450227315839876u, 2423137u},
    {107877157769785250u, 4699559462162527509u, 1659824538212078296u, 16113542462077916297u, 1122217u},
    {13483882020456306687u, 11375778722911727913u, 17778399518985739104u, 13063125786772664989u, 3408305u},
    {14485033541868523548u, 9294454879418139506u, 1719898231711309617u, 3377521468867955476u, 1356303u},
    {10004538573131964725u, 15229004745697298642u, 15742287660923231334u, 9176333820521773826u, 838734u},
    {7236633840033964292u, 7662239854645180148u, 10825803263389742587u, 6933000948261334383u, 222811u},
    {14669091513980166753u, 2333113410489164921u, 3070404465346029979u, 8218675864750592951u, 2574148u},
    {6019546134041266751u, 12346927540129553034u, 11507376299318146887u, 12585506020181988023u, 432082u},
    {8306446855645653712u, 8721130794001414334u, 12236325520417360026u, 11681300752802688222u, 3097884u},
    {10855902365537115889u, 8481552502679949995u, 7398412894596828429u, 8992287545702404457u, 1633274u},
    {10702840675155663058u, 17420512694506925866u, 16758410275427019562u, 10262306949858298351u, 319573u},
    {1502681412147627227u, 531876206782889061u, 7321112795755469215u, 798528626023381828u, 2170976u},
    {17065425407895116030u, 4276034948305404622u, 10191439538076831406u, 13370702336477362453u, 259068u},
    {15459463856337610300u, 483091860474102739u, 10983492869923015058u, 12326627554950067178u, 520397u},
    {18208178749083923419u, 5876076364907806248u, 8898316989894532767u, 3828652126612534392u, 2009720u},
    {12605611948194166192u, 9611907678141259952u, 12658928932215428623u, 16682377017089820902u, 2242335u},
    {1897620117242975676u, 15039556942632171378u, 9457355384391584004u, 7751526358613187676u, 2361250u},
    {7877093570545844653u, 2013432984829318040u, 6760135439916467464u, 2781745955636834605u, 3899978u},
    {10981181324555536621u, 14696283263900210788u, 6070806012351311073u, 6196837392064718145u, 3095770u},
    {15756725420262172830u, 12907639028108335371u, 12377441815872582649u, 921798011553040442u, 1032956u},
    {5138345797917093883u, 15491222559987117453u, 2805700680755940401u, 17745222809223472991u, 2522684u},
    {731841907079017719u, 7397361341205803656u, 13509110269964681308u, 6459661193247651019u, 2715806u},
    {8081614945215037529u, 18108274882914168787u, 14456593716939967864u, 17632150729949922419u, 3522085u},
    {13720268309977941440u, 8523368440083606286u, 984351094987442520u, 5253117788963813428u, 1676804u},
    {1014832106776889229u, 7187013683414505804u, 17556295609914694242u, 16027717455922892051u, 1056930u},
    {16901025201870523924u, 15301366469097328631u, 5762595572661155062u, 10900193632968661628u, 157343u},
    {13757849575350814987u, 15880199111868102479u, 17498174056187352433u, 5551337217873434386u, 3515535u},
    {2732877455985640911u, 9308027278788976509u, 7633058804890195729u, 12891101918729678334u, 848698u},
    {4737645647017615186u, 8602966740703969830u, 14150023342146449661u, 7581703101675404347u, 2618724u},
    {16156321477367968222u, 14584485763460103752u, 9619282178187041944u, 17486244696187944585u, 3776040u},
    {8320641081944826344u, 6983117252436381173u, 8707328531529449864u, 5185744837671218367u, 2047531u},
    {4796771894580195615u, 5421425631435632941u, 11087940583887024525u, 12575791648125192293u, 1009606u},
    {12791026302233390586u, 10905094350413688146u, 12802327964535734463u, 18393310435744696933u, 141008u},
    {2865406003334303582u, 13597387245615788332u, 3670272330074596365u, 15062638310808594696u, 2139848u},
    {530922311091730849u, 1072194673874681671u, 7655197060666546163u, 16973007842388342507u, 3183961u},
    {7636072635416450725u, 7112044244926624975u, 1128451592653619063u, 12236467123090501364u, 1108892u},
    {172993555112576737u, 4941698996441114902u, 3709102253507276757u, 6433581328541437359u, 2880707u},
    {10348372365337208825u, 12309111901854474776u, 15652244438062408386u, 16554328705899422293u, 2217148u},
    {8401675999539204806u, 373202769385684523u, 15601028725291862635u, 473244742511433306u, 2309515u},
    {7380757382882022981u, 16992937191934052775u, 11286816469719145512u, 9986551009846693225u, 2726365u},
    {499700297371869201u, 11075140193545701317u, 9928942761255273708u, 6103130466579016775u, 1641543u},
    {13898263481613932427u, 14494505481373029732u, 1243315411990657925u, 3921391207758228409u, 986121u},
    {16785733802163033549u, 6325739875610394528u, 9358954592468932370u, 6575431783085543920u, 117985u},
    {16192303450151817196u, 10561558810205646113u, 9831333934436946215u, 11603449085781366100u, 1549375u},
    {17197182915444687027u, 77546709999780128u, 5836662359891885694u, 3919691013750761366u, 3852541u},
    {16510560256126541744u, 9195016550492443585u, 8172232699014060635u, 5187156018473047539u, 3277389u},
    {12115730637014942591u, 9811860868699269643u, 2476625980839613694u, 18146913264820058828u, 1035310u},
    {16649855507808669843u, 8570193167328550681u, 12979494156910397062u, 6720454362281163548u, 2900929u},
    {16904396046390368492u, 11896918689732910141u, 2601264160545760720u, 15906183389903602458u, 2534795u},
    {10695585097144620855u, 7357379993633350219u, 14611318778769644634u, 10567167460087980648u, 1956374u},
    {4908334669166442468u, 12060340091369544667u, 7769418720616191796u, 1405183027778257694u, 348133u},
    {5833831425389614593u, 15073516164988450137u, 2047415606385255701u, 9373909146690427435u, 2970321u},
    {12722127787942121236u, 4435298949197624063u, 13946036824070252585u, 4450305996991278271u, 3139507u},
    {13967990304867086505u, 7518537106526362551u, 4732910342133565164u, 1210835191203772626u, 2218450u},
    {6094845410607654605u, 16841729403927886581u, 18193799113970287760u, 6165818673825030705u, 5169u},
    {10160884368413615594u, 15452341383759614300u, 9174189512019947178u, 1008901673916926782u, 977323u},
    {11747365292414351453u, 12295477647119077328u, 570571638432081225u, 3116504971898152962u, 2257819u},
    {1515463199054313340u, 8406961233471100832u, 336440315169624789u, 4437162648687867894u, 2278473u},
    {13037998742648767073u, 232948831430442792u, 16362820229085971197u, 12652109369384408671u, 2570964u},
    {8344087038118141039u, 14687244449757329323u, 835388399623147469u, 5523803074465353109u, 2592557u},
    {8517249184141567141u, 2074421333032342961u, 8748833623124426282u, 16765186057798588440u, 2639719u},
    {1527381876977893931u, 11469561708902912113u, 12558992441668026748u, 5525071384467217697u, 2095001u},
    {5727835950945780801u, 6764542000153001526u, 14984093083279345485u, 4722389565271552808u, 2498675u},
    {18115376619458604543u, 14478923457003136859u, 2871449859862192412u, 3072511372563739091u, 3388012u},
    {4569330449028375949u, 9501529398416521171u, 17586507523225017847u, 16059283669775170009u, 831674u},
    {2285605662708823937u, 5168034940804817846u, 7486706893843503820u, 14570975689151485059u, 2066073u},
    {5297983815426136217u, 3769434473862239744u, 10835783995142450889u, 9117369183218496939u, 3131075u},
    {8474484998199842677u, 18180179642049519172u, 10045435314688778506u, 11731088382462284949u, 2040928u},
    {2617004541397919038u, 10600924321487334653u, 4110388324231904448u, 17619701433474372654u, 2298021u},
    {16584096286781566905u, 9631817788700440765u, 18235060126409052614u, 13084815543747667946u, 1482059u},
    {10007123093202962694u, 7877151796204338951u, 1957666082613267667u, 14222685201631756840u, 140182u},
    {6380450884903786563u, 14252804855680205311u, 18380168890861484388u, 16792005326537635041u, 2633111u},
    {5048974781491582428u, 1040032241282008540u, 12964231871722930827u, 2786760914967936325u, 159673u},
    {2900882958262251008u, 17332485377747985836u, 3746863801926352689u, 2597018835118648036u, 3676192u},
    {13524298821068066041u, 7641276294253766518u, 1715073268853110356u, 4967730170165936947u, 169563u},
    {13819398517081826053u, 18265605097327416250u, 15985962343283546349u, 15783740984539318566u, 3437419u},
    {10891211431455507593u, 18124314725136128546u, 13754587286193060666u, 16204310268846705261u, 363911u},
    {12186492360109087680u, 193263936346911230u, 8943635237958717955u, 4906629383866017633u, 1156449u},
    {14352423974155676211u, 5689762201884919671u, 2265061269953821366u, 4705076336109242561u, 284305u},
    {9913708668301560770u, 98653598824330505u, 3346782467828248016u, 13840302561561116042u, 1547469u},
    {5024187267823698180u, 11187521430897271054u, 12742567091483391714u, 16385619625054943279u, 2590774u},
    {3663645237254255145u, 2820277001585160125u, 17216974608179074383u, 10856430467005630814u, 628129u},
    {14743925837490289364u, 4534498037194700942u, 17573056079558273222u, 11108456427605607717u, 2781633u},
    {5278956675455211643u, 2853370822735253141u, 14681332802130646724u, 10283490436552208260u, 3746451u},
    {3285693126363002448u, 17704032781164954565u, 16851526403081253124u, 9076309087806175659u, 3888147u},
    {11241375098540771206u, 14251587398844965539u, 14633271027210175675u, 11961226677964380099u, 3878689u},
    {8585000831394633412u, 4020040713864069281u, 226738593690385676u, 11024303489050785377u, 3130344u},
    {10675441318083711105u, 2433600956830598214u, 12813500998986025759u, 6182640158878850301u, 903517u},
    {16088848901294332760u, 7245012731002931101u, 15242245305603619414u, 10320902900471580839u, 46157u},
    {11386001569378529786u, 6029868574112698432u, 4529054784375399032u, 17150558837713961880u, 1008155u},
    {11531028446183893274u, 5759457050544771157u, 13344196840837673863u, 3189131332091018674u, 2335912u},
    {16270660288441562335u, 7732117310765209025u, 4158863954432901020u, 11067901861834812566u, 3837297u},
    {2222750644481765472u, 3888243609325123980u, 2254828874678107468u, 10879424752450905703u, 2653705u},
    {13488361021159485368u, 8987585684205887633u, 2251295675647914429u, 9200266670678396030u, 3311177u},
    {10900424011816041753u, 2336144027398380493u, 12352088551657933684u, 4312478492139768266u, 1513811u},
    {4233081161695997526u, 11366336865274648687u, 3341384979046051956u, 1036731204936435926u, 930736u},
    {11664785614288744161u, 12498037834825103391u, 3123131579657490875u, 14933091015680002090u, 1612321u},
    {3607114108323070221u, 17770074920051856902u, 12009989330251224557u, 5145831264477641929u, 1366330u},
    {3302360440491287188u, 3711638051822992568u, 2529624328951365258u, 10473555480475613556u, 1165752u},
    {16026251306753156269u, 4499652784166867229u, 12747969072094266828u, 16882981344146107561u, 258047u},
    {7879604315670116229u, 14263425325395471615u, 14978046240760960124u, 4256158192088718096u, 3240271u},
    {17136556539035608881u, 8281625847401153015u, 11308703272685202379u, 13894830509404784826u, 1061489u},
    {5815820848361005700u, 2139807176055049319u, 11807780261971464657u, 7153282839569754051u, 580529u},
    {2469931802632805238u, 11241469766085471532u, 15861228421428881148u, 5559143617964100443u, 280841u},
    {7458152259684773473u, 357157236920407608u, 2757594545621288364u, 6490364071025062522u, 299385u},
    {13994157983749103882u, 10960658281235930282u, 2501723121225394786u, 9012721939705863605u, 1052444u},
    {9315258271452621010u, 6757576029466519455u, 863549443519392395u, 15439739298249211419u, 409231u},
    {8589520060405646541u, 9939951220186900917u, 14140881368821682804u, 13698491862170075371u, 2402141u},
    {15360100073527042905u, 7224845079234191375u, 3661406199022026453u, 6817725533519682582u, 2896354u},
    {1762217458274829466u, 3885075952372258418u, 3336843455751398607u, 13384083204819258648u, 1185453u},
    {8596749165834395837u, 17283185128890467463u, 16806841367827491234u, 7227627165279288013u, 337284u},
    {17684764406406836260u, 3943835427792997703u, 12664408453217328055u, 9806054588013983513u, 3856078u},
    {13301788508790944101u, 13994892289776129205u, 7199866806977040347u, 10087137665072299472u, 2587329u},
    {13964664394383745541u, 17502789568914099796u, 10060358671668260124u, 552130964250120077u, 3050375u},
    {11230346299000161523u, 9550812018055614900u, 14033841599880110187u, 9351699118398676481u, 3154820u},
    {7674807506703475577u, 1853370267418346083u, 514029624140946555u, 5822803689524554366u, 2073700u},
    {17278715781739044373u, 5762932763439897130u, 13109244457585089328u, 6091090918194401810u, 1508777u},
    {7369008125502939012u, 14754879128838920073u, 6510509786224805636u, 12854083768025562802u, 3882868u},
    {9443871307245871507u, 6883023964884229499u, 5343606528455067687u, 11672898925228477923u, 3578675u},
    {16864758302708095713u, 1334475381234244401u, 15824847893876490027u, 10658481237096288046u, 3763430u},
    {3343034989475882806u, 10277168912051607688u, 17238314966950699038u, 14048596284065821558u, 243023u},
    {2380481342984056992u, 15678040057948501229u, 7898835434960647643u, 4616169015561009304u, 1464917u},
    {4227967420570917390u, 4175827453489719025u, 14492964437196807278u, 7953358297776468350u, 2723614u},
    {2459394024705868934u, 3480584470584884609u, 9067101823986371233u, 17776409951697202920u, 3284112u},
    {8347280989042178762u, 248607234530569940u, 12431775725860554039u, 15264733533352602870u, 160251u},
    {8059799021632168452u, 13453716170693763975u, 13071703869573310595u, 2092626351549199706u, 566593u},
    {7235749372051122589u, 13020171286158608995u, 9739216690523229136u, 8729420676746861923u, 1209219u},
    {1735301510724623979u, 14856261851229455933u, 782323234618514022u, 17676416701443831987u, 2439068u},
    {5738403648111670868u, 3807740438891609698u, 1563654403091377873u, 17915276202256919438u, 451738u},
    {12409077557351478472u, 14993517442288375397u, 12632847700624246607u, 11897836129447755047u, 3005560u},
    {4328759112052689288u, 7728225056999716702u, 7429241850005841034u, 11656715448122412305u, 2861651u},
    {613262416887602778u, 16936873836253512920u, 3945580018759825505u, 8627641845795414844u, 44863u},
    {18254623300830465309u, 18095590708314413783u, 7555112184934606423u, 827584907020677u, 0u},
    {18046801395846954772u, 836937189988346602u, 16731578305736887593u, 827584u, 0u},
    {16997737476690744323u, 5561017026082392588u, 15266246979075151u, 0u, 0u},
    {12172759318655059175u, 18060748744986551404u, 15266246u, 0u, 0u},
    {9335988314792887517u, 281612550989040892u, 0u, 0u, 0u},
    {18244584222493396995u, 281612550u, 0u, 0u, 0u},
    {5194834656039319013u, 0u, 0u, 0u, 0u},
    {5194834657u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3411146u},
    {9723994830070269767u, 8029656959681469760u, 2890824976687550535u, 18437611016931681722u, 229686u},
    {3461018863244295655u, 10086607780572384537u, 76633274902748419u, 1877734422283051405u, 1501543u},
    {12369904178486372599u, 4903984040861168900u, 10057070661541096381u, 6368766856652062851u, 3726591u},
    {540659102414143285u, 1839879974362973574u, 5871301785266442733u, 4896602277354327920u, 754427u},
    {16967724975511558063u, 17717676453236981143u, 4636256201961155273u, 14641608316387269761u, 2020443u},
    {13332702594810295265u, 3051719728272154616u, 18132331297546332348u, 6738626855105424311u, 1563790u},
    {763172068322347629u, 3225360889373641788u, 15255622483896334258u, 15088883994580591738u, 1240134u},
    {11437374389685816674u, 18008780925734578119u, 12255062749118244466u, 1896373894590116051u, 221464u},
    {14381361620642659372u, 16873688140271415166u, 13451400378449205992u, 16072928762083843634u, 506816u},
    {12013782951321701116u, 5580188651001229507u, 3609258414981045204u, 5773956644151624822u, 2814083u},
    {5474151946605438578u, 4714847669352366146u, 5383367744534934306u, 5095942257332088960u, 2350379u},
    {9179431639690934571u, 15355724446617854386u, 10141123828068754707u, 6312367526284894071u, 558147u},
    {8030826676902615323u, 8396136576428430424u, 7207320432757666951u, 11827741423397057795u, 3869990u},
    {5086944251424452727u, 9184986418422114989u, 1023086593961812680u, 16572577761611053995u, 3523979u},
    {13276228207989246075u, 11359911280866807682u, 11164966726969987896u, 13683891228475084577u, 1973889u},
    {4060760627606082840u, 8479723141708940706u, 11157313957758937032u, 5008385827513829285u, 115960u},
    {8992668537133962730u, 1461892522831045343u, 2199232737774894244u, 16791558500288382275u, 3471801u},
    {2942841243746473783u, 6051507890400124688u, 5503820204219516910u, 13034410368140435875u, 1711715u},
    {16235198757108165881u, 6318894372675363691u, 5253952123069936785u, 11272560251483298129u, 3103092u},
    {10009175809641099416u, 6181230952053418291u, 7867440448068636671u, 7263001359026529371u, 3332610u},
    {11498618603827460181u, 5783614445566461721u, 15449648648212653740u, 2655549196395892243u, 644605u},
    {578627315446755205u, 17354019982396008055u, 16884746167574476595u, 16801310276956391829u, 685769u},
    {1276618416521254757u, 17941154309092046532u, 8458653663534410090u, 12406556396561598994u, 411209u},
    {17350610872010237912u, 13571171828332192624u, 10552694930450213577u, 10311821427014057275u, 2447249u},
    {14444696400957409124u, 6650134649873422426u, 9163635199757070075u, 15681641692529825165u, 3502891u},
    {6599990515843244925u, 14307405593597889951u, 9215016058334646128u, 10873256055165932617u, 546741u},
    {7879805043712865545u, 10584190132367166100u, 2324586257019916295u, 17375965765315492665u, 3685518u},
    {1947223333544397461u, 8406313050066551311u, 10481250961219830183u, 140043418738943580u, 1908868u},
    {13211396643187127022u, 14891083820743771438u, 2085852093599296554u, 17256977374671313927u, 1381316u},
    {11195357583999037769u, 2232216202441987512u, 12383678988100343257u, 17463418557172458069u, 1249558u},
    {13867879546551133458u, 7785802682048244348u, 1303148056037769589u, 4490621124446206949u, 3654396u},
    {13217991089412973294u, 11863280958896389920u, 618166720581660363u, 8642265402760033399u, 3691490u},
    {9058467602786769246u, 17778835204390728397u, 8392922474790445840u, 5256242750653734867u, 2579470u},
    {9575470750092056399u, 9412437014289685307u, 14031670600902639113u, 2569598619519532087u, 2113635u},
    {4456134725598274325u, 7713400251756823298u, 11979615319749618979u, 5803597209514068587u, 1330479u},
    {1421012062076410684u, 11069392972022791650u, 711539833221132129u, 1825982862360240620u, 1473559u},
    {9100179110434845225u, 3613089118813616544u, 9776072719420014573u, 2260967782752260251u, 2807031u},
    {5717083997034055316u, 9982959616382827089u, 2480576979876137121u, 4087005850848901195u, 2876058u},
    {9734319423105176779u, 5837263520986129496u, 8310459701472247112u, 1926551354940277132u, 1668690u},
    {7354955203855749980u, 13746607103877610650u, 11554674734040629320u, 1399876186015540530u, 2847051u},
    {12801545025644028630u, 7556562182606803374u, 12053562761794158518u, 13887576877843838750u, 2710110u},
    {17066319293071559388u, 905710754980035722u, 14275501936679093320u, 17415872882609810446u, 3454228u},
    {11404413726784571524u, 11313573051474373625u, 12345352403042231575u, 2297504692479880495u, 1995666u},
    {13741132429398333115u, 4425580352109423367u, 9503333690767543722u, 6377881817593766706u, 1709241u},
    {48588571610586725u, 998070574160089529u, 5671454463337875276u, 1905027382651299541u, 1140001u},
    {12396767947107556643u, 18124571468099355986u, 3746370602484020582u, 12342877889081477401u, 242872u},
    {5609648723999321975u, 1545693840299979170u, 5562773454175548330u, 16073323680427477603u, 995302u},
    {1844951298609150266u, 10820573966183133583u, 10514379140098599037u, 14285763716853106272u, 2124663u},
    {15339084834957429421u, 8719294788037404448u, 16938015876965270361u, 15387460658968294041u, 3591617u},
    {13624476533529694252u, 15586668075671482688u, 11339160343297136455u, 7992588999169318097u, 1638035u},
    {11886391248624791910u, 16488809753918948192u, 10157379713644854595u, 10190337179769206800u, 2216424u},
    {16423660443389603583u, 17177547943094719851u, 2729833132383547u, 1121749727046083839u, 2179894u},
    {5747164501175980383u, 2028828916272388138u, 6576126704909627332u, 9912102331043691968u, 1616555u},
    {18412347136758744718u, 8863691888911193773u, 4727805475042417032u, 15450145310394756179u, 2514720u},
    {15073447567899247057u, 9047844192307397008u, 637218779540062039u, 6531571875120698434u, 1876582u},
    {15118276454626650893u, 4131236427558050239u, 16811531449808607212u, 17832842561787102084u, 206354u},
    {7126352070185109949u, 17977576598832807317u, 11091476556128996458u, 3318455903004113878u, 1722378u},
    {9702184974977113929u, 7804553167508487924u, 1796283554349215367u, 11344814533437329565u, 1788325u},
    {12001577806000107135u, 12388715397673024807u, 6106107762882246041u, 18335617670574126911u, 1806911u},
    {13534260570030654037u, 1873389230327361279u, 3581344739163183074u, 12283122629564337390u, 22316u},
    {7836838008906935774u, 11321825867486212722u, 16937801260611682423u, 432757234051439147u, 1002784u},
    {3630850249517783571u, 11951414524995697442u, 1090905246622547431u, 8016891038451968889u, 1838614u},
    {16188022648673700457u, 9817062779497477416u, 18204521962850657069u, 9257288486780006259u, 2900019u},
    {8077811684765077130u, 4291437214128887575u, 17485428235471316988u, 5169585094252067042u, 2482037u},
    {4460837537034766773u, 13288531429174396286u, 11370367088175668810u, 13880843561772226640u, 3837206u},
    {13995354030744040339u, 2105714037792133423u, 9047233976520113896u, 14914648342734101111u, 1972307u},
    {10365005015080838034u, 17887960174274891375u, 6515375682761302334u, 15024362217267444895u, 1788258u},
    {14374725071348379660u, 8880009931471416648u, 11458560757707836813u, 12138663351060019160u, 3840105u},
    {8039967228253872575u, 6088204983481508414u, 14174087824592380525u, 15995565728671909624u, 2987374u},
    {14089889908352116741u, 695247699857309664u, 13303902668171811297u, 13890165394908183438u, 3161288u},
    {13203282762715252082u, 16352345633204148160u, 16919812005513558797u, 418603454759094195u, 1264671u},
    {14154357336449815384u, 411341988650379037u, 2044868286199766361u, 6220282149954848283u, 2522029u},
    {3458477588870831713u, 136614982154500515u, 13049174131226162806u, 7324340227560477312u, 2204099u},
    {6953352368283030436u, 14555535158143311118u, 10473162867878091588u, 11930161473748568816u, 1388283u},
    {2344046038676258065u, 15917110566398418065u, 3591288590050379828u, 11554824359201512951u, 667747u},
    {2637000455355243832u, 17938873423090655151u, 3033421392574874268u, 11613590409676209387u, 2555110u},
    {17353004725795809313u, 11961492744216719547u, 1951059495148838373u, 17557128823080254870u, 383554u},
    {7282468712190049526u, 7858366796514224743u, 8130921433136314114u, 17156782721060425184u, 857378u},
    {10403734168911634804u, 12771304909652526679u, 107877157769785249u, 4699559462162527509u, 3400950u},
    {295763428092594462u, 3255352150563842096u, 13483882020456306686u, 11375778722911727913u, 3853408u},
    {14718058831904816115u, 11953603462921242321u, 14485033541868523547u, 9294454879418139506u, 1347251u},
    {8820751662979362964u, 13218433200613911806u, 10004538573131964724u, 15229004745697298642u, 1308354u},
    {16717947067022515325u, 17136538632585942193u, 7236633840033964291u, 7662239854645180148u, 1478331u},
    {9457987207881870766u, 8641255437721171235u, 14669091513980166752u, 2333113410489164921u, 1359533u},
    {2929619872438354459u, 18292513363907715517u, 6019546134041266750u, 12346927540129553034u, 117197u},
    {13715403861520221011u, 13866021413117744474u, 8306446855645653711u, 8721130794001414334u, 2754632u},
    {799408594509026907u, 8861477313782105218u, 10855902365537115888u, 8481552502679949995u, 2961635u},
    {6616255070234723125u, 4132962913489774059u, 10702840675155663057u, 17420512694506925866u, 1489316u},
    {6415117257354830542u, 3338244726243026520u, 1502681412147627226u, 531876206782889061u, 1335569u},
    {14908739289739243427u, 17247304790720977483u, 17065425407895116029u, 4276034948305404622u, 2750962u},
    {11189535442778580281u, 9085129442342322383u, 15459463856337610299u, 483091860474102739u, 2136488u},
    {7100941307359952555u, 9265671370884869011u, 18208178749083923418u, 5876076364907806248u, 1531309u},
    {3638628595121727607u, 8922617990949653283u, 12605611948194166191u, 9611907678141259952u, 2796015u},
    {9621590962163912686u, 3062094279024614848u, 1897620117242975675u, 15039556942632171378u, 3679670u},
    {12405183342880241257u, 13652841913594150209u, 7877093570545844652u, 2013432984829318040u, 3718362u},
    {17379976863772295506u, 5381881205260593846u, 10981181324555536620u, 14696283263900210788u, 505763u},
    {4260805757521364370u, 15720148472643758463u, 15756725420262172829u, 12907639028108335371u, 3843357u},
    {11153679462656909365u, 12951092991128970043u, 5138345797917093882u, 15491222559987117453u, 2574261u},
    {2584292545429578807u, 12285198528524147615u, 731841907079017718u, 7397361341205803656u, 1182798u},
    {625825109025934258u, 13766061747601954552u, 8081614945215037528u, 18108274882914168787u, 1115228u},
    {13539983199835167885u, 4672547153554910690u, 13720268309977941439u, 8523368440083606286u, 2890042u},
    {6797997127955967103u, 12723102475844203629u, 1014832106776889228u, 7187013683414505804u, 1363738u},
    {14455826952864686912u, 19387909679452688u, 16901025201870523923u, 15301366469097328631u, 1492318u},
    {10287600134671528316u, 1166509874373019331u, 13757849575350814986u, 15880199111868102479u, 682919u},
    {8643398204663834840u, 6976394692075623312u, 2732877455985640910u, 9308027278788976509u, 1524011u},
    {5970599223695743265u, 11840955251116196808u, 4737645647017615185u, 8602966740703969830u, 1564057u},
    {5903646542046486582u, 269275565246935261u, 16156321477367968221u, 14584485763460103752u, 3555544u},
    {8290127888044714744u, 14025862266472503277u, 8320641081944826343u, 6983117252436381173u, 927322u},
    {15432287200302464257u, 15177109300089390043u, 4796771894580195614u, 5421425631435632941u, 1322599u},
    {3838971607287908636u, 10202385290463844947u, 12791026302233390585u, 10905094350413688146u, 2740839u},
    {8665185131131830600u, 12296343292228268203u, 2865406003334303581u, 13597387245615788332u, 3436289u},
    {14016194668340774995u, 18350357579271241434u, 530922311091730848u, 1072194673874681671u, 2732191u},
    {10070998354637934035u, 12203282704704588703u, 7636072635416450724u, 7112044244926624975u, 2265039u},
    {3123314744109012114u, 14051753962367672480u, 172993555112576736u, 4941698996441114902u, 3215793u},
    {14361928354828572262u, 12748230806021314252u, 10348372365337208824u, 12309111901854474776u, 700112u},
    {12891544815418735164u, 9926744777820073330u, 8401675999539204805u, 373202769385684523u, 3220221u},
    {12649923272645359594u, 14076631995465446276u, 7380757382882022980u, 16992937191934052775u, 2728302u},
    {2589091817884735557u, 12255741772588607227u, 499700297371869200u, 11075140193545701317u, 592466u},
    {7016468418770675960u, 16067814486435751834u, 13898263481613932426u, 14494505481373029732u, 3075295u},
    {5651461879623923593u, 11439911754637797840u, 16785733802163033548u, 6325739875610394528u, 2230750u},
    {15042880322530789167u, 11224157487625655622u, 16192303450151817195u, 10561558810205646113u, 297565u},
    {7247015746423966072u, 14701878742437557683u, 17197182915444687026u, 77546709999780128u, 2369096u},
    {9679008153802175598u, 11055828257990388190u, 16510560256126541743u, 9195016550492443585u, 652043u},
    {10154031793956020787u, 10229267671140948613u, 12115730637014942590u, 9811860868699269643u, 3653602u},
    {18338934910476631214u, 2534586150838334067u, 16649855507808669842u, 8570193167328550681u, 402004u},
    {7064067379910651052u, 9745012056678260600u, 16904396046390368491u, 11896918689732910141u, 406868u},
    {563309706582461855u, 18048039016290736849u, 10695585097144620854u, 7357379993633350219u, 1448596u},
    {1710747227483110266u, 10557819371756299149u, 4908334669166442467u, 12060340091369544667u, 730698u},
    {7090234475579389990u, 7285553148577940998u, 5833831425389614592u, 15073516164988450137u, 2156787u},
    {15537993111623726826u, 16877624480266076270u, 12722127787942121235u, 4435298949197624063u, 1330713u},
    {17810010556038147093u, 3237498989927255940u, 13967990304867086504u, 7518537106526362551u, 2835730u},
    {18343529762273698067u, 14815351242735920951u, 6094845410607654604u, 16841729403927886581u, 1735604u},
    {1608226550488125843u, 9164322621937633174u, 10160884368413615593u, 15452341383759614300u, 2476678u},
    {1572432748253357722u, 17113921831939563356u, 11747365292414351452u, 12295477647119077328u, 2617281u},
    {14103183916936182523u, 3200226698126580563u, 1515463199054313339u, 8406961233471100832u, 909431u},
    {13935407527042844273u, 212126252193769357u, 13037998742648767072u, 232948831430442792u, 3228367u},
    {14766686768765767806u, 15153839696304105336u, 8344087038118141038u, 14687244449757329323u, 3079605u},
    {13158673371133478608u, 17301789474767562459u, 8517249184141567140u, 2074421333032342961u, 672436u},
    {11104138821883446312u, 7820846401109757351u, 1527381876977893930u, 11469561708902912113u, 3425306u},
    {11351405692007757423u, 3182507447452574538u, 5727835950945780800u, 6764542000153001526u, 3654013u},
    {1912573969072122067u, 11372781937139437340u, 18115376619458604542u, 14478923457003136859u, 3360190u},
    {17121237711153727543u, 5230672540832061874u, 4569330449028375948u, 9501529398416521171u, 2815985u},
    {11384802476705895254u, 17460995159483701864u, 2285605662708823936u, 5168034940804817846u, 1216452u},
    {5603958677203868204u, 5272765397458821827u, 5297983815426136216u, 3769434473862239744u, 1174513u},
    {2989733823023825436u, 9271028246211277999u, 8474484998199842676u, 18180179642049519172u, 458508u},
    {10584668242209140808u, 15009973179397265063u, 2617004541397919037u, 10600924321487334653u, 2610638u},
    {2876793194691390502u, 18187331455967435071u, 16584096286781566904u, 9631817788700440765u, 1240004u},
    {14097875443358219351u, 14349334261204633398u, 10007123093202962693u, 7877151796204338951u, 3114849u},
    {9874738500792007136u, 14430291206381764207u, 6380450884903786562u, 14252804855680205311u, 1692760u},
    {6641273826448159011u, 2949222992530116639u, 5048974781491582427u, 1040032241282008540u, 2095915u},
    {4047635338287570418u, 12694778236465461400u, 2900882958262251007u, 17332485377747985836u, 171917u},
    {14285482539554246450u, 10146504953540651086u, 13524298821068066040u, 7641276294253766518u, 1899186u},
    {16659339257807876931u, 8189135860747012912u, 13819398517081826052u, 18265605097327416250u, 2052319u},
    {14338262523883600728u, 6293153160943238847u, 10891211431455507592u, 18124314725136128546u, 2664358u},
    {3384816382660993246u, 10920900019669860010u, 12186492360109087679u, 193263936346911230u, 3755127u},
    {18422172017864006896u, 10040014406986441652u, 14352423974155676210u, 5689762201884919671u, 1441772u},
    {18331261940207079728u, 9430982366918392112u, 9913708668301560769u, 98653598824330505u, 1008002u},
    {7821491226525070409u, 17090498156581426712u, 5024187267823698179u, 11187521430897271054u, 543772u},
    {10212344643340134514u, 1093402640774919421u, 3663645237254255144u, 2820277001585160125u, 3628131u},
    {68280651847924623u, 6730034108360011769u, 14743925837490289363u, 4534498037194700942u, 2337792u},
    {5438645457199419397u, 2199899435571926405u, 5278956675455211642u, 2853370822735253141u, 2706290u},
    {12111007152655513724u, 14796054803699088636u, 3285693126363002447u, 17704032781164954565u, 3048850u},
    {14302853256216020190u, 423446629874791973u, 11241375098540771205u, 14251587398844965539u, 3083093u},
    {13316545273478702086u, 10423252256128635175u, 8585000831394633411u, 4020040713864069281u, 3019522u},
    {9627654564192810283u, 8415137898483499789u, 10675441318083711104u, 2433600956830598214u, 2127927u},
    {15772520129927110620u, 17949726815718866529u, 16088848901294332759u, 7245012731002931101u, 2661080u},
    {8360724989436224388u, 16359946114845365233u, 11386001569378529785u, 6029868574112698432u, 3627042u},
    {13931320866511783879u, 2593410222829157878u, 11531028446183893273u, 5759457050544771157u, 1190169u},
    {13697280481425080508u, 8186831947092832227u, 16270660288441562334u, 7732117310765209025u, 3750858u},
    {17688935958212196254u, 14637970713979884275u, 2222750644481765471u, 3888243609325123980u, 2842996u},
    {10007851334870344271u, 18219467786700659047u, 13488361021159485367u, 8987585684205887633u, 1642621u},
    {9424924548366143193u, 2566245955194104486u, 10900424011816041752u, 2336144027398380493u, 2889106u},
    {620078124984122419u, 13537452603636580960u, 4233081161695997525u, 11366336865274648687u, 1738738u},
    {15584821751404672511u, 15489883105636250830u, 11664785614288744160u, 12498037834825103391u, 2380191u},
    {11250739729596127000u, 13531463622842271272u, 3607114108323070220u, 17770074920051856902u, 1989551u},
    {16243571963912050016u, 14912718849848099300u, 3302360440491287187u, 3711638051822992568u, 1739166u},
    {16598144879526069680u, 5843241783628784668u, 16026251306753156268u, 4499652784166867229u, 3690586u},
    {8269421483856706331u, 3543648097962672751u, 7879604315670116228u, 14263425325395471615u, 3635336u},
    {10828454514208870316u, 17286541347612554398u, 17136556539035608880u, 8281625847401153015u, 2717929u},
    {5411476014929933483u, 5285467087383761464u, 5815820848361005699u, 2139807176055049319u, 26297u},
    {10714710577673602519u, 5050970054022587349u, 2469931802632805237u, 11241469766085471532u, 3736532u},
    {2467945720384254955u, 17958118254680573234u, 7458152259684773472u, 357157236920407608u, 428476u},
    {17245634695429221110u, 9070062197833962106u, 13994157983749103881u, 10960658281235930282u, 3047680u},
    {15900644673286931130u, 5455839897713234499u, 9315258271452621009u, 6757576029466519455u, 3689585u},
    {2324283921570176811u, 1995864831145378156u, 8589520060405646540u, 9939951220186900917u, 1034636u},
    {18228294117151128581u, 5955871262792783889u, 15360100073527042904u, 7224845079234191375u, 3579139u},
    {12004869838920354558u, 12801510750194455735u, 1762217458274829465u, 3885075952372258418u, 3329593u},
    {7500245285778954903u, 15177065358720654951u, 8596749165834395836u, 17283185128890467463u, 2858246u},
    {2894708669451354262u, 9642707496599102910u, 17684764406406836259u, 3943835427792997703u, 852131u},
    {2855821581726120530u, 15697940201906572867u, 13301788508790944100u, 13994892289776129205u, 3515623u},
    {3235285071468702717u, 5295441683037672842u, 13964664394383745540u, 17502789568914099796u, 2125556u},
    {7103815947768428712u, 5356665383198148197u, 11230346299000161522u, 9550812018055614900u, 2815153u},
    {14411984355169591356u, 17595107526924605279u, 7674807506703475576u, 1853370267418346083u, 3815461u},
    {15383625322747173433u, 14637803558993363899u, 17278715781739044372u, 5762932763439897130u, 2988600u},
    {7566410439736173281u, 17740382323507560857u, 7369008125502939011u, 14754879128838920073u, 2035726u},
    {1083403426051724853u, 542408726119780559u, 9443871307245871506u, 6883023964884229499u, 2029555u},
    {3984793326202627751u, 10658048557583548990u, 16864758302708095712u, 1334475381234244401u, 2438943u},
    {12063919125282139128u, 17150468061623520812u, 3343034989475882805u, 10277168912051607688u, 2252004u},
    {4740831759538323895u, 3063348186234131252u, 2380481342984056991u, 15678040057948501229u, 3715809u},
    {16818468352021138670u, 15515574133888018737u, 4227967420570917389u, 4175827453489719025u, 1182862u},
    {1379966131966612819u, 5255087456392451243u, 2459394024705868933u, 3480584470584884609u, 1758275u},
    {13298111613670397744u, 3562905188468641962u, 8347280989042178761u, 248607234530569940u, 2764915u},
    {15461068793091685532u, 13799419705611169068u, 8059799021632168451u, 13453716170693763975u, 2699899u},
    {5366729494208533470u, 10290423869364204158u, 7235749372051122588u, 13020171286158608995u, 672068u},
    {5355864831470125162u, 1887461935688253515u, 1735301510724623978u, 14856261851229455933u, 3293022u},
    {6900597190886802386u, 199625833206199391u, 5738403648111670867u, 3807740438891609698u, 300209u},
    {13142678246821307699u, 2985368284953984783u, 12409077557351478471u, 14993517442288375397u, 979169u},
    {11124408178042619538u, 2778634667674972457u, 4328759112052689287u, 7728225056999716702u, 181020u},
    {3082124087983032194u, 2522497051212251436u, 613262416887602777u, 16936873836253512920u, 495187u},
    {13357880265209739439u, 5105021483259292176u, 18254623300830465308u, 18095590708314413783u, 2401705u},
    {7423258188121964064u, 17445475397060004897u, 18046801395846954771u, 836937189988346602u, 682087u},
    {8388311865488266196u, 9436473914694364215u, 16997737476690744322u, 5561017026082392588u, 2512651u},
    {8596625302574035285u, 17260551772673418975u, 12172759318655059174u, 18060748744986551404u, 3547496u},
    {127961364440389647u, 12869227393934662555u, 9335988314792887516u, 281612550989040892u, 0u},
    {16704396762662708717u, 28942732959948795u, 18244584222493396994u, 281612550u, 0u},
    {8219203230041567975u, 7964894462657826326u, 5194834656039319012u, 0u, 0u},
    {2987445008974636329u, 725307759560009207u, 5194834656u, 0u, 0u},
    {10655084776998494581u, 3594065036646546892u, 5u, 0u, 0u},
    {3584294101388385140u, 95827785405u, 0u, 0u, 0u},
    {15269945517571305139u, 95u, 0u, 0u, 0u},
    {1767710632520u, 0u, 0u, 0u, 0u},
    {1768u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1694826u},
    {6520483079085988544u, 13818947702025853917u, 9723994830070269766u, 8029656959681469760u, 3827353u},
    {11671450904825323256u, 17601106490346634239u, 3461018863244295654u, 10086607780572384537u, 220507u},
    {5901579165798765412u, 8293391221002534280u, 12369904178486372598u, 4903984040861168900u, 2083843u},
    {16218568798923525757u, 3604870224555805723u, 540659102414143284u, 1839879974362973574u, 3445915u},
    {4641869538083308031u, 14582909502627652829u, 16967724975511558062u, 17717676453236981143u, 1371557u},
    {9412530507698429275u, 5325430074147925844u, 13332702594810295264u, 3051719728272154616u, 2972164u},
    {17667928229927239558u, 15289869829139710723u, 763172068322347628u, 3225360889373641788u, 3601720u},
    {4991357273108543526u, 6791747262133216493u, 11437374389685816673u, 18008780925734578119u, 661966u},
    {8237483240729299850u, 17804603197861342541u, 14381361620642659371u, 16873688140271415166u, 1721382u},
    {15185729494700143639u, 12127255167882059279u, 12013782951321701115u, 5580188651001229507u, 1686154u},
    {5895308161771698293u, 15122911067001769501u, 5474151946605438577u, 4714847669352366146u, 404240u},
    {4753865208161272047u, 13326000853950014528u, 9179431639690934570u, 15355724446617854386u, 2030475u},
    {12568343461178903180u, 16344625923247726825u, 8030826676902615322u, 8396136576428430424u, 1825361u},
    {16773255039635850860u, 15253910089303010499u, 5086944251424452726u, 9184986418422114989u, 2540774u},
    {13278910929666196444u, 12933600625787163619u, 13276228207989246074u, 11359911280866807682u, 2655462u},
    {6651197661655153115u, 15549366715780155631u, 4060760627606082839u, 8479723141708940706u, 1124352u},
    {4428044684881342985u, 5230394386554759187u, 8992668537133962729u, 1461892522831045343u, 3834150u},
    {17869860139078377843u, 3374083209300813499u, 2942841243746473782u, 6051507890400124688u, 2704200u},
    {10033813872956417634u, 2539836087346527344u, 16235198757108165880u, 6318894372675363691u, 3053951u},
    {7055614280260961128u, 10868880492776587180u, 10009175809641099415u, 6181230952053418291u, 1030367u},
    {14051739937694508037u, 1427630852496523806u, 11498618603827460180u, 5783614445566461721u, 3263308u},
    {1078589072141489116u, 17620473161155982837u, 578627315446755204u, 17354019982396008055u, 3841923u},
    {9570347712348027252u, 1525397662054829339u, 1276618416521254756u, 17941154309092046532u, 1319698u},
    {9031729467879397569u, 3156436325716358763u, 17350610872010237911u, 13571171828332192624u, 1129521u},
    {7511076989564967896u, 3038379286651224773u, 14444696400957409123u, 6650134649873422426u, 2168511u},
    {4134794397124731988u, 14185759347848796193u, 6599990515843244924u, 14307405593597889951u, 3457596u},
    {14636201058428623548u, 11490025247617538344u, 7879805043712865544u, 10584190132367166100u, 2582143u},
    {15884771284295558572u, 2617839296476282791u, 1947223333544397460u, 8406313050066551311u, 2559771u},
    {11029378081588543039u, 4026972416804154943u, 13211396643187127021u, 14891083820743771438u, 3821182u},
    {6015993840895279071u, 13697294472599484003u, 11195357583999037768u, 2232216202441987512u, 194209u},
    {3159444459209798833u, 17877024955979576788u, 13867879546551133457u, 7785802682048244348u, 2484749u},
    {13471050154735552371u, 5247810365790776236u, 13217991089412973293u, 11863280958896389920u, 2855087u},
    {2054841791635616685u, 4729019952003681509u, 9058467602786769245u, 17778835204390728397u, 2436732u},
    {12000406374763851174u, 13517969394516375886u, 9575470750092056398u, 9412437014289685307u, 175515u},
    {8921463153718397775u, 8099270816369458344u, 4456134725598274324u, 7713400251756823298u, 2416745u},
    {6181713060312353472u, 16894535644389831612u, 1421012062076410683u, 11069392972022791650u, 553453u},
    {16401325341321406755u, 1847896166564708252u, 9100179110434845224u, 3613089118813616544u, 2114825u},
    {10902053434079780911u, 15252054443032930004u, 5717083997034055315u, 9982959616382827089u, 32439u},
    {15224724567724218444u, 12802083254192966491u, 9734319423105176778u, 5837263520986129496u, 3017564u},
    {14531445883740212654u, 14965022562797874257u, 7354955203855749979u, 13746607103877610650u, 3392056u},
    {3741938596612862547u, 1118867262038555441u, 12801545025644028629u, 7556562182606803374u, 2223678u},
    {9399980006213533009u, 3210400891591660128u, 17066319293071559387u, 905710754980035722u, 28774u},
    {5186860230412114600u, 16063813655301984457u, 11404413726784571523u, 11313573051474373625u, 1629941u},
    {8258289323565539810u, 6270115085484493004u, 13741132429398333114u, 4425580352109423367u, 3324264u},
    {5362581478346363376u, 17873282214860306175u, 48588571610586724u, 998070574160089529u, 2066238u},
    {11128950791671138189u, 5896282539927968424u, 12396767947107556642u, 18124571468099355986u, 1760980u},
    {4751431036387180186u, 10015049076594555656u, 5609648723999321974u, 1545693840299979170u, 646990u},
    {11151429421539143922u, 17876336335341059814u, 1844951298609150265u, 10820573966183133583u, 17667u},
    {8059355454028320465u, 6686272268540841714u, 15339084834957429420u, 8719294788037404448u, 1204969u},
    {2518366959622077170u, 8694729900456186321u, 13624476533529694251u, 15586668075671482688u, 3235167u},
    {11965172429963804445u, 4936186594385742079u, 11886391248624791909u, 16488809753918948192u, 1509239u},
    {15752610376918433030u, 17862206696150802100u, 16423660443389603582u, 17177547943094719851u, 608035u},
    {1029753126688132741u, 3441825956511016418u, 5747164501175980382u, 2028828916272388138u, 32950u},
    {4306315998623294647u, 4438039256738315630u, 18412347136758744717u, 8863691888911193773u, 2203366u},
    {7622189601155226530u, 16288341854478105224u, 15073447567899247056u, 9047844192307397008u, 1298525u},
    {3507644113593435741u, 8487612302568862791u, 15118276454626650892u, 4131236427558050239u, 1910130u},
    {7317430959961543217u, 4920418040643256451u, 7126352070185109948u, 17977576598832807317u, 1210674u},
    {14945697323946490142u, 7662142261060443519u, 9702184974977113928u, 7804553167508487924u, 3624857u},
    {8412902969280950503u, 15524058626189795152u, 12001577806000107134u, 12388715397673024807u, 3900383u},
    {13190378595475918658u, 5874050115792740462u, 13534260570030654036u, 1873389230327361279u, 476160u},
    {233060272994809435u, 2357860250831434684u, 7836838008906935773u, 11321825867486212722u, 3356229u},
    {8256140402054361206u, 1633532036277188125u, 3630850249517783570u, 11951414524995697442u, 934039u},
    {2842638492308067216u, 18374813321117406543u, 16188022648673700456u, 9817062779497477416u, 2170527u},
    {11386019006752213107u, 15254756833779669313u, 8077811684765077129u, 4291437214128887575u, 1622732u},
    {15828613359999692542u, 3709015291235274457u, 4460837537034766772u, 13288531429174396286u, 869736u},
    {7160027745900136211u, 13823262546747662462u, 13995354030744040338u, 2105714037792133423u, 958264u},
    {11798816099433658122u, 9296684761182741488u, 10365005015080838033u, 17887960174274891375u, 917552u},
    {17330631361600153369u, 7275870783393909570u, 14374725071348379659u, 8880009931471416648u, 1917253u},
    {16878820466516429369u, 8572814317998226207u, 8039967228253872574u, 6088204983481508414u, 2533203u},
    {1934739969660131787u, 1662847921768730665u, 14089889908352116740u, 695247699857309664u, 3649933u},
    {11782475138204395108u, 3688725537815995746u, 13203282762715252081u, 16352345633204148160u, 2767643u},
    {6368807209586092771u, 11167600740221911827u, 14154357336449815383u, 411341988650379037u, 3499663u},
    {11105358218663828647u, 6906986779910789808u, 3458477588870831712u, 136614982154500515u, 3900892u},
    {1572390736067489480u, 16324127120050755602u, 6953352368283030435u, 14555535158143311118u, 3493292u},
    {15226864934109428265u, 10777515314243552921u, 2344046038676258064u, 15917110566398418065u, 3718276u},
    {12378213194078827811u, 14026368510978357837u, 2637000455355243831u, 17938873423090655151u, 3902570u},
    {16133362058591842428u, 4203270820570457767u, 17353004725795809312u, 11961492744216719547u, 221667u},
    {784983187721112014u, 13231193119334013314u, 7282468712190049525u, 7858366796514224743u, 927576u},
    {14445121729416633034u, 1519917074661017968u, 10403734168911634803u, 12771304909652526679u, 691743u},
    {9945782852418700640u, 6943462845485625346u, 295763428092594461u, 3255352150563842096u, 3474892u},
    {540182104081763977u, 5921116144612731286u, 14718058831904816114u, 11953603462921242321u, 1728949u},
    {4898112119081432221u, 17092690235010071617u, 8820751662979362963u, 13218433200613911806u, 3192370u},
    {6159789931060881952u, 3946352172236711225u, 16717947067022515324u, 17136538632585942193u, 3599645u},
    {2869570662772356395u, 8758188173069352979u, 9457987207881870765u, 8641255437721171235u, 3357886u},
    {5777985750342102290u, 10735609210976069480u, 2929619872438354458u, 18292513363907715517u, 1678526u},
    {14248406356583871739u, 5467131391233972087u, 13715403861520221010u, 13866021413117744474u, 3819147u},
    {3455778055543645930u, 14748891795032138497u, 799408594509026906u, 8861477313782105218u, 1392118u},
    {1118790032458618386u, 15101666895257662597u, 6616255070234723124u, 4132962913489774059u, 1279109u},
    {17261366427914262329u, 8491500653671996920u, 6415117257354830541u, 3338244726243026520u, 1384516u},
    {16182085872871998396u, 7450679729489755542u, 14908739289739243426u, 17247304790720977483u, 318353u},
    {4944788005040019563u, 5961211489976473261u, 11189535442778580280u, 9085129442342322383u, 2293051u},
    {17205482684651743868u, 16170295293055738670u, 7100941307359952554u, 9265671370884869011u, 3227340u},
    {10867578130417141736u, 11505812969304534904u, 3638628595121727606u, 8922617990949653283u, 1933963u},
    {13763910745144875178u, 4540907016620509893u, 9621590962163912685u, 3062094279024614848u, 1840793u},
    {8556043909833510900u, 11264165978312076951u, 12405183342880241256u, 13652841913594150209u, 2689864u},
    {2062845810527448941u, 3003332565500986607u, 17379976863772295505u, 5381881205260593846u, 628456u},
    {14759996971367899025u, 7748417920983770575u, 4260805757521364369u, 15720148472643758463u, 2861407u},
    {2735609345998128397u, 16498199175707704347u, 11153679462656909364u, 12951092991128970043u, 1919446u},
    {12046181269887254180u, 9030091274806295107u, 2584292545429578806u, 12285198528524147615u, 165952u},
    {14114342418240350174u, 16655948150695927491u, 625825109025934257u, 13766061747601954552u, 3299288u},
    {8880309890203181484u, 18342217773340881216u, 13539983199835167884u, 4672547153554910690u, 2220767u},
    {5160617449051327507u, 5734164436909752011u, 6797997127955967102u, 12723102475844203629u, 1051020u},
    {13193417342821639386u, 13843666898221111364u, 14455826952864686911u, 19387909679452688u, 736627u},
    {2173857675364363876u, 17170775993126165630u, 10287600134671528315u, 1166509874373019331u, 3191114u},
    {3568241330385846365u, 2103282926826159732u, 8643398204663834839u, 6976394692075623312u, 1274470u},
    {15962649220849151765u, 6549246259119923456u, 5970599223695743264u, 11840955251116196808u, 2878707u},
    {18147464113820337072u, 5202948149576897015u, 5903646542046486581u, 269275565246935261u, 2531017u},
    {6729504316477532231u, 14594125143069290235u, 8290127888044714743u, 14025862266472503277u, 2440243u},
    {8592123778852408541u, 7994527123988830949u, 15432287200302464256u, 15177109300089390043u, 2291164u},
    {7482962269589133332u, 3685632320314419036u, 3838971607287908635u, 10202385290463844947u, 2523605u},
    {10128113046425256707u, 5102588321985617008u, 8665185131131830599u, 12296343292228268203u, 2587377u},
    {50956410513612774u, 1923765916047473535u, 14016194668340774994u, 18350357579271241434u, 1385030u},
    {1283499051533077514u, 1374946850243174382u, 10070998354637934034u, 12203282704704588703u, 28358u},
    {1821794211003557456u, 7515154284197541374u, 3123314744109012113u, 14051753962367672480u, 3582976u},
    {3878526780973974375u, 12202758234488625772u, 14361928354828572261u, 12748230806021314252u, 2973662u},
    {9292835321578192162u, 18330075162707683840u, 12891544815418735163u, 9926744777820073330u, 1376999u},
    {7004317868747716235u, 6741122592586599618u, 12649923272645359593u, 14076631995465446276u, 322592u},
    {12188431477959222465u, 14985315137362870746u, 2589091817884735556u, 12255741772588607227u, 3850468u},
    {9643166116561629597u, 11444835890524846371u, 7016468418770675959u, 16067814486435751834u, 2971358u},
    {12305623516571138979u, 291771258568240256u, 5651461879623923592u, 11439911754637797840u, 2994046u},
    {565156304692772612u, 2107061042941123672u, 15042880322530789166u, 11224157487625655622u, 115443u},
    {648854778624924044u, 15043122893670957610u, 7247015746423966071u, 14701878742437557683u, 1681400u},
    {3743382907451010679u, 4278725973842124059u, 9679008153802175597u, 11055828257990388190u, 3748461u},
    {12894209676789310020u, 3072486985524410055u, 10154031793956020786u, 10229267671140948613u, 681440u},
    {15533283755899404347u, 1802358206727650941u, 18338934910476631213u, 2534586150838334067u, 934412u},
    {11741165439337297429u, 8621221557346667435u, 7064067379910651051u, 9745012056678260600u, 1823655u},
    {16318069712193218035u, 6872746447523625019u, 563309706582461854u, 18048039016290736849u, 2028034u},
    {12863831296075506756u, 10572148938951416749u, 1710747227483110265u, 10557819371756299149u, 419377u},
    {9739728236975264603u, 945726966320071356u, 7090234475579389989u, 7285553148577940998u, 875356u},
    {17257070097606713210u, 3140024939463839406u, 15537993111623726825u, 16877624480266076270u, 3630171u},
    {10755797354635963212u, 17172408334805606229u, 17810010556038147092u, 3237498989927255940u, 2360550u},
    {13809386488627086506u, 4855310930202681274u, 18343529762273698066u, 14815351242735920951u, 705174u},
    {1744960361622463932u, 909022828283730873u, 1608226550488125842u, 9164322621937633174u, 1966311u},
    {3056248166608605336u, 17548274043178913377u, 1572432748253357721u, 17113921831939563356u, 1609636u},
    {8437775108254453556u, 12040762332267337811u, 14103183916936182522u, 3200226698126580563u, 3686887u},
    {6908634809296509388u, 14709430083961432196u, 13935407527042844272u, 212126252193769357u, 1178796u},
    {17123794434878404527u, 460470591756419704u, 14766686768765767805u, 15153839696304105336u, 431886u},
    {15817597099303857142u, 2429008175165276256u, 13158673371133478607u, 17301789474767562459u, 2093932u},
    {5907247799058530331u, 15649246324361502442u, 11104138821883446311u, 7820846401109757351u, 649074u},
    {15175442351942554813u, 13576199910412687873u, 11351405692007757422u, 3182507447452574538u, 3238494u},
    {5919703648757498705u, 18393213369977789336u, 1912573969072122066u, 11372781937139437340u, 2305326u},
    {16897201491876820655u, 15548357758125912757u, 17121237711153727542u, 5230672540832061874u, 1249944u},
    {16060233414218495066u, 14067014625043534118u, 11384802476705895253u, 17460995159483701864u, 680934u},
    {13910538716997618902u, 4960096716024046913u, 5603958677203868203u, 5272765397458821827u, 2583448u},
    {17526408005178472839u, 6592329960926459210u, 2989733823023825435u, 9271028246211277999u, 1192276u},
    {17759787526398456657u, 13308139268961230084u, 10584668242209140807u, 15009973179397265063u, 1562213u},
    {9215712449966325065u, 10412167731179900187u, 2876793194691390501u, 18187331455967435071u, 535218u},
    {15735893713328448570u, 5415459459769155760u, 14097875443358219350u, 14349334261204633398u, 1017653u},
    {4059868951350713373u, 5340761965636875053u, 9874738500792007135u, 14430291206381764207u, 3627698u},
    {15340386402540699872u, 17751743350290867723u, 6641273826448159010u, 2949222992530116639u, 685307u},
    {1596811776039147307u, 136037856213067726u, 4047635338287570417u, 12694778236465461400u, 3168135u},
    {11598924518756578836u, 8196762343479171776u, 14285482539554246449u, 10146504953540651086u, 2527694u},
    {619190801874688813u, 14863720252416673310u, 16659339257807876930u, 8189135860747012912u, 1308766u},
    {13105644243542872761u, 13369573262231290465u, 14338262523883600727u, 6293153160943238847u, 2179426u},
    {5265147644117535889u, 1238361948138663348u, 3384816382660993245u, 10920900019669860010u, 1301521u},
    {2779677962459328608u, 10933274182773433533u, 18422172017864006895u, 10040014406986441652u, 3442078u},
    {3280367032340809724u, 16276707757740468568u, 18331261940207079727u, 9430982366918392112u, 696511u},
    {15205620300283059188u, 2356806490978881667u, 7821491226525070408u, 17090498156581426712u, 679725u},
    {13837036797384338615u, 2622510888386242831u, 10212344643340134513u, 1093402640774919421u, 1554630u},
    {3972714706084701288u, 6572761763155946733u, 68280651847924622u, 6730034108360011769u, 2069287u},
    {4978530906217486424u, 5534856984624270772u, 5438645457199419396u, 2199899435571926405u, 1314488u},
    {7661811547890802921u, 15506598780796743785u, 12111007152655513723u, 14796054803699088636u, 3423837u},
    {13401303554850801783u, 15927401618486578698u, 14302853256216020189u, 423446629874791973u, 2545637u},
    {4807803735146467127u, 15277889140634409757u, 13316545273478702085u, 10423252256128635175u, 3060539u},
    {14250199471371374661u, 16523295978549457411u, 9627654564192810282u, 8415137898483499789u, 400390u},
    {4165004525952904161u, 18415147510859217894u, 15772520129927110619u, 17949726815718866529u, 155705u},
    {9678196844469058557u, 11660702773711488227u, 8360724989436224387u, 16359946114845365233u, 3870299u},
    {3090434160274586276u, 12018722636175844286u, 13931320866511783878u, 2593410222829157878u, 2402799u},
    {2171871799474869565u, 8929701174492127542u, 13697280481425080507u, 8186831947092832227u, 557232u},
    {2241892540007104279u, 2137223747089089771u, 17688935958212196253u, 14637970713979884275u, 3304327u},
    {15084640703991326090u, 16366039243067849166u, 10007851334870344270u, 18219467786700659047u, 2397721u},
    {5047802739417560963u, 12446128886468827828u, 9424924548366143192u, 2566245955194104486u, 3398026u},
    {10403244460962044063u, 10722694335543356883u, 620078124984122418u, 13537452603636580960u, 3770745u},
    {933214355178528953u, 6891860357091721203u, 15584821751404672510u, 15489883105636250830u, 3073362u},
    {11650635113609934758u, 16774525737924885237u, 11250739729596126999u, 13531463622842271272u, 3732608u},
    {13436062758697716256u, 18086291003488233899u, 16243571963912050015u, 14912718849848099300u, 356521u},
    {2989917560426903664u, 5017945893925917183u, 16598144879526069679u, 5843241783628784668u, 695298u},
    {15703493034154850981u, 13105066071642125573u, 8269421483856706330u, 3543648097962672751u, 3511534u},
    {8043384986984385222u, 12079950904528967664u, 10828454514208870315u, 17286541347612554398u, 1369494u},
    {4471948545911513475u, 3272466190473848422u, 5411476014929933482u, 5285467087383761464u, 376135u},
    {17039697976712453411u, 1580182522250867923u, 10714710577673602518u, 5050970054022587349u, 855291u},
    {5003492868897572723u, 39147644959920785u, 2467945720384254954u, 17958118254680573234u, 3407806u},
    {14507650864935980793u, 18157621502373118480u, 17245634695429221109u, 9070062197833962106u, 2792923u},
    {8218060802537593171u, 16023031792918488728u, 15900644673286931129u, 5455839897713234499u, 2727299u},
    {2104988227129338622u, 17986845675346528037u, 2324283921570176810u, 1995864831145378156u, 2555928u},
    {12107624164032690752u, 4821758922984699407u, 18228294117151128580u, 5955871262792783889u, 2565038u},
    {12898832660579351775u, 5654268918474910478u, 12004869838920354557u, 12801510750194455735u, 2437861u},
    {11847978596590282657u, 12514417523279565472u, 7500245285778954902u, 15177065358720654951u, 3200970u},
    {13112220186992544684u, 12243436796605048503u, 2894708669451354261u, 9642707496599102910u, 3330793u},
    {18141040345940887940u, 13508945992699696966u, 2855821581726120529u, 15697940201906572867u, 1910218u},
    {13756797946157932023u, 16210648383368196134u, 3235285071468702716u, 5295441683037672842u, 1322912u},
    {4765463514125386344u, 10012805261853283617u, 7103815947768428711u, 5356665383198148197u, 707690u},
    {16171258230347382408u, 13328910822717536404u, 14411984355169591355u, 17595107526924605279u, 548170u},
    {4749900625754156385u, 9592449691010264101u, 15383625322747173432u, 14637803558993363899u, 770552u},
    {5308894532054452242u, 7978732002140321325u, 7566410439736173280u, 17740382323507560857u, 2060285u},
    {18204260834959538923u, 10671315131316290848u, 1083403426051724852u, 542408726119780559u, 3555220u},
    {3841584351550250270u, 18228307259579940271u, 3984793326202627750u, 10658048557583548990u, 41236u},
    {8631105509328027896u, 735936673078229005u, 12063919125282139127u, 17150468061623520812u, 2001937u},
    {999999130118288799u, 18150887648273008353u, 4740831759538323894u, 3063348186234131252u, 1257209u},
    {2021970363754745967u, 1981428071440203411u, 16818468352021138669u, 15515574133888018737u, 3628861u},
    {11023498352519687936u, 9042580609917884981u, 1379966131966612818u, 5255087456392451243u, 1739227u},
    {9789872831207235577u, 13732789647221491894u, 13298111613670397743u, 3562905188468641962u, 1974291u},
    {11078524020182030090u, 1781697808685166684u, 15461068793091685531u, 13799419705611169068u, 3157495u},
    {4741427662173485904u, 14232809316878613118u, 5366729494208533469u, 10290423869364204158u, 757016u},
    {2039497965652923325u, 8023007236270356037u, 5355864831470125161u, 1887461935688253515u, 3009238u},
    {6522165516418729189u, 6668238426533148978u, 6900597190886802385u, 199625833206199391u, 1680889u},
    {11367270680539169502u, 3230626719000185688u, 13142678246821307698u, 2985368284953984783u, 2192587u},
    {492558625943501772u, 12729059499912750294u, 11124408178042619537u, 2778634667674972457u, 26089u},
    {11493856733348911540u, 9797723103107780855u, 3082124087983032193u, 2522497051212251436u, 3306269u},
    {15435323869622119021u, 2168791697983939002u, 13357880265209739438u, 5105021483259292176u, 408616u},
    {13496578800602479167u, 3670915907895047751u, 7423258188121964063u, 17445475397060004897u, 3739775u},
    {11949099682150128712u, 13910505518915712791u, 8388311865488266195u, 9436473914694364215u, 2102636u},
    {5039185764063100219u, 7324937393249854807u, 8596625302574035284u, 17260551772673418975u, 2329714u},
    {2081587698989479700u, 9488128348201819182u, 127961364440389646u, 12869227393934662555u, 1568988u},
    {13939954471414720796u, 5741642332274774816u, 16704396762662708716u, 28942732959948795u, 2090294u},
    {4458334854681685311u, 4232042807760050809u, 8219203230041567974u, 7964894462657826326u, 256512u},
    {10130328368236673294u, 2936947854742435251u, 2987445008974636328u, 725307759560009207u, 3428406u},
    {14568140289531192084u, 9986771653816261977u, 10655084776998494580u, 3594065036646546892u, 5u},
    {1303492864762456670u, 16194937712193557066u, 3584294101388385139u, 95827785405u, 0u},
    {7968834245744663050u, 3824925371669121156u, 15269945517571305138u, 95u, 0u},
    {10075841910182007529u, 18053988140674653715u, 1767710632519u, 0u, 0u},
    {16846570551553151647u, 13108856226502528479u, 1767u, 0u, 0u},
    {5169403991708033428u, 32608505634471u, 0u, 0u, 0u},
    {9327309686551918131u, 32608u, 0u, 0u, 0u},
    {601520758065208u, 0u, 0u, 0u, 0u},
    {601521u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3032906u},
    {6813411472018392636u, 2475020607870878274u, 6520483079085988543u, 13818947702025853917u, 1032894u},
    {16585245098858652246u, 12486639416749945338u, 11671450904825323255u, 17601106490346634239u, 366888u},
    {15986041586919514763u, 15373007522506953865u, 5901579165798765411u, 8293391221002534280u, 107906u},
    {14096549836544842827u, 16482775085849014296u, 16218568798923525756u, 3604870224555805723u, 1478608u},
    {3680631783032940564u, 8573260314136600586u, 4641869538083308030u, 14582909502627652829u, 3535892u},
    {17530850727238022187u, 17133491705435138405u, 9412530507698429274u, 5325430074147925844u, 740504u},
    {7385221098248665799u, 236247505378978080u, 17667928229927239557u, 15289869829139710723u, 993856u},
    {4627584462873000022u, 14189830652144196552u, 4991357273108543525u, 6791747262133216493u, 345723u},
    {12303435377220277972u, 6709982898029943045u, 8237483240729299849u, 17804603197861342541u, 1169819u},
    {15020898690882440372u, 18126555992985462057u, 15185729494700143638u, 12127255167882059279u, 3408401u},
    {10120263540084716019u, 4007192837192860278u, 5895308161771698292u, 15122911067001769501u, 3653953u},
    {14487731430165917311u, 11437857107328758273u, 4753865208161272046u, 13326000853950014528u, 3231446u},
    {9582068860728580954u, 10400175999049389436u, 12568343461178903179u, 16344625923247726825u, 2697372u},
    {15849317301214543269u, 4716758885985598319u, 16773255039635850859u, 15253910089303010499u, 1913144u},
    {5239207946025223018u, 74615368947715167u, 13278910929666196443u, 12933600625787163619u, 3089108u},
    {10646964227361105394u, 13622477684417629839u, 6651197661655153114u, 15549366715780155631u, 2290247u},
    {8068534129099819448u, 6367307712493831614u, 4428044684881342984u, 5230394386554759187u, 3221917u},
    {9265461279900018221u, 1064752124833879208u, 17869860139078377842u, 3374083209300813499u, 966040u},
    {3188856633739919508u, 7441351369605628757u, 10033813872956417633u, 2539836087346527344u, 3265692u},
    {11770693646740491250u, 16343318836418246503u, 7055614280260961127u, 10868880492776587180u, 3173273u},
    {16492134886402724353u, 8604658941360119059u, 14051739937694508036u, 1427630852496523806u, 2082764u},
    {14612612591949613128u, 14558593157163430204u, 1078589072141489115u, 17620473161155982837u, 660722u},
    {2039133135819818427u, 7613615804569716447u, 9570347712348027251u, 1525397662054829339u, 3142006u},
    {18443442532834604438u, 8185001334124651020u, 9031729467879397568u, 3156436325716358763u, 648371u},
    {2010736664545437653u, 15343019476468169482u, 7511076989564967895u, 3038379286651224773u, 3386555u},
    {4125624828739999898u, 17962058526400255164u, 4134794397124731987u, 14185759347848796193u, 1781766u},
    {9581930628913130047u, 10618705377689535132u, 14636201058428623547u, 11490025247617538344u, 1288352u},
    {4753603102061351175u, 2242164176760423230u, 15884771284295558571u, 2617839296476282791u, 3458862u},
    {2259025435762639244u, 13571673582518751466u, 11029378081588543038u, 4026972416804154943u, 344321u},
    {6339989106174883648u, 4525397734138958464u, 6015993840895279070u, 13697294472599484003u, 365464u},
    {789478151396412089u, 11467114123563212436u, 3159444459209798832u, 17877024955979576788u, 3234369u},
    {15826031746016780108u, 8301394629932825981u, 13471050154735552370u, 5247810365790776236u, 2454435u},
    {121919657157286591u, 17870414412270910538u, 2054841791635616684u, 4729019952003681509u, 2341839u},
    {10970181486415721554u, 15565230072070132241u, 12000406374763851173u, 13517969394516375886u, 1562350u},
    {13026969388481582198u, 5660651816262534385u, 8921463153718397774u, 8099270816369458344u, 1792112u},
    {1580929975628493760u, 13228469163881005915u, 6181713060312353471u, 16894535644389831612u, 2518401u},
    {10208638815342373530u, 1362113480142541968u, 16401325341321406754u, 1847896166564708252u, 2596778u},
    {11985595473654122725u, 13001832535679848322u, 10902053434079780910u, 15252054443032930004u, 2596073u},
    {11301990167482935380u, 12028746653586860039u, 15224724567724218443u, 12802083254192966491u, 2661748u},
    {14697204116206183479u, 10214017306066273553u, 14531445883740212653u, 14965022562797874257u, 2060165u},
    {2238453987203376767u, 9474472908982662641u, 3741938596612862546u, 1118867262038555441u, 2161181u},
    {17805890333322536425u, 1525448677602936967u, 9399980006213533008u, 3210400891591660128u, 3633583u},
    {6620363638315021824u, 4531012947882258894u, 5186860230412114599u, 16063813655301984457u, 59869u},
    {4313049729883595798u, 17247823311442913607u, 8258289323565539809u, 6270115085484493004u, 162570u},
    {11388125036100031616u, 11636873821952068240u, 5362581478346363375u, 17873282214860306175u, 3231866u},
    {14097314984444359675u, 10290499056130502714u, 11128950791671138188u, 5896282539927968424u, 3854398u},
    {10064478537493642447u, 4001003983613561934u, 4751431036387180185u, 10015049076594555656u, 328134u},
    {10826432734406704729u, 3722984335185755197u, 11151429421539143921u, 17876336335341059814u, 3088545u},
    {9523814850939246737u, 6767646745454726133u, 8059355454028320464u, 6686272268540841714u, 2592252u},
    {2821490998595688445u, 16241790003951436689u, 2518366959622077169u, 8694729900456186321u, 1966211u},
    {18272278921599314261u, 12909679387122346977u, 11965172429963804444u, 4936186594385742079u, 3468415u},
    {1213156506406493014u, 11337670487983686814u, 15752610376918433029u, 17862206696150802100u, 2988008u},
    {9529965151820841937u, 11913760994114797978u, 1029753126688132740u, 3441825956511016418u, 2305340u},
    {5084938464653480468u, 8864384906077486972u, 4306315998623294646u, 4438039256738315630u, 180281u},
    {9595921821169565724u, 17291089914193498360u, 7622189601155226529u, 16288341854478105224u, 3083134u},
    {15216007741973496120u, 5933425076984934379u, 3507644113593435740u, 8487612302568862791u, 1111396u},
    {13410538186955737715u, 6808851369029820416u, 7317430959961543216u, 4920418040643256451u, 1303064u},
    {2082148064105559198u, 17777481743276866664u, 14945697323946490141u, 7662142261060443519u, 1717154u},
    {842207648564435736u, 16679233687401746338u, 8412902969280950502u, 15524058626189795152u, 2026644u},
    {9686752514834624465u, 4234446392556958371u, 13190378595475918657u, 5874050115792740462u, 2819860u},
    {14644968174249517310u, 2083032336500128817u, 233060272994809434u, 2357860250831434684u, 2616449u},
    {7445850599405654788u, 13305609238161990974u, 8256140402054361205u, 1633532036277188125u, 6876u},
    {7752818820500185719u, 5646412993613346033u, 2842638492308067215u, 18374813321117406543u, 2743274u},
    {9692538877979532775u, 2516830361874538777u, 11386019006752213106u, 15254756833779669313u, 1847371u},
    {1377311712155452835u, 5583000990352361340u, 15828613359999692541u, 3709015291235274457u, 3266814u},
    {13013630667376221563u, 1973547738931236548u, 7160027745900136210u, 13823262546747662462u, 68040u},
    {2653756363089997721u, 2623884100525319166u, 11798816099433658121u, 9296684761182741488u, 3800745u},
    {6592621915238573460u, 7464243466965585033u, 17330631361600153368u, 7275870783393909570u, 3795695u},
    {14879962092460600079u, 17229266498580546749u, 16878820466516429368u, 8572814317998226207u, 299416u},
    {14847813188963255544u, 11587130018269696997u, 1934739969660131786u, 1662847921768730665u, 747462u},
    {5695088492529823673u, 2784740751479316863u, 11782475138204395107u, 3688725537815995746u, 3834349u},
    {10448063464220809713u, 4720942157204222629u, 6368807209586092770u, 11167600740221911827u, 3334753u},
    {18269724497893535722u, 9241552599132443887u, 11105358218663828646u, 6906986779910789808u, 2120204u},
    {10009702429325441417u, 14174762198445219040u, 1572390736067489479u, 16324127120050755602u, 2219025u},
    {4137420533449922941u, 16856500290412997196u, 15226864934109428264u, 10777515314243552921u, 2558460u},
    {16392421612421568691u, 1258369751416537598u, 12378213194078827810u, 14026368510978357837u, 1297267u},
    {5157976436214406232u, 13269354596830669995u, 16133362058591842427u, 4203270820570457767u, 2420666u},
    {5411712367391271845u, 6987508516994740639u, 784983187721112013u, 13231193119334013314u, 363619u},
    {17560552440344736953u, 13221642966010130469u, 14445121729416633033u, 1519917074661017968u, 1405875u},
    {5743711161141809509u, 1785152698871585065u, 9945782852418700639u, 6943462845485625346u, 671849u},
    {8671743725318024995u, 9999277493682029696u, 540182104081763976u, 5921116144612731286u, 815344u},
    {4074951297389133494u, 15462116527962749966u, 4898112119081432220u, 17092690235010071617u, 2994679u},
    {15918474323707203552u, 16866926483684532532u, 6159789931060881951u, 3946352172236711225u, 2126082u},
    {8440536875405675139u, 15380285431507106004u, 2869570662772356394u, 8758188173069352979u, 3853541u},
    {15366707235936660638u, 8090486552490850187u, 5777985750342102289u, 10735609210976069480u, 3405036u},
    {9765823409473179696u, 16005767327498816419u, 14248406356583871738u, 5467131391233972087u, 2664026u},
    {11129898294636982138u, 5642788672271622038u, 3455778055543645929u, 14748891795032138497u, 2256752u},
    {6391588864077570929u, 14122052376096517072u, 1118790032458618385u, 15101666895257662597u, 3293922u},
    {16345781235894651266u, 2920037863467283789u, 17261366427914262328u, 8491500653671996920u, 1558407u},
    {4188112432308228554u, 10289513419431064381u, 16182085872871998395u, 7450679729489755542u, 2845422u},
    {9411011676124619220u, 16982233072773223836u, 4944788005040019562u, 5961211489976473261u, 1593464u},
    {5481003378346292284u, 12228031629949004027u, 17205482684651743867u, 16170295293055738670u, 2637620u},
    {13611744341104265505u, 17054186592219606113u, 10867578130417141735u, 11505812969304534904u, 69312u},
    {10190122539074320459u, 17546263899175620937u, 13763910745144875177u, 4540907016620509893u, 1256661u},
    {9381856012822321022u, 15560210140834459074u, 8556043909833510899u, 11264165978312076951u, 2654734u},
    {11874578281518761119u, 14819125809384250477u, 2062845810527448940u, 3003332565500986607u, 2073827u},
    {12807211039839611965u, 14348208932660955174u, 14759996971367899024u, 7748417920983770575u, 3744169u},
    {10532880253971531397u, 2792805486281980856u, 2735609345998128396u, 16498199175707704347u, 1240978u},
    {3879724979499624148u, 10670465911820187040u, 12046181269887254179u, 9030091274806295107u, 577008u},
    {12241836090200103888u, 3464312179856990176u, 14114342418240350173u, 16655948150695927491u, 2146117u},
    {6629418051058851251u, 14084863516504513239u, 8880309890203181483u, 18342217773340881216u, 2255926u},
    {16865340848071490205u, 1422516901746440478u, 5160617449051327506u, 5734164436909752011u, 466686u},
    {4217125785501567802u, 2715030495460155351u, 13193417342821639385u, 13843666898221111364u, 1142131u},
    {18099186593203930231u, 10740733784223564610u, 2173857675364363875u, 17170775993126165630u, 737945u},
    {8860572745026127903u, 15078735245629386252u, 3568241330385846364u, 2103282926826159732u, 3472851u},
    {8983320211652564763u, 4127538912866574729u, 15962649220849151764u, 6549246259119923456u, 802384u},
    {10696922920890746732u, 7953641399469137468u, 18147464113820337071u, 5202948149576897015u, 2086609u},
    {11741494801116372678u, 316472625983363572u, 6729504316477532230u, 14594125143069290235u, 3696683u},
    {439094870690751268u, 17055904544030375754u, 8592123778852408540u, 7994527123988830949u, 579778u},
    {17829612420126854096u, 14161729470891030744u, 7482962269589133331u, 3685632320314419036u, 3174367u},
    {18065945887590241507u, 14370822703329799006u, 10128113046425256706u, 5102588321985617008u, 2725059u},
    {13629200046437557520u, 13850138983909518774u, 50956410513612773u, 1923765916047473535u, 317268u},
    {5003034260982658300u, 16644820765896064346u, 1283499051533077513u, 1374946850243174382u, 1147330u},
    {8071616851091767454u, 5548620239576932987u, 1821794211003557455u, 7515154284197541374u, 1356599u},
    {4095389606693146076u, 832242997583451117u, 3878526780973974374u, 12202758234488625772u, 1487865u},
    {16140727171134864411u, 992496923738368980u, 9292835321578192161u, 18330075162707683840u, 2155737u},
    {14303726160175308145u, 13407106008423360644u, 7004317868747716234u, 6741122592586599618u, 3761811u},
    {3544232941997270016u, 17526357405256045944u, 12188431477959222464u, 14985315137362870746u, 3238296u},
    {14541183926702976374u, 4939428895189485143u, 9643166116561629596u, 11444835890524846371u, 191951u},
    {4645601312732034601u, 3940331308838487751u, 12305623516571138978u, 291771258568240256u, 942758u},
    {6776524020601886949u, 18225905597451023907u, 565156304692772611u, 2107061042941123672u, 2989326u},
    {13782444461525838161u, 9133817152439773674u, 648854778624924043u, 15043122893670957610u, 1481449u},
    {11350717465111417033u, 2973643690928878901u, 3743382907451010678u, 4278725973842124059u, 2497353u},
    {13252486664334344737u, 10537075181314278189u, 12894209676789310019u, 3072486985524410055u, 49784u},
    {16663376271375180170u, 7384866286579376522u, 15533283755899404346u, 1802358206727650941u, 2513607u},
    {7811377576057844594u, 12233083667044592223u, 11741165439337297428u, 8621221557346667435u, 1478581u},
    {4723322161151249461u, 16951567668537261168u, 16318069712193218034u, 6872746447523625019u, 2804842u},
    {4917241728910402410u, 6629182269485832673u, 12863831296075506755u, 10572148938951416749u, 486711u},
    {6146461641977922347u, 14460114086699066595u, 9739728236975264602u, 945726966320071356u, 2252343u},
    {6864643897181928922u, 10253019609980822492u, 17257070097606713209u, 3140024939463839406u, 1230621u},
    {11129691559074968562u, 15655520770821257296u, 10755797354635963211u, 17172408334805606229u, 1488182u},
    {9522407936518747808u, 13716856260194021356u, 13809386488627086505u, 4855310930202681274u, 2403226u},
    {1494940308603638570u, 16072322447873367241u, 1744960361622463931u, 909022828283730873u, 2075092u},
    {9407788879667817448u, 9506689157241521534u, 3056248166608605335u, 17548274043178913377u, 387283u},
    {5496048284555169966u, 11442268448759297422u, 8437775108254453555u, 12040762332267337811u, 524802u},
    {6926783949106350960u, 18002875633111401261u, 6908634809296509387u, 14709430083961432196u, 1524660u},
    {7062767426443625778u, 16993935399779042210u, 17123794434878404526u, 460470591756419704u, 2770547u},
    {8512422758294058089u, 3147616325653957458u, 15817597099303857141u, 2429008175165276256u, 691093u},
    {17865143661191245784u, 7283664526615983420u, 5907247799058530330u, 15649246324361502442u, 1592271u},
    {964747540554676514u, 14588297246848055480u, 15175442351942554812u, 13576199910412687873u, 1004344u},
    {8893636192354059935u, 12910367873297917282u, 5919703648757498704u, 18393213369977789336u, 3034412u},
    {12075853214375980241u, 5247905970298653190u, 16897201491876820654u, 15548357758125912757u, 855640u},
    {5253774505943284047u, 9802559333860663980u, 16060233414218495065u, 14067014625043534118u, 3262381u},
    {13098298865367769764u, 8385271696870267417u, 13910538716997618901u, 4960096716024046913u, 1902173u},
    {14276299925425714026u, 1226232507949622951u, 17526408005178472838u, 6592329960926459210u, 2685675u},
    {11534817687008092677u, 1736742472128424935u, 17759787526398456656u, 13308139268961230084u, 1944743u},
    {7244572527003572828u, 12913610133971733993u, 9215712449966325064u, 10412167731179900187u, 603895u},
    {8660923604615011286u, 7897021193356293476u, 15735893713328448569u, 5415459459769155760u, 460786u},
    {11119951827574282216u, 16161582547277397952u, 4059868951350713372u, 5340761965636875053u, 1386435u},
    {14295858323659190498u, 11934091210922577555u, 15340386402540699871u, 17751743350290867723u, 3468376u},
    {15698745074897147790u, 11335629299436110454u, 1596811776039147306u, 136037856213067726u, 2941127u},
    {9182785489349056981u, 14662273417002078424u, 11598924518756578835u, 8196762343479171776u, 1076389u},
    {450177745758502950u, 2211418475947505496u, 619190801874688812u, 14863720252416673310u, 2109768u},
    {6534448740539490317u, 5097941825486908686u, 13105644243542872760u, 13369573262231290465u, 725485u},
    {1700982504819063370u, 11753718567371323364u, 5265147644117535888u, 1238361948138663348u, 2850231u},
    {15250145352448339994u, 16184298738783432732u, 2779677962459328607u, 10933274182773433533u, 3455845u},
    {16224701170084979653u, 7143100534278439787u, 3280367032340809723u, 16276707757740468568u, 2762735u},
    {13149719525932299203u, 725100398888082709u, 15205620300283059187u, 2356806490978881667u, 1541600u},
    {3427952063346971926u, 13950399256360440802u, 13837036797384338614u, 2622510888386242831u, 841379u},
    {246015854317206890u, 5080995809569552482u, 3972714706084701287u, 6572761763155946733u, 3170198u},
    {3097741994527901988u, 16900170955665378210u, 4978530906217486423u, 5534856984624270772u, 770654u},
    {14034389774811131938u, 10017803204935392981u, 7661811547890802920u, 15506598780796743785u, 144921u},
    {2510857867933770618u, 884050184721557368u, 13401303554850801782u, 15927401618486578698u, 91029u},
    {13999443487487761341u, 15652172548275701071u, 4807803735146467126u, 15277889140634409757u, 1198419u},
    {4718018654631147581u, 11748224067629247107u, 14250199471371374660u, 16523295978549457411u, 2193396u},
    {17266759337143439938u, 3769507529548960760u, 4165004525952904160u, 18415147510859217894u, 3221713u},
    {3445627350253814682u, 17916676738947062590u, 9678196844469058556u, 11660702773711488227u, 3098759u},
    {5406992710867431949u, 15957660202582387982u, 3090434160274586275u, 12018722636175844286u, 3611320u},
    {15292009909788240701u, 17810965452164789758u, 2171871799474869564u, 8929701174492127542u, 2577881u},
    {7500071871225058031u, 16518730467264522830u, 2241892540007104278u, 2137223747089089771u, 486015u},
    {12538290581882544453u, 5165310714210469414u, 15084640703991326089u, 16366039243067849166u, 2830998u},
    {3397431721751405718u, 8603403407886966118u, 5047802739417560962u, 12446128886468827828u, 3153424u},
    {7532436155298969187u, 15553489484963456203u, 10403244460962044062u, 10722694335543356883u, 2514748u},
    {5017555919202344116u, 10735453102976274988u, 933214355178528952u, 6891860357091721203u, 3098862u},
    {17990875964326508448u, 5120928174227240195u, 11650635113609934757u, 16774525737924885237u, 3897299u},
    {6177823518053592403u, 16179364246557669108u, 13436062758697716255u, 18086291003488233899u, 2492141u},
    {4148386233526148820u, 18175841386081682080u, 2989917560426903663u, 5017945893925917183u, 3395805u},
    {7236680135505436964u, 3874987106947949644u, 15703493034154850980u, 13105066071642125573u, 2511700u},
    {8415050697537691244u, 15974182125550780752u, 8043384986984385221u, 12079950904528967664u, 1619497u},
    {13793368126942725644u, 17260394815865803991u, 4471948545911513474u, 3272466190473848422u, 3630616u},
    {11227137506143987553u, 5242570622860241119u, 17039697976712453410u, 1580182522250867923u, 2122198u},
    {15510815177228696173u, 12823572649564942097u, 5003492868897572722u, 39147644959920785u, 3857884u},
    {10631704832680523052u, 14960869979367442748u, 14507650864935980792u, 18157621502373118480u, 1422793u},
    {6717345488093724699u, 4824950317363939906u, 8218060802537593170u, 16023031792918488728u, 2412607u},
    {18427383595332240424u, 1918524291888035034u, 2104988227129338621u, 17986845675346528037u, 3575574u},
    {12764976211264735206u, 12554340405790000826u, 12107624164032690751u, 4821758922984699407u, 1831032u},
    {7030048755912928662u, 5579864408261298180u, 12898832660579351774u, 5654268918474910478u, 2626683u},
    {17463623010656842448u, 12386336927607704159u, 11847978596590282656u, 12514417523279565472u, 3561788u},
    {18087798767250939897u, 6846116823777653649u, 13112220186992544683u, 12243436796605048503u, 1852679u},
    {5726056225637966193u, 5288057202725470572u, 18141040345940887939u, 13508945992699696966u, 3781009u},
    {16562677683112914061u, 5635924867891757547u, 13756797946157932022u, 16210648383368196134u, 3732760u},
    {16074292895027654171u, 684062940411049457u, 4765463514125386343u, 10012805261853283617u, 3811703u},
    {7688012373484914198u, 7111791376570730831u, 16171258230347382407u, 13328910822717536404u, 476489u},
    {9088653830812264766u, 12043312067690211426u, 4749900625754156384u, 9592449691010264101u, 2840428u},
    {812182738792391857u, 9869686341364024335u, 5308894532054452241u, 7978732002140321325u, 368152u},
    {6238378627645665522u, 10171769943440305120u, 18204260834959538922u, 10671315131316290848u, 3783516u},
    {2141299829202014456u, 11420537649949970219u, 3841584351550250269u, 18228307259579940271u, 832706u},
    {11010420201386567688u, 5726941884047172018u, 8631105509328027895u, 735936673078229005u, 3492841u},
    {17121514384519191272u, 13171648045558673998u, 999999130118288798u, 18150887648273008353u, 1944680u},
    {4264090605873595498u, 11532744400996764359u, 2021970363754745966u, 1981428071440203411u, 1918027u},
    {14912311444237858409u, 13149308730696564995u, 11023498352519687935u, 9042580609917884981u, 2268518u},
    {11286980146990594257u, 11180745715041979709u, 9789872831207235576u, 13732789647221491894u, 2836031u},
    {16793251087569459815u, 546160436816599072u, 11078524020182030089u, 1781697808685166684u, 2030889u},
    {7495822370081015034u, 4413490824891447429u, 4741427662173485903u, 14232809316878613118u, 1334343u},
    {7359952295459612329u, 8633408253856143679u, 2039497965652923324u, 8023007236270356037u, 2110929u},
    {11430257845333144567u, 8157735737684671519u, 6522165516418729188u, 6668238426533148978u, 3257625u},
    {7813363713312398401u, 3167852653321034206u, 11367270680539169501u, 3230626719000185688u, 2543698u},
    {1602449443989187657u, 12983659598434164015u, 492558625943501771u, 12729059499912750294u, 3791883u},
    {17116128460797275463u, 296780879288649414u, 11493856733348911539u, 9797723103107780855u, 382933u},
    {5578761869376544690u, 13014245588509387837u, 15435323869622119020u, 2168791697983939002u, 3688250u},
    {461225220479062875u, 8102515635041788196u, 13496578800602479166u, 3670915907895047751u, 183765u},
    {2416326979399303329u, 1842951895405355946u, 11949099682150128711u, 13910505518915712791u, 2554401u},
    {2423753013329182047u, 16739808241106236525u, 5039185764063100218u, 7324937393249854807u, 2633718u},
    {1246725654062374863u, 8758361695937566360u, 2081587698989479699u, 9488128348201819182u, 2661304u},
    {5964483899277707113u, 17304455926781195101u, 13939954471414720795u, 5741642332274774816u, 2857000u},
    {16189119328389260214u, 5043624867699330224u, 4458334854681685310u, 4232042807760050809u, 2962262u},
    {16039256569359785570u, 992732308404131384u, 10130328368236673293u, 2936947854742435251u, 2321476u},
    {17201825425819414703u, 15073165979378091125u, 14568140289531192083u, 9986771653816261977u, 2929332u},
    {15429248513956387768u, 14604735683237217651u, 1303492864762456669u, 16194937712193557066u, 318369u},
    {3380909584718096437u, 8190549715904773111u, 7968834245744663049u, 3824925371669121156u, 2146158u},
    {5851805267204825442u, 8231623303632085126u, 10075841910182007528u, 18053988140674653715u, 3601269u},
    {3081979404896659179u, 47936307677375303u, 16846570551553151646u, 13108856226502528479u, 1767u},
    {9372382901656053232u, 6332148573649681306u, 5169403991708033427u, 32608505634471u, 0u},
    {2402672081157802693u, 13122802764957152577u, 9327309686551918130u, 32608u, 0u},
    {15449293985646324234u, 11271194141045823817u, 601520758065207u, 0u, 0u},
    {13024292844182575736u, 13983834875983848644u, 601520u, 0u, 0u},
    {8705110111045412146u, 11096099479052645u, 0u, 0u, 0u},
    {8836961548853745775u, 11096099u, 0u, 0u, 0u},
    {204686907306506031u, 0u, 0u, 0u, 0u},
    {204686908u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1358636u},
    {8540286447474164498u, 13645684075769366634u, 6813411472018392635u, 2475020607870878274u, 1120829u},
    {10683109426636252971u, 6500640797128554718u, 16585245098858652245u, 12486639416749945338u, 1341157u},
    {7153378740980472185u, 9590702888198678223u, 15986041586919514762u, 15373007522506953865u, 2908027u},
    {12940893593296405564u, 13345627464689214437u, 14096549836544842826u, 16482775085849014296u, 3819872u},
    {12609558605374707121u, 13089787361276572397u, 3680631783032940563u, 8573260314136600586u, 3027196u},
    {6408491820066156112u, 4105229105000233260u, 17530850727238022186u, 17133491705435138405u, 1088252u},
    {2122322040430024146u, 6324458425250549771u, 7385221098248665798u, 236247505378978080u, 3607261u},
    {13244793145342103565u, 10445009403454592217u, 4627584462873000021u, 14189830652144196552u, 467651u},
    {5083980990117162567u, 4092187143614878207u, 12303435377220277971u, 6709982898029943045u, 2173819u},
    {16467826940967297967u, 15625483451669857650u, 15020898690882440371u, 18126555992985462057u, 2386608u},
    {6105299459675223550u, 9962269870922613231u, 10120263540084716018u, 4007192837192860278u, 2859976u},
    {7688484563270719580u, 6067324543097670227u, 14487731430165917310u, 11437857107328758273u, 1294670u},
    {16878457148249750861u, 6865435391550762477u, 9582068860728580953u, 10400175999049389436u, 1789761u},
    {9492126302151689935u, 14008670424100799865u, 15849317301214543268u, 4716758885985598319u, 138657u},
    {13593112211263738096u, 1544571056659287720u, 5239207946025223017u, 74615368947715167u, 194745u},
    {12180714658099661891u, 11396059236212072452u, 10646964227361105393u, 13622477684417629839u, 1422442u},
    {11835157186403732831u, 13895393105345445864u, 8068534129099819447u, 6367307712493831614u, 3032828u},
    {2944876752563775912u, 1089930296262355579u, 9265461279900018220u, 1064752124833879208u, 1052716u},
    {8788609638503779741u, 18010162105114922455u, 3188856633739919507u, 7441351369605628757u, 3160589u},
    {5655618689152378596u, 11858459986344061647u, 11770693646740491249u, 16343318836418246503u, 1615745u},
    {14417162022741491042u, 11980511275936068437u, 16492134886402724352u, 8604658941360119059u, 160416u},
    {14179752250806951709u, 1429611462072604710u, 14612612591949613127u, 14558593157163430204u, 2578689u},
    {16689845007311721602u, 13508255077533334914u, 2039133135819818426u, 7613615804569716447u, 2303561u},
    {6390889590463171460u, 7383154265679819509u, 18443442532834604437u, 8185001334124651020u, 3621752u},
    {7196787153673903823u, 16396271690963158564u, 2010736664545437652u, 15343019476468169482u, 1068893u},
    {7045440898067283591u, 16754417136181986526u, 4125624828739999897u, 17962058526400255164u, 1422421u},
    {2106066216786898156u, 5091299481083613790u, 9581930628913130046u, 10618705377689535132u, 454213u},
    {14092780581001542311u, 13697952376791199918u, 4753603102061351174u, 2242164176760423230u, 1346899u},
    {9703531317559762131u, 18329898684202324803u, 2259025435762639243u, 13571673582518751466u, 3134802u},
    {10909267561607589145u, 10588431319553366122u, 6339989106174883647u, 4525397734138958464u, 539752u},
    {4644798857286167797u, 9827694448400912269u, 789478151396412088u, 11467114123563212436u, 800754u},
    {16226436352460926646u, 16744967157772353059u, 15826031746016780107u, 8301394629932825981u, 7106u},
    {2179174454314539674u, 3555088613518216126u, 121919657157286590u, 17870414412270910538u, 42812u},
    {676487228098108006u, 15780641136912298636u, 10970181486415721553u, 15565230072070132241u, 2177049u},
    {16350365393655819043u, 6143620854253970483u, 13026969388481582197u, 5660651816262534385u, 2273000u},
    {6192081226268580829u, 4674153285492223614u, 1580929975628493759u, 13228469163881005915u, 3527819u},
    {14639413985241460591u, 5401148802020150771u, 10208638815342373529u, 1362113480142541968u, 1705754u},
    {1595876304052708931u, 15652277090491465401u, 11985595473654122724u, 13001832535679848322u, 3642162u},
    {4225879174570192135u, 13597444601290296235u, 11301990167482935379u, 12028746653586860039u, 2921737u},
    {9535967522440964883u, 6567547728131470146u, 14697204116206183478u, 10214017306066273553u, 1893455u},
    {7356366785407406482u, 12134556138141705092u, 2238453987203376766u, 9474472908982662641u, 663488u},
    {3792936365870240507u, 3509920114283104709u, 17805890333322536424u, 1525448677602936967u, 3439204u},
    {6206123502489358018u, 9515681360565986322u, 6620363638315021823u, 4531012947882258894u, 1412625u},
    {8472662497686988008u, 18283057397749261260u, 4313049729883595797u, 17247823311442913607u, 1929943u},
    {4411463812345409917u, 14773291150213663464u, 11388125036100031615u, 11636873821952068240u, 3161571u},
    {2229849068869340948u, 7295038542383090523u, 14097314984444359674u, 10290499056130502714u, 2051110u},
    {15403581957534668973u, 4703212461029700032u, 10064478537493642446u, 4001003983613561934u, 2604635u},
    {8787690062323666451u, 13376220204256350584u, 10826432734406704728u, 3722984335185755197u, 3593615u},
    {12014122845434331730u, 15309073192919137676u, 9523814850939246736u, 6767646745454726133u, 1562950u},
    {16872238847381862022u, 9997819199853203081u, 2821490998595688444u, 16241790003951436689u, 616371u},
    {15175365015709644797u, 1119238571582811777u, 18272278921599314260u, 12909679387122346977u, 1335098u},
    {12810309284488042660u, 7763529547185091667u, 1213156506406493013u, 11337670487983686814u, 1315027u},
    {8724941965577400768u, 13363443973924472361u, 9529965151820841936u, 11913760994114797978u, 70518u},
    {12903073821913632434u, 6635821285983325193u, 5084938464653480467u, 8864384906077486972u, 3758112u},
    {5116637039448202378u, 10078531573262149937u, 9595921821169565723u, 17291089914193498360u, 1339117u},
    {13096695714043418421u, 4081154625233260610u, 15216007741973496119u, 5933425076984934379u, 1921072u},
    {13902005914308369817u, 14113666890507344284u, 13410538186955737714u, 6808851369029820416u, 2781716u},
    {4004517723036228989u, 7689865918815558602u, 2082148064105559197u, 17777481743276866664u, 1839319u},
    {17067509837137049300u, 16423628507879086661u, 842207648564435735u, 16679233687401746338u, 2987298u},
    {6259488618203599915u, 8494796331843423408u, 9686752514834624464u, 4234446392556958371u, 3546409u},
    {18263122828276093923u, 809138840958931543u, 14644968174249517309u, 2083032336500128817u, 2548522u},
    {6451198141179182350u, 6572641562358190394u, 7445850599405654787u, 13305609238161990974u, 1405161u},
    {3376318384054284568u, 10376167870366890163u, 7752818820500185718u, 5646412993613346033u, 3625147u},
    {4391435789826613795u, 15451160306057989439u, 9692538877979532774u, 2516830361874538777u, 1873840u},
    {11572051618379272028u, 14928165011556987792u, 1377311712155452834u, 5583000990352361340u, 1517487u},
    {811489401953035197u, 4908851016212389586u, 13013630667376221562u, 1973547738931236548u, 1616042u},
    {3920030847324871634u, 15968613681738090254u, 2653756363089997720u, 2623884100525319166u, 2293699u},
    {17948936073092295846u, 1650720191060245978u, 6592621915238573459u, 7464243466965585033u, 406658u},
    {8603659922646936409u, 2276528090818517503u, 14879962092460600078u, 17229266498580546749u, 3139576u},
    {12515602877109644906u, 11571257354804782616u, 14847813188963255543u, 11587130018269696997u, 2523598u},
    {7026503992428863153u, 16766086744572185663u, 5695088492529823672u, 2784740751479316863u, 2016537u},
    {18025850162995726514u, 1335030582773693617u, 10448063464220809712u, 4720942157204222629u, 985570u},
    {14737781831697351997u, 15056566326577524459u, 18269724497893535721u, 9241552599132443887u, 2790398u},
    {6518003464038638264u, 12066137080627614595u, 10009702429325441416u, 14174762198445219040u, 3636461u},
    {394135852068260580u, 11638184992892397211u, 4137420533449922940u, 16856500290412997196u, 1810110u},
    {8229538703074877641u, 9478155452373009039u, 16392421612421568690u, 1258369751416537598u, 583154u},
    {10868614109035121357u, 14584720499153630418u, 5157976436214406231u, 13269354596830669995u, 3793595u},
    {1924245444925695402u, 12318596821471828109u, 5411712367391271844u, 6987508516994740639u, 1902951u},
    {12098195516447040954u, 977698182365541906u, 17560552440344736952u, 13221642966010130469u, 3023321u},
    {12096578208334328541u, 15161198767363466660u, 5743711161141809508u, 1785152698871585065u, 2999419u},
    {6946004393120529962u, 9798331460712726990u, 8671743725318024994u, 9999277493682029696u, 2265516u},
    {8325181738788252866u, 11432646830256277634u, 4074951297389133493u, 15462116527962749966u, 295416u},
    {15876145174627303044u, 9663589668314725436u, 15918474323707203551u, 16866926483684532532u, 1735693u},
    {11931305604708057452u, 4410141901409270986u, 8440536875405675138u, 15380285431507106004u, 1086154u},
    {2719378477334093691u, 17947904015144970997u, 15366707235936660637u, 8090486552490850187u, 486885u},
    {7681623072065653445u, 17914876295563632802u, 9765823409473179695u, 16005767327498816419u, 1208686u},
    {10702443827176126051u, 1731588782117523527u, 11129898294636982137u, 5642788672271622038u, 3839243u},
    {8800055703385131002u, 1772056089385007458u, 6391588864077570928u, 14122052376096517072u, 2045569u},
    {11476858804862248214u, 490641778278099873u, 16345781235894651265u, 2920037863467283789u, 3108140u},
    {17353854502348167166u, 4889422577321786199u, 4188112432308228553u, 10289513419431064381u, 2639949u},
    {4488256786701971468u, 9442408551748217085u, 9411011676124619219u, 16982233072773223836u, 2726672u},
    {3485555038321695350u, 2864643356245446457u, 5481003378346292283u, 12228031629949004027u, 2634307u},
    {2794352806758973794u, 2041517900698954288u, 13611744341104265504u, 17054186592219606113u, 1966121u},
    {16584281400035694846u, 2637446995386507980u, 10190122539074320458u, 17546263899175620937u, 3676931u},
    {13213855774829907235u, 4486731207803924106u, 9381856012822321021u, 15560210140834459074u, 2565169u},
    {13763396341585913358u, 8803905421977137123u, 11874578281518761118u, 14819125809384250477u, 474214u},
    {8768329003739757869u, 927456811159135909u, 12807211039839611964u, 14348208932660955174u, 2960788u},
    {17817066779364814290u, 16883575762481040108u, 10532880253971531396u, 2792805486281980856u, 322116u},
    {11353423422034211805u, 4219795804150519583u, 3879724979499624147u, 10670465911820187040u, 300739u},
    {11281134370234747678u, 5514594580518652251u, 12241836090200103887u, 3464312179856990176u, 1823231u},
    {14239537518024518207u, 7713739188334591203u, 6629418051058851250u, 14084863516504513239u, 2896045u},
    {12526695205104949234u, 567919806830570711u, 16865340848071490204u, 1422516901746440478u, 2650848u},
    {8669824938675949919u, 5274243997783718737u, 4217125785501567801u, 2715030495460155351u, 225095u},
    {6918660356678203328u, 17936753162130700480u, 18099186593203930230u, 10740733784223564610u, 1013625u},
    {1306625686105758904u, 15623063898327995556u, 8860572745026127902u, 15078735245629386252u, 1098082u},
    {8115710948304974211u, 7248436441445730462u, 8983320211652564762u, 4127538912866574729u, 1480264u},
    {6693692959645955985u, 14056072377093969770u, 10696922920890746731u, 7953641399469137468u, 1531015u},
    {11799273799581280217u, 12886948163190871871u, 11741494801116372677u, 316472625983363572u, 2727438u},
    {7784326472474059266u, 15894355860278867758u, 439094870690751267u, 17055904544030375754u, 2083892u},
    {7158707043213892088u, 13579321321115997950u, 17829612420126854095u, 14161729470891030744u, 1700109u},
    {1726142978916145963u, 11953215372196644717u, 18065945887590241506u, 14370822703329799006u, 817538u},
    {14753727992631698592u, 5719422788781220916u, 13629200046437557519u, 13850138983909518774u, 3880041u},
    {10440954928216924868u, 4750885136480278895u, 5003034260982658299u, 16644820765896064346u, 10055u},
    {8283642054259195000u, 1717973227152727348u, 8071616851091767453u, 5548620239576932987u, 2147233u},
    {16823379616706133395u, 6098967544681836810u, 4095389606693146075u, 832242997583451117u, 3022116u},
    {7244927355414392561u, 13836202552723696418u, 16140727171134864410u, 992496923738368980u, 238173u},
    {204701054367176373u, 5999729331005569756u, 14303726160175308144u, 13407106008423360644u, 886988u},
    {2650158349742979208u, 11423024082411624917u, 3544232941997270015u, 17526357405256045944u, 2141976u},
    {7033302954366897976u, 15391826299451526657u, 14541183926702976373u, 4939428895189485143u, 2668288u},
    {15940489759401020537u, 9889756789646360106u, 4645601312732034600u, 3940331308838487751u, 3653322u},
    {14764583491458309749u, 4854206258097919706u, 6776524020601886948u, 18225905597451023907u, 2957719u},
    {8045556481417600547u, 5308964168617636127u, 13782444461525838160u, 9133817152439773674u, 1045297u},
    {8130626457346328412u, 13228488089888737893u, 11350717465111417032u, 2973643690928878901u, 903490u},
    {655938575722371623u, 13883987835805237503u, 13252486664334344736u, 10537075181314278189u, 1896903u},
    {5752158756898774639u, 15280709627313122091u, 16663376271375180169u, 7384866286579376522u, 3000544u},
    {9575274141387409957u, 1988038551542559576u, 7811377576057844593u, 12233083667044592223u, 977574u},
    {8291310752286580821u, 9120341531401644769u, 4723322161151249460u, 16951567668537261168u, 3899940u},
    {9388267066145862547u, 13012510146097237968u, 4917241728910402409u, 6629182269485832673u, 2634355u},
    {17179911720226526380u, 15372093486863972286u, 6146461641977922346u, 14460114086699066595u, 1129806u},
    {8368806675443004796u, 1181466048652086770u, 6864643897181928921u, 10253019609980822492u, 1031231u},
    {17891431304370333940u, 15821003698929852918u, 11129691559074968561u, 15655520770821257296u, 1404767u},
    {4146010931792361322u, 13022841454730565981u, 9522407936518747807u, 13716856260194021356u, 188595u},
    {15335655476854722006u, 859681430062670867u, 1494940308603638569u, 16072322447873367241u, 3639901u},
    {9823344341960674241u, 8551096701529641567u, 9407788879667817447u, 9506689157241521534u, 3099115u},
    {17794955369274948789u, 1158046590510686475u, 5496048284555169965u, 11442268448759297422u, 3281593u},
    {12925443127610677136u, 12846927311835634706u, 6926783949106350959u, 18002875633111401261u, 3274333u},
    {5249552932518117382u, 18348931757185392148u, 7062767426443625777u, 16993935399779042210u, 2663872u},
    {9626412223252685825u, 8652533298644884463u, 8512422758294058088u, 3147616325653957458u, 316995u},
    {10530527497711339443u, 11136390459079737439u, 17865143661191245783u, 7283664526615983420u, 1770678u},
    {11737585327138203769u, 7488265231439245591u, 964747540554676513u, 14588297246848055480u, 653694u},
    {9744627285246626270u, 1214730224252895632u, 8893636192354059934u, 12910367873297917282u, 3239552u},
    {16186910205439368365u, 3508485094248296781u, 12075853214375980240u, 5247905970298653190u, 147806u},
    {4914497399811400611u, 4178202588746862682u, 5253774505943284046u, 9802559333860663980u, 1441489u},
    {1764948359162130976u, 2744390557444486045u, 13098298865367769763u, 8385271696870267417u, 67947u},
    {12317752796323707463u, 2141048415033045797u, 14276299925425714025u, 1226232507949622951u, 398998u},
    {15511222593108923413u, 13520982483105404067u, 11534817687008092676u, 1736742472128424935u, 829458u},
    {13645318753514209410u, 5716802504140293880u, 7244572527003572827u, 12913610133971733993u, 2317126u},
    {11948196253007858739u, 14702995281455496191u, 8660923604615011285u, 7897021193356293476u, 1121145u},
    {9362270995716872862u, 13169234298072682501u, 11119951827574282215u, 16161582547277397952u, 2417130u},
    {9585639038451146266u, 11946368383108254477u, 14295858323659190497u, 11934091210922577555u, 1224445u},
    {8280013468164115999u, 6843950456160412729u, 15698745074897147789u, 11335629299436110454u, 1874684u},
    {4690557681985460954u, 230978274878502066u, 9182785489349056980u, 14662273417002078424u, 2693735u},
    {15434642569219945655u, 10024298748023155276u, 450177745758502949u, 2211418475947505496u, 2922480u},
    {2312024823735341772u, 4244879255607559122u, 6534448740539490316u, 5097941825486908686u, 451610u},
    {2246428889662887662u, 9423907555155643432u, 1700982504819063369u, 11753718567371323364u, 2352592u},
    {1923666171646107556u, 17146498487085414178u, 15250145352448339993u, 16184298738783432732u, 509505u},
    {15806039866900156518u, 813947565302512378u, 16224701170084979652u, 7143100534278439787u, 245271u},
    {16571534749785936754u, 16630662489401675298u, 13149719525932299202u, 725100398888082709u, 2346409u},
    {1390709238767046554u, 9576967544925136152u, 3427952063346971925u, 13950399256360440802u, 2003834u},
    {8046247077248357832u, 2086884981235932357u, 246015854317206889u, 5080995809569552482u, 2097603u},
    {13872635206257945643u, 17927611542876221368u, 3097741994527901987u, 16900170955665378210u, 97449u},
    {10766597587865291937u, 2264616232790275354u, 14034389774811131937u, 10017803204935392981u, 1049456u},
    {2025645426109429210u, 3624917457456807549u, 2510857867933770617u, 884050184721557368u, 849724u},
    {7698253032515298439u, 2695354296543077687u, 13999443487487761340u, 15652172548275701071u, 153752u},
    {3004205295843944934u, 18382641419387836336u, 4718018654631147580u, 11748224067629247107u, 1220412u},
    {16897523052604015207u, 13756887486895266881u, 17266759337143439937u, 3769507529548960760u, 2514992u},
    {6942588300726696755u, 3471242809159345167u, 3445627350253814681u, 17916676738947062590u, 1785242u},
    {5274505855690513539u, 14712984228019338366u, 5406992710867431948u, 15957660202582387982u, 690621u},
    {7980735572483199380u, 11039731370868357689u, 15292009909788240700u, 17810965452164789758u, 950922u},
    {6446890779262095767u, 950967668332250598u, 7500071871225058030u, 16518730467264522830u, 2668304u},
    {9048422052595448925u, 7772386824970788700u, 12538290581882544452u, 5165310714210469414u, 1547683u},
    {1365979267884301800u, 9512504909285936543u, 3397431721751405717u, 8603403407886966118u, 3312604u},
    {10029756827134917674u, 8440193925580631389u, 7532436155298969186u, 15553489484963456203u, 3845078u},
    {16917941041221736966u, 952899814600481638u, 5017555919202344115u, 10735453102976274988u, 262322u},
    {15985736625679184139u, 6708814357342919002u, 17990875964326508447u, 5120928174227240195u, 2085093u},
    {3872941932689136780u, 4396578081324073337u, 6177823518053592402u, 16179364246557669108u, 939335u},
    {6688058489659592756u, 13582202820169742119u, 4148386233526148819u, 18175841386081682080u, 3032221u},
    {5194863587424244930u, 5491851672899559056u, 7236680135505436963u, 3874987106947949644u, 2680898u},
    {10480029476037778689u, 15647066143635762355u, 8415050697537691243u, 15974182125550780752u, 2094127u},
    {15375688570284016872u, 9826679956322469362u, 13793368126942725643u, 17260394815865803991u, 2950322u},
    {8316379920176654678u, 1020361938694509008u, 11227137506143987552u, 5242570622860241119u, 3761016u},
    {18301284864176865187u, 15817809146970296009u, 15510815177228696172u, 12823572649564942097u, 2436636u},
    {11858139861838529251u, 14587259847388982822u, 10631704832680523051u, 14960869979367442748u, 3748580u},
    {13663355883982679510u, 7584126101652388099u, 6717345488093724698u, 4824950317363939906u, 2440910u},
    {9871564129297051416u, 10108405393708296644u, 18427383595332240423u, 1918524291888035034u, 884657u},
    {5011175875295906683u, 7629314348261136986u, 12764976211264735205u, 12554340405790000826u, 1703805u},
    {14912536107881017387u, 9484579803688968851u, 7030048755912928661u, 5579864408261298180u, 3495920u},
    {471672690892935108u, 10755319926680101241u, 17463623010656842447u, 12386336927607704159u, 34986u},
    {12491591885915042521u, 6847671347716472226u, 18087798767250939896u, 6846116823777653649u, 1509905u},
    {11038199366551643770u, 16706447991983182980u, 5726056225637966192u, 5288057202725470572u, 836599u},
    {6008155985367877831u, 5476629662621852064u, 16562677683112914060u, 5635924867891757547u, 1926876u},
    {273461033410740325u, 16315249881289342795u, 16074292895027654170u, 684062940411049457u, 2718483u},
    {16104333622823402411u, 5192166885982044795u, 7688012373484914197u, 7111791376570730831u, 525505u},
    {8314861846101753803u, 16291654742893918499u, 9088653830812264765u, 12043312067690211426u, 3786768u},
    {6732787163007263609u, 1310519231303647091u, 812182738792391856u, 9869686341364024335u, 631503u},
    {11821242414519380673u, 14647924607099233381u, 6238378627645665521u, 10171769943440305120u, 1921086u},
    {8873715730306052527u, 6417634397402334041u, 2141299829202014455u, 11420537649949970219u, 1864391u},
    {558171201809681746u, 14204023472535431131u, 11010420201386567687u, 5726941884047172018u, 3098971u},
    {11690283659503207377u, 229856609518429099u, 17121514384519191271u, 13171648045558673998u, 191326u},
    {9533908578118838202u, 8159044618006869936u, 4264090605873595497u, 11532744400996764359u, 1887954u},
    {16784592387062373793u, 8567602560278254882u, 14912311444237858408u, 13149308730696564995u, 640689u},
    {1738610700139593824u, 13257186356985632888u, 11286980146990594256u, 11180745715041979709u, 2263666u},
    {3197441003035210406u, 9306598151562341254u, 16793251087569459814u, 546160436816599072u, 974567u},
    {590029110530328963u, 4892071335672542454u, 7495822370081015033u, 4413490824891447429u, 3174249u},
    {3009540363822998920u, 6511826857087751303u, 7359952295459612328u, 8633408253856143679u, 825490u},
    {7267630063126716906u, 5479808838087870328u, 11430257845333144566u, 8157735737684671519u, 3760886u},
    {15032187263116261987u, 14364097509820693861u, 7813363713312398400u, 3167852653321034206u, 720597u},
    {1529071088741149741u, 15523572081570062238u, 1602449443989187656u, 12983659598434164015u, 463523u},
    {722425818297550190u, 2217397970453553038u, 17116128460797275462u, 296780879288649414u, 2378667u},
    {3727645104711584562u, 3649460278550593560u, 5578761869376544689u, 13014245588509387837u, 1738252u},
    {3093877737167482415u, 7202608574427255771u, 461225220479062874u, 8102515635041788196u, 2250372u},
    {10830652401696220915u, 576446776874024190u, 2416326979399303328u, 1842951895405355946u, 1216823u},
    {1681771627115048135u, 5669355030467959478u, 2423753013329182046u, 16739808241106236525u, 2135488u},
    {10908103250440129129u, 12302262276019425053u, 1246725654062374862u, 8758361695937566360u, 576435u},
    {1894996490476095490u, 16200889556484430075u, 5964483899277707112u, 17304455926781195101u, 3884201u},
    {10388398647305924883u, 5702755311208071130u, 16189119328389260213u, 5043624867699330224u, 3034876u},
    {6462491728088473147u, 8427241060804180713u, 16039256569359785569u, 992732308404131384u, 711715u},
    {17807047169760924639u, 10509278950268079279u, 17201825425819414702u, 15073165979378091125u, 2661807u},
    {10172065652685167513u, 3495357219868373073u, 15429248513956387767u, 14604735683237217651u, 2604339u},
    {14951457691573022117u, 11478843761453601245u, 3380909584718096436u, 8190549715904773111u, 924693u},
    {15597503625585566289u, 9174982918214346147u, 5851805267204825441u, 8231623303632085126u, 2598632u},
    {2770157368367570132u, 12544104167186005433u, 3081979404896659178u, 47936307677375303u, 3422712u},
    {7683109510753891852u, 6415546980185876702u, 9372382901656053231u, 6332148573649681306u, 451063u},
    {17203396305295096602u, 18028398764545993212u, 2402672081157802692u, 13122802764957152577u, 1637658u},
    {14301819063048660891u, 10391552189678960025u, 15449293985646324233u, 11271194141045823817u, 252707u},
    {9067083432391384371u, 8529292954714292816u, 13024292844182575735u, 13983834875983848644u, 601520u},
    {258220484089921530u, 18210580729593078385u, 8705110111045412145u, 11096099479052645u, 0u},
    {7008947863348393979u, 8379183837012106892u, 8836961548853745774u, 11096099u, 0u},
    {17998263518384539593u, 15319868923530310939u, 204686907306506030u, 0u, 0u},
    {7942345641840046399u, 5654038307778610962u, 204686907u, 0u, 0u},
    {7646224753088607887u, 3775806994322226444u, 0u, 0u, 0u},
    {5944028753895727460u, 3775806994u, 0u, 0u, 0u},
    {14311113074855950423u, 3u, 0u, 0u, 0u},
    {69651345296u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1452766u},
    {2985980661317373887u, 8929834458646081531u, 8540286447474164497u, 13645684075769366634u, 837943u},
    {12632896936406505597u, 6224301298171370976u, 10683109426636252970u, 6500640797128554718u, 381795u},
    {2974504733101087227u, 15318559571481076497u, 7153378740980472184u, 9590702888198678223u, 811664u},
    {17023900091356564369u, 13970703177880718382u, 12940893593296405563u, 13345627464689214437u, 2567544u},
    {11470109592151380046u, 10235541559289244741u, 12609558605374707120u, 13089787361276572397u, 3794915u},
    {1982186281281087039u, 14473258446922356142u, 6408491820066156111u, 4105229105000233260u, 3005828u},
    {4133287532412692168u, 10707778577013646006u, 2122322040430024145u, 6324458425250549771u, 3725094u},
    {3313092904293497419u, 4002591971994426742u, 13244793145342103564u, 10445009403454592217u, 3087909u},
    {4796127304994479805u, 11148506349724384841u, 5083980990117162566u, 4092187143614878207u, 3309155u},
    {17504000514676797550u, 5863754319466864231u, 16467826940967297966u, 15625483451669857650u, 993231u},
    {5407158764069212573u, 8253344508472779390u, 6105299459675223549u, 9962269870922613231u, 785322u},
    {1381133965475865709u, 577450926438412504u, 7688484563270719579u, 6067324543097670227u, 1082248u},
    {90257854098458547u, 18179072575958696020u, 16878457148249750860u, 6865435391550762477u, 1599045u},
    {5703855237553066582u, 9683124168292655165u, 9492126302151689934u, 14008670424100799865u, 1700114u},
    {133039639510647379u, 5650749764182357858u, 13593112211263738095u, 1544571056659287720u, 594109u},
    {7685270747099194008u, 13624881743468426358u, 12180714658099661890u, 11396059236212072452u, 3270769u},
    {7568472833365491654u, 6291704543566876319u, 11835157186403732830u, 13895393105345445864u, 491489u},
    {7138700460692200091u, 17077018693272375624u, 2944876752563775911u, 1089930296262355579u, 3676594u},
    {4131462822538923146u, 4421729563153993993u, 8788609638503779740u, 18010162105114922455u, 2223403u},
    {6238751587236627866u, 15119353364893956051u, 5655618689152378595u, 11858459986344061647u, 1027317u},
    {12920535544261103665u, 8728883077864304745u, 14417162022741491041u, 11980511275936068437u, 3280642u},
    {11343834596653981534u, 12338473440609829761u, 14179752250806951708u, 1429611462072604710u, 1815225u},
    {13067475192214144511u, 13961983989272800105u, 16689845007311721601u, 13508255077533334914u, 1804094u},
    {6135909669796136178u, 1625960397308817041u, 6390889590463171459u, 7383154265679819509u, 2124919u},
    {8520464633892878085u, 14412811317228560204u, 7196787153673903822u, 16396271690963158564u, 2008772u},
    {9327954975457421207u, 16366602120845357836u, 7045440898067283590u, 16754417136181986526u, 2562397u},
    {13136901263960357789u, 7582158555262084438u, 2106066216786898155u, 5091299481083613790u, 379986u},
    {10046661564302195619u, 3682014599794546771u, 14092780581001542310u, 13697952376791199918u, 1478298u},
    {12662054457445902176u, 15799482936584016737u, 9703531317559762130u, 18329898684202324803u, 3687511u},
    {12586284348098068644u, 12536772423144689221u, 10909267561607589144u, 10588431319553366122u, 1510383u},
    {1992962722711170326u, 4351401439066450426u, 4644798857286167796u, 9827694448400912269u, 1496488u},
    {3631641387633741540u, 15766635594844600074u, 16226436352460926645u, 16744967157772353059u, 1315489u},
    {18396909128314910375u, 5846916412795672503u, 2179174454314539673u, 3555088613518216126u, 1520u},
    {3794042351451722106u, 11741581514410256678u, 676487228098108005u, 15780641136912298636u, 1015103u},
    {9466593504958811168u, 5536305999986824482u, 16350365393655819042u, 6143620854253970483u, 3386357u},
    {10236273060421378021u, 9708066920649154959u, 6192081226268580828u, 4674153285492223614u, 3734363u},
    {987643096714516071u, 8358285788849648638u, 14639413985241460590u, 5401148802020150771u, 855391u},
    {15394121340680076246u, 9845319184881807718u, 1595876304052708930u, 15652277090491465401u, 2743948u},
    {3850312573272539040u, 15285253167020272545u, 4225879174570192134u, 13597444601290296235u, 558725u},
    {13077761089216122933u, 3300334556948275168u, 9535967522440964882u, 6567547728131470146u, 1565606u},
    {8243334021080306198u, 8408084133127956663u, 7356366785407406481u, 12134556138141705092u, 2773150u},
    {10622674000490828501u, 565236894620091265u, 3792936365870240506u, 3509920114283104709u, 221120u},
    {2840038315416947011u, 10248106564056329793u, 6206123502489358017u, 9515681360565986322u, 2845277u},
    {1293712389326473892u, 5261890979274249230u, 8472662497686988007u, 18283057397749261260u, 80467u},
    {7967435318451308737u, 3641647734991733173u, 4411463812345409916u, 14773291150213663464u, 933581u},
    {7920323355331701525u, 2325611945757278444u, 2229849068869340947u, 7295038542383090523u, 1055408u},
    {3620576630637321562u, 1007748637891648765u, 15403581957534668972u, 4703212461029700032u, 2470100u},
    {2392242194073000673u, 6511447643485505358u, 8787690062323666450u, 13376220204256350584u, 1781520u},
    {17036689384461301326u, 9896739334566482358u, 12014122845434331729u, 15309073192919137676u, 2920364u},
    {5938686180374076183u, 15626349974830528274u, 16872238847381862021u, 9997819199853203081u, 2080294u},
    {171030284890169448u, 17787069724027836915u, 15175365015709644796u, 1119238571582811777u, 2893030u},
    {8158246759373367527u, 12772121778302301613u, 12810309284488042659u, 7763529547185091667u, 1777499u},
    {5724998922125085449u, 200240803198044489u, 8724941965577400767u, 13363443973924472361u, 353592u},
    {8522838655657277462u, 12865425152432622646u, 12903073821913632433u, 6635821285983325193u, 3389541u},
    {14938470684033813605u, 16363664272390048614u, 5116637039448202377u, 10078531573262149937u, 2489835u},
    {9129852187534391557u, 12016215174956866445u, 13096695714043418420u, 4081154625233260610u, 3384665u},
    {8461911941078743577u, 4533959198549501986u, 13902005914308369816u, 14113666890507344284u, 2805966u},
    {17258398962878478803u, 2126526936973605468u, 4004517723036228988u, 7689865918815558602u, 3607935u},
    {6202244516164256897u, 507897527121905289u, 17067509837137049299u, 16423628507879086661u, 3472581u},
    {5956738946500158652u, 10325222089241232857u, 6259488618203599914u, 8494796331843423408u, 894754u},
    {1352211149971580022u, 10981882930467764608u, 18263122828276093922u, 809138840958931543u, 834863u},
    {7063118407068543451u, 10439158912548575296u, 6451198141179182349u, 6572641562358190394u, 3899437u},
    {14827391362631474299u, 4665353602568791857u, 3376318384054284567u, 10376167870366890163u, 1671578u},
    {2130217937842002104u, 8755480394672518658u, 4391435789826613794u, 15451160306057989439u, 663696u},
    {8318495822263414826u, 15688929907323286408u, 11572051618379272027u, 14928165011556987792u, 484346u},
    {15392022440576734151u, 7950762077194807212u, 811489401953035196u, 4908851016212389586u, 2379032u},
    {106582277383888142u, 10284000135380014579u, 3920030847324871633u, 15968613681738090254u, 3548220u},
    {11073920828429330128u, 1048336168285192690u, 17948936073092295845u, 1650720191060245978u, 2317085u},
    {851876887397324836u, 7032305647993474761u, 8603659922646936408u, 2276528090818517503u, 2279118u},
    {8166930417252960311u, 3358175606010529108u, 12515602877109644905u, 11571257354804782616u, 2641383u},
    {9538251546892990621u, 9249861730723494993u, 7026503992428863152u, 16766086744572185663u, 2059652u},
    {1822098276940876906u, 9671957607305864980u, 18025850162995726513u, 1335030582773693617u, 3718096u},
    {17950570120477900615u, 3111400545115084577u, 14737781831697351996u, 15056566326577524459u, 1762851u},
    {7654271952284803346u, 3574034457512761424u, 6518003464038638263u, 12066137080627614595u, 2001022u},
    {6637589806521987855u, 3139300390878419734u, 394135852068260579u, 11638184992892397211u, 2093086u},
    {4963127305731747764u, 16432300059463154962u, 8229538703074877640u, 9478155452373009039u, 1576782u},
    {3540901561357423659u, 8779714133936770311u, 10868614109035121356u, 14584720499153630418u, 3729971u},
    {766577161465856716u, 15615623026013944306u, 1924245444925695401u, 12318596821471828109u, 2219874u},
    {10964267460910347776u, 14361640468986122158u, 12098195516447040953u, 977698182365541906u, 1577732u},
    {10019519022899505581u, 6676962119505168342u, 12096578208334328540u, 15161198767363466660u, 3824862u},
    {8994010654404547937u, 1945581276971089206u, 6946004393120529961u, 9798331460712726990u, 2577526u},
    {3324636734021595389u, 11864644315017168241u, 8325181738788252865u, 11432646830256277634u, 426745u},
    {13940697120127433304u, 9876389168558723758u, 15876145174627303043u, 9663589668314725436u, 793021u},
    {5943262002826032015u, 2849213909640366046u, 11931305604708057451u, 4410141901409270986u, 301576u},
    {9832051398685256486u, 6351684065806642871u, 2719378477334093690u, 17947904015144970997u, 2417389u},
    {4055260044886798801u, 8337618901983308992u, 7681623072065653444u, 17914876295563632802u, 119615u},
    {61044854987695232u, 3111429228467780491u, 10702443827176126050u, 1731588782117523527u, 2313353u},
    {3088038287537140890u, 17586529050815331235u, 8800055703385131001u, 1772056089385007458u, 3160244u},
    {2293357651514081u, 472944891718715503u, 11476858804862248213u, 490641778278099873u, 3337379u},
    {11272111392274379618u, 17332686262223861183u, 17353854502348167165u, 4889422577321786199u, 155243u},
    {2356743029174671742u, 5647997499169378413u, 4488256786701971467u, 9442408551748217085u, 2948877u},
    {9634045206356415829u, 10630226611428102732u, 3485555038321695349u, 2864643356245446457u, 1295907u},
    {14319557739728494076u, 2413395894168712639u, 2794352806758973793u, 2041517900698954288u, 2351288u},
    {9475087152772369456u, 12865838988902327337u, 16584281400035694845u, 2637446995386507980u, 1038686u},
    {18230186557329709601u, 6013220596121186630u, 13213855774829907234u, 4486731207803924106u, 698169u},
    {17594920194665313860u, 14897343222890002330u, 13763396341585913357u, 8803905421977137123u, 3402534u},
    {8465151732758733119u, 15908170112417229837u, 8768329003739757868u, 927456811159135909u, 1197976u},
    {1498180459696185375u, 397524915726393220u, 17817066779364814289u, 16883575762481040108u, 2193088u},
    {11167185520269011621u, 12592576594024057724u, 11353423422034211804u, 4219795804150519583u, 2071771u},
    {12332287641017662959u, 11214080253851781818u, 11281134370234747677u, 5514594580518652251u, 193889u},
    {18237518347746214467u, 15215385073745446485u, 14239537518024518206u, 7713739188334591203u, 3443244u},
    {18034709739556973945u, 5518445293999396168u, 12526695205104949233u, 567919806830570711u, 761090u},
    {9237918271822297362u, 6535962725234119428u, 8669824938675949918u, 5274243997783718737u, 3603337u},
    {9711693148407288908u, 14148792574284755680u, 6918660356678203327u, 17936753162130700480u, 3177990u},
    {11312281935769148941u, 14743236419362425879u, 1306625686105758903u, 15623063898327995556u, 2313526u},
    {202618291901400629u, 1537190349069265861u, 8115710948304974210u, 7248436441445730462u, 262460u},
    {1186975172046969007u, 12843408355975045410u, 6693692959645955984u, 14056072377093969770u, 3290359u},
    {17280362682115368754u, 5215946174467252631u, 11799273799581280216u, 12886948163190871871u, 2259757u},
    {14159022282295463491u, 5782130902102537000u, 7784326472474059265u, 15894355860278867758u, 1761483u},
    {17474225394622644982u, 4305570441320445302u, 7158707043213892087u, 13579321321115997950u, 3453853u},
    {15362658442900586943u, 9795576299502481626u, 1726142978916145962u, 11953215372196644717u, 1456780u},
    {7182591230936076532u, 13396584750723303114u, 14753727992631698591u, 5719422788781220916u, 3639749u},
    {7544588652718959664u, 16809842570914304705u, 10440954928216924867u, 4750885136480278895u, 3287765u},
    {6461494844748175814u, 599611930987861536u, 8283642054259194999u, 1717973227152727348u, 2500693u},
    {17025709037907654661u, 15689479261652677088u, 16823379616706133394u, 6098967544681836810u, 62043u},
    {5995997594762452947u, 4303311112460389790u, 7244927355414392560u, 13836202552723696418u, 1027228u},
    {12057965994045875850u, 11385847250578815416u, 204701054367176372u, 5999729331005569756u, 2055876u},
    {5337273951229460144u, 4298414641303320463u, 2650158349742979207u, 11423024082411624917u, 2361325u},
    {4854543441580360206u, 12959470052019477341u, 7033302954366897975u, 15391826299451526657u, 968539u},
    {14211675586242484519u, 4864562687565727206u, 15940489759401020536u, 9889756789646360106u, 1428298u},
    {14104725966699523037u, 321595375957274371u, 14764583491458309748u, 4854206258097919706u, 2643274u},
    {4376316258816398670u, 8430191335436449515u, 8045556481417600546u, 5308964168617636127u, 2274026u},
    {5846549052943869316u, 4701588705964508616u, 8130626457346328411u, 13228488089888737893u, 2652488u},
    {8903473181767584097u, 3567895954524285331u, 655938575722371622u, 13883987835805237503u, 243928u},
    {9851600615378742468u, 9663615356764469238u, 5752158756898774638u, 15280709627313122091u, 2303035u},
    {7701480648705086515u, 8184684845386577938u, 9575274141387409956u, 1988038551542559576u, 2227205u},
    {15884586699239636624u, 13103557075803402862u, 8291310752286580820u, 9120341531401644769u, 2284588u},
    {5263381721639558056u, 15906953049789692555u, 9388267066145862546u, 13012510146097237968u, 1291607u},
    {1691422017263194533u, 14220016274181077827u, 17179911720226526379u, 15372093486863972286u, 1547402u},
    {10388484977864615371u, 16241949889334693058u, 8368806675443004795u, 1181466048652086770u, 2189579u},
    {4704651752882753583u, 9967553166615742674u, 17891431304370333939u, 15821003698929852918u, 2844649u},
    {10524978177216629002u, 17148985588345541753u, 4146010931792361321u, 13022841454730565981u, 3634673u},
    {3252305484066301495u, 11860343434946299023u, 15335655476854722005u, 859681430062670867u, 2618381u},
    {13333358842462042064u, 1679867758135635678u, 9823344341960674240u, 8551096701529641567u, 277831u},
    {12411110469930332753u, 12605185000221013266u, 17794955369274948788u, 1158046590510686475u, 1120825u},
    {9215467139814955819u, 8959834263564387785u, 12925443127610677135u, 12846927311835634706u, 2510083u},
    {17926734960726420850u, 2855055697424049776u, 5249552932518117381u, 18348931757185392148u, 304769u},
    {14704563506719366919u, 14064945311940275541u, 9626412223252685824u, 8652533298644884463u, 2142436u},
    {11872876224212531506u, 18199093744679846993u, 10530527497711339442u, 11136390459079737439u, 3595921u},
    {643490052480895531u, 2150186486333262854u, 11737585327138203768u, 7488265231439245591u, 3350657u},
    {2494278529711975183u, 2686868184051885890u, 9744627285246626269u, 1214730224252895632u, 2695358u},
    {995820807321558090u, 9319089040146886251u, 16186910205439368364u, 3508485094248296781u, 3844566u},
    {11086654542965674066u, 5350746638705281402u, 4914497399811400610u, 4178202588746862682u, 336210u},
    {13027391616123158392u, 2365176634836134036u, 1764948359162130975u, 2744390557444486045u, 2785217u},
    {15805716137645388359u, 5315902410849842361u, 12317752796323707462u, 2141048415033045797u, 2505179u},
    {7997397180323874119u, 3582284618430277297u, 15511222593108923412u, 13520982483105404067u, 1314734u},
    {9063112358596726886u, 16641515966087172693u, 13645318753514209409u, 5716802504140293880u, 175971u},
    {5479401186041870923u, 13304589940983193635u, 11948196253007858738u, 14702995281455496191u, 2968121u},
    {14255030563635412201u, 17870238509122618954u, 9362270995716872861u, 13169234298072682501u, 3082677u},
    {2607380474966840709u, 10014593287969194336u, 9585639038451146265u, 11946368383108254477u, 3823797u},
    {1017950370175709404u, 3810166310022842457u, 8280013468164115998u, 6843950456160412729u, 802607u},
    {242362935412008862u, 2676656769168934907u, 4690557681985460953u, 230978274878502066u, 449574u},
    {3625880117220784859u, 8710909554120365543u, 15434642569219945654u, 10024298748023155276u, 3552865u},
    {5506930548057920605u, 5889918293379701526u, 2312024823735341771u, 4244879255607559122u, 3058552u},
    {9404919105257516619u, 4632985280660853825u, 2246428889662887661u, 9423907555155643432u, 3732295u},
    {10562556099609682304u, 2480077916518879544u, 1923666171646107555u, 17146498487085414178u, 1155435u},
    {13491051228868024330u, 1456971128426719220u, 15806039866900156517u, 813947565302512378u, 3112520u},
    {2904642413146549462u, 1680285972313902515u, 16571534749785936753u, 16630662489401675298u, 3543450u},
    {13207692611721521518u, 8723124396753794852u, 1390709238767046553u, 9576967544925136152u, 3755261u},
    {4439719359060927604u, 17692976933888315130u, 8046247077248357831u, 2086884981235932357u, 3107769u},
    {15078199675007679818u, 3187568007966678033u, 13872635206257945642u, 17927611542876221368u, 1671341u},
    {14676983131170185903u, 3673831896430019772u, 10766597587865291936u, 2264616232790275354u, 1194669u},
    {13923513823354422591u, 14626276986357166413u, 2025645426109429209u, 3624917457456807549u, 1584199u},
    {1201432858329122547u, 9661706111364477258u, 7698253032515298438u, 2695354296543077687u, 431238u},
    {12788769542414817997u, 16815187824869432661u, 3004205295843944933u, 18382641419387836336u, 3574864u},
    {3178480067020605043u, 5067429320526028024u, 16897523052604015206u, 13756887486895266881u, 676449u},
    {7516604753487590373u, 11806739785577457191u, 6942588300726696754u, 3471242809159345167u, 717473u},
    {9938674337321147467u, 8325150531758015541u, 5274505855690513538u, 14712984228019338366u, 808786u},
    {6722327454912913163u, 3823371981927630968u, 7980735572483199379u, 11039731370868357689u, 770810u},
    {11586923404229132408u, 951375389500152411u, 6446890779262095766u, 950967668332250598u, 3373184u},
    {14890983252275691929u, 10735230989575513429u, 9048422052595448924u, 7772386824970788700u, 48924u},
    {912112501931052882u, 8342751565331413009u, 1365979267884301799u, 9512504909285936543u, 512579u},
    {8318108863694875185u, 1905738875535092266u, 10029756827134917673u, 8440193925580631389u, 875552u},
    {319364983584868327u, 10642221971954655219u, 16917941041221736965u, 952899814600481638u, 404305u},
    {17764267430116922516u, 10619459510160919971u, 15985736625679184138u, 6708814357342919002u, 57725u},
    {16856551575951027341u, 13128344300291414378u, 3872941932689136779u, 4396578081324073337u, 1917690u},
    {10680261847963347703u, 1605899968123387836u, 6688058489659592755u, 13582202820169742119u, 838875u},
    {13331040998050392749u, 16315389906652876629u, 5194863587424244929u, 5491851672899559056u, 572905u},
    {7066215498250140617u, 8866964447830151207u, 10480029476037778688u, 15647066143635762355u, 1455387u},
    {17997024395302143936u, 7126121867014502119u, 15375688570284016871u, 9826679956322469362u, 626431u},
    {15664622807919599997u, 12399890286980494163u, 8316379920176654677u, 1020361938694509008u, 2016402u},
    {11678966375759509288u, 4536292656718269135u, 18301284864176865186u, 15817809146970296009u, 1714440u},
    {6880765692952069150u, 14937995713280857732u, 11858139861838529250u, 14587259847388982822u, 980049u},
    {1078147044089020643u, 12066217231612044250u, 13663355883982679509u, 7584126101652388099u, 1102754u},
    {16178874094078105442u, 2642446608010760737u, 9871564129297051415u, 10108405393708296644u, 3429709u},
    {16902351408806257112u, 7363468424494126343u, 5011175875295906682u, 7629314348261136986u, 2441351u},
    {3986314977046727888u, 9516548250710534539u, 14912536107881017386u, 9484579803688968851u, 1015811u},
    {7668053759072433641u, 2380762957152599502u, 471672690892935107u, 10755319926680101241u, 119257u},
    {14536727603286958585u, 1507076027006461555u, 12491591885915042520u, 6847671347716472226u, 3314610u},
    {9046384599355600455u, 1229141534165107204u, 11038199366551643769u, 16706447991983182980u, 13688u},
    {16751990717903619976u, 2079855213869520815u, 6008155985367877830u, 5476629662621852064u, 1638968u},
    {12373533736247799398u, 5268955723598091237u, 273461033410740324u, 16315249881289342795u, 217930u},
    {8746332256166176604u, 9288915611213886708u, 16104333622823402410u, 5192166885982044795u, 359873u},
    {17178991522203218643u, 12199684436850640802u, 8314861846101753802u, 16291654742893918499u, 730889u},
    {4649574209087741096u, 17383521165632886931u, 6732787163007263608u, 1310519231303647091u, 1096834u},
    {4285606967922950512u, 10406600969062438384u, 11821242414519380672u, 14647924607099233381u, 244407u},
    {9119881084520389322u, 11555058207052574862u, 8873715730306052526u, 6417634397402334041u, 470405u},
    {17166050356845809125u, 14376884356165980922u, 558171201809681745u, 14204023472535431131u, 741801u},
    {3881808767236848629u, 1728675705648899523u, 11690283659503207376u, 229856609518429099u, 896445u},
    {6667243663271031649u, 14734434229412889245u, 9533908578118838201u, 8159044618006869936u, 3513165u},
    {192486560647829975u, 16773126652463188609u, 16784592387062373792u, 8567602560278254882u, 3829762u},
    {10897883070204478244u, 5303744711194388551u, 1738610700139593823u, 13257186356985632888u, 605446u},
    {10227853764943241737u, 2876404627193298352u, 3197441003035210405u, 9306598151562341254u, 3480968u},
    {13868852205505148197u, 921346192130010309u, 590029110530328962u, 4892071335672542454u, 1444341u},
    {6061368812765870623u, 16550513268076701442u, 3009540363822998919u, 6511826857087751303u, 186032u},
    {14130213086966097803u, 10816011529529458353u, 7267630063126716905u, 5479808838087870328u, 1335536u},
    {1362783798830436350u, 7612369354330074265u, 15032187263116261986u, 14364097509820693861u, 1690778u},
    {16788166786043667640u, 8471558941075768258u, 1529071088741149740u, 15523572081570062238u, 3017884u},
    {10551144526833819560u, 18378591700757075080u, 722425818297550189u, 2217397970453553038u, 2525138u},
    {13346468009990118726u, 5381662818983254986u, 3727645104711584561u, 3649460278550593560u, 3735443u},
    {9390349210544851623u, 1376358232536894876u, 3093877737167482414u, 7202608574427255771u, 3905492u},
    {14862787198848267875u, 11466029451862638812u, 10830652401696220914u, 576446776874024190u, 2648852u},
    {11382597904063195713u, 10799839393042761889u, 1681771627115048134u, 5669355030467959478u, 2844474u},
    {7728505185644300518u, 8588042680604108337u, 10908103250440129128u, 12302262276019425053u, 3251982u},
    {3500200059256014352u, 263245524270511849u, 1894996490476095489u, 16200889556484430075u, 553234u},
    {15019651460818893404u, 13429144701773851520u, 10388398647305924882u, 5702755311208071130u, 3716653u},
    {6620226557773571216u, 4666062052764928462u, 6462491728088473146u, 8427241060804180713u, 3302903u},
    {11998087273111033249u, 8786407818405582994u, 17807047169760924638u, 10509278950268079279u, 1983694u},
    {4084774155041239231u, 15633393623137069792u, 10172065652685167512u, 3495357219868373073u, 1175617u},
    {3968822599353582593u, 6833999087055714246u, 14951457691573022116u, 11478843761453601245u, 1283070u},
    {14639098912629423005u, 1018886657344533217u, 15597503625585566288u, 9174982918214346147u, 329749u},
    {9921724479864537310u, 9817253600132392074u, 2770157368367570131u, 12544104167186005433u, 131248u},
    {15388060413594323324u, 2853286065228990008u, 7683109510753891851u, 6415546980185876702u, 758955u},
    {187290103116338671u, 17714975814024508009u, 17203396305295096601u, 18028398764545993212u, 827172u},
    {11031374483215183148u, 3711662475257047053u, 14301819063048660890u, 10391552189678960025u, 1436397u},
    {18149150233531119756u, 11392253914884430548u, 9067083432391384370u, 8529292954714292816u, 2822559u},
    {17893220537645362882u, 8124147724366666091u, 258220484089921529u, 18210580729593078385u, 1111465u},
    {2227225863110095806u, 13416035272704354996u, 7008947863348393978u, 8379183837012106892u, 2366758u},
    {11115811781474633693u, 13667397419593172093u, 17998263518384539592u, 15319868923530310939u, 1818530u},
    {15337228622159128806u, 13162613299420428438u, 7942345641840046398u, 5654038307778610962u, 1561907u},
    {6377794835788439022u, 241054353978826909u, 7646224753088607886u, 3775806994322226444u, 0u},
    {7146511216770700339u, 2706900866591456414u, 5944028753895727459u, 3775806994u, 0u},
    {1036770148847208252u, 3551547267339855370u, 14311113074855950422u, 3u, 0u},
    {14581628963979443984u, 18162761432867240237u, 69651345295u, 0u, 0u},
    {9379928775179982568u, 12015199978642611074u, 69u, 0u, 0u},
    {11098900071914976720u, 1284840541064u, 0u, 0u, 0u},
    {15505245902150421015u, 1284u, 0u, 0u, 0u},
    {23701124636546u, 0u, 0u, 0u, 0u},
    {23702u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3618546u},
    {9256008311617887927u, 9062202391160917686u, 2985980661317373886u, 8929834458646081531u, 1482549u},
    {9815300430213501215u, 15348785449927466228u, 12632896936406505596u, 6224301298171370976u, 2295778u},
    {7724823269300122839u, 5955265337496371297u, 2974504733101087226u, 15318559571481076497u, 3447086u},
    {3504866642781123183u, 17009255611598832508u, 17023900091356564368u, 13970703177880718382u, 182319u},
    {740105733195911190u, 1660504787879441224u, 11470109592151380045u, 10235541559289244741u, 3346912u},
    {12711171579013488714u, 12692381375932269818u, 1982186281281087038u, 14473258446922356142u, 2344839u},
    {17759228806598715716u, 10090149394076564523u, 4133287532412692167u, 10707778577013646006u, 2137195u},
    {158048972417905263u, 12998383538221678688u, 3313092904293497418u, 4002591971994426742u, 2799240u},
    {12757059256267334065u, 5705687344189104950u, 4796127304994479804u, 11148506349724384841u, 1468508u},
    {1281788220960064168u, 3703377716889606371u, 17504000514676797549u, 5863754319466864231u, 2102202u},
    {4007054930936141528u, 16503766177663180801u, 5407158764069212572u, 8253344508472779390u, 53677u},
    {1488792169309214834u, 9989475000833594288u, 1381133965475865708u, 577450926438412504u, 1114499u},
    {10302568252567759232u, 1165330934482611571u, 90257854098458546u, 18179072575958696020u, 1485712u},
    {9505034995037189657u, 5920363308762207214u, 5703855237553066581u, 9683124168292655165u, 1640258u},
    {9789493730651313415u, 14682849555562670647u, 133039639510647378u, 5650749764182357858u, 325069u},
    {9380991487313933741u, 1376798030663542922u, 7685270747099194007u, 13624881743468426358u, 1230236u},
    {2637680354038513994u, 14459888957382006805u, 7568472833365491653u, 6291704543566876319u, 3872038u},
    {707996462597054591u, 9845774143032500786u, 7138700460692200090u, 17077018693272375624u, 1421189u},
    {9729700371826776447u, 9801671164624871185u, 4131462822538923145u, 4421729563153993993u, 3215538u},
    {3058200135264248996u, 4707040218271859608u, 6238751587236627865u, 15119353364893956051u, 537449u},
    {13528879147778885300u, 6188366593771132760u, 12920535544261103664u, 8728883077864304745u, 901235u},
    {5899989371911689145u, 15566649205303163046u, 11343834596653981533u, 12338473440609829761u, 2974418u},
    {4916184916119086801u, 718646740110467799u, 13067475192214144510u, 13961983989272800105u, 2205989u},
    {3070146647741237468u, 10763198762115722485u, 6135909669796136177u, 1625960397308817041u, 70067u},
    {18104377026223947045u, 10295348962528222927u, 8520464633892878084u, 14412811317228560204u, 516528u},
    {16547629339737992599u, 13305867390110875091u, 9327954975457421206u, 16366602120845357836u, 873388u},
    {3774662274065579357u, 13957122203265615313u, 13136901263960357788u, 7582158555262084438u, 383661u},
    {11848614981689911176u, 4558744098253892578u, 10046661564302195618u, 3682014599794546771u, 1022936u},
    {11948002228356987690u, 14882507907129590842u, 12662054457445902175u, 15799482936584016737u, 3838544u},
    {1987786805493478264u, 7940571283305328813u, 12586284348098068643u, 12536772423144689221u, 1514944u},
    {12203249871584310801u, 228707223525232215u, 1992962722711170325u, 4351401439066450426u, 3148528u},
    {3853981572137696179u, 2628578186404683299u, 3631641387633741539u, 15766635594844600074u, 555723u},
    {13351972419490830333u, 14556764986615924464u, 18396909128314910374u, 5846916412795672503u, 3699909u},
    {18190512908919594777u, 1942123516461251512u, 3794042351451722105u, 11741581514410256678u, 3248749u},
    {13344254113192736783u, 9239647545752901040u, 9466593504958811167u, 5536305999986824482u, 2837862u},
    {13029508234689263544u, 17878974532562848002u, 10236273060421378020u, 9708066920649154959u, 3884830u},
    {10284176159290712074u, 9681851932947281521u, 987643096714516070u, 8358285788849648638u, 2465822u},
    {339200234497817365u, 10117520965070510493u, 15394121340680076245u, 9845319184881807718u, 490234u},
    {1205448331994774054u, 6699289980500890585u, 3850312573272539039u, 15285253167020272545u, 3130244u},
    {2643967272944452159u, 11780035856213102209u, 13077761089216122932u, 3300334556948275168u, 2678154u},
    {3998496196450441559u, 12302625129586035746u, 8243334021080306197u, 8408084133127956663u, 3297803u},
    {10372584163481313022u, 2474718776100225294u, 10622674000490828500u, 565236894620091265u, 863470u},
    {15549171103944981553u, 3412187594313787508u, 2840038315416947010u, 10248106564056329793u, 91431u},
    {16435282559901607110u, 7575635699816229919u, 1293712389326473891u, 5261890979274249230u, 2101619u},
    {4524615374937966u, 8331966986843772683u, 7967435318451308736u, 3641647734991733173u, 1071676u},
    {4125681513578326359u, 14288600043587035012u, 7920323355331701524u, 2325611945757278444u, 3848913u},
    {3092307181775083192u, 1726880081045736249u, 3620576630637321561u, 1007748637891648765u, 1423784u},
    {8767721394212368864u, 17102812162203264795u, 2392242194073000672u, 6511447643485505358u, 1347064u},
    {639536432505398827u, 7661382636321882282u, 17036689384461301325u, 9896739334566482358u, 3356129u},
    {13045653882309012738u, 14043610993142570730u, 5938686180374076182u, 15626349974830528274u, 3301481u},
    {16175705693283511928u, 15687725487797356362u, 171030284890169447u, 17787069724027836915u, 971858u},
    {1232458753033535765u, 6679184842811670920u, 8158246759373367526u, 12772121778302301613u, 3042575u},
    {10981691038343146546u, 6782191434263980337u, 5724998922125085448u, 200240803198044489u, 2123595u},
    {12752444648040241023u, 6305724172900669711u, 8522838655657277461u, 12865425152432622646u, 357267u},
    {11338189708331894778u, 15624837707160350403u, 14938470684033813604u, 16363664272390048614u, 2962829u},
    {40568736541134335u, 10995049963432777072u, 9129852187534391556u, 12016215174956866445u, 3598920u},
    {11658301819361995787u, 8366413720723413288u, 8461911941078743576u, 4533959198549501986u, 1998006u},
    {683804138614072265u, 6246246263781053996u, 17258398962878478802u, 2126526936973605468u, 189430u},
    {5195132848543234518u, 6279735993485312903u, 6202244516164256896u, 507897527121905289u, 1137661u},
    {255005563214060772u, 3438442406237057762u, 5956738946500158651u, 10325222089241232857u, 1579066u},
    {14058866978040729595u, 11211666506682346809u, 1352211149971580021u, 10981882930467764608u, 3407938u},
    {791889978669207116u, 9196149763561755434u, 7063118407068543450u, 10439158912548575296u, 2909325u},
    {6869877583609206059u, 11755168965169070789u, 14827391362631474298u, 4665353602568791857u, 1979293u},
    {9920892819085496859u, 9054507196051786122u, 2130217937842002103u, 8755480394672518658u, 2842344u},
    {16289376002880475018u, 11782789440949690196u, 8318495822263414825u, 15688929907323286408u, 1324175u},
    {286814494152966097u, 16517195341641276784u, 15392022440576734150u, 7950762077194807212u, 2809264u},
    {10740661009389977826u, 8255233908441226039u, 106582277383888141u, 10284000135380014579u, 2142917u},
    {10281967067165317761u, 7481168507858515944u, 11073920828429330127u, 1048336168285192690u, 2315803u},
    {17753207454862459079u, 16319029012412030294u, 851876887397324835u, 7032305647993474761u, 2359564u},
    {3637938015016106290u, 11364186708321558013u, 8166930417252960310u, 3358175606010529108u, 1436009u},
    {5206635669252667385u, 7639127703769482529u, 9538251546892990620u, 9249861730723494993u, 880372u},
    {7966070908938820090u, 3689181694879730218u, 1822098276940876905u, 9671957607305864980u, 700611u},
    {356926686237575530u, 3211286706812394094u, 17950570120477900614u, 3111400545115084577u, 2342546u},
    {4985668777987299947u, 13619858747957924411u, 7654271952284803345u, 3574034457512761424u, 2213065u},
    {714617923730301059u, 3547994546024681234u, 6637589806521987854u, 3139300390878419734u, 171771u},
    {9457365628836977979u, 13982384345433901046u, 4963127305731747763u, 16432300059463154962u, 3293006u},
    {1110237629845544221u, 7584251391333261233u, 3540901561357423658u, 8779714133936770311u, 2774620u},
    {3434320679018473810u, 4027716600319988629u, 766577161465856715u, 15615623026013944306u, 1202339u},
    {1636656915799734952u, 16896309903503519002u, 10964267460910347775u, 14361640468986122158u, 2583841u},
    {65098303218360892u, 17512187745199214658u, 10019519022899505580u, 6676962119505168342u, 1422u},
    {12903423729542122968u, 13177186009722520425u, 8994010654404547936u, 1945581276971089206u, 2558657u},
    {17909383219068883287u, 7773078405632330412u, 3324636734021595388u, 11864644315017168241u, 243879u},
    {8707045843466621307u, 14917894262607034035u, 13940697120127433303u, 9876389168558723758u, 2112445u},
    {16831990833964305909u, 17765988230789623715u, 5943262002826032014u, 2849213909640366046u, 575483u},
    {6393827511300216638u, 4246359300966514543u, 9832051398685256485u, 6351684065806642871u, 2764476u},
    {13804749599994284588u, 8692531507291289017u, 4055260044886798800u, 8337618901983308992u, 702166u},
    {2259632176673114123u, 2821310865308525327u, 61044854987695231u, 3111429228467780491u, 242650u},
    {3943691030103579828u, 15122955993964388755u, 3088038287537140889u, 17586529050815331235u, 2200893u},
    {2340147814368708203u, 2263357534850494308u, 2293357651514080u, 472944891718715503u, 2106805u},
    {2075392191272589734u, 18188028637913085279u, 11272111392274379617u, 17332686262223861183u, 1491057u},
    {10743012436092375353u, 9235368655243468494u, 2356743029174671741u, 5647997499169378413u, 2046989u},
    {2282257418812430978u, 4324712483525018868u, 9634045206356415828u, 10630226611428102732u, 1924203u},
    {2503529315249290857u, 8288127798239588727u, 14319557739728494075u, 2413395894168712639u, 2146029u},
    {2393396700880550544u, 7992548519913487518u, 9475087152772369455u, 12865838988902327337u, 1758591u},
    {5007165877697508125u, 12069972926419772100u, 18230186557329709600u, 6013220596121186630u, 2899094u},
    {9596645671329245500u, 13034922131439687225u, 17594920194665313859u, 14897343222890002330u, 3008629u},
    {9459590591755456205u, 7844163653201125166u, 8465151732758733118u, 15908170112417229837u, 2018618u},
    {2070725504182777322u, 5873213068653756845u, 1498180459696185374u, 397524915726393220u, 2957445u},
    {17846491985795924139u, 17120770237726050694u, 11167185520269011620u, 12592576594024057724u, 2447758u},
    {15111608291458442635u, 17480305370644111309u, 12332287641017662958u, 11214080253851781818u, 608927u},
    {8682532644998824483u, 2882277178792468521u, 18237518347746214466u, 15215385073745446485u, 2280518u},
    {16931120205497510131u, 16098444668407383444u, 18034709739556973944u, 5518445293999396168u, 2752749u},
    {2260254849645692795u, 16655085182183024605u, 9237918271822297361u, 6535962725234119428u, 1382582u},
    {1543155386430423455u, 11583677248373519096u, 9711693148407288907u, 14148792574284755680u, 2357447u},
    {6907372251897252764u, 2006648250456383899u, 11312281935769148940u, 14743236419362425879u, 1300005u},
    {16862265480964451844u, 11578591152789311187u, 202618291901400628u, 1537190349069265861u, 930062u},
    {2086496536984526118u, 14587173807535405047u, 1186975172046969006u, 12843408355975045410u, 1507008u},
    {17288489082521913609u, 3610677413457944666u, 17280362682115368753u, 5215946174467252631u, 949944u},
    {16303565836085379028u, 7102529822700257949u, 14159022282295463490u, 5782130902102537000u, 2936691u},
    {5048817145539843457u, 261714775068274425u, 17474225394622644981u, 4305570441320445302u, 3675505u},
    {16061689145625431583u, 10033890483123154458u, 15362658442900586942u, 9795576299502481626u, 3574064u},
    {18254704813994209686u, 10117517866369544659u, 7182591230936076531u, 13396584750723303114u, 1107141u},
    {11395163958645332791u, 13507002109576778671u, 7544588652718959663u, 16809842570914304705u, 1255027u},
    {10501228757228747183u, 14519473871331676401u, 6461494844748175813u, 599611930987861536u, 2872125u},
    {13767185576807187388u, 6074180593684517635u, 17025709037907654660u, 15689479261652677088u, 2814212u},
    {2469027993911534493u, 5944307224372220019u, 5995997594762452946u, 4303311112460389790u, 40516u},
    {10300834019797393401u, 1885347307281991249u, 12057965994045875849u, 11385847250578815416u, 2548774u},
    {2359494138721059265u, 4057233137579706830u, 5337273951229460143u, 4298414641303320463u, 3315529u},
    {16165509576852002556u, 5118576263019854483u, 4854543441580360205u, 12959470052019477341u, 1989721u},
    {15905820847040632986u, 15287500031061939667u, 14211675586242484518u, 4864562687565727206u, 1808720u},
    {8285277843201541187u, 16595534627390079697u, 14104725966699523036u, 321595375957274371u, 3876588u},
    {11602612749008398317u, 16781901456885503387u, 4376316258816398669u, 8430191335436449515u, 967384u},
    {7133916633692216761u, 17675965575923246126u, 5846549052943869315u, 4701588705964508616u, 2009777u},
    {2228334483222877773u, 14535998985350702948u, 8903473181767584096u, 3567895954524285331u, 428138u},
    {15728093703523687330u, 2583981555153559659u, 9851600615378742467u, 9663615356764469238u, 2286404u},
    {8778673497059133779u, 6083280545068026978u, 7701480648705086514u, 8184684845386577938u, 3314002u},
    {16811645385041461160u, 11520752313160030868u, 15884586699239636623u, 13103557075803402862u, 2942652u},
    {1411008073079355327u, 4578166949353892581u, 5263381721639558055u, 15906953049789692555u, 1337376u},
    {18311537502287428887u, 13782602732391633516u, 1691422017263194532u, 14220016274181077827u, 1571617u},
    {1432503548939507121u, 3996622073731420349u, 10388484977864615370u, 16241949889334693058u, 1279639u},
    {3326967343446592969u, 6859264658439498984u, 4704651752882753582u, 9967553166615742674u, 3867121u},
    {13598077459860667316u, 16852077325717690390u, 10524978177216629001u, 17148985588345541753u, 2325505u},
    {10013646320090009408u, 650010317407366304u, 3252305484066301494u, 11860343434946299023u, 1222063u},
    {15157921011338445496u, 15711578737804540623u, 13333358842462042063u, 1679867758135635678u, 3640948u},
    {11211137982290625489u, 17312232416953101436u, 12411110469930332752u, 12605185000221013266u, 1338588u},
    {17893983930764097027u, 11336165016708896259u, 9215467139814955818u, 8959834263564387785u, 2429129u},
    {12532915155713145328u, 8084621369275005673u, 17926734960726420849u, 2855055697424049776u, 743463u},
    {8811647380937104381u, 6370970326438554404u, 14704563506719366918u, 14064945311940275541u, 2199848u},
    {2221567149263215581u, 13950347666463136564u, 11872876224212531505u, 18199093744679846993u, 3280592u},
    {6771151975815451163u, 1573214810310483754u, 643490052480895530u, 2150186486333262854u, 1124166u},
    {5081347397332350106u, 5331354196104014827u, 2494278529711975182u, 2686868184051885890u, 1282579u},
    {12219189005255689015u, 12730069424358025221u, 995820807321558089u, 9319089040146886251u, 1002056u},
    {11943393844676323520u, 18180063953031323816u, 11086654542965674065u, 5350746638705281402u, 3216482u},
    {3878539371775032278u, 14940709593466009104u, 13027391616123158391u, 2365176634836134036u, 3019397u},
    {3050705715358029795u, 17066422172702423033u, 15805716137645388358u, 5315902410849842361u, 2789788u},
    {4543492559155005992u, 6264607681916687019u, 7997397180323874118u, 3582284618430277297u, 3700888u},
    {16582290832078584675u, 5484383003181632615u, 9063112358596726885u, 16641515966087172693u, 2493265u},
    {17573202638305255069u, 9625374797047554543u, 5479401186041870922u, 13304589940983193635u, 3903820u},
    {7803153077675663483u, 15554239309238535738u, 14255030563635412200u, 17870238509122618954u, 3829689u},
    {7717330162951746519u, 10349712684249362167u, 2607380474966840708u, 10014593287969194336u, 3424529u},
    {8191931480828952879u, 12966067148707112057u, 1017950370175709403u, 3810166310022842457u, 570604u},
    {16588306208288995839u, 18135166385972831715u, 242362935412008861u, 2676656769168934907u, 3469353u},
    {7317306346839243330u, 7234380301674827377u, 3625880117220784858u, 8710909554120365543u, 2886860u},
    {7309800394298139199u, 12747078431101655956u, 5506930548057920604u, 5889918293379701526u, 1154635u},
    {3709766342475279103u, 4858599021015001951u, 9404919105257516618u, 4632985280660853825u, 1632793u},
    {18173259419737575198u, 256860327653906217u, 10562556099609682303u, 2480077916518879544u, 857563u},
    {17739244624102270682u, 5258560483427471028u, 13491051228868024329u, 1456971128426719220u, 1244735u},
    {9328953322465470358u, 12616982821886231746u, 2904642413146549461u, 1680285972313902515u, 225271u},
    {11206717601626018854u, 12805144562523903265u, 13207692611721521517u, 8723124396753794852u, 2106951u},
    {12008633853133530329u, 18189098504270915239u, 4439719359060927603u, 17692976933888315130u, 923407u},
    {5394891231042971291u, 16705893033029152585u, 15078199675007679817u, 3187568007966678033u, 3846326u},
    {12090973767186782041u, 3158853694473993402u, 14676983131170185902u, 3673831896430019772u, 3829564u},
    {14009866977380679412u, 4446082922315196270u, 13923513823354422590u, 14626276986357166413u, 324637u},
    {2299345895493359689u, 13686330632231641163u, 1201432858329122546u, 9661706111364477258u, 1396908u},
    {18365001295696229482u, 8611853666953967570u, 12788769542414817996u, 16815187824869432661u, 1268393u},
    {12508915185827759544u, 1177979201433546223u, 3178480067020605042u, 5067429320526028024u, 3325896u},
    {14738798278672366563u, 16966510959027899188u, 7516604753487590372u, 11806739785577457191u, 2088564u},
    {5431492175006289860u, 5973981995947092876u, 9938674337321147466u, 8325150531758015541u, 234160u},
    {7077332955622190993u, 14487126151453089208u, 6722327454912913162u, 3823371981927630968u, 792913u},
    {1839775992239978989u, 2936145726778217409u, 11586923404229132407u, 951375389500152411u, 3833038u},
    {10350755594104594168u, 7440713944235555325u, 14890983252275691928u, 10735230989575513429u, 3042718u},
    {9511969974732911809u, 12494359771492111670u, 912112501931052881u, 8342751565331413009u, 1747811u},
    {18218357269134676920u, 8550955780039596767u, 8318108863694875184u, 1905738875535092266u, 2697259u},
    {13699390959254845947u, 145289221206638822u, 319364983584868326u, 10642221971954655219u, 1463303u},
    {12126852489800462036u, 1426881442794938084u, 17764267430116922515u, 10619459510160919971u, 751470u},
    {16368113681662286918u, 8291552673186714822u, 16856551575951027340u, 13128344300291414378u, 1118511u},
    {15134234328391113518u, 13842883246196760271u, 10680261847963347702u, 1605899968123387836u, 1646559u},
    {10819398793046970257u, 16208611365094305863u, 13331040998050392748u, 16315389906652876629u, 210355u},
    {10792941582937904945u, 6028434570085495033u, 7066215498250140616u, 8866964447830151207u, 3495340u},
    {2417676793335125240u, 17191556925039497839u, 17997024395302143935u, 7126121867014502119u, 324399u},
    {5245729520706425490u, 5573373520167810372u, 15664622807919599996u, 12399890286980494163u, 3725417u},
    {16425218301179454775u, 14251854052846635823u, 11678966375759509287u, 4536292656718269135u, 1196620u},
    {11516591863290328247u, 7639906620425662259u, 6880765692952069149u, 14937995713280857732u, 1767196u},
    {17020708407345530126u, 14221728326678256454u, 1078147044089020642u, 12066217231612044250u, 2622317u},
    {4603236651899086241u, 12925489591385771767u, 16178874094078105441u, 2642446608010760737u, 736923u},
    {940350509216923831u, 1781887624874385100u, 16902351408806257111u, 7363468424494126343u, 268114u},
    {12737661767786367060u, 4360651345213142471u, 3986314977046727887u, 9516548250710534539u, 155168u},
    {18202936698205207140u, 4670669837451862940u, 7668053759072433640u, 2380762957152599502u, 3573755u},
    {324009182651181425u, 15666195361078785104u, 14536727603286958584u, 1507076027006461555u, 225646u},
    {6503616262072713250u, 16994654027251241441u, 9046384599355600454u, 1229141534165107204u, 3374177u},
    {4391998603115600551u, 3560476741691136892u, 16751990717903619975u, 2079855213869520815u, 474412u},
    {15638048064313850824u, 1213258723550347331u, 12373533736247799397u, 5268955723598091237u, 3553124u},
    {13488647752317920456u, 9923922801823449234u, 8746332256166176603u, 9288915611213886708u, 1189968u},
    {11751385025743216886u, 9562241299510169318u, 17178991522203218642u, 12199684436850640802u, 956320u},
    {13885329539811591630u, 16186217234869109405u, 4649574209087741095u, 17383521165632886931u, 1642968u},
    {17461056872497285423u, 10394980090947763720u, 4285606967922950511u, 10406600969062438384u, 1400960u},
    {10801431242370886003u, 13133654103114831885u, 9119881084520389321u, 11555058207052574862u, 2028712u},
    {14606383674187539979u, 11303998484105042841u, 17166050356845809124u, 14376884356165980922u, 3867947u},
    {12491658603476324038u, 8719405302964574560u, 3881808767236848628u, 1728675705648899523u, 1880280u},
    {18059063180677457772u, 730776555849588275u, 6667243663271031648u, 14734434229412889245u, 3023017u},
    {15027628917426384811u, 10715424388201579323u, 192486560647829974u, 16773126652463188609u, 2360326u},
    {10233997346506272108u, 2760864687031151191u, 10897883070204478243u, 5303744711194388551u, 3586457u},
    {11059406128662811279u, 964359830230200385u, 10227853764943241736u, 2876404627193298352u, 3071277u},
    {7077175739650364720u, 2784127976911906191u, 13868852205505148196u, 921346192130010309u, 2673872u},
    {9986036868799801791u, 8393917365204534474u, 6061368812765870622u, 16550513268076701442u, 399659u},
    {9540317399580911805u, 9385600054437036306u, 14130213086966097802u, 10816011529529458353u, 2511119u},
    {5507587756123471938u, 5997507157976871910u, 1362783798830436349u, 7612369354330074265u, 2212880u},
    {18373735813776628741u, 13428341831419049019u, 16788166786043667639u, 8471558941075768258u, 211702u},
    {8933320671842075492u, 15693211124594494726u, 10551144526833819559u, 18378591700757075080u, 2678025u},
    {770685607251628344u, 14122887027529298587u, 13346468009990118725u, 5381662818983254986u, 393779u},
    {13888586578198266738u, 14488226378758782498u, 9390349210544851622u, 1376358232536894876u, 480952u},
    {1593062639875062680u, 4961387416681352051u, 14862787198848267874u, 11466029451862638812u, 3429216u},
    {7798107286895553564u, 17404255151159486857u, 11382597904063195712u, 10799839393042761889u, 714976u},
    {11726379923505184986u, 4802119006028223650u, 7728505185644300517u, 8588042680604108337u, 2551818u},
    {15365450167400856675u, 4112703754304720162u, 3500200059256014351u, 263245524270511849u, 1432893u},
    {8275055376518539548u, 12524131761634656495u, 15019651460818893403u, 13429144701773851520u, 2947730u},
    {12377487529108646667u, 6163879987676412623u, 6620226557773571215u, 4666062052764928462u, 3655872u},
    {11616505918399722352u, 15903591806272112628u, 11998087273111033248u, 8786407818405582994u, 3737966u},
    {3719420634760401258u, 4227810175600799479u, 4084774155041239230u, 15633393623137069792u, 3284332u},
    {3404859128413118258u, 17106228298792461088u, 3968822599353582592u, 6833999087055714246u, 546456u},
    {2845013893137901595u, 7314209009899981070u, 14639098912629423004u, 1018886657344533217u, 944384u},
    {4325125997796564454u, 2307960333812683344u, 9921724479864537309u, 9817253600132392074u, 2333197u},
    {15158297319229028849u, 10723714448799208542u, 15388060413594323323u, 2853286065228990008u, 3299513u},
    {4879160243986123423u, 9304485683237780349u, 187290103116338670u, 17714975814024508009u, 1990875u},
    {12524346298034690228u, 9033282296082916335u, 11031374483215183147u, 3711662475257047053u, 387822u},
    {8830891135026693770u, 6689889334169248791u, 18149150233531119755u, 11392253914884430548u, 2910930u},
    {4673188191423045559u, 16194385616293292693u, 17893220537645362881u, 8124147724366666091u, 722229u},
    {4806521806832437466u, 11777717810954407355u, 2227225863110095805u, 13416035272704354996u, 2629848u},
    {18364328065831691289u, 2226670130382628504u, 11115811781474633692u, 13667397419593172093u, 2609196u},
    {12572633006869290162u, 16362914198690512488u, 15337228622159128805u, 13162613299420428438u, 1348832u},
    {530059234537237131u, 17506034021523293889u, 6377794835788439021u, 241054353978826909u, 2210140u},
    {4761782914287340734u, 13300799873810327326u, 7146511216770700338u, 2706900866591456414u, 1123513u},
    {13591117689223913010u, 12461334386969594652u, 1036770148847208251u, 3551547267339855370u, 230270u},
    {8427559367261534950u, 16398404545484629131u, 14581628963979443983u, 18162761432867240237u, 2907795u},
    {18404963147594106609u, 621959570725912273u, 9379928775179982567u, 12015199978642611074u, 69u},
    {3195789833192781037u, 3740420747707503264u, 11098900071914976719u, 1284840541064u, 0u},
    {16225024713921676999u, 3514771470453146414u, 15505245902150421014u, 1284u, 0u},
    {7391878619112761931u, 3960441394400666268u, 23701124636545u, 0u, 0u},
    {5867411013787967946u, 2299138451806825241u, 23701u, 0u, 0u},
    {16411626537853442259u, 437208580429441u, 0u, 0u, 0u},
    {10707033367384924379u, 437208u, 0u, 0u, 0u},
    {8065074790011774u, 0u, 0u, 0u, 0u},
    {8065075u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2981726u},
    {18434541478717816453u, 1325454934945920539u, 9256008311617887926u, 9062202391160917686u, 28076u},
    {3475142787575574686u, 1236063896058074506u, 9815300430213501214u, 15348785449927466228u, 2523080u},
    {12360867653534364352u, 677551530501074193u, 7724823269300122838u, 5955265337496371297u, 198594u},
    {766039004974216405u, 7533311856413756135u, 3504866642781123182u, 17009255611598832508u, 172394u},
    {3392779016848650897u, 10913126526063869353u, 740105733195911189u, 1660504787879441224u, 555373u},
    {9174545888314431151u, 14076383186767761830u, 12711171579013488713u, 12692381375932269818u, 113094u},
    {6396727092003485876u, 550072053346322581u, 17759228806598715715u, 10090149394076564523u, 1518783u},
    {13662932913126400654u, 2239673265946028757u, 158048972417905262u, 12998383538221678688u, 712180u},
    {18445916880027987172u, 10252684678674979400u, 12757059256267334064u, 5705687344189104950u, 1541758u},
    {5678741489591895950u, 5375619417691127757u, 1281788220960064167u, 3703377716889606371u, 139707u},
    {1394929455536692491u, 11527243002268889258u, 4007054930936141527u, 16503766177663180801u, 2468024u},
    {17331465918791649493u, 5466672086544914584u, 1488792169309214833u, 9989475000833594288u, 672716u},
    {1223822984738165159u, 10806448320489436519u, 10302568252567759231u, 1165330934482611571u, 631038u},
    {17222382739300884148u, 5384222666086220280u, 9505034995037189656u, 5920363308762207214u, 2990119u},
    {16716856098086139071u, 2367653331622434455u, 9789493730651313414u, 14682849555562670647u, 417620u},
    {5618343877839714229u, 17970517138792680018u, 9380991487313933740u, 1376798030663542922u, 2622151u},
    {10689474731011360914u, 6308003389999766673u, 2637680354038513993u, 14459888957382006805u, 2490485u},
    {12770348909972014617u, 17658275506817542073u, 707996462597054590u, 9845774143032500786u, 99658u},
    {11301462277792531470u, 4462393105202734299u, 9729700371826776446u, 9801671164624871185u, 1262911u},
    {1661436471874578739u, 11685455689314737647u, 3058200135264248995u, 4707040218271859608u, 3440775u},
    {2626211581253220055u, 4026812142112514874u, 13528879147778885299u, 6188366593771132760u, 119744u},
    {13608628738515656385u, 9223606738806437756u, 5899989371911689144u, 15566649205303163046u, 3801667u},
    {13505729601321452838u, 4681205017662986817u, 4916184916119086800u, 718646740110467799u, 1442924u},
    {4503013772284444586u, 2996439822314419630u, 3070146647741237467u, 10763198762115722485u, 3424485u},
    {8346469574154228247u, 10854495629970791838u, 18104377026223947044u, 10295348962528222927u, 2562516u},
    {11637552597892394794u, 15355630042321333101u, 16547629339737992598u, 13305867390110875091u, 2710860u},
    {10122918761043339679u, 8094464777293131000u, 3774662274065579356u, 13957122203265615313u, 1036262u},
    {1059410836949459509u, 18057381940025386057u, 11848614981689911175u, 4558744098253892578u, 2094870u},
    {3440538117164202674u, 15367022223708564293u, 11948002228356987689u, 14882507907129590842u, 771731u},
    {7737461809819789667u, 5756098000019822666u, 1987786805493478263u, 7940571283305328813u, 679493u},
    {4742088458098632117u, 8778102302103639732u, 12203249871584310800u, 228707223525232215u, 1870509u},
    {14678657845388294555u, 17619801338087289784u, 3853981572137696178u, 2628578186404683299u, 61311u},
    {1255364258120253805u, 13354265418885244417u, 13351972419490830332u, 14556764986615924464u, 3720226u},
    {3433953810317462503u, 9003361644351651031u, 18190512908919594776u, 1942123516461251512u, 882297u},
    {17855205528083298036u, 5619479617712093997u, 13344254113192736782u, 9239647545752901040u, 471151u},
    {14584203316167085900u, 7535924363038379263u, 13029508234689263543u, 17878974532562848002u, 1416744u},
    {16331940854922946252u, 770226079012611855u, 10284176159290712073u, 9681851932947281521u, 1596910u},
    {12516627933512613730u, 16222084614085413194u, 339200234497817364u, 10117520965070510493u, 3794237u},
    {14430179140578810095u, 1496088588228415518u, 1205448331994774053u, 6699289980500890585u, 1878273u},
    {6081624684932448027u, 15805260731343137663u, 2643967272944452158u, 11780035856213102209u, 2864144u},
    {8179882508686158091u, 17450722584112010827u, 3998496196450441558u, 12302625129586035746u, 1342273u},
    {17259278079078770147u, 10222938064688575054u, 10372584163481313021u, 2474718776100225294u, 1381310u},
    {10719565588094164200u, 17881821493346010411u, 15549171103944981552u, 3412187594313787508u, 519784u},
    {5611952517742741128u, 6464476715924691582u, 16435282559901607109u, 7575635699816229919u, 2458085u},
    {4619912349559011197u, 229255643750449033u, 4524615374937965u, 8331966986843772683u, 1149060u},
    {8202984508526084797u, 3502576508902292663u, 4125681513578326358u, 14288600043587035012u, 3770606u},
    {11452101004768737734u, 13222037446147214740u, 3092307181775083191u, 1726880081045736249u, 1364055u},
    {14394422745565055667u, 15503116983986755642u, 8767721394212368863u, 17102812162203264795u, 1261884u},
    {5685947558538843862u, 13382572111570364033u, 639536432505398826u, 7661382636321882282u, 3493177u},
    {8365599051855783649u, 8291852979689181409u, 13045653882309012737u, 14043610993142570730u, 2777052u},
    {14301020476213168677u, 6181875261903383425u, 16175705693283511927u, 15687725487797356362u, 2704335u},
    {1789236218793071512u, 11000802146854087255u, 1232458753033535764u, 6679184842811670920u, 475834u},
    {913052276652885056u, 2023548584944775204u, 10981691038343146545u, 6782191434263980337u, 1990242u},
    {9807090255698682975u, 13988783796129786034u, 12752444648040241022u, 6305724172900669711u, 3274149u},
    {13755964071204873966u, 13521370116386360307u, 11338189708331894777u, 15624837707160350403u, 2292852u},
    {4982578094757019518u, 1477741693679662459u, 40568736541134334u, 10995049963432777072u, 419196u},
    {2120170097180703686u, 9518373513257413221u, 11658301819361995786u, 8366413720723413288u, 2672188u},
    {7557025497851265731u, 6132710871697444746u, 683804138614072264u, 6246246263781053996u, 581420u},
    {17140601448519792726u, 3023002987658114648u, 5195132848543234517u, 6279735993485312903u, 2804586u},
    {5102405288399142717u, 4188757169584314601u, 255005563214060771u, 3438442406237057762u, 2316909u},
    {5737868474539708184u, 6692730865781837884u, 14058866978040729594u, 11211666506682346809u, 2430527u},
    {3467653710379624857u, 13367253243951638776u, 791889978669207115u, 9196149763561755434u, 530236u},
    {12683279809553682670u, 558421233472394318u, 6869877583609206058u, 11755168965169070789u, 2564568u},
    {1046147298479430064u, 12540873045324236857u, 9920892819085496858u, 9054507196051786122u, 2027545u},
    {13152405614945294474u, 17220506550724941283u, 16289376002880475017u, 11782789440949690196u, 867703u},
    {855966182148813630u, 9899211338108626862u, 286814494152966096u, 16517195341641276784u, 2204626u},
    {12583121771147751382u, 9091376295747582154u, 10740661009389977825u, 8255233908441226039u, 3211207u},
    {10681137252376679859u, 7170143195743158515u, 10281967067165317760u, 7481168507858515944u, 1843835u},
    {17150109512282048815u, 14061160247285622650u, 17753207454862459078u, 16319029012412030294u, 2772545u},
    {8143888550188490114u, 11849998442441705144u, 3637938015016106289u, 11364186708321558013u, 55442u},
    {11964468341814776616u, 17663658567428150752u, 5206635669252667384u, 7639127703769482529u, 772190u},
    {9936481854002130306u, 7242060547758176309u, 7966070908938820089u, 3689181694879730218u, 2209201u},
    {11487223570325089918u, 5193847430634202623u, 356926686237575529u, 3211286706812394094u, 52772u},
    {4986082309779497178u, 9575473623919511725u, 4985668777987299946u, 13619858747957924411u, 930919u},
    {5596895283372116134u, 8459790953337513962u, 714617923730301058u, 3547994546024681234u, 174074u},
    {13148815163676279706u, 15511257361363540511u, 9457365628836977978u, 13982384345433901046u, 986841u},
    {4763640550927807362u, 14237544074856315775u, 1110237629845544220u, 7584251391333261233u, 3499204u},
    {4644803960888649204u, 16058403033378123818u, 3434320679018473809u, 4027716600319988629u, 1888295u},
    {9670434528829617308u, 12513455720447696371u, 1636656915799734951u, 16896309903503519002u, 118849u},
    {14290522988867978259u, 9571578822588885127u, 65098303218360891u, 17512187745199214658u, 3399184u},
    {15342782312785135454u, 15181672651184060868u, 12903423729542122967u, 13177186009722520425u, 3410674u},
    {7483221397753795264u, 9838775928668064992u, 17909383219068883286u, 7773078405632330412u, 106918u},
    {1663334951616171825u, 7044473737917487774u, 8707045843466621306u, 14917894262607034035u, 2158651u},
    {15055983963195421819u, 7297121006039498255u, 16831990833964305908u, 17765988230789623715u, 3633098u},
    {16693499695570580725u, 8833224071075726450u, 6393827511300216637u, 4246359300966514543u, 2473077u},
    {7040521640534883712u, 4728605863078128582u, 13804749599994284587u, 8692531507291289017u, 599818u},
    {16057943370212272690u, 14550811412746626825u, 2259632176673114122u, 2821310865308525327u, 3410837u},
    {5429762996982709492u, 1491257421177725933u, 3943691030103579827u, 15122955993964388755u, 1603107u},
    {5613741145651813563u, 15285925819188858600u, 2340147814368708202u, 2263357534850494308u, 1600008u},
    {6059914961270078292u, 8931942604738239025u, 2075392191272589733u, 18188028637913085279u, 650337u},
    {17328866389835023775u, 15984311625160235712u, 10743012436092375352u, 9235368655243468494u, 68133u},
    {3383409138886446031u, 116090984250364241u, 2282257418812430977u, 4324712483525018868u, 81558u},
    {12648874289035472424u, 15167837399205850129u, 2503529315249290856u, 8288127798239588727u, 3589423u},
    {2346959799831942778u, 9897666513473504904u, 2393396700880550543u, 7992548519913487518u, 1970793u},
    {4487818495502629500u, 4303334663160759169u, 5007165877697508124u, 12069972926419772100u, 3499544u},
    {4526546496042293640u, 7301180504479684147u, 9596645671329245499u, 13034922131439687225u, 3357963u},
    {12645261126416892291u, 147116978699918910u, 9459590591755456204u, 7844163653201125166u, 1981268u},
    {17946438835391803620u, 1550092227085971838u, 2070725504182777321u, 5873213068653756845u, 2337564u},
    {8122364078342875889u, 8624259145547531060u, 17846491985795924138u, 17120770237726050694u, 2296752u},
    {3860946412983000533u, 4049734635086376104u, 15111608291458442634u, 17480305370644111309u, 3904808u},
    {11616514635193128101u, 16276455602312185484u, 8682532644998824482u, 2882277178792468521u, 1604684u},
    {4781946452578213613u, 6190069184478319315u, 16931120205497510130u, 16098444668407383444u, 530226u},
    {9159147027366211769u, 3815242130744384347u, 2260254849645692794u, 16655085182183024605u, 2952401u},
    {6754784979946423726u, 2990407773029841867u, 1543155386430423454u, 11583677248373519096u, 3311869u},
    {2807039779625826364u, 5730552143239940059u, 6907372251897252763u, 2006648250456383899u, 2676684u},
    {15667167926902953235u, 4832594103922189170u, 16862265480964451843u, 11578591152789311187u, 1709776u},
    {3701284353440114247u, 13605836807559738893u, 2086496536984526117u, 14587173807535405047u, 422714u},
    {12197580082039312981u, 651975335126833622u, 17288489082521913608u, 3610677413457944666u, 2216413u},
    {10372233314608114952u, 3294979415616911306u, 16303565836085379027u, 7102529822700257949u, 2468836u},
    {8379281098855260148u, 9469817349687790081u, 5048817145539843456u, 261714775068274425u, 969543u},
    {8359221498614001734u, 3131313860480746002u, 16061689145625431582u, 10033890483123154458u, 1596742u},
    {16047527233022311712u, 15008493486128422139u, 18254704813994209685u, 10117517866369544659u, 1747301u},
    {13431633294014141091u, 11383649682215752697u, 11395163958645332790u, 13507002109576778671u, 1946005u},
    {2303570254648237714u, 1146435751454644822u, 10501228757228747182u, 14519473871331676401u, 1156989u},
    {1333163425769524395u, 13865074266343946319u, 13767185576807187387u, 6074180593684517635u, 1929040u},
    {46856778868977869u, 9758655741094266143u, 2469027993911534492u, 5944307224372220019u, 642382u},
    {2658197053270832007u, 2067204648227469823u, 10300834019797393400u, 1885347307281991249u, 1193049u},
    {6176203657230312909u, 2445505671846195050u, 2359494138721059264u, 4057233137579706830u, 134825u},
    {18037472699269763545u, 15926028669604311608u, 16165509576852002555u, 5118576263019854483u, 612037u},
    {14823377214521436803u, 3401449665806070703u, 15905820847040632985u, 15287500031061939667u, 1208234u},
    {7384882450213487126u, 1020355106973971445u, 8285277843201541186u, 16595534627390079697u, 3498700u},
    {8272849193286988390u, 18405953490535987592u, 11602612749008398316u, 16781901456885503387u, 1184763u},
    {883070882227218264u, 13594634943560617786u, 7133916633692216760u, 17675965575923246126u, 2841833u},
    {15283123223200297443u, 514576071601435396u, 2228334483222877772u, 14535998985350702948u, 3359170u},
    {16342774056567289494u, 10863163254467074215u, 15728093703523687329u, 2583981555153559659u, 1650299u},
    {15841275911064916629u, 5850783657106788928u, 8778673497059133778u, 6083280545068026978u, 3447484u},
    {5908267239946698627u, 17225697457817193763u, 16811645385041461159u, 11520752313160030868u, 2089177u},
    {15617513574602379683u, 13756761955644901326u, 1411008073079355326u, 4578166949353892581u, 1062641u},
    {3363476286505317475u, 14907395304201165794u, 18311537502287428886u, 13782602732391633516u, 1813566u},
    {13042807331061450324u, 11481305878243901417u, 1432503548939507120u, 3996622073731420349u, 747732u},
    {2462222583469995172u, 15424409170948827182u, 3326967343446592968u, 6859264658439498984u, 3396692u},
    {3216451886159794026u, 8873892287696748757u, 13598077459860667315u, 16852077325717690390u, 80879u},
    {13300161897323700020u, 870453512796028835u, 10013646320090009407u, 650010317407366304u, 163890u},
    {15269930880572378409u, 10564090823288661197u, 15157921011338445495u, 15711578737804540623u, 997999u},
    {8033618099646580515u, 14584342803154656586u, 11211137982290625488u, 17312232416953101436u, 1253486u},
    {2085431468493294969u, 13308987919414353935u, 17893983930764097026u, 11336165016708896259u, 768202u},
    {2739785085886040378u, 9054098860478789442u, 12532915155713145327u, 8084621369275005673u, 1620993u},
    {5919624555129997446u, 14612748869056793667u, 8811647380937104380u, 6370970326438554404u, 2343612u},
    {5824454725027309029u, 10810535740740621790u, 2221567149263215580u, 13950347666463136564u, 3252895u},
    {16050699701533341508u, 16274974298630379565u, 6771151975815451162u, 1573214810310483754u, 3857040u},
    {13680677657561613724u, 9631928069010563378u, 5081347397332350105u, 5331354196104014827u, 2598446u},
    {12597296040757772392u, 16660322888888564874u, 12219189005255689014u, 12730069424358025221u, 1168241u},
    {12082233873067759928u, 9307582288761810190u, 11943393844676323519u, 18180063953031323816u, 1343739u},
    {4210674732954955712u, 11659894723426518232u, 3878539371775032277u, 14940709593466009104u, 3297599u},
    {156059311500304950u, 16934820994270939819u, 3050705715358029794u, 17066422172702423033u, 3667562u},
    {5064231191846840486u, 12595278117784204493u, 4543492559155005991u, 6264607681916687019u, 433998u},
    {5129372147209014759u, 1626260967190048193u, 16582290832078584674u, 5484383003181632615u, 2261363u},
    {7966338312863649062u, 9830547394430437762u, 17573202638305255068u, 9625374797047554543u, 3353252u},
    {6954607913532780054u, 13656151727418028661u, 7803153077675663482u, 15554239309238535738u, 2465298u},
    {2099481300910817146u, 3935981390835189134u, 7717330162951746518u, 10349712684249362167u, 3673158u},
    {7505849968572225612u, 10535976641773538338u, 8191931480828952878u, 12966067148707112057u, 2640589u},
    {3374830396944974688u, 5290057183961057906u, 16588306208288995838u, 18135166385972831715u, 1551541u},
    {4197222546812263988u, 6160308155834089739u, 7317306346839243329u, 7234380301674827377u, 3520506u},
    {15394466316450578138u, 13848917044924817632u, 7309800394298139198u, 12747078431101655956u, 1666430u},
    {17594039950095884347u, 14214805952365934411u, 3709766342475279102u, 4858599021015001951u, 2205676u},
    {2361397149026397220u, 11472144043852687185u, 18173259419737575197u, 256860327653906217u, 3817135u},
    {4387566362881303097u, 10301961087969924956u, 17739244624102270681u, 5258560483427471028u, 374259u},
    {9639093104562777560u, 15940994318013582773u, 9328953322465470357u, 12616982821886231746u, 2762027u},
    {9623888731499686604u, 14267693341566403254u, 11206717601626018853u, 12805144562523903265u, 1658005u},
    {17007086794673221723u, 6817001167342597634u, 12008633853133530328u, 18189098504270915239u, 3284525u},
    {636782839916649382u, 9177715466645630297u, 5394891231042971290u, 16705893033029152585u, 3273051u},
    {2665820023275265951u, 2113460190452749576u, 12090973767186782040u, 3158853694473993402u, 2741388u},
    {9191628439596698666u, 3987459269132961093u, 14009866977380679411u, 4446082922315196270u, 3656220u},
    {11603398802573217825u, 3800177797908164337u, 2299345895493359688u, 13686330632231641163u, 2005772u},
    {16528636602432211169u, 1118852733286124666u, 18365001295696229481u, 8611853666953967570u, 1358380u},
    {3517173599807896654u, 12523935079455491583u, 12508915185827759543u, 1177979201433546223u, 1787652u},
    {2070719908876905996u, 13168157042933205809u, 14738798278672366562u, 16966510959027899188u, 3537712u},
    {1211982096690225356u, 9025679068548238682u, 5431492175006289859u, 5973981995947092876u, 192432u},
    {14589370398559605178u, 2602438384085957613u, 7077332955622190992u, 14487126151453089208u, 2918778u},
    {10649833332604028188u, 883080468863725783u, 1839775992239978988u, 2936145726778217409u, 1018161u},
    {2625195838725942173u, 6262934287791442827u, 10350755594104594167u, 7440713944235555325u, 1539350u},
    {11505741548413126121u, 16981020527365191628u, 9511969974732911808u, 12494359771492111670u, 2610741u},
    {16140547119876312874u, 10675489121993625781u, 18218357269134676919u, 8550955780039596767u, 63644u},
    {1414729905939312775u, 3648914576978752162u, 13699390959254845946u, 145289221206638822u, 3132648u},
    {15928290128716508192u, 7646134581110144528u, 12126852489800462035u, 1426881442794938084u, 267221u},
    {1865250069213013514u, 2879344081310345692u, 16368113681662286917u, 8291552673186714822u, 424204u},
    {5484017421208222228u, 13208243099432870826u, 15134234328391113517u, 13842883246196760271u, 3670582u},
    {2625974193926316436u, 14505575909580343878u, 10819398793046970256u, 16208611365094305863u, 2583342u},
    {10467098268979730752u, 8412837169304718166u, 10792941582937904944u, 6028434570085495033u, 2268668u},
    {1083713869208429140u, 9416857730247463619u, 2417676793335125239u, 17191556925039497839u, 1351933u},
    {12403063047131787915u, 4508891749407683968u, 5245729520706425489u, 5573373520167810372u, 3063306u},
    {8829349595843402833u, 1900386844056150803u, 16425218301179454774u, 14251854052846635823u, 97667u},
    {117459780845903682u, 8501512094307888665u, 11516591863290328246u, 7639906620425662259u, 1430187u},
    {1355187415608129450u, 1320990942062059365u, 17020708407345530125u, 14221728326678256454u, 1473444u},
    {9606367267824808635u, 16680177849093924286u, 4603236651899086240u, 12925489591385771767u, 2846321u},
    {3702381338355888947u, 18091922591445404726u, 940350509216923830u, 1781887624874385100u, 2016383u},
    {10390954537738442558u, 8273901129574831817u, 12737661767786367059u, 4360651345213142471u, 3197519u},
    {12553045526615432957u, 4597442539285470866u, 18202936698205207139u, 4670669837451862940u, 1609902u},
    {14901175134682770800u, 12030145443338835364u, 324009182651181424u, 15666195361078785104u, 3313290u},
    {13564920481980050316u, 15608891959925831589u, 6503616262072713249u, 16994654027251241441u, 1607580u},
    {12873830498521464378u, 16839449486684451302u, 4391998603115600550u, 3560476741691136892u, 3270887u},
    {11601777282111108594u, 10627159943651020875u, 15638048064313850823u, 1213258723550347331u, 2820683u},
    {12651750107761443739u, 7019579507090263348u, 13488647752317920455u, 9923922801823449234u, 2745139u},
    {7102104874098104598u, 4144890853067097954u, 11751385025743216885u, 9562241299510169318u, 2456594u},
    {11397825277706991002u, 7697376888078018956u, 13885329539811591629u, 16186217234869109405u, 1012999u},
    {17238855046296666491u, 864352693738991770u, 17461056872497285422u, 10394980090947763720u, 1039315u},
    {10846985882467079536u, 5512801756553429383u, 10801431242370886002u, 13133654103114831885u, 3415985u},
    {13473976609243179299u, 13862475862340089596u, 14606383674187539978u, 11303998484105042841u, 23658u},
    {2355171608589129863u, 2120399417536181736u, 12491658603476324037u, 8719405302964574560u, 552976u},
    {12737723676474299529u, 14294493642979809128u, 18059063180677457771u, 730776555849588275u, 2759320u},
    {499651916919130155u, 6883035309171449345u, 15027628917426384810u, 10715424388201579323u, 1229274u},
    {3169964078436371255u, 3368075198642367590u, 10233997346506272107u, 2760864687031151191u, 1496801u},
    {579823486237560376u, 1774558687002997755u, 11059406128662811278u, 964359830230200385u, 2490380u},
    {10504941928421491853u, 5334368910795836908u, 7077175739650364719u, 2784127976911906191u, 1910172u},
    {8167757486676570120u, 2363946698158641724u, 9986036868799801790u, 8393917365204534474u, 981898u},
    {17526714861023357767u, 11924625840699328008u, 9540317399580911804u, 9385600054437036306u, 906764u},
    {18257726797966878648u, 4548426315752136399u, 5507587756123471937u, 5997507157976871910u, 1389369u},
    {11723646975043308132u, 12384955099424448558u, 18373735813776628740u, 13428341831419049019u, 3074429u},
    {7253083541313362450u, 17888768225731537210u, 8933320671842075491u, 15693211124594494726u, 3884489u},
    {3214010648839940262u, 6075595499217753660u, 770685607251628343u, 14122887027529298587u, 252075u},
    {11825798480085649313u, 16726882833127360730u, 13888586578198266737u, 14488226378758782498u, 3332350u},
    {7187596935871058393u, 5388019196404464956u, 1593062639875062679u, 4961387416681352051u, 2080312u},
    {2383393644995999907u, 4380758004711712275u, 7798107286895553563u, 17404255151159486857u, 2510892u},
    {6202110928415413848u, 181575493709185853u, 11726379923505184985u, 4802119006028223650u, 293867u},
    {12105027309286092918u, 17857255068777973292u, 15365450167400856674u, 4112703754304720162u, 3153293u},
    {3597131265826198444u, 10744547276321403086u, 8275055376518539547u, 12524131761634656495u, 2113353u},
    {16072058667760132274u, 2506127344700177893u, 12377487529108646666u, 6163879987676412623u, 2760439u},
    {15665354735905990917u, 12995447454617164657u, 11616505918399722351u, 15903591806272112628u, 2627548u},
    {3011601599634376777u, 14866583155002109996u, 3719420634760401257u, 4227810175600799479u, 1549244u},
    {2556227236578645537u, 17814917001908718329u, 3404859128413118257u, 17106228298792461088u, 1972814u},
    {9636673424864545878u, 6197988871309714215u, 2845013893137901594u, 7314209009899981070u, 114780u},
    {13442712771028838714u, 677556184042505743u, 4325125997796564453u, 2307960333812683344u, 3208725u},
    {4984647007472099186u, 2438695667500111157u, 15158297319229028848u, 10723714448799208542u, 490929u},
    {14538009261935049100u, 147857001869439079u, 4879160243986123422u, 9304485683237780349u, 1413964u},
    {11638916353426559755u, 3971380900565271922u, 12524346298034690227u, 9033282296082916335u, 3284627u},
    {11420606273305070829u, 11378403675418494147u, 8830891135026693769u, 6689889334169248791u, 2899403u},
    {5610127766520010465u, 14516679888452185771u, 4673188191423045558u, 16194385616293292693u, 1752611u},
    {3275587668249202120u, 10151225975233105003u, 4806521806832437465u, 11777717810954407355u, 3520529u},
    {3610015034906903839u, 11140973240548894001u, 18364328065831691288u, 2226670130382628504u, 316606u},
    {2163954512778246522u, 9754492326679472945u, 12572633006869290161u, 16362914198690512488u, 3691505u},
    {9421381769535914157u, 530381699252248966u, 530059234537237130u, 17506034021523293889u, 2287805u},
    {3312605620390140545u, 2401873697232291341u, 4761782914287340733u, 13300799873810327326u, 3655290u},
    {4828109956274340888u, 10931573541707301851u, 13591117689223913009u, 12461334386969594652u, 2240541u},
    {18223989369011169681u, 12531027050707814470u, 8427559367261534949u, 16398404545484629131u, 2466495u},
    {11846246526433894334u, 708859780113050894u, 18404963147594106608u, 621959570725912273u, 3549865u},
    {3447474195956473524u, 17261415624970776659u, 3195789833192781036u, 3740420747707503264u, 3036143u},
    {4584446581898186670u, 5975082455206458759u, 16225024713921676998u, 3514771470453146414u, 3758458u},
    {5858329512852352033u, 13880748248251095144u, 7391878619112761930u, 3960441394400666268u, 3542795u},
    {2428044430419004223u, 13910884111654169873u, 5867411013787967945u, 2299138451806825241u, 23701u},
    {9249713713118916373u, 13813402643114925011u, 16411626537853442258u, 437208580429441u, 0u},
    {7699487163811386042u, 12709233245113008371u, 10707033367384924378u, 437208u, 0u},
    {13926518256030955772u, 513788062702692973u, 8065074790011773u, 0u, 0u},
    {16488956846596042133u, 14573144992262313621u, 8065074u, 0u, 0u},
    {10185797813483916202u, 148774370586673980u, 0u, 0u, 0u},
    {10822224773950393825u, 148774370u, 0u, 0u, 0u},
    {2744402738939596879u, 0u, 0u, 0u, 0u},
    {2744402739u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1540556u},
    {904078173679462098u, 14163586007945680625u, 18434541478717816452u, 1325454934945920539u, 600908u},
    {1004820142061437307u, 3365784157202451710u, 3475142787575574685u, 1236063896058074506u, 1573892u},
    {8384868608267773599u, 390759836496135392u, 12360867653534364351u, 677551530501074193u, 2131654u},
    {3732543719049777218u, 17274240668129691060u, 766039004974216404u, 7533311856413756135u, 1758024u},
    {5872705225677787688u, 6827204710132356294u, 3392779016848650896u, 10913126526063869353u, 1363511u},
    {3398813597577870092u, 4671773711530531159u, 9174545888314431150u, 14076383186767761830u, 2475715u},
    {9474518539412297291u, 2192201293617057759u, 6396727092003485875u, 550072053346322581u, 319181u},
    {16838702129160675614u, 9409025734555220657u, 13662932913126400653u, 2239673265946028757u, 1111650u},
    {4584098874163625178u, 12973306701605360937u, 18445916880027987171u, 10252684678674979400u, 2350412u},
    {3405247285666595494u, 9028158329203638978u, 5678741489591895949u, 5375619417691127757u, 3799345u},
    {3805192046640300306u, 14535989716437370699u, 1394929455536692490u, 11527243002268889258u, 3380137u},
    {13274663295620744794u, 772602967433318758u, 17331465918791649492u, 5466672086544914584u, 3787487u},
    {16651958640706190201u, 6524028765430487370u, 1223822984738165158u, 10806448320489436519u, 2816795u},
    {14715570640739884941u, 16827735739772550321u, 17222382739300884147u, 5384222666086220280u, 3350744u},
    {4056516088574296926u, 4312477835684450682u, 16716856098086139070u, 2367653331622434455u, 1527436u},
    {3387171560428857677u, 5884053257383498298u, 5618343877839714228u, 17970517138792680018u, 2113798u},
    {16593140744617817791u, 7780711292102017198u, 10689474731011360913u, 6308003389999766673u, 225783u},
    {4264999070597363906u, 10120336286803155330u, 12770348909972014616u, 17658275506817542073u, 3625564u},
    {5818774878638668005u, 15060212740157368478u, 11301462277792531469u, 4462393105202734299u, 657322u},
    {15106522733450532689u, 10280176519824610799u, 1661436471874578738u, 11685455689314737647u, 3450173u},
    {3939605605646977783u, 6331811303613277813u, 2626211581253220054u, 4026812142112514874u, 12723u},
    {7698885683964010561u, 16201980564745474580u, 13608628738515656384u, 9223606738806437756u, 3768632u},
    {7891556450890197015u, 14106562268275389506u, 13505729601321452837u, 4681205017662986817u, 2281078u},
    {15507837186870087669u, 17748141484702323646u, 4503013772284444585u, 2996439822314419630u, 2485887u},
    {10483340713805471300u, 13369981288647878079u, 8346469574154228246u, 10854495629970791838u, 399122u},
    {534901262959620637u, 12903130144468328792u, 11637552597892394793u, 15355630042321333101u, 1301814u},
    {12965527977456514254u, 7556103540365421774u, 10122918761043339678u, 8094464777293131000u, 2330136u},
    {18030055712988907024u, 17750816569637202056u, 1059410836949459508u, 18057381940025386057u, 1016693u},
    {12820651399067426396u, 17109588091600588497u, 3440538117164202673u, 15367022223708564293u, 3444947u},
    {16084365219378242924u, 976994794358258557u, 7737461809819789666u, 5756098000019822666u, 3205629u},
    {5508420872970120702u, 8024402774543949863u, 4742088458098632116u, 8778102302103639732u, 2046344u},
    {9556729334178466681u, 5990688834177661958u, 14678657845388294554u, 17619801338087289784u, 1279928u},
    {9866761533817578658u, 705415784900895178u, 1255364258120253804u, 13354265418885244417u, 3698212u},
    {6729843488480112948u, 10748887298434761743u, 3433953810317462502u, 9003361644351651031u, 3851350u},
    {9568062572236918676u, 15175106994976934272u, 17855205528083298035u, 5619479617712093997u, 2273278u},
    {17934506629697502338u, 11083171959437796479u, 14584203316167085899u, 7535924363038379263u, 2691539u},
    {7361784473413185569u, 6340066462196931235u, 16331940854922946251u, 770226079012611855u, 494719u},
    {13889106192676433855u, 15167923773085578715u, 12516627933512613729u, 16222084614085413194u, 2978124u},
    {12719995684423868506u, 5851745843582434137u, 14430179140578810094u, 1496088588228415518u, 1336151u},
    {4307749082520391479u, 6143472604565925u, 6081624684932448026u, 15805260731343137663u, 693066u},
    {13010901898796067300u, 8587430311694141554u, 8179882508686158090u, 17450722584112010827u, 3405332u},
    {12021938255506228387u, 874152730332388204u, 17259278079078770146u, 10222938064688575054u, 625485u},
    {15063930794007491050u, 2293180611553330234u, 10719565588094164199u, 17881821493346010411u, 2783734u},
    {8681552403417814134u, 13305545726232293467u, 5611952517742741127u, 6464476715924691582u, 709223u},
    {1173358642600918118u, 5273856389088123798u, 4619912349559011196u, 229255643750449033u, 2375053u},
    {15198679563144364989u, 10570089358376697019u, 8202984508526084796u, 3502576508902292663u, 1924336u},
    {5923466083595497864u, 11493639034952884351u, 11452101004768737733u, 13222037446147214740u, 581905u},
    {12359672694348336816u, 9630330336384771909u, 14394422745565055666u, 15503116983986755642u, 2814437u},
    {2832358642448155239u, 12707287035643183412u, 5685947558538843861u, 13382572111570364033u, 283500u},
    {11702445397231006714u, 14942733195818118124u, 8365599051855783648u, 8291852979689181409u, 3088879u},
    {343079567748043648u, 10383458566950489949u, 14301020476213168676u, 6181875261903383425u, 2604679u},
    {13794983408015568891u, 9897344133389693923u, 1789236218793071511u, 11000802146854087255u, 321788u},
    {3203775682346727195u, 208981679322129673u, 913052276652885055u, 2023548584944775204u, 520989u},
    {1039284417674975256u, 2325483313178186412u, 9807090255698682974u, 13988783796129786034u, 2526192u},
    {14774918412498352773u, 9077079581901383310u, 13755964071204873965u, 13521370116386360307u, 1983537u},
    {7945582581033035477u, 4460052850434627212u, 4982578094757019517u, 1477741693679662459u, 367062u},
    {12084066183504888038u, 2000835932529550653u, 2120170097180703685u, 9518373513257413221u, 423672u},
    {12621068634950111523u, 14849725882083644179u, 7557025497851265730u, 6132710871697444746u, 3721070u},
    {2890471162310541348u, 901182234177056317u, 17140601448519792725u, 3023002987658114648u, 510481u},
    {5875663953457929627u, 16117551711704116485u, 5102405288399142716u, 4188757169584314601u, 3438667u},
    {11240785985912004044u, 3207097150066975418u, 5737868474539708183u, 6692730865781837884u, 1984000u},
    {5392209276600990866u, 2040813604352673851u, 3467653710379624856u, 13367253243951638776u, 2928325u},
    {1373142485440047843u, 10156372788821244421u, 12683279809553682669u, 558421233472394318u, 154590u},
    {10088287718898662792u, 1637768301958739914u, 1046147298479430063u, 12540873045324236857u, 3838030u},
    {8382945654962021397u, 17432406594839547373u, 13152405614945294473u, 17220506550724941283u, 1481071u},
    {6085496115510708038u, 9452244073083397856u, 855966182148813629u, 9899211338108626862u, 656996u},
    {12461214807959205110u, 8774540571560545817u, 12583121771147751381u, 9091376295747582154u, 1975491u},
    {11708437591864534469u, 7906959649288096040u, 10681137252376679858u, 7170143195743158515u, 538274u},
    {9005256123322193176u, 16461081984053445096u, 17150109512282048814u, 14061160247285622650u, 1764702u},
    {11394625986998462509u, 8274791146452059548u, 8143888550188490113u, 11849998442441705144u, 517599u},
    {6762918096303769006u, 7205611118691976195u, 11964468341814776615u, 17663658567428150752u, 1967888u},
    {11797331007011406337u, 16486164630011673875u, 9936481854002130305u, 7242060547758176309u, 309033u},
    {4286695480545008763u, 17651278002885758627u, 11487223570325089917u, 5193847430634202623u, 3462465u},
    {17463758167207317243u, 11532493511310247792u, 4986082309779497177u, 9575473623919511725u, 1574936u},
    {10915530257427584461u, 1141144985595475793u, 5596895283372116133u, 8459790953337513962u, 1023196u},
    {13480530257865766761u, 7760768457000789309u, 13148815163676279705u, 15511257361363540511u, 2287560u},
    {2623318221264352498u, 9888982977994898296u, 4763640550927807361u, 14237544074856315775u, 3340272u},
    {1804272055976129544u, 1879830092988405287u, 4644803960888649203u, 16058403033378123818u, 2574543u},
    {13706537211494915814u, 7843623816527460091u, 9670434528829617307u, 12513455720447696371u, 3251327u},
    {1721401674174942786u, 18421010043466867291u, 14290522988867978258u, 9571578822588885127u, 2687623u},
    {10443316817849052247u, 2715408301777278064u, 15342782312785135453u, 15181672651184060868u, 2111111u},
    {3423925560684392118u, 14240623690643340304u, 7483221397753795263u, 9838775928668064992u, 2975436u},
    {13988282617940424396u, 8157466623742595607u, 1663334951616171824u, 7044473737917487774u, 1046472u},
    {12940484082412873089u, 1787449663932722962u, 15055983963195421818u, 7297121006039498255u, 2287536u},
    {3160930517390123042u, 4077916825975617127u, 16693499695570580724u, 8833224071075726450u, 2431987u},
    {1381341323079770031u, 15057468375105615100u, 7040521640534883711u, 4728605863078128582u, 3644817u},
    {9984069646975714766u, 5961909762186684034u, 16057943370212272689u, 14550811412746626825u, 2716226u},
    {15618067847997364841u, 6830035111890463160u, 5429762996982709491u, 1491257421177725933u, 526699u},
    {17612017261650007669u, 2833991063088576508u, 5613741145651813562u, 15285925819188858600u, 3732828u},
    {2307027086434314483u, 13100669749176803914u, 6059914961270078291u, 8931942604738239025u, 3230019u},
    {10763077384128097823u, 959052786086975504u, 17328866389835023774u, 15984311625160235712u, 2387054u},
    {1701884517939408263u, 8382661492187075042u, 3383409138886446030u, 116090984250364241u, 1937613u},
    {281528048542319076u, 3329711358917947429u, 12648874289035472423u, 15167837399205850129u, 1397326u},
    {1195845547268139034u, 10370714197919032173u, 2346959799831942777u, 9897666513473504904u, 2815489u},
    {3005641884876509802u, 10203071707451176651u, 4487818495502629499u, 4303334663160759169u, 1266538u},
    {16473148086684461119u, 12072581076881388933u, 4526546496042293639u, 7301180504479684147u, 162727u},
    {17475983832815597149u, 8509957189937723793u, 12645261126416892290u, 147116978699918910u, 1999418u},
    {11874020146477450709u, 16404384367219394138u, 17946438835391803619u, 1550092227085971838u, 2678275u},
    {1973856414590841087u, 9454181902520318817u, 8122364078342875888u, 8624259145547531060u, 786554u},
    {43858408834441960u, 10507845989768630290u, 3860946412983000532u, 4049734635086376104u, 3442176u},
    {15824338739993563451u, 3629449517124298489u, 11616514635193128100u, 16276455602312185484u, 3533072u},
    {6023033602844113210u, 4470440704636992986u, 4781946452578213612u, 6190069184478319315u, 3699690u},
    {15680928887603285131u, 13689795336621411220u, 9159147027366211768u, 3815242130744384347u, 1954080u},
    {7310873025489415729u, 6402994008882896669u, 6754784979946423725u, 2990407773029841867u, 2060104u},
    {11627274347760088389u, 7269533881189041818u, 2807039779625826363u, 5730552143239940059u, 256701u},
    {17766546702675835358u, 16258561101635609821u, 15667167926902953234u, 4832594103922189170u, 3198891u},
    {18045819253810905730u, 8242876877049471539u, 3701284353440114246u, 13605836807559738893u, 187403u},
    {5810731245006379360u, 11765409046999019254u, 12197580082039312980u, 651975335126833622u, 2839942u},
    {9907019409190139115u, 8694350492903215041u, 10372233314608114951u, 3294979415616911306u, 1641077u},
    {442286247814747997u, 15876440415135371519u, 8379281098855260147u, 9469817349687790081u, 1780114u},
    {18010241554594003875u, 4895157648546612988u, 8359221498614001733u, 3131313860480746002u, 1112062u},
    {1223277035579335287u, 18203675703823783972u, 16047527233022311711u, 15008493486128422139u, 3827635u},
    {10552723589455127495u, 6204099281885912911u, 13431633294014141090u, 11383649682215752697u, 3554656u},
    {2186952997894852460u, 5316140949536382147u, 2303570254648237713u, 1146435751454644822u, 1627182u},
    {14430818881780355480u, 12133660565912263788u, 1333163425769524394u, 13865074266343946319u, 1674037u},
    {10996032362041147723u, 11702499529279420900u, 46856778868977868u, 9758655741094266143u, 2688388u},
    {14905733729414740887u, 7904206346535845331u, 2658197053270832006u, 2067204648227469823u, 3664878u},
    {9847351672138041052u, 667003688907869522u, 6176203657230312908u, 2445505671846195050u, 70494u},
    {6226002550061086054u, 13049097114691790471u, 18037472699269763544u, 15926028669604311608u, 799205u},
    {7624159291066871567u, 13473770321506314236u, 14823377214521436802u, 3401449665806070703u, 626061u},
    {10626108433130041089u, 12501315417526065413u, 7384882450213487125u, 1020355106973971445u, 1694988u},
    {16149175934025294802u, 2775769639581855464u, 8272849193286988389u, 18405953490535987592u, 2591636u},
    {1513258301030481626u, 14969884727127764933u, 883070882227218263u, 13594634943560617786u, 551474u},
    {7959642067361802353u, 16350208592177845936u, 15283123223200297442u, 514576071601435396u, 2955760u},
    {16937611226632532397u, 827962533656455536u, 16342774056567289493u, 10863163254467074215u, 765367u},
    {17548500105609381013u, 5716927947753719229u, 15841275911064916628u, 5850783657106788928u, 213180u},
    {6993502421825756593u, 15060186688951328061u, 5908267239946698626u, 17225697457817193763u, 3568059u},
    {8340611757723878208u, 16010916798416924798u, 15617513574602379682u, 13756761955644901326u, 3444018u},
    {16296549054626744064u, 13069383641682860480u, 3363476286505317474u, 14907395304201165794u, 1309088u},
    {16172876224247917087u, 2221960253637162591u, 13042807331061450323u, 11481305878243901417u, 221396u},
    {5841909118310080971u, 10736056169048747543u, 2462222583469995171u, 15424409170948827182u, 585914u},
    {13088662489765983317u, 11249785013507826579u, 3216451886159794025u, 8873892287696748757u, 312379u},
    {6619074648908899452u, 14048102483765016204u, 13300161897323700019u, 870453512796028835u, 2368011u},
    {11370582719747536889u, 13995201541098047928u, 15269930880572378408u, 10564090823288661197u, 1556307u},
    {10287069603226724197u, 4550364480329048615u, 8033618099646580514u, 14584342803154656586u, 2731680u},
    {3885875548003101957u, 701890684455061224u, 2085431468493294968u, 13308987919414353935u, 2542432u},
    {10348843757148150392u, 1051555170884177777u, 2739785085886040377u, 9054098860478789442u, 3096203u},
    {9484549332387288493u, 14675864654156864240u, 5919624555129997445u, 14612748869056793667u, 102816u},
    {7896122316982008956u, 13972918206926162287u, 5824454725027309028u, 10810535740740621790u, 3361874u},
    {9664339229776892038u, 1605792996299078301u, 16050699701533341507u, 16274974298630379565u, 2616616u},
    {17118213061619958870u, 17701891168270651280u, 13680677657561613723u, 9631928069010563378u, 814163u},
    {2023276981202444820u, 15413802354667261701u, 12597296040757772391u, 16660322888888564874u, 658796u},
    {15224564902275484035u, 12168869765742950172u, 12082233873067759927u, 9307582288761810190u, 3177909u},
    {10038594694525961628u, 10467650518699960966u, 4210674732954955711u, 11659894723426518232u, 69735u},
    {7757008890328808497u, 17522613543373110732u, 156059311500304949u, 16934820994270939819u, 3103894u},
    {11843580850767798382u, 15486265186599723263u, 5064231191846840485u, 12595278117784204493u, 2222283u},
    {314155423669739925u, 7167025333454709018u, 5129372147209014758u, 1626260967190048193u, 1665042u},
    {4381813503887002090u, 169079137104344194u, 7966338312863649061u, 9830547394430437762u, 2020218u},
    {7948878561084044696u, 1648951888820549710u, 6954607913532780053u, 13656151727418028661u, 2432478u},
    {10626100501354808664u, 17445347760581689306u, 2099481300910817145u, 3935981390835189134u, 843938u},
    {1971757321441285885u, 8225613806389526368u, 7505849968572225611u, 10535976641773538338u, 1618324u},
    {6380178621372636912u, 6906452928195309720u, 3374830396944974687u, 5290057183961057906u, 1919724u},
    {17313851164754401555u, 3431259078700775533u, 4197222546812263987u, 6160308155834089739u, 751297u},
    {10372689452365096651u, 17911615892818935997u, 15394466316450578137u, 13848917044924817632u, 1054924u},
    {2897014773587429155u, 8180776707988378295u, 17594039950095884346u, 14214805952365934411u, 812424u},
    {7777400965550719315u, 3594751447448998573u, 2361397149026397219u, 11472144043852687185u, 3782929u},
    {10789467799732410577u, 8866848183728360230u, 4387566362881303096u, 10301961087969924956u, 881783u},
    {4158502469481303567u, 11291953770529028639u, 9639093104562777559u, 15940994318013582773u, 15705u},
    {15013678664000545694u, 15783130292954237938u, 9623888731499686603u, 14267693341566403254u, 2362873u},
    {11714169827904183200u, 14586175455503930952u, 17007086794673221722u, 6817001167342597634u, 1431202u},
    {8087233391720359610u, 5311710049991953286u, 636782839916649381u, 9177715466645630297u, 1289656u},
    {15594678038697851528u, 93312288359503531u, 2665820023275265950u, 2113460190452749576u, 1316850u},
    {5556509578925722509u, 15222518215643797193u, 9191628439596698665u, 3987459269132961093u, 2883051u},
    {17409980559946486622u, 14875587418839928010u, 11603398802573217824u, 3800177797908164337u, 2059378u},
    {16452926909362407899u, 4740274301744084685u, 16528636602432211168u, 1118852733286124666u, 3142631u},
    {257797784335315953u, 13026208177357473388u, 3517173599807896653u, 12523935079455491583u, 2909723u},
    {3580094136300395957u, 2625552195304332938u, 2070719908876905995u, 13168157042933205809u, 1001792u},
    {2939090111373254618u, 14838053484034791839u, 1211982096690225355u, 9025679068548238682u, 453467u},
    {12421427668156257553u, 24966188755549391u, 14589370398559605177u, 2602438384085957613u, 996888u},
    {17464410673573424684u, 10204862654594056954u, 10649833332604028187u, 883080468863725783u, 3576848u},
    {9512229656662892498u, 5949336973082271947u, 2625195838725942172u, 6262934287791442827u, 2574217u},
    {9250127997181508968u, 10791908947781340937u, 11505741548413126120u, 16981020527365191628u, 594424u},
    {7336881249548834599u, 9900705351929303069u, 16140547119876312873u, 10675489121993625781u, 2495555u},
    {15852767596427646366u, 7825165090090977887u, 1414729905939312774u, 3648914576978752162u, 435286u},
    {4164108975024181834u, 15527417372620270869u, 15928290128716508191u, 7646134581110144528u, 3745805u},
    {4155527058377087613u, 15963951037984353563u, 1865250069213013513u, 2879344081310345692u, 1176543u},
    {3397644016946186518u, 5558527763777123775u, 5484017421208222227u, 13208243099432870826u, 1192595u},
    {15507815876386770101u, 8432843521302579493u, 2625974193926316435u, 14505575909580343878u, 2935816u},
    {12830410701837614819u, 16248471028938505516u, 10467098268979730751u, 8412837169304718166u, 2676380u},
    {2814148736592346052u, 15978501240134938955u, 1083713869208429139u, 9416857730247463619u, 2240011u},
    {15856428274479365219u, 1528376569773088552u, 12403063047131787914u, 4508891749407683968u, 1457677u},
    {7764189881573143878u, 11326815785200114790u, 8829349595843402832u, 1900386844056150803u, 3836644u},
    {7530910835291760451u, 13376548452244001496u, 117459780845903681u, 8501512094307888665u, 1298562u},
    {15471317171142539274u, 15669819066637247296u, 1355187415608129449u, 1320990942062059365u, 1890503u},
    {14589511604198080425u, 7268306001383344473u, 9606367267824808634u, 16680177849093924286u, 296338u},
    {9466726682799748530u, 18155339721147335260u, 3702381338355888946u, 18091922591445404726u, 3216578u},
    {7192439757233657564u, 9812629867079793544u, 10390954537738442557u, 8273901129574831817u, 3134109u},
    {18317264023065382596u, 15811839438892174126u, 12553045526615432956u, 4597442539285470866u, 3717991u},
    {11322313689630372691u, 3433996233938563141u, 14901175134682770799u, 12030145443338835364u, 2409728u},
    {13672848411926487610u, 7791222004617486919u, 13564920481980050315u, 15608891959925831589u, 2712135u},
    {308475746785688610u, 5092531751518030604u, 12873830498521464377u, 16839449486684451302u, 1880744u},
    {1796789832904061591u, 285401997315653831u, 11601777282111108593u, 10627159943651020875u, 1625917u},
    {7466499539832193592u, 1531038160995408566u, 12651750107761443738u, 7019579507090263348u, 2038733u},
    {6583728375798499787u, 4551537717681461310u, 7102104874098104597u, 4144890853067097954u, 3213137u},
    {11435428817408918835u, 8157071521688938923u, 11397825277706991001u, 7697376888078018956u, 3887903u},
    {9632955492475691299u, 11802977003364200044u, 17238855046296666490u, 864352693738991770u, 1974582u},
    {16669851794348539926u, 7822862071335879122u, 10846985882467079535u, 5512801756553429383u, 1486322u},
    {10696858162058835521u, 1924314451149523111u, 13473976609243179298u, 13862475862340089596u, 1665832u},
    {7809427767689479458u, 16527135784102033881u, 2355171608589129862u, 2120399417536181736u, 1468553u},
    {15276080392366520538u, 1401185292256059831u, 12737723676474299528u, 14294493642979809128u, 2036341u},
    {12260093194694347044u, 1895824868905295605u, 499651916919130154u, 6883035309171449345u, 2896222u},
    {17555760831632995429u, 11908127883988419599u, 3169964078436371254u, 3368075198642367590u, 2449019u},
    {14374184957872657261u, 8091818477727790764u, 579823486237560375u, 1774558687002997755u, 114218u},
    {8002997665733353380u, 13249629666246797761u, 10504941928421491852u, 5334368910795836908u, 3149807u},
    {13998490921562678851u, 7137491190065604893u, 8167757486676570119u, 2363946698158641724u, 1904012u},
    {1547609770353626319u, 2519042644488888813u, 17526714861023357766u, 11924625840699328008u, 476934u},
    {13302669914979119455u, 6942885887670357502u, 18257726797966878647u, 4548426315752136399u, 3421011u},
    {5687977068230080556u, 3155342273189579349u, 11723646975043308131u, 12384955099424448558u, 1002068u},
    {9841677776484604660u, 7348608539637980837u, 7253083541313362449u, 17888768225731537210u, 1233691u},
    {3340803442928717488u, 7237725866180453790u, 3214010648839940261u, 6075595499217753660u, 516135u},
    {4205331661686063458u, 49757904214012610u, 11825798480085649312u, 16726882833127360730u, 3022605u},
    {11721757774590092179u, 12175807958206653432u, 7187596935871058392u, 5388019196404464956u, 3106367u},
    {6485131307743031564u, 13506109086307716410u, 2383393644995999906u, 4380758004711712275u, 2030727u},
    {8235406821369904916u, 10970183123113389469u, 6202110928415413847u, 181575493709185853u, 3199987u},
    {1610041810677320364u, 2367701723018100253u, 12105027309286092917u, 17857255068777973292u, 431824u},
    {8759244228384518416u, 17954373415376389274u, 3597131265826198443u, 10744547276321403086u, 3044935u},
    {17112272268339181634u, 15396773796530421186u, 16072058667760132273u, 2506127344700177893u, 1359618u},
    {3809258017889076053u, 6440517805535548814u, 15665354735905990916u, 12995447454617164657u, 1231587u},
    {8198205565068486753u, 15880567705847334680u, 3011601599634376776u, 14866583155002109996u, 904835u},
    {18199023346037721972u, 5879347615218849303u, 2556227236578645536u, 17814917001908718329u, 56149u},
    {15834869727639248065u, 13179426539624873057u, 9636673424864545877u, 6197988871309714215u, 1574144u},
    {1357096595550192041u, 1294241673646824990u, 13442712771028838713u, 677556184042505743u, 3295707u},
    {3148203949496330746u, 9902005487400694918u, 4984647007472099185u, 2438695667500111157u, 202844u},
    {15576775542422263261u, 3424818105855087223u, 14538009261935049099u, 147857001869439079u, 445240u},
    {7260366780895393391u, 17002736695733432984u, 11638916353426559754u, 3971380900565271922u, 3543249u},
    {9674818916683131267u, 11701622944870114352u, 11420606273305070828u, 11378403675418494147u, 1794543u},
    {13692039720283749527u, 1592820800873292713u, 5610127766520010464u, 14516679888452185771u, 3424062u},
    {14010277511271105771u, 13276503042535076822u, 3275587668249202119u, 10151225975233105003u, 2390869u},
    {6471341372712273431u, 14409346366259273542u, 3610015034906903838u, 11140973240548894001u, 1448338u},
    {1944619869357834866u, 3189803288896179221u, 2163954512778246521u, 9754492326679472945u, 1408299u},
    {7122084624130929543u, 6577167879225709102u, 9421381769535914156u, 530381699252248966u, 1299584u},
    {9326211867424540087u, 5762348098610278518u, 3312605620390140544u, 2401873697232291341u, 2758039u},
    {5009601887865721080u, 17254943921907397308u, 4828109956274340887u, 10931573541707301851u, 3527087u},
    {7159913863329957729u, 5365987697082972516u, 18223989369011169680u, 12531027050707814470u, 3271115u},
    {14859641067522573216u, 825429821604402467u, 11846246526433894333u, 708859780113050894u, 2149466u},
    {17268915697880302703u, 6775886312839087317u, 3447474195956473523u, 17261415624970776659u, 3597368u},
    {18332627311709927168u, 8006851238312284880u, 4584446581898186669u, 5975082455206458759u, 2476870u},
    {10753540691722007242u, 16473199484314659826u, 5858329512852352032u, 13880748248251095144u, 204288u},
    {13990218242125693870u, 7917860262335023622u, 2428044430419004222u, 13910884111654169873u, 2732307u},
    {11103879885768428522u, 8916749932738042576u, 9249713713118916372u, 13813402643114925011u, 1468914u},
    {3075822809314133235u, 17625180187436902236u, 7699487163811386041u, 12709233245113008371u, 508756u},
    {16552448739512879814u, 4860206346044478241u, 13926518256030955771u, 513788062702692973u, 949273u},
    {8331978764843304750u, 17864225913574618247u, 16488956846596042132u, 14573144992262313621u, 252574u},
    {5839133096847019109u, 9512827516038136664u, 10185797813483916201u, 148774370586673980u, 0u},
    {15483871580745470487u, 1071163349222448987u, 10822224773950393824u, 148774370u, 0u},
    {5003703160224186616u, 11128473256515883940u, 2744402738939596878u, 0u, 0u},
    {12716056207320828136u, 17332503152050969833u, 2744402738u, 0u, 0u},
    {13903208475620639509u, 13731806812987167191u, 2u, 0u, 0u},
    {7494366531701931190u, 50625294960u, 0u, 0u, 0u},
    {11534656105194817662u, 50u, 0u, 0u, 0u},
    {933871859791u, 0u, 0u, 0u, 0u},
    {934u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2184536u},
    {12244510716637114204u, 10722066986224769282u, 904078173679462097u, 14163586007945680625u, 2772024u},
    {10701501129329870842u, 17731177191384858407u, 1004820142061437306u, 3365784157202451710u, 1651883u},
    {5807363968998846294u, 9195191221918963949u, 8384868608267773598u, 390759836496135392u, 2844713u},
    {4563132662752990216u, 9809963713305183656u, 3732543719049777217u, 17274240668129691060u, 2916008u},
    {18098817381967301812u, 90717868984254388u, 5872705225677787687u, 6827204710132356294u, 3257360u},
    {15706022854192763404u, 4456271295806643188u, 3398813597577870091u, 4671773711530531159u, 1651970u},
    {1684609589779182507u, 1173975792645367037u, 9474518539412297290u, 2192201293617057759u, 2251807u},
    {16520495454057883572u, 7566611402803206815u, 16838702129160675613u, 9409025734555220657u, 159365u},
    {2251702846448775927u, 10888979572083986433u, 4584098874163625177u, 12973306701605360937u, 1136193u},
    {17925838737148579452u, 13910253949438099204u, 3405247285666595493u, 9028158329203638978u, 2841331u},
    {1173257877282329777u, 11281509911607430784u, 3805192046640300305u, 14535989716437370699u, 2820390u},
    {1157548834637506747u, 15037559420173007899u, 13274663295620744793u, 772602967433318758u, 2105808u},
    {12867249683952773143u, 7978109263952246693u, 16651958640706190200u, 6524028765430487370u, 2077132u},
    {12979403722914827368u, 6554207719727558788u, 14715570640739884940u, 16827735739772550321u, 3311141u},
    {10187648664040998726u, 16516937432483800529u, 4056516088574296925u, 4312477835684450682u, 2568916u},
    {7222547002551930158u, 14026917731629086510u, 3387171560428857676u, 5884053257383498298u, 3824454u},
    {9816464343944114683u, 16302351926383293145u, 16593140744617817790u, 7780711292102017198u, 1749529u},
    {3622720236428547969u, 9941208320000067899u, 4264999070597363905u, 10120336286803155330u, 9518u},
    {1477454836910666396u, 13549417482812400593u, 5818774878638668004u, 15060212740157368478u, 2601985u},
    {14548533568643765997u, 3622361543222987824u, 15106522733450532688u, 10280176519824610799u, 3404428u},
    {4737648960800460493u, 788801964828018628u, 3939605605646977782u, 6331811303613277813u, 3311126u},
    {14143505403593523432u, 15560438218067468558u, 7698885683964010560u, 16201980564745474580u, 2999522u},
    {8488411524057763881u, 975018759137188843u, 7891556450890197014u, 14106562268275389506u, 1191177u},
    {5876446359259012306u, 13271739170260239289u, 15507837186870087668u, 17748141484702323646u, 2131887u},
    {7794009568343891591u, 15877058699233878719u, 10483340713805471299u, 13369981288647878079u, 261336u},
    {17011771546415045912u, 737172104517828994u, 534901262959620636u, 12903130144468328792u, 3367193u},
    {5708139289424770433u, 7004441158229441692u, 12965527977456514253u, 7556103540365421774u, 1336194u},
    {2874469582591104873u, 4759988642859161076u, 18030055712988907023u, 17750816569637202056u, 1731378u},
    {3271796951840116992u, 17644234839804799596u, 12820651399067426395u, 17109588091600588497u, 2181743u},
    {6356439507724219721u, 11647926410421171731u, 16084365219378242923u, 976994794358258557u, 1409996u},
    {7731449317865794313u, 9657520062540456068u, 5508420872970120701u, 8024402774543949863u, 537142u},
    {4100206586186202244u, 17019852661028878938u, 9556729334178466680u, 5990688834177661958u, 3084416u},
    {14474300497359745022u, 5263972203052623459u, 9866761533817578657u, 705415784900895178u, 667098u},
    {3924326166898501925u, 9960522252921046887u, 6729843488480112947u, 10748887298434761743u, 2331698u},
    {10719854100283269179u, 16902233675467226855u, 9568062572236918675u, 15175106994976934272u, 3163705u},
    {5628385098724818994u, 1562562962257935067u, 17934506629697502337u, 11083171959437796479u, 3851941u},
    {15559021014900100809u, 1016387874567616470u, 7361784473413185568u, 6340066462196931235u, 1942295u},
    {857014310106953133u, 13249242000844658152u, 13889106192676433854u, 15167923773085578715u, 817527u},
    {10045238090569116794u, 14884246263194618838u, 12719995684423868505u, 5851745843582434137u, 333038u},
    {7445187784844612246u, 2816213242902678964u, 4307749082520391478u, 6143472604565925u, 681780u},
    {14105839516085788787u, 14557210420332707385u, 13010901898796067299u, 8587430311694141554u, 512914u},
    {14736995701331896144u, 10703932578532182127u, 12021938255506228386u, 874152730332388204u, 3219820u},
    {6427171179710072237u, 7452926784938038249u, 15063930794007491049u, 2293180611553330234u, 2545079u},
    {11406044685022700441u, 10479119703324870604u, 8681552403417814133u, 13305545726232293467u, 740077u},
    {5285923306377695787u, 17406881142929832067u, 1173358642600918117u, 5273856389088123798u, 2693192u},
    {17636803975309009989u, 15264371515630627511u, 15198679563144364988u, 10570089358376697019u, 1977670u},
    {13202890053527580946u, 8640182148938563475u, 5923466083595497863u, 11493639034952884351u, 2530003u},
    {6760802311907010808u, 18390914033733215900u, 12359672694348336815u, 9630330336384771909u, 1363410u},
    {7324903314963847459u, 6491717669043473597u, 2832358642448155238u, 12707287035643183412u, 1453439u},
    {3354640416928608856u, 5673226306988027204u, 11702445397231006713u, 14942733195818118124u, 388416u},
    {1532310011728297039u, 15033889693085676811u, 343079567748043647u, 10383458566950489949u, 1379850u},
    {16736024518438171634u, 11627219494866229843u, 13794983408015568890u, 9897344133389693923u, 3516419u},
    {13105994692456874738u, 3421769986036305538u, 3203775682346727194u, 208981679322129673u, 1064703u},
    {17528000640917020676u, 7881672644244899590u, 1039284417674975255u, 2325483313178186412u, 3788220u},
    {11713362674684815941u, 4808427321810247967u, 14774918412498352772u, 9077079581901383310u, 3498699u},
    {13740042264026013976u, 7326631256422344989u, 7945582581033035476u, 4460052850434627212u, 2996783u},
    {14964523523968407204u, 12856571109785258062u, 12084066183504888037u, 2000835932529550653u, 317753u},
    {1490484207866844435u, 10877522083268836253u, 12621068634950111522u, 14849725882083644179u, 1978186u},
    {10096956065417169518u, 8777949623524365721u, 2890471162310541347u, 901182234177056317u, 2640479u},
    {14327903582165929274u, 6973368123940145461u, 5875663953457929626u, 16117551711704116485u, 1982084u},
    {12490816177289485778u, 16186532597816920368u, 11240785985912004043u, 3207097150066975418u, 1257727u},
    {9320030331960683422u, 5093146848147734968u, 5392209276600990865u, 2040813604352673851u, 3703072u},
    {16941053980732885222u, 15343575845624322149u, 1373142485440047842u, 10156372788821244421u, 2846097u},
    {8684518844656174627u, 14976347242887146027u, 10088287718898662791u, 1637768301958739914u, 3606405u},
    {4062341010919400395u, 15440653358828433104u, 8382945654962021396u, 17432406594839547373u, 688427u},
    {7186274481024956686u, 12742012409982966159u, 6085496115510708037u, 9452244073083397856u, 3012547u},
    {864200433802304966u, 2279681203874328896u, 12461214807959205109u, 8774540571560545817u, 2855891u},
    {6310353119153559092u, 8059062935135795434u, 11708437591864534468u, 7906959649288096040u, 1732042u},
    {2481891251585437106u, 2147353388344903584u, 9005256123322193175u, 16461081984053445096u, 3264826u},
    {17427381721044735915u, 5373812643237496984u, 11394625986998462508u, 8274791146452059548u, 3898211u},
    {7801512811493552386u, 2918224964051712103u, 6762918096303769005u, 7205611118691976195u, 3091775u},
    {15264579327043993593u, 12431713240589499524u, 11797331007011406336u, 16486164630011673875u, 3752697u},
    {12601542962442787917u, 13077545621379998598u, 4286695480545008762u, 17651278002885758627u, 177725u},
    {9369663990226360517u, 1841309623648991718u, 17463758167207317242u, 11532493511310247792u, 3267843u},
    {8733855779361309329u, 14948476265124840928u, 10915530257427584460u, 1141144985595475793u, 2743351u},
    {11720459681738149356u, 5638155181144408463u, 13480530257865766760u, 7760768457000789309u, 926591u},
    {6206113069559735614u, 3015426540437604971u, 2623318221264352497u, 9888982977994898296u, 343293u},
    {8398352980472763398u, 10370085126738345711u, 1804272055976129543u, 1879830092988405287u, 3328699u},
    {1588400717882288983u, 6185176308833605897u, 13706537211494915813u, 7843623816527460091u, 2511205u},
    {3278205589252927784u, 16396155106342634763u, 1721401674174942785u, 18421010043466867291u, 2671328u},
    {14577666919188495866u, 13537486430348377220u, 10443316817849052246u, 2715408301777278064u, 2454507u},
    {17952928660143757465u, 11765994920885409822u, 3423925560684392117u, 14240623690643340304u, 810901u},
    {12204786741138465619u, 8548317821121715156u, 13988282617940424395u, 8157466623742595607u, 3147840u},
    {15993436107474955469u, 12385703782979315639u, 12940484082412873088u, 1787449663932722962u, 2314314u},
    {2465810662610401193u, 16747077025130536998u, 3160930517390123041u, 4077916825975617127u, 3766996u},
    {16294167352731098181u, 17195251468107966916u, 1381341323079770030u, 15057468375105615100u, 2883275u},
    {13274929992688793719u, 15579567212930449687u, 9984069646975714765u, 5961909762186684034u, 3069445u},
    {3660131970862439517u, 14653643942134614641u, 15618067847997364840u, 6830035111890463160u, 1287213u},
    {3773390136813270830u, 17279868138373421370u, 17612017261650007668u, 2833991063088576508u, 3157480u},
    {10554315435338337288u, 6440412790104631527u, 2307027086434314482u, 13100669749176803914u, 1209105u},
    {10615940793640953339u, 11817839930729354646u, 10763077384128097822u, 959052786086975504u, 1299990u},
    {5891518587226615217u, 13916181793128302054u, 1701884517939408262u, 8382661492187075042u, 816514u},
    {3191270903336855774u, 13144421526492090074u, 281528048542319075u, 3329711358917947429u, 3603793u},
    {15541869358950459989u, 4795543752077036624u, 1195845547268139033u, 10370714197919032173u, 2328375u},
    {17529236981034203504u, 2308510431649040178u, 3005641884876509801u, 10203071707451176651u, 2112181u},
    {15671037164641355089u, 6204993158315071456u, 16473148086684461118u, 12072581076881388933u, 388203u},
    {3931378967097172186u, 7581250522570191197u, 17475983832815597148u, 8509957189937723793u, 2564708u},
    {14488614045340727519u, 10464680828124147443u, 11874020146477450708u, 16404384367219394138u, 793477u},
    {17080133489546363206u, 13978024538175742370u, 1973856414590841086u, 9454181902520318817u, 3225222u},
    {5339738625727315972u, 9535907672508591058u, 43858408834441959u, 10507845989768630290u, 1440352u},
    {16613662232843552669u, 2168656630662015870u, 15824338739993563450u, 3629449517124298489u, 155576u},
    {14750923235423042530u, 18360972803361003155u, 6023033602844113209u, 4470440704636992986u, 3844042u},
    {2813352558591893207u, 10013330571934595064u, 15680928887603285130u, 13689795336621411220u, 3357000u},
    {13238738721713957797u, 14989983808645949802u, 7310873025489415728u, 6402994008882896669u, 3457221u},
    {11861779048893588603u, 9546311969219515842u, 11627274347760088388u, 7269533881189041818u, 2472113u},
    {4746109409709160269u, 13663370602172622437u, 17766546702675835357u, 16258561101635609821u, 1534750u},
    {10834782297305162829u, 15568168283705892962u, 18045819253810905729u, 8242876877049471539u, 1085352u},
    {14535134176700600093u, 1744236789844954469u, 5810731245006379359u, 11765409046999019254u, 2571684u},
    {5206765102506284693u, 3822271018320166019u, 9907019409190139114u, 8694350492903215041u, 1288559u},
    {10222093578947667224u, 16836846436394845132u, 442286247814747996u, 15876440415135371519u, 3648277u},
    {16712907381049431644u, 1247627326879047134u, 18010241554594003874u, 4895157648546612988u, 2448237u},
    {13188728394944577160u, 4914130608259700164u, 1223277035579335286u, 18203675703823783972u, 387395u},
    {6082841394036611015u, 7818304907004087225u, 10552723589455127494u, 6204099281885912911u, 3032328u},
    {9725636909970320564u, 3659672401670706104u, 2186952997894852459u, 5316140949536382147u, 1517057u},
    {3421372087865053039u, 12157455867986700582u, 14430818881780355479u, 12133660565912263788u, 1581270u},
    {3840942205606155694u, 9279929895469433677u, 10996032362041147722u, 11702499529279420900u, 2706634u},
    {5770785212338253899u, 7864238558492020308u, 14905733729414740886u, 7904206346535845331u, 1002092u},
    {7192061816645133933u, 9337958312070974494u, 9847351672138041051u, 667003688907869522u, 361722u},
    {5714319012656729698u, 10599053388520925479u, 6226002550061086053u, 13049097114691790471u, 3852052u},
    {10810446800089012581u, 3099881292237911692u, 7624159291066871566u, 13473770321506314236u, 1916416u},
    {8390514465458087950u, 2769569033861204979u, 10626108433130041088u, 12501315417526065413u, 2037273u},
    {1127965337215153485u, 9287898455246275674u, 16149175934025294801u, 2775769639581855464u, 2925327u},
    {15859342249614273496u, 9202540820589764793u, 1513258301030481625u, 14969884727127764933u, 3534083u},
    {9436018905718908949u, 13942384929301105519u, 7959642067361802352u, 16350208592177845936u, 1915188u},
    {17668542635655591000u, 214510855095591948u, 16937611226632532396u, 827962533656455536u, 1321535u},
    {17701120424025769115u, 6640524085768543587u, 17548500105609381012u, 5716927947753719229u, 8106u},
    {12537908467780106112u, 12519204066971322720u, 6993502421825756592u, 15060186688951328061u, 766038u},
    {5752953915684041781u, 401853035005953499u, 8340611757723878207u, 16010916798416924798u, 1461456u},
    {14075022070149366488u, 2525206359031063672u, 16296549054626744063u, 13069383641682860480u, 3265206u},
    {956923682307084343u, 6800939686215596188u, 16172876224247917086u, 2221960253637162591u, 3877771u},
    {1272538974787882477u, 8350079530480402825u, 5841909118310080970u, 10736056169048747543u, 477067u},
    {14443044017778934693u, 10264506465192463168u, 13088662489765983316u, 11249785013507826579u, 3736661u},
    {9792843406058691060u, 6098002843853547260u, 6619074648908899451u, 14048102483765016204u, 868895u},
    {2090256289951975303u, 15058930078679357789u, 11370582719747536888u, 13995201541098047928u, 582002u},
    {12553558264013007540u, 2014448072281579265u, 10287069603226724196u, 4550364480329048615u, 2893320u},
    {7671413546924797943u, 5762946506425309849u, 3885875548003101956u, 701890684455061224u, 2317420u},
    {12018076073806771540u, 8551974384069189670u, 10348843757148150391u, 1051555170884177777u, 2611467u},
    {2495166936281151056u, 9521360288004852446u, 9484549332387288492u, 14675864654156864240u, 3567163u},
    {12765571287296336417u, 15752037437050435542u, 7896122316982008955u, 13972918206926162287u, 1112712u},
    {16588246537645557195u, 9347766177081603635u, 9664339229776892037u, 1605792996299078301u, 2590193u},
    {9653745863643295222u, 9183295775279389109u, 17118213061619958869u, 17701891168270651280u, 3552649u},
    {13178291201641766705u, 6961327012151377703u, 2023276981202444819u, 15413802354667261701u, 3425751u},
    {1289183170592308872u, 11169634349454687190u, 15224564902275484034u, 12168869765742950172u, 1046221u},
    {8222130399316202835u, 7070079221975204654u, 10038594694525961627u, 10467650518699960966u, 684033u},
    {2967342337581845187u, 1384699888788930886u, 7757008890328808496u, 17522613543373110732u, 3574617u},
    {10034420885061133393u, 16538682227867452633u, 11843580850767798381u, 15486265186599723263u, 1806471u},
    {8858814079721606948u, 16590506618055834955u, 314155423669739924u, 7167025333454709018u, 1353298u},
    {8061104590455518336u, 4213142284630992288u, 4381813503887002089u, 169079137104344194u, 3452361u},
    {8307528685440158939u, 11628222581094722613u, 7948878561084044695u, 1648951888820549710u, 401697u},
    {7645474542819057236u, 1108960840625339366u, 10626100501354808663u, 17445347760581689306u, 598917u},
    {16414133175449961811u, 6227995472212186580u, 1971757321441285884u, 8225613806389526368u, 3305813u},
    {15021393639583379872u, 13803519663167337963u, 6380178621372636911u, 6906452928195309720u, 2415177u},
    {12422241329226164263u, 8463590193634748999u, 17313851164754401554u, 3431259078700775533u, 2240643u},
    {42398728424274238u, 4966215661450568604u, 10372689452365096650u, 17911615892818935997u, 2074543u},
    {10463789473911654005u, 2501054023132974309u, 2897014773587429154u, 8180776707988378295u, 3465616u},
    {3034833054984359850u, 17290147426781953509u, 7777400965550719314u, 3594751447448998573u, 204053u},
    {17695679523780774828u, 8426370330731061516u, 10789467799732410576u, 8866848183728360230u, 2763040u},
    {14763133173300936321u, 17347843793761957097u, 4158502469481303566u, 11291953770529028639u, 136457u},
    {6676939393517962237u, 455368630812414974u, 15013678664000545693u, 15783130292954237938u, 1655655u},
    {6136299646022062673u, 1754971230256551584u, 11714169827904183199u, 14586175455503930952u, 2792128u},
    {917171531185328194u, 17790408902875192926u, 8087233391720359609u, 5311710049991953286u, 1152219u},
    {1454188380180061529u, 11691373916203689459u, 15594678038697851527u, 93312288359503531u, 995616u},
    {9089119641759790087u, 12794376127171313819u, 5556509578925722508u, 15222518215643797193u, 1719709u},
    {15336568042227157128u, 13833632134759642090u, 17409980559946486621u, 14875587418839928010u, 3064534u},
    {12047285412354744762u, 16449926192374333214u, 16452926909362407898u, 4740274301744084685u, 3027160u},
    {6655642495641808283u, 666920244383399906u, 257797784335315952u, 13026208177357473388u, 1706469u},
    {1096391279581165814u, 9275388609182600015u, 3580094136300395956u, 2625552195304332938u, 3591241u},
    {13634847703080353902u, 13609651026827910248u, 2939090111373254617u, 14838053484034791839u, 1353419u},
    {3763510790085126601u, 17337808936189836461u, 12421427668156257552u, 24966188755549391u, 2425463u},
    {3983290989151884062u, 17908607113639855311u, 17464410673573424683u, 10204862654594056954u, 2201703u},
    {15545439265889344716u, 13788423136199186813u, 9512229656662892497u, 5949336973082271947u, 2999306u},
    {11228292827477395121u, 15448380514265545191u, 9250127997181508967u, 10791908947781340937u, 1562062u},
    {4563940082162025341u, 11071651525315180615u, 7336881249548834598u, 9900705351929303069u, 2328049u},
    {12130013533176226101u, 15190403920929333997u, 15852767596427646365u, 7825165090090977887u, 1899232u},
    {5980050398061779608u, 17501598390057795707u, 4164108975024181833u, 15527417372620270869u, 2126269u},
    {15320539736979417949u, 12639594705440870231u, 4155527058377087612u, 15963951037984353563u, 547143u},
    {4602925287605697428u, 4422895190027843638u, 3397644016946186517u, 5558527763777123775u, 114113u},
    {4753223426195820744u, 4488746682400121733u, 15507815876386770100u, 8432843521302579493u, 1925129u},
    {9700012388873960069u, 14120219119069685753u, 12830410701837614818u, 16248471028938505516u, 2915037u},
    {854823771835935571u, 2921826773365486664u, 2814148736592346051u, 15978501240134938955u, 822209u},
    {18246243166600269299u, 10089882662833448154u, 15856428274479365218u, 1528376569773088552u, 746664u},
    {11167125732672787362u, 12924674979035631089u, 7764189881573143877u, 11326815785200114790u, 2487894u},
    {14414315068453126196u, 16145663676252227048u, 7530910835291760450u, 13376548452244001496u, 1806343u},
    {12378719943772726820u, 8689216952875197039u, 15471317171142539273u, 15669819066637247296u, 3390657u},
    {15872461382336065525u, 6672855130732174131u, 14589511604198080424u, 7268306001383344473u, 3734188u},
    {1370785887471395406u, 9229948676724789868u, 9466726682799748529u, 18155339721147335260u, 693730u},
    {1963533642997447111u, 17707021695037051504u, 7192439757233657563u, 9812629867079793544u, 1692783u},
    {16852815227478395905u, 11406483618131040800u, 18317264023065382595u, 15811839438892174126u, 2563558u},
    {4098788040688299889u, 10068060615800764369u, 11322313689630372690u, 3433996233938563141u, 487991u},
    {13848093285059941944u, 5932167462984679932u, 13672848411926487609u, 7791222004617486919u, 2629199u},
    {9817365400230685383u, 17592705152679155943u, 308475746785688609u, 5092531751518030604u, 3752923u},
    {12183936470410108822u, 7995382650084061460u, 1796789832904061590u, 285401997315653831u, 966495u},
    {16196210982453665611u, 5863651899990643296u, 7466499539832193591u, 1531038160995408566u, 645604u},
    {14295814056549672750u, 14878694984881206953u, 6583728375798499786u, 4551537717681461310u, 789483u},
    {16982095796110127928u, 8031601593426927058u, 11435428817408918834u, 8157071521688938923u, 3121915u},
    {6734547120186337967u, 7683560372887241611u, 9632955492475691298u, 11802977003364200044u, 2203202u},
    {1075006799358902272u, 4785906558769515169u, 16669851794348539925u, 7822862071335879122u, 2754795u},
    {1821466947108453522u, 4099467846480739638u, 10696858162058835520u, 1924314451149523111u, 1406576u},
    {10940831611489352525u, 16512926738932554725u, 7809427767689479457u, 16527135784102033881u, 1739656u},
    {12850956533245975663u, 9379805774221796846u, 15276080392366520537u, 1401185292256059831u, 1210372u},
    {10808240410613737775u, 16264108076582334324u, 12260093194694347043u, 1895824868905295605u, 1009656u},
    {18221333505013287802u, 8957994591883583881u, 17555760831632995428u, 11908127883988419599u, 1158358u},
    {5856960077102694907u, 5077773638002816675u, 14374184957872657260u, 8091818477727790764u, 3420113u},
    {9777115020945831628u, 10443557975490699815u, 8002997665733353379u, 13249629666246797761u, 205422u},
    {12593267655330137138u, 7559468113344429785u, 13998490921562678850u, 7137491190065604893u, 3745075u},
    {7511381253723257849u, 17098566336292639321u, 1547609770353626318u, 2519042644488888813u, 1374598u},
    {16681884031537180143u, 10940631368912787722u, 13302669914979119454u, 6942885887670357502u, 3082697u},
    {3844832932339718161u, 17925061270915033337u, 5687977068230080555u, 3155342273189579349u, 3837617u},
    {9678844158845177506u, 302506163294720173u, 9841677776484604659u, 7348608539637980837u, 1732905u},
    {8692302625523307288u, 15276614491887509119u, 3340803442928717487u, 7237725866180453790u, 2697381u},
    {14432026559726722725u, 4094049421047700569u, 4205331661686063457u, 49757904214012610u, 3801872u},
    {18151569490523550693u, 10709937020158501734u, 11721757774590092178u, 12175807958206653432u, 1698890u},
    {2681489092587887042u, 18043168615651600648u, 6485131307743031563u, 13506109086307716410u, 944818u},
    {12614295774333663454u, 13644782324728491958u, 8235406821369904915u, 10970183123113389469u, 3353367u},
    {7658392599086458313u, 5198461668706033960u, 1610041810677320363u, 2367701723018100253u, 652283u},
    {13075614906584947221u, 13219550328679873862u, 8759244228384518415u, 17954373415376389274u, 2629529u},
    {5314717826996099228u, 5496565701091454893u, 17112272268339181633u, 15396773796530421186u, 1484919u},
    {6446142060147614298u, 14999974984994619720u, 3809258017889076052u, 6440517805535548814u, 1512300u},
    {8351832302854000934u, 9123174429347724852u, 8198205565068486752u, 15880567705847334680u, 2313822u},
    {15570134387717962849u, 2266633799725412075u, 18199023346037721971u, 5879347615218849303u, 3520644u},
    {9769532238253090596u, 12823130238325885498u, 15834869727639248064u, 13179426539624873057u, 3754731u},
    {13569588941945093685u, 7320710523672173793u, 1357096595550192040u, 1294241673646824990u, 1632543u},
    {16535115396064993282u, 13076684522255635119u, 3148203949496330745u, 9902005487400694918u, 2066011u},
    {15351887775478463485u, 7464295128301791841u, 15576775542422263260u, 3424818105855087223u, 3751453u},
    {16736446409294715135u, 9114742784030833833u, 7260366780895393390u, 17002736695733432984u, 1533750u},
    {9820249237960313742u, 4444476143075288963u, 9674818916683131266u, 11701622944870114352u, 409488u},
    {12154348999723406961u, 11477907756161676072u, 13692039720283749526u, 1592820800873292713u, 970672u},
    {2654787682798389007u, 7089861584415100479u, 14010277511271105770u, 13276503042535076822u, 3788481u},
    {10639133950852276900u, 9415005269991117973u, 6471341372712273430u, 14409346366259273542u, 1044582u},
    {618103863413843057u, 5230550200067588366u, 1944619869357834865u, 3189803288896179221u, 1080235u},
    {535814127118359451u, 13764557574588791873u, 7122084624130929542u, 6577167879225709102u, 3783766u},
    {5522043777920004114u, 10864425209479138189u, 9326211867424540086u, 5762348098610278518u, 1798634u},
    {9291688396908926267u, 6003977613193967722u, 5009601887865721079u, 17254943921907397308u, 1828275u},
    {327913648484062635u, 16802940087037220633u, 7159913863329957728u, 5365987697082972516u, 1777890u},
    {11221556872980890018u, 11194432926097142447u, 14859641067522573215u, 825429821604402467u, 134033u},
    {6082987398048782905u, 7063109544026865772u, 17268915697880302702u, 6775886312839087317u, 458525u},
    {6077725440716443706u, 14399885818220469584u, 18332627311709927167u, 8006851238312284880u, 2388933u},
    {2866378767222985720u, 12258040292563677481u, 10753540691722007241u, 16473199484314659826u, 3446814u},
    {14539888540316034094u, 13873560868087357602u, 13990218242125693869u, 7917860262335023622u, 2909232u},
    {7933380354741151916u, 15947741771632464033u, 11103879885768428521u, 8916749932738042576u, 2337932u},
    {3531180849623850649u, 7227071478124470154u, 3075822809314133234u, 17625180187436902236u, 1753563u},
    {6145355001968135558u, 1611587591482129659u, 16552448739512879813u, 4860206346044478241u, 3577877u},
    {14495232997582767573u, 7209470539823874152u, 8331978764843304749u, 17864225913574618247u, 66412u},
    {9219411904332264840u, 820101167827545053u, 5839133096847019108u, 9512827516038136664u, 3380381u},
    {11218198172498423534u, 15253850048073269893u, 15483871580745470486u, 1071163349222448987u, 1713244u},
    {5457745300950232082u, 11374386779051704524u, 5003703160224186615u, 11128473256515883940u, 2096878u},
    {318754061454271651u, 4077985254536323631u, 12716056207320828135u, 17332503152050969833u, 2215238u},
    {1541334063659549028u, 16649935115918346590u, 13903208475620639508u, 13731806812987167191u, 2u},
    {17630612266575847914u, 14633674365067756047u, 7494366531701931189u, 50625294960u, 0u},
    {3589168826506087042u, 859370161314004003u, 11534656105194817661u, 50u, 0u},
    {16832044840913076714u, 12403562326482543228u, 933871859790u, 0u, 0u},
    {7424147988743268093u, 16082974426691716519u, 933u, 0u, 0u},
    {12974964729871316354u, 17226895195197u, 0u, 0u, 0u},
    {16513436708047969310u, 17226u, 0u, 0u, 0u},
    {317780126850429u, 0u, 0u, 0u, 0u},
    {317781u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3119416u},
    {1475531741771517865u, 1978038759213676812u, 12244510716637114203u, 10722066986224769282u, 271541u},
    {10781498191248144394u, 15022061969131820025u, 10701501129329870841u, 17731177191384858407u, 2378564u},
    {14054962015761002722u, 1135134006848161551u, 5807363968998846293u, 9195191221918963949u, 549198u},
    {16015060913808091198u, 4662417609477995339u, 4563132662752990215u, 9809963713305183656u, 1011575u},
    {8658295063035460504u, 10112164044018814989u, 18098817381967301811u, 90717868984254388u, 3293701u},
    {15006953686587338586u, 6800050486951224777u, 15706022854192763403u, 4456271295806643188u, 1141355u},
    {8262478072455938642u, 14018014548458976239u, 1684609589779182506u, 1173975792645367037u, 30576u},
    {3037992500427528979u, 11605639072233635590u, 16520495454057883571u, 7566611402803206815u, 449015u},
    {3778011359176244855u, 1665048344668387863u, 2251702846448775926u, 10888979572083986433u, 170127u},
    {13617728094243903390u, 3991443138215172004u, 17925838737148579451u, 13910253949438099204u, 2196877u},
    {13674970509213397488u, 7266468140592904862u, 1173257877282329776u, 11281509911607430784u, 2687729u},
    {13022249625694415968u, 16345662587311648441u, 1157548834637506746u, 15037559420173007899u, 2806669u},
    {7608255289886017363u, 4292955701289402932u, 12867249683952773142u, 7978109263952246693u, 3741812u},
    {2693648253400758492u, 11919867320527082896u, 12979403722914827367u, 6554207719727558788u, 853722u},
    {7685507716534173494u, 12836499046131194100u, 10187648664040998725u, 16516937432483800529u, 2588233u},
    {17005992347408947521u, 8411730750372844277u, 7222547002551930157u, 14026917731629086510u, 939768u},
    {1911722380786545921u, 16045209049193821958u, 9816464343944114682u, 16302351926383293145u, 3757732u},
    {13009180021967968328u, 2795876981547718055u, 3622720236428547968u, 9941208320000067899u, 140393u},
    {17234671529266288720u, 14474513703523419351u, 1477454836910666395u, 13549417482812400593u, 1056112u},
    {11436565018367593981u, 15686995974840376081u, 14548533568643765996u, 3622361543222987824u, 3698540u},
    {16596705383045270809u, 5714133926521628253u, 4737648960800460492u, 788801964828018628u, 3689296u},
    {4880029142410635427u, 15269076880969458054u, 14143505403593523431u, 15560438218067468558u, 2074622u},
    {17673794326903665977u, 6251284131830479455u, 8488411524057763880u, 975018759137188843u, 712422u},
    {14854961120618209493u, 876046950358194963u, 5876446359259012305u, 13271739170260239289u, 1322076u},
    {13234002698235338095u, 4511261667864998949u, 7794009568343891590u, 15877058699233878719u, 899679u},
    {1041754741884577160u, 1344290208854572230u, 17011771546415045911u, 737172104517828994u, 805266u},
    {4063448896278959215u, 8960091086321231252u, 5708139289424770432u, 7004441158229441692u, 227001u},
    {9521799998554811973u, 9774342349287475575u, 2874469582591104872u, 4759988642859161076u, 3370887u},
    {11907265118947323261u, 8881833531583437602u, 3271796951840116991u, 17644234839804799596u, 2529105u},
    {6378052422692720799u, 3181897470027276315u, 6356439507724219720u, 11647926410421171731u, 97711u},
    {12534105623272754740u, 14358285787015384004u, 7731449317865794312u, 9657520062540456068u, 773061u},
    {12816832105891479186u, 11226448945092865855u, 4100206586186202243u, 17019852661028878938u, 204254u},
    {17009998302823550897u, 10610564896581173820u, 14474300497359745021u, 5263972203052623459u, 898493u},
    {4303437031255955973u, 6427594085638275297u, 3924326166898501924u, 9960522252921046887u, 2209423u},
    {8934513756284976096u, 753940646599968206u, 10719854100283269178u, 16902233675467226855u, 2675457u},
    {17411959327114533550u, 83974191463484952u, 5628385098724818993u, 1562562962257935067u, 410997u},
    {5983616583248287154u, 17367958133604277927u, 15559021014900100808u, 1016387874567616470u, 3399098u},
    {1247586198233276984u, 8863347245284049802u, 857014310106953132u, 13249242000844658152u, 2189106u},
    {1638281204768922819u, 2466792704794564406u, 10045238090569116793u, 14884246263194618838u, 323475u},
    {17053897244449059555u, 14329220524488676184u, 7445187784844612245u, 2816213242902678964u, 85458u},
    {8483511075617998484u, 5434870455966139051u, 14105839516085788786u, 14557210420332707385u, 2136347u},
    {16265429489751015737u, 130311089091999848u, 14736995701331896143u, 10703932578532182127u, 1680220u},
    {11064006033243207709u, 14824978503127081697u, 6427171179710072236u, 7452926784938038249u, 1667967u},
    {1424052663956695611u, 9508606160085061560u, 11406044685022700440u, 10479119703324870604u, 2222667u},
    {6574892858960091953u, 6162497456532794712u, 5285923306377695786u, 17406881142929832067u, 3264487u},
    {14229242699045388648u, 8070987892065293447u, 17636803975309009988u, 15264371515630627511u, 3541462u},
    {17330605815290037881u, 9454075069091991489u, 13202890053527580945u, 8640182148938563475u, 879697u},
    {13960324764975734528u, 4530804009540762377u, 6760802311907010807u, 18390914033733215900u, 354219u},
    {11103742992450764047u, 13330319558186956203u, 7324903314963847458u, 6491717669043473597u, 2858714u},
    {6202741815783084062u, 14992735033161068126u, 3354640416928608855u, 5673226306988027204u, 2488793u},
    {4881955875988426749u, 8724998709944597246u, 1532310011728297038u, 15033889693085676811u, 1406581u},
    {1716027667633088016u, 1200247557590151226u, 16736024518438171633u, 11627219494866229843u, 1900772u},
    {17315908377882838838u, 3539781747995549371u, 13105994692456874737u, 3421769986036305538u, 1485080u},
    {10383845120845729715u, 1542159337316946331u, 17528000640917020675u, 7881672644244899590u, 2852867u},
    {8824608835937473773u, 16069004272268179591u, 11713362674684815940u, 4808427321810247967u, 2646226u},
    {9787456490002130846u, 2928340726475068281u, 13740042264026013975u, 7326631256422344989u, 1643616u},
    {6584893677389337044u, 2230784962946797515u, 14964523523968407203u, 12856571109785258062u, 3734153u},
    {6647891555701269342u, 17535330351565779067u, 1490484207866844434u, 10877522083268836253u, 3197352u},
    {13850740948785944991u, 1063340332890964560u, 10096956065417169517u, 8777949623524365721u, 3027043u},
    {15687117372239352410u, 4392709535191925387u, 14327903582165929273u, 6973368123940145461u, 2473690u},
    {11862879971475030313u, 5352080942117985530u, 12490816177289485777u, 16186532597816920368u, 2662543u},
    {7458784143849222489u, 10734032601247470441u, 9320030331960683421u, 5093146848147734968u, 3651913u},
    {837338912543977286u, 11948085957013755877u, 16941053980732885221u, 15343575845624322149u, 3275660u},
    {9704339843543815226u, 18417025735318848905u, 8684518844656174626u, 14976347242887146027u, 1101995u},
    {12921157535043369260u, 17071704936299824042u, 4062341010919400394u, 15440653358828433104u, 3245876u},
    {3999568940235750253u, 13622033485370680407u, 7186274481024956685u, 12742012409982966159u, 2488015u},
    {6446995220745874478u, 4471849916749599848u, 864200433802304965u, 2279681203874328896u, 3288927u},
    {14844250948228958695u, 5053459957830551346u, 6310353119153559091u, 8059062935135795434u, 3127010u},
    {4488189988532077011u, 12888869124329119270u, 2481891251585437105u, 2147353388344903584u, 2252467u},
    {15713004601172641749u, 17164525681876872848u, 17427381721044735914u, 5373812643237496984u, 1947292u},
    {9395594692162700115u, 15857544519760386402u, 7801512811493552385u, 2918224964051712103u, 2049525u},
    {1833918673699492026u, 6056420881485159971u, 15264579327043993592u, 12431713240589499524u, 1903918u},
    {2761073882674185418u, 10114515507220126239u, 12601542962442787916u, 13077545621379998598u, 2161344u},
    {948705111552720413u, 17571983763222809385u, 9369663990226360516u, 1841309623648991718u, 1764772u},
    {2922413643356677726u, 10542403464151332971u, 8733855779361309328u, 14948476265124840928u, 957504u},
    {237036439965188503u, 2003589428759551671u, 11720459681738149355u, 5638155181144408463u, 3310350u},
    {15391688011471962489u, 15075512369341635953u, 6206113069559735613u, 3015426540437604971u, 3569691u},
    {6964005116664391093u, 7802951452265247568u, 8398352980472763397u, 10370085126738345711u, 3267829u},
    {9469361589650986641u, 10210852025024870530u, 1588400717882288982u, 6185176308833605897u, 2118599u},
    {15374884863080801534u, 4210260490998654641u, 3278205589252927783u, 16396155106342634763u, 3399859u},
    {5499501281205191419u, 12358202413345480277u, 14577666919188495865u, 13537486430348377220u, 1117112u},
    {2753301793446168275u, 15737257853195189354u, 17952928660143757464u, 11765994920885409822u, 2467737u},
    {6533991005335169336u, 18445358517605944997u, 12204786741138465618u, 8548317821121715156u, 3461597u},
    {10395952851897520491u, 4453282849387622521u, 15993436107474955468u, 12385703782979315639u, 1610864u},
    {13586420618861338358u, 16239334297279004282u, 2465810662610401192u, 16747077025130536998u, 2468949u},
    {6390799714822619958u, 7289594411610891991u, 16294167352731098180u, 17195251468107966916u, 820030u},
    {642821942821957409u, 16485820432297985822u, 13274929992688793718u, 15579567212930449687u, 1406879u},
    {4596190126858995318u, 5005408433588541399u, 3660131970862439516u, 14653643942134614641u, 3149778u},
    {3517123357391337468u, 8572315239066849646u, 3773390136813270829u, 17279868138373421370u, 1479226u},
    {13867755392285283167u, 13003438350408410571u, 10554315435338337287u, 6440412790104631527u, 21386u},
    {17437403387317244613u, 6934738653826926426u, 10615940793640953338u, 11817839930729354646u, 491476u},
    {7185370345685990263u, 15512057653383382027u, 5891518587226615216u, 13916181793128302054u, 1623018u},
    {16029147652369923384u, 18434360568563999162u, 3191270903336855773u, 13144421526492090074u, 2154447u},
    {1678922790945775977u, 7892627424246359254u, 15541869358950459988u, 4795543752077036624u, 144601u},
    {6691351692451332612u, 2685724713022685720u, 17529236981034203503u, 2308510431649040178u, 435853u},
    {10004333843372552847u, 8315111896745808099u, 15671037164641355088u, 6204993158315071456u, 824164u},
    {2033738546927879984u, 11585491790907844398u, 3931378967097172185u, 7581250522570191197u, 885234u},
    {8108743281754053647u, 4750723585761750349u, 14488614045340727518u, 10464680828124147443u, 3843978u},
    {9831500931560834198u, 1473108545327230816u, 17080133489546363205u, 13978024538175742370u, 1317590u},
    {2640678282442394567u, 16820555948333493091u, 5339738625727315971u, 9535907672508591058u, 375611u},
    {9173420673067322281u, 8993992601843136700u, 16613662232843552668u, 2168656630662015870u, 3162830u},
    {7642681393037540345u, 8468514085987096860u, 14750923235423042529u, 18360972803361003155u, 3761237u},
    {10705194494932991498u, 14508771544996968012u, 2813352558591893206u, 10013330571934595064u, 108650u},
    {9697314872099800369u, 13529045585754489716u, 13238738721713957796u, 14989983808645949802u, 1881608u},
    {5545765174708906846u, 7364661072725322865u, 11861779048893588602u, 9546311969219515842u, 2411554u},
    {11508739774434971765u, 13500284669629248323u, 4746109409709160268u, 13663370602172622437u, 202093u},
    {5024358344523268869u, 18412541388726961047u, 10834782297305162828u, 15568168283705892962u, 805265u},
    {11489761283995186632u, 247283418874077092u, 14535134176700600092u, 1744236789844954469u, 174477u},
    {16845161240166583684u, 15793742712221916765u, 5206765102506284692u, 3822271018320166019u, 2571024u},
    {12695385111347936545u, 14138919111351035219u, 10222093578947667223u, 16836846436394845132u, 1227762u},
    {4267996090762519790u, 4826443156199642131u, 16712907381049431643u, 1247627326879047134u, 770554u},
    {2299547268856541489u, 17147481066757779992u, 13188728394944577159u, 4914130608259700164u, 1956158u},
    {2774598537832567866u, 17922639459432677929u, 6082841394036611014u, 7818304907004087225u, 3078738u},
    {14986714134466896825u, 17375710303406199265u, 9725636909970320563u, 3659672401670706104u, 2807003u},
    {7847561951239664091u, 14503033030077250220u, 3421372087865053038u, 12157455867986700582u, 3066007u},
    {11637189233428723241u, 606339732945894974u, 3840942205606155693u, 9279929895469433677u, 539976u},
    {1859045723913649296u, 8771293640609763417u, 5770785212338253898u, 7864238558492020308u, 2305484u},
    {12428174637508148729u, 3779670169923630252u, 7192061816645133932u, 9337958312070974494u, 357085u},
    {5953424497091156862u, 6371173291658646231u, 5714319012656729697u, 10599053388520925479u, 76151u},
    {5936481432885865604u, 3086871094562749428u, 10810446800089012580u, 3099881292237911692u, 1701138u},
    {1027445060253501258u, 5769104473391394889u, 8390514465458087949u, 2769569033861204979u, 3497984u},
    {4879377071331857619u, 7313925896381558024u, 1127965337215153484u, 9287898455246275674u, 2776987u},
    {11183040942903419362u, 16784798324293230004u, 15859342249614273495u, 9202540820589764793u, 1911951u},
    {11631347816998845071u, 3852411389863690474u, 9436018905718908948u, 13942384929301105519u, 3816156u},
    {7927006485246310478u, 1272102011209752152u, 17668542635655590999u, 214510855095591948u, 608532u},
    {13684560227896834526u, 1647691940409850074u, 17701120424025769114u, 6640524085768543587u, 2886162u},
    {12343013871811577560u, 15870242652568083957u, 12537908467780106111u, 12519204066971322720u, 2253246u},
    {5562616960595470248u, 14831326264863705602u, 5752953915684041780u, 401853035005953499u, 172961u},
    {14652464318174382885u, 2619204875387872379u, 14075022070149366487u, 2525206359031063672u, 1492179u},
    {13455648887367711757u, 15090599961935138442u, 956923682307084342u, 6800939686215596188u, 3439968u},
    {14736959415936112528u, 13499282281282221835u, 1272538974787882476u, 8350079530480402825u, 1752510u},
    {3712134450672900589u, 15796910547940205622u, 14443044017778934692u, 10264506465192463168u, 2448396u},
    {2941062511168632253u, 9404865066587360649u, 9792843406058691059u, 6098002843853547260u, 3846235u},
    {7812548690776538432u, 9472981931637008753u, 2090256289951975302u, 15058930078679357789u, 3734698u},
    {728516847240446318u, 14156264098867437614u, 12553558264013007539u, 2014448072281579265u, 3816206u},
    {12007410989543939295u, 12792922452416219394u, 7671413546924797942u, 5762946506425309849u, 2665960u},
    {18215126213725143265u, 11007203302785920175u, 12018076073806771539u, 8551974384069189670u, 528975u},
    {11366852707458164014u, 11450186604472986950u, 2495166936281151055u, 9521360288004852446u, 2357160u},
    {16843695572440042589u, 9179630224866922711u, 12765571287296336416u, 15752037437050435542u, 2837169u},
    {14609296384225554900u, 6542697690496847937u, 16588246537645557194u, 9347766177081603635u, 1733711u},
    {6745108376857827263u, 7062789211664290570u, 9653745863643295221u, 9183295775279389109u, 2374293u},
    {4293164951553620884u, 9399464164783106409u, 13178291201641766704u, 6961327012151377703u, 38341u},
    {10843202350078151244u, 7880804140618115376u, 1289183170592308871u, 11169634349454687190u, 457262u},
    {16557803099215094289u, 17304916135274788451u, 8222130399316202834u, 7070079221975204654u, 845981u},
    {9681873163828538928u, 14543081630813498363u, 2967342337581845186u, 1384699888788930886u, 2032510u},
    {4156012988027241459u, 2248501725632019063u, 10034420885061133392u, 16538682227867452633u, 935665u},
    {8005518421539597894u, 3352078878523387884u, 8858814079721606947u, 16590506618055834955u, 1832400u},
    {7211553829259769372u, 17397467946769417995u, 8061104590455518335u, 4213142284630992288u, 1460959u},
    {12941791949790970308u, 9776812136948649186u, 8307528685440158938u, 11628222581094722613u, 1523137u},
    {389637195674561296u, 15836696149794518912u, 7645474542819057235u, 1108960840625339366u, 1682811u},
    {281649020977707141u, 3712508846890357331u, 16414133175449961810u, 6227995472212186580u, 2196550u},
    {3344608148120867623u, 1035819547797599481u, 15021393639583379871u, 13803519663167337963u, 1780893u},
    {18128007822165664545u, 971927347006977557u, 12422241329226164262u, 8463590193634748999u, 3594090u},
    {14042438823703776117u, 6140767736879608258u, 42398728424274237u, 4966215661450568604u, 2769910u},
    {5397739318128036648u, 1944789708199947873u, 10463789473911654004u, 2501054023132974309u, 3707020u},
    {9116974192361154300u, 18090878122060563150u, 3034833054984359849u, 17290147426781953509u, 3669450u},
    {12238592678213849045u, 8474426737728208134u, 17695679523780774827u, 8426370330731061516u, 2928496u},
    {8632896899488778231u, 554045365737378727u, 14763133173300936320u, 17347843793761957097u, 1248082u},
    {13404152286509190100u, 12735308626939043230u, 6676939393517962236u, 455368630812414974u, 1387181u},
    {3802702705419946350u, 9555519622375744636u, 6136299646022062672u, 1754971230256551584u, 3482499u},
    {17638333891439030637u, 12247364511287812987u, 917171531185328193u, 17790408902875192926u, 978149u},
    {15484061132840028648u, 7523902165384825799u, 1454188380180061528u, 11691373916203689459u, 2178269u},
    {14727038851235404145u, 3241589822773039824u, 9089119641759790086u, 12794376127171313819u, 3828950u},
    {10978920350877855469u, 2376361041232819911u, 15336568042227157127u, 13833632134759642090u, 1127285u},
    {11978163484151291493u, 358817342788212374u, 12047285412354744761u, 16449926192374333214u, 997568u},
    {9961844319336256859u, 8054910866271844732u, 6655642495641808282u, 666920244383399906u, 2819824u},
    {4392204527577923428u, 11419643644828322882u, 1096391279581165813u, 9275388609182600015u, 3405660u},
    {3405082463816402553u, 6147949562857309675u, 13634847703080353901u, 13609651026827910248u, 2384505u},
    {7198680635180286687u, 9400533632302684145u, 3763510790085126600u, 17337808936189836461u, 2077536u},
    {14533658710239762772u, 13260441839212692221u, 3983290989151884061u, 17908607113639855311u, 1378165u},
    {12872939595538418730u, 4046752225480953658u, 15545439265889344715u, 13788423136199186813u, 1520885u},
    {17834787851078018773u, 4051699743708297388u, 11228292827477395120u, 15448380514265545191u, 2539181u},
    {16168526557320551466u, 14859429959875179563u, 4563940082162025340u, 11071651525315180615u, 3160946u},
    {4755829981145781247u, 14686311778556699623u, 12130013533176226100u, 15190403920929333997u, 3451049u},
    {4316072503736700557u, 17124713828380715180u, 5980050398061779607u, 17501598390057795707u, 1600051u},
    {18118155546254569145u, 16046386882515911390u, 15320539736979417948u, 12639594705440870231u, 1484378u},
    {9330739152138157102u, 302445674542228091u, 4602925287605697427u, 4422895190027843638u, 1147945u},
    {5014484907047255946u, 8186191953462974400u, 4753223426195820743u, 4488746682400121733u, 3739862u},
    {12144943166135154794u, 5071938618485850452u, 9700012388873960068u, 14120219119069685753u, 2142546u},
    {5470933967573172383u, 16777201067397973595u, 854823771835935570u, 2921826773365486664u, 98635u},
    {8169591807426507763u, 8126660619016310254u, 18246243166600269298u, 10089882662833448154u, 1429284u},
    {1149130891336732208u, 8593667828068766554u, 11167125732672787361u, 12924674979035631089u, 258181u},
    {11515374270671655638u, 1005323967225168116u, 14414315068453126195u, 16145663676252227048u, 2293394u},
    {10968805702742670762u, 9303752378548971765u, 12378719943772726819u, 8689216952875197039u, 2361201u},
    {3663304771643505122u, 14235546083351443237u, 15872461382336065524u, 6672855130732174131u, 356520u},
    {13766005937579237824u, 17133415968766257523u, 1370785887471395405u, 9229948676724789868u, 2868319u},
    {17425746963422294387u, 1595358506440561886u, 1963533642997447110u, 17707021695037051504u, 1159215u},
    {16918580947722900013u, 14367147269240461782u, 16852815227478395904u, 11406483618131040800u, 2821909u},
    {492268169062627409u, 12948105558019975652u, 4098788040688299888u, 10068060615800764369u, 1270942u},
    {10228239162361558849u, 17557274258545047144u, 13848093285059941943u, 5932167462984679932u, 577457u},
    {663409416936116328u, 2509853815176723090u, 9817365400230685382u, 17592705152679155943u, 3743061u},
    {8494689970603619382u, 8172757763810566159u, 12183936470410108821u, 7995382650084061460u, 1462956u},
    {16884991649889650846u, 13931942521599100664u, 16196210982453665610u, 5863651899990643296u, 1888171u},
    {6352664210695289022u, 11125580414077535833u, 14295814056549672749u, 14878694984881206953u, 1800244u},
    {8062120154997602473u, 2686843197689059941u, 16982095796110127927u, 8031601593426927058u, 2464142u},
    {14152188086439304902u, 2615091737377042072u, 6734547120186337966u, 7683560372887241611u, 1632014u},
    {11327099398067315518u, 16694003187009180400u, 1075006799358902271u, 4785906558769515169u, 3482597u},
    {5219456662135146897u, 17919104620092819530u, 1821466947108453521u, 4099467846480739638u, 636302u},
    {1271035753875848866u, 11298340060826347396u, 10940831611489352524u, 16512926738932554725u, 667789u},
    {8272677097497678057u, 14416663763380037444u, 12850956533245975662u, 9379805774221796846u, 2772815u},
    {13399664211762580838u, 18397812955772568223u, 10808240410613737774u, 16264108076582334324u, 1238859u},
    {11900961501440319446u, 17273052697371653210u, 18221333505013287801u, 8957994591883583881u, 1829160u},
    {6904205362125972570u, 5815270729695735691u, 5856960077102694906u, 5077773638002816675u, 3646412u},
    {8189648584756242079u, 16092710390264599939u, 9777115020945831627u, 10443557975490699815u, 3549587u},
    {9839747179645009882u, 875322722580543311u, 12593267655330137137u, 7559468113344429785u, 1133888u},
    {437986791319239988u, 11563168585254464126u, 7511381253723257848u, 17098566336292639321u, 3249064u},
    {10399116111922020065u, 553914562963893900u, 16681884031537180142u, 10940631368912787722u, 2969518u},
    {7481090572508686726u, 9105997286435572012u, 3844832932339718160u, 17925061270915033337u, 773891u},
    {3191758599946248493u, 4313513741769659536u, 9678844158845177505u, 302506163294720173u, 21931u},
    {6723500273707459805u, 9418328466606392980u, 8692302625523307287u, 15276614491887509119u, 3188863u},
    {3304979254076841604u, 3923772243011484543u, 14432026559726722724u, 4094049421047700569u, 2461849u},
    {5748553232738144343u, 2758422294430651754u, 18151569490523550692u, 10709937020158501734u, 1559630u},
    {3686087620605672445u, 12085829244329316615u, 2681489092587887041u, 18043168615651600648u, 1403881u},
    {15235124152287479349u, 15310704344973464483u, 12614295774333663453u, 13644782324728491958u, 559171u},
    {11064257405994394812u, 17406911400421697592u, 7658392599086458312u, 5198461668706033960u, 1789509u},
    {17579444734280603850u, 12354758068935432212u, 13075614906584947220u, 13219550328679873862u, 1094423u},
    {5380579754499308312u, 6078536070709789469u, 5314717826996099227u, 5496565701091454893u, 650273u},
    {4395215640372042695u, 5229353169061432080u, 6446142060147614297u, 14999974984994619720u, 2380776u},
    {14471205982549413004u, 3254958858438238867u, 8351832302854000933u, 9123174429347724852u, 1780714u},
    {17585075477188843751u, 7537733451311911273u, 15570134387717962848u, 2266633799725412075u, 3737033u},
    {9320815301355511285u, 6680969760064995093u, 9769532238253090595u, 12823130238325885498u, 2325262u},
    {3229848785561686085u, 16538554489461012066u, 13569588941945093684u, 7320710523672173793u, 1857238u},
    {1514833086652727062u, 9393297925777120574u, 16535115396064993281u, 13076684522255635119u, 2296499u},
    {2632111274136502680u, 12881142414765778813u, 15351887775478463484u, 7464295128301791841u, 1923696u},
    {17311956993984613490u, 4808880175929983233u, 16736446409294715134u, 9114742784030833833u, 2654284u},
    {5349133165334254204u, 12979438413182060507u, 9820249237960313741u, 4444476143075288963u, 1124876u},
    {10901601237990109893u, 17592796434216103608u, 12154348999723406960u, 11477907756161676072u, 1529666u},
    {10787739619638065370u, 15211056201139129319u, 2654787682798389006u, 7089861584415100479u, 2575958u},
    {12405524073856175404u, 16989228433535654680u, 10639133950852276899u, 9415005269991117973u, 2298694u},
    {3571842624676046785u, 5639349185588819630u, 618103863413843056u, 5230550200067588366u, 84411u},
    {1209797948352788640u, 4227162315684688179u, 535814127118359450u, 13764557574588791873u, 3024170u},
    {11142807170009786031u, 2436219767506888066u, 5522043777920004113u, 10864425209479138189u, 1257528u},
    {6320941892571868437u, 11586553155342721295u, 9291688396908926266u, 6003977613193967722u, 732957u},
    {14964069911112534314u, 8670346224276586826u, 327913648484062634u, 16802940087037220633u, 1382674u},
    {4254537182534329437u, 14470897151435261542u, 11221556872980890017u, 11194432926097142447u, 79435u},
    {5479524276356499611u, 2009620208281319148u, 6082987398048782904u, 7063109544026865772u, 3275624u},
    {13702668508662797446u, 16026881741385879133u, 6077725440716443705u, 14399885818220469584u, 447195u},
    {3035180004585777214u, 11889984842793452401u, 2866378767222985719u, 12258040292563677481u, 2087241u},
    {3316845911723930173u, 4002536005755113373u, 14539888540316034093u, 13873560868087357602u, 1247563u},
    {14600941434479352562u, 3204211495329765253u, 7933380354741151915u, 15947741771632464033u, 1155329u},
    {13423598370464393328u, 7220577067768861545u, 3531180849623850648u, 7227071478124470154u, 1426838u},
    {13729833874459346953u, 15417339341341384743u, 6145355001968135557u, 1611587591482129659u, 201181u},
    {18039044018930336416u, 3358119776101251682u, 14495232997582767572u, 7209470539823874152u, 1489023u},
    {17171593612359121780u, 771898327525321260u, 9219411904332264839u, 820101167827545053u, 2694118u},
    {15916293156891082302u, 5767121722789659450u, 11218198172498423533u, 15253850048073269893u, 3325492u},
    {11515893155456123206u, 9812874144923343681u, 5457745300950232081u, 11374386779051704524u, 2318023u},
    {17016902438214055516u, 6139341203661102875u, 318754061454271650u, 4077985254536323631u, 251041u},
    {11644152058382405766u, 1871146266019320667u, 1541334063659549027u, 16649935115918346590u, 324326u},
    {7460627655892988888u, 10898652264217523489u, 17630612266575847913u, 14633674365067756047u, 3617799u},
    {12842830443853397471u, 15786266275946955203u, 3589168826506087041u, 859370161314004003u, 523461u},
    {3960052638597371814u, 40123621054712290u, 16832044840913076713u, 12403562326482543228u, 766040u},
    {5893777273702088355u, 15386196821392675957u, 7424147988743268092u, 16082974426691716519u, 933u},
    {10944199825008825552u, 6546772434895344384u, 12974964729871316353u, 17226895195197u, 0u},
    {16699794329279300718u, 9926279784540748962u, 16513436708047969309u, 17226u, 0u},
    {8681837665504033514u, 14464212403127020161u, 317780126850428u, 0u, 0u},
    {5620940765541904479u, 2339977395420732573u, 317780u, 0u, 0u},
    {13526352776507011038u, 5862008671720816u, 0u, 0u, 0u},
    {12391061995261696936u, 5862008u, 0u, 0u, 0u},
    {108134973725099977u, 0u, 0u, 0u, 0u},
    {108134974u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 1760946u},
    {6385517845005574083u, 16428621867789277255u, 1475531741771517864u, 1978038759213676812u, 1847611u},
    {4235284030464885607u, 17787783447805064704u, 10781498191248144393u, 15022061969131820025u, 2941987u},
    {12656763870093952522u, 2303221099032560692u, 14054962015761002721u, 1135134006848161551u, 2750165u},
    {12434284708005169469u, 2970098773289638083u, 16015060913808091197u, 4662417609477995339u, 1306511u},
    {14924003958032661458u, 13901448572703073888u, 8658295063035460503u, 10112164044018814989u, 1443975u},
    {14097229099939831405u, 417086929493333637u, 15006953686587338585u, 6800050486951224777u, 2105591u},
    {10789202615659435063u, 7651316766350711884u, 8262478072455938641u, 14018014548458976239u, 236704u},
    {760642426870531712u, 4952432235019675326u, 3037992500427528978u, 11605639072233635590u, 418701u},
    {11027295927120582364u, 14240537306777867055u, 3778011359176244854u, 1665048344668387863u, 1532816u},
    {1335632512740772017u, 5420051098005144602u, 13617728094243903389u, 3991443138215172004u, 3291027u},
    {3206657328012850837u, 801827673784756340u, 13674970509213397487u, 7266468140592904862u, 3287644u},
    {17670162493363574079u, 17779048363903790899u, 13022249625694415967u, 16345662587311648441u, 2252844u},
    {4727160643303868157u, 3675098482916345100u, 7608255289886017362u, 4292955701289402932u, 1646052u},
    {13122601933649434171u, 17807143551211316525u, 2693648253400758491u, 11919867320527082896u, 555507u},
    {4616534370848138846u, 15952866391750187672u, 7685507716534173493u, 12836499046131194100u, 2875837u},
    {17996752580078536699u, 2358006082422153633u, 17005992347408947520u, 8411730750372844277u, 2625025u},
    {3829648588504033061u, 17486324528472598581u, 1911722380786545920u, 16045209049193821958u, 3127294u},
    {11055863720207011781u, 6987813206083576031u, 13009180021967968327u, 2795876981547718055u, 3414960u},
    {7592766626832093822u, 7367204706171158369u, 17234671529266288719u, 14474513703523419351u, 2737505u},
    {291971549463323332u, 5826721683747595494u, 11436565018367593980u, 15686995974840376081u, 1170070u},
    {10427461673867572100u, 15997252511084812032u, 16596705383045270808u, 5714133926521628253u, 3519566u},
    {3726745245347216718u, 15385059614024404727u, 4880029142410635426u, 15269076880969458054u, 2945291u},
    {15602117846029963402u, 10293364115934496705u, 17673794326903665976u, 6251284131830479455u, 615600u},
    {17928907108121239003u, 4169496470198713743u, 14854961120618209492u, 876046950358194963u, 2368485u},
    {11223580240152352384u, 14172335745551195304u, 13234002698235338094u, 4511261667864998949u, 2561618u},
    {6652646337752163058u, 11623025718973238398u, 1041754741884577159u, 1344290208854572230u, 1352511u},
    {13933306859717424872u, 2109696116323075320u, 4063448896278959214u, 8960091086321231252u, 2524410u},
    {17086839341630451285u, 17098349913641394563u, 9521799998554811972u, 9774342349287475575u, 1016410u},
    {4389437357071165355u, 2999147890548561383u, 11907265118947323260u, 8881833531583437602u, 616007u},
    {8467873223046676873u, 16896558730605760560u, 6378052422692720798u, 3181897470027276315u, 1020482u},
    {13153831611024150368u, 784680791008708364u, 12534105623272754739u, 14358285787015384004u, 3118266u},
    {6270504843830044370u, 15413370683938726520u, 12816832105891479185u, 11226448945092865855u, 981125u},
    {7990435203554548177u, 15545419244155360361u, 17009998302823550896u, 10610564896581173820u, 784323u},
    {18074481868763500427u, 16514416361855946316u, 4303437031255955972u, 6427594085638275297u, 1808704u},
    {4863415545007027248u, 15283108075608014333u, 8934513756284976095u, 753940646599968206u, 646000u},
    {13879658395052809401u, 27171903282985581u, 17411959327114533549u, 83974191463484952u, 112647u},
    {11923174591518528755u, 9476092670499441526u, 5983616583248287153u, 17367958133604277927u, 14266u},
    {11675623582184231943u, 3115627062921387973u, 1247586198233276983u, 8863347245284049802u, 912600u},
    {11519324153379443239u, 767432794817697160u, 1638281204768922818u, 2466792704794564406u, 3351101u},
    {6054307747273063955u, 4440425893812179010u, 17053897244449059554u, 14329220524488676184u, 1656167u},
    {17998706054820227769u, 17882680460201290525u, 8483511075617998483u, 5434870455966139051u, 3157928u},
    {14891997423783158983u, 47556960036556622u, 16265429489751015736u, 130311089091999848u, 2882445u},
    {15959300373360278479u, 15522197711033054031u, 11064006033243207708u, 14824978503127081697u, 3743822u},
    {16431612599025015938u, 12233970926678380929u, 1424052663956695610u, 9508606160085061560u, 2038406u},
    {17072495321957737140u, 2865806961206434356u, 6574892858960091952u, 6162497456532794712u, 29130u},
    {1326504276608304757u, 15784137790349164924u, 14229242699045388647u, 8070987892065293447u, 787686u},
    {9005626007052425884u, 5301221915039135097u, 17330605815290037880u, 9454075069091991489u, 3427877u},
    {2970828828335504121u, 6445163552594728462u, 13960324764975734527u, 4530804009540762377u, 3888071u},
    {10880417640353600087u, 2435470776575264474u, 11103742992450764046u, 13330319558186956203u, 257794u},
    {18107984423965040456u, 13184370521847167410u, 6202741815783084061u, 14992735033161068126u, 326877u},
    {15774128786724388322u, 9750553967309877310u, 4881955875988426748u, 8724998709944597246u, 2565550u},
    {16500336884670397045u, 4755885776128631627u, 1716027667633088015u, 1200247557590151226u, 485703u},
    {15585373896781801471u, 6171963269374289868u, 17315908377882838837u, 3539781747995549371u, 1569375u},
    {6034937858404979426u, 13603226262571284830u, 10383845120845729714u, 1542159337316946331u, 8717u},
    {1835174746036302223u, 12752465919757693234u, 8824608835937473772u, 16069004272268179591u, 2495668u},
    {8109886168031320595u, 15822057148714670121u, 9787456490002130845u, 2928340726475068281u, 3743595u},
    {6994892780381466292u, 1137191262334233115u, 6584893677389337043u, 2230784962946797515u, 1373413u},
    {6620729979841328143u, 14439938065556920208u, 6647891555701269341u, 17535330351565779067u, 2956294u},
    {15061475822117977212u, 16753253236908322196u, 13850740948785944990u, 1063340332890964560u, 3754261u},
    {17549775806766407066u, 8147704885992579164u, 15687117372239352409u, 4392709535191925387u, 1074389u},
    {15836089370367921980u, 12444693481753885909u, 11862879971475030312u, 5352080942117985530u, 3768073u},
    {3362309991329832985u, 14698201145419326720u, 7458784143849222488u, 10734032601247470441u, 3175787u},
    {9726757417825058501u, 2365260281721218742u, 837338912543977285u, 11948085957013755877u, 2295215u},
    {3238895087708119439u, 13942188575319904416u, 9704339843543815225u, 18417025735318848905u, 3583978u},
    {702709976834881568u, 5608689623980118222u, 12921157535043369259u, 17071704936299824042u, 170664u},
    {13757560738480537691u, 11068930325576712386u, 3999568940235750252u, 13622033485370680407u, 231969u},
    {17521352730152326979u, 5264236428263812939u, 6446995220745874477u, 4471849916749599848u, 511113u},
    {7223555124449262451u, 2020644784989846496u, 14844250948228958694u, 5053459957830551346u, 3394495u},
    {17729595471815746321u, 16612557564702348804u, 4488189988532077010u, 12888869124329119270u, 803301u},
    {15357353122666870006u, 8266605588388267252u, 15713004601172641748u, 17164525681876872848u, 264210u},
    {11288132128156295023u, 11923124539888803973u, 9395594692162700114u, 15857544519760386402u, 194233u},
    {4560741232332042669u, 9259509109737832917u, 1833918673699492025u, 6056420881485159971u, 1433984u},
    {2050922974861032980u, 1431022137211151335u, 2761073882674185417u, 10114515507220126239u, 3360398u},
    {17705587084571413411u, 9609962833468514526u, 948705111552720412u, 17571983763222809385u, 1192336u},
    {534585443476581026u, 16861021158545550347u, 2922413643356677725u, 10542403464151332971u, 3146050u},
    {18440850763787700554u, 2489529450114473837u, 237036439965188502u, 2003589428759551671u, 838913u},
    {15798863269869184777u, 2507395199612090198u, 15391688011471962488u, 15075512369341635953u, 1123845u},
    {12646229868454239922u, 11263228789445900320u, 6964005116664391092u, 7802951452265247568u, 2750147u},
    {7040010108274449919u, 11251499546662930134u, 9469361589650986640u, 10210852025024870530u, 1676178u},
    {16401434436224155721u, 10056395429649144514u, 15374884863080801533u, 4210260490998654641u, 1970745u},
    {16335821516737707724u, 5794235014768111883u, 5499501281205191418u, 12358202413345480277u, 1555957u},
    {3595605336940471324u, 721497213466043577u, 2753301793446168274u, 15737257853195189354u, 3831138u},
    {14574208634607420989u, 1918115803083813706u, 6533991005335169335u, 18445358517605944997u, 3131696u},
    {12291919933391912661u, 16741229378344839016u, 10395952851897520490u, 4453282849387622521u, 1429826u},
    {1647064190282095588u, 14468723690332403942u, 13586420618861338357u, 16239334297279004282u, 638454u},
    {1226638938323591488u, 12954910285309182421u, 6390799714822619957u, 7289594411610891991u, 3073116u},
    {2769516034492238858u, 2858218026755681827u, 642821942821957408u, 16485820432297985822u, 1812484u},
    {2638320689254069221u, 6267511222119172904u, 4596190126858995317u, 5005408433588541399u, 3768640u},
    {2866689702101687417u, 440617846854237223u, 3517123357391337467u, 8572315239066849646u, 1792805u},
    {13737138147366328761u, 1458021115059934698u, 13867755392285283166u, 13003438350408410571u, 932935u},
    {3600105140857408294u, 5248454011612736343u, 17437403387317244612u, 6934738653826926426u, 1066580u},
    {3902985560527289757u, 3198471884390868901u, 7185370345685990262u, 15512057653383382027u, 3234938u},
    {11029198582786920122u, 16975535477184132058u, 16029147652369923383u, 18434360568563999162u, 2078939u},
    {300058476374461039u, 17446826503806709600u, 1678922790945775976u, 7892627424246359254u, 1062178u},
    {87587502345272863u, 847473102557513830u, 6691351692451332611u, 2685724713022685720u, 1544369u},
    {12624105860918625046u, 12830584787547839715u, 10004333843372552846u, 8315111896745808099u, 3050768u},
    {17351470925906673916u, 3156035710633753064u, 2033738546927879983u, 11585491790907844398u, 3630991u},
    {15665694802912402011u, 9004963457175061891u, 8108743281754053646u, 4750723585761750349u, 1732374u},
    {3736334071069148883u, 7903400036654847415u, 9831500931560834197u, 1473108545327230816u, 1687915u},
    {16353771016159810069u, 9193619162114481192u, 2640678282442394566u, 16820555948333493091u, 3190315u},
    {6313445841967551523u, 11391385816590278464u, 9173420673067322280u, 8993992601843136700u, 2047818u},
    {3703720162854349213u, 5693264530359620121u, 7642681393037540344u, 8468514085987096860u, 1365831u},
    {17098301123597343649u, 4062453403939787192u, 10705194494932991497u, 14508771544996968012u, 2942280u},
    {700693982927960035u, 2779160068916764972u, 9697314872099800368u, 13529045585754489716u, 801576u},
    {5221724494225163334u, 3856035072710635797u, 5545765174708906845u, 7364661072725322865u, 1383148u},
    {14917243034649645956u, 15317257136747486008u, 11508739774434971764u, 13500284669629248323u, 2052118u},
    {13660895866145600925u, 8145630990907352194u, 5024358344523268868u, 18412541388726961047u, 1686510u},
    {9493252970721918611u, 9109544197084293165u, 11489761283995186631u, 247283418874077092u, 711758u},
    {12236389085883314701u, 14422899553898150578u, 16845161240166583683u, 15793742712221916765u, 847340u},
    {12521443027682390144u, 12635152025412947334u, 12695385111347936544u, 14138919111351035219u, 3829507u},
    {10066269714767327687u, 7572990556619488843u, 4267996090762519789u, 4826443156199642131u, 3785561u},
    {17413085557312221697u, 14071919809231551097u, 2299547268856541488u, 17147481066757779992u, 2838231u},
    {14135943524024080199u, 5932157395066274880u, 2774598537832567865u, 17922639459432677929u, 532892u},
    {10496650739259033880u, 5557300823903499562u, 14986714134466896824u, 17375710303406199265u, 1054745u},
    {17971528397431798184u, 10289921906769095565u, 7847561951239664090u, 14503033030077250220u, 1619742u},
    {1761261144779988540u, 685923040950463073u, 11637189233428723240u, 606339732945894974u, 2836531u},
    {14909485585010377382u, 7493074084254609442u, 1859045723913649295u, 8771293640609763417u, 1771330u},
    {1776366018295029835u, 15163918100656468456u, 12428174637508148728u, 3779670169923630252u, 1631996u},
    {7009767029430620733u, 7832158016224860969u, 5953424497091156861u, 6371173291658646231u, 3277117u},
    {2961099275645407778u, 9067838488050148403u, 5936481432885865603u, 3086871094562749428u, 243780u},
    {4029634042509578253u, 9501639907449181796u, 1027445060253501257u, 5769104473391394889u, 1957467u},
    {7677644166019442081u, 14973846282823928769u, 4879377071331857618u, 7313925896381558024u, 3655740u},
    {5491327152274008545u, 3818141082252833049u, 11183040942903419361u, 16784798324293230004u, 1808389u},
    {15371317535500072775u, 4574980856908358383u, 11631347816998845070u, 3852411389863690474u, 2554538u},
    {9770939577053145193u, 16707924135064758875u, 7927006485246310477u, 1272102011209752152u, 3384059u},
    {15148796126225493513u, 10126672457171782224u, 13684560227896834525u, 1647691940409850074u, 952578u},
    {18166690342697772200u, 10211890210105059908u, 12343013871811577559u, 15870242652568083957u, 3226557u},
    {3066507727128554432u, 10614977135388117526u, 5562616960595470247u, 14831326264863705602u, 1362380u},
    {3208177857964233782u, 3066740941762165134u, 14652464318174382884u, 2619204875387872379u, 1656813u},
    {6191464261770848077u, 4107113632798501082u, 13455648887367711756u, 15090599961935138442u, 1328808u},
    {10942577194357556827u, 11085727209805637438u, 14736959415936112527u, 13499282281282221835u, 883486u},
    {9907899102653372125u, 1794194958639208404u, 3712134450672900588u, 15796910547940205622u, 2026256u},
    {748229833262957926u, 3823539213578447646u, 2941062511168632252u, 9404865066587360649u, 1812629u},
    {17272155134942419677u, 3775474084101429113u, 7812548690776538431u, 9472981931637008753u, 1787614u},
    {1227227239063937104u, 7886707369798873458u, 728516847240446317u, 14156264098867437614u, 2099465u},
    {11894061281732926605u, 1804120742597882052u, 12007410989543939294u, 12792922452416219394u, 2951686u},
    {10581079639968112884u, 3078665922891478649u, 18215126213725143264u, 11007203302785920175u, 3528359u},
    {9554227997648218581u, 13799580689862461066u, 11366852707458164013u, 11450186604472986950u, 1535001u},
    {9924867965990523166u, 9790547984816415683u, 16843695572440042588u, 9179630224866922711u, 3117852u},
    {7364576638373519877u, 11099518001358577051u, 14609296384225554899u, 6542697690496847937u, 62070u},
    {13827030537687951944u, 13193941679014091057u, 6745108376857827262u, 7062789211664290570u, 1733473u},
    {3231577692709465675u, 2068895886052921600u, 4293164951553620883u, 9399464164783106409u, 1437998u},
    {6883628342483759084u, 1786252002985166632u, 10843202350078151243u, 7880804140618115376u, 601383u},
    {3506872596230735654u, 5597526269500071135u, 16557803099215094288u, 17304916135274788451u, 3225784u},
    {5999723509951856582u, 16669632864354443917u, 9681873163828538927u, 14543081630813498363u, 797772u},
    {4466218487096467822u, 9190528861633021754u, 4156012988027241458u, 2248501725632019063u, 2029060u},
    {9645089882885375628u, 12149184777750019374u, 8005518421539597893u, 3352078878523387884u, 1712377u},
    {4207284661678921675u, 1014743394813555227u, 7211553829259769371u, 17397467946769417995u, 2658297u},
    {9838711058941513841u, 3695800066434343643u, 12941791949790970307u, 9776812136948649186u, 3040268u},
    {15454326154185206735u, 8139904206034956067u, 389637195674561295u, 15836696149794518912u, 2036757u},
    {10751369931341344166u, 12676810596419515446u, 281649020977707140u, 3712508846890357331u, 1464390u},
    {9754842334811924201u, 3325134025031134392u, 3344608148120867622u, 1035819547797599481u, 1907037u},
    {9533554638504854612u, 8404240495770581714u, 18128007822165664544u, 971927347006977557u, 860436u},
    {740829847716468581u, 14814607327607657899u, 14042438823703776116u, 6140767736879608258u, 3864761u},
    {12911297852052925951u, 5340757806071862262u, 5397739318128036647u, 1944789708199947873u, 239718u},
    {15896854896063115102u, 11893701002487953549u, 9116974192361154299u, 18090878122060563150u, 2368343u},
    {18185694271424286918u, 9925125060602151459u, 12238592678213849044u, 8474426737728208134u, 2691109u},
    {3848568786900080133u, 4446371694413197486u, 8632896899488778230u, 554045365737378727u, 2882464u},
    {879345631624228509u, 12948851497536052744u, 13404152286509190099u, 12735308626939043230u, 2380756u},
    {16273256158956164150u, 16282766039444733573u, 3802702705419946349u, 9555519622375744636u, 3774710u},
    {1667470074791489688u, 10369945756407464261u, 17638333891439030636u, 12247364511287812987u, 1621553u},
    {17410011177652609476u, 1139617649363857108u, 15484061132840028647u, 7523902165384825799u, 3851936u},
    {2798752203124312998u, 14055471689657878774u, 14727038851235404144u, 3241589822773039824u, 3822790u},
    {13667175383964217856u, 12153489182770609736u, 10978920350877855468u, 2376361041232819911u, 3826527u},
    {884311689414918454u, 15550143286032059213u, 11978163484151291492u, 358817342788212374u, 3063843u},
    {4248029802781409066u, 3065356057385997540u, 9961844319336256858u, 8054910866271844732u, 1872622u},
    {6547914793724174052u, 16622386950220224359u, 4392204527577923427u, 11419643644828322882u, 1249763u},
    {17194435779779353397u, 5989393420173069880u, 3405082463816402552u, 6147949562857309675u, 1791449u},
    {347850565340281974u, 14198958752501056533u, 7198680635180286686u, 9400533632302684145u, 99992u},
    {11948012602373136772u, 7425245382915126985u, 14533658710239762771u, 13260441839212692221u, 624877u},
    {11510998695329509370u, 570609802996625601u, 12872939595538418729u, 4046752225480953658u, 893083u},
    {85705078663723243u, 7105481151138031278u, 17834787851078018772u, 4051699743708297388u, 843812u},
    {22935021459988902u, 7140883171221730091u, 16168526557320551465u, 14859429959875179563u, 3177806u},
    {15962104798545998066u, 9435893459140748644u, 4755829981145781246u, 14686311778556699623u, 2551346u},
    {1866465266959427875u, 9176181401133864755u, 4316072503736700556u, 17124713828380715180u, 2688875u},
    {14095107914228000926u, 9595690724451053226u, 18118155546254569144u, 16046386882515911390u, 770612u},
    {1672863697666309305u, 13067792603591276958u, 9330739152138157101u, 302445674542228091u, 2368105u},
    {5543149750416196984u, 13610248280853188737u, 5014484907047255945u, 8186191953462974400u, 1512843u},
    {9249116041726033504u, 1062823063815311600u, 12144943166135154793u, 5071938618485850452u, 3243892u},
    {15403334427695210837u, 8900774953281452537u, 5470933967573172382u, 16777201067397973595u, 3047154u},
    {2761923147447266612u, 11838163449005485571u, 8169591807426507762u, 8126660619016310254u, 1019916u},
    {18392059127940076494u, 12265902790388260112u, 1149130891336732207u, 8593667828068766554u, 3717471u},
    {5290623322392762539u, 12243680459399003400u, 11515374270671655637u, 1005323967225168116u, 451177u},
    {12726008078461562011u, 10905988212666778644u, 10968805702742670761u, 9303752378548971765u, 2179249u},
    {6971271120468648689u, 14463530243510882810u, 3663304771643505121u, 14235546083351443237u, 3023090u},
    {7537340705400150186u, 14012979738688465858u, 13766005937579237823u, 17133415968766257523u, 547057u},
    {18125187558997199870u, 13844834530059560259u, 17425746963422294386u, 1595358506440561886u, 1500864u},
    {2562182580102243814u, 9228908767146357965u, 16918580947722900012u, 14367147269240461782u, 2699458u},
    {11864250662115236583u, 5309536907502339170u, 492268169062627408u, 12948105558019975652u, 2562994u},
    {1982479603352744165u, 10557815116266660087u, 10228239162361558848u, 17557274258545047144u, 3246947u},
    {14188656887565018512u, 1205833860717785390u, 663409416936116327u, 2509853815176723090u, 1639836u},
    {1321965968853964151u, 15334612015389271480u, 8494689970603619381u, 8172757763810566159u, 1345867u},
    {10777685691816400626u, 823364478766302043u, 16884991649889650845u, 13931942521599100664u, 1556422u},
    {9674255833337600194u, 7162765596650307300u, 6352664210695289021u, 11125580414077535833u, 1122811u},
    {13065621126744461274u, 10541723303841373059u, 8062120154997602472u, 2686843197689059941u, 1139407u},
    {13959473591045700733u, 3052266906865659913u, 14152188086439304901u, 2615091737377042072u, 2639976u},
    {11223686378748318991u, 13533607066725787902u, 11327099398067315517u, 16694003187009180400u, 2646607u},
    {2173388867840743657u, 9957030587685433712u, 5219456662135146896u, 17919104620092819530u, 3109241u},
    {6224397491185269782u, 3664856566083442675u, 1271035753875848865u, 11298340060826347396u, 278908u},
    {14420274726905267594u, 7485888877502648286u, 8272677097497678056u, 14416663763380037444u, 1253688u},
    {18050244126305826686u, 9449110164232941696u, 13399664211762580837u, 18397812955772568223u, 2780312u},
    {9702812673261602100u, 7233585902401980927u, 11900961501440319445u, 17273052697371653210u, 2746457u},
    {17043634535575391230u, 16938136091115605488u, 6904205362125972569u, 5815270729695735691u, 1293828u},
    {17463698209599272668u, 8773138552709859614u, 8189648584756242078u, 16092710390264599939u, 576339u},
    {14141764523294360416u, 5340942747086476499u, 9839747179645009881u, 875322722580543311u, 1840625u},
    {18438719957093437296u, 6165832642140402059u, 437986791319239987u, 11563168585254464126u, 2684018u},
    {14321953150484860381u, 9449857680322984393u, 10399116111922020064u, 553914562963893900u, 1449602u},
    {556973792206606532u, 3368430374819585165u, 7481090572508686725u, 9105997286435572012u, 3367298u},
    {5868411871946270378u, 7508267655459707280u, 3191758599946248492u, 4313513741769659536u, 2756109u},
    {3209667656711018858u, 18311038247256333520u, 6723500273707459804u, 9418328466606392980u, 1770619u},
    {12967291636438679870u, 7333074201121068597u, 3304979254076841603u, 3923772243011484543u, 1096872u},
    {8015755303400629069u, 13976705500609145142u, 5748553232738144342u, 2758422294430651754u, 2830366u},
    {7622113013983271793u, 5680706247833975374u, 3686087620605672444u, 12085829244329316615u, 1869945u},
    {13877430935017862368u, 2318058522606986959u, 15235124152287479348u, 15310704344973464483u, 2224307u},
    {12412696908911487941u, 8075889889097513942u, 11064257405994394811u, 17406911400421697592u, 1784026u},
    {4249977956504674677u, 1333798091771700006u, 17579444734280603849u, 12354758068935432212u, 1393100u},
    {14217058068857466376u, 6327455335861565832u, 5380579754499308311u, 6078536070709789469u, 2233803u},
    {4767132317735018675u, 5590975392498842437u, 4395215640372042694u, 5229353169061432080u, 670423u},
    {2005519487369968682u, 11792078609059124091u, 14471205982549413003u, 3254958858438238867u, 2371349u},
    {7461043804800659204u, 5372544476120642821u, 17585075477188843750u, 7537733451311911273u, 2801096u},
    {3942444146086073132u, 574924033214163516u, 9320815301355511284u, 6680969760064995093u, 2025585u},
    {2092377807244005231u, 4202783167439424778u, 3229848785561686084u, 16538554489461012066u, 1399200u},
    {17078877751940797337u, 8424995850742765158u, 1514833086652727061u, 9393297925777120574u, 2975629u},
    {16538484900293529952u, 883238766197179751u, 2632111274136502679u, 12881142414765778813u, 2877416u},
    {9920612475137671938u, 6162912997711175773u, 17311956993984613489u, 4808880175929983233u, 491766u},
    {13168311218216851270u, 1614815309462268507u, 5349133165334254203u, 12979438413182060507u, 582405u},
    {27183633297419604u, 8834426036790519595u, 10901601237990109892u, 17592796434216103608u, 374258u},
    {13884301325019465741u, 10201788605737353474u, 10787739619638065369u, 15211056201139129319u, 3019168u},
    {6961963005247812538u, 3923317752914456626u, 12405524073856175403u, 16989228433535654680u, 1022231u},
    {8868510736798703010u, 4298397939537404258u, 3571842624676046784u, 5639349185588819630u, 2592428u},
    {1804828895637931056u, 10395183601987309663u, 1209797948352788639u, 4227162315684688179u, 3161488u},
    {16571229645084490700u, 9554351479967151953u, 11142807170009786030u, 2436219767506888066u, 3108305u},
    {3430389914678287205u, 16250525757542151761u, 6320941892571868436u, 11586553155342721295u, 1270410u},
    {142173062949933424u, 14619932278203196022u, 14964069911112534313u, 8670346224276586826u, 3218906u},
    {17112791055952439476u, 17157911861774724474u, 4254537182534329436u, 14470897151435261542u, 3472979u},
    {895688796054970787u, 5484747042122487380u, 5479524276356499610u, 2009620208281319148u, 1631500u},
    {10642676111336955795u, 7786495711028880382u, 13702668508662797445u, 16026881741385879133u, 26119u},
    {4677721203889783552u, 18052825612377954805u, 3035180004585777213u, 11889984842793452401u, 2134161u},
    {14639836469506620738u, 15929789994775005000u, 3316845911723930172u, 4002536005755113373u, 1825653u},
    {8822803365117250799u, 6430013104741606297u, 14600941434479352561u, 3204211495329765253u, 803267u},
    {4587049902477662173u, 10289190992301375253u, 13423598370464393327u, 7220577067768861545u, 3744390u},
    {11498863608060121284u, 9096677724363649270u, 13729833874459346952u, 15417339341341384743u, 2356537u},
    {15726599415843781539u, 4660191962426813778u, 18039044018930336415u, 3358119776101251682u, 2782192u},
    {12332154644552305409u, 5226812608262280397u, 17171593612359121779u, 771898327525321260u, 136295u},
    {15496005505002040778u, 12759123285977249135u, 15916293156891082301u, 5767121722789659450u, 706973u},
    {2860731398176819974u, 8963940527395877891u, 11515893155456123205u, 9812874144923343681u, 783103u},
    {5912790128805354738u, 2377594746752076237u, 17016902438214055515u, 6139341203661102875u, 3778792u},
    {10309444557546393533u, 15067165291809263994u, 11644152058382405765u, 1871146266019320667u, 973373u},
    {18092743575866415952u, 3025537671462017129u, 7460627655892988887u, 10898652264217523489u, 306459u},
    {5338372811361964530u, 6373191715194314958u, 12842830443853397470u, 15786266275946955203u, 2175105u},
    {10315163361229475429u, 12145305777833936u, 3960052638597371813u, 40123621054712290u, 2056151u},
    {13511341318936138791u, 2497657954148189951u, 5893777273702088354u, 15386196821392675957u, 3338744u},
    {12751792041658051607u, 17436528981831309267u, 10944199825008825551u, 6546772434895344384u, 2948455u},
    {7015084037684132429u, 8504881979498160137u, 16699794329279300717u, 9926279784540748962u, 2856525u},
    {17971258610318153480u, 6383933149067315895u, 8681837665504033513u, 14464212403127020161u, 1850428u},
    {3447822052334483549u, 18340986258434505365u, 5620940765541904478u, 2339977395420732573u, 317780u},
    {9520161355216373436u, 15760531544326706255u, 13526352776507011037u, 5862008671720816u, 0u},
    {825678912143803427u, 11984736258012124u, 12391061995261696935u, 5862008u, 0u},
    {1665237984864249512u, 9428165262369145888u, 108134973725099976u, 0u, 0u},
    {1872475570816657107u, 13375733694553103370u, 108134973u, 0u, 0u},
    {7219497396953235475u, 1994738185724226068u, 0u, 0u, 0u},
    {13359612935124468138u, 1994738185u, 0u, 0u, 0u},
    {18349680732400958527u, 1u, 0u, 0u, 0u},
    {36796424807u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3878626u},
    {11358783659110083547u, 17095325567840813766u, 6385517845005574082u, 16428621867789277255u, 3340172u},
    {18294035850200623283u, 2919724732959905761u, 4235284030464885606u, 17787783447805064704u, 3764115u},
    {16526827647612003963u, 8067659727256742046u, 12656763870093952521u, 2303221099032560692u, 853127u},
    {15729157320191982440u, 12090986756367378427u, 12434284708005169468u, 2970098773289638083u, 3599037u},
    {7098283431226458066u, 5661849356966812220u, 14924003958032661457u, 13901448572703073888u, 3079077u},
    {11112588918795085318u, 12096832010649692550u, 14097229099939831404u, 417086929493333637u, 716213u},
    {5234627670075224775u, 6122011799606639851u, 10789202615659435062u, 7651316766350711884u, 2846889u},
    {17043383876748732662u, 8223558329714289172u, 760642426870531711u, 4952432235019675326u, 2449824u},
    {7161931949165403543u, 1681278155657238258u, 11027295927120582363u, 14240537306777867055u, 852808u},
    {17612599174182421012u, 16682528665625476897u, 1335632512740772016u, 5420051098005144602u, 498415u},
    {11139529532032082396u, 9525734258962956220u, 3206657328012850836u, 801827673784756340u, 2866643u},
    {2251726987855802490u, 4039071126641161937u, 17670162493363574078u, 17779048363903790899u, 8737u},
    {3713021173175291379u, 2556865089122695792u, 4727160643303868156u, 3675098482916345100u, 483436u},
    {9394781842831852749u, 16528145670185643822u, 13122601933649434170u, 17807143551211316525u, 1525369u},
    {4492364481266488378u, 7214813709501614424u, 4616534370848138845u, 15952866391750187672u, 2827765u},
    {12976653876847618356u, 5292235058585469344u, 17996752580078536698u, 2358006082422153633u, 2623052u},
    {13838222644098150610u, 3136709049329377838u, 3829648588504033060u, 17486324528472598581u, 3810112u},
    {10746170807141785987u, 1087122488141468118u, 11055863720207011780u, 6987813206083576031u, 939467u},
    {6633120200418315033u, 6896533461132342196u, 7592766626832093821u, 7367204706171158369u, 3367215u},
    {12611796096889354328u, 5271768912226242412u, 291971549463323331u, 5826721683747595494u, 25296u},
    {8315640756377728663u, 411963964886479655u, 10427461673867572099u, 15997252511084812032u, 1994502u},
    {6596150284979668500u, 9496950588875817715u, 3726745245347216717u, 15385059614024404727u, 3316886u},
    {13445771902238523271u, 12019004979876884299u, 15602117846029963401u, 10293364115934496705u, 3372606u},
    {4660934614245571430u, 14299233802022571392u, 17928907108121239002u, 4169496470198713743u, 2658860u},
    {11248769053002845472u, 5537672924727082721u, 11223580240152352383u, 14172335745551195304u, 1179236u},
    {2984936457724362463u, 8147765693692209873u, 6652646337752163057u, 11623025718973238398u, 1085605u},
    {7696157852282697540u, 73881155071100187u, 13933306859717424871u, 2109696116323075320u, 1122156u},
    {8779385090626585347u, 3832516338308348669u, 17086839341630451284u, 17098349913641394563u, 2427882u},
    {581139095187574280u, 1234664270305287271u, 4389437357071165354u, 2999147890548561383u, 1901784u},
    {966783656434783935u, 2022644647825537412u, 8467873223046676872u, 16896558730605760560u, 3475130u},
    {6792356875808278274u, 18093140504618594124u, 13153831611024150367u, 784680791008708364u, 3529249u},
    {2618520566930744662u, 5274719849072320773u, 6270504843830044369u, 15413370683938726520u, 2875115u},
    {13059690436128796166u, 6611647502315535428u, 7990435203554548176u, 15545419244155360361u, 717054u},
    {8943200023230890076u, 15897628656890380572u, 18074481868763500426u, 16514416361855946316u, 373948u},
    {12469971185080793762u, 11586314560169536751u, 4863415545007027247u, 15283108075608014333u, 1472991u},
    {15539697467028665782u, 1828520070216344129u, 13879658395052809400u, 27171903282985581u, 1981263u},
    {12123534346657021891u, 5349689042483478516u, 11923174591518528754u, 9476092670499441526u, 929731u},
    {7586736553282765459u, 7277851240337411383u, 11675623582184231942u, 3115627062921387973u, 2540115u},
    {9340903316038096146u, 15345915577487103640u, 11519324153379443238u, 767432794817697160u, 2434720u},
    {5148307863404558254u, 8341730542657617773u, 6054307747273063954u, 4440425893812179010u, 672050u},
    {12657469514308027966u, 14920628919197637318u, 17998706054820227768u, 17882680460201290525u, 2578067u},
    {5858996536744336229u, 13340717057427183428u, 14891997423783158982u, 47556960036556622u, 1616274u},
    {14752404977832841627u, 3718772823726231864u, 15959300373360278478u, 15522197711033054031u, 3048642u},
    {13772683725363253109u, 3344124016759776917u, 16431612599025015937u, 12233970926678380929u, 3011956u},
    {14716596774893198267u, 10417155610132951555u, 17072495321957737139u, 2865806961206434356u, 191074u},
    {9627186387228271036u, 1682346371906655911u, 1326504276608304756u, 15784137790349164924u, 2223565u},
    {15950995367212322296u, 14557849082372160486u, 9005626007052425883u, 5301221915039135097u, 1736766u},
    {856721818924894747u, 16762259933607198197u, 2970828828335504120u, 6445163552594728462u, 3120885u},
    {11528288079588743601u, 4402449634675948442u, 10880417640353600086u, 2435470776575264474u, 3788658u},
    {15331737045307605845u, 18191369529871366915u, 18107984423965040455u, 13184370521847167410u, 1234839u},
    {11138603392518255606u, 4043352901307466300u, 15774128786724388321u, 9750553967309877310u, 4584u},
    {14538278572105737570u, 5127006609515100249u, 16500336884670397044u, 4755885776128631627u, 2551549u},
    {4750371772411563343u, 11977500815912017883u, 15585373896781801470u, 6171963269374289868u, 3057373u},
    {11075488216023574576u, 8070325954915955813u, 6034937858404979425u, 13603226262571284830u, 3812562u},
    {17935190876282854090u, 9829808332073189576u, 1835174746036302222u, 12752465919757693234u, 2246686u},
    {9046867852108562698u, 10634606665863007382u, 8109886168031320594u, 15822057148714670121u, 3053511u},
    {12368012820955600074u, 7840016509138390540u, 6994892780381466291u, 1137191262334233115u, 1540611u},
    {4275064163341174125u, 4978218163985762555u, 6620729979841328142u, 14439938065556920208u, 1945677u},
    {9953742593869704671u, 14238303553670279347u, 15061475822117977211u, 16753253236908322196u, 281716u},
    {17114690582341511100u, 11012419250245351168u, 17549775806766407065u, 8147704885992579164u, 2753185u},
    {16402748038944325052u, 15643271543219903435u, 15836089370367921979u, 12444693481753885909u, 3822330u},
    {8666514342286582247u, 1348704249142259695u, 3362309991329832984u, 14698201145419326720u, 3221016u},
    {12003084147638751551u, 9757807418158178444u, 9726757417825058500u, 2365260281721218742u, 1901307u},
    {11525117445916972658u, 9581581326999532871u, 3238895087708119438u, 13942188575319904416u, 3266423u},
    {8613253053244930065u, 11348392359500527251u, 702709976834881567u, 5608689623980118222u, 2391665u},
    {3581483239824833776u, 10661158486526175243u, 13757560738480537690u, 11068930325576712386u, 218578u},
    {9530661352757254543u, 1064064176254245058u, 17521352730152326978u, 5264236428263812939u, 164373u},
    {11503848900929884961u, 10388163837869678319u, 7223555124449262450u, 2020644784989846496u, 2131050u},
    {16435615390459606848u, 5558166072890283351u, 17729595471815746320u, 16612557564702348804u, 2821086u},
    {12557808297512484879u, 5039185628544958093u, 15357353122666870005u, 8266605588388267252u, 1822626u},
    {6129114848000406517u, 17276347844353656694u, 11288132128156295022u, 11923124539888803973u, 1958994u},
    {9954113209258940255u, 2558575484470486859u, 4560741232332042668u, 9259509109737832917u, 3357115u},
    {6363952190738227151u, 2388779204192786106u, 2050922974861032979u, 1431022137211151335u, 1425879u},
    {10733413547974972072u, 7627916151127699907u, 17705587084571413410u, 9609962833468514526u, 3881538u},
    {16421187748427265486u, 10564205993069376004u, 534585443476581025u, 16861021158545550347u, 2145161u},
    {11468966004096562153u, 1013762838100594337u, 18440850763787700553u, 2489529450114473837u, 3113666u},
    {596777878567964677u, 13136458478448164401u, 15798863269869184776u, 2507395199612090198u, 1205856u},
    {12049222877591760386u, 7218784293984816918u, 12646229868454239921u, 11263228789445900320u, 570012u},
    {14849996561207824665u, 15377473584659808267u, 7040010108274449918u, 11251499546662930134u, 2189538u},
    {4638856371750759780u, 5980319889793412482u, 16401434436224155720u, 10056395429649144514u, 1606109u},
    {16275378755769260353u, 8924074505682873760u, 16335821516737707723u, 5794235014768111883u, 49942u},
    {6024481728045171647u, 11173122852082702044u, 3595605336940471323u, 721497213466043577u, 2418766u},
    {10791980963945349455u, 16193014068461157758u, 14574208634607420988u, 1918115803083813706u, 1293863u},
    {3081483413782180973u, 9624854591126562926u, 12291919933391912660u, 16741229378344839016u, 3101082u},
    {4573727307678171783u, 3190510274025056438u, 1647064190282095587u, 14468723690332403942u, 3068343u},
    {5795707077909269858u, 13586087278990483848u, 1226638938323591487u, 12954910285309182421u, 2600559u},
    {2647120324158997858u, 18423459260313485318u, 2769516034492238857u, 2858218026755681827u, 3824964u},
    {17210334194492205873u, 3422034722056747109u, 2638320689254069220u, 6267511222119172904u, 448441u},
    {14366139631460411087u, 7087648225324799330u, 2866689702101687416u, 440617846854237223u, 914483u},
    {18102952893537217430u, 8219998883836950750u, 13737138147366328760u, 1458021115059934698u, 3269262u},
    {14704452199241844088u, 13055981963641928134u, 3600105140857408293u, 5248454011612736343u, 1514508u},
    {14187763469131269133u, 11267127943629579293u, 3902985560527289756u, 3198471884390868901u, 2276872u},
    {1632465973873583522u, 557634090355899758u, 11029198582786920121u, 16975535477184132058u, 481859u},
    {11001184487969093745u, 12953350783654101415u, 300058476374461038u, 17446826503806709600u, 2972858u},
    {11440545081635450512u, 4977593543898016950u, 87587502345272862u, 847473102557513830u, 234895u},
    {1516402470062238272u, 7269479295847927247u, 12624105860918625045u, 12830584787547839715u, 3120288u},
    {5824726478057780833u, 18326357179612860594u, 17351470925906673915u, 3156035710633753064u, 3785047u},
    {2942708184213528057u, 1470644018554384593u, 15665694802912402010u, 9004963457175061891u, 2662924u},
    {10806544536182561086u, 5436720522410947097u, 3736334071069148882u, 7903400036654847415u, 2293343u},
    {7785964431674610968u, 18095498333966683406u, 16353771016159810068u, 9193619162114481192u, 340762u},
    {15560854236036981324u, 4006371108500295153u, 6313445841967551522u, 11391385816590278464u, 38738u},
    {13541820086204824789u, 17785093936990355239u, 3703720162854349212u, 5693264530359620121u, 1476040u},
    {3110118242017407212u, 12793351767119876675u, 17098301123597343648u, 4062453403939787192u, 2221069u},
    {8955695376548246889u, 505669244891602300u, 700693982927960034u, 2779160068916764972u, 2004830u},
    {718023952972841463u, 12471608767901662475u, 5221724494225163333u, 3856035072710635797u, 2225173u},
    {2936353515581105549u, 14095953560474971420u, 14917243034649645955u, 15317257136747486008u, 169290u},
    {16723009991410075648u, 1490886585826754297u, 13660895866145600924u, 8145630990907352194u, 1641880u},
    {15371052503912904555u, 13001702560049878070u, 9493252970721918610u, 9109544197084293165u, 616951u},
    {3265999115780844854u, 18288358608100441037u, 12236389085883314700u, 14422899553898150578u, 1359213u},
    {9804973033000569800u, 16828833222128801440u, 12521443027682390143u, 12635152025412947334u, 376390u},
    {15666935449585325527u, 17614901577317394194u, 10066269714767327686u, 7572990556619488843u, 1121551u},
    {17525179324652351999u, 13625433515994566897u, 17413085557312221696u, 14071919809231551097u, 1270396u},
    {6482585828884977860u, 2508776097115864014u, 14135943524024080198u, 5932157395066274880u, 480631u},
    {10129229626843661906u, 8644052299983120468u, 10496650739259033879u, 5557300823903499562u, 3130284u},
    {11286523566844944055u, 10344188375551189137u, 17971528397431798183u, 10289921906769095565u, 2027712u},
    {1657798884608768947u, 439952919594033442u, 1761261144779988539u, 685923040950463073u, 3856610u},
    {15981693010331108554u, 2929133902394442365u, 14909485585010377381u, 7493074084254609442u, 1725147u},
    {15163284979994989523u, 13263572116083392486u, 1776366018295029834u, 15163918100656468456u, 2707136u},
    {1316396971579715625u, 18280810938557111593u, 7009767029430620732u, 7832158016224860969u, 3287259u},
    {956785263627674202u, 7056538913107908811u, 2961099275645407777u, 9067838488050148403u, 3366181u},
    {11007197775373304949u, 15514570671897087812u, 4029634042509578252u, 9501639907449181796u, 3140083u},
    {17598348588615400293u, 8717035417070509134u, 7677644166019442080u, 14973846282823928769u, 3856842u},
    {7628143928286347384u, 13662852838130685005u, 5491327152274008544u, 3818141082252833049u, 1916459u},
    {10534137117699926486u, 9756852479425119237u, 15371317535500072774u, 4574980856908358383u, 3394632u},
    {16414502094773354503u, 4725574270740451341u, 9770939577053145192u, 16707924135064758875u, 2093013u},
    {3677344815364630739u, 440768721232079142u, 15148796126225493512u, 10126672457171782224u, 2806427u},
    {7495562737489015373u, 4364411251482847417u, 18166690342697772199u, 10211890210105059908u, 1220313u},
    {5732021301783357474u, 11482899979983535123u, 3066507727128554431u, 10614977135388117526u, 2185859u},
    {5819230902065936410u, 15214453033823197963u, 3208177857964233781u, 3066740941762165134u, 3897076u},
    {273108829537215905u, 16249607392048543685u, 6191464261770848076u, 4107113632798501082u, 3302226u},
    {4946243345004737835u, 13377535357974736564u, 10942577194357556826u, 11085727209805637438u, 3513503u},
    {1708017169083367112u, 12098241810781211804u, 9907899102653372124u, 1794194958639208404u, 243226u},
    {6874786226229859213u, 12395290504084114262u, 748229833262957925u, 3823539213578447646u, 1543860u},
    {2599555727685410254u, 3543878190753552851u, 17272155134942419676u, 3775474084101429113u, 1758013u},
    {9369164829776482776u, 13049470479668716854u, 1227227239063937103u, 7886707369798873458u, 145331u},
    {10115248621035847553u, 1963788127510628525u, 11894061281732926604u, 1804120742597882052u, 2832314u},
    {15309499770614870627u, 17869579026681182024u, 10581079639968112883u, 3078665922891478649u, 1983018u},
    {16960933083579899612u, 2593868183207164703u, 9554227997648218580u, 13799580689862461066u, 3402919u},
    {223307132685456282u, 2310294211152548250u, 9924867965990523165u, 9790547984816415683u, 143576u},
    {6012779577168084601u, 16951147534018192977u, 7364576638373519876u, 11099518001358577051u, 401261u},
    {13985780965331722292u, 12324828816515884957u, 13827030537687951943u, 13193941679014091057u, 2780070u},
    {1534890076219306974u, 10624069759015916455u, 3231577692709465674u, 2068895886052921600u, 3082915u},
    {3943306599232341620u, 2428431115834017568u, 6883628342483759083u, 1786252002985166632u, 2661257u},
    {7171211607565094003u, 6703483840076958602u, 3506872596230735653u, 5597526269500071135u, 1318858u},
    {15916573500507132535u, 172976251134046801u, 5999723509951856581u, 16669632864354443917u, 2125817u},
    {604700538234301541u, 246005871373687200u, 4466218487096467821u, 9190528861633021754u, 2358626u},
    {18263948941607902852u, 2286321576523000026u, 9645089882885375627u, 12149184777750019374u, 321849u},
    {12869859970685835372u, 15260735979294533119u, 4207284661678921674u, 1014743394813555227u, 1130973u},
    {15537076849178467094u, 2159102754036420747u, 9838711058941513840u, 3695800066434343643u, 3765091u},
    {5207034979374025737u, 14214570744689180324u, 15454326154185206734u, 8139904206034956067u, 3617529u},
    {11459486432463858930u, 4321578331345865483u, 10751369931341344165u, 12676810596419515446u, 568376u},
    {2245197412622732495u, 17379053116532455414u, 9754842334811924200u, 3325134025031134392u, 2469790u},
    {17106942407166429770u, 17351301017701958232u, 9533554638504854611u, 8404240495770581714u, 2320222u},
    {15524006984751188912u, 1004751130792336329u, 740829847716468580u, 14814607327607657899u, 460560u},
    {2668032171711809345u, 7291236525533750449u, 12911297852052925950u, 5340757806071862262u, 227573u},
    {190749094717803928u, 6827465205069161078u, 15896854896063115101u, 11893701002487953549u, 2885857u},
    {11029004095051914536u, 12853286869417952836u, 18185694271424286917u, 9925125060602151459u, 2757042u},
    {10656474581185311018u, 8920251701547725541u, 3848568786900080132u, 4446371694413197486u, 2739896u},
    {15110046933403282380u, 5791652008293046975u, 879345631624228508u, 12948851497536052744u, 3784265u},
    {14815181673690199284u, 2143560587921985383u, 16273256158956164149u, 16282766039444733573u, 3562135u},
    {4563824387770083881u, 5212804111402585842u, 1667470074791489687u, 10369945756407464261u, 3185046u},
    {4296196265932481438u, 8695286750846071234u, 17410011177652609475u, 1139617649363857108u, 229897u},
    {10572083487326893047u, 2512373410194275422u, 2798752203124312997u, 14055471689657878774u, 2591968u},
    {5044868079283805441u, 15851235331253399916u, 13667175383964217855u, 12153489182770609736u, 3131206u},
    {13504340921863823324u, 14179037588482121361u, 884311689414918453u, 15550143286032059213u, 2110784u},
    {5203937215608991764u, 4735245368124904231u, 4248029802781409065u, 3065356057385997540u, 2663902u},
    {2604711683216883432u, 1743125399575078701u, 6547914793724174051u, 16622386950220224359u, 466917u},
    {15851535349191353002u, 9658518685572829397u, 17194435779779353396u, 5989393420173069880u, 195846u},
    {15806879041662682816u, 17618323902341354622u, 347850565340281973u, 14198958752501056533u, 179608u},
    {13385691806785127777u, 17726925371346077861u, 11948012602373136771u, 7425245382915126985u, 3589069u},
    {17248144404324939455u, 6405982293226247282u, 11510998695329509369u, 570609802996625601u, 2376405u},
    {2527969901053781544u, 11273289813582985267u, 85705078663723242u, 7105481151138031278u, 389302u},
    {9337810087146073581u, 5228032368933764145u, 22935021459988901u, 7140883171221730091u, 3708309u},
    {9395914054267653735u, 5553463531497161475u, 15962104798545998065u, 9435893459140748644u, 1348040u},
    {6500153356113380996u, 2161091580041455295u, 1866465266959427874u, 9176181401133864755u, 652186u},
    {11931789693236791993u, 17556961132724126020u, 14095107914228000925u, 9595690724451053226u, 1375206u},
    {6050245258131664588u, 11840486843524499542u, 1672863697666309304u, 13067792603591276958u, 3438037u},
    {6482016274186768011u, 2367184052909463462u, 5543149750416196983u, 13610248280853188737u, 2928253u},
    {2882483623753852383u, 151490991933704173u, 9249116041726033503u, 1062823063815311600u, 2043227u},
    {4946310198614635753u, 8083134790325663617u, 15403334427695210836u, 8900774953281452537u, 1123126u},
    {824041168737600189u, 7574087100322189199u, 2761923147447266611u, 11838163449005485571u, 873422u},
    {13791414221772684726u, 24382526509090837u, 18392059127940076493u, 12265902790388260112u, 3574997u},
    {13406317164658709828u, 9012767718058673007u, 5290623322392762538u, 12243680459399003400u, 1371055u},
    {10005700218867802060u, 14943025185635541555u, 12726008078461562010u, 10905988212666778644u, 2819545u},
    {5820827656506635626u, 10989799687346193485u, 6971271120468648688u, 14463530243510882810u, 1832653u},
    {13479732099048482895u, 16975476344713959548u, 7537340705400150185u, 14012979738688465858u, 529983u},
    {10183313384536100178u, 9536265007385494692u, 18125187558997199869u, 13844834530059560259u, 300146u},
    {1904495659058806431u, 11357678579549124836u, 2562182580102243813u, 9228908767146357965u, 2674322u},
    {5094625395743438072u, 8852557166815991246u, 11864250662115236582u, 5309536907502339170u, 2027804u},
    {6945192913846774666u, 4282557854457757796u, 1982479603352744164u, 10557815116266660087u, 2868384u},
    {18235778925073433371u, 8398836891986493804u, 14188656887565018511u, 1205833860717785390u, 3165983u},
    {6011834273333755074u, 7209172041398522685u, 1321965968853964150u, 15334612015389271480u, 1665927u},
    {7977452329476568603u, 13962996230777799444u, 10777685691816400625u, 823364478766302043u, 1575551u},
    {10451367149239566414u, 1823725726914780540u, 9674255833337600193u, 7162765596650307300u, 1155465u},
    {11873207505036154899u, 7364014631767428002u, 13065621126744461273u, 10541723303841373059u, 1401220u},
    {17112900493769319163u, 12417443065180796367u, 13959473591045700732u, 3052266906865659913u, 3189559u},
    {9378241158882926705u, 18163734950204881983u, 11223686378748318990u, 13533607066725787902u, 709209u},
    {11841599579841793877u, 17785740546420990748u, 2173388867840743656u, 9957030587685433712u, 3359772u},
    {9705998419754487193u, 3526469247445136167u, 6224397491185269781u, 3664856566083442675u, 3467099u},
    {7953235632018207587u, 4533632774923371768u, 14420274726905267593u, 7485888877502648286u, 518538u},
    {6290017288001784291u, 6422586231267188801u, 18050244126305826685u, 9449110164232941696u, 1508477u},
    {3356394848829085197u, 8281111120060425204u, 9702812673261602099u, 7233585902401980927u, 249447u},
    {9373443903309356228u, 12150777413383693494u, 17043634535575391229u, 16938136091115605488u, 2936543u},
    {11328119977851193390u, 6970959019430434931u, 17463698209599272667u, 8773138552709859614u, 470586u},
    {11752971166871867027u, 7421901884877023322u, 14141764523294360415u, 5340942747086476499u, 2219207u},
    {9106603752792795892u, 2701861241738110569u, 18438719957093437295u, 6165832642140402059u, 559061u},
    {7082956652142357738u, 210614873059956730u, 14321953150484860380u, 9449857680322984393u, 2915476u},
    {10240073825186688285u, 10029172377787065938u, 556973792206606531u, 3368430374819585165u, 774005u},
    {14923208513787248145u, 18261989814578026367u, 5868411871946270377u, 7508267655459707280u, 455872u},
    {2155144027080442992u, 8302962333272805879u, 3209667656711018857u, 18311038247256333520u, 2995498u},
    {3604053267462766156u, 17377059175053424003u, 12967291636438679869u, 7333074201121068597u, 3772473u},
    {2851891485163817235u, 1160914662211741163u, 8015755303400629068u, 13976705500609145142u, 3264202u},
    {6327432352736543385u, 12108012116563231372u, 7622113013983271792u, 5680706247833975374u, 662204u},
    {8310527017488227452u, 150990301700139538u, 13877430935017862367u, 2318058522606986959u, 294868u},
    {6744030804003992153u, 11858414146772610749u, 12412696908911487940u, 8075889889097513942u, 1992839u},
    {10577235499373818000u, 14570747351152471159u, 4249977956504674676u, 1333798091771700006u, 3168291u},
    {3039968960689319942u, 5005082551492662165u, 14217058068857466375u, 6327455335861565832u, 2306133u},
    {2002149191713562295u, 610781570293685240u, 4767132317735018674u, 5590975392498842437u, 2531112u},
    {1256980475372507287u, 5027954102107366646u, 2005519487369968681u, 11792078609059124091u, 2183719u},
    {1454191184424969677u, 11732767511698923354u, 7461043804800659203u, 5372544476120642821u, 3822944u},
    {1805725990281404147u, 14323055668778705407u, 3942444146086073131u, 574924033214163516u, 1270832u},
    {9500513541993928594u, 12048793045287632595u, 2092377807244005230u, 4202783167439424778u, 3594940u},
    {15620468303873376487u, 12469613800966702734u, 17078877751940797336u, 8424995850742765158u, 1005469u},
    {3583759335243071827u, 16835338497501138454u, 16538484900293529951u, 883238766197179751u, 2060933u},
    {17585441505044051722u, 11044176650930850412u, 9920612475137671937u, 6162912997711175773u, 1601813u},
    {10344685800946525921u, 4184474802862264739u, 13168311218216851269u, 1614815309462268507u, 2352695u},
    {6569556206373456843u, 11733651109896574742u, 27183633297419603u, 8834426036790519595u, 2258818u},
    {4750044685223670033u, 5053561754226151269u, 13884301325019465740u, 10201788605737353474u, 1745981u},
    {3849028060498377767u, 12277010269186713740u, 6961963005247812537u, 3923317752914456626u, 2547869u},
    {13396940730043889323u, 2623263839059303212u, 8868510736798703009u, 4298397939537404258u, 1024032u},
    {11215843173093782230u, 11466395196704293858u, 1804828895637931055u, 10395183601987309663u, 2317431u},
    {12309848837107619577u, 10232150676289307470u, 16571229645084490699u, 9554351479967151953u, 2036516u},
    {6530349553824589819u, 3223089714976973542u, 3430389914678287204u, 16250525757542151761u, 3485616u},
    {1486312431366912903u, 17625861678256301144u, 142173062949933423u, 14619932278203196022u, 444765u},
    {12554488477372468633u, 5405501361129539080u, 17112791055952439475u, 17157911861774724474u, 453732u},
    {9844708122233824705u, 10223983411183266878u, 895688796054970786u, 5484747042122487380u, 231778u},
    {1545678927050904268u, 18233234716516089699u, 10642676111336955794u, 7786495711028880382u, 2083137u},
    {1218292100123501906u, 14085391052813711648u, 4677721203889783551u, 18052825612377954805u, 274395u},
    {9838092518176985724u, 17247107144605374012u, 14639836469506620737u, 15929789994775005000u, 915458u},
    {14883965242084250465u, 18221464796929727126u, 8822803365117250798u, 6430013104741606297u, 3090661u},
    {18201759927206816461u, 14318162916209524191u, 4587049902477662172u, 10289190992301375253u, 944387u},
    {12802174384058396102u, 3293084948666728916u, 11498863608060121283u, 9096677724363649270u, 2629512u},
    {7924649619713815471u, 9000739669428065706u, 15726599415843781538u, 4660191962426813778u, 2096079u},
    {15895682342236165596u, 12086819730047927750u, 12332154644552305408u, 5226812608262280397u, 267209u},
    {11730697299819491393u, 1913356517584631011u, 15496005505002040777u, 12759123285977249135u, 1561189u},
    {4234644671660470288u, 4624121357902457578u, 2860731398176819973u, 8963940527395877891u, 3889669u},
    {4993066295173456937u, 14026717757030511424u, 5912790128805354737u, 2377594746752076237u, 386417u},
    {9972699446475286645u, 1661994119673182457u, 10309444557546393532u, 15067165291809263994u, 3858475u},
    {9984097934425737886u, 17660865480379713845u, 18092743575866415951u, 3025537671462017129u, 1741415u},
    {3334402570451513022u, 5915809137740592125u, 5338372811361964529u, 6373191715194314958u, 658398u},
    {4734918480975283080u, 13098002629766724693u, 10315163361229475428u, 12145305777833936u, 2585809u},
    {14651880274982566687u, 10971088673371861414u, 13511341318936138790u, 2497657954148189951u, 3829880u},
    {16400210465473247111u, 15389286385254826253u, 12751792041658051606u, 17436528981831309267u, 113075u},
    {11761634832872127795u, 17783847022260864045u, 7015084037684132428u, 8504881979498160137u, 2323709u},
    {3675484788613323195u, 14637014112322724921u, 17971258610318153479u, 6383933149067315895u, 2079357u},
    {15218157611841129567u, 4914278878131207353u, 3447822052334483548u, 18340986258434505365u, 2817626u},
    {12167237339377246577u, 14809541331686221574u, 9520161355216373435u, 15760531544326706255u, 649693u},
    {14291444203317078051u, 265901031535141358u, 825678912143803426u, 11984736258012124u, 3289363u},
    {13403322465385581580u, 279253047053213137u, 1665237984864249511u, 9428165262369145888u, 2443726u},
    {6800509113193543767u, 10015282920352148579u, 1872475570816657106u, 13375733694553103370u, 2666223u},
    {16521833770456330724u, 16012764714406348957u, 7219497396953235474u, 1994738185724226068u, 0u},
    {10754635338151291699u, 15715913221515782701u, 13359612935124468137u, 1994738185u, 0u},
    {12954953815911108024u, 14538341978142428738u, 18349680732400958526u, 1u, 0u},
    {18131640678213654351u, 2038552321561642993u, 36796424806u, 0u, 0u},
    {12570155405993318771u, 14691444572274331667u, 36u, 0u, 0u},
    {15092938650099753871u, 678774231225u, 0u, 0u, 0u},
    {14282045276542575092u, 678u, 0u, 0u, 0u},
    {12521174527252u, 0u, 0u, 0u, 0u},
    {12522u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 958206u},
    {8559742597383587436u, 15244535695874542414u, 11358783659110083546u, 17095325567840813766u, 2028594u},
    {16441661769054260693u, 12558585180948069461u, 18294035850200623282u, 2919724732959905761u, 3754960u},
    {13336172316164032383u, 7649953656338883368u, 16526827647612003962u, 8067659727256742046u, 3109955u},
    {1880546254380768252u, 5628005295641184943u, 15729157320191982439u, 12090986756367378427u, 2241968u},
    {10963553148753550614u, 4703105855628664818u, 7098283431226458065u, 5661849356966812220u, 3426827u},
    {9856116952237132818u, 1017074096587701359u, 11112588918795085317u, 12096832010649692550u, 3749924u},
    {11949733213488134344u, 2336749810503249527u, 5234627670075224774u, 6122011799606639851u, 487490u},
    {6533622909753609882u, 1567224864194991301u, 17043383876748732661u, 8223558329714289172u, 1298521u},
    {5661356030132685160u, 13663340802701856291u, 7161931949165403542u, 1681278155657238258u, 2017941u},
    {5995762701005809395u, 11438098584864831097u, 17612599174182421011u, 16682528665625476897u, 766088u},
    {12293606676644822655u, 14708339677869827403u, 11139529532032082395u, 9525734258962956220u, 208484u},
    {5613228148562967380u, 16003041532531873779u, 2251726987855802489u, 4039071126641161937u, 1889184u},
    {17415813457372800300u, 3009301955068858645u, 3713021173175291378u, 2556865089122695792u, 1461322u},
    {1313909153692743263u, 17830550550313673753u, 9394781842831852748u, 16528145670185643822u, 490834u},
    {15309591479025065644u, 630203588105295740u, 4492364481266488377u, 7214813709501614424u, 1736387u},
    {7497698845191509456u, 14942730306048959178u, 12976653876847618355u, 5292235058585469344u, 2072588u},
    {14797435215749411880u, 15614179888047841958u, 13838222644098150609u, 3136709049329377838u, 339278u},
    {4530839820014369595u, 10551640650841695080u, 10746170807141785986u, 1087122488141468118u, 2768078u},
    {11596400896420858971u, 2063567947213299189u, 6633120200418315032u, 6896533461132342196u, 626915u},
    {16557504502521971699u, 13651365527433684533u, 12611796096889354327u, 5271768912226242412u, 2801361u},
    {3052019228448763415u, 10040262776679115586u, 8315640756377728662u, 411963964886479655u, 3111973u},
    {16475983701783105021u, 8180463787997302843u, 6596150284979668499u, 9496950588875817715u, 3114065u},
    {724449902237950584u, 7140265704432333448u, 13445771902238523270u, 12019004979876884299u, 1725517u},
    {14416764029306931971u, 10439440553595475467u, 4660934614245571429u, 14299233802022571392u, 3322850u},
    {17978106086013482605u, 6476845563978382149u, 11248769053002845471u, 5537672924727082721u, 285013u},
    {16244068354075695823u, 16708720169313636370u, 2984936457724362462u, 8147765693692209873u, 98855u},
    {17758941188498015211u, 4909602981068365439u, 7696157852282697539u, 73881155071100187u, 729877u},
    {944003420421080628u, 13638058694740988077u, 8779385090626585346u, 3832516338308348669u, 525034u},
    {17878542685988438337u, 2593131766505477812u, 581139095187574279u, 1234664270305287271u, 272786u},
    {16196010877868560226u, 1671849455276136u, 966783656434783934u, 2022644647825537412u, 362362u},
    {15731857517365187127u, 15263957571735148249u, 6792356875808278273u, 18093140504618594124u, 786885u},
    {16071558311961859154u, 3913240965771944717u, 2618520566930744661u, 5274719849072320773u, 2949379u},
    {72568861621489109u, 353248751904585302u, 13059690436128796165u, 6611647502315535428u, 2437176u},
    {8858547200713240568u, 9129958998044100476u, 8943200023230890075u, 15897628656890380572u, 3095370u},
    {12393187276872111585u, 11862236837632486128u, 12469971185080793761u, 11586314560169536751u, 1468021u},
    {5535354646706316823u, 5055919654075726699u, 15539697467028665781u, 1828520070216344129u, 944724u},
    {14858507827069333801u, 3178122930322488136u, 12123534346657021890u, 5349689042483478516u, 1856u},
    {16535230634164140631u, 14509583214892564150u, 7586736553282765458u, 7277851240337411383u, 3778750u},
    {18015236487813506965u, 7130964991526697034u, 9340903316038096145u, 15345915577487103640u, 2987368u},
    {59304861366174947u, 5173688090729594321u, 5148307863404558253u, 8341730542657617773u, 255164u},
    {4580024045405321765u, 15771748608849005318u, 12657469514308027965u, 14920628919197637318u, 545470u},
    {13983423119518209279u, 18072979352346522041u, 5858996536744336228u, 13340717057427183428u, 2376328u},
    {17254043009594656429u, 14812171850549833030u, 14752404977832841626u, 3718772823726231864u, 1597826u},
    {7190517356034076324u, 14068012888309641077u, 13772683725363253108u, 3344124016759776917u, 2215137u},
    {10048522742599128636u, 4429256071534734643u, 14716596774893198266u, 10417155610132951555u, 1356429u},
    {9600699514401496702u, 16421508697023246481u, 9627186387228271035u, 1682346371906655911u, 120080u},
    {10742593075337910964u, 15973214477243427760u, 15950995367212322295u, 14557849082372160486u, 2433931u},
    {11007324790992060251u, 2624625028000706448u, 856721818924894746u, 16762259933607198197u, 376022u},
    {4815347823889337064u, 4549688912297004711u, 11528288079588743600u, 4402449634675948442u, 1781118u},
    {8055906958014867383u, 3589988752752496003u, 15331737045307605844u, 18191369529871366915u, 440599u},
    {5231180284145815752u, 3211442157425510302u, 11138603392518255605u, 4043352901307466300u, 591835u},
    {7158350206843384062u, 18001405825206269940u, 14538278572105737569u, 5127006609515100249u, 864120u},
    {13209261640685906825u, 1273723217461664551u, 4750371772411563342u, 11977500815912017883u, 3899496u},
    {10357722977604208061u, 11343612135720384343u, 11075488216023574575u, 8070325954915955813u, 1624977u},
    {16726486748920737518u, 4970565498816891626u, 17935190876282854089u, 9829808332073189576u, 2284432u},
    {15976119599932342109u, 753768961295845604u, 9046867852108562697u, 10634606665863007382u, 3133146u},
    {14693439749157423224u, 5111824935852853348u, 12368012820955600073u, 7840016509138390540u, 338497u},
    {11833676136728267929u, 9683329522827180133u, 4275064163341174124u, 4978218163985762555u, 2328732u},
    {14405476938886057174u, 15385816735874243073u, 9953742593869704670u, 14238303553670279347u, 3234443u},
    {18372329055524712760u, 16073725970065175907u, 17114690582341511099u, 11012419250245351168u, 367199u},
    {6346432662226854383u, 10363940344878251752u, 16402748038944325051u, 15643271543219903435u, 2800903u},
    {1831404121178666352u, 7088544725581943164u, 8666514342286582246u, 1348704249142259695u, 1628050u},
    {9122863477861047541u, 7866432612040762152u, 12003084147638751550u, 9757807418158178444u, 3793564u},
    {4032878111530889091u, 9577295666844489420u, 11525117445916972657u, 9581581326999532871u, 1916332u},
    {14101443432199785243u, 18004789333370123255u, 8613253053244930064u, 11348392359500527251u, 3723809u},
    {14378037962746503723u, 14347390269344627468u, 3581483239824833775u, 10661158486526175243u, 2995534u},
    {7689490970559887455u, 6093217227568132669u, 9530661352757254542u, 1064064176254245058u, 643490u},
    {8448683115380338587u, 16804794040246100278u, 11503848900929884960u, 10388163837869678319u, 527536u},
    {14645282560870696142u, 14299009918675537839u, 16435615390459606847u, 5558166072890283351u, 3643550u},
    {8772209830639871104u, 13098311030817349750u, 12557808297512484878u, 5039185628544958093u, 2958943u},
    {17567847743604760996u, 17767243031842166428u, 6129114848000406516u, 17276347844353656694u, 1981904u},
    {18362197719460176731u, 1749051004865641862u, 9954113209258940254u, 2558575484470486859u, 589730u},
    {14945683223232040514u, 13117503287502839359u, 6363952190738227150u, 2388779204192786106u, 3353913u},
    {3648879311074277331u, 3355495484649257487u, 10733413547974972071u, 7627916151127699907u, 2374254u},
    {942414625137438295u, 8709180246329270283u, 16421187748427265485u, 10564205993069376004u, 268693u},
    {1658561425771179011u, 4018345710795705253u, 11468966004096562152u, 1013762838100594337u, 1191341u},
    {9442908455281753463u, 5157031544715386779u, 596777878567964676u, 13136458478448164401u, 706080u},
    {5299541705460696002u, 5092023965359723141u, 12049222877591760385u, 7218784293984816918u, 1583263u},
    {5215402891863671162u, 18396214775881614451u, 14849996561207824664u, 15377473584659808267u, 3881290u},
    {1816894851943204408u, 13833072761294189571u, 4638856371750759779u, 5980319889793412482u, 3306298u},
    {11736837487419822938u, 9389034493134579020u, 16275378755769260352u, 8924074505682873760u, 227453u},
    {9526568268210325599u, 12941462363992086002u, 6024481728045171646u, 11173122852082702044u, 2825051u},
    {13568312574586181604u, 10216895349542625354u, 10791980963945349454u, 16193014068461157758u, 2233162u},
    {16966869133401167707u, 18385690046515463071u, 3081483413782180972u, 9624854591126562926u, 1082908u},
    {2799766533797552020u, 14435747443720474025u, 4573727307678171782u, 3190510274025056438u, 2128267u},
    {17339177526216268628u, 15552493145254891038u, 5795707077909269857u, 13586087278990483848u, 2643977u},
    {18246044068929091432u, 5540825234734866068u, 2647120324158997857u, 18423459260313485318u, 1915123u},
    {2325806020109330203u, 10448620149909202861u, 17210334194492205872u, 3422034722056747109u, 1409680u},
    {2940521632799318584u, 13129988384632888456u, 14366139631460411086u, 7087648225324799330u, 294532u},
    {1621700940847014781u, 14650163574033904958u, 18102952893537217429u, 8219998883836950750u, 734950u},
    {8022994845893974202u, 13313321963553548691u, 14704452199241844087u, 13055981963641928134u, 1417229u},
    {8283170479275734606u, 11639601390489793734u, 14187763469131269132u, 11267127943629579293u, 2885654u},
    {15692380259649499423u, 6279434837334920647u, 1632465973873583521u, 557634090355899758u, 2983803u},
    {6221934034266937631u, 17405233844484364938u, 11001184487969093744u, 12953350783654101415u, 304636u},
    {15761845161746631036u, 16147180353583782239u, 11440545081635450511u, 4977593543898016950u, 3454262u},
    {14927104711465059897u, 6341385261888257272u, 1516402470062238271u, 7269479295847927247u, 1286313u},
    {739479957272192736u, 14833417083095138747u, 5824726478057780832u, 18326357179612860594u, 1598771u},
    {5046640672429476883u, 2046137069617505255u, 2942708184213528056u, 1470644018554384593u, 1756460u},
    {13050136537759748767u, 13949171534629651733u, 10806544536182561085u, 5436720522410947097u, 490180u},
    {14145325017188185793u, 15512271402821396980u, 7785964431674610967u, 18095498333966683406u, 2342062u},
    {14464098314233969501u, 7772670937837571635u, 15560854236036981323u, 4006371108500295153u, 3194374u},
    {6411340700181951377u, 491552518480377836u, 13541820086204824788u, 17785093936990355239u, 2122738u},
    {13795996638395566668u, 1863629175268007192u, 3110118242017407211u, 12793351767119876675u, 68634u},
    {14082300370193899830u, 16776116819913243725u, 8955695376548246888u, 505669244891602300u, 306016u},
    {15033097893452130966u, 6262355740003351351u, 718023952972841462u, 12471608767901662475u, 2424423u},
    {1409821041766408700u, 13252896342985116027u, 2936353515581105548u, 14095953560474971420u, 2696123u},
    {14100162174073600529u, 14228072518066332292u, 16723009991410075647u, 1490886585826754297u, 1698708u},
    {12222676943090704868u, 15262254010699597767u, 15371052503912904554u, 13001702560049878070u, 3132656u},
    {958469351587419413u, 5741969878436673266u, 3265999115780844853u, 18288358608100441037u, 2136626u},
    {2858405673486702741u, 8620128481019447374u, 9804973033000569799u, 16828833222128801440u, 1780727u},
    {11506056821949299726u, 14335063536827359461u, 15666935449585325526u, 17614901577317394194u, 354980u},
    {17952703772815144775u, 10140062890981795168u, 17525179324652351998u, 13625433515994566897u, 3188524u},
    {10966616523380308709u, 5595607576662543271u, 6482585828884977859u, 2508776097115864014u, 3751264u},
    {9545421633093430966u, 4320317247961791309u, 10129229626843661905u, 8644052299983120468u, 2165825u},
    {937839801610212500u, 3918630650724784556u, 11286523566844944054u, 10344188375551189137u, 412395u},
    {1512175757089923922u, 5318870844012893645u, 1657798884608768946u, 439952919594033442u, 2538667u},
    {10320428777584933956u, 7568336989175732953u, 15981693010331108553u, 2929133902394442365u, 269685u},
    {3014120534086204006u, 17381108013282049021u, 15163284979994989522u, 13263572116083392486u, 2723496u},
    {6344584320005948312u, 481774997413241827u, 1316396971579715624u, 18280810938557111593u, 3629490u},
    {8610989189844695009u, 8903087713238645806u, 956785263627674201u, 7056538913107908811u, 1202811u},
    {3397781320517789269u, 792575306949254308u, 11007197775373304948u, 15514570671897087812u, 3801436u},
    {15590140393220683939u, 13950533862319421568u, 17598348588615400292u, 8717035417070509134u, 2383486u},
    {9053071711156429621u, 15463471187011803269u, 7628143928286347383u, 13662852838130685005u, 1576282u},
    {7046179378429070963u, 12199792116670354621u, 10534137117699926485u, 9756852479425119237u, 2267644u},
    {3213800558664780621u, 7468960161427187992u, 16414502094773354502u, 4725574270740451341u, 456620u},
    {1982974078123933920u, 1186315247044073917u, 3677344815364630738u, 440768721232079142u, 2220208u},
    {15238848732680288502u, 15327898784032728117u, 7495562737489015372u, 4364411251482847417u, 1395505u},
    {11852234170554383154u, 7944948566992202450u, 5732021301783357473u, 11482899979983535123u, 558401u},
    {14160407018604716134u, 13761420450219038898u, 5819230902065936409u, 15214453033823197963u, 1986731u},
    {6476152800225660453u, 9494261620341649559u, 273108829537215904u, 16249607392048543685u, 2541394u},
    {17819975496571668756u, 12185375482145451049u, 4946243345004737834u, 13377535357974736564u, 3503252u},
    {6185299725001349384u, 8944460414592155400u, 1708017169083367111u, 12098241810781211804u, 75044u},
    {5616126439543289452u, 13103578972848393925u, 6874786226229859212u, 12395290504084114262u, 707771u},
    {1545483073740492011u, 10164731167197760177u, 2599555727685410253u, 3543878190753552851u, 381962u},
    {5373942987329251503u, 8080119237298198197u, 9369164829776482775u, 13049470479668716854u, 988417u},
    {5383085566455523344u, 8140990723645216731u, 10115248621035847552u, 1963788127510628525u, 3868070u},
    {1097099504153830816u, 14976982947378829084u, 15309499770614870626u, 17869579026681182024u, 3895125u},
    {3507826287112817599u, 3353127588652459494u, 16960933083579899611u, 2593868183207164703u, 241300u},
    {15504917062899489283u, 14684391516332556308u, 223307132685456281u, 2310294211152548250u, 954799u},
    {6175901826003754809u, 9609012765615111569u, 6012779577168084600u, 16951147534018192977u, 161558u},
    {6537925459461018657u, 1931261220052671717u, 13985780965331722291u, 12324828816515884957u, 1713225u},
    {18385149756149318303u, 5771403360822482919u, 1534890076219306973u, 10624069759015916455u, 2739264u},
    {16937031400551571173u, 10539669663325772886u, 3943306599232341619u, 2428431115834017568u, 115337u},
    {7526717087879908546u, 10769802798548853796u, 7171211607565094002u, 6703483840076958602u, 1564561u},
    {1569526395856059025u, 12232140230150622934u, 15916573500507132534u, 172976251134046801u, 1617255u},
    {9195159846292387848u, 10968180026793944640u, 604700538234301540u, 246005871373687200u, 2847991u},
    {10145495562652063384u, 3423745889921977395u, 18263948941607902851u, 2286321576523000026u, 3067405u},
    {13120935663122334981u, 16333421379441844753u, 12869859970685835371u, 15260735979294533119u, 3763944u},
    {735792248411504337u, 2552072729540416672u, 15537076849178467093u, 2159102754036420747u, 1042174u},
    {5639953576904958539u, 1368556363768770069u, 5207034979374025736u, 14214570744689180324u, 3804480u},
    {17382833077072462632u, 1913890281852884504u, 11459486432463858929u, 4321578331345865483u, 714107u},
    {12858503822111550581u, 430533155089471860u, 2245197412622732494u, 17379053116532455414u, 3115912u},
    {9845139850136141148u, 6800749885571148586u, 17106942407166429769u, 17351301017701958232u, 3686417u},
    {9187303386267008404u, 15080689821797964470u, 15524006984751188911u, 1004751130792336329u, 727474u},
    {12849713682110481257u, 4969344770818147509u, 2668032171711809344u, 7291236525533750449u, 2930130u},
    {18006745650745046317u, 14278779879123285368u, 190749094717803927u, 6827465205069161078u, 1465577u},
    {4293884791662502452u, 7711773659624234602u, 11029004095051914535u, 12853286869417952836u, 3099063u},
    {2753708303139704122u, 17468388524755825403u, 10656474581185311017u, 8920251701547725541u, 1466084u},
    {8769505304706162142u, 8311984413644727046u, 15110046933403282379u, 5791652008293046975u, 2921402u},
    {13891270864160972281u, 10374915411970604430u, 14815181673690199283u, 2143560587921985383u, 1336677u},
    {12262104165114732963u, 13108254928753629114u, 4563824387770083880u, 5212804111402585842u, 2622439u},
    {1391963465480675629u, 4101923835862317624u, 4296196265932481437u, 8695286750846071234u, 3383535u},
    {9557145211907151056u, 11382979242842568147u, 10572083487326893046u, 2512373410194275422u, 3828439u},
    {3831651785790366108u, 12072880856099238323u, 5044868079283805440u, 15851235331253399916u, 3022167u},
    {15436838487222318218u, 8987527622040180842u, 13504340921863823323u, 14179037588482121361u, 2791915u},
    {10844255467394248784u, 13958115168734019256u, 5203937215608991763u, 4735245368124904231u, 745017u},
    {2816224436036340911u, 2851752480854539660u, 2604711683216883431u, 1743125399575078701u, 151847u},
    {12797091571257534754u, 8182486447849730726u, 15851535349191353001u, 9658518685572829397u, 1966252u},
    {1761445773066985472u, 15436078006101970129u, 15806879041662682815u, 17618323902341354622u, 41049u},
    {5155250786019331291u, 11878030282131728601u, 13385691806785127776u, 17726925371346077861u, 3518995u},
    {10249928793366176936u, 10922462390690804035u, 17248144404324939454u, 6405982293226247282u, 1751265u},
    {9716596127973394765u, 13265773208026340072u, 2527969901053781543u, 11273289813582985267u, 2162202u},
    {7643211110283536443u, 12994054902219942113u, 9337810087146073580u, 5228032368933764145u, 272611u},
    {17524111157913039508u, 1603271399192315195u, 9395914054267653734u, 5553463531497161475u, 3871759u},
    {16104210563397592745u, 16334931999940310411u, 6500153356113380995u, 2161091580041455295u, 2546020u},
    {4069015493066817999u, 7444973753562818903u, 11931789693236791992u, 17556961132724126020u, 1249077u},
    {10303614978746957057u, 3251541619760948831u, 6050245258131664587u, 11840486843524499542u, 3325304u},
    {17322322042683693854u, 6945329805291461887u, 6482016274186768010u, 2367184052909463462u, 399843u},
    {12281142112320312011u, 5811167296489048330u, 2882483623753852382u, 151490991933704173u, 687615u},
    {2973367417190211914u, 5391307963255930727u, 4946310198614635752u, 8083134790325663617u, 435834u},
    {11330314414572869466u, 20386018775998452u, 824041168737600188u, 7574087100322189199u, 1321779u},
    {4163946436239695198u, 5827252592141962241u, 13791414221772684725u, 24382526509090837u, 301867u},
    {15802096084384686196u, 10042696521587623446u, 13406317164658709827u, 9012767718058673007u, 1469268u},
    {11798578071290199312u, 1857095477195451788u, 10005700218867802059u, 14943025185635541555u, 2008234u},
    {15002162830484006265u, 11406242466442583051u, 5820827656506635625u, 10989799687346193485u, 2273666u},
    {15721494928560724223u, 9322524791843477084u, 13479732099048482894u, 16975476344713959548u, 1336961u},
    {16964819960542177962u, 15623242601770353283u, 10183313384536100177u, 9536265007385494692u, 2419739u},
    {9604020820694777177u, 7829765418637593120u, 1904495659058806430u, 11357678579549124836u, 3335585u},
    {10382000530960191571u, 8076042965691544480u, 5094625395743438071u, 8852557166815991246u, 1689176u},
    {16492220939075135092u, 6253296147907053188u, 6945192913846774665u, 4282557854457757796u, 2176860u},
    {10126512911066585515u, 9689727149961318997u, 18235778925073433370u, 8398836891986493804u, 184999u},
    {12363204253917319043u, 4183153000061213580u, 6011834273333755073u, 7209172041398522685u, 3029292u},
    {3489949484910114128u, 5647160520347732801u, 7977452329476568602u, 13962996230777799444u, 1208119u},
    {1260405539172705454u, 13773840142643989503u, 10451367149239566413u, 1823725726914780540u, 766533u},
    {17617354831136817293u, 2101473408516057416u, 11873207505036154898u, 7364014631767428002u, 1275937u},
    {16433227520893003298u, 8106244633443516401u, 17112900493769319162u, 12417443065180796367u, 283044u},
    {1127058613999667421u, 14470553893857436364u, 9378241158882926704u, 18163734950204881983u, 3229426u},
    {14802865967727559888u, 1095099978417429395u, 11841599579841793876u, 17785740546420990748u, 3670280u},
    {17481480923985792329u, 10126715071984512410u, 9705998419754487192u, 3526469247445136167u, 3581225u},
    {13553218275948364387u, 8502042815361217516u, 7953235632018207586u, 4533632774923371768u, 512847u},
    {10896964195902666265u, 2065295741000621285u, 6290017288001784290u, 6422586231267188801u, 3607433u},
    {12112024237795080513u, 16339925829170993108u, 3356394848829085196u, 8281111120060425204u, 2444963u},
    {9078559869112863133u, 10339602762478011430u, 9373443903309356227u, 12150777413383693494u, 2896445u},
    {12065023721411039398u, 4730048658225488392u, 11328119977851193389u, 6970959019430434931u, 3904607u},
    {4999739560246453007u, 10213402837722480293u, 11752971166871867026u, 7421901884877023322u, 1936941u},
    {9975303333535172529u, 9821996082760818243u, 9106603752792795891u, 2701861241738110569u, 3604955u},
    {13198760557737739684u, 10012705919747794390u, 7082956652142357737u, 210614873059956730u, 713774u},
    {6352611633788447858u, 3094042159282472202u, 10240073825186688284u, 10029172377787065938u, 1703201u},
    {8871130911717581343u, 16845838743787203763u, 14923208513787248144u, 18261989814578026367u, 885739u},
    {17946006532170306022u, 7923489028407338319u, 2155144027080442991u, 8302962333272805879u, 606015u},
    {9442538540563544398u, 824593356551881439u, 3604053267462766155u, 17377059175053424003u, 433309u},
    {9973585466489363234u, 1150945988268354555u, 2851891485163817234u, 1160914662211741163u, 126652u},
    {11665208493190394184u, 1134695274062740536u, 6327432352736543384u, 12108012116563231372u, 372700u},
    {13639262702035540538u, 6100185822417418857u, 8310527017488227451u, 150990301700139538u, 2220919u},
    {8977078963488099904u, 9597267678185686856u, 6744030804003992152u, 11858414146772610749u, 819296u},
    {14329177125810157006u, 1272226052861760063u, 10577235499373817999u, 14570747351152471159u, 1794818u},
    {10375682581180334576u, 7096387755561536109u, 3039968960689319941u, 5005082551492662165u, 1860535u},
    {3335768367774315123u, 5689299453766210413u, 2002149191713562294u, 610781570293685240u, 3034688u},
    {5313094042609164406u, 8077752902939735096u, 1256980475372507286u, 5027954102107366646u, 3222101u},
    {3302342475068539329u, 8243781275837109173u, 1454191184424969676u, 11732767511698923354u, 3016903u},
    {12214144519948799332u, 2989304256334403559u, 1805725990281404146u, 14323055668778705407u, 822629u},
    {12792257556030707029u, 4206405188052677871u, 9500513541993928593u, 12048793045287632595u, 197868u},
    {2733949391189828u, 1011396630986970661u, 15620468303873376486u, 12469613800966702734u, 2489278u},
    {50208882978134745u, 15706727392048493915u, 3583759335243071826u, 16835338497501138454u, 1049765u},
    {15238176346926036593u, 11393102624680838694u, 17585441505044051721u, 11044176650930850412u, 278333u},
    {16649515998606438928u, 13504868007030475971u, 10344685800946525920u, 4184474802862264739u, 3270001u},
    {17735540405688061941u, 2824668767838087323u, 6569556206373456842u, 11733651109896574742u, 516631u},
    {18115841286502781668u, 5110940693246579887u, 4750044685223670032u, 5053561754226151269u, 1475560u},
    {7129869941064507487u, 12895862303511687370u, 3849028060498377766u, 12277010269186713740u, 1582417u},
    {11241672703707089176u, 5761854506951048622u, 13396940730043889322u, 2623263839059303212u, 500779u},
    {8685384378635475876u, 2162034743827590966u, 11215843173093782229u, 11466395196704293858u, 3904749u},
    {4958547202586969139u, 1681629191135437365u, 12309848837107619576u, 10232150676289307470u, 2849043u},
    {12628770659984200344u, 8083874303378972758u, 6530349553824589818u, 3223089714976973542u, 2374876u},
    {5528797161465089787u, 5344264267135124392u, 1486312431366912902u, 17625861678256301144u, 64065u},
    {13943191546405472958u, 13681770155272943737u, 12554488477372468632u, 5405501361129539080u, 3462001u},
    {17598533741521661887u, 13844380463122976315u, 9844708122233824704u, 10223983411183266878u, 144384u},
    {33728247377089097u, 2229522497145176644u, 1545678927050904267u, 18233234716516089699u, 1851828u},
    {1824156979415211813u, 8512239337484488265u, 1218292100123501905u, 14085391052813711648u, 1373801u},
    {8883839957539405547u, 10816973888129509850u, 9838092518176985723u, 17247107144605374012u, 3412585u},
    {4932029417883656879u, 10469687111680778918u, 14883965242084250464u, 18221464796929727126u, 2751666u},
    {12366124165395518961u, 2229690728076435523u, 18201759927206816460u, 14318162916209524191u, 2737242u},
    {8644878668634738504u, 3397954233915437760u, 12802174384058396101u, 3293084948666728916u, 3556075u},
    {9451961736877821806u, 7259154559376512332u, 7924649619713815470u, 9000739669428065706u, 2884060u},
    {3201940614349996971u, 1698718721111043552u, 15895682342236165595u, 12086819730047927750u, 2160764u},
    {9599899896539551486u, 6611718518704218082u, 11730697299819491392u, 1913356517584631011u, 674121u},
    {4555128052442877284u, 16845296339242136767u, 4234644671660470287u, 4624121357902457578u, 2577393u},
    {17951343023340874747u, 6106435724147401234u, 4993066295173456936u, 14026717757030511424u, 253131u},
    {2437931491507156431u, 9466626600730072775u, 9972699446475286644u, 1661994119673182457u, 366186u},
    {11592884483738899760u, 18127873148609200843u, 9984097934425737885u, 17660865480379713845u, 384155u},
    {17261433842791202115u, 644549270780604856u, 3334402570451513021u, 5915809137740592125u, 3012895u},
    {15797325160722157880u, 18388860792441714706u, 4734918480975283079u, 13098002629766724693u, 993908u},
    {11210841709773461790u, 7975394755126125410u, 14651880274982566686u, 10971088673371861414u, 2223636u},
    {7422206610882259622u, 15928500206798684445u, 16400210465473247110u, 15389286385254826253u, 3126778u},
    {8754781597870371402u, 14177996435877121996u, 11761634832872127794u, 17783847022260864045u, 505374u},
    {3987074181544999741u, 12074114503350928916u, 3675484788613323194u, 14637014112322724921u, 778591u},
    {12230466771639015534u, 6605484396579671500u, 15218157611841129566u, 4914278878131207353u, 2045594u},
    {8473813469861066311u, 17312027261606163371u, 12167237339377246576u, 14809541331686221574u, 2695773u},
    {12391979217664734689u, 15576165965481426766u, 14291444203317078050u, 265901031535141358u, 3419588u},
    {17285699779102754742u, 6471352220963677225u, 13403322465385581579u, 279253047053213137u, 3867075u},
    {15741631654929539550u, 969785390307647372u, 6800509113193543766u, 10015282920352148579u, 866214u},
    {7291813406851304019u, 244327384480485433u, 16521833770456330723u, 16012764714406348957u, 398862u},
    {3677534512557996080u, 16848486937069966658u, 10754635338151291698u, 15715913221515782701u, 2968847u},
    {1767644386465028887u, 7880407506176065246u, 12954953815911108023u, 14538341978142428738u, 1135142u},
    {8841416965565659045u, 3918741150281876334u, 18131640678213654350u, 2038552321561642993u, 3456056u},
    {9146484503763957319u, 5970446885758525516u, 12570155405993318770u, 14691444572274331667u, 36u},
    {14583981928082736287u, 5326590660885604737u, 15092938650099753870u, 678774231225u, 0u},
    {3399223179347815367u, 17638102829046651306u, 14282045276542575091u, 678u, 0u},
    {9489291632850881240u, 11410616131456490643u, 12521174527251u, 0u, 0u},
    {8108787653629104004u, 3219459544495685547u, 12521u, 0u, 0u},
    {14600035003161000364u, 230974902006461u, 0u, 0u, 0u},
    {16639082353499510799u, 230974u, 0u, 0u, 0u},
    {4260734904763344u, 0u, 0u, 0u, 0u},
    {4260735u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2189186u},
    {2743817708075818480u, 14102809151311148291u, 8559742597383587435u, 15244535695874542414u, 1114766u},
    {12698929934268261483u, 9403924262498755991u, 16441661769054260692u, 12558585180948069461u, 642318u},
    {8686800665762480305u, 4299099972757223932u, 13336172316164032382u, 7649953656338883368u, 407278u},
    {6832196980787072456u, 3492555964890136858u, 1880546254380768251u, 5628005295641184943u, 1049629u},
    {1337445509893469467u, 15931271585805247557u, 10963553148753550613u, 4703105855628664818u, 448197u},
    {13750049649203572390u, 6599162830369976835u, 9856116952237132817u, 1017074096587701359u, 1675461u},
    {10713368456253605267u, 10611677267515020539u, 11949733213488134343u, 2336749810503249527u, 2928180u},
    {4714239208632274642u, 801512055185281339u, 6533622909753609881u, 1567224864194991301u, 2409939u},
    {5626563808783318610u, 4282660318070042141u, 5661356030132685159u, 13663340802701856291u, 2873066u},
    {1801101672415658892u, 15247073510973143324u, 5995762701005809394u, 11438098584864831097u, 465691u},
    {8104067806661982497u, 11259306766141090949u, 12293606676644822654u, 14708339677869827403u, 339119u},
    {485282286033680092u, 3418240090509424045u, 5613228148562967379u, 16003041532531873779u, 2978335u},
    {3211188788290951435u, 502673834767057593u, 17415813457372800299u, 3009301955068858645u, 1752332u},
    {6520949286860152193u, 13378243088457679021u, 1313909153692743262u, 17830550550313673753u, 2913404u},
    {18322464030421062332u, 6630393183980482682u, 15309591479025065643u, 630203588105295740u, 1453283u},
    {4025942477000168179u, 2755787345767039949u, 7497698845191509455u, 14942730306048959178u, 2696387u},
    {10728979593997685162u, 8165461873861162751u, 14797435215749411879u, 15614179888047841958u, 1693085u},
    {2486699012465250428u, 12062284766384621082u, 4530839820014369594u, 10551640650841695080u, 2491242u},
    {16961380847022744079u, 15710856300931912311u, 11596400896420858970u, 2063567947213299189u, 1760758u},
    {11188912904112222288u, 2474483934009654069u, 16557504502521971698u, 13651365527433684533u, 1314985u},
    {5773363189064013655u, 5308884144262122051u, 3052019228448763414u, 10040262776679115586u, 2057580u},
    {468620557266302501u, 8734291118460669028u, 16475983701783105020u, 8180463787997302843u, 355829u},
    {12592144848050108195u, 10871152031036278805u, 724449902237950583u, 7140265704432333448u, 3423206u},
    {928162642715867685u, 18126702058466206823u, 14416764029306931970u, 10439440553595475467u, 3454251u},
    {9290540156283433007u, 7290819166624289624u, 17978106086013482604u, 6476845563978382149u, 3437785u},
    {3767784232259910904u, 13323167333994480472u, 16244068354075695822u, 16708720169313636370u, 525110u},
    {6236882987038514719u, 14079106684919589190u, 17758941188498015210u, 4909602981068365439u, 1039393u},
    {15946285375104422710u, 15290521708935464082u, 944003420421080627u, 13638058694740988077u, 3855204u},
    {1016935997058001016u, 14225761641133611842u, 17878542685988438336u, 2593131766505477812u, 90631u},
    {11607696092557704539u, 2170282771182199557u, 16196010877868560225u, 1671849455276136u, 3242048u},
    {3843161117296873999u, 5683402910203456023u, 15731857517365187126u, 15263957571735148249u, 1199717u},
    {873317106528324042u, 14500348408379663655u, 16071558311961859153u, 3913240965771944717u, 3524653u},
    {13571416138389611706u, 3410740145672185373u, 72568861621489108u, 353248751904585302u, 2748569u},
    {10729538318527663338u, 12153519350999182781u, 8858547200713240567u, 9129958998044100476u, 2428147u},
    {3208365118526356599u, 1248140197021201396u, 12393187276872111584u, 11862236837632486128u, 644453u},
    {198660295048796469u, 4972282972828402416u, 5535354646706316822u, 5055919654075726699u, 411389u},
    {3857639494142690986u, 1822257744477425550u, 14858507827069333800u, 3178122930322488136u, 1409832u},
    {3603125748426491433u, 3733565071813039504u, 16535230634164140630u, 14509583214892564150u, 3757886u},
    {15760858295213367437u, 4719581876798307533u, 18015236487813506964u, 7130964991526697034u, 3122443u},
    {11848487415994093422u, 16858865245781786807u, 59304861366174946u, 5173688090729594321u, 3425705u},
    {1474496208747939448u, 12581125185359088418u, 4580024045405321764u, 15771748608849005318u, 3175673u},
    {3131538792082659676u, 3023892496105763237u, 13983423119518209278u, 18072979352346522041u, 2188194u},
    {5561841007541278650u, 7159697849971145198u, 17254043009594656428u, 14812171850549833030u, 909756u},
    {4994232794808898370u, 10011004555432833852u, 7190517356034076323u, 14068012888309641077u, 1829202u},
    {2633990742582596359u, 9797893437624502545u, 10048522742599128635u, 4429256071534734643u, 3493020u},
    {12715024017386471300u, 12008809058899918257u, 9600699514401496701u, 16421508697023246481u, 2628441u},
    {735998261243407880u, 903523252286301752u, 10742593075337910963u, 15973214477243427760u, 1656207u},
    {10836207617869394997u, 296596252193823383u, 11007324790992060250u, 2624625028000706448u, 545380u},
    {15505893142797042808u, 8779792368889427179u, 4815347823889337063u, 4549688912297004711u, 3207430u},
    {5238091032221623893u, 171888965221162742u, 8055906958014867382u, 3589988752752496003u, 2217628u},
    {152980882983212452u, 3907105213112822914u, 5231180284145815751u, 3211442157425510302u, 3201915u},
    {16139832666125577438u, 6247949539435791459u, 7158350206843384061u, 18001405825206269940u, 2642423u},
    {7998576185858717720u, 13333398653531397184u, 13209261640685906824u, 1273723217461664551u, 1657196u},
    {8605786859181763380u, 15678046738726085653u, 10357722977604208060u, 11343612135720384343u, 3829895u},
    {16284231186196467391u, 9873314819558057674u, 16726486748920737517u, 4970565498816891626u, 1799397u},
    {8530259883591083447u, 11717319548974173039u, 15976119599932342108u, 753768961295845604u, 3675085u},
    {7320685413360619121u, 13573334407703095130u, 14693439749157423223u, 5111824935852853348u, 1496845u},
    {12101826080884859921u, 16946837684889339821u, 11833676136728267928u, 9683329522827180133u, 2035546u},
    {300983231174247671u, 10660886826924647048u, 14405476938886057173u, 15385816735874243073u, 264680u},
    {14309991322705782622u, 5869518243972748216u, 18372329055524712759u, 16073725970065175907u, 3236581u},
    {4668057954461062310u, 4857035228302081184u, 6346432662226854382u, 10363940344878251752u, 1458279u},
    {3999242904227891930u, 13782112916275112586u, 1831404121178666351u, 7088544725581943164u, 658916u},
    {14334103766559062851u, 8019926223730980519u, 9122863477861047540u, 7866432612040762152u, 3561238u},
    {17803759193075350540u, 9471069390273251777u, 4032878111530889090u, 9577295666844489420u, 3385335u},
    {11604789474327577394u, 5832668086037340820u, 14101443432199785242u, 18004789333370123255u, 429834u},
    {14582897114415554547u, 5666722205729516517u, 14378037962746503722u, 14347390269344627468u, 2188967u},
    {10789926909104413209u, 2030948933717721618u, 7689490970559887454u, 6093217227568132669u, 833460u},
    {8365663122501930993u, 8694841793750414108u, 8448683115380338586u, 16804794040246100278u, 1713380u},
    {12248681091115985287u, 8813284580975804962u, 14645282560870696141u, 14299009918675537839u, 3029613u},
    {8614475464358026222u, 11365785996633516052u, 8772209830639871103u, 13098311030817349750u, 2226674u},
    {5087471902675585903u, 1201702952998121975u, 17567847743604760995u, 17767243031842166428u, 1066244u},
    {5729958768920385174u, 7172092381512777766u, 18362197719460176730u, 1749051004865641862u, 163778u},
    {10413659382667752063u, 12089377922687422503u, 14945683223232040513u, 13117503287502839359u, 2214274u},
    {14458847979757300580u, 12034980526919930758u, 3648879311074277330u, 3355495484649257487u, 3375607u},
    {15386336680578223109u, 2648585629067022350u, 942414625137438294u, 8709180246329270283u, 2991207u},
    {7601404706456706828u, 471000977337028642u, 1658561425771179010u, 4018345710795705253u, 2219490u},
    {1647851529522134432u, 9988825179794088595u, 9442908455281753462u, 5157031544715386779u, 2601672u},
    {7446683530690442424u, 11462673186071358749u, 5299541705460696001u, 5092023965359723141u, 1167051u},
    {5163969682184496015u, 7706645941570982570u, 5215402891863671161u, 18396214775881614451u, 3798626u},
    {3109388683358185669u, 4979392963195470254u, 1816894851943204407u, 13833072761294189571u, 1168079u},
    {16004655740166580887u, 2322706418882717754u, 11736837487419822937u, 9389034493134579020u, 2339330u},
    {4043281823815836508u, 11914452000132835069u, 9526568268210325598u, 12941462363992086002u, 3077756u},
    {7863509888417716636u, 10300248068417316022u, 13568312574586181603u, 10216895349542625354u, 596504u},
    {8020782275864606132u, 11175101967737055757u, 16966869133401167706u, 18385690046515463071u, 1313436u},
    {10765163550575892899u, 18436842942577042571u, 2799766533797552019u, 14435747443720474025u, 3258592u},
    {13001045846788386902u, 4190295458986461195u, 17339177526216268627u, 15552493145254891038u, 3493737u},
    {3126282385438661704u, 16984601776187022772u, 18246044068929091431u, 5540825234734866068u, 14583u},
    {15304574464511479868u, 15674570471903342284u, 2325806020109330202u, 10448620149909202861u, 840596u},
    {8495654417918446113u, 16247363770367208051u, 2940521632799318583u, 13129988384632888456u, 1218208u},
    {14555412329633563723u, 15555296775464550111u, 1621700940847014780u, 14650163574033904958u, 2966629u},
    {9193507197029966069u, 17890182430089545755u, 8022994845893974201u, 13313321963553548691u, 2077805u},
    {355689150745338865u, 13503808727695867080u, 8283170479275734605u, 11639601390489793734u, 565094u},
    {15255599167881927017u, 7869853511804263369u, 15692380259649499422u, 6279434837334920647u, 2133367u},
    {15221555661253573835u, 17143801221059646397u, 6221934034266937630u, 17405233844484364938u, 340400u},
    {4491498209544816722u, 17306732318725562606u, 15761845161746631035u, 16147180353583782239u, 17183u},
    {180540465456694289u, 18421429753251140833u, 14927104711465059896u, 6341385261888257272u, 3339901u},
    {16164957408282690535u, 8236790449792196019u, 739479957272192735u, 14833417083095138747u, 1546312u},
    {15403602484249187277u, 10020421896060716283u, 5046640672429476882u, 2046137069617505255u, 2279854u},
    {2096584248203035632u, 17783148032865558554u, 13050136537759748766u, 13949171534629651733u, 1078167u},
    {14411690179934616210u, 12322064351387511195u, 14145325017188185792u, 15512271402821396980u, 3388585u},
    {937945137385141929u, 9985872495108249576u, 14464098314233969500u, 7772670937837571635u, 3209615u},
    {4875606833454852570u, 6942083498663469135u, 6411340700181951376u, 491552518480377836u, 3371290u},
    {6318707266174322999u, 11175638783078180209u, 13795996638395566667u, 1863629175268007192u, 3185115u},
    {11276470179747970357u, 7571768255450907532u, 14082300370193899829u, 16776116819913243725u, 3545484u},
    {842213044208027375u, 9138039859758525481u, 15033097893452130965u, 6262355740003351351u, 3597200u},
    {11781625111144951646u, 4048827553853820298u, 1409821041766408699u, 13252896342985116027u, 1774106u},
    {13137848064000355141u, 4152669546924324139u, 14100162174073600528u, 14228072518066332292u, 3149697u},
    {5299879653507065970u, 6890103003000770400u, 12222676943090704867u, 15262254010699597767u, 2679060u},
    {5169921097737960830u, 14736323531655601801u, 958469351587419412u, 5741969878436673266u, 2454351u},
    {17356862200768959654u, 12856685634582159926u, 2858405673486702740u, 8620128481019447374u, 3667851u},
    {16912174319650239628u, 5394938105067714367u, 11506056821949299725u, 14335063536827359461u, 2818910u},
    {17112464214864198673u, 8673136306572864419u, 17952703772815144774u, 10140062890981795168u, 2557244u},
    {11765009370264761528u, 18209215061932912797u, 10966616523380308708u, 5595607576662543271u, 3736117u},
    {6798775043825325679u, 16023598163353377392u, 9545421633093430965u, 4320317247961791309u, 1491893u},
    {17645322775468821166u, 17392743563816219526u, 937839801610212499u, 3918630650724784556u, 3180316u},
    {10173316323324896553u, 13959667507546526004u, 1512175757089923921u, 5318870844012893645u, 124120u},
    {10115843603123352474u, 2614327204894987416u, 10320428777584933955u, 7568336989175732953u, 825503u},
    {2010786462426837739u, 4281459252376218062u, 3014120534086204005u, 17381108013282049021u, 2679574u},
    {6902974954406081104u, 3172317665401055044u, 6344584320005948311u, 481774997413241827u, 2168602u},
    {7722491893084785655u, 968366537241439373u, 8610989189844695008u, 8903087713238645806u, 3903093u},
    {6148542658875615833u, 16603008827941243692u, 3397781320517789268u, 792575306949254308u, 2353706u},
    {1317942467676956837u, 12311484884226682531u, 15590140393220683938u, 13950533862319421568u, 2338952u},
    {16565809622253866932u, 12945407350708651770u, 9053071711156429620u, 15463471187011803269u, 1195805u},
    {9731923589280353082u, 15672435017429943020u, 7046179378429070962u, 12199792116670354621u, 2549391u},
    {3632203098729746862u, 7834549784676486919u, 3213800558664780620u, 7468960161427187992u, 1810278u},
    {2570558936945225682u, 411739821062020883u, 1982974078123933919u, 1186315247044073917u, 2802058u},
    {12031282055894797451u, 3886917852954913058u, 15238848732680288501u, 15327898784032728117u, 1009024u},
    {17317112148929367217u, 14433738228303937460u, 11852234170554383153u, 7944948566992202450u, 3820597u},
    {487894630908722812u, 13562075495514357406u, 14160407018604716133u, 13761420450219038898u, 2966203u},
    {16872272224462407222u, 14257430751376493154u, 6476152800225660452u, 9494261620341649559u, 414278u},
    {15773083666756436034u, 467930528394804809u, 17819975496571668755u, 12185375482145451049u, 505170u},
    {6095773689468025179u, 15121560901250201912u, 6185299725001349383u, 8944460414592155400u, 3315189u},
    {17042846948230125217u, 3008312876663633855u, 5616126439543289451u, 13103578972848393925u, 249930u},
    {14210241806800914877u, 2228741727866189300u, 1545483073740492010u, 10164731167197760177u, 524141u},
    {6135156656399069895u, 591169044558408642u, 5373942987329251502u, 8080119237298198197u, 3823991u},
    {17903831351076984071u, 10933915556970939436u, 5383085566455523343u, 8140990723645216731u, 3310122u},
    {6930725329746410957u, 4574207244471169627u, 1097099504153830815u, 14976982947378829084u, 2085910u},
    {15397466497640229043u, 15716912230396025119u, 3507826287112817598u, 3353127588652459494u, 3073709u},
    {15421072509350191145u, 16994435728532590031u, 15504917062899489282u, 14684391516332556308u, 1374375u},
    {7055403531597177633u, 5012404841402456959u, 6175901826003754808u, 9609012765615111569u, 3131380u},
    {9275717096742803849u, 14703707712453969265u, 6537925459461018656u, 1931261220052671717u, 368403u},
    {16342568277129741137u, 14404842871822043130u, 18385149756149318302u, 5771403360822482919u, 1044137u},
    {4359518637453976989u, 8544511172100256478u, 16937031400551571172u, 10539669663325772886u, 1800929u},
    {16353644232310976030u, 10165955878871234100u, 7526717087879908545u, 10769802798548853796u, 2949400u},
    {18445677794468759142u, 11949234155583803131u, 1569526395856059024u, 12232140230150622934u, 836230u},
    {11225579793939736891u, 10113819406778574009u, 9195159846292387847u, 10968180026793944640u, 2007886u},
    {17610709180188508797u, 11925231657971325412u, 10145495562652063383u, 3423745889921977395u, 2624047u},
    {10821774533245954089u, 2882601411657978401u, 13120935663122334980u, 16333421379441844753u, 1629389u},
    {6852909964845443314u, 17168130368576792793u, 735792248411504336u, 2552072729540416672u, 3877089u},
    {3501818206770564933u, 9743162047348652487u, 5639953576904958538u, 1368556363768770069u, 2189700u},
    {5969948546550451310u, 5931425903548018240u, 17382833077072462631u, 1913890281852884504u, 3807999u},
    {3040260728233046853u, 11128139283074691983u, 12858503822111550580u, 430533155089471860u, 1481890u},
    {9896878585566307878u, 15414250253486363557u, 9845139850136141147u, 6800749885571148586u, 1119583u},
    {4415240987532902846u, 14666987246721062896u, 9187303386267008403u, 15080689821797964470u, 3763719u},
    {13515573143700677978u, 9574907724177958279u, 12849713682110481256u, 4969344770818147509u, 616708u},
    {7400786641350225072u, 7349416162959837366u, 18006745650745046316u, 14278779879123285368u, 87337u},
    {14389526274660303988u, 2260347368932262478u, 4293884791662502451u, 7711773659624234602u, 1650739u},
    {16873309683250744291u, 16332475429242346406u, 2753708303139704121u, 17468388524755825403u, 1374827u},
    {11832510931871977926u, 1911515850366379750u, 8769505304706162141u, 8311984413644727046u, 3831541u},
    {18026920503233122303u, 14106265279852082141u, 13891270864160972280u, 10374915411970604430u, 3568673u},
    {16007046139521416212u, 8218929274847197830u, 12262104165114732962u, 13108254928753629114u, 3615736u},
    {16846043773813842952u, 11716501194412445517u, 1391963465480675628u, 4101923835862317624u, 3791291u},
    {17176679212486546595u, 5061522944676100700u, 9557145211907151055u, 11382979242842568147u, 2128432u},
    {844984193789965352u, 864111887305999623u, 3831651785790366107u, 12072880856099238323u, 2839848u},
    {13668790744942240519u, 203739917279888415u, 15436838487222318217u, 8987527622040180842u, 2764689u},
    {18050736450706925938u, 6599065784768617454u, 10844255467394248783u, 13958115168734019256u, 2250061u},
    {6592574411822819671u, 5553674452939933686u, 2816224436036340910u, 2851752480854539660u, 2167229u},
    {2301681245875798752u, 16067241265608338064u, 12797091571257534753u, 8182486447849730726u, 853965u},
    {14928555368405596574u, 13866620616480218683u, 1761445773066985471u, 15436078006101970129u, 3284311u},
    {523192085923583711u, 4020112803354942556u, 5155250786019331290u, 11878030282131728601u, 2264122u},
    {3541360991525388249u, 3513775254319137786u, 10249928793366176935u, 10922462390690804035u, 389006u},
    {10181884821843172856u, 11167663126935418829u, 9716596127973394764u, 13265773208026340072u, 1284127u},
    {13676860208687209095u, 12892614428232839910u, 7643211110283536442u, 12994054902219942113u, 976016u},
    {15697792687328368124u, 12204003339750829089u, 17524111157913039507u, 1603271399192315195u, 2705938u},
    {2456604003028033778u, 16186471083156069763u, 16104210563397592744u, 16334931999940310411u, 1249085u},
    {11771100618075992800u, 8684444521969718753u, 4069015493066817998u, 7444973753562818903u, 485174u},
    {2329089478739274832u, 7946277943407164141u, 10303614978746957056u, 3251541619760948831u, 1507083u},
    {14340811351522247619u, 16640084724471975041u, 17322322042683693853u, 6945329805291461887u, 2524010u},
    {3556567707947378500u, 74004756748713072u, 12281142112320312010u, 5811167296489048330u, 3200890u},
    {12834638591394340512u, 9985390985946378014u, 2973367417190211913u, 5391307963255930727u, 1105128u},
    {14564047974296470212u, 1974965855231037039u, 11330314414572869465u, 20386018775998452u, 3395996u},
    {3694384919565289522u, 4329415289198767581u, 4163946436239695197u, 5827252592141962241u, 1446919u},
    {14723384133616356448u, 9295880971709370484u, 15802096084384686195u, 10042696521587623446u, 3017097u},
    {14958315217893509902u, 10565154323403426159u, 11798578071290199311u, 1857095477195451788u, 1146143u},
    {15440039008445770257u, 9195755924929269551u, 15002162830484006264u, 11406242466442583051u, 1468831u},
    {6009377514715534445u, 6205385398321556236u, 15721494928560724222u, 9322524791843477084u, 3187678u},
    {17959174128823015756u, 6078776499422673528u, 16964819960542177961u, 15623242601770353283u, 2577433u},
    {12076982274859293644u, 17402764194187118365u, 9604020820694777176u, 7829765418637593120u, 303166u},
    {6737603869901446634u, 17257460217013419976u, 10382000530960191570u, 8076042965691544480u, 3054363u},
    {17683514176468095299u, 17108502500218494337u, 16492220939075135091u, 6253296147907053188u, 1843661u},
    {14003391567060793336u, 16964867609869127924u, 10126512911066585514u, 9689727149961318997u, 206678u},
    {6496346856634504469u, 5289379457012680785u, 12363204253917319042u, 4183153000061213580u, 1445685u},
    {15609245560029181942u, 5648977470404987427u, 3489949484910114127u, 5647160520347732801u, 587620u},
    {14487748794041072691u, 3904166006622926907u, 1260405539172705453u, 13773840142643989503u, 639851u},
    {13843429552718699302u, 10730938785670489234u, 17617354831136817292u, 2101473408516057416u, 1940402u},
    {2272915474205087513u, 12065035049364279572u, 16433227520893003297u, 8106244633443516401u, 3200298u},
    {10479418000443275252u, 9800223890644341061u, 1127058613999667420u, 14470553893857436364u, 771738u},
    {9168234969105548917u, 12279299736233852116u, 14802865967727559887u, 1095099978417429395u, 2095324u},
    {14774494145513608005u, 7683879671828111592u, 17481480923985792328u, 10126715071984512410u, 3865414u},
    {14175613447430185988u, 14579009200926693423u, 13553218275948364386u, 8502042815361217516u, 2584906u},
    {1122526283616631058u, 10248150997829831592u, 10896964195902666264u, 2065295741000621285u, 2976654u},
    {6716185768678120178u, 7042248360015298670u, 12112024237795080512u, 16339925829170993108u, 1917238u},
    {984180989819930897u, 1786042692753514724u, 9078559869112863132u, 10339602762478011430u, 2510201u},
    {7045368875765813665u, 16618610273239724143u, 12065023721411039397u, 4730048658225488392u, 2888427u},
    {9791772288466375973u, 1016426332638313392u, 4999739560246453006u, 10213402837722480293u, 1201474u},
    {8812312180405633933u, 14086720307974854774u, 9975303333535172528u, 9821996082760818243u, 3727375u},
    {14170416735408023011u, 9479988692247589609u, 13198760557737739683u, 10012705919747794390u, 3665861u},
    {2168278882871383510u, 263374117415395690u, 6352611633788447857u, 3094042159282472202u, 3058498u},
    {12595785904988523459u, 7275015435731389162u, 8871130911717581342u, 16845838743787203763u, 3751950u},
    {2988261171096016209u, 15640100562622973023u, 17946006532170306021u, 7923489028407338319u, 1732545u},
    {5663809775590520118u, 10929973410577598855u, 9442538540563544397u, 824593356551881439u, 3799157u},
    {15876896120470427723u, 6953360234067501657u, 9973585466489363233u, 1150945988268354555u, 2918204u},
    {17442817840753412421u, 7273904210558375015u, 11665208493190394183u, 1134695274062740536u, 2566736u},
    {14507121197565973269u, 16558313535501059765u, 13639262702035540537u, 6100185822417418857u, 737673u},
    {1702161462652230678u, 7713420033812346836u, 8977078963488099903u, 9597267678185686856u, 2561262u},
    {6129800890003605015u, 794624333197806138u, 14329177125810157005u, 1272226052861760063u, 1883451u},
    {6966266106376874478u, 13855044531431586059u, 10375682581180334575u, 7096387755561536109u, 3730041u},
    {17562825892425910952u, 18284162140697710748u, 3335768367774315122u, 5689299453766210413u, 395862u},
    {2272188417953562665u, 4388251730686638619u, 5313094042609164405u, 8077752902939735096u, 1583778u},
    {14424025019810219967u, 18285156300056026450u, 3302342475068539328u, 8243781275837109173u, 1894258u},
    {17498905256890375581u, 4341119229668148598u, 12214144519948799331u, 2989304256334403559u, 1467182u},
    {16411486594037649268u, 12061176113241448493u, 12792257556030707028u, 4206405188052677871u, 140421u},
    {16540552244681223498u, 10091467339522449513u, 2733949391189827u, 1011396630986970661u, 3807148u},
    {12029729997711916984u, 10267743520030649603u, 50208882978134744u, 15706727392048493915u, 433830u},
    {1486029629832899306u, 16759012066428266815u, 15238176346926036592u, 11393102624680838694u, 1631611u},
    {14695292580982328863u, 13853536396940739520u, 16649515998606438927u, 13504868007030475971u, 781850u},
    {10358896948329833951u, 3791390000258455119u, 17735540405688061940u, 2824668767838087323u, 3627150u},
    {14780432430322758194u, 4693890395408402368u, 18115841286502781667u, 5110940693246579887u, 3773596u},
    {8528035463006412351u, 8748273104217504539u, 7129869941064507486u, 12895862303511687370u, 3757008u},
    {16671942307409261179u, 16983567785399436775u, 11241672703707089175u, 5761854506951048622u, 16638u},
    {659855824154715991u, 15568447976559735730u, 8685384378635475875u, 2162034743827590966u, 1317551u},
    {1087323444494553886u, 13278726165872747105u, 4958547202586969138u, 1681629191135437365u, 727704u},
    {15102318697297938774u, 6251195788382759745u, 12628770659984200343u, 8083874303378972758u, 650646u},
    {2055160940386104477u, 10220932246772193451u, 5528797161465089786u, 5344264267135124392u, 3408996u},
    {4748833781088044251u, 17531147947718838258u, 13943191546405472957u, 13681770155272943737u, 505368u},
    {17018294072266660864u, 10293241834614120418u, 17598533741521661886u, 13844380463122976315u, 3675156u},
    {1983110044432250673u, 9249641354407112614u, 33728247377089096u, 2229522497145176644u, 511919u},
    {13309931605346444010u, 14260990876436564588u, 1824156979415211812u, 8512239337484488265u, 451829u},
    {392978454796771963u, 18316714390947513465u, 8883839957539405546u, 10816973888129509850u, 1156625u},
    {12993026926086895822u, 8672167588729609848u, 4932029417883656878u, 10469687111680778918u, 3684276u},
    {6444049081796576237u, 5894734959579534009u, 12366124165395518960u, 2229690728076435523u, 609718u},
    {6531036264900422049u, 11298695978728879961u, 8644878668634738503u, 3397954233915437760u, 2894557u},
    {5564210236962627083u, 8072362640803585174u, 9451961736877821805u, 7259154559376512332u, 2243976u},
    {18066039105169387852u, 10377019853188399590u, 3201940614349996970u, 1698718721111043552u, 2953229u},
    {1728017326595319505u, 8632493799375706704u, 9599899896539551485u, 6611718518704218082u, 3029094u},
    {7260639944879622740u, 6477995901131871923u, 4555128052442877283u, 16845296339242136767u, 2905543u},
    {106927131132963646u, 3306456450650015818u, 17951343023340874746u, 6106435724147401234u, 1468106u},
    {13003793054384815825u, 17963277530552315086u, 2437931491507156430u, 9466626600730072775u, 2245222u},
    {11173179579900447250u, 1248366120105630296u, 11592884483738899759u, 18127873148609200843u, 3691085u},
    {14688780908458203415u, 2585897918767512258u, 17261433842791202114u, 644549270780604856u, 768391u},
    {13391029334171269355u, 10926683623632034923u, 15797325160722157879u, 18388860792441714706u, 2659515u},
    {12563980796395890923u, 1214286731070293899u, 11210841709773461789u, 7975394755126125410u, 204476u},
    {5222538505564190729u, 1167704818755524910u, 7422206610882259621u, 15928500206798684445u, 2965726u},
    {13625260694503721316u, 3590286055544747886u, 8754781597870371401u, 14177996435877121996u, 2195308u},
    {13244025237335997764u, 5835911294465876730u, 3987074181544999740u, 12074114503350928916u, 2615276u},
    {17781140587612084528u, 18035932358905828286u, 12230466771639015533u, 6605484396579671500u, 986878u},
    {545328237004852613u, 3660459405330750227u, 8473813469861066310u, 17312027261606163371u, 635648u},
    {17293858928180602159u, 7188831457606108255u, 12391979217664734688u, 15576165965481426766u, 3156456u},
    {18292749472437718417u, 2310426663369960758u, 17285699779102754741u, 6471352220963677225u, 1790921u},
    {16596148833186007373u, 7985435338740499537u, 15741631654929539549u, 969785390307647372u, 1526264u},
    {4404250497900033238u, 7009266261878321060u, 7291813406851304018u, 244327384480485433u, 3202057u},
    {16407671757375063226u, 3155845703348475330u, 3677534512557996079u, 16848486937069966658u, 1416496u},
    {9543523745270462593u, 4843996624155252963u, 1767644386465028886u, 7880407506176065246u, 1497883u},
    {17784323034645923481u, 3064263741176270240u, 8841416965565659044u, 3918741150281876334u, 3346074u},
    {11243990621541380170u, 4555211904805800211u, 9146484503763957318u, 5970446885758525516u, 3598808u},
    {12792178086487083590u, 17571180844680953500u, 14583981928082736286u, 5326590660885604737u, 3038470u},
    {17791291941104464185u, 15145765610675585405u, 3399223179347815366u, 17638102829046651306u, 1383239u},
    {18093093093808227911u, 17613169776853942656u, 9489291632850881239u, 11410616131456490643u, 2652251u},
    {7061597821801941369u, 16284744789452350529u, 8108787653629104003u, 3219459544495685547u, 12521u},
    {6051761077562241651u, 5652793171965255507u, 14600035003161000363u, 230974902006461u, 0u},
    {8018971781462254949u, 3799869517586538406u, 16639082353499510798u, 230974u, 0u},
    {7189177965605301193u, 8752330409342263856u, 4260734904763343u, 0u, 0u},
    {8586519307974351828u, 16689937844347222740u, 4260734u, 0u, 0u},
    {779723294015835795u, 78596686354090637u, 0u, 0u, 0u},
    {6531819360415513379u, 78596686u, 0u, 0u, 0u},
    {1449852958215529844u, 0u, 0u, 0u, 0u},
    {1449852959u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 2796066u},
    {6180897705302832356u, 17209559613061430484u, 2743817708075818479u, 14102809151311148291u, 1975255u},
    {14572055736138614790u, 5350072584120554554u, 12698929934268261482u, 9403924262498755991u, 2585926u},
    {260911832661759910u, 11982289111281272941u, 8686800665762480304u, 4299099972757223932u, 1831838u},
    {9348663152967806233u, 5978415333859593792u, 6832196980787072455u, 3492555964890136858u, 354713u},
    {2033848876248514150u, 7975027578721636837u, 1337445509893469466u, 15931271585805247557u, 2272583u},
    {14623421225820388345u, 9927713485365156886u, 13750049649203572389u, 6599162830369976835u, 1041427u},
    {13216204154070094729u, 9451659008643662974u, 10713368456253605266u, 10611677267515020539u, 481305u},
    {5987386909073757476u, 18245238676195314755u, 4714239208632274641u, 801512055185281339u, 1694731u},
    {13839765135401583162u, 16664914070740892904u, 5626563808783318609u, 4282660318070042141u, 2326761u},
    {18061063251805012189u, 10579991379072337177u, 1801101672415658891u, 15247073510973143324u, 993242u},
    {6838643555366030245u, 8161777181450131449u, 8104067806661982496u, 11259306766141090949u, 1709416u},
    {9352231128784274857u, 8894573146576081430u, 485282286033680091u, 3418240090509424045u, 3812503u},
    {7794795200203031576u, 16109932292057861667u, 3211188788290951434u, 502673834767057593u, 2579761u},
    {11207545803560538070u, 17028442891921304010u, 6520949286860152192u, 13378243088457679021u, 59334u},
    {12028792030782994633u, 16206026057097935115u, 18322464030421062331u, 6630393183980482682u, 954031u},
    {10890972083160544725u, 8075165148857569502u, 4025942477000168178u, 2755787345767039949u, 1244325u},
    {2213906181635240559u, 1285054839505718842u, 10728979593997685161u, 8165461873861162751u, 1554017u},
    {3288458751403202859u, 4998321087080936228u, 2486699012465250427u, 12062284766384621082u, 124726u},
    {8678421056835829895u, 12692835575002668994u, 16961380847022744078u, 15710856300931912311u, 1329542u},
    {17421243278002833688u, 12151272583746588534u, 11188912904112222287u, 2474483934009654069u, 2638936u},
    {10425868187456780502u, 4408746149453360742u, 5773363189064013654u, 5308884144262122051u, 830620u},
    {11902159928088760110u, 13648391582592787429u, 468620557266302500u, 8734291118460669028u, 3388832u},
    {17579556540834337125u, 1654878453789119486u, 12592144848050108194u, 10871152031036278805u, 2181737u},
    {9035794898474779024u, 2246557868640304668u, 928162642715867684u, 18126702058466206823u, 704848u},
    {5614563708022836247u, 12434624412833824902u, 9290540156283433006u, 7290819166624289624u, 3500348u},
    {8007417091025423317u, 5132844883278492318u, 3767784232259910903u, 13323167333994480472u, 1511152u},
    {2004515268309624781u, 9705034367753696361u, 6236882987038514718u, 14079106684919589190u, 775842u},
    {5098674917336238771u, 10544005998729043019u, 15946285375104422709u, 15290521708935464082u, 1648833u},
    {2174216696249528060u, 11014736637222057450u, 1016935997058001015u, 14225761641133611842u, 463764u},
    {12272806732948316192u, 5229985307023550525u, 11607696092557704538u, 2170282771182199557u, 3410389u},
    {10669328734868276315u, 10344104605472283429u, 3843161117296873998u, 5683402910203456023u, 909212u},
    {12941527980341050430u, 5087424570059921904u, 873317106528324041u, 14500348408379663655u, 1302843u},
    {3798501311420582104u, 7157519863408638459u, 13571416138389611705u, 3410740145672185373u, 2593604u},
    {3380439845196256295u, 6612270413852216467u, 10729538318527663337u, 12153519350999182781u, 1255565u},
    {9424892296830090859u, 16276301519221473567u, 3208365118526356598u, 1248140197021201396u, 16750u},
    {5645377205052890301u, 15891879886338415597u, 198660295048796468u, 4972282972828402416u, 1128540u},
    {7301911605629600020u, 6944368392077422486u, 3857639494142690985u, 1822257744477425550u, 3178218u},
    {8802866965334688043u, 2622116003523418832u, 3603125748426491432u, 3733565071813039504u, 1942796u},
    {18056189321835934776u, 9323000543035755664u, 15760858295213367436u, 4719581876798307533u, 3764666u},
    {15479825557904375554u, 16006322114559347224u, 11848487415994093421u, 16858865245781786807u, 2336662u},
    {2665918008776084140u, 14492193906357591036u, 1474496208747939447u, 12581125185359088418u, 3769290u},
    {3410209660818427309u, 14493776082082664896u, 3131538792082659675u, 3023892496105763237u, 1409248u},
    {10582066532292204725u, 4931658736171431809u, 5561841007541278649u, 7159697849971145198u, 3635144u},
    {3052639254435130970u, 7707571371296657981u, 4994232794808898369u, 10011004555432833852u, 3801117u},
    {7509404417300714438u, 10699103324764510360u, 2633990742582596358u, 9797893437624502545u, 2561343u},
    {14644127387924033604u, 11414927995604488525u, 12715024017386471299u, 12008809058899918257u, 2105093u},
    {12807375735140251150u, 8619610465225327579u, 735998261243407879u, 903523252286301752u, 453515u},
    {18303051236646639060u, 8432134948030302863u, 10836207617869394996u, 296596252193823383u, 3297248u},
    {4113665544148167463u, 3366623256965425550u, 15505893142797042807u, 8779792368889427179u, 1505619u},
    {2785032423923145885u, 13558086376041302744u, 5238091032221623892u, 171888965221162742u, 867098u},
    {15900731395416963441u, 15196236894572340250u, 152980882983212451u, 3907105213112822914u, 2764523u},
    {14381127037861631014u, 3186065628845598793u, 16139832666125577437u, 6247949539435791459u, 148739u},
    {15614789478590898497u, 1877494211976922244u, 7998576185858717719u, 13333398653531397184u, 2252366u},
    {5343246789156421897u, 16013101267114185080u, 8605786859181763379u, 15678046738726085653u, 77218u},
    {1879716585626383564u, 6909007293528171890u, 16284231186196467390u, 9873314819558057674u, 2384665u},
    {10415535560263758731u, 10626999815982018883u, 8530259883591083446u, 11717319548974173039u, 1436932u},
    {12045308377637612458u, 5553529963621538350u, 7320685413360619120u, 13573334407703095130u, 721161u},
    {15798489034376619045u, 3609467334906553623u, 12101826080884859920u, 16946837684889339821u, 3709082u},
    {123504490700092561u, 6128083057315790758u, 300983231174247670u, 10660886826924647048u, 1780971u},
    {11909391041463290558u, 11755759774420196852u, 14309991322705782621u, 5869518243972748216u, 1581657u},
    {10953188837177837616u, 6577412934339940745u, 4668057954461062309u, 4857035228302081184u, 1036088u},
    {6563662213995992645u, 7424441521527081126u, 3999242904227891929u, 13782112916275112586u, 1167321u},
    {16706205638375533451u, 10536047536099473734u, 14334103766559062850u, 8019926223730980519u, 1708950u},
    {7098015640819788342u, 881067309829594717u, 17803759193075350539u, 9471069390273251777u, 3689570u},
    {13889803811380044570u, 17751045247248447603u, 11604789474327577393u, 5832668086037340820u, 2506126u},
    {3377589759541194374u, 3776453786159945788u, 14582897114415554546u, 5666722205729516517u, 722962u},
    {430340923033179212u, 11847397219881676752u, 10789926909104413208u, 2030948933717721618u, 2598318u},
    {18357934364619330454u, 11960479716727691510u, 8365663122501930992u, 8694841793750414108u, 1206614u},
    {8760173831906517416u, 3694873700339442345u, 12248681091115985286u, 8813284580975804962u, 2859243u},
    {15482479979740334648u, 590142447823350530u, 8614475464358026221u, 11365785996633516052u, 2644447u},
    {13555661655882390715u, 5474091319180771864u, 5087471902675585902u, 1201702952998121975u, 2081157u},
    {2345240988466174110u, 12010344764466996533u, 5729958768920385173u, 7172092381512777766u, 3022740u},
    {850919474204475397u, 17175107987777625300u, 10413659382667752062u, 12089377922687422503u, 73851u},
    {3426194131678179575u, 13473575048399560820u, 14458847979757300579u, 12034980526919930758u, 2955114u},
    {10906826995749067964u, 2451415337524251263u, 15386336680578223108u, 2648585629067022350u, 2095514u},
    {10126966160429826689u, 3502097615201554783u, 7601404706456706827u, 471000977337028642u, 2432798u},
    {489262542025362756u, 5899751823161470454u, 1647851529522134431u, 9988825179794088595u, 299008u},
    {15434620207564833179u, 13329425408977163167u, 7446683530690442423u, 11462673186071358749u, 3715613u},
    {81950174044164881u, 15343878786291779169u, 5163969682184496014u, 7706645941570982570u, 402183u},
    {2239650207047814742u, 439725789833944267u, 3109388683358185668u, 4979392963195470254u, 914167u},
    {6862395604107413766u, 9701387755351854142u, 16004655740166580886u, 2322706418882717754u, 1352487u},
    {9009908055290147410u, 18385176636218895993u, 4043281823815836507u, 11914452000132835069u, 3690066u},
    {14406591783487127803u, 12190606600274044546u, 7863509888417716635u, 10300248068417316022u, 334741u},
    {7792728800986255287u, 1503429632021766884u, 8020782275864606131u, 11175101967737055757u, 3369508u},
    {3572247784350086468u, 17943942850649590707u, 10765163550575892898u, 18436842942577042571u, 593871u},
    {16940893322290964738u, 15409004559689926339u, 13001045846788386901u, 4190295458986461195u, 2768357u},
    {4489755768712439926u, 7076647207888763224u, 3126282385438661703u, 16984601776187022772u, 2063917u},
    {15970728674314022102u, 4126433483725869646u, 15304574464511479867u, 15674570471903342284u, 1865104u},
    {5636797538696323998u, 3398669360739686014u, 8495654417918446112u, 16247363770367208051u, 3410577u},
    {2234569481222672506u, 4365913409704158373u, 14555412329633563722u, 15555296775464550111u, 1078732u},
    {14938774956789040270u, 16361282291168530978u, 9193507197029966068u, 17890182430089545755u, 1574187u},
    {13327434995883888968u, 12607287427217996624u, 355689150745338864u, 13503808727695867080u, 844363u},
    {13991386403214799905u, 3876817036838251746u, 15255599167881927016u, 7869853511804263369u, 3586076u},
    {14943725133871293076u, 13111354952937349850u, 15221555661253573834u, 17143801221059646397u, 699838u},
    {10108824511093250358u, 3734460598739939016u, 4491498209544816721u, 17306732318725562606u, 2533957u},
    {13247233380868396703u, 17297501019626159586u, 180540465456694288u, 18421429753251140833u, 1204804u},
    {17518212946226701666u, 10892157494650174362u, 16164957408282690534u, 8236790449792196019u, 239409u},
    {14187195976310346279u, 9027407526191945718u, 15403602484249187276u, 10020421896060716283u, 3088886u},
    {2434889767219207269u, 10714396912853304672u, 2096584248203035631u, 17783148032865558554u, 11696u},
    {11425186627548034472u, 17294713022600283586u, 14411690179934616209u, 12322064351387511195u, 2272732u},
    {17089600927390629815u, 5972596811816056015u, 937945137385141928u, 9985872495108249576u, 1331100u},
    {13355810167150520518u, 4359672952544926177u, 4875606833454852569u, 6942083498663469135u, 363842u},
    {6846410810507429599u, 17576033426534700509u, 6318707266174322998u, 11175638783078180209u, 310129u},
    {1987879532174345384u, 8487873915581007712u, 11276470179747970356u, 7571768255450907532u, 3186633u},
    {245503439220254855u, 13315039109456848434u, 842213044208027374u, 9138039859758525481u, 737381u},
    {3258811585081391894u, 10337396860903302375u, 11781625111144951645u, 4048827553853820298u, 2460417u},
    {4793980712672573126u, 16424803199189231428u, 13137848064000355140u, 4152669546924324139u, 2419482u},
    {5864476798290729504u, 6006251696470264478u, 5299879653507065969u, 6890103003000770400u, 1982699u},
    {18131472363030248807u, 2907799252315316065u, 5169921097737960829u, 14736323531655601801u, 1649824u},
    {7074848210342186578u, 14521368968538142021u, 17356862200768959653u, 12856685634582159926u, 3397680u},
    {2156144091015294778u, 13512648625448104120u, 16912174319650239627u, 5394938105067714367u, 1421661u},
    {12481435239439737958u, 8268847399648892161u, 17112464214864198672u, 8673136306572864419u, 2748526u},
    {16862564877194831137u, 5070339082943130469u, 11765009370264761527u, 18209215061932912797u, 1453496u},
    {13674478224199139184u, 4457501772402957124u, 6798775043825325678u, 16023598163353377392u, 1456267u},
    {14231197396934000573u, 6810277854273117071u, 17645322775468821165u, 17392743563816219526u, 2848841u},
    {13855591195682039432u, 8216136965454028916u, 10173316323324896552u, 13959667507546526004u, 1097961u},
    {866329729693305900u, 16003661576448220666u, 10115843603123352473u, 2614327204894987416u, 1629621u},
    {16419394253867615257u, 17837169679356794056u, 2010786462426837738u, 4281459252376218062u, 96685u},
    {3437489826512749662u, 14977820771297347780u, 6902974954406081103u, 3172317665401055044u, 1714005u},
    {13313988673011931029u, 4756926233061887871u, 7722491893084785654u, 968366537241439373u, 1613412u},
    {12171585567092644307u, 17424984347566463455u, 6148542658875615832u, 16603008827941243692u, 3344432u},
    {5039255566765161021u, 10334513454447086073u, 1317942467676956836u, 12311484884226682531u, 2553188u},
    {9118606212344359780u, 2543781299462001851u, 16565809622253866931u, 12945407350708651770u, 1948154u},
    {1237471261296841307u, 1097202655507386732u, 9731923589280353081u, 15672435017429943020u, 2836794u},
    {10128151114259533836u, 10300393768431504909u, 3632203098729746861u, 7834549784676486919u, 2789210u},
    {11982608521432987753u, 7088119454280521287u, 2570558936945225681u, 411739821062020883u, 3678989u},
    {2127824101018773974u, 3687884021223368723u, 12031282055894797450u, 3886917852954913058u, 1204517u},
    {16105697355573646678u, 1780958065756161231u, 17317112148929367216u, 14433738228303937460u, 826585u},
    {4575976956482406826u, 16632697461387921142u, 487894630908722811u, 13562075495514357406u, 3365619u},
    {8396948277728158376u, 11251078209951011206u, 16872272224462407221u, 14257430751376493154u, 1929064u},
    {8397177611471454055u, 6644540635519488239u, 15773083666756436033u, 467930528394804809u, 3335209u},
    {264060261425150310u, 13814982119863148842u, 6095773689468025178u, 15121560901250201912u, 2924717u},
    {14884507972614354891u, 10309385775675222610u, 17042846948230125216u, 3008312876663633855u, 3632831u},
    {1647351851401769054u, 16041230217521986349u, 14210241806800914876u, 2228741727866189300u, 797338u},
    {15390443484846601011u, 10398942543663529883u, 6135156656399069894u, 591169044558408642u, 2885000u},
    {8613547393358696214u, 14187305395276921121u, 17903831351076984070u, 10933915556970939436u, 1874521u},
    {9543974114732897848u, 8035866996474213181u, 6930725329746410956u, 4574207244471169627u, 453019u},
    {12588021511762897677u, 7009095943140720157u, 15397466497640229042u, 15716912230396025119u, 3301456u},
    {10866826955934255037u, 2286497583671297361u, 15421072509350191144u, 16994435728532590031u, 2191760u},
    {17633577682244909985u, 12037124010331671395u, 7055403531597177632u, 5012404841402456959u, 214592u},
    {14728349826592751085u, 4774742851864086817u, 9275717096742803848u, 14703707712453969265u, 3544346u},
    {5041329905693013920u, 9944895480571400037u, 16342568277129741136u, 14404842871822043130u, 2261378u},
    {14346102618304590894u, 17134914651751131379u, 4359518637453976988u, 8544511172100256478u, 316322u},
    {6261645224331850080u, 11391422828700185815u, 16353644232310976029u, 10165955878871234100u, 3238031u},
    {16959863735224836196u, 7182512182666485071u, 18445677794468759141u, 11949234155583803131u, 1396248u},
    {9641926297217123761u, 3775788881148019936u, 11225579793939736890u, 10113819406778574009u, 1936853u},
    {9705525074101882523u, 15946719608998823726u, 17610709180188508796u, 11925231657971325412u, 16135u},
    {12889383774694096810u, 494689081889511563u, 10821774533245954088u, 2882601411657978401u, 998712u},
    {7081143894385014322u, 17860963584072921375u, 6852909964845443313u, 17168130368576792793u, 834122u},
    {6182225269214728906u, 5383653369725132720u, 3501818206770564932u, 9743162047348652487u, 1230742u},
    {11171398687512515398u, 8257025998494444950u, 5969948546550451309u, 5931425903548018240u, 1695139u},
    {10066024445508079305u, 9947213667934682189u, 3040260728233046852u, 11128139283074691983u, 3576930u},
    {11068812898061273974u, 1406591177813914594u, 9896878585566307877u, 15414250253486363557u, 2130221u},
    {8428923058741623211u, 10610157029249846335u, 4415240987532902845u, 14666987246721062896u, 3431787u},
    {3729112311101472439u, 13194857411794037175u, 13515573143700677977u, 9574907724177958279u, 3881398u},
    {10576456195208761573u, 10230607238941122407u, 7400786641350225071u, 7349416162959837366u, 1439926u},
    {9356884692649562205u, 2613918089275860417u, 14389526274660303987u, 2260347368932262478u, 2572767u},
    {9987152271906671665u, 10042171118209581548u, 16873309683250744290u, 16332475429242346406u, 2060981u},
    {3954839899461112575u, 8755465255272451658u, 11832510931871977925u, 1911515850366379750u, 2983423u},
    {15433790624055927671u, 5180727738827503623u, 18026920503233122302u, 14106265279852082141u, 236548u},
    {1161664520415068906u, 4204124508593804200u, 16007046139521416211u, 8218929274847197830u, 2340302u},
    {15150795099037765991u, 12479392135454346525u, 16846043773813842951u, 11716501194412445517u, 948208u},
    {847415048357882462u, 2977659993181158223u, 17176679212486546594u, 5061522944676100700u, 3874849u},
    {11498335769185561304u, 2625855984683934676u, 844984193789965351u, 864111887305999623u, 3232263u},
    {13780393501901302660u, 4619268499864509978u, 13668790744942240518u, 203739917279888415u, 2267323u},
    {14013377468254302369u, 11219705359122822567u, 18050736450706925937u, 6599065784768617454u, 284045u},
    {14266418632729804928u, 16628838135265287291u, 6592574411822819670u, 5553674452939933686u, 3819394u},
    {11137883082990346983u, 16283566539583798837u, 2301681245875798751u, 16067241265608338064u, 1711009u},
    {7525601994848248560u, 18011941032073306879u, 14928555368405596573u, 13866620616480218683u, 3087001u},
    {16598678996282753971u, 9122316308272126004u, 523192085923583710u, 4020112803354942556u, 2982138u},
    {3203729955671864057u, 12830211046341005492u, 3541360991525388248u, 3513775254319137786u, 3837731u},
    {3603933973417427404u, 4198419196555706175u, 10181884821843172855u, 11167663126935418829u, 3597528u},
    {1732443811287885791u, 15123217939107343762u, 13676860208687209094u, 12892614428232839910u, 1424096u},
    {4391997141051646278u, 17683923813252610162u, 15697792687328368123u, 12204003339750829089u, 2470355u},
    {6330712166926210525u, 14379473639526752770u, 2456604003028033777u, 16186471083156069763u, 2034680u},
    {16062034045681272752u, 1083098102356880011u, 11771100618075992799u, 8684444521969718753u, 1081090u},
    {7213861285192233102u, 1025909898911559744u, 2329089478739274831u, 7946277943407164141u, 3623300u},
    {1483353168472632000u, 9806316580918345144u, 14340811351522247618u, 16640084724471975041u, 105555u},
    {12422089259176724204u, 2503259225546622763u, 3556567707947378499u, 74004756748713072u, 2246630u},
    {6467805886601662080u, 160415305491711142u, 12834638591394340511u, 9985390985946378014u, 1594363u},
    {8702446136390264498u, 9159429405502960967u, 14564047974296470211u, 1974965855231037039u, 323073u},
    {2192213564732539202u, 1005338762079676809u, 3694384919565289521u, 4329415289198767581u, 24467u},
    {8222213982416631208u, 12948588129929879460u, 14723384133616356447u, 9295880971709370484u, 2425663u},
    {17389055074197064901u, 18193173648434658278u, 14958315217893509901u, 10565154323403426159u, 2409177u},
    {4986752430553294329u, 5894925616200541857u, 15440039008445770256u, 9195755924929269551u, 457116u},
    {16550783018880697536u, 14855819122246441233u, 6009377514715534444u, 6205385398321556236u, 1406134u},
    {5354101389260964275u, 15710776945832441569u, 17959174128823015755u, 6078776499422673528u, 1999487u},
    {4253316865463652808u, 8768845662095154930u, 12076982274859293643u, 17402764194187118365u, 1935042u},
    {11596049264307802965u, 10340555473898106140u, 6737603869901446633u, 17257460217013419976u, 1672528u},
    {3106085136181080902u, 13447835395668501757u, 17683514176468095298u, 17108502500218494337u, 1698565u},
    {17674235700375173619u, 8578741908677116278u, 14003391567060793335u, 16964867609869127924u, 1581584u},
    {13997393958704085600u, 18320288386589313501u, 6496346856634504468u, 5289379457012680785u, 1544182u},
    {13259110523843008857u, 7857427918939900790u, 15609245560029181941u, 5648977470404987427u, 707763u},
    {4475969756867866957u, 17735564931065591894u, 14487748794041072690u, 3904166006622926907u, 3600357u},
    {10760159185171555937u, 846598468922741392u, 13843429552718699301u, 10730938785670489234u, 1703110u},
    {5665605186516368209u, 15252314116847957916u, 2272915474205087512u, 12065035049364279572u, 21201u},
    {9482774511116486105u, 821885843019287808u, 10479418000443275251u, 9800223890644341061u, 1599672u},
    {11878012585750858419u, 16366361949093336737u, 9168234969105548916u, 12279299736233852116u, 2481451u},
    {10874687408021958930u, 75097227999267597u, 14774494145513608004u, 7683879671828111592u, 1267172u},
    {15204731119472794542u, 16466727897393246662u, 14175613447430185987u, 14579009200926693423u, 865878u},
    {6557231480349254967u, 12091950016848487563u, 1122526283616631057u, 10248150997829831592u, 2854798u},
    {12732286521307377584u, 4726971115877042387u, 6716185768678120177u, 7042248360015298670u, 3071568u},
    {10553435184116780327u, 7835326584570711000u, 984180989819930896u, 1786042692753514724u, 2459168u},
    {1600210934335914474u, 17409179069642045021u, 7045368875765813664u, 16618610273239724143u, 413081u},
    {776623219454220163u, 7049140808632027579u, 9791772288466375972u, 1016426332638313392u, 1923888u},
    {7881864506184863478u, 1403398264877611496u, 8812312180405633932u, 14086720307974854774u, 2192466u},
    {9348405699381722142u, 2965115107777141508u, 14170416735408023010u, 9479988692247589609u, 2558789u},
    {2339587942644041714u, 11106193170237144860u, 2168278882871383509u, 263374117415395690u, 3754377u},
    {8445211561922971937u, 7597502975997300788u, 12595785904988523458u, 7275015435731389162u, 195300u},
    {8971345027706409108u, 9368475055673281802u, 2988261171096016208u, 15640100562622973023u, 2671295u},
    {7303909704933399840u, 13123509887034056567u, 5663809775590520117u, 10929973410577598855u, 1942413u},
    {244540506048893315u, 8751193047766551516u, 15876896120470427722u, 6953360234067501657u, 3694137u},
    {12826456719215860175u, 11822313637412890944u, 17442817840753412420u, 7273904210558375015u, 3096725u},
    {13897760469676542863u, 11100665095723822258u, 14507121197565973268u, 16558313535501059765u, 176587u},
    {14544467051673254581u, 12740874315320606311u, 1702161462652230677u, 7713420033812346836u, 107921u},
    {9546794664726175844u, 683647951114572661u, 6129800890003605014u, 794624333197806138u, 1083469u},
    {10249166652079571431u, 3214250818878344369u, 6966266106376874477u, 13855044531431586059u, 2905165u},
    {9113594458550372865u, 331415332493905119u, 17562825892425910951u, 18284162140697710748u, 3512602u},
    {12977218333390759772u, 4918791675295800878u, 2272188417953562664u, 4388251730686638619u, 2959059u},
    {8072480240475577428u, 12835260616966729964u, 14424025019810219966u, 18285156300056026450u, 957544u},
    {9278595029643052206u, 4000863237501041091u, 17498905256890375580u, 4341119229668148598u, 1493917u},
    {15365597167056595173u, 8912048185798050313u, 16411486594037649267u, 12061176113241448493u, 184540u},
    {7479775343069456363u, 3111120781034553277u, 16540552244681223497u, 10091467339522449513u, 1927991u},
    {14926501974267125693u, 12581627642473167727u, 12029729997711916983u, 10267743520030649603u, 2257864u},
    {14582674483983041446u, 760290224978357401u, 1486029629832899305u, 16759012066428266815u, 1001712u},
    {5461986358351206809u, 2385809959128164336u, 14695292580982328862u, 13853536396940739520u, 2406663u},
    {16407871499777629214u, 13295020586005530429u, 10358896948329833950u, 3791390000258455119u, 550058u},
    {11287283449852214245u, 9902594116558121828u, 14780432430322758193u, 4693890395408402368u, 1588585u},
    {7425398967594609389u, 13119594473904810407u, 8528035463006412350u, 8748273104217504539u, 2712304u},
    {4931537349527049687u, 2696028516086904714u, 16671942307409261178u, 16983567785399436775u, 217255u},
    {16690304912286752428u, 7013689287755699797u, 659855824154715990u, 15568447976559735730u, 1091187u},
    {11496196663692175661u, 4855071296838444740u, 1087323444494553885u, 13278726165872747105u, 2940502u},
    {11636604106355339886u, 9766010264479010434u, 15102318697297938773u, 6251195788382759745u, 3296597u},
    {8195357764545733561u, 8921803290997976794u, 2055160940386104476u, 10220932246772193451u, 1146684u},
    {10710576775791030400u, 3559911636060332137u, 4748833781088044250u, 17531147947718838258u, 3310257u},
    {5342141252433127707u, 816699529230561887u, 17018294072266660863u, 10293241834614120418u, 1424062u},
    {8688022718307086734u, 361752144423701757u, 1983110044432250672u, 9249641354407112614u, 3558614u},
    {5352873197177776392u, 11662342984800894893u, 13309931605346444009u, 14260990876436564588u, 763576u},
    {4518708180202523974u, 1493169367972265279u, 392978454796771962u, 18316714390947513465u, 1369146u},
    {16853272395691949186u, 13123345371095101537u, 12993026926086895821u, 8672167588729609848u, 3147972u},
    {10764853432747015814u, 17310008142857948319u, 6444049081796576236u, 5894734959579534009u, 3128536u},
    {1327299601671400855u, 11163844019072351261u, 6531036264900422048u, 11298695978728879961u, 103655u},
    {15422380553902290993u, 1041516168073313194u, 5564210236962627082u, 8072362640803585174u, 39373u},
    {2335085873252875163u, 10286372195291206981u, 18066039105169387851u, 10377019853188399590u, 3124676u},
    {12184977117548003546u, 11199268235477407524u, 1728017326595319504u, 8632493799375706704u, 3516611u},
    {2129537674618381672u, 7693192195899043106u, 7260639944879622739u, 6477995901131871923u, 3462113u},
    {6384389828735004419u, 15086980199313029885u, 106927131132963645u, 3306456450650015818u, 1134976u},
    {14194616629148774672u, 14497491515188313324u, 13003793054384815824u, 17963277530552315086u, 1267812u},
    {4065914685712153858u, 16597440876239160179u, 11173179579900447249u, 1248366120105630296u, 3463057u},
    {9293812980754742599u, 3430846803661716073u, 14688780908458203414u, 2585897918767512258u, 2492956u},
    {16036147935599921762u, 14396139354653812728u, 13391029334171269354u, 10926683623632034923u, 3326615u},
    {2102812994886253924u, 16732236584640185088u, 12563980796395890922u, 1214286731070293899u, 801405u},
    {7584210298554637732u, 9743153081795138880u, 5222538505564190728u, 1167704818755524910u, 3223547u},
    {12497418241803029069u, 2163797924500942847u, 13625260694503721315u, 3590286055544747886u, 3865385u},
    {15870192580507650138u, 6759913610525423646u, 13244025237335997763u, 5835911294465876730u, 1167352u},
    {45174727047645818u, 2654079820493613161u, 17781140587612084527u, 18035932358905828286u, 3121401u},
    {15074504105245640436u, 14183047749872637717u, 545328237004852612u, 3660459405330750227u, 2988584u},
    {12983528417096963245u, 9796839782221799523u, 17293858928180602158u, 7188831457606108255u, 248480u},
    {2127909621125219587u, 3124493250973490623u, 18292749472437718416u, 2310426663369960758u, 3203817u},
    {17860479967416761472u, 1024364229820274695u, 16596148833186007372u, 7985435338740499537u, 1066835u},
    {4838357395409577923u, 3325411599983509207u, 4404250497900033237u, 7009266261878321060u, 3109988u},
    {14407622989202785655u, 14747963903216767041u, 16407671757375063225u, 3155845703348475330u, 874833u},
    {5117412542073610295u, 11905221556971513473u, 9543523745270462592u, 4843996624155252963u, 2051570u},
    {10500864280181587413u, 11671010014579956001u, 17784323034645923480u, 3064263741176270240u, 844782u},
    {4048650687834465992u, 9239123944651255293u, 11243990621541380169u, 4555211904805800211u, 3316872u},
    {11646479618687886540u, 9187525908734753656u, 12792178086487083589u, 17571180844680953500u, 741098u},
    {10667370040509458646u, 14878374125538662858u, 17791291941104464184u, 15145765610675585405u, 1686846u},
    {12505968273870865041u, 7193057728571774276u, 18093093093808227910u, 17613169776853942656u, 3891533u},
    {7167547723819835487u, 10632003311128622297u, 7061597821801941368u, 16284744789452350529u, 1751031u},
    {7130201270533265895u, 13398928484181271219u, 6051761077562241650u, 5652793171965255507u, 2866339u},
    {11539795275495867513u, 15930064865054550218u, 8018971781462254948u, 3799869517586538406u, 1808532u},
    {17744919149540528849u, 5286129176565578564u, 7189177965605301192u, 8752330409342263856u, 2419593u},
    {15336816731439814314u, 14572003567851605809u, 8586519307974351827u, 16689937844347222740u, 354484u},
    {3193930988617815057u, 17027606016944983305u, 779723294015835794u, 78596686354090637u, 0u},
    {17968307127445206903u, 13090827613750355578u, 6531819360415513378u, 78596686u, 0u},
    {3112136228011837709u, 18060431523858526409u, 1449852958215529843u, 0u, 0u},
    {4711348190406322506u, 3975823872128231611u, 1449852958u, 0u, 0u},
    {8107560571435377403u, 8298322391003035699u, 1u, 0u, 0u},
    {13144915838084412048u, 26745066464u, 0u, 0u, 0u},
    {13744050392456646824u, 26u, 0u, 0u, 0u},
    {493359396309u, 0u, 0u, 0u, 0u},
    {494u, 0u, 0u, 0u, 0u},
    {1u, 0u, 0u, 0u, 3244596u},
    {7458203391589413994u, 15076372225419554348u, 6180897705302832355u, 17209559613061430484u, 965515u},
    {10368844237154028195u, 3332115437533064359u, 14572055736138614789u, 5350072584120554554u, 1123694u},
    {8475205883582359594u, 6443678606174432439u, 260911832661759909u, 11982289111281272941u, 3778044u},
    {14537194694100801109u, 3088992691564660225u, 9348663152967806232u, 5978415333859593792u, 2639611u},
    {10993074186927631250u, 10967654100977255642u, 2033848876248514149u, 7975027578721636837u, 3026176u},
    {6486627743787095443u, 3284719439112513188u, 14623421225820388344u, 9927713485365156886u, 656711u},
    {7493218048446065375u, 5325525875238454628u, 13216204154070094728u, 9451659008643662974u, 795120u},
    {1616538734751148021u, 13356465254608735113u, 5987386909073757475u, 18245238676195314755u, 1063051u},
    {8716154626483189788u, 1275847134035882751u, 13839765135401583161u, 16664914070740892904u, 3229981u},
    {7416774060704609149u, 2298065143765046264u, 18061063251805012188u, 10579991379072337177u, 1044577u},
    {1911207688590927065u, 12180649492904546481u, 6838643555366030244u, 8161777181450131449u, 1707026u},
    {5130183874582210771u, 6369507337708840697u, 9352231128784274856u, 8894573146576081430u, 2227429u},
    {5757126580232534362u, 15930467255300352972u, 7794795200203031575u, 16109932292057861667u, 1238738u},
    {6069911694748864702u, 4610172940175209133u, 11207545803560538069u, 17028442891921304010u, 3530432u},
    {4369448343495501595u, 18268681734506646544u, 12028792030782994632u, 16206026057097935115u, 255579u},
    {381775295458467121u, 11254423067456160864u, 10890972083160544724u, 8075165148857569502u, 3256712u},
    {2320742666144733337u, 11146493595836845340u, 2213906181635240558u, 1285054839505718842u, 1428279u},
    {5506851244200010277u, 9373776727256032842u, 3288458751403202858u, 4998321087080936228u, 579995u},
    {10844745993282669625u, 10643218417197322639u, 8678421056835829894u, 12692835575002668994u, 2471806u},
    {2514969754678621137u, 9736813815211702278u, 17421243278002833687u, 12151272583746588534u, 717357u},
    {3806888629695969990u, 12083473731216703942u, 10425868187456780501u, 4408746149453360742u, 1599540u},
    {5926417754169685270u, 9706119891806086721u, 11902159928088760109u, 13648391582592787429u, 3773640u},
    {13997775480963944188u, 14001359391969262911u, 17579556540834337124u, 1654878453789119486u, 692396u},
    {8880737190466337955u, 16270306390126839162u, 9035794898474779023u, 2246557868640304668u, 2207340u},
    {2271229141686152919u, 4829533799620115003u, 5614563708022836246u, 12434624412833824902u, 908328u},
    {16916840094883402147u, 12421732096664149669u, 8007417091025423316u, 5132844883278492318u, 2673467u},
    {14760231739486975337u, 5212075087908220275u, 2004515268309624780u, 9705034367753696361u, 1279210u},
    {336994930719860969u, 131413060466679742u, 5098674917336238770u, 10544005998729043019u, 3360069u},
    {16723957450479830933u, 1843898500553139850u, 2174216696249528059u, 11014736637222057450u, 2268071u},
    {13514527631448784731u, 15994962140911052997u, 12272806732948316191u, 5229985307023550525u, 2161284u},
    {18147916370196670620u, 2733514092254225339u, 10669328734868276314u, 10344104605472283429u, 2352338u},
    {11454731446631604283u, 2310117233229550989u, 12941527980341050429u, 5087424570059921904u, 1291179u},
    {13072670016817126855u, 12130466693637318000u, 3798501311420582103u, 7157519863408638459u, 2983147u},
    {1656452403204743115u, 1182692329616247967u, 3380439845196256294u, 6612270413852216467u, 3433823u},
    {5376237725509502153u, 12993762084968179243u, 9424892296830090858u, 16276301519221473567u, 2125534u},
    {7256502472959318602u, 14114390362275778559u, 5645377205052890300u, 15891879886338415597u, 1454964u},
    {11754234617195346037u, 14696754110696905528u, 7301911605629600019u, 6944368392077422486u, 1520193u},
    {10553285930532428039u, 6706653298125050077u, 8802866965334688042u, 2622116003523418832u, 1494622u},
    {17417612278114461795u, 3097396235217621819u, 18056189321835934775u, 9323000543035755664u, 516960u},
    {3281143839371687949u, 11115667805507308761u, 15479825557904375553u, 16006322114559347224u, 467155u},
    {15493077850092579677u, 7773775561369589913u, 2665918008776084139u, 14492193906357591036u, 552925u},
    {14944403809534200371u, 10262054984562483568u, 3410209660818427308u, 14493776082082664896u, 1720755u},
    {16362600542972016811u, 1211370466188308443u, 10582066532292204724u, 4931658736171431809u, 3765781u},
    {16785764333988812600u, 9351488438793850146u, 3052639254435130969u, 7707571371296657981u, 1874553u},
    {14576836220470183249u, 6317224632042024272u, 7509404417300714437u, 10699103324764510360u, 1616986u},
    {7788954707999483192u, 15806052322845964731u, 14644127387924033603u, 11414927995604488525u, 2426269u},
    {10848984042781987490u, 6131285774771709124u, 12807375735140251149u, 8619610465225327579u, 75701u},
    {7227453302181294140u, 5985958662828932134u, 18303051236646639059u, 8432134948030302863u, 2817512u},
    {2138618817300904332u, 987512120581278335u, 4113665544148167462u, 3366623256965425550u, 610335u},
    {9877823540758381769u, 11388171647696768270u, 2785032423923145884u, 13558086376041302744u, 3477152u},
    {3377677617371237182u, 12437412831809620617u, 15900731395416963440u, 15196236894572340250u, 841963u},
    {15419605796709101618u, 6058566880036843283u, 14381127037861631013u, 3186065628845598793u, 216665u},
    {7483747037802999102u, 8440210745557288583u, 15614789478590898496u, 1877494211976922244u, 884459u},
    {18254319582059776302u, 1173343977198037860u, 5343246789156421896u, 16013101267114185080u, 3444285u},
    {1713658934598946678u, 7161766429107534321u, 1879716585626383563u, 6909007293528171890u, 1872064u},
    {8399380201370797853u, 13149263218207957182u, 10415535560263758730u, 10626999815982018883u, 276212u},
    {2186279744923050894u, 15893868368435546891u, 12045308377637612457u, 5553529963621538350u, 357116u},
    {11111081575084586603u, 16388215711188978526u, 15798489034376619044u, 3609467334906553623u, 172798u},
    {16636412460507049019u, 17895144014782482201u, 123504490700092560u, 6128083057315790758u, 562264u},
    {7997389507309035779u, 54489338705640595u, 11909391041463290557u, 11755759774420196852u, 1093519u},
    {1689504886779109833u, 12196194949273511263u, 10953188837177837615u, 6577412934339940745u, 136031u},
    {16164468607967189801u, 13086169529339171743u, 6563662213995992644u, 7424441521527081126u, 847781u},
    {471271512354752572u, 14550264087760779456u, 16706205638375533450u, 10536047536099473734u, 887754u},
    {1138292204009998687u, 16190659658551939223u, 7098015640819788341u, 881067309829594717u, 1348591u},
    {16673196014533743516u, 17484921796545655061u, 13889803811380044569u, 17751045247248447603u, 1596969u},
    {9167676850610632775u, 8498375923592220035u, 3377589759541194373u, 3776453786159945788u, 1623690u},
    {8284993018734899115u, 2729756962605170403u, 430340923033179211u, 11847397219881676752u, 3847654u},
    {8216959654820943380u, 1585214811938210735u, 18357934364619330453u, 11960479716727691510u, 1080754u},
    {1267566680629594114u, 1719761119316169101u, 8760173831906517415u, 3694873700339442345u, 741686u},
    {16119663642906011791u, 406783008793929797u, 15482479979740334647u, 590142447823350530u, 3782335u},
    {13608775348284262217u, 16855175357698667891u, 13555661655882390714u, 5474091319180771864u, 2644594u},
    {3794862784053010632u, 9558951569443548734u, 2345240988466174109u, 12010344764466996533u, 1376969u},
    {10563217169966995512u, 8911221795668380531u, 850919474204475396u, 17175107987777625300u, 3841466u},
    {7090980138720807420u, 12008732485578596647u, 3426194131678179574u, 13473575048399560820u, 78991u},
    {13824176088236389628u, 18273078873843312161u, 10906826995749067963u, 2451415337524251263u, 2349092u},
    {9421669550403685601u, 18195073742185717401u, 10126966160429826688u, 3502097615201554783u, 3419937u},
    {9191031380587114436u, 3730010769537733145u, 489262542025362755u, 5899751823161470454u, 3839599u},
    {10763397608042477641u, 9879385538850959150u, 15434620207564833178u, 13329425408977163167u, 3668335u},
    {3804901259524872671u, 14329556428664107196u, 81950174044164880u, 15343878786291779169u, 400082u},
    {16140362644734735490u, 9204766222389731013u, 2239650207047814741u, 439725789833944267u, 2475784u},
    {3422529313875754795u, 18132812171839355829u, 6862395604107413765u, 9701387755351854142u, 568672u},
    {11414751766581778368u, 9314013249493508318u, 9009908055290147409u, 18385176636218895993u, 697857u},
    {18240711330653885126u, 11091508664412910586u, 14406591783487127802u, 12190606600274044546u, 3376083u},
    {11317519528343015476u, 10965131811875597013u, 7792728800986255286u, 1503429632021766884u, 86841u},
    {11622626214982017854u, 17612772798740842628u, 3572247784350086467u, 17943942850649590707u, 3292560u},
    {13831672203923548687u, 10184195419737025299u, 16940893322290964737u, 15409004559689926339u, 813313u},
    {5115546358186698609u, 7623897093004800728u, 4489755768712439925u, 7076647207888763224u, 1038157u},
    {4507210010789404718u, 11871153143661428030u, 15970728674314022101u, 4126433483725869646u, 648485u},
    {11085024499936989925u, 4514180175133494878u, 5636797538696323997u, 3398669360739686014u, 2301640u},
    {9668858224095251218u, 8821425991951842833u, 2234569481222672505u, 4365913409704158373u, 228140u},
    {8529321435764448659u, 8602180023476112978u, 14938774956789040269u, 16361282291168530978u, 3754920u},
    {10847976242553375244u, 2497029445274145237u, 13327434995883888967u, 12607287427217996624u, 3131422u},
    {9989069923124689765u, 18070500281135737051u, 13991386403214799904u, 3876817036838251746u, 3736726u},
    {12185966866808518408u, 17064243560016876401u, 14943725133871293075u, 13111354952937349850u, 3226764u},
    {7617873421409766764u, 14144208144635605996u, 10108824511093250357u, 3734460598739939016u, 199409u},
    {2807200949691886806u, 16892231744333682986u, 13247233380868396702u, 17297501019626159586u, 621290u},
    {6150632836084572846u, 1551111426441159057u, 17518212946226701665u, 10892157494650174362u, 1095492u},
    {1460163119798300694u, 17891995306752692360u, 14187195976310346278u, 9027407526191945718u, 2703620u},
    {1490617490535160657u, 10296922495373250971u, 2434889767219207268u, 10714396912853304672u, 48271u},
    {1518560083532892118u, 9451185573326220229u, 11425186627548034471u, 17294713022600283586u, 3462621u},
    {9968565103378748428u, 3183827295174643555u, 17089600927390629814u, 5972596811816056015u, 1963344u},
    {1920583562412830240u, 17215772885477652778u, 13355810167150520517u, 4359672952544926177u, 3579931u},
    {3470425403646391099u, 11943567396641152859u, 6846410810507429598u, 17576033426534700509u, 3097316u},
    {14685480021924155578u, 6981248483940331586u, 1987879532174345383u, 8487873915581007712u, 3059716u},
    {4297477513110520642u, 289880831771979095u, 245503439220254854u, 13315039109456848434u, 1797656u},
    {6060767033509323378u, 14114919771126812770u, 3258811585081391893u, 10337396860903302375u, 3671615u},
    {1990715404695385197u, 12992066454738407229u, 4793980712672573125u, 16424803199189231428u, 1380806u},
    {16584371364002904926u, 3609553912915028033u, 5864476798290729503u, 6006251696470264478u, 1382113u},
    {12160907156047126160u, 11863331314331462378u, 18131472363030248806u, 2907799252315316065u, 2048739u},
    {15139457925596747474u, 5015924843975497801u, 7074848210342186577u, 14521368968538142021u, 2053399u},
    {16467082182177542953u, 11359162947630907932u, 2156144091015294777u, 13512648625448104120u, 2942615u},
    {18407624522741375722u, 943553497933344610u, 12481435239439737957u, 8268847399648892161u, 1426132u},
    {12422550481596326444u, 15258931332979034035u, 16862564877194831136u, 5070339082943130469u, 3360405u},
    {8701062728773201245u, 3512605409942289803u, 13674478224199139183u, 4457501772402957124u, 1998402u},
    {11489817734708756567u, 408500918968870511u, 14231197396934000572u, 6810277854273117071u, 85177u},
    {12040242091132514747u, 17827395010778135813u, 13855591195682039431u, 8216136965454028916u, 372732u},
    {16733408227234129487u, 13521195558685802008u, 866329729693305899u, 16003661576448220666u, 2111155u},
    {3941873099502147728u, 638143634294331625u, 16419394253867615256u, 17837169679356794056u, 3355540u},
    {16792711180918803436u, 2779481463114451443u, 3437489826512749661u, 14977820771297347780u, 60987u},
    {9788020451830054640u, 4387174628242238114u, 13313988673011931028u, 4756926233061887871u, 3204044u},
    {14151990874024313170u, 3636012419823195217u, 12171585567092644306u, 17424984347566463455u, 1641346u},
    {18425202146152961140u, 14633753414798933270u, 5039255566765161020u, 10334513454447086073u, 1179910u},
    {4573192072295847759u, 13511390539167917501u, 9118606212344359779u, 2543781299462001851u, 885725u},
    {7544442016940918588u, 7531189405321218196u, 1237471261296841306u, 1097202655507386732u, 3697965u},
    {5816758763471318940u, 23745726414024615u, 10128151114259533835u, 10300393768431504909u, 1435225u},
    {11624235687901688247u, 725960157616515356u, 11982608521432987752u, 7088119454280521287u, 701843u},
    {13208860981870511335u, 14372798207057115470u, 2127824101018773973u, 3687884021223368723u, 2795930u},
    {9223552938836023586u, 15558987856398669387u, 16105697355573646677u, 1780958065756161231u, 3222836u},
    {13244851001432749616u, 9633907828208799666u, 4575976956482406825u, 16632697461387921142u, 547171u},
    {4091466339890039605u, 12906509344438885963u, 8396948277728158375u, 11251078209951011206u, 826269u},
    {5418010232325478779u, 1680589432703453253u, 8397177611471454054u, 6644540635519488239u, 2817931u},
    {101617160221740344u, 15187496114376444921u, 264060261425150309u, 13814982119863148842u, 279172u},
    {15901652862940262191u, 4489447079143713261u, 14884507972614354890u, 10309385775675222610u, 2409332u},
    {9549531388140649057u, 2643419205015276921u, 1647351851401769053u, 16041230217521986349u, 1227804u},
    {1464507257639581551u, 17767565599600891562u, 15390443484846601010u, 10398942543663529883u, 3470366u},
    {4674465934678415321u, 9430987097012426175u, 8613547393358696213u, 14187305395276921121u, 2031472u},
    {2620940537827651456u, 6119172049817855868u, 9543974114732897847u, 8035866996474213181u, 1057602u},
    {12135440507999479686u, 11293776582796996114u, 12588021511762897676u, 7009095943140720157u, 2857532u},
    {879758330469517260u, 7089230963838065471u, 10866826955934255036u, 2286497583671297361u, 190050u},
    {12297633780227549817u, 15413236268819211571u, 17633577682244909984u, 12037124010331671395u, 1026828u},
    {15041857401877841651u, 10718957913604846248u, 14728349826592751084u, 4774742851864086817u, 51364u},
    {12196317358407808390u, 6873687399589817226u, 5041329905693013919u, 9944895480571400037u, 3104334u},
    {12275855620830919569u, 4996743637796849589u, 14346102618304590893u, 17134914651751131379u, 342768u},
    {6808631065907778648u, 7502282795440746216u, 6261645224331850079u, 11391422828700185815u, 2646015u},
    {5850015217034378222u, 16622821504607295473u, 16959863735224836195u, 7182512182666485071u, 1560925u},
    {17380499564157200014u, 15858992976010093972u, 9641926297217123760u, 3775788881148019936u, 1192152u},
    {17702771038397441574u, 15307728944267771085u, 9705525074101882522u, 15946719608998823726u, 3379648u},
    {12410458474130459685u, 5444948079252811662u, 12889383774694096809u, 494689081889511563u, 3401026u},
    {17282791981959407014u, 14882583595006729253u, 7081143894385014321u, 17860963584072921375u, 2785933u},
    {17221621236871002268u, 9287101291314144876u, 6182225269214728905u, 5383653369725132720u, 2301776u},
    {8097179365123521146u, 3644159484583507925u, 11171398687512515397u, 8257025998494444950u, 177033u},
    {11485021174817339099u, 10823528306578724180u, 10066024445508079304u, 9947213667934682189u, 2032710u},
    {14865581513735225362u, 4946909264569474152u, 11068812898061273973u, 1406591177813914594u, 959015u},
    {15342356728527669425u, 15300351508551544639u, 8428923058741623210u, 10610157029249846335u, 450903u},
    {7841911012909254648u, 6321613210639743213u, 3729112311101472438u, 13194857411794037175u, 3821079u},
    {15294464934051696786u, 8280342425687156632u, 10576456195208761572u, 10230607238941122407u, 1075783u},
    {7396206261235382560u, 14281309373768646372u, 9356884692649562204u, 2613918089275860417u, 1418437u},
    {5061209936002363065u, 16147548326110640127u, 9987152271906671664u, 10042171118209581548u, 1978472u},
    {7774158030106756339u, 15303943967820306415u, 3954839899461112574u, 8755465255272451658u, 3504063u},
    {1911386972853963417u, 295842071462790484u, 15433790624055927670u, 5180727738827503623u, 1343546u},
    {15197894433561128094u, 7937549378444740099u, 1161664520415068905u, 4204124508593804200u, 727953u},
    {10439707320019154111u, 17463268336016037856u, 15150795099037765990u, 12479392135454346525u, 1263021u},
    {4825426829135689313u, 5107330975217859676u, 847415048357882461u, 2977659993181158223u, 1722938u},
    {10988315710454841491u, 17502244163591255185u, 11498335769185561303u, 2625855984683934676u, 411047u},
    {12602468781804839709u, 14649521502585187128u, 13780393501901302659u, 4619268499864509978u, 2752696u},
    {4065840528208829698u, 8142623119491189702u, 14013377468254302368u, 11219705359122822567u, 3013621u},
    {8690267741124788683u, 6025865373291896816u, 14266418632729804927u, 16628838135265287291u, 3827660u},
    {5873773592265284672u, 457297429497527698u, 11137883082990346982u, 16283566539583798837u, 3773029u},
    {13220952411031996229u, 5612196797712241104u, 7525601994848248559u, 18011941032073306879u, 2334257u},
    {13666206608281154986u, 5077710085623684951u, 16598678996282753970u, 9122316308272126004u, 214634u},
    {6582210749916518697u, 8747880244292786437u, 3203729955671864056u, 12830211046341005492u, 1034260u},
    {14407538836900174746u, 17816265508122035807u, 3603933973417427403u, 4198419196555706175u, 3425037u},
    {4318143123517195163u, 10523499960491896042u, 1732443811287885790u, 15123217939107343762u, 1616180u},
    {14031099614758546231u, 1355158003457372062u, 4391997141051646277u, 17683923813252610162u, 2169077u},
    {4472202047056289020u, 9539072955148076419u, 6330712166926210524u, 14379473639526752770u, 121115u},
    {11651246958756359248u, 787312285480313551u, 16062034045681272751u, 1083098102356880011u, 927187u},
    {12271488704114535834u, 16227135886032203287u, 7213861285192233101u, 1025909898911559744u, 351487u},
    {9203968269523266836u, 17856715333091936943u, 1483353168472631999u, 9806316580918345144u, 2889454u},
    {6712138837810951394u, 1991689939534003498u, 12422089259176724203u, 2503259225546622763u, 883631u},
    {12373040146676767271u, 8537816264413688064u, 6467805886601662079u, 160415305491711142u, 439913u},
    {15733569814114114411u, 4043726991623727864u, 8702446136390264497u, 9159429405502960967u, 3718273u},
    {5111437403186409638u, 4153702380119910575u, 2192213564732539201u, 1005338762079676809u, 2725619u},
    {7917636215266486340u, 1046000656781210716u, 8222213982416631207u, 12948588129929879460u, 1878919u},
    {14595514240952960852u, 839965685593801890u, 17389055074197064900u, 18193173648434658278u, 3158307u},
    {14232403335302111278u, 6985913691306459168u, 4986752430553294328u, 5894925616200541857u, 648068u},
    {9608760247683498379u, 9687349125575162421u, 16550783018880697535u, 14855819122246441233u, 120424u},
    {6345350382988481036u, 1867869482183795193u, 5354101389260964274u, 15710776945832441569u, 2703825u},
    {1959111391568477142u, 2038530836881068700u, 4253316865463652807u, 8768845662095154930u, 1968885u},
    {10975330380352255246u, 15275126136524690611u, 11596049264307802964u, 10340555473898106140u, 2446117u},
    {1365891149714770017u, 7128588498253223955u, 3106085136181080901u, 13447835395668501757u, 210780u},
    {16533024297846587922u, 14203363780784821230u, 17674235700375173618u, 8578741908677116278u, 957323u},
    {9409796582990651764u, 2687158510963295225u, 13997393958704085599u, 18320288386589313501u, 170770u},
    {17468892971117287988u, 2575060974571834351u, 13259110523843008856u, 7857427918939900790u, 509401u},
    {17231678881541435621u, 17544391189684876399u, 4475969756867866956u, 17735564931065591894u, 2925444u},
    {13350661016938839483u, 15619856636330513998u, 10760159185171555936u, 846598468922741392u, 2610855u},
    {7020450915557062388u, 13580498315347121764u, 5665605186516368208u, 15252314116847957916u, 1585770u},
    {10638634066900286678u, 14660394618363040122u, 9482774511116486104u, 821885843019287808u, 503509u},
    {5870947442341094252u, 15384269796893286886u, 11878012585750858418u, 16366361949093336737u, 164778u},
    {6777823244459088516u, 12334824552160228215u, 10874687408021958929u, 75097227999267597u, 2038108u},
    {6497671528547613304u, 3761492733430183698u, 15204731119472794541u, 16466727897393246662u, 3162173u},
    {10380994405538574013u, 9333208031561575501u, 6557231480349254966u, 12091950016848487563u, 2343367u},
    {11705992363176879423u, 3815139496203497074u, 12732286521307377583u, 4726971115877042387u, 2878905u},
    {7068156924205129544u, 1945405716445917089u, 10553435184116780326u, 7835326584570711000u, 2347238u},
    {13326318129893328190u, 10280644482160209713u, 1600210934335914473u, 17409179069642045021u, 3228438u},
    {8486334327624156543u, 10843072490987351858u, 776623219454220162u, 7049140808632027579u, 1859622u},
    {10895827391785495892u, 7645575135450034979u, 7881864506184863477u, 1403398264877611496u, 582962u},
    {2695806064576352769u, 8829602034778563636u, 9348405699381722141u, 2965115107777141508u, 505438u},
    {5459084950322704983u, 9328459401983254195u, 2339587942644041713u, 11106193170237144860u, 1705211u},
    {3084841988696041184u, 16753935982688499671u, 8445211561922971936u, 7597502975997300788u, 53550u},
    {18169238176478534752u, 7561581323315659737u, 8971345027706409107u, 9368475055673281802u, 489396u},
    {11632538542868256182u, 17572768983224860795u, 7303909704933399839u, 13123509887034056567u, 1746875u},
    {18411366384601951844u, 8685872873196388057u, 244540506048893314u, 8751193047766551516u, 263906u},
    {9636257282173382139u, 10818098715416525973u, 12826456719215860174u, 11822313637412890944u, 205760u},
    {6294076698632410538u, 17561526120243565911u, 13897760469676542862u, 11100665095723822258u, 3184180u},
    {4528746345866318002u, 1681934850637486035u, 14544467051673254580u, 12740874315320606311u, 1904379u},
    {8602781419933724412u, 9361150401088365825u, 9546794664726175843u, 683647951114572661u, 2369886u},
    {6324141274877242798u, 1157718313063204440u, 10249166652079571430u, 3214250818878344369u, 2341061u},
    {3336079652529017666u, 7146573948927218502u, 9113594458550372864u, 331415332493905119u, 1023231u},
    {4406871195123771899u, 12245492976012125038u, 12977218333390759771u, 4918791675295800878u, 488372u},
    {5524221622843147405u, 6549853167142158550u, 8072480240475577427u, 12835260616966729964u, 2043480u},
    {11420678947362026514u, 7627841778016668673u, 9278595029643052205u, 4000863237501041091u, 2654350u},
    {10795367588639294937u, 9642829993877272834u, 15365597167056595172u, 8912048185798050313u, 685445u},
    {4254838081654957465u, 18382344655116654194u, 7479775343069456362u, 3111120781034553277u, 2363901u},
    {5872406499626552398u, 7968105247497721838u, 14926501974267125692u, 12581627642473167727u, 2152915u},
    {13905385571959313077u, 10437477046090621218u, 14582674483983041445u, 760290224978357401u, 428767u},
    {8980085801484981504u, 11243405132984378713u, 5461986358351206808u, 2385809959128164336u, 1974510u},
    {6919274412205189835u, 5083191153874770532u, 16407871499777629213u, 13295020586005530429u, 1664452u},
    {10715646419401748349u, 13025515115078796898u, 11287283449852214244u, 9902594116558121828u, 277141u},
    {2563859584643187684u, 13385245060755786752u, 7425398967594609388u, 13119594473904810407u, 1620748u},
    {14250968679908560125u, 4352807893470078974u, 4931537349527049686u, 2696028516086904714u, 1306608u},
    {10789351241230176521u, 329620410093858033u, 16690304912286752427u, 7013689287755699797u, 1475192u},
    {10403604491807679154u, 15738281155847352314u, 11496196663692175660u, 4855071296838444740u, 2072727u},
    {4769363373830303973u, 9452775983254637832u, 11636604106355339885u, 9766010264479010434u, 3183175u},
    {7668287461656151864u, 7053186927967496019u, 8195357764545733560u, 8921803290997976794u, 1576946u},
    {5850876662395532780u, 8146562543219004318u, 10710576775791030399u, 3559911636060332137u, 1304620u},
    {2902043517520806252u, 2321347708668394184u, 5342141252433127706u, 816699529230561887u, 79373u},
    {12867318990114752752u, 3502744985108009917u, 8688022718307086733u, 361752144423701757u, 3310630u},
    {15567818237494298639u, 10718541982955725035u, 5352873197177776391u, 11662342984800894893u, 2819873u},
    {5801488243155829141u, 9133694437190831744u, 4518708180202523973u, 1493169367972265279u, 480478u},
    {14716860832063417937u, 14787293843129724539u, 16853272395691949185u, 13123345371095101537u, 877421u},
    {1525298323434380085u, 15095301864700175238u, 10764853432747015813u, 17310008142857948319u, 3630696u},
    {2528626663206935818u, 3659883716401067405u, 1327299601671400854u, 11163844019072351261u, 1773204u},
    {5571511970773425785u, 8489443498224601800u, 15422380553902290992u, 1041516168073313194u, 2937854u},
    {1047046791502184450u, 5127603089430814245u, 2335085873252875162u, 10286372195291206981u, 1644797u},
    {15741574896506115832u, 2031002945245250323u, 12184977117548003545u, 11199268235477407524u, 2986284u},
    {11072518891514720821u, 5025480302913583201u, 2129537674618381671u, 7693192195899043106u, 1460585u},
    {6671081146631395571u, 8555650210683059348u, 6384389828735004418u, 15086980199313029885u, 754339u},
    {7248041930424987359u, 6540406788726353934u, 14194616629148774671u, 14497491515188313324u, 1311572u},
    {16907262310529471978u, 2639269519753135298u, 4065914685712153857u, 16597440876239160179u, 2392827u},
    {10041039221839818878u, 5867526208952099162u, 9293812980754742598u, 3430846803661716073u, 3072528u},
    {14098678750886643208u, 16483038993910995545u, 16036147935599921761u, 14396139354653812728u, 806362u},
    {9558505874903487231u, 15491082811029414995u, 2102812994886253923u, 16732236584640185088u, 833636u},
    {644576231351073347u, 6292002663264052607u, 7584210298554637731u, 9743153081795138880u, 112220u},
    {6527828702347924434u, 9087975358169224018u, 12497418241803029068u, 2163797924500942847u, 3174401u},
    {12946449512178183884u, 11615134012306704327u, 15870192580507650137u, 6759913610525423646u, 3252955u},
    {7116236906580928816u, 16757290783639395395u, 45174727047645817u, 2654079820493613161u, 3239559u},
    {14071378323049257778u, 8305681529418524225u, 15074504105245640435u, 14183047749872637717u, 3743998u},
    {6980272782433851794u, 12550836231779428050u, 12983528417096963244u, 9796839782221799523u, 1410368u},
    {11810925796442483120u, 17052506333964968733u, 2127909621125219586u, 312449325097349