/*
 * Decompiled with CFR 0.152.
 */
package rene.util.parser;

import java.util.Vector;

public class StringParser {
    char[] C;
    int N;
    int L;
    boolean Error;

    public StringParser(String string) {
        this.C = string.toCharArray();
        this.N = 0;
        this.L = this.C.length;
        this.Error = this.N >= this.L;
    }

    public boolean blank() {
        return this.C[this.N] == ' ' || this.C[this.N] == '\t' || this.C[this.N] == '\n' || this.C[this.N] == '\r';
    }

    public boolean blank(char c2) {
        return this.C[this.N] == ' ' || this.C[this.N] == '\t' || this.C[this.N] == '\n' || this.C[this.N] == '\r' || this.C[this.N] == c2;
    }

    public String upto(char c2) {
        int n;
        if (this.Error) {
            return "";
        }
        for (n = this.N; n < this.L && this.C[n] != c2; ++n) {
        }
        if (n >= this.L) {
            this.Error = true;
        }
        String string = new String(this.C, this.N, n - this.N);
        this.N = n;
        return string;
    }

    public boolean advance() {
        if (this.N < this.L) {
            ++this.N;
        }
        if (this.N >= this.L) {
            this.Error = true;
        }
        return !this.Error;
    }

    public String parseword() {
        if (this.Error) {
            return "";
        }
        while (this.blank()) {
            if (this.advance()) continue;
            return "";
        }
        int n = this.N;
        while (!this.Error && !this.blank()) {
            this.advance();
        }
        return new String(this.C, n, this.N - n);
    }

    public String parsedigits(char c2) {
        if (this.Error) {
            return "";
        }
        while (this.blank()) {
            if (this.advance()) continue;
            return "";
        }
        int n = this.N;
        while (!this.Error && !this.blank() && this.N <= this.L && this.C[this.N] >= '0' && this.C[this.N] <= '9' && this.C[this.N] != c2) {
            this.advance();
        }
        return new String(this.C, n, this.N - n);
    }

    public String parsedigits() {
        if (this.Error) {
            return "";
        }
        while (this.blank()) {
            if (this.advance()) continue;
            return "";
        }
        int n = this.N;
        while (!this.Error && !this.blank() && this.N <= this.L && this.C[this.N] >= '0' && this.C[this.N] <= '9') {
            this.advance();
        }
        return new String(this.C, n, this.N - n);
    }

    public String parseword(char c2) {
        if (this.Error) {
            return "";
        }
        while (this.blank()) {
            if (this.advance()) continue;
            return "";
        }
        int n = this.N;
        while (!this.Error && !this.blank(c2)) {
            this.advance();
        }
        return new String(this.C, n, this.N - n);
    }

    public boolean isint() {
        if (this.Error) {
            return false;
        }
        return this.C[this.N] >= '0' && this.C[this.N] <= '9';
    }

    public int parseint() {
        int n = 1;
        try {
            this.skipblanks();
            if (this.Error) {
                return 0;
            }
            if (this.C[this.N] == '-') {
                n = -1;
                ++this.N;
                if (this.N > this.L) {
                    this.Error = true;
                    return 0;
                }
            }
            return n * Integer.parseInt(this.parsedigits(), 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int parseint(char c2) {
        int n = 1;
        try {
            this.skipblanks();
            if (this.Error) {
                return 0;
            }
            if (this.C[this.N] == '-') {
                n = -1;
                ++this.N;
                if (this.N > this.L) {
                    this.Error = true;
                    return 0;
                }
            }
            return n * Integer.parseInt(this.parsedigits(c2), 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void skipblanks() {
        if (this.Error) {
            return;
        }
        while (this.blank() && this.advance()) {
        }
    }

    public boolean skip(String string) {
        if (this.Error) {
            return false;
        }
        int n = string.length();
        if (this.N + n > this.L) {
            return false;
        }
        if (!new String(this.C, this.N, n).equals(string)) {
            return false;
        }
        this.N += n;
        if (this.N >= this.L) {
            this.Error = true;
        }
        return true;
    }

    public char next() {
        if (this.Error) {
            return ' ';
        }
        ++this.N;
        if (this.N >= this.L) {
            this.Error = true;
        }
        return this.C[this.N - 1];
    }

    public String wrapline(int n) {
        int n2 = this.N;
        int n3 = this.N;
        String string = "";
        while (n2 < this.L) {
            if (this.C[n2] == '\n') {
                if (n2 > this.N) {
                    string = new String(this.C, this.N, n2 - this.N);
                }
                this.N = n2 + 1;
                break;
            }
            if (this.C[n2] == ' ' || this.C[n2] == '\t' || this.C[n2] == '\n') {
                n3 = n2;
            }
            if (++n2 - this.N >= n && n3 > this.N) {
                string = new String(this.C, this.N, n3 - this.N);
                this.N = n3 + 1;
                break;
            }
            if (n2 < this.L) continue;
            if (n2 > this.N) {
                string = new String(this.C, this.N, n2 - this.N);
            }
            this.N = n2;
            break;
        }
        if (this.N >= this.L) {
            this.Error = true;
        }
        return string;
    }

    public Vector wraplines(int n) {
        Vector<String> vector = new Vector<String>(10, 10);
        while (!this.Error) {
            String string = this.wrapline(n);
            vector.addElement(string);
        }
        return vector;
    }

    public String wraplineword(int n) {
        int n2 = this.N;
        int n3 = this.N;
        String string = "";
        while (n2 < this.L) {
            if (this.C[n2] == '\n') {
                string = new String(this.C, this.N, n2 - this.N);
                this.N = n2 + 1;
                break;
            }
            if (++n2 >= this.L) {
                if (n2 > this.N) {
                    string = new String(this.C, this.N, n2 - this.N);
                }
                this.N = n2;
                break;
            }
            if (n2 - this.N < n || n3 <= this.N) continue;
            string = new String(this.C, this.N, n3 - this.N);
            this.N = n3 + 1;
            if (this.N >= this.L || this.C[this.N] == '\n') break;
            string = string + "\\";
            break;
        }
        if (this.N >= this.L) {
            this.Error = true;
        }
        return string;
    }

    public Vector wrapwords(int n) {
        Vector<String> vector = new Vector<String>(10, 10);
        while (!this.Error) {
            String string = this.wraplineword(n);
            vector.addElement(string);
        }
        return vector;
    }

    public void replace(char c2, char c3) {
        for (int i = 0; i < this.L; ++i) {
            if (this.C[i] != c2) continue;
            this.C[i] = c3;
        }
    }

    public boolean error() {
        return this.Error;
    }
}

