/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import atp.sHotEqn;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.FontStruct;
import rene.zirkel.graphics.LatexOutput;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class MyGraphics13
extends MyGraphics {
    Graphics2D G;
    BasicStroke Thin;
    BasicStroke Normal;
    BasicStroke Thick;
    BasicStroke SuperThick;
    AlphaComposite C;
    AlphaComposite CO;
    Component ZC = null;
    LatexOutput LOut;
    int[] xx = new int[64];
    int[] yy = new int[64];
    FontStruct FS = new FontStruct();
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);
    int StrH = 0;
    int StrW = 0;
    int StrAsc = 0;
    boolean StrTex = false;
    String Str = null;
    sHotEqn HE = null;

    public MyGraphics13(Graphics graphics, double d2, Component component, LatexOutput latexOutput) {
        this.LOut = latexOutput;
        this.G = (Graphics2D)graphics;
        if (Global.getParameter("quality", true)) {
            this.G.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.G.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.G.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.G.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        float[] fArray = new float[]{(float)(d2 * 15.0), (float)(d2 * 15.0)};
        if (d2 < Global.getParameter("minlinesize", 1.0)) {
            d2 = Global.getParameter("minlinesize", 1.0);
        }
        this.Thin = new BasicStroke((float)(d2 * 2.0), 0, 0, 10.0f, fArray, 0.0f);
        this.Normal = new BasicStroke((float)d2);
        this.Thick = new BasicStroke((float)(d2 * 4.0), 1, 0);
        this.SuperThick = new BasicStroke(20.0f, 1, 1);
        this.C = AlphaComposite.getInstance(3, 0.5f);
        this.CO = AlphaComposite.getInstance(3, 1.0f);
        this.G.setComposite(this.CO);
        this.ZC = component;
    }

    public MyGraphics13(Graphics graphics) {
        this(graphics, 0.5, null, null);
    }

    public MyGraphics13(Graphics graphics, Component component) {
        this(graphics, 0.5, component, null);
    }

    public MyGraphics13(Graphics graphics, double d2) {
        this(graphics, d2, null, null);
    }

    public void setColor(Color color) {
        this.G.setColor(color);
    }

    public void setColor(ConstructionObject constructionObject) {
        this.G.setStroke(this.Normal);
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (constructionObject.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.getColorType() == 2) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setColor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setColor(ZirkelFrame.Colors[n]);
            }
        }
        if (constructionObject.getColorType() == 2) {
            this.G.setStroke(this.Thin);
        } else if (constructionObject.getColorType() == 1) {
            this.G.setStroke(this.Thick);
        } else {
            this.G.setStroke(this.Normal);
        }
    }

    public void clearRect(int n, int n2, int n3, int n4, Color color) {
        this.G.setColor(color);
        this.G.fillRect(n, n2, n3, n4);
    }

    public void setFillColor(ConstructionObject constructionObject) {
        this.G.setStroke(this.Normal);
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject instanceof PointObject && constructionObject.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else {
            if (constructionObject.getColorType() != 1) {
                int n = constructionObject.getColorIndex();
                if (constructionObject.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterLightColors[n]);
                } else {
                    this.setColor(ZirkelFrame.LightColors[n]);
                }
            } else {
                int n = constructionObject.getColorIndex();
                if (constructionObject.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterColors[n]);
                } else {
                    this.setColor(ZirkelFrame.Colors[n]);
                }
            }
            if (constructionObject.getColorType() == 2) {
                this.G.setStroke(this.Thin);
            } else if (constructionObject.getColorType() == 1) {
                this.G.setStroke(this.Thick);
            } else {
                this.G.setStroke(this.Normal);
            }
        }
    }

    public void setLabelColor(ConstructionObject constructionObject) {
        if (constructionObject.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.isFilled()) {
            int n = constructionObject.getColorType();
            constructionObject.setColorType(0);
            this.setColor(constructionObject);
            constructionObject.setColorType(n);
        } else {
            this.setColor(constructionObject);
        }
    }

    public void drawRect(double d2, double d3, double d4, double d5) {
        if (this.test(d2) || this.test(d3) || this.test(d2 + d4) || this.test(d3 + d5)) {
            return;
        }
        this.G.setStroke(this.Normal);
        this.G.draw(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public void drawMarkerRect(double d2, double d3, double d4, double d5) {
        if (this.test(d2) || this.test(d3) || this.test(d2 + d4) || this.test(d3 + d5)) {
            return;
        }
        this.G.setColor(ZirkelFrame.IndicateColor);
        this.G.setStroke(this.SuperThick);
        this.G.draw(new Rectangle2D.Double(d2, d3, d4, d5));
        this.G.setStroke(this.Normal);
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.G.setStroke(this.Normal);
        this.G.draw(new Line2D.Double(d2, d3, d4, d5));
    }

    public void drawThickLine(double d2, double d3, double d4, double d5) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.G.setStroke(this.Thick);
        this.G.draw(new Line2D.Double(d2, d3, d4, d5));
        this.G.setStroke(this.Normal);
    }

    public void drawMarkerLine(double d2, double d3, double d4, double d5) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.G.setColor(ZirkelFrame.IndicateColor);
        this.G.setStroke(this.SuperThick);
        this.G.draw(new Line2D.Double(d2, d3, d4, d5));
        this.G.setStroke(this.Normal);
    }

    public void drawLine(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.G.draw(new Line2D.Double(d2, d3, d4, d5));
    }

    public boolean test(double d2) {
        return Math.abs(d2) > 100000.0;
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.G.setStroke(this.Normal);
        this.G.draw(new Arc2D.Double(d2, d3, d4, d5, d6, d7, 0));
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7, ConstructionObject constructionObject) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.G.draw(new Arc2D.Double(d2, d3, d4, d5, d6, d7, 0));
    }

    public FontMetrics getFontMetrics() {
        return this.G.getFontMetrics();
    }

    public void drawString(String string, double d2, double d3) {
        if (this.test(d2) || this.test(d3)) {
            return;
        }
        this.G.drawString(string, (float)d2, (float)d3);
    }

    public void drawOval(double d2, double d3, double d4, double d5) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.G.setStroke(this.Normal);
        this.G.draw(new Ellipse2D.Double(d2, d3, d4, d5));
    }

    public void drawOval(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.G.draw(new Ellipse2D.Double(d2, d3, d4, d5));
    }

    public void drawCircle(double d2, double d3, double d4, ConstructionObject constructionObject) {
        if (d4 > 10.0 * (this.W + this.H)) {
            this.drawLargeCircleArc(d2, d3, d4, 0.0, 360.0);
        } else {
            this.G.draw(new Ellipse2D.Double(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4));
        }
    }

    public void drawMarkerArc(double d2, double d3, double d4, double d5, double d6) {
        if (this.test(d2) || this.test(d3) || this.test(d4)) {
            return;
        }
        this.G.setColor(ZirkelFrame.IndicateColor);
        this.G.setStroke(this.SuperThick);
        this.G.draw(new Arc2D.Double(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4, d5, d6, 0));
    }

    public void drawCircleArc(double d2, double d3, double d4, double d5, double d6, ConstructionObject constructionObject) {
        if (d4 > 10.0 * (this.W + this.H)) {
            this.drawLargeCircleArc(d2, d3, d4, d5, d6);
        } else {
            this.G.draw(new Arc2D.Double(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4, d5, d6, 0));
        }
    }

    void drawLargeCircleArc(double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sqrt((this.W + this.H) / d4 / 10.0);
        double d8 = d5;
        double d9 = d2 + d4 * Math.cos(d8 / 180.0 * Math.PI);
        double d10 = d3 - d4 * Math.sin(d8 / 180.0 * Math.PI);
        d8 += d7;
        while (d8 < d5 + d6 + d7) {
            double d11;
            double d12;
            double d13;
            double d14;
            if (d8 > d5 + d6) {
                d8 = d5 + d6;
            }
            if (Math.sqrt((d14 = (d9 + (d13 = d2 + d4 * Math.cos(d8 / 180.0 * Math.PI))) / 2.0) * d14 + (d12 = (d10 + (d11 = d3 - d4 * Math.sin(d8 / 180.0 * Math.PI))) / 2.0) * d12) <= 10.0 * (this.W + this.H)) {
                this.G.draw(new Line2D.Double(d9, d10, d13, d11));
            }
            d9 = d13;
            d10 = d11;
            d8 += d7;
        }
    }

    public void fillRect(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.setFillColor(constructionObject);
        if (bl2 && !constructionObject.isSolid()) {
            this.G.setComposite(this.C);
        }
        this.G.fill(new Rectangle2D.Double(d2, d3, d4, d5));
        if (bl2 && !constructionObject.isSolid()) {
            this.G.setComposite(this.CO);
        }
        if (bl) {
            this.setColor(constructionObject);
            this.G.draw(new Rectangle2D.Double(d2, d3, d4, d5));
        }
    }

    public void fillOval(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        if (constructionObject.getColorType() != 3) {
            this.setFillColor(constructionObject);
            if (bl2 && !constructionObject.isSolid()) {
                this.G.setComposite(this.C);
            }
            try {
                this.G.fill(new Ellipse2D.Double(d2, d3, d4, d5));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl2 && !constructionObject.isSolid()) {
                this.G.setComposite(this.CO);
            }
        }
        if (bl) {
            this.setColor(constructionObject);
            this.drawOval(d2, d3, d4, d5);
        }
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, boolean bl3, ConstructionObject constructionObject) {
        if (this.test(d2) || this.test(d3) || this.test(d4) || this.test(d5)) {
            return;
        }
        this.setFillColor(constructionObject);
        if (bl2 && !constructionObject.isSolid()) {
            this.G.setComposite(this.C);
        }
        Arc2D.Double double_ = new Arc2D.Double(d2, d3, d4, d5, d6, d7, bl3 ? 2 : 1);
        this.G.fill(double_);
        if (bl2 && !constructionObject.isSolid()) {
            this.G.setComposite(this.CO);
        }
        if (bl) {
            this.setColor(constructionObject);
            double_.setArcType(0);
            this.G.setStroke(this.Normal);
            this.G.draw(double_);
        }
    }

    public void fillPolygon(double[] dArray, double[] dArray2, int n, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        int n2;
        if (constructionObject.getColorType() != 3) {
            this.setFillColor(constructionObject);
            if (bl2 && !constructionObject.isSolid()) {
                this.G.setComposite(this.C);
            }
        }
        if (n > this.xx.length) {
            this.xx = new int[n];
            this.yy = new int[n];
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.xx[n2] = (int)dArray[n2];
            if (this.test(dArray[n2])) {
                return;
            }
            this.yy[n2] = (int)dArray2[n2];
            if (!this.test(dArray2[n2])) continue;
            return;
        }
        if (constructionObject.getColorType() != 3) {
            this.G.fillPolygon(this.xx, this.yy, n);
            if (bl2 && !constructionObject.isSolid()) {
                this.G.setComposite(this.CO);
            }
        }
        if (bl) {
            this.setColor(constructionObject);
            this.G.setStroke(this.Normal);
            for (n2 = 0; n2 < n - 1; ++n2) {
                this.drawLine(this.xx[n2], this.yy[n2], this.xx[n2 + 1], this.yy[n2 + 1]);
            }
            this.drawLine(this.xx[n - 1], this.yy[n - 1], this.xx[0], this.yy[0]);
        }
    }

    public void drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.G.drawImage(image, n, n2, imageObserver);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.G.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public void setFont(int n, boolean bl) {
        Font font = this.FS.getFont(n, bl);
        if (font != null) {
            this.G.setFont(font);
        } else {
            font = new Font(Global.getParameter("font.name", "dialog"), bl ? 1 : 0, n);
            this.FS.storeFont(n, bl, font);
            this.G.setFont(font);
        }
    }

    public void setDefaultFont(int n, boolean bl, boolean bl2) {
        this.ffactor = Global.getParameter("ffactor", 130);
        this.fsize = n;
        this.flarge = bl;
        this.fbold = bl2;
        this.setFont(bl, bl2);
    }

    public void setFont(boolean bl, boolean bl2) {
        int n = this.fsize;
        if (bl) {
            n = n * this.ffactor / 100;
        }
        if (this.flarge) {
            n = n * this.ffactor / 100;
        }
        this.setFont(n, bl2 || this.fbold);
    }

    public void drawImage(Image image, double d2, double d3, double d4, double d5, double d6, double d7, ImageObserver imageObserver) {
        try {
            int n = image.getWidth(imageObserver);
            int n2 = image.getHeight(imageObserver);
            AffineTransform affineTransform = new AffineTransform((d4 - d2) / (double)n, (d5 - d3) / (double)n, (d6 - d2) / (double)n2, (d7 - d3) / (double)n2, d2, d3);
            this.G.drawImage(image, affineTransform, imageObserver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Graphics getGraphics() {
        return this.G;
    }

    public void computeString(String string) {
        if (string.equals(this.Str)) {
            return;
        }
        this.StrAsc = 0;
        this.StrW = 0;
        this.StrH = 0;
        this.StrTex = false;
        this.Str = string;
        while (string != "") {
            int n = string.indexOf(36);
            while (n > 0 && string.charAt(n - 1) == '\\') {
                n = string.indexOf(36, n + 1);
            }
            if (n < 0) {
                this.StrH = Math.max(this.StrH, this.getFontMetrics().getHeight());
                this.StrW += this.getFontMetrics().stringWidth(string);
                this.StrAsc = Math.max(this.StrAsc, this.getFontMetrics().getAscent());
                break;
            }
            this.StrTex = true;
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            this.StrH = Math.max(this.StrH, this.getFontMetrics().getHeight());
            this.StrW += this.getFontMetrics().stringWidth(string2);
            this.StrAsc = Math.max(this.StrAsc, this.getFontMetrics().getAscent());
            n = string.indexOf(36);
            while (n > 0 && string.charAt(n - 1) == '\\') {
                n = string.indexOf(36, n + 1);
            }
            string2 = string;
            if (n >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string = "";
            }
            if (this.HE == null || !this.HE.getEquation().equals(string2)) {
                this.setHotEqn(string2);
            }
            this.StrH = Math.max(this.StrH, this.heightHotEqn(this.G));
            this.StrW += this.widthHotEqn(this.G);
            this.StrAsc = Math.max(this.StrAsc, this.ascentHotEqn(this.G));
        }
    }

    public int stringWidth(String string) {
        this.computeString(string);
        return this.StrW;
    }

    public int stringHeight(String string) {
        this.computeString(string);
        return this.StrH;
    }

    public boolean isTex(String string) {
        this.computeString(string);
        return this.StrTex;
    }

    public int drawStringExtended(String string, double d2, double d3) {
        if (string.startsWith("$$")) {
            if ((string = string.substring(2)).endsWith("$$")) {
                string = string.substring(0, string.length() - 2);
            }
            if (this.HE == null || !this.HE.getEquation().equals(string)) {
                this.setHotEqn(string);
            }
            if (this.LOut == null || !this.LOut.println("$$" + string + "$$", d2, d3 + (double)this.ascentHotEqn(this.G))) {
                return this.paintHotEqn((int)d2, (int)d3, this.G);
            }
            return this.heightHotEqn(this.G);
        }
        this.computeString(string);
        if (this.LOut != null) {
            if (this.StrTex && this.LOut.printDollar()) {
                this.LOut.println(string, d2, d3 + (double)this.StrAsc, true);
                return this.StrH;
            }
            if (!this.StrTex && this.LOut.println(string, d2, d3 + (double)this.StrAsc)) {
                return this.StrH;
            }
        }
        int n = 0;
        while (string != "") {
            int n2 = string.indexOf(36);
            while (n2 > 0 && string.charAt(n2 - 1) == '\\') {
                n2 = string.indexOf(36, n2 + 1);
            }
            if (n2 < 0) {
                this.drawString(this.translateDollar(string), d2 + (double)n, d3 + (double)this.StrAsc);
                n += this.getFontMetrics().stringWidth(string);
                break;
            }
            String string2 = string.substring(0, n2);
            string = string.substring(n2 + 1);
            this.drawString(this.translateDollar(string2), d2 + (double)n, d3 + (double)this.StrAsc);
            n += this.getFontMetrics().stringWidth(string2);
            n2 = string.indexOf(36);
            while (n2 > 0 && string.charAt(n2 - 1) == '\\') {
                n2 = string.indexOf(36, n2 + 1);
            }
            string2 = string;
            if (n2 >= 0) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                string = "";
            }
            if (this.HE == null || !this.HE.getEquation().equals(string2)) {
                this.setHotEqn(string2);
            }
            this.paintHotEqn((int)d2 + n, (int)d3 + this.StrAsc - this.ascentHotEqn(this.G), this.G);
            n += this.widthHotEqn(this.G);
        }
        return this.StrH;
    }

    public String translateDollar(String string) {
        int n;
        while ((n = string.indexOf("\\$")) >= 0) {
            string = string.substring(0, n) + "$" + string.substring(n + 2);
        }
        return string;
    }

    public int stringAscent(String string) {
        return this.getFontMetrics().getAscent();
    }

    public void setHotEqn(String string) {
        if (this.ZC == null) {
            return;
        }
        if (this.HE == null) {
            this.HE = new sHotEqn(this.ZC);
        }
        this.HE.setEquation(string);
    }

    public int paintHotEqn(int n, int n2, Graphics graphics) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.paint(n, n2, graphics);
    }

    public int heightHotEqn(Graphics graphics) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.getSizeof((String)this.HE.getEquation(), (Graphics)graphics).height;
    }

    public int ascentHotEqn(Graphics graphics) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.getAscent(this.HE.getEquation(), graphics);
    }

    public int widthHotEqn(Graphics graphics) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.getSizeof((String)this.HE.getEquation(), (Graphics)graphics).width;
    }
}

