/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
 *    2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/opcode.pl from its data.
 * Any changes made here will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADAV	 = 10,
	OP_PADHV	 = 11,
	OP_PADANY	 = 12,
	OP_PUSHRE	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_TRANSR	 = 36,
	OP_SASSIGN	 = 37,
	OP_AASSIGN	 = 38,
	OP_CHOP		 = 39,
	OP_SCHOP	 = 40,
	OP_CHOMP	 = 41,
	OP_SCHOMP	 = 42,
	OP_DEFINED	 = 43,
	OP_UNDEF	 = 44,
	OP_STUDY	 = 45,
	OP_POS		 = 46,
	OP_PREINC	 = 47,
	OP_I_PREINC	 = 48,
	OP_PREDEC	 = 49,
	OP_I_PREDEC	 = 50,
	OP_POSTINC	 = 51,
	OP_I_POSTINC	 = 52,
	OP_POSTDEC	 = 53,
	OP_I_POSTDEC	 = 54,
	OP_POW		 = 55,
	OP_MULTIPLY	 = 56,
	OP_I_MULTIPLY	 = 57,
	OP_DIVIDE	 = 58,
	OP_I_DIVIDE	 = 59,
	OP_MODULO	 = 60,
	OP_I_MODULO	 = 61,
	OP_REPEAT	 = 62,
	OP_ADD		 = 63,
	OP_I_ADD	 = 64,
	OP_SUBTRACT	 = 65,
	OP_I_SUBTRACT	 = 66,
	OP_CONCAT	 = 67,
	OP_STRINGIFY	 = 68,
	OP_LEFT_SHIFT	 = 69,
	OP_RIGHT_SHIFT	 = 70,
	OP_LT		 = 71,
	OP_I_LT		 = 72,
	OP_GT		 = 73,
	OP_I_GT		 = 74,
	OP_LE		 = 75,
	OP_I_LE		 = 76,
	OP_GE		 = 77,
	OP_I_GE		 = 78,
	OP_EQ		 = 79,
	OP_I_EQ		 = 80,
	OP_NE		 = 81,
	OP_I_NE		 = 82,
	OP_NCMP		 = 83,
	OP_I_NCMP	 = 84,
	OP_SLT		 = 85,
	OP_SGT		 = 86,
	OP_SLE		 = 87,
	OP_SGE		 = 88,
	OP_SEQ		 = 89,
	OP_SNE		 = 90,
	OP_SCMP		 = 91,
	OP_BIT_AND	 = 92,
	OP_BIT_XOR	 = 93,
	OP_BIT_OR	 = 94,
	OP_NEGATE	 = 95,
	OP_I_NEGATE	 = 96,
	OP_NOT		 = 97,
	OP_COMPLEMENT	 = 98,
	OP_SMARTMATCH	 = 99,
	OP_ATAN2	 = 100,
	OP_SIN		 = 101,
	OP_COS		 = 102,
	OP_RAND		 = 103,
	OP_SRAND	 = 104,
	OP_EXP		 = 105,
	OP_LOG		 = 106,
	OP_SQRT		 = 107,
	OP_INT		 = 108,
	OP_HEX		 = 109,
	OP_OCT		 = 110,
	OP_ABS		 = 111,
	OP_LENGTH	 = 112,
	OP_SUBSTR	 = 113,
	OP_VEC		 = 114,
	OP_INDEX	 = 115,
	OP_RINDEX	 = 116,
	OP_SPRINTF	 = 117,
	OP_FORMLINE	 = 118,
	OP_ORD		 = 119,
	OP_CHR		 = 120,
	OP_CRYPT	 = 121,
	OP_UCFIRST	 = 122,
	OP_LCFIRST	 = 123,
	OP_UC		 = 124,
	OP_LC		 = 125,
	OP_QUOTEMETA	 = 126,
	OP_RV2AV	 = 127,
	OP_AELEMFAST	 = 128,
	OP_AELEMFAST_LEX = 129,
	OP_AELEM	 = 130,
	OP_ASLICE	 = 131,
	OP_KVASLICE	 = 132,
	OP_AEACH	 = 133,
	OP_AKEYS	 = 134,
	OP_AVALUES	 = 135,
	OP_EACH		 = 136,
	OP_VALUES	 = 137,
	OP_KEYS		 = 138,
	OP_DELETE	 = 139,
	OP_EXISTS	 = 140,
	OP_RV2HV	 = 141,
	OP_HELEM	 = 142,
	OP_HSLICE	 = 143,
	OP_KVHSLICE	 = 144,
	OP_UNPACK	 = 145,
	OP_PACK		 = 146,
	OP_SPLIT	 = 147,
	OP_JOIN		 = 148,
	OP_LIST		 = 149,
	OP_LSLICE	 = 150,
	OP_ANONLIST	 = 151,
	OP_ANONHASH	 = 152,
	OP_SPLICE	 = 153,
	OP_PUSH		 = 154,
	OP_POP		 = 155,
	OP_SHIFT	 = 156,
	OP_UNSHIFT	 = 157,
	OP_SORT		 = 158,
	OP_REVERSE	 = 159,
	OP_GREPSTART	 = 160,
	OP_GREPWHILE	 = 161,
	OP_MAPSTART	 = 162,
	OP_MAPWHILE	 = 163,
	OP_RANGE	 = 164,
	OP_FLIP		 = 165,
	OP_FLOP		 = 166,
	OP_AND		 = 167,
	OP_OR		 = 168,
	OP_XOR		 = 169,
	OP_DOR		 = 170,
	OP_COND_EXPR	 = 171,
	OP_ANDASSIGN	 = 172,
	OP_ORASSIGN	 = 173,
	OP_DORASSIGN	 = 174,
	OP_METHOD	 = 175,
	OP_ENTERSUB	 = 176,
	OP_LEAVESUB	 = 177,
	OP_LEAVESUBLV	 = 178,
	OP_CALLER	 = 179,
	OP_WARN		 = 180,
	OP_DIE		 = 181,
	OP_RESET	 = 182,
	OP_LINESEQ	 = 183,
	OP_NEXTSTATE	 = 184,
	OP_DBSTATE	 = 185,
	OP_UNSTACK	 = 186,
	OP_ENTER	 = 187,
	OP_LEAVE	 = 188,
	OP_SCOPE	 = 189,
	OP_ENTERITER	 = 190,
	OP_ITER		 = 191,
	OP_ENTERLOOP	 = 192,
	OP_LEAVELOOP	 = 193,
	OP_RETURN	 = 194,
	OP_LAST		 = 195,
	OP_NEXT		 = 196,
	OP_REDO		 = 197,
	OP_DUMP		 = 198,
	OP_GOTO		 = 199,
	OP_EXIT		 = 200,
	OP_METHOD_NAMED	 = 201,
	OP_ENTERGIVEN	 = 202,
	OP_LEAVEGIVEN	 = 203,
	OP_ENTERWHEN	 = 204,
	OP_LEAVEWHEN	 = 205,
	OP_BREAK	 = 206,
	OP_CONTINUE	 = 207,
	OP_OPEN		 = 208,
	OP_CLOSE	 = 209,
	OP_PIPE_OP	 = 210,
	OP_FILENO	 = 211,
	OP_UMASK	 = 212,
	OP_BINMODE	 = 213,
	OP_TIE		 = 214,
	OP_UNTIE	 = 215,
	OP_TIED		 = 216,
	OP_DBMOPEN	 = 217,
	OP_DBMCLOSE	 = 218,
	OP_SSELECT	 = 219,
	OP_SELECT	 = 220,
	OP_GETC		 = 221,
	OP_READ		 = 222,
	OP_ENTERWRITE	 = 223,
	OP_LEAVEWRITE	 = 224,
	OP_PRTF		 = 225,
	OP_PRINT	 = 226,
	OP_SAY		 = 227,
	OP_SYSOPEN	 = 228,
	OP_SYSSEEK	 = 229,
	OP_SYSREAD	 = 230,
	OP_SYSWRITE	 = 231,
	OP_EOF		 = 232,
	OP_TELL		 = 233,
	OP_SEEK		 = 234,
	OP_TRUNCATE	 = 235,
	OP_FCNTL	 = 236,
	OP_IOCTL	 = 237,
	OP_FLOCK	 = 238,
	OP_SEND		 = 239,
	OP_RECV		 = 240,
	OP_SOCKET	 = 241,
	OP_SOCKPAIR	 = 242,
	OP_BIND		 = 243,
	OP_CONNECT	 = 244,
	OP_LISTEN	 = 245,
	OP_ACCEPT	 = 246,
	OP_SHUTDOWN	 = 247,
	OP_GSOCKOPT	 = 248,
	OP_SSOCKOPT	 = 249,
	OP_GETSOCKNAME	 = 250,
	OP_GETPEERNAME	 = 251,
	OP_LSTAT	 = 252,
	OP_STAT		 = 253,
	OP_FTRREAD	 = 254,
	OP_FTRWRITE	 = 255,
	OP_FTREXEC	 = 256,
	OP_FTEREAD	 = 257,
	OP_FTEWRITE	 = 258,
	OP_FTEEXEC	 = 259,
	OP_FTIS		 = 260,
	OP_FTSIZE	 = 261,
	OP_FTMTIME	 = 262,
	OP_FTATIME	 = 263,
	OP_FTCTIME	 = 264,
	OP_FTROWNED	 = 265,
	OP_FTEOWNED	 = 266,
	OP_FTZERO	 = 267,
	OP_FTSOCK	 = 268,
	OP_FTCHR	 = 269,
	OP_FTBLK	 = 270,
	OP_FTFILE	 = 271,
	OP_FTDIR	 = 272,
	OP_FTPIPE	 = 273,
	OP_FTSUID	 = 274,
	OP_FTSGID	 = 275,
	OP_FTSVTX	 = 276,
	OP_FTLINK	 = 277,
	OP_FTTTY	 = 278,
	OP_FTTEXT	 = 279,
	OP_FTBINARY	 = 280,
	OP_CHDIR	 = 281,
	OP_CHOWN	 = 282,
	OP_CHROOT	 = 283,
	OP_UNLINK	 = 284,
	OP_CHMOD	 = 285,
	OP_UTIME	 = 286,
	OP_RENAME	 = 287,
	OP_LINK		 = 288,
	OP_SYMLINK	 = 289,
	OP_READLINK	 = 290,
	OP_MKDIR	 = 291,
	OP_RMDIR	 = 292,
	OP_OPEN_DIR	 = 293,
	OP_READDIR	 = 294,
	OP_TELLDIR	 = 295,
	OP_SEEKDIR	 = 296,
	OP_REWINDDIR	 = 297,
	OP_CLOSEDIR	 = 298,
	OP_FORK		 = 299,
	OP_WAIT		 = 300,
	OP_WAITPID	 = 301,
	OP_SYSTEM	 = 302,
	OP_EXEC		 = 303,
	OP_KILL		 = 304,
	OP_GETPPID	 = 305,
	OP_GETPGRP	 = 306,
	OP_SETPGRP	 = 307,
	OP_GETPRIORITY	 = 308,
	OP_SETPRIORITY	 = 309,
	OP_TIME		 = 310,
	OP_TMS		 = 311,
	OP_LOCALTIME	 = 312,
	OP_GMTIME	 = 313,
	OP_ALARM	 = 314,
	OP_SLEEP	 = 315,
	OP_SHMGET	 = 316,
	OP_SHMCTL	 = 317,
	OP_SHMREAD	 = 318,
	OP_SHMWRITE	 = 319,
	OP_MSGGET	 = 320,
	OP_MSGCTL	 = 321,
	OP_MSGSND	 = 322,
	OP_MSGRCV	 = 323,
	OP_SEMOP	 = 324,
	OP_SEMGET	 = 325,
	OP_SEMCTL	 = 326,
	OP_REQUIRE	 = 327,
	OP_DOFILE	 = 328,
	OP_HINTSEVAL	 = 329,
	OP_ENTEREVAL	 = 330,
	OP_LEAVEEVAL	 = 331,
	OP_ENTERTRY	 = 332,
	OP_LEAVETRY	 = 333,
	OP_GHBYNAME	 = 334,
	OP_GHBYADDR	 = 335,
	OP_GHOSTENT	 = 336,
	OP_GNBYNAME	 = 337,
	OP_GNBYADDR	 = 338,
	OP_GNETENT	 = 339,
	OP_GPBYNAME	 = 340,
	OP_GPBYNUMBER	 = 341,
	OP_GPROTOENT	 = 342,
	OP_GSBYNAME	 = 343,
	OP_GSBYPORT	 = 344,
	OP_GSERVENT	 = 345,
	OP_SHOSTENT	 = 346,
	OP_SNETENT	 = 347,
	OP_SPROTOENT	 = 348,
	OP_SSERVENT	 = 349,
	OP_EHOSTENT	 = 350,
	OP_ENETENT	 = 351,
	OP_EPROTOENT	 = 352,
	OP_ESERVENT	 = 353,
	OP_GPWNAM	 = 354,
	OP_GPWUID	 = 355,
	OP_GPWENT	 = 356,
	OP_SPWENT	 = 357,
	OP_EPWENT	 = 358,
	OP_GGRNAM	 = 359,
	OP_GGRGID	 = 360,
	OP_GGRENT	 = 361,
	OP_SGRENT	 = 362,
	OP_EGRENT	 = 363,
	OP_GETLOGIN	 = 364,
	OP_SYSCALL	 = 365,
	OP_LOCK		 = 366,
	OP_ONCE		 = 367,
	OP_CUSTOM	 = 368,
	OP_REACH	 = 369,
	OP_RKEYS	 = 370,
	OP_RVALUES	 = 371,
	OP_COREARGS	 = 372,
	OP_RUNCV	 = 373,
	OP_FC		 = 374,
	OP_PADCV	 = 375,
	OP_INTROCV	 = 376,
	OP_CLONECV	 = 377,
	OP_PADRANGE	 = 378,
	OP_max		
} opcode;

#define MAXO 379
#define OP_FREED MAXO

/* the OP_IS_* macros are optimized to a simple range check because
    all the member OPs are contiguous in regen/opcodes table.
    opcode.pl verifies the range contiguity, or generates an OR-equals
    expression */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

#define OP_IS_NUMCOMPARE(op)	\
	((op) >= OP_LT && (op) <= OP_I_NCMP)

#define OP_IS_DIRHOP(op)	\
	((op) >= OP_READDIR && (op) <= OP_CLOSEDIR)

/* ex: set ro: */
