/* DO NOT EDIT! GENERATED AUTOMATICALLY! */
/* A GNU-like <stdio.h>.

   Copyright (C) 2004, 2007-2025 Free Software Foundation, Inc.

   This file is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   This file is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#if __GNUC__ >= 3
#pragma GCC system_header
#endif


#if defined __need_FILE || defined __need___FILE || defined _GL_ALREADY_INCLUDING_STDIO_H || defined _GL_SKIP_GNULIB_STDIO_H
/* Special invocation convention:
   - Inside glibc header files.
   - On OSF/1 5.1 we have a sequence of nested includes
     <stdio.h> -> <getopt.h> -> <ctype.h> -> <sys/localedef.h> ->
     <sys/lc_core.h> -> <nl_types.h> -> <mesg.h> -> <stdio.h>.
     In this situation, the functions are not yet declared, therefore we cannot
     provide the C++ aliases.  */

#include_next <stdio.h>

#else
/* Normal invocation convention.  */

#ifndef _GL_STDIO_H

/* Suppress macOS deprecation warnings for sprintf and vsprintf.  */
#if (defined __APPLE__ && defined __MACH__) && !defined _POSIX_C_SOURCE
# ifdef __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__
#  include <AvailabilityMacros.h>
# endif
# if (defined MAC_OS_X_VERSION_MIN_REQUIRED \
      && 130000 <= MAC_OS_X_VERSION_MIN_REQUIRED)
#  define _POSIX_C_SOURCE 200809L
#  define _GL_DEFINED__POSIX_C_SOURCE
# endif
#endif

#define _GL_ALREADY_INCLUDING_STDIO_H

/* The include_next requires a split double-inclusion guard.  */
#include_next <stdio.h>

#undef _GL_ALREADY_INCLUDING_STDIO_H

#ifdef _GL_DEFINED__POSIX_C_SOURCE
# undef _GL_DEFINED__POSIX_C_SOURCE
# undef _POSIX_C_SOURCE
#endif

#ifndef _GL_STDIO_H
#define _GL_STDIO_H

/* This file uses _GL_ATTRIBUTE_DEALLOC, _GL_ATTRIBUTE_FORMAT,
   _GL_ATTRIBUTE_MALLOC, _GL_ATTRIBUTE_NODISCARD, _GL_ATTRIBUTE_NOTHROW,
   GNULIB_POSIXCHECK, HAVE_RAW_DECL_*.  */
#if !_GL_CONFIG_H_INCLUDED
 #error "Please include config.h first."
#endif

/* Get va_list.  Needed on many systems, including glibc 2.8.  */
#include <stdarg.h>

#include <stddef.h>

/* Get off_t and ssize_t.  Needed on many systems, including glibc 2.8
   and eglibc 2.11.2.
   May also define off_t to a 64-bit type on native Windows.
   Also defines off64_t on macOS, NetBSD, OpenBSD, MSVC, Cygwin, Haiku.  */
#include <sys/types.h>

/* Solaris 10 and NetBSD 7.0 declare renameat in <unistd.h>, not in <stdio.h>.  */
/* But in any case avoid namespace pollution on glibc systems.  */
#if (0 || defined GNULIB_POSIXCHECK) && (defined __sun || defined __NetBSD__) \
    && ! defined __GLIBC__
# include <unistd.h>
#endif

/* Android 4.3 declares renameat in <sys/stat.h>, not in <stdio.h>.  */
/* But in any case avoid namespace pollution on glibc systems.  */
#if (0 || defined GNULIB_POSIXCHECK) && defined __ANDROID__ \
    && ! defined __GLIBC__
# include <sys/stat.h>
#endif

/* MSVC declares 'perror' in <stdlib.h>, not in <stdio.h>.  We must include
   it before we  #define perror rpl_perror.  */
/* But in any case avoid namespace pollution on glibc systems.  */
#if (0 || defined GNULIB_POSIXCHECK) \
    && (defined _WIN32 && ! defined __CYGWIN__) \
    && ! defined __GLIBC__
# include <stdlib.h>
#endif

/* MSVC declares 'remove' in <io.h>, not in <stdio.h>.  We must include
   it before we  #define remove rpl_remove.  */
/* MSVC declares 'rename' in <io.h>, not in <stdio.h>.  We must include
   it before we  #define rename rpl_rename.  */
/* But in any case avoid namespace pollution on glibc systems.  */
#if (0 || 0 || defined GNULIB_POSIXCHECK) \
    && (defined _WIN32 && ! defined __CYGWIN__) \
    && ! defined __GLIBC__
# include <io.h>
#endif


/* _GL_ATTRIBUTE_DEALLOC (F, I) declares that the function returns pointers
   that can be freed by passing them as the Ith argument to the
   function F.  */
#ifndef _GL_ATTRIBUTE_DEALLOC
# if __GNUC__ >= 11 && !defined __clang__
#  define _GL_ATTRIBUTE_DEALLOC(f, i) __attribute__ ((__malloc__ (f, i)))
# else
#  define _GL_ATTRIBUTE_DEALLOC(f, i)
# endif
#endif

/* The __attribute__ feature is available in gcc versions 2.5 and later.
   The __-protected variants of the attributes 'format' and 'printf' are
   accepted by gcc versions 2.6.4 (effectively 2.7) and later.
   We enable _GL_ATTRIBUTE_FORMAT only if these are supported too, because
   gnulib and libintl do '#define printf __printf__' when they override
   the 'printf' function.  */
#ifndef _GL_ATTRIBUTE_FORMAT
# if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7) || defined __clang__
#  define _GL_ATTRIBUTE_FORMAT(spec) __attribute__ ((__format__ spec))
# else
#  define _GL_ATTRIBUTE_FORMAT(spec) /* empty */
# endif
#endif

/* _GL_ATTRIBUTE_MALLOC declares that the function returns a pointer to freshly
   allocated memory.  */
#ifndef _GL_ATTRIBUTE_MALLOC
# if __GNUC__ >= 3 || defined __clang__
#  define _GL_ATTRIBUTE_MALLOC __attribute__ ((__malloc__))
# else
#  define _GL_ATTRIBUTE_MALLOC
# endif
#endif

/* _GL_ATTRIBUTE_NOTHROW declares that the function does not throw exceptions.
 */
#ifndef _GL_ATTRIBUTE_NOTHROW
# if defined __cplusplus
#  if (__GNUC__ + (__GNUC_MINOR__ >= 8) > 2) || __clang_major__ >= 4
#   if __cplusplus >= 201103L
#    define _GL_ATTRIBUTE_NOTHROW noexcept (true)
#   else
#    define _GL_ATTRIBUTE_NOTHROW throw ()
#   endif
#  else
#   define _GL_ATTRIBUTE_NOTHROW
#  endif
# else
#  if (__GNUC__ + (__GNUC_MINOR__ >= 3) > 3) || defined __clang__
#   define _GL_ATTRIBUTE_NOTHROW __attribute__ ((__nothrow__))
#  else
#   define _GL_ATTRIBUTE_NOTHROW
#  endif
# endif
#endif

/* An __attribute__ __format__ specifier for a function that takes a format
   string and arguments, where the format string directives are the ones
   standardized by ISO C99 and POSIX.
   _GL_ATTRIBUTE_SPEC_PRINTF_STANDARD  */
/* __gnu_printf__ is supported in GCC >= 4.4.  */
#if (__GNUC__ + (__GNUC_MINOR__ >= 4) > 4) && !defined __clang__
# define _GL_ATTRIBUTE_SPEC_PRINTF_STANDARD __gnu_printf__
#else
# define _GL_ATTRIBUTE_SPEC_PRINTF_STANDARD __printf__
#endif

/* An __attribute__ __format__ specifier for a function that takes a format
   string and arguments, where the format string directives are the ones of the
   system printf(), rather than the ones standardized by ISO C99 and POSIX.
   _GL_ATTRIBUTE_SPEC_PRINTF_SYSTEM  */
/* On mingw, Gnulib sets __USE_MINGW_ANSI_STDIO in order to get closer to
   the standards.  The macro GNULIB_PRINTF_ATTRIBUTE_FLAVOR_GNU indicates
   whether this change is effective.  On older mingw, it is not.  */
#if GNULIB_PRINTF_ATTRIBUTE_FLAVOR_GNU
# define _GL_ATTRIBUTE_SPEC_PRINTF_SYSTEM _GL_ATTRIBUTE_SPEC_PRINTF_STANDARD
#else
# define _GL_ATTRIBUTE_SPEC_PRINTF_SYSTEM __printf__
#endif

/* _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD
   indicates to GCC that the function takes a format string and arguments,
   where the format string directives are the ones standardized by ISO C99
   and POSIX.  */
#define _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD(formatstring_parameter, first_argument) \
  _GL_ATTRIBUTE_FORMAT ((_GL_ATTRIBUTE_SPEC_PRINTF_STANDARD, formatstring_parameter, first_argument))

/* _GL_ATTRIBUTE_FORMAT_PRINTF_SYSTEM is like _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD,
   except that it indicates to GCC that the supported format string directives
   are the ones of the system printf(), rather than the ones standardized by
   ISO C99 and POSIX.  */
#define _GL_ATTRIBUTE_FORMAT_PRINTF_SYSTEM(formatstring_parameter, first_argument) \
  _GL_ATTRIBUTE_FORMAT ((_GL_ATTRIBUTE_SPEC_PRINTF_SYSTEM, formatstring_parameter, first_argument))

/* _GL_ATTRIBUTE_FORMAT_SCANF
   indicates to GCC that the function takes a format string and arguments,
   where the format string directives are the ones standardized by ISO C99
   and POSIX.  */
#if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 4)
# define _GL_ATTRIBUTE_FORMAT_SCANF(formatstring_parameter, first_argument) \
   _GL_ATTRIBUTE_FORMAT ((__gnu_scanf__, formatstring_parameter, first_argument))
#else
# define _GL_ATTRIBUTE_FORMAT_SCANF(formatstring_parameter, first_argument) \
   _GL_ATTRIBUTE_FORMAT ((__scanf__, formatstring_parameter, first_argument))
#endif

/* _GL_ATTRIBUTE_FORMAT_SCANF_SYSTEM is like _GL_ATTRIBUTE_FORMAT_SCANF,
   except that it indicates to GCC that the supported format string directives
   are the ones of the system scanf(), rather than the ones standardized by
   ISO C99 and POSIX.  */
#define _GL_ATTRIBUTE_FORMAT_SCANF_SYSTEM(formatstring_parameter, first_argument) \
  _GL_ATTRIBUTE_FORMAT ((__scanf__, formatstring_parameter, first_argument))

/* The definitions of _GL_FUNCDECL_RPL etc. are copied here.  */
/* C++ compatible function declaration macros.
   Copyright (C) 2010-2025 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#ifndef _GL_CXXDEFS_H
#define _GL_CXXDEFS_H

/* Begin/end the GNULIB_NAMESPACE namespace.  */
#if defined __cplusplus && defined GNULIB_NAMESPACE
# define _GL_BEGIN_NAMESPACE namespace GNULIB_NAMESPACE {
# define _GL_END_NAMESPACE }
#else
# define _GL_BEGIN_NAMESPACE
# define _GL_END_NAMESPACE
#endif

/* The three most frequent use cases of these macros are:

   * For providing a substitute for a function that is missing on some
     platforms, but is declared and works fine on the platforms on which
     it exists:

       #if @GNULIB_FOO@
       # if !@HAVE_FOO@
       _GL_FUNCDECL_SYS (foo, ...);
       # endif
       _GL_CXXALIAS_SYS (foo, ...);
       _GL_CXXALIASWARN (foo);
       #elif defined GNULIB_POSIXCHECK
       ...
       #endif

   * For providing a replacement for a function that exists on all platforms,
     but is broken/insufficient and needs to be replaced on some platforms:

       #if @GNULIB_FOO@
       # if @REPLACE_FOO@
       #  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
       #   undef foo
       #   define foo rpl_foo
       #  endif
       _GL_FUNCDECL_RPL (foo, ...);
       _GL_CXXALIAS_RPL (foo, ...);
       # else
       _GL_CXXALIAS_SYS (foo, ...);
       # endif
       _GL_CXXALIASWARN (foo);
       #elif defined GNULIB_POSIXCHECK
       ...
       #endif

   * For providing a replacement for a function that exists on some platforms
     but is broken/insufficient and needs to be replaced on some of them and
     is additionally either missing or undeclared on some other platforms:

       #if @GNULIB_FOO@
       # if @REPLACE_FOO@
       #  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
       #   undef foo
       #   define foo rpl_foo
       #  endif
       _GL_FUNCDECL_RPL (foo, ...);
       _GL_CXXALIAS_RPL (foo, ...);
       # else
       #  if !@HAVE_FOO@   or   if !@HAVE_DECL_FOO@
       _GL_FUNCDECL_SYS (foo, ...);
       #  endif
       _GL_CXXALIAS_SYS (foo, ...);
       # endif
       _GL_CXXALIASWARN (foo);
       #elif defined GNULIB_POSIXCHECK
       ...
       #endif
*/

/* _GL_EXTERN_C declaration;
   performs the declaration with C linkage.  */
#if defined __cplusplus
# define _GL_EXTERN_C extern "C"
#else
# define _GL_EXTERN_C extern
#endif

/* _GL_EXTERN_C_FUNC declaration;
   performs the declaration of a function with C linkage.  */
#if defined __cplusplus
# define _GL_EXTERN_C_FUNC extern "C"
#else
/* In C mode, omit the 'extern' keyword, because attributes in bracket syntax
   are not allowed between 'extern' and the return type (see gnulib-common.m4).
 */
# define _GL_EXTERN_C_FUNC
#endif

/* _GL_FUNCDECL_RPL (func, rettype, parameters, [attributes]);
   declares a replacement function, named rpl_func, with the given prototype,
   consisting of return type, parameters, and attributes.
   Although attributes are optional, the comma before them is required
   for portability to C17 and earlier.  The attribute _GL_ATTRIBUTE_NOTHROW,
   if needed, must be placed after the _GL_FUNCDECL_RPL invocation,
   at the end of the declaration.
   Examples:
     _GL_FUNCDECL_RPL (free, void, (void *ptr), ) _GL_ATTRIBUTE_NOTHROW;
     _GL_FUNCDECL_RPL (open, int, (const char *filename, int flags, ...),
                                  _GL_ARG_NONNULL ((1)));

   Note: Attributes, such as _GL_ATTRIBUTE_DEPRECATED, are supported in front
   of a _GL_FUNCDECL_RPL invocation only in C mode, not in C++ mode.  (That's
   because
     [[...]] extern "C" <declaration>;
   is invalid syntax in C++.)
 */
#define _GL_FUNCDECL_RPL(func,rettype,parameters,...) \
  _GL_FUNCDECL_RPL_1 (rpl_##func, rettype, parameters, __VA_ARGS__)
#define _GL_FUNCDECL_RPL_1(rpl_func,rettype,parameters,...) \
  _GL_EXTERN_C_FUNC __VA_ARGS__ rettype rpl_func parameters

/* _GL_FUNCDECL_SYS (func, rettype, parameters, [attributes]);
   declares the system function, named func, with the given prototype,
   consisting of return type, parameters, and attributes.
   Although attributes are optional, the comma before them is required
   for portability to C17 and earlier.  The attribute _GL_ATTRIBUTE_NOTHROW,
   if needed, must be placed after the _GL_FUNCDECL_RPL invocation,
   at the end of the declaration.
   Examples:
     _GL_FUNCDECL_SYS (getumask, mode_t, (void), ) _GL_ATTRIBUTE_NOTHROW;
     _GL_FUNCDECL_SYS (posix_openpt, int, (int flags), _GL_ATTRIBUTE_NODISCARD);
 */
#define _GL_FUNCDECL_SYS(func,rettype,parameters,...) \
  _GL_EXTERN_C_FUNC __VA_ARGS__ rettype func parameters

/* _GL_CXXALIAS_RPL (func, rettype, parameters);
   declares a C++ alias called GNULIB_NAMESPACE::func
   that redirects to rpl_func, if GNULIB_NAMESPACE is defined.
   Example:
     _GL_CXXALIAS_RPL (open, int, (const char *filename, int flags, ...));

   Wrapping rpl_func in an object with an inline conversion operator
   avoids a reference to rpl_func unless GNULIB_NAMESPACE::func is
   actually used in the program.  */
#define _GL_CXXALIAS_RPL(func,rettype,parameters) \
  _GL_CXXALIAS_RPL_1 (func, rpl_##func, rettype, parameters)
#if defined __cplusplus && defined GNULIB_NAMESPACE
# define _GL_CXXALIAS_RPL_1(func,rpl_func,rettype,parameters) \
    namespace GNULIB_NAMESPACE                                \
    {                                                         \
      static const struct _gl_ ## func ## _wrapper            \
      {                                                       \
        typedef rettype (*type) parameters;                   \
                                                              \
        inline operator type () const                         \
        {                                                     \
          return ::rpl_func;                                  \
        }                                                     \
      } func = {};                                            \
    }                                                         \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#else
# define _GL_CXXALIAS_RPL_1(func,rpl_func,rettype,parameters) \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#endif

/* _GL_CXXALIAS_MDA (func, rettype, parameters);
   is to be used when func is a Microsoft deprecated alias, on native Windows.
   It declares a C++ alias called GNULIB_NAMESPACE::func
   that redirects to _func, if GNULIB_NAMESPACE is defined.
   Example:
     _GL_CXXALIAS_MDA (open, int, (const char *filename, int flags, ...));
 */
#define _GL_CXXALIAS_MDA(func,rettype,parameters) \
  _GL_CXXALIAS_RPL_1 (func, _##func, rettype, parameters)

/* _GL_CXXALIAS_RPL_CAST_1 (func, rpl_func, rettype, parameters);
   is like  _GL_CXXALIAS_RPL_1 (func, rpl_func, rettype, parameters);
   except that the C function rpl_func may have a slightly different
   declaration.  A cast is used to silence the "invalid conversion" error
   that would otherwise occur.  */
#if defined __cplusplus && defined GNULIB_NAMESPACE
# define _GL_CXXALIAS_RPL_CAST_1(func,rpl_func,rettype,parameters) \
    namespace GNULIB_NAMESPACE                                     \
    {                                                              \
      static const struct _gl_ ## func ## _wrapper                 \
      {                                                            \
        typedef rettype (*type) parameters;                        \
                                                                   \
        inline operator type () const                              \
        {                                                          \
          return reinterpret_cast<type>(::rpl_func);               \
        }                                                          \
      } func = {};                                                 \
    }                                                              \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#else
# define _GL_CXXALIAS_RPL_CAST_1(func,rpl_func,rettype,parameters) \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#endif

/* _GL_CXXALIAS_MDA_CAST (func, rettype, parameters);
   is like  _GL_CXXALIAS_MDA (func, rettype, parameters);
   except that the C function func may have a slightly different declaration.
   A cast is used to silence the "invalid conversion" error that would
   otherwise occur.  */
#define _GL_CXXALIAS_MDA_CAST(func,rettype,parameters) \
  _GL_CXXALIAS_RPL_CAST_1 (func, _##func, rettype, parameters)

/* _GL_CXXALIAS_SYS (func, rettype, parameters);
   declares a C++ alias called GNULIB_NAMESPACE::func
   that redirects to the system provided function func, if GNULIB_NAMESPACE
   is defined.
   Example:
     _GL_CXXALIAS_SYS (open, int, (const char *filename, int flags, ...));

   Wrapping func in an object with an inline conversion operator
   avoids a reference to func unless GNULIB_NAMESPACE::func is
   actually used in the program.  */
#if defined __cplusplus && defined GNULIB_NAMESPACE
# define _GL_CXXALIAS_SYS(func,rettype,parameters)            \
    namespace GNULIB_NAMESPACE                                \
    {                                                         \
      static const struct _gl_ ## func ## _wrapper            \
      {                                                       \
        typedef rettype (*type) parameters;                   \
                                                              \
        inline operator type () const                         \
        {                                                     \
          return ::func;                                      \
        }                                                     \
      } func = {};                                            \
    }                                                         \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#else
# define _GL_CXXALIAS_SYS(func,rettype,parameters) \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#endif

/* _GL_CXXALIAS_SYS_CAST (func, rettype, parameters);
   is like  _GL_CXXALIAS_SYS (func, rettype, parameters);
   except that the C function func may have a slightly different declaration.
   A cast is used to silence the "invalid conversion" error that would
   otherwise occur.  */
#if defined __cplusplus && defined GNULIB_NAMESPACE
# define _GL_CXXALIAS_SYS_CAST(func,rettype,parameters) \
    namespace GNULIB_NAMESPACE                          \
    {                                                   \
      static const struct _gl_ ## func ## _wrapper      \
      {                                                 \
        typedef rettype (*type) parameters;             \
                                                        \
        inline operator type () const                   \
        {                                               \
          return reinterpret_cast<type>(::func);        \
        }                                               \
      } func = {};                                      \
    }                                                   \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#else
# define _GL_CXXALIAS_SYS_CAST(func,rettype,parameters) \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#endif

/* _GL_CXXALIAS_SYS_CAST2 (func, rettype, parameters, rettype2, parameters2);
   is like  _GL_CXXALIAS_SYS (func, rettype, parameters);
   except that the C function is picked among a set of overloaded functions,
   namely the one with rettype2 and parameters2.  Two consecutive casts
   are used to silence the "cannot find a match" and "invalid conversion"
   errors that would otherwise occur.  */
#if defined __cplusplus && defined GNULIB_NAMESPACE
  /* The outer cast must be a reinterpret_cast.
     The inner cast: When the function is defined as a set of overloaded
     functions, it works as a static_cast<>, choosing the designated variant.
     When the function is defined as a single variant, it works as a
     reinterpret_cast<>. The parenthesized cast syntax works both ways.  */
# define _GL_CXXALIAS_SYS_CAST2(func,rettype,parameters,rettype2,parameters2) \
    namespace GNULIB_NAMESPACE                                                \
    {                                                                         \
      static const struct _gl_ ## func ## _wrapper                            \
      {                                                                       \
        typedef rettype (*type) parameters;                                   \
                                                                              \
        inline operator type () const                                         \
        {                                                                     \
          return reinterpret_cast<type>((rettype2 (*) parameters2)(::func));  \
        }                                                                     \
      } func = {};                                                            \
    }                                                                         \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#else
# define _GL_CXXALIAS_SYS_CAST2(func,rettype,parameters,rettype2,parameters2) \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#endif

/* _GL_CXXALIASWARN (func);
   causes a warning to be emitted when ::func is used but not when
   GNULIB_NAMESPACE::func is used.  func must be defined without overloaded
   variants.  */
#if defined __cplusplus && defined GNULIB_NAMESPACE
# define _GL_CXXALIASWARN(func) \
   _GL_CXXALIASWARN_1 (func, GNULIB_NAMESPACE)
# define _GL_CXXALIASWARN_1(func,namespace) \
   _GL_CXXALIASWARN_2 (func, namespace)
/* To work around GCC bug <https://gcc.gnu.org/bugzilla/show_bug.cgi?id=43881>,
   we enable the warning only when not optimizing.  */
# if !(defined __GNUC__ && !defined __clang__ && __OPTIMIZE__)
#  define _GL_CXXALIASWARN_2(func,namespace) \
    _GL_WARN_ON_USE (func, \
                     "The symbol ::" #func " refers to the system function. " \
                     "Use " #namespace "::" #func " instead.")
# elif (__GNUC__ >= 3 || defined __clang__) && GNULIB_STRICT_CHECKING
#  define _GL_CXXALIASWARN_2(func,namespace) \
     extern __typeof__ (func) func
# else
#  define _GL_CXXALIASWARN_2(func,namespace) \
     _GL_EXTERN_C int _gl_cxxalias_dummy
# endif
#else
# define _GL_CXXALIASWARN(func) \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#endif

/* _GL_CXXALIASWARN1 (func, rettype, parameters_and_attributes);
   causes a warning to be emitted when the given overloaded variant of ::func
   is used but not when GNULIB_NAMESPACE::func is used.  */
#if defined __cplusplus && defined GNULIB_NAMESPACE
# define _GL_CXXALIASWARN1(func,rettype,parameters_and_attributes) \
   _GL_CXXALIASWARN1_1 (func, rettype, parameters_and_attributes, \
                        GNULIB_NAMESPACE)
# define _GL_CXXALIASWARN1_1(func,rettype,parameters_and_attributes,namespace) \
   _GL_CXXALIASWARN1_2 (func, rettype, parameters_and_attributes, namespace)
/* To work around GCC bug <https://gcc.gnu.org/bugzilla/show_bug.cgi?id=43881>,
   we enable the warning only when not optimizing.  */
# if !(defined __GNUC__ && !defined __clang__ && __OPTIMIZE__)
#  define _GL_CXXALIASWARN1_2(func,rettype,parameters_and_attributes,namespace) \
    _GL_WARN_ON_USE_CXX (func, rettype, rettype, parameters_and_attributes, \
                         "The symbol ::" #func " refers to the system function. " \
                         "Use " #namespace "::" #func " instead.")
# else
#  define _GL_CXXALIASWARN1_2(func,rettype,parameters_and_attributes,namespace) \
     _GL_EXTERN_C int _gl_cxxalias_dummy
# endif
#else
# define _GL_CXXALIASWARN1(func,rettype,parameters_and_attributes) \
    _GL_EXTERN_C int _gl_cxxalias_dummy
#endif

#endif /* _GL_CXXDEFS_H */

/* The definition of _GL_ARG_NONNULL is copied here.  */
/* A C macro for declaring that specific arguments must not be NULL.
   Copyright (C) 2009-2025 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* _GL_ARG_NONNULL((n,...,m)) tells the compiler and static analyzer tools
   that the values passed as arguments n, ..., m must be non-NULL pointers.
   n = 1 stands for the first argument, n = 2 for the second argument etc.  */
#ifndef _GL_ARG_NONNULL
# if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 3) || defined __clang__
#  define _GL_ARG_NONNULL(params) __attribute__ ((__nonnull__ params))
# else
#  define _GL_ARG_NONNULL(params)
# endif
#endif

/* The definition of _GL_WARN_ON_USE is copied here.  */
/* A C macro for emitting warnings if a function is used.
   Copyright (C) 2010-2025 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* _GL_WARN_ON_USE (function, "literal string") issues a declaration
   for FUNCTION which will then trigger a compiler warning containing
   the text of "literal string" anywhere that function is called, if
   supported by the compiler.  If the compiler does not support this
   feature, the macro expands to an unused extern declaration.

   _GL_WARN_ON_USE_ATTRIBUTE ("literal string") expands to the
   attribute used in _GL_WARN_ON_USE.  If the compiler does not support
   this feature, it expands to empty.

   These macros are useful for marking a function as a potential
   portability trap, with the intent that "literal string" include
   instructions on the replacement function that should be used
   instead.
   _GL_WARN_ON_USE is for functions with 'extern' linkage.
   _GL_WARN_ON_USE_ATTRIBUTE is for functions with 'static' or 'inline'
   linkage.

   _GL_WARN_ON_USE should not be used more than once for a given function
   in a given compilation unit (because this may generate a warning even
   if the function is never called).

   However, one of the reasons that a function is a portability trap is
   if it has the wrong signature.  Declaring FUNCTION with a different
   signature in C is a compilation error, so this macro must use the
   same type as any existing declaration so that programs that avoid
   the problematic FUNCTION do not fail to compile merely because they
   included a header that poisoned the function.  But this implies that
   _GL_WARN_ON_USE is only safe to use if FUNCTION is known to already
   have a declaration.  Use of this macro implies that there must not
   be any other macro hiding the declaration of FUNCTION; but
   undefining FUNCTION first is part of the poisoning process anyway
   (although for symbols that are provided only via a macro, the result
   is a compilation error rather than a warning containing
   "literal string").  Also note that in C++, it is only safe to use if
   FUNCTION has no overloads.

   For an example, it is possible to poison 'getline' by:
   - adding a call to gl_WARN_ON_USE_PREPARE([[#include <stdio.h>]],
     [getline]) in configure.ac, which potentially defines
     HAVE_RAW_DECL_GETLINE
   - adding this code to a header that wraps the system <stdio.h>:
     #undef getline
     #if HAVE_RAW_DECL_GETLINE
     _GL_WARN_ON_USE (getline, "getline is required by POSIX 2008, but"
       "not universally present; use the gnulib module getline");
     #endif

   It is not possible to directly poison global variables.  But it is
   possible to write a wrapper accessor function, and poison that
   (less common usage, like &environ, will cause a compilation error
   rather than issue the nice warning, but the end result of informing
   the developer about their portability problem is still achieved):
     #if HAVE_RAW_DECL_ENVIRON
     static char ***
     rpl_environ (void) { return &environ; }
     _GL_WARN_ON_USE (rpl_environ, "environ is not always properly declared");
     # undef environ
     # define environ (*rpl_environ ())
     #endif
   or better (avoiding contradictory use of 'static' and 'extern'):
     #if HAVE_RAW_DECL_ENVIRON
     static char ***
     _GL_WARN_ON_USE_ATTRIBUTE ("environ is not always properly declared")
     rpl_environ (void) { return &environ; }
     # undef environ
     # define environ (*rpl_environ ())
     #endif
   */
#ifndef _GL_WARN_ON_USE

# if (4 < __GNUC__ || (__GNUC__ == 4 && 3 <= __GNUC_MINOR__)) && !defined __clang__
/* A compiler attribute is available in gcc versions 4.3.0 and later.  */
#  define _GL_WARN_ON_USE(function, message) \
_GL_WARN_EXTERN_C __typeof__ (function) function __attribute__ ((__warning__ (message)))
#  define _GL_WARN_ON_USE_ATTRIBUTE(message) \
  __attribute__ ((__warning__ (message)))
# elif __clang_major__ >= 4
/* Another compiler attribute is available in clang.  */
#  define _GL_WARN_ON_USE(function, message) \
_GL_WARN_EXTERN_C __typeof__ (function) function \
  __attribute__ ((__diagnose_if__ (1, message, "warning")))
#  define _GL_WARN_ON_USE_ATTRIBUTE(message) \
  __attribute__ ((__diagnose_if__ (1, message, "warning")))
# elif (__GNUC__ >= 3 || defined __clang__) && GNULIB_STRICT_CHECKING
/* Verify the existence of the function.  */
#  define _GL_WARN_ON_USE(function, message) \
_GL_WARN_EXTERN_C __typeof__ (function) function
#  define _GL_WARN_ON_USE_ATTRIBUTE(message)
# else /* Unsupported.  */
#  define _GL_WARN_ON_USE(function, message) \
_GL_WARN_EXTERN_C int _gl_warn_on_use
#  define _GL_WARN_ON_USE_ATTRIBUTE(message)
# endif
#endif

/* _GL_WARN_ON_USE_CXX (function, rettype_gcc, rettype_clang, parameters_and_attributes, "message")
   is like _GL_WARN_ON_USE (function, "message"), except that in C++ mode the
   function is declared with the given prototype, consisting of return type,
   parameters, and attributes.
   This variant is useful for overloaded functions in C++. _GL_WARN_ON_USE does
   not work in this case.  */
#ifndef _GL_WARN_ON_USE_CXX
# if !defined __cplusplus
#  define _GL_WARN_ON_USE_CXX(function,rettype_gcc,rettype_clang,parameters_and_attributes,msg) \
     _GL_WARN_ON_USE (function, msg)
# else
#  if (4 < __GNUC__ || (__GNUC__ == 4 && 3 <= __GNUC_MINOR__)) && !defined __clang__
/* A compiler attribute is available in gcc versions 4.3.0 and later.  */
#   define _GL_WARN_ON_USE_CXX(function,rettype_gcc,rettype_clang,parameters_and_attributes,msg) \
extern rettype_gcc function parameters_and_attributes \
  __attribute__ ((__warning__ (msg)))
#  elif __clang_major__ >= 4
/* Another compiler attribute is available in clang.  */
#   define _GL_WARN_ON_USE_CXX(function,rettype_gcc,rettype_clang,parameters_and_attributes,msg) \
extern rettype_clang function parameters_and_attributes \
  __attribute__ ((__diagnose_if__ (1, msg, "warning")))
#  elif (__GNUC__ >= 3 || defined __clang__) && GNULIB_STRICT_CHECKING
/* Verify the existence of the function.  */
#   define _GL_WARN_ON_USE_CXX(function,rettype_gcc,rettype_clang,parameters_and_attributes,msg) \
extern rettype_gcc function parameters_and_attributes
#  else /* Unsupported.  */
#   define _GL_WARN_ON_USE_CXX(function,rettype_gcc,rettype_clang,parameters_and_attributes,msg) \
_GL_WARN_EXTERN_C int _gl_warn_on_use
#  endif
# endif
#endif

/* _GL_WARN_EXTERN_C declaration;
   performs the declaration with C linkage.  */
#ifndef _GL_WARN_EXTERN_C
# if defined __cplusplus
#  define _GL_WARN_EXTERN_C extern "C"
# else
#  define _GL_WARN_EXTERN_C extern
# endif
#endif

/* Macros for stringification.  */
#define _GL_STDIO_STRINGIZE(token) #token
#define _GL_STDIO_MACROEXPAND_AND_STRINGIZE(token) _GL_STDIO_STRINGIZE(token)

/* When also using extern inline, suppress the use of static inline in
   standard headers of problematic Apple configurations, as Libc at
   least through Libc-825.26 (2013-04-09) mishandles it; see, e.g.,
   <https://lists.gnu.org/r/bug-gnulib/2012-12/msg00023.html>.
   Perhaps Apple will fix this some day.  */
#if (defined _GL_EXTERN_INLINE_IN_USE && defined __APPLE__ \
     && defined __GNUC__ && defined __STDC__)
# undef putc_unlocked
#endif


/* Maximum number of characters produced by printing a NaN value.  */
#ifndef _PRINTF_NAN_LEN_MAX
# if defined __FreeBSD__ || defined __DragonFly__ \
     || defined __NetBSD__ \
     || (defined __APPLE__ && defined __MACH__)
/* On BSD systems, a NaN value prints as just "nan", without a sign.  */
#  define _PRINTF_NAN_LEN_MAX 3
# elif (__GLIBC__ >= 2) || MUSL_LIBC || defined __OpenBSD__ || defined __sun || defined __CYGWIN__
/* glibc, musl libc, OpenBSD, Solaris libc, and Cygwin produce "[-]nan".  */
#  define _PRINTF_NAN_LEN_MAX 4
# elif defined _AIX
/* AIX produces "[-]NaNQ".  */
#  define _PRINTF_NAN_LEN_MAX 5
# elif defined _WIN32 && !defined __CYGWIN__
/* On native Windows, the output can be:
   - with MSVC ucrt: "[-]nan" or "[-]nan(ind)" or "[-]nan(snan)",
   - with mingw: "[-]1.#IND" or "[-]1.#QNAN".  */
#  define _PRINTF_NAN_LEN_MAX 10
# elif defined __sgi
/* On IRIX, the output typically is "[-]nan0xNNNNNNNN" with 8 hexadecimal
   digits.  */
#  define _PRINTF_NAN_LEN_MAX 14
# else
/* We don't know, but 32 should be a safe maximum.  */
#  define _PRINTF_NAN_LEN_MAX 32
# endif
#endif


#if 0
/* Prints formatted output to file descriptor FD.
   Returns the number of bytes written to the file descriptor.  Upon
   failure, returns -1 with errno set.
   Failure code EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure codes are ENOMEM
   and the possible failure codes from write(), excluding EINTR.  */
_GL_FUNCDECL_SYS (dzprintf, off64_t,
                  (int fd, const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((2)));
_GL_CXXALIAS_SYS (dzprintf, off64_t,
                  (int fd, const char *restrict format, ...));
#endif

#if 0
/* Prints formatted output to file descriptor FD.
   Returns the number of bytes written to the file descriptor.  Upon
   failure, returns a negative value.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define dprintf rpl_dprintf
#  endif
_GL_FUNCDECL_RPL (dprintf, int, (int fd, const char *restrict format, ...),
                                _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                                _GL_ARG_NONNULL ((2)));
_GL_CXXALIAS_RPL (dprintf, int, (int fd, const char *restrict format, ...));
# else
#  if !1
_GL_FUNCDECL_SYS (dprintf, int, (int fd, const char *restrict format, ...),
                                _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                                _GL_ARG_NONNULL ((2)));
#  endif
_GL_CXXALIAS_SYS (dprintf, int, (int fd, const char *restrict format, ...));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (dprintf);
# endif
#elif defined GNULIB_POSIXCHECK
# undef dprintf
# if HAVE_RAW_DECL_DPRINTF
_GL_WARN_ON_USE (dprintf, "dprintf is unportable - "
                 "use gnulib module dprintf for portability");
# endif
#endif

#if 0
/* Close STREAM and its underlying file descriptor.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define fclose rpl_fclose
#  endif
_GL_FUNCDECL_RPL (fclose, int, (FILE *stream), _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL (fclose, int, (FILE *stream));
# else
_GL_CXXALIAS_SYS (fclose, int, (FILE *stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fclose);
# endif
#elif defined GNULIB_POSIXCHECK
# undef fclose
/* Assume fclose is always declared.  */
_GL_WARN_ON_USE (fclose, "fclose is not always POSIX compliant - "
                 "use gnulib module fclose for portable POSIX compliance");
#endif

#if 1
/* On native Windows, map 'fcloseall' to '_fcloseall', so that -loldnames is
   not required.  In C++ with GNULIB_NAMESPACE, avoid differences between
   platforms by defining GNULIB_NAMESPACE::fcloseall on all platforms that have
   it.  */
# if defined _WIN32 && !defined __CYGWIN__
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fcloseall
#   define fcloseall _fcloseall
#  endif
_GL_CXXALIAS_MDA (fcloseall, int, (void));
# else
#  if 1
#   if defined __FreeBSD__ || defined __DragonFly__
_GL_CXXALIAS_SYS (fcloseall, void, (void));
#   else
_GL_CXXALIAS_SYS (fcloseall, int, (void));
#   endif
#  endif
# endif
# if (defined _WIN32 && !defined __CYGWIN__) || 1
_GL_CXXALIASWARN (fcloseall);
# endif
#endif

#if 0
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fdopen
#   define fdopen rpl_fdopen
#  endif
_GL_FUNCDECL_RPL (fdopen, FILE *,
                  (int fd, const char *mode),
                  _GL_ARG_NONNULL ((2)) _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                  _GL_ATTRIBUTE_MALLOC
                  _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (fdopen, FILE *, (int fd, const char *mode));
# elif defined _WIN32 && !defined __CYGWIN__
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fdopen
#   define fdopen _fdopen
#  endif
_GL_CXXALIAS_MDA (fdopen, FILE *, (int fd, const char *mode));
# else
#  if __GNUC__ >= 11 && !defined __clang__
/* For -Wmismatched-dealloc: Associate fdopen with fclose or rpl_fclose.  */
#   if __GLIBC__ + (__GLIBC_MINOR__ >= 2) > 2
_GL_FUNCDECL_SYS (fdopen, FILE *,
                  (int fd, const char *mode),
                  _GL_ARG_NONNULL ((2)) _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                  _GL_ATTRIBUTE_MALLOC
                  _GL_ATTRIBUTE_NODISCARD)
                  _GL_ATTRIBUTE_NOTHROW;
#   else
_GL_FUNCDECL_SYS (fdopen, FILE *,
                  (int fd, const char *mode),
                  _GL_ARG_NONNULL ((2)) _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                  _GL_ATTRIBUTE_MALLOC
                  _GL_ATTRIBUTE_NODISCARD);
#   endif
#  endif
_GL_CXXALIAS_SYS (fdopen, FILE *, (int fd, const char *mode));
# endif
_GL_CXXALIASWARN (fdopen);
#else
# if 0 && (__GNUC__ >= 11 && !defined __clang__) && !defined fdopen
/* For -Wmismatched-dealloc: Associate fdopen with fclose or rpl_fclose.  */
#  if __GLIBC__ + (__GLIBC_MINOR__ >= 2) > 2
_GL_FUNCDECL_SYS (fdopen, FILE *,
                  (int fd, const char *mode),
                  _GL_ARG_NONNULL ((2)) _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                  _GL_ATTRIBUTE_MALLOC)
                  _GL_ATTRIBUTE_NOTHROW;
#  else
_GL_FUNCDECL_SYS (fdopen, FILE *,
                  (int fd, const char *mode),
                  _GL_ARG_NONNULL ((2)) _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                  _GL_ATTRIBUTE_MALLOC);
#  endif
# endif
# if defined GNULIB_POSIXCHECK
#  undef fdopen
/* Assume fdopen is always declared.  */
_GL_WARN_ON_USE (fdopen, "fdopen on native Windows platforms is not POSIX compliant - "
                 "use gnulib module fdopen for portability");
# elif 1
/* On native Windows, map 'fdopen' to '_fdopen', so that -loldnames is not
   required.  In C++ with GNULIB_NAMESPACE, avoid differences between
   platforms by defining GNULIB_NAMESPACE::fdopen always.  */
#  if defined _WIN32 && !defined __CYGWIN__
#   if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#    undef fdopen
#    define fdopen _fdopen
#   endif
_GL_CXXALIAS_MDA (fdopen, FILE *, (int fd, const char *mode));
#  else
_GL_CXXALIAS_SYS (fdopen, FILE *, (int fd, const char *mode));
#  endif
_GL_CXXALIASWARN (fdopen);
# endif
#endif

#if 1
/* Flush all pending data on STREAM according to POSIX rules.  Both
   output and seekable input streams are supported.
   Note! LOSS OF DATA can occur if fflush is applied on an input stream
   that is _not_seekable_ or on an update stream that is _not_seekable_
   and in which the most recent operation was input.  Seekability can
   be tested with lseek(fileno(fp),0,SEEK_CUR).  */
# if 1
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define fflush rpl_fflush
#  endif
_GL_FUNCDECL_RPL (fflush, int, (FILE *gl_stream), );
_GL_CXXALIAS_RPL (fflush, int, (FILE *gl_stream));
# else
_GL_CXXALIAS_SYS (fflush, int, (FILE *gl_stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fflush);
# endif
#elif defined GNULIB_POSIXCHECK
# undef fflush
/* Assume fflush is always declared.  */
_GL_WARN_ON_USE (fflush, "fflush is not always POSIX compliant - "
                 "use gnulib module fflush for portable POSIX compliance");
#endif

#if 1
# if 0 && 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fgetc
#   define fgetc rpl_fgetc
#  endif
_GL_FUNCDECL_RPL (fgetc, int, (FILE *stream), _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL (fgetc, int, (FILE *stream));
# else
_GL_CXXALIAS_SYS (fgetc, int, (FILE *stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fgetc);
# endif
#endif

#if 1
# if 0 && 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fgets
#   define fgets rpl_fgets
#  endif
_GL_FUNCDECL_RPL (fgets, char *,
                  (char *restrict s, int n, FILE *restrict stream),
                  _GL_ARG_NONNULL ((1, 3)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (fgets, char *,
                  (char *restrict s, int n, FILE *restrict stream));
# else
_GL_CXXALIAS_SYS (fgets, char *,
                  (char *restrict s, int n, FILE *restrict stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fgets);
# endif
#endif

#if 1
/* On native Windows, map 'fileno' to '_fileno', so that -loldnames is not
   required.  In C++ with GNULIB_NAMESPACE, avoid differences between
   platforms by defining GNULIB_NAMESPACE::fileno always.  */
# if defined _WIN32 && !defined __CYGWIN__
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fileno
#   define fileno _fileno
#  endif
_GL_CXXALIAS_MDA (fileno, int, (FILE *restrict stream));
# else
_GL_CXXALIAS_SYS (fileno, int, (FILE *restrict stream));
# endif
_GL_CXXALIASWARN (fileno);
#endif

#if 0
# if (0 && 0) \
     || (0 && 0)
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fopen
#   define fopen rpl_fopen
#  endif
_GL_FUNCDECL_RPL (fopen, FILE *,
                  (const char *restrict filename, const char *restrict mode),
                  _GL_ARG_NONNULL ((1, 2)) _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                  _GL_ATTRIBUTE_MALLOC _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (fopen, FILE *,
                  (const char *restrict filename, const char *restrict mode));
# else
#  if __GNUC__ >= 11 && !defined __clang__
/* For -Wmismatched-dealloc: Associate fopen with fclose or rpl_fclose.  */
_GL_FUNCDECL_SYS (fopen, FILE *,
                  (const char *restrict filename, const char *restrict mode),
                  _GL_ARG_NONNULL ((1, 2)) _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                  _GL_ATTRIBUTE_NODISCARD);
#  endif
_GL_CXXALIAS_SYS (fopen, FILE *,
                  (const char *restrict filename, const char *restrict mode));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fopen);
# endif
#else
# if 0 && (__GNUC__ >= 11 && !defined __clang__) && !defined fopen
/* For -Wmismatched-dealloc: Associate fopen with fclose or rpl_fclose.  */
_GL_FUNCDECL_SYS (fopen, FILE *,
                  (const char *restrict filename, const char *restrict mode),
                  _GL_ARG_NONNULL ((1, 2)) _GL_ATTRIBUTE_DEALLOC (fclose, 1));
# endif
# if defined GNULIB_POSIXCHECK
#  undef fopen
/* Assume fopen is always declared.  */
_GL_WARN_ON_USE (fopen, "fopen on native Windows platforms is not POSIX compliant - "
                 "use gnulib module fopen for portability");
# endif
#endif

#if 0
/* Prints formatted output to stream FP.
   Returns the number of bytes written to the stream.  Upon failure,
   returns -1 with the stream's error indicator set.
   Failure cause EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure causes are ENOMEM
   and the possible failure causes from fwrite().  */
_GL_FUNCDECL_SYS (fzprintf, off64_t,
                  (FILE *restrict fp, const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_SYS (fzprintf, off64_t,
                  (FILE *restrict fp, const char *restrict format, ...));
#endif

#if 0 || 1
/* Prints formatted output to stream FP.
   Returns the number of bytes written to the stream.  Upon failure,
   returns a negative value with the stream's error indicator set.  */
# if (0 && 0) \
     || (1 && 0 && (0 || 0))
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define fprintf rpl_fprintf
#  endif
#  define GNULIB_overrides_fprintf 1
#  if 0 || 0
_GL_FUNCDECL_RPL (fprintf, int,
                  (FILE *restrict fp, const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2)));
#  else
_GL_FUNCDECL_RPL (fprintf, int,
                  (FILE *restrict fp, const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_SYSTEM (2, 3)
                  _GL_ARG_NONNULL ((1, 2)));
#  endif
_GL_CXXALIAS_RPL (fprintf, int,
                  (FILE *restrict fp, const char *restrict format, ...));
# else
_GL_CXXALIAS_SYS (fprintf, int,
                  (FILE *restrict fp, const char *restrict format, ...));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fprintf);
# endif
#endif
#if !0 && defined GNULIB_POSIXCHECK
# if !GNULIB_overrides_fprintf
#  undef fprintf
# endif
/* Assume fprintf is always declared.  */
_GL_WARN_ON_USE (fprintf, "fprintf is not always POSIX compliant - "
                 "use gnulib module fprintf-posix for portable "
                 "POSIX compliance");
#endif

#if 1
/* Discard all pending buffered I/O data on STREAM.
   STREAM must not be wide-character oriented.
   When discarding pending output, the file position is set back to where it
   was before the write calls.  When discarding pending input, the file
   position is advanced to match the end of the previously read input.
   Return 0 if successful.  Upon error, return -1 and set errno.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define fpurge rpl_fpurge
#  endif
_GL_FUNCDECL_RPL (fpurge, int, (FILE *gl_stream), _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL (fpurge, int, (FILE *gl_stream));
# else
#  if !0
_GL_FUNCDECL_SYS (fpurge, int, (FILE *gl_stream), _GL_ARG_NONNULL ((1)));
#  endif
_GL_CXXALIAS_SYS (fpurge, int, (FILE *gl_stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fpurge);
# endif
#elif defined GNULIB_POSIXCHECK
# undef fpurge
# if HAVE_RAW_DECL_FPURGE
_GL_WARN_ON_USE (fpurge, "fpurge is not always present - "
                 "use gnulib module fpurge for portability");
# endif
#endif

#if 1
# if 0 && (0 || 0)
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fputc
#   define fputc rpl_fputc
#  endif
_GL_FUNCDECL_RPL (fputc, int, (int c, FILE *stream), _GL_ARG_NONNULL ((2)));
_GL_CXXALIAS_RPL (fputc, int, (int c, FILE *stream));
# else
_GL_CXXALIAS_SYS (fputc, int, (int c, FILE *stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fputc);
# endif
#endif

#if 1
# if 0 && (0 || 0)
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fputs
#   define fputs rpl_fputs
#  endif
_GL_FUNCDECL_RPL (fputs, int,
                  (const char *restrict string, FILE *restrict stream),
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_RPL (fputs, int,
                  (const char *restrict string, FILE *restrict stream));
# else
_GL_CXXALIAS_SYS (fputs, int,
                  (const char *restrict string, FILE *restrict stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fputs);
# endif
#endif

#if 1
# if 0 && 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fread
#   define fread rpl_fread
#  endif
_GL_FUNCDECL_RPL (fread, size_t,
                  (void *restrict ptr, size_t s, size_t n,
                   FILE *restrict stream),
                  _GL_ARG_NONNULL ((4)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (fread, size_t,
                  (void *restrict ptr, size_t s, size_t n,
                   FILE *restrict stream));
# else
_GL_CXXALIAS_SYS (fread, size_t,
                  (void *restrict ptr, size_t s, size_t n,
                   FILE *restrict stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fread);
# endif
#endif

#if 0
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef freopen
#   define freopen rpl_freopen
#  endif
_GL_FUNCDECL_RPL (freopen, FILE *,
                  (const char *restrict filename, const char *restrict mode,
                   FILE *restrict stream),
                  _GL_ARG_NONNULL ((2, 3)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (freopen, FILE *,
                  (const char *restrict filename, const char *restrict mode,
                   FILE *restrict stream));
# else
_GL_CXXALIAS_SYS (freopen, FILE *,
                  (const char *restrict filename, const char *restrict mode,
                   FILE *restrict stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (freopen);
# endif
#elif defined GNULIB_POSIXCHECK
# undef freopen
/* Assume freopen is always declared.  */
_GL_WARN_ON_USE (freopen,
                 "freopen on native Windows platforms is not POSIX compliant - "
                 "use gnulib module freopen for portability");
#endif

#if 1
# if 0 && 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fscanf
#   define fscanf rpl_fscanf
#  endif
_GL_FUNCDECL_RPL (fscanf, int,
                  (FILE *restrict stream, const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_SCANF_SYSTEM (2, 3)
                  _GL_ARG_NONNULL ((1, 2)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (fscanf, int,
                  (FILE *restrict stream, const char *restrict format, ...));
# else
_GL_CXXALIAS_SYS (fscanf, int,
                  (FILE *restrict stream, const char *restrict format, ...));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fscanf);
# endif
#endif


/* Set up the following warnings, based on which modules are in use.
   GNU Coding Standards discourage the use of fseek, since it imposes
   an arbitrary limitation on some 32-bit hosts.  Remember that the
   fseek module depends on the fseeko module, so we only have three
   cases to consider:

   1. The developer is not using either module.  Issue a warning under
   GNULIB_POSIXCHECK for both functions, to remind them that both
   functions have bugs on some systems.  _GL_NO_LARGE_FILES has no
   impact on this warning.

   2. The developer is using both modules.  They may be unaware of the
   arbitrary limitations of fseek, so issue a warning under
   GNULIB_POSIXCHECK.  On the other hand, they may be using both
   modules intentionally, so the developer can define
   _GL_NO_LARGE_FILES in the compilation units where the use of fseek
   is safe, to silence the warning.

   3. The developer is using the fseeko module, but not fseek.  Gnulib
   guarantees that fseek will still work around platform bugs in that
   case, but we presume that the developer is aware of the pitfalls of
   fseek and was trying to avoid it, so issue a warning even when
   GNULIB_POSIXCHECK is undefined.  Again, _GL_NO_LARGE_FILES can be
   defined to silence the warning in particular compilation units.
   In C++ compilations with GNULIB_NAMESPACE, in order to avoid that
   fseek gets defined as a macro, it is recommended that the developer
   uses the fseek module, even if he is not calling the fseek function.

   Most gnulib clients that perform stream operations should fall into
   category 3.  */

#if 1
# if defined GNULIB_POSIXCHECK && !defined _GL_NO_LARGE_FILES
#  define _GL_FSEEK_WARN /* Category 2, above.  */
#  undef fseek
# endif
# if 1
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fseek
#   define fseek rpl_fseek
#  endif
_GL_FUNCDECL_RPL (fseek, int, (FILE *fp, long offset, int whence),
                              _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL (fseek, int, (FILE *fp, long offset, int whence));
# else
_GL_CXXALIAS_SYS (fseek, int, (FILE *fp, long offset, int whence));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fseek);
# endif
#endif

#if 1
# if !1 && !defined _GL_NO_LARGE_FILES
#  define _GL_FSEEK_WARN /* Category 3, above.  */
#  undef fseek
# endif
# if 1
/* Provide an fseeko function that is aware of a preceding fflush(), and which
   detects pipes.  */
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fseeko
#   define fseeko rpl_fseeko
#  endif
_GL_FUNCDECL_RPL (fseeko, int, (FILE *fp, off_t offset, int whence),
                               _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL (fseeko, int, (FILE *fp, off_t offset, int whence));
# else
#  if ! 1
_GL_FUNCDECL_SYS (fseeko, int, (FILE *fp, off_t offset, int whence),
                               _GL_ARG_NONNULL ((1)));
#  endif
_GL_CXXALIAS_SYS (fseeko, int, (FILE *fp, off_t offset, int whence));
# endif
_GL_CXXALIASWARN (fseeko);
#elif defined GNULIB_POSIXCHECK
# define _GL_FSEEK_WARN /* Category 1, above.  */
# undef fseek
# undef fseeko
# if HAVE_RAW_DECL_FSEEKO
_GL_WARN_ON_USE (fseeko, "fseeko is unportable - "
                 "use gnulib module fseeko for portability");
# endif
#endif

#ifdef _GL_FSEEK_WARN
# undef _GL_FSEEK_WARN
/* Here, either fseek is undefined (but C89 guarantees that it is
   declared), or it is defined as rpl_fseek (declared above).  */
_GL_WARN_ON_USE (fseek, "fseek cannot handle files larger than 4 GB "
                 "on 32-bit platforms - "
                 "use fseeko function for handling of large files");
#endif


/* ftell, ftello.  See the comments on fseek/fseeko.  */

#if 1
# if defined GNULIB_POSIXCHECK && !defined _GL_NO_LARGE_FILES
#  define _GL_FTELL_WARN /* Category 2, above.  */
#  undef ftell
# endif
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef ftell
#   define ftell rpl_ftell
#  endif
_GL_FUNCDECL_RPL (ftell, long, (FILE *fp),
                               _GL_ARG_NONNULL ((1)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (ftell, long, (FILE *fp));
# else
_GL_CXXALIAS_SYS (ftell, long, (FILE *fp));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (ftell);
# endif
#endif

#if 1
# if !1 && !defined _GL_NO_LARGE_FILES
#  define _GL_FTELL_WARN /* Category 3, above.  */
#  undef ftell
# endif
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef ftello
#   define ftello rpl_ftello
#  endif
_GL_FUNCDECL_RPL (ftello, off_t, (FILE *fp),
                                 _GL_ARG_NONNULL ((1)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (ftello, off_t, (FILE *fp));
# else
#  if ! 1
_GL_FUNCDECL_SYS (ftello, off_t, (FILE *fp),
                                 _GL_ARG_NONNULL ((1)) _GL_ATTRIBUTE_NODISCARD);
#  endif
_GL_CXXALIAS_SYS (ftello, off_t, (FILE *fp));
# endif
_GL_CXXALIASWARN (ftello);
#elif defined GNULIB_POSIXCHECK
# define _GL_FTELL_WARN /* Category 1, above.  */
# undef ftell
# undef ftello
# if HAVE_RAW_DECL_FTELLO
_GL_WARN_ON_USE (ftello, "ftello is unportable - "
                 "use gnulib module ftello for portability");
# endif
#endif

#ifdef _GL_FTELL_WARN
# undef _GL_FTELL_WARN
/* Here, either ftell is undefined (but C89 guarantees that it is
   declared), or it is defined as rpl_ftell (declared above).  */
_GL_WARN_ON_USE (ftell, "ftell cannot handle files larger than 4 GB "
                 "on 32-bit platforms - "
                 "use ftello function for handling of large files");
#endif


#if 1
# if 0 && (0 || 0)
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef fwrite
#   define fwrite rpl_fwrite
#  endif
_GL_FUNCDECL_RPL (fwrite, size_t,
                  (const void *restrict ptr, size_t s, size_t n,
                   FILE *restrict stream),
                  _GL_ARG_NONNULL ((1, 4)));
_GL_CXXALIAS_RPL (fwrite, size_t,
                  (const void *restrict ptr, size_t s, size_t n,
                   FILE *restrict stream));
# else
_GL_CXXALIAS_SYS (fwrite, size_t,
                  (const void *restrict ptr, size_t s, size_t n,
                   FILE *restrict stream));

/* Work around bug 11959 when fortifying glibc 2.4 through 2.15
   <https://sourceware.org/bugzilla/show_bug.cgi?id=11959>,
   which sometimes causes an unwanted diagnostic for fwrite calls.
   This affects only function declaration attributes under certain
   versions of gcc and clang, and is not needed for C++.  */
#  if (0 < __USE_FORTIFY_LEVEL                                            \
       && __GLIBC__ == 2 && 4 <= __GLIBC_MINOR__ && __GLIBC_MINOR__ <= 15 \
       && (3 < __GNUC__ + (4 <= __GNUC_MINOR__) || defined __clang__)     \
       && !defined __cplusplus)
#   undef fwrite
#   undef fwrite_unlocked
_GL_EXTERN_C size_t __REDIRECT (rpl_fwrite,
                                (const void *__restrict, size_t, size_t,
                                 FILE *__restrict),
                                fwrite);
_GL_EXTERN_C size_t __REDIRECT (rpl_fwrite_unlocked,
                                (const void *__restrict, size_t, size_t,
                                 FILE *__restrict),
                                fwrite_unlocked);
#   define fwrite rpl_fwrite
#   define fwrite_unlocked rpl_fwrite_unlocked
#  endif
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (fwrite);
# endif
#endif

#if 1
# if 0 && 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef getc
#   define getc rpl_fgetc
#  endif
_GL_FUNCDECL_RPL (fgetc, int, (FILE *stream), _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL_1 (getc, rpl_fgetc, int, (FILE *stream));
# else
_GL_CXXALIAS_SYS (getc, int, (FILE *stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (getc);
# endif
#endif

#if 1
# if 0 && 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef getchar
#   define getchar rpl_getchar
#  endif
_GL_FUNCDECL_RPL (getchar, int, (void), );
_GL_CXXALIAS_RPL (getchar, int, (void));
# else
_GL_CXXALIAS_SYS (getchar, int, (void));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (getchar);
# endif
#endif

#if 0
/* Read input, up to (and including) the next occurrence of DELIMITER, from
   STREAM, store it in *LINEPTR (and NUL-terminate it).
   *LINEPTR is a pointer returned from malloc (or NULL), pointing to *LINESIZE
   bytes of space.  It is realloc'd as necessary.
   Return the number of bytes read and stored at *LINEPTR (not including the
   NUL terminator), or -1 on error or EOF.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef getdelim
#   define getdelim rpl_getdelim
#  endif
_GL_FUNCDECL_RPL (getdelim, ssize_t,
                  (char **restrict lineptr, size_t *restrict linesize,
                   int delimiter,
                   FILE *restrict stream),
                  _GL_ARG_NONNULL ((1, 2, 4)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (getdelim, ssize_t,
                  (char **restrict lineptr, size_t *restrict linesize,
                   int delimiter,
                   FILE *restrict stream));
# else
#  if !1
_GL_FUNCDECL_SYS (getdelim, ssize_t,
                  (char **restrict lineptr, size_t *restrict linesize,
                   int delimiter,
                   FILE *restrict stream),
                  _GL_ARG_NONNULL ((1, 2, 4)) _GL_ATTRIBUTE_NODISCARD);
#  endif
_GL_CXXALIAS_SYS (getdelim, ssize_t,
                  (char **restrict lineptr, size_t *restrict linesize,
                   int delimiter,
                   FILE *restrict stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (getdelim);
# endif
#elif defined GNULIB_POSIXCHECK
# undef getdelim
# if HAVE_RAW_DECL_GETDELIM
_GL_WARN_ON_USE (getdelim, "getdelim is unportable - "
                 "use gnulib module getdelim for portability");
# endif
#endif

#if 0
/* Read a line, up to (and including) the next newline, from STREAM, store it
   in *LINEPTR (and NUL-terminate it).
   *LINEPTR is a pointer returned from malloc (or NULL), pointing to *LINESIZE
   bytes of space.  It is realloc'd as necessary.
   Return the number of bytes read and stored at *LINEPTR (not including the
   NUL terminator), or -1 on error or EOF.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef getline
#   define getline rpl_getline
#  endif
_GL_FUNCDECL_RPL (getline, ssize_t,
                  (char **restrict lineptr, size_t *restrict linesize,
                   FILE *restrict stream),
                  _GL_ARG_NONNULL ((1, 2, 3)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (getline, ssize_t,
                  (char **restrict lineptr, size_t *restrict linesize,
                   FILE *restrict stream));
# else
#  if !1
_GL_FUNCDECL_SYS (getline, ssize_t,
                  (char **restrict lineptr, size_t *restrict linesize,
                   FILE *restrict stream),
                  _GL_ARG_NONNULL ((1, 2, 3)) _GL_ATTRIBUTE_NODISCARD);
#  endif
_GL_CXXALIAS_SYS (getline, ssize_t,
                  (char **restrict lineptr, size_t *restrict linesize,
                   FILE *restrict stream));
# endif
# if __GLIBC__ >= 2 && 1
_GL_CXXALIASWARN (getline);
# endif
#elif defined GNULIB_POSIXCHECK
# undef getline
# if HAVE_RAW_DECL_GETLINE
_GL_WARN_ON_USE (getline, "getline is unportable - "
                 "use gnulib module getline for portability");
# endif
#endif

/* It is very rare that the developer ever has full control of stdin,
   so any use of gets warrants an unconditional warning; besides, C11
   removed it.  */
#undef gets
#if HAVE_RAW_DECL_GETS && !defined __cplusplus
_GL_WARN_ON_USE (gets, "gets is a security hole - use fgets instead");
#endif

#if 1
/* On native Windows, map 'getw' to '_getw', so that -loldnames is not
   required.  In C++ with GNULIB_NAMESPACE, avoid differences between
   platforms by defining GNULIB_NAMESPACE::getw always.  */
# if defined _WIN32 && !defined __CYGWIN__
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef getw
#   define getw _getw
#  endif
_GL_CXXALIAS_MDA (getw, int, (FILE *restrict stream));
# else
#  if 1
#   if defined __APPLE__ && defined __MACH__
/* The presence of the declaration depends on _POSIX_C_SOURCE.  */
_GL_FUNCDECL_SYS (getw, int, (FILE *restrict stream), );
#   endif
_GL_CXXALIAS_SYS (getw, int, (FILE *restrict stream));
#  endif
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (getw);
# endif
#endif

#if 0
struct obstack;
/* Grows an obstack with formatted output.  Returns the number of
   bytes added to OBS.  No trailing nul byte is added, and the
   object should be closed with obstack_finish before use.
   Upon memory allocation error, calls obstack_alloc_failed_handler.
   Upon other error, returns -1 with errno set.

   Failure code EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure code is through
   obstack_alloc_failed_handler.  */
_GL_FUNCDECL_SYS (obstack_zprintf, ptrdiff_t,
                  (struct obstack *obs, const char *format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_SYS (obstack_zprintf, ptrdiff_t,
                  (struct obstack *obs, const char *format, ...));
_GL_FUNCDECL_SYS (obstack_vzprintf, ptrdiff_t,
                  (struct obstack *obs, const char *format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_SYS (obstack_vzprintf, ptrdiff_t,
                  (struct obstack *obs, const char *format, va_list args));
#endif

#if 0 || 0
struct obstack;
/* Grows an obstack with formatted output.  Returns the number of
   bytes added to OBS.  No trailing nul byte is added, and the
   object should be closed with obstack_finish before use.
   Upon memory allocation error, calls obstack_alloc_failed_handler.
   Upon other error, returns -1.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define obstack_printf rpl_obstack_printf
#  endif
_GL_FUNCDECL_RPL (obstack_printf, int,
                  (struct obstack *obs, const char *format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_RPL (obstack_printf, int,
                  (struct obstack *obs, const char *format, ...));
# else
#  if !1
_GL_FUNCDECL_SYS (obstack_printf, int,
                  (struct obstack *obs, const char *format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2)));
#  endif
_GL_CXXALIAS_SYS (obstack_printf, int,
                  (struct obstack *obs, const char *format, ...));
# endif
_GL_CXXALIASWARN (obstack_printf);
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define obstack_vprintf rpl_obstack_vprintf
#  endif
_GL_FUNCDECL_RPL (obstack_vprintf, int,
                  (struct obstack *obs, const char *format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_RPL (obstack_vprintf, int,
                  (struct obstack *obs, const char *format, va_list args));
# else
#  if !1
_GL_FUNCDECL_SYS (obstack_vprintf, int,
                  (struct obstack *obs, const char *format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2)));
#  endif
_GL_CXXALIAS_SYS (obstack_vprintf, int,
                  (struct obstack *obs, const char *format, va_list args));
# endif
_GL_CXXALIASWARN (obstack_vprintf);
#endif

#if 1
# if !1
_GL_FUNCDECL_SYS (pclose, int, (FILE *stream), _GL_ARG_NONNULL ((1)));
# endif
_GL_CXXALIAS_SYS (pclose, int, (FILE *stream));
_GL_CXXALIASWARN (pclose);
#elif defined GNULIB_POSIXCHECK
# undef pclose
# if HAVE_RAW_DECL_PCLOSE
_GL_WARN_ON_USE (pclose, "pclose is unportable - "
                 "use gnulib module pclose for more portability");
# endif
#endif

#if 0
/* Print a message to standard error, describing the value of ERRNO,
   (if STRING is not NULL and not empty) prefixed with STRING and ": ",
   and terminated with a newline.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define perror rpl_perror
#  endif
_GL_FUNCDECL_RPL (perror, void, (const char *string), );
_GL_CXXALIAS_RPL (perror, void, (const char *string));
# else
_GL_CXXALIAS_SYS (perror, void, (const char *string));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (perror);
# endif
#elif defined GNULIB_POSIXCHECK
# undef perror
/* Assume perror is always declared.  */
_GL_WARN_ON_USE (perror, "perror is not always POSIX compliant - "
                 "use gnulib module perror for portability");
#endif

#if 1
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef popen
#   define popen rpl_popen
#  endif
_GL_FUNCDECL_RPL (popen, FILE *,
                  (const char *cmd, const char *mode),
                  _GL_ARG_NONNULL ((1, 2)) _GL_ATTRIBUTE_DEALLOC (pclose, 1)
                  _GL_ATTRIBUTE_MALLOC _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (popen, FILE *, (const char *cmd, const char *mode));
# else
#  if !1 || (__GNUC__ >= 11 && !defined __clang__)
_GL_FUNCDECL_SYS (popen, FILE *,
                  (const char *cmd, const char *mode),
                  _GL_ARG_NONNULL ((1, 2)) _GL_ATTRIBUTE_DEALLOC (pclose, 1)
                  _GL_ATTRIBUTE_MALLOC _GL_ATTRIBUTE_NODISCARD);
#  endif
_GL_CXXALIAS_SYS (popen, FILE *, (const char *cmd, const char *mode));
# endif
_GL_CXXALIASWARN (popen);
#else
# if 1 \
     && (__GNUC__ >= 11 && !defined __clang__) && !defined popen
/* For -Wmismatched-dealloc: Associate popen with pclose or rpl_pclose.  */
_GL_FUNCDECL_SYS (popen, FILE *,
                  (const char *cmd, const char *mode),
                  _GL_ARG_NONNULL ((1, 2)) _GL_ATTRIBUTE_DEALLOC (pclose, 1)
                  _GL_ATTRIBUTE_MALLOC);
# endif
# if defined GNULIB_POSIXCHECK
#  undef popen
#  if HAVE_RAW_DECL_POPEN
_GL_WARN_ON_USE (popen, "popen is buggy on some platforms - "
                 "use gnulib module popen or pipe for more portability");
#  endif
# endif
#endif

#if 0
/* Prints formatted output to standard output.
   Returns the number of bytes written to standard output.  Upon failure,
   returns -1 with stdout's error indicator set.
   Failure cause EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure causes are ENOMEM
   and the possible failure causes from fwrite().  */
_GL_FUNCDECL_SYS (zprintf, off64_t, (const char *restrict format, ...),
                                    _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (1, 2)
                                    _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_SYS (zprintf, off64_t, (const char *restrict format, ...));
#endif

#if 0 || 1
/* Prints formatted output to standard output.
   Returns the number of bytes written to standard output.  Upon failure,
   returns a negative value with stdout's error indicator set.  */
# if (0 && 0) \
     || (1 && 0 && (0 || 0))
#  if defined __GNUC__ || defined __clang__
#   if !(defined __cplusplus && defined GNULIB_NAMESPACE)
/* Don't break __attribute__((format(printf,M,N))).  */
#    define printf __printf__
#   endif
#   if 0 || 0
_GL_FUNCDECL_RPL_1 (__printf__, int,
                    (const char *restrict format, ...)
                    __asm__ (
                             _GL_STDIO_MACROEXPAND_AND_STRINGIZE(rpl_printf)),
                    _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (1, 2)
                    _GL_ARG_NONNULL ((1)));
#   else
_GL_FUNCDECL_RPL_1 (__printf__, int,
                    (const char *restrict format, ...)
                    __asm__ (
                             _GL_STDIO_MACROEXPAND_AND_STRINGIZE(rpl_printf)),
                    _GL_ATTRIBUTE_FORMAT_PRINTF_SYSTEM (1, 2)
                    _GL_ARG_NONNULL ((1)));
#   endif
_GL_CXXALIAS_RPL_1 (printf, __printf__, int, (const char *format, ...));
#  else
#   if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#    define printf rpl_printf
#   endif
_GL_FUNCDECL_RPL (printf, int,
                  (const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (1, 2)
                  _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL (printf, int, (const char *restrict format, ...));
#  endif
#  define GNULIB_overrides_printf 1
# else
_GL_CXXALIAS_SYS (printf, int, (const char *restrict format, ...));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (printf);
# endif
#endif
#if !0 && defined GNULIB_POSIXCHECK
# if !GNULIB_overrides_printf
#  undef printf
# endif
/* Assume printf is always declared.  */
_GL_WARN_ON_USE (printf, "printf is not always POSIX compliant - "
                 "use gnulib module printf-posix for portable "
                 "POSIX compliance");
#endif

#if 1
# if 0 && (0 || 0)
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef putc
#   define putc rpl_fputc
#  endif
_GL_FUNCDECL_RPL (fputc, int, (int c, FILE *stream), _GL_ARG_NONNULL ((2)));
_GL_CXXALIAS_RPL_1 (putc, rpl_fputc, int, (int c, FILE *stream));
# else
_GL_CXXALIAS_SYS (putc, int, (int c, FILE *stream));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (putc);
# endif
#endif

#if 1
# if 0 && (0 || 0)
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef putchar
#   define putchar rpl_putchar
#  endif
_GL_FUNCDECL_RPL (putchar, int, (int c), );
_GL_CXXALIAS_RPL (putchar, int, (int c));
# else
_GL_CXXALIAS_SYS (putchar, int, (int c));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (putchar);
# endif
#endif

#if 1
# if 0 && (0 || 0)
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef puts
#   define puts rpl_puts
#  endif
_GL_FUNCDECL_RPL (puts, int, (const char *string), _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL (puts, int, (const char *string));
# else
_GL_CXXALIAS_SYS (puts, int, (const char *string));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (puts);
# endif
#endif

#if 1
/* On native Windows, map 'putw' to '_putw', so that -loldnames is not
   required.  In C++ with GNULIB_NAMESPACE, avoid differences between
   platforms by defining GNULIB_NAMESPACE::putw always.  */
# if defined _WIN32 && !defined __CYGWIN__
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef putw
#   define putw _putw
#  endif
_GL_CXXALIAS_MDA (putw, int, (int w, FILE *restrict stream));
# else
#  if 1
#   if defined __APPLE__ && defined __MACH__
/* The presence of the declaration depends on _POSIX_C_SOURCE.  */
_GL_FUNCDECL_SYS (putw, int, (int w, FILE *restrict stream), );
#   endif
_GL_CXXALIAS_SYS (putw, int, (int w, FILE *restrict stream));
#  endif
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (putw);
# endif
#endif

#if 0
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef remove
#   define remove rpl_remove
#  endif
_GL_FUNCDECL_RPL (remove, int, (const char *name), _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_RPL (remove, int, (const char *name));
# else
_GL_CXXALIAS_SYS (remove, int, (const char *name));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (remove);
# endif
#elif defined GNULIB_POSIXCHECK
# undef remove
/* Assume remove is always declared.  */
_GL_WARN_ON_USE (remove, "remove cannot handle directories on some platforms - "
                 "use gnulib module remove for more portability");
#endif

#if 0
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef rename
#   define rename rpl_rename
#  endif
_GL_FUNCDECL_RPL (rename, int,
                  (const char *old_filename, const char *new_filename),
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_RPL (rename, int,
                  (const char *old_filename, const char *new_filename));
# else
_GL_CXXALIAS_SYS (rename, int,
                  (const char *old_filename, const char *new_filename));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (rename);
# endif
#elif defined GNULIB_POSIXCHECK
# undef rename
/* Assume rename is always declared.  */
_GL_WARN_ON_USE (rename, "rename is buggy on some platforms - "
                 "use gnulib module rename for more portability");
#endif

#if 0
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef renameat
#   define renameat rpl_renameat
#  endif
_GL_FUNCDECL_RPL (renameat, int,
                  (int fd1, char const *file1, int fd2, char const *file2),
                  _GL_ARG_NONNULL ((2, 4)));
_GL_CXXALIAS_RPL (renameat, int,
                  (int fd1, char const *file1, int fd2, char const *file2));
# else
#  if !1
_GL_FUNCDECL_SYS (renameat, int,
                  (int fd1, char const *file1, int fd2, char const *file2),
                  _GL_ARG_NONNULL ((2, 4)));
#  endif
_GL_CXXALIAS_SYS (renameat, int,
                  (int fd1, char const *file1, int fd2, char const *file2));
# endif
_GL_CXXALIASWARN (renameat);
#elif defined GNULIB_POSIXCHECK
# undef renameat
# if HAVE_RAW_DECL_RENAMEAT
_GL_WARN_ON_USE (renameat, "renameat is not portable - "
                 "use gnulib module renameat for portability");
# endif
#endif

#if 1
# if 0 && 0
#  if defined __GNUC__ || defined __clang__
#   if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#    undef scanf
/* Don't break __attribute__((format(scanf,M,N))).  */
#    define scanf __scanf__
#   endif
_GL_FUNCDECL_RPL_1 (__scanf__, int,
                    (const char *restrict format, ...)
                    __asm__ (
                             _GL_STDIO_MACROEXPAND_AND_STRINGIZE(rpl_scanf)),
                    _GL_ATTRIBUTE_FORMAT_SCANF_SYSTEM (1, 2)
                    _GL_ARG_NONNULL ((1)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL_1 (scanf, __scanf__, int, (const char *restrict format, ...));
#  else
#   if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#    undef scanf
#    define scanf rpl_scanf
#   endif
_GL_FUNCDECL_RPL (scanf, int, (const char *restrict format, ...),
                              _GL_ATTRIBUTE_FORMAT_SCANF_SYSTEM (1, 2)
                              _GL_ARG_NONNULL ((1)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (scanf, int, (const char *restrict format, ...));
#  endif
# else
_GL_CXXALIAS_SYS (scanf, int, (const char *restrict format, ...));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (scanf);
# endif
#endif

#if 0
/* Prints formatted output to string STR.  Similar to sprintf, but the
   additional parameter SIZE limits how much is written into STR.
   STR may be NULL, in which case nothing will be written.
   Returns the string length of the formatted string (which may be larger
   than SIZE).  Upon failure, returns -1 with errno set.
   Failure code EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure code is ENOMEM.  */
_GL_FUNCDECL_SYS (snzprintf, ptrdiff_t,
                  (char *restrict str, size_t size,
                   const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (3, 4)
                  _GL_ARG_NONNULL ((3)));
_GL_CXXALIAS_SYS (snzprintf, ptrdiff_t,
                  (char *restrict str, size_t size,
                   const char *restrict format, ...));
#endif

#if 1
/* Prints formatted output to string STR.  Similar to sprintf, but the
   additional parameter SIZE limits how much is written into STR.
   STR may be NULL, in which case nothing will be written.
   Returns the string length of the formatted string (which may be larger
   than SIZE).  Upon failure, returns a negative value.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define snprintf rpl_snprintf
#  endif
#  define GNULIB_overrides_snprintf 1
_GL_FUNCDECL_RPL (snprintf, int,
                  (char *restrict str, size_t size,
                   const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (3, 4)
                  _GL_ARG_NONNULL ((3)));
_GL_CXXALIAS_RPL (snprintf, int,
                  (char *restrict str, size_t size,
                   const char *restrict format, ...));
# else
#  if !1
_GL_FUNCDECL_SYS (snprintf, int,
                  (char *restrict str, size_t size,
                   const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (3, 4)
                  _GL_ARG_NONNULL ((3)));
#  endif
_GL_CXXALIAS_SYS (snprintf, int,
                  (char *restrict str, size_t size,
                   const char *restrict format, ...));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (snprintf);
# endif
#elif defined GNULIB_POSIXCHECK
# undef snprintf
# if HAVE_RAW_DECL_SNPRINTF
_GL_WARN_ON_USE (snprintf, "snprintf is unportable - "
                 "use gnulib module snprintf for portability");
# endif
#endif

#if 0
/* Prints formatted output to string STR.
   Returns the string length of the formatted string.  Upon failure,
   returns -1 with errno set.
   Failure code EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure code is ENOMEM.  */
_GL_FUNCDECL_SYS (szprintf, ptrdiff_t,
                  (char *restrict str,
                   const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_SYS (szprintf, ptrdiff_t,
                  (char *restrict str,
                   const char *restrict format, ...));
#endif

/* Some people would argue that all sprintf uses should be warned about
   (for example, OpenBSD issues a link warning for it),
   since it can cause security holes due to buffer overruns.
   However, we believe that sprintf can be used safely, and is more
   efficient than snprintf in those safe cases; and as proof of our
   belief, we use sprintf in several gnulib modules.  So this header
   intentionally avoids adding a warning to sprintf except when
   GNULIB_POSIXCHECK is defined.  */

#if 0
/* Prints formatted output to string STR.
   Returns the string length of the formatted string.  Upon failure,
   returns a negative value.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define sprintf rpl_sprintf
#  endif
#  define GNULIB_overrides_sprintf 1
_GL_FUNCDECL_RPL (sprintf, int,
                  (char *restrict str, const char *restrict format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_RPL (sprintf, int,
                  (char *restrict str, const char *restrict format, ...));
# else
_GL_CXXALIAS_SYS (sprintf, int,
                  (char *restrict str, const char *restrict format, ...));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (sprintf);
# endif
#elif defined GNULIB_POSIXCHECK
# undef sprintf
/* Assume sprintf is always declared.  */
_GL_WARN_ON_USE (sprintf, "sprintf is not always POSIX compliant - "
                 "use gnulib module sprintf-posix for portable "
                 "POSIX compliance");
#endif

#if 1
/* On native Windows, map 'tempnam' to '_tempnam', so that -loldnames is not
   required.  In C++ with GNULIB_NAMESPACE, avoid differences between
   platforms by defining GNULIB_NAMESPACE::tempnam always.  */
# if defined _WIN32 && !defined __CYGWIN__
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef tempnam
#   define tempnam _tempnam
#  endif
_GL_CXXALIAS_MDA (tempnam, char *, (const char *dir, const char *prefix));
# else
_GL_CXXALIAS_SYS (tempnam, char *, (const char *dir, const char *prefix));
# endif
_GL_CXXALIASWARN (tempnam);
#endif

#if 0
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define tmpfile rpl_tmpfile
#  endif
_GL_FUNCDECL_RPL (tmpfile, FILE *, (void),
                                   _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                                   _GL_ATTRIBUTE_MALLOC
                                   _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (tmpfile, FILE *, (void));
# else
#  if __GNUC__ >= 11 && !defined __clang__
/* For -Wmismatched-dealloc: Associate tmpfile with fclose or rpl_fclose.  */
_GL_FUNCDECL_SYS (tmpfile, FILE *, (void),
                                   _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                                   _GL_ATTRIBUTE_MALLOC
                                   _GL_ATTRIBUTE_NODISCARD);
#  endif
_GL_CXXALIAS_SYS (tmpfile, FILE *, (void));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (tmpfile);
# endif
#else
# if 0 \
     && (__GNUC__ >= 11 && !defined __clang__) && !defined tmpfile
/* For -Wmismatched-dealloc: Associate tmpfile with fclose or rpl_fclose.  */
_GL_FUNCDECL_SYS (tmpfile, FILE *, (void),
                                   _GL_ATTRIBUTE_DEALLOC (fclose, 1)
                                   _GL_ATTRIBUTE_MALLOC);
# endif
# if defined GNULIB_POSIXCHECK
#  undef tmpfile
#  if HAVE_RAW_DECL_TMPFILE
_GL_WARN_ON_USE (tmpfile, "tmpfile is not usable on mingw - "
                 "use gnulib module tmpfile for portability");
#  endif
# endif
#endif

#if 0
/* Prints formatted output to a string dynamically allocated with malloc().
   If the memory allocation succeeds, it stores the address of the string in
   *RESULT and returns the number of resulting bytes, excluding the trailing
   NUL.  Upon memory allocation error, or some other error, it returns -1
   with errno set.
   Failure code EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure code is ENOMEM.  */
_GL_FUNCDECL_SYS (aszprintf, ptrdiff_t,
                  (char **result, const char *format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2))
                  _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_SYS (aszprintf, ptrdiff_t,
                  (char **result, const char *format, ...));
_GL_FUNCDECL_SYS (vaszprintf, ptrdiff_t,
                  (char **result, const char *format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2))
                  _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_SYS (vaszprintf, ptrdiff_t,
                  (char **result, const char *format, va_list args));
#endif

#if 0
/* Write formatted output to a string dynamically allocated with malloc().
   If the memory allocation succeeds, store the address of the string in
   *RESULT and return the number of resulting bytes, excluding the trailing
   NUL.  Upon memory allocation error, or some other error, return -1.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define asprintf rpl_asprintf
#  endif
#  define GNULIB_overrides_asprintf
_GL_FUNCDECL_RPL (asprintf, int,
                  (char **result, const char *format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2))
                  _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (asprintf, int,
                  (char **result, const char *format, ...));
# else
#  if !1
_GL_FUNCDECL_SYS (asprintf, int,
                  (char **result, const char *format, ...),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 3)
                  _GL_ARG_NONNULL ((1, 2))
                  _GL_ATTRIBUTE_NODISCARD);
#  endif
_GL_CXXALIAS_SYS (asprintf, int,
                  (char **result, const char *format, ...));
# endif
_GL_CXXALIASWARN (asprintf);
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define vasprintf rpl_vasprintf
#  endif
#  define GNULIB_overrides_vasprintf 1
_GL_FUNCDECL_RPL (vasprintf, int,
                  (char **result, const char *format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2))
                  _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (vasprintf, int,
                  (char **result, const char *format, va_list args));
# else
#  if !1
_GL_FUNCDECL_SYS (vasprintf, int,
                  (char **result, const char *format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2))
                  _GL_ATTRIBUTE_NODISCARD);
#  endif
_GL_CXXALIAS_SYS (vasprintf, int,
                  (char **result, const char *format, va_list args));
# endif
_GL_CXXALIASWARN (vasprintf);
#endif

#if 0
/* Prints formatted output to file descriptor FD.
   Returns the number of bytes written to the file descriptor.  Upon
   failure, returns -1 with errno set.
   Failure code EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure codes are ENOMEM
   and the possible failure codes from write(), excluding EINTR.  */
_GL_FUNCDECL_SYS (vdzprintf, off64_t,
                  (int fd, const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((2)));
_GL_CXXALIAS_SYS (vdzprintf, off64_t,
                  (int fd, const char *restrict format, va_list args));
#endif

#if 0
/* Prints formatted output to file descriptor FD.
   Returns the number of bytes written to the file descriptor.  Upon
   failure, returns a negative value.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define vdprintf rpl_vdprintf
#  endif
_GL_FUNCDECL_RPL (vdprintf, int,
                  (int fd, const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((2)));
_GL_CXXALIAS_RPL (vdprintf, int,
                  (int fd, const char *restrict format, va_list args));
# else
#  if !1
_GL_FUNCDECL_SYS (vdprintf, int,
                  (int fd, const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((2)));
#  endif
/* Need to cast, because on Solaris, the third parameter will likely be
                                                    __va_list args.  */
_GL_CXXALIAS_SYS_CAST (vdprintf, int,
                       (int fd, const char *restrict format, va_list args));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (vdprintf);
# endif
#elif defined GNULIB_POSIXCHECK
# undef vdprintf
# if HAVE_RAW_DECL_VDPRINTF
_GL_WARN_ON_USE (vdprintf, "vdprintf is unportable - "
                 "use gnulib module vdprintf for portability");
# endif
#endif

#if 0
/* Prints formatted output to stream FP.
   Returns the number of bytes written to the stream.  Upon failure,
   returns -1 with the stream's error indicator set.
   Failure cause EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure causes are ENOMEM
   and the possible failure causes from fwrite().  */
_GL_FUNCDECL_SYS (vfzprintf, off64_t,
                  (FILE *restrict fp,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_SYS (vfzprintf, off64_t,
                  (FILE *restrict fp,
                   const char *restrict format, va_list args));
#endif

#if 0 || 1
/* Prints formatted output to stream FP.
   Returns the number of bytes written to the stream.  Upon failure,
   returns a negative value with the stream's error indicator set.  */
# if (0 && 0) \
     || (1 && 0 && (0 || 0))
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define vfprintf rpl_vfprintf
#  endif
#  define GNULIB_overrides_vfprintf 1
#  if 0
_GL_FUNCDECL_RPL (vfprintf, int,
                  (FILE *restrict fp,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2)));
#  else
_GL_FUNCDECL_RPL (vfprintf, int,
                  (FILE *restrict fp,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_SYSTEM (2, 0)
                  _GL_ARG_NONNULL ((1, 2)));
#  endif
_GL_CXXALIAS_RPL (vfprintf, int,
                  (FILE *restrict fp,
                   const char *restrict format, va_list args));
# else
/* Need to cast, because on Solaris, the third parameter is
                                                      __va_list args
   and GCC's fixincludes did not change this to __gnuc_va_list.  */
_GL_CXXALIAS_SYS_CAST (vfprintf, int,
                       (FILE *restrict fp,
                        const char *restrict format, va_list args));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (vfprintf);
# endif
#endif
#if !0 && defined GNULIB_POSIXCHECK
# if !GNULIB_overrides_vfprintf
#  undef vfprintf
# endif
/* Assume vfprintf is always declared.  */
_GL_WARN_ON_USE (vfprintf, "vfprintf is not always POSIX compliant - "
                 "use gnulib module vfprintf-posix for portable "
                      "POSIX compliance");
#endif

#if 0
# if 0 && 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef vfscanf
#   define vfscanf rpl_vfscanf
#  endif
_GL_FUNCDECL_RPL (vfscanf, int,
                  (FILE *restrict stream,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_SCANF_SYSTEM (2, 0)
                  _GL_ARG_NONNULL ((1, 2)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (vfscanf, int,
                  (FILE *restrict stream,
                   const char *restrict format, va_list args));
# else
_GL_CXXALIAS_SYS (vfscanf, int,
                  (FILE *restrict stream,
                   const char *restrict format, va_list args));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (vfscanf);
# endif
#endif

#if 0
/* Prints formatted output to standard output.
   Returns the number of bytes written to standard output.  Upon failure,
   returns -1 with stdout's error indicator set.
   Failure cause EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure causes are ENOMEM
   and the possible failure causes from fwrite().  */
_GL_FUNCDECL_SYS (vzprintf, off64_t,
                  (const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (1, 0)
                  _GL_ARG_NONNULL ((1)));
_GL_CXXALIAS_SYS (vzprintf, off64_t,
                  (const char *restrict format, va_list args));
#endif

#if 0 || 1
/* Prints formatted output to standard output.
   Returns the number of bytes written to standard output.  Upon failure,
   returns a negative value with stdout's error indicator set.  */
# if (0 && 0) \
     || (1 && 0 && (0 || 0))
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define vprintf rpl_vprintf
#  endif
#  define GNULIB_overrides_vprintf 1
#  if 0 || 0
_GL_FUNCDECL_RPL (vprintf, int, (const char *restrict format, va_list args),
                                _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (1, 0)
                                _GL_ARG_NONNULL ((1)));
#  else
_GL_FUNCDECL_RPL (vprintf, int, (const char *restrict format, va_list args),
                                _GL_ATTRIBUTE_FORMAT_PRINTF_SYSTEM (1, 0)
                                _GL_ARG_NONNULL ((1)));
#  endif
_GL_CXXALIAS_RPL (vprintf, int, (const char *restrict format, va_list args));
# else
/* Need to cast, because on Solaris, the second parameter is
                                                          __va_list args
   and GCC's fixincludes did not change this to __gnuc_va_list.  */
_GL_CXXALIAS_SYS_CAST (vprintf, int,
                       (const char *restrict format, va_list args));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (vprintf);
# endif
#endif
#if !0 && defined GNULIB_POSIXCHECK
# if !GNULIB_overrides_vprintf
#  undef vprintf
# endif
/* Assume vprintf is always declared.  */
_GL_WARN_ON_USE (vprintf, "vprintf is not always POSIX compliant - "
                 "use gnulib module vprintf-posix for portable "
                 "POSIX compliance");
#endif

#if 0
# if 0 && 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   undef vscanf
#   define vscanf rpl_vscanf
#  endif
_GL_FUNCDECL_RPL (vscanf, int, (const char *restrict format, va_list args),
                               _GL_ATTRIBUTE_FORMAT_SCANF_SYSTEM (1, 0)
                               _GL_ARG_NONNULL ((1)) _GL_ATTRIBUTE_NODISCARD);
_GL_CXXALIAS_RPL (vscanf, int, (const char *restrict format, va_list args));
# else
_GL_CXXALIAS_SYS (vscanf, int, (const char *restrict format, va_list args));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (vscanf);
# endif
#endif

#if 1
/* Prints formatted output to string STR.  Similar to sprintf, but the
   additional parameter SIZE limits how much is written into STR.
   STR may be NULL, in which case nothing will be written.
   Returns the string length of the formatted string (which may be larger
   than SIZE).  Upon failure, returns -1 with errno set.
   Failure code EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure code is ENOMEM.  */
_GL_FUNCDECL_SYS (vsnzprintf, ptrdiff_t,
                  (char *restrict str, size_t size,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (3, 0)
                  _GL_ARG_NONNULL ((3)));
_GL_CXXALIAS_SYS (vsnzprintf, ptrdiff_t,
                  (char *restrict str, size_t size,
                   const char *restrict format, va_list args));
#endif

#if 0
/* Prints formatted output to string STR.  Similar to vsprintf, but the
   additional parameter SIZE limits how much is written into STR.
   STR may be NULL, in which case nothing will be written.
   Returns the string length of the formatted string (which may be larger
   than SIZE).  Upon failure, returns a negative value.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define vsnprintf rpl_vsnprintf
#  endif
#  define GNULIB_overrides_vsnprintf 1
_GL_FUNCDECL_RPL (vsnprintf, int,
                  (char *restrict str, size_t size,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (3, 0)
                  _GL_ARG_NONNULL ((3)));
_GL_CXXALIAS_RPL (vsnprintf, int,
                  (char *restrict str, size_t size,
                   const char *restrict format, va_list args));
# else
#  if !1
_GL_FUNCDECL_SYS (vsnprintf, int,
                  (char *restrict str, size_t size,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (3, 0)
                  _GL_ARG_NONNULL ((3)));
#  endif
_GL_CXXALIAS_SYS (vsnprintf, int,
                  (char *restrict str, size_t size,
                   const char *restrict format, va_list args));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (vsnprintf);
# endif
#elif defined GNULIB_POSIXCHECK
# undef vsnprintf
# if HAVE_RAW_DECL_VSNPRINTF
_GL_WARN_ON_USE (vsnprintf, "vsnprintf is unportable - "
                 "use gnulib module vsnprintf for portability");
# endif
#endif

#if 0
/* Prints formatted output to string STR.
   Returns the string length of the formatted string.  Upon failure,
   returns -1 with errno set.
   Failure code EOVERFLOW can only occur when a width > INT_MAX is used.
   Therefore, if the format string is valid and does not use %ls/%lc
   directives nor widths, the only possible failure code is ENOMEM.  */
_GL_FUNCDECL_SYS (vszprintf, ptrdiff_t,
                  (char *restrict str,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_SYS (vszprintf, ptrdiff_t,
                  (char *restrict str,
                   const char *restrict format, va_list args));
#endif

#if 0
/* Prints formatted output to string STR.
   Returns the string length of the formatted string.  Upon failure,
   returns a negative value.  */
# if 0
#  if !(defined __cplusplus && defined GNULIB_NAMESPACE)
#   define vsprintf rpl_vsprintf
#  endif
#  define GNULIB_overrides_vsprintf 1
_GL_FUNCDECL_RPL (vsprintf, int,
                  (char *restrict str,
                   const char *restrict format, va_list args),
                  _GL_ATTRIBUTE_FORMAT_PRINTF_STANDARD (2, 0)
                  _GL_ARG_NONNULL ((1, 2)));
_GL_CXXALIAS_RPL (vsprintf, int,
                  (char *restrict str,
                   const char *restrict format, va_list args));
# else
/* Need to cast, because on Solaris, the third parameter is
                                                       __va_list args
   and GCC's fixincludes did not change this to __gnuc_va_list.  */
_GL_CXXALIAS_SYS_CAST (vsprintf, int,
                       (char *restrict str,
                        const char *restrict format, va_list args));
# endif
# if __GLIBC__ >= 2
_GL_CXXALIASWARN (vsprintf);
# endif
#elif defined GNULIB_POSIXCHECK
# undef vsprintf
/* Assume vsprintf is always declared.  */
_GL_WARN_ON_USE (vsprintf, "vsprintf is not always POSIX compliant - "
                 "use gnulib module vsprintf-posix for portable "
                      "POSIX compliance");
#endif

#endif /* _GL_STDIO_H */
#endif /* _GL_STDIO_H */
#endif
