/*
 * Copyright (C) 2014-2025 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#include<QStringBuilder>

#include "src/datovka_shared/app_version_info.h"

#define textLineNL(text) \
	(QString("‣ ") % (text) % QLatin1String("<br>"))

QString AppVersionInfo::releaseNewsText(void)
{
	QString content;

	content.append(textLineNL(tr("Added restamping functionality. You may select messages whose timestamps should be tracked. The running application will generate a notification when a tracked timestamp should be renewed.")));
	content.append(textLineNL(tr("Added --conf-basedir and --conf-dir command line options. Those can be used to change the default configuration directory location. These options are not allowed in the portable application.")));
	content.append(textLineNL(tr("Calling e-mail client programs via xdg-email in Linux if available.")));
	content.append(textLineNL(tr("Displaying all available timestamps in signature detail dialogue.")));
	content.append(textLineNL(tr("Data from data boxes can be exported to the mobile application.")));
	content.append(textLineNL(tr("Extended the dialogue content when changing the location of databases for a data box.")));

	return content;
}
