/* structure_model.c generated by valac 0.56.18, the Vala compiler
 * generated from structure_model.vala, do not modify */

/* SPDX-FileCopyrightText: 2011-2012 Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gtex.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;
typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())

#define TYPE_STRUCT_ERROR (struct_error_get_type ())

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
typedef struct _StructureModelPrivate StructureModelPrivate;
enum  {
	STRUCTURE_MODEL_0_PROPERTY,
	STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY,
	STRUCTURE_MODEL_NUM_PROPERTIES
};
static GParamSpec* structure_model_properties[STRUCTURE_MODEL_NUM_PROPERTIES];
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()

struct _StructureModel {
	GtexTreeModelNode parent_instance;
	StructureModelPrivate * priv;
};

struct _StructureModelClass {
	GtexTreeModelNodeClass parent_class;
};

struct _StructureModelPrivate {
	gboolean _emit_signals;
	GNode* _tree;
	guint _nb_nodes;
	GNode* _end_node;
	GeeArrayList* _list_labels;
	GeeArrayList* _list_includes;
	GeeArrayList* _list_tables;
	GeeArrayList* _list_figures;
	GeeArrayList* _list_todos_and_fixmes;
};

static gint StructureModel_private_offset;
static gpointer structure_model_parent_class = NULL;
static GtkTreeModelIface * structure_model_gtk_tree_model_parent_iface = NULL;

VALA_EXTERN GType struct_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType struct_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StructData* struct_data_dup (const StructData* self);
VALA_EXTERN void struct_data_free (StructData* self);
VALA_EXTERN void struct_data_copy (const StructData* self,
                       StructData* dest);
VALA_EXTERN void struct_data_destroy (StructData* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (StructData, struct_data_destroy)
VALA_EXTERN GType struct_list_column_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark struct_error_quark (void);
VALA_EXTERN GType struct_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType structure_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StructureModel, g_object_unref)
static void _struct_data_free0_ (gpointer var);
static gboolean _g_node_free_all_node (GNode* node,
                                GDestroyNotify free_func);
static void _g_node_free_all (GNode* self,
                       GDestroyNotify free_func);
static inline void _g_node_destroy__struct_data_free0_ (GNode* self);
VALA_EXTERN StructureModel* structure_model_new (void);
VALA_EXTERN StructureModel* structure_model_construct (GType object_type);
static void structure_model_reset_simple_lists (StructureModel* self);
static void structure_model_real_get_value (GtkTreeModel* base,
                                     GtkTreeIter* iter,
                                     gint column,
                                     GValue* val);
VALA_EXTERN gchar* structure_get_icon_from_type (StructType type);
VALA_EXTERN gchar* structure_get_type_name (StructType type);
VALA_EXTERN guint structure_model_get_nb_items (StructureModel* self);
VALA_EXTERN GtkTreeIter* structure_model_add_item_at_end (StructureModel* self,
                                              StructData* item);
static void structure_model_search_end_node (StructureModel* self);
VALA_EXTERN gboolean structure_is_section (StructType type);
static GtkTreeIter* structure_model_insert_item_after (StructureModel* self,
                                                GNode* parent,
                                                GNode* sibling,
                                                StructData* item);
VALA_EXTERN GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self,
                                                         GtkTreeIter* section_iter,
                                                         GError** error);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
VALA_EXTERN void structure_model_delete (StructureModel* self,
                             GtkTreeIter* iter);
static GNode* structure_model_delete_node (StructureModel* self,
                                    GNode* node);
static void structure_model_regenerate_simple_lists (StructureModel* self);
VALA_EXTERN void structure_model_modify_data (StructureModel* self,
                                  GtkTreePath* path,
                                  const gchar* text,
                                  GtkTextMark* end_mark);
VALA_EXTERN gboolean structure_model_get_emit_signals (StructureModel* self);
static void structure_model_make_children_between_marks (StructureModel* self,
                                                  GNode* node);
VALA_EXTERN void structure_model_shift_right (StructureModel* self,
                                  GtkTreeIter* iter);
static void structure_model_shift_node (StructureModel* self,
                                 GNode* node,
                                 gboolean shift_right);
static void structure_model_reinsert_node (StructureModel* self,
                                    GNode* node,
                                    gboolean force_first_child);
VALA_EXTERN void structure_model_shift_left (StructureModel* self,
                                 GtkTreeIter* iter);
VALA_EXTERN gboolean structure_model_item_contains_subparagraph (StructureModel* self,
                                                     GtkTreeIter* iter);
static gboolean structure_model_node_contains_subparagraph (StructureModel* self,
                                                     GNode* node);
static void structure_model_insert_node (StructureModel* self,
                                  GNode* node,
                                  gboolean force_first_child);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void structure_model_insert_node_in_list (StructureModel* self,
                                          GNode* node);
static gint structure_model_compare_nodes (GtkTextMark* mark1,
                                    GtkTextMark* mark2);
VALA_EXTERN void structure_model_populate_list (StructureModel* self,
                                    GtkListStore* store,
                                    StructType type);
static GeeArrayList* structure_model_get_list (StructureModel* self,
                                        StructType type);
VALA_EXTERN GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self,
                                                          StructType list_type,
                                                          gint num);
VALA_EXTERN gint structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                                  GtkTreeIter* tree_iter);
static gboolean __lambda62_ (StructureModel* self,
                      GNode* node);
static gboolean ___lambda62__gnode_traverse_func (GNode* node,
                                           gpointer self);
VALA_EXTERN void structure_model_set_emit_signals (StructureModel* self,
                                       gboolean value);
static void structure_model_finalize (GObject * obj);
static GType structure_model_get_type_once (void);
static void _vala_structure_model_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_structure_model_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
struct_data_copy (const StructData* self,
                  StructData* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextMark* _tmp5_;
	(*dest).type = (*self).type;
	_tmp0_ = (*self).text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).text);
	(*dest).text = _tmp1_;
	_tmp2_ = (*self).start_mark;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).start_mark);
	(*dest).start_mark = _tmp3_;
	_tmp4_ = (*self).end_mark;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).end_mark);
	(*dest).end_mark = _tmp5_;
}

void
struct_data_destroy (StructData* self)
{
	_g_free0 ((*self).text);
	_g_object_unref0 ((*self).start_mark);
	_g_object_unref0 ((*self).end_mark);
}

StructData*
struct_data_dup (const StructData* self)
{
	StructData* dup;
	dup = g_new0 (StructData, 1);
	struct_data_copy (self, dup);
	return dup;
}

void
struct_data_free (StructData* self)
{
	struct_data_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
struct_data_get_type_once (void)
{
	GType struct_data_type_id;
	struct_data_type_id = g_boxed_type_register_static ("StructData", (GBoxedCopyFunc) struct_data_dup, (GBoxedFreeFunc) struct_data_free);
	return struct_data_type_id;
}

GType
struct_data_get_type (void)
{
	static gsize struct_data_type_id__once = 0;
	if (g_once_init_enter (&struct_data_type_id__once)) {
		GType struct_data_type_id;
		struct_data_type_id = struct_data_get_type_once ();
		g_once_init_leave (&struct_data_type_id__once, struct_data_type_id);
	}
	return struct_data_type_id__once;
}

 G_GNUC_NO_INLINE static GType
struct_list_column_get_type_once (void)
{
	static const GEnumValue values[] = {{STRUCT_LIST_COLUMN_PIXBUF, "STRUCT_LIST_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_LIST_COLUMN_TEXT, "STRUCT_LIST_COLUMN_TEXT", "text"}, {STRUCT_LIST_COLUMN_TOOLTIP, "STRUCT_LIST_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_LIST_COLUMN_N_COLUMNS, "STRUCT_LIST_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType struct_list_column_type_id;
	struct_list_column_type_id = g_enum_register_static ("StructListColumn", values);
	return struct_list_column_type_id;
}

GType
struct_list_column_get_type (void)
{
	static gsize struct_list_column_type_id__once = 0;
	if (g_once_init_enter (&struct_list_column_type_id__once)) {
		GType struct_list_column_type_id;
		struct_list_column_type_id = struct_list_column_get_type_once ();
		g_once_init_leave (&struct_list_column_type_id__once, struct_list_column_type_id);
	}
	return struct_list_column_type_id__once;
}

GQuark
struct_error_quark (void)
{
	return g_quark_from_static_string ("struct-error-quark");
}

 G_GNUC_NO_INLINE static GType
struct_error_get_type_once (void)
{
	static const GEnumValue values[] = {{STRUCT_ERROR_GENERAL, "STRUCT_ERROR_GENERAL", "general"}, {STRUCT_ERROR_DATA_OUTDATED, "STRUCT_ERROR_DATA_OUTDATED", "data-outdated"}, {0, NULL, NULL}};
	GType struct_error_type_id;
	struct_error_type_id = g_enum_register_static ("StructError", values);
	return struct_error_type_id;
}

GType
struct_error_get_type (void)
{
	static gsize struct_error_type_id__once = 0;
	if (g_once_init_enter (&struct_error_type_id__once)) {
		GType struct_error_type_id;
		struct_error_type_id = struct_error_get_type_once ();
		g_once_init_leave (&struct_error_type_id__once, struct_error_type_id);
	}
	return struct_error_type_id__once;
}

static inline gpointer
structure_model_get_instance_private (StructureModel* self)
{
	return G_STRUCT_MEMBER_P (self, StructureModel_private_offset);
}

static void
_struct_data_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (struct_data_free (var), NULL));
}

static gboolean
_g_node_free_all_node (GNode* node,
                       GDestroyNotify free_func)
{
	(node->data == NULL) ? NULL : (free_func (node->data), NULL);
	return FALSE;
}

static void
_g_node_free_all (GNode* self,
                  GDestroyNotify free_func)
{
	(free_func == NULL) ? NULL : (g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, (GNodeTraverseFunc) _g_node_free_all_node, free_func), NULL);
	g_node_destroy (self);
}

static inline void
_g_node_destroy__struct_data_free0_ (GNode* self)
{
	_g_node_free_all (self, (GDestroyNotify) _struct_data_free0_);
}

static gpointer
_struct_data_dup0 (gpointer self)
{
	return self ? struct_data_dup (self) : NULL;
}

StructureModel*
structure_model_construct (GType object_type)
{
	StructureModel * self = NULL;
	GType* _tmp0_;
	GType* _tmp1_;
	gint _tmp1__length1;
	StructData empty_data = {0};
	StructData _tmp2_ = {0};
	StructData _tmp3_;
	StructData _tmp4_;
	StructData* _tmp5_;
	GNode* _tmp6_;
	GNode* _tmp7_;
	self = (StructureModel*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (GType, 6);
	_tmp0_[0] = G_TYPE_STRING;
	_tmp0_[1] = G_TYPE_STRING;
	_tmp0_[2] = G_TYPE_STRING;
	_tmp0_[3] = gtk_text_mark_get_type ();
	_tmp0_[4] = gtk_text_mark_get_type ();
	_tmp0_[5] = TYPE_STRUCT_TYPE;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 6;
	gtex_tree_model_node_set_column_types ((GtexTreeModelNode*) self, (gint) 6, _tmp1_);
	_tmp1_ = (g_free (_tmp1_), NULL);
	empty_data = _tmp2_;
	_tmp3_ = empty_data;
	_tmp4_ = _tmp3_;
	_tmp5_ = _struct_data_dup0 (&_tmp4_);
	_tmp6_ = g_node_new (_tmp5_);
	(self->priv->_tree == NULL) ? NULL : (self->priv->_tree = (_g_node_destroy__struct_data_free0_ (self->priv->_tree), NULL));
	self->priv->_tree = _tmp6_;
	_tmp7_ = self->priv->_tree;
	gtex_tree_model_node_set_tree ((GtexTreeModelNode*) self, _tmp7_);
	structure_model_reset_simple_lists (self);
	struct_data_destroy (&empty_data);
	return self;
}

StructureModel*
structure_model_new (void)
{
	return structure_model_construct (TYPE_STRUCTURE_MODEL);
}

/*************************************************************************/
static void
structure_model_real_get_value (GtkTreeModel* base,
                                GtkTreeIter* iter,
                                gint column,
                                GValue* val)
{
	StructureModel * self;
	GValue _vala_val = {0};
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructData data = {0};
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructData _tmp5_;
	StructData _tmp6_ = {0};
	self = (StructureModel*) base;
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	g_return_if_fail (gtex_tree_model_node_iter_is_valid ((GtexTreeModelNode*) self, &_tmp0_));
	g_return_if_fail (gtex_tree_model_node_column_index_is_valid ((GtexTreeModelNode*) self, column));
	_tmp1_ = *iter;
	_tmp2_ = gtex_tree_model_node_get_node_from_iter (&_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = *((StructData*) _tmp4_);
	struct_data_copy (&_tmp5_, &_tmp6_);
	data = _tmp6_;
	switch (column) {
		case GTEX_STRUCTURE_COLUMN_TEXT:
		{
			StructData _tmp7_;
			const gchar* _tmp8_;
			GValue _tmp9_ = {0};
			_tmp7_ = data;
			_tmp8_ = _tmp7_.text;
			g_value_init (&_tmp9_, G_TYPE_STRING);
			g_value_set_string (&_tmp9_, _tmp8_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp9_;
			break;
		}
		case GTEX_STRUCTURE_COLUMN_START_MARK:
		{
			StructData _tmp10_;
			GtkTextMark* _tmp11_;
			GValue _tmp12_ = {0};
			_tmp10_ = data;
			_tmp11_ = _tmp10_.start_mark;
			g_value_init (&_tmp12_, gtk_text_mark_get_type ());
			g_value_set_object (&_tmp12_, _tmp11_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp12_;
			break;
		}
		case GTEX_STRUCTURE_COLUMN_END_MARK:
		{
			StructData _tmp13_;
			GtkTextMark* _tmp14_;
			GValue _tmp15_ = {0};
			_tmp13_ = data;
			_tmp14_ = _tmp13_.end_mark;
			g_value_init (&_tmp15_, gtk_text_mark_get_type ());
			g_value_set_object (&_tmp15_, _tmp14_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp15_;
			break;
		}
		case GTEX_STRUCTURE_COLUMN_TYPE:
		{
			StructData _tmp16_;
			GValue _tmp17_ = {0};
			_tmp16_ = data;
			g_value_init (&_tmp17_, TYPE_STRUCT_TYPE);
			g_value_set_enum (&_tmp17_, _tmp16_.type);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp17_;
			break;
		}
		case GTEX_STRUCTURE_COLUMN_PIXBUF:
		{
			StructData _tmp18_;
			gchar* _tmp19_;
			GValue _tmp20_ = {0};
			_tmp18_ = data;
			_tmp19_ = structure_get_icon_from_type (_tmp18_.type);
			g_value_init (&_tmp20_, G_TYPE_STRING);
			g_value_take_string (&_tmp20_, _tmp19_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp20_;
			break;
		}
		case GTEX_STRUCTURE_COLUMN_TOOLTIP:
		{
			StructData _tmp21_;
			gchar* _tmp22_;
			GValue _tmp23_ = {0};
			_tmp21_ = data;
			_tmp22_ = structure_get_type_name (_tmp21_.type);
			g_value_init (&_tmp23_, G_TYPE_STRING);
			g_value_take_string (&_tmp23_, _tmp22_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp23_;
			break;
		}
		default:
		{
			g_return_if_reached ();
		}
	}
	struct_data_destroy (&data);
	if (val) {
		*val = _vala_val;
	} else {
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	}
}

/*************************************************************************/
guint
structure_model_get_nb_items (StructureModel* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_nb_nodes;
	return result;
}

GtkTreeIter*
structure_model_add_item_at_end (StructureModel* self,
                                 StructData* item)
{
	GNode* _tmp0_;
	StructType item_depth = 0;
	StructData _tmp1_;
	GNode* parent = NULL;
	GNode* _tmp2_;
	GNode* prev_sibling = NULL;
	GtkTreeIter* end_iter = NULL;
	GNode* _tmp11_;
	GNode* _tmp12_;
	StructData _tmp13_;
	GtkTreeIter* _tmp14_;
	GtkTreeIter* _tmp15_;
	GtkTreeIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->_end_node;
	if (_tmp0_ == NULL) {
		structure_model_search_end_node (self);
	}
	_tmp1_ = *item;
	item_depth = _tmp1_.type;
	_tmp2_ = self->priv->_end_node;
	parent = _tmp2_;
	prev_sibling = NULL;
	while (TRUE) {
		GNode* _tmp3_;
		GNode* _tmp4_;
		StructType cur_depth = 0;
		GNode* _tmp5_;
		gconstpointer _tmp6_;
		gboolean _tmp7_ = FALSE;
		GNode* _tmp8_;
		GNode* _tmp9_;
		GNode* _tmp10_;
		_tmp3_ = parent;
		_tmp4_ = self->priv->_tree;
		if (_tmp3_ == _tmp4_) {
			break;
		}
		_tmp5_ = parent;
		_tmp6_ = _tmp5_->data;
		cur_depth = (*((StructData*) _tmp6_)).type;
		if (structure_is_section (cur_depth)) {
			_tmp7_ = cur_depth < item_depth;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			break;
		}
		_tmp8_ = parent;
		prev_sibling = _tmp8_;
		_tmp9_ = parent;
		_tmp10_ = _tmp9_->parent;
		parent = _tmp10_;
	}
	_tmp11_ = parent;
	_tmp12_ = prev_sibling;
	_tmp13_ = *item;
	_tmp14_ = structure_model_insert_item_after (self, _tmp11_, _tmp12_, &_tmp13_);
	end_iter = _tmp14_;
	_tmp15_ = end_iter;
	if (_tmp15_ != NULL) {
		GtkTreeIter* _tmp16_;
		GtkTreeIter _tmp17_;
		GNode* _tmp18_;
		_tmp16_ = end_iter;
		_tmp17_ = *_tmp16_;
		_tmp18_ = gtex_tree_model_node_get_node_from_iter (&_tmp17_);
		self->priv->_end_node = _tmp18_;
	}
	result = end_iter;
	return result;
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

GtkTreeIter*
structure_model_get_next_sibling_or_parent (StructureModel* self,
                                            GtkTreeIter* section_iter,
                                            GError** error)
{
	GtkTreeIter _tmp0_;
	GNode* cur_node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	GNode* _tmp4_;
	gconstpointer _tmp5_;
	GError* _inner_error0_ = NULL;
	GtkTreeIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (section_iter != NULL, NULL);
	_tmp0_ = *section_iter;
	if (!gtex_tree_model_node_iter_is_valid ((GtexTreeModelNode*) self, &_tmp0_)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not valid.");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = *section_iter;
	_tmp3_ = gtex_tree_model_node_get_node_from_iter (&_tmp2_);
	cur_node = _tmp3_;
	_tmp4_ = cur_node;
	_tmp5_ = _tmp4_->data;
	if (!structure_is_section ((*((StructData*) _tmp5_)).type)) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not a section.");
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		GNode* _tmp8_;
		GNode* next_sibling_node = NULL;
		GNode* _tmp11_;
		GNode* _tmp12_;
		GNode* _tmp13_;
		GNode* _tmp17_;
		GNode* _tmp18_;
		_tmp8_ = cur_node;
		if (_tmp8_ != NULL) {
			GNode* _tmp9_;
			GNode* _tmp10_;
			_tmp9_ = cur_node;
			_tmp10_ = self->priv->_tree;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		if (!_tmp7_) {
			break;
		}
		_tmp11_ = cur_node;
		_tmp12_ = g_node_next_sibling (_tmp11_);
		next_sibling_node = _tmp12_;
		_tmp13_ = next_sibling_node;
		if (_tmp13_ != NULL) {
			GtkTreeIter ret = {0};
			GNode* _tmp14_;
			GtkTreeIter _tmp15_ = {0};
			GtkTreeIter* _tmp16_;
			memset (&ret, 0, sizeof (GtkTreeIter));
			_tmp14_ = next_sibling_node;
			gtex_tree_model_node_get_iter_at_node ((GtexTreeModelNode*) self, &_tmp15_, _tmp14_);
			ret = _tmp15_;
			_tmp16_ = __vala_GtkTreeIter_copy0 (&ret);
			result = _tmp16_;
			return result;
		}
		_tmp17_ = cur_node;
		_tmp18_ = _tmp17_->parent;
		cur_node = _tmp18_;
	}
	result = NULL;
	return result;
}

void
structure_model_delete (StructureModel* self,
                        GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* _tmp3_;
	GNode* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	g_return_if_fail (gtex_tree_model_node_iter_is_valid ((GtexTreeModelNode*) self, &_tmp0_));
	_tmp1_ = *iter;
	_tmp2_ = gtex_tree_model_node_get_node_from_iter (&_tmp1_);
	node = _tmp2_;
	_tmp3_ = structure_model_delete_node (self, node);
	_tmp4_ = _tmp3_;
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_node_destroy__struct_data_free0_ (_tmp4_), NULL));
	self->priv->_end_node = NULL;
	structure_model_regenerate_simple_lists (self);
}

void
structure_model_modify_data (StructureModel* self,
                             GtkTreePath* path,
                             const gchar* text,
                             GtkTextMark* end_mark)
{
	GtkTreeIter iter = {0};
	gboolean iter_is_valid = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GNode* node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GNode* _tmp5_;
	gconstpointer _tmp6_;
	gchar* _tmp7_;
	GNode* _tmp8_;
	gconstpointer _tmp9_;
	GtkTextMark* _tmp10_;
	gboolean _tmp11_;
	GNode* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (end_mark != NULL);
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
	iter = _tmp0_;
	iter_is_valid = _tmp1_;
	g_return_if_fail (iter_is_valid);
	_tmp2_ = iter;
	_tmp3_ = gtex_tree_model_node_get_node_from_iter (&_tmp2_);
	node = _tmp3_;
	gtex_tree_model_node_change_stamp ((GtexTreeModelNode*) self);
	_tmp4_ = text;
	if (_tmp4_ == NULL) {
		_tmp4_ = "";
	}
	_tmp5_ = node;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = g_strdup (_tmp4_);
	_g_free0 ((*((StructData*) _tmp6_)).text);
	(*((StructData*) _tmp6_)).text = _tmp7_;
	_tmp8_ = node;
	_tmp9_ = _tmp8_->data;
	_tmp10_ = _g_object_ref0 (end_mark);
	_g_object_unref0 ((*((StructData*) _tmp9_)).end_mark);
	(*((StructData*) _tmp9_)).end_mark = _tmp10_;
	_tmp11_ = self->priv->_emit_signals;
	if (_tmp11_) {
		GtkTreeIter _tmp12_;
		_tmp12_ = iter;
		gtk_tree_model_row_changed ((GtkTreeModel*) self, path, &_tmp12_);
	}
	_tmp13_ = node;
	structure_model_make_children_between_marks (self, _tmp13_);
}

void
structure_model_shift_right (StructureModel* self,
                             GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructType type = 0;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	gboolean _tmp5_ = FALSE;
	StructType new_type = 0;
	GNode* new_parent = NULL;
	GNode* _tmp6_;
	GNode* _tmp7_;
	gint new_pos = 0;
	gboolean _tmp8_ = FALSE;
	GNode* _tmp9_;
	GNode* node_unlinked = NULL;
	GNode* _tmp16_;
	GNode* _tmp17_;
	GNode* _tmp18_;
	GNode* _tmp19_;
	GNode* _tmp20_;
	GNode* _tmp21_;
	GNode* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	g_return_if_fail (gtex_tree_model_node_iter_is_valid ((GtexTreeModelNode*) self, &_tmp0_));
	_tmp1_ = *iter;
	_tmp2_ = gtex_tree_model_node_get_node_from_iter (&_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->data;
	type = (*((StructData*) _tmp4_)).type;
	if (structure_is_section (type)) {
		_tmp5_ = type != STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp5_ = FALSE;
	}
	g_return_if_fail (_tmp5_);
	new_type = type + 1;
	_tmp6_ = node;
	_tmp7_ = g_node_prev_sibling (_tmp6_);
	new_parent = _tmp7_;
	_tmp9_ = new_parent;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		GNode* _tmp10_;
		gconstpointer _tmp11_;
		_tmp10_ = new_parent;
		_tmp11_ = _tmp10_->data;
		_tmp8_ = new_type <= (*((StructData*) _tmp11_)).type;
	}
	if (_tmp8_) {
		GNode* _tmp12_;
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp15_;
		_tmp12_ = node;
		_tmp13_ = _tmp12_->parent;
		new_parent = _tmp13_;
		_tmp14_ = new_parent;
		_tmp15_ = node;
		new_pos = g_node_child_position (_tmp14_, _tmp15_);
	} else {
		new_pos = -1;
	}
	_tmp16_ = node;
	_tmp17_ = structure_model_delete_node (self, _tmp16_);
	node_unlinked = _tmp17_;
	_tmp18_ = node_unlinked;
	structure_model_shift_node (self, _tmp18_, TRUE);
	_tmp19_ = new_parent;
	_tmp20_ = node_unlinked;
	node_unlinked = NULL;
	_tmp21_ = g_node_insert (_tmp19_, new_pos, _tmp20_);
	node = _tmp21_;
	_tmp22_ = node;
	structure_model_reinsert_node (self, _tmp22_, FALSE);
	(node_unlinked == NULL) ? NULL : (node_unlinked = (_g_node_destroy__struct_data_free0_ (node_unlinked), NULL));
}

void
structure_model_shift_left (StructureModel* self,
                            GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructType type = 0;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	gboolean _tmp5_ = FALSE;
	StructType new_type = 0;
	GNode* new_parent = NULL;
	gint new_pos = 0;
	GNode* parent = NULL;
	GNode* _tmp6_;
	GNode* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GNode* _tmp9_;
	GNode* _tmp10_;
	GNode* sibling = NULL;
	GNode* _tmp20_;
	GNode* _tmp21_;
	GNode* node_unlinked = NULL;
	GNode* _tmp22_;
	GNode* _tmp23_;
	GNode* _tmp24_;
	GNode* _tmp35_;
	GNode* _tmp36_;
	GNode* _tmp37_;
	GNode* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	g_return_if_fail (gtex_tree_model_node_iter_is_valid ((GtexTreeModelNode*) self, &_tmp0_));
	_tmp1_ = *iter;
	_tmp2_ = gtex_tree_model_node_get_node_from_iter (&_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->data;
	type = (*((StructData*) _tmp4_)).type;
	if (STRUCT_TYPE_PART < type) {
		_tmp5_ = type <= STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp5_ = FALSE;
	}
	g_return_if_fail (_tmp5_);
	new_type = type - 1;
	_tmp6_ = node;
	_tmp7_ = _tmp6_->parent;
	parent = _tmp7_;
	_tmp9_ = parent;
	_tmp10_ = self->priv->_tree;
	if (_tmp9_ == _tmp10_) {
		_tmp8_ = TRUE;
	} else {
		GNode* _tmp11_;
		gconstpointer _tmp12_;
		_tmp11_ = parent;
		_tmp12_ = _tmp11_->data;
		_tmp8_ = (*((StructData*) _tmp12_)).type < new_type;
	}
	if (_tmp8_) {
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp15_;
		_tmp13_ = parent;
		new_parent = _tmp13_;
		_tmp14_ = parent;
		_tmp15_ = node;
		new_pos = g_node_child_position (_tmp14_, _tmp15_);
	} else {
		GNode* _tmp16_;
		GNode* _tmp17_;
		GNode* _tmp18_;
		GNode* _tmp19_;
		_tmp16_ = parent;
		_tmp17_ = _tmp16_->parent;
		new_parent = _tmp17_;
		_tmp18_ = new_parent;
		_tmp19_ = parent;
		new_pos = g_node_child_position (_tmp18_, _tmp19_) + 1;
	}
	_tmp20_ = node;
	_tmp21_ = g_node_next_sibling (_tmp20_);
	sibling = _tmp21_;
	_tmp22_ = node;
	_tmp23_ = structure_model_delete_node (self, _tmp22_);
	node_unlinked = _tmp23_;
	_tmp24_ = node_unlinked;
	structure_model_shift_node (self, _tmp24_, FALSE);
	while (TRUE) {
		GNode* _tmp25_;
		GNode* _tmp26_;
		gconstpointer _tmp27_;
		GNode* next_sibling = NULL;
		GNode* _tmp28_;
		GNode* _tmp29_;
		GNode* new_child = NULL;
		GNode* _tmp30_;
		GNode* _tmp31_;
		GNode* _tmp32_;
		GNode* _tmp33_;
		GNode* _tmp34_;
		_tmp25_ = sibling;
		if (!(_tmp25_ != NULL)) {
			break;
		}
		_tmp26_ = sibling;
		_tmp27_ = _tmp26_->data;
		if ((*((StructData*) _tmp27_)).type <= new_type) {
			break;
		}
		_tmp28_ = sibling;
		_tmp29_ = g_node_next_sibling (_tmp28_);
		next_sibling = _tmp29_;
		_tmp30_ = sibling;
		_tmp31_ = structure_model_delete_node (self, _tmp30_);
		new_child = _tmp31_;
		_tmp32_ = node_unlinked;
		_tmp33_ = new_child;
		new_child = NULL;
		g_node_append (_tmp32_, _tmp33_);
		_tmp34_ = next_sibling;
		sibling = _tmp34_;
		(new_child == NULL) ? NULL : (new_child = (_g_node_destroy__struct_data_free0_ (new_child), NULL));
	}
	_tmp35_ = new_parent;
	_tmp36_ = node_unlinked;
	node_unlinked = NULL;
	_tmp37_ = g_node_insert (_tmp35_, new_pos, _tmp36_);
	node = _tmp37_;
	_tmp38_ = node;
	structure_model_reinsert_node (self, _tmp38_, FALSE);
	(node_unlinked == NULL) ? NULL : (node_unlinked = (_g_node_destroy__struct_data_free0_ (node_unlinked), NULL));
}

gboolean
structure_model_item_contains_subparagraph (StructureModel* self,
                                            GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	g_return_val_if_fail (gtex_tree_model_node_iter_is_valid ((GtexTreeModelNode*) self, &_tmp0_), FALSE);
	_tmp1_ = *iter;
	_tmp2_ = gtex_tree_model_node_get_node_from_iter (&_tmp1_);
	node = _tmp2_;
	result = structure_model_node_contains_subparagraph (self, node);
	return result;
}

static gboolean
structure_model_node_contains_subparagraph (StructureModel* self,
                                            GNode* node)
{
	StructType type = 0;
	gconstpointer _tmp0_;
	GNode* child = NULL;
	GNode* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node->data;
	type = (*((StructData*) _tmp0_)).type;
	if (type == STRUCT_TYPE_SUBPARAGRAPH) {
		result = TRUE;
		return result;
	}
	if (!structure_is_section (type)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = g_node_first_child (node);
	child = _tmp1_;
	while (TRUE) {
		GNode* _tmp2_;
		GNode* _tmp3_;
		GNode* _tmp4_;
		GNode* _tmp5_;
		_tmp2_ = child;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = child;
		if (structure_model_node_contains_subparagraph (self, _tmp3_)) {
			result = TRUE;
			return result;
		}
		_tmp4_ = child;
		_tmp5_ = g_node_next_sibling (_tmp4_);
		child = _tmp5_;
	}
	result = FALSE;
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
structure_model_insert_node (StructureModel* self,
                             GNode* node,
                             gboolean force_first_child)
{
	guint _tmp0_;
	gboolean _tmp1_;
	GtkTreeIter item_iter = {0};
	GtkTreeIter _tmp2_ = {0};
	GtkTreePath* item_path = NULL;
	GtkTreeIter _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreePath* _tmp5_;
	GtkTreeIter _tmp6_;
	GNode* parent = NULL;
	GNode* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GNode* _tmp9_;
	GNode* _tmp10_;
	gboolean first_child = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	gtex_tree_model_node_change_stamp ((GtexTreeModelNode*) self);
	_tmp0_ = self->priv->_nb_nodes;
	self->priv->_nb_nodes = _tmp0_ + 1;
	_tmp1_ = self->priv->_emit_signals;
	if (!_tmp1_) {
		return;
	}
	memset (&item_iter, 0, sizeof (GtkTreeIter));
	gtex_tree_model_node_get_iter_at_node ((GtexTreeModelNode*) self, &_tmp2_, node);
	item_iter = _tmp2_;
	_tmp3_ = item_iter;
	_tmp4_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp3_);
	item_path = _tmp4_;
	_tmp5_ = item_path;
	_tmp6_ = item_iter;
	gtk_tree_model_row_inserted ((GtkTreeModel*) self, _tmp5_, &_tmp6_);
	_tmp7_ = node->parent;
	parent = _tmp7_;
	_tmp9_ = parent;
	_tmp10_ = self->priv->_tree;
	if (_tmp9_ != _tmp10_) {
		GNode* _tmp11_;
		GNode* _tmp12_;
		_tmp11_ = parent;
		_tmp12_ = _tmp11_->children;
		_tmp8_ = _tmp12_ == node;
	} else {
		_tmp8_ = FALSE;
	}
	first_child = _tmp8_;
	if (force_first_child) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = first_child;
	}
	if (_tmp13_) {
		GtkTreeIter parent_iter = {0};
		GNode* _tmp14_;
		GtkTreeIter _tmp15_ = {0};
		GtkTreePath* parent_path = NULL;
		GtkTreeIter _tmp16_;
		GtkTreePath* _tmp17_;
		GtkTreePath* _tmp18_;
		GtkTreeIter _tmp19_;
		memset (&parent_iter, 0, sizeof (GtkTreeIter));
		_tmp14_ = parent;
		gtex_tree_model_node_get_iter_at_node ((GtexTreeModelNode*) self, &_tmp15_, _tmp14_);
		parent_iter = _tmp15_;
		_tmp16_ = parent_iter;
		_tmp17_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp16_);
		parent_path = _tmp17_;
		_tmp18_ = parent_path;
		_tmp19_ = parent_iter;
		gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp18_, &_tmp19_);
		__vala_GtkTreePath_free0 (parent_path);
	}
	__vala_GtkTreePath_free0 (item_path);
}

static GNode*
g_node_unlink_vala (GNode* self)
{
	void* ptr = NULL;
	void* _tmp0_;
	GNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	ptr = self;
	g_node_unlink (self);
	_tmp0_ = ptr;
	ptr = NULL;
	result = (GNode*) _tmp0_;
	return result;
}

static GNode*
structure_model_delete_node (StructureModel* self,
                             GNode* node)
{
	GtkTreePath* path = NULL;
	GNode* parent = NULL;
	gboolean _tmp0_;
	GNode* node_unlinked = NULL;
	GNode* _tmp5_;
	GNode* _tmp6_;
	gboolean _tmp7_;
	GNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	gtex_tree_model_node_change_stamp ((GtexTreeModelNode*) self);
	path = NULL;
	parent = NULL;
	_tmp0_ = self->priv->_emit_signals;
	if (_tmp0_) {
		GtkTreeIter iter = {0};
		GtkTreeIter _tmp1_ = {0};
		GtkTreeIter _tmp2_;
		GtkTreePath* _tmp3_;
		GNode* _tmp4_;
		memset (&iter, 0, sizeof (GtkTreeIter));
		gtex_tree_model_node_get_iter_at_node ((GtexTreeModelNode*) self, &_tmp1_, node);
		iter = _tmp1_;
		_tmp2_ = iter;
		_tmp3_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp2_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp3_;
		_tmp4_ = node->parent;
		parent = _tmp4_;
	}
	_tmp5_ = g_node_unlink_vala (node);
	node_unlinked = _tmp5_;
	_tmp6_ = node_unlinked;
	self->priv->_nb_nodes = self->priv->_nb_nodes - g_node_n_nodes (_tmp6_, G_TRAVERSE_ALL);
	_tmp7_ = self->priv->_emit_signals;
	if (_tmp7_) {
		GtkTreePath* _tmp8_;
		gboolean _tmp9_ = FALSE;
		GNode* _tmp10_;
		GNode* _tmp11_;
		_tmp8_ = path;
		gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp8_);
		_tmp10_ = parent;
		_tmp11_ = self->priv->_tree;
		if (_tmp10_ != _tmp11_) {
			GNode* _tmp12_;
			GNode* _tmp13_;
			_tmp12_ = parent;
			_tmp13_ = _tmp12_->children;
			_tmp9_ = _tmp13_ == NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkTreeIter parent_iter = {0};
			GNode* _tmp14_;
			GtkTreeIter _tmp15_ = {0};
			GtkTreePath* parent_path = NULL;
			GtkTreeIter _tmp16_;
			GtkTreePath* _tmp17_;
			GtkTreePath* _tmp18_;
			GtkTreeIter _tmp19_;
			memset (&parent_iter, 0, sizeof (GtkTreeIter));
			_tmp14_ = parent;
			gtex_tree_model_node_get_iter_at_node ((GtexTreeModelNode*) self, &_tmp15_, _tmp14_);
			parent_iter = _tmp15_;
			_tmp16_ = parent_iter;
			_tmp17_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp16_);
			parent_path = _tmp17_;
			_tmp18_ = parent_path;
			_tmp19_ = parent_iter;
			gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp18_, &_tmp19_);
			__vala_GtkTreePath_free0 (parent_path);
		}
	}
	result = node_unlinked;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static void
structure_model_shift_node (StructureModel* self,
                            GNode* node,
                            gboolean shift_right)
{
	gconstpointer _tmp0_;
	GNode* child = NULL;
	GNode* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->data;
	if (!structure_is_section ((*((StructData*) _tmp0_)).type)) {
		return;
	}
	if (shift_right) {
		gconstpointer _tmp1_;
		_tmp1_ = node->data;
		if ((*((StructData*) _tmp1_)).type != STRUCT_TYPE_SUBPARAGRAPH) {
			gconstpointer _tmp2_;
			gconstpointer _tmp3_;
			_tmp2_ = node->data;
			_tmp3_ = node->data;
			(*((StructData*) _tmp3_)).type = (*((StructData*) _tmp3_)).type + 1;
		}
	} else {
		gconstpointer _tmp4_;
		_tmp4_ = node->data;
		if ((*((StructData*) _tmp4_)).type != STRUCT_TYPE_PART) {
			gconstpointer _tmp5_;
			gconstpointer _tmp6_;
			_tmp5_ = node->data;
			_tmp6_ = node->data;
			(*((StructData*) _tmp6_)).type = (*((StructData*) _tmp6_)).type - 1;
		}
	}
	_tmp7_ = g_node_first_child (node);
	child = _tmp7_;
	while (TRUE) {
		GNode* _tmp8_;
		GNode* _tmp9_;
		GNode* _tmp10_;
		GNode* _tmp11_;
		_tmp8_ = child;
		if (!(_tmp8_ != NULL)) {
			break;
		}
		_tmp9_ = child;
		structure_model_shift_node (self, _tmp9_, shift_right);
		_tmp10_ = child;
		_tmp11_ = g_node_next_sibling (_tmp10_);
		child = _tmp11_;
	}
}

static void
structure_model_reinsert_node (StructureModel* self,
                               GNode* node,
                               gboolean force_first_child)
{
	GNode* child = NULL;
	GNode* _tmp0_;
	gboolean first_child = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	structure_model_insert_node (self, node, force_first_child);
	_tmp0_ = g_node_first_child (node);
	child = _tmp0_;
	first_child = TRUE;
	while (TRUE) {
		GNode* _tmp1_;
		GNode* _tmp2_;
		GNode* _tmp3_;
		GNode* _tmp4_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		structure_model_reinsert_node (self, _tmp2_, first_child);
		_tmp3_ = child;
		_tmp4_ = g_node_next_sibling (_tmp3_);
		child = _tmp4_;
		first_child = FALSE;
	}
}

static GtkTreeIter*
structure_model_insert_item_after (StructureModel* self,
                                   GNode* parent,
                                   GNode* sibling,
                                   StructData* item)
{
	StructData _tmp0_;
	const gchar* _tmp1_;
	GNode* new_node = NULL;
	StructData _tmp2_;
	StructData _tmp3_;
	StructData* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp7_ = {0};
	GtkTreeIter* _tmp8_;
	GtkTreeIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = *item;
	_tmp1_ = _tmp0_.text;
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
	_tmp2_ = *item;
	_tmp3_ = _tmp2_;
	_tmp4_ = _struct_data_dup0 (&_tmp3_);
	_tmp5_ = g_node_new (_tmp4_);
	_tmp6_ = g_node_insert_after (parent, sibling, _tmp5_);
	new_node = _tmp6_;
	structure_model_insert_node (self, new_node, FALSE);
	structure_model_insert_node_in_list (self, new_node);
	memset (&iter, 0, sizeof (GtkTreeIter));
	gtex_tree_model_node_get_iter_at_node ((GtexTreeModelNode*) self, &_tmp7_, new_node);
	iter = _tmp7_;
	_tmp8_ = __vala_GtkTreeIter_copy0 (&iter);
	result = _tmp8_;
	return result;
}

static void
structure_model_make_children_between_marks (StructureModel* self,
                                             GNode* node)
{
	StructData data = {0};
	gconstpointer _tmp0_;
	StructData _tmp1_;
	StructData _tmp2_ = {0};
	StructData _tmp3_;
	GtkTextMark* _tmp4_;
	GNode* sibling = NULL;
	GNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->data;
	_tmp1_ = *((StructData*) _tmp0_);
	struct_data_copy (&_tmp1_, &_tmp2_);
	data = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = _tmp3_.end_mark;
	if (_tmp4_ == NULL) {
		struct_data_destroy (&data);
		return;
	}
	_tmp5_ = g_node_next_sibling (node);
	sibling = _tmp5_;
	while (TRUE) {
		GNode* _tmp6_;
		StructData sibling_data = {0};
		GNode* _tmp7_;
		gconstpointer _tmp8_;
		StructData _tmp9_;
		StructData _tmp10_ = {0};
		StructData _tmp11_;
		StructData _tmp12_;
		GtkTextMark* _tmp13_;
		StructData _tmp14_;
		GtkTextMark* _tmp15_;
		GNode* sibling_unlinked = NULL;
		GNode* _tmp16_;
		GNode* _tmp17_;
		GNode* new_child = NULL;
		GNode* _tmp18_;
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
		_tmp6_ = sibling;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = sibling;
		_tmp8_ = _tmp7_->data;
		_tmp9_ = *((StructData*) _tmp8_);
		struct_data_copy (&_tmp9_, &_tmp10_);
		sibling_data = _tmp10_;
		_tmp11_ = sibling_data;
		if (structure_is_section (_tmp11_.type)) {
			struct_data_destroy (&sibling_data);
			break;
		}
		_tmp12_ = data;
		_tmp13_ = _tmp12_.end_mark;
		_tmp14_ = sibling_data;
		_tmp15_ = _tmp14_.start_mark;
		if (structure_model_compare_nodes (_tmp13_, _tmp15_) <= 0) {
			struct_data_destroy (&sibling_data);
			break;
		}
		_tmp16_ = sibling;
		_tmp17_ = structure_model_delete_node (self, _tmp16_);
		sibling_unlinked = _tmp17_;
		_tmp18_ = sibling_unlinked;
		sibling_unlinked = NULL;
		_tmp19_ = g_node_append (node, _tmp18_);
		new_child = _tmp19_;
		_tmp20_ = new_child;
		structure_model_insert_node (self, _tmp20_, FALSE);
		_tmp21_ = g_node_next_sibling (node);
		sibling = _tmp21_;
		(sibling_unlinked == NULL) ? NULL : (sibling_unlinked = (_g_node_destroy__struct_data_free0_ (sibling_unlinked), NULL));
		struct_data_destroy (&sibling_data);
	}
	struct_data_destroy (&data);
}

static void
structure_model_search_end_node (StructureModel* self)
{
	GNode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tree;
	self->priv->_end_node = _tmp0_;
	while (TRUE) {
		GNode* _tmp1_;
		GNode* _tmp2_;
		GNode* _tmp3_;
		_tmp1_ = self->priv->_end_node;
		if (!(!G_NODE_IS_LEAF (_tmp1_))) {
			break;
		}
		_tmp2_ = self->priv->_end_node;
		_tmp3_ = g_node_last_child (_tmp2_);
		self->priv->_end_node = _tmp3_;
	}
}

static gint
structure_model_compare_nodes (GtkTextMark* mark1,
                               GtkTextMark* mark2)
{
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter iter1 = {0};
	GtkTextIter iter2 = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
	gint result;
	g_return_val_if_fail (mark1 != NULL, 0);
	g_return_val_if_fail (mark2 != NULL, 0);
	_tmp0_ = gtk_text_mark_get_buffer (mark1);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = gtk_text_mark_get_buffer (mark2);
	g_return_val_if_fail (doc == _tmp2_, 0);
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp3_, mark1);
	iter1 = _tmp3_;
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp4_, mark2);
	iter2 = _tmp4_;
	_tmp5_ = iter2;
	result = gtk_text_iter_compare (&iter1, &_tmp5_);
	_g_object_unref0 (doc);
	return result;
}

/*************************************************************************/
void
structure_model_populate_list (StructureModel* self,
                               GtkListStore* store,
                               StructType type)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = structure_model_get_list (self, type);
	list = _tmp0_;
	_tmp1_ = list;
	g_return_if_fail (_tmp1_ != NULL);
	{
		GeeArrayList* _node_list = NULL;
		GeeArrayList* _tmp2_;
		gint _node_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _node_index = 0;
		_tmp2_ = list;
		_node_list = _tmp2_;
		_tmp3_ = _node_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_node_size = _tmp5_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			GNode* node = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			StructData data = {0};
			GNode* _tmp10_;
			gconstpointer _tmp11_;
			StructData _tmp12_;
			StructData _tmp13_ = {0};
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp14_ = {0};
			GtkTreeIter _tmp15_;
			StructData _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			StructData _tmp19_;
			const gchar* _tmp20_;
			StructData _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_node_index = _node_index + 1;
			_tmp6_ = _node_index;
			_tmp7_ = _node_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _node_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _node_index);
			node = (GNode*) _tmp9_;
			_tmp10_ = node;
			_tmp11_ = _tmp10_->data;
			_tmp12_ = *((StructData*) _tmp11_);
			struct_data_copy (&_tmp12_, &_tmp13_);
			data = _tmp13_;
			gtk_list_store_append (store, &_tmp14_);
			iter = _tmp14_;
			_tmp15_ = iter;
			_tmp16_ = data;
			_tmp17_ = structure_get_icon_from_type (_tmp16_.type);
			_tmp18_ = _tmp17_;
			_tmp19_ = data;
			_tmp20_ = _tmp19_.text;
			_tmp21_ = data;
			_tmp22_ = structure_get_type_name (_tmp21_.type);
			_tmp23_ = _tmp22_;
			gtk_list_store_set (store, &_tmp15_, STRUCT_LIST_COLUMN_PIXBUF, _tmp18_, STRUCT_LIST_COLUMN_TEXT, _tmp20_, STRUCT_LIST_COLUMN_TOOLTIP, _tmp23_, -1);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp18_);
			struct_data_destroy (&data);
		}
	}
	_g_object_unref0 (list);
}

GtkTreePath*
structure_model_get_tree_path_from_list_num (StructureModel* self,
                                             StructType list_type,
                                             gint num)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTreeIter iter = {0};
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	GtkTreeIter _tmp9_;
	GtkTreePath* _tmp10_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = structure_model_get_list (self, list_type);
	list = _tmp0_;
	_tmp1_ = list;
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
	if (0 <= num) {
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp2_ = num < _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	memset (&iter, 0, sizeof (GtkTreeIter));
	_tmp6_ = list;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, num);
	gtex_tree_model_node_get_iter_at_node ((GtexTreeModelNode*) self, &_tmp8_, (GNode*) _tmp7_);
	iter = _tmp8_;
	_tmp9_ = iter;
	_tmp10_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (list);
	return result;
}

gint
structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                             GtkTreeIter* tree_iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GeeArrayList* list = NULL;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (tree_iter != NULL, 0);
	_tmp0_ = *tree_iter;
	g_return_val_if_fail (gtex_tree_model_node_iter_is_valid ((GtexTreeModelNode*) self, &_tmp0_), -1);
	_tmp1_ = *tree_iter;
	_tmp2_ = gtex_tree_model_node_get_node_from_iter (&_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = structure_model_get_list (self, (*((StructData*) _tmp4_)).type);
	list = _tmp5_;
	_tmp6_ = list;
	g_return_val_if_fail (_tmp6_ != NULL, -1);
	{
		gint num = 0;
		num = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GeeArrayList* _tmp12_;
				gpointer _tmp13_;
				GNode* _tmp14_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = num;
					num = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = list;
				_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (!(num < _tmp11_)) {
					break;
				}
				_tmp12_ = list;
				_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, num);
				_tmp14_ = node;
				if (((GNode*) _tmp13_) == _tmp14_) {
					result = num;
					_g_object_unref0 (list);
					return result;
				}
			}
		}
	}
	g_return_val_if_reached (-1);
}

static void
structure_model_insert_node_in_list (StructureModel* self,
                                     GNode* node)
{
	StructData item = {0};
	gconstpointer _tmp0_;
	StructData _tmp1_;
	StructData _tmp2_ = {0};
	GeeArrayList* list = NULL;
	StructData _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->data;
	_tmp1_ = *((StructData*) _tmp0_);
	struct_data_copy (&_tmp1_, &_tmp2_);
	item = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = structure_model_get_list (self, _tmp3_.type);
	list = _tmp4_;
	_tmp5_ = list;
	if (_tmp5_ != NULL) {
		GeeArrayList* _tmp6_;
		_tmp6_ = list;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, node);
	}
	_g_object_unref0 (list);
	struct_data_destroy (&item);
}

static gboolean
__lambda62_ (StructureModel* self,
             GNode* node)
{
	gboolean result;
	g_return_val_if_fail (node != NULL, FALSE);
	structure_model_insert_node_in_list (self, node);
	result = FALSE;
	return result;
}

static gboolean
___lambda62__gnode_traverse_func (GNode* node,
                                  gpointer self)
{
	gboolean result;
	result = __lambda62_ ((StructureModel*) self, node);
	return result;
}

static void
structure_model_regenerate_simple_lists (StructureModel* self)
{
	GNode* _tmp0_;
	g_return_if_fail (self != NULL);
	structure_model_reset_simple_lists (self);
	_tmp0_ = self->priv->_tree;
	g_node_traverse (_tmp0_, G_PRE_ORDER, G_TRAVERSE_ALL, -1, ___lambda62__gnode_traverse_func, self);
}

static void
structure_model_reset_simple_lists (StructureModel* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_labels);
	self->priv->_list_labels = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_includes);
	self->priv->_list_includes = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_tables);
	self->priv->_list_tables = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_figures);
	self->priv->_list_figures = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
	self->priv->_list_todos_and_fixmes = _tmp4_;
}

static GeeArrayList*
structure_model_get_list (StructureModel* self,
                          StructType type)
{
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (structure_is_section (type)) {
		result = NULL;
		return result;
	}
	switch (type) {
		case STRUCT_TYPE_LABEL:
		{
			GeeArrayList* _tmp0_;
			GeeArrayList* _tmp1_;
			_tmp0_ = self->priv->_list_labels;
			_tmp1_ = _g_object_ref0 (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case STRUCT_TYPE_INCLUDE:
		{
			GeeArrayList* _tmp2_;
			GeeArrayList* _tmp3_;
			_tmp2_ = self->priv->_list_includes;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case STRUCT_TYPE_TABLE:
		{
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			_tmp4_ = self->priv->_list_tables;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case STRUCT_TYPE_FIGURE:
		case STRUCT_TYPE_IMAGE:
		{
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
			_tmp6_ = self->priv->_list_figures;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case STRUCT_TYPE_TODO:
		case STRUCT_TYPE_FIXME:
		{
			GeeArrayList* _tmp8_;
			GeeArrayList* _tmp9_;
			_tmp8_ = self->priv->_list_todos_and_fixmes;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			result = _tmp9_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

gboolean
structure_model_get_emit_signals (StructureModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_emit_signals;
	return result;
}

void
structure_model_set_emit_signals (StructureModel* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = structure_model_get_emit_signals (self);
	if (old_value != value) {
		self->priv->_emit_signals = value;
		g_object_notify_by_pspec ((GObject *) self, structure_model_properties[STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY]);
	}
}

static void
structure_model_class_init (StructureModelClass * klass,
                            gpointer klass_data)
{
	structure_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StructureModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_structure_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_structure_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = structure_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY, structure_model_properties[STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY] = g_param_spec_boolean ("emit-signals", "emit-signals", "emit-signals", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
structure_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface,
                                               gpointer iface_data)
{
	structure_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_value = (void (*) (GtkTreeModel*, GtkTreeIter*, gint, GValue*)) structure_model_real_get_value;
}

static void
structure_model_instance_init (StructureModel * self,
                               gpointer klass)
{
	self->priv = structure_model_get_instance_private (self);
	self->priv->_emit_signals = FALSE;
	self->priv->_nb_nodes = (guint) 0;
	self->priv->_end_node = NULL;
}

static void
structure_model_finalize (GObject * obj)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRUCTURE_MODEL, StructureModel);
	(self->priv->_tree == NULL) ? NULL : (self->priv->_tree = (_g_node_destroy__struct_data_free0_ (self->priv->_tree), NULL));
	_g_object_unref0 (self->priv->_list_labels);
	_g_object_unref0 (self->priv->_list_includes);
	_g_object_unref0 (self->priv->_list_tables);
	_g_object_unref0 (self->priv->_list_figures);
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
	G_OBJECT_CLASS (structure_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
structure_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StructureModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StructureModel), 0, (GInstanceInitFunc) structure_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) structure_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType structure_model_type_id;
	structure_model_type_id = g_type_register_static (gtex_tree_model_node_get_type (), "StructureModel", &g_define_type_info, 0);
	g_type_add_interface_static (structure_model_type_id, gtk_tree_model_get_type (), &gtk_tree_model_info);
	StructureModel_private_offset = g_type_add_instance_private (structure_model_type_id, sizeof (StructureModelPrivate));
	return structure_model_type_id;
}

GType
structure_model_get_type (void)
{
	static gsize structure_model_type_id__once = 0;
	if (g_once_init_enter (&structure_model_type_id__once)) {
		GType structure_model_type_id;
		structure_model_type_id = structure_model_get_type_once ();
		g_once_init_leave (&structure_model_type_id__once, structure_model_type_id);
	}
	return structure_model_type_id__once;
}

static void
_vala_structure_model_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
	switch (property_id) {
		case STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY:
		g_value_set_boolean (value, structure_model_get_emit_signals (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_structure_model_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
	switch (property_id) {
		case STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY:
		structure_model_set_emit_signals (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

