/* geary-attachment.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from geary-attachment.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_ATTACHMENT_0_PROPERTY,
	GEARY_ATTACHMENT_CONTENT_TYPE_PROPERTY,
	GEARY_ATTACHMENT_CONTENT_ID_PROPERTY,
	GEARY_ATTACHMENT_CONTENT_DESCRIPTION_PROPERTY,
	GEARY_ATTACHMENT_CONTENT_DISPOSITION_PROPERTY,
	GEARY_ATTACHMENT_HAS_CONTENT_FILENAME_PROPERTY,
	GEARY_ATTACHMENT_CONTENT_FILENAME_PROPERTY,
	GEARY_ATTACHMENT_FILE_PROPERTY,
	GEARY_ATTACHMENT_FILESIZE_PROPERTY,
	GEARY_ATTACHMENT_NUM_PROPERTIES
};
static GParamSpec* geary_attachment_properties[GEARY_ATTACHMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyAttachmentGetSafeFileNameData GearyAttachmentGetSafeFileNameData;

struct _GearyAttachmentPrivate {
	GearyMimeContentType* _content_type;
	gchar* _content_id;
	gchar* _content_description;
	GearyMimeContentDisposition* _content_disposition;
	gchar* _content_filename;
	GFile* _file;
	gint64 _filesize;
};

struct _GearyAttachmentGetSafeFileNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAttachment* self;
	gchar* alt_file_name;
	gchar* result;
	gchar* file_name;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** others;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint others_length1;
	gint _others_size_;
	gint i;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GearyMimeContentType* mime_type;
	GearyMimeContentType* _tmp15_;
	GearyMimeContentType* _tmp16_;
	GearyMimeContentType* name_type;
	GearyMimeContentType* _tmp17_;
	const gchar* _tmp18_;
	GearyMimeContentType* _tmp19_;
	GearyMimeContentType* _tmp20_;
	GError* err;
	GError* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GearyMimeContentType* _tmp25_;
	GearyMimeContentType* _tmp26_;
	GearyMimeContentType* _tmp27_;
	GearyMimeContentType* _tmp28_;
	GearyMimeContentType* _tmp29_;
	GearyMimeContentType* _tmp30_;
	GearyMimeContentType* _tmp31_;
	GearyMemoryFileBuffer* _tmp32_;
	GFile* _tmp33_;
	GearyMemoryFileBuffer* _tmp34_;
	GearyMimeContentType* _tmp35_;
	GearyMimeContentType* _tmp36_;
	GearyMimeContentType* _tmp37_;
	GError* _vala1_err;
	GError* _tmp38_;
	const gchar* _tmp39_;
	gchar* ext;
	GearyMimeContentType* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	GError* _inner_error0_;
};

static gint GearyAttachment_private_offset;
static gpointer geary_attachment_parent_class = NULL;

static void geary_attachment_set_content_type (GearyAttachment* self,
                                        GearyMimeContentType* value);
static void geary_attachment_set_content_id (GearyAttachment* self,
                                      const gchar* value);
static void geary_attachment_set_content_description (GearyAttachment* self,
                                               const gchar* value);
static void geary_attachment_set_content_disposition (GearyAttachment* self,
                                               GearyMimeContentDisposition* value);
static void geary_attachment_set_content_filename (GearyAttachment* self,
                                            const gchar* value);
static void geary_attachment_set_file (GearyAttachment* self,
                                GFile* value);
static void geary_attachment_set_filesize (GearyAttachment* self,
                                    gint64 value);
static void geary_attachment_get_safe_file_name_data_free (gpointer _data);
static gboolean geary_attachment_get_safe_file_name_co (GearyAttachmentGetSafeFileNameData* _data_);
static void geary_attachment_finalize (GObject * obj);
static GType geary_attachment_get_type_once (void);
static void _vala_geary_attachment_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_geary_attachment_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_attachment_get_instance_private (GearyAttachment* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAttachment_private_offset);
}

GearyMimeContentType*
geary_attachment_get_content_type (GearyAttachment* self)
{
	GearyMimeContentType* result;
	GearyMimeContentType* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ATTACHMENT (self), NULL);
	_tmp0_ = self->priv->_content_type;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_attachment_set_content_type (GearyAttachment* self,
                                   GearyMimeContentType* value)
{
	GearyMimeContentType* old_value;
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	old_value = geary_attachment_get_content_type (self);
	if (old_value != value) {
		GearyMimeContentType* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_content_type);
		self->priv->_content_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_TYPE_PROPERTY]);
	}
}

const gchar*
geary_attachment_get_content_id (GearyAttachment* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ATTACHMENT (self), NULL);
	_tmp0_ = self->priv->_content_id;
	result = _tmp0_;
	return result;
}

static void
geary_attachment_set_content_id (GearyAttachment* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	old_value = geary_attachment_get_content_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content_id);
		self->priv->_content_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_ID_PROPERTY]);
	}
}

const gchar*
geary_attachment_get_content_description (GearyAttachment* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ATTACHMENT (self), NULL);
	_tmp0_ = self->priv->_content_description;
	result = _tmp0_;
	return result;
}

static void
geary_attachment_set_content_description (GearyAttachment* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	old_value = geary_attachment_get_content_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content_description);
		self->priv->_content_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_DESCRIPTION_PROPERTY]);
	}
}

GearyMimeContentDisposition*
geary_attachment_get_content_disposition (GearyAttachment* self)
{
	GearyMimeContentDisposition* result;
	GearyMimeContentDisposition* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ATTACHMENT (self), NULL);
	_tmp0_ = self->priv->_content_disposition;
	result = _tmp0_;
	return result;
}

static void
geary_attachment_set_content_disposition (GearyAttachment* self,
                                          GearyMimeContentDisposition* value)
{
	GearyMimeContentDisposition* old_value;
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	old_value = geary_attachment_get_content_disposition (self);
	if (old_value != value) {
		GearyMimeContentDisposition* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_content_disposition);
		self->priv->_content_disposition = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_DISPOSITION_PROPERTY]);
	}
}

gboolean
geary_attachment_get_has_content_filename (GearyAttachment* self)
{
	gboolean result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ATTACHMENT (self), FALSE);
	_tmp0_ = self->priv->_content_filename;
	result = _tmp0_ != NULL;
	return result;
}

const gchar*
geary_attachment_get_content_filename (GearyAttachment* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ATTACHMENT (self), NULL);
	_tmp0_ = self->priv->_content_filename;
	result = _tmp0_;
	return result;
}

static void
geary_attachment_set_content_filename (GearyAttachment* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	old_value = geary_attachment_get_content_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content_filename);
		self->priv->_content_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_FILENAME_PROPERTY]);
	}
}

GFile*
geary_attachment_get_file (GearyAttachment* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ATTACHMENT (self), NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
geary_attachment_set_file (GearyAttachment* self,
                           GFile* value)
{
	GFile* old_value;
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	old_value = geary_attachment_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_attachment_properties[GEARY_ATTACHMENT_FILE_PROPERTY]);
	}
}

gint64
geary_attachment_get_filesize (GearyAttachment* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_IS_ATTACHMENT (self), 0LL);
	result = self->priv->_filesize;
	return result;
}

static void
geary_attachment_set_filesize (GearyAttachment* self,
                               gint64 value)
{
	gint64 old_value;
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	old_value = geary_attachment_get_filesize (self);
	if (old_value != value) {
		self->priv->_filesize = value;
		g_object_notify_by_pspec ((GObject *) self, geary_attachment_properties[GEARY_ATTACHMENT_FILESIZE_PROPERTY]);
	}
}

GearyAttachment*
geary_attachment_construct (GType object_type,
                            GearyMimeContentType* content_type,
                            const gchar* content_id,
                            const gchar* content_description,
                            GearyMimeContentDisposition* content_disposition,
                            const gchar* content_filename)
{
	GearyAttachment * self = NULL;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (content_type), NULL);
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (content_disposition), NULL);
	self = (GearyAttachment*) geary_base_object_construct (object_type);
	geary_attachment_set_content_type (self, content_type);
	geary_attachment_set_content_id (self, content_id);
	geary_attachment_set_content_description (self, content_description);
	geary_attachment_set_content_disposition (self, content_disposition);
	geary_attachment_set_content_filename (self, content_filename);
	return self;
}

static void
geary_attachment_get_safe_file_name_data_free (gpointer _data)
{
	GearyAttachmentGetSafeFileNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->alt_file_name);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAttachmentGetSafeFileNameData, _data_);
}

void
geary_attachment_get_safe_file_name (GearyAttachment* self,
                                     const gchar* alt_file_name,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearyAttachmentGetSafeFileNameData* _data_;
	GearyAttachment* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	_data_ = g_slice_new0 (GearyAttachmentGetSafeFileNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_attachment_get_safe_file_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (alt_file_name);
	_g_free0 (_data_->alt_file_name);
	_data_->alt_file_name = _tmp1_;
	geary_attachment_get_safe_file_name_co (_data_);
}

gchar*
geary_attachment_get_safe_file_name_finish (GearyAttachment* self,
                                            GAsyncResult* _res_)
{
	gchar* result;
	GearyAttachmentGetSafeFileNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns a string to use as a file name, even if not specified.
     *
     * This checks that the extension of the given content file name
     * matches the given content type, even if the attachment has the
     * default content type.
     *
     * If no file name was specified for the attachment, it will
     * construct one from the attachment's id and by guessing the file
     * name extension, and also guessing the MIME content type if
     * needed.
     *
     * If a file name is constructed and a non-empty value for the
     * `alt_file_name` parameter is specified, then that will be used
     * in preference over the content id and attachment id.
     */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
geary_attachment_get_safe_file_name_co (GearyAttachmentGetSafeFileNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_content_filename;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->file_name = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->file_name;
	if (geary_string_is_empty (_data_->_tmp2_)) {
		_data_->_tmp3_ = g_strdup (_data_->alt_file_name);
		_data_->_tmp4_ = _data_->self->priv->_content_id;
		_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
		_data_->_tmp6_ = g_strdup ("attachment");
		_data_->_tmp7_ = g_new0 (gchar*, 3 + 1);
		_data_->_tmp7_[0] = _data_->_tmp3_;
		_data_->_tmp7_[1] = _data_->_tmp5_;
		_data_->_tmp7_[2] = _data_->_tmp6_;
		_data_->others = _data_->_tmp7_;
		_data_->others_length1 = 3;
		_data_->_others_size_ = _data_->others_length1;
		_data_->i = 0;
		while (TRUE) {
			_data_->_tmp8_ = _data_->file_name;
			if (!geary_string_is_empty (_data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->others;
			_data_->_tmp9__length1 = _data_->others_length1;
			_data_->_tmp10_ = _data_->i;
			_data_->i = _data_->_tmp10_ + 1;
			_data_->_tmp11_ = _data_->_tmp9_[_data_->_tmp10_];
			_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
			_g_free0 (_data_->file_name);
			_data_->file_name = _data_->_tmp12_;
		}
		_data_->others = (_vala_array_free (_data_->others, _data_->others_length1, (GDestroyNotify) g_free), NULL);
	}
	_data_->_tmp13_ = _data_->file_name;
	_data_->_tmp14_ = string_strip (_data_->_tmp13_);
	_g_free0 (_data_->file_name);
	_data_->file_name = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->self->priv->_content_type;
	_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
	_data_->mime_type = _data_->_tmp16_;
	_data_->name_type = NULL;
	{
		_data_->_tmp18_ = _data_->file_name;
		_data_->_tmp19_ = geary_mime_content_type_guess_type (_data_->_tmp18_, NULL, &_data_->_inner_error0_);
		_data_->_tmp17_ = _data_->_tmp19_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp20_ = _data_->_tmp17_;
		_data_->_tmp17_ = NULL;
		_g_object_unref0 (_data_->name_type);
		_data_->name_type = _data_->_tmp20_;
		_g_object_unref0 (_data_->_tmp17_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp21_ = _data_->err;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_debug ("geary-attachment.vala:126: Error guessing attachment file name content" \
" type: %s", _data_->_tmp22_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->name_type);
		_g_object_unref0 (_data_->mime_type);
		_g_free0 (_data_->file_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = _data_->name_type;
	if (_data_->_tmp25_ == NULL) {
		_data_->_tmp24_ = TRUE;
	} else {
		_data_->_tmp26_ = _data_->name_type;
		_data_->_tmp27_ = geary_mime_content_type_ATTACHMENT_DEFAULT;
		_data_->_tmp24_ = geary_mime_content_type_is_same (_data_->_tmp26_, _data_->_tmp27_);
	}
	if (_data_->_tmp24_) {
		_data_->_tmp23_ = TRUE;
	} else {
		_data_->_tmp28_ = _data_->name_type;
		_data_->_tmp29_ = _data_->mime_type;
		_data_->_tmp23_ = !geary_mime_content_type_is_same (_data_->_tmp28_, _data_->_tmp29_);
	}
	if (_data_->_tmp23_) {
		_data_->_tmp30_ = _data_->mime_type;
		_data_->_tmp31_ = geary_mime_content_type_ATTACHMENT_DEFAULT;
		if (geary_mime_content_type_is_same (_data_->_tmp30_, _data_->_tmp31_)) {
			{
				_data_->_tmp33_ = _data_->self->priv->_file;
				_data_->_tmp34_ = geary_memory_file_buffer_new (_data_->_tmp33_, TRUE, &_data_->_inner_error0_);
				_data_->_tmp32_ = _data_->_tmp34_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_data_->_tmp36_ = geary_mime_content_type_guess_type (NULL, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp32_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer), &_data_->_inner_error0_);
				_data_->_tmp35_ = _data_->_tmp36_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->_tmp32_);
					goto __catch1_g_error;
				}
				_data_->_tmp37_ = _data_->_tmp35_;
				_data_->_tmp35_ = NULL;
				_g_object_unref0 (_data_->mime_type);
				_data_->mime_type = _data_->_tmp37_;
				_g_object_unref0 (_data_->_tmp35_);
				_g_object_unref0 (_data_->_tmp32_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp38_ = _data_->_vala1_err;
				_data_->_tmp39_ = _data_->_tmp38_->message;
				g_debug ("geary-attachment.vala:146: Error guessing attachment data content type" \
": %s", _data_->_tmp39_);
				_g_error_free0 (_data_->_vala1_err);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->name_type);
				_g_object_unref0 (_data_->mime_type);
				_g_free0 (_data_->file_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp40_ = _data_->mime_type;
		_data_->_tmp41_ = geary_mime_content_type_get_file_name_extension (_data_->_tmp40_);
		_data_->ext = _data_->_tmp41_;
		_data_->_tmp43_ = _data_->ext;
		if (_data_->_tmp43_ != NULL) {
			_data_->_tmp44_ = _data_->file_name;
			_data_->_tmp45_ = _data_->ext;
			_data_->_tmp42_ = !g_str_has_suffix (_data_->_tmp44_, _data_->_tmp45_);
		} else {
			_data_->_tmp42_ = FALSE;
		}
		if (_data_->_tmp42_) {
			_data_->_tmp47_ = _data_->ext;
			_data_->_tmp46_ = _data_->_tmp47_;
			if (_data_->_tmp46_ == NULL) {
				_data_->_tmp46_ = "";
			}
			_data_->_tmp48_ = _data_->file_name;
			_data_->_tmp49_ = g_strconcat (_data_->_tmp48_, _data_->_tmp46_, NULL);
			_g_free0 (_data_->file_name);
			_data_->file_name = _data_->_tmp49_;
		}
		_g_free0 (_data_->ext);
	}
	_data_->result = _data_->file_name;
	_g_object_unref0 (_data_->name_type);
	_g_object_unref0 (_data_->mime_type);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Sets the attachment's on-disk location and size.
     */
void
geary_attachment_set_file_info (GearyAttachment* self,
                                GFile* file,
                                gint64 file_size)
{
	g_return_if_fail (GEARY_IS_ATTACHMENT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	geary_attachment_set_file (self, file);
	geary_attachment_set_filesize (self, file_size);
}

static void
geary_attachment_class_init (GearyAttachmentClass * klass,
                             gpointer klass_data)
{
	geary_attachment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAttachment_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_attachment_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_attachment_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_attachment_finalize;
	/**
	     * The {@link Mime.ContentType} of the {@link Attachment}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ATTACHMENT_CONTENT_TYPE_PROPERTY, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_TYPE_PROPERTY] = g_param_spec_object ("content-type", "content-type", "content-type", GEARY_MIME_TYPE_CONTENT_TYPE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The Content-ID of the attachment.
	     *
	     * See [[https://tools.ietf.org/html/rfc2111]]
	     *
	     * @see Email.get_attachment_by_content_id
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ATTACHMENT_CONTENT_ID_PROPERTY, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_ID_PROPERTY] = g_param_spec_string ("content-id", "content-id", "content-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The Content-Description of the attachment.
	     *
	     * See [[https://tools.ietf.org/html/rfc2045#section-8]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ATTACHMENT_CONTENT_DESCRIPTION_PROPERTY, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_DESCRIPTION_PROPERTY] = g_param_spec_string ("content-description", "content-description", "content-description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The {@link Mime.ContentDisposition} of the attachment, as specified by the {@link Email}.
	     *
	     * See [[https://tools.ietf.org/html/rfc2183]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ATTACHMENT_CONTENT_DISPOSITION_PROPERTY, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_DISPOSITION_PROPERTY] = g_param_spec_object ("content-disposition", "content-disposition", "content-disposition", GEARY_MIME_TYPE_CONTENT_DISPOSITION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns true if a filename was supplied in {@link content_disposition}.
	     *
	     * Since all files must have a name, one is supplied for the
	     * Attachment by Geary if this is false.  This is merely to
	     * indicate how the filename should be displayed, since Geary's
	     * will be an untranslated "none".
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ATTACHMENT_HAS_CONTENT_FILENAME_PROPERTY, geary_attachment_properties[GEARY_ATTACHMENT_HAS_CONTENT_FILENAME_PROPERTY] = g_param_spec_boolean ("has-content-filename", "has-content-filename", "has-content-filename", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The filename supplied in {@link content_disposition}, if any.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ATTACHMENT_CONTENT_FILENAME_PROPERTY, geary_attachment_properties[GEARY_ATTACHMENT_CONTENT_FILENAME_PROPERTY] = g_param_spec_string ("content-filename", "content-filename", "content-filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The attachment's on-disk File, if any.
	     *
	     * This will be null if the attachment has not been saved to disk.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ATTACHMENT_FILE_PROPERTY, geary_attachment_properties[GEARY_ATTACHMENT_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The file size (in bytes) if the {@link file}.
	     *
	     * This will be -1 if the attachment has not been saved to disk.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ATTACHMENT_FILESIZE_PROPERTY, geary_attachment_properties[GEARY_ATTACHMENT_FILESIZE_PROPERTY] = g_param_spec_int64 ("filesize", "filesize", "filesize", G_MININT64, G_MAXINT64, (gint64) -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_attachment_instance_init (GearyAttachment * self,
                                gpointer klass)
{
	self->priv = geary_attachment_get_instance_private (self);
	self->priv->_file = NULL;
	self->priv->_filesize = (gint64) -1;
}

static void
geary_attachment_finalize (GObject * obj)
{
	GearyAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_ATTACHMENT, GearyAttachment);
	_g_object_unref0 (self->priv->_content_type);
	_g_free0 (self->priv->_content_id);
	_g_free0 (self->priv->_content_description);
	_g_object_unref0 (self->priv->_content_disposition);
	_g_free0 (self->priv->_content_filename);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (geary_attachment_parent_class)->finalize (obj);
}

/**
 * An attachment that was a part of an {@link Email}.
 */
 G_GNUC_NO_INLINE static GType
geary_attachment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAttachmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_attachment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAttachment), 0, (GInstanceInitFunc) geary_attachment_instance_init, NULL };
	GType geary_attachment_type_id;
	geary_attachment_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAttachment", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyAttachment_private_offset = g_type_add_instance_private (geary_attachment_type_id, sizeof (GearyAttachmentPrivate));
	return geary_attachment_type_id;
}

GType
geary_attachment_get_type (void)
{
	static gsize geary_attachment_type_id__once = 0;
	if (g_once_init_enter (&geary_attachment_type_id__once)) {
		GType geary_attachment_type_id;
		geary_attachment_type_id = geary_attachment_get_type_once ();
		g_once_init_leave (&geary_attachment_type_id__once, geary_attachment_type_id);
	}
	return geary_attachment_type_id__once;
}

static void
_vala_geary_attachment_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GearyAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ATTACHMENT, GearyAttachment);
	switch (property_id) {
		case GEARY_ATTACHMENT_CONTENT_TYPE_PROPERTY:
		g_value_set_object (value, geary_attachment_get_content_type (self));
		break;
		case GEARY_ATTACHMENT_CONTENT_ID_PROPERTY:
		g_value_set_string (value, geary_attachment_get_content_id (self));
		break;
		case GEARY_ATTACHMENT_CONTENT_DESCRIPTION_PROPERTY:
		g_value_set_string (value, geary_attachment_get_content_description (self));
		break;
		case GEARY_ATTACHMENT_CONTENT_DISPOSITION_PROPERTY:
		g_value_set_object (value, geary_attachment_get_content_disposition (self));
		break;
		case GEARY_ATTACHMENT_HAS_CONTENT_FILENAME_PROPERTY:
		g_value_set_boolean (value, geary_attachment_get_has_content_filename (self));
		break;
		case GEARY_ATTACHMENT_CONTENT_FILENAME_PROPERTY:
		g_value_set_string (value, geary_attachment_get_content_filename (self));
		break;
		case GEARY_ATTACHMENT_FILE_PROPERTY:
		g_value_set_object (value, geary_attachment_get_file (self));
		break;
		case GEARY_ATTACHMENT_FILESIZE_PROPERTY:
		g_value_set_int64 (value, geary_attachment_get_filesize (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_attachment_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GearyAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ATTACHMENT, GearyAttachment);
	switch (property_id) {
		case GEARY_ATTACHMENT_CONTENT_TYPE_PROPERTY:
		geary_attachment_set_content_type (self, g_value_get_object (value));
		break;
		case GEARY_ATTACHMENT_CONTENT_ID_PROPERTY:
		geary_attachment_set_content_id (self, g_value_get_string (value));
		break;
		case GEARY_ATTACHMENT_CONTENT_DESCRIPTION_PROPERTY:
		geary_attachment_set_content_description (self, g_value_get_string (value));
		break;
		case GEARY_ATTACHMENT_CONTENT_DISPOSITION_PROPERTY:
		geary_attachment_set_content_disposition (self, g_value_get_object (value));
		break;
		case GEARY_ATTACHMENT_CONTENT_FILENAME_PROPERTY:
		geary_attachment_set_content_filename (self, g_value_get_string (value));
		break;
		case GEARY_ATTACHMENT_FILE_PROPERTY:
		geary_attachment_set_file (self, g_value_get_object (value));
		break;
		case GEARY_ATTACHMENT_FILESIZE_PROPERTY:
		geary_attachment_set_filesize (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

