// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// LogsAggregateBucketValueTimeseriesPoint A timeseries point
type LogsAggregateBucketValueTimeseriesPoint struct {
	// The time value for this point
	Time *string `json:"time,omitempty"`
	// The value for this point
	Value *float64 `json:"value,omitempty"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewLogsAggregateBucketValueTimeseriesPoint instantiates a new LogsAggregateBucketValueTimeseriesPoint object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewLogsAggregateBucketValueTimeseriesPoint() *LogsAggregateBucketValueTimeseriesPoint {
	this := LogsAggregateBucketValueTimeseriesPoint{}
	return &this
}

// NewLogsAggregateBucketValueTimeseriesPointWithDefaults instantiates a new LogsAggregateBucketValueTimeseriesPoint object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewLogsAggregateBucketValueTimeseriesPointWithDefaults() *LogsAggregateBucketValueTimeseriesPoint {
	this := LogsAggregateBucketValueTimeseriesPoint{}
	return &this
}

// GetTime returns the Time field value if set, zero value otherwise.
func (o *LogsAggregateBucketValueTimeseriesPoint) GetTime() string {
	if o == nil || o.Time == nil {
		var ret string
		return ret
	}
	return *o.Time
}

// GetTimeOk returns a tuple with the Time field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsAggregateBucketValueTimeseriesPoint) GetTimeOk() (*string, bool) {
	if o == nil || o.Time == nil {
		return nil, false
	}
	return o.Time, true
}

// HasTime returns a boolean if a field has been set.
func (o *LogsAggregateBucketValueTimeseriesPoint) HasTime() bool {
	return o != nil && o.Time != nil
}

// SetTime gets a reference to the given string and assigns it to the Time field.
func (o *LogsAggregateBucketValueTimeseriesPoint) SetTime(v string) {
	o.Time = &v
}

// GetValue returns the Value field value if set, zero value otherwise.
func (o *LogsAggregateBucketValueTimeseriesPoint) GetValue() float64 {
	if o == nil || o.Value == nil {
		var ret float64
		return ret
	}
	return *o.Value
}

// GetValueOk returns a tuple with the Value field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogsAggregateBucketValueTimeseriesPoint) GetValueOk() (*float64, bool) {
	if o == nil || o.Value == nil {
		return nil, false
	}
	return o.Value, true
}

// HasValue returns a boolean if a field has been set.
func (o *LogsAggregateBucketValueTimeseriesPoint) HasValue() bool {
	return o != nil && o.Value != nil
}

// SetValue gets a reference to the given float64 and assigns it to the Value field.
func (o *LogsAggregateBucketValueTimeseriesPoint) SetValue(v float64) {
	o.Value = &v
}

// MarshalJSON serializes the struct using spec logic.
func (o LogsAggregateBucketValueTimeseriesPoint) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	if o.Time != nil {
		toSerialize["time"] = o.Time
	}
	if o.Value != nil {
		toSerialize["value"] = o.Value
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *LogsAggregateBucketValueTimeseriesPoint) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		Time  *string  `json:"time,omitempty"`
		Value *float64 `json:"value,omitempty"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"time", "value"})
	} else {
		return err
	}
	o.Time = all.Time
	o.Value = all.Value

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	return nil
}
