#ifndef SBK_KXMLGUICLIENTWRAPPER_H
#define SBK_KXMLGUICLIENTWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kxmlguiclient.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

class KXMLGUIClientWrapper : public KXMLGUIClient
{
public:
    KXMLGUIClientWrapper();
    KXMLGUIClientWrapper(::KXMLGUIClient * parent);
    KXMLGUIClientWrapper(const KXMLGUIClientWrapper &) = delete;
    KXMLGUIClientWrapper& operator=(const KXMLGUIClientWrapper &) = delete;
    KXMLGUIClientWrapper(KXMLGUIClientWrapper &&) = delete;
    KXMLGUIClientWrapper& operator=(KXMLGUIClientWrapper &&) = delete;
    ~KXMLGUIClientWrapper() override;

    ::KActionCollection * actionCollection() const override;
    static ::KActionCollection * sbk_o_actionCollection(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    ::QString componentName() const override;
    static ::QString sbk_o_componentName(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    ::QString localXMLFile() const override;
    void setComponentName(const ::QString & componentName, const ::QString & componentDisplayName) override;
    static void sbk_o_setComponentName(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & componentName, const ::QString & componentDisplayName);
    void setLocalXMLFile(const ::QString & file) override;
    static void sbk_o_setLocalXMLFile(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & file);
    void setXML(const ::QString & document, bool merge = false) override;
    static void sbk_o_setXML(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & document, bool merge = false);
    void setXMLFile(const ::QString & file, bool merge = false, bool setXMLDoc = true) override;
    static void sbk_o_setXMLFile(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & file, bool merge = false, bool setXMLDoc = true);
    void stateChanged(const ::QString & newstate, ::KXMLGUIClient::ReverseStateChange reverse = KXMLGUIClient::ReverseStateChange::StateNoReverse) override;
    static void sbk_o_stateChanged(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & newstate, ::KXMLGUIClient::ReverseStateChange reverse = KXMLGUIClient::ReverseStateChange::StateNoReverse);
    ::QString xmlFile() const override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 9> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KXMLGUICLIENTWRAPPER_H
