/* DatabaseTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DatabaseTable.vala, do not modify */

/* Copyright 2009-2013 Yorba Foundation
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <sqlite3.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define DB_IN_MEMORY_NAME ":memory:"
#define DATABASE_TABLE_SCHEMA_VERSION 21
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef enum  {
	DB_VERIFY_RESULT_OK,
	DB_VERIFY_RESULT_FUTURE_VERSION,
	DB_VERIFY_RESULT_UPGRADE_ERROR,
	DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE
} DbVerifyResult;

#define DB_TYPE_VERIFY_RESULT (db_verify_result_get_type ())

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define ENOTES_TYPE_PAGE_TABLE (enotes_page_table_get_type ())
#define ENOTES_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTable))
#define ENOTES_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))
#define ENOTES_IS_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_IS_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_PAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))

typedef struct _ENotesPageTable ENotesPageTable;
typedef struct _ENotesPageTableClass ENotesPageTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define ENOTES_TYPE_IMAGE_TABLE (enotes_image_table_get_type ())
#define ENOTES_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTable))
#define ENOTES_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))
#define ENOTES_IS_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IS_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IMAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))

typedef struct _ENotesImageTable ENotesImageTable;
typedef struct _ENotesImageTableClass ENotesImageTableClass;

#define ENOTES_TYPE_NOTEBOOK_TABLE (enotes_notebook_table_get_type ())
#define ENOTES_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTable))
#define ENOTES_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))
#define ENOTES_IS_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_IS_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_NOTEBOOK_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))

typedef struct _ENotesNotebookTable ENotesNotebookTable;
typedef struct _ENotesNotebookTableClass ENotesNotebookTableClass;

#define ENOTES_TYPE_BOOKMARK_TABLE (enotes_bookmark_table_get_type ())
#define ENOTES_BOOKMARK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTable))
#define ENOTES_BOOKMARK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTableClass))
#define ENOTES_IS_BOOKMARK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_BOOKMARK_TABLE))
#define ENOTES_IS_BOOKMARK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_BOOKMARK_TABLE))
#define ENOTES_BOOKMARK_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTableClass))

typedef struct _ENotesBookmarkTable ENotesBookmarkTable;
typedef struct _ENotesBookmarkTableClass ENotesBookmarkTableClass;

#define ENOTES_TYPE_TAGS_TABLE (enotes_tags_table_get_type ())
#define ENOTES_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTable))
#define ENOTES_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))
#define ENOTES_IS_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_IS_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_TAGS_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))

typedef struct _ENotesTagsTable ENotesTagsTable;
typedef struct _ENotesTagsTableClass ENotesTagsTableClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecDatabaseTable ParamSpecDatabaseTable;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ParamSpecDatabaseTable {
	GParamSpec parent_instance;
};

VALA_EXTERN gchar* db_filename;
gchar* db_filename = NULL;
static gpointer database_table_parent_class = NULL;
VALA_EXTERN sqlite3* database_table_db;
sqlite3* database_table_db = NULL;
static gint database_table_in_transaction;
static gint database_table_in_transaction = 0;
static gboolean database_table__init;
static gboolean database_table__init = FALSE;

VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void db_preconfigure (GFile* db_file);
VALA_EXTERN gboolean db_init (GError** error);
VALA_EXTERN gboolean database_table_init (const gchar* filename);
VALA_EXTERN gboolean db_is_file_valid (const gchar* path);
VALA_EXTERN void db_terminate (void);
VALA_EXTERN void database_table_terminate (void);
VALA_EXTERN GType db_verify_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
static void database_table_prepare_db (const gchar* filename);
VALA_EXTERN GType enotes_page_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageTable, database_table_unref)
VALA_EXTERN ENotesPageTable* enotes_page_table_get_instance (void);
VALA_EXTERN GType enotes_image_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesImageTable, database_table_unref)
VALA_EXTERN ENotesImageTable* enotes_image_table_get_instance (void);
VALA_EXTERN GType enotes_notebook_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebookTable, database_table_unref)
VALA_EXTERN ENotesNotebookTable* enotes_notebook_table_get_instance (void);
VALA_EXTERN GType enotes_bookmark_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesBookmarkTable, database_table_unref)
VALA_EXTERN ENotesBookmarkTable* enotes_bookmark_table_get_instance (void);
VALA_EXTERN GType enotes_tags_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTagsTable, database_table_unref)
VALA_EXTERN ENotesTagsTable* enotes_tags_table_get_instance (void);
VALA_EXTERN void database_table_warning (const gchar* op,
                             gint res);
VALA_EXTERN void enotes_page_table_reset_instance (void);
VALA_EXTERN void enotes_image_table_reset_instance (void);
VALA_EXTERN void enotes_notebook_table_reset_instance (void);
VALA_EXTERN void enotes_bookmark_table_reset_instance (void);
VALA_EXTERN void enotes_tags_table_reset_instance (void);
VALA_EXTERN void enotes_file_data_table_reset_instance (void);
VALA_EXTERN void enotes_trash_reset_instance (void);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
VALA_EXTERN sqlite3_stmt* database_table_create_stmt (const gchar* data);
static void database_table_assert_test (gboolean condition,
                                 const gchar* data);
VALA_EXTERN void database_table_bind_text (sqlite3_stmt* stmt,
                               gint column,
                               const gchar* data);
VALA_EXTERN void database_table_bind_int (sqlite3_stmt* stmt,
                              gint column,
                              gint64 data);
VALA_EXTERN gboolean database_table_exists_by_id (DatabaseTable* self,
                                      gint64 id);
VALA_EXTERN gboolean database_table_select_by_id (DatabaseTable* self,
                                      gint64 id,
                                      const gchar* columns,
                                      sqlite3_stmt** stmt);
static void database_table_prepare_update_by_id (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          sqlite3_stmt** stmt);
static gboolean database_table_execute_update_by_id (DatabaseTable* self,
                                              sqlite3_stmt* stmt);
VALA_EXTERN gboolean database_table_update_text_by_id (DatabaseTable* self,
                                           gint64 id,
                                           const gchar* column,
                                           const gchar* text);
VALA_EXTERN void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
VALA_EXTERN gboolean database_table_update_int_by_id (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint value);
VALA_EXTERN void database_table_update_int_by_id_2 (DatabaseTable* self,
                                        gint64 id,
                                        const gchar* column,
                                        gint value,
                                        GError** error);
VALA_EXTERN gboolean database_table_update_int64_by_id (DatabaseTable* self,
                                            gint64 id,
                                            const gchar* column,
                                            gint64 value);
VALA_EXTERN void database_table_update_int64_by_id_2 (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint64 value,
                                          GError** error);
VALA_EXTERN void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
VALA_EXTERN gboolean database_table_has_column (const gchar* table_name,
                                    const gchar* column_name);
VALA_EXTERN gboolean database_table_has_table (const gchar* table_name);
VALA_EXTERN gboolean database_table_add_column (const gchar* table_name,
                                    const gchar* column_name,
                                    const gchar* column_constraints);
VALA_EXTERN gint64 database_table_last_insert_row (DatabaseTable* self);
VALA_EXTERN gboolean database_table_ensure_column (const gchar* table_name,
                                       const gchar* column_name,
                                       const gchar* column_constraints,
                                       const gchar* upgrade_msg);
VALA_EXTERN gint database_table_get_row_count (DatabaseTable* self);
VALA_EXTERN void database_table_begin_transaction (void);
VALA_EXTERN void database_table_commit_transaction (GError** error);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
static void database_table_finalize (DatabaseTable * obj);
static GType database_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
database_error_quark (void)
{
	return g_quark_from_static_string ("database-error-quark");
}

static GType
database_error_get_type_once (void)
{
	static const GEnumValue values[] = {{DATABASE_ERROR_ERROR, "DATABASE_ERROR_ERROR", "error"}, {DATABASE_ERROR_BACKING, "DATABASE_ERROR_BACKING", "backing"}, {DATABASE_ERROR_MEMORY, "DATABASE_ERROR_MEMORY", "memory"}, {DATABASE_ERROR_ABORT, "DATABASE_ERROR_ABORT", "abort"}, {DATABASE_ERROR_LIMITS, "DATABASE_ERROR_LIMITS", "limits"}, {DATABASE_ERROR_TYPESPEC, "DATABASE_ERROR_TYPESPEC", "typespec"}, {0, NULL, NULL}};
	GType database_error_type_id;
	database_error_type_id = g_enum_register_static ("DatabaseError", values);
	return database_error_type_id;
}

GType
database_error_get_type (void)
{
	static volatile gsize database_error_type_id__once = 0;
	if (g_once_init_enter (&database_error_type_id__once)) {
		GType database_error_type_id;
		database_error_type_id = database_error_get_type_once ();
		g_once_init_leave (&database_error_type_id__once, database_error_type_id);
	}
	return database_error_type_id__once;
}

void
db_preconfigure (GFile* db_file)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp3_;
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (db_file != NULL) {
#line 318 "DatabaseTable.c"
		gchar* _tmp1_;
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp1_ = g_file_get_path (db_file);
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp0_);
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp0_ = _tmp1_;
#line 326 "DatabaseTable.c"
	} else {
		gchar* _tmp2_;
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp2_ = g_strdup (DB_IN_MEMORY_NAME);
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp0_);
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp0_ = _tmp2_;
#line 335 "DatabaseTable.c"
	}
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = g_strdup (_tmp0_);
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (db_filename);
#line 24 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	db_filename = _tmp3_;
#line 23 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp0_);
#line 345 "DatabaseTable.c"
}

gboolean
db_init (GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
#line 28 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = db_filename;
#line 28 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (_tmp0_ != NULL, "filename != null");
#line 30 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = db_filename;
#line 30 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = database_table_init (_tmp1_);
#line 30 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 364 "DatabaseTable.c"
}

gboolean
db_is_file_valid (const gchar* path)
{
	GFile* file_db = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	sqlite3* test_db = NULL;
	sqlite3* _tmp2_ = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_;
	gboolean result;
#line 33 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 34 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = g_file_new_for_path (path);
#line 34 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	file_db = _tmp0_;
#line 37 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = file_db;
#line 37 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (!g_file_query_exists (_tmp1_, NULL)) {
#line 38 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		result = TRUE;
#line 38 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_object_unref0 (file_db);
#line 38 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return result;
#line 397 "DatabaseTable.c"
	}
#line 42 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	sqlite3_open_v2 (path, &_tmp2_, SQLITE_OPEN_READONLY, NULL);
#line 42 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_close0 (test_db);
#line 42 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	test_db = _tmp2_;
#line 45 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = test_db;
#line 45 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp3_, "SELECT id from notebook", -1, &_tmp4_, NULL);
#line 45 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 45 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp4_;
#line 45 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = _tmp5_;
#line 47 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_OK) {
#line 417 "DatabaseTable.c"
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 48 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp6_ = g_strdup_printf ("%i", res);
#line 48 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp7_ = _tmp6_;
#line 48 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp8_ = g_strconcat ("File was corrupted, or not a database ", _tmp7_, NULL);
#line 48 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp9_ = _tmp8_;
#line 48 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:48: %s", _tmp9_);
#line 48 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp9_);
#line 48 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp7_);
#line 49 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		result = FALSE;
#line 49 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_sqlite3_finalize0 (stmt);
#line 49 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_sqlite3_close0 (test_db);
#line 49 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_object_unref0 (file_db);
#line 49 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return result;
#line 446 "DatabaseTable.c"
	}
#line 52 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = TRUE;
#line 52 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 52 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_close0 (test_db);
#line 52 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_object_unref0 (file_db);
#line 52 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 458 "DatabaseTable.c"
}

void
db_terminate (void)
{
#line 56 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_terminate ();
#line 466 "DatabaseTable.c"
}

static GType
db_verify_result_get_type_once (void)
{
	static const GEnumValue values[] = {{DB_VERIFY_RESULT_OK, "DB_VERIFY_RESULT_OK", "ok"}, {DB_VERIFY_RESULT_FUTURE_VERSION, "DB_VERIFY_RESULT_FUTURE_VERSION", "future-version"}, {DB_VERIFY_RESULT_UPGRADE_ERROR, "DB_VERIFY_RESULT_UPGRADE_ERROR", "upgrade-error"}, {DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE, "DB_VERIFY_RESULT_NO_UPGRADE_AVAILABLE", "no-upgrade-available"}, {0, NULL, NULL}};
	GType db_verify_result_type_id;
	db_verify_result_type_id = g_enum_register_static ("DbVerifyResult", values);
	return db_verify_result_type_id;
}

GType
db_verify_result_get_type (void)
{
	static volatile gsize db_verify_result_type_id__once = 0;
	if (g_once_init_enter (&db_verify_result_type_id__once)) {
		GType db_verify_result_type_id;
		db_verify_result_type_id = db_verify_result_get_type_once ();
		g_once_init_leave (&db_verify_result_type_id__once, db_verify_result_type_id);
	}
	return db_verify_result_type_id__once;
}

static void
database_table_prepare_db (const gchar* filename)
{
	GFile* file_db = NULL;
	GFile* _tmp0_;
	GFile* db_dir = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean existed = FALSE;
	GFile* _tmp7_;
	sqlite3* _tmp8_ = NULL;
	GError* _inner_error0_ = NULL;
#line 83 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (filename != NULL);
#line 84 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = g_file_new_for_path (filename);
#line 84 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	file_db = _tmp0_;
#line 85 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = file_db;
#line 85 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = g_file_get_parent (_tmp1_);
#line 85 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	db_dir = _tmp2_;
#line 87 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = db_dir;
#line 87 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (!g_file_query_exists (_tmp3_, NULL)) {
#line 519 "DatabaseTable.c"
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 88 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp4_ = db_dir;
#line 88 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 88 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp6_ = _tmp5_;
#line 88 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_mkdir_with_parents (_tmp6_, 0766);
#line 88 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp6_);
#line 533 "DatabaseTable.c"
	}
#line 91 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp7_ = file_db;
#line 91 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	existed = g_file_query_exists (_tmp7_, NULL);
#line 94 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	sqlite3_open_v2 (filename, &_tmp8_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
#line 94 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_close0 (database_table_db);
#line 94 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_db = _tmp8_;
#line 97 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (g_strcmp0 (filename, DB_IN_MEMORY_NAME) != 0) {
#line 547 "DatabaseTable.c"
		{
			GFileInfo* info = NULL;
			GFile* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
#line 99 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp9_ = file_db;
#line 99 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp10_ = g_file_query_info (_tmp9_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 99 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			info = _tmp10_;
#line 99 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 561 "DatabaseTable.c"
				goto __catch0_g_error;
			}
#line 100 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp11_ = info;
#line 100 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_vala_assert (g_file_info_get_attribute_boolean (_tmp11_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE), "info.get_attribute_boolean (FileAttribute.ACCESS_CAN_WRITE)");
#line 102 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (!existed) {
#line 570 "DatabaseTable.c"
				ENotesPageTable* _tmp12_;
				ENotesPageTable* _tmp13_;
				ENotesImageTable* _tmp14_;
				ENotesImageTable* _tmp15_;
				ENotesNotebookTable* _tmp16_;
				ENotesNotebookTable* _tmp17_;
				ENotesBookmarkTable* _tmp18_;
				ENotesBookmarkTable* _tmp19_;
				ENotesTagsTable* _tmp20_;
				ENotesTagsTable* _tmp21_;
#line 103 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp12_ = enotes_page_table_get_instance ();
#line 103 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp13_ = _tmp12_;
#line 103 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_database_table_unref0 (_tmp13_);
#line 104 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp14_ = enotes_image_table_get_instance ();
#line 104 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp15_ = _tmp14_;
#line 104 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_database_table_unref0 (_tmp15_);
#line 105 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp16_ = enotes_notebook_table_get_instance ();
#line 105 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp17_ = _tmp16_;
#line 105 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_database_table_unref0 (_tmp17_);
#line 106 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp18_ = enotes_bookmark_table_get_instance ();
#line 106 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp19_ = _tmp18_;
#line 106 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_database_table_unref0 (_tmp19_);
#line 107 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp20_ = enotes_tags_table_get_instance ();
#line 107 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_tmp21_ = _tmp20_;
#line 107 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_database_table_unref0 (_tmp21_);
#line 611 "DatabaseTable.c"
			}
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_g_object_unref0 (info);
#line 615 "DatabaseTable.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp22_;
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			e = _inner_error0_;
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_inner_error0_ = NULL;
#line 110 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp22_ = e->message;
#line 110 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			g_error ("DatabaseTable.vala:110: Error accessing database file:\n" \
" %s\n" \
"\n" \
" Error was: \n" \
"%s", filename, _tmp22_);
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_g_error_free0 (e);
#line 632 "DatabaseTable.c"
		}
		__finally0:
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_g_object_unref0 (db_dir);
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_g_object_unref0 (file_db);
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			g_clear_error (&_inner_error0_);
#line 98 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			return;
#line 647 "DatabaseTable.c"
		}
	}
#line 83 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_object_unref0 (db_dir);
#line 83 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_object_unref0 (file_db);
#line 654 "DatabaseTable.c"
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "sqlite3.vapi"
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
#line 36 "sqlite3.vapi"
	sqlite_errmsg = _tmp0_;
#line 36 "sqlite3.vapi"
	ec = _tmp1_;
#line 37 "sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 683 "DatabaseTable.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 38 "sqlite3.vapi"
		_tmp2_ = sqlite_errmsg;
#line 38 "sqlite3.vapi"
		_tmp3_ = g_strdup (_tmp2_);
#line 38 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "sqlite3.vapi"
		_vala_errmsg = _tmp3_;
#line 694 "DatabaseTable.c"
	} else {
#line 40 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 40 "sqlite3.vapi"
		_vala_errmsg = NULL;
#line 700 "DatabaseTable.c"
	}
#line 42 "sqlite3.vapi"
	_tmp4_ = sqlite_errmsg;
#line 42 "sqlite3.vapi"
	sqlite3_free ((void*) _tmp4_);
#line 43 "sqlite3.vapi"
	result = ec;
#line 43 "sqlite3.vapi"
	if (errmsg) {
#line 43 "sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 712 "DatabaseTable.c"
	} else {
#line 43 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 716 "DatabaseTable.c"
	}
#line 43 "sqlite3.vapi"
	return result;
#line 720 "DatabaseTable.c"
}

gboolean
database_table_init (const gchar* filename)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3* _tmp3_;
	gboolean result;
#line 117 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 118 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (database_table__init) {
#line 118 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		result = TRUE;
#line 118 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return result;
#line 741 "DatabaseTable.c"
	}
#line 119 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table__init = TRUE;
#line 122 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_prepare_db (filename);
#line 126 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 126 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS VersionTable (" "id INTEGER PRIMARY KEY, " "schema_version INTEGER, " "app_version TEXT, " "user_data TEXT NULL" ")", -1, &_tmp1_, NULL);
#line 126 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 126 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp1_;
#line 126 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = _tmp2_;
#line 136 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = database_table_db;
#line 136 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = _sqlite3_exec (_tmp3_, "PRAGMA synchronous=OFF", NULL, NULL, NULL);
#line 137 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_OK) {
#line 138 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_warning ("Unable to disable synchronous mode", res);
#line 765 "DatabaseTable.c"
	}
#line 141 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = TRUE;
#line 141 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 141 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 773 "DatabaseTable.c"
}

void
database_table_terminate (void)
{
#line 146 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	enotes_page_table_reset_instance ();
#line 147 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	enotes_image_table_reset_instance ();
#line 148 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	enotes_notebook_table_reset_instance ();
#line 149 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	enotes_bookmark_table_reset_instance ();
#line 150 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	enotes_tags_table_reset_instance ();
#line 151 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	enotes_file_data_table_reset_instance ();
#line 152 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	enotes_trash_reset_instance ();
#line 154 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_close0 (database_table_db);
#line 154 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_db = NULL;
#line 155 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table__init = FALSE;
#line 799 "DatabaseTable.c"
}

void
database_table_fatal (const gchar* op,
                      gint res)
{
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
#line 159 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (op != NULL);
#line 160 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 160 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = sqlite3_errmsg (_tmp0_);
#line 160 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_warning ("DatabaseTable.vala:160: %s: [%d] %s", op, res, _tmp1_);
#line 816 "DatabaseTable.c"
}

void
database_table_warning (const gchar* op,
                        gint res)
{
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
#line 164 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (op != NULL);
#line 165 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 165 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = sqlite3_errmsg (_tmp0_);
#line 165 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_warning ("DatabaseTable.vala:165: %s: [%d] %s", op, res, _tmp1_);
#line 833 "DatabaseTable.c"
}

void
database_table_set_table_name (DatabaseTable* self,
                               const gchar* table_name)
{
	gchar* _tmp0_;
#line 168 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (self != NULL);
#line 168 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (table_name != NULL);
#line 169 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = g_strdup (table_name);
#line 169 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (self->table_name);
#line 169 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	self->table_name = _tmp0_;
#line 851 "DatabaseTable.c"
}

void
database_table_throw_error (const gchar* method,
                            gint res,
                            GError** error)
{
	gchar* msg = NULL;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 174 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (method != NULL);
#line 175 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 175 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = sqlite3_errmsg (_tmp0_);
#line 175 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("(%s) [%d] - %s", method, res, _tmp1_);
#line 175 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	msg = _tmp2_;
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	switch (res) {
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_OK:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_DONE:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_ROW:
#line 882 "DatabaseTable.c"
		{
#line 181 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_g_free0 (msg);
#line 181 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			return;
#line 888 "DatabaseTable.c"
		}
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_PERM:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_BUSY:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_READONLY:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_IOERR:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_CORRUPT:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_CANTOPEN:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_NOLFS:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_AUTH:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_FORMAT:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_NOTADB:
#line 910 "DatabaseTable.c"
		{
			const gchar* _tmp3_;
			GError* _tmp4_;
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp3_ = msg;
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp4_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_BACKING, _tmp3_);
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_inner_error0_ = _tmp4_;
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 928 "DatabaseTable.c"
			} else {
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 193 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 938 "DatabaseTable.c"
			}
		}
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_NOMEM:
#line 943 "DatabaseTable.c"
		{
			const gchar* _tmp5_;
			GError* _tmp6_;
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp5_ = msg;
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp6_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_MEMORY, _tmp5_);
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_inner_error0_ = _tmp6_;
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 961 "DatabaseTable.c"
			} else {
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 196 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 971 "DatabaseTable.c"
			}
		}
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_ABORT:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_LOCKED:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_INTERRUPT:
#line 980 "DatabaseTable.c"
		{
			const gchar* _tmp7_;
			GError* _tmp8_;
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp7_ = msg;
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp8_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_ABORT, _tmp7_);
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_inner_error0_ = _tmp8_;
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 998 "DatabaseTable.c"
			} else {
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 201 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1008 "DatabaseTable.c"
			}
		}
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_FULL:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_EMPTY:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_TOOBIG:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_CONSTRAINT:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_RANGE:
#line 1021 "DatabaseTable.c"
		{
			const gchar* _tmp9_;
			GError* _tmp10_;
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp9_ = msg;
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp10_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_LIMITS, _tmp9_);
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_inner_error0_ = _tmp10_;
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1039 "DatabaseTable.c"
			} else {
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 208 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1049 "DatabaseTable.c"
			}
		}
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_SCHEMA:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_MISMATCH:
#line 1056 "DatabaseTable.c"
		{
			const gchar* _tmp11_;
			GError* _tmp12_;
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp11_ = msg;
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp12_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_TYPESPEC, _tmp11_);
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_inner_error0_ = _tmp12_;
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1074 "DatabaseTable.c"
			} else {
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 212 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1084 "DatabaseTable.c"
			}
		}
		default:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_ERROR:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_INTERNAL:
#line 177 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		case SQLITE_MISUSE:
#line 1094 "DatabaseTable.c"
		{
			const gchar* _tmp13_;
			GError* _tmp14_;
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp13_ = msg;
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp14_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_ERROR, _tmp13_);
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_inner_error0_ = _tmp14_;
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1112 "DatabaseTable.c"
			} else {
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_g_free0 (msg);
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 218 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1122 "DatabaseTable.c"
			}
		}
	}
}

sqlite3_stmt*
database_table_create_stmt (const gchar* data)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* result;
#line 222 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 223 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_debug ("DatabaseTable.vala:223: Running statement: %s\n", data);
#line 226 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 226 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, data, -1, &_tmp1_, NULL);
#line 226 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 226 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp1_;
#line 226 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = _tmp2_;
#line 227 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_assert_test (res == SQLITE_OK, data);
#line 229 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = stmt;
#line 229 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 1157 "DatabaseTable.c"
}

void
database_table_bind_text (sqlite3_stmt* stmt,
                          gint column,
                          const gchar* data)
{
	gint res = 0;
	gchar* _tmp0_;
	GDestroyNotify _tmp1_;
#line 232 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (stmt != NULL);
#line 232 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (data != NULL);
#line 233 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = g_strdup (data);
#line 233 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = g_free;
#line 233 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_text (stmt, column, _tmp0_, -1, _tmp1_);
#line 234 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 1180 "DatabaseTable.c"
}

void
database_table_bind_int (sqlite3_stmt* stmt,
                         gint column,
                         gint64 data)
{
	gint res = 0;
#line 237 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (stmt != NULL);
#line 238 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_int64 (stmt, column, data);
#line 239 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 1195 "DatabaseTable.c"
}

static void
database_table_assert_test (gboolean condition,
                            const gchar* data)
{
#line 242 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (data != NULL);
#line 243 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (!condition) {
#line 244 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:244: Assertion failed: %s\n", data);
#line 1208 "DatabaseTable.c"
	}
}

gboolean
database_table_exists_by_id (DatabaseTable* self,
                             gint64 id)
{
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	gint res = 0;
	sqlite3_stmt* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean result;
#line 248 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 249 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = self->table_name;
#line 249 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = g_strdup_printf ("SELECT id FROM %s WHERE id=?", _tmp0_);
#line 249 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = _tmp1_;
#line 249 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = database_table_create_stmt (_tmp2_);
#line 249 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp4_ = _tmp3_;
#line 249 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp2_);
#line 249 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp4_;
#line 251 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp5_ = stmt;
#line 251 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_bind_int (_tmp5_, 1, id);
#line 253 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp6_ = stmt;
#line 253 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp6_);
#line 254 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_ROW) {
#line 254 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp7_ = res != SQLITE_DONE;
#line 1255 "DatabaseTable.c"
	} else {
#line 254 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp7_ = FALSE;
#line 1259 "DatabaseTable.c"
	}
#line 254 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (_tmp7_) {
#line 1263 "DatabaseTable.c"
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 255 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, id);
#line 255 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp9_ = _tmp8_;
#line 255 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp10_ = self->table_name;
#line 255 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp11_ = g_strdup_printf ("exists_by_id [%s] %s", _tmp9_, _tmp10_);
#line 255 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp12_ = _tmp11_;
#line 255 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_fatal (_tmp12_, res);
#line 255 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp12_);
#line 255 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp9_);
#line 1285 "DatabaseTable.c"
	}
#line 257 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = res == SQLITE_ROW;
#line 257 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 257 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 1293 "DatabaseTable.c"
}

gboolean
database_table_select_by_id (DatabaseTable* self,
                             gint64 id,
                             const gchar* columns,
                             sqlite3_stmt** stmt)
{
	sqlite3_stmt* _vala_stmt = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint res = 0;
	sqlite3_stmt* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean result;
#line 260 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 260 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (columns != NULL, FALSE);
#line 261 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = self->table_name;
#line 261 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = g_strdup_printf ("SELECT %s FROM %s WHERE id=?", columns, _tmp0_);
#line 261 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = _tmp1_;
#line 261 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = database_table_create_stmt (_tmp2_);
#line 261 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (_vala_stmt);
#line 261 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_stmt = _tmp3_;
#line 261 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp2_);
#line 263 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp4_ = _vala_stmt;
#line 263 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_bind_int (_tmp4_, 1, id);
#line 265 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp5_ = _vala_stmt;
#line 265 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp5_);
#line 266 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_ROW) {
#line 266 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp6_ = res != SQLITE_DONE;
#line 1342 "DatabaseTable.c"
	} else {
#line 266 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp6_ = FALSE;
#line 1346 "DatabaseTable.c"
	}
#line 266 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (_tmp6_) {
#line 1350 "DatabaseTable.c"
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 267 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, id);
#line 267 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp8_ = _tmp7_;
#line 267 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp9_ = self->table_name;
#line 267 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp10_ = g_strdup_printf ("select_by_id [%s] %s %s", _tmp8_, _tmp9_, columns);
#line 267 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp11_ = _tmp10_;
#line 267 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_fatal (_tmp11_, res);
#line 267 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp11_);
#line 267 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp8_);
#line 1372 "DatabaseTable.c"
	}
#line 269 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = res == SQLITE_ROW;
#line 269 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (stmt) {
#line 269 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		*stmt = _vala_stmt;
#line 1380 "DatabaseTable.c"
	} else {
#line 269 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_sqlite3_finalize0 (_vala_stmt);
#line 1384 "DatabaseTable.c"
	}
#line 269 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 1388 "DatabaseTable.c"
}

static void
database_table_prepare_update_by_id (DatabaseTable* self,
                                     gint64 id,
                                     const gchar* column,
                                     sqlite3_stmt** stmt)
{
	sqlite3_stmt* _vala_stmt = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint res = 0;
#line 273 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (self != NULL);
#line 273 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 274 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = self->table_name;
#line 274 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = g_strdup_printf ("UPDATE %s SET %s=? WHERE id=?", _tmp0_, column);
#line 274 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = _tmp1_;
#line 274 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = database_table_create_stmt (_tmp2_);
#line 274 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (_vala_stmt);
#line 274 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_stmt = _tmp3_;
#line 274 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp2_);
#line 276 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_int64 (_vala_stmt, 2, id);
#line 277 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 273 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (stmt) {
#line 273 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		*stmt = _vala_stmt;
#line 1429 "DatabaseTable.c"
	} else {
#line 273 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_sqlite3_finalize0 (_vala_stmt);
#line 1433 "DatabaseTable.c"
	}
}

static gboolean
database_table_execute_update_by_id (DatabaseTable* self,
                                     sqlite3_stmt* stmt)
{
	gint res = 0;
	gboolean result;
#line 280 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 280 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 281 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (stmt);
#line 282 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_DONE) {
#line 283 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_fatal ("execute_update_by_id", res);
#line 285 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		result = FALSE;
#line 285 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return result;
#line 1457 "DatabaseTable.c"
	}
#line 288 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = TRUE;
#line 288 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 1463 "DatabaseTable.c"
}

gboolean
database_table_update_text_by_id (DatabaseTable* self,
                                  gint64 id,
                                  const gchar* column,
                                  const gchar* text)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	gchar* _tmp1_;
	GDestroyNotify _tmp2_;
	gboolean result;
#line 291 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 291 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 291 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 293 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
#line 293 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 293 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp0_;
#line 295 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = g_strdup (text);
#line 295 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = g_free;
#line 295 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_text (stmt, 1, _tmp1_, -1, _tmp2_);
#line 296 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 298 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = database_table_execute_update_by_id (self, stmt);
#line 298 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 298 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 1504 "DatabaseTable.c"
}

void
database_table_update_text_by_id_2 (DatabaseTable* self,
                                    gint64 id,
                                    const gchar* column,
                                    const gchar* text,
                                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	gchar* _tmp2_;
	GDestroyNotify _tmp3_;
	sqlite3_stmt* _tmp4_;
	GError* _inner_error0_ = NULL;
#line 301 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (self != NULL);
#line 301 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 301 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (text != NULL);
#line 303 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
#line 303 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 303 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp0_;
#line 305 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = stmt;
#line 305 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = g_strdup (text);
#line 305 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = g_free;
#line 305 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_text (_tmp1_, 1, _tmp2_, -1, _tmp3_);
#line 306 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 308 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp4_ = stmt;
#line 308 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp4_);
#line 309 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_DONE) {
#line 1550 "DatabaseTable.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp5_ = self->table_name;
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp6_ = g_strdup_printf ("DatabaseTable.update_text_by_id_2 %s.%s", _tmp5_, column);
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp7_ = _tmp6_;
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_throw_error (_tmp7_, res, &_inner_error0_);
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp7_);
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1574 "DatabaseTable.c"
			} else {
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 310 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1584 "DatabaseTable.c"
			}
		}
	}
#line 301 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1590 "DatabaseTable.c"
}

gboolean
database_table_update_int_by_id (DatabaseTable* self,
                                 gint64 id,
                                 const gchar* column,
                                 gint value)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	gboolean result;
#line 313 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 313 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 315 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
#line 315 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 315 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp0_;
#line 317 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_int (stmt, 1, value);
#line 318 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 320 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = database_table_execute_update_by_id (self, stmt);
#line 320 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 320 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 1623 "DatabaseTable.c"
}

void
database_table_update_int_by_id_2 (DatabaseTable* self,
                                   gint64 id,
                                   const gchar* column,
                                   gint value,
                                   GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 323 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (self != NULL);
#line 323 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 325 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
#line 325 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 325 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp0_;
#line 327 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = stmt;
#line 327 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_int (_tmp1_, 1, value);
#line 328 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 330 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = stmt;
#line 330 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp2_);
#line 331 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_DONE) {
#line 1661 "DatabaseTable.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp3_ = self->table_name;
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp4_ = g_strdup_printf ("DatabaseTable.update_int_by_id_2 %s.%s", _tmp3_, column);
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp5_ = _tmp4_;
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_throw_error (_tmp5_, res, &_inner_error0_);
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp5_);
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1685 "DatabaseTable.c"
			} else {
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 332 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1695 "DatabaseTable.c"
			}
		}
	}
#line 323 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1701 "DatabaseTable.c"
}

gboolean
database_table_update_int64_by_id (DatabaseTable* self,
                                   gint64 id,
                                   const gchar* column,
                                   gint64 value)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	gboolean result;
#line 335 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 335 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 337 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
#line 337 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 337 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp0_;
#line 339 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_int64 (stmt, 1, value);
#line 340 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 342 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = database_table_execute_update_by_id (self, stmt);
#line 342 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 342 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 1734 "DatabaseTable.c"
}

void
database_table_update_int64_by_id_2 (DatabaseTable* self,
                                     gint64 id,
                                     const gchar* column,
                                     gint64 value,
                                     GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 345 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (self != NULL);
#line 345 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 347 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, id, column, &_tmp0_);
#line 347 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 347 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp0_;
#line 349 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = stmt;
#line 349 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_int64 (_tmp1_, 1, value);
#line 350 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 352 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = stmt;
#line 352 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp2_);
#line 353 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_DONE) {
#line 1772 "DatabaseTable.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp3_ = self->table_name;
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp4_ = g_strdup_printf ("DatabaseTable.update_int64_by_id_2 %s.%s", _tmp3_, column);
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp5_ = _tmp4_;
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_throw_error (_tmp5_, res, &_inner_error0_);
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp5_);
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1796 "DatabaseTable.c"
			} else {
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 354 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1806 "DatabaseTable.c"
			}
		}
	}
#line 345 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1812 "DatabaseTable.c"
}

void
database_table_delete_by_id (DatabaseTable* self,
                             gint64 id,
                             GError** error)
{
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint res = 0;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	GError* _inner_error0_ = NULL;
#line 357 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (self != NULL);
#line 358 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = self->table_name;
#line 358 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = g_strdup_printf ("DELETE FROM %s WHERE id=?", _tmp0_);
#line 358 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = _tmp1_;
#line 358 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = database_table_create_stmt (_tmp2_);
#line 358 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp4_ = _tmp3_;
#line 358 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp2_);
#line 358 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp4_;
#line 360 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp5_ = stmt;
#line 360 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_bind_int64 (_tmp5_, 1, id);
#line 361 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 363 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp6_ = stmt;
#line 363 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp6_);
#line 364 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_DONE) {
#line 1858 "DatabaseTable.c"
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp7_ = self->table_name;
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp8_ = g_strdup_printf ("%s.remove", _tmp7_);
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp9_ = _tmp8_;
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_throw_error (_tmp9_, res, &_inner_error0_);
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_g_free0 (_tmp9_);
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1882 "DatabaseTable.c"
			} else {
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 365 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 1892 "DatabaseTable.c"
			}
		}
	}
#line 357 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1898 "DatabaseTable.c"
}

gboolean
database_table_has_column (const gchar* table_name,
                           const gchar* column_name)
{
	sqlite3_stmt* stmt = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gboolean result;
#line 368 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 368 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 369 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = g_strdup_printf ("PRAGMA table_info(%s)", table_name);
#line 369 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = _tmp0_;
#line 369 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = database_table_create_stmt (_tmp1_);
#line 369 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 369 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp1_);
#line 369 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp3_;
#line 1927 "DatabaseTable.c"
	{
		gboolean _tmp4_ = FALSE;
#line 371 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp4_ = TRUE;
#line 371 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		while (TRUE) {
#line 1934 "DatabaseTable.c"
			gint res = 0;
			sqlite3_stmt* _tmp5_;
#line 371 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (!_tmp4_) {
#line 1939 "DatabaseTable.c"
			}
#line 371 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp4_ = FALSE;
#line 372 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			_tmp5_ = stmt;
#line 372 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			res = sqlite3_step (_tmp5_);
#line 373 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (res == SQLITE_DONE) {
#line 374 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				break;
#line 1951 "DatabaseTable.c"
			} else {
#line 375 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				if (res != SQLITE_ROW) {
#line 1955 "DatabaseTable.c"
					gchar* _tmp6_;
					gchar* _tmp7_;
#line 376 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					_tmp6_ = g_strdup_printf ("has_column %s", table_name);
#line 376 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					_tmp7_ = _tmp6_;
#line 376 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					database_table_fatal (_tmp7_, res);
#line 376 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					_g_free0 (_tmp7_);
#line 378 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					break;
#line 1968 "DatabaseTable.c"
				} else {
					gchar* column = NULL;
					sqlite3_stmt* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_;
#line 380 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					_tmp8_ = stmt;
#line 380 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 1);
#line 380 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					_tmp10_ = g_strdup (_tmp9_);
#line 380 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					column = _tmp10_;
#line 381 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					_tmp12_ = column;
#line 381 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					if (_tmp12_ != NULL) {
#line 1988 "DatabaseTable.c"
						const gchar* _tmp13_;
#line 381 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
						_tmp13_ = column;
#line 381 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
						_tmp11_ = g_strcmp0 (_tmp13_, column_name) == 0;
#line 1994 "DatabaseTable.c"
					} else {
#line 381 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
						_tmp11_ = FALSE;
#line 1998 "DatabaseTable.c"
					}
#line 381 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					if (_tmp11_) {
#line 382 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
						result = TRUE;
#line 382 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
						_g_free0 (column);
#line 382 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
						_sqlite3_finalize0 (stmt);
#line 382 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
						return result;
#line 2010 "DatabaseTable.c"
					}
#line 375 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
					_g_free0 (column);
#line 2014 "DatabaseTable.c"
				}
			}
		}
	}
#line 386 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = FALSE;
#line 386 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 386 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 2025 "DatabaseTable.c"
}

gboolean
database_table_has_table (const gchar* table_name)
{
	sqlite3_stmt* stmt = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint res = 0;
	gboolean result;
#line 389 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 390 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = g_strdup_printf ("PRAGMA table_info(%s)", table_name);
#line 390 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = _tmp0_;
#line 390 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = database_table_create_stmt (_tmp1_);
#line 390 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 390 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp1_);
#line 390 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp3_;
#line 392 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (stmt);
#line 394 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = res != SQLITE_DONE;
#line 394 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 394 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 2060 "DatabaseTable.c"
}

gboolean
database_table_add_column (const gchar* table_name,
                           const gchar* column_name,
                           const gchar* column_constraints)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	gboolean result;
#line 397 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 397 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 397 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (column_constraints != NULL, FALSE);
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = g_strdup_printf ("ALTER TABLE %s ADD COLUMN %s %s", table_name, column_name, column_constraints);
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = _tmp1_;
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp3_;
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp5_ = _tmp4_;
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp2_);
#line 399 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = _tmp5_;
#line 401 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 403 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp6_ = stmt;
#line 403 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp6_);
#line 404 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_DONE) {
#line 2110 "DatabaseTable.c"
		sqlite3* _tmp7_;
		const gchar* _tmp8_;
#line 405 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp7_ = database_table_db;
#line 405 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp8_ = sqlite3_errmsg (_tmp7_);
#line 405 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:405: Unable to add column %s %s %s: (%d) %s", table_name, column_name, column_constraints, res, _tmp8_);
#line 408 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		result = FALSE;
#line 408 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_sqlite3_finalize0 (stmt);
#line 408 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return result;
#line 2125 "DatabaseTable.c"
	}
#line 411 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = TRUE;
#line 411 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 411 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 2133 "DatabaseTable.c"
}

gint64
database_table_last_insert_row (DatabaseTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp5_;
	gint64 result;
#line 414 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 415 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_create_stmt ("SELECT last_insert_rowid()");
#line 415 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp0_;
#line 417 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = stmt;
#line 417 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp1_);
#line 418 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_ROW) {
#line 2157 "DatabaseTable.c"
		const gchar* _tmp2_;
		sqlite3* _tmp3_;
		const gchar* _tmp4_;
#line 419 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp2_ = self->table_name;
#line 419 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp3_ = database_table_db;
#line 419 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp4_ = sqlite3_errmsg (_tmp3_);
#line 419 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:419: Unable to retrieve last row on %s: (%d) %s", _tmp2_, res, _tmp4_);
#line 421 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		result = (gint64) 0;
#line 421 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_sqlite3_finalize0 (stmt);
#line 421 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return result;
#line 2175 "DatabaseTable.c"
	}
#line 424 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp5_ = stmt;
#line 424 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = sqlite3_column_int64 (_tmp5_, 0);
#line 424 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 424 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 2185 "DatabaseTable.c"
}

gboolean
database_table_ensure_column (const gchar* table_name,
                              const gchar* column_name,
                              const gchar* column_constraints,
                              const gchar* upgrade_msg)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 430 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 430 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 430 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (column_constraints != NULL, FALSE);
#line 430 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (upgrade_msg != NULL, FALSE);
#line 432 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (!database_table_has_table (table_name)) {
#line 432 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp0_ = TRUE;
#line 2208 "DatabaseTable.c"
	} else {
#line 432 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp0_ = database_table_has_column (table_name, column_name);
#line 2212 "DatabaseTable.c"
	}
#line 432 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (_tmp0_) {
#line 433 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		result = TRUE;
#line 433 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return result;
#line 2220 "DatabaseTable.c"
	}
#line 435 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_message ("DatabaseTable.vala:435: %s", upgrade_msg);
#line 437 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = database_table_add_column (table_name, column_name, column_constraints);
#line 437 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 2228 "DatabaseTable.c"
}

gint
database_table_get_row_count (DatabaseTable* self)
{
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint res = 0;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp9_;
	gint result;
#line 440 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 441 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = self->table_name;
#line 441 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = g_strdup_printf ("SELECT COUNT(id) AS RowCount FROM %s", _tmp0_);
#line 441 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp2_ = _tmp1_;
#line 441 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp3_ = database_table_create_stmt (_tmp2_);
#line 441 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp4_ = _tmp3_;
#line 441 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (_tmp2_);
#line 441 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	stmt = _tmp4_;
#line 443 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp5_ = stmt;
#line 443 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = sqlite3_step (_tmp5_);
#line 444 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_ROW) {
#line 2266 "DatabaseTable.c"
		const gchar* _tmp6_;
		sqlite3* _tmp7_;
		const gchar* _tmp8_;
#line 445 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp6_ = self->table_name;
#line 445 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp7_ = database_table_db;
#line 445 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_tmp8_ = sqlite3_errmsg (_tmp7_);
#line 445 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:445: Unable to retrieve row count on %s: (%d) %s", _tmp6_, res, _tmp8_);
#line 447 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		result = 0;
#line 447 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		_sqlite3_finalize0 (stmt);
#line 447 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return result;
#line 2284 "DatabaseTable.c"
	}
#line 450 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp9_ = stmt;
#line 450 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	result = sqlite3_column_int (_tmp9_, 0);
#line 450 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 450 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return result;
#line 2294 "DatabaseTable.c"
}

void
database_table_begin_transaction (void)
{
	gint _tmp0_;
	gint res = 0;
	sqlite3* _tmp1_;
#line 455 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_in_transaction;
#line 455 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_in_transaction = _tmp0_ + 1;
#line 455 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (_tmp0_ != 0) {
#line 456 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return;
#line 2311 "DatabaseTable.c"
	}
#line 458 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = database_table_db;
#line 458 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = _sqlite3_exec (_tmp1_, "BEGIN TRANSACTION", NULL, NULL, NULL);
#line 459 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 2319 "DatabaseTable.c"
}

void
database_table_commit_transaction (GError** error)
{
	gint _tmp0_;
	gint res = 0;
	sqlite3* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 464 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_vala_assert (database_table_in_transaction > 0, "in_transaction > 0");
#line 465 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_in_transaction = database_table_in_transaction - 1;
#line 465 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp0_ = database_table_in_transaction;
#line 465 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (_tmp0_ != 0) {
#line 466 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return;
#line 2339 "DatabaseTable.c"
	}
#line 468 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_tmp1_ = database_table_db;
#line 468 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	res = _sqlite3_exec (_tmp1_, "COMMIT TRANSACTION", NULL, NULL, NULL);
#line 469 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (res != SQLITE_DONE) {
#line 470 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_throw_error ("commit_transaction", res, &_inner_error0_);
#line 470 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 470 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			if (_inner_error0_->domain == DATABASE_ERROR) {
#line 470 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_propagate_error (error, _inner_error0_);
#line 470 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 2357 "DatabaseTable.c"
			} else {
#line 470 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 470 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				g_clear_error (&_inner_error0_);
#line 470 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
				return;
#line 2365 "DatabaseTable.c"
			}
		}
	}
}

DatabaseTable*
database_table_construct (GType object_type)
{
	DatabaseTable* self = NULL;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	self = (DatabaseTable*) g_type_create_instance (object_type);
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return self;
#line 2379 "DatabaseTable.c"
}

static void
value_database_table_init (GValue* value)
{
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	value->data[0].v_pointer = NULL;
#line 2387 "DatabaseTable.c"
}

static void
value_database_table_free_value (GValue* value)
{
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (value->data[0].v_pointer) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_unref (value->data[0].v_pointer);
#line 2397 "DatabaseTable.c"
	}
}

static void
value_database_table_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (src_value->data[0].v_pointer) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		dest_value->data[0].v_pointer = database_table_ref (src_value->data[0].v_pointer);
#line 2409 "DatabaseTable.c"
	} else {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2413 "DatabaseTable.c"
	}
}

static gpointer
value_database_table_peek_pointer (const GValue* value)
{
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return value->data[0].v_pointer;
#line 2422 "DatabaseTable.c"
}

static gchar*
value_database_table_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (collect_values[0].v_pointer) {
#line 2433 "DatabaseTable.c"
		DatabaseTable * object;
		object = collect_values[0].v_pointer;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2440 "DatabaseTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2444 "DatabaseTable.c"
		}
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		value->data[0].v_pointer = database_table_ref (object);
#line 2448 "DatabaseTable.c"
	} else {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2452 "DatabaseTable.c"
	}
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return NULL;
#line 2456 "DatabaseTable.c"
}

static gchar*
value_database_table_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	DatabaseTable ** object_p;
	object_p = collect_values[0].v_pointer;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (!object_p) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2471 "DatabaseTable.c"
	}
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (!value->data[0].v_pointer) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		*object_p = NULL;
#line 2477 "DatabaseTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		*object_p = value->data[0].v_pointer;
#line 2481 "DatabaseTable.c"
	} else {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		*object_p = database_table_ref (value->data[0].v_pointer);
#line 2485 "DatabaseTable.c"
	}
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return NULL;
#line 2489 "DatabaseTable.c"
}

GParamSpec*
param_spec_database_table (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecDatabaseTable* spec;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATABASE_TABLE), NULL);
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return G_PARAM_SPEC (spec);
#line 2508 "DatabaseTable.c"
}

gpointer
value_get_database_table (const GValue* value)
{
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE), NULL);
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return value->data[0].v_pointer;
#line 2518 "DatabaseTable.c"
}

void
value_set_database_table (GValue* value,
                          gpointer v_object)
{
	DatabaseTable * old;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE));
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	old = value->data[0].v_pointer;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (v_object) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATABASE_TABLE));
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		value->data[0].v_pointer = v_object;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_ref (value->data[0].v_pointer);
#line 2540 "DatabaseTable.c"
	} else {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2544 "DatabaseTable.c"
	}
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (old) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_unref (old);
#line 2550 "DatabaseTable.c"
	}
}

void
value_take_database_table (GValue* value,
                           gpointer v_object)
{
	DatabaseTable * old;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE));
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	old = value->data[0].v_pointer;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (v_object) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATABASE_TABLE));
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		value->data[0].v_pointer = v_object;
#line 2571 "DatabaseTable.c"
	} else {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2575 "DatabaseTable.c"
	}
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (old) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		database_table_unref (old);
#line 2581 "DatabaseTable.c"
	}
}

static void
database_table_class_init (DatabaseTableClass * klass,
                           gpointer klass_data)
{
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	database_table_parent_class = g_type_class_peek_parent (klass);
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	((DatabaseTableClass *) klass)->finalize = database_table_finalize;
#line 2593 "DatabaseTable.c"
}

static void
database_table_instance_init (DatabaseTable * self,
                              gpointer klass)
{
#line 81 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	self->table_name = NULL;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	self->ref_count = 1;
#line 2604 "DatabaseTable.c"
}

static void
database_table_finalize (DatabaseTable * obj)
{
	DatabaseTable * self;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATABASE_TABLE, DatabaseTable);
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_signal_handlers_destroy (self);
#line 81 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	_g_free0 (self->table_name);
#line 2617 "DatabaseTable.c"
}

static GType
database_table_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_database_table_init, value_database_table_free_value, value_database_table_copy_value, value_database_table_peek_pointer, "p", value_database_table_collect_value, "p", value_database_table_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DatabaseTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) database_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DatabaseTable), 0, (GInstanceInitFunc) database_table_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType database_table_type_id;
	database_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DatabaseTable", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return database_table_type_id;
}

GType
database_table_get_type (void)
{
	static volatile gsize database_table_type_id__once = 0;
	if (g_once_init_enter (&database_table_type_id__once)) {
		GType database_table_type_id;
		database_table_type_id = database_table_get_type_once ();
		g_once_init_leave (&database_table_type_id__once, database_table_type_id);
	}
	return database_table_type_id__once;
}

gpointer
database_table_ref (gpointer instance)
{
	DatabaseTable * self;
	self = instance;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	return instance;
#line 2652 "DatabaseTable.c"
}

void
database_table_unref (gpointer instance)
{
	DatabaseTable * self;
	self = instance;
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		DATABASE_TABLE_GET_CLASS (self)->finalize (self);
#line 67 "../Notes-up-2.0.6/src/Services/DatabaseTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2666 "DatabaseTable.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

