/* Unity.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Unity.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0+
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 *                         2015 Rico Tzschichholz
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define SLINGSHOT_UNITY_DBUS_NAME "com.canonical.Unity"
#define SLINGSHOT_UNITY_INTERFACE_NAME "com.canonical.Unity.LauncherEntry"
#define SLINGSHOT_UNITY_SIGNAL_NAME "Update"
#define SLINGSHOT_UNITY_UNITY_UPDATE_THRESHOLD_DURATION ((guint) 32)
#define SLINGSHOT_UNITY_UNITY_UPDATE_THRESHOLD_FAST_COUNT ((guint) 3)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY (slingshot_unity_launcher_entry_get_type ())
#define SLINGSHOT_UNITY_LAUNCHER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY, SlingshotUnityLauncherEntry))
#define SLINGSHOT_UNITY_LAUNCHER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY, SlingshotUnityLauncherEntryClass))
#define SLINGSHOT_UNITY_IS_LAUNCHER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY))
#define SLINGSHOT_UNITY_IS_LAUNCHER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY))
#define SLINGSHOT_UNITY_LAUNCHER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY, SlingshotUnityLauncherEntryClass))

typedef struct _SlingshotUnityLauncherEntry SlingshotUnityLauncherEntry;
typedef struct _SlingshotUnityLauncherEntryClass SlingshotUnityLauncherEntryClass;
enum  {
	SLINGSHOT_UNITY_0_PROPERTY,
	SLINGSHOT_UNITY_NUM_PROPERTIES
};
static GParamSpec* slingshot_unity_properties[SLINGSHOT_UNITY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block11Data Block11Data;
#define _slingshot_unity_launcher_entry_unref0(var) ((var == NULL) ? NULL : (var = (slingshot_unity_launcher_entry_unref (var), NULL)))
typedef struct _SlingshotUnityLauncherEntryPrivate SlingshotUnityLauncherEntryPrivate;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _SlingshotUnityParamSpecLauncherEntry SlingshotUnityParamSpecLauncherEntry;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

struct _SlingshotUnityPrivate {
	GeeHashSet* clients;
	guint launcher_entry_dbus_signal_id;
	guint dbus_name_owner_changed_signal_id;
	GeeHashMap* launcher_entries;
	guint launcher_entries_timer_id;
};

struct _Block10Data {
	int _ref_count_;
	SlingshotUnity* self;
	gchar* name;
};

struct _Block11Data {
	int _ref_count_;
	SlingshotUnity* self;
	SlingshotUnityLauncherEntry* entry;
};

struct _SlingshotUnityLauncherEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlingshotUnityLauncherEntryPrivate * priv;
	guint fast_count;
	gint64 last_update;
	gchar* sender_name;
	GVariant* parameters;
	guint timer_id;
	gboolean warned;
};

struct _SlingshotUnityLauncherEntryClass {
	GTypeClass parent_class;
	void (*finalize) (SlingshotUnityLauncherEntry *self);
};

struct _Block12Data {
	int _ref_count_;
	SlingshotUnity* self;
	gchar* sender_name;
	GVariant* parameters;
};

struct _SlingshotUnityParamSpecLauncherEntry {
	GParamSpec parent_instance;
};

static gint SlingshotUnity_private_offset;
static gpointer slingshot_unity_parent_class = NULL;
static guint slingshot_unity_unity_bus_id;
static GDBusConnection* slingshot_unity_connection;
static SlingshotUnity* slingshot_unity_instance;
static SlingshotUnity* slingshot_unity_instance = NULL;
static GDBusConnection* slingshot_unity_connection = NULL;
static guint slingshot_unity_unity_bus_id = 0U;
static GVariantType* slingshot_unity_payload_variant_type;
static GVariantType* slingshot_unity_payload_variant_type = NULL;
static gpointer slingshot_unity_launcher_entry_parent_class = NULL;

static GType slingshot_unity_client_get_type_once (void);
static gpointer slingshot_unity_launcher_entry_ref (gpointer instance);
static void slingshot_unity_launcher_entry_unref (gpointer instance);
static GParamSpec* slingshot_unity_param_spec_launcher_entry (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void slingshot_unity_value_set_launcher_entry (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void slingshot_unity_value_take_launcher_entry (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer slingshot_unity_value_get_launcher_entry (const GValue* value) G_GNUC_UNUSED ;
static GType slingshot_unity_launcher_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void slingshot_unity_acquire_unity_dbus (void);
static void slingshot_unity_handle_bus_acquired (GDBusConnection* conn,
                                          const gchar* name);
static void slingshot_unity_handle_name_acquired (GDBusConnection* conn,
                                           const gchar* name);
static void slingshot_unity_handle_name_lost (GDBusConnection* conn,
                                       const gchar* name);
static void slingshot_unity_handle_entry_signal (GDBusConnection* connection,
                                          const gchar* sender_name,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* signal_name,
                                          GVariant* parameters,
                                          SlingshotUnity* self);
static void slingshot_unity_handle_update_request (SlingshotUnity* self,
                                            const gchar* sender_name,
                                            GVariant* parameters);
static void slingshot_unity_handle_name_owner_changed (GDBusConnection* connection,
                                                const gchar* sender_name,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* signal_name,
                                                GVariant* parameters,
                                                SlingshotUnity* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean __lambda83_ (Block10Data* _data10_,
                      SlingshotUnityClient* client);
static gboolean ___lambda83__gee_forall_func (gpointer g,
                                       gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean _____lambda81_ (Block11Data* _data11_);
static void slingshot_unity_perform_update (SlingshotUnity* self,
                                     const gchar* sender_name,
                                     GVariant* parameters);
static gboolean ______lambda81__gsource_func (gpointer self);
static SlingshotUnityLauncherEntry* slingshot_unity_launcher_entry_new (void);
static SlingshotUnityLauncherEntry* slingshot_unity_launcher_entry_construct (GType object_type);
static gboolean slingshot_unity_clean_up_launcher_entries (SlingshotUnity* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean __lambda82_ (Block12Data* _data12_,
                      SlingshotUnityClient* client);
static gboolean ___lambda82__gee_forall_func (gpointer g,
                                       gpointer self);
static void slingshot_unity_launcher_entry_finalize (SlingshotUnityLauncherEntry * obj);
static GType slingshot_unity_launcher_entry_get_type_once (void);
static GObject * slingshot_unity_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void slingshot_unity_finalize (GObject * obj);
static GType slingshot_unity_get_type_once (void);

/**
     * The LauncherEntry corresponding to the sender_name requested an update
     *
     * @param sender_name the dbusname
     * @param parameters the data in a standardize format '(sa{sv})' from libunity
     * @param is_retry whether this data was already processed before and decided to give is another run
     */
void
slingshot_unity_client_update_launcher_entry (SlingshotUnityClient* self,
                                              const gchar* sender_name,
                                              GVariant* parameters,
                                              gboolean is_retry)
{
	SlingshotUnityClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SLINGSHOT_UNITY_CLIENT_GET_INTERFACE (self);
	if (_iface_->update_launcher_entry) {
		_iface_->update_launcher_entry (self, sender_name, parameters, is_retry);
	}
}

/**
     * The LauncherEntry corresponding to the sender_name vanished
     *
     * @param sender_name the dbusname
     */
void
slingshot_unity_client_remove_launcher_entry (SlingshotUnityClient* self,
                                              const gchar* sender_name)
{
	SlingshotUnityClientIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SLINGSHOT_UNITY_CLIENT_GET_INTERFACE (self);
	if (_iface_->remove_launcher_entry) {
		_iface_->remove_launcher_entry (self, sender_name);
	}
}

static void
slingshot_unity_client_default_init (SlingshotUnityClientIface * iface,
                                     gpointer iface_data)
{
}

/**
 * The interface to provide the LauncherEntry handling.
 */
static GType
slingshot_unity_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotUnityClientIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_unity_client_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType slingshot_unity_client_type_id;
	slingshot_unity_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "SlingshotUnityClient", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (slingshot_unity_client_type_id, G_TYPE_OBJECT);
	return slingshot_unity_client_type_id;
}

GType
slingshot_unity_client_get_type (void)
{
	static volatile gsize slingshot_unity_client_type_id__once = 0;
	if (g_once_init_enter (&slingshot_unity_client_type_id__once)) {
		GType slingshot_unity_client_type_id;
		slingshot_unity_client_type_id = slingshot_unity_client_get_type_once ();
		g_once_init_leave (&slingshot_unity_client_type_id__once, slingshot_unity_client_type_id);
	}
	return slingshot_unity_client_type_id__once;
}

static inline gpointer
slingshot_unity_get_instance_private (SlingshotUnity* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotUnity_private_offset);
}

SlingshotUnity*
slingshot_unity_get_default (void)
{
	SlingshotUnity* _tmp0_;
	SlingshotUnity* _tmp2_;
	SlingshotUnity* result;
	_tmp0_ = slingshot_unity_instance;
	if (_tmp0_ == NULL) {
		SlingshotUnity* _tmp1_;
		_tmp1_ = slingshot_unity_new ();
		_g_object_unref0 (slingshot_unity_instance);
		slingshot_unity_instance = _tmp1_;
	}
	_tmp2_ = slingshot_unity_instance;
	result = _tmp2_;
	return result;
}

/**
     * Connect DBus connection and try to aquire unity busname
     */
static void
slingshot_unity_acquire_unity_dbus (void)
{
	GError* _inner_error0_ = NULL;
	{
		GDBusConnection* _tmp0_;
		_tmp0_ = slingshot_unity_connection;
		if (_tmp0_ == NULL) {
			GDBusConnection* _tmp1_ = NULL;
			GDBusConnection* _tmp2_;
			GDBusConnection* _tmp3_;
			_tmp2_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (slingshot_unity_connection);
			slingshot_unity_connection = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("Unity.vala:75: %s", _tmp5_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (slingshot_unity_unity_bus_id == 0U) {
		slingshot_unity_unity_bus_id = g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, SLINGSHOT_UNITY_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT, (GClosure*) g_cclosure_new ((GCallback) ((GBusAcquiredCallback) slingshot_unity_handle_bus_acquired), NULL, (GClosureNotify) NULL), (GClosure*) g_cclosure_new ((GCallback) ((GBusNameAcquiredCallback) slingshot_unity_handle_name_acquired), NULL, (GClosureNotify) NULL), (GClosure*) g_cclosure_new ((GCallback) ((GBusNameLostCallback) slingshot_unity_handle_name_lost), NULL, (GClosureNotify) NULL));
	}
}

static void
slingshot_unity_handle_bus_acquired (GDBusConnection* conn,
                                     const gchar* name)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
}

static void
slingshot_unity_handle_name_acquired (GDBusConnection* conn,
                                      const gchar* name)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_debug ("Unity.vala:92: %s acquired", name);
}

static void
slingshot_unity_handle_name_lost (GDBusConnection* conn,
                                  const gchar* name)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	if (conn == NULL) {
		g_warning ("Unity.vala:97: %s failed", name);
	} else {
		g_debug ("Unity.vala:99: %s lost", name);
	}
}

/**
     * Add a client which will receive all update requests of running LauncherEntry applications.
     *
     * @param client the client to add
     */
void
slingshot_unity_add_client (SlingshotUnity* self,
                            SlingshotUnityClient* client)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = self->priv->clients;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, client);
}

/**
     * Remove a client.
     *
     * @param client the client to remove
     */
void
slingshot_unity_remove_client (SlingshotUnity* self,
                               SlingshotUnityClient* client)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = self->priv->clients;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, client);
}

static void
slingshot_unity_handle_entry_signal (GDBusConnection* connection,
                                     const gchar* sender_name,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* signal_name,
                                     GVariant* parameters,
                                     SlingshotUnity* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	if (parameters == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = signal_name == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sender_name == NULL;
	}
	if (_tmp0_) {
		return;
	}
	if (g_strcmp0 (signal_name, SLINGSHOT_UNITY_SIGNAL_NAME) == 0) {
		slingshot_unity_handle_update_request (self, sender_name, parameters);
	}
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		SlingshotUnity* self;
		self = _data10_->self;
		_g_free0 (_data10_->name);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
__lambda83_ (Block10Data* _data10_,
             SlingshotUnityClient* client)
{
	SlingshotUnity* self;
	const gchar* _tmp0_;
	gboolean result;
	self = _data10_->self;
	g_return_val_if_fail (client != NULL, FALSE);
	_tmp0_ = _data10_->name;
	slingshot_unity_client_remove_launcher_entry (client, _tmp0_);
	result = TRUE;
	_g_object_unref0 (client);
	return result;
}

static gboolean
___lambda83__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda83_ (self, (SlingshotUnityClient*) g);
	return result;
}

static void
slingshot_unity_handle_name_owner_changed (GDBusConnection* connection,
                                           const gchar* sender_name,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* signal_name,
                                           GVariant* parameters,
                                           SlingshotUnity* self)
{
	Block10Data* _data10_;
	gchar* before = NULL;
	gchar* after = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GeeHashSet* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	g_variant_get (parameters, "(sss)", &_tmp0_, &_tmp1_, &_tmp2_, NULL);
	_g_free0 (_data10_->name);
	_data10_->name = _tmp0_;
	_g_free0 (before);
	before = _tmp1_;
	_g_free0 (after);
	after = _tmp2_;
	_tmp4_ = after;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = after;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_g_free0 (after);
		_g_free0 (before);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp6_ = self->priv->clients;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp6_, ___lambda83__gee_forall_func, _data10_);
	_g_free0 (after);
	_g_free0 (before);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SlingshotUnity* self;
		self = _data11_->self;
		_slingshot_unity_launcher_entry_unref0 (_data11_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gboolean
_____lambda81_ (Block11Data* _data11_)
{
	SlingshotUnity* self;
	SlingshotUnityLauncherEntry* _tmp0_;
	SlingshotUnityLauncherEntry* _tmp1_;
	SlingshotUnityLauncherEntry* _tmp2_;
	const gchar* _tmp3_;
	SlingshotUnityLauncherEntry* _tmp4_;
	GVariant* _tmp5_;
	gboolean result;
	self = _data11_->self;
	_tmp0_ = _data11_->entry;
	_tmp0_->timer_id = 0U;
	_tmp1_ = _data11_->entry;
	_tmp1_->last_update = g_get_monotonic_time ();
	_tmp2_ = _data11_->entry;
	_tmp3_ = _tmp2_->sender_name;
	_tmp4_ = _data11_->entry;
	_tmp5_ = _tmp4_->parameters;
	slingshot_unity_perform_update (self, _tmp3_, _tmp5_);
	result = FALSE;
	return result;
}

static gboolean
______lambda81__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda81_ (self);
	return result;
}

static void
slingshot_unity_handle_update_request (SlingshotUnity* self,
                                       const gchar* sender_name,
                                       GVariant* parameters)
{
	Block11Data* _data11_;
	gint64 current_time = 0LL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SlingshotUnityLauncherEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (parameters != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	current_time = g_get_monotonic_time ();
	_tmp0_ = self->priv->launcher_entries;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, sender_name);
	_slingshot_unity_launcher_entry_unref0 (_data11_->entry);
	_data11_->entry = (SlingshotUnityLauncherEntry*) _tmp1_;
	_tmp2_ = _data11_->entry;
	if (_tmp2_ != NULL) {
		SlingshotUnityLauncherEntry* _tmp3_;
		GVariant* _tmp4_;
		gboolean _tmp5_ = FALSE;
		SlingshotUnityLauncherEntry* _tmp6_;
		_tmp3_ = _data11_->entry;
		_tmp4_ = _g_variant_ref0 (parameters);
		_g_variant_unref0 (_tmp3_->parameters);
		_tmp3_->parameters = _tmp4_;
		_tmp6_ = _data11_->entry;
		if ((current_time - _tmp6_->last_update) < ((gint64) (SLINGSHOT_UNITY_UNITY_UPDATE_THRESHOLD_DURATION * 1000))) {
			SlingshotUnityLauncherEntry* _tmp7_;
			_tmp7_ = _data11_->entry;
			_tmp5_ = _tmp7_->fast_count > SLINGSHOT_UNITY_UNITY_UPDATE_THRESHOLD_FAST_COUNT;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			SlingshotUnityLauncherEntry* _tmp8_;
			_tmp8_ = _data11_->entry;
			if (_tmp8_->timer_id <= 0U) {
				SlingshotUnityLauncherEntry* _tmp9_;
				SlingshotUnityLauncherEntry* _tmp11_;
				_tmp9_ = _data11_->entry;
				if (!_tmp9_->warned) {
					SlingshotUnityLauncherEntry* _tmp10_;
					g_warning ("Unity.vala:210: LauncherEntry '%s' is behaving badly, skipping request" \
"s", sender_name);
					_tmp10_ = _data11_->entry;
					_tmp10_->warned = TRUE;
				}
				_tmp11_ = _data11_->entry;
				_tmp11_->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, SLINGSHOT_UNITY_UNITY_UPDATE_THRESHOLD_DURATION, ______lambda81__gsource_func, block11_data_ref (_data11_), block11_data_unref);
			}
		} else {
			SlingshotUnityLauncherEntry* _tmp12_;
			guint _tmp13_;
			SlingshotUnityLauncherEntry* _tmp14_;
			SlingshotUnityLauncherEntry* _tmp15_;
			const gchar* _tmp16_;
			SlingshotUnityLauncherEntry* _tmp17_;
			GVariant* _tmp18_;
			_tmp12_ = _data11_->entry;
			_tmp13_ = _tmp12_->fast_count;
			_tmp12_->fast_count = _tmp13_ + 1;
			_tmp14_ = _data11_->entry;
			_tmp14_->last_update = current_time;
			_tmp15_ = _data11_->entry;
			_tmp16_ = _tmp15_->sender_name;
			_tmp17_ = _data11_->entry;
			_tmp18_ = _tmp17_->parameters;
			slingshot_unity_perform_update (self, _tmp16_, _tmp18_);
		}
	} else {
		SlingshotUnityLauncherEntry* _tmp19_;
		SlingshotUnityLauncherEntry* _tmp20_;
		guint _tmp21_;
		SlingshotUnityLauncherEntry* _tmp22_;
		SlingshotUnityLauncherEntry* _tmp23_;
		gchar* _tmp24_;
		SlingshotUnityLauncherEntry* _tmp25_;
		GVariant* _tmp26_;
		GeeHashMap* _tmp27_;
		SlingshotUnityLauncherEntry* _tmp28_;
		_tmp19_ = slingshot_unity_launcher_entry_new ();
		_slingshot_unity_launcher_entry_unref0 (_data11_->entry);
		_data11_->entry = _tmp19_;
		_tmp20_ = _data11_->entry;
		_tmp21_ = _tmp20_->fast_count;
		_tmp20_->fast_count = _tmp21_ + 1;
		_tmp22_ = _data11_->entry;
		_tmp22_->last_update = current_time;
		_tmp23_ = _data11_->entry;
		_tmp24_ = g_strdup (sender_name);
		_g_free0 (_tmp23_->sender_name);
		_tmp23_->sender_name = _tmp24_;
		_tmp25_ = _data11_->entry;
		_tmp26_ = _g_variant_ref0 (parameters);
		_g_variant_unref0 (_tmp25_->parameters);
		_tmp25_->parameters = _tmp26_;
		_tmp27_ = self->priv->launcher_entries;
		_tmp28_ = _data11_->entry;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, sender_name, _tmp28_);
		slingshot_unity_perform_update (self, sender_name, parameters);
	}
	if (self->priv->launcher_entries_timer_id <= 0U) {
		self->priv->launcher_entries_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (60 * 1000), (GSourceFunc) slingshot_unity_clean_up_launcher_entries, g_object_ref (self), g_object_unref);
	}
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static gboolean
slingshot_unity_clean_up_launcher_entries (SlingshotUnity* self)
{
	gint64 current_time = 0LL;
	GeeMapIterator* launcher_entries_it = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	gboolean keep_running = FALSE;
	GeeHashMap* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	current_time = g_get_monotonic_time ();
	_tmp0_ = self->priv->launcher_entries;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	launcher_entries_it = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		SlingshotUnityLauncherEntry* entry = NULL;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		SlingshotUnityLauncherEntry* _tmp5_;
		_tmp2_ = launcher_entries_it;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = launcher_entries_it;
		_tmp4_ = gee_map_iterator_get_value (_tmp3_);
		entry = (SlingshotUnityLauncherEntry*) _tmp4_;
		_tmp5_ = entry;
		if ((current_time - _tmp5_->last_update) > ((gint64) ((10 * SLINGSHOT_UNITY_UNITY_UPDATE_THRESHOLD_DURATION) * 1000))) {
			GeeMapIterator* _tmp6_;
			_tmp6_ = launcher_entries_it;
			gee_map_iterator_unset (_tmp6_);
		}
		_slingshot_unity_launcher_entry_unref0 (entry);
	}
	_tmp7_ = self->priv->launcher_entries;
	_tmp8_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp7_);
	_tmp9_ = _tmp8_;
	keep_running = _tmp9_ > 0;
	if (!keep_running) {
		self->priv->launcher_entries_timer_id = 0U;
	}
	result = keep_running;
	_g_object_unref0 (launcher_entries_it);
	return result;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SlingshotUnity* self;
		self = _data12_->self;
		_g_free0 (_data12_->sender_name);
		_g_variant_unref0 (_data12_->parameters);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
__lambda82_ (Block12Data* _data12_,
             SlingshotUnityClient* client)
{
	SlingshotUnity* self;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (client != NULL, FALSE);
	slingshot_unity_client_update_launcher_entry (client, _data12_->sender_name, _data12_->parameters, FALSE);
	result = TRUE;
	_g_object_unref0 (client);
	return result;
}

static gboolean
___lambda82__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda82_ (self, (SlingshotUnityClient*) g);
	return result;
}

static void
slingshot_unity_perform_update (SlingshotUnity* self,
                                const gchar* sender_name,
                                GVariant* parameters)
{
	Block12Data* _data12_;
	gchar* _tmp0_;
	GVariant* _tmp1_;
	const GVariantType* _tmp2_;
	GeeHashSet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (parameters != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender_name);
	_g_free0 (_data12_->sender_name);
	_data12_->sender_name = _tmp0_;
	_tmp1_ = _g_variant_ref0 (parameters);
	_g_variant_unref0 (_data12_->parameters);
	_data12_->parameters = _tmp1_;
	_tmp2_ = slingshot_unity_payload_variant_type;
	if (!g_variant_is_of_type (_data12_->parameters, _tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = g_variant_get_type_string (_data12_->parameters);
		g_warning ("Unity.vala:261: Illegal payload signature '%s' from %s. expected '(sa{" \
"sv})'", _tmp3_, _data12_->sender_name);
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	_tmp4_ = self->priv->clients;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp4_, ___lambda82__gee_forall_func, _data12_);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

SlingshotUnity*
slingshot_unity_construct (GType object_type)
{
	SlingshotUnity * self = NULL;
	self = (SlingshotUnity*) g_object_new (object_type, NULL);
	return self;
}

SlingshotUnity*
slingshot_unity_new (void)
{
	return slingshot_unity_construct (SLINGSHOT_TYPE_UNITY);
}

static SlingshotUnityLauncherEntry*
slingshot_unity_launcher_entry_construct (GType object_type)
{
	SlingshotUnityLauncherEntry* self = NULL;
	self = (SlingshotUnityLauncherEntry*) g_type_create_instance (object_type);
	return self;
}

static SlingshotUnityLauncherEntry*
slingshot_unity_launcher_entry_new (void)
{
	return slingshot_unity_launcher_entry_construct (SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY);
}

static void
slingshot_unity_value_launcher_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
slingshot_unity_value_launcher_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		slingshot_unity_launcher_entry_unref (value->data[0].v_pointer);
	}
}

static void
slingshot_unity_value_launcher_entry_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = slingshot_unity_launcher_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
slingshot_unity_value_launcher_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
slingshot_unity_value_launcher_entry_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SlingshotUnityLauncherEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = slingshot_unity_launcher_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
slingshot_unity_value_launcher_entry_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	SlingshotUnityLauncherEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = slingshot_unity_launcher_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
slingshot_unity_param_spec_launcher_entry (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	SlingshotUnityParamSpecLauncherEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
slingshot_unity_value_get_launcher_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY), NULL);
	return value->data[0].v_pointer;
}

static void
slingshot_unity_value_set_launcher_entry (GValue* value,
                                          gpointer v_object)
{
	SlingshotUnityLauncherEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		slingshot_unity_launcher_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		slingshot_unity_launcher_entry_unref (old);
	}
}

static void
slingshot_unity_value_take_launcher_entry (GValue* value,
                                           gpointer v_object)
{
	SlingshotUnityLauncherEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		slingshot_unity_launcher_entry_unref (old);
	}
}

static void
slingshot_unity_launcher_entry_class_init (SlingshotUnityLauncherEntryClass * klass,
                                           gpointer klass_data)
{
	slingshot_unity_launcher_entry_parent_class = g_type_class_peek_parent (klass);
	((SlingshotUnityLauncherEntryClass *) klass)->finalize = slingshot_unity_launcher_entry_finalize;
}

static void
slingshot_unity_launcher_entry_instance_init (SlingshotUnityLauncherEntry * self,
                                              gpointer klass)
{
	self->fast_count = 0U;
	self->last_update = 0LL;
	self->timer_id = 0U;
	self->warned = FALSE;
	self->ref_count = 1;
}

static void
slingshot_unity_launcher_entry_finalize (SlingshotUnityLauncherEntry * obj)
{
	SlingshotUnityLauncherEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY, SlingshotUnityLauncherEntry);
	g_signal_handlers_destroy (self);
	_g_free0 (self->sender_name);
	_g_variant_unref0 (self->parameters);
}

static GType
slingshot_unity_launcher_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { slingshot_unity_value_launcher_entry_init, slingshot_unity_value_launcher_entry_free_value, slingshot_unity_value_launcher_entry_copy_value, slingshot_unity_value_launcher_entry_peek_pointer, "p", slingshot_unity_value_launcher_entry_collect_value, "p", slingshot_unity_value_launcher_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotUnityLauncherEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_unity_launcher_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotUnityLauncherEntry), 0, (GInstanceInitFunc) slingshot_unity_launcher_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType slingshot_unity_launcher_entry_type_id;
	slingshot_unity_launcher_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SlingshotUnityLauncherEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return slingshot_unity_launcher_entry_type_id;
}

static GType
slingshot_unity_launcher_entry_get_type (void)
{
	static volatile gsize slingshot_unity_launcher_entry_type_id__once = 0;
	if (g_once_init_enter (&slingshot_unity_launcher_entry_type_id__once)) {
		GType slingshot_unity_launcher_entry_type_id;
		slingshot_unity_launcher_entry_type_id = slingshot_unity_launcher_entry_get_type_once ();
		g_once_init_leave (&slingshot_unity_launcher_entry_type_id__once, slingshot_unity_launcher_entry_type_id);
	}
	return slingshot_unity_launcher_entry_type_id__once;
}

static gpointer
slingshot_unity_launcher_entry_ref (gpointer instance)
{
	SlingshotUnityLauncherEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
slingshot_unity_launcher_entry_unref (gpointer instance)
{
	SlingshotUnityLauncherEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SLINGSHOT_UNITY_LAUNCHER_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GObject *
slingshot_unity_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotUnity * self;
	GeeHashSet* _tmp0_;
	GeeHashMap* _tmp1_;
	GDBusConnection* _tmp2_;
	parent_class = G_OBJECT_CLASS (slingshot_unity_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_UNITY, SlingshotUnity);
	_tmp0_ = gee_hash_set_new (SLINGSHOT_TYPE_UNITY_CLIENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->clients);
	self->priv->clients = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SLINGSHOT_UNITY_TYPE_LAUNCHER_ENTRY, (GBoxedCopyFunc) slingshot_unity_launcher_entry_ref, (GDestroyNotify) slingshot_unity_launcher_entry_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->launcher_entries);
	self->priv->launcher_entries = _tmp1_;
	slingshot_unity_acquire_unity_dbus ();
	_tmp2_ = slingshot_unity_connection;
	if (_tmp2_ != NULL) {
		GDBusConnection* _tmp3_;
		GDBusConnection* _tmp4_;
		_tmp3_ = slingshot_unity_connection;
		self->priv->launcher_entry_dbus_signal_id = g_dbus_connection_signal_subscribe (_tmp3_, NULL, SLINGSHOT_UNITY_INTERFACE_NAME, NULL, NULL, NULL, G_DBUS_SIGNAL_FLAGS_NONE, (GDBusSignalCallback) slingshot_unity_handle_entry_signal, g_object_ref (self), g_object_unref);
		_tmp4_ = slingshot_unity_connection;
		self->priv->dbus_name_owner_changed_signal_id = g_dbus_connection_signal_subscribe (_tmp4_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, G_DBUS_SIGNAL_FLAGS_NONE, (GDBusSignalCallback) slingshot_unity_handle_name_owner_changed, g_object_ref (self), g_object_unref);
	}
	return obj;
}

static void
slingshot_unity_class_init (SlingshotUnityClass * klass,
                            gpointer klass_data)
{
	GVariantType* _tmp0_;
	slingshot_unity_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotUnity_private_offset);
	G_OBJECT_CLASS (klass)->constructor = slingshot_unity_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_unity_finalize;
	slingshot_unity_acquire_unity_dbus ();
	_tmp0_ = g_variant_type_new ("(sa{sv})");
	_g_variant_type_free0 (slingshot_unity_payload_variant_type);
	slingshot_unity_payload_variant_type = _tmp0_;
}

static void
slingshot_unity_instance_init (SlingshotUnity * self,
                               gpointer klass)
{
	self->priv = slingshot_unity_get_instance_private (self);
	self->priv->launcher_entry_dbus_signal_id = 0U;
	self->priv->dbus_name_owner_changed_signal_id = 0U;
	self->priv->launcher_entries_timer_id = 0U;
}

static void
slingshot_unity_finalize (GObject * obj)
{
	SlingshotUnity * self;
	GDBusConnection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_UNITY, SlingshotUnity);
	if (self->priv->launcher_entries_timer_id > 0U) {
		g_source_remove (self->priv->launcher_entries_timer_id);
	}
	_g_object_unref0 (self->priv->clients);
	self->priv->clients = NULL;
	_g_object_unref0 (self->priv->launcher_entries);
	self->priv->launcher_entries = NULL;
	if (slingshot_unity_unity_bus_id > 0U) {
		g_bus_unown_name (slingshot_unity_unity_bus_id);
	}
	_tmp0_ = slingshot_unity_connection;
	if (_tmp0_ != NULL) {
		if (self->priv->launcher_entry_dbus_signal_id > 0U) {
			GDBusConnection* _tmp1_;
			_tmp1_ = slingshot_unity_connection;
			g_dbus_connection_signal_unsubscribe (_tmp1_, self->priv->launcher_entry_dbus_signal_id);
		}
		if (self->priv->dbus_name_owner_changed_signal_id > 0U) {
			GDBusConnection* _tmp2_;
			_tmp2_ = slingshot_unity_connection;
			g_dbus_connection_signal_unsubscribe (_tmp2_, self->priv->dbus_name_owner_changed_signal_id);
		}
	}
	_g_object_unref0 (self->priv->clients);
	_g_object_unref0 (self->priv->launcher_entries);
	G_OBJECT_CLASS (slingshot_unity_parent_class)->finalize (obj);
}

/**
 * Handle the LauncherEntry DBus interface implemented by applications.
 */
static GType
slingshot_unity_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotUnityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_unity_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotUnity), 0, (GInstanceInitFunc) slingshot_unity_instance_init, NULL };
	GType slingshot_unity_type_id;
	slingshot_unity_type_id = g_type_register_static (G_TYPE_OBJECT, "SlingshotUnity", &g_define_type_info, 0);
	SlingshotUnity_private_offset = g_type_add_instance_private (slingshot_unity_type_id, sizeof (SlingshotUnityPrivate));
	return slingshot_unity_type_id;
}

GType
slingshot_unity_get_type (void)
{
	static volatile gsize slingshot_unity_type_id__once = 0;
	if (g_once_init_enter (&slingshot_unity_type_id__once)) {
		GType slingshot_unity_type_id;
		slingshot_unity_type_id = slingshot_unity_get_type_once ();
		g_once_init_leave (&slingshot_unity_type_id__once, slingshot_unity_type_id);
	}
	return slingshot_unity_type_id__once;
}

