/*
 * $Id: time.c,v 1.1 2001/03/15 22:16:13 jpormann Exp jpormann $
 *
 * procstatd - Copyright (c) 1999 by Robert G. Brown, rgb@phy.duke.edu
 *         GPL version 2b (b for beverage) granted.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * procstatd - A daemon to extract statistics from /proc/stat and publish them
 *         on demand via a socket connection or broadcast.
 */

#include "procstatd.h"

void init_time()
{

 int i,numfields;

 /* TIME */
 {
   struct tm *realtime;
   time_t realseconds;
   char timebuf[64];

   /* get the current time */
   time(&realseconds);
   realtime = localtime(&realseconds);
   /* Return the (string) data in the name label */
   /* JBP: removed equals-signs, used to be "time=%d:%02d%s" */
   sprintf(stats[TIME].name, "time %d:%02d%s",
		realtime->tm_hour%12 ? realtime->tm_hour%12 : 12,
		realtime->tm_min, realtime->tm_hour > 11 ? "pm" : "am");
   stats[TIME].source = SYS_DATA;		/* Tag its source for xref */
   stats[TIME].avail = 1;			/* Yes, we found it */
   stats[TIME].current = realseconds;		/* Save time in seconds */
 }

}  /* End get_time() */

void get_time()
{

 int i,numfields;
 /* TIME */
 {
   struct tm *realtime;
   time_t realseconds;
   char timebuf[64];

   /* get the current time */
   time(&realseconds);
   realtime = localtime(&realseconds);
   /* Just this once, return the (string) data in the name label */
   sprintf(stats[TIME].name, "time %d:%02d%s",
		realtime->tm_hour%12 ? realtime->tm_hour%12 : 12,
		realtime->tm_min, realtime->tm_hour > 11 ? "pm" : "am");

   stats[TIME].current = realseconds;		/* Save time in seconds */
 }

} /* End get_time() */

void eval_time()
{

 stats[TIME].rate = stats[TIME].current;

} /* End eval_time() */
