/* rygel-simple-container.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-simple-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_SIMPLE_CONTAINER_0_PROPERTY,
	RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES_PROPERTY,
	RYGEL_SIMPLE_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_simple_container_properties[RYGEL_SIMPLE_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSimpleContainerGetChildrenData RygelSimpleContainerGetChildrenData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _RygelSimpleContainerFindObjectData RygelSimpleContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelSimpleContainerSearchData RygelSimpleContainerSearchData;

struct _RygelSimpleContainerPrivate {
	RygelMediaObjects* empty_children;
	GeeArrayList* _search_classes;
};

struct _RygelSimpleContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSimpleContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	guint stop;
	RygelMediaObjects* unsorted_children;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	RygelMediaObjects* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	RygelMediaObjects* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeList* _tmp10_;
	RygelMediaObjects* _tmp11_;
	RygelMediaObjects* _tmp12_;
	RygelMediaObjects* _tmp13_;
	GeeList* _tmp14_;
	RygelMediaObjects* _tmp15_;
};

struct _Block2Data {
	int _ref_count_;
	RygelSimpleContainer* self;
	gint restart_count;
	gboolean restart;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gulong updated_id;
};

struct _RygelSimpleContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSimpleContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	RygelMediaObject* media_object;
	gint max_count;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaObjects* children_to_search;
	RygelMediaObjects* _tmp6_;
	gboolean _tmp7_;
	Block3Data* _data3_;
	gboolean _tmp8_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp9_;
	gint _child_size;
	RygelMediaObjects* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _child_index;
	gint _tmp13_;
	gint _tmp14_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp15_;
	gpointer _tmp16_;
	RygelMediaObject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaObject* _tmp20_;
	RygelMediaObject* _tmp21_;
	RygelMediaObject* _tmp22_;
	gulong _tmp23_;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp24_;
	RygelMediaContainer* _tmp25_;
	RygelMediaObject* _tmp26_;
	RygelMediaContainer* _tmp27_;
	RygelMediaObject* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	GError* _inner_error0_;
};

struct _RygelSimpleContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelSimpleContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	guint _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	GError* _inner_error0_;
};

static gint RygelSimpleContainer_private_offset;
static gpointer rygel_simple_container_parent_class = NULL;
static RygelSearchableContainerIface * rygel_simple_container_rygel_searchable_container_parent_iface = NULL;

static void rygel_simple_container_real_constructed (GObject* base);
static void rygel_simple_container_add_child (RygelSimpleContainer* self,
                                       RygelMediaObject* child);
static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self,
                                                  RygelMediaContainer* source,
                                                  RygelMediaContainer* updated,
                                                  RygelMediaObject* object,
                                                  RygelObjectEventType event_type,
                                                  gboolean sub_tree_update);
static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                                                           RygelMediaContainer* container,
                                                                                           RygelMediaObject* object,
                                                                                           RygelObjectEventType event_type,
                                                                                           gboolean sub_tree_update,
                                                                                           gpointer self);
static void rygel_simple_container_real_get_children_data_free (gpointer _data);
static void rygel_simple_container_real_get_children (RygelMediaContainer* base,
                                               guint offset,
                                               guint max_count,
                                               const gchar* sort_criteria,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_);
static void rygel_simple_container_real_find_object_data_free (gpointer _data);
static void rygel_simple_container_real_find_object (RygelMediaContainer* base,
                                              const gchar* id,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void rygel_simple_container_find_object_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ________lambda21_ (Block3Data* _data3_,
                        RygelMediaContainer* _,
                        RygelMediaObject* updated);
static void _________lambda21__rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                                 RygelMediaContainer* container,
                                                                 RygelMediaObject* object,
                                                                 RygelObjectEventType event_type,
                                                                 gboolean sub_tree_update,
                                                                 gpointer self);
static void rygel_simple_container_real_search_data_free (gpointer _data);
static void rygel_simple_container_real_search (RygelSearchableContainer* base,
                                         RygelSearchExpression* expression,
                                         guint offset,
                                         guint max_count,
                                         const gchar* sort_criteria,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_);
static void rygel_simple_container_search_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void rygel_simple_container_finalize (GObject * obj);
static GType rygel_simple_container_get_type_once (void);
static void _vala_rygel_simple_container_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_rygel_simple_container_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
rygel_simple_container_get_instance_private (RygelSimpleContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelSimpleContainer_private_offset);
}

/**
     * Creates a child RygelSimpleContainer.
     *
     * @param id The ID of the item. This should be unique in the server.
     * @param parent The parent of the container.
     * @param title The title of the container.
     */
RygelSimpleContainer*
rygel_simple_container_construct (GType object_type,
                                  const gchar* id,
                                  RygelMediaContainer* parent,
                                  const gchar* title)
{
	RygelSimpleContainer * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelSimpleContainer*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "child-count", 0, NULL);
	return self;
}

RygelSimpleContainer*
rygel_simple_container_new (const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title)
{
	return rygel_simple_container_construct (RYGEL_TYPE_SIMPLE_CONTAINER, id, parent, title);
}

static void
rygel_simple_container_real_constructed (GObject* base)
{
	RygelSimpleContainer * self;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	self = (RygelSimpleContainer*) base;
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer));
	_tmp0_ = rygel_media_objects_new ();
	_g_object_unref0 (self->children);
	self->children = _tmp0_;
	_tmp1_ = rygel_media_objects_new ();
	_g_object_unref0 (self->priv->empty_children);
	self->priv->empty_children = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

/**
     * Creates a RygelSimpleContainer as a root container.
     *
     * @param title The title of the container.
     */
RygelSimpleContainer*
rygel_simple_container_construct_root (GType object_type,
                                       const gchar* title)
{
	RygelSimpleContainer * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelSimpleContainer*) g_object_new (object_type, "id", "0", "parent", NULL, "title", title, "child-count", 0, NULL);
	return self;
}

RygelSimpleContainer*
rygel_simple_container_new_root (const gchar* title)
{
	return rygel_simple_container_construct_root (RYGEL_TYPE_SIMPLE_CONTAINER, title);
}

/**
     * Adds an item to the container.
     *
     * @param child The child item to add to the container.
     */
void
rygel_simple_container_add_child_item (RygelSimpleContainer* self,
                                       RygelMediaItem* child)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	rygel_simple_container_add_child (self, (RygelMediaObject*) child);
}

/**
     * Get all children, including the empty children.
     *
     * This is useful when all children are empty,
     * so get_children() would return no objects,
     * but when you need to add items to the empty
     * items.
     *
     * This is useful only when implementing derived classes.
     */
RygelMediaObjects*
rygel_simple_container_get_all_children (RygelSimpleContainer* self)
{
	RygelMediaObjects* all = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	all = _tmp0_;
	_tmp1_ = self->children;
	gee_array_list_add_all ((GeeArrayList*) all, (GeeCollection*) _tmp1_);
	_tmp2_ = self->priv->empty_children;
	gee_array_list_add_all ((GeeArrayList*) all, (GeeCollection*) _tmp2_);
	result = all;
	return result;
}

/**
     * Adds a child container to this container.
     *
     * The child container will only be added to the hierarchy if, or when,
     * it contains some children.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                                                      RygelMediaContainer* container,
                                                                                      RygelMediaObject* object,
                                                                                      RygelObjectEventType event_type,
                                                                                      gboolean sub_tree_update,
                                                                                      gpointer self)
{
	rygel_simple_container_on_container_updated ((RygelSimpleContainer*) self, _sender, container, object, event_type, sub_tree_update);
}

void
rygel_simple_container_add_child_container (RygelSimpleContainer* self,
                                            RygelMediaContainer* child)
{
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	if (RYGEL_IS_SEARCHABLE_CONTAINER (child)) {
		GeeArrayList* search_classes = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		_tmp0_ = rygel_searchable_container_get_search_classes (G_TYPE_CHECK_INSTANCE_CAST (child, RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer));
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		search_classes = _tmp2_;
		_tmp3_ = rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = search_classes;
		gee_array_list_add_all (_tmp4_, (GeeCollection*) _tmp5_);
		_g_object_unref0 (search_classes);
	}
	_tmp6_ = rygel_media_container_get_child_count (child);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > 0) {
		rygel_simple_container_add_child (self, (RygelMediaObject*) child);
	} else {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		RygelMediaObjects* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) child);
		_tmp9_ = _tmp8_;
		g_debug ("Container '%s' empty, refusing to add to hierarchy " "until it has any children to offer.", _tmp9_);
		_tmp10_ = self->priv->empty_children;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (RygelMediaObject*) child);
		_tmp11_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
		_tmp12_ = _tmp11_;
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp12_ + 1);
		g_signal_connect_object (child, "container-updated", (GCallback) _rygel_simple_container_on_container_updated_rygel_media_container_container_updated, self, 0);
	}
}

/**
     * Removes the item from the container.
     */
void
rygel_simple_container_remove_child (RygelSimpleContainer* self,
                                     RygelMediaObject* child)
{
	RygelMediaObjects* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->children;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, child);
	_tmp1_ = rygel_media_container_get_child_count ((RygelMediaContainer*) self);
	_tmp2_ = _tmp1_;
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp2_ - 1);
}

/**
     * Removes all child items and child containers
     * from the container.
     */
void
rygel_simple_container_clear (RygelSimpleContainer* self)
{
	RygelMediaObjects* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->children;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, 0);
}

/**
     * Check that the ID is unique within this container.
     *
     * This is useful only when implementing derived classes.
     *
     * @param child_id The ID to check for uniqueness.
     * @return true if the child ID is unique within this container.
     */
gboolean
rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self,
                                           const gchar* child_id)
{
	gboolean unique = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (child_id != NULL, FALSE);
	unique = TRUE;
	{
		RygelMediaObjects* _child_list = NULL;
		RygelMediaObjects* _tmp0_;
		gint _child_size = 0;
		RygelMediaObjects* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _child_index = 0;
		_tmp0_ = self->children;
		_child_list = _tmp0_;
		_tmp1_ = _child_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_child_size = _tmp3_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelMediaObject* child = NULL;
			RygelMediaObjects* _tmp6_;
			gpointer _tmp7_;
			RygelMediaObject* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_child_index = _child_index + 1;
			_tmp4_ = _child_index;
			_tmp5_ = _child_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _child_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _child_index);
			child = (RygelMediaObject*) _tmp7_;
			_tmp8_ = child;
			_tmp9_ = rygel_media_object_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, child_id) == 0) {
				unique = FALSE;
				_g_object_unref0 (child);
				break;
			}
			_g_object_unref0 (child);
		}
	}
	if (unique) {
		{
			RygelMediaObjects* _child_list = NULL;
			RygelMediaObjects* _tmp11_;
			gint _child_size = 0;
			RygelMediaObjects* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _child_index = 0;
			_tmp11_ = self->priv->empty_children;
			_child_list = _tmp11_;
			_tmp12_ = _child_list;
			_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_child_size = _tmp14_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				RygelMediaObject* child = NULL;
				RygelMediaObjects* _tmp17_;
				gpointer _tmp18_;
				RygelMediaObject* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_child_index = _child_index + 1;
				_tmp15_ = _child_index;
				_tmp16_ = _child_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _child_list;
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _child_index);
				child = (RygelMediaObject*) _tmp18_;
				_tmp19_ = child;
				_tmp20_ = rygel_media_object_get_id (_tmp19_);
				_tmp21_ = _tmp20_;
				if (g_strcmp0 (_tmp21_, child_id) == 0) {
					unique = FALSE;
					_g_object_unref0 (child);
					break;
				}
				_g_object_unref0 (child);
			}
		}
	}
	result = unique;
	return result;
}

static void
rygel_simple_container_real_get_children_data_free (gpointer _data)
{
	RygelSimpleContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSimpleContainerGetChildrenData, _data_);
}

static void
rygel_simple_container_real_get_children (RygelMediaContainer* base,
                                          guint offset,
                                          guint max_count,
                                          const gchar* sort_criteria,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	RygelSimpleContainer * self;
	RygelSimpleContainerGetChildrenData* _data_;
	RygelSimpleContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (sort_criteria != NULL);
	self = (RygelSimpleContainer*) base;
	_data_ = g_slice_new0 (RygelSimpleContainerGetChildrenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_simple_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp1_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_simple_container_real_get_children_co (_data_);
}

static RygelMediaObjects*
rygel_simple_container_get_children_finish (RygelMediaContainer* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	RygelMediaObjects* result;
	RygelSimpleContainerGetChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->stop = _data_->offset + _data_->max_count;
	_data_->_tmp0_ = rygel_media_container_get_create_mode_enabled ((RygelMediaContainer*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = rygel_media_container_get_all_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->stop = CLAMP (_data_->stop, (guint) 0, (guint) _data_->_tmp3_);
		_data_->_tmp4_ = rygel_simple_container_get_all_children (_data_->self);
		_g_object_unref0 (_data_->unsorted_children);
		_data_->unsorted_children = _data_->_tmp4_;
	} else {
		_data_->_tmp5_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->stop = CLAMP (_data_->stop, (guint) 0, (guint) _data_->_tmp6_);
		_data_->_tmp7_ = _data_->self->children;
		_data_->_tmp8_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp7_, 0, _data_->_tmp9_);
		_data_->_tmp11_ = RYGEL_IS_MEDIA_OBJECTS (_data_->_tmp10_) ? ((RygelMediaObjects*) _data_->_tmp10_) : NULL;
		if (_data_->_tmp11_ == NULL) {
			_g_object_unref0 (_data_->_tmp10_);
		}
		_g_object_unref0 (_data_->unsorted_children);
		_data_->unsorted_children = _data_->_tmp11_;
	}
	_data_->_tmp12_ = _data_->unsorted_children;
	rygel_media_objects_sort_by_criteria (_data_->_tmp12_, _data_->sort_criteria);
	_data_->_tmp13_ = _data_->unsorted_children;
	_data_->_tmp14_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp13_, (gint) _data_->offset, (gint) _data_->stop);
	_data_->_tmp15_ = RYGEL_IS_MEDIA_OBJECTS (_data_->_tmp14_) ? ((RygelMediaObjects*) _data_->_tmp14_) : NULL;
	if (_data_->_tmp15_ == NULL) {
		_g_object_unref0 (_data_->_tmp14_);
	}
	_data_->result = _data_->_tmp15_;
	_g_object_unref0 (_data_->unsorted_children);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_simple_container_real_find_object_data_free (gpointer _data)
{
	RygelSimpleContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSimpleContainerFindObjectData, _data_);
}

static void
rygel_simple_container_real_find_object (RygelMediaContainer* base,
                                         const gchar* id,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	RygelSimpleContainer * self;
	RygelSimpleContainerFindObjectData* _data_;
	RygelSimpleContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (id != NULL);
	self = (RygelSimpleContainer*) base;
	_data_ = g_slice_new0 (RygelSimpleContainerFindObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_simple_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_simple_container_real_find_object_co (_data_);
}

static RygelMediaObject*
rygel_simple_container_find_object_finish (RygelMediaContainer* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	RygelMediaObject* result;
	RygelSimpleContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelSimpleContainer* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
rygel_simple_container_find_object_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	RygelSimpleContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_simple_container_real_find_object_co (_data_);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		RygelSimpleContainer* self;
		self = _data3_->_data2_->self;
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
________lambda21_ (Block3Data* _data3_,
                   RygelMediaContainer* _,
                   RygelMediaObject* updated)
{
	Block2Data* _data2_;
	RygelSimpleContainer* self;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_return_if_fail (_ != NULL);
	g_return_if_fail (updated != NULL);
	if (updated == G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject)) {
		gint _tmp0_;
		_data2_->restart = TRUE;
		_tmp0_ = _data2_->restart_count;
		_data2_->restart_count = _tmp0_ + 1;
		g_signal_handler_disconnect ((GObject*) self, _data3_->updated_id);
		_data3_->updated_id = (gulong) 0;
	}
}

static void
_________lambda21__rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                            RygelMediaContainer* container,
                                                            RygelMediaObject* object,
                                                            RygelObjectEventType event_type,
                                                            gboolean sub_tree_update,
                                                            gpointer self)
{
	________lambda21_ (self, container, object);
}

static gboolean
rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->media_object = NULL;
	_data_->max_count = 0;
	_data_->_data2_->restart_count = 0;
	_data_->_data2_->restart = FALSE;
	_data_->_tmp0_ = rygel_media_container_get_create_mode_enabled ((RygelMediaContainer*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = rygel_media_container_get_all_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->max_count = _data_->_tmp3_;
	} else {
		_data_->_tmp4_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->max_count = _data_->_tmp5_;
	}
	_data_->_state_ = 1;
	rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) _data_->max_count, "", _data_->cancellable, rygel_simple_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->children_to_search = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->media_object);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = TRUE;
		while (TRUE) {
			_data_->_data3_ = g_slice_new0 (Block3Data);
			_data_->_data3_->_ref_count_ = 1;
			_data_->_data3_->_data2_ = block2_data_ref (_data_->_data2_);
			if (!_data_->_tmp7_) {
				if (_data_->_data2_->restart) {
					_data_->_tmp8_ = _data_->_data2_->restart_count < 10;
				} else {
					_data_->_tmp8_ = FALSE;
				}
				if (!_data_->_tmp8_) {
					block3_data_unref (_data_->_data3_);
					_data_->_data3_ = NULL;
					break;
				}
			}
			_data_->_tmp7_ = FALSE;
			_data_->_data2_->restart = FALSE;
			_data_->_data3_->updated_id = (gulong) 0;
			{
				_data_->_tmp9_ = _data_->children_to_search;
				_data_->_child_list = _data_->_tmp9_;
				_data_->_tmp10_ = _data_->_child_list;
				_data_->_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				_data_->_child_size = _data_->_tmp12_;
				_data_->_child_index = -1;
				while (TRUE) {
					_data_->_child_index = _data_->_child_index + 1;
					_data_->_tmp13_ = _data_->_child_index;
					_data_->_tmp14_ = _data_->_child_size;
					if (!(_data_->_tmp13_ < _data_->_tmp14_)) {
						break;
					}
					_data_->_tmp15_ = _data_->_child_list;
					_data_->_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp15_, _data_->_child_index);
					_data_->child = (RygelMediaObject*) _data_->_tmp16_;
					_data_->_tmp17_ = _data_->child;
					_data_->_tmp18_ = rygel_media_object_get_id (_data_->_tmp17_);
					_data_->_tmp19_ = _data_->_tmp18_;
					if (g_strcmp0 (_data_->_tmp19_, _data_->id) == 0) {
						_data_->_tmp20_ = _data_->child;
						_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
						_g_object_unref0 (_data_->media_object);
						_data_->media_object = _data_->_tmp21_;
						_g_object_unref0 (_data_->child);
						break;
					} else {
						_data_->_tmp22_ = _data_->child;
						if (RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp22_)) {
							_data_->_tmp23_ = g_signal_connect_data ((RygelMediaContainer*) _data_->self, "container-updated", (GCallback) _________lambda21__rygel_media_container_container_updated, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
							_data_->_data3_->updated_id = _data_->_tmp23_;
							_data_->_tmp24_ = _data_->child;
							_data_->_tmp25_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp24_) ? ((RygelMediaContainer*) _data_->_tmp24_) : NULL);
							_data_->container = _data_->_tmp25_;
							_data_->_tmp27_ = _data_->container;
							_data_->_state_ = 2;
							rygel_media_container_find_object (_data_->_tmp27_, _data_->id, _data_->cancellable, rygel_simple_container_find_object_ready, _data_);
							return FALSE;
							_state_2:
							_data_->_tmp28_ = rygel_media_container_find_object_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error0_);
							_data_->_tmp26_ = _data_->_tmp28_;
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
								_g_object_unref0 (_data_->container);
								_g_object_unref0 (_data_->child);
								block3_data_unref (_data_->_data3_);
								_data_->_data3_ = NULL;
								_g_object_unref0 (_data_->children_to_search);
								_g_object_unref0 (_data_->media_object);
								block2_data_unref (_data_->_data2_);
								_data_->_data2_ = NULL;
								g_object_unref (_data_->_async_result);
								return FALSE;
							}
							_data_->_tmp29_ = _data_->_tmp26_;
							_data_->_tmp26_ = NULL;
							_g_object_unref0 (_data_->media_object);
							_data_->media_object = _data_->_tmp29_;
							if (_data_->_data3_->updated_id != ((gulong) 0)) {
								g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_data3_->updated_id);
							}
							_data_->_tmp30_ = _data_->media_object;
							if (_data_->_tmp30_ != NULL) {
								_data_->_data2_->restart = FALSE;
								_g_object_unref0 (_data_->_tmp26_);
								_g_object_unref0 (_data_->container);
								_g_object_unref0 (_data_->child);
								break;
							}
							if (_data_->_data2_->restart) {
								_g_object_unref0 (_data_->_tmp26_);
								_g_object_unref0 (_data_->container);
								_g_object_unref0 (_data_->child);
								break;
							}
							_g_object_unref0 (_data_->_tmp26_);
							_g_object_unref0 (_data_->container);
						}
					}
					_g_object_unref0 (_data_->child);
				}
			}
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
		}
	}
	_data_->result = _data_->media_object;
	_g_object_unref0 (_data_->children_to_search);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_simple_container_real_search_data_free (gpointer _data)
{
	RygelSimpleContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSimpleContainerSearchData, _data_);
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_simple_container_real_search (RygelSearchableContainer* base,
                                    RygelSearchExpression* expression,
                                    guint offset,
                                    guint max_count,
                                    const gchar* sort_criteria,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	RygelSimpleContainer * self;
	RygelSimpleContainerSearchData* _data_;
	RygelSimpleContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (sort_criteria != NULL);
	self = (RygelSimpleContainer*) base;
	_data_ = g_slice_new0 (RygelSimpleContainerSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_simple_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_simple_container_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_simple_container_search_finish (RygelSearchableContainer* base,
                                      GAsyncResult* _res_,
                                      guint* total_matches,
                                      GError** error)
{
	RygelMediaObjects* result;
	RygelSimpleContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_simple_container_search_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	RygelSimpleContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_simple_container_real_search_co (_data_);
}

static gboolean
rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->expression, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_simple_container_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->total_matches = _data_->_tmp1_;
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_simple_container_add_child (RygelSimpleContainer* self,
                                  RygelMediaObject* child)
{
	RygelMediaObjects* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->children;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, child);
	_tmp1_ = rygel_media_container_get_child_count ((RygelMediaContainer*) self);
	_tmp2_ = _tmp1_;
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp2_ + 1);
}

static void
rygel_simple_container_on_container_updated (RygelSimpleContainer* self,
                                             RygelMediaContainer* source,
                                             RygelMediaContainer* updated,
                                             RygelMediaObject* object,
                                             RygelObjectEventType event_type,
                                             gboolean sub_tree_update)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (updated != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = rygel_media_container_get_child_count (updated);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0) {
		RygelMediaObjects* _tmp2_;
		RygelMediaObjects* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp2_ = self->priv->empty_children;
		if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, (RygelMediaObject*) updated)) {
			return;
		}
		_tmp3_ = self->priv->empty_children;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, (RygelMediaObject*) updated);
		_tmp4_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
		_tmp5_ = _tmp4_;
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp5_ - 1);
		rygel_simple_container_add_child (self, (RygelMediaObject*) updated);
		rygel_media_container_updated ((RygelMediaContainer*) self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
		_tmp6_ = rygel_media_object_get_id ((RygelMediaObject*) updated);
		_tmp7_ = _tmp6_;
		g_debug ("rygel-simple-container.vala:307: Container '%s' now non-empty, added i" \
"t to hierarchy now.", _tmp7_);
	} else {
		RygelMediaObjects* _tmp8_;
		RygelMediaObjects* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp8_ = self->children;
		if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp8_, (RygelMediaObject*) updated)) {
			return;
		}
		rygel_simple_container_remove_child (self, (RygelMediaObject*) updated);
		_tmp9_ = self->priv->empty_children;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (RygelMediaObject*) updated);
		_tmp10_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
		_tmp11_ = _tmp10_;
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp11_ + 1);
		rygel_media_container_updated ((RygelMediaContainer*) self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
		_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) updated);
		_tmp13_ = _tmp12_;
		g_debug ("rygel-simple-container.vala:320: Container '%s' now empty, removing it" \
" from hierarchy now.", _tmp13_);
	}
}

static GeeArrayList*
rygel_simple_container_real_get_search_classes (RygelSearchableContainer* base)
{
	GeeArrayList* result;
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelSimpleContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}

static void
rygel_simple_container_real_set_search_classes (RygelSearchableContainer* base,
                                                GeeArrayList* value)
{
	RygelSimpleContainer* self;
	GeeArrayList* old_value;
	self = (RygelSimpleContainer*) base;
	old_value = rygel_simple_container_real_get_search_classes (base);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_classes);
		self->priv->_search_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_simple_container_properties[RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES_PROPERTY]);
	}
}

static void
rygel_simple_container_class_init (RygelSimpleContainerClass * klass,
                                   gpointer klass_data)
{
	rygel_simple_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelSimpleContainer_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_simple_container_real_constructed;
	((RygelMediaContainerClass *) klass)->get_children = (void (*) (RygelMediaContainer*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_simple_container_real_get_children;
	((RygelMediaContainerClass *) klass)->get_children_finish = (RygelMediaObjects* (*) (RygelMediaContainer*, GAsyncResult*, GError**)) rygel_simple_container_get_children_finish;
	((RygelMediaContainerClass *) klass)->find_object = (void (*) (RygelMediaContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_simple_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*) (RygelMediaContainer*, GAsyncResult*, GError**)) rygel_simple_container_find_object_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_simple_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_simple_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES_PROPERTY, rygel_simple_container_properties[RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES_PROPERTY] = g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_simple_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface,
                                                                  gpointer iface_data)
{
	rygel_simple_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (RygelSearchableContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_simple_container_real_search;
	iface->search_finish = (RygelMediaObjects* (*) (RygelSearchableContainer*, GAsyncResult*, guint*, GError**)) rygel_simple_container_search_finish;
	iface->get_search_classes = rygel_simple_container_real_get_search_classes;
	iface->set_search_classes = rygel_simple_container_real_set_search_classes;
}

static void
rygel_simple_container_instance_init (RygelSimpleContainer * self,
                                      gpointer klass)
{
	self->priv = rygel_simple_container_get_instance_private (self);
}

static void
rygel_simple_container_finalize (GObject * obj)
{
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
	_g_object_unref0 (self->children);
	_g_object_unref0 (self->priv->empty_children);
	_g_object_unref0 (self->priv->_search_classes);
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->finalize (obj);
}

/**
 * A simple implementation of RygelMediaContainer that keeps all RygelMediaObjects
 * in memory. You should add children via rygel_simple_container_add_child_item().
 */
 G_GNUC_NO_INLINE static GType
rygel_simple_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleContainer), 0, (GInstanceInitFunc) rygel_simple_container_instance_init, NULL };
	static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_simple_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_simple_container_type_id;
	rygel_simple_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelSimpleContainer", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_simple_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
	RygelSimpleContainer_private_offset = g_type_add_instance_private (rygel_simple_container_type_id, sizeof (RygelSimpleContainerPrivate));
	return rygel_simple_container_type_id;
}

GType
rygel_simple_container_get_type (void)
{
	static volatile gsize rygel_simple_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_simple_container_type_id__once)) {
		GType rygel_simple_container_type_id;
		rygel_simple_container_type_id = rygel_simple_container_get_type_once ();
		g_once_init_leave (&rygel_simple_container_type_id__once, rygel_simple_container_type_id);
	}
	return rygel_simple_container_type_id__once;
}

static void
_vala_rygel_simple_container_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
	switch (property_id) {
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_simple_container_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
	switch (property_id) {
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES_PROPERTY:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

