/* LocationPanel.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from LocationPanel.vala, do not modify */

/*-
 * Copyright 2017-2023 elementary, Inc. (https://elementary.io)
 * Copyright (C) 2017 David Hewitt <davidmhewitt@gmail.com>   
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include "security-privacy.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <switchboard.h>
#include <gio/gdesktopappinfo.h>
#include <granite-7.h>

#define SECURITY_PRIVACY_LOCATION_PANEL_PERMISSIONS_TABLE "location"
#define SECURITY_PRIVACY_LOCATION_PANEL_PERMISSIONS_ID "location"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SECURITY_PRIVACY_LOCATION_PANEL_0_PROPERTY,
	SECURITY_PRIVACY_LOCATION_PANEL_NUM_PROPERTIES
};
static GParamSpec* security_privacy_location_panel_properties[SECURITY_PRIVACY_LOCATION_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SecurityPrivacyLocationPanelInitInterfacesData SecurityPrivacyLocationPanelInitInterfacesData;

#define SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION (security_privacy_location_panel_app_permission_get_type ())
#define SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION, SecurityPrivacyLocationPanelAppPermission))
#define SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION, SecurityPrivacyLocationPanelAppPermissionClass))
#define SECURITY_PRIVACY_LOCATION_PANEL_IS_APP_PERMISSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION))
#define SECURITY_PRIVACY_LOCATION_PANEL_IS_APP_PERMISSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION))
#define SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION, SecurityPrivacyLocationPanelAppPermissionClass))

typedef struct _SecurityPrivacyLocationPanelAppPermission SecurityPrivacyLocationPanelAppPermission;
typedef struct _SecurityPrivacyLocationPanelAppPermissionClass SecurityPrivacyLocationPanelAppPermissionClass;

#define SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW (security_privacy_location_panel_location_row_get_type ())
#define SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, SecurityPrivacyLocationPanelLocationRow))
#define SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, SecurityPrivacyLocationPanelLocationRowClass))
#define SECURITY_PRIVACY_LOCATION_PANEL_IS_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW))
#define SECURITY_PRIVACY_LOCATION_PANEL_IS_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW))
#define SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, SecurityPrivacyLocationPanelLocationRowClass))

typedef struct _SecurityPrivacyLocationPanelLocationRow SecurityPrivacyLocationPanelLocationRow;
typedef struct _SecurityPrivacyLocationPanelLocationRowClass SecurityPrivacyLocationPanelLocationRowClass;
typedef struct _Block5Data Block5Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _SecurityPrivacyLocationPanelAppPermissionPrivate SecurityPrivacyLocationPanelAppPermissionPrivate;
enum  {
	SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_0_PROPERTY,
	SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_ID_PROPERTY,
	SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_LEVEL_PROPERTY,
	SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_TIMESTAMP_PROPERTY,
	SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_NUM_PROPERTIES
};
static GParamSpec* security_privacy_location_panel_app_permission_properties[SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_NUM_PROPERTIES];
typedef struct _SecurityPrivacyLocationPanelLocationRowPrivate SecurityPrivacyLocationPanelLocationRowPrivate;
enum  {
	SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_0_PROPERTY,
	SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_AUTHED_PROPERTY,
	SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_TIMESTAMP_PROPERTY,
	SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_NUM_PROPERTIES
};
static GParamSpec* security_privacy_location_panel_location_row_properties[SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_NUM_PROPERTIES];

struct _SecurityPrivacyLocationPanelPrivate {
	GtkStack* disabled_stack;
	GListStore* liststore;
	SecurityPrivacyPermissionStore* permission_store;
};

struct _SecurityPrivacyLocationPanelInitInterfacesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecurityPrivacyLocationPanel* self;
	SecurityPrivacyPermissionStore* _tmp0_;
	SecurityPrivacyPermissionStore* _tmp1_;
	SecurityPrivacyPermissionStore* _tmp2_;
	SecurityPrivacyPermissionStore* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	SecurityPrivacyLocationPanel* self;
	SecurityPrivacyLocationPanelAppPermission* app_permission;
	SecurityPrivacyLocationPanelLocationRow* app_row;
};

struct _SecurityPrivacyLocationPanelAppPermission {
	GObject parent_instance;
	SecurityPrivacyLocationPanelAppPermissionPrivate * priv;
};

struct _SecurityPrivacyLocationPanelAppPermissionClass {
	GObjectClass parent_class;
};

struct _SecurityPrivacyLocationPanelAppPermissionPrivate {
	gchar* _id;
	gchar* _level;
	gchar* _timestamp;
};

struct _SecurityPrivacyLocationPanelLocationRow {
	AppRow parent_instance;
	SecurityPrivacyLocationPanelLocationRowPrivate * priv;
};

struct _SecurityPrivacyLocationPanelLocationRowClass {
	AppRowClass parent_class;
};

struct _SecurityPrivacyLocationPanelLocationRowPrivate {
	gboolean _authed;
	gchar* _timestamp;
};

static gint SecurityPrivacyLocationPanel_private_offset;
static gpointer security_privacy_location_panel_parent_class = NULL;
static gint SecurityPrivacyLocationPanelAppPermission_private_offset;
static gpointer security_privacy_location_panel_app_permission_parent_class = NULL;
static gint SecurityPrivacyLocationPanelLocationRow_private_offset;
static gpointer security_privacy_location_panel_location_row_parent_class = NULL;

static void security_privacy_location_panel_init_interfaces_data_free (gpointer _data);
static void security_privacy_location_panel_init_interfaces (SecurityPrivacyLocationPanel* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void security_privacy_location_panel_init_interfaces_finish (SecurityPrivacyLocationPanel* self,
                                                             GAsyncResult* _res_);
static gboolean security_privacy_location_panel_init_interfaces_co (SecurityPrivacyLocationPanelInitInterfacesData* _data_);
static void security_privacy_location_panel_init_interfaces_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void ___lambda25_ (SecurityPrivacyLocationPanel* self,
                   const gchar* table,
                   const gchar* id,
                   gboolean deleted,
                   GVariant* data,
                   GVariant* permissions);
static void security_privacy_location_panel_load_permissions (SecurityPrivacyLocationPanel* self);
static void ____lambda25__security_privacy_permission_store_changed (SecurityPrivacyPermissionStore* _sender,
                                                              const gchar* table,
                                                              const gchar* id,
                                                              gboolean deleted,
                                                              GVariant* data,
                                                              GVariant* permissions,
                                                              gpointer self);
static void security_privacy_location_panel_update_status (SecurityPrivacyLocationPanel* self);
static GtkWidget* security_privacy_location_panel_create_widget_func (SecurityPrivacyLocationPanel* self,
                                                               GObject* object);
static GType security_privacy_location_panel_app_permission_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType security_privacy_location_panel_location_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static SecurityPrivacyLocationPanelLocationRow* security_privacy_location_panel_location_row_new (SecurityPrivacyLocationPanelAppPermission* permission);
static SecurityPrivacyLocationPanelLocationRow* security_privacy_location_panel_location_row_construct (GType object_type,
                                                                                                 SecurityPrivacyLocationPanelAppPermission* permission);
static void __lambda26_ (Block5Data* _data5_);
static gboolean security_privacy_location_panel_location_row_get_authed (SecurityPrivacyLocationPanelLocationRow* self);
static const gchar* security_privacy_location_panel_location_row_get_timestamp (SecurityPrivacyLocationPanelLocationRow* self);
static const gchar* security_privacy_location_panel_app_permission_get_id (SecurityPrivacyLocationPanelAppPermission* self);
static void ___lambda26__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static SecurityPrivacyLocationPanelAppPermission* security_privacy_location_panel_app_permission_new (const gchar* id,
                                                                                               const gchar* level,
                                                                                               const gchar* timestamp);
static SecurityPrivacyLocationPanelAppPermission* security_privacy_location_panel_app_permission_construct (GType object_type,
                                                                                                     const gchar* id,
                                                                                                     const gchar* level,
                                                                                                     const gchar* timestamp);
static void security_privacy_location_panel_app_permission_set_id (SecurityPrivacyLocationPanelAppPermission* self,
                                                            const gchar* value);
static const gchar* security_privacy_location_panel_app_permission_get_level (SecurityPrivacyLocationPanelAppPermission* self);
static void security_privacy_location_panel_app_permission_set_level (SecurityPrivacyLocationPanelAppPermission* self,
                                                               const gchar* value);
static const gchar* security_privacy_location_panel_app_permission_get_timestamp (SecurityPrivacyLocationPanelAppPermission* self);
static void security_privacy_location_panel_app_permission_set_timestamp (SecurityPrivacyLocationPanelAppPermission* self,
                                                                   const gchar* value);
static void security_privacy_location_panel_app_permission_finalize (GObject * obj);
static GType security_privacy_location_panel_app_permission_get_type_once (void);
static void _vala_security_privacy_location_panel_app_permission_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
static void _vala_security_privacy_location_panel_app_permission_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
static void security_privacy_location_panel_location_row_on_active_changed (SecurityPrivacyLocationPanelLocationRow* self);
static void security_privacy_location_panel_location_row_set_authed (SecurityPrivacyLocationPanelLocationRow* self,
                                                              gboolean value);
static void security_privacy_location_panel_location_row_set_timestamp (SecurityPrivacyLocationPanelLocationRow* self,
                                                                 const gchar* value);
static GObject * security_privacy_location_panel_location_row_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static void security_privacy_location_panel_location_row_finalize (GObject * obj);
static GType security_privacy_location_panel_location_row_get_type_once (void);
static void _vala_security_privacy_location_panel_location_row_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_security_privacy_location_panel_location_row_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static GObject * security_privacy_location_panel_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static GtkWidget* _security_privacy_location_panel_create_widget_func_gtk_list_box_create_widget_func (GObject* item,
                                                                                                gpointer self);
static void _security_privacy_location_panel___lambda27_ (SecurityPrivacyLocationPanel* self);
static void __security_privacy_location_panel___lambda27__g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void _security_privacy_location_panel___lambda28_ (SecurityPrivacyLocationPanel* self,
                                                   GtkListBoxRow* row);
static void __security_privacy_location_panel___lambda28__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                               GtkListBoxRow* row,
                                                                               gpointer self);
static void _security_privacy_location_panel___lambda29_ (SecurityPrivacyLocationPanel* self,
                                                   GObject* obj,
                                                   GAsyncResult* res);
static void __security_privacy_location_panel___lambda29__gasync_ready_callback (GObject* source_object,
                                                                          GAsyncResult* res,
                                                                          gpointer self);
static void security_privacy_location_panel_finalize (GObject * obj);
static GType security_privacy_location_panel_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
security_privacy_location_panel_get_instance_private (SecurityPrivacyLocationPanel* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyLocationPanel_private_offset);
}

SecurityPrivacyLocationPanel*
security_privacy_location_panel_construct (GType object_type)
{
	SecurityPrivacyLocationPanel * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-system-privacy-location");
	_tmp1_ = _tmp0_;
	self = (SecurityPrivacyLocationPanel*) g_object_new (object_type, "activatable", TRUE, "description", _ ("Allow the apps below to determine your location"), "icon", _tmp1_, "title", _ ("Location Services"), NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

SecurityPrivacyLocationPanel*
security_privacy_location_panel_new (void)
{
	return security_privacy_location_panel_construct (SECURITY_PRIVACY_TYPE_LOCATION_PANEL);
}

static void
security_privacy_location_panel_init_interfaces_data_free (gpointer _data)
{
	SecurityPrivacyLocationPanelInitInterfacesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SecurityPrivacyLocationPanelInitInterfacesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
security_privacy_location_panel_init_interfaces (SecurityPrivacyLocationPanel* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SecurityPrivacyLocationPanelInitInterfacesData* _data_;
	SecurityPrivacyLocationPanel* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SecurityPrivacyLocationPanelInitInterfacesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, security_privacy_location_panel_init_interfaces_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	security_privacy_location_panel_init_interfaces_co (_data_);
}

static void
security_privacy_location_panel_init_interfaces_finish (SecurityPrivacyLocationPanel* self,
                                                        GAsyncResult* _res_)
{
	SecurityPrivacyLocationPanelInitInterfacesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
security_privacy_location_panel_init_interfaces_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	SecurityPrivacyLocationPanelInitInterfacesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	security_privacy_location_panel_init_interfaces_co (_data_);
}

static void
___lambda25_ (SecurityPrivacyLocationPanel* self,
              const gchar* table,
              const gchar* id,
              gboolean deleted,
              GVariant* data,
              GVariant* permissions)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (table != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (data != NULL);
	g_return_if_fail (permissions != NULL);
	if (g_strcmp0 (table, SECURITY_PRIVACY_LOCATION_PANEL_PERMISSIONS_TABLE) != 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (id, SECURITY_PRIVACY_LOCATION_PANEL_PERMISSIONS_ID) != 0;
	}
	if (_tmp0_) {
		return;
	}
	security_privacy_location_panel_load_permissions (self);
}

static void
____lambda25__security_privacy_permission_store_changed (SecurityPrivacyPermissionStore* _sender,
                                                         const gchar* table,
                                                         const gchar* id,
                                                         gboolean deleted,
                                                         GVariant* data,
                                                         GVariant* permissions,
                                                         gpointer self)
{
	___lambda25_ ((SecurityPrivacyLocationPanel*) self, table, id, deleted, data, permissions);
}

static gboolean
security_privacy_location_panel_init_interfaces_co (SecurityPrivacyLocationPanelInitInterfacesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (SECURITY_PRIVACY_TYPE_PERMISSION_STORE_PROXY, 0, NULL, security_privacy_location_panel_init_interfaces_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.impl.portal.PermissionStore", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/impl/portal/PermissionStore", "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (SecurityPrivacyPermissionStore*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (SecurityPrivacyPermissionStore*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->permission_store);
		_data_->self->priv->permission_store = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->permission_store;
		g_signal_connect_object (_data_->_tmp3_, "changed", (GCallback) ____lambda25__security_privacy_permission_store_changed, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_critical ("LocationPanel.vala:109: Unable to connect to GNOME session interface: " \
"%s", _data_->_tmp5_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
security_privacy_location_panel_update_status (SecurityPrivacyLocationPanel* self)
{
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkStack* _tmp4_;
		_tmp4_ = self->priv->disabled_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "enabled");
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS);
		switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Enabled"));
	} else {
		GtkStack* _tmp5_;
		_tmp5_ = self->priv->disabled_stack;
		gtk_stack_set_visible_child_name (_tmp5_, "disabled");
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE);
		switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Disabled"));
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SecurityPrivacyLocationPanel* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->app_row);
		_g_object_unref0 (_data5_->app_permission);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda26_ (Block5Data* _data5_)
{
	SecurityPrivacyLocationPanel* self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar** permissions = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint permissions_length1;
	gint _permissions_size_;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	_tmp1_ = security_privacy_location_panel_location_row_get_authed (_data5_->app_row);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = "EXACT";
	} else {
		_tmp0_ = "NONE";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_tmp4_ = security_privacy_location_panel_location_row_get_timestamp (_data5_->app_row);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp3_;
	_tmp7_[1] = _tmp6_;
	permissions = _tmp7_;
	permissions_length1 = 2;
	_permissions_size_ = permissions_length1;
	{
		SecurityPrivacyPermissionStore* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = self->priv->permission_store;
		_tmp9_ = security_privacy_location_panel_app_permission_get_id (_data5_->app_permission);
		_tmp10_ = _tmp9_;
		security_privacy_permission_store_set_permission (_tmp8_, SECURITY_PRIVACY_LOCATION_PANEL_PERMISSIONS_TABLE, TRUE, SECURITY_PRIVACY_LOCATION_PANEL_PERMISSIONS_ID, _tmp10_, permissions, (gint) permissions_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("LocationPanel.vala:135: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		permissions = (_vala_array_free (permissions, permissions_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	permissions = (_vala_array_free (permissions, permissions_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda26__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda26_ (self);
}

static GtkWidget*
security_privacy_location_panel_create_widget_func (SecurityPrivacyLocationPanel* self,
                                                    GObject* object)
{
	Block5Data* _data5_;
	SecurityPrivacyLocationPanelAppPermission* _tmp0_;
	SecurityPrivacyLocationPanelLocationRow* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION, SecurityPrivacyLocationPanelAppPermission));
	_data5_->app_permission = _tmp0_;
	_tmp1_ = security_privacy_location_panel_location_row_new (_data5_->app_permission);
	g_object_ref_sink (_tmp1_);
	_data5_->app_row = _tmp1_;
	g_signal_connect_data ((GObject*) _data5_->app_row, "notify::authed", (GCallback) ___lambda26__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _data5_->app_row);
	result = _tmp2_;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static void
security_privacy_location_panel_load_permissions (SecurityPrivacyLocationPanel* self)
{
	GListStore* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->liststore;
	g_list_store_remove_all (_tmp0_);
	{
		GVariant* permissions = NULL;
		GVariant* data = NULL;
		SecurityPrivacyPermissionStore* _tmp1_;
		GVariant* _tmp2_ = NULL;
		GVariant* _tmp3_ = NULL;
		const gchar* app_id = NULL;
		gchar** app_permissions = NULL;
		gint app_permissions_length1 = 0;
		gint _app_permissions_size_ = 0;
		GVariantIter* iter = NULL;
		GVariant* _tmp4_;
		GVariantIter* _tmp5_;
		_tmp1_ = self->priv->permission_store;
		security_privacy_permission_store_lookup (_tmp1_, SECURITY_PRIVACY_LOCATION_PANEL_PERMISSIONS_TABLE, SECURITY_PRIVACY_LOCATION_PANEL_PERMISSIONS_ID, &_tmp2_, &_tmp3_, &_inner_error0_);
		_g_variant_unref0 (permissions);
		permissions = _tmp2_;
		_g_variant_unref0 (data);
		data = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_variant_unref0 (data);
			_g_variant_unref0 (permissions);
			goto __catch0_g_error;
		}
		_tmp4_ = permissions;
		_tmp5_ = g_variant_iter_new (_tmp4_);
		iter = _tmp5_;
		while (TRUE) {
			GVariantIter* _tmp6_;
			const gchar* _tmp7_ = NULL;
			gchar** _tmp8_ = NULL;
			gboolean _tmp9_;
			SecurityPrivacyLocationPanelAppPermission* app_permission = NULL;
			const gchar* _tmp10_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			SecurityPrivacyLocationPanelAppPermission* _tmp15_;
			SecurityPrivacyLocationPanelAppPermission* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GDesktopAppInfo* _tmp21_;
			GDesktopAppInfo* _tmp22_;
			gboolean _tmp23_;
			_tmp6_ = iter;
			_tmp9_ = g_variant_iter_next (_tmp6_, "{&s^a&s}", &_tmp7_, &_tmp8_, NULL);
			app_id = _tmp7_;
			app_permissions = _tmp8_;
			app_permissions_length1 = -1;
			_app_permissions_size_ = app_permissions_length1;
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = app_id;
			_tmp11_ = app_permissions;
			_tmp11__length1 = app_permissions_length1;
			_tmp12_ = _tmp11_[0];
			_tmp13_ = app_permissions;
			_tmp13__length1 = app_permissions_length1;
			_tmp14_ = _tmp13_[1];
			_tmp15_ = security_privacy_location_panel_app_permission_new (_tmp10_, _tmp12_, _tmp14_);
			app_permission = _tmp15_;
			_tmp16_ = app_permission;
			_tmp17_ = security_privacy_location_panel_app_permission_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, ".desktop", NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_desktop_app_info_new (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_ != NULL;
			_g_object_unref0 (_tmp22_);
			_g_free0 (_tmp20_);
			if (_tmp23_) {
				GListStore* _tmp24_;
				SecurityPrivacyLocationPanelAppPermission* _tmp25_;
				_tmp24_ = self->priv->liststore;
				_tmp25_ = app_permission;
				g_list_store_append (_tmp24_, (GObject*) _tmp25_);
			}
			_g_object_unref0 (app_permission);
		}
		_g_variant_iter_free0 (iter);
		_g_variant_unref0 (data);
		_g_variant_unref0 (permissions);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_critical ("LocationPanel.vala:166: %s", _tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static inline gpointer
security_privacy_location_panel_app_permission_get_instance_private (SecurityPrivacyLocationPanelAppPermission* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyLocationPanelAppPermission_private_offset);
}

static SecurityPrivacyLocationPanelAppPermission*
security_privacy_location_panel_app_permission_construct (GType object_type,
                                                          const gchar* id,
                                                          const gchar* level,
                                                          const gchar* timestamp)
{
	SecurityPrivacyLocationPanelAppPermission * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (level != NULL, NULL);
	g_return_val_if_fail (timestamp != NULL, NULL);
	self = (SecurityPrivacyLocationPanelAppPermission*) g_object_new (object_type, "id", id, "level", level, "timestamp", timestamp, NULL);
	return self;
}

static SecurityPrivacyLocationPanelAppPermission*
security_privacy_location_panel_app_permission_new (const gchar* id,
                                                    const gchar* level,
                                                    const gchar* timestamp)
{
	return security_privacy_location_panel_app_permission_construct (SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION, id, level, timestamp);
}

static const gchar*
security_privacy_location_panel_app_permission_get_id (SecurityPrivacyLocationPanelAppPermission* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
security_privacy_location_panel_app_permission_set_id (SecurityPrivacyLocationPanelAppPermission* self,
                                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = security_privacy_location_panel_app_permission_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, security_privacy_location_panel_app_permission_properties[SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_ID_PROPERTY]);
	}
}

static const gchar*
security_privacy_location_panel_app_permission_get_level (SecurityPrivacyLocationPanelAppPermission* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_level;
	result = _tmp0_;
	return result;
}

static void
security_privacy_location_panel_app_permission_set_level (SecurityPrivacyLocationPanelAppPermission* self,
                                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = security_privacy_location_panel_app_permission_get_level (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_level);
		self->priv->_level = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, security_privacy_location_panel_app_permission_properties[SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_LEVEL_PROPERTY]);
	}
}

static const gchar*
security_privacy_location_panel_app_permission_get_timestamp (SecurityPrivacyLocationPanelAppPermission* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_timestamp;
	result = _tmp0_;
	return result;
}

static void
security_privacy_location_panel_app_permission_set_timestamp (SecurityPrivacyLocationPanelAppPermission* self,
                                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = security_privacy_location_panel_app_permission_get_timestamp (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_timestamp);
		self->priv->_timestamp = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, security_privacy_location_panel_app_permission_properties[SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_TIMESTAMP_PROPERTY]);
	}
}

static void
security_privacy_location_panel_app_permission_class_init (SecurityPrivacyLocationPanelAppPermissionClass * klass,
                                                           gpointer klass_data)
{
	security_privacy_location_panel_app_permission_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyLocationPanelAppPermission_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_security_privacy_location_panel_app_permission_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_security_privacy_location_panel_app_permission_set_property;
	G_OBJECT_CLASS (klass)->finalize = security_privacy_location_panel_app_permission_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_ID_PROPERTY, security_privacy_location_panel_app_permission_properties[SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_LEVEL_PROPERTY, security_privacy_location_panel_app_permission_properties[SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_LEVEL_PROPERTY] = g_param_spec_string ("level", "level", "level", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_TIMESTAMP_PROPERTY, security_privacy_location_panel_app_permission_properties[SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_TIMESTAMP_PROPERTY] = g_param_spec_string ("timestamp", "timestamp", "timestamp", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
security_privacy_location_panel_app_permission_instance_init (SecurityPrivacyLocationPanelAppPermission * self,
                                                              gpointer klass)
{
	self->priv = security_privacy_location_panel_app_permission_get_instance_private (self);
}

static void
security_privacy_location_panel_app_permission_finalize (GObject * obj)
{
	SecurityPrivacyLocationPanelAppPermission * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION, SecurityPrivacyLocationPanelAppPermission);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_level);
	_g_free0 (self->priv->_timestamp);
	G_OBJECT_CLASS (security_privacy_location_panel_app_permission_parent_class)->finalize (obj);
}

static GType
security_privacy_location_panel_app_permission_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyLocationPanelAppPermissionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_location_panel_app_permission_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyLocationPanelAppPermission), 0, (GInstanceInitFunc) security_privacy_location_panel_app_permission_instance_init, NULL };
	GType security_privacy_location_panel_app_permission_type_id;
	security_privacy_location_panel_app_permission_type_id = g_type_register_static (G_TYPE_OBJECT, "SecurityPrivacyLocationPanelAppPermission", &g_define_type_info, 0);
	SecurityPrivacyLocationPanelAppPermission_private_offset = g_type_add_instance_private (security_privacy_location_panel_app_permission_type_id, sizeof (SecurityPrivacyLocationPanelAppPermissionPrivate));
	return security_privacy_location_panel_app_permission_type_id;
}

static GType
security_privacy_location_panel_app_permission_get_type (void)
{
	static volatile gsize security_privacy_location_panel_app_permission_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_location_panel_app_permission_type_id__once)) {
		GType security_privacy_location_panel_app_permission_type_id;
		security_privacy_location_panel_app_permission_type_id = security_privacy_location_panel_app_permission_get_type_once ();
		g_once_init_leave (&security_privacy_location_panel_app_permission_type_id__once, security_privacy_location_panel_app_permission_type_id);
	}
	return security_privacy_location_panel_app_permission_type_id__once;
}

static void
_vala_security_privacy_location_panel_app_permission_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	SecurityPrivacyLocationPanelAppPermission * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION, SecurityPrivacyLocationPanelAppPermission);
	switch (property_id) {
		case SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_ID_PROPERTY:
		g_value_set_string (value, security_privacy_location_panel_app_permission_get_id (self));
		break;
		case SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_LEVEL_PROPERTY:
		g_value_set_string (value, security_privacy_location_panel_app_permission_get_level (self));
		break;
		case SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_TIMESTAMP_PROPERTY:
		g_value_set_string (value, security_privacy_location_panel_app_permission_get_timestamp (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_security_privacy_location_panel_app_permission_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	SecurityPrivacyLocationPanelAppPermission * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION, SecurityPrivacyLocationPanelAppPermission);
	switch (property_id) {
		case SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_ID_PROPERTY:
		security_privacy_location_panel_app_permission_set_id (self, g_value_get_string (value));
		break;
		case SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_LEVEL_PROPERTY:
		security_privacy_location_panel_app_permission_set_level (self, g_value_get_string (value));
		break;
		case SECURITY_PRIVACY_LOCATION_PANEL_APP_PERMISSION_TIMESTAMP_PROPERTY:
		security_privacy_location_panel_app_permission_set_timestamp (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
security_privacy_location_panel_location_row_get_instance_private (SecurityPrivacyLocationPanelLocationRow* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyLocationPanelLocationRow_private_offset);
}

static SecurityPrivacyLocationPanelLocationRow*
security_privacy_location_panel_location_row_construct (GType object_type,
                                                        SecurityPrivacyLocationPanelAppPermission* permission)
{
	SecurityPrivacyLocationPanelLocationRow * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	GDesktopAppInfo* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_val_if_fail (permission != NULL, NULL);
	_tmp0_ = security_privacy_location_panel_app_permission_get_id (permission);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".desktop", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_desktop_app_info_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = security_privacy_location_panel_app_permission_get_level (permission);
	_tmp7_ = _tmp6_;
	_tmp8_ = security_privacy_location_panel_app_permission_get_timestamp (permission);
	_tmp9_ = _tmp8_;
	self = (SecurityPrivacyLocationPanelLocationRow*) g_object_new (object_type, "app-info", _tmp5_, "authed", g_strcmp0 (_tmp7_, "NONE") != 0, "timestamp", _tmp9_, NULL);
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	return self;
}

static SecurityPrivacyLocationPanelLocationRow*
security_privacy_location_panel_location_row_new (SecurityPrivacyLocationPanelAppPermission* permission)
{
	return security_privacy_location_panel_location_row_construct (SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, permission);
}

static void
security_privacy_location_panel_location_row_on_active_changed (SecurityPrivacyLocationPanelLocationRow* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_authed;
	security_privacy_location_panel_location_row_set_authed (self, !_tmp0_);
}

static gboolean
security_privacy_location_panel_location_row_get_authed (SecurityPrivacyLocationPanelLocationRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_authed;
	return result;
}

static void
security_privacy_location_panel_location_row_set_authed (SecurityPrivacyLocationPanelLocationRow* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = security_privacy_location_panel_location_row_get_authed (self);
	if (old_value != value) {
		self->priv->_authed = value;
		g_object_notify_by_pspec ((GObject *) self, security_privacy_location_panel_location_row_properties[SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_AUTHED_PROPERTY]);
	}
}

static const gchar*
security_privacy_location_panel_location_row_get_timestamp (SecurityPrivacyLocationPanelLocationRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_timestamp;
	result = _tmp0_;
	return result;
}

static void
security_privacy_location_panel_location_row_set_timestamp (SecurityPrivacyLocationPanelLocationRow* self,
                                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = security_privacy_location_panel_location_row_get_timestamp (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_timestamp);
		self->priv->_timestamp = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, security_privacy_location_panel_location_row_properties[SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_TIMESTAMP_PROPERTY]);
	}
}

static GObject *
security_privacy_location_panel_location_row_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SecurityPrivacyLocationPanelLocationRow * self;
	GtkSwitch* active_switch = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkSwitch* _tmp6_ = NULL;
	GtkSwitch* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	GtkSwitch* _tmp13_;
	GtkSwitch* _tmp14_;
	parent_class = G_OBJECT_CLASS (security_privacy_location_panel_location_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, SecurityPrivacyLocationPanelLocationRow);
	_tmp0_ = app_row_get_app_info ((AppRow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_app_info_get_display_name ((GAppInfo*) _tmp1_);
	_tmp3_ = g_strdup_printf ("Allow %s to use location services", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_ (_tmp4_));
	_tmp6_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	active_switch = _tmp7_;
	_tmp8_ = ((AppRow*) self)->main_grid;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp8_, 6);
	_tmp9_ = ((AppRow*) self)->main_grid;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 6);
	_tmp10_ = ((AppRow*) self)->main_grid;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp10_, 6);
	_tmp11_ = ((AppRow*) self)->main_grid;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp11_, 6);
	_tmp12_ = ((AppRow*) self)->main_grid;
	_tmp13_ = active_switch;
	gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, 2, 0, 1, 2);
	_tmp14_ = active_switch;
	g_object_bind_property_with_closures ((GObject*) self, "authed", (GObject*) _tmp14_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (active_switch);
	return obj;
}

static void
security_privacy_location_panel_location_row_class_init (SecurityPrivacyLocationPanelLocationRowClass * klass,
                                                         gpointer klass_data)
{
	security_privacy_location_panel_location_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyLocationPanelLocationRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_security_privacy_location_panel_location_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_security_privacy_location_panel_location_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = security_privacy_location_panel_location_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = security_privacy_location_panel_location_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_AUTHED_PROPERTY, security_privacy_location_panel_location_row_properties[SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_AUTHED_PROPERTY] = g_param_spec_boolean ("authed", "authed", "authed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_TIMESTAMP_PROPERTY, security_privacy_location_panel_location_row_properties[SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_TIMESTAMP_PROPERTY] = g_param_spec_string ("timestamp", "timestamp", "timestamp", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
security_privacy_location_panel_location_row_instance_init (SecurityPrivacyLocationPanelLocationRow * self,
                                                            gpointer klass)
{
	self->priv = security_privacy_location_panel_location_row_get_instance_private (self);
}

static void
security_privacy_location_panel_location_row_finalize (GObject * obj)
{
	SecurityPrivacyLocationPanelLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, SecurityPrivacyLocationPanelLocationRow);
	_g_free0 (self->priv->_timestamp);
	G_OBJECT_CLASS (security_privacy_location_panel_location_row_parent_class)->finalize (obj);
}

static GType
security_privacy_location_panel_location_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyLocationPanelLocationRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_location_panel_location_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyLocationPanelLocationRow), 0, (GInstanceInitFunc) security_privacy_location_panel_location_row_instance_init, NULL };
	GType security_privacy_location_panel_location_row_type_id;
	security_privacy_location_panel_location_row_type_id = g_type_register_static (TYPE_APP_ROW, "SecurityPrivacyLocationPanelLocationRow", &g_define_type_info, 0);
	SecurityPrivacyLocationPanelLocationRow_private_offset = g_type_add_instance_private (security_privacy_location_panel_location_row_type_id, sizeof (SecurityPrivacyLocationPanelLocationRowPrivate));
	return security_privacy_location_panel_location_row_type_id;
}

static GType
security_privacy_location_panel_location_row_get_type (void)
{
	static volatile gsize security_privacy_location_panel_location_row_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_location_panel_location_row_type_id__once)) {
		GType security_privacy_location_panel_location_row_type_id;
		security_privacy_location_panel_location_row_type_id = security_privacy_location_panel_location_row_get_type_once ();
		g_once_init_leave (&security_privacy_location_panel_location_row_type_id__once, security_privacy_location_panel_location_row_type_id);
	}
	return security_privacy_location_panel_location_row_type_id__once;
}

static void
_vala_security_privacy_location_panel_location_row_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SecurityPrivacyLocationPanelLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, SecurityPrivacyLocationPanelLocationRow);
	switch (property_id) {
		case SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_AUTHED_PROPERTY:
		g_value_set_boolean (value, security_privacy_location_panel_location_row_get_authed (self));
		break;
		case SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_TIMESTAMP_PROPERTY:
		g_value_set_string (value, security_privacy_location_panel_location_row_get_timestamp (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_security_privacy_location_panel_location_row_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SecurityPrivacyLocationPanelLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, SecurityPrivacyLocationPanelLocationRow);
	switch (property_id) {
		case SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_AUTHED_PROPERTY:
		security_privacy_location_panel_location_row_set_authed (self, g_value_get_boolean (value));
		break;
		case SECURITY_PRIVACY_LOCATION_PANEL_LOCATION_ROW_TIMESTAMP_PROPERTY:
		security_privacy_location_panel_location_row_set_timestamp (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GtkWidget*
_security_privacy_location_panel_create_widget_func_gtk_list_box_create_widget_func (GObject* item,
                                                                                     gpointer self)
{
	GtkWidget* result;
	result = security_privacy_location_panel_create_widget_func ((SecurityPrivacyLocationPanel*) self, item);
	return result;
}

static void
_security_privacy_location_panel___lambda27_ (SecurityPrivacyLocationPanel* self)
{
	security_privacy_location_panel_update_status (self);
}

static void
__security_privacy_location_panel___lambda27__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	_security_privacy_location_panel___lambda27_ ((SecurityPrivacyLocationPanel*) self);
}

static void
_security_privacy_location_panel___lambda28_ (SecurityPrivacyLocationPanel* self,
                                              GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	security_privacy_location_panel_location_row_on_active_changed (G_TYPE_CHECK_INSTANCE_CAST (row, SECURITY_PRIVACY_LOCATION_PANEL_TYPE_LOCATION_ROW, SecurityPrivacyLocationPanelLocationRow));
}

static void
__security_privacy_location_panel___lambda28__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                          GtkListBoxRow* row,
                                                                          gpointer self)
{
	_security_privacy_location_panel___lambda28_ ((SecurityPrivacyLocationPanel*) self, row);
}

static void
_security_privacy_location_panel___lambda29_ (SecurityPrivacyLocationPanel* self,
                                              GObject* obj,
                                              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	security_privacy_location_panel_init_interfaces_finish (self, res);
	security_privacy_location_panel_load_permissions (self);
}

static void
__security_privacy_location_panel___lambda29__gasync_ready_callback (GObject* source_object,
                                                                     GAsyncResult* res,
                                                                     gpointer self)
{
	_security_privacy_location_panel___lambda29_ ((SecurityPrivacyLocationPanel*) self, source_object, res);
	g_object_unref (self);
}

static GObject *
security_privacy_location_panel_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SecurityPrivacyLocationPanel * self;
	GListStore* _tmp0_;
	GranitePlaceholder* placeholder = NULL;
	gchar* _tmp1_;
	GranitePlaceholder* _tmp2_ = NULL;
	GtkListBox* listbox = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_;
	GListStore* _tmp5_;
	GtkListBox* _tmp6_;
	GranitePlaceholder* _tmp7_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp8_;
	GtkWidget* _tmp9_;
	GtkScrolledWindow* _tmp10_ = NULL;
	GranitePlaceholder* alert = NULL;
	gchar* _tmp11_;
	GranitePlaceholder* _tmp12_ = NULL;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	GranitePlaceholder* _tmp15_;
	GtkStack* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkFrame* frame = NULL;
	GtkStack* _tmp18_;
	GtkWidget* _tmp19_;
	GtkFrame* _tmp20_ = NULL;
	GtkFrame* _tmp21_;
	GSettings* location_settings = NULL;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	GtkSwitch* _tmp24_;
	GtkSwitch* _tmp25_;
	GtkSwitch* _tmp26_;
	GtkSwitch* _tmp27_;
	GtkListBox* _tmp28_;
	parent_class = G_OBJECT_CLASS (security_privacy_location_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_LOCATION_PANEL, SecurityPrivacyLocationPanel);
	_tmp0_ = g_list_store_new (SECURITY_PRIVACY_LOCATION_PANEL_TYPE_APP_PERMISSION);
	_g_object_unref0 (self->priv->liststore);
	self->priv->liststore = _tmp0_;
	_tmp1_ = g_strdup (_ ("When apps are installed that use location services they will automatic" \
"ally appear here."));
	_tmp2_ = granite_placeholder_new (_ ("No Apps Are Using Location Services"));
	granite_placeholder_set_description (_tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	placeholder = _tmp2_;
	_tmp3_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	listbox = _tmp3_;
	_tmp4_ = listbox;
	_tmp5_ = self->priv->liststore;
	gtk_list_box_bind_model (_tmp4_, (GListModel*) _tmp5_, _security_privacy_location_panel_create_widget_func_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp6_ = listbox;
	_tmp7_ = placeholder;
	gtk_list_box_set_placeholder (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = listbox;
	_tmp9_ = _g_object_ref0 ((GtkWidget*) _tmp8_);
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp10_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp10_, TRUE);
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
	g_object_ref_sink (_tmp10_);
	scrolled = _tmp10_;
	_tmp11_ = g_strdup_printf ("%s\n%s\n%s", _ ("While location services are disabled, location requests from apps will" \
" be automatically rejected."), _ ("The additional functionality that location access provides in those ap" \
"ps will be affected."), _ ("This will not prevent apps from trying to determine your location base" \
"d on IP address."));
	_tmp12_ = granite_placeholder_new (_ ("Location Services Are Disabled"));
	granite_placeholder_set_description (_tmp12_, _tmp11_);
	_g_free0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	alert = _tmp12_;
	_tmp13_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->disabled_stack);
	self->priv->disabled_stack = _tmp13_;
	_tmp14_ = self->priv->disabled_stack;
	_tmp15_ = alert;
	gtk_stack_add_named (_tmp14_, (GtkWidget*) _tmp15_, "disabled");
	_tmp16_ = self->priv->disabled_stack;
	_tmp17_ = scrolled;
	gtk_stack_add_named (_tmp16_, (GtkWidget*) _tmp17_, "enabled");
	_tmp18_ = self->priv->disabled_stack;
	_tmp19_ = _g_object_ref0 ((GtkWidget*) _tmp18_);
	_tmp20_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp20_, _tmp19_);
	_g_object_unref0 (_tmp19_);
	g_object_ref_sink (_tmp20_);
	frame = _tmp20_;
	_tmp21_ = frame;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp21_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp22_ = g_settings_new ("org.gnome.system.location");
	location_settings = _tmp22_;
	_tmp23_ = location_settings;
	_tmp24_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp25_ = _tmp24_;
	g_settings_bind (_tmp23_, "enabled", (GObject*) _tmp25_, "active", G_SETTINGS_BIND_DEFAULT);
	security_privacy_location_panel_update_status (self);
	_tmp26_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp27_ = _tmp26_;
	g_signal_connect_object ((GObject*) _tmp27_, "notify::active", (GCallback) __security_privacy_location_panel___lambda27__g_object_notify, self, 0);
	_tmp28_ = listbox;
	g_signal_connect_object (_tmp28_, "row-activated", (GCallback) __security_privacy_location_panel___lambda28__gtk_list_box_row_activated, self, 0);
	security_privacy_location_panel_init_interfaces (self, __security_privacy_location_panel___lambda29__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (location_settings);
	_g_object_unref0 (frame);
	_g_object_unref0 (alert);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (listbox);
	_g_object_unref0 (placeholder);
	return obj;
}

static void
security_privacy_location_panel_class_init (SecurityPrivacyLocationPanelClass * klass,
                                            gpointer klass_data)
{
	security_privacy_location_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyLocationPanel_private_offset);
	G_OBJECT_CLASS (klass)->constructor = security_privacy_location_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = security_privacy_location_panel_finalize;
}

static void
security_privacy_location_panel_instance_init (SecurityPrivacyLocationPanel * self,
                                               gpointer klass)
{
	self->priv = security_privacy_location_panel_get_instance_private (self);
}

static void
security_privacy_location_panel_finalize (GObject * obj)
{
	SecurityPrivacyLocationPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_LOCATION_PANEL, SecurityPrivacyLocationPanel);
	_g_object_unref0 (self->priv->disabled_stack);
	_g_object_unref0 (self->priv->liststore);
	_g_object_unref0 (self->priv->permission_store);
	G_OBJECT_CLASS (security_privacy_location_panel_parent_class)->finalize (obj);
}

static GType
security_privacy_location_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyLocationPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_location_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyLocationPanel), 0, (GInstanceInitFunc) security_privacy_location_panel_instance_init, NULL };
	GType security_privacy_location_panel_type_id;
	security_privacy_location_panel_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "SecurityPrivacyLocationPanel", &g_define_type_info, 0);
	SecurityPrivacyLocationPanel_private_offset = g_type_add_instance_private (security_privacy_location_panel_type_id, sizeof (SecurityPrivacyLocationPanelPrivate));
	return security_privacy_location_panel_type_id;
}

GType
security_privacy_location_panel_get_type (void)
{
	static volatile gsize security_privacy_location_panel_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_location_panel_type_id__once)) {
		GType security_privacy_location_panel_type_id;
		security_privacy_location_panel_type_id = security_privacy_location_panel_get_type_once ();
		g_once_init_leave (&security_privacy_location_panel_type_id__once, security_privacy_location_panel_type_id);
	}
	return security_privacy_location_panel_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

