const char checks_lua[] =
"local ffi = require('ffi')\n"
"\n"
"ffi.cdef[[\n"
"    int memcmp(const char *mem1, const char *mem2, size_t num);\n"
"]]\n"
"\n"
"local err_string_arg = \"bad argument #%d to '%s' (%s expected, got %s)\"\n"
"\n"
"local c_char_ptr     = ffi.typeof('const char *')\n"
"\n"
"local memcmp  = ffi.C.memcmp\n"
"\n"
"local _qualifiers_cache = {\n"
"    -- ['\?type1|type2'] = {\n"
"    --     [1] = 'type1',\n"
"    --     [2] = 'type2',\n"
"    --     optional = true,\n"
"    -- },\n"
"}\n"
"\n"
"--- Check that string (or substring) starts with given string\n"
"-- Optionally restricting the matching with the given offsets\n"
"-- @function startswith\n"
"-- @string    inp     original string\n"
"-- @string    head    the substring to check against\n"
"-- @int[opt]  _start  start index of matching boundary\n"
"-- @int[opt]  _end    end index of matching boundary\n"
"-- @returns           boolean\n"
"local function startswith(inp, head, _start, _end)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.startswith', 'string',\n"
"                                    type(inp)), 2)\n"
"    end\n"
"    if type(head) ~= 'string' then\n"
"        error(err_string_arg:format(2, 'string.startswith', 'string',\n"
"                                    type(head)), 2)\n"
"    end\n"
"    if _start ~= nil and type(_start) ~= 'number' then\n"
"        error(err_string_arg:format(3, 'string.startswith', 'integer',\n"
"                                    type(_start)), 2)\n"
"    end\n"
"    if _end ~= nil and type(_end) ~= 'number' then\n"
"        error(err_string_arg:format(4, 'string.startswith', 'integer',\n"
"                                    type(_end)), 2)\n"
"    end\n"
"    -- prepare input arguments (move negative values [offset from the end] to\n"
"    -- positive ones and/or assign default values)\n"
"    local head_len, inp_len = #head, #inp\n"
"    if _start == nil then\n"
"        _start = 1\n"
"    elseif _start < 0 then\n"
"        _start = inp_len + _start + 1\n"
"        if _start < 0 then _start = 0 end\n"
"    end\n"
"    if _end == nil or _end > inp_len then\n"
"        _end = inp_len\n"
"    elseif _end < 0 then\n"
"        _end = inp_len + _end + 1\n"
"        if _end < 0 then _end = 0 end\n"
"    end\n"
"    -- check for degenerate case (interval lesser than input)\n"
"    if head_len == 0 then\n"
"        return true\n"
"    elseif _end - _start + 1 < head_len or _start > _end then\n"
"        return false\n"
"    end\n"
"    _start = _start - 1\n"
"    return memcmp(c_char_ptr(inp) + _start, c_char_ptr(head), head_len) == 0\n"
"end\n"
"\n"
"\n"
"local function check_string_type(value, expected_type)\n"
"    -- 1. Check any value.\n"
"    if expected_type == '\?' then\n"
"        return true\n"
"    end\n"
"\n"
"    -- 2. Parse type qualifier\n"
"    local qualifier = _qualifiers_cache[expected_type]\n"
"    if qualifier == nil then\n"
"        qualifier = { optional = false }\n"
"\n"
"        for typ in expected_type:gmatch('[^|]+') do\n"
"            if startswith(typ, '\?') then\n"
"                qualifier.optional = true\n"
"                typ = typ:sub(2)\n"
"            end\n"
"\n"
"            table.insert(qualifier, typ)\n"
"        end\n"
"\n"
"        _qualifiers_cache[expected_type] = qualifier\n"
"    end\n"
"\n"
"    -- 3. Check optional argument\n"
"    if qualifier.optional and value == nil then\n"
"        return true\n"
"    end\n"
"\n"
"    -- 4. Check types\n"
"    for _, typ in ipairs(qualifier) do\n"
"        if type(value) == typ then\n"
"            return true\n"
"        end\n"
"\n"
"        local mt = getmetatable(value)\n"
"        local value_metatype = mt and mt.__type\n"
"        if value_metatype == typ then\n"
"            return true\n"
"        end\n"
"\n"
"        local checker = rawget(_G, 'checkers')[typ]\n"
"        if type(checker) == 'function' and checker(value) == true then\n"
"            return true\n"
"        end\n"
"    end\n"
"\n"
"    -- 5. Nothing works, return an error\n"
"    return nil, string.format(\n"
"        'bad argument %s to %s (%s expected, got %s)',\n"
"        -- argname and function name are formatted by the caller\n"
"        '%s', '%s', expected_type, type(value)\n"
"    )\n"
"end\n"
"\n"
"local function keyname_fmt(key)\n"
"    if type(key) == 'string' then\n"
"        return string.format('.%s', key)\n"
"    elseif type(key) == 'number' then\n"
"        return string.format('[%s]', key)\n"
"    else\n"
"        return '[\?]'\n"
"    end\n"
"end\n"
"\n"
"local function check_table_type(tbl, expected_fields)\n"
"    if tbl == nil then\n"
"        tbl = nil\n"
"    end\n"
"\n"
"    for expected_key, expected_type in pairs(expected_fields) do\n"
"        local value = tbl and tbl[expected_key]\n"
"\n"
"        if type(expected_type) == 'string' then\n"
"            local ok, efmt = check_string_type(value, expected_type)\n"
"            if not ok then\n"
"                return nil, string.format(efmt, '%s'..keyname_fmt(expected_key), '%s')\n"
"            end\n"
"        elseif type(expected_type) == 'table' then\n"
"            local ok, efmt = check_string_type(value, '\?table')\n"
"            if not ok then\n"
"                return nil, string.format(efmt, '%s'..keyname_fmt(expected_key), '%s')\n"
"            end\n"
"\n"
"            if rawget(_G, '_checks_v2_compatible') and value == nil then\n"
"                value = {}\n"
"                tbl[expected_key] = value\n"
"            end\n"
"\n"
"            local ok, efmt = check_table_type(value, expected_type)\n"
"            if not ok then\n"
"                return nil, string.format(efmt, '%s'..keyname_fmt(expected_key), '%s')\n"
"            end\n"
"        else\n"
"            return nil, string.format(\n"
"                'checks: type %q is not supported',\n"
"                type(expected_type)\n"
"            )\n"
"        end\n"
"    end\n"
"\n"
"    if not tbl then\n"
"        return true\n"
"    end\n"
"\n"
"    for key, _ in pairs(tbl) do\n"
"        if not expected_fields[key] then\n"
"            return nil, string.format(\n"
"                'unexpected argument %s to %s',\n"
"                -- argname and function name\n"
"                -- are formatted by the caller\n"
"                '%s'..keyname_fmt(key), '%s'\n"
"            )\n"
"        end\n"
"    end\n"
"\n"
"    return true\n"
"end\n"
"\n"
"local function checks(...)\n"
"    local skip = 0\n"
"\n"
"    local level = 1\n"
"    if type(...) == 'number' then\n"
"        level = ...\n"
"        skip = 1\n"
"    end\n"
"    level = level + 1 -- escape the checks level\n"
"\n"
"    for i = 1, select('#', ...) - skip + 1 do\n"
"        local expected_type = select(i + skip, ...)\n"
"        local argname, value = debug.getlocal(level, i)\n"
"\n"
"        if expected_type == nil and argname == nil then\n"
"            break\n"
"        elseif expected_type == nil then\n"
"            local err = string.format(\n"
"                'checks: argument %q is not checked',\n"
"                argname\n"
"            )\n"
"            error(err, level)\n"
"        elseif argname == nil then\n"
"            local err = 'checks: excess check, absent argument'\n"
"            error(err, level)\n"
"        elseif type(expected_type) == 'string' then\n"
"            local ok, efmt = check_string_type(value, expected_type)\n"
"            if not ok then\n"
"                local info = debug.getinfo(level, 'nl')\n"
"                local err = string.format(efmt, '#'..tostring(i), info.name)\n"
"                error(err, level)\n"
"            end\n"
"\n"
"        elseif type(expected_type) == 'table' then\n"
"            local ok, efmt = check_string_type(value, '\?table')\n"
"            if not ok then\n"
"                local info = debug.getinfo(level, 'nl')\n"
"                local err = string.format(efmt, '#'..tostring(i), info.name)\n"
"                error(err, level)\n"
"            end\n"
"\n"
"            if rawget(_G, '_checks_v2_compatible') and value == nil then\n"
"                value = {}\n"
"                debug.setlocal(level, i, value)\n"
"            end\n"
"\n"
"            local ok, efmt = check_table_type(value, expected_type)\n"
"            if not ok then\n"
"                local info = debug.getinfo(level, 'nl')\n"
"                local err = string.format(efmt, argname, info.name)\n"
"                error(err, level)\n"
"            end\n"
"        else\n"
"            local err = string.format(\n"
"                'checks: type %q is not supported',\n"
"                type(expected_type)\n"
"            )\n"
"            error(err, level)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"rawset(_G, 'checks', checks)\n"
"\n"
"local checkers = rawget(_G, 'checkers') or {}\n"
"rawset(_G, 'checkers', checkers)\n"
"\n"
"local _checks_v2_compatible = rawget(_G, '_checks_v2_compatible') or false\n"
"rawset(_G, '_checks_v2_compatible', _checks_v2_compatible)\n"
"\n"
"local ffi = require('ffi')\n"
"function checkers.uint64(arg)\n"
"    if type(arg) == 'number' then\n"
"        -- Double floating point format has 52 fraction bits\n"
"        -- If we want to keep integer precision,\n"
"        -- the number must be less than 2^53\n"
"        return (arg >= 0) and (arg < 2^53) and (math.floor(arg) == arg)\n"
"    end\n"
"\n"
"    if type(arg) == 'cdata' then\n"
"        if ffi.istype('int64_t', arg) then\n"
"            return (arg >= 0)\n"
"        elseif ffi.istype('uint64_t', arg) then\n"
"            return true\n"
"        end\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"function checkers.int64(arg)\n"
"    if type(arg) == 'number' then\n"
"        return (arg > -2^53) and (arg < 2^53) and (math.floor(arg) == arg)\n"
"    end\n"
"\n"
"    if type(arg) == 'cdata' then\n"
"        if ffi.istype('int64_t', arg) then\n"
"            return true\n"
"        elseif ffi.istype('uint64_t', arg) then\n"
"            return arg < 2^63\n"
"        end\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"local has_box = rawget(_G, 'box') ~= nil\n"
"if has_box and box.tuple ~= nil then\n"
"    checkers.tuple = box.tuple.is\n"
"end\n"
"\n"
"local has_decimal, decimal = pcall(require, 'decimal')\n"
"if has_decimal then\n"
"    -- There is a decimal.is_decimal check since 2.4, but we\n"
"    -- reimplement it here to support older versions which have decimal.\n"
"    local cdata_t = ffi.typeof(decimal.new(0))\n"
"    checkers.decimal = function(arg)\n"
"        return ffi.istype(cdata_t, arg)\n"
"    end\n"
"end\n"
"\n"
"local function add_ffi_type_checker(checks_type, c_type)\n"
"    local has_cdata_t, cdata_t = pcall(ffi.typeof, c_type)\n"
"    if has_cdata_t then\n"
"        checkers[checks_type] = function(arg)\n"
"            return ffi.istype(cdata_t, arg)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- There is a uuid.is_uuid check since 2.6.1, but we\n"
"-- reimplement it here to support older versions which have uuid.\n"
"-- https://github.com/tarantool/tarantool/blob/7682d34162be34648172d91008e9185301bce8f6/src/lua/uuid.lua#L29\n"
"add_ffi_type_checker('uuid', 'struct tt_uuid')\n"
"\n"
"function checkers.uuid_str(arg)\n"
"    if type(arg) == 'string' and #arg == 36 then\n"
"        local match = arg:match(\n"
"            '^'..\n"
"            '%x%x%x%x%x%x%x%x%-'..\n"
"            '%x%x%x%x%-'..\n"
"            '%x%x%x%x%-'..\n"
"            '[0-9a-dA-D]%x%x%x%-'..\n"
"            '%x%x%x%x%x%x%x%x%x%x%x%x'..\n"
"            '$'\n"
"        )\n"
"        return match ~= nil\n"
"    else\n"
"        return false\n"
"    end\n"
"end\n"
"\n"
"function checkers.uuid_bin(arg)\n"
"    if type(arg) == 'string' and #arg == 16 then\n"
"        return true\n"
"    else\n"
"        return false\n"
"    end\n"
"end\n"
"\n"
"add_ffi_type_checker('error', 'struct error')\n"
"\n"
"local has_datetime, datetime = pcall(require, 'datetime')\n"
"if has_datetime then\n"
"    checkers.datetime = datetime.is_datetime\n"
"end\n"
"\n"
"add_ffi_type_checker('interval', 'struct interval')\n"
"\n"
"return setmetatable(\n"
"    {\n"
"        checks = checks,\n"
"        _VERSION = require('checks.version'),\n"
"    },\n"
"    {\n"
"        -- Made export table callable for backward compatibility.\n"
"        __call = function(_, ...)\n"
"            return checks(...)\n"
"        end\n"
"    }\n"
")\n"
""
;
